/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.services.ec2.model.PropagatingVgw;
import com.amazonaws.services.ec2.model.Route;
import com.amazonaws.services.ec2.model.RouteTableAssociation;
import com.amazonaws.services.ec2.model.Tag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class RouteTable {
    private String routeTableId;
    private String vpcId;
    private List<Route> routes;
    private List<RouteTableAssociation> associations;
    private List<Tag> tags;
    private List<PropagatingVgw> propagatingVgwSet;

    public String getRouteTableId() {
        return this.routeTableId;
    }

    public void setRouteTableId(String routeTableId) {
        this.routeTableId = routeTableId;
    }

    public RouteTable withRouteTableId(String routeTableId) {
        this.routeTableId = routeTableId;
        return this;
    }

    public String getVpcId() {
        return this.vpcId;
    }

    public void setVpcId(String vpcId) {
        this.vpcId = vpcId;
    }

    public RouteTable withVpcId(String vpcId) {
        this.vpcId = vpcId;
        return this;
    }

    public List<Route> getRoutes() {
        if (this.routes == null) {
            this.routes = new ArrayList<Route>();
        }
        return this.routes;
    }

    public void setRoutes(Collection<Route> routes) {
        if (routes == null) {
            this.routes = null;
            return;
        }
        ArrayList<Route> routesCopy = new ArrayList<Route>(routes.size());
        routesCopy.addAll(routes);
        this.routes = routesCopy;
    }

    public RouteTable withRoutes(Route ... routes) {
        if (this.getRoutes() == null) {
            this.setRoutes(new ArrayList<Route>(routes.length));
        }
        for (Route value : routes) {
            this.getRoutes().add(value);
        }
        return this;
    }

    public RouteTable withRoutes(Collection<Route> routes) {
        if (routes == null) {
            this.routes = null;
        } else {
            ArrayList<Route> routesCopy = new ArrayList<Route>(routes.size());
            routesCopy.addAll(routes);
            this.routes = routesCopy;
        }
        return this;
    }

    public List<RouteTableAssociation> getAssociations() {
        if (this.associations == null) {
            this.associations = new ArrayList<RouteTableAssociation>();
        }
        return this.associations;
    }

    public void setAssociations(Collection<RouteTableAssociation> associations) {
        if (associations == null) {
            this.associations = null;
            return;
        }
        ArrayList<RouteTableAssociation> associationsCopy = new ArrayList<RouteTableAssociation>(associations.size());
        associationsCopy.addAll(associations);
        this.associations = associationsCopy;
    }

    public RouteTable withAssociations(RouteTableAssociation ... associations) {
        if (this.getAssociations() == null) {
            this.setAssociations(new ArrayList<RouteTableAssociation>(associations.length));
        }
        for (RouteTableAssociation value : associations) {
            this.getAssociations().add(value);
        }
        return this;
    }

    public RouteTable withAssociations(Collection<RouteTableAssociation> associations) {
        if (associations == null) {
            this.associations = null;
        } else {
            ArrayList<RouteTableAssociation> associationsCopy = new ArrayList<RouteTableAssociation>(associations.size());
            associationsCopy.addAll(associations);
            this.associations = associationsCopy;
        }
        return this;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new ArrayList<Tag>();
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        ArrayList<Tag> tagsCopy = new ArrayList<Tag>(tags.size());
        tagsCopy.addAll(tags);
        this.tags = tagsCopy;
    }

    public RouteTable withTags(Tag ... tags) {
        if (this.getTags() == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag value : tags) {
            this.getTags().add(value);
        }
        return this;
    }

    public RouteTable withTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
        } else {
            ArrayList<Tag> tagsCopy = new ArrayList<Tag>(tags.size());
            tagsCopy.addAll(tags);
            this.tags = tagsCopy;
        }
        return this;
    }

    public List<PropagatingVgw> getPropagatingVgwSet() {
        if (this.propagatingVgwSet == null) {
            this.propagatingVgwSet = new ArrayList<PropagatingVgw>();
        }
        return this.propagatingVgwSet;
    }

    public void setPropagatingVgwSet(Collection<PropagatingVgw> propagatingVgwSet) {
        if (propagatingVgwSet == null) {
            this.propagatingVgwSet = null;
            return;
        }
        ArrayList<PropagatingVgw> propagatingVgwSetCopy = new ArrayList<PropagatingVgw>(propagatingVgwSet.size());
        propagatingVgwSetCopy.addAll(propagatingVgwSet);
        this.propagatingVgwSet = propagatingVgwSetCopy;
    }

    public RouteTable withPropagatingVgwSet(PropagatingVgw ... propagatingVgwSet) {
        if (this.getPropagatingVgwSet() == null) {
            this.setPropagatingVgwSet(new ArrayList<PropagatingVgw>(propagatingVgwSet.length));
        }
        for (PropagatingVgw value : propagatingVgwSet) {
            this.getPropagatingVgwSet().add(value);
        }
        return this;
    }

    public RouteTable withPropagatingVgwSet(Collection<PropagatingVgw> propagatingVgwSet) {
        if (propagatingVgwSet == null) {
            this.propagatingVgwSet = null;
        } else {
            ArrayList<PropagatingVgw> propagatingVgwSetCopy = new ArrayList<PropagatingVgw>(propagatingVgwSet.size());
            propagatingVgwSetCopy.addAll(propagatingVgwSet);
            this.propagatingVgwSet = propagatingVgwSetCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.routeTableId != null) {
            sb.append("RouteTableId: " + this.routeTableId + ", ");
        }
        if (this.vpcId != null) {
            sb.append("VpcId: " + this.vpcId + ", ");
        }
        if (this.routes != null) {
            sb.append("Routes: " + this.routes + ", ");
        }
        if (this.associations != null) {
            sb.append("Associations: " + this.associations + ", ");
        }
        if (this.tags != null) {
            sb.append("Tags: " + this.tags + ", ");
        }
        if (this.propagatingVgwSet != null) {
            sb.append("PropagatingVgwSet: " + this.propagatingVgwSet + ", ");
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getRouteTableId() == null ? 0 : this.getRouteTableId().hashCode());
        hashCode = 31 * hashCode + (this.getVpcId() == null ? 0 : this.getVpcId().hashCode());
        hashCode = 31 * hashCode + (this.getRoutes() == null ? 0 : ((Object)this.getRoutes()).hashCode());
        hashCode = 31 * hashCode + (this.getAssociations() == null ? 0 : ((Object)this.getAssociations()).hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : ((Object)this.getTags()).hashCode());
        hashCode = 31 * hashCode + (this.getPropagatingVgwSet() == null ? 0 : ((Object)this.getPropagatingVgwSet()).hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteTable)) {
            return false;
        }
        RouteTable other = (RouteTable)obj;
        if (other.getRouteTableId() == null ^ this.getRouteTableId() == null) {
            return false;
        }
        if (other.getRouteTableId() != null && !other.getRouteTableId().equals(this.getRouteTableId())) {
            return false;
        }
        if (other.getVpcId() == null ^ this.getVpcId() == null) {
            return false;
        }
        if (other.getVpcId() != null && !other.getVpcId().equals(this.getVpcId())) {
            return false;
        }
        if (other.getRoutes() == null ^ this.getRoutes() == null) {
            return false;
        }
        if (other.getRoutes() != null && !((Object)other.getRoutes()).equals(this.getRoutes())) {
            return false;
        }
        if (other.getAssociations() == null ^ this.getAssociations() == null) {
            return false;
        }
        if (other.getAssociations() != null && !((Object)other.getAssociations()).equals(this.getAssociations())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !((Object)other.getTags()).equals(this.getTags())) {
            return false;
        }
        if (other.getPropagatingVgwSet() == null ^ this.getPropagatingVgwSet() == null) {
            return false;
        }
        return other.getPropagatingVgwSet() == null || ((Object)other.getPropagatingVgwSet()).equals(this.getPropagatingVgwSet());
    }
}

