/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.services.ec2.model.InstanceState;
import com.amazonaws.services.ec2.model.InstanceStatusEvent;
import com.amazonaws.services.ec2.model.InstanceStatusSummary;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class InstanceStatus {
    private String instanceId;
    private String availabilityZone;
    private List<InstanceStatusEvent> events;
    private InstanceState instanceState;
    private InstanceStatusSummary systemStatus;
    private InstanceStatusSummary instanceStatus;

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public InstanceStatus withInstanceId(String instanceId) {
        this.instanceId = instanceId;
        return this;
    }

    public String getAvailabilityZone() {
        return this.availabilityZone;
    }

    public void setAvailabilityZone(String availabilityZone) {
        this.availabilityZone = availabilityZone;
    }

    public InstanceStatus withAvailabilityZone(String availabilityZone) {
        this.availabilityZone = availabilityZone;
        return this;
    }

    public List<InstanceStatusEvent> getEvents() {
        if (this.events == null) {
            this.events = new ArrayList<InstanceStatusEvent>();
        }
        return this.events;
    }

    public void setEvents(Collection<InstanceStatusEvent> events) {
        if (events == null) {
            this.events = null;
            return;
        }
        ArrayList<InstanceStatusEvent> eventsCopy = new ArrayList<InstanceStatusEvent>(events.size());
        eventsCopy.addAll(events);
        this.events = eventsCopy;
    }

    public InstanceStatus withEvents(InstanceStatusEvent ... events) {
        if (this.getEvents() == null) {
            this.setEvents(new ArrayList<InstanceStatusEvent>(events.length));
        }
        for (InstanceStatusEvent value : events) {
            this.getEvents().add(value);
        }
        return this;
    }

    public InstanceStatus withEvents(Collection<InstanceStatusEvent> events) {
        if (events == null) {
            this.events = null;
        } else {
            ArrayList<InstanceStatusEvent> eventsCopy = new ArrayList<InstanceStatusEvent>(events.size());
            eventsCopy.addAll(events);
            this.events = eventsCopy;
        }
        return this;
    }

    public InstanceState getInstanceState() {
        return this.instanceState;
    }

    public void setInstanceState(InstanceState instanceState) {
        this.instanceState = instanceState;
    }

    public InstanceStatus withInstanceState(InstanceState instanceState) {
        this.instanceState = instanceState;
        return this;
    }

    public InstanceStatusSummary getSystemStatus() {
        return this.systemStatus;
    }

    public void setSystemStatus(InstanceStatusSummary systemStatus) {
        this.systemStatus = systemStatus;
    }

    public InstanceStatus withSystemStatus(InstanceStatusSummary systemStatus) {
        this.systemStatus = systemStatus;
        return this;
    }

    public InstanceStatusSummary getInstanceStatus() {
        return this.instanceStatus;
    }

    public void setInstanceStatus(InstanceStatusSummary instanceStatus) {
        this.instanceStatus = instanceStatus;
    }

    public InstanceStatus withInstanceStatus(InstanceStatusSummary instanceStatus) {
        this.instanceStatus = instanceStatus;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.instanceId != null) {
            sb.append("InstanceId: " + this.instanceId + ", ");
        }
        if (this.availabilityZone != null) {
            sb.append("AvailabilityZone: " + this.availabilityZone + ", ");
        }
        if (this.events != null) {
            sb.append("Events: " + this.events + ", ");
        }
        if (this.instanceState != null) {
            sb.append("InstanceState: " + this.instanceState + ", ");
        }
        if (this.systemStatus != null) {
            sb.append("SystemStatus: " + this.systemStatus + ", ");
        }
        if (this.instanceStatus != null) {
            sb.append("InstanceStatus: " + this.instanceStatus + ", ");
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getInstanceId() == null ? 0 : this.getInstanceId().hashCode());
        hashCode = 31 * hashCode + (this.getAvailabilityZone() == null ? 0 : this.getAvailabilityZone().hashCode());
        hashCode = 31 * hashCode + (this.getEvents() == null ? 0 : ((Object)this.getEvents()).hashCode());
        hashCode = 31 * hashCode + (this.getInstanceState() == null ? 0 : this.getInstanceState().hashCode());
        hashCode = 31 * hashCode + (this.getSystemStatus() == null ? 0 : this.getSystemStatus().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceStatus() == null ? 0 : this.getInstanceStatus().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceStatus)) {
            return false;
        }
        InstanceStatus other = (InstanceStatus)obj;
        if (other.getInstanceId() == null ^ this.getInstanceId() == null) {
            return false;
        }
        if (other.getInstanceId() != null && !other.getInstanceId().equals(this.getInstanceId())) {
            return false;
        }
        if (other.getAvailabilityZone() == null ^ this.getAvailabilityZone() == null) {
            return false;
        }
        if (other.getAvailabilityZone() != null && !other.getAvailabilityZone().equals(this.getAvailabilityZone())) {
            return false;
        }
        if (other.getEvents() == null ^ this.getEvents() == null) {
            return false;
        }
        if (other.getEvents() != null && !((Object)other.getEvents()).equals(this.getEvents())) {
            return false;
        }
        if (other.getInstanceState() == null ^ this.getInstanceState() == null) {
            return false;
        }
        if (other.getInstanceState() != null && !other.getInstanceState().equals(this.getInstanceState())) {
            return false;
        }
        if (other.getSystemStatus() == null ^ this.getSystemStatus() == null) {
            return false;
        }
        if (other.getSystemStatus() != null && !other.getSystemStatus().equals(this.getSystemStatus())) {
            return false;
        }
        if (other.getInstanceStatus() == null ^ this.getInstanceStatus() == null) {
            return false;
        }
        return other.getInstanceStatus() == null || other.getInstanceStatus().equals(this.getInstanceStatus());
    }
}

