/*
 * Copyright 2010 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "ka" locale.
 */
public class LocalizedNamesImpl_ka extends LocalizedNamesImpl {

  @Override
  public String[] loadLikelyRegionCodes() {
    return new String[] {
        "GE",
    };
  }

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AC",
        "BL",
        "CC",
        "CP",
        "DG",
        "EA",
        "GF",
        "GG",
        "IC",
        "MF",
        "MP",
        "NU",
        "PN",
        "SJ",
        "TA",
        "TC",
        "TK",
        "VG",
        "VI",
        "YT",
        "AU",
        "AT",
        "AF",
        "AZ",
        "AX",
        "AL",
        "DZ",
        "US",
        "AS",
        "AI",
        "AO",
        "AD",
        "AQ",
        "AG",
        "AE",
        "AR",
        "AW",
        "TL",
        "NZ",
        "NC",
        "BD",
        "BB",
        "BS",
        "BH",
        "BE",
        "BZ",
        "BY",
        "BJ",
        "BM",
        "BO",
        "BA",
        "BW",
        "BR",
        "IO",
        "BN",
        "BV",
        "BG",
        "BF",
        "BI",
        "BT",
        "GA",
        "GY",
        "GM",
        "GH",
        "DE",
        "GP",
        "GT",
        "GN",
        "GW",
        "GI",
        "GD",
        "GL",
        "GU",
        "DK",
        "EH",
        "QO",
        "GB",
        "DM",
        "DO",
        "EG",
        "EU",
        "ET",
        "EC",
        "GQ",
        "IQ",
        "ER",
        "ES",
        "EE",
        "WF",
        "VU",
        "VA",
        "VE",
        "VN",
        "ZM",
        "ZW",
        "TR",
        "TM",
        "JM",
        "JP",
        "YE",
        "IN",
        "ID",
        "JO",
        "IR",
        "IE",
        "IS",
        "IL",
        "IT",
        "CV",
        "KY",
        "KH",
        "CM",
        "CA",
        "QA",
        "KE",
        "CY",
        "KI",
        "CO",
        "KM",
        "CG",
        "CD",
        "CR",
        "CU",
        "KW",
        "CK",
        "LA",
        "LV",
        "LS",
        "LB",
        "LR",
        "LY",
        "LT",
        "LI",
        "LU",
        "MG",
        "MU",
        "MR",
        "MO",
        "MK",
        "MW",
        "MY",
        "MV",
        "ML",
        "MT",
        "IM",
        "MA",
        "MQ",
        "MH",
        "MX",
        "MM",
        "FM",
        "MZ",
        "MD",
        "MC",
        "MS",
        "ME",
        "MN",
        "NA",
        "NR",
        "NP",
        "NE",
        "NG",
        "NL",
        "AN",
        "NI",
        "NO",
        "NF",
        "OM",
        "PK",
        "PW",
        "PS",
        "PA",
        "PG",
        "PY",
        "PE",
        "PL",
        "PT",
        "PR",
        "RE",
        "RW",
        "RO",
        "RU",
        "GR",
        "SV",
        "WS",
        "ZA",
        "KR",
        "GS",
        "SM",
        "ST",
        "SA",
        "FR",
        "GE",
        "SC",
        "SN",
        "VC",
        "KN",
        "LC",
        "PM",
        "RS",
        "CS",
        "SZ",
        "SL",
        "SG",
        "SY",
        "SK",
        "SI",
        "SB",
        "SO",
        "AM",
        "CI",
        "SD",
        "SR",
        "TW",
        "TH",
        "TZ",
        "TJ",
        "TG",
        "TO",
        "TT",
        "TV",
        "TN",
        "UG",
        "UZ",
        "UA",
        "HU",
        "UY",
        "FK",
        "FO",
        "PH",
        "FI",
        "FJ",
        "PF",
        "TF",
        "KZ",
        "KG",
        "UM",
        "CH",
        "SE",
        "CX",
        "LK",
        "TD",
        "CZ",
        "CL",
        "CN",
        "KP",
        "CF",
        "SH",
        "JE",
        "DJ",
        "HT",
        "HM",
        "HK",
        "HN",
        "HR",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "მსოფლიო");
    namesMap.put("002", "აფრიკა");
    namesMap.put("003", "ჩრდილოეთ ამერიკა");
    namesMap.put("005", "სამხრეთი ამერიკა");
    namesMap.put("009", "ოკეანეთი");
    namesMap.put("011", "დასავლეთი აფრიკა");
    namesMap.put("013", "ცენტრალური ამერიკა");
    namesMap.put("014", "აღმოსავლეთი აფრიკა");
    namesMap.put("015", "ჩრდილოეთი აფრიკა");
    namesMap.put("017", "შუა აფრიკა");
    namesMap.put("018", "სამხრეთი აფრიკა");
    namesMap.put("019", "ამერიკები");
    namesMap.put("021", "ჩრდილოეთი ამერიკა");
    namesMap.put("029", "კარიბი");
    namesMap.put("030", "აღმოსავლეთი აზია");
    namesMap.put("034", "სამხრეთი აზია");
    namesMap.put("035", "სამხრეთ-აღმოსავლეთი აზია");
    namesMap.put("039", "სამხრეთი ევროპა");
    namesMap.put("053", "ავსტრალია და ახალი ზელანდია");
    namesMap.put("054", "მელანეზია");
    namesMap.put("057", "მირონეზია");
    namesMap.put("061", "პოლინეზია");
    namesMap.put("062", "სამხრეთ-ცენტრალური აზია");
    namesMap.put("142", "აზია");
    namesMap.put("143", "ცენტრალური აზია");
    namesMap.put("145", "დასავლეთი აზია");
    namesMap.put("150", "ევროპა");
    namesMap.put("151", "აღმოსავლეთი ევროპა");
    namesMap.put("154", "ჩრდილოეთი ევროპა");
    namesMap.put("155", "დასავლეთი ევროპა");
    namesMap.put("172", "დამოუკიდებელ სახელმწიფოთა თანამეგობრობა");
    namesMap.put("419", "ლათინური ამერიკა და კარიბი");
    namesMap.put("AD", "ანდორა");
    namesMap.put("AE", "არაბეთის გაერთიანებული ემირატები");
    namesMap.put("AF", "ავღანეთი");
    namesMap.put("AG", "ანტიგუა და ბარბუდა");
    namesMap.put("AI", "ანგვილა");
    namesMap.put("AL", "ალბანეთი");
    namesMap.put("AM", "სომხეთი");
    namesMap.put("AN", "ნიდერლანდების ანტილები");
    namesMap.put("AO", "ანგოლა");
    namesMap.put("AQ", "ანტარქტიკა");
    namesMap.put("AR", "არგენტინა");
    namesMap.put("AS", "ამერიკული სამოა");
    namesMap.put("AT", "ავსტრია");
    namesMap.put("AU", "ავსტრალია");
    namesMap.put("AW", "არუბა");
    namesMap.put("AX", "ალანდის კუნძულები");
    namesMap.put("AZ", "აზერბაიჯანი");
    namesMap.put("BA", "ბოსნია და ჰერცეგოვინა");
    namesMap.put("BB", "ბარბადოსი");
    namesMap.put("BD", "ბანგლადეში");
    namesMap.put("BE", "ბელგია");
    namesMap.put("BF", "ბურკინა-ფასო");
    namesMap.put("BG", "ბულგარეთი");
    namesMap.put("BH", "ბაჰრეინი");
    namesMap.put("BI", "ბურუნდი");
    namesMap.put("BJ", "ბენინი");
    namesMap.put("BM", "ბერმუდა");
    namesMap.put("BN", "ბრუნეი");
    namesMap.put("BO", "ბოლივია");
    namesMap.put("BR", "ბრაზილია");
    namesMap.put("BS", "ბაჰამის კუნძულები");
    namesMap.put("BT", "ბუტანი");
    namesMap.put("BV", "ბუვეს კუნძული");
    namesMap.put("BW", "ბოტსვანა");
    namesMap.put("BY", "ბელორუსია");
    namesMap.put("BZ", "ბელიზი");
    namesMap.put("CA", "კანადა");
    namesMap.put("CD", "კონგო - კინშასა");
    namesMap.put("CF", "ცენტრალური აფრიკის რესპუბლიკა");
    namesMap.put("CG", "კონგო");
    namesMap.put("CH", "შვეიცარია");
    namesMap.put("CI", "სპილოს ძვლის სანაპირო");
    namesMap.put("CK", "კუკის კუნძულები");
    namesMap.put("CL", "ჩილე");
    namesMap.put("CM", "კამერუნი");
    namesMap.put("CN", "ჩინეთი");
    namesMap.put("CO", "კოლუმბია");
    namesMap.put("CR", "კოსტა-რიკა");
    namesMap.put("CS", "სერბია და მონტენეგრო");
    namesMap.put("CU", "კუბა");
    namesMap.put("CV", "კაბო-ვერდე");
    namesMap.put("CX", "შობის კუნძული");
    namesMap.put("CY", "კვიპროსი");
    namesMap.put("CZ", "ჩეხეთის რესპუბლიკა");
    namesMap.put("DE", "გერმანია");
    namesMap.put("DJ", "ჯიბუტი");
    namesMap.put("DK", "დანია");
    namesMap.put("DM", "დომინიკა");
    namesMap.put("DO", "დომინიკანის რესპუბლიკა");
    namesMap.put("DZ", "ალჟირი");
    namesMap.put("EC", "ეკვადორი");
    namesMap.put("EE", "ესტონეთი");
    namesMap.put("EG", "ეგვიპტე");
    namesMap.put("EH", "დასავლეთი საჰარა");
    namesMap.put("ER", "ერიტრეა");
    namesMap.put("ES", "ესპანეთი");
    namesMap.put("ET", "ეთიოპია");
    namesMap.put("EU", "ევროკავშირი");
    namesMap.put("FI", "ფინეთი");
    namesMap.put("FJ", "ფიჯი");
    namesMap.put("FK", "ფალკლენდის კუნძულები");
    namesMap.put("FM", "მიკრონეზია");
    namesMap.put("FO", "ფაროს კუნძულები");
    namesMap.put("FR", "საფრანგეთი");
    namesMap.put("GA", "გაბონი");
    namesMap.put("GB", "დიდი ბრიტანეთი");
    namesMap.put("GD", "გრენადა");
    namesMap.put("GE", "საქართველო");
    namesMap.put("GH", "განა");
    namesMap.put("GI", "გიბრალტარი");
    namesMap.put("GL", "გრენლანდია");
    namesMap.put("GM", "გამბია");
    namesMap.put("GN", "გვინეა");
    namesMap.put("GP", "გვადელუპე");
    namesMap.put("GQ", "ეკვატორული გვინეა");
    namesMap.put("GR", "საბერძნეთი");
    namesMap.put("GS", "სამხრეთი ჯორჯია და სამხრეთ სენდვიჩის კუნძულები");
    namesMap.put("GT", "გვატემალა");
    namesMap.put("GU", "გუამი");
    namesMap.put("GW", "გვინეა-ბისაუ");
    namesMap.put("GY", "გაიანა");
    namesMap.put("HK", "ჰონგ კონგი");
    namesMap.put("HM", "ჰერდის კუნძული და მაკდონალდის კუნძულები");
    namesMap.put("HN", "ჰონდურასი");
    namesMap.put("HR", "ჰორვატია");
    namesMap.put("HT", "ჰაიტი");
    namesMap.put("HU", "უნგრეთი");
    namesMap.put("ID", "ინდონეზია");
    namesMap.put("IE", "ირლანდია");
    namesMap.put("IL", "ისრაელი");
    namesMap.put("IM", "მანის კუნძული");
    namesMap.put("IN", "ინდოეთი");
    namesMap.put("IO", "ბრიტანული ტერიტორია ინდოეთის ოკეანეში");
    namesMap.put("IQ", "ერაყი");
    namesMap.put("IR", "ირანი");
    namesMap.put("IS", "ისლანდია");
    namesMap.put("IT", "იტალია");
    namesMap.put("JE", "ჯერსი");
    namesMap.put("JM", "იამაიკა");
    namesMap.put("JO", "იორდანია");
    namesMap.put("JP", "იაპონია");
    namesMap.put("KE", "კენია");
    namesMap.put("KG", "ყირგიზეთი");
    namesMap.put("KH", "კამბოჯა");
    namesMap.put("KI", "კირიბატი");
    namesMap.put("KM", "კომორის კუნძულები");
    namesMap.put("KN", "სენტ-კიტსი და ნევისი");
    namesMap.put("KP", "ჩრდილოეთი კორეა");
    namesMap.put("KR", "სამხრეთი კორეა");
    namesMap.put("KW", "კუვეიტი");
    namesMap.put("KY", "კაიმანის კუნძულები");
    namesMap.put("KZ", "ყაზახეთი");
    namesMap.put("LA", "ლაოსი");
    namesMap.put("LB", "ლიბანი");
    namesMap.put("LC", "სენტ-ლუსია");
    namesMap.put("LI", "ლიხტენშტაინი");
    namesMap.put("LK", "შრი-ლანკა");
    namesMap.put("LR", "ლიბერია");
    namesMap.put("LS", "ლესოთო");
    namesMap.put("LT", "ლიტვა");
    namesMap.put("LU", "ლუქსემბურგი");
    namesMap.put("LV", "ლატვია");
    namesMap.put("LY", "ლიბია");
    namesMap.put("MA", "მაროკო");
    namesMap.put("MC", "მონაკო");
    namesMap.put("MD", "მოლდოვა");
    namesMap.put("ME", "მონტენეგრო");
    namesMap.put("MG", "მადაგასკარი");
    namesMap.put("MH", "მარშალის კუნძულები");
    namesMap.put("MK", "მაკედონია");
    namesMap.put("ML", "მალი");
    namesMap.put("MM", "მიანმარი");
    namesMap.put("MN", "მონღოლეთი");
    namesMap.put("MO", "მაკაო");
    namesMap.put("MQ", "მარტინიკი");
    namesMap.put("MR", "მავრიტანია");
    namesMap.put("MS", "მონსერატი");
    namesMap.put("MT", "მალტა");
    namesMap.put("MU", "მავრიკია");
    namesMap.put("MV", "მალდივის კუნძულები");
    namesMap.put("MW", "მალავი");
    namesMap.put("MX", "მექსიკა");
    namesMap.put("MY", "მალაიზია");
    namesMap.put("MZ", "მოზამბიკი");
    namesMap.put("NA", "ნამიბია");
    namesMap.put("NC", "ახალი კალედონია");
    namesMap.put("NE", "ნიგერი");
    namesMap.put("NF", "ნორფოლკის კუნძული");
    namesMap.put("NG", "ნიგერია");
    namesMap.put("NI", "ნიკარაგუა");
    namesMap.put("NL", "ნიდერლანდები");
    namesMap.put("NO", "ნორვეგია");
    namesMap.put("NP", "ნეპალი");
    namesMap.put("NR", "ნაურუ");
    namesMap.put("NZ", "ახალი ზელანდია");
    namesMap.put("OM", "ომანი");
    namesMap.put("PA", "პანამა");
    namesMap.put("PE", "პერუ");
    namesMap.put("PF", "ფრანგული პოლინეზია");
    namesMap.put("PG", "პაპუა-ახალი გვინეა");
    namesMap.put("PH", "ფილიპინები");
    namesMap.put("PK", "პაკისტანი");
    namesMap.put("PL", "პოლონეთი");
    namesMap.put("PM", "სენტ-პიერი და მიქელონი");
    namesMap.put("PR", "პუერტო რიკო");
    namesMap.put("PS", "პალესტინის ტერიტორია");
    namesMap.put("PT", "პორტუგალია");
    namesMap.put("PW", "პალაუ");
    namesMap.put("PY", "პარაგვაი");
    namesMap.put("QA", "კატარი");
    namesMap.put("QO", "დაშორებული ოკეანია");
    namesMap.put("RE", "რეიუნიონი");
    namesMap.put("RO", "რუმინეთი");
    namesMap.put("RS", "სერბია");
    namesMap.put("RU", "რუსეთი");
    namesMap.put("RW", "რუანდა");
    namesMap.put("SA", "საუდის არაბეთი");
    namesMap.put("SB", "სოლომონის კუნძულები");
    namesMap.put("SC", "სეიშელის კუნძულები");
    namesMap.put("SD", "სუდანი");
    namesMap.put("SE", "შვეცია");
    namesMap.put("SG", "სინგაპური");
    namesMap.put("SH", "წმინდა ელენეს კუნძული");
    namesMap.put("SI", "სლოვენია");
    namesMap.put("SK", "სლოვაკეთი");
    namesMap.put("SL", "სიერა-ლეონე");
    namesMap.put("SM", "სან-მარინო");
    namesMap.put("SN", "სენეგალი");
    namesMap.put("SO", "სომალი");
    namesMap.put("SR", "სურინამი");
    namesMap.put("ST", "საო-ტომე და პრინსიპი");
    namesMap.put("SV", "სალვადორი");
    namesMap.put("SY", "სირია");
    namesMap.put("SZ", "სვაზილენდი");
    namesMap.put("TD", "ჩადი");
    namesMap.put("TF", "ფრანგული სამხრეთის ტერიტორიები");
    namesMap.put("TG", "ტოგო");
    namesMap.put("TH", "ტაილანდი");
    namesMap.put("TJ", "ტაჯიკეთი");
    namesMap.put("TL", "აღმოსავლეთი ტიმორი");
    namesMap.put("TM", "თურქმენეთი");
    namesMap.put("TN", "ტუნისი");
    namesMap.put("TO", "ტონგა");
    namesMap.put("TR", "თურქეთი");
    namesMap.put("TT", "ტრინიდადი და ტობაგო");
    namesMap.put("TV", "ტუვალუ");
    namesMap.put("TW", "ტაივანი");
    namesMap.put("TZ", "ტანზანია");
    namesMap.put("UA", "უკრაინა");
    namesMap.put("UG", "უგანდა");
    namesMap.put("UM", "შეერთებული შტატების მცირე დაშორებული კუნძულები");
    namesMap.put("US", "ამერიკის შეერთებული შტატები");
    namesMap.put("UY", "ურუგვაი");
    namesMap.put("UZ", "უზბეკეთი");
    namesMap.put("VA", "ვატიკანი");
    namesMap.put("VC", "სენტ-ვინსენტი და გრენადინები");
    namesMap.put("VE", "ვენესუელა");
    namesMap.put("VN", "ვიეტნამი");
    namesMap.put("VU", "ვანუატუ");
    namesMap.put("WF", "ვალისი და ფუტუნა");
    namesMap.put("WS", "სამოა");
    namesMap.put("YE", "იემენი");
    namesMap.put("ZA", "სამხრეთ აფრიკა");
    namesMap.put("ZM", "ზამბია");
    namesMap.put("ZW", "ზიმბაბვე");
    namesMap.put("ZZ", "უცნობი ან არასწორი რეგიონი");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "მსოფლიო",
        "002": "აფრიკა",
        "003": "ჩრდილოეთ ამერიკა",
        "005": "სამხრეთი ამერიკა",
        "009": "ოკეანეთი",
        "011": "დასავლეთი აფრიკა",
        "013": "ცენტრალური ამერიკა",
        "014": "აღმოსავლეთი აფრიკა",
        "015": "ჩრდილოეთი აფრიკა",
        "017": "შუა აფრიკა",
        "018": "სამხრეთი აფრიკა",
        "019": "ამერიკები",
        "021": "ჩრდილოეთი ამერიკა",
        "029": "კარიბი",
        "030": "აღმოსავლეთი აზია",
        "034": "სამხრეთი აზია",
        "035": "სამხრეთ-აღმოსავლეთი აზია",
        "039": "სამხრეთი ევროპა",
        "053": "ავსტრალია და ახალი ზელანდია",
        "054": "მელანეზია",
        "057": "მირონეზია",
        "061": "პოლინეზია",
        "062": "სამხრეთ-ცენტრალური აზია",
        "142": "აზია",
        "143": "ცენტრალური აზია",
        "145": "დასავლეთი აზია",
        "150": "ევროპა",
        "151": "აღმოსავლეთი ევროპა",
        "154": "ჩრდილოეთი ევროპა",
        "155": "დასავლეთი ევროპა",
        "172": "დამოუკიდებელ სახელმწიფოთა თანამეგობრობა",
        "419": "ლათინური ამერიკა და კარიბი",
        "AD": "ანდორა",
        "AE": "არაბეთის გაერთიანებული ემირატები",
        "AF": "ავღანეთი",
        "AG": "ანტიგუა და ბარბუდა",
        "AI": "ანგვილა",
        "AL": "ალბანეთი",
        "AM": "სომხეთი",
        "AN": "ნიდერლანდების ანტილები",
        "AO": "ანგოლა",
        "AQ": "ანტარქტიკა",
        "AR": "არგენტინა",
        "AS": "ამერიკული სამოა",
        "AT": "ავსტრია",
        "AU": "ავსტრალია",
        "AW": "არუბა",
        "AX": "ალანდის კუნძულები",
        "AZ": "აზერბაიჯანი",
        "BA": "ბოსნია და ჰერცეგოვინა",
        "BB": "ბარბადოსი",
        "BD": "ბანგლადეში",
        "BE": "ბელგია",
        "BF": "ბურკინა-ფასო",
        "BG": "ბულგარეთი",
        "BH": "ბაჰრეინი",
        "BI": "ბურუნდი",
        "BJ": "ბენინი",
        "BM": "ბერმუდა",
        "BN": "ბრუნეი",
        "BO": "ბოლივია",
        "BR": "ბრაზილია",
        "BS": "ბაჰამის კუნძულები",
        "BT": "ბუტანი",
        "BV": "ბუვეს კუნძული",
        "BW": "ბოტსვანა",
        "BY": "ბელორუსია",
        "BZ": "ბელიზი",
        "CA": "კანადა",
        "CD": "კონგო - კინშასა",
        "CF": "ცენტრალური აფრიკის რესპუბლიკა",
        "CG": "კონგო",
        "CH": "შვეიცარია",
        "CI": "სპილოს ძვლის სანაპირო",
        "CK": "კუკის კუნძულები",
        "CL": "ჩილე",
        "CM": "კამერუნი",
        "CN": "ჩინეთი",
        "CO": "კოლუმბია",
        "CR": "კოსტა-რიკა",
        "CS": "სერბია და მონტენეგრო",
        "CU": "კუბა",
        "CV": "კაბო-ვერდე",
        "CX": "შობის კუნძული",
        "CY": "კვიპროსი",
        "CZ": "ჩეხეთის რესპუბლიკა",
        "DE": "გერმანია",
        "DJ": "ჯიბუტი",
        "DK": "დანია",
        "DM": "დომინიკა",
        "DO": "დომინიკანის რესპუბლიკა",
        "DZ": "ალჟირი",
        "EC": "ეკვადორი",
        "EE": "ესტონეთი",
        "EG": "ეგვიპტე",
        "EH": "დასავლეთი საჰარა",
        "ER": "ერიტრეა",
        "ES": "ესპანეთი",
        "ET": "ეთიოპია",
        "EU": "ევროკავშირი",
        "FI": "ფინეთი",
        "FJ": "ფიჯი",
        "FK": "ფალკლენდის კუნძულები",
        "FM": "მიკრონეზია",
        "FO": "ფაროს კუნძულები",
        "FR": "საფრანგეთი",
        "GA": "გაბონი",
        "GB": "დიდი ბრიტანეთი",
        "GD": "გრენადა",
        "GE": "საქართველო",
        "GH": "განა",
        "GI": "გიბრალტარი",
        "GL": "გრენლანდია",
        "GM": "გამბია",
        "GN": "გვინეა",
        "GP": "გვადელუპე",
        "GQ": "ეკვატორული გვინეა",
        "GR": "საბერძნეთი",
        "GS": "სამხრეთი ჯორჯია და სამხრეთ სენდვიჩის კუნძულები",
        "GT": "გვატემალა",
        "GU": "გუამი",
        "GW": "გვინეა-ბისაუ",
        "GY": "გაიანა",
        "HK": "ჰონგ კონგი",
        "HM": "ჰერდის კუნძული და მაკდონალდის კუნძულები",
        "HN": "ჰონდურასი",
        "HR": "ჰორვატია",
        "HT": "ჰაიტი",
        "HU": "უნგრეთი",
        "ID": "ინდონეზია",
        "IE": "ირლანდია",
        "IL": "ისრაელი",
        "IM": "მანის კუნძული",
        "IN": "ინდოეთი",
        "IO": "ბრიტანული ტერიტორია ინდოეთის ოკეანეში",
        "IQ": "ერაყი",
        "IR": "ირანი",
        "IS": "ისლანდია",
        "IT": "იტალია",
        "JE": "ჯერსი",
        "JM": "იამაიკა",
        "JO": "იორდანია",
        "JP": "იაპონია",
        "KE": "კენია",
        "KG": "ყირგიზეთი",
        "KH": "კამბოჯა",
        "KI": "კირიბატი",
        "KM": "კომორის კუნძულები",
        "KN": "სენტ-კიტსი და ნევისი",
        "KP": "ჩრდილოეთი კორეა",
        "KR": "სამხრეთი კორეა",
        "KW": "კუვეიტი",
        "KY": "კაიმანის კუნძულები",
        "KZ": "ყაზახეთი",
        "LA": "ლაოსი",
        "LB": "ლიბანი",
        "LC": "სენტ-ლუსია",
        "LI": "ლიხტენშტაინი",
        "LK": "შრი-ლანკა",
        "LR": "ლიბერია",
        "LS": "ლესოთო",
        "LT": "ლიტვა",
        "LU": "ლუქსემბურგი",
        "LV": "ლატვია",
        "LY": "ლიბია",
        "MA": "მაროკო",
        "MC": "მონაკო",
        "MD": "მოლდოვა",
        "ME": "მონტენეგრო",
        "MG": "მადაგასკარი",
        "MH": "მარშალის კუნძულები",
        "MK": "მაკედონია",
        "ML": "მალი",
        "MM": "მიანმარი",
        "MN": "მონღოლეთი",
        "MO": "მაკაო",
        "MQ": "მარტინიკი",
        "MR": "მავრიტანია",
        "MS": "მონსერატი",
        "MT": "მალტა",
        "MU": "მავრიკია",
        "MV": "მალდივის კუნძულები",
        "MW": "მალავი",
        "MX": "მექსიკა",
        "MY": "მალაიზია",
        "MZ": "მოზამბიკი",
        "NA": "ნამიბია",
        "NC": "ახალი კალედონია",
        "NE": "ნიგერი",
        "NF": "ნორფოლკის კუნძული",
        "NG": "ნიგერია",
        "NI": "ნიკარაგუა",
        "NL": "ნიდერლანდები",
        "NO": "ნორვეგია",
        "NP": "ნეპალი",
        "NR": "ნაურუ",
        "NZ": "ახალი ზელანდია",
        "OM": "ომანი",
        "PA": "პანამა",
        "PE": "პერუ",
        "PF": "ფრანგული პოლინეზია",
        "PG": "პაპუა-ახალი გვინეა",
        "PH": "ფილიპინები",
        "PK": "პაკისტანი",
        "PL": "პოლონეთი",
        "PM": "სენტ-პიერი და მიქელონი",
        "PR": "პუერტო რიკო",
        "PS": "პალესტინის ტერიტორია",
        "PT": "პორტუგალია",
        "PW": "პალაუ",
        "PY": "პარაგვაი",
        "QA": "კატარი",
        "QO": "დაშორებული ოკეანია",
        "RE": "რეიუნიონი",
        "RO": "რუმინეთი",
        "RS": "სერბია",
        "RU": "რუსეთი",
        "RW": "რუანდა",
        "SA": "საუდის არაბეთი",
        "SB": "სოლომონის კუნძულები",
        "SC": "სეიშელის კუნძულები",
        "SD": "სუდანი",
        "SE": "შვეცია",
        "SG": "სინგაპური",
        "SH": "წმინდა ელენეს კუნძული",
        "SI": "სლოვენია",
        "SK": "სლოვაკეთი",
        "SL": "სიერა-ლეონე",
        "SM": "სან-მარინო",
        "SN": "სენეგალი",
        "SO": "სომალი",
        "SR": "სურინამი",
        "ST": "საო-ტომე და პრინსიპი",
        "SV": "სალვადორი",
        "SY": "სირია",
        "SZ": "სვაზილენდი",
        "TD": "ჩადი",
        "TF": "ფრანგული სამხრეთის ტერიტორიები",
        "TG": "ტოგო",
        "TH": "ტაილანდი",
        "TJ": "ტაჯიკეთი",
        "TL": "აღმოსავლეთი ტიმორი",
        "TM": "თურქმენეთი",
        "TN": "ტუნისი",
        "TO": "ტონგა",
        "TR": "თურქეთი",
        "TT": "ტრინიდადი და ტობაგო",
        "TV": "ტუვალუ",
        "TW": "ტაივანი",
        "TZ": "ტანზანია",
        "UA": "უკრაინა",
        "UG": "უგანდა",
        "UM": "შეერთებული შტატების მცირე დაშორებული კუნძულები",
        "US": "ამერიკის შეერთებული შტატები",
        "UY": "ურუგვაი",
        "UZ": "უზბეკეთი",
        "VA": "ვატიკანი",
        "VC": "სენტ-ვინსენტი და გრენადინები",
        "VE": "ვენესუელა",
        "VN": "ვიეტნამი",
        "VU": "ვანუატუ",
        "WF": "ვალისი და ფუტუნა",
        "WS": "სამოა",
        "YE": "იემენი",
        "ZA": "სამხრეთ აფრიკა",
        "ZM": "ზამბია",
        "ZW": "ზიმბაბვე",
        "ZZ": "უცნობი ან არასწორი რეგიონი"
    };
  }-*/;
}
