/*
 * XMLModelCombiner.java
 *
 * Copyright (c) 2002-2015 Alexei Drummond, Andrew Rambaut and Marc Suchard
 *
 * This file is part of BEAST.
 * See the NOTICE file distributed with this work for additional
 * information regarding copyright ownership and licensing.
 *
 * BEAST is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 *  BEAST is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with BEAST; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin St, Fifth Floor,
 * Boston, MA  02110-1301  USA
 */

package dr.xml;

import org.jdom.output.XMLOutputter;

import javax.swing.*;
import javax.swing.event.ListDataListener;
import java.io.OutputStream;
import java.util.HashMap;

/**
 * Package: XMLModelCombiner
 * Description:
 * <p/>
 * <p/>
 * Created by
 * Alexander V. Alekseyenko (alexander.alekseyenko@gmail.com)
 * Date: Apr 13, 2009
 * Time: 1:23:34 PM
 */
public class XMLModelCombiner implements ListModel {
    private XMLModelFile from;
    private XMLModelFile to;
    private XMLIDMapping mapping;

    public XMLModelCombiner(XMLModelFile model1, XMLModelFile model2) {
        from = model1;
        to = model2;
        mapping = new XMLIDMapping();
    }

    public void writeXML(OutputStream ostream) {
        from.prefixIdentifiedNames("from", mapping.getFromNames(), true);
        to.prefixIdentifiedNames("to", mapping.getToNames(), false);
        XMLOutputter outputter = new XMLOutputter();
        from.print(outputter, ostream);
        to.print(outputter, ostream);

    }

    public int getSize() {
        return mapping.getFromNames().size();
    }

    public Object getElementAt(int i) {
        return null;  //AUTOGENERATED METHOD IMPLEMENTATION
    }

    public void addListDataListener(ListDataListener listDataListener) {
        //AUTOGENERATED METHOD IMPLEMENTATION
    }

    public void removeListDataListener(ListDataListener listDataListener) {
        //AUTOGENERATED METHOD IMPLEMENTATION
    }

    public class XMLIDMapping {
        HashMap<String, String> fromMap;
        HashMap<String, String> toMap;

        public XMLIDMapping() {
            fromMap = new HashMap<String, String>();
            toMap = new HashMap<String, String>();
        }

        public void addRule(String cName, String m1Name, String m2Name) {
            fromMap.put(cName, m1Name);
            toMap.put(cName, m2Name);
        }

        public void removeRule(String cName) {
            fromMap.remove(cName);
            toMap.remove(cName);
        }

        public HashMap<String, String> getFromNames() {
            return fromMap;
        }

        public HashMap<String, String> getToNames() {
            return toMap;
        }
    }

//    public static void main(String[] args){
//        XMLModelCombiner mc = new XMLModelCombiner(new XMLModelFile("small1.xml"), new XMLModelFile("small2.xml"));
//
//
//    }
}
