**The ASTRA Toolbox** provides high-performance GPU primitives for 2D and 3D tomography. It supports 2D parallel and fan beam, and 3D parallel and cone beam geometries.  All of them have highly flexible source/detector positioning. A large number of 2D and 3D algorithms are available, including FBP, SIRT, SART, CGLS. The basic forward and backward projection operations are GPU-accelerated, and directly callable from Python to enable building new algorithms.

## References

If you use the ASTRA Toolbox for your research, we would appreciate it if you would refer to the following papers:

*W. van Aarle, W. J. Palenstijn, J. Cant, E. Janssens, F. Bleichrodt, A. Dabravolski, J. De Beenhouwer, K. J. Batenburg, and J. Sijbers, “Fast and Flexible X-ray Tomography Using the ASTRA Toolbox”, Optics Express, 24(22), 25129-25147, (2016), https://dx.doi.org/10.1364/OE.24.025129*

*W. van Aarle, W. J. Palenstijn, J. De Beenhouwer, T. Altantzis, S. Bals, K. J. Batenburg, and J. Sijbers, “The ASTRA Toolbox: A platform for advanced algorithm development in electron tomography”, Ultramicroscopy, 157, 35–47, (2015), https://dx.doi.org/10.1016/j.ultramic.2015.05.002*

Additionally, if you use parallel beam GPU code, we would appreciate it if you would refer to the following paper:

*W. J. Palenstijn, K J. Batenburg, and J. Sijbers, "Performance improvements for iterative electron tomography reconstruction using graphics processing units (GPUs)", Journal of Structural Biology, vol. 176, issue 2, pp. 250-253, 2011, https://dx.doi.org/10.1016/j.jsb.2011.07.017*

## License

The ASTRA Toolbox is open source under the GPLv3 license.

## Copyright

2010-2024, imec Vision Lab, University of Antwerp

2014-2024, CWI, Amsterdam

https://visielab.uantwerpen.be/ and https://www.cwi.nl/
