/*
 * Cayman Register documentation
 *
 * Copyright (C) 2011  Advanced Micro Devices, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
 * AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#ifndef _CAYMAN_REG_AUTO
#define _CAYMAN_REG_AUTO

enum {

    VGT_VTX_VECT_EJECT_REG                                = 0x000088b0,
	PRIM_COUNT_mask                                   = 0x3ff << 0,
	PRIM_COUNT_shift                                  = 0,
    VGT_LAST_COPY_STATE                                   = 0x000088c0,
	SRC_STATE_ID_mask                                 = 0x07 << 0,
	SRC_STATE_ID_shift                                = 0,
	DST_STATE_ID_mask                                 = 0x07 << 16,
	DST_STATE_ID_shift                                = 16,
    VGT_CACHE_INVALIDATION                                = 0x000088c4,
	CACHE_INVALIDATION_mask                           = 0x03 << 0,
	CACHE_INVALIDATION_shift                          = 0,
	    VC_ONLY                                       = 0x00,
	    TC_ONLY                                       = 0x01,
	    VC_AND_TC                                     = 0x02,
	VS_NO_EXTRA_BUFFER_bit                            = 1 << 5,
	AUTO_INVLD_EN_mask                                = 0x03 << 6,
	AUTO_INVLD_EN_shift                               = 6,
    VGT_GS_VERTEX_REUSE                                   = 0x000088d4,
	VERT_REUSE_mask                                   = 0x1f << 0,
	VERT_REUSE_shift                                  = 0,
    VGT_CNTL_STATUS                                       = 0x000088f0,
	VGT_OUT_INDX_BUSY_bit                             = 1 << 0,
	VGT_OUT_BUSY_bit                                  = 1 << 1,
	VGT_PT_BUSY_bit                                   = 1 << 2,
	VGT_TE_BUSY_bit                                   = 1 << 3,
	VGT_VR_BUSY_bit                                   = 1 << 4,
	VGT_PI_BUSY_bit                                   = 1 << 5,
	VGT_INVLD_BUSY_bit                                = 1 << 6,
	VGT_GS_BUSY_bit                                   = 1 << 7,
	VGT_HS_BUSY_bit                                   = 1 << 8,
	VGT_TE11_BUSY_bit                                 = 1 << 9,
	VGT_BUSY_bit                                      = 1 << 10,
    VGT_PRIMITIVE_TYPE                                    = 0x00008958,
	VGT_PRIMITIVE_TYPE__PRIM_TYPE_mask                = 0x3f << 0,
	VGT_PRIMITIVE_TYPE__PRIM_TYPE_shift               = 0,
	    DI_PT_NONE                                    = 0x00,
	    DI_PT_POINTLIST                               = 0x01,
	    DI_PT_LINELIST                                = 0x02,
	    DI_PT_LINESTRIP                               = 0x03,
	    DI_PT_TRILIST                                 = 0x04,
	    DI_PT_TRIFAN                                  = 0x05,
	    DI_PT_TRISTRIP                                = 0x06,
	    DI_PT_UNUSED_0                                = 0x07,
	    DI_PT_UNUSED_1                                = 0x08,
	    DI_PT_PATCH                                   = 0x09,
	    DI_PT_LINELIST_ADJ                            = 0x0a,
	    DI_PT_LINESTRIP_ADJ                           = 0x0b,
	    DI_PT_TRILIST_ADJ                             = 0x0c,
	    DI_PT_TRISTRIP_ADJ                            = 0x0d,
	    DI_PT_UNUSED_3                                = 0x0e,
	    DI_PT_UNUSED_4                                = 0x0f,
	    DI_PT_TRI_WITH_WFLAGS                         = 0x10,
	    DI_PT_RECTLIST                                = 0x11,
	    DI_PT_LINELOOP                                = 0x12,
	    DI_PT_QUADLIST                                = 0x13,
	    DI_PT_QUADSTRIP                               = 0x14,
	    DI_PT_POLYGON                                 = 0x15,
	    DI_PT_2D_COPY_RECT_LIST_V0                    = 0x16,
	    DI_PT_2D_COPY_RECT_LIST_V1                    = 0x17,
	    DI_PT_2D_COPY_RECT_LIST_V2                    = 0x18,
	    DI_PT_2D_COPY_RECT_LIST_V3                    = 0x19,
	    DI_PT_2D_FILL_RECT_LIST                       = 0x1a,
	    DI_PT_2D_LINE_STRIP                           = 0x1b,
	    DI_PT_2D_TRI_STRIP                            = 0x1c,
    VGT_INDEX_TYPE                                        = 0x0000895c,
	INDEX_TYPE_mask                                   = 0x03 << 0,
	INDEX_TYPE_shift                                  = 0,
	    DI_INDEX_SIZE_16_BIT                          = 0x00,
	    DI_INDEX_SIZE_32_BIT                          = 0x01,
    VGT_STRMOUT_BUFFER_FILLED_SIZE_0                      = 0x00008960,
    VGT_STRMOUT_BUFFER_FILLED_SIZE_1                      = 0x00008964,
    VGT_STRMOUT_BUFFER_FILLED_SIZE_2                      = 0x00008968,
    VGT_STRMOUT_BUFFER_FILLED_SIZE_3                      = 0x0000896c,
    VGT_NUM_INDICES                                       = 0x00008970,
    VGT_NUM_INSTANCES                                     = 0x00008974,
    VGT_SYS_CONFIG                                        = 0x0000898c,
	DUAL_CORE_EN_bit                                  = 1 << 0,
	MAX_LS_HS_THDGRP_mask                             = 0x3f << 1,
	MAX_LS_HS_THDGRP_shift                            = 1,
    PA_CL_CNTL_STATUS                                     = 0x00008a10,
	CL_BUSY_bit                                       = 1 << 31,
    PA_CL_ENHANCE                                         = 0x00008a14,
	CLIP_VTX_REORDER_ENA_bit                          = 1 << 0,
	NUM_CLIP_SEQ_mask                                 = 0x03 << 1,
	NUM_CLIP_SEQ_shift                                = 1,
	CLIPPED_PRIM_SEQ_STALL_bit                        = 1 << 3,
	VE_NAN_PROC_DISABLE_bit                           = 1 << 4,
    PA_SU_CNTL_STATUS                                     = 0x00008a50,
	SU_BUSY_bit                                       = 1 << 31,
    PA_SU_LINE_STIPPLE_VALUE                              = 0x00008a60,
	LINE_STIPPLE_VALUE_mask                           = 0xffffff << 0,
	LINE_STIPPLE_VALUE_shift                          = 0,
    PA_SC_LINE_STIPPLE_STATE                              = 0x00008b10,
	CURRENT_PTR_mask                                  = 0x0f << 0,
	CURRENT_PTR_shift                                 = 0,
	CURRENT_COUNT_mask                                = 0xff << 8,
	CURRENT_COUNT_shift                               = 8,
    SQ_CONFIG                                             = 0x00008c00,
	VC_ENABLE_bit                                     = 1 << 0,
	EXPORT_SRC_C_bit                                  = 1 << 1,
	GFX_PRIO_mask                                     = 0x03 << 2,
	GFX_PRIO_shift                                    = 2,
	CS1_PRIO_mask                                     = 0x03 << 4,
	CS1_PRIO_shift                                    = 4,
	CS2_PRIO_mask                                     = 0x03 << 6,
	CS2_PRIO_shift                                    = 6,
    SQ_GPR_RESOURCE_MGMT_1                                = 0x00008c04,
	SQ_GPR_RESOURCE_MGMT_1__NUM_PS_GPRS_mask          = 0xff << 0,
	SQ_GPR_RESOURCE_MGMT_1__NUM_PS_GPRS_shift         = 0,
	SQ_GPR_RESOURCE_MGMT_1__NUM_VS_GPRS_mask          = 0xff << 16,
	SQ_GPR_RESOURCE_MGMT_1__NUM_VS_GPRS_shift         = 16,
	NUM_CLAUSE_TEMP_GPRS_mask                         = 0x0f << 28,
	NUM_CLAUSE_TEMP_GPRS_shift                        = 28,
    SQ_GLOBAL_GPR_RESOURCE_MGMT_1                         = 0x00008c10,
	PS_GGPR_BASE_mask                                 = 0xff << 0,
	PS_GGPR_BASE_shift                                = 0,
	VS_GGPR_BASE_mask                                 = 0xff << 8,
	VS_GGPR_BASE_shift                                = 8,
	GS_GGPR_BASE_mask                                 = 0xff << 16,
	GS_GGPR_BASE_shift                                = 16,
	ES_GGPR_BASE_mask                                 = 0xff << 24,
	ES_GGPR_BASE_shift                                = 24,
    SQ_GLOBAL_GPR_RESOURCE_MGMT_2                         = 0x00008c14,
	HS_GGPR_BASE_mask                                 = 0xff << 0,
	HS_GGPR_BASE_shift                                = 0,
	LS_GGPR_BASE_mask                                 = 0xff << 8,
	LS_GGPR_BASE_shift                                = 8,
	CS_GGPR_BASE_mask                                 = 0xff << 16,
	CS_GGPR_BASE_shift                                = 16,
    SQ_ESGS_RING_BASE                                     = 0x00008c40,
    SQ_ESGS_RING_SIZE                                     = 0x00008c44,
    SQ_GSVS_RING_BASE                                     = 0x00008c48,
    SQ_GSVS_RING_SIZE                                     = 0x00008c4c,
    SQ_ESTMP_RING_BASE                                    = 0x00008c50,
    SQ_ESTMP_RING_SIZE                                    = 0x00008c54,
    SQ_GSTMP_RING_BASE                                    = 0x00008c58,
    SQ_GSTMP_RING_SIZE                                    = 0x00008c5c,
    SQ_VSTMP_RING_BASE                                    = 0x00008c60,
    SQ_VSTMP_RING_SIZE                                    = 0x00008c64,
    SQ_PSTMP_RING_BASE                                    = 0x00008c68,
    SQ_PSTMP_RING_SIZE                                    = 0x00008c6c,
    SQ_ALU_WORD1_OP3                                      = 0x00008dfc,
	SRC2_SEL_mask                                     = 0x1ff << 0,
	SRC2_SEL_shift                                    = 0,
	    SQ_ALU_SRC_LDS_OQ_A                           = 0xdb,
	    SQ_ALU_SRC_LDS_OQ_B                           = 0xdc,
	    SQ_ALU_SRC_LDS_OQ_A_POP                       = 0xdd,
	    SQ_ALU_SRC_LDS_OQ_B_POP                       = 0xde,
	    SQ_ALU_SRC_LDS_DIRECT_A                       = 0xdf,
	    SQ_ALU_SRC_LDS_DIRECT_B                       = 0xe0,
	    SQ_ALU_SRC_TIME_HI                            = 0xe3,
	    SQ_ALU_SRC_TIME_LO                            = 0xe4,
	    SQ_ALU_SRC_MASK_HI                            = 0xe5,
	    SQ_ALU_SRC_MASK_LO                            = 0xe6,
	    SQ_ALU_SRC_HW_WAVE_ID                         = 0xe7,
	    SQ_ALU_SRC_SIMD_ID                            = 0xe8,
	    SQ_ALU_SRC_SE_ID                              = 0xe9,
	    SQ_ALU_SRC_HW_THREADGRP_ID                    = 0xea,
	    SQ_ALU_SRC_WAVE_ID_IN_GRP                     = 0xeb,
	    SQ_ALU_SRC_NUM_THREADGRP_WAVES                = 0xec,
	    SQ_ALU_SRC_HW_ALU_ODD                         = 0xed,
	    SQ_ALU_SRC_LOOP_IDX                           = 0xee,
	    SQ_ALU_SRC_PARAM_BASE_ADDR                    = 0xf0,
	    SQ_ALU_SRC_NEW_PRIM_MASK                      = 0xf1,
	    SQ_ALU_SRC_PRIM_MASK_HI                       = 0xf2,
	    SQ_ALU_SRC_PRIM_MASK_LO                       = 0xf3,
	    SQ_ALU_SRC_1_DBL_L                            = 0xf4,
	    SQ_ALU_SRC_1_DBL_M                            = 0xf5,
	    SQ_ALU_SRC_0_5_DBL_L                          = 0xf6,
	    SQ_ALU_SRC_0_5_DBL_M                          = 0xf7,
	    SQ_ALU_SRC_0                                  = 0xf8,
	    SQ_ALU_SRC_1                                  = 0xf9,
	    SQ_ALU_SRC_1_INT                              = 0xfa,
	    SQ_ALU_SRC_M_1_INT                            = 0xfb,
	    SQ_ALU_SRC_0_5                                = 0xfc,
	    SQ_ALU_SRC_LITERAL                            = 0xfd,
	    SQ_ALU_SRC_PV                                 = 0xfe,
	    SQ_ALU_SRC_PS                                 = 0xff,
	SRC2_REL_bit                                      = 1 << 9,
	SRC2_CHAN_mask                                    = 0x03 << 10,
	SRC2_CHAN_shift                                   = 10,
	    SQ_CHAN_X                                     = 0x00,
	    SQ_CHAN_Y                                     = 0x01,
	    SQ_CHAN_Z                                     = 0x02,
	    SQ_CHAN_W                                     = 0x03,
	SRC2_NEG_bit                                      = 1 << 12,
	SQ_ALU_WORD1_OP3__ALU_INST_mask                   = 0x1f << 13,
	SQ_ALU_WORD1_OP3__ALU_INST_shift                  = 13,
	    SQ_OP3_INST_BFE_UINT                          = 0x04,
	    SQ_OP3_INST_BFE_INT                           = 0x05,
	    SQ_OP3_INST_BFI_INT                           = 0x06,
	    SQ_OP3_INST_FMA                               = 0x07,
	    SQ_OP3_INST_CNDNE_64                          = 0x09,
	    SQ_OP3_INST_FMA_64                            = 0x0a,
	    SQ_OP3_INST_LERP_UINT                         = 0x0b,
	    SQ_OP3_INST_BIT_ALIGN_INT                     = 0x0c,
	    SQ_OP3_INST_BYTE_ALIGN_INT                    = 0x0d,
	    SQ_OP3_INST_SAD_ACCUM_UINT                    = 0x0e,
	    SQ_OP3_INST_SAD_ACCUM_HI_UINT                 = 0x0f,
	    SQ_OP3_INST_MULADD_UINT24                     = 0x10,
	    SQ_OP3_INST_LDS_IDX_OP                        = 0x11,
	    SQ_OP3_INST_MULADD                            = 0x14,
	    SQ_OP3_INST_MULADD_M2                         = 0x15,
	    SQ_OP3_INST_MULADD_M4                         = 0x16,
	    SQ_OP3_INST_MULADD_D2                         = 0x17,
	    SQ_OP3_INST_MULADD_IEEE                       = 0x18,
	    SQ_OP3_INST_CNDE                              = 0x19,
	    SQ_OP3_INST_CNDGT                             = 0x1a,
	    SQ_OP3_INST_CNDGE                             = 0x1b,
	    SQ_OP3_INST_CNDE_INT                          = 0x1c,
	    SQ_OP3_INST_CNDGT_INT                         = 0x1d,
	    SQ_OP3_INST_CNDGE_INT                         = 0x1e,
	    SQ_OP3_INST_MUL_LIT                           = 0x1f,
    SQ_ALU_WORD1_LDS_DIRECT_LITERAL_LO                    = 0x00008dfc,
	OFFSET_A_mask                                     = 0x1fff << 0,
	OFFSET_A_shift                                    = 0,
	STRIDE_A_mask                                     = 0x7f << 13,
	STRIDE_A_shift                                    = 13,
	THREAD_REL_A_bit                                  = 1 << 22,
    SQ_TEX_WORD2                                          = 0x00008dfc,
	OFFSET_X_mask                                     = 0x1f << 0,
	OFFSET_X_shift                                    = 0,
	OFFSET_Y_mask                                     = 0x1f << 5,
	OFFSET_Y_shift                                    = 5,
	OFFSET_Z_mask                                     = 0x1f << 10,
	OFFSET_Z_shift                                    = 10,
	SAMPLER_ID_mask                                   = 0x1f << 15,
	SAMPLER_ID_shift                                  = 15,
	SQ_TEX_WORD2__SRC_SEL_X_mask                      = 0x07 << 20,
	SQ_TEX_WORD2__SRC_SEL_X_shift                     = 20,
	    SQ_SEL_X                                      = 0x00,
	    SQ_SEL_Y                                      = 0x01,
	    SQ_SEL_Z                                      = 0x02,
	    SQ_SEL_W                                      = 0x03,
	    SQ_SEL_0                                      = 0x04,
	    SQ_SEL_1                                      = 0x05,
	SQ_TEX_WORD2__SRC_SEL_Y_mask                      = 0x07 << 23,
	SQ_TEX_WORD2__SRC_SEL_Y_shift                     = 23,
/* 	    SQ_SEL_X                                      = 0x00, */
/* 	    SQ_SEL_Y                                      = 0x01, */
/* 	    SQ_SEL_Z                                      = 0x02, */
/* 	    SQ_SEL_W                                      = 0x03, */
/* 	    SQ_SEL_0                                      = 0x04, */
/* 	    SQ_SEL_1                                      = 0x05, */
	SRC_SEL_Z_mask                                    = 0x07 << 26,
	SRC_SEL_Z_shift                                   = 26,
/* 	    SQ_SEL_X                                      = 0x00, */
/* 	    SQ_SEL_Y                                      = 0x01, */
/* 	    SQ_SEL_Z                                      = 0x02, */
/* 	    SQ_SEL_W                                      = 0x03, */
/* 	    SQ_SEL_0                                      = 0x04, */
/* 	    SQ_SEL_1                                      = 0x05, */
	SRC_SEL_W_mask                                    = 0x07 << 29,
	SRC_SEL_W_shift                                   = 29,
/* 	    SQ_SEL_X                                      = 0x00, */
/* 	    SQ_SEL_Y                                      = 0x01, */
/* 	    SQ_SEL_Z                                      = 0x02, */
/* 	    SQ_SEL_W                                      = 0x03, */
/* 	    SQ_SEL_0                                      = 0x04, */
/* 	    SQ_SEL_1                                      = 0x05, */
    SQ_CF_ALLOC_EXPORT_WORD1                              = 0x00008dfc,
	BURST_COUNT_mask                                  = 0x0f << 16,
	BURST_COUNT_shift                                 = 16,
	VALID_PIXEL_MODE_bit                              = 1 << 20,
	SQ_CF_ALLOC_EXPORT_WORD1__CF_INST_mask            = 0xff << 22,
	SQ_CF_ALLOC_EXPORT_WORD1__CF_INST_shift           = 22,
	    SQ_CF_INST_MEM_STREAM0_BUF0                   = 0x40,
	    SQ_CF_INST_MEM_STREAM0_BUF1                   = 0x41,
	    SQ_CF_INST_MEM_STREAM0_BUF2                   = 0x42,
	    SQ_CF_INST_MEM_STREAM0_BUF3                   = 0x43,
	    SQ_CF_INST_MEM_STREAM1_BUF0                   = 0x44,
	    SQ_CF_INST_MEM_STREAM1_BUF1                   = 0x45,
	    SQ_CF_INST_MEM_STREAM1_BUF2                   = 0x46,
	    SQ_CF_INST_MEM_STREAM1_BUF3                   = 0x47,
	    SQ_CF_INST_MEM_STREAM2_BUF0                   = 0x48,
	    SQ_CF_INST_MEM_STREAM2_BUF1                   = 0x49,
	    SQ_CF_INST_MEM_STREAM2_BUF2                   = 0x4a,
	    SQ_CF_INST_MEM_STREAM2_BUF3                   = 0x4b,
	    SQ_CF_INST_MEM_STREAM3_BUF0                   = 0x4c,
	    SQ_CF_INST_MEM_STREAM3_BUF1                   = 0x4d,
	    SQ_CF_INST_MEM_STREAM3_BUF2                   = 0x4e,
	    SQ_CF_INST_MEM_STREAM3_BUF3                   = 0x4f,
	    SQ_CF_INST_MEM_SCRATCH                        = 0x50,
	    SQ_CF_INST_MEM_RING                           = 0x52,
	    SQ_CF_INST_EXPORT                             = 0x53,
	    SQ_CF_INST_EXPORT_DONE                        = 0x54,
	    SQ_CF_INST_MEM_EXPORT                         = 0x55,
	    SQ_CF_INST_MEM_RAT                            = 0x56,
	    SQ_CF_INST_MEM_RAT_CACHELESS                  = 0x57,
	    SQ_CF_INST_MEM_RING1                          = 0x58,
	    SQ_CF_INST_MEM_RING2                          = 0x59,
	    SQ_CF_INST_MEM_RING3                          = 0x5a,
	    SQ_CF_INST_MEM_EXPORT_COMBINED                = 0x5b,
	    SQ_CF_INST_MEM_RAT_COMBINED_CACHELESS         = 0x5c,
	    SQ_CF_INST_MEM_RAT_COMBINED                   = 0x5d,
	    SQ_CF_INST_EXPORT_DONE_END_IS_NEXT            = 0x5e,
	MARK_bit                                          = 1 << 30,
	BARRIER_bit                                       = 1 << 31,
    SQ_CF_ALU_WORD1                                       = 0x00008dfc,
	KCACHE_MODE1_mask                                 = 0x03 << 0,
	KCACHE_MODE1_shift                                = 0,
	    SQ_CF_KCACHE_NOP                              = 0x00,
	    SQ_CF_KCACHE_LOCK_1                           = 0x01,
	    SQ_CF_KCACHE_LOCK_2                           = 0x02,
	    SQ_CF_KCACHE_LOCK_LOOP_INDEX                  = 0x03,
	KCACHE_ADDR0_mask                                 = 0xff << 2,
	KCACHE_ADDR0_shift                                = 2,
	KCACHE_ADDR1_mask                                 = 0xff << 10,
	KCACHE_ADDR1_shift                                = 10,
	SQ_CF_ALU_WORD1__COUNT_mask                       = 0x7f << 18,
	SQ_CF_ALU_WORD1__COUNT_shift                      = 18,
	SQ_CF_ALU_WORD1__ALT_CONST_bit                    = 1 << 25,
	SQ_CF_ALU_WORD1__CF_INST_mask                     = 0x0f << 26,
	SQ_CF_ALU_WORD1__CF_INST_shift                    = 26,
	    SQ_CF_INST_ALU                                = 0x08,
	    SQ_CF_INST_ALU_PUSH_BEFORE                    = 0x09,
	    SQ_CF_INST_ALU_POP_AFTER                      = 0x0a,
	    SQ_CF_INST_ALU_POP2_AFTER                     = 0x0b,
	    SQ_CF_INST_ALU_EXTENDED                       = 0x0c,
	    SQ_CF_INST_ALU_CONTINUE                       = 0x0d,
	    SQ_CF_INST_ALU_BREAK                          = 0x0e,
	    SQ_CF_INST_ALU_ELSE_AFTER                     = 0x0f,
	WHOLE_QUAD_MODE_bit                               = 1 << 30,
/* 	BARRIER_bit                                       = 1 << 31, */
    SQ_TEX_WORD1                                          = 0x00008dfc,
	SQ_TEX_WORD1__DST_GPR_mask                        = 0x7f << 0,
	SQ_TEX_WORD1__DST_GPR_shift                       = 0,
	SQ_TEX_WORD1__DST_REL_bit                         = 1 << 7,
	SQ_TEX_WORD1__DST_SEL_X_mask                      = 0x07 << 9,
	SQ_TEX_WORD1__DST_SEL_X_shift                     = 9,
/* 	    SQ_SEL_X                                      = 0x00, */
/* 	    SQ_SEL_Y                                      = 0x01, */
/* 	    SQ_SEL_Z                                      = 0x02, */
/* 	    SQ_SEL_W                                      = 0x03, */
/* 	    SQ_SEL_0                                      = 0x04, */
/* 	    SQ_SEL_1                                      = 0x05, */
	    SQ_SEL_MASK                                   = 0x07,
	SQ_TEX_WORD1__DST_SEL_Y_mask                      = 0x07 << 12,
	SQ_TEX_WORD1__DST_SEL_Y_shift                     = 12,
/* 	    SQ_SEL_X                                      = 0x00, */
/* 	    SQ_SEL_Y                                      = 0x01, */
/* 	    SQ_SEL_Z                                      = 0x02, */
/* 	    SQ_SEL_W                                      = 0x03, */
/* 	    SQ_SEL_0                                      = 0x04, */
/* 	    SQ_SEL_1                                      = 0x05, */
/* 	    SQ_SEL_MASK                                   = 0x07, */
	SQ_TEX_WORD1__DST_SEL_Z_mask                      = 0x07 << 15,
	SQ_TEX_WORD1__DST_SEL_Z_shift                     = 15,
/* 	    SQ_SEL_X                                      = 0x00, */
/* 	    SQ_SEL_Y                                      = 0x01, */
/* 	    SQ_SEL_Z                                      = 0x02, */
/* 	    SQ_SEL_W                                      = 0x03, */
/* 	    SQ_SEL_0                                      = 0x04, */
/* 	    SQ_SEL_1                                      = 0x05, */
/* 	    SQ_SEL_MASK                                   = 0x07, */
	SQ_TEX_WORD1__DST_SEL_W_mask                      = 0x07 << 18,
	SQ_TEX_WORD1__DST_SEL_W_shift                     = 18,
/* 	    SQ_SEL_X                                      = 0x00, */
/* 	    SQ_SEL_Y                                      = 0x01, */
/* 	    SQ_SEL_Z                                      = 0x02, */
/* 	    SQ_SEL_W                                      = 0x03, */
/* 	    SQ_SEL_0                                      = 0x04, */
/* 	    SQ_SEL_1                                      = 0x05, */
/* 	    SQ_SEL_MASK                                   = 0x07, */
	SQ_TEX_WORD1__LOD_BIAS_mask                       = 0x7f << 21,
	SQ_TEX_WORD1__LOD_BIAS_shift                      = 21,
	COORD_TYPE_X_bit                                  = 1 << 28,
	COORD_TYPE_Y_bit                                  = 1 << 29,
	COORD_TYPE_Z_bit                                  = 1 << 30,
	COORD_TYPE_W_bit                                  = 1 << 31,
    SQ_ALU_WORD1_OP2_MOVA                                 = 0x00008dfc,
	MOVA_DST_mask                                     = 0x7f << 21,
	MOVA_DST_shift                                    = 21,
	    SQ_ALU_MOVA_DST_AR_X                          = 0x00,
	    SQ_ALU_MOVA_DST_CF_PC                         = 0x01,
	    SQ_ALU_MOVA_DST_CF_IDX0                       = 0x02,
	    SQ_ALU_MOVA_DST_CF_IDX1                       = 0x03,
	    SQ_ALU_MOVA_DST_CLAUSE_GLOBAL_B0              = 0x04,
	    SQ_ALU_MOVA_DST_CLAUSE_GLOBAL_B1              = 0x05,
	    SQ_ALU_MOVA_DST_CLAUSE_GLOBAL_B2              = 0x06,
	    SQ_ALU_MOVA_DST_CLAUSE_GLOBAL_B3              = 0x07,
    SQ_VTX_WORD0                                          = 0x00008dfc,
	VTX_INST_mask                                     = 0x1f << 0,
	VTX_INST_shift                                    = 0,
	    SQ_VTX_INST_FETCH                             = 0x00,
	    SQ_VTX_INST_SEMANTIC                          = 0x01,
	    SQ_VTX_INST_GET_BUFFER_RESINFO                = 0x0e,
	FETCH_TYPE_mask                                   = 0x03 << 5,
	FETCH_TYPE_shift                                  = 5,
	    SQ_VTX_FETCH_VERTEX_DATA                      = 0x00,
	    SQ_VTX_FETCH_INSTANCE_DATA                    = 0x01,
	    SQ_VTX_FETCH_NO_INDEX_OFFSET                  = 0x02,
	FETCH_WHOLE_QUAD_bit                              = 1 << 7,
	BUFFER_ID_mask                                    = 0xff << 8,
	BUFFER_ID_shift                                   = 8,
	SQ_VTX_WORD0__SRC_GPR_mask                        = 0x7f << 16,
	SQ_VTX_WORD0__SRC_GPR_shift                       = 16,
	SRC_REL_bit                                       = 1 << 23,
	SQ_VTX_WORD0__SRC_SEL_X_mask                      = 0x03 << 24,
	SQ_VTX_WORD0__SRC_SEL_X_shift                     = 24,
/* 	    SQ_SEL_X                                      = 0x00, */
/* 	    SQ_SEL_Y                                      = 0x01, */
/* 	    SQ_SEL_Z                                      = 0x02, */
/* 	    SQ_SEL_W                                      = 0x03, */
	SQ_VTX_WORD0__SRC_SEL_Y_mask                      = 0x03 << 26,
	SQ_VTX_WORD0__SRC_SEL_Y_shift                     = 26,
/* 	    SQ_SEL_X                                      = 0x00, */
/* 	    SQ_SEL_Y                                      = 0x01, */
/* 	    SQ_SEL_Z                                      = 0x02, */
/* 	    SQ_SEL_W                                      = 0x03, */
	STRUCTURED_READ_mask                              = 0x03 << 28,
	STRUCTURED_READ_shift                             = 28,
	    SQ_VTX_STRU_READ_OFF                          = 0x00,
	    SQ_VTX_STRU_READ_GPR_OFFSET                   = 0x01,
	    SQ_VTX_STRU_READ_INST_OFFSET                  = 0x02,
	LDS_REQ_bit                                       = 1 << 30,
	COALESCED_READ_bit                                = 1 << 31,
    SQ_CF_ALLOC_EXPORT_WORD1_SWIZ                         = 0x00008dfc,
	SEL_X_mask                                        = 0x07 << 0,
	SEL_X_shift                                       = 0,
/* 	    SQ_SEL_X                                      = 0x00, */
/* 	    SQ_SEL_Y                                      = 0x01, */
/* 	    SQ_SEL_Z                                      = 0x02, */
/* 	    SQ_SEL_W                                      = 0x03, */
/* 	    SQ_SEL_0                                      = 0x04, */
/* 	    SQ_SEL_1                                      = 0x05, */
/* 	    SQ_SEL_MASK                                   = 0x07, */
	SEL_Y_mask                                        = 0x07 << 3,
	SEL_Y_shift                                       = 3,
/* 	    SQ_SEL_X                                      = 0x00, */
/* 	    SQ_SEL_Y                                      = 0x01, */
/* 	    SQ_SEL_Z                                      = 0x02, */
/* 	    SQ_SEL_W                                      = 0x03, */
/* 	    SQ_SEL_0                                      = 0x04, */
/* 	    SQ_SEL_1                                      = 0x05, */
/* 	    SQ_SEL_MASK                                   = 0x07, */
	SEL_Z_mask                                        = 0x07 << 6,
	SEL_Z_shift                                       = 6,
/* 	    SQ_SEL_X                                      = 0x00, */
/* 	    SQ_SEL_Y                                      = 0x01, */
/* 	    SQ_SEL_Z                                      = 0x02, */
/* 	    SQ_SEL_W                                      = 0x03, */
/* 	    SQ_SEL_0                                      = 0x04, */
/* 	    SQ_SEL_1                                      = 0x05, */
/* 	    SQ_SEL_MASK                                   = 0x07, */
	SEL_W_mask                                        = 0x07 << 9,
	SEL_W_shift                                       = 9,
/* 	    SQ_SEL_X                                      = 0x00, */
/* 	    SQ_SEL_Y                                      = 0x01, */
/* 	    SQ_SEL_Z                                      = 0x02, */
/* 	    SQ_SEL_W                                      = 0x03, */
/* 	    SQ_SEL_0                                      = 0x04, */
/* 	    SQ_SEL_1                                      = 0x05, */
/* 	    SQ_SEL_MASK                                   = 0x07, */
    SQ_MEM_RD_WORD0                                       = 0x00008dfc,
	MEM_INST_mask                                     = 0x1f << 0,
	MEM_INST_shift                                    = 0,
	    SQ_MEM_INST_MEM                               = 0x02,
	SQ_MEM_RD_WORD0__ELEM_SIZE_mask                   = 0x03 << 5,
	SQ_MEM_RD_WORD0__ELEM_SIZE_shift                  = 5,
/* 	FETCH_WHOLE_QUAD_bit                              = 1 << 7, */
	MEM_OP_mask                                       = 0x07 << 8,
	MEM_OP_shift                                      = 8,
	    SQ_MEM_OP_RD_SCRATCH                          = 0x00,
	    SQ_MEM_OP_RD_SCATTER                          = 0x02,
	    SQ_MEM_OP_GDS                                 = 0x04,
	    SQ_MEM_OP_TF_WRITE                            = 0x05,
	SQ_MEM_RD_WORD0__UNCACHED_bit                     = 1 << 11,
	INDEXED_bit                                       = 1 << 12,
	SQ_MEM_RD_WORD0__SRC_SEL_Y_mask                   = 0x03 << 13,
	SQ_MEM_RD_WORD0__SRC_SEL_Y_shift                  = 13,
/* 	    SQ_SEL_X                                      = 0x00, */
/* 	    SQ_SEL_Y                                      = 0x01, */
/* 	    SQ_SEL_Z                                      = 0x02, */
/* 	    SQ_SEL_W                                      = 0x03, */
	SQ_MEM_RD_WORD0__SRC_GPR_mask                     = 0x7f << 16,
	SQ_MEM_RD_WORD0__SRC_GPR_shift                    = 16,
/* 	SRC_REL_bit                                       = 1 << 23, */
	SQ_MEM_RD_WORD0__SRC_SEL_X_mask                   = 0x03 << 24,
	SQ_MEM_RD_WORD0__SRC_SEL_X_shift                  = 24,
/* 	    SQ_SEL_X                                      = 0x00, */
/* 	    SQ_SEL_Y                                      = 0x01, */
/* 	    SQ_SEL_Z                                      = 0x02, */
/* 	    SQ_SEL_W                                      = 0x03, */
	BURST_CNT_mask                                    = 0x0f << 26,
	BURST_CNT_shift                                   = 26,
/* 	LDS_REQ_bit                                       = 1 << 30, */
/* 	COALESCED_READ_bit                                = 1 << 31, */
    SQ_ALU_WORD1                                          = 0x00008dfc,
	SQ_ALU_WORD1__ENCODING_mask                       = 0x07 << 15,
	SQ_ALU_WORD1__ENCODING_shift                      = 15,
	BANK_SWIZZLE_mask                                 = 0x07 << 18,
	BANK_SWIZZLE_shift                                = 18,
	    SQ_ALU_VEC_012                                = 0x00,
	    SQ_ALU_VEC_021                                = 0x01,
	    SQ_ALU_VEC_120                                = 0x02,
	    SQ_ALU_VEC_102                                = 0x03,
	    SQ_ALU_VEC_201                                = 0x04,
	    SQ_ALU_VEC_210                                = 0x05,
	SQ_ALU_WORD1__DST_GPR_mask                        = 0x7f << 21,
	SQ_ALU_WORD1__DST_GPR_shift                       = 21,
	SQ_ALU_WORD1__DST_REL_bit                         = 1 << 28,
	DST_CHAN_mask                                     = 0x03 << 29,
	DST_CHAN_shift                                    = 29,
	    CHAN_X                                        = 0x00,
	    CHAN_Y                                        = 0x01,
	    CHAN_Z                                        = 0x02,
	    CHAN_W                                        = 0x03,
	SQ_ALU_WORD1__CLAMP_bit                           = 1 << 31,
    SQ_CF_ALU_WORD0_EXT                                   = 0x00008dfc,
	KCACHE_BANK_INDEX_MODE0_mask                      = 0x03 << 4,
	KCACHE_BANK_INDEX_MODE0_shift                     = 4,
	    SQ_CF_INDEX_NONE                              = 0x00,
	    SQ_CF_INDEX_0                                 = 0x01,
	    SQ_CF_INDEX_1                                 = 0x02,
	    SQ_CF_INVALID                                 = 0x03,
	KCACHE_BANK_INDEX_MODE1_mask                      = 0x03 << 6,
	KCACHE_BANK_INDEX_MODE1_shift                     = 6,
/* 	    SQ_CF_INDEX_NONE                              = 0x00, */
/* 	    SQ_CF_INDEX_0                                 = 0x01, */
/* 	    SQ_CF_INDEX_1                                 = 0x02, */
/* 	    SQ_CF_INVALID                                 = 0x03, */
	KCACHE_BANK_INDEX_MODE2_mask                      = 0x03 << 8,
	KCACHE_BANK_INDEX_MODE2_shift                     = 8,
/* 	    SQ_CF_INDEX_NONE                              = 0x00, */
/* 	    SQ_CF_INDEX_0                                 = 0x01, */
/* 	    SQ_CF_INDEX_1                                 = 0x02, */
/* 	    SQ_CF_INVALID                                 = 0x03, */
	KCACHE_BANK_INDEX_MODE3_mask                      = 0x03 << 10,
	KCACHE_BANK_INDEX_MODE3_shift                     = 10,
/* 	    SQ_CF_INDEX_NONE                              = 0x00, */
/* 	    SQ_CF_INDEX_0                                 = 0x01, */
/* 	    SQ_CF_INDEX_1                                 = 0x02, */
/* 	    SQ_CF_INVALID                                 = 0x03, */
	KCACHE_BANK2_mask                                 = 0x0f << 22,
	KCACHE_BANK2_shift                                = 22,
	KCACHE_BANK3_mask                                 = 0x0f << 26,
	KCACHE_BANK3_shift                                = 26,
	KCACHE_MODE2_mask                                 = 0x03 << 30,
	KCACHE_MODE2_shift                                = 30,
/* 	    SQ_CF_KCACHE_NOP                              = 0x00, */
/* 	    SQ_CF_KCACHE_LOCK_1                           = 0x01, */
/* 	    SQ_CF_KCACHE_LOCK_2                           = 0x02, */
/* 	    SQ_CF_KCACHE_LOCK_LOOP_INDEX                  = 0x03, */
    SQ_ALU_WORD0_LDS_IDX_OP                               = 0x00008dfc,
	SRC0_SEL_mask                                     = 0x1ff << 0,
	SRC0_SEL_shift                                    = 0,
/* 	    SQ_ALU_SRC_LDS_OQ_A                           = 0xdb, */
/* 	    SQ_ALU_SRC_LDS_OQ_B                           = 0xdc, */
/* 	    SQ_ALU_SRC_LDS_OQ_A_POP                       = 0xdd, */
/* 	    SQ_ALU_SRC_LDS_OQ_B_POP                       = 0xde, */
/* 	    SQ_ALU_SRC_LDS_DIRECT_A                       = 0xdf, */
/* 	    SQ_ALU_SRC_LDS_DIRECT_B                       = 0xe0, */
/* 	    SQ_ALU_SRC_TIME_HI                            = 0xe3, */
/* 	    SQ_ALU_SRC_TIME_LO                            = 0xe4, */
/* 	    SQ_ALU_SRC_MASK_HI                            = 0xe5, */
/* 	    SQ_ALU_SRC_MASK_LO                            = 0xe6, */
/* 	    SQ_ALU_SRC_HW_WAVE_ID                         = 0xe7, */
/* 	    SQ_ALU_SRC_SIMD_ID                            = 0xe8, */
/* 	    SQ_ALU_SRC_SE_ID                              = 0xe9, */
/* 	    SQ_ALU_SRC_HW_THREADGRP_ID                    = 0xea, */
/* 	    SQ_ALU_SRC_WAVE_ID_IN_GRP                     = 0xeb, */
/* 	    SQ_ALU_SRC_NUM_THREADGRP_WAVES                = 0xec, */
/* 	    SQ_ALU_SRC_HW_ALU_ODD                         = 0xed, */
/* 	    SQ_ALU_SRC_LOOP_IDX                           = 0xee, */
/* 	    SQ_ALU_SRC_PARAM_BASE_ADDR                    = 0xf0, */
/* 	    SQ_ALU_SRC_NEW_PRIM_MASK                      = 0xf1, */
/* 	    SQ_ALU_SRC_PRIM_MASK_HI                       = 0xf2, */
/* 	    SQ_ALU_SRC_PRIM_MASK_LO                       = 0xf3, */
/* 	    SQ_ALU_SRC_1_DBL_L                            = 0xf4, */
/* 	    SQ_ALU_SRC_1_DBL_M                            = 0xf5, */
/* 	    SQ_ALU_SRC_0_5_DBL_L                          = 0xf6, */
/* 	    SQ_ALU_SRC_0_5_DBL_M                          = 0xf7, */
/* 	    SQ_ALU_SRC_0                                  = 0xf8, */
/* 	    SQ_ALU_SRC_1                                  = 0xf9, */
/* 	    SQ_ALU_SRC_1_INT                              = 0xfa, */
/* 	    SQ_ALU_SRC_M_1_INT                            = 0xfb, */
/* 	    SQ_ALU_SRC_0_5                                = 0xfc, */
/* 	    SQ_ALU_SRC_LITERAL                            = 0xfd, */
/* 	    SQ_ALU_SRC_PV                                 = 0xfe, */
/* 	    SQ_ALU_SRC_PS                                 = 0xff, */
	SRC0_REL_bit                                      = 1 << 9,
	SRC0_CHAN_mask                                    = 0x03 << 10,
	SRC0_CHAN_shift                                   = 10,
/* 	    SQ_CHAN_X                                     = 0x00, */
/* 	    SQ_CHAN_Y                                     = 0x01, */
/* 	    SQ_CHAN_Z                                     = 0x02, */
/* 	    SQ_CHAN_W                                     = 0x03, */
	IDX_OFFSET_4_bit                                  = 1 << 12,
	SRC1_SEL_mask                                     = 0x1ff << 13,
	SRC1_SEL_shift                                    = 13,
/* 	    SQ_ALU_SRC_LDS_OQ_A                           = 0xdb, */
/* 	    SQ_ALU_SRC_LDS_OQ_B                           = 0xdc, */
/* 	    SQ_ALU_SRC_LDS_OQ_A_POP                       = 0xdd, */
/* 	    SQ_ALU_SRC_LDS_OQ_B_POP                       = 0xde, */
/* 	    SQ_ALU_SRC_LDS_DIRECT_A                       = 0xdf, */
/* 	    SQ_ALU_SRC_LDS_DIRECT_B                       = 0xe0, */
/* 	    SQ_ALU_SRC_TIME_HI                            = 0xe3, */
/* 	    SQ_ALU_SRC_TIME_LO                            = 0xe4, */
/* 	    SQ_ALU_SRC_MASK_HI                            = 0xe5, */
/* 	    SQ_ALU_SRC_MASK_LO                            = 0xe6, */
/* 	    SQ_ALU_SRC_HW_WAVE_ID                         = 0xe7, */
/* 	    SQ_ALU_SRC_SIMD_ID                            = 0xe8, */
/* 	    SQ_ALU_SRC_SE_ID                              = 0xe9, */
/* 	    SQ_ALU_SRC_HW_THREADGRP_ID                    = 0xea, */
/* 	    SQ_ALU_SRC_WAVE_ID_IN_GRP                     = 0xeb, */
/* 	    SQ_ALU_SRC_NUM_THREADGRP_WAVES                = 0xec, */
/* 	    SQ_ALU_SRC_HW_ALU_ODD                         = 0xed, */
/* 	    SQ_ALU_SRC_LOOP_IDX                           = 0xee, */
/* 	    SQ_ALU_SRC_PARAM_BASE_ADDR                    = 0xf0, */
/* 	    SQ_ALU_SRC_NEW_PRIM_MASK                      = 0xf1, */
/* 	    SQ_ALU_SRC_PRIM_MASK_HI                       = 0xf2, */
/* 	    SQ_ALU_SRC_PRIM_MASK_LO                       = 0xf3, */
/* 	    SQ_ALU_SRC_1_DBL_L                            = 0xf4, */
/* 	    SQ_ALU_SRC_1_DBL_M                            = 0xf5, */
/* 	    SQ_ALU_SRC_0_5_DBL_L                          = 0xf6, */
/* 	    SQ_ALU_SRC_0_5_DBL_M                          = 0xf7, */
/* 	    SQ_ALU_SRC_0                                  = 0xf8, */
/* 	    SQ_ALU_SRC_1                                  = 0xf9, */
/* 	    SQ_ALU_SRC_1_INT                              = 0xfa, */
/* 	    SQ_ALU_SRC_M_1_INT                            = 0xfb, */
/* 	    SQ_ALU_SRC_0_5                                = 0xfc, */
/* 	    SQ_ALU_SRC_LITERAL                            = 0xfd, */
/* 	    SQ_ALU_SRC_PV                                 = 0xfe, */
/* 	    SQ_ALU_SRC_PS                                 = 0xff, */
	SRC1_REL_bit                                      = 1 << 22,
	SRC1_CHAN_mask                                    = 0x03 << 23,
	SRC1_CHAN_shift                                   = 23,
/* 	    SQ_CHAN_X                                     = 0x00, */
/* 	    SQ_CHAN_Y                                     = 0x01, */
/* 	    SQ_CHAN_Z                                     = 0x02, */
/* 	    SQ_CHAN_W                                     = 0x03, */
	IDX_OFFSET_5_bit                                  = 1 << 25,
	INDEX_MODE_mask                                   = 0x07 << 26,
	INDEX_MODE_shift                                  = 26,
	    SQ_INDEX_AR_X                                 = 0x00,
	    SQ_INDEX_LOOP                                 = 0x04,
	    SQ_INDEX_GLOBAL                               = 0x05,
	    SQ_INDEX_GLOBAL_AR_X                          = 0x06,
	PRED_SEL_mask                                     = 0x03 << 29,
	PRED_SEL_shift                                    = 29,
	    SQ_PRED_SEL_OFF                               = 0x00,
	    SQ_PRED_SEL_ZERO                              = 0x02,
	    SQ_PRED_SEL_ONE                               = 0x03,
	LAST_bit                                          = 1 << 31,
    SQ_MEM_GDS_WORD2                                      = 0x00008dfc,
	SQ_MEM_GDS_WORD2__DST_SEL_X_mask                  = 0x07 << 0,
	SQ_MEM_GDS_WORD2__DST_SEL_X_shift                 = 0,
/* 	    SQ_SEL_X                                      = 0x00, */
/* 	    SQ_SEL_Y                                      = 0x01, */
/* 	    SQ_SEL_Z                                      = 0x02, */
/* 	    SQ_SEL_W                                      = 0x03, */
/* 	    SQ_SEL_0                                      = 0x04, */
/* 	    SQ_SEL_1                                      = 0x05, */
/* 	    SQ_SEL_MASK                                   = 0x07, */
	SQ_MEM_GDS_WORD2__DST_SEL_Y_mask                  = 0x07 << 3,
	SQ_MEM_GDS_WORD2__DST_SEL_Y_shift                 = 3,
/* 	    SQ_SEL_X                                      = 0x00, */
/* 	    SQ_SEL_Y                                      = 0x01, */
/* 	    SQ_SEL_Z                                      = 0x02, */
/* 	    SQ_SEL_W                                      = 0x03, */
/* 	    SQ_SEL_0                                      = 0x04, */
/* 	    SQ_SEL_1                                      = 0x05, */
/* 	    SQ_SEL_MASK                                   = 0x07, */
	SQ_MEM_GDS_WORD2__DST_SEL_Z_mask                  = 0x07 << 6,
	SQ_MEM_GDS_WORD2__DST_SEL_Z_shift                 = 6,
/* 	    SQ_SEL_X                                      = 0x00, */
/* 	    SQ_SEL_Y                                      = 0x01, */
/* 	    SQ_SEL_Z                                      = 0x02, */
/* 	    SQ_SEL_W                                      = 0x03, */
/* 	    SQ_SEL_0                                      = 0x04, */
/* 	    SQ_SEL_1                                      = 0x05, */
/* 	    SQ_SEL_MASK                                   = 0x07, */
	SQ_MEM_GDS_WORD2__DST_SEL_W_mask                  = 0x07 << 9,
	SQ_MEM_GDS_WORD2__DST_SEL_W_shift                 = 9,
/* 	    SQ_SEL_X                                      = 0x00, */
/* 	    SQ_SEL_Y                                      = 0x01, */
/* 	    SQ_SEL_Z                                      = 0x02, */
/* 	    SQ_SEL_W                                      = 0x03, */
/* 	    SQ_SEL_0                                      = 0x04, */
/* 	    SQ_SEL_1                                      = 0x05, */
/* 	    SQ_SEL_MASK                                   = 0x07, */
    SQ_CF_ALLOC_EXPORT_WORD0_RAT                          = 0x00008dfc,
	RAT_ID_mask                                       = 0x0f << 0,
	RAT_ID_shift                                      = 0,
	RAT_INST_mask                                     = 0x3f << 4,
	RAT_INST_shift                                    = 4,
	    SQ_EXPORT_RAT_INST_NOP                        = 0x00,
	    SQ_EXPORT_RAT_INST_STORE_TYPED                = 0x01,
	    SQ_EXPORT_RAT_INST_STORE_RAW                  = 0x02,
	    SQ_EXPORT_RAT_INST_STORE_RAW_FDENORM          = 0x03,
	    SQ_EXPORT_RAT_INST_CMPXCHG_INT                = 0x04,
	    SQ_EXPORT_RAT_INST_CMPXCHG_FLT                = 0x05,
	    SQ_EXPORT_RAT_INST_CMPXCHG_FDENORM            = 0x06,
	    SQ_EXPORT_RAT_INST_ADD                        = 0x07,
	    SQ_EXPORT_RAT_INST_SUB                        = 0x08,
	    SQ_EXPORT_RAT_INST_RSUB                       = 0x09,
	    SQ_EXPORT_RAT_INST_MIN_INT                    = 0x0a,
	    SQ_EXPORT_RAT_INST_MIN_UINT                   = 0x0b,
	    SQ_EXPORT_RAT_INST_MAX_INT                    = 0x0c,
	    SQ_EXPORT_RAT_INST_MAX_UINT                   = 0x0d,
	    SQ_EXPORT_RAT_INST_AND                        = 0x0e,
	    SQ_EXPORT_RAT_INST_OR                         = 0x0f,
	    SQ_EXPORT_RAT_INST_XOR                        = 0x10,
	    SQ_EXPORT_RAT_INST_MSKOR                      = 0x11,
	    SQ_EXPORT_RAT_INST_INC_UINT                   = 0x12,
	    SQ_EXPORT_RAT_INST_DEC_UINT                   = 0x13,
	    SQ_EXPORT_RAT_INST_NOP_RTN                    = 0x20,
	    SQ_EXPORT_RAT_INST_XCHG_RTN                   = 0x22,
	    SQ_EXPORT_RAT_INST_XCHG_FDENORM_RTN           = 0x23,
	    SQ_EXPORT_RAT_INST_CMPXCHG_INT_RTN            = 0x24,
	    SQ_EXPORT_RAT_INST_CMPXCHG_FLT_RTN            = 0x25,
	    SQ_EXPORT_RAT_INST_CMPXCHG_FDENORM_RTN        = 0x26,
	    SQ_EXPORT_RAT_INST_ADD_RTN                    = 0x27,
	    SQ_EXPORT_RAT_INST_SUB_RTN                    = 0x28,
	    SQ_EXPORT_RAT_INST_RSUB_RTN                   = 0x29,
	    SQ_EXPORT_RAT_INST_MIN_INT_RTN                = 0x2a,
	    SQ_EXPORT_RAT_INST_MIN_UINT_RTN               = 0x2b,
	    SQ_EXPORT_RAT_INST_MAX_INT_RTN                = 0x2c,
	    SQ_EXPORT_RAT_INST_MAX_UINT_RTN               = 0x2d,
	    SQ_EXPORT_RAT_INST_AND_RTN                    = 0x2e,
	    SQ_EXPORT_RAT_INST_OR_RTN                     = 0x2f,
	    SQ_EXPORT_RAT_INST_XOR_RTN                    = 0x30,
	    SQ_EXPORT_RAT_INST_MSKOR_RTN                  = 0x31,
	    SQ_EXPORT_RAT_INST_INC_UINT_RTN               = 0x32,
	    SQ_EXPORT_RAT_INST_DEC_UINT_RTN               = 0x33,
	RAT_INDEX_MODE_mask                               = 0x03 << 11,
	RAT_INDEX_MODE_shift                              = 11,
/* 	    SQ_CF_INDEX_NONE                              = 0x00, */
/* 	    SQ_CF_INDEX_0                                 = 0x01, */
/* 	    SQ_CF_INDEX_1                                 = 0x02, */
/* 	    SQ_CF_INVALID                                 = 0x03, */
	SQ_CF_ALLOC_EXPORT_WORD0_RAT__TYPE_mask           = 0x03 << 13,
	SQ_CF_ALLOC_EXPORT_WORD0_RAT__TYPE_shift          = 13,
	    SQ_EXPORT_PIXEL                               = 0x00,
	    SQ_EXPORT_POS                                 = 0x01,
	    SQ_EXPORT_PARAM                               = 0x02,
	    X_UNUSED_FOR_SX_EXPORTS                       = 0x03,
	RW_GPR_mask                                       = 0x7f << 15,
	RW_GPR_shift                                      = 15,
	RW_REL_bit                                        = 1 << 22,
	INDEX_GPR_mask                                    = 0x7f << 23,
	INDEX_GPR_shift                                   = 23,
	SQ_CF_ALLOC_EXPORT_WORD0_RAT__ELEM_SIZE_mask      = 0x03 << 30,
	SQ_CF_ALLOC_EXPORT_WORD0_RAT__ELEM_SIZE_shift     = 30,
    SQ_CF_ALU_WORD0                                       = 0x00008dfc,
	SQ_CF_ALU_WORD0__ADDR_mask                        = 0x3fffff << 0,
	SQ_CF_ALU_WORD0__ADDR_shift                       = 0,
	KCACHE_BANK0_mask                                 = 0x0f << 22,
	KCACHE_BANK0_shift                                = 22,
	KCACHE_BANK1_mask                                 = 0x0f << 26,
	KCACHE_BANK1_shift                                = 26,
	KCACHE_MODE0_mask                                 = 0x03 << 30,
	KCACHE_MODE0_shift                                = 30,
/* 	    SQ_CF_KCACHE_NOP                              = 0x00, */
/* 	    SQ_CF_KCACHE_LOCK_1                           = 0x01, */
/* 	    SQ_CF_KCACHE_LOCK_2                           = 0x02, */
/* 	    SQ_CF_KCACHE_LOCK_LOOP_INDEX                  = 0x03, */
    SQ_MEM_GDS_WORD1                                      = 0x00008dfc,
	SQ_MEM_GDS_WORD1__DST_GPR_mask                    = 0x7f << 0,
	SQ_MEM_GDS_WORD1__DST_GPR_shift                   = 0,
	DST_REL_MODE_mask                                 = 0x03 << 7,
	DST_REL_MODE_shift                                = 7,
	    SQ_REL_NONE                                   = 0x00,
	    SQ_REL_LOOP                                   = 0x01,
	    SQ_REL_GLOBAL                                 = 0x02,
	GDS_OP_mask                                       = 0x3f << 9,
	GDS_OP_shift                                      = 9,
	    SQ_DS_INST_ADD                                = 0x00,
	    SQ_DS_INST_SUB                                = 0x01,
	    SQ_DS_INST_RSUB                               = 0x02,
	    SQ_DS_INST_INC                                = 0x03,
	    SQ_DS_INST_DEC                                = 0x04,
	    SQ_DS_INST_MIN_INT                            = 0x05,
	    SQ_DS_INST_MAX_INT                            = 0x06,
	    SQ_DS_INST_MIN_UINT                           = 0x07,
	    SQ_DS_INST_MAX_UINT                           = 0x08,
	    SQ_DS_INST_AND                                = 0x09,
	    SQ_DS_INST_OR                                 = 0x0a,
	    SQ_DS_INST_XOR                                = 0x0b,
	    SQ_DS_INST_MSKOR                              = 0x0c,
	    SQ_DS_INST_WRITE                              = 0x0d,
	    SQ_DS_INST_WRITE_REL                          = 0x0e,
	    SQ_DS_INST_WRITE2                             = 0x0f,
	    SQ_DS_INST_CMP_STORE                          = 0x10,
	    SQ_DS_INST_CMP_STORE_SPF                      = 0x11,
	    SQ_DS_INST_BYTE_WRITE                         = 0x12,
	    SQ_DS_INST_SHORT_WRITE                        = 0x13,
	    SQ_DS_INST_ADD_RET                            = 0x20,
	    SQ_DS_INST_SUB_RET                            = 0x21,
	    SQ_DS_INST_RSUB_RET                           = 0x22,
	    SQ_DS_INST_INC_RET                            = 0x23,
	    SQ_DS_INST_DEC_RET                            = 0x24,
	    SQ_DS_INST_MIN_INT_RET                        = 0x25,
	    SQ_DS_INST_MAX_INT_RET                        = 0x26,
	    SQ_DS_INST_MIN_UINT_RET                       = 0x27,
	    SQ_DS_INST_MAX_UINT_RET                       = 0x28,
	    SQ_DS_INST_AND_RET                            = 0x29,
	    SQ_DS_INST_OR_RET                             = 0x2a,
	    SQ_DS_INST_XOR_RET                            = 0x2b,
	    SQ_DS_INST_MSKOR_RET                          = 0x2c,
	    SQ_DS_INST_XCHG_RET                           = 0x2d,
	    SQ_DS_INST_XCHG_REL_RET                       = 0x2e,
	    SQ_DS_INST_XCHG2_RET                          = 0x2f,
	    SQ_DS_INST_CMP_XCHG_RET                       = 0x30,
	    SQ_DS_INST_CMP_XCHG_SPF_RET                   = 0x31,
	    SQ_DS_INST_READ_RET                           = 0x32,
	    SQ_DS_INST_READ_REL_RET                       = 0x33,
	    SQ_DS_INST_READ2_RET                          = 0x34,
	    SQ_DS_INST_READWRITE_RET                      = 0x35,
	    SQ_DS_INST_BYTE_READ_RET                      = 0x36,
	    SQ_DS_INST_UBYTE_READ_RET                     = 0x37,
	    SQ_DS_INST_SHORT_READ_RET                     = 0x38,
	    SQ_DS_INST_USHORT_READ_RET                    = 0x39,
	    SQ_DS_INST_ATOMIC_ORDERED_ALLOC_RET           = 0x3f,
	DS_OFFSET_mask                                    = 0x7f << 16,
	DS_OFFSET_shift                                   = 16,
	UAV_INDEX_MODE_mask                               = 0x03 << 24,
	UAV_INDEX_MODE_shift                              = 24,
/* 	    SQ_CF_INDEX_NONE                              = 0x00, */
/* 	    SQ_CF_INDEX_0                                 = 0x01, */
/* 	    SQ_CF_INDEX_1                                 = 0x02, */
/* 	    SQ_CF_INVALID                                 = 0x03, */
	UAV_ID_mask                                       = 0x0f << 26,
	UAV_ID_shift                                      = 26,
	ALLOC_CONSUME_bit                                 = 1 << 30,
	BCAST_FIRST_REQ_bit                               = 1 << 31,
    SQ_MEM_RD_WORD2                                       = 0x00008dfc,
	ARRAY_BASE_mask                                   = 0x1fff << 0,
	ARRAY_BASE_shift                                  = 0,
	SQ_MEM_RD_WORD2__ENDIAN_SWAP_mask                 = 0x03 << 16,
	SQ_MEM_RD_WORD2__ENDIAN_SWAP_shift                = 16,
	    SQ_ENDIAN_NONE                                = 0x00,
	    SQ_ENDIAN_8IN16                               = 0x01,
	    SQ_ENDIAN_8IN32                               = 0x02,
	SQ_MEM_RD_WORD2__ARRAY_SIZE_mask                  = 0xfff << 20,
	SQ_MEM_RD_WORD2__ARRAY_SIZE_shift                 = 20,
    SQ_CF_ALU_WORD1_EXT                                   = 0x00008dfc,
	KCACHE_MODE3_mask                                 = 0x03 << 0,
	KCACHE_MODE3_shift                                = 0,
/* 	    SQ_CF_KCACHE_NOP                              = 0x00, */
/* 	    SQ_CF_KCACHE_LOCK_1                           = 0x01, */
/* 	    SQ_CF_KCACHE_LOCK_2                           = 0x02, */
/* 	    SQ_CF_KCACHE_LOCK_LOOP_INDEX                  = 0x03, */
	KCACHE_ADDR2_mask                                 = 0xff << 2,
	KCACHE_ADDR2_shift                                = 2,
	KCACHE_ADDR3_mask                                 = 0xff << 10,
	KCACHE_ADDR3_shift                                = 10,
	SQ_CF_ALU_WORD1_EXT__CF_INST_mask                 = 0x0f << 26,
	SQ_CF_ALU_WORD1_EXT__CF_INST_shift                = 26,
/* 	    SQ_CF_INST_ALU                                = 0x08, */
/* 	    SQ_CF_INST_ALU_PUSH_BEFORE                    = 0x09, */
/* 	    SQ_CF_INST_ALU_POP_AFTER                      = 0x0a, */
/* 	    SQ_CF_INST_ALU_POP2_AFTER                     = 0x0b, */
/* 	    SQ_CF_INST_ALU_EXTENDED                       = 0x0c, */
/* 	    SQ_CF_INST_ALU_CONTINUE                       = 0x0d, */
/* 	    SQ_CF_INST_ALU_BREAK                          = 0x0e, */
/* 	    SQ_CF_INST_ALU_ELSE_AFTER                     = 0x0f, */
/* 	BARRIER_bit                                       = 1 << 31, */
    SQ_CF_GWS_WORD0                                       = 0x00008dfc,
	VALUE_mask                                        = 0x3ff << 0,
	VALUE_shift                                       = 0,
	RESOURCE_mask                                     = 0x1f << 16,
	RESOURCE_shift                                    = 16,
	SIGN_bit                                          = 1 << 25,
	VAL_INDEX_MODE_mask                               = 0x03 << 26,
	VAL_INDEX_MODE_shift                              = 26,
	    SQ_GWS_INDEX_NONE                             = 0x00,
	    SQ_GWS_INDEX_0                                = 0x01,
	    SQ_GWS_INDEX_1                                = 0x02,
	    SQ_GWS_INDEX_MIX                              = 0x03,
	RSRC_INDEX_MODE_mask                              = 0x03 << 28,
	RSRC_INDEX_MODE_shift                             = 28,
/* 	    SQ_CF_INDEX_NONE                              = 0x00, */
/* 	    SQ_CF_INDEX_0                                 = 0x01, */
/* 	    SQ_CF_INDEX_1                                 = 0x02, */
/* 	    SQ_CF_INVALID                                 = 0x03, */
	GWS_OPCODE_mask                                   = 0x03 << 30,
	GWS_OPCODE_shift                                  = 30,
	    SQ_GWS_SEMA_V                                 = 0x00,
	    SQ_GWS_SEMA_P                                 = 0x01,
	    SQ_GWS_BARRIER                                = 0x02,
	    SQ_GWS_INIT                                   = 0x03,
    SQ_VTX_WORD2                                          = 0x00008dfc,
	SQ_VTX_WORD2__OFFSET_mask                         = 0xffff << 0,
	SQ_VTX_WORD2__OFFSET_shift                        = 0,
	SQ_VTX_WORD2__ENDIAN_SWAP_mask                    = 0x03 << 16,
	SQ_VTX_WORD2__ENDIAN_SWAP_shift                   = 16,
/* 	    SQ_ENDIAN_NONE                                = 0x00, */
/* 	    SQ_ENDIAN_8IN16                               = 0x01, */
/* 	    SQ_ENDIAN_8IN32                               = 0x02, */
	CONST_BUF_NO_STRIDE_bit                           = 1 << 18,
	SQ_VTX_WORD2__ALT_CONST_bit                       = 1 << 20,
	BUFFER_INDEX_MODE_mask                            = 0x03 << 21,
	BUFFER_INDEX_MODE_shift                           = 21,
/* 	    SQ_CF_INDEX_NONE                              = 0x00, */
/* 	    SQ_CF_INDEX_0                                 = 0x01, */
/* 	    SQ_CF_INDEX_1                                 = 0x02, */
/* 	    SQ_CF_INVALID                                 = 0x03, */
    SQ_ALU_WORD1_OP2_EXECUTE_MASK                         = 0x00008dfc,
	EXECUTE_MASK_OP_mask                              = 0x03 << 5,
	EXECUTE_MASK_OP_shift                             = 5,
	    SQ_ALU_EXECUTE_MASK_OP_DEACTIVATE             = 0x00,
	    SQ_ALU_EXECUTE_MASK_OP_BREAK                  = 0x01,
	    SQ_ALU_EXECUTE_MASK_OP_CONTINUE               = 0x02,
	    SQ_ALU_EXECUTE_MASK_OP_KILL                   = 0x03,
    SQ_CF_ALLOC_EXPORT_WORD1_BUF                          = 0x00008dfc,
	SQ_CF_ALLOC_EXPORT_WORD1_BUF__ARRAY_SIZE_mask     = 0xfff << 0,
	SQ_CF_ALLOC_EXPORT_WORD1_BUF__ARRAY_SIZE_shift    = 0,
	COMP_MASK_mask                                    = 0x0f << 12,
	COMP_MASK_shift                                   = 12,
    SQ_CF_WORD0                                           = 0x00008dfc,
	SQ_CF_WORD0__ADDR_mask                            = 0xffffff << 0,
	SQ_CF_WORD0__ADDR_shift                           = 0,
	JUMPTABLE_SEL_mask                                = 0x07 << 24,
	JUMPTABLE_SEL_shift                               = 24,
	    SQ_CF_JUMPTABLE_SEL_CONST_A                   = 0x00,
	    SQ_CF_JUMPTABLE_SEL_CONST_B                   = 0x01,
	    SQ_CF_JUMPTABLE_SEL_CONST_C                   = 0x02,
	    SQ_CF_JUMPTABLE_SEL_CONST_D                   = 0x03,
	    SQ_CF_JUMPTABLE_SEL_INDEX_0                   = 0x04,
	    SQ_CF_JUMPTABLE_SEL_INDEX_1                   = 0x05,
    SQ_CF_ALLOC_EXPORT_WORD0                              = 0x00008dfc,
/* 	ARRAY_BASE_mask                                   = 0x1fff << 0, */
/* 	ARRAY_BASE_shift                                  = 0, */
	SQ_CF_ALLOC_EXPORT_WORD0__TYPE_mask               = 0x03 << 13,
	SQ_CF_ALLOC_EXPORT_WORD0__TYPE_shift              = 13,
/* 	    SQ_EXPORT_PIXEL                               = 0x00, */
/* 	    SQ_EXPORT_POS                                 = 0x01, */
/* 	    SQ_EXPORT_PARAM                               = 0x02, */
/* 	    X_UNUSED_FOR_SX_EXPORTS                       = 0x03, */
/* 	RW_GPR_mask                                       = 0x7f << 15, */
/* 	RW_GPR_shift                                      = 15, */
/* 	RW_REL_bit                                        = 1 << 22, */
/* 	INDEX_GPR_mask                                    = 0x7f << 23, */
/* 	INDEX_GPR_shift                                   = 23, */
	SQ_CF_ALLOC_EXPORT_WORD0__ELEM_SIZE_mask          = 0x03 << 30,
	SQ_CF_ALLOC_EXPORT_WORD0__ELEM_SIZE_shift         = 30,
    SQ_MEM_GDS_WORD0                                      = 0x00008dfc,
/* 	MEM_INST_mask                                     = 0x1f << 0, */
/* 	MEM_INST_shift                                    = 0, */
/* 	    SQ_MEM_INST_MEM                               = 0x02, */
/* 	MEM_OP_mask                                       = 0x07 << 8, */
/* 	MEM_OP_shift                                      = 8, */
/* 	    SQ_MEM_OP_RD_SCRATCH                          = 0x00, */
/* 	    SQ_MEM_OP_RD_SCATTER                          = 0x02, */
/* 	    SQ_MEM_OP_GDS                                 = 0x04, */
/* 	    SQ_MEM_OP_TF_WRITE                            = 0x05, */
	SQ_MEM_GDS_WORD0__SRC_GPR_mask                    = 0x7f << 11,
	SQ_MEM_GDS_WORD0__SRC_GPR_shift                   = 11,
	SRC_REL_MODE_mask                                 = 0x03 << 18,
	SRC_REL_MODE_shift                                = 18,
/* 	    SQ_REL_NONE                                   = 0x00, */
/* 	    SQ_REL_LOOP                                   = 0x01, */
/* 	    SQ_REL_GLOBAL                                 = 0x02, */
	SQ_MEM_GDS_WORD0__SRC_SEL_X_mask                  = 0x07 << 20,
	SQ_MEM_GDS_WORD0__SRC_SEL_X_shift                 = 20,
/* 	    SQ_SEL_X                                      = 0x00, */
/* 	    SQ_SEL_Y                                      = 0x01, */
/* 	    SQ_SEL_Z                                      = 0x02, */
/* 	    SQ_SEL_W                                      = 0x03, */
/* 	    SQ_SEL_0                                      = 0x04, */
/* 	    SQ_SEL_1                                      = 0x05, */
	SQ_MEM_GDS_WORD0__SRC_SEL_Y_mask                  = 0x07 << 23,
	SQ_MEM_GDS_WORD0__SRC_SEL_Y_shift                 = 23,
/* 	    SQ_SEL_X                                      = 0x00, */
/* 	    SQ_SEL_Y                                      = 0x01, */
/* 	    SQ_SEL_Z                                      = 0x02, */
/* 	    SQ_SEL_W                                      = 0x03, */
/* 	    SQ_SEL_0                                      = 0x04, */
/* 	    SQ_SEL_1                                      = 0x05, */
/* 	SRC_SEL_Z_mask                                    = 0x07 << 26, */
/* 	SRC_SEL_Z_shift                                   = 26, */
/* 	    SQ_SEL_X                                      = 0x00, */
/* 	    SQ_SEL_Y                                      = 0x01, */
/* 	    SQ_SEL_Z                                      = 0x02, */
/* 	    SQ_SEL_W                                      = 0x03, */
/* 	    SQ_SEL_0                                      = 0x04, */
/* 	    SQ_SEL_1                                      = 0x05, */
    SQ_ALU_WORD1_LDS_DIRECT_LITERAL_HI                    = 0x00008dfc,
	OFFSET_B_mask                                     = 0x1fff << 0,
	OFFSET_B_shift                                    = 0,
	STRIDE_B_mask                                     = 0x7f << 13,
	STRIDE_B_shift                                    = 13,
	THREAD_REL_B_bit                                  = 1 << 22,
	DIRECT_READ_32_bit                                = 1 << 31,
    SQ_VTX_WORD1                                          = 0x00008dfc,
	SQ_VTX_WORD1__DST_SEL_X_mask                      = 0x07 << 9,
	SQ_VTX_WORD1__DST_SEL_X_shift                     = 9,
/* 	    SQ_SEL_X                                      = 0x00, */
/* 	    SQ_SEL_Y                                      = 0x01, */
/* 	    SQ_SEL_Z                                      = 0x02, */
/* 	    SQ_SEL_W                                      = 0x03, */
/* 	    SQ_SEL_0                                      = 0x04, */
/* 	    SQ_SEL_1                                      = 0x05, */
/* 	    SQ_SEL_MASK                                   = 0x07, */
	SQ_VTX_WORD1__DST_SEL_Y_mask                      = 0x07 << 12,
	SQ_VTX_WORD1__DST_SEL_Y_shift                     = 12,
/* 	    SQ_SEL_X                                      = 0x00, */
/* 	    SQ_SEL_Y                                      = 0x01, */
/* 	    SQ_SEL_Z                                      = 0x02, */
/* 	    SQ_SEL_W                                      = 0x03, */
/* 	    SQ_SEL_0                                      = 0x04, */
/* 	    SQ_SEL_1                                      = 0x05, */
/* 	    SQ_SEL_MASK                                   = 0x07, */
	SQ_VTX_WORD1__DST_SEL_Z_mask                      = 0x07 << 15,
	SQ_VTX_WORD1__DST_SEL_Z_shift                     = 15,
/* 	    SQ_SEL_X                                      = 0x00, */
/* 	    SQ_SEL_Y                                      = 0x01, */
/* 	    SQ_SEL_Z                                      = 0x02, */
/* 	    SQ_SEL_W                                      = 0x03, */
/* 	    SQ_SEL_0                                      = 0x04, */
/* 	    SQ_SEL_1                                      = 0x05, */
/* 	    SQ_SEL_MASK                                   = 0x07, */
	SQ_VTX_WORD1__DST_SEL_W_mask                      = 0x07 << 18,
	SQ_VTX_WORD1__DST_SEL_W_shift                     = 18,
/* 	    SQ_SEL_X                                      = 0x00, */
/* 	    SQ_SEL_Y                                      = 0x01, */
/* 	    SQ_SEL_Z                                      = 0x02, */
/* 	    SQ_SEL_W                                      = 0x03, */
/* 	    SQ_SEL_0                                      = 0x04, */
/* 	    SQ_SEL_1                                      = 0x05, */
/* 	    SQ_SEL_MASK                                   = 0x07, */
	USE_CONST_FIELDS_bit                              = 1 << 21,
	SQ_VTX_WORD1__DATA_FORMAT_mask                    = 0x3f << 22,
	SQ_VTX_WORD1__DATA_FORMAT_shift                   = 22,
	SQ_VTX_WORD1__NUM_FORMAT_ALL_mask                 = 0x03 << 28,
	SQ_VTX_WORD1__NUM_FORMAT_ALL_shift                = 28,
	    SQ_NUM_FORMAT_NORM                            = 0x00,
	    SQ_NUM_FORMAT_INT                             = 0x01,
	    SQ_NUM_FORMAT_SCALED                          = 0x02,
	SQ_VTX_WORD1__FORMAT_COMP_ALL_bit                 = 1 << 30,
	SQ_VTX_WORD1__SRF_MODE_ALL_bit                    = 1 << 31,
    SQ_ALU_WORD1_OP2                                      = 0x00008dfc,
	SRC0_ABS_bit                                      = 1 << 0,
	SRC1_ABS_bit                                      = 1 << 1,
	UPDATE_EXECUTE_MASK_bit                           = 1 << 2,
	UPDATE_PRED_bit                                   = 1 << 3,
	WRITE_MASK_bit                                    = 1 << 4,
	OMOD_mask                                         = 0x03 << 5,
	OMOD_shift                                        = 5,
	    SQ_ALU_OMOD_OFF                               = 0x00,
	    SQ_ALU_OMOD_M2                                = 0x01,
	    SQ_ALU_OMOD_M4                                = 0x02,
	    SQ_ALU_OMOD_D2                                = 0x03,
	SQ_ALU_WORD1_OP2__ALU_INST_mask                   = 0x7ff << 7,
	SQ_ALU_WORD1_OP2__ALU_INST_shift                  = 7,
	    SQ_OP2_INST_ADD                               = 0x00,
	    SQ_OP2_INST_MUL                               = 0x01,
	    SQ_OP2_INST_MUL_IEEE                          = 0x02,
	    SQ_OP2_INST_MAX                               = 0x03,
	    SQ_OP2_INST_MIN                               = 0x04,
	    SQ_OP2_INST_MAX_DX10                          = 0x05,
	    SQ_OP2_INST_MIN_DX10                          = 0x06,
	    SQ_OP2_INST_SETE                              = 0x08,
	    SQ_OP2_INST_SETGT                             = 0x09,
	    SQ_OP2_INST_SETGE                             = 0x0a,
	    SQ_OP2_INST_SETNE                             = 0x0b,
	    SQ_OP2_INST_SETE_DX10                         = 0x0c,
	    SQ_OP2_INST_SETGT_DX10                        = 0x0d,
	    SQ_OP2_INST_SETGE_DX10                        = 0x0e,
	    SQ_OP2_INST_SETNE_DX10                        = 0x0f,
	    SQ_OP2_INST_FRACT                             = 0x10,
	    SQ_OP2_INST_TRUNC                             = 0x11,
	    SQ_OP2_INST_CEIL                              = 0x12,
	    SQ_OP2_INST_RNDNE                             = 0x13,
	    SQ_OP2_INST_FLOOR                             = 0x14,
	    SQ_OP2_INST_ASHR_INT                          = 0x15,
	    SQ_OP2_INST_LSHR_INT                          = 0x16,
	    SQ_OP2_INST_LSHL_INT                          = 0x17,
	    SQ_OP2_INST_MOV                               = 0x19,
	    SQ_OP2_INST_NOP                               = 0x1a,
	    SQ_OP2_INST_PRED_SETGT_UINT                   = 0x1e,
	    SQ_OP2_INST_PRED_SETGE_UINT                   = 0x1f,
	    SQ_OP2_INST_PRED_SETE                         = 0x20,
	    SQ_OP2_INST_PRED_SETGT                        = 0x21,
	    SQ_OP2_INST_PRED_SETGE                        = 0x22,
	    SQ_OP2_INST_PRED_SETNE                        = 0x23,
	    SQ_OP2_INST_PRED_SET_INV                      = 0x24,
	    SQ_OP2_INST_PRED_SET_POP                      = 0x25,
	    SQ_OP2_INST_PRED_SET_CLR                      = 0x26,
	    SQ_OP2_INST_PRED_SET_RESTORE                  = 0x27,
	    SQ_OP2_INST_PRED_SETE_PUSH                    = 0x28,
	    SQ_OP2_INST_PRED_SETGT_PUSH                   = 0x29,
	    SQ_OP2_INST_PRED_SETGE_PUSH                   = 0x2a,
	    SQ_OP2_INST_PRED_SETNE_PUSH                   = 0x2b,
	    SQ_OP2_INST_KILLE                             = 0x2c,
	    SQ_OP2_INST_KILLGT                            = 0x2d,
	    SQ_OP2_INST_KILLGE                            = 0x2e,
	    SQ_OP2_INST_KILLNE                            = 0x2f,
	    SQ_OP2_INST_AND_INT                           = 0x30,
	    SQ_OP2_INST_OR_INT                            = 0x31,
	    SQ_OP2_INST_XOR_INT                           = 0x32,
	    SQ_OP2_INST_NOT_INT                           = 0x33,
	    SQ_OP2_INST_ADD_INT                           = 0x34,
	    SQ_OP2_INST_SUB_INT                           = 0x35,
	    SQ_OP2_INST_MAX_INT                           = 0x36,
	    SQ_OP2_INST_MIN_INT                           = 0x37,
	    SQ_OP2_INST_MAX_UINT                          = 0x38,
	    SQ_OP2_INST_MIN_UINT                          = 0x39,
	    SQ_OP2_INST_SETE_INT                          = 0x3a,
	    SQ_OP2_INST_SETGT_INT                         = 0x3b,
	    SQ_OP2_INST_SETGE_INT                         = 0x3c,
	    SQ_OP2_INST_SETNE_INT                         = 0x3d,
	    SQ_OP2_INST_SETGT_UINT                        = 0x3e,
	    SQ_OP2_INST_SETGE_UINT                        = 0x3f,
	    SQ_OP2_INST_KILLGT_UINT                       = 0x40,
	    SQ_OP2_INST_KILLGE_UINT                       = 0x41,
	    SQ_OP2_INST_PRED_SETE_INT                     = 0x42,
	    SQ_OP2_INST_PRED_SETGT_INT                    = 0x43,
	    SQ_OP2_INST_PRED_SETGE_INT                    = 0x44,
	    SQ_OP2_INST_PRED_SETNE_INT                    = 0x45,
	    SQ_OP2_INST_KILLE_INT                         = 0x46,
	    SQ_OP2_INST_KILLGT_INT                        = 0x47,
	    SQ_OP2_INST_KILLGE_INT                        = 0x48,
	    SQ_OP2_INST_KILLNE_INT                        = 0x49,
	    SQ_OP2_INST_PRED_SETE_PUSH_INT                = 0x4a,
	    SQ_OP2_INST_PRED_SETGT_PUSH_INT               = 0x4b,
	    SQ_OP2_INST_PRED_SETGE_PUSH_INT               = 0x4c,
	    SQ_OP2_INST_PRED_SETNE_PUSH_INT               = 0x4d,
	    SQ_OP2_INST_PRED_SETLT_PUSH_INT               = 0x4e,
	    SQ_OP2_INST_PRED_SETLE_PUSH_INT               = 0x4f,
	    SQ_OP2_INST_FLT_TO_INT                        = 0x50,
	    SQ_OP2_INST_BFREV_INT                         = 0x51,
	    SQ_OP2_INST_ADDC_UINT                         = 0x52,
	    SQ_OP2_INST_SUBB_UINT                         = 0x53,
	    SQ_OP2_INST_GROUP_BARRIER                     = 0x54,
	    SQ_OP2_INST_GROUP_SEQ_BEGIN                   = 0x55,
	    SQ_OP2_INST_GROUP_SEQ_END                     = 0x56,
	    SQ_OP2_INST_SET_MODE                          = 0x57,
	    SQ_OP2_INST_SET_CF_IDX0                       = 0x58,
	    SQ_OP2_INST_SET_CF_IDX1                       = 0x59,
	    SQ_OP2_INST_SET_LDS_SIZE                      = 0x5a,
	    SQ_OP2_INST_EXP_IEEE                          = 0x81,
	    SQ_OP2_INST_LOG_CLAMPED                       = 0x82,
	    SQ_OP2_INST_LOG_IEEE                          = 0x83,
	    SQ_OP2_INST_RECIP_CLAMPED                     = 0x84,
	    SQ_OP2_INST_RECIP_FF                          = 0x85,
	    SQ_OP2_INST_RECIP_IEEE                        = 0x86,
	    SQ_OP2_INST_RECIPSQRT_CLAMPED                 = 0x87,
	    SQ_OP2_INST_RECIPSQRT_FF                      = 0x88,
	    SQ_OP2_INST_RECIPSQRT_IEEE                    = 0x89,
	    SQ_OP2_INST_SQRT_IEEE                         = 0x8a,
	    SQ_OP2_INST_SIN                               = 0x8d,
	    SQ_OP2_INST_COS                               = 0x8e,
	    SQ_OP2_INST_MULLO_INT                         = 0x8f,
	    SQ_OP2_INST_MULHI_INT                         = 0x90,
	    SQ_OP2_INST_MULLO_UINT                        = 0x91,
	    SQ_OP2_INST_MULHI_UINT                        = 0x92,
	    SQ_OP2_INST_RECIP_INT                         = 0x93,
	    SQ_OP2_INST_RECIP_UINT                        = 0x94,
	    SQ_OP2_INST_RECIP_64                          = 0x95,
	    SQ_OP2_INST_RECIP_CLAMPED_64                  = 0x96,
	    SQ_OP2_INST_RECIPSQRT_64                      = 0x97,
	    SQ_OP2_INST_RECIPSQRT_CLAMPED_64              = 0x98,
	    SQ_OP2_INST_SQRT_64                           = 0x99,
	    SQ_OP2_INST_FLT_TO_UINT                       = 0x9a,
	    SQ_OP2_INST_INT_TO_FLT                        = 0x9b,
	    SQ_OP2_INST_UINT_TO_FLT                       = 0x9c,
	    SQ_OP2_INST_BFM_INT                           = 0xa0,
	    SQ_OP2_INST_FLT32_TO_FLT16                    = 0xa2,
	    SQ_OP2_INST_FLT16_TO_FLT32                    = 0xa3,
	    SQ_OP2_INST_UBYTE0_FLT                        = 0xa4,
	    SQ_OP2_INST_UBYTE1_FLT                        = 0xa5,
	    SQ_OP2_INST_UBYTE2_FLT                        = 0xa6,
	    SQ_OP2_INST_UBYTE3_FLT                        = 0xa7,
	    SQ_OP2_INST_BCNT_INT                          = 0xaa,
	    SQ_OP2_INST_FFBH_UINT                         = 0xab,
	    SQ_OP2_INST_FFBL_INT                          = 0xac,
	    SQ_OP2_INST_FFBH_INT                          = 0xad,
	    SQ_OP2_INST_FLT_TO_UINT4                      = 0xae,
	    SQ_OP2_INST_DOT_IEEE                          = 0xaf,
	    SQ_OP2_INST_FLT_TO_INT_RPI                    = 0xb0,
	    SQ_OP2_INST_FLT_TO_INT_FLOOR                  = 0xb1,
	    SQ_OP2_INST_MULHI_UINT24                      = 0xb2,
	    SQ_OP2_INST_MBCNT_32HI_INT                    = 0xb3,
	    SQ_OP2_INST_OFFSET_TO_FLT                     = 0xb4,
	    SQ_OP2_INST_MUL_UINT24                        = 0xb5,
	    SQ_OP2_INST_BCNT_ACCUM_PREV_INT               = 0xb6,
	    SQ_OP2_INST_MBCNT_32LO_ACCUM_PREV_INT         = 0xb7,
	    SQ_OP2_INST_SETE_64                           = 0xb8,
	    SQ_OP2_INST_SETNE_64                          = 0xb9,
	    SQ_OP2_INST_SETGT_64                          = 0xba,
	    SQ_OP2_INST_SETGE_64                          = 0xbb,
	    SQ_OP2_INST_MIN_64                            = 0xbc,
	    SQ_OP2_INST_MAX_64                            = 0xbd,
	    SQ_OP2_INST_DOT4                              = 0xbe,
	    SQ_OP2_INST_DOT4_IEEE                         = 0xbf,
	    SQ_OP2_INST_CUBE                              = 0xc0,
	    SQ_OP2_INST_MAX4                              = 0xc1,
	    SQ_OP2_INST_FREXP_64                          = 0xc4,
	    SQ_OP2_INST_LDEXP_64                          = 0xc5,
	    SQ_OP2_INST_FRACT_64                          = 0xc6,
	    SQ_OP2_INST_PRED_SETGT_64                     = 0xc7,
	    SQ_OP2_INST_PRED_SETE_64                      = 0xc8,
	    SQ_OP2_INST_PRED_SETGE_64                     = 0xc9,
	    SQ_OP2_INST_MUL_64                            = 0xca,
	    SQ_OP2_INST_ADD_64                            = 0xcb,
	    SQ_OP2_INST_MOVA_INT                          = 0xcc,
	    SQ_OP2_INST_FLT64_TO_FLT32                    = 0xcd,
	    SQ_OP2_INST_FLT32_TO_FLT64                    = 0xce,
	    SQ_OP2_INST_SAD_ACCUM_PREV_UINT               = 0xcf,
	    SQ_OP2_INST_DOT                               = 0xd0,
	    SQ_OP2_INST_MUL_PREV                          = 0xd1,
	    SQ_OP2_INST_MUL_IEEE_PREV                     = 0xd2,
	    SQ_OP2_INST_ADD_PREV                          = 0xd3,
	    SQ_OP2_INST_MULADD_PREV                       = 0xd4,
	    SQ_OP2_INST_MULADD_IEEE_PREV                  = 0xd5,
	    SQ_OP2_INST_INTERP_XY                         = 0xd6,
	    SQ_OP2_INST_INTERP_ZW                         = 0xd7,
	    SQ_OP2_INST_INTERP_X                          = 0xd8,
	    SQ_OP2_INST_INTERP_Z                          = 0xd9,
	    SQ_OP2_INST_STORE_FLAGS                       = 0xda,
	    SQ_OP2_INST_LOAD_STORE_FLAGS                  = 0xdb,
	    SQ_OP2_INST_INTERP_LOAD_P0                    = 0xe0,
	    SQ_OP2_INST_INTERP_LOAD_P10                   = 0xe1,
	    SQ_OP2_INST_INTERP_LOAD_P20                   = 0xe2,
    SQ_CF_WORD1                                           = 0x00008dfc,
	POP_COUNT_mask                                    = 0x07 << 0,
	POP_COUNT_shift                                   = 0,
	CF_CONST_mask                                     = 0x1f << 3,
	CF_CONST_shift                                    = 3,
	COND_mask                                         = 0x03 << 8,
	COND_shift                                        = 8,
	    SQ_CF_COND_ACTIVE                             = 0x00,
	    SQ_CF_COND_FALSE                              = 0x01,
	    SQ_CF_COND_BOOL                               = 0x02,
	    SQ_CF_COND_NOT_BOOL                           = 0x03,
	SQ_CF_WORD1__COUNT_mask                           = 0x3f << 10,
	SQ_CF_WORD1__COUNT_shift                          = 10,
/* 	VALID_PIXEL_MODE_bit                              = 1 << 20, */
	SQ_CF_WORD1__CF_INST_mask                         = 0xff << 22,
	SQ_CF_WORD1__CF_INST_shift                        = 22,
	    SQ_CF_INST_NOP                                = 0x00,
	    SQ_CF_INST_TC                                 = 0x01,
	    SQ_CF_INST_VC                                 = 0x02,
	    SQ_CF_INST_GDS                                = 0x03,
	    SQ_CF_INST_LOOP_START                         = 0x04,
	    SQ_CF_INST_LOOP_END                           = 0x05,
	    SQ_CF_INST_LOOP_START_DX10                    = 0x06,
	    SQ_CF_INST_LOOP_START_NO_AL                   = 0x07,
	    SQ_CF_INST_LOOP_CONTINUE                      = 0x08,
	    SQ_CF_INST_LOOP_BREAK                         = 0x09,
	    SQ_CF_INST_JUMP                               = 0x0a,
	    SQ_CF_INST_PUSH                               = 0x0b,
	    SQ_CF_INST_ELSE                               = 0x0d,
	    SQ_CF_INST_POP                                = 0x0e,
	    SQ_CF_INST_CALL                               = 0x12,
	    SQ_CF_INST_CALL_FS                            = 0x13,
	    SQ_CF_INST_RETURN                             = 0x14,
	    SQ_CF_INST_EMIT_VERTEX                        = 0x15,
	    SQ_CF_INST_EMIT_CUT_VERTEX                    = 0x16,
	    SQ_CF_INST_CUT_VERTEX                         = 0x17,
	    SQ_CF_INST_KILL                               = 0x18,
	    SQ_CF_INST_WAIT_ACK                           = 0x1a,
	    SQ_CF_INST_TC_ACK                             = 0x1b,
	    SQ_CF_INST_VC_ACK                             = 0x1c,
	    SQ_CF_INST_JUMPTABLE                          = 0x1d,
	    SQ_CF_INST_GLOBAL_WAVE_SYNC                   = 0x1e,
	    SQ_CF_INST_HALT                               = 0x1f,
	    SQ_CF_INST_END                                = 0x20,
	    SQ_CF_INST_LDS_DEALLOC                        = 0x21,
	    SQ_CF_INST_PUSH_WQM                           = 0x22,
	    SQ_CF_INST_POP_WQM                            = 0x23,
	    SQ_CF_INST_ELSE_WQM                           = 0x24,
	    SQ_CF_INST_JUMP_ANY                           = 0x25,
	    SQ_CF_INST_REACTIVATE                         = 0x26,
	    SQ_CF_INST_REACTIVATE_WQM                     = 0x27,
	    SQ_CF_INST_INTERRUPT                          = 0x28,
	    SQ_CF_INST_INTERRUPT_AND_SLEEP                = 0x29,
	    SQ_CF_INST_SET_PRIORITY                       = 0x2a,
/* 	BARRIER_bit                                       = 1 << 31, */
    SQ_VTX_WORD1_SEM                                      = 0x00008dfc,
	SEMANTIC_ID_mask                                  = 0xff << 0,
	SEMANTIC_ID_shift                                 = 0,
    SQ_TEX_WORD0                                          = 0x00008dfc,
	TEX_INST_mask                                     = 0x1f << 0,
	TEX_INST_shift                                    = 0,
	    SQ_TEX_INST_LD                                = 0x03,
	    SQ_TEX_INST_GET_TEXTURE_RESINFO               = 0x04,
	    SQ_TEX_INST_GET_NUMBER_OF_SAMPLES             = 0x05,
	    SQ_TEX_INST_GET_LOD                           = 0x06,
	    SQ_TEX_INST_GET_GRADIENTS_H                   = 0x07,
	    SQ_TEX_INST_GET_GRADIENTS_V                   = 0x08,
	    SQ_TEX_INST_SET_TEXTURE_OFFSETS               = 0x09,
	    SQ_TEX_INST_KEEP_GRADIENTS                    = 0x0a,
	    SQ_TEX_INST_SET_GRADIENTS_H                   = 0x0b,
	    SQ_TEX_INST_SET_GRADIENTS_V                   = 0x0c,
	    SQ_TEX_INST_PASS                              = 0x0d,
	    SQ_TEX_INST_SAMPLE                            = 0x10,
	    SQ_TEX_INST_SAMPLE_L                          = 0x11,
	    SQ_TEX_INST_SAMPLE_LB                         = 0x12,
	    SQ_TEX_INST_SAMPLE_LZ                         = 0x13,
	    SQ_TEX_INST_SAMPLE_G                          = 0x14,
	    SQ_TEX_INST_GATHER4                           = 0x15,
	    SQ_TEX_INST_SAMPLE_G_LB                       = 0x16,
	    SQ_TEX_INST_GATHER4_O                         = 0x17,
	    SQ_TEX_INST_SAMPLE_C                          = 0x18,
	    SQ_TEX_INST_SAMPLE_C_L                        = 0x19,
	    SQ_TEX_INST_SAMPLE_C_LB                       = 0x1a,
	    SQ_TEX_INST_SAMPLE_C_LZ                       = 0x1b,
	    SQ_TEX_INST_SAMPLE_C_G                        = 0x1c,
	    SQ_TEX_INST_GATHER4_C                         = 0x1d,
	    SQ_TEX_INST_SAMPLE_C_G_LB                     = 0x1e,
	    SQ_TEX_INST_GATHER4_C_O                       = 0x1f,
	INST_MOD_mask                                     = 0x03 << 5,
	INST_MOD_shift                                    = 5,
/* 	FETCH_WHOLE_QUAD_bit                              = 1 << 7, */
	RESOURCE_ID_mask                                  = 0xff << 8,
	RESOURCE_ID_shift                                 = 8,
	SQ_TEX_WORD0__SRC_GPR_mask                        = 0x7f << 16,
	SQ_TEX_WORD0__SRC_GPR_shift                       = 16,
/* 	SRC_REL_bit                                       = 1 << 23, */
	SQ_TEX_WORD0__ALT_CONST_bit                       = 1 << 24,
	RESOURCE_INDEX_MODE_mask                          = 0x03 << 25,
	RESOURCE_INDEX_MODE_shift                         = 25,
/* 	    SQ_CF_INDEX_NONE                              = 0x00, */
/* 	    SQ_CF_INDEX_0                                 = 0x01, */
/* 	    SQ_CF_INDEX_1                                 = 0x02, */
/* 	    SQ_CF_INVALID                                 = 0x03, */
	SAMPLER_INDEX_MODE_mask                           = 0x03 << 27,
	SAMPLER_INDEX_MODE_shift                          = 27,
/* 	    SQ_CF_INDEX_NONE                              = 0x00, */
/* 	    SQ_CF_INDEX_0                                 = 0x01, */
/* 	    SQ_CF_INDEX_1                                 = 0x02, */
/* 	    SQ_CF_INVALID                                 = 0x03, */
    SQ_VTX_WORD1_GPR                                      = 0x00008dfc,
	SQ_VTX_WORD1_GPR__DST_GPR_mask                    = 0x7f << 0,
	SQ_VTX_WORD1_GPR__DST_GPR_shift                   = 0,
	SQ_VTX_WORD1_GPR__DST_REL_bit                     = 1 << 7,
    SQ_ALU_WORD1_LDS_IDX_OP                               = 0x00008dfc,
/* 	SRC2_SEL_mask                                     = 0x1ff << 0, */
/* 	SRC2_SEL_shift                                    = 0, */
/* 	    SQ_ALU_SRC_LDS_OQ_A                           = 0xdb, */
/* 	    SQ_ALU_SRC_LDS_OQ_B                           = 0xdc, */
/* 	    SQ_ALU_SRC_LDS_OQ_A_POP                       = 0xdd, */
/* 	    SQ_ALU_SRC_LDS_OQ_B_POP                       = 0xde, */
/* 	    SQ_ALU_SRC_LDS_DIRECT_A                       = 0xdf, */
/* 	    SQ_ALU_SRC_LDS_DIRECT_B                       = 0xe0, */
/* 	    SQ_ALU_SRC_TIME_HI                            = 0xe3, */
/* 	    SQ_ALU_SRC_TIME_LO                            = 0xe4, */
/* 	    SQ_ALU_SRC_MASK_HI                            = 0xe5, */
/* 	    SQ_ALU_SRC_MASK_LO                            = 0xe6, */
/* 	    SQ_ALU_SRC_HW_WAVE_ID                         = 0xe7, */
/* 	    SQ_ALU_SRC_SIMD_ID                            = 0xe8, */
/* 	    SQ_ALU_SRC_SE_ID                              = 0xe9, */
/* 	    SQ_ALU_SRC_HW_THREADGRP_ID                    = 0xea, */
/* 	    SQ_ALU_SRC_WAVE_ID_IN_GRP                     = 0xeb, */
/* 	    SQ_ALU_SRC_NUM_THREADGRP_WAVES                = 0xec, */
/* 	    SQ_ALU_SRC_HW_ALU_ODD                         = 0xed, */
/* 	    SQ_ALU_SRC_LOOP_IDX                           = 0xee, */
/* 	    SQ_ALU_SRC_PARAM_BASE_ADDR                    = 0xf0, */
/* 	    SQ_ALU_SRC_NEW_PRIM_MASK                      = 0xf1, */
/* 	    SQ_ALU_SRC_PRIM_MASK_HI                       = 0xf2, */
/* 	    SQ_ALU_SRC_PRIM_MASK_LO                       = 0xf3, */
/* 	    SQ_ALU_SRC_1_DBL_L                            = 0xf4, */
/* 	    SQ_ALU_SRC_1_DBL_M                            = 0xf5, */
/* 	    SQ_ALU_SRC_0_5_DBL_L                          = 0xf6, */
/* 	    SQ_ALU_SRC_0_5_DBL_M                          = 0xf7, */
/* 	    SQ_ALU_SRC_0                                  = 0xf8, */
/* 	    SQ_ALU_SRC_1                                  = 0xf9, */
/* 	    SQ_ALU_SRC_1_INT                              = 0xfa, */
/* 	    SQ_ALU_SRC_M_1_INT                            = 0xfb, */
/* 	    SQ_ALU_SRC_0_5                                = 0xfc, */
/* 	    SQ_ALU_SRC_LITERAL                            = 0xfd, */
/* 	    SQ_ALU_SRC_PV                                 = 0xfe, */
/* 	    SQ_ALU_SRC_PS                                 = 0xff, */
/* 	SRC2_REL_bit                                      = 1 << 9, */
/* 	SRC2_CHAN_mask                                    = 0x03 << 10, */
/* 	SRC2_CHAN_shift                                   = 10, */
/* 	    SQ_CHAN_X                                     = 0x00, */
/* 	    SQ_CHAN_Y                                     = 0x01, */
/* 	    SQ_CHAN_Z                                     = 0x02, */
/* 	    SQ_CHAN_W                                     = 0x03, */
	IDX_OFFSET_1_bit                                  = 1 << 12,
	SQ_ALU_WORD1_LDS_IDX_OP__ALU_INST_mask            = 0x1f << 13,
	SQ_ALU_WORD1_LDS_IDX_OP__ALU_INST_shift           = 13,
/* 	    SQ_OP3_INST_BFE_UINT                          = 0x04, */
/* 	    SQ_OP3_INST_BFE_INT                           = 0x05, */
/* 	    SQ_OP3_INST_BFI_INT                           = 0x06, */
/* 	    SQ_OP3_INST_FMA                               = 0x07, */
/* 	    SQ_OP3_INST_CNDNE_64                          = 0x09, */
/* 	    SQ_OP3_INST_FMA_64                            = 0x0a, */
/* 	    SQ_OP3_INST_LERP_UINT                         = 0x0b, */
/* 	    SQ_OP3_INST_BIT_ALIGN_INT                     = 0x0c, */
/* 	    SQ_OP3_INST_BYTE_ALIGN_INT                    = 0x0d, */
/* 	    SQ_OP3_INST_SAD_ACCUM_UINT                    = 0x0e, */
/* 	    SQ_OP3_INST_SAD_ACCUM_HI_UINT                 = 0x0f, */
/* 	    SQ_OP3_INST_MULADD_UINT24                     = 0x10, */
/* 	    SQ_OP3_INST_LDS_IDX_OP                        = 0x11, */
/* 	    SQ_OP3_INST_MULADD                            = 0x14, */
/* 	    SQ_OP3_INST_MULADD_M2                         = 0x15, */
/* 	    SQ_OP3_INST_MULADD_M4                         = 0x16, */
/* 	    SQ_OP3_INST_MULADD_D2                         = 0x17, */
/* 	    SQ_OP3_INST_MULADD_IEEE                       = 0x18, */
/* 	    SQ_OP3_INST_CNDE                              = 0x19, */
/* 	    SQ_OP3_INST_CNDGT                             = 0x1a, */
/* 	    SQ_OP3_INST_CNDGE                             = 0x1b, */
/* 	    SQ_OP3_INST_CNDE_INT                          = 0x1c, */
/* 	    SQ_OP3_INST_CNDGT_INT                         = 0x1d, */
/* 	    SQ_OP3_INST_CNDGE_INT                         = 0x1e, */
/* 	    SQ_OP3_INST_MUL_LIT                           = 0x1f, */
/* 	BANK_SWIZZLE_mask                                 = 0x07 << 18, */
/* 	BANK_SWIZZLE_shift                                = 18, */
/* 	    SQ_ALU_VEC_012                                = 0x00, */
/* 	    SQ_ALU_VEC_021                                = 0x01, */
/* 	    SQ_ALU_VEC_120                                = 0x02, */
/* 	    SQ_ALU_VEC_102                                = 0x03, */
/* 	    SQ_ALU_VEC_201                                = 0x04, */
/* 	    SQ_ALU_VEC_210                                = 0x05, */
	LDS_OP_mask                                       = 0x3f << 21,
	LDS_OP_shift                                      = 21,
/* 	    SQ_DS_INST_ADD                                = 0x00, */
/* 	    SQ_DS_INST_SUB                                = 0x01, */
/* 	    SQ_DS_INST_RSUB                               = 0x02, */
/* 	    SQ_DS_INST_INC                                = 0x03, */
/* 	    SQ_DS_INST_DEC                                = 0x04, */
/* 	    SQ_DS_INST_MIN_INT                            = 0x05, */
/* 	    SQ_DS_INST_MAX_INT                            = 0x06, */
/* 	    SQ_DS_INST_MIN_UINT                           = 0x07, */
/* 	    SQ_DS_INST_MAX_UINT                           = 0x08, */
/* 	    SQ_DS_INST_AND                                = 0x09, */
/* 	    SQ_DS_INST_OR                                 = 0x0a, */
/* 	    SQ_DS_INST_XOR                                = 0x0b, */
/* 	    SQ_DS_INST_MSKOR                              = 0x0c, */
/* 	    SQ_DS_INST_WRITE                              = 0x0d, */
/* 	    SQ_DS_INST_WRITE_REL                          = 0x0e, */
/* 	    SQ_DS_INST_WRITE2                             = 0x0f, */
/* 	    SQ_DS_INST_CMP_STORE                          = 0x10, */
/* 	    SQ_DS_INST_CMP_STORE_SPF                      = 0x11, */
/* 	    SQ_DS_INST_BYTE_WRITE                         = 0x12, */
/* 	    SQ_DS_INST_SHORT_WRITE                        = 0x13, */
/* 	    SQ_DS_INST_ADD_RET                            = 0x20, */
/* 	    SQ_DS_INST_SUB_RET                            = 0x21, */
/* 	    SQ_DS_INST_RSUB_RET                           = 0x22, */
/* 	    SQ_DS_INST_INC_RET                            = 0x23, */
/* 	    SQ_DS_INST_DEC_RET                            = 0x24, */
/* 	    SQ_DS_INST_MIN_INT_RET                        = 0x25, */
/* 	    SQ_DS_INST_MAX_INT_RET                        = 0x26, */
/* 	    SQ_DS_INST_MIN_UINT_RET                       = 0x27, */
/* 	    SQ_DS_INST_MAX_UINT_RET                       = 0x28, */
/* 	    SQ_DS_INST_AND_RET                            = 0x29, */
/* 	    SQ_DS_INST_OR_RET                             = 0x2a, */
/* 	    SQ_DS_INST_XOR_RET                            = 0x2b, */
/* 	    SQ_DS_INST_MSKOR_RET                          = 0x2c, */
/* 	    SQ_DS_INST_XCHG_RET                           = 0x2d, */
/* 	    SQ_DS_INST_XCHG_REL_RET                       = 0x2e, */
/* 	    SQ_DS_INST_XCHG2_RET                          = 0x2f, */
/* 	    SQ_DS_INST_CMP_XCHG_RET                       = 0x30, */
/* 	    SQ_DS_INST_CMP_XCHG_SPF_RET                   = 0x31, */
/* 	    SQ_DS_INST_READ_RET                           = 0x32, */
/* 	    SQ_DS_INST_READ_REL_RET                       = 0x33, */
/* 	    SQ_DS_INST_READ2_RET                          = 0x34, */
/* 	    SQ_DS_INST_READWRITE_RET                      = 0x35, */
/* 	    SQ_DS_INST_BYTE_READ_RET                      = 0x36, */
/* 	    SQ_DS_INST_UBYTE_READ_RET                     = 0x37, */
/* 	    SQ_DS_INST_SHORT_READ_RET                     = 0x38, */
/* 	    SQ_DS_INST_USHORT_READ_RET                    = 0x39, */
/* 	    SQ_DS_INST_ATOMIC_ORDERED_ALLOC_RET           = 0x3f, */
	IDX_OFFSET_0_bit                                  = 1 << 27,
	IDX_OFFSET_2_bit                                  = 1 << 28,
/* 	DST_CHAN_mask                                     = 0x03 << 29, */
/* 	DST_CHAN_shift                                    = 29, */
/* 	    CHAN_X                                        = 0x00, */
/* 	    CHAN_Y                                        = 0x01, */
/* 	    CHAN_Z                                        = 0x02, */
/* 	    CHAN_W                                        = 0x03, */
	IDX_OFFSET_3_bit                                  = 1 << 31,
    SQ_CF_ENCODING_WORD1                                  = 0x00008dfc,
	SQ_CF_ENCODING_WORD1__ENCODING_mask               = 0x03 << 28,
	SQ_CF_ENCODING_WORD1__ENCODING_shift              = 28,
	    SQ_CF_ENCODING_INST_CF                        = 0x00,
	    SQ_CF_ENCODING_INST_ALLOC_EXPORT              = 0x01,
	    SQ_CF_ENCODING_INST_ALU0                      = 0x02,
	    SQ_CF_ENCODING_INST_ALU1                      = 0x03,
    SQ_ALU_WORD0                                          = 0x00008dfc,
/* 	SRC0_SEL_mask                                     = 0x1ff << 0, */
/* 	SRC0_SEL_shift                                    = 0, */
/* 	    SQ_ALU_SRC_LDS_OQ_A                           = 0xdb, */
/* 	    SQ_ALU_SRC_LDS_OQ_B                           = 0xdc, */
/* 	    SQ_ALU_SRC_LDS_OQ_A_POP                       = 0xdd, */
/* 	    SQ_ALU_SRC_LDS_OQ_B_POP                       = 0xde, */
/* 	    SQ_ALU_SRC_LDS_DIRECT_A                       = 0xdf, */
/* 	    SQ_ALU_SRC_LDS_DIRECT_B                       = 0xe0, */
/* 	    SQ_ALU_SRC_TIME_HI                            = 0xe3, */
/* 	    SQ_ALU_SRC_TIME_LO                            = 0xe4, */
/* 	    SQ_ALU_SRC_MASK_HI                            = 0xe5, */
/* 	    SQ_ALU_SRC_MASK_LO                            = 0xe6, */
/* 	    SQ_ALU_SRC_HW_WAVE_ID                         = 0xe7, */
/* 	    SQ_ALU_SRC_SIMD_ID                            = 0xe8, */
/* 	    SQ_ALU_SRC_SE_ID                              = 0xe9, */
/* 	    SQ_ALU_SRC_HW_THREADGRP_ID                    = 0xea, */
/* 	    SQ_ALU_SRC_WAVE_ID_IN_GRP                     = 0xeb, */
/* 	    SQ_ALU_SRC_NUM_THREADGRP_WAVES                = 0xec, */
/* 	    SQ_ALU_SRC_HW_ALU_ODD                         = 0xed, */
/* 	    SQ_ALU_SRC_LOOP_IDX                           = 0xee, */
/* 	    SQ_ALU_SRC_PARAM_BASE_ADDR                    = 0xf0, */
/* 	    SQ_ALU_SRC_NEW_PRIM_MASK                      = 0xf1, */
/* 	    SQ_ALU_SRC_PRIM_MASK_HI                       = 0xf2, */
/* 	    SQ_ALU_SRC_PRIM_MASK_LO                       = 0xf3, */
/* 	    SQ_ALU_SRC_1_DBL_L                            = 0xf4, */
/* 	    SQ_ALU_SRC_1_DBL_M                            = 0xf5, */
/* 	    SQ_ALU_SRC_0_5_DBL_L                          = 0xf6, */
/* 	    SQ_ALU_SRC_0_5_DBL_M                          = 0xf7, */
/* 	    SQ_ALU_SRC_0                                  = 0xf8, */
/* 	    SQ_ALU_SRC_1                                  = 0xf9, */
/* 	    SQ_ALU_SRC_1_INT                              = 0xfa, */
/* 	    SQ_ALU_SRC_M_1_INT                            = 0xfb, */
/* 	    SQ_ALU_SRC_0_5                                = 0xfc, */
/* 	    SQ_ALU_SRC_LITERAL                            = 0xfd, */
/* 	    SQ_ALU_SRC_PV                                 = 0xfe, */
/* 	    SQ_ALU_SRC_PS                                 = 0xff, */
/* 	SRC0_REL_bit                                      = 1 << 9, */
/* 	SRC0_CHAN_mask                                    = 0x03 << 10, */
/* 	SRC0_CHAN_shift                                   = 10, */
/* 	    SQ_CHAN_X                                     = 0x00, */
/* 	    SQ_CHAN_Y                                     = 0x01, */
/* 	    SQ_CHAN_Z                                     = 0x02, */
/* 	    SQ_CHAN_W                                     = 0x03, */
	SRC0_NEG_bit                                      = 1 << 12,
/* 	SRC1_SEL_mask                                     = 0x1ff << 13, */
/* 	SRC1_SEL_shift                                    = 13, */
/* 	    SQ_ALU_SRC_LDS_OQ_A                           = 0xdb, */
/* 	    SQ_ALU_SRC_LDS_OQ_B                           = 0xdc, */
/* 	    SQ_ALU_SRC_LDS_OQ_A_POP                       = 0xdd, */
/* 	    SQ_ALU_SRC_LDS_OQ_B_POP                       = 0xde, */
/* 	    SQ_ALU_SRC_LDS_DIRECT_A                       = 0xdf, */
/* 	    SQ_ALU_SRC_LDS_DIRECT_B                       = 0xe0, */
/* 	    SQ_ALU_SRC_TIME_HI                            = 0xe3, */
/* 	    SQ_ALU_SRC_TIME_LO                            = 0xe4, */
/* 	    SQ_ALU_SRC_MASK_HI                            = 0xe5, */
/* 	    SQ_ALU_SRC_MASK_LO                            = 0xe6, */
/* 	    SQ_ALU_SRC_HW_WAVE_ID                         = 0xe7, */
/* 	    SQ_ALU_SRC_SIMD_ID                            = 0xe8, */
/* 	    SQ_ALU_SRC_SE_ID                              = 0xe9, */
/* 	    SQ_ALU_SRC_HW_THREADGRP_ID                    = 0xea, */
/* 	    SQ_ALU_SRC_WAVE_ID_IN_GRP                     = 0xeb, */
/* 	    SQ_ALU_SRC_NUM_THREADGRP_WAVES                = 0xec, */
/* 	    SQ_ALU_SRC_HW_ALU_ODD                         = 0xed, */
/* 	    SQ_ALU_SRC_LOOP_IDX                           = 0xee, */
/* 	    SQ_ALU_SRC_PARAM_BASE_ADDR                    = 0xf0, */
/* 	    SQ_ALU_SRC_NEW_PRIM_MASK                      = 0xf1, */
/* 	    SQ_ALU_SRC_PRIM_MASK_HI                       = 0xf2, */
/* 	    SQ_ALU_SRC_PRIM_MASK_LO                       = 0xf3, */
/* 	    SQ_ALU_SRC_1_DBL_L                            = 0xf4, */
/* 	    SQ_ALU_SRC_1_DBL_M                            = 0xf5, */
/* 	    SQ_ALU_SRC_0_5_DBL_L                          = 0xf6, */
/* 	    SQ_ALU_SRC_0_5_DBL_M                          = 0xf7, */
/* 	    SQ_ALU_SRC_0                                  = 0xf8, */
/* 	    SQ_ALU_SRC_1                                  = 0xf9, */
/* 	    SQ_ALU_SRC_1_INT                              = 0xfa, */
/* 	    SQ_ALU_SRC_M_1_INT                            = 0xfb, */
/* 	    SQ_ALU_SRC_0_5                                = 0xfc, */
/* 	    SQ_ALU_SRC_LITERAL                            = 0xfd, */
/* 	    SQ_ALU_SRC_PV                                 = 0xfe, */
/* 	    SQ_ALU_SRC_PS                                 = 0xff, */
/* 	SRC1_REL_bit                                      = 1 << 22, */
/* 	SRC1_CHAN_mask                                    = 0x03 << 23, */
/* 	SRC1_CHAN_shift                                   = 23, */
/* 	    SQ_CHAN_X                                     = 0x00, */
/* 	    SQ_CHAN_Y                                     = 0x01, */
/* 	    SQ_CHAN_Z                                     = 0x02, */
/* 	    SQ_CHAN_W                                     = 0x03, */
	SRC1_NEG_bit                                      = 1 << 25,
/* 	INDEX_MODE_mask                                   = 0x07 << 26, */
/* 	INDEX_MODE_shift                                  = 26, */
/* 	    SQ_INDEX_AR_X                                 = 0x00, */
/* 	    SQ_INDEX_LOOP                                 = 0x04, */
/* 	    SQ_INDEX_GLOBAL                               = 0x05, */
/* 	    SQ_INDEX_GLOBAL_AR_X                          = 0x06, */
/* 	PRED_SEL_mask                                     = 0x03 << 29, */
/* 	PRED_SEL_shift                                    = 29, */
/* 	    SQ_PRED_SEL_OFF                               = 0x00, */
/* 	    SQ_PRED_SEL_ZERO                              = 0x02, */
/* 	    SQ_PRED_SEL_ONE                               = 0x03, */
/* 	LAST_bit                                          = 1 << 31, */
    SQ_MEM_RD_WORD1                                       = 0x00008dfc,
	SQ_MEM_RD_WORD1__DST_GPR_mask                     = 0x7f << 0,
	SQ_MEM_RD_WORD1__DST_GPR_shift                    = 0,
	SQ_MEM_RD_WORD1__DST_REL_bit                      = 1 << 7,
	SQ_MEM_RD_WORD1__DST_SEL_X_mask                   = 0x07 << 9,
	SQ_MEM_RD_WORD1__DST_SEL_X_shift                  = 9,
/* 	    SQ_SEL_X                                      = 0x00, */
/* 	    SQ_SEL_Y                                      = 0x01, */
/* 	    SQ_SEL_Z                                      = 0x02, */
/* 	    SQ_SEL_W                                      = 0x03, */
/* 	    SQ_SEL_0                                      = 0x04, */
/* 	    SQ_SEL_1                                      = 0x05, */
/* 	    SQ_SEL_MASK                                   = 0x07, */
	SQ_MEM_RD_WORD1__DST_SEL_Y_mask                   = 0x07 << 12,
	SQ_MEM_RD_WORD1__DST_SEL_Y_shift                  = 12,
/* 	    SQ_SEL_X                                      = 0x00, */
/* 	    SQ_SEL_Y                                      = 0x01, */
/* 	    SQ_SEL_Z                                      = 0x02, */
/* 	    SQ_SEL_W                                      = 0x03, */
/* 	    SQ_SEL_0                                      = 0x04, */
/* 	    SQ_SEL_1                                      = 0x05, */
/* 	    SQ_SEL_MASK                                   = 0x07, */
	SQ_MEM_RD_WORD1__DST_SEL_Z_mask                   = 0x07 << 15,
	SQ_MEM_RD_WORD1__DST_SEL_Z_shift                  = 15,
/* 	    SQ_SEL_X                                      = 0x00, */
/* 	    SQ_SEL_Y                                      = 0x01, */
/* 	    SQ_SEL_Z                                      = 0x02, */
/* 	    SQ_SEL_W                                      = 0x03, */
/* 	    SQ_SEL_0                                      = 0x04, */
/* 	    SQ_SEL_1                                      = 0x05, */
/* 	    SQ_SEL_MASK                                   = 0x07, */
	SQ_MEM_RD_WORD1__DST_SEL_W_mask                   = 0x07 << 18,
	SQ_MEM_RD_WORD1__DST_SEL_W_shift                  = 18,
/* 	    SQ_SEL_X                                      = 0x00, */
/* 	    SQ_SEL_Y                                      = 0x01, */
/* 	    SQ_SEL_Z                                      = 0x02, */
/* 	    SQ_SEL_W                                      = 0x03, */
/* 	    SQ_SEL_0                                      = 0x04, */
/* 	    SQ_SEL_1                                      = 0x05, */
/* 	    SQ_SEL_MASK                                   = 0x07, */
	SQ_MEM_RD_WORD1__DATA_FORMAT_mask                 = 0x3f << 22,
	SQ_MEM_RD_WORD1__DATA_FORMAT_shift                = 22,
	SQ_MEM_RD_WORD1__NUM_FORMAT_ALL_mask              = 0x03 << 28,
	SQ_MEM_RD_WORD1__NUM_FORMAT_ALL_shift             = 28,
/* 	    SQ_NUM_FORMAT_NORM                            = 0x00, */
/* 	    SQ_NUM_FORMAT_INT                             = 0x01, */
/* 	    SQ_NUM_FORMAT_SCALED                          = 0x02, */
	SQ_MEM_RD_WORD1__FORMAT_COMP_ALL_bit              = 1 << 30,
	SQ_MEM_RD_WORD1__SRF_MODE_ALL_bit                 = 1 << 31,
    SQ_LSTMP_RING_BASE                                    = 0x00008e10,
    SQ_LSTMP_RING_SIZE                                    = 0x00008e14,
    SQ_HSTMP_RING_BASE                                    = 0x00008e18,
    SQ_HSTMP_RING_SIZE                                    = 0x00008e1c,
    SQ_EX_ALLOC_TABLE_SLOTS                               = 0x00008e48,
	PIX_SLOTS_mask                                    = 0x7f << 0,
	PIX_SLOTS_shift                                   = 0,
	POS_SLOTS_mask                                    = 0x7f << 8,
	POS_SLOTS_shift                                   = 8,
	SMX_SLOTS_mask                                    = 0x7f << 16,
	SMX_SLOTS_shift                                   = 16,
    SX_EXPORT_BUFFER_SIZES                                = 0x0000900c,
	COLOR_BUFFER_SIZE_mask                            = 0xff << 0,
	COLOR_BUFFER_SIZE_shift                           = 0,
	POSITION_BUFFER_SIZE_mask                         = 0xff << 8,
	POSITION_BUFFER_SIZE_shift                        = 8,
	SMX_BUFFER_SIZE_mask                              = 0xff << 16,
	SMX_BUFFER_SIZE_shift                             = 16,
    SX_MEMORY_EXPORT_BASE                                 = 0x00009010,
    SX_MEMORY_EXPORT_SIZE                                 = 0x00009014,
    SPI_CONFIG_CNTL                                       = 0x00009100,
	GPR_WRITE_PRIORITY_mask                           = 0x3ffff << 0,
	GPR_WRITE_PRIORITY_shift                          = 0,
    SPI_CONFIG_CNTL_1                                     = 0x0000913c,
	VTX_DONE_DELAY_mask                               = 0x0f << 0,
	VTX_DONE_DELAY_shift                              = 0,
	    X_DELAY_14_CLKS                               = 0x00,
	    X_DELAY_16_CLKS                               = 0x01,
	    X_DELAY_18_CLKS                               = 0x02,
	    X_DELAY_20_CLKS                               = 0x03,
	    X_DELAY_22_CLKS                               = 0x04,
	    X_DELAY_24_CLKS                               = 0x05,
	    X_DELAY_26_CLKS                               = 0x06,
	    X_DELAY_28_CLKS                               = 0x07,
	    X_DELAY_30_CLKS                               = 0x08,
	    X_DELAY_32_CLKS                               = 0x09,
	    X_DELAY_34_CLKS                               = 0x0a,
	    X_DELAY_4_CLKS                                = 0x0b,
	    X_DELAY_6_CLKS                                = 0x0c,
	    X_DELAY_8_CLKS                                = 0x0d,
	    X_DELAY_10_CLKS                               = 0x0e,
	    X_DELAY_12_CLKS                               = 0x0f,
	INTERP_ONE_PRIM_PER_ROW_bit                       = 1 << 4,
	BC_OPTIMIZE_DISABLE_bit                           = 1 << 5,
	PC_LIMIT_ENABLE_bit                               = 1 << 6,
	PC_LIMIT_STRICT_bit                               = 1 << 7,
	PC_LIMIT_SIZE_mask                                = 0xffff << 16,
	PC_LIMIT_SIZE_shift                               = 16,
    TD_CNTL                                               = 0x00009494,
	SYNC_PHASE_SH_mask                                = 0x03 << 0,
	SYNC_PHASE_SH_shift                               = 0,
	PAD_STALL_EN_bit                                  = 1 << 8,
	EXTEND_LDS_STALL_mask                             = 0x03 << 9,
	EXTEND_LDS_STALL_shift                            = 9,
	    X_0                                           = 0x00,
	    EXTEND_LDS_STALL__X_1                         = 0x01,
	    X_2                                           = 0x02,
	    X_3                                           = 0x03,
	GATHER4_FLOAT_MODE_bit                            = 1 << 16,
	LD_FLOAT_MODE_bit                                 = 1 << 18,
	GATHER4_DX9_MODE_bit                              = 1 << 19,
    TD_STATUS                                             = 0x00009498,
	BUSY_bit                                          = 1 << 31,
    DB_SUBTILE_CONTROL                                    = 0x00009858,
	MSAA1_X_mask                                      = 0x03 << 0,
	MSAA1_X_shift                                     = 0,
	MSAA1_Y_mask                                      = 0x03 << 2,
	MSAA1_Y_shift                                     = 2,
	MSAA2_X_mask                                      = 0x03 << 4,
	MSAA2_X_shift                                     = 4,
	MSAA2_Y_mask                                      = 0x03 << 6,
	MSAA2_Y_shift                                     = 6,
	MSAA4_X_mask                                      = 0x03 << 8,
	MSAA4_X_shift                                     = 8,
	MSAA4_Y_mask                                      = 0x03 << 10,
	MSAA4_Y_shift                                     = 10,
	MSAA8_X_mask                                      = 0x03 << 12,
	MSAA8_X_shift                                     = 12,
	MSAA8_Y_mask                                      = 0x03 << 14,
	MSAA8_Y_shift                                     = 14,
	MSAA16_X_mask                                     = 0x03 << 16,
	MSAA16_X_shift                                    = 16,
	MSAA16_Y_mask                                     = 0x03 << 18,
	MSAA16_Y_shift                                    = 18,
    DB_ZPASS_COUNT_LOW                                    = 0x00009870,
    DB_ZPASS_COUNT_HI                                     = 0x00009874,
	COUNT_HI_mask                                     = 0x7fffffff << 0,
	COUNT_HI_shift                                    = 0,
    TD_PS_BORDER_COLOR_INDEX                              = 0x0000a400,
	INDEX_mask                                        = 0x1f << 0,
	INDEX_shift                                       = 0,
    TD_PS_BORDER_COLOR_RED                                = 0x0000a404,
    TD_PS_BORDER_COLOR_GREEN                              = 0x0000a408,
    TD_PS_BORDER_COLOR_BLUE                               = 0x0000a40c,
    TD_PS_BORDER_COLOR_ALPHA                              = 0x0000a410,
    TD_VS_BORDER_COLOR_INDEX                              = 0x0000a414,
/* 	INDEX_mask                                        = 0x1f << 0, */
/* 	INDEX_shift                                       = 0, */
    TD_VS_BORDER_COLOR_RED                                = 0x0000a418,
    TD_VS_BORDER_COLOR_GREEN                              = 0x0000a41c,
    TD_VS_BORDER_COLOR_BLUE                               = 0x0000a420,
    TD_VS_BORDER_COLOR_ALPHA                              = 0x0000a424,
    TD_GS_BORDER_COLOR_INDEX                              = 0x0000a428,
/* 	INDEX_mask                                        = 0x1f << 0, */
/* 	INDEX_shift                                       = 0, */
    TD_GS_BORDER_COLOR_RED                                = 0x0000a42c,
    TD_GS_BORDER_COLOR_GREEN                              = 0x0000a430,
    TD_GS_BORDER_COLOR_BLUE                               = 0x0000a434,
    TD_GS_BORDER_COLOR_ALPHA                              = 0x0000a438,
    TD_HS_BORDER_COLOR_INDEX                              = 0x0000a43c,
/* 	INDEX_mask                                        = 0x1f << 0, */
/* 	INDEX_shift                                       = 0, */
    TD_HS_BORDER_COLOR_RED                                = 0x0000a440,
    TD_HS_BORDER_COLOR_GREEN                              = 0x0000a444,
    TD_HS_BORDER_COLOR_BLUE                               = 0x0000a448,
    TD_HS_BORDER_COLOR_ALPHA                              = 0x0000a44c,
    TD_LS_BORDER_COLOR_INDEX                              = 0x0000a450,
/* 	INDEX_mask                                        = 0x1f << 0, */
/* 	INDEX_shift                                       = 0, */
    TD_LS_BORDER_COLOR_RED                                = 0x0000a454,
    TD_LS_BORDER_COLOR_GREEN                              = 0x0000a458,
    TD_LS_BORDER_COLOR_BLUE                               = 0x0000a45c,
    TD_LS_BORDER_COLOR_ALPHA                              = 0x0000a460,
    TD_CS_BORDER_COLOR_INDEX                              = 0x0000a464,
/* 	INDEX_mask                                        = 0x1f << 0, */
/* 	INDEX_shift                                       = 0, */
    TD_CS_BORDER_COLOR_RED                                = 0x0000a468,
    TD_CS_BORDER_COLOR_GREEN                              = 0x0000a46c,
    TD_CS_BORDER_COLOR_BLUE                               = 0x0000a470,
    TD_CS_BORDER_COLOR_ALPHA                              = 0x0000a474,
    DB_RENDER_CONTROL                                     = 0x00028000,
	DEPTH_CLEAR_ENABLE_bit                            = 1 << 0,
	STENCIL_CLEAR_ENABLE_bit                          = 1 << 1,
	DEPTH_COPY_bit                                    = 1 << 2,
	STENCIL_COPY_bit                                  = 1 << 3,
	RESUMMARIZE_ENABLE_bit                            = 1 << 4,
	STENCIL_COMPRESS_DISABLE_bit                      = 1 << 5,
	DEPTH_COMPRESS_DISABLE_bit                        = 1 << 6,
	COPY_CENTROID_bit                                 = 1 << 7,
	COPY_SAMPLE_mask                                  = 0x0f << 8,
	COPY_SAMPLE_shift                                 = 8,
    DB_COUNT_CONTROL                                      = 0x00028004,
	ZPASS_INCREMENT_DISABLE_bit                       = 1 << 0,
	PERFECT_ZPASS_COUNTS_bit                          = 1 << 1,
	SAMPLE_RATE_mask                                  = 0x07 << 4,
	SAMPLE_RATE_shift                                 = 4,
    DB_DEPTH_VIEW                                         = 0x00028008,
	SLICE_START_mask                                  = 0x7ff << 0,
	SLICE_START_shift                                 = 0,
	SLICE_MAX_mask                                    = 0x7ff << 13,
	SLICE_MAX_shift                                   = 13,
	Z_READ_ONLY_bit                                   = 1 << 24,
	STENCIL_READ_ONLY_bit                             = 1 << 25,
    DB_RENDER_OVERRIDE                                    = 0x0002800c,
	FORCE_HIZ_ENABLE_mask                             = 0x03 << 0,
	FORCE_HIZ_ENABLE_shift                            = 0,
	    FORCE_OFF                                     = 0x00,
	    FORCE_ENABLE                                  = 0x01,
	    FORCE_DISABLE                                 = 0x02,
	    FORCE_RESERVED                                = 0x03,
	FORCE_HIS_ENABLE0_mask                            = 0x03 << 2,
	FORCE_HIS_ENABLE0_shift                           = 2,
/* 	    FORCE_OFF                                     = 0x00, */
/* 	    FORCE_ENABLE                                  = 0x01, */
/* 	    FORCE_DISABLE                                 = 0x02, */
/* 	    FORCE_RESERVED                                = 0x03, */
	FORCE_HIS_ENABLE1_mask                            = 0x03 << 4,
	FORCE_HIS_ENABLE1_shift                           = 4,
/* 	    FORCE_OFF                                     = 0x00, */
/* 	    FORCE_ENABLE                                  = 0x01, */
/* 	    FORCE_DISABLE                                 = 0x02, */
/* 	    FORCE_RESERVED                                = 0x03, */
	FORCE_SHADER_Z_ORDER_bit                          = 1 << 6,
	FAST_Z_DISABLE_bit                                = 1 << 7,
	FAST_STENCIL_DISABLE_bit                          = 1 << 8,
	NOOP_CULL_DISABLE_bit                             = 1 << 9,
	FORCE_COLOR_KILL_bit                              = 1 << 10,
	FORCE_Z_READ_bit                                  = 1 << 11,
	FORCE_STENCIL_READ_bit                            = 1 << 12,
	FORCE_FULL_Z_RANGE_mask                           = 0x03 << 13,
	FORCE_FULL_Z_RANGE_shift                          = 13,
/* 	    FORCE_OFF                                     = 0x00, */
/* 	    FORCE_ENABLE                                  = 0x01, */
/* 	    FORCE_DISABLE                                 = 0x02, */
/* 	    FORCE_RESERVED                                = 0x03, */
	FORCE_QC_SMASK_CONFLICT_bit                       = 1 << 15,
	DISABLE_VIEWPORT_CLAMP_bit                        = 1 << 16,
	IGNORE_SC_ZRANGE_bit                              = 1 << 17,
	DISABLE_FULLY_COVERED_bit                         = 1 << 18,
	FORCE_Z_LIMIT_SUMM_mask                           = 0x03 << 19,
	FORCE_Z_LIMIT_SUMM_shift                          = 19,
	    FORCE_SUMM_OFF                                = 0x00,
	    FORCE_SUMM_MINZ                               = 0x01,
	    FORCE_SUMM_MAXZ                               = 0x02,
	    FORCE_SUMM_BOTH                               = 0x03,
	MAX_TILES_IN_DTT_mask                             = 0x1f << 21,
	MAX_TILES_IN_DTT_shift                            = 21,
	DISABLE_TILE_RATE_TILES_bit                       = 1 << 26,
	FORCE_Z_DIRTY_bit                                 = 1 << 27,
	FORCE_STENCIL_DIRTY_bit                           = 1 << 28,
	FORCE_Z_VALID_bit                                 = 1 << 29,
	FORCE_STENCIL_VALID_bit                           = 1 << 30,
	PRESERVE_COMPRESSION_bit                          = 1 << 31,
    DB_RENDER_OVERRIDE2                                   = 0x00028010,
	PARTIAL_SQUAD_LAUNCH_CONTROL_mask                 = 0x03 << 0,
	PARTIAL_SQUAD_LAUNCH_CONTROL_shift                = 0,
	    PSLC_AUTO                                     = 0x00,
	    PSLC_ON_HANG_ONLY                             = 0x01,
	    PSLC_ASAP                                     = 0x02,
	    PSLC_COUNTDOWN                                = 0x03,
	PARTIAL_SQUAD_LAUNCH_COUNTDOWN_mask               = 0x07 << 2,
	PARTIAL_SQUAD_LAUNCH_COUNTDOWN_shift              = 2,
	DISABLE_ZMASK_EXPCLEAR_OPTIMIZATIO_bit            = 1 << 5,
	DISABLE_SMEM_EXPCLEAR_OPTIMIZATION_bit            = 1 << 6,
	DISABLE_COLOR_ON_VALIDATION_bit                   = 1 << 7,
	DECOMPRESS_Z_ON_FLUSH_bit                         = 1 << 8,
    DB_HTILE_DATA_BASE                                    = 0x00028014,
    DB_STENCIL_CLEAR                                      = 0x00028028,
	DB_STENCIL_CLEAR__CLEAR_mask                      = 0xff << 0,
	DB_STENCIL_CLEAR__CLEAR_shift                     = 0,
    DB_DEPTH_CLEAR                                        = 0x0002802c,
    PA_SC_SCREEN_SCISSOR_TL                               = 0x00028030,
	PA_SC_SCREEN_SCISSOR_TL__TL_X_mask                = 0xffff << 0,
	PA_SC_SCREEN_SCISSOR_TL__TL_X_shift               = 0,
	PA_SC_SCREEN_SCISSOR_TL__TL_Y_mask                = 0xffff << 16,
	PA_SC_SCREEN_SCISSOR_TL__TL_Y_shift               = 16,
    PA_SC_SCREEN_SCISSOR_BR                               = 0x00028034,
	PA_SC_SCREEN_SCISSOR_BR__BR_X_mask                = 0xffff << 0,
	PA_SC_SCREEN_SCISSOR_BR__BR_X_shift               = 0,
	PA_SC_SCREEN_SCISSOR_BR__BR_Y_mask                = 0xffff << 16,
	PA_SC_SCREEN_SCISSOR_BR__BR_Y_shift               = 16,
    DB_DEPTH_INFO                                         = 0x0002803c,
	ADDR5_SWIZZLE_MASK_mask                           = 0x0f << 0,
	ADDR5_SWIZZLE_MASK_shift                          = 0,
    DB_Z_INFO                                             = 0x00028040,
	DB_Z_INFO__FORMAT_mask                            = 0x03 << 0,
	DB_Z_INFO__FORMAT_shift                           = 0,
	    Z_INVALID                                     = 0x00,
	    Z_16                                          = 0x01,
	    Z_24                                          = 0x02,
	    Z_32_FLOAT                                    = 0x03,
	DB_Z_INFO__NUM_SAMPLES_mask                       = 0x03 << 2,
	DB_Z_INFO__NUM_SAMPLES_shift                      = 2,
	DB_Z_INFO__ARRAY_MODE_mask                        = 0x0f << 4,
	DB_Z_INFO__ARRAY_MODE_shift                       = 4,
	    ARRAY_1D_TILED_THIN1                          = 0x02,
	    ARRAY_2D_TILED_THIN1                          = 0x04,
	DB_Z_INFO__TILE_SPLIT_mask                        = 0x07 << 8,
	DB_Z_INFO__TILE_SPLIT_shift                       = 8,
	    ADDR_SURF_TILE_SPLIT_64B                      = 0x00,
	    ADDR_SURF_TILE_SPLIT_128B                     = 0x01,
	    ADDR_SURF_TILE_SPLIT_256B                     = 0x02,
	    ADDR_SURF_TILE_SPLIT_512B                     = 0x03,
	    ADDR_SURF_TILE_SPLIT_1KB                      = 0x04,
	    ADDR_SURF_TILE_SPLIT_2KB                      = 0x05,
	    ADDR_SURF_TILE_SPLIT_4KB                      = 0x06,
	DB_Z_INFO__NUM_BANKS_mask                         = 0x03 << 12,
	DB_Z_INFO__NUM_BANKS_shift                        = 12,
	    ADDR_SURF_2_BANK                              = 0x00,
	    ADDR_SURF_4_BANK                              = 0x01,
	    ADDR_SURF_8_BANK                              = 0x02,
	    ADDR_SURF_16_BANK                             = 0x03,
	DB_Z_INFO__BANK_WIDTH_mask                        = 0x03 << 16,
	DB_Z_INFO__BANK_WIDTH_shift                       = 16,
	    ADDR_SURF_BANK_WIDTH_1                        = 0x00,
	    ADDR_SURF_BANK_WIDTH_2                        = 0x01,
	    ADDR_SURF_BANK_WIDTH_4                        = 0x02,
	    ADDR_SURF_BANK_WIDTH_8                        = 0x03,
	DB_Z_INFO__BANK_HEIGHT_mask                       = 0x03 << 20,
	DB_Z_INFO__BANK_HEIGHT_shift                      = 20,
	    ADDR_SURF_BANK_HEIGHT_1                       = 0x00,
	    ADDR_SURF_BANK_HEIGHT_2                       = 0x01,
	    ADDR_SURF_BANK_HEIGHT_4                       = 0x02,
	    ADDR_SURF_BANK_HEIGHT_8                       = 0x03,
	DB_Z_INFO__MACRO_TILE_ASPECT_mask                 = 0x03 << 24,
	DB_Z_INFO__MACRO_TILE_ASPECT_shift                = 24,
	    ADDR_SURF_MACRO_ASPECT_1                      = 0x00,
	    ADDR_SURF_MACRO_ASPECT_2                      = 0x01,
	    ADDR_SURF_MACRO_ASPECT_4                      = 0x02,
	    ADDR_SURF_MACRO_ASPECT_8                      = 0x03,
	ALLOW_EXPCLEAR_bit                                = 1 << 27,
	READ_SIZE_bit                                     = 1 << 28,
	TILE_SURFACE_ENABLE_bit                           = 1 << 29,
	ZRANGE_PRECISION_bit                              = 1 << 31,
    DB_STENCIL_INFO                                       = 0x00028044,
	DB_STENCIL_INFO__FORMAT_bit                       = 1 << 0,
	DB_STENCIL_INFO__TILE_SPLIT_mask                  = 0x07 << 8,
	DB_STENCIL_INFO__TILE_SPLIT_shift                 = 8,
/* 	    ADDR_SURF_TILE_SPLIT_64B                      = 0x00, */
/* 	    ADDR_SURF_TILE_SPLIT_128B                     = 0x01, */
/* 	    ADDR_SURF_TILE_SPLIT_256B                     = 0x02, */
/* 	    ADDR_SURF_TILE_SPLIT_512B                     = 0x03, */
/* 	    ADDR_SURF_TILE_SPLIT_1KB                      = 0x04, */
/* 	    ADDR_SURF_TILE_SPLIT_2KB                      = 0x05, */
/* 	    ADDR_SURF_TILE_SPLIT_4KB                      = 0x06, */
/* 	ALLOW_EXPCLEAR_bit                                = 1 << 27, */
	TILE_STENCIL_DISABLE_bit                          = 1 << 29,
    DB_Z_READ_BASE                                        = 0x00028048,
    DB_STENCIL_READ_BASE                                  = 0x0002804c,
    DB_Z_WRITE_BASE                                       = 0x00028050,
    DB_STENCIL_WRITE_BASE                                 = 0x00028054,
    DB_DEPTH_SIZE                                         = 0x00028058,
	PITCH_TILE_MAX_mask                               = 0x7ff << 0,
	PITCH_TILE_MAX_shift                              = 0,
	HEIGHT_TILE_MAX_mask                              = 0x7ff << 11,
	HEIGHT_TILE_MAX_shift                             = 11,
    DB_DEPTH_SLICE                                        = 0x0002805c,
	SLICE_TILE_MAX_mask                               = 0x3fffff << 0,
	SLICE_TILE_MAX_shift                              = 0,
    SQ_ALU_CONST_BUFFER_SIZE_PS_0                         = 0x00028140,
	SQ_ALU_CONST_BUFFER_SIZE_PS_0_num                 = 16,
	SQ_ALU_CONST_BUFFER_SIZE_PS_0__DATA_mask          = 0x1ff << 0,
	SQ_ALU_CONST_BUFFER_SIZE_PS_0__DATA_shift         = 0,
    SQ_ALU_CONST_BUFFER_SIZE_VS_0                         = 0x00028180,
	SQ_ALU_CONST_BUFFER_SIZE_VS_0_num                 = 16,
	SQ_ALU_CONST_BUFFER_SIZE_VS_0__DATA_mask          = 0x1ff << 0,
	SQ_ALU_CONST_BUFFER_SIZE_VS_0__DATA_shift         = 0,
    SQ_ALU_CONST_BUFFER_SIZE_GS_0                         = 0x000281c0,
	SQ_ALU_CONST_BUFFER_SIZE_GS_0_num                 = 16,
	SQ_ALU_CONST_BUFFER_SIZE_GS_0__DATA_mask          = 0x1ff << 0,
	SQ_ALU_CONST_BUFFER_SIZE_GS_0__DATA_shift         = 0,
    PA_SC_WINDOW_OFFSET                                   = 0x00028200,
	WINDOW_X_OFFSET_mask                              = 0xffff << 0,
	WINDOW_X_OFFSET_shift                             = 0,
	WINDOW_Y_OFFSET_mask                              = 0xffff << 16,
	WINDOW_Y_OFFSET_shift                             = 16,
    PA_SC_WINDOW_SCISSOR_TL                               = 0x00028204,
	PA_SC_WINDOW_SCISSOR_TL__TL_X_mask                = 0x7fff << 0,
	PA_SC_WINDOW_SCISSOR_TL__TL_X_shift               = 0,
	PA_SC_WINDOW_SCISSOR_TL__TL_Y_mask                = 0x7fff << 16,
	PA_SC_WINDOW_SCISSOR_TL__TL_Y_shift               = 16,
	WINDOW_OFFSET_DISABLE_bit                         = 1 << 31,
    PA_SC_WINDOW_SCISSOR_BR                               = 0x00028208,
	PA_SC_WINDOW_SCISSOR_BR__BR_X_mask                = 0x7fff << 0,
	PA_SC_WINDOW_SCISSOR_BR__BR_X_shift               = 0,
	PA_SC_WINDOW_SCISSOR_BR__BR_Y_mask                = 0x7fff << 16,
	PA_SC_WINDOW_SCISSOR_BR__BR_Y_shift               = 16,
    PA_SC_CLIPRECT_RULE                                   = 0x0002820c,
	CLIP_RULE_mask                                    = 0xffff << 0,
	CLIP_RULE_shift                                   = 0,
    PA_SC_CLIPRECT_0_TL                                   = 0x00028210,
	PA_SC_CLIPRECT_0_TL_num                           = 4,
	PA_SC_CLIPRECT_0_TL_offset                        = 8,
	PA_SC_CLIPRECT_0_TL__TL_X_mask                    = 0x7fff << 0,
	PA_SC_CLIPRECT_0_TL__TL_X_shift                   = 0,
	PA_SC_CLIPRECT_0_TL__TL_Y_mask                    = 0x7fff << 16,
	PA_SC_CLIPRECT_0_TL__TL_Y_shift                   = 16,
    PA_SC_CLIPRECT_0_BR                                   = 0x00028214,
	PA_SC_CLIPRECT_0_BR_num                           = 4,
	PA_SC_CLIPRECT_0_BR_offset                        = 8,
	PA_SC_CLIPRECT_0_BR__BR_X_mask                    = 0x7fff << 0,
	PA_SC_CLIPRECT_0_BR__BR_X_shift                   = 0,
	PA_SC_CLIPRECT_0_BR__BR_Y_mask                    = 0x7fff << 16,
	PA_SC_CLIPRECT_0_BR__BR_Y_shift                   = 16,
    PA_SC_EDGERULE                                        = 0x00028230,
	ER_TRI_mask                                       = 0x0f << 0,
	ER_TRI_shift                                      = 0,
	ER_POINT_mask                                     = 0x0f << 4,
	ER_POINT_shift                                    = 4,
	ER_RECT_mask                                      = 0x0f << 8,
	ER_RECT_shift                                     = 8,
	ER_LINE_LR_mask                                   = 0x3f << 12,
	ER_LINE_LR_shift                                  = 12,
	ER_LINE_RL_mask                                   = 0x3f << 18,
	ER_LINE_RL_shift                                  = 18,
	ER_LINE_TB_mask                                   = 0x0f << 24,
	ER_LINE_TB_shift                                  = 24,
	ER_LINE_BT_mask                                   = 0x0f << 28,
	ER_LINE_BT_shift                                  = 28,
    PA_SU_HARDWARE_SCREEN_OFFSET                          = 0x00028234,
	HW_SCREEN_OFFSET_X_mask                           = 0x1f << 0,
	HW_SCREEN_OFFSET_X_shift                          = 0,
	HW_SCREEN_OFFSET_Y_mask                           = 0x1f << 8,
	HW_SCREEN_OFFSET_Y_shift                          = 8,
    CB_TARGET_MASK                                        = 0x00028238,
	TARGET0_ENABLE_mask                               = 0x0f << 0,
	TARGET0_ENABLE_shift                              = 0,
	TARGET1_ENABLE_mask                               = 0x0f << 4,
	TARGET1_ENABLE_shift                              = 4,
	TARGET2_ENABLE_mask                               = 0x0f << 8,
	TARGET2_ENABLE_shift                              = 8,
	TARGET3_ENABLE_mask                               = 0x0f << 12,
	TARGET3_ENABLE_shift                              = 12,
	TARGET4_ENABLE_mask                               = 0x0f << 16,
	TARGET4_ENABLE_shift                              = 16,
	TARGET5_ENABLE_mask                               = 0x0f << 20,
	TARGET5_ENABLE_shift                              = 20,
	TARGET6_ENABLE_mask                               = 0x0f << 24,
	TARGET6_ENABLE_shift                              = 24,
	TARGET7_ENABLE_mask                               = 0x0f << 28,
	TARGET7_ENABLE_shift                              = 28,
    CB_SHADER_MASK                                        = 0x0002823c,
	OUTPUT0_ENABLE_mask                               = 0x0f << 0,
	OUTPUT0_ENABLE_shift                              = 0,
	OUTPUT1_ENABLE_mask                               = 0x0f << 4,
	OUTPUT1_ENABLE_shift                              = 4,
	OUTPUT2_ENABLE_mask                               = 0x0f << 8,
	OUTPUT2_ENABLE_shift                              = 8,
	OUTPUT3_ENABLE_mask                               = 0x0f << 12,
	OUTPUT3_ENABLE_shift                              = 12,
	OUTPUT4_ENABLE_mask                               = 0x0f << 16,
	OUTPUT4_ENABLE_shift                              = 16,
	OUTPUT5_ENABLE_mask                               = 0x0f << 20,
	OUTPUT5_ENABLE_shift                              = 20,
	OUTPUT6_ENABLE_mask                               = 0x0f << 24,
	OUTPUT6_ENABLE_shift                              = 24,
	OUTPUT7_ENABLE_mask                               = 0x0f << 28,
	OUTPUT7_ENABLE_shift                              = 28,
    PA_SC_GENERIC_SCISSOR_TL                              = 0x00028240,
	PA_SC_GENERIC_SCISSOR_TL__TL_X_mask               = 0x7fff << 0,
	PA_SC_GENERIC_SCISSOR_TL__TL_X_shift              = 0,
	PA_SC_GENERIC_SCISSOR_TL__TL_Y_mask               = 0x7fff << 16,
	PA_SC_GENERIC_SCISSOR_TL__TL_Y_shift              = 16,
/* 	WINDOW_OFFSET_DISABLE_bit                         = 1 << 31, */
    PA_SC_GENERIC_SCISSOR_BR                              = 0x00028244,
	PA_SC_GENERIC_SCISSOR_BR__BR_X_mask               = 0x7fff << 0,
	PA_SC_GENERIC_SCISSOR_BR__BR_X_shift              = 0,
	PA_SC_GENERIC_SCISSOR_BR__BR_Y_mask               = 0x7fff << 16,
	PA_SC_GENERIC_SCISSOR_BR__BR_Y_shift              = 16,
    PA_SC_VPORT_SCISSOR_0_TL                              = 0x00028250,
	PA_SC_VPORT_SCISSOR_0_TL_num                      = 16,
	PA_SC_VPORT_SCISSOR_0_TL_offset                   = 8,
	PA_SC_VPORT_SCISSOR_0_TL__TL_X_mask               = 0x7fff << 0,
	PA_SC_VPORT_SCISSOR_0_TL__TL_X_shift              = 0,
	PA_SC_VPORT_SCISSOR_0_TL__TL_Y_mask               = 0x7fff << 16,
	PA_SC_VPORT_SCISSOR_0_TL__TL_Y_shift              = 16,
/* 	WINDOW_OFFSET_DISABLE_bit                         = 1 << 31, */
    PA_SC_VPORT_SCISSOR_0_BR                              = 0x00028254,
	PA_SC_VPORT_SCISSOR_0_BR_num                      = 16,
	PA_SC_VPORT_SCISSOR_0_BR_offset                   = 8,
	PA_SC_VPORT_SCISSOR_0_BR__BR_X_mask               = 0x7fff << 0,
	PA_SC_VPORT_SCISSOR_0_BR__BR_X_shift              = 0,
	PA_SC_VPORT_SCISSOR_0_BR__BR_Y_mask               = 0x7fff << 16,
	PA_SC_VPORT_SCISSOR_0_BR__BR_Y_shift              = 16,
    PA_SC_VPORT_ZMIN_0                                    = 0x000282d0,
	PA_SC_VPORT_ZMIN_0_num                            = 16,
	PA_SC_VPORT_ZMIN_0_offset                         = 8,
    PA_SC_VPORT_ZMAX_0                                    = 0x000282d4,
	PA_SC_VPORT_ZMAX_0_num                            = 16,
	PA_SC_VPORT_ZMAX_0_offset                         = 8,
    SX_MISC                                               = 0x00028350,
	MULTIPASS_bit                                     = 1 << 0,
    SX_SURFACE_SYNC                                       = 0x00028354,
	SURFACE_SYNC_MASK_mask                            = 0x3ff << 0,
	SURFACE_SYNC_MASK_shift                           = 0,
    SX_SCATTER_EXPORT_BASE                                = 0x00028358,
    SX_SCATTER_EXPORT_SIZE                                = 0x0002835c,
    SQ_VTX_SEMANTIC_0                                     = 0x00028380,
	SQ_VTX_SEMANTIC_0_num                             = 32,
/* 	SEMANTIC_ID_mask                                  = 0xff << 0, */
/* 	SEMANTIC_ID_shift                                 = 0, */
    VGT_MAX_VTX_INDX                                      = 0x00028400,
    VGT_MIN_VTX_INDX                                      = 0x00028404,
    VGT_INDX_OFFSET                                       = 0x00028408,
    VGT_MULTI_PRIM_IB_RESET_INDX                          = 0x0002840c,
    SX_ALPHA_TEST_CONTROL                                 = 0x00028410,
	ALPHA_FUNC_mask                                   = 0x07 << 0,
	ALPHA_FUNC_shift                                  = 0,
	    REF_NEVER                                     = 0x00,
	    REF_LESS                                      = 0x01,
	    REF_EQUAL                                     = 0x02,
	    REF_LEQUAL                                    = 0x03,
	    REF_GREATER                                   = 0x04,
	    REF_NOTEQUAL                                  = 0x05,
	    REF_GEQUAL                                    = 0x06,
	    REF_ALWAYS                                    = 0x07,
	ALPHA_TEST_ENABLE_bit                             = 1 << 3,
	ALPHA_TEST_BYPASS_bit                             = 1 << 8,
    CB_BLEND_RED                                          = 0x00028414,
    CB_BLEND_GREEN                                        = 0x00028418,
    CB_BLEND_BLUE                                         = 0x0002841c,
    CB_BLEND_ALPHA                                        = 0x00028420,
    DB_STENCILREFMASK                                     = 0x00028430,
	STENCILREF_mask                                   = 0xff << 0,
	STENCILREF_shift                                  = 0,
	STENCILMASK_mask                                  = 0xff << 8,
	STENCILMASK_shift                                 = 8,
	STENCILWRITEMASK_mask                             = 0xff << 16,
	STENCILWRITEMASK_shift                            = 16,
    DB_STENCILREFMASK_BF                                  = 0x00028434,
	STENCILREF_BF_mask                                = 0xff << 0,
	STENCILREF_BF_shift                               = 0,
	STENCILMASK_BF_mask                               = 0xff << 8,
	STENCILMASK_BF_shift                              = 8,
	STENCILWRITEMASK_BF_mask                          = 0xff << 16,
	STENCILWRITEMASK_BF_shift                         = 16,
    SX_ALPHA_REF                                          = 0x00028438,
    PA_CL_VPORT_XSCALE_0                                  = 0x0002843c,
	PA_CL_VPORT_XSCALE_0_num                          = 16,
	PA_CL_VPORT_XSCALE_0_offset                       = 24,
    PA_CL_VPORT_XOFFSET_0                                 = 0x00028440,
	PA_CL_VPORT_XOFFSET_0_num                         = 16,
	PA_CL_VPORT_XOFFSET_0_offset                      = 24,
    PA_CL_VPORT_YSCALE_0                                  = 0x00028444,
	PA_CL_VPORT_YSCALE_0_num                          = 16,
	PA_CL_VPORT_YSCALE_0_offset                       = 24,
    PA_CL_VPORT_YOFFSET_0                                 = 0x00028448,
	PA_CL_VPORT_YOFFSET_0_num                         = 16,
	PA_CL_VPORT_YOFFSET_0_offset                      = 24,
    PA_CL_VPORT_ZSCALE_0                                  = 0x0002844c,
	PA_CL_VPORT_ZSCALE_0_num                          = 16,
	PA_CL_VPORT_ZSCALE_0_offset                       = 24,
    PA_CL_VPORT_ZOFFSET_0                                 = 0x00028450,
	PA_CL_VPORT_ZOFFSET_0_num                         = 16,
	PA_CL_VPORT_ZOFFSET_0_offset                      = 24,
    PA_CL_UCP_0_X                                         = 0x000285bc,
	PA_CL_UCP_0_X_num                                 = 6,
	PA_CL_UCP_0_X_offset                              = 16,
    PA_CL_UCP_0_Y                                         = 0x000285c0,
	PA_CL_UCP_0_Y_num                                 = 6,
	PA_CL_UCP_0_Y_offset                              = 16,
    PA_CL_UCP_0_Z                                         = 0x000285c4,
	PA_CL_UCP_0_Z_num                                 = 6,
	PA_CL_UCP_0_Z_offset                              = 16,
    PA_CL_UCP_0_W                                         = 0x000285c8,
	PA_CL_UCP_0_W_num                                 = 6,
	PA_CL_UCP_0_W_offset                              = 16,
    SPI_VS_OUT_ID_0                                       = 0x0002861c,
	SPI_VS_OUT_ID_0_num                               = 10,
	SEMANTIC_0_mask                                   = 0xff << 0,
	SEMANTIC_0_shift                                  = 0,
	SEMANTIC_1_mask                                   = 0xff << 8,
	SEMANTIC_1_shift                                  = 8,
	SEMANTIC_2_mask                                   = 0xff << 16,
	SEMANTIC_2_shift                                  = 16,
	SEMANTIC_3_mask                                   = 0xff << 24,
	SEMANTIC_3_shift                                  = 24,
    SPI_PS_INPUT_CNTL_0                                   = 0x00028644,
	SPI_PS_INPUT_CNTL_0_num                           = 32,
	SEMANTIC_mask                                     = 0xff << 0,
	SEMANTIC_shift                                    = 0,
	DEFAULT_VAL_mask                                  = 0x03 << 8,
	DEFAULT_VAL_shift                                 = 8,
	    X_0_0F                                        = 0x00,
	FLAT_SHADE_bit                                    = 1 << 10,
	CYL_WRAP_mask                                     = 0x0f << 13,
	CYL_WRAP_shift                                    = 13,
	PT_SPRITE_TEX_bit                                 = 1 << 17,
    SPI_VS_OUT_CONFIG                                     = 0x000286c4,
	VS_PER_COMPONENT_bit                              = 1 << 0,
	VS_EXPORT_COUNT_mask                              = 0x1f << 1,
	VS_EXPORT_COUNT_shift                             = 1,
	VS_HALF_PACK_bit                                  = 1 << 6,
	VS_EXPORTS_FOG_bit                                = 1 << 8,
	VS_OUT_FOG_VEC_ADDR_mask                          = 0x1f << 9,
	VS_OUT_FOG_VEC_ADDR_shift                         = 9,
    SPI_PS_IN_CONTROL_0                                   = 0x000286cc,
	NUM_INTERP_mask                                   = 0x3f << 0,
	NUM_INTERP_shift                                  = 0,
	POSITION_ENA_bit                                  = 1 << 8,
	POSITION_CENTROID_bit                             = 1 << 9,
	POSITION_ADDR_mask                                = 0x1f << 10,
	POSITION_ADDR_shift                               = 10,
	PARAM_GEN_mask                                    = 0x0f << 15,
	PARAM_GEN_shift                                   = 15,
	PERSP_GRADIENT_ENA_bit                            = 1 << 28,
	LINEAR_GRADIENT_ENA_bit                           = 1 << 29,
	POSITION_SAMPLE_bit                               = 1 << 30,
    SPI_PS_IN_CONTROL_1                                   = 0x000286d0,
	FRONT_FACE_ENA_bit                                = 1 << 8,
	FRONT_FACE_ALL_BITS_bit                           = 1 << 11,
	FRONT_FACE_ADDR_mask                              = 0x1f << 12,
	FRONT_FACE_ADDR_shift                             = 12,
	FOG_ADDR_mask                                     = 0x7f << 17,
	FOG_ADDR_shift                                    = 17,
	FIXED_PT_POSITION_ENA_bit                         = 1 << 24,
	FIXED_PT_POSITION_ADDR_mask                       = 0x1f << 25,
	FIXED_PT_POSITION_ADDR_shift                      = 25,
	POSITION_ULC_bit                                  = 1 << 30,
    SPI_INTERP_CONTROL_0                                  = 0x000286d4,
	FLAT_SHADE_ENA_bit                                = 1 << 0,
	PNT_SPRITE_ENA_bit                                = 1 << 1,
	PNT_SPRITE_OVRD_X_mask                            = 0x07 << 2,
	PNT_SPRITE_OVRD_X_shift                           = 2,
	    SPI_PNT_SPRITE_SEL_0                          = 0x00,
	    SPI_PNT_SPRITE_SEL_1                          = 0x01,
	    SPI_PNT_SPRITE_SEL_S                          = 0x02,
	    SPI_PNT_SPRITE_SEL_T                          = 0x03,
	    SPI_PNT_SPRITE_SEL_NONE                       = 0x04,
	PNT_SPRITE_OVRD_Y_mask                            = 0x07 << 5,
	PNT_SPRITE_OVRD_Y_shift                           = 5,
/* 	    SPI_PNT_SPRITE_SEL_0                          = 0x00, */
/* 	    SPI_PNT_SPRITE_SEL_1                          = 0x01, */
/* 	    SPI_PNT_SPRITE_SEL_S                          = 0x02, */
/* 	    SPI_PNT_SPRITE_SEL_T                          = 0x03, */
/* 	    SPI_PNT_SPRITE_SEL_NONE                       = 0x04, */
	PNT_SPRITE_OVRD_Z_mask                            = 0x07 << 8,
	PNT_SPRITE_OVRD_Z_shift                           = 8,
/* 	    SPI_PNT_SPRITE_SEL_0                          = 0x00, */
/* 	    SPI_PNT_SPRITE_SEL_1                          = 0x01, */
/* 	    SPI_PNT_SPRITE_SEL_S                          = 0x02, */
/* 	    SPI_PNT_SPRITE_SEL_T                          = 0x03, */
/* 	    SPI_PNT_SPRITE_SEL_NONE                       = 0x04, */
	PNT_SPRITE_OVRD_W_mask                            = 0x07 << 11,
	PNT_SPRITE_OVRD_W_shift                           = 11,
/* 	    SPI_PNT_SPRITE_SEL_0                          = 0x00, */
/* 	    SPI_PNT_SPRITE_SEL_1                          = 0x01, */
/* 	    SPI_PNT_SPRITE_SEL_S                          = 0x02, */
/* 	    SPI_PNT_SPRITE_SEL_T                          = 0x03, */
/* 	    SPI_PNT_SPRITE_SEL_NONE                       = 0x04, */
	PNT_SPRITE_TOP_1_bit                              = 1 << 14,
    SPI_INPUT_Z                                           = 0x000286d8,
	PROVIDE_Z_TO_SPI_bit                              = 1 << 0,
    SPI_FOG_CNTL                                          = 0x000286dc,
	PASS_FOG_THROUGH_PS_bit                           = 1 << 0,
    SPI_BARYC_CNTL                                        = 0x000286e0,
	PERSP_CENTER_ENA_mask                             = 0x03 << 0,
	PERSP_CENTER_ENA_shift                            = 0,
	    X_OFF                                         = 0x00,
	    PERSP_CENTER_ENA__X_ON_AT_CENTER              = 0x01,
	    PERSP_CENTER_ENA__X_ON_AT_CENTROID            = 0x02,
	PERSP_CENTROID_ENA_mask                           = 0x03 << 4,
	PERSP_CENTROID_ENA_shift                          = 4,
/* 	    X_OFF                                         = 0x00, */
	    PERSP_CENTROID_ENA__X_ON_AT_CENTROID          = 0x01,
	    PERSP_CENTROID_ENA__X_ON_AT_CENTER            = 0x02,
	PERSP_SAMPLE_ENA_mask                             = 0x03 << 8,
	PERSP_SAMPLE_ENA_shift                            = 8,
/* 	    X_OFF                                         = 0x00, */
	PERSP_PULL_MODEL_ENA_mask                         = 0x03 << 12,
	PERSP_PULL_MODEL_ENA_shift                        = 12,
/* 	    X_OFF                                         = 0x00, */
	LINEAR_CENTER_ENA_mask                            = 0x03 << 16,
	LINEAR_CENTER_ENA_shift                           = 16,
/* 	    X_OFF                                         = 0x00, */
	    LINEAR_CENTER_ENA__X_ON_AT_CENTER             = 0x01,
	    LINEAR_CENTER_ENA__X_ON_AT_CENTROID           = 0x02,
	LINEAR_CENTROID_ENA_mask                          = 0x03 << 20,
	LINEAR_CENTROID_ENA_shift                         = 20,
/* 	    X_OFF                                         = 0x00, */
	    LINEAR_CENTROID_ENA__X_ON_AT_CENTROID         = 0x01,
	    LINEAR_CENTROID_ENA__X_ON_AT_CENTER           = 0x02,
	LINEAR_SAMPLE_ENA_mask                            = 0x03 << 24,
	LINEAR_SAMPLE_ENA_shift                           = 24,
/* 	    X_OFF                                         = 0x00, */
    SPI_PS_IN_CONTROL_2                                   = 0x000286e4,
	LINE_STIPPLE_TEX_ADDR_mask                        = 0xff << 0,
	LINE_STIPPLE_TEX_ADDR_shift                       = 0,
	LINE_STIPPLE_TEX_ENA_bit                          = 1 << 8,
    SPI_GPR_MGMT                                          = 0x000286f8,
	SPI_GPR_MGMT__NUM_PS_GPRS_mask                    = 0x1f << 0,
	SPI_GPR_MGMT__NUM_PS_GPRS_shift                   = 0,
	SPI_GPR_MGMT__NUM_VS_GPRS_mask                    = 0x1f << 5,
	SPI_GPR_MGMT__NUM_VS_GPRS_shift                   = 5,
	NUM_GS_GPRS_mask                                  = 0x1f << 10,
	NUM_GS_GPRS_shift                                 = 10,
	NUM_ES_GPRS_mask                                  = 0x1f << 15,
	NUM_ES_GPRS_shift                                 = 15,
	NUM_HS_GPRS_mask                                  = 0x1f << 20,
	NUM_HS_GPRS_shift                                 = 20,
	NUM_LS_GPRS_mask                                  = 0x1f << 25,
	NUM_LS_GPRS_shift                                 = 25,
    SPI_LDS_MGMT                                          = 0x000286fc,
	NUM_PS_LDS_mask                                   = 0xff << 0,
	NUM_PS_LDS_shift                                  = 0,
	NUM_LS_LDS_mask                                   = 0xff << 8,
	NUM_LS_LDS_shift                                  = 8,
    SPI_STACK_MGMT                                        = 0x00028700,
	NUM_PS_STACK_mask                                 = 0x1f << 0,
	NUM_PS_STACK_shift                                = 0,
	NUM_VS_STACK_mask                                 = 0x1f << 5,
	NUM_VS_STACK_shift                                = 5,
	NUM_GS_STACK_mask                                 = 0x1f << 10,
	NUM_GS_STACK_shift                                = 10,
	NUM_ES_STACK_mask                                 = 0x1f << 15,
	NUM_ES_STACK_shift                                = 15,
	NUM_HS_STACK_mask                                 = 0x1f << 20,
	NUM_HS_STACK_shift                                = 20,
	NUM_LS_STACK_mask                                 = 0x1f << 25,
	NUM_LS_STACK_shift                                = 25,
    SPI_WAVE_MGMT_1                                       = 0x00028704,
	NUM_PS_WAVES_mask                                 = 0x1f << 0,
	NUM_PS_WAVES_shift                                = 0,
	NUM_VS_WAVES_mask                                 = 0x1f << 5,
	NUM_VS_WAVES_shift                                = 5,
	NUM_GS_WAVES_mask                                 = 0x1f << 10,
	NUM_GS_WAVES_shift                                = 10,
	NUM_ES_WAVES_mask                                 = 0x1f << 15,
	NUM_ES_WAVES_shift                                = 15,
	NUM_HS_WAVES_mask                                 = 0x1f << 20,
	NUM_HS_WAVES_shift                                = 20,
	NUM_LS_WAVES_mask                                 = 0x1f << 25,
	NUM_LS_WAVES_shift                                = 25,
    SPI_WAVE_MGMT_2                                       = 0x00028708,
	NUM_CS_WAVES_ONE_RING_mask                        = 0x1f << 0,
	NUM_CS_WAVES_ONE_RING_shift                       = 0,
	NUM_CS_WAVES_MULTI_RING_mask                      = 0x1f << 5,
	NUM_CS_WAVES_MULTI_RING_shift                     = 5,
    CB_BLEND0_CONTROL                                     = 0x00028780,
	CB_BLEND0_CONTROL_num                             = 8,
	COLOR_SRCBLEND_mask                               = 0x1f << 0,
	COLOR_SRCBLEND_shift                              = 0,
	    BLEND_ZERO                                    = 0x00,
	    BLEND_ONE                                     = 0x01,
	    BLEND_SRC_COLOR                               = 0x02,
	    BLEND_ONE_MINUS_SRC_COLOR                     = 0x03,
	    BLEND_SRC_ALPHA                               = 0x04,
	    BLEND_ONE_MINUS_SRC_ALPHA                     = 0x05,
	    BLEND_DST_ALPHA                               = 0x06,
	    BLEND_ONE_MINUS_DST_ALPHA                     = 0x07,
	    BLEND_DST_COLOR                               = 0x08,
	    BLEND_ONE_MINUS_DST_COLOR                     = 0x09,
	    BLEND_SRC_ALPHA_SATURATE                      = 0x0a,
	    BLEND_BOTH_SRC_ALPHA                          = 0x0b,
	    BLEND_BOTH_INV_SRC_ALPHA                      = 0x0c,
	    BLEND_CONSTANT_COLOR                          = 0x0d,
	    BLEND_ONE_MINUS_CONSTANT_COLOR                = 0x0e,
	    BLEND_SRC1_COLOR                              = 0x0f,
	    BLEND_INV_SRC1_COLOR                          = 0x10,
	    BLEND_SRC1_ALPHA                              = 0x11,
	    BLEND_INV_SRC1_ALPHA                          = 0x12,
	    BLEND_CONSTANT_ALPHA                          = 0x13,
	    BLEND_ONE_MINUS_CONSTANT_ALPHA                = 0x14,
	COLOR_COMB_FCN_mask                               = 0x07 << 5,
	COLOR_COMB_FCN_shift                              = 5,
	    COMB_DST_PLUS_SRC                             = 0x00,
	    COMB_SRC_MINUS_DST                            = 0x01,
	    COMB_MIN_DST_SRC                              = 0x02,
	    COMB_MAX_DST_SRC                              = 0x03,
	    COMB_DST_MINUS_SRC                            = 0x04,
	COLOR_DESTBLEND_mask                              = 0x1f << 8,
	COLOR_DESTBLEND_shift                             = 8,
/* 	    BLEND_ZERO                                    = 0x00, */
/* 	    BLEND_ONE                                     = 0x01, */
/* 	    BLEND_SRC_COLOR                               = 0x02, */
/* 	    BLEND_ONE_MINUS_SRC_COLOR                     = 0x03, */
/* 	    BLEND_SRC_ALPHA                               = 0x04, */
/* 	    BLEND_ONE_MINUS_SRC_ALPHA                     = 0x05, */
/* 	    BLEND_DST_ALPHA                               = 0x06, */
/* 	    BLEND_ONE_MINUS_DST_ALPHA                     = 0x07, */
/* 	    BLEND_DST_COLOR                               = 0x08, */
/* 	    BLEND_ONE_MINUS_DST_COLOR                     = 0x09, */
/* 	    BLEND_SRC_ALPHA_SATURATE                      = 0x0a, */
/* 	    BLEND_BOTH_SRC_ALPHA                          = 0x0b, */
/* 	    BLEND_BOTH_INV_SRC_ALPHA                      = 0x0c, */
/* 	    BLEND_CONSTANT_COLOR                          = 0x0d, */
/* 	    BLEND_ONE_MINUS_CONSTANT_COLOR                = 0x0e, */
/* 	    BLEND_SRC1_COLOR                              = 0x0f, */
/* 	    BLEND_INV_SRC1_COLOR                          = 0x10, */
/* 	    BLEND_SRC1_ALPHA                              = 0x11, */
/* 	    BLEND_INV_SRC1_ALPHA                          = 0x12, */
/* 	    BLEND_CONSTANT_ALPHA                          = 0x13, */
/* 	    BLEND_ONE_MINUS_CONSTANT_ALPHA                = 0x14, */
	ALPHA_SRCBLEND_mask                               = 0x1f << 16,
	ALPHA_SRCBLEND_shift                              = 16,
/* 	    BLEND_ZERO                                    = 0x00, */
/* 	    BLEND_ONE                                     = 0x01, */
/* 	    BLEND_SRC_COLOR                               = 0x02, */
/* 	    BLEND_ONE_MINUS_SRC_COLOR                     = 0x03, */
/* 	    BLEND_SRC_ALPHA                               = 0x04, */
/* 	    BLEND_ONE_MINUS_SRC_ALPHA                     = 0x05, */
/* 	    BLEND_DST_ALPHA                               = 0x06, */
/* 	    BLEND_ONE_MINUS_DST_ALPHA                     = 0x07, */
/* 	    BLEND_DST_COLOR                               = 0x08, */
/* 	    BLEND_ONE_MINUS_DST_COLOR                     = 0x09, */
/* 	    BLEND_SRC_ALPHA_SATURATE                      = 0x0a, */
/* 	    BLEND_BOTH_SRC_ALPHA                          = 0x0b, */
/* 	    BLEND_BOTH_INV_SRC_ALPHA                      = 0x0c, */
/* 	    BLEND_CONSTANT_COLOR                          = 0x0d, */
/* 	    BLEND_ONE_MINUS_CONSTANT_COLOR                = 0x0e, */
/* 	    BLEND_SRC1_COLOR                              = 0x0f, */
/* 	    BLEND_INV_SRC1_COLOR                          = 0x10, */
/* 	    BLEND_SRC1_ALPHA                              = 0x11, */
/* 	    BLEND_INV_SRC1_ALPHA                          = 0x12, */
/* 	    BLEND_CONSTANT_ALPHA                          = 0x13, */
/* 	    BLEND_ONE_MINUS_CONSTANT_ALPHA                = 0x14, */
	ALPHA_COMB_FCN_mask                               = 0x07 << 21,
	ALPHA_COMB_FCN_shift                              = 21,
/* 	    COMB_DST_PLUS_SRC                             = 0x00, */
/* 	    COMB_SRC_MINUS_DST                            = 0x01, */
/* 	    COMB_MIN_DST_SRC                              = 0x02, */
/* 	    COMB_MAX_DST_SRC                              = 0x03, */
/* 	    COMB_DST_MINUS_SRC                            = 0x04, */
	ALPHA_DESTBLEND_mask                              = 0x1f << 24,
	ALPHA_DESTBLEND_shift                             = 24,
/* 	    BLEND_ZERO                                    = 0x00, */
/* 	    BLEND_ONE                                     = 0x01, */
/* 	    BLEND_SRC_COLOR                               = 0x02, */
/* 	    BLEND_ONE_MINUS_SRC_COLOR                     = 0x03, */
/* 	    BLEND_SRC_ALPHA                               = 0x04, */
/* 	    BLEND_ONE_MINUS_SRC_ALPHA                     = 0x05, */
/* 	    BLEND_DST_ALPHA                               = 0x06, */
/* 	    BLEND_ONE_MINUS_DST_ALPHA                     = 0x07, */
/* 	    BLEND_DST_COLOR                               = 0x08, */
/* 	    BLEND_ONE_MINUS_DST_COLOR                     = 0x09, */
/* 	    BLEND_SRC_ALPHA_SATURATE                      = 0x0a, */
/* 	    BLEND_BOTH_SRC_ALPHA                          = 0x0b, */
/* 	    BLEND_BOTH_INV_SRC_ALPHA                      = 0x0c, */
/* 	    BLEND_CONSTANT_COLOR                          = 0x0d, */
/* 	    BLEND_ONE_MINUS_CONSTANT_COLOR                = 0x0e, */
/* 	    BLEND_SRC1_COLOR                              = 0x0f, */
/* 	    BLEND_INV_SRC1_COLOR                          = 0x10, */
/* 	    BLEND_SRC1_ALPHA                              = 0x11, */
/* 	    BLEND_INV_SRC1_ALPHA                          = 0x12, */
/* 	    BLEND_CONSTANT_ALPHA                          = 0x13, */
/* 	    BLEND_ONE_MINUS_CONSTANT_ALPHA                = 0x14, */
	SEPARATE_ALPHA_BLEND_bit                          = 1 << 29,
	CB_BLEND0_CONTROL__ENABLE_bit                     = 1 << 30,
    PA_CL_POINT_X_RAD                                     = 0x000287d4,
    PA_CL_POINT_Y_RAD                                     = 0x000287d8,
    PA_CL_POINT_SIZE                                      = 0x000287dc,
    PA_CL_POINT_CULL_RAD                                  = 0x000287e0,
    VGT_DMA_BASE_HI                                       = 0x000287e4,
	VGT_DMA_BASE_HI__BASE_ADDR_mask                   = 0xff << 0,
	VGT_DMA_BASE_HI__BASE_ADDR_shift                  = 0,
    VGT_DMA_BASE                                          = 0x000287e8,
    VGT_DRAW_INITIATOR                                    = 0x000287f0,
	SOURCE_SELECT_mask                                = 0x03 << 0,
	SOURCE_SELECT_shift                               = 0,
	    DI_SRC_SEL_DMA                                = 0x00,
	    DI_SRC_SEL_IMMEDIATE                          = 0x01,
	    DI_SRC_SEL_AUTO_INDEX                         = 0x02,
	    DI_SRC_SEL_RESERVED                           = 0x03,
	MAJOR_MODE_mask                                   = 0x03 << 2,
	MAJOR_MODE_shift                                  = 2,
	    DI_MAJOR_MODE_0                               = 0x00,
	    DI_MAJOR_MODE_1                               = 0x01,
	NOT_EOP_bit                                       = 1 << 5,
	USE_OPAQUE_bit                                    = 1 << 6,
    VGT_IMMED_DATA                                        = 0x000287f4,
    VGT_EVENT_ADDRESS_REG                                 = 0x000287f8,
	ADDRESS_LOW_mask                                  = 0xfffffff << 0,
	ADDRESS_LOW_shift                                 = 0,
    DB_DEPTH_CONTROL                                      = 0x00028800,
	STENCIL_ENABLE_bit                                = 1 << 0,
	Z_ENABLE_bit                                      = 1 << 1,
	Z_WRITE_ENABLE_bit                                = 1 << 2,
	ZFUNC_mask                                        = 0x07 << 4,
	ZFUNC_shift                                       = 4,
	    FRAG_NEVER                                    = 0x00,
	    FRAG_LESS                                     = 0x01,
	    FRAG_EQUAL                                    = 0x02,
	    FRAG_LEQUAL                                   = 0x03,
	    FRAG_GREATER                                  = 0x04,
	    FRAG_NOTEQUAL                                 = 0x05,
	    FRAG_GEQUAL                                   = 0x06,
	    FRAG_ALWAYS                                   = 0x07,
	BACKFACE_ENABLE_bit                               = 1 << 7,
	STENCILFUNC_mask                                  = 0x07 << 8,
	STENCILFUNC_shift                                 = 8,
/* 	    REF_NEVER                                     = 0x00, */
/* 	    REF_LESS                                      = 0x01, */
/* 	    REF_EQUAL                                     = 0x02, */
/* 	    REF_LEQUAL                                    = 0x03, */
/* 	    REF_GREATER                                   = 0x04, */
/* 	    REF_NOTEQUAL                                  = 0x05, */
/* 	    REF_GEQUAL                                    = 0x06, */
/* 	    REF_ALWAYS                                    = 0x07, */
	STENCILFAIL_mask                                  = 0x07 << 11,
	STENCILFAIL_shift                                 = 11,
	    STENCIL_KEEP                                  = 0x00,
	    STENCIL_ZERO                                  = 0x01,
	    STENCIL_REPLACE                               = 0x02,
	    STENCIL_INCR_CLAMP                            = 0x03,
	    STENCIL_DECR_CLAMP                            = 0x04,
	    STENCIL_INVERT                                = 0x05,
	    STENCIL_INCR_WRAP                             = 0x06,
	    STENCIL_DECR_WRAP                             = 0x07,
	STENCILZPASS_mask                                 = 0x07 << 14,
	STENCILZPASS_shift                                = 14,
/* 	    STENCIL_KEEP                                  = 0x00, */
/* 	    STENCIL_ZERO                                  = 0x01, */
/* 	    STENCIL_REPLACE                               = 0x02, */
/* 	    STENCIL_INCR_CLAMP                            = 0x03, */
/* 	    STENCIL_DECR_CLAMP                            = 0x04, */
/* 	    STENCIL_INVERT                                = 0x05, */
/* 	    STENCIL_INCR_WRAP                             = 0x06, */
/* 	    STENCIL_DECR_WRAP                             = 0x07, */
	STENCILZFAIL_mask                                 = 0x07 << 17,
	STENCILZFAIL_shift                                = 17,
/* 	    STENCIL_KEEP                                  = 0x00, */
/* 	    STENCIL_ZERO                                  = 0x01, */
/* 	    STENCIL_REPLACE                               = 0x02, */
/* 	    STENCIL_INCR_CLAMP                            = 0x03, */
/* 	    STENCIL_DECR_CLAMP                            = 0x04, */
/* 	    STENCIL_INVERT                                = 0x05, */
/* 	    STENCIL_INCR_WRAP                             = 0x06, */
/* 	    STENCIL_DECR_WRAP                             = 0x07, */
	STENCILFUNC_BF_mask                               = 0x07 << 20,
	STENCILFUNC_BF_shift                              = 20,
/* 	    REF_NEVER                                     = 0x00, */
/* 	    REF_LESS                                      = 0x01, */
/* 	    REF_EQUAL                                     = 0x02, */
/* 	    REF_LEQUAL                                    = 0x03, */
/* 	    REF_GREATER                                   = 0x04, */
/* 	    REF_NOTEQUAL                                  = 0x05, */
/* 	    REF_GEQUAL                                    = 0x06, */
/* 	    REF_ALWAYS                                    = 0x07, */
	STENCILFAIL_BF_mask                               = 0x07 << 23,
	STENCILFAIL_BF_shift                              = 23,
/* 	    STENCIL_KEEP                                  = 0x00, */
/* 	    STENCIL_ZERO                                  = 0x01, */
/* 	    STENCIL_REPLACE                               = 0x02, */
/* 	    STENCIL_INCR_CLAMP                            = 0x03, */
/* 	    STENCIL_DECR_CLAMP                            = 0x04, */
/* 	    STENCIL_INVERT                                = 0x05, */
/* 	    STENCIL_INCR_WRAP                             = 0x06, */
/* 	    STENCIL_DECR_WRAP                             = 0x07, */
	STENCILZPASS_BF_mask                              = 0x07 << 26,
	STENCILZPASS_BF_shift                             = 26,
/* 	    STENCIL_KEEP                                  = 0x00, */
/* 	    STENCIL_ZERO                                  = 0x01, */
/* 	    STENCIL_REPLACE                               = 0x02, */
/* 	    STENCIL_INCR_CLAMP                            = 0x03, */
/* 	    STENCIL_DECR_CLAMP                            = 0x04, */
/* 	    STENCIL_INVERT                                = 0x05, */
/* 	    STENCIL_INCR_WRAP                             = 0x06, */
/* 	    STENCIL_DECR_WRAP                             = 0x07, */
	STENCILZFAIL_BF_mask                              = 0x07 << 29,
	STENCILZFAIL_BF_shift                             = 29,
/* 	    STENCIL_KEEP                                  = 0x00, */
/* 	    STENCIL_ZERO                                  = 0x01, */
/* 	    STENCIL_REPLACE                               = 0x02, */
/* 	    STENCIL_INCR_CLAMP                            = 0x03, */
/* 	    STENCIL_DECR_CLAMP                            = 0x04, */
/* 	    STENCIL_INVERT                                = 0x05, */
/* 	    STENCIL_INCR_WRAP                             = 0x06, */
/* 	    STENCIL_DECR_WRAP                             = 0x07, */
    DB_EQAA                                               = 0x00028804,
    CB_COLOR_CONTROL                                      = 0x00028808,
	DEGAMMA_ENABLE_bit                                = 1 << 3,
	CB_COLOR_CONTROL__MODE_mask                       = 0x07 << 4,
	CB_COLOR_CONTROL__MODE_shift                      = 4,
	    CB_DISABLE                                    = 0x00,
	    CB_NORMAL                                     = 0x01,
	    CB_ELIMINATE_FAST_CLEAR                       = 0x02,
	    CB_RESOLVE                                    = 0x03,
	    CB_DECOMPRESS                                 = 0x04,
	    CB_FMASK_DECOMPRESS                           = 0x05,
	ROP3_mask                                         = 0xff << 16,
	ROP3_shift                                        = 16,
	    X_0X00                                        = 0x00,
	    X_0X05                                        = 0x05,
	    X_0X0A                                        = 0x0a,
	    X_0X0F                                        = 0x0f,
	    X_0X11                                        = 0x11,
	    X_0X22                                        = 0x22,
	    X_0X33                                        = 0x33,
	    X_0X44                                        = 0x44,
	    X_0X50                                        = 0x50,
	    X_0X55                                        = 0x55,
	    X_0X5A                                        = 0x5a,
	    X_0X5F                                        = 0x5f,
	    X_0X66                                        = 0x66,
	    X_0X77                                        = 0x77,
	    X_0X88                                        = 0x88,
	    X_0X99                                        = 0x99,
	    X_0XA0                                        = 0xa0,
	    X_0XA5                                        = 0xa5,
	    X_0XAA                                        = 0xaa,
	    X_0XAF                                        = 0xaf,
	    X_0XBB                                        = 0xbb,
	    X_0XCC                                        = 0xcc,
	    X_0XDD                                        = 0xdd,
	    X_0XEE                                        = 0xee,
	    X_0XF0                                        = 0xf0,
	    X_0XF5                                        = 0xf5,
	    X_0XFA                                        = 0xfa,
	    X_0XFF                                        = 0xff,
    DB_SHADER_CONTROL                                     = 0x0002880c,
	Z_EXPORT_ENABLE_bit                               = 1 << 0,
	STENCIL_REF_EXPORT_ENABLE_bit                     = 1 << 1,
	Z_ORDER_mask                                      = 0x03 << 4,
	Z_ORDER_shift                                     = 4,
	    LATE_Z                                        = 0x00,
	    EARLY_Z_THEN_LATE_Z                           = 0x01,
	    RE_Z                                          = 0x02,
	    EARLY_Z_THEN_RE_Z                             = 0x03,
	KILL_ENABLE_bit                                   = 1 << 6,
	COVERAGE_TO_MASK_ENABLE_bit                       = 1 << 7,
	MASK_EXPORT_ENABLE_bit                            = 1 << 8,
	DUAL_EXPORT_ENABLE_bit                            = 1 << 9,
	EXEC_ON_HIER_FAIL_bit                             = 1 << 10,
	EXEC_ON_NOOP_bit                                  = 1 << 11,
	ALPHA_TO_MASK_DISABLE_bit                         = 1 << 12,
	DB_SOURCE_FORMAT_mask                             = 0x03 << 13,
	DB_SOURCE_FORMAT_shift                            = 13,
	    EXPORT_DB_FULL                                = 0x00,
	    EXPORT_DB_FOUR16                              = 0x01,
	    EXPORT_DB_TWO                                 = 0x02,
	DEPTH_BEFORE_SHADER_bit                           = 1 << 15,
	CONSERVATIVE_Z_EXPORT_mask                        = 0x03 << 16,
	CONSERVATIVE_Z_EXPORT_shift                       = 16,
	    EXPORT_ANY_Z                                  = 0x00,
	    EXPORT_LESS_THAN_Z                            = 0x01,
	    EXPORT_GREATER_THAN_Z                         = 0x02,
	    EXPORT_RESERVED                               = 0x03,
    PA_CL_CLIP_CNTL                                       = 0x00028810,
	UCP_ENA_0_bit                                     = 1 << 0,
	UCP_ENA_1_bit                                     = 1 << 1,
	UCP_ENA_2_bit                                     = 1 << 2,
	UCP_ENA_3_bit                                     = 1 << 3,
	UCP_ENA_4_bit                                     = 1 << 4,
	UCP_ENA_5_bit                                     = 1 << 5,
	PS_UCP_Y_SCALE_NEG_bit                            = 1 << 13,
	PS_UCP_MODE_mask                                  = 0x03 << 14,
	PS_UCP_MODE_shift                                 = 14,
	CLIP_DISABLE_bit                                  = 1 << 16,
	UCP_CULL_ONLY_ENA_bit                             = 1 << 17,
	BOUNDARY_EDGE_FLAG_ENA_bit                        = 1 << 18,
	DX_CLIP_SPACE_DEF_bit                             = 1 << 19,
	DIS_CLIP_ERR_DETECT_bit                           = 1 << 20,
	VTX_KILL_OR_bit                                   = 1 << 21,
	DX_RASTERIZATION_KILL_bit                         = 1 << 22,
	DX_LINEAR_ATTR_CLIP_ENA_bit                       = 1 << 24,
	VTE_VPORT_PROVOKE_DISABLE_bit                     = 1 << 25,
	ZCLIP_NEAR_DISABLE_bit                            = 1 << 26,
	ZCLIP_FAR_DISABLE_bit                             = 1 << 27,
    PA_SU_SC_MODE_CNTL                                    = 0x00028814,
	CULL_FRONT_bit                                    = 1 << 0,
	CULL_BACK_bit                                     = 1 << 1,
	FACE_bit                                          = 1 << 2,
	POLY_MODE_mask                                    = 0x03 << 3,
	POLY_MODE_shift                                   = 3,
	    X_DISABLE_POLY_MODE                           = 0x00,
	    X_DUAL_MODE                                   = 0x01,
	POLYMODE_FRONT_PTYPE_mask                         = 0x07 << 5,
	POLYMODE_FRONT_PTYPE_shift                        = 5,
	    X_DRAW_POINTS                                 = 0x00,
	    X_DRAW_LINES                                  = 0x01,
	    X_DRAW_TRIANGLES                              = 0x02,
	POLYMODE_BACK_PTYPE_mask                          = 0x07 << 8,
	POLYMODE_BACK_PTYPE_shift                         = 8,
/* 	    X_DRAW_POINTS                                 = 0x00, */
/* 	    X_DRAW_LINES                                  = 0x01, */
/* 	    X_DRAW_TRIANGLES                              = 0x02, */
	POLY_OFFSET_FRONT_ENABLE_bit                      = 1 << 11,
	POLY_OFFSET_BACK_ENABLE_bit                       = 1 << 12,
	POLY_OFFSET_PARA_ENABLE_bit                       = 1 << 13,
	VTX_WINDOW_OFFSET_ENABLE_bit                      = 1 << 16,
	PROVOKING_VTX_LAST_bit                            = 1 << 19,
	PERSP_CORR_DIS_bit                                = 1 << 20,
	MULTI_PRIM_IB_ENA_bit                             = 1 << 21,
    PA_CL_VTE_CNTL                                        = 0x00028818,
	VPORT_X_SCALE_ENA_bit                             = 1 << 0,
	VPORT_X_OFFSET_ENA_bit                            = 1 << 1,
	VPORT_Y_SCALE_ENA_bit                             = 1 << 2,
	VPORT_Y_OFFSET_ENA_bit                            = 1 << 3,
	VPORT_Z_SCALE_ENA_bit                             = 1 << 4,
	VPORT_Z_OFFSET_ENA_bit                            = 1 << 5,
	VTX_XY_FMT_bit                                    = 1 << 8,
	VTX_Z_FMT_bit                                     = 1 << 9,
	VTX_W0_FMT_bit                                    = 1 << 10,
    PA_CL_VS_OUT_CNTL                                     = 0x0002881c,
	CLIP_DIST_ENA_0_bit                               = 1 << 0,
	CLIP_DIST_ENA_1_bit                               = 1 << 1,
	CLIP_DIST_ENA_2_bit                               = 1 << 2,
	CLIP_DIST_ENA_3_bit                               = 1 << 3,
	CLIP_DIST_ENA_4_bit                               = 1 << 4,
	CLIP_DIST_ENA_5_bit                               = 1 << 5,
	CLIP_DIST_ENA_6_bit                               = 1 << 6,
	CLIP_DIST_ENA_7_bit                               = 1 << 7,
	CULL_DIST_ENA_0_bit                               = 1 << 8,
	CULL_DIST_ENA_1_bit                               = 1 << 9,
	CULL_DIST_ENA_2_bit                               = 1 << 10,
	CULL_DIST_ENA_3_bit                               = 1 << 11,
	CULL_DIST_ENA_4_bit                               = 1 << 12,
	CULL_DIST_ENA_5_bit                               = 1 << 13,
	CULL_DIST_ENA_6_bit                               = 1 << 14,
	CULL_DIST_ENA_7_bit                               = 1 << 15,
	USE_VTX_POINT_SIZE_bit                            = 1 << 16,
	USE_VTX_EDGE_FLAG_bit                             = 1 << 17,
	USE_VTX_RENDER_TARGET_INDX_bit                    = 1 << 18,
	USE_VTX_VIEWPORT_INDX_bit                         = 1 << 19,
	USE_VTX_KILL_FLAG_bit                             = 1 << 20,
	VS_OUT_MISC_VEC_ENA_bit                           = 1 << 21,
	VS_OUT_CCDIST0_VEC_ENA_bit                        = 1 << 22,
	VS_OUT_CCDIST1_VEC_ENA_bit                        = 1 << 23,
    PA_CL_NANINF_CNTL                                     = 0x00028820,
	VTE_XY_INF_DISCARD_bit                            = 1 << 0,
	VTE_Z_INF_DISCARD_bit                             = 1 << 1,
	VTE_W_INF_DISCARD_bit                             = 1 << 2,
	VTE_0XNANINF_IS_0_bit                             = 1 << 3,
	VTE_XY_NAN_RETAIN_bit                             = 1 << 4,
	VTE_Z_NAN_RETAIN_bit                              = 1 << 5,
	VTE_W_NAN_RETAIN_bit                              = 1 << 6,
	VTE_W_RECIP_NAN_IS_0_bit                          = 1 << 7,
	VS_XY_NAN_TO_INF_bit                              = 1 << 8,
	VS_XY_INF_RETAIN_bit                              = 1 << 9,
	VS_Z_NAN_TO_INF_bit                               = 1 << 10,
	VS_Z_INF_RETAIN_bit                               = 1 << 11,
	VS_W_NAN_TO_INF_bit                               = 1 << 12,
	VS_W_INF_RETAIN_bit                               = 1 << 13,
	VS_CLIP_DIST_INF_DISCARD_bit                      = 1 << 14,
	VTE_NO_OUTPUT_NEG_0_bit                           = 1 << 20,
    PA_SU_LINE_STIPPLE_CNTL                               = 0x00028824,
	LINE_STIPPLE_RESET_mask                           = 0x03 << 0,
	LINE_STIPPLE_RESET_shift                          = 0,
	EXPAND_FULL_LENGTH_bit                            = 1 << 2,
	FRACTIONAL_ACCUM_bit                              = 1 << 3,
	DIAMOND_ADJUST_bit                                = 1 << 4,
    PA_SU_LINE_STIPPLE_SCALE                              = 0x00028828,
    PA_SU_PRIM_FILTER_CNTL                                = 0x0002882c,
	TRIANGLE_FILTER_DISABLE_bit                       = 1 << 0,
	LINE_FILTER_DISABLE_bit                           = 1 << 1,
	POINT_FILTER_DISABLE_bit                          = 1 << 2,
	RECTANGLE_FILTER_DISABLE_bit                      = 1 << 3,
	TRIANGLE_EXPAND_ENA_bit                           = 1 << 4,
	LINE_EXPAND_ENA_bit                               = 1 << 5,
	POINT_EXPAND_ENA_bit                              = 1 << 6,
	RECTANGLE_EXPAND_ENA_bit                          = 1 << 7,
	PRIM_EXPAND_CONSTANT_mask                         = 0xff << 8,
	PRIM_EXPAND_CONSTANT_shift                        = 8,
    SQ_LSTMP_RING_ITEMSIZE                                = 0x00028830,
	ITEMSIZE_mask                                     = 0x7fff << 0,
	ITEMSIZE_shift                                    = 0,
    SQ_HSTMP_RING_ITEMSIZE                                = 0x00028834,
/* 	ITEMSIZE_mask                                     = 0x7fff << 0, */
/* 	ITEMSIZE_shift                                    = 0, */
    SQ_PGM_START_PS                                       = 0x00028840,
    SQ_PGM_RESOURCES_PS                                   = 0x00028844,
	NUM_GPRS_mask                                     = 0xff << 0,
	NUM_GPRS_shift                                    = 0,
	STACK_SIZE_mask                                   = 0xff << 8,
	STACK_SIZE_shift                                  = 8,
	DX10_CLAMP_bit                                    = 1 << 21,
	UNCACHED_FIRST_INST_bit                           = 1 << 28,
	CLAMP_CONSTS_bit                                  = 1 << 31,
    SQ_PGM_RESOURCES_2_PS                                 = 0x00028848,
	SINGLE_ROUND_mask                                 = 0x03 << 0,
	SINGLE_ROUND_shift                                = 0,
	    SQ_ROUND_NEAREST_EVEN                         = 0x00,
	    SQ_ROUND_PLUS_INFINITY                        = 0x01,
	    SQ_ROUND_MINUS_INFINITY                       = 0x02,
	    SQ_ROUND_TO_ZERO                              = 0x03,
	DOUBLE_ROUND_mask                                 = 0x03 << 2,
	DOUBLE_ROUND_shift                                = 2,
/* 	    SQ_ROUND_NEAREST_EVEN                         = 0x00, */
/* 	    SQ_ROUND_PLUS_INFINITY                        = 0x01, */
/* 	    SQ_ROUND_MINUS_INFINITY                       = 0x02, */
/* 	    SQ_ROUND_TO_ZERO                              = 0x03, */
	ALLOW_SINGLE_DENORM_IN_bit                        = 1 << 4,
	ALLOW_SINGLE_DENORM_OUT_bit                       = 1 << 5,
	ALLOW_DOUBLE_DENORM_IN_bit                        = 1 << 6,
	ALLOW_DOUBLE_DENORM_OUT_bit                       = 1 << 7,
	SINGLE_IEEE_MODE_bit                              = 1 << 8,
	DOUBLE_IEEE_MODE_bit                              = 1 << 9,
    SQ_PGM_EXPORTS_PS                                     = 0x0002884c,
	EXPORT_MODE_mask                                  = 0x1f << 0,
	EXPORT_MODE_shift                                 = 0,
    SQ_PGM_START_VS                                       = 0x0002885c,
    SQ_PGM_RESOURCES_VS                                   = 0x00028860,
/* 	NUM_GPRS_mask                                     = 0xff << 0, */
/* 	NUM_GPRS_shift                                    = 0, */
/* 	STACK_SIZE_mask                                   = 0xff << 8, */
/* 	STACK_SIZE_shift                                  = 8, */
	USE_LS_CONSTS_bit                                 = 1 << 16,
/* 	DX10_CLAMP_bit                                    = 1 << 21, */
/* 	UNCACHED_FIRST_INST_bit                           = 1 << 28, */
    SQ_PGM_RESOURCES_2_VS                                 = 0x00028864,
/* 	SINGLE_ROUND_mask                                 = 0x03 << 0, */
/* 	SINGLE_ROUND_shift                                = 0, */
/* 	    SQ_ROUND_NEAREST_EVEN                         = 0x00, */
/* 	    SQ_ROUND_PLUS_INFINITY                        = 0x01, */
/* 	    SQ_ROUND_MINUS_INFINITY                       = 0x02, */
/* 	    SQ_ROUND_TO_ZERO                              = 0x03, */
/* 	DOUBLE_ROUND_mask                                 = 0x03 << 2, */
/* 	DOUBLE_ROUND_shift                                = 2, */
/* 	    SQ_ROUND_NEAREST_EVEN                         = 0x00, */
/* 	    SQ_ROUND_PLUS_INFINITY                        = 0x01, */
/* 	    SQ_ROUND_MINUS_INFINITY                       = 0x02, */
/* 	    SQ_ROUND_TO_ZERO                              = 0x03, */
/* 	ALLOW_SINGLE_DENORM_IN_bit                        = 1 << 4, */
/* 	ALLOW_SINGLE_DENORM_OUT_bit                       = 1 << 5, */
/* 	ALLOW_DOUBLE_DENORM_IN_bit                        = 1 << 6, */
/* 	ALLOW_DOUBLE_DENORM_OUT_bit                       = 1 << 7, */
/* 	SINGLE_IEEE_MODE_bit                              = 1 << 8, */
/* 	DOUBLE_IEEE_MODE_bit                              = 1 << 9, */
    SQ_PGM_START_GS                                       = 0x00028874,
    SQ_PGM_RESOURCES_GS                                   = 0x00028878,
/* 	NUM_GPRS_mask                                     = 0xff << 0, */
/* 	NUM_GPRS_shift                                    = 0, */
/* 	STACK_SIZE_mask                                   = 0xff << 8, */
/* 	STACK_SIZE_shift                                  = 8, */
/* 	DX10_CLAMP_bit                                    = 1 << 21, */
/* 	UNCACHED_FIRST_INST_bit                           = 1 << 28, */
    SQ_PGM_RESOURCES_2_GS                                 = 0x0002887c,
/* 	SINGLE_ROUND_mask                                 = 0x03 << 0, */
/* 	SINGLE_ROUND_shift                                = 0, */
/* 	    SQ_ROUND_NEAREST_EVEN                         = 0x00, */
/* 	    SQ_ROUND_PLUS_INFINITY                        = 0x01, */
/* 	    SQ_ROUND_MINUS_INFINITY                       = 0x02, */
/* 	    SQ_ROUND_TO_ZERO                              = 0x03, */
/* 	DOUBLE_ROUND_mask                                 = 0x03 << 2, */
/* 	DOUBLE_ROUND_shift                                = 2, */
/* 	    SQ_ROUND_NEAREST_EVEN                         = 0x00, */
/* 	    SQ_ROUND_PLUS_INFINITY                        = 0x01, */
/* 	    SQ_ROUND_MINUS_INFINITY                       = 0x02, */
/* 	    SQ_ROUND_TO_ZERO                              = 0x03, */
/* 	ALLOW_SINGLE_DENORM_IN_bit                        = 1 << 4, */
/* 	ALLOW_SINGLE_DENORM_OUT_bit                       = 1 << 5, */
/* 	ALLOW_DOUBLE_DENORM_IN_bit                        = 1 << 6, */
/* 	ALLOW_DOUBLE_DENORM_OUT_bit                       = 1 << 7, */
/* 	SINGLE_IEEE_MODE_bit                              = 1 << 8, */
/* 	DOUBLE_IEEE_MODE_bit                              = 1 << 9, */
    SQ_PGM_START_ES                                       = 0x0002888c,
    SQ_PGM_RESOURCES_ES                                   = 0x00028890,
/* 	NUM_GPRS_mask                                     = 0xff << 0, */
/* 	NUM_GPRS_shift                                    = 0, */
/* 	STACK_SIZE_mask                                   = 0xff << 8, */
/* 	STACK_SIZE_shift                                  = 8, */
/* 	USE_LS_CONSTS_bit                                 = 1 << 16, */
/* 	DX10_CLAMP_bit                                    = 1 << 21, */
/* 	UNCACHED_FIRST_INST_bit                           = 1 << 28, */
    SQ_PGM_RESOURCES_2_ES                                 = 0x00028894,
/* 	SINGLE_ROUND_mask                                 = 0x03 << 0, */
/* 	SINGLE_ROUND_shift                                = 0, */
/* 	    SQ_ROUND_NEAREST_EVEN                         = 0x00, */
/* 	    SQ_ROUND_PLUS_INFINITY                        = 0x01, */
/* 	    SQ_ROUND_MINUS_INFINITY                       = 0x02, */
/* 	    SQ_ROUND_TO_ZERO                              = 0x03, */
/* 	DOUBLE_ROUND_mask                                 = 0x03 << 2, */
/* 	DOUBLE_ROUND_shift                                = 2, */
/* 	    SQ_ROUND_NEAREST_EVEN                         = 0x00, */
/* 	    SQ_ROUND_PLUS_INFINITY                        = 0x01, */
/* 	    SQ_ROUND_MINUS_INFINITY                       = 0x02, */
/* 	    SQ_ROUND_TO_ZERO                              = 0x03, */
/* 	ALLOW_SINGLE_DENORM_IN_bit                        = 1 << 4, */
/* 	ALLOW_SINGLE_DENORM_OUT_bit                       = 1 << 5, */
/* 	ALLOW_DOUBLE_DENORM_IN_bit                        = 1 << 6, */
/* 	ALLOW_DOUBLE_DENORM_OUT_bit                       = 1 << 7, */
/* 	SINGLE_IEEE_MODE_bit                              = 1 << 8, */
/* 	DOUBLE_IEEE_MODE_bit                              = 1 << 9, */
    SQ_PGM_START_FS                                       = 0x000288a4,
    SQ_PGM_RESOURCES_FS                                   = 0x000288a8,
/* 	NUM_GPRS_mask                                     = 0xff << 0, */
/* 	NUM_GPRS_shift                                    = 0, */
/* 	STACK_SIZE_mask                                   = 0xff << 8, */
/* 	STACK_SIZE_shift                                  = 8, */
/* 	DX10_CLAMP_bit                                    = 1 << 21, */
    SQ_PGM_START_HS                                       = 0x000288b8,
    SQ_PGM_RESOURCES_HS                                   = 0x000288bc,
/* 	NUM_GPRS_mask                                     = 0xff << 0, */
/* 	NUM_GPRS_shift                                    = 0, */
/* 	STACK_SIZE_mask                                   = 0xff << 8, */
/* 	STACK_SIZE_shift                                  = 8, */
/* 	DX10_CLAMP_bit                                    = 1 << 21, */
/* 	UNCACHED_FIRST_INST_bit                           = 1 << 28, */
    SQ_PGM_RESOURCES_2_HS                                 = 0x000288c0,
/* 	SINGLE_ROUND_mask                                 = 0x03 << 0, */
/* 	SINGLE_ROUND_shift                                = 0, */
/* 	    SQ_ROUND_NEAREST_EVEN                         = 0x00, */
/* 	    SQ_ROUND_PLUS_INFINITY                        = 0x01, */
/* 	    SQ_ROUND_MINUS_INFINITY                       = 0x02, */
/* 	    SQ_ROUND_TO_ZERO                              = 0x03, */
/* 	DOUBLE_ROUND_mask                                 = 0x03 << 2, */
/* 	DOUBLE_ROUND_shift                                = 2, */
/* 	    SQ_ROUND_NEAREST_EVEN                         = 0x00, */
/* 	    SQ_ROUND_PLUS_INFINITY                        = 0x01, */
/* 	    SQ_ROUND_MINUS_INFINITY                       = 0x02, */
/* 	    SQ_ROUND_TO_ZERO                              = 0x03, */
/* 	ALLOW_SINGLE_DENORM_IN_bit                        = 1 << 4, */
/* 	ALLOW_SINGLE_DENORM_OUT_bit                       = 1 << 5, */
/* 	ALLOW_DOUBLE_DENORM_IN_bit                        = 1 << 6, */
/* 	ALLOW_DOUBLE_DENORM_OUT_bit                       = 1 << 7, */
/* 	SINGLE_IEEE_MODE_bit                              = 1 << 8, */
/* 	DOUBLE_IEEE_MODE_bit                              = 1 << 9, */
    SQ_PGM_START_LS                                       = 0x000288d0,
    SQ_PGM_RESOURCES_LS                                   = 0x000288d4,
/* 	NUM_GPRS_mask                                     = 0xff << 0, */
/* 	NUM_GPRS_shift                                    = 0, */
/* 	STACK_SIZE_mask                                   = 0xff << 8, */
/* 	STACK_SIZE_shift                                  = 8, */
	USE_VS_CONSTS_bit                                 = 1 << 16,
/* 	DX10_CLAMP_bit                                    = 1 << 21, */
/* 	UNCACHED_FIRST_INST_bit                           = 1 << 28, */
    SQ_PGM_RESOURCES_2_LS                                 = 0x000288d8,
/* 	SINGLE_ROUND_mask                                 = 0x03 << 0, */
/* 	SINGLE_ROUND_shift                                = 0, */
/* 	    SQ_ROUND_NEAREST_EVEN                         = 0x00, */
/* 	    SQ_ROUND_PLUS_INFINITY                        = 0x01, */
/* 	    SQ_ROUND_MINUS_INFINITY                       = 0x02, */
/* 	    SQ_ROUND_TO_ZERO                              = 0x03, */
/* 	DOUBLE_ROUND_mask                                 = 0x03 << 2, */
/* 	DOUBLE_ROUND_shift                                = 2, */
/* 	    SQ_ROUND_NEAREST_EVEN                         = 0x00, */
/* 	    SQ_ROUND_PLUS_INFINITY                        = 0x01, */
/* 	    SQ_ROUND_MINUS_INFINITY                       = 0x02, */
/* 	    SQ_ROUND_TO_ZERO                              = 0x03, */
/* 	ALLOW_SINGLE_DENORM_IN_bit                        = 1 << 4, */
/* 	ALLOW_SINGLE_DENORM_OUT_bit                       = 1 << 5, */
/* 	ALLOW_DOUBLE_DENORM_IN_bit                        = 1 << 6, */
/* 	ALLOW_DOUBLE_DENORM_OUT_bit                       = 1 << 7, */
/* 	SINGLE_IEEE_MODE_bit                              = 1 << 8, */
/* 	DOUBLE_IEEE_MODE_bit                              = 1 << 9, */
    SQ_VTX_SEMANTIC_CLEAR                                 = 0x000288f0,
    SQ_ESGS_RING_ITEMSIZE                                 = 0x00028900,
/* 	ITEMSIZE_mask                                     = 0x7fff << 0, */
/* 	ITEMSIZE_shift                                    = 0, */
    SQ_GSVS_RING_ITEMSIZE                                 = 0x00028904,
/* 	ITEMSIZE_mask                                     = 0x7fff << 0, */
/* 	ITEMSIZE_shift                                    = 0, */
    SQ_ESTMP_RING_ITEMSIZE                                = 0x00028908,
/* 	ITEMSIZE_mask                                     = 0x7fff << 0, */
/* 	ITEMSIZE_shift                                    = 0, */
    SQ_GSTMP_RING_ITEMSIZE                                = 0x0002890c,
/* 	ITEMSIZE_mask                                     = 0x7fff << 0, */
/* 	ITEMSIZE_shift                                    = 0, */
    SQ_VSTMP_RING_ITEMSIZE                                = 0x00028910,
/* 	ITEMSIZE_mask                                     = 0x7fff << 0, */
/* 	ITEMSIZE_shift                                    = 0, */
    SQ_PSTMP_RING_ITEMSIZE                                = 0x00028914,
/* 	ITEMSIZE_mask                                     = 0x7fff << 0, */
/* 	ITEMSIZE_shift                                    = 0, */
    SQ_GS_VERT_ITEMSIZE                                   = 0x0002891c,
/* 	ITEMSIZE_mask                                     = 0x7fff << 0, */
/* 	ITEMSIZE_shift                                    = 0, */
    SQ_GS_VERT_ITEMSIZE_1                                 = 0x00028920,
/* 	ITEMSIZE_mask                                     = 0x7fff << 0, */
/* 	ITEMSIZE_shift                                    = 0, */
    SQ_GS_VERT_ITEMSIZE_2                                 = 0x00028924,
/* 	ITEMSIZE_mask                                     = 0x7fff << 0, */
/* 	ITEMSIZE_shift                                    = 0, */
    SQ_GS_VERT_ITEMSIZE_3                                 = 0x00028928,
/* 	ITEMSIZE_mask                                     = 0x7fff << 0, */
/* 	ITEMSIZE_shift                                    = 0, */
    SQ_GSVS_RING_OFFSET_1                                 = 0x0002892c,
	SQ_GSVS_RING_OFFSET_1__OFFSET_mask                = 0x7fff << 0,
	SQ_GSVS_RING_OFFSET_1__OFFSET_shift               = 0,
    SQ_GSVS_RING_OFFSET_2                                 = 0x00028930,
	SQ_GSVS_RING_OFFSET_2__OFFSET_mask                = 0x7fff << 0,
	SQ_GSVS_RING_OFFSET_2__OFFSET_shift               = 0,
    SQ_GSVS_RING_OFFSET_3                                 = 0x00028934,
	SQ_GSVS_RING_OFFSET_3__OFFSET_mask                = 0x7fff << 0,
	SQ_GSVS_RING_OFFSET_3__OFFSET_shift               = 0,
    SQ_ALU_CONST_CACHE_PS_0                               = 0x00028940,
	SQ_ALU_CONST_CACHE_PS_0_num                       = 16,
    SQ_ALU_CONST_CACHE_VS_0                               = 0x00028980,
	SQ_ALU_CONST_CACHE_VS_0_num                       = 16,
    SQ_ALU_CONST_CACHE_GS_0                               = 0x000289c0,
	SQ_ALU_CONST_CACHE_GS_0_num                       = 16,
    PA_SU_POINT_SIZE                                      = 0x00028a00,
	HEIGHT_mask                                       = 0xffff << 0,
	HEIGHT_shift                                      = 0,
	PA_SU_POINT_SIZE__WIDTH_mask                      = 0xffff << 16,
	PA_SU_POINT_SIZE__WIDTH_shift                     = 16,
    PA_SU_POINT_MINMAX                                    = 0x00028a04,
	MIN_SIZE_mask                                     = 0xffff << 0,
	MIN_SIZE_shift                                    = 0,
	PA_SU_POINT_MINMAX__MAX_SIZE_mask                 = 0xffff << 16,
	PA_SU_POINT_MINMAX__MAX_SIZE_shift                = 16,
    PA_SU_LINE_CNTL                                       = 0x00028a08,
	PA_SU_LINE_CNTL__WIDTH_mask                       = 0xffff << 0,
	PA_SU_LINE_CNTL__WIDTH_shift                      = 0,
    PA_SC_LINE_STIPPLE                                    = 0x00028a0c,
	LINE_PATTERN_mask                                 = 0xffff << 0,
	LINE_PATTERN_shift                                = 0,
	REPEAT_COUNT_mask                                 = 0xff << 16,
	REPEAT_COUNT_shift                                = 16,
	PATTERN_BIT_ORDER_bit                             = 1 << 28,
	AUTO_RESET_CNTL_mask                              = 0x03 << 29,
	AUTO_RESET_CNTL_shift                             = 29,
    VGT_OUTPUT_PATH_CNTL                                  = 0x00028a10,
	PATH_SELECT_mask                                  = 0x07 << 0,
	PATH_SELECT_shift                                 = 0,
	    VGT_OUTPATH_VTX_REUSE                         = 0x00,
	    VGT_OUTPATH_TESS_EN                           = 0x01,
	    VGT_OUTPATH_PASSTHRU                          = 0x02,
	    VGT_OUTPATH_GS_BLOCK                          = 0x03,
	    VGT_OUTPATH_HS_BLOCK                          = 0x04,
    VGT_HOS_CNTL                                          = 0x00028a14,
	TESS_MODE_mask                                    = 0x03 << 0,
	TESS_MODE_shift                                   = 0,
    VGT_HOS_MAX_TESS_LEVEL                                = 0x00028a18,
    VGT_HOS_MIN_TESS_LEVEL                                = 0x00028a1c,
    VGT_HOS_REUSE_DEPTH                                   = 0x00028a20,
	REUSE_DEPTH_mask                                  = 0xff << 0,
	REUSE_DEPTH_shift                                 = 0,
    VGT_GROUP_PRIM_TYPE                                   = 0x00028a24,
	VGT_GROUP_PRIM_TYPE__PRIM_TYPE_mask               = 0x1f << 0,
	VGT_GROUP_PRIM_TYPE__PRIM_TYPE_shift              = 0,
	    VGT_GRP_3D_POINT                              = 0x00,
	    VGT_GRP_3D_LINE                               = 0x01,
	    VGT_GRP_3D_TRI                                = 0x02,
	    VGT_GRP_3D_RECT                               = 0x03,
	    VGT_GRP_3D_QUAD                               = 0x04,
	    VGT_GRP_2D_COPY_RECT_V0                       = 0x05,
	    VGT_GRP_2D_COPY_RECT_V1                       = 0x06,
	    VGT_GRP_2D_COPY_RECT_V2                       = 0x07,
	    VGT_GRP_2D_COPY_RECT_V3                       = 0x08,
	    VGT_GRP_2D_FILL_RECT                          = 0x09,
	    VGT_GRP_2D_LINE                               = 0x0a,
	    VGT_GRP_2D_TRI                                = 0x0b,
	    VGT_GRP_PRIM_INDEX_LINE                       = 0x0c,
	    VGT_GRP_PRIM_INDEX_TRI                        = 0x0d,
	    VGT_GRP_PRIM_INDEX_QUAD                       = 0x0e,
	    VGT_GRP_3D_LINE_ADJ                           = 0x0f,
	    VGT_GRP_3D_TRI_ADJ                            = 0x10,
	    VGT_GRP_3D_PATCH                              = 0x11,
	RETAIN_ORDER_bit                                  = 1 << 14,
	RETAIN_QUADS_bit                                  = 1 << 15,
	PRIM_ORDER_mask                                   = 0x07 << 16,
	PRIM_ORDER_shift                                  = 16,
	    VGT_GRP_LIST                                  = 0x00,
	    VGT_GRP_STRIP                                 = 0x01,
	    VGT_GRP_FAN                                   = 0x02,
	    VGT_GRP_LOOP                                  = 0x03,
	    VGT_GRP_POLYGON                               = 0x04,
    VGT_GROUP_FIRST_DECR                                  = 0x00028a28,
	FIRST_DECR_mask                                   = 0x0f << 0,
	FIRST_DECR_shift                                  = 0,
    VGT_GROUP_DECR                                        = 0x00028a2c,
	DECR_mask                                         = 0x0f << 0,
	DECR_shift                                        = 0,
    VGT_GROUP_VECT_0_CNTL                                 = 0x00028a30,
	COMP_X_EN_bit                                     = 1 << 0,
	COMP_Y_EN_bit                                     = 1 << 1,
	COMP_Z_EN_bit                                     = 1 << 2,
	COMP_W_EN_bit                                     = 1 << 3,
	VGT_GROUP_VECT_0_CNTL__STRIDE_mask                = 0xff << 8,
	VGT_GROUP_VECT_0_CNTL__STRIDE_shift               = 8,
	SHIFT_mask                                        = 0xff << 16,
	SHIFT_shift                                       = 16,
    VGT_GROUP_VECT_1_CNTL                                 = 0x00028a34,
/* 	COMP_X_EN_bit                                     = 1 << 0, */
/* 	COMP_Y_EN_bit                                     = 1 << 1, */
/* 	COMP_Z_EN_bit                                     = 1 << 2, */
/* 	COMP_W_EN_bit                                     = 1 << 3, */
	VGT_GROUP_VECT_1_CNTL__STRIDE_mask                = 0xff << 8,
	VGT_GROUP_VECT_1_CNTL__STRIDE_shift               = 8,
/* 	SHIFT_mask                                        = 0xff << 16, */
/* 	SHIFT_shift                                       = 16, */
    VGT_GROUP_VECT_0_FMT_CNTL                             = 0x00028a38,
	X_CONV_mask                                       = 0x0f << 0,
	X_CONV_shift                                      = 0,
	    VGT_GRP_INDEX_16                              = 0x00,
	    VGT_GRP_INDEX_32                              = 0x01,
	    VGT_GRP_UINT_16                               = 0x02,
	    VGT_GRP_UINT_32                               = 0x03,
	    VGT_GRP_SINT_16                               = 0x04,
	    VGT_GRP_SINT_32                               = 0x05,
	    VGT_GRP_FLOAT_32                              = 0x06,
	    VGT_GRP_AUTO_PRIM                             = 0x07,
	    VGT_GRP_FIX_1_23_TO_FLOAT                     = 0x08,
	X_OFFSET_mask                                     = 0x0f << 4,
	X_OFFSET_shift                                    = 4,
	Y_CONV_mask                                       = 0x0f << 8,
	Y_CONV_shift                                      = 8,
/* 	    VGT_GRP_INDEX_16                              = 0x00, */
/* 	    VGT_GRP_INDEX_32                              = 0x01, */
/* 	    VGT_GRP_UINT_16                               = 0x02, */
/* 	    VGT_GRP_UINT_32                               = 0x03, */
/* 	    VGT_GRP_SINT_16                               = 0x04, */
/* 	    VGT_GRP_SINT_32                               = 0x05, */
/* 	    VGT_GRP_FLOAT_32                              = 0x06, */
/* 	    VGT_GRP_AUTO_PRIM                             = 0x07, */
/* 	    VGT_GRP_FIX_1_23_TO_FLOAT                     = 0x08, */
	Y_OFFSET_mask                                     = 0x0f << 12,
	Y_OFFSET_shift                                    = 12,
	Z_CONV_mask                                       = 0x0f << 16,
	Z_CONV_shift                                      = 16,
/* 	    VGT_GRP_INDEX_16                              = 0x00, */
/* 	    VGT_GRP_INDEX_32                              = 0x01, */
/* 	    VGT_GRP_UINT_16                               = 0x02, */
/* 	    VGT_GRP_UINT_32                               = 0x03, */
/* 	    VGT_GRP_SINT_16                               = 0x04, */
/* 	    VGT_GRP_SINT_32                               = 0x05, */
/* 	    VGT_GRP_FLOAT_32                              = 0x06, */
/* 	    VGT_GRP_AUTO_PRIM                             = 0x07, */
/* 	    VGT_GRP_FIX_1_23_TO_FLOAT                     = 0x08, */
	Z_OFFSET_mask                                     = 0x0f << 20,
	Z_OFFSET_shift                                    = 20,
	W_CONV_mask                                       = 0x0f << 24,
	W_CONV_shift                                      = 24,
/* 	    VGT_GRP_INDEX_16                              = 0x00, */
/* 	    VGT_GRP_INDEX_32                              = 0x01, */
/* 	    VGT_GRP_UINT_16                               = 0x02, */
/* 	    VGT_GRP_UINT_32                               = 0x03, */
/* 	    VGT_GRP_SINT_16                               = 0x04, */
/* 	    VGT_GRP_SINT_32                               = 0x05, */
/* 	    VGT_GRP_FLOAT_32                              = 0x06, */
/* 	    VGT_GRP_AUTO_PRIM                             = 0x07, */
/* 	    VGT_GRP_FIX_1_23_TO_FLOAT                     = 0x08, */
	W_OFFSET_mask                                     = 0x0f << 28,
	W_OFFSET_shift                                    = 28,
    VGT_GROUP_VECT_1_FMT_CNTL                             = 0x00028a3c,
/* 	X_CONV_mask                                       = 0x0f << 0, */
/* 	X_CONV_shift                                      = 0, */
/* 	    VGT_GRP_INDEX_16                              = 0x00, */
/* 	    VGT_GRP_INDEX_32                              = 0x01, */
/* 	    VGT_GRP_UINT_16                               = 0x02, */
/* 	    VGT_GRP_UINT_32                               = 0x03, */
/* 	    VGT_GRP_SINT_16                               = 0x04, */
/* 	    VGT_GRP_SINT_32                               = 0x05, */
/* 	    VGT_GRP_FLOAT_32                              = 0x06, */
/* 	    VGT_GRP_AUTO_PRIM                             = 0x07, */
/* 	    VGT_GRP_FIX_1_23_TO_FLOAT                     = 0x08, */
/* 	X_OFFSET_mask                                     = 0x0f << 4, */
/* 	X_OFFSET_shift                                    = 4, */
/* 	Y_CONV_mask                                       = 0x0f << 8, */
/* 	Y_CONV_shift                                      = 8, */
/* 	    VGT_GRP_INDEX_16                              = 0x00, */
/* 	    VGT_GRP_INDEX_32                              = 0x01, */
/* 	    VGT_GRP_UINT_16                               = 0x02, */
/* 	    VGT_GRP_UINT_32                               = 0x03, */
/* 	    VGT_GRP_SINT_16                               = 0x04, */
/* 	    VGT_GRP_SINT_32                               = 0x05, */
/* 	    VGT_GRP_FLOAT_32                              = 0x06, */
/* 	    VGT_GRP_AUTO_PRIM                             = 0x07, */
/* 	    VGT_GRP_FIX_1_23_TO_FLOAT                     = 0x08, */
/* 	Y_OFFSET_mask                                     = 0x0f << 12, */
/* 	Y_OFFSET_shift                                    = 12, */
/* 	Z_CONV_mask                                       = 0x0f << 16, */
/* 	Z_CONV_shift                                      = 16, */
/* 	    VGT_GRP_INDEX_16                              = 0x00, */
/* 	    VGT_GRP_INDEX_32                              = 0x01, */
/* 	    VGT_GRP_UINT_16                               = 0x02, */
/* 	    VGT_GRP_UINT_32                               = 0x03, */
/* 	    VGT_GRP_SINT_16                               = 0x04, */
/* 	    VGT_GRP_SINT_32                               = 0x05, */
/* 	    VGT_GRP_FLOAT_32                              = 0x06, */
/* 	    VGT_GRP_AUTO_PRIM                             = 0x07, */
/* 	    VGT_GRP_FIX_1_23_TO_FLOAT                     = 0x08, */
/* 	Z_OFFSET_mask                                     = 0x0f << 20, */
/* 	Z_OFFSET_shift                                    = 20, */
/* 	W_CONV_mask                                       = 0x0f << 24, */
/* 	W_CONV_shift                                      = 24, */
/* 	    VGT_GRP_INDEX_16                              = 0x00, */
/* 	    VGT_GRP_INDEX_32                              = 0x01, */
/* 	    VGT_GRP_UINT_16                               = 0x02, */
/* 	    VGT_GRP_UINT_32                               = 0x03, */
/* 	    VGT_GRP_SINT_16                               = 0x04, */
/* 	    VGT_GRP_SINT_32                               = 0x05, */
/* 	    VGT_GRP_FLOAT_32                              = 0x06, */
/* 	    VGT_GRP_AUTO_PRIM                             = 0x07, */
/* 	    VGT_GRP_FIX_1_23_TO_FLOAT                     = 0x08, */
/* 	W_OFFSET_mask                                     = 0x0f << 28, */
/* 	W_OFFSET_shift                                    = 28, */
    VGT_GS_MODE                                           = 0x00028a40,
	VGT_GS_MODE__MODE_mask                            = 0x03 << 0,
	VGT_GS_MODE__MODE_shift                           = 0,
	    GS_OFF                                        = 0x00,
	    GS_SCENARIO_A                                 = 0x01,
	    GS_SCENARIO_B                                 = 0x02,
	    GS_SCENARIO_G                                 = 0x03,
	    GS_SCENARIO_C                                 = 0x04,
	    SPRITE_EN                                     = 0x05,
	ES_PASSTHRU_bit                                   = 1 << 2,
	CUT_MODE_mask                                     = 0x03 << 3,
	CUT_MODE_shift                                    = 3,
	    GS_CUT_1024                                   = 0x00,
	    GS_CUT_512                                    = 0x01,
	    GS_CUT_256                                    = 0x02,
	    GS_CUT_128                                    = 0x03,
	MODE_HI_bit                                       = 1 << 8,
    PA_SC_MODE_CNTL_0                                     = 0x00028a48,
	MSAA_ENABLE_bit                                   = 1 << 0,
	VPORT_SCISSOR_ENABLE_bit                          = 1 << 1,
	LINE_STIPPLE_ENABLE_bit                           = 1 << 2,
    VGT_ENHANCE                                           = 0x00028a50,
    VGT_GS_PER_ES                                         = 0x00028a54,
	GS_PER_ES_mask                                    = 0x7ff << 0,
	GS_PER_ES_shift                                   = 0,
    VGT_ES_PER_GS                                         = 0x00028a58,
	ES_PER_GS_mask                                    = 0x7ff << 0,
	ES_PER_GS_shift                                   = 0,
    VGT_GS_PER_VS                                         = 0x00028a5c,
	GS_PER_VS_mask                                    = 0x0f << 0,
	GS_PER_VS_shift                                   = 0,
    VGT_GS_OUT_PRIM_TYPE                                  = 0x00028a6c,
	OUTPRIM_TYPE_mask                                 = 0x3f << 0,
	OUTPRIM_TYPE_shift                                = 0,
	    POINTLIST                                     = 0x00,
	    LINESTRIP                                     = 0x01,
	    TRISTRIP                                      = 0x02,
    VGT_DMA_SIZE                                          = 0x00028a74,
    VGT_DMA_MAX_SIZE                                      = 0x00028a78,
    VGT_DMA_INDEX_TYPE                                    = 0x00028a7c,
/* 	INDEX_TYPE_mask                                   = 0x03 << 0, */
/* 	INDEX_TYPE_shift                                  = 0, */
	    VGT_INDEX_16                                  = 0x00,
	    VGT_INDEX_32                                  = 0x01,
	SWAP_MODE_mask                                    = 0x03 << 2,
	SWAP_MODE_shift                                   = 2,
	    VGT_DMA_SWAP_NONE                             = 0x00,
	    VGT_DMA_SWAP_16_BIT                           = 0x01,
	    VGT_DMA_SWAP_32_BIT                           = 0x02,
	    VGT_DMA_SWAP_WORD                             = 0x03,
    VGT_PRIMITIVEID_EN                                    = 0x00028a84,
	PRIMITIVEID_EN_bit                                = 1 << 0,
    VGT_DMA_NUM_INSTANCES                                 = 0x00028a88,
    VGT_EVENT_INITIATOR                                   = 0x00028a90,
	EVENT_TYPE_mask                                   = 0x3f << 0,
	EVENT_TYPE_shift                                  = 0,
	    SAMPLE_STREAMOUTSTATS1                        = 0x01,
	    SAMPLE_STREAMOUTSTATS2                        = 0x02,
	    SAMPLE_STREAMOUTSTATS3                        = 0x03,
	    CACHE_FLUSH_TS                                = 0x04,
	    CONTEXT_DONE                                  = 0x05,
	    CACHE_FLUSH                                   = 0x06,
	    CS_PARTIAL_FLUSH                              = 0x07,
	    VGT_STREAMOUT_SYNC                            = 0x08,
	    RST_PIX_CNT                                   = 0x0d,
	    VS_PARTIAL_FLUSH                              = 0x0f,
	    PS_PARTIAL_FLUSH                              = 0x10,
	    FLUSH_HS_OUTPUT                               = 0x11,
	    FLUSH_LS_OUTPUT                               = 0x12,
	    CACHE_FLUSH_AND_INV_TS_EVENT                  = 0x14,
	    ZPASS_DONE                                    = 0x15,
	    CACHE_FLUSH_AND_INV_EVENT                     = 0x16,
	    PERFCOUNTER_START                             = 0x17,
	    PERFCOUNTER_STOP                              = 0x18,
	    PIPELINESTAT_START                            = 0x19,
	    PIPELINESTAT_STOP                             = 0x1a,
	    PERFCOUNTER_SAMPLE                            = 0x1b,
	    FLUSH_ES_OUTPUT                               = 0x1c,
	    FLUSH_GS_OUTPUT                               = 0x1d,
	    SAMPLE_PIPELINESTAT                           = 0x1e,
	    SO_VGTSTREAMOUT_FLUSH                         = 0x1f,
	    SAMPLE_STREAMOUTSTATS                         = 0x20,
	    RESET_VTX_CNT                                 = 0x21,
	    BLOCK_CONTEXT_DONE                            = 0x22,
	    CS_CONTEXT_DONE                               = 0x23,
	    VGT_FLUSH                                     = 0x24,
	    SQ_NON_EVENT                                  = 0x26,
	    SC_SEND_DB_VPZ                                = 0x27,
	    BOTTOM_OF_PIPE_TS                             = 0x28,
	    FLUSH_SX_TS                                   = 0x29,
	    DB_CACHE_FLUSH_AND_INV                        = 0x2a,
	    FLUSH_AND_INV_DB_DATA_TS                      = 0x2b,
	    FLUSH_AND_INV_DB_META                         = 0x2c,
	    FLUSH_AND_INV_CB_DATA_TS                      = 0x2d,
	    FLUSH_AND_INV_CB_META                         = 0x2e,
	    CS_DONE                                       = 0x2f,
	    PS_DONE                                       = 0x30,
	    FLUSH_AND_INV_CB_PIXEL_DATA                   = 0x31,
	    SX_CB_RAT_ACK_REQUEST                         = 0x32,
	ADDRESS_HI_mask                                   = 0x1ff << 18,
	ADDRESS_HI_shift                                  = 18,
	EXTENDED_EVENT_bit                                = 1 << 27,
    VGT_MULTI_PRIM_IB_RESET_EN                            = 0x00028a94,
	RESET_EN_bit                                      = 1 << 0,
    VGT_INSTANCE_STEP_RATE_0                              = 0x00028aa0,
    VGT_INSTANCE_STEP_RATE_1                              = 0x00028aa4,
    VGT_REUSE_OFF                                         = 0x00028ab4,
	REUSE_OFF_bit                                     = 1 << 0,
    VGT_VTX_CNT_EN                                        = 0x00028ab8,
	VTX_CNT_EN_bit                                    = 1 << 0,
    DB_HTILE_SURFACE                                      = 0x00028abc,
	HTILE_WIDTH_bit                                   = 1 << 0,
	HTILE_HEIGHT_bit                                  = 1 << 1,
	LINEAR_bit                                        = 1 << 2,
	FULL_CACHE_bit                                    = 1 << 3,
	HTILE_USES_PRELOAD_WIN_bit                        = 1 << 4,
	PRELOAD_bit                                       = 1 << 5,
	PREFETCH_WIDTH_mask                               = 0x3f << 6,
	PREFETCH_WIDTH_shift                              = 6,
	PREFETCH_HEIGHT_mask                              = 0x3f << 12,
	PREFETCH_HEIGHT_shift                             = 12,
    DB_SRESULTS_COMPARE_STATE0                            = 0x00028ac0,
	COMPAREFUNC0_mask                                 = 0x07 << 0,
	COMPAREFUNC0_shift                                = 0,
/* 	    REF_NEVER                                     = 0x00, */
/* 	    REF_LESS                                      = 0x01, */
/* 	    REF_EQUAL                                     = 0x02, */
/* 	    REF_LEQUAL                                    = 0x03, */
/* 	    REF_GREATER                                   = 0x04, */
/* 	    REF_NOTEQUAL                                  = 0x05, */
/* 	    REF_GEQUAL                                    = 0x06, */
/* 	    REF_ALWAYS                                    = 0x07, */
	COMPAREVALUE0_mask                                = 0xff << 4,
	COMPAREVALUE0_shift                               = 4,
	COMPAREMASK0_mask                                 = 0xff << 12,
	COMPAREMASK0_shift                                = 12,
	ENABLE0_bit                                       = 1 << 24,
    DB_SRESULTS_COMPARE_STATE1                            = 0x00028ac4,
	COMPAREFUNC1_mask                                 = 0x07 << 0,
	COMPAREFUNC1_shift                                = 0,
/* 	    REF_NEVER                                     = 0x00, */
/* 	    REF_LESS                                      = 0x01, */
/* 	    REF_EQUAL                                     = 0x02, */
/* 	    REF_LEQUAL                                    = 0x03, */
/* 	    REF_GREATER                                   = 0x04, */
/* 	    REF_NOTEQUAL                                  = 0x05, */
/* 	    REF_GEQUAL                                    = 0x06, */
/* 	    REF_ALWAYS                                    = 0x07, */
	COMPAREVALUE1_mask                                = 0xff << 4,
	COMPAREVALUE1_shift                               = 4,
	COMPAREMASK1_mask                                 = 0xff << 12,
	COMPAREMASK1_shift                                = 12,
	ENABLE1_bit                                       = 1 << 24,
    DB_PRELOAD_CONTROL                                    = 0x00028ac8,
	START_X_mask                                      = 0xff << 0,
	START_X_shift                                     = 0,
	START_Y_mask                                      = 0xff << 8,
	START_Y_shift                                     = 8,
	MAX_X_mask                                        = 0xff << 16,
	MAX_X_shift                                       = 16,
	MAX_Y_mask                                        = 0xff << 24,
	MAX_Y_shift                                       = 24,
    VGT_STRMOUT_BUFFER_SIZE_0                             = 0x00028ad0,
    VGT_STRMOUT_VTX_STRIDE_0                              = 0x00028ad4,
	VGT_STRMOUT_VTX_STRIDE_0__STRIDE_mask             = 0x3ff << 0,
	VGT_STRMOUT_VTX_STRIDE_0__STRIDE_shift            = 0,
    VGT_STRMOUT_BUFFER_BASE_0                             = 0x00028ad8,
    VGT_STRMOUT_BUFFER_OFFSET_0                           = 0x00028adc,
    VGT_STRMOUT_BUFFER_SIZE_1                             = 0x00028ae0,
    VGT_STRMOUT_VTX_STRIDE_1                              = 0x00028ae4,
	VGT_STRMOUT_VTX_STRIDE_1__STRIDE_mask             = 0x3ff << 0,
	VGT_STRMOUT_VTX_STRIDE_1__STRIDE_shift            = 0,
    VGT_STRMOUT_BUFFER_BASE_1                             = 0x00028ae8,
    VGT_STRMOUT_BUFFER_OFFSET_1                           = 0x00028aec,
    VGT_STRMOUT_BUFFER_SIZE_2                             = 0x00028af0,
    VGT_STRMOUT_VTX_STRIDE_2                              = 0x00028af4,
	VGT_STRMOUT_VTX_STRIDE_2__STRIDE_mask             = 0x3ff << 0,
	VGT_STRMOUT_VTX_STRIDE_2__STRIDE_shift            = 0,
    VGT_STRMOUT_BUFFER_BASE_2                             = 0x00028af8,
    VGT_STRMOUT_BUFFER_OFFSET_2                           = 0x00028afc,
    VGT_STRMOUT_BUFFER_SIZE_3                             = 0x00028b00,
    VGT_STRMOUT_VTX_STRIDE_3                              = 0x00028b04,
	VGT_STRMOUT_VTX_STRIDE_3__STRIDE_mask             = 0x3ff << 0,
	VGT_STRMOUT_VTX_STRIDE_3__STRIDE_shift            = 0,
    VGT_STRMOUT_BUFFER_BASE_3                             = 0x00028b08,
    VGT_STRMOUT_BUFFER_OFFSET_3                           = 0x00028b0c,
    VGT_STRMOUT_BASE_OFFSET_0                             = 0x00028b10,
    VGT_STRMOUT_BASE_OFFSET_1                             = 0x00028b14,
    VGT_STRMOUT_BASE_OFFSET_2                             = 0x00028b18,
    VGT_STRMOUT_BASE_OFFSET_3                             = 0x00028b1c,
    VGT_STRMOUT_DRAW_OPAQUE_OFFSET                        = 0x00028b28,
    VGT_STRMOUT_DRAW_OPAQUE_BUFFER_FILLED_SIZE            = 0x00028b2c,
    VGT_STRMOUT_DRAW_OPAQUE_VERTEX_STRIDE                 = 0x00028b30,
	VERTEX_STRIDE_mask                                = 0x1ff << 0,
	VERTEX_STRIDE_shift                               = 0,
    VGT_GS_MAX_VERT_OUT                                   = 0x00028b38,
	MAX_VERT_OUT_mask                                 = 0x7ff << 0,
	MAX_VERT_OUT_shift                                = 0,
    VGT_STRMOUT_BASE_OFFSET_HI_0                          = 0x00028b44,
	VGT_STRMOUT_BASE_OFFSET_HI_0__BASE_OFFSET_mask    = 0x3f << 0,
	VGT_STRMOUT_BASE_OFFSET_HI_0__BASE_OFFSET_shift   = 0,
    VGT_STRMOUT_BASE_OFFSET_HI_1                          = 0x00028b48,
	VGT_STRMOUT_BASE_OFFSET_HI_1__BASE_OFFSET_mask    = 0x3f << 0,
	VGT_STRMOUT_BASE_OFFSET_HI_1__BASE_OFFSET_shift   = 0,
    VGT_STRMOUT_BASE_OFFSET_HI_2                          = 0x00028b4c,
	VGT_STRMOUT_BASE_OFFSET_HI_2__BASE_OFFSET_mask    = 0x3f << 0,
	VGT_STRMOUT_BASE_OFFSET_HI_2__BASE_OFFSET_shift   = 0,
    VGT_STRMOUT_BASE_OFFSET_HI_3                          = 0x00028b50,
	VGT_STRMOUT_BASE_OFFSET_HI_3__BASE_OFFSET_mask    = 0x3f << 0,
	VGT_STRMOUT_BASE_OFFSET_HI_3__BASE_OFFSET_shift   = 0,
    VGT_SHADER_STAGES_EN                                  = 0x00028b54,
	LS_EN_mask                                        = 0x03 << 0,
	LS_EN_shift                                       = 0,
	    LS_STAGE_OFF                                  = 0x00,
	    LS_STAGE_ON                                   = 0x01,
	    CS_STAGE_ON                                   = 0x02,
	HS_EN_bit                                         = 1 << 2,
	ES_EN_mask                                        = 0x03 << 3,
	ES_EN_shift                                       = 3,
	    ES_STAGE_OFF                                  = 0x00,
	    ES_STAGE_DS                                   = 0x01,
	    ES_STAGE_REAL                                 = 0x02,
	GS_EN_bit                                         = 1 << 5,
	VS_EN_mask                                        = 0x03 << 6,
	VS_EN_shift                                       = 6,
	    VS_STAGE_REAL                                 = 0x00,
	    VS_STAGE_DS                                   = 0x01,
	    VS_STAGE_COPY_SHADER                          = 0x02,
	DYNAMIC_HS_bit                                    = 1 << 8,
    VGT_LS_HS_CONFIG                                      = 0x00028b58,
	NUM_PATCHES_mask                                  = 0xff << 0,
	NUM_PATCHES_shift                                 = 0,
	HS_NUM_INPUT_CP_mask                              = 0x3f << 8,
	HS_NUM_INPUT_CP_shift                             = 8,
	HS_NUM_OUTPUT_CP_mask                             = 0x3f << 14,
	HS_NUM_OUTPUT_CP_shift                            = 14,
    DB_ALPHA_TO_MASK                                      = 0x00028b70,
	ALPHA_TO_MASK_ENABLE_bit                          = 1 << 0,
	ALPHA_TO_MASK_OFFSET0_mask                        = 0x03 << 8,
	ALPHA_TO_MASK_OFFSET0_shift                       = 8,
	ALPHA_TO_MASK_OFFSET1_mask                        = 0x03 << 10,
	ALPHA_TO_MASK_OFFSET1_shift                       = 10,
	ALPHA_TO_MASK_OFFSET2_mask                        = 0x03 << 12,
	ALPHA_TO_MASK_OFFSET2_shift                       = 12,
	ALPHA_TO_MASK_OFFSET3_mask                        = 0x03 << 14,
	ALPHA_TO_MASK_OFFSET3_shift                       = 14,
	OFFSET_ROUND_bit                                  = 1 << 16,
    PA_SU_POLY_OFFSET_DB_FMT_CNTL                         = 0x00028b78,
	POLY_OFFSET_NEG_NUM_DB_BITS_mask                  = 0xff << 0,
	POLY_OFFSET_NEG_NUM_DB_BITS_shift                 = 0,
	POLY_OFFSET_DB_IS_FLOAT_FMT_bit                   = 1 << 8,
    PA_SU_POLY_OFFSET_CLAMP                               = 0x00028b7c,
    PA_SU_POLY_OFFSET_FRONT_SCALE                         = 0x00028b80,
    PA_SU_POLY_OFFSET_FRONT_OFFSET                        = 0x00028b84,
    PA_SU_POLY_OFFSET_BACK_SCALE                          = 0x00028b88,
    PA_SU_POLY_OFFSET_BACK_OFFSET                         = 0x00028b8c,
    VGT_GS_INSTANCE_CNT                                   = 0x00028b90,
	VGT_GS_INSTANCE_CNT__ENABLE_bit                   = 1 << 0,
	CNT_mask                                          = 0x7f << 2,
	CNT_shift                                         = 2,
    VGT_STRMOUT_CONFIG                                    = 0x00028b94,
	STREAMOUT_0_EN_bit                                = 1 << 0,
	STREAMOUT_1_EN_bit                                = 1 << 1,
	STREAMOUT_2_EN_bit                                = 1 << 2,
	STREAMOUT_3_EN_bit                                = 1 << 3,
	RAST_STREAM_mask                                  = 0x07 << 4,
	RAST_STREAM_shift                                 = 4,
    VGT_STRMOUT_BUFFER_CONFIG                             = 0x00028b98,
	STREAM_0_BUFFER_EN_mask                           = 0x0f << 0,
	STREAM_0_BUFFER_EN_shift                          = 0,
	STREAM_1_BUFFER_EN_mask                           = 0x0f << 4,
	STREAM_1_BUFFER_EN_shift                          = 4,
	STREAM_2_BUFFER_EN_mask                           = 0x0f << 8,
	STREAM_2_BUFFER_EN_shift                          = 8,
	STREAM_3_BUFFER_EN_mask                           = 0x0f << 12,
	STREAM_3_BUFFER_EN_shift                          = 12,
    CB_IMMED0_BASE                                        = 0x00028b9c,
	CB_IMMED0_BASE_num                                = 12,
    PA_SC_CENTROID_PRIORITY_0                             = 0x00028bd4,
	DISTANCE_0_mask                                   = 0x0f << 0,
	DISTANCE_0_shift                                  = 0,
	DISTANCE_1_mask                                   = 0x0f << 4,
	DISTANCE_1_shift                                  = 4,
	DISTANCE_2_mask                                   = 0x0f << 8,
	DISTANCE_2_shift                                  = 8,
	DISTANCE_3_mask                                   = 0x0f << 12,
	DISTANCE_3_shift                                  = 12,
	DISTANCE_4_mask                                   = 0x0f << 16,
	DISTANCE_4_shift                                  = 16,
	DISTANCE_5_mask                                   = 0x0f << 20,
	DISTANCE_5_shift                                  = 20,
	DISTANCE_6_mask                                   = 0x0f << 24,
	DISTANCE_6_shift                                  = 24,
	DISTANCE_7_mask                                   = 0x0f << 28,
	DISTANCE_7_shift                                  = 28,
    PA_SC_CENTROID_PRIORITY_1                             = 0x00028bd8,
	DISTANCE_8_mask                                   = 0x0f << 0,
	DISTANCE_8_shift                                  = 0,
	DISTANCE_9_mask                                   = 0x0f << 4,
	DISTANCE_9_shift                                  = 4,
	DISTANCE_10_mask                                  = 0x0f << 8,
	DISTANCE_10_shift                                 = 8,
	DISTANCE_11_mask                                  = 0x0f << 12,
	DISTANCE_11_shift                                 = 12,
	DISTANCE_12_mask                                  = 0x0f << 16,
	DISTANCE_12_shift                                 = 16,
	DISTANCE_13_mask                                  = 0x0f << 20,
	DISTANCE_13_shift                                 = 20,
	DISTANCE_14_mask                                  = 0x0f << 24,
	DISTANCE_14_shift                                 = 24,
	DISTANCE_15_mask                                  = 0x0f << 28,
	DISTANCE_15_shift                                 = 28,
    PA_SC_LINE_CNTL                                       = 0x00028bdc,
	EXPAND_LINE_WIDTH_bit                             = 1 << 9,
	LAST_PIXEL_bit                                    = 1 << 10,
	PERPENDICULAR_ENDCAP_ENA_bit                      = 1 << 11,
	DX10_DIAMOND_TEST_ENA_bit                         = 1 << 12,
    PA_SC_AA_CONFIG                                       = 0x00028be0,
	MSAA_NUM_SAMPLES_mask                             = 0x07 << 0,
	MSAA_NUM_SAMPLES_shift                            = 0,
	AA_MASK_CENTROID_DTMN_bit                         = 1 << 4,
	MAX_SAMPLE_DIST_mask                              = 0x0f << 13,
	MAX_SAMPLE_DIST_shift                             = 13,
	MSAA_EXPOSED_SAMPLES_mask                         = 0x07 << 20,
	MSAA_EXPOSED_SAMPLES_shift                        = 20,
	DETAIL_TO_EXPOSED_MODE_mask                       = 0x03 << 24,
	DETAIL_TO_EXPOSED_MODE_shift                      = 24,
    PA_SU_VTX_CNTL                                        = 0x00028be4,
	PIX_CENTER_bit                                    = 1 << 0,
	PA_SU_VTX_CNTL__ROUND_MODE_mask                   = 0x03 << 1,
	PA_SU_VTX_CNTL__ROUND_MODE_shift                  = 1,
	    X_TRUNCATE                                    = 0x00,
	    X_ROUND                                       = 0x01,
	    X_ROUND_TO_EVEN                               = 0x02,
	    X_ROUND_TO_ODD                                = 0x03,
	QUANT_MODE_mask                                   = 0x07 << 3,
	QUANT_MODE_shift                                  = 3,
	    X_1_16TH                                      = 0x00,
	    X_1_8TH                                       = 0x01,
	    X_1_4TH                                       = 0x02,
	    X_1_2                                         = 0x03,
	    QUANT_MODE__X_1                               = 0x04,
	    X_1_256TH                                     = 0x05,
	    X_1_1024TH                                    = 0x06,
	    X_1_4096TH                                    = 0x07,
    PA_CL_GB_VERT_CLIP_ADJ                                = 0x00028be8,
    PA_CL_GB_HORZ_CLIP_ADJ                                = 0x00028bf0,
    PA_CL_GB_HORZ_DISC_ADJ                                = 0x00028bf4,
    PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_0                     = 0x00028bf8,
	S0_X_mask                                         = 0x0f << 0,
	S0_X_shift                                        = 0,
	S0_Y_mask                                         = 0x0f << 4,
	S0_Y_shift                                        = 4,
	S1_X_mask                                         = 0x0f << 8,
	S1_X_shift                                        = 8,
	S1_Y_mask                                         = 0x0f << 12,
	S1_Y_shift                                        = 12,
	S2_X_mask                                         = 0x0f << 16,
	S2_X_shift                                        = 16,
	S2_Y_mask                                         = 0x0f << 20,
	S2_Y_shift                                        = 20,
	S3_X_mask                                         = 0x0f << 24,
	S3_X_shift                                        = 24,
	S3_Y_mask                                         = 0x0f << 28,
	S3_Y_shift                                        = 28,
    PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_1                     = 0x00028bfc,
	S4_X_mask                                         = 0x0f << 0,
	S4_X_shift                                        = 0,
	S4_Y_mask                                         = 0x0f << 4,
	S4_Y_shift                                        = 4,
	S5_X_mask                                         = 0x0f << 8,
	S5_X_shift                                        = 8,
	S5_Y_mask                                         = 0x0f << 12,
	S5_Y_shift                                        = 12,
	S6_X_mask                                         = 0x0f << 16,
	S6_X_shift                                        = 16,
	S6_Y_mask                                         = 0x0f << 20,
	S6_Y_shift                                        = 20,
	S7_X_mask                                         = 0x0f << 24,
	S7_X_shift                                        = 24,
	S7_Y_mask                                         = 0x0f << 28,
	S7_Y_shift                                        = 28,
    PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_2                     = 0x00028c00,
	S8_X_mask                                         = 0x0f << 0,
	S8_X_shift                                        = 0,
	S8_Y_mask                                         = 0x0f << 4,
	S8_Y_shift                                        = 4,
	S9_X_mask                                         = 0x0f << 8,
	S9_X_shift                                        = 8,
	S9_Y_mask                                         = 0x0f << 12,
	S9_Y_shift                                        = 12,
	S10_X_mask                                        = 0x0f << 16,
	S10_X_shift                                       = 16,
	S10_Y_mask                                        = 0x0f << 20,
	S10_Y_shift                                       = 20,
	S11_X_mask                                        = 0x0f << 24,
	S11_X_shift                                       = 24,
	S11_Y_mask                                        = 0x0f << 28,
	S11_Y_shift                                       = 28,
    PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_3                     = 0x00028c04,
	S12_X_mask                                        = 0x0f << 0,
	S12_X_shift                                       = 0,
	S12_Y_mask                                        = 0x0f << 4,
	S12_Y_shift                                       = 4,
	S13_X_mask                                        = 0x0f << 8,
	S13_X_shift                                       = 8,
	S13_Y_mask                                        = 0x0f << 12,
	S13_Y_shift                                       = 12,
	S14_X_mask                                        = 0x0f << 16,
	S14_X_shift                                       = 16,
	S14_Y_mask                                        = 0x0f << 20,
	S14_Y_shift                                       = 20,
	S15_X_mask                                        = 0x0f << 24,
	S15_X_shift                                       = 24,
	S15_Y_mask                                        = 0x0f << 28,
	S15_Y_shift                                       = 28,
    PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_0                     = 0x00028c08,
/* 	S0_X_mask                                         = 0x0f << 0, */
/* 	S0_X_shift                                        = 0, */
/* 	S0_Y_mask                                         = 0x0f << 4, */
/* 	S0_Y_shift                                        = 4, */
/* 	S1_X_mask                                         = 0x0f << 8, */
/* 	S1_X_shift                                        = 8, */
/* 	S1_Y_mask                                         = 0x0f << 12, */
/* 	S1_Y_shift                                        = 12, */
/* 	S2_X_mask                                         = 0x0f << 16, */
/* 	S2_X_shift                                        = 16, */
/* 	S2_Y_mask                                         = 0x0f << 20, */
/* 	S2_Y_shift                                        = 20, */
/* 	S3_X_mask                                         = 0x0f << 24, */
/* 	S3_X_shift                                        = 24, */
/* 	S3_Y_mask                                         = 0x0f << 28, */
/* 	S3_Y_shift                                        = 28, */
    PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_1                     = 0x00028c0c,
/* 	S4_X_mask                                         = 0x0f << 0, */
/* 	S4_X_shift                                        = 0, */
/* 	S4_Y_mask                                         = 0x0f << 4, */
/* 	S4_Y_shift                                        = 4, */
/* 	S5_X_mask                                         = 0x0f << 8, */
/* 	S5_X_shift                                        = 8, */
/* 	S5_Y_mask                                         = 0x0f << 12, */
/* 	S5_Y_shift                                        = 12, */
/* 	S6_X_mask                                         = 0x0f << 16, */
/* 	S6_X_shift                                        = 16, */
/* 	S6_Y_mask                                         = 0x0f << 20, */
/* 	S6_Y_shift                                        = 20, */
/* 	S7_X_mask                                         = 0x0f << 24, */
/* 	S7_X_shift                                        = 24, */
/* 	S7_Y_mask                                         = 0x0f << 28, */
/* 	S7_Y_shift                                        = 28, */
    PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_2                     = 0x00028c10,
/* 	S8_X_mask                                         = 0x0f << 0, */
/* 	S8_X_shift                                        = 0, */
/* 	S8_Y_mask                                         = 0x0f << 4, */
/* 	S8_Y_shift                                        = 4, */
/* 	S9_X_mask                                         = 0x0f << 8, */
/* 	S9_X_shift                                        = 8, */
/* 	S9_Y_mask                                         = 0x0f << 12, */
/* 	S9_Y_shift                                        = 12, */
/* 	S10_X_mask                                        = 0x0f << 16, */
/* 	S10_X_shift                                       = 16, */
/* 	S10_Y_mask                                        = 0x0f << 20, */
/* 	S10_Y_shift                                       = 20, */
/* 	S11_X_mask                                        = 0x0f << 24, */
/* 	S11_X_shift                                       = 24, */
/* 	S11_Y_mask                                        = 0x0f << 28, */
/* 	S11_Y_shift                                       = 28, */
    PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_3                     = 0x00028c14,
/* 	S12_X_mask                                        = 0x0f << 0, */
/* 	S12_X_shift                                       = 0, */
/* 	S12_Y_mask                                        = 0x0f << 4, */
/* 	S12_Y_shift                                       = 4, */
/* 	S13_X_mask                                        = 0x0f << 8, */
/* 	S13_X_shift                                       = 8, */
/* 	S13_Y_mask                                        = 0x0f << 12, */
/* 	S13_Y_shift                                       = 12, */
/* 	S14_X_mask                                        = 0x0f << 16, */
/* 	S14_X_shift                                       = 16, */
/* 	S14_Y_mask                                        = 0x0f << 20, */
/* 	S14_Y_shift                                       = 20, */
/* 	S15_X_mask                                        = 0x0f << 24, */
/* 	S15_X_shift                                       = 24, */
/* 	S15_Y_mask                                        = 0x0f << 28, */
/* 	S15_Y_shift                                       = 28, */
    PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_0                     = 0x00028c18,
/* 	S0_X_mask                                         = 0x0f << 0, */
/* 	S0_X_shift                                        = 0, */
/* 	S0_Y_mask                                         = 0x0f << 4, */
/* 	S0_Y_shift                                        = 4, */
/* 	S1_X_mask                                         = 0x0f << 8, */
/* 	S1_X_shift                                        = 8, */
/* 	S1_Y_mask                                         = 0x0f << 12, */
/* 	S1_Y_shift                                        = 12, */
/* 	S2_X_mask                                         = 0x0f << 16, */
/* 	S2_X_shift                                        = 16, */
/* 	S2_Y_mask                                         = 0x0f << 20, */
/* 	S2_Y_shift                                        = 20, */
/* 	S3_X_mask                                         = 0x0f << 24, */
/* 	S3_X_shift                                        = 24, */
/* 	S3_Y_mask                                         = 0x0f << 28, */
/* 	S3_Y_shift                                        = 28, */
    PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_1                     = 0x00028c1c,
/* 	S4_X_mask                                         = 0x0f << 0, */
/* 	S4_X_shift                                        = 0, */
/* 	S4_Y_mask                                         = 0x0f << 4, */
/* 	S4_Y_shift                                        = 4, */
/* 	S5_X_mask                                         = 0x0f << 8, */
/* 	S5_X_shift                                        = 8, */
/* 	S5_Y_mask                                         = 0x0f << 12, */
/* 	S5_Y_shift                                        = 12, */
/* 	S6_X_mask                                         = 0x0f << 16, */
/* 	S6_X_shift                                        = 16, */
/* 	S6_Y_mask                                         = 0x0f << 20, */
/* 	S6_Y_shift                                        = 20, */
/* 	S7_X_mask                                         = 0x0f << 24, */
/* 	S7_X_shift                                        = 24, */
/* 	S7_Y_mask                                         = 0x0f << 28, */
/* 	S7_Y_shift                                        = 28, */
    PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_2                     = 0x00028c20,
/* 	S8_X_mask                                         = 0x0f << 0, */
/* 	S8_X_shift                                        = 0, */
/* 	S8_Y_mask                                         = 0x0f << 4, */
/* 	S8_Y_shift                                        = 4, */
/* 	S9_X_mask                                         = 0x0f << 8, */
/* 	S9_X_shift                                        = 8, */
/* 	S9_Y_mask                                         = 0x0f << 12, */
/* 	S9_Y_shift                                        = 12, */
/* 	S10_X_mask                                        = 0x0f << 16, */
/* 	S10_X_shift                                       = 16, */
/* 	S10_Y_mask                                        = 0x0f << 20, */
/* 	S10_Y_shift                                       = 20, */
/* 	S11_X_mask                                        = 0x0f << 24, */
/* 	S11_X_shift                                       = 24, */
/* 	S11_Y_mask                                        = 0x0f << 28, */
/* 	S11_Y_shift                                       = 28, */
    PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_3                     = 0x00028c24,
/* 	S12_X_mask                                        = 0x0f << 0, */
/* 	S12_X_shift                                       = 0, */
/* 	S12_Y_mask                                        = 0x0f << 4, */
/* 	S12_Y_shift                                       = 4, */
/* 	S13_X_mask                                        = 0x0f << 8, */
/* 	S13_X_shift                                       = 8, */
/* 	S13_Y_mask                                        = 0x0f << 12, */
/* 	S13_Y_shift                                       = 12, */
/* 	S14_X_mask                                        = 0x0f << 16, */
/* 	S14_X_shift                                       = 16, */
/* 	S14_Y_mask                                        = 0x0f << 20, */
/* 	S14_Y_shift                                       = 20, */
/* 	S15_X_mask                                        = 0x0f << 24, */
/* 	S15_X_shift                                       = 24, */
/* 	S15_Y_mask                                        = 0x0f << 28, */
/* 	S15_Y_shift                                       = 28, */
    PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_0                     = 0x00028c28,
/* 	S0_X_mask                                         = 0x0f << 0, */
/* 	S0_X_shift                                        = 0, */
/* 	S0_Y_mask                                         = 0x0f << 4, */
/* 	S0_Y_shift                                        = 4, */
/* 	S1_X_mask                                         = 0x0f << 8, */
/* 	S1_X_shift                                        = 8, */
/* 	S1_Y_mask                                         = 0x0f << 12, */
/* 	S1_Y_shift                                        = 12, */
/* 	S2_X_mask                                         = 0x0f << 16, */
/* 	S2_X_shift                                        = 16, */
/* 	S2_Y_mask                                         = 0x0f << 20, */
/* 	S2_Y_shift                                        = 20, */
/* 	S3_X_mask                                         = 0x0f << 24, */
/* 	S3_X_shift                                        = 24, */
/* 	S3_Y_mask                                         = 0x0f << 28, */
/* 	S3_Y_shift                                        = 28, */
    PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_1                     = 0x00028c2c,
/* 	S4_X_mask                                         = 0x0f << 0, */
/* 	S4_X_shift                                        = 0, */
/* 	S4_Y_mask                                         = 0x0f << 4, */
/* 	S4_Y_shift                                        = 4, */
/* 	S5_X_mask                                         = 0x0f << 8, */
/* 	S5_X_shift                                        = 8, */
/* 	S5_Y_mask                                         = 0x0f << 12, */
/* 	S5_Y_shift                                        = 12, */
/* 	S6_X_mask                                         = 0x0f << 16, */
/* 	S6_X_shift                                        = 16, */
/* 	S6_Y_mask                                         = 0x0f << 20, */
/* 	S6_Y_shift                                        = 20, */
/* 	S7_X_mask                                         = 0x0f << 24, */
/* 	S7_X_shift                                        = 24, */
/* 	S7_Y_mask                                         = 0x0f << 28, */
/* 	S7_Y_shift                                        = 28, */
    PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_2                     = 0x00028c30,
/* 	S8_X_mask                                         = 0x0f << 0, */
/* 	S8_X_shift                                        = 0, */
/* 	S8_Y_mask                                         = 0x0f << 4, */
/* 	S8_Y_shift                                        = 4, */
/* 	S9_X_mask                                         = 0x0f << 8, */
/* 	S9_X_shift                                        = 8, */
/* 	S9_Y_mask                                         = 0x0f << 12, */
/* 	S9_Y_shift                                        = 12, */
/* 	S10_X_mask                                        = 0x0f << 16, */
/* 	S10_X_shift                                       = 16, */
/* 	S10_Y_mask                                        = 0x0f << 20, */
/* 	S10_Y_shift                                       = 20, */
/* 	S11_X_mask                                        = 0x0f << 24, */
/* 	S11_X_shift                                       = 24, */
/* 	S11_Y_mask                                        = 0x0f << 28, */
/* 	S11_Y_shift                                       = 28, */
    PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_3                     = 0x00028c34,
/* 	S12_X_mask                                        = 0x0f << 0, */
/* 	S12_X_shift                                       = 0, */
/* 	S12_Y_mask                                        = 0x0f << 4, */
/* 	S12_Y_shift                                       = 4, */
/* 	S13_X_mask                                        = 0x0f << 8, */
/* 	S13_X_shift                                       = 8, */
/* 	S13_Y_mask                                        = 0x0f << 12, */
/* 	S13_Y_shift                                       = 12, */
/* 	S14_X_mask                                        = 0x0f << 16, */
/* 	S14_X_shift                                       = 16, */
/* 	S14_Y_mask                                        = 0x0f << 20, */
/* 	S14_Y_shift                                       = 20, */
/* 	S15_X_mask                                        = 0x0f << 24, */
/* 	S15_X_shift                                       = 24, */
/* 	S15_Y_mask                                        = 0x0f << 28, */
/* 	S15_Y_shift                                       = 28, */
    PA_SC_AA_MASK_X0Y0_X1Y0                               = 0x00028c38,
	AA_MASK_X0Y0_mask                                 = 0xffff << 0,
	AA_MASK_X0Y0_shift                                = 0,
	AA_MASK_X1Y0_mask                                 = 0xffff << 16,
	AA_MASK_X1Y0_shift                                = 16,
    PA_SC_AA_MASK_X0Y1_X1Y1                               = 0x00028c3c,
	AA_MASK_X0Y1_mask                                 = 0xffff << 0,
	AA_MASK_X0Y1_shift                                = 0,
	AA_MASK_X1Y1_mask                                 = 0xffff << 16,
	AA_MASK_X1Y1_shift                                = 16,
    VGT_VERTEX_REUSE_BLOCK_CNTL                           = 0x00028c58,
	VTX_REUSE_DEPTH_mask                              = 0xff << 0,
	VTX_REUSE_DEPTH_shift                             = 0,
    VGT_OUT_DEALLOC_CNTL                                  = 0x00028c5c,
	DEALLOC_DIST_mask                                 = 0x7f << 0,
	DEALLOC_DIST_shift                                = 0,
    CB_COLOR0_BASE                                        = 0x00028c60,
	CB_COLOR0_BASE_num                                = 12,
	CB_COLOR0_BASE_offset                             = 51,
    CB_COLOR0_PITCH                                       = 0x00028c64,
	CB_COLOR0_PITCH_num                               = 12,
	CB_COLOR0_PITCH_offset                            = 51,
	CB_COLOR0_PITCH__TILE_MAX_mask                    = 0x7ff << 0,
	CB_COLOR0_PITCH__TILE_MAX_shift                   = 0,
    CB_COLOR0_SLICE                                       = 0x00028c68,
	CB_COLOR0_SLICE_num                               = 12,
	CB_COLOR0_SLICE_offset                            = 51,
	CB_COLOR0_SLICE__TILE_MAX_mask                    = 0x3fffff << 0,
	CB_COLOR0_SLICE__TILE_MAX_shift                   = 0,
    CB_COLOR0_VIEW                                        = 0x00028c6c,
	CB_COLOR0_VIEW_num                                = 12,
	CB_COLOR0_VIEW_offset                             = 51,
/* 	SLICE_START_mask                                  = 0x7ff << 0, */
/* 	SLICE_START_shift                                 = 0, */
/* 	SLICE_MAX_mask                                    = 0x7ff << 13, */
/* 	SLICE_MAX_shift                                   = 13, */
    CB_COLOR0_INFO                                        = 0x00028c70,
	CB_COLOR0_INFO_num                                = 12,
	CB_COLOR0_INFO_offset                             = 51,
	ENDIAN_mask                                       = 0x03 << 0,
	ENDIAN_shift                                      = 0,
	    ENDIAN_NONE                                   = 0x00,
	    ENDIAN_8IN16                                  = 0x01,
	    ENDIAN_8IN32                                  = 0x02,
	    ENDIAN_8IN64                                  = 0x03,
	CB_COLOR0_INFO__FORMAT_mask                       = 0x3f << 2,
	CB_COLOR0_INFO__FORMAT_shift                      = 2,
	    COLOR_INVALID                                 = 0x00,
	    COLOR_8                                       = 0x01,
	    COLOR_16                                      = 0x05,
	    COLOR_16_FLOAT                                = 0x06,
	    COLOR_8_8                                     = 0x07,
	    COLOR_5_6_5                                   = 0x08,
	    COLOR_1_5_5_5                                 = 0x0a,
	    COLOR_4_4_4_4                                 = 0x0b,
	    COLOR_5_5_5_1                                 = 0x0c,
	    COLOR_32                                      = 0x0d,
	    COLOR_32_FLOAT                                = 0x0e,
	    COLOR_16_16                                   = 0x0f,
	    COLOR_16_16_FLOAT                             = 0x10,
	    COLOR_8_24                                    = 0x11,
	    COLOR_24_8                                    = 0x13,
	    COLOR_10_11_11                                = 0x15,
	    COLOR_10_11_11_FLOAT                          = 0x16,
	    COLOR_2_10_10_10                              = 0x19,
	    COLOR_8_8_8_8                                 = 0x1a,
	    COLOR_10_10_10_2                              = 0x1b,
	    COLOR_X24_8_32_FLOAT                          = 0x1c,
	    COLOR_32_32                                   = 0x1d,
	    COLOR_32_32_FLOAT                             = 0x1e,
	    COLOR_16_16_16_16                             = 0x1f,
	    COLOR_16_16_16_16_FLOAT                       = 0x20,
	    COLOR_32_32_32_32                             = 0x22,
	    COLOR_32_32_32_32_FLOAT                       = 0x23,
	CB_COLOR0_INFO__ARRAY_MODE_mask                   = 0x0f << 8,
	CB_COLOR0_INFO__ARRAY_MODE_shift                  = 8,
	    ARRAY_LINEAR_GENERAL                          = 0x00,
	    ARRAY_LINEAR_ALIGNED                          = 0x01,
/* 	    ARRAY_1D_TILED_THIN1                          = 0x02, */
/* 	    ARRAY_2D_TILED_THIN1                          = 0x04, */
	NUMBER_TYPE_mask                                  = 0x07 << 12,
	NUMBER_TYPE_shift                                 = 12,
	    NUMBER_UNORM                                  = 0x00,
	    NUMBER_SNORM                                  = 0x01,
	    NUMBER_UINT                                   = 0x04,
	    NUMBER_SINT                                   = 0x05,
	    NUMBER_SRGB                                   = 0x06,
	    NUMBER_FLOAT                                  = 0x07,
	COMP_SWAP_mask                                    = 0x03 << 15,
	COMP_SWAP_shift                                   = 15,
	    SWAP_STD                                      = 0x00,
	    SWAP_ALT                                      = 0x01,
	    SWAP_STD_REV                                  = 0x02,
	    SWAP_ALT_REV                                  = 0x03,
	FAST_CLEAR_bit                                    = 1 << 17,
	COMPRESSION_bit                                   = 1 << 18,
	BLEND_CLAMP_bit                                   = 1 << 19,
	BLEND_BYPASS_bit                                  = 1 << 20,
	SIMPLE_FLOAT_bit                                  = 1 << 21,
	CB_COLOR0_INFO__ROUND_MODE_bit                    = 1 << 22,
	TILE_COMPACT_bit                                  = 1 << 23,
	SOURCE_FORMAT_mask                                = 0x03 << 24,
	SOURCE_FORMAT_shift                               = 24,
	    EXPORT_4C_32BPC                               = 0x00,
	    EXPORT_4C_16BPC                               = 0x01,
	    EXPORT_2C_32BPC_GR                            = 0x02,
	    EXPORT_2C_32BPC_AR                            = 0x03,
	RAT_bit                                           = 1 << 26,
	RESOURCE_TYPE_mask                                = 0x07 << 27,
	RESOURCE_TYPE_shift                               = 27,
	    BUFFER                                        = 0x00,
	    TEXTURE1D                                     = 0x01,
	    TEXTURE1DARRAY                                = 0x02,
	    TEXTURE2D                                     = 0x03,
	    TEXTURE2DARRAY                                = 0x04,
	    TEXTURE3D                                     = 0x05,
	    STRUCTUREDBUFFER                              = 0x06,
	SOURCE_NUMBER_TYPE_mask                           = 0x03 << 30,
	SOURCE_NUMBER_TYPE_shift                          = 30,
	    EXPORT_FLOAT                                  = 0x00,
	    EXPORT_INT                                    = 0x01,
	    EXPORT_UNORM                                  = 0x02,
	    EXPORT_SNORM                                  = 0x03,
    CB_COLOR0_ATTRIB                                      = 0x00028c74,
	CB_COLOR0_ATTRIB_num                              = 12,
	CB_COLOR0_ATTRIB_offset                           = 51,
	IGNORE_SHADER_ENGINE_TILING_bit                   = 1 << 3,
	CB_COLOR0_ATTRIB__NON_DISP_TILING_ORDER_bit       = 1 << 4,
	CB_COLOR0_ATTRIB__TILE_SPLIT_mask                 = 0x0f << 5,
	CB_COLOR0_ATTRIB__TILE_SPLIT_shift                = 5,
/* 	    ADDR_SURF_TILE_SPLIT_64B                      = 0x00, */
/* 	    ADDR_SURF_TILE_SPLIT_128B                     = 0x01, */
/* 	    ADDR_SURF_TILE_SPLIT_256B                     = 0x02, */
/* 	    ADDR_SURF_TILE_SPLIT_512B                     = 0x03, */
/* 	    ADDR_SURF_TILE_SPLIT_1KB                      = 0x04, */
/* 	    ADDR_SURF_TILE_SPLIT_2KB                      = 0x05, */
/* 	    ADDR_SURF_TILE_SPLIT_4KB                      = 0x06, */
	CB_COLOR0_ATTRIB__NUM_BANKS_mask                  = 0x03 << 10,
	CB_COLOR0_ATTRIB__NUM_BANKS_shift                 = 10,
/* 	    ADDR_SURF_2_BANK                              = 0x00, */
/* 	    ADDR_SURF_4_BANK                              = 0x01, */
/* 	    ADDR_SURF_8_BANK                              = 0x02, */
/* 	    ADDR_SURF_16_BANK                             = 0x03, */
	CB_COLOR0_ATTRIB__BANK_WIDTH_mask                 = 0x03 << 13,
	CB_COLOR0_ATTRIB__BANK_WIDTH_shift                = 13,
/* 	    ADDR_SURF_BANK_WIDTH_1                        = 0x00, */
/* 	    ADDR_SURF_BANK_WIDTH_2                        = 0x01, */
/* 	    ADDR_SURF_BANK_WIDTH_4                        = 0x02, */
/* 	    ADDR_SURF_BANK_WIDTH_8                        = 0x03, */
	CB_COLOR0_ATTRIB__BANK_HEIGHT_mask                = 0x03 << 16,
	CB_COLOR0_ATTRIB__BANK_HEIGHT_shift               = 16,
/* 	    ADDR_SURF_BANK_HEIGHT_1                       = 0x00, */
/* 	    ADDR_SURF_BANK_HEIGHT_2                       = 0x01, */
/* 	    ADDR_SURF_BANK_HEIGHT_4                       = 0x02, */
/* 	    ADDR_SURF_BANK_HEIGHT_8                       = 0x03, */
	CB_COLOR0_ATTRIB__MACRO_TILE_ASPECT_mask          = 0x03 << 19,
	CB_COLOR0_ATTRIB__MACRO_TILE_ASPECT_shift         = 19,
/* 	    ADDR_SURF_MACRO_ASPECT_1                      = 0x00, */
/* 	    ADDR_SURF_MACRO_ASPECT_2                      = 0x01, */
/* 	    ADDR_SURF_MACRO_ASPECT_4                      = 0x02, */
/* 	    ADDR_SURF_MACRO_ASPECT_8                      = 0x03, */
	FMASK_BANK_HEIGHT_mask                            = 0x03 << 22,
	FMASK_BANK_HEIGHT_shift                           = 22,
/* 	    ADDR_SURF_BANK_HEIGHT_1                       = 0x00, */
/* 	    ADDR_SURF_BANK_HEIGHT_2                       = 0x01, */
/* 	    ADDR_SURF_BANK_HEIGHT_4                       = 0x02, */
/* 	    ADDR_SURF_BANK_HEIGHT_8                       = 0x03, */
	CB_COLOR0_ATTRIB__NUM_SAMPLES_mask                = 0x07 << 24,
	CB_COLOR0_ATTRIB__NUM_SAMPLES_shift               = 24,
	NUM_FRAGMENTS_mask                                = 0x03 << 27,
	NUM_FRAGMENTS_shift                               = 27,
	FORCE_DST_ALPHA_1_bit                             = 1 << 31,
    CB_COLOR0_DIM                                         = 0x00028c78,
	CB_COLOR0_DIM_num                                 = 12,
	CB_COLOR0_DIM_offset                              = 51,
	WIDTH_MAX_mask                                    = 0xffff << 0,
	WIDTH_MAX_shift                                   = 0,
	HEIGHT_MAX_mask                                   = 0xffff << 16,
	HEIGHT_MAX_shift                                  = 16,
    CB_COLOR0_CMASK                                       = 0x00028c7c,
	CB_COLOR0_CMASK_num                               = 8,
	CB_COLOR0_CMASK_offset                            = 60,
    CB_COLOR0_CMASK_SLICE                                 = 0x00028c80,
	CB_COLOR0_CMASK_SLICE_num                         = 8,
	CB_COLOR0_CMASK_SLICE_offset                      = 60,
	CB_COLOR0_CMASK_SLICE__TILE_MAX_mask              = 0x3fff << 0,
	CB_COLOR0_CMASK_SLICE__TILE_MAX_shift             = 0,
    CB_COLOR0_FMASK                                       = 0x00028c84,
	CB_COLOR0_FMASK_num                               = 8,
	CB_COLOR0_FMASK_offset                            = 60,
    CB_COLOR0_FMASK_SLICE                                 = 0x00028c88,
	CB_COLOR0_FMASK_SLICE_num                         = 8,
	CB_COLOR0_FMASK_SLICE_offset                      = 60,
	CB_COLOR0_FMASK_SLICE__TILE_MAX_mask              = 0x3fffff << 0,
	CB_COLOR0_FMASK_SLICE__TILE_MAX_shift             = 0,
    CB_COLOR0_CLEAR_WORD0                                 = 0x00028c8c,
	CB_COLOR0_CLEAR_WORD0_num                         = 8,
	CB_COLOR0_CLEAR_WORD0_offset                      = 60,
    CB_COLOR0_CLEAR_WORD1                                 = 0x00028c90,
	CB_COLOR0_CLEAR_WORD1_num                         = 8,
	CB_COLOR0_CLEAR_WORD1_offset                      = 60,
    CB_COLOR0_CLEAR_WORD2                                 = 0x00028c94,
	CB_COLOR0_CLEAR_WORD2_num                         = 8,
	CB_COLOR0_CLEAR_WORD2_offset                      = 60,
    CB_COLOR0_CLEAR_WORD3                                 = 0x00028c98,
	CB_COLOR0_CLEAR_WORD3_num                         = 8,
	CB_COLOR0_CLEAR_WORD3_offset                      = 60,
    SQ_ALU_CONST_CACHE_HS_0                               = 0x00028f00,
	SQ_ALU_CONST_CACHE_HS_0_num                       = 16,
    SQ_ALU_CONST_CACHE_LS_0                               = 0x00028f40,
	SQ_ALU_CONST_CACHE_LS_0_num                       = 16,
    SQ_ALU_CONST_BUFFER_SIZE_HS_0                         = 0x00028f80,
	SQ_ALU_CONST_BUFFER_SIZE_HS_0_num                 = 16,
	SQ_ALU_CONST_BUFFER_SIZE_HS_0__DATA_mask          = 0x1ff << 0,
	SQ_ALU_CONST_BUFFER_SIZE_HS_0__DATA_shift         = 0,
    SQ_ALU_CONST_BUFFER_SIZE_LS_0                         = 0x00028fc0,
	SQ_ALU_CONST_BUFFER_SIZE_LS_0_num                 = 16,
	SQ_ALU_CONST_BUFFER_SIZE_LS_0__DATA_mask          = 0x1ff << 0,
	SQ_ALU_CONST_BUFFER_SIZE_LS_0__DATA_shift         = 0,
    SQ_VTX_CONSTANT_WORD0_0                               = 0x00030000,
    SQ_TEX_RESOURCE_WORD0_0                               = 0x00030000,
	DIM_mask                                          = 0x07 << 0,
	DIM_shift                                         = 0,
	    SQ_TEX_DIM_1D                                 = 0x00,
	    SQ_TEX_DIM_2D                                 = 0x01,
	    SQ_TEX_DIM_3D                                 = 0x02,
	    SQ_TEX_DIM_CUBEMAP                            = 0x03,
	    SQ_TEX_DIM_1D_ARRAY                           = 0x04,
	    SQ_TEX_DIM_2D_ARRAY                           = 0x05,
	    SQ_TEX_DIM_2D_MSAA                            = 0x06,
	    SQ_TEX_DIM_2D_ARRAY_MSAA                      = 0x07,
/* 	IGNORE_SHADER_ENGINE_TILING_bit                   = 1 << 3, */
	SQ_TEX_RESOURCE_WORD0_0__NON_DISP_TILING_ORDER_mask= 0x03 << 4,
	SQ_TEX_RESOURCE_WORD0_0__NON_DISP_TILING_ORDER_shift= 4,
	PITCH_mask                                        = 0xfff << 6,
	PITCH_shift                                       = 6,
	TEX_WIDTH_mask                                    = 0x3fff << 18,
	TEX_WIDTH_shift                                   = 18,
    SQ_VTX_CONSTANT_WORD1_0                               = 0x00030004,
    SQ_TEX_RESOURCE_WORD1_0                               = 0x00030004,
	TEX_HEIGHT_mask                                   = 0x3fff << 0,
	TEX_HEIGHT_shift                                  = 0,
	TEX_DEPTH_mask                                    = 0x1fff << 14,
	TEX_DEPTH_shift                                   = 14,
	SQ_TEX_RESOURCE_WORD1_0__ARRAY_MODE_mask          = 0x0f << 28,
	SQ_TEX_RESOURCE_WORD1_0__ARRAY_MODE_shift         = 28,
    SQ_VTX_CONSTANT_WORD2_0                               = 0x00030008,
	BASE_ADDRESS_HI_mask                              = 0xff << 0,
	BASE_ADDRESS_HI_shift                             = 0,
	SQ_VTX_CONSTANT_WORD2_0__STRIDE_mask              = 0xfff << 8,
	SQ_VTX_CONSTANT_WORD2_0__STRIDE_shift             = 8,
	SQ_VTX_CONSTANT_WORD2_0__DATA_FORMAT_mask         = 0x3f << 20,
	SQ_VTX_CONSTANT_WORD2_0__DATA_FORMAT_shift        = 20,
	SQ_VTX_CONSTANT_WORD2_0__NUM_FORMAT_ALL_mask      = 0x03 << 26,
	SQ_VTX_CONSTANT_WORD2_0__NUM_FORMAT_ALL_shift     = 26,
/* 	    SQ_NUM_FORMAT_NORM                            = 0x00, */
/* 	    SQ_NUM_FORMAT_INT                             = 0x01, */
/* 	    SQ_NUM_FORMAT_SCALED                          = 0x02, */
	SQ_VTX_CONSTANT_WORD2_0__FORMAT_COMP_ALL_bit      = 1 << 28,
	SQ_VTX_CONSTANT_WORD2_0__SRF_MODE_ALL_bit         = 1 << 29,
	SQ_VTX_CONSTANT_WORD2_0__ENDIAN_SWAP_mask         = 0x03 << 30,
	SQ_VTX_CONSTANT_WORD2_0__ENDIAN_SWAP_shift        = 30,
/* 	    SQ_ENDIAN_NONE                                = 0x00, */
/* 	    SQ_ENDIAN_8IN16                               = 0x01, */
/* 	    SQ_ENDIAN_8IN32                               = 0x02, */
    SQ_TEX_RESOURCE_WORD2_0                               = 0x00030008,
    SQ_VTX_CONSTANT_WORD3_0                               = 0x0003000c,
	CACHE_SWIZZLE_bit                                 = 1 << 0,
	SQ_VTX_CONSTANT_WORD3_0__UNCACHED_bit             = 1 << 2,
	SQ_VTX_CONSTANT_WORD3_0__DST_SEL_X_mask           = 0x07 << 3,
	SQ_VTX_CONSTANT_WORD3_0__DST_SEL_X_shift          = 3,
/* 	    SQ_SEL_X                                      = 0x00, */
/* 	    SQ_SEL_Y                                      = 0x01, */
/* 	    SQ_SEL_Z                                      = 0x02, */
/* 	    SQ_SEL_W                                      = 0x03, */
/* 	    SQ_SEL_0                                      = 0x04, */
/* 	    SQ_SEL_1                                      = 0x05, */
	SQ_VTX_CONSTANT_WORD3_0__DST_SEL_Y_mask           = 0x07 << 6,
	SQ_VTX_CONSTANT_WORD3_0__DST_SEL_Y_shift          = 6,
/* 	    SQ_SEL_X                                      = 0x00, */
/* 	    SQ_SEL_Y                                      = 0x01, */
/* 	    SQ_SEL_Z                                      = 0x02, */
/* 	    SQ_SEL_W                                      = 0x03, */
/* 	    SQ_SEL_0                                      = 0x04, */
/* 	    SQ_SEL_1                                      = 0x05, */
	SQ_VTX_CONSTANT_WORD3_0__DST_SEL_Z_mask           = 0x07 << 9,
	SQ_VTX_CONSTANT_WORD3_0__DST_SEL_Z_shift          = 9,
/* 	    SQ_SEL_X                                      = 0x00, */
/* 	    SQ_SEL_Y                                      = 0x01, */
/* 	    SQ_SEL_Z                                      = 0x02, */
/* 	    SQ_SEL_W                                      = 0x03, */
/* 	    SQ_SEL_0                                      = 0x04, */
/* 	    SQ_SEL_1                                      = 0x05, */
	SQ_VTX_CONSTANT_WORD3_0__DST_SEL_W_mask           = 0x07 << 12,
	SQ_VTX_CONSTANT_WORD3_0__DST_SEL_W_shift          = 12,
/* 	    SQ_SEL_X                                      = 0x00, */
/* 	    SQ_SEL_Y                                      = 0x01, */
/* 	    SQ_SEL_Z                                      = 0x02, */
/* 	    SQ_SEL_W                                      = 0x03, */
/* 	    SQ_SEL_0                                      = 0x04, */
/* 	    SQ_SEL_1                                      = 0x05, */
    SQ_TEX_RESOURCE_WORD3_0                               = 0x0003000c,
    SQ_TEX_RESOURCE_WORD4_0                               = 0x00030010,
	FORMAT_COMP_X_mask                                = 0x03 << 0,
	FORMAT_COMP_X_shift                               = 0,
	    SQ_FORMAT_COMP_UNSIGNED                       = 0x00,
	    SQ_FORMAT_COMP_SIGNED                         = 0x01,
	    SQ_FORMAT_COMP_UNSIGNED_BIASED                = 0x02,
	FORMAT_COMP_Y_mask                                = 0x03 << 2,
	FORMAT_COMP_Y_shift                               = 2,
/* 	    SQ_FORMAT_COMP_UNSIGNED                       = 0x00, */
/* 	    SQ_FORMAT_COMP_SIGNED                         = 0x01, */
/* 	    SQ_FORMAT_COMP_UNSIGNED_BIASED                = 0x02, */
	FORMAT_COMP_Z_mask                                = 0x03 << 4,
	FORMAT_COMP_Z_shift                               = 4,
/* 	    SQ_FORMAT_COMP_UNSIGNED                       = 0x00, */
/* 	    SQ_FORMAT_COMP_SIGNED                         = 0x01, */
/* 	    SQ_FORMAT_COMP_UNSIGNED_BIASED                = 0x02, */
	FORMAT_COMP_W_mask                                = 0x03 << 6,
	FORMAT_COMP_W_shift                               = 6,
/* 	    SQ_FORMAT_COMP_UNSIGNED                       = 0x00, */
/* 	    SQ_FORMAT_COMP_SIGNED                         = 0x01, */
/* 	    SQ_FORMAT_COMP_UNSIGNED_BIASED                = 0x02, */
	SQ_TEX_RESOURCE_WORD4_0__NUM_FORMAT_ALL_mask      = 0x03 << 8,
	SQ_TEX_RESOURCE_WORD4_0__NUM_FORMAT_ALL_shift     = 8,
/* 	    SQ_NUM_FORMAT_NORM                            = 0x00, */
/* 	    SQ_NUM_FORMAT_INT                             = 0x01, */
/* 	    SQ_NUM_FORMAT_SCALED                          = 0x02, */
	SQ_TEX_RESOURCE_WORD4_0__SRF_MODE_ALL_bit         = 1 << 10,
	SQ_TEX_RESOURCE_WORD4_0__FORCE_DEGAMMA_bit        = 1 << 11,
	SQ_TEX_RESOURCE_WORD4_0__ENDIAN_SWAP_mask         = 0x03 << 12,
	SQ_TEX_RESOURCE_WORD4_0__ENDIAN_SWAP_shift        = 12,
/* 	    SQ_ENDIAN_NONE                                = 0x00, */
/* 	    SQ_ENDIAN_8IN16                               = 0x01, */
/* 	    SQ_ENDIAN_8IN32                               = 0x02, */
	LOG2_NUM_FRAGMENTS_mask                           = 0x03 << 14,
	LOG2_NUM_FRAGMENTS_shift                          = 14,
	SQ_TEX_RESOURCE_WORD4_0__DST_SEL_X_mask           = 0x07 << 16,
	SQ_TEX_RESOURCE_WORD4_0__DST_SEL_X_shift          = 16,
/* 	    SQ_SEL_X                                      = 0x00, */
/* 	    SQ_SEL_Y                                      = 0x01, */
/* 	    SQ_SEL_Z                                      = 0x02, */
/* 	    SQ_SEL_W                                      = 0x03, */
/* 	    SQ_SEL_0                                      = 0x04, */
/* 	    SQ_SEL_1                                      = 0x05, */
	SQ_TEX_RESOURCE_WORD4_0__DST_SEL_Y_mask           = 0x07 << 19,
	SQ_TEX_RESOURCE_WORD4_0__DST_SEL_Y_shift          = 19,
/* 	    SQ_SEL_X                                      = 0x00, */
/* 	    SQ_SEL_Y                                      = 0x01, */
/* 	    SQ_SEL_Z                                      = 0x02, */
/* 	    SQ_SEL_W                                      = 0x03, */
/* 	    SQ_SEL_0                                      = 0x04, */
/* 	    SQ_SEL_1                                      = 0x05, */
	SQ_TEX_RESOURCE_WORD4_0__DST_SEL_Z_mask           = 0x07 << 22,
	SQ_TEX_RESOURCE_WORD4_0__DST_SEL_Z_shift          = 22,
/* 	    SQ_SEL_X                                      = 0x00, */
/* 	    SQ_SEL_Y                                      = 0x01, */
/* 	    SQ_SEL_Z                                      = 0x02, */
/* 	    SQ_SEL_W                                      = 0x03, */
/* 	    SQ_SEL_0                                      = 0x04, */
/* 	    SQ_SEL_1                                      = 0x05, */
	SQ_TEX_RESOURCE_WORD4_0__DST_SEL_W_mask           = 0x07 << 25,
	SQ_TEX_RESOURCE_WORD4_0__DST_SEL_W_shift          = 25,
/* 	    SQ_SEL_X                                      = 0x00, */
/* 	    SQ_SEL_Y                                      = 0x01, */
/* 	    SQ_SEL_Z                                      = 0x02, */
/* 	    SQ_SEL_W                                      = 0x03, */
/* 	    SQ_SEL_0                                      = 0x04, */
/* 	    SQ_SEL_1                                      = 0x05, */
	BASE_LEVEL_mask                                   = 0x0f << 28,
	BASE_LEVEL_shift                                  = 28,
    SQ_VTX_CONSTANT_WORD4_0                               = 0x00030010,
    SQ_TEX_RESOURCE_WORD5_0                               = 0x00030014,
	LAST_LEVEL_mask                                   = 0x0f << 0,
	LAST_LEVEL_shift                                  = 0,
	BASE_ARRAY_mask                                   = 0x1fff << 4,
	BASE_ARRAY_shift                                  = 4,
	LAST_ARRAY_mask                                   = 0x1fff << 17,
	LAST_ARRAY_shift                                  = 17,
    SQ_TEX_RESOURCE_WORD6_0                               = 0x00030018,
	PERF_MODULATION_mask                              = 0x07 << 3,
	PERF_MODULATION_shift                             = 3,
	INTERLACED_bit                                    = 1 << 6,
	SQ_TEX_RESOURCE_WORD6_0__MIN_LOD_mask             = 0xfff << 8,
	SQ_TEX_RESOURCE_WORD6_0__MIN_LOD_shift            = 8,
	SQ_TEX_RESOURCE_WORD6_0__TILE_SPLIT_mask          = 0x07 << 29,
	SQ_TEX_RESOURCE_WORD6_0__TILE_SPLIT_shift         = 29,
	    SQ_ADDR_SURF_TILE_SPLIT_64B                   = 0x00,
	    SQ_ADDR_SURF_TILE_SPLIT_128B                  = 0x01,
	    SQ_ADDR_SURF_TILE_SPLIT_256B                  = 0x02,
	    SQ_ADDR_SURF_TILE_SPLIT_512B                  = 0x03,
	    SQ_ADDR_SURF_TILE_SPLIT_1KB                   = 0x04,
	    SQ_ADDR_SURF_TILE_SPLIT_2KB                   = 0x05,
	    SQ_ADDR_SURF_TILE_SPLIT_4KB                   = 0x06,
    SQ_VTX_CONSTANT_WORD7_0                               = 0x0003001c,
	SQ_VTX_CONSTANT_WORD7_0__TYPE_mask                = 0x03 << 30,
	SQ_VTX_CONSTANT_WORD7_0__TYPE_shift               = 30,
	    SQ_TEX_VTX_INVALID_TEXTURE                    = 0x00,
	    SQ_TEX_VTX_INVALID_BUFFER                     = 0x01,
	    SQ_TEX_VTX_VALID_TEXTURE                      = 0x02,
	    SQ_TEX_VTX_VALID_BUFFER                       = 0x03,
    SQ_TEX_RESOURCE_WORD7_0                               = 0x0003001c,
	SQ_TEX_RESOURCE_WORD7_0__DATA_FORMAT_mask         = 0x3f << 0,
	SQ_TEX_RESOURCE_WORD7_0__DATA_FORMAT_shift        = 0,
	SQ_TEX_RESOURCE_WORD7_0__MACRO_TILE_ASPECT_mask   = 0x03 << 6,
	SQ_TEX_RESOURCE_WORD7_0__MACRO_TILE_ASPECT_shift  = 6,
	    SQ_ADDR_SURF_MACRO_ASPECT_1                   = 0x00,
	    SQ_ADDR_SURF_MACRO_ASPECT_2                   = 0x01,
	    SQ_ADDR_SURF_MACRO_ASPECT_4                   = 0x02,
	    SQ_ADDR_SURF_MACRO_ASPECT_8                   = 0x03,
	SQ_TEX_RESOURCE_WORD7_0__BANK_WIDTH_mask          = 0x03 << 8,
	SQ_TEX_RESOURCE_WORD7_0__BANK_WIDTH_shift         = 8,
	    SQ_ADDR_SURF_BANK_WH_1                        = 0x00,
	    SQ_ADDR_SURF_BANK_WH_2                        = 0x01,
	    SQ_ADDR_SURF_BANK_WH_4                        = 0x02,
	    SQ_ADDR_SURF_BANK_WH_8                        = 0x03,
	SQ_TEX_RESOURCE_WORD7_0__BANK_HEIGHT_mask         = 0x03 << 10,
	SQ_TEX_RESOURCE_WORD7_0__BANK_HEIGHT_shift        = 10,
/* 	    SQ_ADDR_SURF_BANK_WH_1                        = 0x00, */
/* 	    SQ_ADDR_SURF_BANK_WH_2                        = 0x01, */
/* 	    SQ_ADDR_SURF_BANK_WH_4                        = 0x02, */
/* 	    SQ_ADDR_SURF_BANK_WH_8                        = 0x03, */
	DEPTH_SAMPLE_ORDER_bit                            = 1 << 15,
	SQ_TEX_RESOURCE_WORD7_0__NUM_BANKS_mask           = 0x03 << 16,
	SQ_TEX_RESOURCE_WORD7_0__NUM_BANKS_shift          = 16,
	    SQ_ADDR_SURF_2_BANK                           = 0x00,
	    SQ_ADDR_SURF_4_BANK                           = 0x01,
	    SQ_ADDR_SURF_8_BANK                           = 0x02,
	    SQ_ADDR_SURF_16_BANK                          = 0x03,
	SQ_TEX_RESOURCE_WORD7_0__TYPE_mask                = 0x03 << 30,
	SQ_TEX_RESOURCE_WORD7_0__TYPE_shift               = 30,
/* 	    SQ_TEX_VTX_INVALID_TEXTURE                    = 0x00, */
/* 	    SQ_TEX_VTX_INVALID_BUFFER                     = 0x01, */
/* 	    SQ_TEX_VTX_VALID_TEXTURE                      = 0x02, */
/* 	    SQ_TEX_VTX_VALID_BUFFER                       = 0x03, */
    SQ_LOOP_CONST_DX10_0                                  = 0x0003a200,
    SQ_LOOP_CONST_0                                       = 0x0003a200,
	SQ_LOOP_CONST_0__COUNT_mask                       = 0xfff << 0,
	SQ_LOOP_CONST_0__COUNT_shift                      = 0,
	INIT_mask                                         = 0xfff << 12,
	INIT_shift                                        = 12,
	INC_mask                                          = 0xff << 24,
	INC_shift                                         = 24,
    SQ_JUMPTABLE_CONST_0                                  = 0x0003a200,
	CONST_A_mask                                      = 0xff << 0,
	CONST_A_shift                                     = 0,
	CONST_B_mask                                      = 0xff << 8,
	CONST_B_shift                                     = 8,
	CONST_C_mask                                      = 0xff << 16,
	CONST_C_shift                                     = 16,
	CONST_D_mask                                      = 0xff << 24,
	CONST_D_shift                                     = 24,
    SQ_BOOL_CONST_0                                       = 0x0003a500,
	SQ_BOOL_CONST_0_num                               = 6,
    SQ_TEX_SAMPLER_WORD0_0                                = 0x0003c000,
	CLAMP_X_mask                                      = 0x07 << 0,
	CLAMP_X_shift                                     = 0,
	    SQ_TEX_WRAP                                   = 0x00,
	    SQ_TEX_MIRROR                                 = 0x01,
	    SQ_TEX_CLAMP_LAST_TEXEL                       = 0x02,
	    SQ_TEX_MIRROR_ONCE_LAST_TEXEL                 = 0x03,
	    SQ_TEX_CLAMP_HALF_BORDER                      = 0x04,
	    SQ_TEX_MIRROR_ONCE_HALF_BORDER                = 0x05,
	    SQ_TEX_CLAMP_BORDER                           = 0x06,
	    SQ_TEX_MIRROR_ONCE_BORDER                     = 0x07,
	CLAMP_Y_mask                                      = 0x07 << 3,
	CLAMP_Y_shift                                     = 3,
/* 	    SQ_TEX_WRAP                                   = 0x00, */
/* 	    SQ_TEX_MIRROR                                 = 0x01, */
/* 	    SQ_TEX_CLAMP_LAST_TEXEL                       = 0x02, */
/* 	    SQ_TEX_MIRROR_ONCE_LAST_TEXEL                 = 0x03, */
/* 	    SQ_TEX_CLAMP_HALF_BORDER                      = 0x04, */
/* 	    SQ_TEX_MIRROR_ONCE_HALF_BORDER                = 0x05, */
/* 	    SQ_TEX_CLAMP_BORDER                           = 0x06, */
/* 	    SQ_TEX_MIRROR_ONCE_BORDER                     = 0x07, */
	CLAMP_Z_mask                                      = 0x07 << 6,
	CLAMP_Z_shift                                     = 6,
/* 	    SQ_TEX_WRAP                                   = 0x00, */
/* 	    SQ_TEX_MIRROR                                 = 0x01, */
/* 	    SQ_TEX_CLAMP_LAST_TEXEL                       = 0x02, */
/* 	    SQ_TEX_MIRROR_ONCE_LAST_TEXEL                 = 0x03, */
/* 	    SQ_TEX_CLAMP_HALF_BORDER                      = 0x04, */
/* 	    SQ_TEX_MIRROR_ONCE_HALF_BORDER                = 0x05, */
/* 	    SQ_TEX_CLAMP_BORDER                           = 0x06, */
/* 	    SQ_TEX_MIRROR_ONCE_BORDER                     = 0x07, */
	XY_MAG_FILTER_mask                                = 0x03 << 9,
	XY_MAG_FILTER_shift                               = 9,
	    SQ_TEX_XY_FILTER_POINT                        = 0x00,
	    SQ_TEX_XY_FILTER_BILINEAR                     = 0x01,
	XY_MIN_FILTER_mask                                = 0x03 << 11,
	XY_MIN_FILTER_shift                               = 11,
/* 	    SQ_TEX_XY_FILTER_POINT                        = 0x00, */
/* 	    SQ_TEX_XY_FILTER_BILINEAR                     = 0x01, */
	Z_FILTER_mask                                     = 0x03 << 13,
	Z_FILTER_shift                                    = 13,
	    SQ_TEX_Z_FILTER_NONE                          = 0x00,
	    SQ_TEX_Z_FILTER_POINT                         = 0x01,
	    SQ_TEX_Z_FILTER_LINEAR                        = 0x02,
	MIP_FILTER_mask                                   = 0x03 << 15,
	MIP_FILTER_shift                                  = 15,
/* 	    SQ_TEX_Z_FILTER_NONE                          = 0x00, */
/* 	    SQ_TEX_Z_FILTER_POINT                         = 0x01, */
/* 	    SQ_TEX_Z_FILTER_LINEAR                        = 0x02, */
	BORDER_COLOR_TYPE_mask                            = 0x03 << 20,
	BORDER_COLOR_TYPE_shift                           = 20,
	    SQ_TEX_BORDER_COLOR_TRANS_BLACK               = 0x00,
	    SQ_TEX_BORDER_COLOR_OPAQUE_BLACK              = 0x01,
	    SQ_TEX_BORDER_COLOR_OPAQUE_WHITE              = 0x02,
	    SQ_TEX_BORDER_COLOR_REGISTER                  = 0x03,
	DEPTH_COMPARE_FUNCTION_mask                       = 0x07 << 22,
	DEPTH_COMPARE_FUNCTION_shift                      = 22,
	    SQ_TEX_DEPTH_COMPARE_NEVER                    = 0x00,
	    SQ_TEX_DEPTH_COMPARE_LESS                     = 0x01,
	    SQ_TEX_DEPTH_COMPARE_EQUAL                    = 0x02,
	    SQ_TEX_DEPTH_COMPARE_LESSEQUAL                = 0x03,
	    SQ_TEX_DEPTH_COMPARE_GREATER                  = 0x04,
	    SQ_TEX_DEPTH_COMPARE_NOTEQUAL                 = 0x05,
	    SQ_TEX_DEPTH_COMPARE_GREATEREQUAL             = 0x06,
	    SQ_TEX_DEPTH_COMPARE_ALWAYS                   = 0x07,
	FORCE_UNNORMALIZED_bit                            = 1 << 25,
    SQ_TEX_SAMPLER_WORD1_0                                = 0x0003c004,
	SQ_TEX_SAMPLER_WORD1_0__MIN_LOD_mask              = 0xfff << 0,
	SQ_TEX_SAMPLER_WORD1_0__MIN_LOD_shift             = 0,
	MAX_LOD_mask                                      = 0xfff << 12,
	MAX_LOD_shift                                     = 12,
	PERF_MIP_mask                                     = 0x0f << 24,
	PERF_MIP_shift                                    = 24,
	PERF_Z_mask                                       = 0x0f << 28,
	PERF_Z_shift                                      = 28,
    SQ_TEX_SAMPLER_WORD2_0                                = 0x0003c008,
	SQ_TEX_SAMPLER_WORD2_0__LOD_BIAS_mask             = 0x3fff << 0,
	SQ_TEX_SAMPLER_WORD2_0__LOD_BIAS_shift            = 0,
	LOD_BIAS_SEC_mask                                 = 0x3f << 14,
	LOD_BIAS_SEC_shift                                = 14,
	MC_COORD_TRUNCATE_bit                             = 1 << 20,
	SQ_TEX_SAMPLER_WORD2_0__FORCE_DEGAMMA_bit         = 1 << 21,
	TRUNCATE_COORD_bit                                = 1 << 28,
	SQ_TEX_SAMPLER_WORD2_0__DISABLE_CUBE_WRAP_bit     = 1 << 29,
	SQ_TEX_SAMPLER_WORD2_0__TYPE_bit                  = 1 << 31,
    SQ_VTX_BASE_VTX_LOC                                   = 0x0003cff0,
    SQ_VTX_START_INST_LOC                                 = 0x0003cff4,
    SQ_TEX_SAMPLER_CLEAR                                  = 0x0003ff00,
    SQ_TEX_RESOURCE_CLEAR                                 = 0x0003ff04,
    SQ_LOOP_BOOL_CLEAR                                    = 0x0003ff08,
    PA_CL_GB_VERT_DISC_ADJ                                = 0x0028be8c,

} ;

#endif /* _CAYMAN_REG_AUTO */

