//------------------------------------------------------------------------------
// GB_free_memory: wrapper for free
//------------------------------------------------------------------------------

// SuiteSparse:GraphBLAS, Timothy A. Davis, (c) 2017-2021, All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0

//------------------------------------------------------------------------------

// A wrapper for free.  If p is NULL on input, it is not freed.

// The memory is freed using the free() function pointer passed in to GrB_init,
// which is typically the ANSI C free function.  The free_pool is bypassed.

#include "GB.h"

GB_PUBLIC   // accessed by the MATLAB tests in GraphBLAS/Test only
void GB_free_memory         // free memory, bypassing the free_pool
(
    // input/output
    void **p,               // pointer to allocated block of memory to free
    // input
    size_t size_allocated   // # of bytes actually allocated
)
{

    if (p != NULL && (*p) != NULL)
    { 
        if (GB_Global_malloc_tracking_get ( ))
        {
            // for memory usage testing only
            GB_Global_nmalloc_decrement ( ) ;
        }
        ASSERT (size_allocated == GB_Global_memtable_size (*p)) ;
//      printf ("\nhard free %p %ld\n", *p, size_allocated) ;

//      if (GB_Global_I_have_RMM ( ))
//      {
//          rmmdealloc (*p, size_allocated) ;
//      }
//      else

        {
            GB_Global_free_function (*p) ;
        }
//      GB_Global_free_pool_dump (2) ; GB_Global_memtable_dump ( ) ;
        (*p) = NULL ;
    }
}

