/* Orientation.c generated by valac 0.40.4, the Vala compiler
 * generated from Orientation.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU LGPL (version 2.1 or later).
 * See the COPYING file in this distribution.
 */


#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gdk/gdk.h>


#define TYPE_ORIENTATION (orientation_get_type ())

#define TYPE_ROTATION (rotation_get_type ())

#define TYPE_DIMENSIONS (dimensions_get_type ())
typedef struct _Dimensions Dimensions;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_BOX (box_get_type ())
typedef struct _Box Box;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef enum  {
	ORIENTATION_MIN = 1,
	ORIENTATION_TOP_LEFT = 1,
	ORIENTATION_TOP_RIGHT = 2,
	ORIENTATION_BOTTOM_RIGHT = 3,
	ORIENTATION_BOTTOM_LEFT = 4,
	ORIENTATION_LEFT_TOP = 5,
	ORIENTATION_RIGHT_TOP = 6,
	ORIENTATION_RIGHT_BOTTOM = 7,
	ORIENTATION_LEFT_BOTTOM = 8,
	ORIENTATION_MAX = 8
} Orientation;

typedef enum  {
	ROTATION_CLOCKWISE,
	ROTATION_COUNTERCLOCKWISE,
	ROTATION_MIRROR,
	ROTATION_UPSIDE_DOWN
} Rotation;

struct _Dimensions {
	gint width;
	gint height;
};

struct _Box {
	gint left;
	gint top;
	gint right;
	gint bottom;
};



GType orientation_get_type (void) G_GNUC_CONST;
gchar* orientation_to_string (Orientation self);
Orientation orientation_rotate_clockwise (Orientation self);
Orientation orientation_rotate_counterclockwise (Orientation self);
Orientation orientation_flip_top_to_bottom (Orientation self);
Orientation orientation_flip_left_to_right (Orientation self);
GType rotation_get_type (void) G_GNUC_CONST;
Orientation orientation_perform (Orientation self,
                                 Rotation rotation);
Rotation* orientation_to_rotations (Orientation self,
                                    int* result_length1);
GType dimensions_get_type (void) G_GNUC_CONST;
Dimensions* dimensions_dup (const Dimensions* self);
void dimensions_free (Dimensions* self);
void orientation_rotate_dimensions (Orientation self,
                                    Dimensions* dim,
                                    Dimensions* result);
void dimensions_init (Dimensions *self,
                      gint width,
                      gint height);
void orientation_derotate_dimensions (Orientation self,
                                      Dimensions* dim,
                                      Dimensions* result);
GdkPixbuf* orientation_rotate_pixbuf (Orientation self,
                                      GdkPixbuf* pixbuf);
void orientation_rotate_point (Orientation self,
                               Dimensions* space,
                               GdkPoint* point,
                               GdkPoint* result);
gboolean dimensions_has_area (Dimensions *self);
void orientation_derotate_point (Orientation self,
                                 Dimensions* space,
                                 GdkPoint* point,
                                 GdkPoint* result);
GType box_get_type (void) G_GNUC_CONST;
Box* box_dup (const Box* self);
void box_free (Box* self);
void orientation_rotate_box (Orientation self,
                             Dimensions* space,
                             Box* box,
                             Box* result);
void box_get_points (Box *self,
                     GdkPoint* top_left,
                     GdkPoint* bottom_right);
void box_from_points (GdkPoint* corner1,
                      GdkPoint* corner2,
                      Box* result);
void orientation_derotate_box (Orientation self,
                               Dimensions* space,
                               Box* box,
                               Box* result);
GdkPixbuf* rotation_perform (Rotation self,
                             GdkPixbuf* pixbuf);
Rotation rotation_opposite (Rotation self);


gchar*
orientation_to_string (Orientation self)
{
	gchar* result = NULL;
#line 20 "/home/jens/Source/shotwell/src/Orientation.vala"
	switch (self) {
#line 20 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_TOP_LEFT:
#line 133 "Orientation.c"
		{
			gchar* _tmp0_;
#line 22 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp0_ = g_strdup ("top-left");
#line 22 "/home/jens/Source/shotwell/src/Orientation.vala"
			result = _tmp0_;
#line 22 "/home/jens/Source/shotwell/src/Orientation.vala"
			return result;
#line 142 "Orientation.c"
		}
#line 20 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_TOP_RIGHT:
#line 146 "Orientation.c"
		{
			gchar* _tmp1_;
#line 25 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp1_ = g_strdup ("top-right");
#line 25 "/home/jens/Source/shotwell/src/Orientation.vala"
			result = _tmp1_;
#line 25 "/home/jens/Source/shotwell/src/Orientation.vala"
			return result;
#line 155 "Orientation.c"
		}
#line 20 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_BOTTOM_RIGHT:
#line 159 "Orientation.c"
		{
			gchar* _tmp2_;
#line 28 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp2_ = g_strdup ("bottom-right");
#line 28 "/home/jens/Source/shotwell/src/Orientation.vala"
			result = _tmp2_;
#line 28 "/home/jens/Source/shotwell/src/Orientation.vala"
			return result;
#line 168 "Orientation.c"
		}
#line 20 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_BOTTOM_LEFT:
#line 172 "Orientation.c"
		{
			gchar* _tmp3_;
#line 31 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp3_ = g_strdup ("bottom-left");
#line 31 "/home/jens/Source/shotwell/src/Orientation.vala"
			result = _tmp3_;
#line 31 "/home/jens/Source/shotwell/src/Orientation.vala"
			return result;
#line 181 "Orientation.c"
		}
#line 20 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_LEFT_TOP:
#line 185 "Orientation.c"
		{
			gchar* _tmp4_;
#line 34 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp4_ = g_strdup ("left-top");
#line 34 "/home/jens/Source/shotwell/src/Orientation.vala"
			result = _tmp4_;
#line 34 "/home/jens/Source/shotwell/src/Orientation.vala"
			return result;
#line 194 "Orientation.c"
		}
#line 20 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_RIGHT_TOP:
#line 198 "Orientation.c"
		{
			gchar* _tmp5_;
#line 37 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp5_ = g_strdup ("right-top");
#line 37 "/home/jens/Source/shotwell/src/Orientation.vala"
			result = _tmp5_;
#line 37 "/home/jens/Source/shotwell/src/Orientation.vala"
			return result;
#line 207 "Orientation.c"
		}
#line 20 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_RIGHT_BOTTOM:
#line 211 "Orientation.c"
		{
			gchar* _tmp6_;
#line 40 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp6_ = g_strdup ("right-bottom");
#line 40 "/home/jens/Source/shotwell/src/Orientation.vala"
			result = _tmp6_;
#line 40 "/home/jens/Source/shotwell/src/Orientation.vala"
			return result;
#line 220 "Orientation.c"
		}
#line 20 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_LEFT_BOTTOM:
#line 224 "Orientation.c"
		{
			gchar* _tmp7_;
#line 43 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp7_ = g_strdup ("left-bottom");
#line 43 "/home/jens/Source/shotwell/src/Orientation.vala"
			result = _tmp7_;
#line 43 "/home/jens/Source/shotwell/src/Orientation.vala"
			return result;
#line 233 "Orientation.c"
		}
		default:
		{
			gchar* _tmp8_;
#line 46 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp8_ = g_strdup_printf ("unknown orientation %d", (gint) self);
#line 46 "/home/jens/Source/shotwell/src/Orientation.vala"
			result = _tmp8_;
#line 46 "/home/jens/Source/shotwell/src/Orientation.vala"
			return result;
#line 244 "Orientation.c"
		}
	}
}


Orientation
orientation_rotate_clockwise (Orientation self)
{
	Orientation result = 0;
#line 51 "/home/jens/Source/shotwell/src/Orientation.vala"
	switch (self) {
#line 51 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_TOP_LEFT:
#line 258 "Orientation.c"
		{
#line 53 "/home/jens/Source/shotwell/src/Orientation.vala"
			result = ORIENTATION_RIGHT_TOP;
#line 53 "/home/jens/Source/shotwell/src/Orientation.vala"
			return result;
#line 264 "Orientation.c"
		}
#line 51 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_TOP_RIGHT:
#line 268 "Orientation.c"
		{
#line 56 "/home/jens/Source/shotwell/src/Orientation.vala"
			result = ORIENTATION_RIGHT_BOTTOM;
#line 56 "/home/jens/Source/shotwell/src/Orientation.vala"
			return result;
#line 274 "Orientation.c"
		}
#line 51 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_BOTTOM_RIGHT:
#line 278 "Orientation.c"
		{
#line 59 "/home/jens/Source/shotwell/src/Orientation.vala"
			result = ORIENTATION_LEFT_BOTTOM;
#line 59 "/home/jens/Source/shotwell/src/Orientation.vala"
			return result;
#line 284 "Orientation.c"
		}
#line 51 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_BOTTOM_LEFT:
#line 288 "Orientation.c"
		{
#line 62 "/home/jens/Source/shotwell/src/Orientation.vala"
			result = ORIENTATION_LEFT_TOP;
#line 62 "/home/jens/Source/shotwell/src/Orientation.vala"
			return result;
#line 294 "Orientation.c"
		}
#line 51 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_LEFT_TOP:
#line 298 "Orientation.c"
		{
#line 65 "/home/jens/Source/shotwell/src/Orientation.vala"
			result = ORIENTATION_TOP_RIGHT;
#line 65 "/home/jens/Source/shotwell/src/Orientation.vala"
			return result;
#line 304 "Orientation.c"
		}
#line 51 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_RIGHT_TOP:
#line 308 "Orientation.c"
		{
#line 68 "/home/jens/Source/shotwell/src/Orientation.vala"
			result = ORIENTATION_BOTTOM_RIGHT;
#line 68 "/home/jens/Source/shotwell/src/Orientation.vala"
			return result;
#line 314 "Orientation.c"
		}
#line 51 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_RIGHT_BOTTOM:
#line 318 "Orientation.c"
		{
#line 71 "/home/jens/Source/shotwell/src/Orientation.vala"
			result = ORIENTATION_BOTTOM_LEFT;
#line 71 "/home/jens/Source/shotwell/src/Orientation.vala"
			return result;
#line 324 "Orientation.c"
		}
#line 51 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_LEFT_BOTTOM:
#line 328 "Orientation.c"
		{
#line 74 "/home/jens/Source/shotwell/src/Orientation.vala"
			result = ORIENTATION_TOP_LEFT;
#line 74 "/home/jens/Source/shotwell/src/Orientation.vala"
			return result;
#line 334 "Orientation.c"
		}
		default:
		{
#line 77 "/home/jens/Source/shotwell/src/Orientation.vala"
			g_error ("Orientation.vala:77: rotate_clockwise: %d", (gint) self);
#line 340 "Orientation.c"
		}
	}
}


Orientation
orientation_rotate_counterclockwise (Orientation self)
{
	Orientation result = 0;
#line 82 "/home/jens/Source/shotwell/src/Orientation.vala"
	switch (self) {
#line 82 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_TOP_LEFT:
#line 354 "Orientation.c"
		{
#line 84 "/home/jens/Source/shotwell/src/Orientation.vala"
			result = ORIENTATION_LEFT_BOTTOM;
#line 84 "/home/jens/Source/shotwell/src/Orientation.vala"
			return result;
#line 360 "Orientation.c"
		}
#line 82 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_TOP_RIGHT:
#line 364 "Orientation.c"
		{
#line 87 "/home/jens/Source/shotwell/src/Orientation.vala"
			result = ORIENTATION_LEFT_TOP;
#line 87 "/home/jens/Source/shotwell/src/Orientation.vala"
			return result;
#line 370 "Orientation.c"
		}
#line 82 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_BOTTOM_RIGHT:
#line 374 "Orientation.c"
		{
#line 90 "/home/jens/Source/shotwell/src/Orientation.vala"
			result = ORIENTATION_RIGHT_TOP;
#line 90 "/home/jens/Source/shotwell/src/Orientation.vala"
			return result;
#line 380 "Orientation.c"
		}
#line 82 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_BOTTOM_LEFT:
#line 384 "Orientation.c"
		{
#line 93 "/home/jens/Source/shotwell/src/Orientation.vala"
			result = ORIENTATION_RIGHT_BOTTOM;
#line 93 "/home/jens/Source/shotwell/src/Orientation.vala"
			return result;
#line 390 "Orientation.c"
		}
#line 82 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_LEFT_TOP:
#line 394 "Orientation.c"
		{
#line 96 "/home/jens/Source/shotwell/src/Orientation.vala"
			result = ORIENTATION_BOTTOM_LEFT;
#line 96 "/home/jens/Source/shotwell/src/Orientation.vala"
			return result;
#line 400 "Orientation.c"
		}
#line 82 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_RIGHT_TOP:
#line 404 "Orientation.c"
		{
#line 99 "/home/jens/Source/shotwell/src/Orientation.vala"
			result = ORIENTATION_TOP_LEFT;
#line 99 "/home/jens/Source/shotwell/src/Orientation.vala"
			return result;
#line 410 "Orientation.c"
		}
#line 82 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_RIGHT_BOTTOM:
#line 414 "Orientation.c"
		{
#line 102 "/home/jens/Source/shotwell/src/Orientation.vala"
			result = ORIENTATION_TOP_RIGHT;
#line 102 "/home/jens/Source/shotwell/src/Orientation.vala"
			return result;
#line 420 "Orientation.c"
		}
#line 82 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_LEFT_BOTTOM:
#line 424 "Orientation.c"
		{
#line 105 "/home/jens/Source/shotwell/src/Orientation.vala"
			result = ORIENTATION_BOTTOM_RIGHT;
#line 105 "/home/jens/Source/shotwell/src/Orientation.vala"
			return result;
#line 430 "Orientation.c"
		}
		default:
		{
#line 108 "/home/jens/Source/shotwell/src/Orientation.vala"
			g_error ("Orientation.vala:108: rotate_counterclockwise: %d", (gint) self);
#line 436 "Orientation.c"
		}
	}
}


Orientation
orientation_flip_top_to_bottom (Orientation self)
{
	Orientation result = 0;
#line 113 "/home/jens/Source/shotwell/src/Orientation.vala"
	switch (self) {
#line 113 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_TOP_LEFT:
#line 450 "Orientation.c"
		{
#line 115 "/home/jens/Source/shotwell/src/Orientation.vala"
			result = ORIENTATION_BOTTOM_LEFT;
#line 115 "/home/jens/Source/shotwell/src/Orientation.vala"
			return result;
#line 456 "Orientation.c"
		}
#line 113 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_TOP_RIGHT:
#line 460 "Orientation.c"
		{
#line 118 "/home/jens/Source/shotwell/src/Orientation.vala"
			result = ORIENTATION_BOTTOM_RIGHT;
#line 118 "/home/jens/Source/shotwell/src/Orientation.vala"
			return result;
#line 466 "Orientation.c"
		}
#line 113 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_BOTTOM_RIGHT:
#line 470 "Orientation.c"
		{
#line 121 "/home/jens/Source/shotwell/src/Orientation.vala"
			result = ORIENTATION_TOP_RIGHT;
#line 121 "/home/jens/Source/shotwell/src/Orientation.vala"
			return result;
#line 476 "Orientation.c"
		}
#line 113 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_BOTTOM_LEFT:
#line 480 "Orientation.c"
		{
#line 124 "/home/jens/Source/shotwell/src/Orientation.vala"
			result = ORIENTATION_TOP_LEFT;
#line 124 "/home/jens/Source/shotwell/src/Orientation.vala"
			return result;
#line 486 "Orientation.c"
		}
#line 113 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_LEFT_TOP:
#line 490 "Orientation.c"
		{
#line 127 "/home/jens/Source/shotwell/src/Orientation.vala"
			result = ORIENTATION_LEFT_BOTTOM;
#line 127 "/home/jens/Source/shotwell/src/Orientation.vala"
			return result;
#line 496 "Orientation.c"
		}
#line 113 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_RIGHT_TOP:
#line 500 "Orientation.c"
		{
#line 130 "/home/jens/Source/shotwell/src/Orientation.vala"
			result = ORIENTATION_RIGHT_BOTTOM;
#line 130 "/home/jens/Source/shotwell/src/Orientation.vala"
			return result;
#line 506 "Orientation.c"
		}
#line 113 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_RIGHT_BOTTOM:
#line 510 "Orientation.c"
		{
#line 133 "/home/jens/Source/shotwell/src/Orientation.vala"
			result = ORIENTATION_RIGHT_TOP;
#line 133 "/home/jens/Source/shotwell/src/Orientation.vala"
			return result;
#line 516 "Orientation.c"
		}
#line 113 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_LEFT_BOTTOM:
#line 520 "Orientation.c"
		{
#line 136 "/home/jens/Source/shotwell/src/Orientation.vala"
			result = ORIENTATION_LEFT_TOP;
#line 136 "/home/jens/Source/shotwell/src/Orientation.vala"
			return result;
#line 526 "Orientation.c"
		}
		default:
		{
#line 139 "/home/jens/Source/shotwell/src/Orientation.vala"
			g_error ("Orientation.vala:139: flip_top_to_bottom: %d", (gint) self);
#line 532 "Orientation.c"
		}
	}
}


Orientation
orientation_flip_left_to_right (Orientation self)
{
	Orientation result = 0;
#line 144 "/home/jens/Source/shotwell/src/Orientation.vala"
	switch (self) {
#line 144 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_TOP_LEFT:
#line 546 "Orientation.c"
		{
#line 146 "/home/jens/Source/shotwell/src/Orientation.vala"
			result = ORIENTATION_TOP_RIGHT;
#line 146 "/home/jens/Source/shotwell/src/Orientation.vala"
			return result;
#line 552 "Orientation.c"
		}
#line 144 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_TOP_RIGHT:
#line 556 "Orientation.c"
		{
#line 149 "/home/jens/Source/shotwell/src/Orientation.vala"
			result = ORIENTATION_TOP_LEFT;
#line 149 "/home/jens/Source/shotwell/src/Orientation.vala"
			return result;
#line 562 "Orientation.c"
		}
#line 144 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_BOTTOM_RIGHT:
#line 566 "Orientation.c"
		{
#line 152 "/home/jens/Source/shotwell/src/Orientation.vala"
			result = ORIENTATION_BOTTOM_LEFT;
#line 152 "/home/jens/Source/shotwell/src/Orientation.vala"
			return result;
#line 572 "Orientation.c"
		}
#line 144 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_BOTTOM_LEFT:
#line 576 "Orientation.c"
		{
#line 155 "/home/jens/Source/shotwell/src/Orientation.vala"
			result = ORIENTATION_BOTTOM_RIGHT;
#line 155 "/home/jens/Source/shotwell/src/Orientation.vala"
			return result;
#line 582 "Orientation.c"
		}
#line 144 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_LEFT_TOP:
#line 586 "Orientation.c"
		{
#line 158 "/home/jens/Source/shotwell/src/Orientation.vala"
			result = ORIENTATION_RIGHT_TOP;
#line 158 "/home/jens/Source/shotwell/src/Orientation.vala"
			return result;
#line 592 "Orientation.c"
		}
#line 144 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_RIGHT_TOP:
#line 596 "Orientation.c"
		{
#line 161 "/home/jens/Source/shotwell/src/Orientation.vala"
			result = ORIENTATION_LEFT_TOP;
#line 161 "/home/jens/Source/shotwell/src/Orientation.vala"
			return result;
#line 602 "Orientation.c"
		}
#line 144 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_RIGHT_BOTTOM:
#line 606 "Orientation.c"
		{
#line 164 "/home/jens/Source/shotwell/src/Orientation.vala"
			result = ORIENTATION_LEFT_BOTTOM;
#line 164 "/home/jens/Source/shotwell/src/Orientation.vala"
			return result;
#line 612 "Orientation.c"
		}
#line 144 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_LEFT_BOTTOM:
#line 616 "Orientation.c"
		{
#line 167 "/home/jens/Source/shotwell/src/Orientation.vala"
			result = ORIENTATION_RIGHT_BOTTOM;
#line 167 "/home/jens/Source/shotwell/src/Orientation.vala"
			return result;
#line 622 "Orientation.c"
		}
		default:
		{
#line 170 "/home/jens/Source/shotwell/src/Orientation.vala"
			g_error ("Orientation.vala:170: flip_left_to_right: %d", (gint) self);
#line 628 "Orientation.c"
		}
	}
}


Orientation
orientation_perform (Orientation self,
                     Rotation rotation)
{
	Orientation result = 0;
#line 175 "/home/jens/Source/shotwell/src/Orientation.vala"
	switch (rotation) {
#line 175 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ROTATION_CLOCKWISE:
#line 643 "Orientation.c"
		{
#line 177 "/home/jens/Source/shotwell/src/Orientation.vala"
			result = orientation_rotate_clockwise (self);
#line 177 "/home/jens/Source/shotwell/src/Orientation.vala"
			return result;
#line 649 "Orientation.c"
		}
#line 175 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ROTATION_COUNTERCLOCKWISE:
#line 653 "Orientation.c"
		{
#line 180 "/home/jens/Source/shotwell/src/Orientation.vala"
			result = orientation_rotate_counterclockwise (self);
#line 180 "/home/jens/Source/shotwell/src/Orientation.vala"
			return result;
#line 659 "Orientation.c"
		}
#line 175 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ROTATION_MIRROR:
#line 663 "Orientation.c"
		{
#line 183 "/home/jens/Source/shotwell/src/Orientation.vala"
			result = orientation_flip_left_to_right (self);
#line 183 "/home/jens/Source/shotwell/src/Orientation.vala"
			return result;
#line 669 "Orientation.c"
		}
#line 175 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ROTATION_UPSIDE_DOWN:
#line 673 "Orientation.c"
		{
#line 186 "/home/jens/Source/shotwell/src/Orientation.vala"
			result = orientation_flip_top_to_bottom (self);
#line 186 "/home/jens/Source/shotwell/src/Orientation.vala"
			return result;
#line 679 "Orientation.c"
		}
		default:
		{
#line 189 "/home/jens/Source/shotwell/src/Orientation.vala"
			g_error ("Orientation.vala:189: perform: %d", (gint) rotation);
#line 685 "Orientation.c"
		}
	}
}


Rotation*
orientation_to_rotations (Orientation self,
                          int* result_length1)
{
	Rotation* result = NULL;
#line 194 "/home/jens/Source/shotwell/src/Orientation.vala"
	switch (self) {
#line 194 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_TOP_LEFT:
#line 700 "Orientation.c"
		{
			Rotation* _tmp0_;
			Rotation* _tmp1_;
			gint _tmp1__length1;
#line 197 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp0_ = g_new0 (Rotation, 0);
#line 197 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp1_ = _tmp0_;
#line 197 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp1__length1 = 0;
#line 197 "/home/jens/Source/shotwell/src/Orientation.vala"
			if (result_length1) {
#line 197 "/home/jens/Source/shotwell/src/Orientation.vala"
				*result_length1 = _tmp1__length1;
#line 715 "Orientation.c"
			}
#line 197 "/home/jens/Source/shotwell/src/Orientation.vala"
			result = _tmp1_;
#line 197 "/home/jens/Source/shotwell/src/Orientation.vala"
			return result;
#line 721 "Orientation.c"
		}
#line 194 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_TOP_RIGHT:
#line 725 "Orientation.c"
		{
			Rotation* _tmp2_;
			Rotation* _tmp3_;
			gint _tmp3__length1;
#line 200 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp2_ = g_new0 (Rotation, 1);
#line 200 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp2_[0] = ROTATION_MIRROR;
#line 200 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp3_ = _tmp2_;
#line 200 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp3__length1 = 1;
#line 200 "/home/jens/Source/shotwell/src/Orientation.vala"
			if (result_length1) {
#line 200 "/home/jens/Source/shotwell/src/Orientation.vala"
				*result_length1 = _tmp3__length1;
#line 742 "Orientation.c"
			}
#line 200 "/home/jens/Source/shotwell/src/Orientation.vala"
			result = _tmp3_;
#line 200 "/home/jens/Source/shotwell/src/Orientation.vala"
			return result;
#line 748 "Orientation.c"
		}
#line 194 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_BOTTOM_RIGHT:
#line 752 "Orientation.c"
		{
			Rotation* _tmp4_;
			Rotation* _tmp5_;
			gint _tmp5__length1;
#line 203 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp4_ = g_new0 (Rotation, 1);
#line 203 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp4_[0] = ROTATION_UPSIDE_DOWN;
#line 203 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp5_ = _tmp4_;
#line 203 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp5__length1 = 1;
#line 203 "/home/jens/Source/shotwell/src/Orientation.vala"
			if (result_length1) {
#line 203 "/home/jens/Source/shotwell/src/Orientation.vala"
				*result_length1 = _tmp5__length1;
#line 769 "Orientation.c"
			}
#line 203 "/home/jens/Source/shotwell/src/Orientation.vala"
			result = _tmp5_;
#line 203 "/home/jens/Source/shotwell/src/Orientation.vala"
			return result;
#line 775 "Orientation.c"
		}
#line 194 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_BOTTOM_LEFT:
#line 779 "Orientation.c"
		{
			Rotation* _tmp6_;
			Rotation* _tmp7_;
			gint _tmp7__length1;
#line 207 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp6_ = g_new0 (Rotation, 2);
#line 207 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp6_[0] = ROTATION_MIRROR;
#line 207 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp6_[1] = ROTATION_UPSIDE_DOWN;
#line 207 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp7_ = _tmp6_;
#line 207 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp7__length1 = 2;
#line 207 "/home/jens/Source/shotwell/src/Orientation.vala"
			if (result_length1) {
#line 207 "/home/jens/Source/shotwell/src/Orientation.vala"
				*result_length1 = _tmp7__length1;
#line 798 "Orientation.c"
			}
#line 207 "/home/jens/Source/shotwell/src/Orientation.vala"
			result = _tmp7_;
#line 207 "/home/jens/Source/shotwell/src/Orientation.vala"
			return result;
#line 804 "Orientation.c"
		}
#line 194 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_LEFT_TOP:
#line 808 "Orientation.c"
		{
			Rotation* _tmp8_;
			Rotation* _tmp9_;
			gint _tmp9__length1;
#line 210 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp8_ = g_new0 (Rotation, 2);
#line 210 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp8_[0] = ROTATION_COUNTERCLOCKWISE;
#line 210 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp8_[1] = ROTATION_UPSIDE_DOWN;
#line 210 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp9_ = _tmp8_;
#line 210 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp9__length1 = 2;
#line 210 "/home/jens/Source/shotwell/src/Orientation.vala"
			if (result_length1) {
#line 210 "/home/jens/Source/shotwell/src/Orientation.vala"
				*result_length1 = _tmp9__length1;
#line 827 "Orientation.c"
			}
#line 210 "/home/jens/Source/shotwell/src/Orientation.vala"
			result = _tmp9_;
#line 210 "/home/jens/Source/shotwell/src/Orientation.vala"
			return result;
#line 833 "Orientation.c"
		}
#line 194 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_RIGHT_TOP:
#line 837 "Orientation.c"
		{
			Rotation* _tmp10_;
			Rotation* _tmp11_;
			gint _tmp11__length1;
#line 213 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp10_ = g_new0 (Rotation, 1);
#line 213 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp10_[0] = ROTATION_CLOCKWISE;
#line 213 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp11_ = _tmp10_;
#line 213 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp11__length1 = 1;
#line 213 "/home/jens/Source/shotwell/src/Orientation.vala"
			if (result_length1) {
#line 213 "/home/jens/Source/shotwell/src/Orientation.vala"
				*result_length1 = _tmp11__length1;
#line 854 "Orientation.c"
			}
#line 213 "/home/jens/Source/shotwell/src/Orientation.vala"
			result = _tmp11_;
#line 213 "/home/jens/Source/shotwell/src/Orientation.vala"
			return result;
#line 860 "Orientation.c"
		}
#line 194 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_RIGHT_BOTTOM:
#line 864 "Orientation.c"
		{
			Rotation* _tmp12_;
			Rotation* _tmp13_;
			gint _tmp13__length1;
#line 216 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp12_ = g_new0 (Rotation, 2);
#line 216 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp12_[0] = ROTATION_CLOCKWISE;
#line 216 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp12_[1] = ROTATION_UPSIDE_DOWN;
#line 216 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp13_ = _tmp12_;
#line 216 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp13__length1 = 2;
#line 216 "/home/jens/Source/shotwell/src/Orientation.vala"
			if (result_length1) {
#line 216 "/home/jens/Source/shotwell/src/Orientation.vala"
				*result_length1 = _tmp13__length1;
#line 883 "Orientation.c"
			}
#line 216 "/home/jens/Source/shotwell/src/Orientation.vala"
			result = _tmp13_;
#line 216 "/home/jens/Source/shotwell/src/Orientation.vala"
			return result;
#line 889 "Orientation.c"
		}
#line 194 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_LEFT_BOTTOM:
#line 893 "Orientation.c"
		{
			Rotation* _tmp14_;
			Rotation* _tmp15_;
			gint _tmp15__length1;
#line 219 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp14_ = g_new0 (Rotation, 1);
#line 219 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp14_[0] = ROTATION_COUNTERCLOCKWISE;
#line 219 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp15_ = _tmp14_;
#line 219 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp15__length1 = 1;
#line 219 "/home/jens/Source/shotwell/src/Orientation.vala"
			if (result_length1) {
#line 219 "/home/jens/Source/shotwell/src/Orientation.vala"
				*result_length1 = _tmp15__length1;
#line 910 "Orientation.c"
			}
#line 219 "/home/jens/Source/shotwell/src/Orientation.vala"
			result = _tmp15_;
#line 219 "/home/jens/Source/shotwell/src/Orientation.vala"
			return result;
#line 916 "Orientation.c"
		}
		default:
		{
#line 222 "/home/jens/Source/shotwell/src/Orientation.vala"
			g_error ("Orientation.vala:222: to_rotations: %d", (gint) self);
#line 922 "Orientation.c"
		}
	}
}


void
orientation_rotate_dimensions (Orientation self,
                               Dimensions* dim,
                               Dimensions* result)
{
#line 226 "/home/jens/Source/shotwell/src/Orientation.vala"
	g_return_if_fail (dim != NULL);
#line 227 "/home/jens/Source/shotwell/src/Orientation.vala"
	switch (self) {
#line 227 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_TOP_LEFT:
#line 227 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_TOP_RIGHT:
#line 227 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_BOTTOM_RIGHT:
#line 227 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_BOTTOM_LEFT:
#line 945 "Orientation.c"
		{
			Dimensions _tmp0_;
#line 233 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp0_ = *dim;
#line 233 "/home/jens/Source/shotwell/src/Orientation.vala"
			*result = _tmp0_;
#line 233 "/home/jens/Source/shotwell/src/Orientation.vala"
			return;
#line 954 "Orientation.c"
		}
#line 227 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_LEFT_TOP:
#line 227 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_RIGHT_TOP:
#line 227 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_RIGHT_BOTTOM:
#line 227 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_LEFT_BOTTOM:
#line 964 "Orientation.c"
		{
			Dimensions _tmp1_;
			gint _tmp2_;
			Dimensions _tmp3_;
			gint _tmp4_;
			Dimensions _tmp5_ = {0};
#line 240 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp1_ = *dim;
#line 240 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp2_ = _tmp1_.height;
#line 240 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp3_ = *dim;
#line 240 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp4_ = _tmp3_.width;
#line 240 "/home/jens/Source/shotwell/src/Orientation.vala"
			dimensions_init (&_tmp5_, _tmp2_, _tmp4_);
#line 240 "/home/jens/Source/shotwell/src/Orientation.vala"
			*result = _tmp5_;
#line 240 "/home/jens/Source/shotwell/src/Orientation.vala"
			return;
#line 985 "Orientation.c"
		}
		default:
		{
#line 243 "/home/jens/Source/shotwell/src/Orientation.vala"
			g_error ("Orientation.vala:243: rotate_dimensions: %d", (gint) self);
#line 991 "Orientation.c"
		}
	}
}


void
orientation_derotate_dimensions (Orientation self,
                                 Dimensions* dim,
                                 Dimensions* result)
{
	Dimensions _tmp0_;
	Dimensions _tmp1_ = {0};
#line 247 "/home/jens/Source/shotwell/src/Orientation.vala"
	g_return_if_fail (dim != NULL);
#line 248 "/home/jens/Source/shotwell/src/Orientation.vala"
	_tmp0_ = *dim;
#line 248 "/home/jens/Source/shotwell/src/Orientation.vala"
	orientation_rotate_dimensions (self, &_tmp0_, &_tmp1_);
#line 248 "/home/jens/Source/shotwell/src/Orientation.vala"
	*result = _tmp1_;
#line 248 "/home/jens/Source/shotwell/src/Orientation.vala"
	return;
#line 1014 "Orientation.c"
}


static gpointer
_g_object_ref0 (gpointer self)
{
#line 256 "/home/jens/Source/shotwell/src/Orientation.vala"
	return self ? g_object_ref (self) : NULL;
#line 1023 "Orientation.c"
}


GdkPixbuf*
orientation_rotate_pixbuf (Orientation self,
                           GdkPixbuf* pixbuf)
{
	GdkPixbuf* result = NULL;
	GdkPixbuf* rotated = NULL;
#line 251 "/home/jens/Source/shotwell/src/Orientation.vala"
	g_return_val_if_fail (GDK_IS_PIXBUF (pixbuf), NULL);
#line 253 "/home/jens/Source/shotwell/src/Orientation.vala"
	switch (self) {
#line 253 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_TOP_LEFT:
#line 1039 "Orientation.c"
		{
			GdkPixbuf* _tmp0_;
#line 256 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp0_ = _g_object_ref0 (pixbuf);
#line 256 "/home/jens/Source/shotwell/src/Orientation.vala"
			_g_object_unref0 (rotated);
#line 256 "/home/jens/Source/shotwell/src/Orientation.vala"
			rotated = _tmp0_;
#line 257 "/home/jens/Source/shotwell/src/Orientation.vala"
			break;
#line 1050 "Orientation.c"
		}
#line 253 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_TOP_RIGHT:
#line 1054 "Orientation.c"
		{
			GdkPixbuf* _tmp1_;
#line 261 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp1_ = gdk_pixbuf_flip (pixbuf, TRUE);
#line 261 "/home/jens/Source/shotwell/src/Orientation.vala"
			_g_object_unref0 (rotated);
#line 261 "/home/jens/Source/shotwell/src/Orientation.vala"
			rotated = _tmp1_;
#line 262 "/home/jens/Source/shotwell/src/Orientation.vala"
			break;
#line 1065 "Orientation.c"
		}
#line 253 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_BOTTOM_RIGHT:
#line 1069 "Orientation.c"
		{
			GdkPixbuf* _tmp2_;
#line 265 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp2_ = gdk_pixbuf_rotate_simple (pixbuf, GDK_PIXBUF_ROTATE_UPSIDEDOWN);
#line 265 "/home/jens/Source/shotwell/src/Orientation.vala"
			_g_object_unref0 (rotated);
#line 265 "/home/jens/Source/shotwell/src/Orientation.vala"
			rotated = _tmp2_;
#line 266 "/home/jens/Source/shotwell/src/Orientation.vala"
			break;
#line 1080 "Orientation.c"
		}
#line 253 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_BOTTOM_LEFT:
#line 1084 "Orientation.c"
		{
			GdkPixbuf* _tmp3_;
#line 270 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp3_ = gdk_pixbuf_flip (pixbuf, FALSE);
#line 270 "/home/jens/Source/shotwell/src/Orientation.vala"
			_g_object_unref0 (rotated);
#line 270 "/home/jens/Source/shotwell/src/Orientation.vala"
			rotated = _tmp3_;
#line 271 "/home/jens/Source/shotwell/src/Orientation.vala"
			break;
#line 1095 "Orientation.c"
		}
#line 253 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_LEFT_TOP:
#line 1099 "Orientation.c"
		{
			GdkPixbuf* _tmp4_;
			GdkPixbuf* _tmp5_;
			GdkPixbuf* _tmp6_;
#line 274 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp4_ = gdk_pixbuf_rotate_simple (pixbuf, GDK_PIXBUF_ROTATE_COUNTERCLOCKWISE);
#line 274 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp5_ = _tmp4_;
#line 274 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp6_ = gdk_pixbuf_flip (_tmp5_, FALSE);
#line 274 "/home/jens/Source/shotwell/src/Orientation.vala"
			_g_object_unref0 (rotated);
#line 274 "/home/jens/Source/shotwell/src/Orientation.vala"
			rotated = _tmp6_;
#line 274 "/home/jens/Source/shotwell/src/Orientation.vala"
			_g_object_unref0 (_tmp5_);
#line 275 "/home/jens/Source/shotwell/src/Orientation.vala"
			break;
#line 1118 "Orientation.c"
		}
#line 253 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_RIGHT_TOP:
#line 1122 "Orientation.c"
		{
			GdkPixbuf* _tmp7_;
#line 278 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp7_ = gdk_pixbuf_rotate_simple (pixbuf, GDK_PIXBUF_ROTATE_CLOCKWISE);
#line 278 "/home/jens/Source/shotwell/src/Orientation.vala"
			_g_object_unref0 (rotated);
#line 278 "/home/jens/Source/shotwell/src/Orientation.vala"
			rotated = _tmp7_;
#line 279 "/home/jens/Source/shotwell/src/Orientation.vala"
			break;
#line 1133 "Orientation.c"
		}
#line 253 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_RIGHT_BOTTOM:
#line 1137 "Orientation.c"
		{
			GdkPixbuf* _tmp8_;
			GdkPixbuf* _tmp9_;
			GdkPixbuf* _tmp10_;
#line 282 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp8_ = gdk_pixbuf_rotate_simple (pixbuf, GDK_PIXBUF_ROTATE_CLOCKWISE);
#line 282 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp9_ = _tmp8_;
#line 282 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp10_ = gdk_pixbuf_flip (_tmp9_, FALSE);
#line 282 "/home/jens/Source/shotwell/src/Orientation.vala"
			_g_object_unref0 (rotated);
#line 282 "/home/jens/Source/shotwell/src/Orientation.vala"
			rotated = _tmp10_;
#line 282 "/home/jens/Source/shotwell/src/Orientation.vala"
			_g_object_unref0 (_tmp9_);
#line 283 "/home/jens/Source/shotwell/src/Orientation.vala"
			break;
#line 1156 "Orientation.c"
		}
#line 253 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_LEFT_BOTTOM:
#line 1160 "Orientation.c"
		{
			GdkPixbuf* _tmp11_;
#line 286 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp11_ = gdk_pixbuf_rotate_simple (pixbuf, GDK_PIXBUF_ROTATE_COUNTERCLOCKWISE);
#line 286 "/home/jens/Source/shotwell/src/Orientation.vala"
			_g_object_unref0 (rotated);
#line 286 "/home/jens/Source/shotwell/src/Orientation.vala"
			rotated = _tmp11_;
#line 287 "/home/jens/Source/shotwell/src/Orientation.vala"
			break;
#line 1171 "Orientation.c"
		}
		default:
		{
#line 290 "/home/jens/Source/shotwell/src/Orientation.vala"
			g_error ("Orientation.vala:290: rotate_pixbuf: %d", (gint) self);
#line 1177 "Orientation.c"
		}
	}
#line 293 "/home/jens/Source/shotwell/src/Orientation.vala"
	result = rotated;
#line 293 "/home/jens/Source/shotwell/src/Orientation.vala"
	return result;
#line 1184 "Orientation.c"
}


void
orientation_rotate_point (Orientation self,
                          Dimensions* space,
                          GdkPoint* point,
                          GdkPoint* result)
{
	GdkPoint _tmp0_;
	gint _tmp1_;
	GdkPoint _tmp2_;
	gint _tmp3_;
	Dimensions _tmp4_;
	gint _tmp5_;
	GdkPoint _tmp6_;
	gint _tmp7_;
	GdkPoint _tmp8_;
	gint _tmp9_;
	Dimensions _tmp10_;
	gint _tmp11_;
	GdkPoint rotated = {0};
#line 297 "/home/jens/Source/shotwell/src/Orientation.vala"
	g_return_if_fail (space != NULL);
#line 297 "/home/jens/Source/shotwell/src/Orientation.vala"
	g_return_if_fail (point != NULL);
#line 298 "/home/jens/Source/shotwell/src/Orientation.vala"
	_vala_assert (dimensions_has_area (space), "space.has_area()");
#line 299 "/home/jens/Source/shotwell/src/Orientation.vala"
	_tmp0_ = *point;
#line 299 "/home/jens/Source/shotwell/src/Orientation.vala"
	_tmp1_ = _tmp0_.x;
#line 299 "/home/jens/Source/shotwell/src/Orientation.vala"
	_vala_assert (_tmp1_ >= 0, "point.x >= 0");
#line 300 "/home/jens/Source/shotwell/src/Orientation.vala"
	_tmp2_ = *point;
#line 300 "/home/jens/Source/shotwell/src/Orientation.vala"
	_tmp3_ = _tmp2_.x;
#line 300 "/home/jens/Source/shotwell/src/Orientation.vala"
	_tmp4_ = *space;
#line 300 "/home/jens/Source/shotwell/src/Orientation.vala"
	_tmp5_ = _tmp4_.width;
#line 300 "/home/jens/Source/shotwell/src/Orientation.vala"
	_vala_assert (_tmp3_ < _tmp5_, "point.x < space.width");
#line 301 "/home/jens/Source/shotwell/src/Orientation.vala"
	_tmp6_ = *point;
#line 301 "/home/jens/Source/shotwell/src/Orientation.vala"
	_tmp7_ = _tmp6_.y;
#line 301 "/home/jens/Source/shotwell/src/Orientation.vala"
	_vala_assert (_tmp7_ >= 0, "point.y >= 0");
#line 302 "/home/jens/Source/shotwell/src/Orientation.vala"
	_tmp8_ = *point;
#line 302 "/home/jens/Source/shotwell/src/Orientation.vala"
	_tmp9_ = _tmp8_.y;
#line 302 "/home/jens/Source/shotwell/src/Orientation.vala"
	_tmp10_ = *space;
#line 302 "/home/jens/Source/shotwell/src/Orientation.vala"
	_tmp11_ = _tmp10_.height;
#line 302 "/home/jens/Source/shotwell/src/Orientation.vala"
	_vala_assert (_tmp9_ < _tmp11_, "point.y < space.height");
#line 304 "/home/jens/Source/shotwell/src/Orientation.vala"
	memset (&rotated, 0, sizeof (GdkPoint));
#line 306 "/home/jens/Source/shotwell/src/Orientation.vala"
	switch (self) {
#line 306 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_TOP_LEFT:
#line 1251 "Orientation.c"
		{
			GdkPoint _tmp12_;
#line 309 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp12_ = *point;
#line 309 "/home/jens/Source/shotwell/src/Orientation.vala"
			rotated = _tmp12_;
#line 310 "/home/jens/Source/shotwell/src/Orientation.vala"
			break;
#line 1260 "Orientation.c"
		}
#line 306 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_TOP_RIGHT:
#line 1264 "Orientation.c"
		{
			Dimensions _tmp13_;
			gint _tmp14_;
			GdkPoint _tmp15_;
			gint _tmp16_;
			GdkPoint _tmp17_;
			gint _tmp18_;
#line 314 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp13_ = *space;
#line 314 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp14_ = _tmp13_.width;
#line 314 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp15_ = *point;
#line 314 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp16_ = _tmp15_.x;
#line 314 "/home/jens/Source/shotwell/src/Orientation.vala"
			rotated.x = (_tmp14_ - _tmp16_) - 1;
#line 315 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp17_ = *point;
#line 315 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp18_ = _tmp17_.y;
#line 315 "/home/jens/Source/shotwell/src/Orientation.vala"
			rotated.y = _tmp18_;
#line 316 "/home/jens/Source/shotwell/src/Orientation.vala"
			break;
#line 1290 "Orientation.c"
		}
#line 306 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_BOTTOM_RIGHT:
#line 1294 "Orientation.c"
		{
			Dimensions _tmp19_;
			gint _tmp20_;
			GdkPoint _tmp21_;
			gint _tmp22_;
			Dimensions _tmp23_;
			gint _tmp24_;
			GdkPoint _tmp25_;
			gint _tmp26_;
#line 320 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp19_ = *space;
#line 320 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp20_ = _tmp19_.width;
#line 320 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp21_ = *point;
#line 320 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp22_ = _tmp21_.x;
#line 320 "/home/jens/Source/shotwell/src/Orientation.vala"
			rotated.x = (_tmp20_ - _tmp22_) - 1;
#line 321 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp23_ = *space;
#line 321 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp24_ = _tmp23_.height;
#line 321 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp25_ = *point;
#line 321 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp26_ = _tmp25_.y;
#line 321 "/home/jens/Source/shotwell/src/Orientation.vala"
			rotated.y = (_tmp24_ - _tmp26_) - 1;
#line 322 "/home/jens/Source/shotwell/src/Orientation.vala"
			break;
#line 1326 "Orientation.c"
		}
#line 306 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_BOTTOM_LEFT:
#line 1330 "Orientation.c"
		{
			GdkPoint _tmp27_;
			gint _tmp28_;
			Dimensions _tmp29_;
			gint _tmp30_;
			GdkPoint _tmp31_;
			gint _tmp32_;
#line 326 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp27_ = *point;
#line 326 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp28_ = _tmp27_.x;
#line 326 "/home/jens/Source/shotwell/src/Orientation.vala"
			rotated.x = _tmp28_;
#line 327 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp29_ = *space;
#line 327 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp30_ = _tmp29_.height;
#line 327 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp31_ = *point;
#line 327 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp32_ = _tmp31_.y;
#line 327 "/home/jens/Source/shotwell/src/Orientation.vala"
			rotated.y = (_tmp30_ - _tmp32_) - 1;
#line 328 "/home/jens/Source/shotwell/src/Orientation.vala"
			break;
#line 1356 "Orientation.c"
		}
#line 306 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_LEFT_TOP:
#line 1360 "Orientation.c"
		{
			GdkPoint _tmp33_;
			gint _tmp34_;
			GdkPoint _tmp35_;
			gint _tmp36_;
#line 332 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp33_ = *point;
#line 332 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp34_ = _tmp33_.y;
#line 332 "/home/jens/Source/shotwell/src/Orientation.vala"
			rotated.x = _tmp34_;
#line 333 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp35_ = *point;
#line 333 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp36_ = _tmp35_.x;
#line 333 "/home/jens/Source/shotwell/src/Orientation.vala"
			rotated.y = _tmp36_;
#line 334 "/home/jens/Source/shotwell/src/Orientation.vala"
			break;
#line 1380 "Orientation.c"
		}
#line 306 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_RIGHT_TOP:
#line 1384 "Orientation.c"
		{
			Dimensions _tmp37_;
			gint _tmp38_;
			GdkPoint _tmp39_;
			gint _tmp40_;
			GdkPoint _tmp41_;
			gint _tmp42_;
#line 338 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp37_ = *space;
#line 338 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp38_ = _tmp37_.height;
#line 338 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp39_ = *point;
#line 338 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp40_ = _tmp39_.y;
#line 338 "/home/jens/Source/shotwell/src/Orientation.vala"
			rotated.x = (_tmp38_ - _tmp40_) - 1;
#line 339 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp41_ = *point;
#line 339 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp42_ = _tmp41_.x;
#line 339 "/home/jens/Source/shotwell/src/Orientation.vala"
			rotated.y = _tmp42_;
#line 340 "/home/jens/Source/shotwell/src/Orientation.vala"
			break;
#line 1410 "Orientation.c"
		}
#line 306 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_RIGHT_BOTTOM:
#line 1414 "Orientation.c"
		{
			Dimensions _tmp43_;
			gint _tmp44_;
			GdkPoint _tmp45_;
			gint _tmp46_;
			Dimensions _tmp47_;
			gint _tmp48_;
			GdkPoint _tmp49_;
			gint _tmp50_;
#line 344 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp43_ = *space;
#line 344 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp44_ = _tmp43_.height;
#line 344 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp45_ = *point;
#line 344 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp46_ = _tmp45_.y;
#line 344 "/home/jens/Source/shotwell/src/Orientation.vala"
			rotated.x = (_tmp44_ - _tmp46_) - 1;
#line 345 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp47_ = *space;
#line 345 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp48_ = _tmp47_.width;
#line 345 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp49_ = *point;
#line 345 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp50_ = _tmp49_.x;
#line 345 "/home/jens/Source/shotwell/src/Orientation.vala"
			rotated.y = (_tmp48_ - _tmp50_) - 1;
#line 346 "/home/jens/Source/shotwell/src/Orientation.vala"
			break;
#line 1446 "Orientation.c"
		}
#line 306 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_LEFT_BOTTOM:
#line 1450 "Orientation.c"
		{
			GdkPoint _tmp51_;
			gint _tmp52_;
			Dimensions _tmp53_;
			gint _tmp54_;
			GdkPoint _tmp55_;
			gint _tmp56_;
#line 350 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp51_ = *point;
#line 350 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp52_ = _tmp51_.y;
#line 350 "/home/jens/Source/shotwell/src/Orientation.vala"
			rotated.x = _tmp52_;
#line 351 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp53_ = *space;
#line 351 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp54_ = _tmp53_.width;
#line 351 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp55_ = *point;
#line 351 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp56_ = _tmp55_.x;
#line 351 "/home/jens/Source/shotwell/src/Orientation.vala"
			rotated.y = (_tmp54_ - _tmp56_) - 1;
#line 352 "/home/jens/Source/shotwell/src/Orientation.vala"
			break;
#line 1476 "Orientation.c"
		}
		default:
		{
#line 355 "/home/jens/Source/shotwell/src/Orientation.vala"
			g_error ("Orientation.vala:355: rotate_point: %d", (gint) self);
#line 1482 "Orientation.c"
		}
	}
#line 358 "/home/jens/Source/shotwell/src/Orientation.vala"
	*result = rotated;
#line 358 "/home/jens/Source/shotwell/src/Orientation.vala"
	return;
#line 1489 "Orientation.c"
}


void
orientation_derotate_point (Orientation self,
                            Dimensions* space,
                            GdkPoint* point,
                            GdkPoint* result)
{
	GdkPoint derotated = {0};
#line 362 "/home/jens/Source/shotwell/src/Orientation.vala"
	g_return_if_fail (space != NULL);
#line 362 "/home/jens/Source/shotwell/src/Orientation.vala"
	g_return_if_fail (point != NULL);
#line 363 "/home/jens/Source/shotwell/src/Orientation.vala"
	_vala_assert (dimensions_has_area (space), "space.has_area()");
#line 365 "/home/jens/Source/shotwell/src/Orientation.vala"
	memset (&derotated, 0, sizeof (GdkPoint));
#line 367 "/home/jens/Source/shotwell/src/Orientation.vala"
	switch (self) {
#line 367 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_TOP_LEFT:
#line 1512 "Orientation.c"
		{
			GdkPoint _tmp0_;
#line 370 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp0_ = *point;
#line 370 "/home/jens/Source/shotwell/src/Orientation.vala"
			derotated = _tmp0_;
#line 371 "/home/jens/Source/shotwell/src/Orientation.vala"
			break;
#line 1521 "Orientation.c"
		}
#line 367 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_TOP_RIGHT:
#line 1525 "Orientation.c"
		{
			Dimensions _tmp1_;
			gint _tmp2_;
			GdkPoint _tmp3_;
			gint _tmp4_;
			GdkPoint _tmp5_;
			gint _tmp6_;
#line 375 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp1_ = *space;
#line 375 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp2_ = _tmp1_.width;
#line 375 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp3_ = *point;
#line 375 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp4_ = _tmp3_.x;
#line 375 "/home/jens/Source/shotwell/src/Orientation.vala"
			derotated.x = (_tmp2_ - _tmp4_) - 1;
#line 376 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp5_ = *point;
#line 376 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp6_ = _tmp5_.y;
#line 376 "/home/jens/Source/shotwell/src/Orientation.vala"
			derotated.y = _tmp6_;
#line 377 "/home/jens/Source/shotwell/src/Orientation.vala"
			break;
#line 1551 "Orientation.c"
		}
#line 367 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_BOTTOM_RIGHT:
#line 1555 "Orientation.c"
		{
			Dimensions _tmp7_;
			gint _tmp8_;
			GdkPoint _tmp9_;
			gint _tmp10_;
			Dimensions _tmp11_;
			gint _tmp12_;
			GdkPoint _tmp13_;
			gint _tmp14_;
#line 381 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp7_ = *space;
#line 381 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp8_ = _tmp7_.width;
#line 381 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp9_ = *point;
#line 381 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp10_ = _tmp9_.x;
#line 381 "/home/jens/Source/shotwell/src/Orientation.vala"
			derotated.x = (_tmp8_ - _tmp10_) - 1;
#line 382 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp11_ = *space;
#line 382 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp12_ = _tmp11_.height;
#line 382 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp13_ = *point;
#line 382 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp14_ = _tmp13_.y;
#line 382 "/home/jens/Source/shotwell/src/Orientation.vala"
			derotated.y = (_tmp12_ - _tmp14_) - 1;
#line 383 "/home/jens/Source/shotwell/src/Orientation.vala"
			break;
#line 1587 "Orientation.c"
		}
#line 367 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_BOTTOM_LEFT:
#line 1591 "Orientation.c"
		{
			GdkPoint _tmp15_;
			gint _tmp16_;
			Dimensions _tmp17_;
			gint _tmp18_;
			GdkPoint _tmp19_;
			gint _tmp20_;
#line 387 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp15_ = *point;
#line 387 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp16_ = _tmp15_.x;
#line 387 "/home/jens/Source/shotwell/src/Orientation.vala"
			derotated.x = _tmp16_;
#line 388 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp17_ = *space;
#line 388 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp18_ = _tmp17_.height;
#line 388 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp19_ = *point;
#line 388 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp20_ = _tmp19_.y;
#line 388 "/home/jens/Source/shotwell/src/Orientation.vala"
			derotated.y = (_tmp18_ - _tmp20_) - 1;
#line 389 "/home/jens/Source/shotwell/src/Orientation.vala"
			break;
#line 1617 "Orientation.c"
		}
#line 367 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_LEFT_TOP:
#line 1621 "Orientation.c"
		{
			GdkPoint _tmp21_;
			gint _tmp22_;
			GdkPoint _tmp23_;
			gint _tmp24_;
#line 393 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp21_ = *point;
#line 393 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp22_ = _tmp21_.y;
#line 393 "/home/jens/Source/shotwell/src/Orientation.vala"
			derotated.x = _tmp22_;
#line 394 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp23_ = *point;
#line 394 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp24_ = _tmp23_.x;
#line 394 "/home/jens/Source/shotwell/src/Orientation.vala"
			derotated.y = _tmp24_;
#line 395 "/home/jens/Source/shotwell/src/Orientation.vala"
			break;
#line 1641 "Orientation.c"
		}
#line 367 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_RIGHT_TOP:
#line 1645 "Orientation.c"
		{
			GdkPoint _tmp25_;
			gint _tmp26_;
			Dimensions _tmp27_;
			gint _tmp28_;
			GdkPoint _tmp29_;
			gint _tmp30_;
#line 399 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp25_ = *point;
#line 399 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp26_ = _tmp25_.y;
#line 399 "/home/jens/Source/shotwell/src/Orientation.vala"
			derotated.x = _tmp26_;
#line 400 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp27_ = *space;
#line 400 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp28_ = _tmp27_.height;
#line 400 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp29_ = *point;
#line 400 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp30_ = _tmp29_.x;
#line 400 "/home/jens/Source/shotwell/src/Orientation.vala"
			derotated.y = (_tmp28_ - _tmp30_) - 1;
#line 401 "/home/jens/Source/shotwell/src/Orientation.vala"
			break;
#line 1671 "Orientation.c"
		}
#line 367 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_RIGHT_BOTTOM:
#line 1675 "Orientation.c"
		{
			Dimensions _tmp31_;
			gint _tmp32_;
			GdkPoint _tmp33_;
			gint _tmp34_;
			Dimensions _tmp35_;
			gint _tmp36_;
			GdkPoint _tmp37_;
			gint _tmp38_;
#line 405 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp31_ = *space;
#line 405 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp32_ = _tmp31_.width;
#line 405 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp33_ = *point;
#line 405 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp34_ = _tmp33_.y;
#line 405 "/home/jens/Source/shotwell/src/Orientation.vala"
			derotated.x = (_tmp32_ - _tmp34_) - 1;
#line 406 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp35_ = *space;
#line 406 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp36_ = _tmp35_.height;
#line 406 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp37_ = *point;
#line 406 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp38_ = _tmp37_.x;
#line 406 "/home/jens/Source/shotwell/src/Orientation.vala"
			derotated.y = (_tmp36_ - _tmp38_) - 1;
#line 407 "/home/jens/Source/shotwell/src/Orientation.vala"
			break;
#line 1707 "Orientation.c"
		}
#line 367 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_LEFT_BOTTOM:
#line 1711 "Orientation.c"
		{
			Dimensions _tmp39_;
			gint _tmp40_;
			GdkPoint _tmp41_;
			gint _tmp42_;
			GdkPoint _tmp43_;
			gint _tmp44_;
#line 411 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp39_ = *space;
#line 411 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp40_ = _tmp39_.width;
#line 411 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp41_ = *point;
#line 411 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp42_ = _tmp41_.y;
#line 411 "/home/jens/Source/shotwell/src/Orientation.vala"
			derotated.x = (_tmp40_ - _tmp42_) - 1;
#line 412 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp43_ = *point;
#line 412 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp44_ = _tmp43_.x;
#line 412 "/home/jens/Source/shotwell/src/Orientation.vala"
			derotated.y = _tmp44_;
#line 413 "/home/jens/Source/shotwell/src/Orientation.vala"
			break;
#line 1737 "Orientation.c"
		}
		default:
		{
#line 416 "/home/jens/Source/shotwell/src/Orientation.vala"
			g_error ("Orientation.vala:416: rotate_point: %d", (gint) self);
#line 1743 "Orientation.c"
		}
	}
#line 419 "/home/jens/Source/shotwell/src/Orientation.vala"
	*result = derotated;
#line 419 "/home/jens/Source/shotwell/src/Orientation.vala"
	return;
#line 1750 "Orientation.c"
}


void
orientation_rotate_box (Orientation self,
                        Dimensions* space,
                        Box* box,
                        Box* result)
{
	GdkPoint top_left = {0};
	GdkPoint bottom_right = {0};
	GdkPoint _tmp0_ = {0};
	GdkPoint _tmp1_ = {0};
	GdkPoint _tmp2_;
	gint _tmp3_;
	Dimensions _tmp4_;
	gint _tmp5_;
	GdkPoint _tmp6_;
	gint _tmp7_;
	Dimensions _tmp8_;
	gint _tmp9_;
	GdkPoint _tmp10_;
	gint _tmp11_;
	Dimensions _tmp12_;
	gint _tmp13_;
	GdkPoint _tmp14_;
	gint _tmp15_;
	Dimensions _tmp16_;
	gint _tmp17_;
	Dimensions _tmp18_;
	GdkPoint _tmp19_;
	GdkPoint _tmp20_ = {0};
	Dimensions _tmp21_;
	GdkPoint _tmp22_;
	GdkPoint _tmp23_ = {0};
	GdkPoint _tmp24_;
	GdkPoint _tmp25_;
	Box _tmp26_ = {0};
#line 423 "/home/jens/Source/shotwell/src/Orientation.vala"
	g_return_if_fail (space != NULL);
#line 423 "/home/jens/Source/shotwell/src/Orientation.vala"
	g_return_if_fail (box != NULL);
#line 425 "/home/jens/Source/shotwell/src/Orientation.vala"
	box_get_points (box, &_tmp0_, &_tmp1_);
#line 425 "/home/jens/Source/shotwell/src/Orientation.vala"
	top_left = _tmp0_;
#line 425 "/home/jens/Source/shotwell/src/Orientation.vala"
	bottom_right = _tmp1_;
#line 427 "/home/jens/Source/shotwell/src/Orientation.vala"
	_tmp2_ = top_left;
#line 427 "/home/jens/Source/shotwell/src/Orientation.vala"
	_tmp3_ = _tmp2_.x;
#line 427 "/home/jens/Source/shotwell/src/Orientation.vala"
	_tmp4_ = *space;
#line 427 "/home/jens/Source/shotwell/src/Orientation.vala"
	_tmp5_ = _tmp4_.width;
#line 427 "/home/jens/Source/shotwell/src/Orientation.vala"
	top_left.x = CLAMP (_tmp3_, 0, _tmp5_ - 1);
#line 428 "/home/jens/Source/shotwell/src/Orientation.vala"
	_tmp6_ = top_left;
#line 428 "/home/jens/Source/shotwell/src/Orientation.vala"
	_tmp7_ = _tmp6_.y;
#line 428 "/home/jens/Source/shotwell/src/Orientation.vala"
	_tmp8_ = *space;
#line 428 "/home/jens/Source/shotwell/src/Orientation.vala"
	_tmp9_ = _tmp8_.height;
#line 428 "/home/jens/Source/shotwell/src/Orientation.vala"
	top_left.y = CLAMP (_tmp7_, 0, _tmp9_ - 1);
#line 430 "/home/jens/Source/shotwell/src/Orientation.vala"
	_tmp10_ = bottom_right;
#line 430 "/home/jens/Source/shotwell/src/Orientation.vala"
	_tmp11_ = _tmp10_.x;
#line 430 "/home/jens/Source/shotwell/src/Orientation.vala"
	_tmp12_ = *space;
#line 430 "/home/jens/Source/shotwell/src/Orientation.vala"
	_tmp13_ = _tmp12_.width;
#line 430 "/home/jens/Source/shotwell/src/Orientation.vala"
	bottom_right.x = CLAMP (_tmp11_, 0, _tmp13_ - 1);
#line 431 "/home/jens/Source/shotwell/src/Orientation.vala"
	_tmp14_ = bottom_right;
#line 431 "/home/jens/Source/shotwell/src/Orientation.vala"
	_tmp15_ = _tmp14_.y;
#line 431 "/home/jens/Source/shotwell/src/Orientation.vala"
	_tmp16_ = *space;
#line 431 "/home/jens/Source/shotwell/src/Orientation.vala"
	_tmp17_ = _tmp16_.height;
#line 431 "/home/jens/Source/shotwell/src/Orientation.vala"
	bottom_right.y = CLAMP (_tmp15_, 0, _tmp17_ - 1);
#line 433 "/home/jens/Source/shotwell/src/Orientation.vala"
	_tmp18_ = *space;
#line 433 "/home/jens/Source/shotwell/src/Orientation.vala"
	_tmp19_ = top_left;
#line 433 "/home/jens/Source/shotwell/src/Orientation.vala"
	orientation_rotate_point (self, &_tmp18_, &_tmp19_, &_tmp20_);
#line 433 "/home/jens/Source/shotwell/src/Orientation.vala"
	top_left = _tmp20_;
#line 434 "/home/jens/Source/shotwell/src/Orientation.vala"
	_tmp21_ = *space;
#line 434 "/home/jens/Source/shotwell/src/Orientation.vala"
	_tmp22_ = bottom_right;
#line 434 "/home/jens/Source/shotwell/src/Orientation.vala"
	orientation_rotate_point (self, &_tmp21_, &_tmp22_, &_tmp23_);
#line 434 "/home/jens/Source/shotwell/src/Orientation.vala"
	bottom_right = _tmp23_;
#line 436 "/home/jens/Source/shotwell/src/Orientation.vala"
	_tmp24_ = top_left;
#line 436 "/home/jens/Source/shotwell/src/Orientation.vala"
	_tmp25_ = bottom_right;
#line 436 "/home/jens/Source/shotwell/src/Orientation.vala"
	box_from_points (&_tmp24_, &_tmp25_, &_tmp26_);
#line 436 "/home/jens/Source/shotwell/src/Orientation.vala"
	*result = _tmp26_;
#line 436 "/home/jens/Source/shotwell/src/Orientation.vala"
	return;
#line 1865 "Orientation.c"
}


void
orientation_derotate_box (Orientation self,
                          Dimensions* space,
                          Box* box,
                          Box* result)
{
	GdkPoint top_left = {0};
	GdkPoint bottom_right = {0};
	GdkPoint _tmp0_ = {0};
	GdkPoint _tmp1_ = {0};
	Dimensions _tmp2_;
	GdkPoint _tmp3_;
	GdkPoint _tmp4_ = {0};
	Dimensions _tmp5_;
	GdkPoint _tmp6_;
	GdkPoint _tmp7_ = {0};
	GdkPoint _tmp8_;
	GdkPoint _tmp9_;
	Box _tmp10_ = {0};
#line 440 "/home/jens/Source/shotwell/src/Orientation.vala"
	g_return_if_fail (space != NULL);
#line 440 "/home/jens/Source/shotwell/src/Orientation.vala"
	g_return_if_fail (box != NULL);
#line 442 "/home/jens/Source/shotwell/src/Orientation.vala"
	box_get_points (box, &_tmp0_, &_tmp1_);
#line 442 "/home/jens/Source/shotwell/src/Orientation.vala"
	top_left = _tmp0_;
#line 442 "/home/jens/Source/shotwell/src/Orientation.vala"
	bottom_right = _tmp1_;
#line 444 "/home/jens/Source/shotwell/src/Orientation.vala"
	_tmp2_ = *space;
#line 444 "/home/jens/Source/shotwell/src/Orientation.vala"
	_tmp3_ = top_left;
#line 444 "/home/jens/Source/shotwell/src/Orientation.vala"
	orientation_derotate_point (self, &_tmp2_, &_tmp3_, &_tmp4_);
#line 444 "/home/jens/Source/shotwell/src/Orientation.vala"
	top_left = _tmp4_;
#line 445 "/home/jens/Source/shotwell/src/Orientation.vala"
	_tmp5_ = *space;
#line 445 "/home/jens/Source/shotwell/src/Orientation.vala"
	_tmp6_ = bottom_right;
#line 445 "/home/jens/Source/shotwell/src/Orientation.vala"
	orientation_derotate_point (self, &_tmp5_, &_tmp6_, &_tmp7_);
#line 445 "/home/jens/Source/shotwell/src/Orientation.vala"
	bottom_right = _tmp7_;
#line 447 "/home/jens/Source/shotwell/src/Orientation.vala"
	_tmp8_ = top_left;
#line 447 "/home/jens/Source/shotwell/src/Orientation.vala"
	_tmp9_ = bottom_right;
#line 447 "/home/jens/Source/shotwell/src/Orientation.vala"
	box_from_points (&_tmp8_, &_tmp9_, &_tmp10_);
#line 447 "/home/jens/Source/shotwell/src/Orientation.vala"
	*result = _tmp10_;
#line 447 "/home/jens/Source/shotwell/src/Orientation.vala"
	return;
#line 1924 "Orientation.c"
}


GType
orientation_get_type (void)
{
	static volatile gsize orientation_type_id__volatile = 0;
	if (g_once_init_enter (&orientation_type_id__volatile)) {
		static const GEnumValue values[] = {{ORIENTATION_MIN, "ORIENTATION_MIN", "min"}, {ORIENTATION_TOP_LEFT, "ORIENTATION_TOP_LEFT", "top-left"}, {ORIENTATION_TOP_RIGHT, "ORIENTATION_TOP_RIGHT", "top-right"}, {ORIENTATION_BOTTOM_RIGHT, "ORIENTATION_BOTTOM_RIGHT", "bottom-right"}, {ORIENTATION_BOTTOM_LEFT, "ORIENTATION_BOTTOM_LEFT", "bottom-left"}, {ORIENTATION_LEFT_TOP, "ORIENTATION_LEFT_TOP", "left-top"}, {ORIENTATION_RIGHT_TOP, "ORIENTATION_RIGHT_TOP", "right-top"}, {ORIENTATION_RIGHT_BOTTOM, "ORIENTATION_RIGHT_BOTTOM", "right-bottom"}, {ORIENTATION_LEFT_BOTTOM, "ORIENTATION_LEFT_BOTTOM", "left-bottom"}, {ORIENTATION_MAX, "ORIENTATION_MAX", "max"}, {0, NULL, NULL}};
		GType orientation_type_id;
		orientation_type_id = g_enum_register_static ("Orientation", values);
		g_once_init_leave (&orientation_type_id__volatile, orientation_type_id);
	}
	return orientation_type_id__volatile;
}


GdkPixbuf*
rotation_perform (Rotation self,
                  GdkPixbuf* pixbuf)
{
	GdkPixbuf* result = NULL;
#line 457 "/home/jens/Source/shotwell/src/Orientation.vala"
	g_return_val_if_fail (GDK_IS_PIXBUF (pixbuf), NULL);
#line 458 "/home/jens/Source/shotwell/src/Orientation.vala"
	switch (self) {
#line 458 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ROTATION_CLOCKWISE:
#line 1953 "Orientation.c"
		{
			GdkPixbuf* _tmp0_;
#line 460 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp0_ = gdk_pixbuf_rotate_simple (pixbuf, GDK_PIXBUF_ROTATE_CLOCKWISE);
#line 460 "/home/jens/Source/shotwell/src/Orientation.vala"
			result = _tmp0_;
#line 460 "/home/jens/Source/shotwell/src/Orientation.vala"
			return result;
#line 1962 "Orientation.c"
		}
#line 458 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ROTATION_COUNTERCLOCKWISE:
#line 1966 "Orientation.c"
		{
			GdkPixbuf* _tmp1_;
#line 463 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp1_ = gdk_pixbuf_rotate_simple (pixbuf, GDK_PIXBUF_ROTATE_COUNTERCLOCKWISE);
#line 463 "/home/jens/Source/shotwell/src/Orientation.vala"
			result = _tmp1_;
#line 463 "/home/jens/Source/shotwell/src/Orientation.vala"
			return result;
#line 1975 "Orientation.c"
		}
#line 458 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ROTATION_MIRROR:
#line 1979 "Orientation.c"
		{
			GdkPixbuf* _tmp2_;
#line 466 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp2_ = gdk_pixbuf_flip (pixbuf, TRUE);
#line 466 "/home/jens/Source/shotwell/src/Orientation.vala"
			result = _tmp2_;
#line 466 "/home/jens/Source/shotwell/src/Orientation.vala"
			return result;
#line 1988 "Orientation.c"
		}
#line 458 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ROTATION_UPSIDE_DOWN:
#line 1992 "Orientation.c"
		{
			GdkPixbuf* _tmp3_;
#line 469 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp3_ = gdk_pixbuf_flip (pixbuf, FALSE);
#line 469 "/home/jens/Source/shotwell/src/Orientation.vala"
			result = _tmp3_;
#line 469 "/home/jens/Source/shotwell/src/Orientation.vala"
			return result;
#line 2001 "Orientation.c"
		}
		default:
		{
#line 472 "/home/jens/Source/shotwell/src/Orientation.vala"
			g_error ("Orientation.vala:472: Unknown rotation: %d", (gint) self);
#line 2007 "Orientation.c"
		}
	}
}


Rotation
rotation_opposite (Rotation self)
{
	Rotation result = 0;
#line 477 "/home/jens/Source/shotwell/src/Orientation.vala"
	switch (self) {
#line 477 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ROTATION_CLOCKWISE:
#line 2021 "Orientation.c"
		{
#line 479 "/home/jens/Source/shotwell/src/Orientation.vala"
			result = ROTATION_COUNTERCLOCKWISE;
#line 479 "/home/jens/Source/shotwell/src/Orientation.vala"
			return result;
#line 2027 "Orientation.c"
		}
#line 477 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ROTATION_COUNTERCLOCKWISE:
#line 2031 "Orientation.c"
		{
#line 482 "/home/jens/Source/shotwell/src/Orientation.vala"
			result = ROTATION_CLOCKWISE;
#line 482 "/home/jens/Source/shotwell/src/Orientation.vala"
			return result;
#line 2037 "Orientation.c"
		}
#line 477 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ROTATION_MIRROR:
#line 477 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ROTATION_UPSIDE_DOWN:
#line 2043 "Orientation.c"
		{
#line 486 "/home/jens/Source/shotwell/src/Orientation.vala"
			result = self;
#line 486 "/home/jens/Source/shotwell/src/Orientation.vala"
			return result;
#line 2049 "Orientation.c"
		}
		default:
		{
#line 489 "/home/jens/Source/shotwell/src/Orientation.vala"
			g_error ("Orientation.vala:489: Unknown rotation: %d", (gint) self);
#line 2055 "Orientation.c"
		}
	}
}


GType
rotation_get_type (void)
{
	static volatile gsize rotation_type_id__volatile = 0;
	if (g_once_init_enter (&rotation_type_id__volatile)) {
		static const GEnumValue values[] = {{ROTATION_CLOCKWISE, "ROTATION_CLOCKWISE", "clockwise"}, {ROTATION_COUNTERCLOCKWISE, "ROTATION_COUNTERCLOCKWISE", "counterclockwise"}, {ROTATION_MIRROR, "ROTATION_MIRROR", "mirror"}, {ROTATION_UPSIDE_DOWN, "ROTATION_UPSIDE_DOWN", "upside-down"}, {0, NULL, NULL}};
		GType rotation_type_id;
		rotation_type_id = g_enum_register_static ("Rotation", values);
		g_once_init_leave (&rotation_type_id__volatile, rotation_type_id);
	}
	return rotation_type_id__volatile;
}



