.TH XvVideoNotify __libmansuffix__  __vendorversion__ "libXv Functions"
.SH NAME
XvVideoNotify \- event generated for video processing
.\"
.SH SYNOPSIS
.B #include <X11/extensions/Xvlib.h>
.br
.sp 1l
.EX

     typedef union {
       int type;
       XvVideoNotifyEvent xvvideo;
       XvPortNotifyEvent xvport;
       long pad[24];
     } XvEvent;

     typedef struct {
       int type;
       unsigned long serial;
       Bool send_event;
       Display *display;
       Drawable drawable;
       unsigned long reason;
       XvPortID port_id;
       Time time;
     } XvVideoNotifyEvent;

.EE
.\"
.IP \fItype\fR 8
Specifies the type of event:
.BR XvVideoNotify .
.IP \fIserial\fR 8
Number of the last request processed by the server.
.IP \fIsend_event\fR 8
True if the event was generated by a SendEvent request.
.IP \fIdisplay\fR 8
A pointer to the display the event was read from.
.IP \fIdrawable\fR 8
The drawable for which the event was generated.
.IP \fIreason\fR 8
The reason the event was generated: \fBXvStarted\fR, \fBXvStopped\fR,
\fBXvPreempted\fR, \fBXvBusy\fR, \fBXvHardError\fR.
.IP \fIport_id\fR 8
The port processing the video for which the event was generated.
.\"
.SH DESCRIPTION
.\"
.B XvVideoNotify
events are generated when video is started, stopped, preempted by
another video request, ignored because the port is grabbed by another
client, or interrupted because of a hard transmission or reception
error.
.\"
.SH SEE ALSO
.BR XvPutVideo (__libmansuffix__),
.BR XvPutStill (__libmansuffix__),
.BR XvGetVideo (__libmansuffix__),
.BR XvGetStill (__libmansuffix__),
.BR XvStopVideo (__libmansuffix__),
.BR XvSelectVideoNotify (__libmansuffix__)
.\"
