.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991, 1994, 1996 X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991 by
.\" Digital Equipment Corporation
.\"
.\" Portions Copyright \(co 1990, 1991 by
.\" Tektronix, Inc.
.\"
.\" Permission to use, copy, modify and distribute this documentation for
.\" any purpose and without fee is hereby granted, provided that the above
.\" copyright notice appears in all copies and that both that copyright notice
.\" and this permission notice appear in all copies, and that the names of
.\" Digital and Tektronix not be used in in advertising or publicity pertaining
.\" to this documentation without specific, written prior permission.
.\" Digital and Tektronix makes no representations about the suitability
.\" of this documentation for any purpose.
.\" It is provided "as is" without express or implied warranty.
.\"
.\"
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xW Athena X Widgets \- C Language X Toolkit Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.TH XSetScreenSaver __libmansuffix__ __xorgversion__ "XLIB FUNCTIONS"
.SH NAME
XSetScreenSaver, XForceScreenSaver, XActivateScreenSaver, XResetScreenSaver, XGetScreenSaver \- manipulate the screen saver
.SH SYNTAX
.HP
int XSetScreenSaver\^(\^Display *\fIdisplay\fP\^, int \fItimeout\fP\^,
int \fIinterval\fP\^, int \fIprefer_blanking\fP\^, int
\fIallow_exposures\fP\^);
.HP
int XForceScreenSaver\^(\^Display *\fIdisplay\fP\^, int \fImode\fP\^);
.HP
int XActivateScreenSaver\^(\^Display *\fIdisplay\fP\^);
.HP
int XResetScreenSaver\^(\^Display *\fIdisplay\fP\^);
.HP
int XGetScreenSaver\^(\^Display *\fIdisplay\fP\^, int *\fItimeout_return\fP\^,
int *\fIinterval_return\fP\^, int *\fIprefer_blanking_return\fP\^, int
*\fIallow_exposures_return\fP\^);
.SH ARGUMENTS
.IP \fIallow_exposures\fP 1i
Specifies the screen save control values.
You can pass
.BR DontAllowExposures ,
.BR AllowExposures ,
or
.BR DefaultExposures .
.IP \fIallow_exposures_return\fP 1i
Returns the current screen save control value
.RB ( DontAllowExposures ,
.BR AllowExposures ,
or
.BR DefaultExposures ).
.IP \fIdisplay\fP 1i
Specifies the connection to the X server.
.IP \fIinterval\fP 1i
Specifies the interval, in seconds, between screen saver alterations.
.IP \fIinterval_return\fP 1i
Returns the interval between screen saver invocations.
.IP \fImode\fP 1i
Specifies the mode that is to be applied.
You can pass
.B ScreenSaverActive
or
.BR ScreenSaverReset .
.IP \fIprefer_blanking\fP 1i
Specifies how to enable screen blanking.
You can pass
.BR DontPreferBlanking ,
.BR PreferBlanking ,
or
.BR DefaultBlanking .
.IP \fIprefer_blanking_return\fP 1i
Returns the current screen blanking preference
.RB ( DontPreferBlanking ,
.BR PreferBlanking ,
or
.BR DefaultBlanking ).
.IP \fItimeout\fP 1i
Specifies the timeout, in seconds, until the screen saver turns on.
.IP \fItimeout_return\fP 1i
Returns the timeout, in seconds, until the screen saver turns on.
.SH DESCRIPTION
Timeout and interval are specified in seconds.
A timeout of 0 disables the screen saver
(but an activated screen saver is not deactivated),
and a timeout of \-1 restores the default.
Other negative values generate a
.B BadValue
error.
If the timeout value is nonzero,
.B XSetScreenSaver
