.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991, 1994, 1996 X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991 by
.\" Digital Equipment Corporation
.\"
.\" Portions Copyright \(co 1990, 1991 by
.\" Tektronix, Inc.
.\"
.\" Permission to use, copy, modify and distribute this documentation for
.\" any purpose and without fee is hereby granted, provided that the above
.\" copyright notice appears in all copies and that both that copyright notice
.\" and this permission notice appear in all copies, and that the names of
.\" Digital and Tektronix not be used in in advertising or publicity pertaining
.\" to this documentation without specific, written prior permission.
.\" Digital and Tektronix makes no representations about the suitability
.\" of this documentation for any purpose.
.\" It is provided "as is" without express or implied warranty.
.\"
.\"
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xW Athena X Widgets \- C Language X Toolkit Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.TH XrmMergeDatabases __libmansuffix__ __xorgversion__ "XLIB FUNCTIONS"
.SH NAME
XrmMergeDatabases, XrmCombineDatabase, XrmCombineFileDatabase \- merge resource databases
.SH SYNTAX
.HP
#include <X11/Xresource.h>
.HP
void XrmMergeDatabases(\^XrmDatabase \fIsource_db\fP, XrmDatabase
*\fItarget_db\fP\^);
.HP
void XrmCombineDatabase(\^XrmDatabase \fIsource_db\fP, XrmDatabase
*\fItarget_db\fP, Bool \fIoverride\fP\^);
.HP
Status XrmCombineFileDatabase(\^char *\fIfilename\fP, XrmDatabase
*\fItarget_db\fP\^, Bool \fIoverride\fP);
.SH ARGUMENTS
.IP \fIsource_db\fP 1i
Specifies the resource database that is to be merged into the target database.
.IP \fItarget_db\fP 1i
Specifies the resource database into which the source
database is to be merged.
.IP \fIfilename\fP 1i
Specifies the resource database file name.
.IP \fIoverride\fP 1i
Specifies whether source entries override target ones.
.SH DESCRIPTION
Calling the
.B XrmMergeDatabases
function is equivalent to calling the
.B XrmCombineDatabase
function with an override argument of
.BR True .
.LP
The
.B XrmCombineDatabase
function merges the contents of one database into another.
If the same specifier is used for an entry in both databases,
the entry in the source_db will replace the entry in the target_db
if override is
.BR True ;
otherwise, the entry in source_db is discarded.
If target_db contains NULL,
.B XrmCombineDatabase
simply stores source_db in it.
Otherwise, source_db is destroyed by the merge, but the database pointed
to by target_db is not destroyed.
The database entries are merged without changing values or types,
regardless of the locales of the databases.
The locale of the target database is not modified.
.LP
The
.B XrmCombineFileDatabase
function merges the contents of a resource file into a database.
If the same specifier is used for an entry in both the file and
the database,
the entry in the file will replace the entry in the database
if override is
.BR True ;
otherwise, the entry in the file is discarded.
The file is parsed in the current locale.
If the file cannot be read,
a zero status is returned;
otherwise, a nonzero status is returned.
If target_db contains NULL,
.B XrmCombineFileDatabase
creates and returns a new database to it.
Otherwise, the database pointed to by target_db is not destroyed by the merge.
The database entries are merged without changing values or types,
regardless of the locale of the database.
The locale of the target database is not modified.
.SH "SEE ALSO"
XrmGetResource(__libmansuffix__),
XrmInitialize(__libmansuffix__),
XrmPutResource(__libmansuffix__)
.br
\fI\*(xL\fP
