/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * This file is part of the LibreOffice project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * This file incorporates work covered by the following license notice:
 *
 *   Licensed to the Apache Software Foundation (ASF) under one or more
 *   contributor license agreements. See the NOTICE file distributed
 *   with this work for additional information regarding copyright
 *   ownership. The ASF licenses this file to you under the Apache
 *   License, Version 2.0 (the "License"); you may not use this file
 *   except in compliance with the License. You may obtain a copy of
 *   the License at http://www.apache.org/licenses/LICENSE-2.0 .
 */

#ifndef INCLUDED_SC_SOURCE_UI_INC_TABOPDLG_HXX
#define INCLUDED_SC_SOURCE_UI_INC_TABOPDLG_HXX

#include <address.hxx>
#include "anyrefdg.hxx"

enum ScTabOpErr
{
    TABOPERR_NOFORMULA = 1,
    TABOPERR_NOCOLROW,
    TABOPERR_WRONGFORMULA,
    TABOPERR_WRONGROW,
    TABOPERR_NOCOLFORMULA,
    TABOPERR_WRONGCOL,
    TABOPERR_NOROWFORMULA
};

class ScTabOpDlg : public ScAnyRefDlgController
{
public:
    ScTabOpDlg(SfxBindings* pB, SfxChildWindow* pCW, weld::Window* pParent,
               ScDocument*     pDocument,
               const ScRefAddress& rCursorPos);
    virtual ~ScTabOpDlg() override;

    virtual void    SetReference( const ScRange& rRef, ScDocument* pDoc ) override;
    virtual bool    IsRefInputMode() const override { return true; }
    virtual void    SetActive() override;

    virtual void    Close() override;

private:
    ScRefAddress    theFormulaCell;
    ScRefAddress    theFormulaEnd;
    ScRefAddress    theRowCell;
    ScRefAddress    theColCell;

    ScDocument* const         pDoc;
    const SCTAB         nCurTab;
    bool                bDlgLostFocus;
    const OUString      errMsgNoFormula;
    const OUString      errMsgNoColRow;
    const OUString      errMsgWrongFormula;
    const OUString      errMsgWrongRowCol;
    const OUString      errMsgNoColFormula;
    const OUString      errMsgNoRowFormula;

    formula::RefEdit* m_pEdActive;
    std::unique_ptr<weld::Label> m_xFtFormulaRange;
    std::unique_ptr<formula::RefEdit> m_xEdFormulaRange;
    std::unique_ptr<formula::RefButton> m_xRBFormulaRange;

    std::unique_ptr<weld::Label> m_xFtRowCell;
    std::unique_ptr<formula::RefEdit> m_xEdRowCell;
    std::unique_ptr<formula::RefButton> m_xRBRowCell;

    std::unique_ptr<weld::Label> m_xFtColCell;
    std::unique_ptr<formula::RefEdit> m_xEdColCell;
    std::unique_ptr<formula::RefButton> m_xRBColCell;

    std::unique_ptr<weld::Button> m_xBtnOk;
    std::unique_ptr<weld::Button> m_xBtnCancel;

    void    Init();
    void    RaiseError( ScTabOpErr eError );

    DECL_LINK( BtnHdl, weld::Button&, void );
    DECL_LINK( GetEditFocusHdl, formula::RefEdit&, void );
    DECL_LINK( LoseEditFocusHdl, formula::RefEdit&, void );
    DECL_LINK( GetButtonFocusHdl, formula::RefButton&, void );
    DECL_LINK( LoseButtonFocusHdl, formula::RefButton&, void );

};

#endif // INCLUDED_SC_SOURCE_UI_INC_TABOPDLG_HXX

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
