/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.type;

import java.util.regex.Pattern;
import org.odftoolkit.odfdom.type.OdfDataType;

public class CellAddress
implements OdfDataType {
    private String mCellAddress;
    private static final Pattern cellAddressPattern = Pattern.compile("^(\\$?([^\\. ']+|'([^']|'')+'))?\\.\\$?[A-Z]+\\$?[0-9]+$");

    public CellAddress(String cellAddress) throws IllegalArgumentException {
        if (!CellAddress.isValid(cellAddress)) {
            throw new IllegalArgumentException("parameter is invalid for datatype CellAddress");
        }
        this.mCellAddress = cellAddress;
    }

    public String toString() {
        return this.mCellAddress;
    }

    public static CellAddress valueOf(String stringValue) throws IllegalArgumentException {
        return new CellAddress(stringValue);
    }

    public static boolean isValid(String stringValue) {
        return stringValue != null && cellAddressPattern.matcher(stringValue).matches();
    }
}

