/*
 * Copyright (C) 2010 Canonical, Ltd.
 *
 * Authors:
 *  Olivier Tilloy <olivier.tilloy@canonical.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 3.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

import Qt 4.7

Rectangle {

    function info() {
        var aa = BamfMatcher.active_application()
        console.log("active application: " + aa.name)
        var aw = BamfMatcher.active_window()
        console.log("active window: " + aw.name)
        var running = BamfMatcher.running_applications()
        console.log("running applications:")
        for (var i = 0; i < running.size(); ++i) {
            var app = running.at(i)
            console.log("   » " + app.name)
            var windows = app.windows()
            for (var j = 0; j < windows.size(); ++j) {
                var window = windows.at(j)
                console.log("      » " + window.name)
            }
        }
    }

    // slots
    function onActiveWindowChanged() {
        var aw = BamfMatcher.active_window()
        if (aw != null)
            console.log("active window changed to: " + aw.name)
    }

    Component.onCompleted: info()
}

