// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/bigtable/admin/v2/bigtable_instance_admin.proto

/*
Package admin is a generated protocol buffer package.

It is generated from these files:
	google/bigtable/admin/v2/bigtable_instance_admin.proto
	google/bigtable/admin/v2/bigtable_table_admin.proto
	google/bigtable/admin/v2/common.proto
	google/bigtable/admin/v2/instance.proto
	google/bigtable/admin/v2/table.proto

It has these top-level messages:
	CreateInstanceRequest
	GetInstanceRequest
	ListInstancesRequest
	ListInstancesResponse
	PartialUpdateInstanceRequest
	DeleteInstanceRequest
	CreateClusterRequest
	GetClusterRequest
	ListClustersRequest
	ListClustersResponse
	DeleteClusterRequest
	CreateInstanceMetadata
	UpdateInstanceMetadata
	CreateClusterMetadata
	UpdateClusterMetadata
	CreateAppProfileRequest
	GetAppProfileRequest
	ListAppProfilesRequest
	ListAppProfilesResponse
	UpdateAppProfileRequest
	DeleteAppProfileRequest
	UpdateAppProfileMetadata
	CreateTableRequest
	CreateTableFromSnapshotRequest
	DropRowRangeRequest
	ListTablesRequest
	ListTablesResponse
	GetTableRequest
	DeleteTableRequest
	ModifyColumnFamiliesRequest
	GenerateConsistencyTokenRequest
	GenerateConsistencyTokenResponse
	CheckConsistencyRequest
	CheckConsistencyResponse
	SnapshotTableRequest
	GetSnapshotRequest
	ListSnapshotsRequest
	ListSnapshotsResponse
	DeleteSnapshotRequest
	SnapshotTableMetadata
	CreateTableFromSnapshotMetadata
	Instance
	Cluster
	AppProfile
	Table
	ColumnFamily
	GcRule
	Snapshot
*/
package admin

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import google_iam_v11 "google.golang.org/genproto/googleapis/iam/v1"
import google_iam_v1 "google.golang.org/genproto/googleapis/iam/v1"
import google_longrunning "google.golang.org/genproto/googleapis/longrunning"
import google_protobuf3 "github.com/golang/protobuf/ptypes/empty"
import google_protobuf4 "google.golang.org/genproto/protobuf/field_mask"
import google_protobuf1 "github.com/golang/protobuf/ptypes/timestamp"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Request message for BigtableInstanceAdmin.CreateInstance.
type CreateInstanceRequest struct {
	// The unique name of the project in which to create the new instance.
	// Values are of the form `projects/<project>`.
	Parent string `protobuf:"bytes,1,opt,name=parent" json:"parent,omitempty"`
	// The ID to be used when referring to the new instance within its project,
	// e.g., just `myinstance` rather than
	// `projects/myproject/instances/myinstance`.
	InstanceId string `protobuf:"bytes,2,opt,name=instance_id,json=instanceId" json:"instance_id,omitempty"`
	// The instance to create.
	// Fields marked `OutputOnly` must be left blank.
	Instance *Instance `protobuf:"bytes,3,opt,name=instance" json:"instance,omitempty"`
	// The clusters to be created within the instance, mapped by desired
	// cluster ID, e.g., just `mycluster` rather than
	// `projects/myproject/instances/myinstance/clusters/mycluster`.
	// Fields marked `OutputOnly` must be left blank.
	// Currently exactly one cluster must be specified.
	Clusters map[string]*Cluster `protobuf:"bytes,4,rep,name=clusters" json:"clusters,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *CreateInstanceRequest) Reset()                    { *m = CreateInstanceRequest{} }
func (m *CreateInstanceRequest) String() string            { return proto.CompactTextString(m) }
func (*CreateInstanceRequest) ProtoMessage()               {}
func (*CreateInstanceRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

func (m *CreateInstanceRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateInstanceRequest) GetInstanceId() string {
	if m != nil {
		return m.InstanceId
	}
	return ""
}

func (m *CreateInstanceRequest) GetInstance() *Instance {
	if m != nil {
		return m.Instance
	}
	return nil
}

func (m *CreateInstanceRequest) GetClusters() map[string]*Cluster {
	if m != nil {
		return m.Clusters
	}
	return nil
}

// Request message for BigtableInstanceAdmin.GetInstance.
type GetInstanceRequest struct {
	// The unique name of the requested instance. Values are of the form
	// `projects/<project>/instances/<instance>`.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
}

func (m *GetInstanceRequest) Reset()                    { *m = GetInstanceRequest{} }
func (m *GetInstanceRequest) String() string            { return proto.CompactTextString(m) }
func (*GetInstanceRequest) ProtoMessage()               {}
func (*GetInstanceRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

func (m *GetInstanceRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for BigtableInstanceAdmin.ListInstances.
type ListInstancesRequest struct {
	// The unique name of the project for which a list of instances is requested.
	// Values are of the form `projects/<project>`.
	Parent string `protobuf:"bytes,1,opt,name=parent" json:"parent,omitempty"`
	// The value of `next_page_token` returned by a previous call.
	PageToken string `protobuf:"bytes,2,opt,name=page_token,json=pageToken" json:"page_token,omitempty"`
}

func (m *ListInstancesRequest) Reset()                    { *m = ListInstancesRequest{} }
func (m *ListInstancesRequest) String() string            { return proto.CompactTextString(m) }
func (*ListInstancesRequest) ProtoMessage()               {}
func (*ListInstancesRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

func (m *ListInstancesRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListInstancesRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Response message for BigtableInstanceAdmin.ListInstances.
type ListInstancesResponse struct {
	// The list of requested instances.
	Instances []*Instance `protobuf:"bytes,1,rep,name=instances" json:"instances,omitempty"`
	// Locations from which Instance information could not be retrieved,
	// due to an outage or some other transient condition.
	// Instances whose Clusters are all in one of the failed locations
	// may be missing from `instances`, and Instances with at least one
	// Cluster in a failed location may only have partial information returned.
	FailedLocations []string `protobuf:"bytes,2,rep,name=failed_locations,json=failedLocations" json:"failed_locations,omitempty"`
	// Set if not all instances could be returned in a single response.
	// Pass this value to `page_token` in another request to get the next
	// page of results.
	NextPageToken string `protobuf:"bytes,3,opt,name=next_page_token,json=nextPageToken" json:"next_page_token,omitempty"`
}

func (m *ListInstancesResponse) Reset()                    { *m = ListInstancesResponse{} }
func (m *ListInstancesResponse) String() string            { return proto.CompactTextString(m) }
func (*ListInstancesResponse) ProtoMessage()               {}
func (*ListInstancesResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

func (m *ListInstancesResponse) GetInstances() []*Instance {
	if m != nil {
		return m.Instances
	}
	return nil
}

func (m *ListInstancesResponse) GetFailedLocations() []string {
	if m != nil {
		return m.FailedLocations
	}
	return nil
}

func (m *ListInstancesResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Request message for BigtableInstanceAdmin.PartialUpdateInstance.
type PartialUpdateInstanceRequest struct {
	// The Instance which will (partially) replace the current value.
	Instance *Instance `protobuf:"bytes,1,opt,name=instance" json:"instance,omitempty"`
	// The subset of Instance fields which should be replaced.
	// Must be explicitly set.
	UpdateMask *google_protobuf4.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask" json:"update_mask,omitempty"`
}

func (m *PartialUpdateInstanceRequest) Reset()                    { *m = PartialUpdateInstanceRequest{} }
func (m *PartialUpdateInstanceRequest) String() string            { return proto.CompactTextString(m) }
func (*PartialUpdateInstanceRequest) ProtoMessage()               {}
func (*PartialUpdateInstanceRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

func (m *PartialUpdateInstanceRequest) GetInstance() *Instance {
	if m != nil {
		return m.Instance
	}
	return nil
}

func (m *PartialUpdateInstanceRequest) GetUpdateMask() *google_protobuf4.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// Request message for BigtableInstanceAdmin.DeleteInstance.
type DeleteInstanceRequest struct {
	// The unique name of the instance to be deleted.
	// Values are of the form `projects/<project>/instances/<instance>`.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
}

func (m *DeleteInstanceRequest) Reset()                    { *m = DeleteInstanceRequest{} }
func (m *DeleteInstanceRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteInstanceRequest) ProtoMessage()               {}
func (*DeleteInstanceRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{5} }

func (m *DeleteInstanceRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for BigtableInstanceAdmin.CreateCluster.
type CreateClusterRequest struct {
	// The unique name of the instance in which to create the new cluster.
	// Values are of the form
	// `projects/<project>/instances/<instance>`.
	Parent string `protobuf:"bytes,1,opt,name=parent" json:"parent,omitempty"`
	// The ID to be used when referring to the new cluster within its instance,
	// e.g., just `mycluster` rather than
	// `projects/myproject/instances/myinstance/clusters/mycluster`.
	ClusterId string `protobuf:"bytes,2,opt,name=cluster_id,json=clusterId" json:"cluster_id,omitempty"`
	// The cluster to be created.
	// Fields marked `OutputOnly` must be left blank.
	Cluster *Cluster `protobuf:"bytes,3,opt,name=cluster" json:"cluster,omitempty"`
}

func (m *CreateClusterRequest) Reset()                    { *m = CreateClusterRequest{} }
func (m *CreateClusterRequest) String() string            { return proto.CompactTextString(m) }
func (*CreateClusterRequest) ProtoMessage()               {}
func (*CreateClusterRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{6} }

func (m *CreateClusterRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateClusterRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *CreateClusterRequest) GetCluster() *Cluster {
	if m != nil {
		return m.Cluster
	}
	return nil
}

// Request message for BigtableInstanceAdmin.GetCluster.
type GetClusterRequest struct {
	// The unique name of the requested cluster. Values are of the form
	// `projects/<project>/instances/<instance>/clusters/<cluster>`.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
}

func (m *GetClusterRequest) Reset()                    { *m = GetClusterRequest{} }
func (m *GetClusterRequest) String() string            { return proto.CompactTextString(m) }
func (*GetClusterRequest) ProtoMessage()               {}
func (*GetClusterRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{7} }

func (m *GetClusterRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for BigtableInstanceAdmin.ListClusters.
type ListClustersRequest struct {
	// The unique name of the instance for which a list of clusters is requested.
	// Values are of the form `projects/<project>/instances/<instance>`.
	// Use `<instance> = '-'` to list Clusters for all Instances in a project,
	// e.g., `projects/myproject/instances/-`.
	Parent string `protobuf:"bytes,1,opt,name=parent" json:"parent,omitempty"`
	// The value of `next_page_token` returned by a previous call.
	PageToken string `protobuf:"bytes,2,opt,name=page_token,json=pageToken" json:"page_token,omitempty"`
}

func (m *ListClustersRequest) Reset()                    { *m = ListClustersRequest{} }
func (m *ListClustersRequest) String() string            { return proto.CompactTextString(m) }
func (*ListClustersRequest) ProtoMessage()               {}
func (*ListClustersRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{8} }

func (m *ListClustersRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListClustersRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Response message for BigtableInstanceAdmin.ListClusters.
type ListClustersResponse struct {
	// The list of requested clusters.
	Clusters []*Cluster `protobuf:"bytes,1,rep,name=clusters" json:"clusters,omitempty"`
	// Locations from which Cluster information could not be retrieved,
	// due to an outage or some other transient condition.
	// Clusters from these locations may be missing from `clusters`,
	// or may only have partial information returned.
	FailedLocations []string `protobuf:"bytes,2,rep,name=failed_locations,json=failedLocations" json:"failed_locations,omitempty"`
	// Set if not all clusters could be returned in a single response.
	// Pass this value to `page_token` in another request to get the next
	// page of results.
	NextPageToken string `protobuf:"bytes,3,opt,name=next_page_token,json=nextPageToken" json:"next_page_token,omitempty"`
}

func (m *ListClustersResponse) Reset()                    { *m = ListClustersResponse{} }
func (m *ListClustersResponse) String() string            { return proto.CompactTextString(m) }
func (*ListClustersResponse) ProtoMessage()               {}
func (*ListClustersResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{9} }

func (m *ListClustersResponse) GetClusters() []*Cluster {
	if m != nil {
		return m.Clusters
	}
	return nil
}

func (m *ListClustersResponse) GetFailedLocations() []string {
	if m != nil {
		return m.FailedLocations
	}
	return nil
}

func (m *ListClustersResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Request message for BigtableInstanceAdmin.DeleteCluster.
type DeleteClusterRequest struct {
	// The unique name of the cluster to be deleted. Values are of the form
	// `projects/<project>/instances/<instance>/clusters/<cluster>`.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
}

func (m *DeleteClusterRequest) Reset()                    { *m = DeleteClusterRequest{} }
func (m *DeleteClusterRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteClusterRequest) ProtoMessage()               {}
func (*DeleteClusterRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{10} }

func (m *DeleteClusterRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// The metadata for the Operation returned by CreateInstance.
type CreateInstanceMetadata struct {
	// The request that prompted the initiation of this CreateInstance operation.
	OriginalRequest *CreateInstanceRequest `protobuf:"bytes,1,opt,name=original_request,json=originalRequest" json:"original_request,omitempty"`
	// The time at which the original request was received.
	RequestTime *google_protobuf1.Timestamp `protobuf:"bytes,2,opt,name=request_time,json=requestTime" json:"request_time,omitempty"`
	// The time at which the operation failed or was completed successfully.
	FinishTime *google_protobuf1.Timestamp `protobuf:"bytes,3,opt,name=finish_time,json=finishTime" json:"finish_time,omitempty"`
}

func (m *CreateInstanceMetadata) Reset()                    { *m = CreateInstanceMetadata{} }
func (m *CreateInstanceMetadata) String() string            { return proto.CompactTextString(m) }
func (*CreateInstanceMetadata) ProtoMessage()               {}
func (*CreateInstanceMetadata) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{11} }

func (m *CreateInstanceMetadata) GetOriginalRequest() *CreateInstanceRequest {
	if m != nil {
		return m.OriginalRequest
	}
	return nil
}

func (m *CreateInstanceMetadata) GetRequestTime() *google_protobuf1.Timestamp {
	if m != nil {
		return m.RequestTime
	}
	return nil
}

func (m *CreateInstanceMetadata) GetFinishTime() *google_protobuf1.Timestamp {
	if m != nil {
		return m.FinishTime
	}
	return nil
}

// The metadata for the Operation returned by UpdateInstance.
type UpdateInstanceMetadata struct {
	// The request that prompted the initiation of this UpdateInstance operation.
	OriginalRequest *PartialUpdateInstanceRequest `protobuf:"bytes,1,opt,name=original_request,json=originalRequest" json:"original_request,omitempty"`
	// The time at which the original request was received.
	RequestTime *google_protobuf1.Timestamp `protobuf:"bytes,2,opt,name=request_time,json=requestTime" json:"request_time,omitempty"`
	// The time at which the operation failed or was completed successfully.
	FinishTime *google_protobuf1.Timestamp `protobuf:"bytes,3,opt,name=finish_time,json=finishTime" json:"finish_time,omitempty"`
}

func (m *UpdateInstanceMetadata) Reset()                    { *m = UpdateInstanceMetadata{} }
func (m *UpdateInstanceMetadata) String() string            { return proto.CompactTextString(m) }
func (*UpdateInstanceMetadata) ProtoMessage()               {}
func (*UpdateInstanceMetadata) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{12} }

func (m *UpdateInstanceMetadata) GetOriginalRequest() *PartialUpdateInstanceRequest {
	if m != nil {
		return m.OriginalRequest
	}
	return nil
}

func (m *UpdateInstanceMetadata) GetRequestTime() *google_protobuf1.Timestamp {
	if m != nil {
		return m.RequestTime
	}
	return nil
}

func (m *UpdateInstanceMetadata) GetFinishTime() *google_protobuf1.Timestamp {
	if m != nil {
		return m.FinishTime
	}
	return nil
}

// The metadata for the Operation returned by CreateCluster.
type CreateClusterMetadata struct {
	// The request that prompted the initiation of this CreateCluster operation.
	OriginalRequest *CreateClusterRequest `protobuf:"bytes,1,opt,name=original_request,json=originalRequest" json:"original_request,omitempty"`
	// The time at which the original request was received.
	RequestTime *google_protobuf1.Timestamp `protobuf:"bytes,2,opt,name=request_time,json=requestTime" json:"request_time,omitempty"`
	// The time at which the operation failed or was completed successfully.
	FinishTime *google_protobuf1.Timestamp `protobuf:"bytes,3,opt,name=finish_time,json=finishTime" json:"finish_time,omitempty"`
}

func (m *CreateClusterMetadata) Reset()                    { *m = CreateClusterMetadata{} }
func (m *CreateClusterMetadata) String() string            { return proto.CompactTextString(m) }
func (*CreateClusterMetadata) ProtoMessage()               {}
func (*CreateClusterMetadata) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{13} }

func (m *CreateClusterMetadata) GetOriginalRequest() *CreateClusterRequest {
	if m != nil {
		return m.OriginalRequest
	}
	return nil
}

func (m *CreateClusterMetadata) GetRequestTime() *google_protobuf1.Timestamp {
	if m != nil {
		return m.RequestTime
	}
	return nil
}

func (m *CreateClusterMetadata) GetFinishTime() *google_protobuf1.Timestamp {
	if m != nil {
		return m.FinishTime
	}
	return nil
}

// The metadata for the Operation returned by UpdateCluster.
type UpdateClusterMetadata struct {
	// The request that prompted the initiation of this UpdateCluster operation.
	OriginalRequest *Cluster `protobuf:"bytes,1,opt,name=original_request,json=originalRequest" json:"original_request,omitempty"`
	// The time at which the original request was received.
	RequestTime *google_protobuf1.Timestamp `protobuf:"bytes,2,opt,name=request_time,json=requestTime" json:"request_time,omitempty"`
	// The time at which the operation failed or was completed successfully.
	FinishTime *google_protobuf1.Timestamp `protobuf:"bytes,3,opt,name=finish_time,json=finishTime" json:"finish_time,omitempty"`
}

func (m *UpdateClusterMetadata) Reset()                    { *m = UpdateClusterMetadata{} }
func (m *UpdateClusterMetadata) String() string            { return proto.CompactTextString(m) }
func (*UpdateClusterMetadata) ProtoMessage()               {}
func (*UpdateClusterMetadata) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{14} }

func (m *UpdateClusterMetadata) GetOriginalRequest() *Cluster {
	if m != nil {
		return m.OriginalRequest
	}
	return nil
}

func (m *UpdateClusterMetadata) GetRequestTime() *google_protobuf1.Timestamp {
	if m != nil {
		return m.RequestTime
	}
	return nil
}

func (m *UpdateClusterMetadata) GetFinishTime() *google_protobuf1.Timestamp {
	if m != nil {
		return m.FinishTime
	}
	return nil
}

// This is a private alpha release of Cloud Bigtable replication. This feature
// is not currently available to most Cloud Bigtable customers. This feature
// might be changed in backward-incompatible ways and is not recommended for
// production use. It is not subject to any SLA or deprecation policy.
//
// Request message for BigtableInstanceAdmin.CreateAppProfile.
type CreateAppProfileRequest struct {
	// The unique name of the instance in which to create the new app profile.
	// Values are of the form
	// `projects/<project>/instances/<instance>`.
	Parent string `protobuf:"bytes,1,opt,name=parent" json:"parent,omitempty"`
	// The ID to be used when referring to the new app profile within its
	// instance, e.g., just `myprofile` rather than
	// `projects/myproject/instances/myinstance/appProfiles/myprofile`.
	AppProfileId string `protobuf:"bytes,2,opt,name=app_profile_id,json=appProfileId" json:"app_profile_id,omitempty"`
	// The app profile to be created.
	// Fields marked `OutputOnly` will be ignored.
	AppProfile *AppProfile `protobuf:"bytes,3,opt,name=app_profile,json=appProfile" json:"app_profile,omitempty"`
	// If true, ignore safety checks when creating the app profile.
	IgnoreWarnings bool `protobuf:"varint,4,opt,name=ignore_warnings,json=ignoreWarnings" json:"ignore_warnings,omitempty"`
}

func (m *CreateAppProfileRequest) Reset()                    { *m = CreateAppProfileRequest{} }
func (m *CreateAppProfileRequest) String() string            { return proto.CompactTextString(m) }
func (*CreateAppProfileRequest) ProtoMessage()               {}
func (*CreateAppProfileRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{15} }

func (m *CreateAppProfileRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateAppProfileRequest) GetAppProfileId() string {
	if m != nil {
		return m.AppProfileId
	}
	return ""
}

func (m *CreateAppProfileRequest) GetAppProfile() *AppProfile {
	if m != nil {
		return m.AppProfile
	}
	return nil
}

func (m *CreateAppProfileRequest) GetIgnoreWarnings() bool {
	if m != nil {
		return m.IgnoreWarnings
	}
	return false
}

// This is a private alpha release of Cloud Bigtable replication. This feature
// is not currently available to most Cloud Bigtable customers. This feature
// might be changed in backward-incompatible ways and is not recommended for
// production use. It is not subject to any SLA or deprecation policy.
//
// Request message for BigtableInstanceAdmin.GetAppProfile.
type GetAppProfileRequest struct {
	// The unique name of the requested app profile. Values are of the form
	// `projects/<project>/instances/<instance>/appProfiles/<app_profile>`.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
}

func (m *GetAppProfileRequest) Reset()                    { *m = GetAppProfileRequest{} }
func (m *GetAppProfileRequest) String() string            { return proto.CompactTextString(m) }
func (*GetAppProfileRequest) ProtoMessage()               {}
func (*GetAppProfileRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{16} }

func (m *GetAppProfileRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// This is a private alpha release of Cloud Bigtable replication. This feature
// is not currently available to most Cloud Bigtable customers. This feature
// might be changed in backward-incompatible ways and is not recommended for
// production use. It is not subject to any SLA or deprecation policy.
//
// Request message for BigtableInstanceAdmin.ListAppProfiles.
type ListAppProfilesRequest struct {
	// The unique name of the instance for which a list of app profiles is
	// requested. Values are of the form
	// `projects/<project>/instances/<instance>`.
	Parent string `protobuf:"bytes,1,opt,name=parent" json:"parent,omitempty"`
	// The value of `next_page_token` returned by a previous call.
	PageToken string `protobuf:"bytes,2,opt,name=page_token,json=pageToken" json:"page_token,omitempty"`
}

func (m *ListAppProfilesRequest) Reset()                    { *m = ListAppProfilesRequest{} }
func (m *ListAppProfilesRequest) String() string            { return proto.CompactTextString(m) }
func (*ListAppProfilesRequest) ProtoMessage()               {}
func (*ListAppProfilesRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{17} }

func (m *ListAppProfilesRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListAppProfilesRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// This is a private alpha release of Cloud Bigtable replication. This feature
// is not currently available to most Cloud Bigtable customers. This feature
// might be changed in backward-incompatible ways and is not recommended for
// production use. It is not subject to any SLA or deprecation policy.
//
// Response message for BigtableInstanceAdmin.ListAppProfiles.
type ListAppProfilesResponse struct {
	// The list of requested app profiles.
	AppProfiles []*AppProfile `protobuf:"bytes,1,rep,name=app_profiles,json=appProfiles" json:"app_profiles,omitempty"`
	// Set if not all app profiles could be returned in a single response.
	// Pass this value to `page_token` in another request to get the next
	// page of results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken" json:"next_page_token,omitempty"`
}

func (m *ListAppProfilesResponse) Reset()                    { *m = ListAppProfilesResponse{} }
func (m *ListAppProfilesResponse) String() string            { return proto.CompactTextString(m) }
func (*ListAppProfilesResponse) ProtoMessage()               {}
func (*ListAppProfilesResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{18} }

func (m *ListAppProfilesResponse) GetAppProfiles() []*AppProfile {
	if m != nil {
		return m.AppProfiles
	}
	return nil
}

func (m *ListAppProfilesResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// This is a private alpha release of Cloud Bigtable replication. This feature
// is not currently available to most Cloud Bigtable customers. This feature
// might be changed in backward-incompatible ways and is not recommended for
// production use. It is not subject to any SLA or deprecation policy.
//
// Request message for BigtableInstanceAdmin.UpdateAppProfile.
type UpdateAppProfileRequest struct {
	// The app profile which will (partially) replace the current value.
	AppProfile *AppProfile `protobuf:"bytes,1,opt,name=app_profile,json=appProfile" json:"app_profile,omitempty"`
	// The subset of app profile fields which should be replaced.
	// If unset, all fields will be replaced.
	UpdateMask *google_protobuf4.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask" json:"update_mask,omitempty"`
	// If true, ignore safety checks when updating the app profile.
	IgnoreWarnings bool `protobuf:"varint,3,opt,name=ignore_warnings,json=ignoreWarnings" json:"ignore_warnings,omitempty"`
}

func (m *UpdateAppProfileRequest) Reset()                    { *m = UpdateAppProfileRequest{} }
func (m *UpdateAppProfileRequest) String() string            { return proto.CompactTextString(m) }
func (*UpdateAppProfileRequest) ProtoMessage()               {}
func (*UpdateAppProfileRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{19} }

func (m *UpdateAppProfileRequest) GetAppProfile() *AppProfile {
	if m != nil {
		return m.AppProfile
	}
	return nil
}

func (m *UpdateAppProfileRequest) GetUpdateMask() *google_protobuf4.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

func (m *UpdateAppProfileRequest) GetIgnoreWarnings() bool {
	if m != nil {
		return m.IgnoreWarnings
	}
	return false
}

// This is a private alpha release of Cloud Bigtable replication. This feature
// is not currently available to most Cloud Bigtable customers. This feature
// might be changed in backward-incompatible ways and is not recommended for
// production use. It is not subject to any SLA or deprecation policy.
//
// Request message for BigtableInstanceAdmin.DeleteAppProfile.
type DeleteAppProfileRequest struct {
	// The unique name of the app profile to be deleted. Values are of the form
	// `projects/<project>/instances/<instance>/appProfiles/<app_profile>`.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// If true, ignore safety checks when deleting the app profile.
	IgnoreWarnings bool `protobuf:"varint,2,opt,name=ignore_warnings,json=ignoreWarnings" json:"ignore_warnings,omitempty"`
}

func (m *DeleteAppProfileRequest) Reset()                    { *m = DeleteAppProfileRequest{} }
func (m *DeleteAppProfileRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteAppProfileRequest) ProtoMessage()               {}
func (*DeleteAppProfileRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{20} }

func (m *DeleteAppProfileRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *DeleteAppProfileRequest) GetIgnoreWarnings() bool {
	if m != nil {
		return m.IgnoreWarnings
	}
	return false
}

// This is a private alpha release of Cloud Bigtable replication. This feature
// is not currently available to most Cloud Bigtable customers. This feature
// might be changed in backward-incompatible ways and is not recommended for
// production use. It is not subject to any SLA or deprecation policy.
//
// The metadata for the Operation returned by UpdateAppProfile.
type UpdateAppProfileMetadata struct {
}

func (m *UpdateAppProfileMetadata) Reset()                    { *m = UpdateAppProfileMetadata{} }
func (m *UpdateAppProfileMetadata) String() string            { return proto.CompactTextString(m) }
func (*UpdateAppProfileMetadata) ProtoMessage()               {}
func (*UpdateAppProfileMetadata) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{21} }

func init() {
	proto.RegisterType((*CreateInstanceRequest)(nil), "google.bigtable.admin.v2.CreateInstanceRequest")
	proto.RegisterType((*GetInstanceRequest)(nil), "google.bigtable.admin.v2.GetInstanceRequest")
	proto.RegisterType((*ListInstancesRequest)(nil), "google.bigtable.admin.v2.ListInstancesRequest")
	proto.RegisterType((*ListInstancesResponse)(nil), "google.bigtable.admin.v2.ListInstancesResponse")
	proto.RegisterType((*PartialUpdateInstanceRequest)(nil), "google.bigtable.admin.v2.PartialUpdateInstanceRequest")
	proto.RegisterType((*DeleteInstanceRequest)(nil), "google.bigtable.admin.v2.DeleteInstanceRequest")
	proto.RegisterType((*CreateClusterRequest)(nil), "google.bigtable.admin.v2.CreateClusterRequest")
	proto.RegisterType((*GetClusterRequest)(nil), "google.bigtable.admin.v2.GetClusterRequest")
	proto.RegisterType((*ListClustersRequest)(nil), "google.bigtable.admin.v2.ListClustersRequest")
	proto.RegisterType((*ListClustersResponse)(nil), "google.bigtable.admin.v2.ListClustersResponse")
	proto.RegisterType((*DeleteClusterRequest)(nil), "google.bigtable.admin.v2.DeleteClusterRequest")
	proto.RegisterType((*CreateInstanceMetadata)(nil), "google.bigtable.admin.v2.CreateInstanceMetadata")
	proto.RegisterType((*UpdateInstanceMetadata)(nil), "google.bigtable.admin.v2.UpdateInstanceMetadata")
	proto.RegisterType((*CreateClusterMetadata)(nil), "google.bigtable.admin.v2.CreateClusterMetadata")
	proto.RegisterType((*UpdateClusterMetadata)(nil), "google.bigtable.admin.v2.UpdateClusterMetadata")
	proto.RegisterType((*CreateAppProfileRequest)(nil), "google.bigtable.admin.v2.CreateAppProfileRequest")
	proto.RegisterType((*GetAppProfileRequest)(nil), "google.bigtable.admin.v2.GetAppProfileRequest")
	proto.RegisterType((*ListAppProfilesRequest)(nil), "google.bigtable.admin.v2.ListAppProfilesRequest")
	proto.RegisterType((*ListAppProfilesResponse)(nil), "google.bigtable.admin.v2.ListAppProfilesResponse")
	proto.RegisterType((*UpdateAppProfileRequest)(nil), "google.bigtable.admin.v2.UpdateAppProfileRequest")
	proto.RegisterType((*DeleteAppProfileRequest)(nil), "google.bigtable.admin.v2.DeleteAppProfileRequest")
	proto.RegisterType((*UpdateAppProfileMetadata)(nil), "google.bigtable.admin.v2.UpdateAppProfileMetadata")
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for BigtableInstanceAdmin service

type BigtableInstanceAdminClient interface {
	// Create an instance within a project.
	CreateInstance(ctx context.Context, in *CreateInstanceRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error)
	// Gets information about an instance.
	GetInstance(ctx context.Context, in *GetInstanceRequest, opts ...grpc.CallOption) (*Instance, error)
	// Lists information about instances in a project.
	ListInstances(ctx context.Context, in *ListInstancesRequest, opts ...grpc.CallOption) (*ListInstancesResponse, error)
	// Updates an instance within a project.
	UpdateInstance(ctx context.Context, in *Instance, opts ...grpc.CallOption) (*Instance, error)
	// Partially updates an instance within a project.
	PartialUpdateInstance(ctx context.Context, in *PartialUpdateInstanceRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error)
	// Delete an instance from a project.
	DeleteInstance(ctx context.Context, in *DeleteInstanceRequest, opts ...grpc.CallOption) (*google_protobuf3.Empty, error)
	// Creates a cluster within an instance.
	CreateCluster(ctx context.Context, in *CreateClusterRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error)
	// Gets information about a cluster.
	GetCluster(ctx context.Context, in *GetClusterRequest, opts ...grpc.CallOption) (*Cluster, error)
	// Lists information about clusters in an instance.
	ListClusters(ctx context.Context, in *ListClustersRequest, opts ...grpc.CallOption) (*ListClustersResponse, error)
	// Updates a cluster within an instance.
	UpdateCluster(ctx context.Context, in *Cluster, opts ...grpc.CallOption) (*google_longrunning.Operation, error)
	// Deletes a cluster from an instance.
	DeleteCluster(ctx context.Context, in *DeleteClusterRequest, opts ...grpc.CallOption) (*google_protobuf3.Empty, error)
	// This is a private alpha release of Cloud Bigtable replication. This feature
	// is not currently available to most Cloud Bigtable customers. This feature
	// might be changed in backward-incompatible ways and is not recommended for
	// production use. It is not subject to any SLA or deprecation policy.
	//
	// Creates an app profile within an instance.
	CreateAppProfile(ctx context.Context, in *CreateAppProfileRequest, opts ...grpc.CallOption) (*AppProfile, error)
	// This is a private alpha release of Cloud Bigtable replication. This feature
	// is not currently available to most Cloud Bigtable customers. This feature
	// might be changed in backward-incompatible ways and is not recommended for
	// production use. It is not subject to any SLA or deprecation policy.
	//
	// Gets information about an app profile.
	GetAppProfile(ctx context.Context, in *GetAppProfileRequest, opts ...grpc.CallOption) (*AppProfile, error)
	// This is a private alpha release of Cloud Bigtable replication. This feature
	// is not currently available to most Cloud Bigtable customers. This feature
	// might be changed in backward-incompatible ways and is not recommended for
	// production use. It is not subject to any SLA or deprecation policy.
	//
	// Lists information about app profiles in an instance.
	ListAppProfiles(ctx context.Context, in *ListAppProfilesRequest, opts ...grpc.CallOption) (*ListAppProfilesResponse, error)
	// This is a private alpha release of Cloud Bigtable replication. This feature
	// is not currently available to most Cloud Bigtable customers. This feature
	// might be changed in backward-incompatible ways and is not recommended for
	// production use. It is not subject to any SLA or deprecation policy.
	//
	// Updates an app profile within an instance.
	UpdateAppProfile(ctx context.Context, in *UpdateAppProfileRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error)
	// This is a private alpha release of Cloud Bigtable replication. This feature
	// is not currently available to most Cloud Bigtable customers. This feature
	// might be changed in backward-incompatible ways and is not recommended for
	// production use. It is not subject to any SLA or deprecation policy.
	//
	// Deletes an app profile from an instance.
	DeleteAppProfile(ctx context.Context, in *DeleteAppProfileRequest, opts ...grpc.CallOption) (*google_protobuf3.Empty, error)
	// This is a private alpha release of Cloud Bigtable instance level
	// permissions. This feature is not currently available to most Cloud Bigtable
	// customers. This feature might be changed in backward-incompatible ways and
	// is not recommended for production use. It is not subject to any SLA or
	// deprecation policy.
	//
	// Gets the access control policy for an instance resource. Returns an empty
	// policy if an instance exists but does not have a policy set.
	GetIamPolicy(ctx context.Context, in *google_iam_v11.GetIamPolicyRequest, opts ...grpc.CallOption) (*google_iam_v1.Policy, error)
	// This is a private alpha release of Cloud Bigtable instance level
	// permissions. This feature is not currently available to most Cloud Bigtable
	// customers. This feature might be changed in backward-incompatible ways and
	// is not recommended for production use. It is not subject to any SLA or
	// deprecation policy.
	//
	// Sets the access control policy on an instance resource. Replaces any
	// existing policy.
	SetIamPolicy(ctx context.Context, in *google_iam_v11.SetIamPolicyRequest, opts ...grpc.CallOption) (*google_iam_v1.Policy, error)
	// This is a private alpha release of Cloud Bigtable instance level
	// permissions. This feature is not currently available to most Cloud Bigtable
	// customers. This feature might be changed in backward-incompatible ways and
	// is not recommended for production use. It is not subject to any SLA or
	// deprecation policy.
	//
	// Returns permissions that the caller has on the specified instance resource.
	TestIamPermissions(ctx context.Context, in *google_iam_v11.TestIamPermissionsRequest, opts ...grpc.CallOption) (*google_iam_v11.TestIamPermissionsResponse, error)
}

type bigtableInstanceAdminClient struct {
	cc *grpc.ClientConn
}

func NewBigtableInstanceAdminClient(cc *grpc.ClientConn) BigtableInstanceAdminClient {
	return &bigtableInstanceAdminClient{cc}
}

func (c *bigtableInstanceAdminClient) CreateInstance(ctx context.Context, in *CreateInstanceRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error) {
	out := new(google_longrunning.Operation)
	err := grpc.Invoke(ctx, "/google.bigtable.admin.v2.BigtableInstanceAdmin/CreateInstance", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableInstanceAdminClient) GetInstance(ctx context.Context, in *GetInstanceRequest, opts ...grpc.CallOption) (*Instance, error) {
	out := new(Instance)
	err := grpc.Invoke(ctx, "/google.bigtable.admin.v2.BigtableInstanceAdmin/GetInstance", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableInstanceAdminClient) ListInstances(ctx context.Context, in *ListInstancesRequest, opts ...grpc.CallOption) (*ListInstancesResponse, error) {
	out := new(ListInstancesResponse)
	err := grpc.Invoke(ctx, "/google.bigtable.admin.v2.BigtableInstanceAdmin/ListInstances", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableInstanceAdminClient) UpdateInstance(ctx context.Context, in *Instance, opts ...grpc.CallOption) (*Instance, error) {
	out := new(Instance)
	err := grpc.Invoke(ctx, "/google.bigtable.admin.v2.BigtableInstanceAdmin/UpdateInstance", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableInstanceAdminClient) PartialUpdateInstance(ctx context.Context, in *PartialUpdateInstanceRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error) {
	out := new(google_longrunning.Operation)
	err := grpc.Invoke(ctx, "/google.bigtable.admin.v2.BigtableInstanceAdmin/PartialUpdateInstance", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableInstanceAdminClient) DeleteInstance(ctx context.Context, in *DeleteInstanceRequest, opts ...grpc.CallOption) (*google_protobuf3.Empty, error) {
	out := new(google_protobuf3.Empty)
	err := grpc.Invoke(ctx, "/google.bigtable.admin.v2.BigtableInstanceAdmin/DeleteInstance", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableInstanceAdminClient) CreateCluster(ctx context.Context, in *CreateClusterRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error) {
	out := new(google_longrunning.Operation)
	err := grpc.Invoke(ctx, "/google.bigtable.admin.v2.BigtableInstanceAdmin/CreateCluster", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableInstanceAdminClient) GetCluster(ctx context.Context, in *GetClusterRequest, opts ...grpc.CallOption) (*Cluster, error) {
	out := new(Cluster)
	err := grpc.Invoke(ctx, "/google.bigtable.admin.v2.BigtableInstanceAdmin/GetCluster", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableInstanceAdminClient) ListClusters(ctx context.Context, in *ListClustersRequest, opts ...grpc.CallOption) (*ListClustersResponse, error) {
	out := new(ListClustersResponse)
	err := grpc.Invoke(ctx, "/google.bigtable.admin.v2.BigtableInstanceAdmin/ListClusters", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableInstanceAdminClient) UpdateCluster(ctx context.Context, in *Cluster, opts ...grpc.CallOption) (*google_longrunning.Operation, error) {
	out := new(google_longrunning.Operation)
	err := grpc.Invoke(ctx, "/google.bigtable.admin.v2.BigtableInstanceAdmin/UpdateCluster", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableInstanceAdminClient) DeleteCluster(ctx context.Context, in *DeleteClusterRequest, opts ...grpc.CallOption) (*google_protobuf3.Empty, error) {
	out := new(google_protobuf3.Empty)
	err := grpc.Invoke(ctx, "/google.bigtable.admin.v2.BigtableInstanceAdmin/DeleteCluster", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableInstanceAdminClient) CreateAppProfile(ctx context.Context, in *CreateAppProfileRequest, opts ...grpc.CallOption) (*AppProfile, error) {
	out := new(AppProfile)
	err := grpc.Invoke(ctx, "/google.bigtable.admin.v2.BigtableInstanceAdmin/CreateAppProfile", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableInstanceAdminClient) GetAppProfile(ctx context.Context, in *GetAppProfileRequest, opts ...grpc.CallOption) (*AppProfile, error) {
	out := new(AppProfile)
	err := grpc.Invoke(ctx, "/google.bigtable.admin.v2.BigtableInstanceAdmin/GetAppProfile", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableInstanceAdminClient) ListAppProfiles(ctx context.Context, in *ListAppProfilesRequest, opts ...grpc.CallOption) (*ListAppProfilesResponse, error) {
	out := new(ListAppProfilesResponse)
	err := grpc.Invoke(ctx, "/google.bigtable.admin.v2.BigtableInstanceAdmin/ListAppProfiles", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableInstanceAdminClient) UpdateAppProfile(ctx context.Context, in *UpdateAppProfileRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error) {
	out := new(google_longrunning.Operation)
	err := grpc.Invoke(ctx, "/google.bigtable.admin.v2.BigtableInstanceAdmin/UpdateAppProfile", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableInstanceAdminClient) DeleteAppProfile(ctx context.Context, in *DeleteAppProfileRequest, opts ...grpc.CallOption) (*google_protobuf3.Empty, error) {
	out := new(google_protobuf3.Empty)
	err := grpc.Invoke(ctx, "/google.bigtable.admin.v2.BigtableInstanceAdmin/DeleteAppProfile", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableInstanceAdminClient) GetIamPolicy(ctx context.Context, in *google_iam_v11.GetIamPolicyRequest, opts ...grpc.CallOption) (*google_iam_v1.Policy, error) {
	out := new(google_iam_v1.Policy)
	err := grpc.Invoke(ctx, "/google.bigtable.admin.v2.BigtableInstanceAdmin/GetIamPolicy", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableInstanceAdminClient) SetIamPolicy(ctx context.Context, in *google_iam_v11.SetIamPolicyRequest, opts ...grpc.CallOption) (*google_iam_v1.Policy, error) {
	out := new(google_iam_v1.Policy)
	err := grpc.Invoke(ctx, "/google.bigtable.admin.v2.BigtableInstanceAdmin/SetIamPolicy", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableInstanceAdminClient) TestIamPermissions(ctx context.Context, in *google_iam_v11.TestIamPermissionsRequest, opts ...grpc.CallOption) (*google_iam_v11.TestIamPermissionsResponse, error) {
	out := new(google_iam_v11.TestIamPermissionsResponse)
	err := grpc.Invoke(ctx, "/google.bigtable.admin.v2.BigtableInstanceAdmin/TestIamPermissions", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for BigtableInstanceAdmin service

type BigtableInstanceAdminServer interface {
	// Create an instance within a project.
	CreateInstance(context.Context, *CreateInstanceRequest) (*google_longrunning.Operation, error)
	// Gets information about an instance.
	GetInstance(context.Context, *GetInstanceRequest) (*Instance, error)
	// Lists information about instances in a project.
	ListInstances(context.Context, *ListInstancesRequest) (*ListInstancesResponse, error)
	// Updates an instance within a project.
	UpdateInstance(context.Context, *Instance) (*Instance, error)
	// Partially updates an instance within a project.
	PartialUpdateInstance(context.Context, *PartialUpdateInstanceRequest) (*google_longrunning.Operation, error)
	// Delete an instance from a project.
	DeleteInstance(context.Context, *DeleteInstanceRequest) (*google_protobuf3.Empty, error)
	// Creates a cluster within an instance.
	CreateCluster(context.Context, *CreateClusterRequest) (*google_longrunning.Operation, error)
	// Gets information about a cluster.
	GetCluster(context.Context, *GetClusterRequest) (*Cluster, error)
	// Lists information about clusters in an instance.
	ListClusters(context.Context, *ListClustersRequest) (*ListClustersResponse, error)
	// Updates a cluster within an instance.
	UpdateCluster(context.Context, *Cluster) (*google_longrunning.Operation, error)
	// Deletes a cluster from an instance.
	DeleteCluster(context.Context, *DeleteClusterRequest) (*google_protobuf3.Empty, error)
	// This is a private alpha release of Cloud Bigtable replication. This feature
	// is not currently available to most Cloud Bigtable customers. This feature
	// might be changed in backward-incompatible ways and is not recommended for
	// production use. It is not subject to any SLA or deprecation policy.
	//
	// Creates an app profile within an instance.
	CreateAppProfile(context.Context, *CreateAppProfileRequest) (*AppProfile, error)
	// This is a private alpha release of Cloud Bigtable replication. This feature
	// is not currently available to most Cloud Bigtable customers. This feature
	// might be changed in backward-incompatible ways and is not recommended for
	// production use. It is not subject to any SLA or deprecation policy.
	//
	// Gets information about an app profile.
	GetAppProfile(context.Context, *GetAppProfileRequest) (*AppProfile, error)
	// This is a private alpha release of Cloud Bigtable replication. This feature
	// is not currently available to most Cloud Bigtable customers. This feature
	// might be changed in backward-incompatible ways and is not recommended for
	// production use. It is not subject to any SLA or deprecation policy.
	//
	// Lists information about app profiles in an instance.
	ListAppProfiles(context.Context, *ListAppProfilesRequest) (*ListAppProfilesResponse, error)
	// This is a private alpha release of Cloud Bigtable replication. This feature
	// is not currently available to most Cloud Bigtable customers. This feature
	// might be changed in backward-incompatible ways and is not recommended for
	// production use. It is not subject to any SLA or deprecation policy.
	//
	// Updates an app profile within an instance.
	UpdateAppProfile(context.Context, *UpdateAppProfileRequest) (*google_longrunning.Operation, error)
	// This is a private alpha release of Cloud Bigtable replication. This feature
	// is not currently available to most Cloud Bigtable customers. This feature
	// might be changed in backward-incompatible ways and is not recommended for
	// production use. It is not subject to any SLA or deprecation policy.
	//
	// Deletes an app profile from an instance.
	DeleteAppProfile(context.Context, *DeleteAppProfileRequest) (*google_protobuf3.Empty, error)
	// This is a private alpha release of Cloud Bigtable instance level
	// permissions. This feature is not currently available to most Cloud Bigtable
	// customers. This feature might be changed in backward-incompatible ways and
	// is not recommended for production use. It is not subject to any SLA or
	// deprecation policy.
	//
	// Gets the access control policy for an instance resource. Returns an empty
	// policy if an instance exists but does not have a policy set.
	GetIamPolicy(context.Context, *google_iam_v11.GetIamPolicyRequest) (*google_iam_v1.Policy, error)
	// This is a private alpha release of Cloud Bigtable instance level
	// permissions. This feature is not currently available to most Cloud Bigtable
	// customers. This feature might be changed in backward-incompatible ways and
	// is not recommended for production use. It is not subject to any SLA or
	// deprecation policy.
	//
	// Sets the access control policy on an instance resource. Replaces any
	// existing policy.
	SetIamPolicy(context.Context, *google_iam_v11.SetIamPolicyRequest) (*google_iam_v1.Policy, error)
	// This is a private alpha release of Cloud Bigtable instance level
	// permissions. This feature is not currently available to most Cloud Bigtable
	// customers. This feature might be changed in backward-incompatible ways and
	// is not recommended for production use. It is not subject to any SLA or
	// deprecation policy.
	//
	// Returns permissions that the caller has on the specified instance resource.
	TestIamPermissions(context.Context, *google_iam_v11.TestIamPermissionsRequest) (*google_iam_v11.TestIamPermissionsResponse, error)
}

func RegisterBigtableInstanceAdminServer(s *grpc.Server, srv BigtableInstanceAdminServer) {
	s.RegisterService(&_BigtableInstanceAdmin_serviceDesc, srv)
}

func _BigtableInstanceAdmin_CreateInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableInstanceAdminServer).CreateInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.bigtable.admin.v2.BigtableInstanceAdmin/CreateInstance",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableInstanceAdminServer).CreateInstance(ctx, req.(*CreateInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableInstanceAdmin_GetInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableInstanceAdminServer).GetInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.bigtable.admin.v2.BigtableInstanceAdmin/GetInstance",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableInstanceAdminServer).GetInstance(ctx, req.(*GetInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableInstanceAdmin_ListInstances_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListInstancesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableInstanceAdminServer).ListInstances(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.bigtable.admin.v2.BigtableInstanceAdmin/ListInstances",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableInstanceAdminServer).ListInstances(ctx, req.(*ListInstancesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableInstanceAdmin_UpdateInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Instance)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableInstanceAdminServer).UpdateInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.bigtable.admin.v2.BigtableInstanceAdmin/UpdateInstance",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableInstanceAdminServer).UpdateInstance(ctx, req.(*Instance))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableInstanceAdmin_PartialUpdateInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PartialUpdateInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableInstanceAdminServer).PartialUpdateInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.bigtable.admin.v2.BigtableInstanceAdmin/PartialUpdateInstance",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableInstanceAdminServer).PartialUpdateInstance(ctx, req.(*PartialUpdateInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableInstanceAdmin_DeleteInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableInstanceAdminServer).DeleteInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.bigtable.admin.v2.BigtableInstanceAdmin/DeleteInstance",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableInstanceAdminServer).DeleteInstance(ctx, req.(*DeleteInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableInstanceAdmin_CreateCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableInstanceAdminServer).CreateCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.bigtable.admin.v2.BigtableInstanceAdmin/CreateCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableInstanceAdminServer).CreateCluster(ctx, req.(*CreateClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableInstanceAdmin_GetCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableInstanceAdminServer).GetCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.bigtable.admin.v2.BigtableInstanceAdmin/GetCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableInstanceAdminServer).GetCluster(ctx, req.(*GetClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableInstanceAdmin_ListClusters_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListClustersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableInstanceAdminServer).ListClusters(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.bigtable.admin.v2.BigtableInstanceAdmin/ListClusters",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableInstanceAdminServer).ListClusters(ctx, req.(*ListClustersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableInstanceAdmin_UpdateCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Cluster)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableInstanceAdminServer).UpdateCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.bigtable.admin.v2.BigtableInstanceAdmin/UpdateCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableInstanceAdminServer).UpdateCluster(ctx, req.(*Cluster))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableInstanceAdmin_DeleteCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableInstanceAdminServer).DeleteCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.bigtable.admin.v2.BigtableInstanceAdmin/DeleteCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableInstanceAdminServer).DeleteCluster(ctx, req.(*DeleteClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableInstanceAdmin_CreateAppProfile_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateAppProfileRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableInstanceAdminServer).CreateAppProfile(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.bigtable.admin.v2.BigtableInstanceAdmin/CreateAppProfile",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableInstanceAdminServer).CreateAppProfile(ctx, req.(*CreateAppProfileRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableInstanceAdmin_GetAppProfile_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAppProfileRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableInstanceAdminServer).GetAppProfile(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.bigtable.admin.v2.BigtableInstanceAdmin/GetAppProfile",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableInstanceAdminServer).GetAppProfile(ctx, req.(*GetAppProfileRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableInstanceAdmin_ListAppProfiles_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAppProfilesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableInstanceAdminServer).ListAppProfiles(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.bigtable.admin.v2.BigtableInstanceAdmin/ListAppProfiles",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableInstanceAdminServer).ListAppProfiles(ctx, req.(*ListAppProfilesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableInstanceAdmin_UpdateAppProfile_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateAppProfileRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableInstanceAdminServer).UpdateAppProfile(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.bigtable.admin.v2.BigtableInstanceAdmin/UpdateAppProfile",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableInstanceAdminServer).UpdateAppProfile(ctx, req.(*UpdateAppProfileRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableInstanceAdmin_DeleteAppProfile_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteAppProfileRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableInstanceAdminServer).DeleteAppProfile(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.bigtable.admin.v2.BigtableInstanceAdmin/DeleteAppProfile",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableInstanceAdminServer).DeleteAppProfile(ctx, req.(*DeleteAppProfileRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableInstanceAdmin_GetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(google_iam_v11.GetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableInstanceAdminServer).GetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.bigtable.admin.v2.BigtableInstanceAdmin/GetIamPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableInstanceAdminServer).GetIamPolicy(ctx, req.(*google_iam_v11.GetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableInstanceAdmin_SetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(google_iam_v11.SetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableInstanceAdminServer).SetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.bigtable.admin.v2.BigtableInstanceAdmin/SetIamPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableInstanceAdminServer).SetIamPolicy(ctx, req.(*google_iam_v11.SetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableInstanceAdmin_TestIamPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(google_iam_v11.TestIamPermissionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableInstanceAdminServer).TestIamPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.bigtable.admin.v2.BigtableInstanceAdmin/TestIamPermissions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableInstanceAdminServer).TestIamPermissions(ctx, req.(*google_iam_v11.TestIamPermissionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _BigtableInstanceAdmin_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.bigtable.admin.v2.BigtableInstanceAdmin",
	HandlerType: (*BigtableInstanceAdminServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateInstance",
			Handler:    _BigtableInstanceAdmin_CreateInstance_Handler,
		},
		{
			MethodName: "GetInstance",
			Handler:    _BigtableInstanceAdmin_GetInstance_Handler,
		},
		{
			MethodName: "ListInstances",
			Handler:    _BigtableInstanceAdmin_ListInstances_Handler,
		},
		{
			MethodName: "UpdateInstance",
			Handler:    _BigtableInstanceAdmin_UpdateInstance_Handler,
		},
		{
			MethodName: "PartialUpdateInstance",
			Handler:    _BigtableInstanceAdmin_PartialUpdateInstance_Handler,
		},
		{
			MethodName: "DeleteInstance",
			Handler:    _BigtableInstanceAdmin_DeleteInstance_Handler,
		},
		{
			MethodName: "CreateCluster",
			Handler:    _BigtableInstanceAdmin_CreateCluster_Handler,
		},
		{
			MethodName: "GetCluster",
			Handler:    _BigtableInstanceAdmin_GetCluster_Handler,
		},
		{
			MethodName: "ListClusters",
			Handler:    _BigtableInstanceAdmin_ListClusters_Handler,
		},
		{
			MethodName: "UpdateCluster",
			Handler:    _BigtableInstanceAdmin_UpdateCluster_Handler,
		},
		{
			MethodName: "DeleteCluster",
			Handler:    _BigtableInstanceAdmin_DeleteCluster_Handler,
		},
		{
			MethodName: "CreateAppProfile",
			Handler:    _BigtableInstanceAdmin_CreateAppProfile_Handler,
		},
		{
			MethodName: "GetAppProfile",
			Handler:    _BigtableInstanceAdmin_GetAppProfile_Handler,
		},
		{
			MethodName: "ListAppProfiles",
			Handler:    _BigtableInstanceAdmin_ListAppProfiles_Handler,
		},
		{
			MethodName: "UpdateAppProfile",
			Handler:    _BigtableInstanceAdmin_UpdateAppProfile_Handler,
		},
		{
			MethodName: "DeleteAppProfile",
			Handler:    _BigtableInstanceAdmin_DeleteAppProfile_Handler,
		},
		{
			MethodName: "GetIamPolicy",
			Handler:    _BigtableInstanceAdmin_GetIamPolicy_Handler,
		},
		{
			MethodName: "SetIamPolicy",
			Handler:    _BigtableInstanceAdmin_SetIamPolicy_Handler,
		},
		{
			MethodName: "TestIamPermissions",
			Handler:    _BigtableInstanceAdmin_TestIamPermissions_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/bigtable/admin/v2/bigtable_instance_admin.proto",
}

func init() {
	proto.RegisterFile("google/bigtable/admin/v2/bigtable_instance_admin.proto", fileDescriptor0)
}

var fileDescriptor0 = []byte{
	// 1566 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xcc, 0x59, 0xcf, 0x6f, 0xdc, 0xc4,
	0x17, 0xd7, 0x6c, 0xfa, 0xed, 0xb7, 0x79, 0x9b, 0x5f, 0xdf, 0xf9, 0x36, 0xc9, 0xca, 0xf4, 0x47,
	0xea, 0x56, 0x6d, 0xba, 0x0d, 0x36, 0x59, 0x50, 0x5b, 0x25, 0xa4, 0xa2, 0x4d, 0x4b, 0x14, 0x94,
	0xaa, 0xd1, 0xb6, 0x14, 0xb5, 0x8a, 0x58, 0x4d, 0xb2, 0x93, 0xc5, 0xc4, 0x6b, 0x1b, 0xdb, 0x1b,
	0xa8, 0x50, 0x2f, 0x08, 0x21, 0x54, 0x09, 0x0e, 0x20, 0x71, 0xa9, 0xe0, 0xc2, 0x05, 0x55, 0x08,
	0xc4, 0x85, 0x1b, 0x57, 0x90, 0xe0, 0xc8, 0x5f, 0x80, 0xc4, 0x19, 0x71, 0xe3, 0x8a, 0x66, 0x3c,
	0xe3, 0xb5, 0xbd, 0xfe, 0xb5, 0xad, 0x2a, 0xf5, 0xd4, 0xf5, 0xcc, 0x9b, 0x37, 0x9f, 0xf9, 0xbc,
	0xcf, 0x7b, 0xf3, 0x26, 0x85, 0xf3, 0x1d, 0xdb, 0xee, 0x98, 0x54, 0xdf, 0x36, 0x3a, 0x3e, 0xd9,
	0x36, 0xa9, 0x4e, 0xda, 0x5d, 0xc3, 0xd2, 0xf7, 0x1b, 0xe1, 0x48, 0xcb, 0xb0, 0x3c, 0x9f, 0x58,
	0x3b, 0xb4, 0xc5, 0xa7, 0x34, 0xc7, 0xb5, 0x7d, 0x1b, 0xd7, 0x82, 0x75, 0x9a, 0xb4, 0xd2, 0x82,
	0xc9, 0xfd, 0x86, 0x72, 0x44, 0x78, 0x24, 0x8e, 0xa1, 0x13, 0xcb, 0xb2, 0x7d, 0xe2, 0x1b, 0xb6,
	0xe5, 0x05, 0xeb, 0x94, 0x33, 0x99, 0xfb, 0xc9, 0x6d, 0x84, 0xe1, 0x31, 0x61, 0x68, 0x90, 0xae,
	0xbe, 0xbf, 0xc8, 0xfe, 0x69, 0x39, 0xb6, 0x69, 0xec, 0xdc, 0x13, 0xf3, 0x4a, 0x7c, 0x3e, 0x36,
	0x77, 0x52, 0xcc, 0x99, 0xb6, 0xd5, 0x71, 0x7b, 0x96, 0x65, 0x58, 0x1d, 0xdd, 0x76, 0xa8, 0x1b,
	0x43, 0xf2, 0x9c, 0x30, 0xe2, 0x5f, 0xdb, 0xbd, 0x5d, 0x9d, 0x76, 0x1d, 0x5f, 0x7a, 0x98, 0x4b,
	0x4e, 0xee, 0x1a, 0xd4, 0x6c, 0xb7, 0xba, 0xc4, 0xdb, 0x13, 0x16, 0xc7, 0x93, 0x16, 0xbe, 0xd1,
	0xa5, 0x9e, 0x4f, 0xba, 0x4e, 0x60, 0xa0, 0xfe, 0x56, 0x81, 0xe9, 0x55, 0x97, 0x12, 0x9f, 0xae,
	0x8b, 0x93, 0x35, 0xe9, 0x3b, 0x3d, 0xea, 0xf9, 0x78, 0x06, 0x0e, 0x3a, 0xc4, 0xa5, 0x96, 0x5f,
	0x43, 0x73, 0x68, 0x7e, 0xb4, 0x29, 0xbe, 0xf0, 0x71, 0xa8, 0x86, 0x5c, 0x1b, 0xed, 0x5a, 0x85,
	0x4f, 0x82, 0x1c, 0x5a, 0x6f, 0xe3, 0x4b, 0x70, 0x48, 0x7e, 0xd5, 0x46, 0xe6, 0xd0, 0x7c, 0xb5,
	0xa1, 0x6a, 0x59, 0x71, 0xd0, 0xc2, 0x5d, 0xc3, 0x35, 0xf8, 0x0e, 0x1c, 0xda, 0x31, 0x7b, 0x9e,
	0x4f, 0x5d, 0xaf, 0x76, 0x60, 0x6e, 0x64, 0xbe, 0xda, 0x58, 0xc9, 0x5e, 0x9f, 0x8a, 0x5d, 0x5b,
	0x15, 0xeb, 0xaf, 0x59, 0xbe, 0x7b, 0xaf, 0x19, 0xba, 0x53, 0xde, 0x84, 0xf1, 0xd8, 0x14, 0x9e,
	0x82, 0x91, 0x3d, 0x7a, 0x4f, 0x9c, 0x90, 0xfd, 0xc4, 0x17, 0xe0, 0x3f, 0xfb, 0xc4, 0xec, 0x51,
	0x7e, 0xb0, 0x6a, 0xe3, 0x44, 0xce, 0xd6, 0x81, 0xa7, 0x66, 0x60, 0xbf, 0x54, 0xb9, 0x88, 0xd4,
	0x79, 0xc0, 0x6b, 0xd4, 0x4f, 0x32, 0x89, 0xe1, 0x80, 0x45, 0xba, 0x54, 0xec, 0xc2, 0x7f, 0xab,
	0xd7, 0xe1, 0xf0, 0x86, 0xe1, 0x85, 0xa6, 0x5e, 0x11, 0xeb, 0x47, 0x01, 0x1c, 0xd2, 0xa1, 0x2d,
	0xdf, 0xde, 0xa3, 0x96, 0x20, 0x7d, 0x94, 0x8d, 0xdc, 0x62, 0x03, 0xea, 0xb7, 0x08, 0xa6, 0x13,
	0xfe, 0x3c, 0xc7, 0xb6, 0x3c, 0x8a, 0x5f, 0x81, 0x51, 0xc9, 0xac, 0x57, 0x43, 0x9c, 0xce, 0x32,
	0xe1, 0xe8, 0x2f, 0xc2, 0x67, 0x61, 0x6a, 0x97, 0x18, 0x26, 0x6d, 0xb7, 0x4c, 0x7b, 0x27, 0x10,
	0x67, 0xad, 0x32, 0x37, 0x32, 0x3f, 0xda, 0x9c, 0x0c, 0xc6, 0x37, 0xe4, 0x30, 0x3e, 0x0d, 0x93,
	0x16, 0x7d, 0xcf, 0x6f, 0x45, 0xa0, 0x8e, 0x70, 0xa8, 0xe3, 0x6c, 0x78, 0x33, 0x84, 0xfb, 0x10,
	0xc1, 0x91, 0x4d, 0xe2, 0xfa, 0x06, 0x31, 0x5f, 0x77, 0xda, 0x29, 0xe2, 0x8b, 0x6a, 0x08, 0x3d,
	0x86, 0x86, 0x96, 0xa1, 0xda, 0xe3, 0x8e, 0x79, 0x32, 0x88, 0x58, 0x2a, 0xd2, 0x85, 0xcc, 0x06,
	0xed, 0x55, 0x96, 0x2f, 0xd7, 0x89, 0xb7, 0xd7, 0x84, 0xc0, 0x9c, 0xfd, 0x56, 0xcf, 0xc1, 0xf4,
	0x55, 0x6a, 0xd2, 0x41, 0x54, 0x69, 0x81, 0x7c, 0x80, 0xe0, 0x70, 0x20, 0x42, 0xa9, 0x87, 0xe2,
	0x48, 0x0a, 0x3d, 0xf6, 0xd3, 0x67, 0x54, 0x8c, 0xac, 0xb7, 0xf1, 0x32, 0xfc, 0x57, 0x7c, 0x88,
	0xe4, 0x29, 0xa1, 0x40, 0xb9, 0x42, 0x3d, 0x03, 0xff, 0x5b, 0xa3, 0x7e, 0x02, 0x48, 0x1a, 0xea,
	0x0d, 0xf8, 0x3f, 0x93, 0x8b, 0x4c, 0x86, 0x27, 0x54, 0xdf, 0x37, 0x28, 0x50, 0x73, 0xdf, 0x9d,
	0x10, 0xdf, 0x4a, 0x24, 0x95, 0x03, 0xed, 0x95, 0x38, 0x4d, 0xb8, 0xe4, 0x69, 0x28, 0xaf, 0x0e,
	0x87, 0x83, 0xd8, 0x96, 0x20, 0xe9, 0x6f, 0x04, 0x33, 0xf1, 0xfa, 0x72, 0x9d, 0xfa, 0xa4, 0x4d,
	0x7c, 0x82, 0xef, 0xc2, 0x94, 0xed, 0x1a, 0x1d, 0xc3, 0x22, 0x66, 0xcb, 0x0d, 0x5c, 0x08, 0x9d,
	0xea, 0x43, 0xd6, 0xaa, 0xe6, 0xa4, 0x74, 0x24, 0xa1, 0xac, 0xc0, 0x98, 0x70, 0xd9, 0x62, 0xd5,
	0x3a, 0x53, 0xbc, 0xb7, 0x64, 0x29, 0x6f, 0x56, 0x85, 0x3d, 0x1b, 0x61, 0xd2, 0xdf, 0x35, 0x2c,
	0xc3, 0x7b, 0x2b, 0x58, 0x3d, 0x52, 0xb8, 0x1a, 0x02, 0x73, 0x36, 0xa0, 0xfe, 0x83, 0x60, 0x26,
	0x9e, 0x91, 0xe1, 0x91, 0x49, 0xe6, 0x91, 0xcf, 0x67, 0x1f, 0x39, 0x2f, 0xc9, 0x9f, 0xad, 0x93,
	0xff, 0x85, 0xe4, 0x45, 0x28, 0x94, 0x11, 0x1e, 0xfc, 0x4e, 0xe6, 0xc1, 0xb5, 0xa2, 0x58, 0xc7,
	0x45, 0xf6, 0x6c, 0x1d, 0xf8, 0x0f, 0x04, 0xd3, 0x41, 0x5c, 0x92, 0x07, 0xde, 0xc8, 0x3c, 0x70,
	0x89, 0xec, 0x7d, 0xa6, 0xce, 0xf8, 0x0b, 0x82, 0xd9, 0x20, 0x12, 0x97, 0x1d, 0x67, 0xd3, 0xb5,
	0x77, 0x0d, 0xb3, 0xb0, 0xbf, 0x39, 0x05, 0x13, 0xc4, 0x71, 0x5a, 0x4e, 0x60, 0xdd, 0xaf, 0xd1,
	0x63, 0x24, 0x74, 0xb1, 0xde, 0xc6, 0xd7, 0xa0, 0x1a, 0xb1, 0x12, 0xb0, 0x4e, 0x65, 0xd3, 0x13,
	0xd9, 0x1f, 0xfa, 0x8e, 0xf0, 0x19, 0x98, 0x34, 0x3a, 0x96, 0xed, 0xd2, 0xd6, 0xbb, 0xc4, 0x65,
	0x1d, 0x20, 0x6b, 0x79, 0xd0, 0xfc, 0xa1, 0xe6, 0x44, 0x30, 0xfc, 0x86, 0x18, 0x65, 0x75, 0x6b,
	0x8d, 0xfa, 0x83, 0xa7, 0x48, 0xab, 0x5b, 0x37, 0x60, 0x86, 0x55, 0xe3, 0xbe, 0xf1, 0x93, 0xd6,
	0xf7, 0x07, 0x08, 0x66, 0x07, 0x3c, 0x8a, 0x12, 0xbf, 0x06, 0x63, 0x11, 0x22, 0x64, 0x99, 0x2f,
	0xc7, 0x44, 0xb5, 0xcf, 0x44, 0x6a, 0x05, 0xaf, 0xa4, 0x55, 0xf0, 0x9f, 0x11, 0xcc, 0x06, 0xba,
	0x1d, 0x64, 0x23, 0x11, 0x15, 0xf4, 0x98, 0x51, 0x79, 0x92, 0xee, 0x21, 0x2d, 0xa4, 0x23, 0xa9,
	0x21, 0xbd, 0x0d, 0xb3, 0xc1, 0x55, 0x54, 0x2a, 0xaa, 0x69, 0x7e, 0x2b, 0xa9, 0x7e, 0x15, 0xa8,
	0x25, 0xf9, 0x91, 0xa9, 0xdd, 0x78, 0x34, 0x0b, 0xd3, 0x57, 0x04, 0x0d, 0xb2, 0x1c, 0x5f, 0x66,
	0x6c, 0xe0, 0x4f, 0x11, 0x4c, 0xc4, 0x2f, 0x28, 0x3c, 0xec, 0x55, 0xa6, 0x1c, 0x95, 0x0b, 0x22,
	0x4f, 0x1a, 0xed, 0x86, 0x7c, 0xd2, 0xa8, 0x0b, 0x1f, 0xfc, 0xfe, 0xe7, 0xe7, 0x95, 0xd3, 0xea,
	0x09, 0xf6, 0x90, 0x7a, 0x3f, 0x90, 0xde, 0x8a, 0xe3, 0xda, 0x6f, 0xd3, 0x1d, 0xdf, 0xd3, 0xeb,
	0xf7, 0xc3, 0xc7, 0x95, 0xb7, 0x84, 0xea, 0xf8, 0x01, 0x82, 0x6a, 0xa4, 0x99, 0xc6, 0x0b, 0xd9,
	0x68, 0x06, 0x7b, 0x6e, 0xa5, 0x44, 0xbb, 0xa8, 0x9e, 0xe5, 0x78, 0x4e, 0xe2, 0x00, 0x0f, 0x23,
	0x39, 0x82, 0xa6, 0x0f, 0x46, 0xaf, 0xdf, 0xc7, 0x0f, 0x11, 0x8c, 0xc7, 0xfa, 0x6b, 0x9c, 0x53,
	0xfb, 0xd3, 0x1a, 0x7b, 0x45, 0x2f, 0x6d, 0x1f, 0x24, 0x56, 0x02, 0x5d, 0x1e, 0x5b, 0xf8, 0x23,
	0x04, 0x13, 0xf1, 0x2b, 0x16, 0x97, 0x38, 0x7f, 0x29, 0x8e, 0x44, 0xcc, 0x94, 0x62, 0x8e, 0x58,
	0xcc, 0xd8, 0x33, 0x24, 0xf5, 0xca, 0xc7, 0x8f, 0xd9, 0x23, 0x14, 0x49, 0xea, 0x65, 0x0e, 0xef,
	0x7c, 0xa3, 0xce, 0xe1, 0x85, 0x8f, 0xf3, 0x5c, 0x9c, 0xfd, 0x57, 0xc2, 0x87, 0x08, 0x26, 0xe2,
	0x9d, 0x7e, 0x9e, 0xe6, 0x53, 0xdf, 0x04, 0xca, 0xcc, 0x40, 0x59, 0xb8, 0xc6, 0x5e, 0xe8, 0x32,
	0x7c, 0xf5, 0x12, 0xe2, 0xfa, 0x12, 0xc1, 0x78, 0xac, 0x5f, 0xc0, 0x43, 0x36, 0x16, 0x45, 0x2c,
	0xad, 0x70, 0x2c, 0x17, 0xd4, 0x85, 0x74, 0x29, 0xc5, 0xd0, 0xe8, 0xb2, 0xfb, 0x5e, 0x92, 0xaf,
	0x0a, 0xfc, 0x19, 0x02, 0xe8, 0x3f, 0x2b, 0xf0, 0xb9, 0xdc, 0x44, 0x4c, 0x20, 0x2b, 0xee, 0x18,
	0xd4, 0x97, 0x38, 0x3a, 0x0d, 0x2f, 0x14, 0x31, 0x15, 0x42, 0x63, 0xa4, 0x7d, 0x8d, 0x60, 0x2c,
	0xfa, 0xe6, 0xc0, 0xcf, 0xe7, 0x27, 0x58, 0xe2, 0xa9, 0xa3, 0x68, 0x65, 0xcd, 0x45, 0x3a, 0xc6,
	0x51, 0x96, 0xe4, 0x90, 0x15, 0xb1, 0xf1, 0x58, 0x93, 0x85, 0x8b, 0x09, 0x29, 0x8a, 0xe6, 0x05,
	0x8e, 0x64, 0x51, 0x19, 0x8a, 0x2f, 0x96, 0x9d, 0x9f, 0x20, 0x18, 0x8f, 0x3d, 0x7e, 0xf2, 0x74,
	0x96, 0xf6, 0x4a, 0xca, 0x14, 0xbb, 0x20, 0xa7, 0x3e, 0x5c, 0x08, 0x7f, 0x40, 0x30, 0x95, 0xec,
	0xce, 0xf0, 0x62, 0x91, 0xf4, 0x07, 0x6e, 0x4b, 0xa5, 0xd4, 0x05, 0xaf, 0x5e, 0xe5, 0x18, 0x2f,
	0xa9, 0x7a, 0x99, 0x00, 0x46, 0x1a, 0x93, 0xa5, 0x68, 0x4b, 0x81, 0xbf, 0x42, 0x30, 0x1e, 0x6b,
	0xc4, 0xf2, 0x38, 0x4c, 0xeb, 0xd8, 0x4a, 0xa2, 0x15, 0x41, 0xc6, 0x7a, 0x21, 0xa3, 0x11, 0xa8,
	0x8c, 0xd4, 0xef, 0x11, 0x4c, 0x26, 0x7a, 0x35, 0xfc, 0x42, 0xbe, 0xd6, 0x07, 0x1b, 0x45, 0x65,
	0x71, 0x88, 0x15, 0x22, 0x41, 0xe2, 0x88, 0xcb, 0xf3, 0x8b, 0x7f, 0x44, 0x30, 0x95, 0x6c, 0x58,
	0xf2, 0x64, 0x90, 0xd1, 0xfc, 0x15, 0xa5, 0xcd, 0x26, 0xc7, 0xf7, 0x5a, 0x63, 0x99, 0xe3, 0x8b,
	0xc4, 0x54, 0x2b, 0xcf, 0x6e, 0x5c, 0x0b, 0x5f, 0x20, 0x98, 0x4a, 0x76, 0x70, 0x79, 0xc0, 0x33,
	0xba, 0xbd, 0xcc, 0xac, 0x12, 0x8c, 0xd6, 0x87, 0xd6, 0xc0, 0xc7, 0x08, 0xc6, 0x58, 0x4f, 0x44,
	0xba, 0x9b, 0xfc, 0x0f, 0xce, 0xfd, 0x6e, 0xc0, 0x20, 0x5d, 0x6d, 0x7f, 0x51, 0x8b, 0x4e, 0x4a,
	0x14, 0xd3, 0x09, 0x9b, 0x60, 0x36, 0xbc, 0x3b, 0x1a, 0x1c, 0x84, 0x4b, 0x3d, 0xbb, 0xe7, 0xee,
	0x64, 0x5f, 0xae, 0x9d, 0x88, 0x67, 0x56, 0x73, 0x18, 0x94, 0x9b, 0x79, 0x50, 0x6e, 0x3e, 0x35,
	0x28, 0x5e, 0x02, 0xca, 0x77, 0x08, 0xf0, 0x2d, 0xea, 0xf1, 0x41, 0xea, 0x76, 0x0d, 0xcf, 0xe3,
	0x7f, 0x39, 0x9a, 0x4f, 0x6c, 0x36, 0x68, 0x22, 0x61, 0x9d, 0x2d, 0x61, 0x29, 0x92, 0x61, 0x95,
	0x43, 0x5d, 0x51, 0x2f, 0x96, 0x83, 0xea, 0x0f, 0x78, 0x5a, 0x42, 0xf5, 0x2b, 0x3f, 0x21, 0x38,
	0xb2, 0x63, 0x77, 0x33, 0x05, 0x75, 0x45, 0x49, 0x6d, 0xe5, 0x37, 0x99, 0x8a, 0x36, 0xd1, 0xdd,
	0x15, 0xb1, 0xae, 0x63, 0x9b, 0xc4, 0xea, 0x68, 0xb6, 0xdb, 0xd1, 0x3b, 0xd4, 0xe2, 0x1a, 0xd3,
	0x83, 0x29, 0xe2, 0x18, 0xde, 0xe0, 0xff, 0x71, 0x2c, 0xf3, 0x1f, 0x8f, 0x2a, 0xc7, 0xd6, 0x82,
	0xf5, 0xab, 0xa6, 0xdd, 0x6b, 0x6b, 0x72, 0x2b, 0x8d, 0xef, 0xa1, 0xdd, 0x6e, 0xfc, 0x2a, 0x0d,
	0xb6, 0xb8, 0xc1, 0x96, 0x34, 0xd8, 0xe2, 0x06, 0x5b, 0xb7, 0x1b, 0xdb, 0x07, 0xf9, 0x5e, 0x2f,
	0xfe, 0x1b, 0x00, 0x00, 0xff, 0xff, 0x1c, 0xa0, 0x3f, 0x27, 0xbe, 0x19, 0x00, 0x00,
}
