; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i686-unknown | FileCheck %s --check-prefixes=X86
; RUN: llc < %s -mtriple=x86_64-unknown | FileCheck %s --check-prefixes=X64

define i64 @test1(i64 %x) nounwind  {
; X86-LABEL: test1:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl %ecx, %edx
; X86-NEXT:    shldl $9, %eax, %edx
; X86-NEXT:    shldl $9, %ecx, %eax
; X86-NEXT:    retl
;
; X64-LABEL: test1:
; X64:       # %bb.0: # %entry
; X64-NEXT:    movq %rdi, %rax
; X64-NEXT:    rolq $9, %rax
; X64-NEXT:    retq
entry:
	%tmp2 = lshr i64 %x, 55		; <i64> [#uses=1]
	%tmp4 = shl i64 %x, 9		; <i64> [#uses=1]
	%tmp5 = or i64 %tmp2, %tmp4		; <i64> [#uses=1]
	ret i64 %tmp5
}

define i64 @test2(i32 %x) nounwind  {
; X86-LABEL: test2:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    roll $10, %eax
; X86-NEXT:    xorl %edx, %edx
; X86-NEXT:    retl
;
; X64-LABEL: test2:
; X64:       # %bb.0: # %entry
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    roll $10, %eax
; X64-NEXT:    retq
entry:
	%tmp2 = lshr i32 %x, 22		; <i32> [#uses=1]
	%tmp4 = shl i32 %x, 10		; <i32> [#uses=1]
	%tmp5 = or i32 %tmp2, %tmp4		; <i32> [#uses=1]
	%tmp56 = zext i32 %tmp5 to i64		; <i64> [#uses=1]
	ret i64 %tmp56
}

