; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-apple-darwin -mcpu=knl -mattr=+avx512bw | FileCheck %s --check-prefix=ALL --check-prefix=AVX512BW
; RUN: llc < %s -mtriple=i386-unknown-linux-gnu -mcpu=knl -mattr=+avx512bw | FileCheck %s --check-prefix=ALL --check-prefix=AVX512F-32

define i64 @test_pcmpeq_b(<64 x i8> %a, <64 x i8> %b) {
; AVX512BW-LABEL: test_pcmpeq_b:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    vpcmpeqb %zmm1, %zmm0, %k0
; AVX512BW-NEXT:    kmovq %k0, %rax
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_pcmpeq_b:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    subl $12, %esp
; AVX512F-32-NEXT:  .Ltmp0:
; AVX512F-32-NEXT:    .cfi_def_cfa_offset 16
; AVX512F-32-NEXT:    vpcmpeqb %zmm1, %zmm0, %k0
; AVX512F-32-NEXT:    kmovq %k0, (%esp)
; AVX512F-32-NEXT:    movl (%esp), %eax
; AVX512F-32-NEXT:    movl {{[0-9]+}}(%esp), %edx
; AVX512F-32-NEXT:    addl $12, %esp
; AVX512F-32-NEXT:    retl
  %res = call i64 @llvm.x86.avx512.mask.pcmpeq.b.512(<64 x i8> %a, <64 x i8> %b, i64 -1)
  ret i64 %res
}

define i64 @test_mask_pcmpeq_b(<64 x i8> %a, <64 x i8> %b, i64 %mask) {
; AVX512BW-LABEL: test_mask_pcmpeq_b:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovq %rdi, %k1
; AVX512BW-NEXT:    vpcmpeqb %zmm1, %zmm0, %k0 {%k1}
; AVX512BW-NEXT:    kmovq %k0, %rax
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_mask_pcmpeq_b:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    subl $12, %esp
; AVX512F-32-NEXT:  .Ltmp1:
; AVX512F-32-NEXT:    .cfi_def_cfa_offset 16
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k0
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    kunpckdq %k0, %k1, %k1
; AVX512F-32-NEXT:    vpcmpeqb %zmm1, %zmm0, %k0 {%k1}
; AVX512F-32-NEXT:    kmovq %k0, (%esp)
; AVX512F-32-NEXT:    movl (%esp), %eax
; AVX512F-32-NEXT:    movl {{[0-9]+}}(%esp), %edx
; AVX512F-32-NEXT:    addl $12, %esp
; AVX512F-32-NEXT:    retl
  %res = call i64 @llvm.x86.avx512.mask.pcmpeq.b.512(<64 x i8> %a, <64 x i8> %b, i64 %mask)
  ret i64 %res
}

declare i64 @llvm.x86.avx512.mask.pcmpeq.b.512(<64 x i8>, <64 x i8>, i64)

define i32 @test_pcmpeq_w(<32 x i16> %a, <32 x i16> %b) {
; AVX512BW-LABEL: test_pcmpeq_w:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    vpcmpeqw %zmm1, %zmm0, %k0
; AVX512BW-NEXT:    kmovd %k0, %eax
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_pcmpeq_w:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    vpcmpeqw %zmm1, %zmm0, %k0
; AVX512F-32-NEXT:    kmovd %k0, %eax
; AVX512F-32-NEXT:    retl
  %res = call i32 @llvm.x86.avx512.mask.pcmpeq.w.512(<32 x i16> %a, <32 x i16> %b, i32 -1)
  ret i32 %res
}

define i32 @test_mask_pcmpeq_w(<32 x i16> %a, <32 x i16> %b, i32 %mask) {
; AVX512BW-LABEL: test_mask_pcmpeq_w:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovd %edi, %k1
; AVX512BW-NEXT:    vpcmpeqw %zmm1, %zmm0, %k0 {%k1}
; AVX512BW-NEXT:    kmovd %k0, %eax
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_mask_pcmpeq_w:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    vpcmpeqw %zmm1, %zmm0, %k0 {%k1}
; AVX512F-32-NEXT:    kmovd %k0, %eax
; AVX512F-32-NEXT:    retl
  %res = call i32 @llvm.x86.avx512.mask.pcmpeq.w.512(<32 x i16> %a, <32 x i16> %b, i32 %mask)
  ret i32 %res
}

declare i32 @llvm.x86.avx512.mask.pcmpeq.w.512(<32 x i16>, <32 x i16>, i32)

define i64 @test_pcmpgt_b(<64 x i8> %a, <64 x i8> %b) {
; AVX512BW-LABEL: test_pcmpgt_b:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    vpcmpgtb %zmm1, %zmm0, %k0
; AVX512BW-NEXT:    kmovq %k0, %rax
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_pcmpgt_b:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    subl $12, %esp
; AVX512F-32-NEXT:  .Ltmp2:
; AVX512F-32-NEXT:    .cfi_def_cfa_offset 16
; AVX512F-32-NEXT:    vpcmpgtb %zmm1, %zmm0, %k0
; AVX512F-32-NEXT:    kmovq %k0, (%esp)
; AVX512F-32-NEXT:    movl (%esp), %eax
; AVX512F-32-NEXT:    movl {{[0-9]+}}(%esp), %edx
; AVX512F-32-NEXT:    addl $12, %esp
; AVX512F-32-NEXT:    retl
  %res = call i64 @llvm.x86.avx512.mask.pcmpgt.b.512(<64 x i8> %a, <64 x i8> %b, i64 -1)
  ret i64 %res
}

define i64 @test_mask_pcmpgt_b(<64 x i8> %a, <64 x i8> %b, i64 %mask) {
; AVX512BW-LABEL: test_mask_pcmpgt_b:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovq %rdi, %k1
; AVX512BW-NEXT:    vpcmpgtb %zmm1, %zmm0, %k0 {%k1}
; AVX512BW-NEXT:    kmovq %k0, %rax
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_mask_pcmpgt_b:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    subl $12, %esp
; AVX512F-32-NEXT:  .Ltmp3:
; AVX512F-32-NEXT:    .cfi_def_cfa_offset 16
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k0
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    kunpckdq %k0, %k1, %k1
; AVX512F-32-NEXT:    vpcmpgtb %zmm1, %zmm0, %k0 {%k1}
; AVX512F-32-NEXT:    kmovq %k0, (%esp)
; AVX512F-32-NEXT:    movl (%esp), %eax
; AVX512F-32-NEXT:    movl {{[0-9]+}}(%esp), %edx
; AVX512F-32-NEXT:    addl $12, %esp
; AVX512F-32-NEXT:    retl
  %res = call i64 @llvm.x86.avx512.mask.pcmpgt.b.512(<64 x i8> %a, <64 x i8> %b, i64 %mask)
  ret i64 %res
}

declare i64 @llvm.x86.avx512.mask.pcmpgt.b.512(<64 x i8>, <64 x i8>, i64)

define i32 @test_pcmpgt_w(<32 x i16> %a, <32 x i16> %b) {
; AVX512BW-LABEL: test_pcmpgt_w:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    vpcmpgtw %zmm1, %zmm0, %k0
; AVX512BW-NEXT:    kmovd %k0, %eax
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_pcmpgt_w:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    vpcmpgtw %zmm1, %zmm0, %k0
; AVX512F-32-NEXT:    kmovd %k0, %eax
; AVX512F-32-NEXT:    retl
  %res = call i32 @llvm.x86.avx512.mask.pcmpgt.w.512(<32 x i16> %a, <32 x i16> %b, i32 -1)
  ret i32 %res
}

define i32 @test_mask_pcmpgt_w(<32 x i16> %a, <32 x i16> %b, i32 %mask) {
; AVX512BW-LABEL: test_mask_pcmpgt_w:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovd %edi, %k1
; AVX512BW-NEXT:    vpcmpgtw %zmm1, %zmm0, %k0 {%k1}
; AVX512BW-NEXT:    kmovd %k0, %eax
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_mask_pcmpgt_w:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    vpcmpgtw %zmm1, %zmm0, %k0 {%k1}
; AVX512F-32-NEXT:    kmovd %k0, %eax
; AVX512F-32-NEXT:    retl
  %res = call i32 @llvm.x86.avx512.mask.pcmpgt.w.512(<32 x i16> %a, <32 x i16> %b, i32 %mask)
  ret i32 %res
}

declare i32 @llvm.x86.avx512.mask.pcmpgt.w.512(<32 x i16>, <32 x i16>, i32)

define i64 @test_cmp_b_512(<64 x i8> %a0, <64 x i8> %a1) {
; AVX512BW-LABEL: test_cmp_b_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    vpcmpeqb %zmm1, %zmm0, %k0
; AVX512BW-NEXT:    kmovq %k0, %rax
; AVX512BW-NEXT:    vpcmpltb %zmm1, %zmm0, %k0
; AVX512BW-NEXT:    kmovq %k0, %rcx
; AVX512BW-NEXT:    addq %rax, %rcx
; AVX512BW-NEXT:    vpcmpleb %zmm1, %zmm0, %k0
; AVX512BW-NEXT:    kmovq %k0, %rax
; AVX512BW-NEXT:    addq %rcx, %rax
; AVX512BW-NEXT:    vpcmpunordb %zmm1, %zmm0, %k0
; AVX512BW-NEXT:    kmovq %k0, %rcx
; AVX512BW-NEXT:    addq %rax, %rcx
; AVX512BW-NEXT:    vpcmpneqb %zmm1, %zmm0, %k0
; AVX512BW-NEXT:    kmovq %k0, %rax
; AVX512BW-NEXT:    addq %rcx, %rax
; AVX512BW-NEXT:    vpcmpnltb %zmm1, %zmm0, %k0
; AVX512BW-NEXT:    kmovq %k0, %rcx
; AVX512BW-NEXT:    addq %rax, %rcx
; AVX512BW-NEXT:    vpcmpnleb %zmm1, %zmm0, %k0
; AVX512BW-NEXT:    kmovq %k0, %rdx
; AVX512BW-NEXT:    addq %rcx, %rdx
; AVX512BW-NEXT:    vpcmpordb %zmm1, %zmm0, %k0
; AVX512BW-NEXT:    kmovq %k0, %rax
; AVX512BW-NEXT:    addq %rdx, %rax
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_cmp_b_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    subl $68, %esp
; AVX512F-32-NEXT:  .Ltmp4:
; AVX512F-32-NEXT:    .cfi_def_cfa_offset 72
; AVX512F-32-NEXT:    vpcmpeqb %zmm1, %zmm0, %k0
; AVX512F-32-NEXT:    kmovq %k0, {{[0-9]+}}(%esp)
; AVX512F-32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX512F-32-NEXT:    movl {{[0-9]+}}(%esp), %edx
; AVX512F-32-NEXT:    vpcmpltb %zmm1, %zmm0, %k0
; AVX512F-32-NEXT:    kmovq %k0, {{[0-9]+}}(%esp)
; AVX512F-32-NEXT:    addl {{[0-9]+}}(%esp), %eax
; AVX512F-32-NEXT:    adcl {{[0-9]+}}(%esp), %edx
; AVX512F-32-NEXT:    vpcmpleb %zmm1, %zmm0, %k0
; AVX512F-32-NEXT:    kmovq %k0, {{[0-9]+}}(%esp)
; AVX512F-32-NEXT:    addl {{[0-9]+}}(%esp), %eax
; AVX512F-32-NEXT:    adcl {{[0-9]+}}(%esp), %edx
; AVX512F-32-NEXT:    vpcmpunordb %zmm1, %zmm0, %k0
; AVX512F-32-NEXT:    kmovq %k0, {{[0-9]+}}(%esp)
; AVX512F-32-NEXT:    addl {{[0-9]+}}(%esp), %eax
; AVX512F-32-NEXT:    adcl {{[0-9]+}}(%esp), %edx
; AVX512F-32-NEXT:    vpcmpneqb %zmm1, %zmm0, %k0
; AVX512F-32-NEXT:    kmovq %k0, {{[0-9]+}}(%esp)
; AVX512F-32-NEXT:    addl {{[0-9]+}}(%esp), %eax
; AVX512F-32-NEXT:    adcl {{[0-9]+}}(%esp), %edx
; AVX512F-32-NEXT:    vpcmpnltb %zmm1, %zmm0, %k0
; AVX512F-32-NEXT:    kmovq %k0, {{[0-9]+}}(%esp)
; AVX512F-32-NEXT:    addl {{[0-9]+}}(%esp), %eax
; AVX512F-32-NEXT:    adcl {{[0-9]+}}(%esp), %edx
; AVX512F-32-NEXT:    vpcmpnleb %zmm1, %zmm0, %k0
; AVX512F-32-NEXT:    kmovq %k0, {{[0-9]+}}(%esp)
; AVX512F-32-NEXT:    addl {{[0-9]+}}(%esp), %eax
; AVX512F-32-NEXT:    adcl {{[0-9]+}}(%esp), %edx
; AVX512F-32-NEXT:    vpcmpordb %zmm1, %zmm0, %k0
; AVX512F-32-NEXT:    kmovq %k0, (%esp)
; AVX512F-32-NEXT:    addl (%esp), %eax
; AVX512F-32-NEXT:    adcl {{[0-9]+}}(%esp), %edx
; AVX512F-32-NEXT:    addl $68, %esp
; AVX512F-32-NEXT:    retl
  %res0 = call i64 @llvm.x86.avx512.mask.cmp.b.512(<64 x i8> %a0, <64 x i8> %a1, i32 0, i64 -1)
  %res1 = call i64 @llvm.x86.avx512.mask.cmp.b.512(<64 x i8> %a0, <64 x i8> %a1, i32 1, i64 -1)
  %ret1 = add i64 %res0, %res1
  %res2 = call i64 @llvm.x86.avx512.mask.cmp.b.512(<64 x i8> %a0, <64 x i8> %a1, i32 2, i64 -1)
  %ret2 = add i64 %ret1, %res2
  %res3 = call i64 @llvm.x86.avx512.mask.cmp.b.512(<64 x i8> %a0, <64 x i8> %a1, i32 3, i64 -1)
  %ret3 = add i64 %ret2, %res3
  %res4 = call i64 @llvm.x86.avx512.mask.cmp.b.512(<64 x i8> %a0, <64 x i8> %a1, i32 4, i64 -1)
  %ret4 = add i64 %ret3, %res4
  %res5 = call i64 @llvm.x86.avx512.mask.cmp.b.512(<64 x i8> %a0, <64 x i8> %a1, i32 5, i64 -1)
  %ret5 = add i64 %ret4, %res5
  %res6 = call i64 @llvm.x86.avx512.mask.cmp.b.512(<64 x i8> %a0, <64 x i8> %a1, i32 6, i64 -1)
  %ret6 = add i64 %ret5, %res6
  %res7 = call i64 @llvm.x86.avx512.mask.cmp.b.512(<64 x i8> %a0, <64 x i8> %a1, i32 7, i64 -1)
  %ret7 = add i64 %ret6, %res7
  ret i64 %ret7
}

define i64 @test_mask_cmp_b_512(<64 x i8> %a0, <64 x i8> %a1, i64 %mask) {
; AVX512BW-LABEL: test_mask_cmp_b_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovq %rdi, %k1
; AVX512BW-NEXT:    vpcmpeqb %zmm1, %zmm0, %k0 {%k1}
; AVX512BW-NEXT:    kmovq %k0, %rax
; AVX512BW-NEXT:    vpcmpltb %zmm1, %zmm0, %k0 {%k1}
; AVX512BW-NEXT:    kmovq %k0, %rcx
; AVX512BW-NEXT:    addq %rax, %rcx
; AVX512BW-NEXT:    vpcmpleb %zmm1, %zmm0, %k0 {%k1}
; AVX512BW-NEXT:    kmovq %k0, %rax
; AVX512BW-NEXT:    addq %rcx, %rax
; AVX512BW-NEXT:    vpcmpunordb %zmm1, %zmm0, %k0 {%k1}
; AVX512BW-NEXT:    kmovq %k0, %rcx
; AVX512BW-NEXT:    addq %rax, %rcx
; AVX512BW-NEXT:    vpcmpneqb %zmm1, %zmm0, %k0 {%k1}
; AVX512BW-NEXT:    kmovq %k0, %rax
; AVX512BW-NEXT:    addq %rcx, %rax
; AVX512BW-NEXT:    vpcmpnltb %zmm1, %zmm0, %k0 {%k1}
; AVX512BW-NEXT:    kmovq %k0, %rcx
; AVX512BW-NEXT:    addq %rax, %rcx
; AVX512BW-NEXT:    vpcmpnleb %zmm1, %zmm0, %k0 {%k1}
; AVX512BW-NEXT:    kmovq %k0, %rdx
; AVX512BW-NEXT:    addq %rcx, %rdx
; AVX512BW-NEXT:    vpcmpordb %zmm1, %zmm0, %k0 {%k1}
; AVX512BW-NEXT:    kmovq %k0, %rax
; AVX512BW-NEXT:    addq %rdx, %rax
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_mask_cmp_b_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    subl $68, %esp
; AVX512F-32-NEXT:  .Ltmp5:
; AVX512F-32-NEXT:    .cfi_def_cfa_offset 72
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k0
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    kunpckdq %k0, %k1, %k1
; AVX512F-32-NEXT:    vpcmpeqb %zmm1, %zmm0, %k0 {%k1}
; AVX512F-32-NEXT:    kmovq %k0, (%esp)
; AVX512F-32-NEXT:    movl (%esp), %eax
; AVX512F-32-NEXT:    movl {{[0-9]+}}(%esp), %edx
; AVX512F-32-NEXT:    vpcmpltb %zmm1, %zmm0, %k0 {%k1}
; AVX512F-32-NEXT:    kmovq %k0, {{[0-9]+}}(%esp)
; AVX512F-32-NEXT:    addl {{[0-9]+}}(%esp), %eax
; AVX512F-32-NEXT:    adcl {{[0-9]+}}(%esp), %edx
; AVX512F-32-NEXT:    vpcmpleb %zmm1, %zmm0, %k0 {%k1}
; AVX512F-32-NEXT:    kmovq %k0, {{[0-9]+}}(%esp)
; AVX512F-32-NEXT:    addl {{[0-9]+}}(%esp), %eax
; AVX512F-32-NEXT:    adcl {{[0-9]+}}(%esp), %edx
; AVX512F-32-NEXT:    vpcmpunordb %zmm1, %zmm0, %k0 {%k1}
; AVX512F-32-NEXT:    kmovq %k0, {{[0-9]+}}(%esp)
; AVX512F-32-NEXT:    addl {{[0-9]+}}(%esp), %eax
; AVX512F-32-NEXT:    adcl {{[0-9]+}}(%esp), %edx
; AVX512F-32-NEXT:    vpcmpneqb %zmm1, %zmm0, %k0 {%k1}
; AVX512F-32-NEXT:    kmovq %k0, {{[0-9]+}}(%esp)
; AVX512F-32-NEXT:    addl {{[0-9]+}}(%esp), %eax
; AVX512F-32-NEXT:    adcl {{[0-9]+}}(%esp), %edx
; AVX512F-32-NEXT:    vpcmpnltb %zmm1, %zmm0, %k0 {%k1}
; AVX512F-32-NEXT:    kmovq %k0, {{[0-9]+}}(%esp)
; AVX512F-32-NEXT:    addl {{[0-9]+}}(%esp), %eax
; AVX512F-32-NEXT:    adcl {{[0-9]+}}(%esp), %edx
; AVX512F-32-NEXT:    vpcmpnleb %zmm1, %zmm0, %k0 {%k1}
; AVX512F-32-NEXT:    kmovq %k0, {{[0-9]+}}(%esp)
; AVX512F-32-NEXT:    addl {{[0-9]+}}(%esp), %eax
; AVX512F-32-NEXT:    adcl {{[0-9]+}}(%esp), %edx
; AVX512F-32-NEXT:    vpcmpordb %zmm1, %zmm0, %k0 {%k1}
; AVX512F-32-NEXT:    kmovq %k0, {{[0-9]+}}(%esp)
; AVX512F-32-NEXT:    addl {{[0-9]+}}(%esp), %eax
; AVX512F-32-NEXT:    adcl {{[0-9]+}}(%esp), %edx
; AVX512F-32-NEXT:    addl $68, %esp
; AVX512F-32-NEXT:    retl
  %res0 = call i64 @llvm.x86.avx512.mask.cmp.b.512(<64 x i8> %a0, <64 x i8> %a1, i32 0, i64 %mask)
  %res1 = call i64 @llvm.x86.avx512.mask.cmp.b.512(<64 x i8> %a0, <64 x i8> %a1, i32 1, i64 %mask)
  %ret1 = add i64 %res0, %res1
  %res2 = call i64 @llvm.x86.avx512.mask.cmp.b.512(<64 x i8> %a0, <64 x i8> %a1, i32 2, i64 %mask)
  %ret2 = add i64 %ret1, %res2
  %res3 = call i64 @llvm.x86.avx512.mask.cmp.b.512(<64 x i8> %a0, <64 x i8> %a1, i32 3, i64 %mask)
  %ret3 = add i64 %ret2, %res3
  %res4 = call i64 @llvm.x86.avx512.mask.cmp.b.512(<64 x i8> %a0, <64 x i8> %a1, i32 4, i64 %mask)
  %ret4 = add i64 %ret3, %res4
  %res5 = call i64 @llvm.x86.avx512.mask.cmp.b.512(<64 x i8> %a0, <64 x i8> %a1, i32 5, i64 %mask)
  %ret5 = add i64 %ret4, %res5
  %res6 = call i64 @llvm.x86.avx512.mask.cmp.b.512(<64 x i8> %a0, <64 x i8> %a1, i32 6, i64 %mask)
  %ret6 = add i64 %ret5, %res6
  %res7 = call i64 @llvm.x86.avx512.mask.cmp.b.512(<64 x i8> %a0, <64 x i8> %a1, i32 7, i64 %mask)
  %ret7 = add i64 %ret6, %res7
  ret i64 %ret7
}

declare i64 @llvm.x86.avx512.mask.cmp.b.512(<64 x i8>, <64 x i8>, i32, i64) nounwind readnone

define i64 @test_ucmp_b_512(<64 x i8> %a0, <64 x i8> %a1) {
; AVX512BW-LABEL: test_ucmp_b_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    vpcmpequb %zmm1, %zmm0, %k0
; AVX512BW-NEXT:    kmovq %k0, %rax
; AVX512BW-NEXT:    vpcmpltub %zmm1, %zmm0, %k0
; AVX512BW-NEXT:    kmovq %k0, %rcx
; AVX512BW-NEXT:    addq %rax, %rcx
; AVX512BW-NEXT:    vpcmpleub %zmm1, %zmm0, %k0
; AVX512BW-NEXT:    kmovq %k0, %rax
; AVX512BW-NEXT:    addq %rcx, %rax
; AVX512BW-NEXT:    vpcmpunordub %zmm1, %zmm0, %k0
; AVX512BW-NEXT:    kmovq %k0, %rcx
; AVX512BW-NEXT:    addq %rax, %rcx
; AVX512BW-NEXT:    vpcmpnequb %zmm1, %zmm0, %k0
; AVX512BW-NEXT:    kmovq %k0, %rax
; AVX512BW-NEXT:    addq %rcx, %rax
; AVX512BW-NEXT:    vpcmpnltub %zmm1, %zmm0, %k0
; AVX512BW-NEXT:    kmovq %k0, %rcx
; AVX512BW-NEXT:    addq %rax, %rcx
; AVX512BW-NEXT:    vpcmpnleub %zmm1, %zmm0, %k0
; AVX512BW-NEXT:    kmovq %k0, %rdx
; AVX512BW-NEXT:    addq %rcx, %rdx
; AVX512BW-NEXT:    vpcmpordub %zmm1, %zmm0, %k0
; AVX512BW-NEXT:    kmovq %k0, %rax
; AVX512BW-NEXT:    addq %rdx, %rax
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_ucmp_b_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    subl $68, %esp
; AVX512F-32-NEXT:  .Ltmp6:
; AVX512F-32-NEXT:    .cfi_def_cfa_offset 72
; AVX512F-32-NEXT:    vpcmpequb %zmm1, %zmm0, %k0
; AVX512F-32-NEXT:    kmovq %k0, {{[0-9]+}}(%esp)
; AVX512F-32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX512F-32-NEXT:    movl {{[0-9]+}}(%esp), %edx
; AVX512F-32-NEXT:    vpcmpltub %zmm1, %zmm0, %k0
; AVX512F-32-NEXT:    kmovq %k0, {{[0-9]+}}(%esp)
; AVX512F-32-NEXT:    addl {{[0-9]+}}(%esp), %eax
; AVX512F-32-NEXT:    adcl {{[0-9]+}}(%esp), %edx
; AVX512F-32-NEXT:    vpcmpleub %zmm1, %zmm0, %k0
; AVX512F-32-NEXT:    kmovq %k0, {{[0-9]+}}(%esp)
; AVX512F-32-NEXT:    addl {{[0-9]+}}(%esp), %eax
; AVX512F-32-NEXT:    adcl {{[0-9]+}}(%esp), %edx
; AVX512F-32-NEXT:    vpcmpunordub %zmm1, %zmm0, %k0
; AVX512F-32-NEXT:    kmovq %k0, {{[0-9]+}}(%esp)
; AVX512F-32-NEXT:    addl {{[0-9]+}}(%esp), %eax
; AVX512F-32-NEXT:    adcl {{[0-9]+}}(%esp), %edx
; AVX512F-32-NEXT:    vpcmpnequb %zmm1, %zmm0, %k0
; AVX512F-32-NEXT:    kmovq %k0, {{[0-9]+}}(%esp)
; AVX512F-32-NEXT:    addl {{[0-9]+}}(%esp), %eax
; AVX512F-32-NEXT:    adcl {{[0-9]+}}(%esp), %edx
; AVX512F-32-NEXT:    vpcmpnltub %zmm1, %zmm0, %k0
; AVX512F-32-NEXT:    kmovq %k0, {{[0-9]+}}(%esp)
; AVX512F-32-NEXT:    addl {{[0-9]+}}(%esp), %eax
; AVX512F-32-NEXT:    adcl {{[0-9]+}}(%esp), %edx
; AVX512F-32-NEXT:    vpcmpnleub %zmm1, %zmm0, %k0
; AVX512F-32-NEXT:    kmovq %k0, {{[0-9]+}}(%esp)
; AVX512F-32-NEXT:    addl {{[0-9]+}}(%esp), %eax
; AVX512F-32-NEXT:    adcl {{[0-9]+}}(%esp), %edx
; AVX512F-32-NEXT:    vpcmpordub %zmm1, %zmm0, %k0
; AVX512F-32-NEXT:    kmovq %k0, (%esp)
; AVX512F-32-NEXT:    addl (%esp), %eax
; AVX512F-32-NEXT:    adcl {{[0-9]+}}(%esp), %edx
; AVX512F-32-NEXT:    addl $68, %esp
; AVX512F-32-NEXT:    retl
  %res0 = call i64 @llvm.x86.avx512.mask.ucmp.b.512(<64 x i8> %a0, <64 x i8> %a1, i32 0, i64 -1)
  %res1 = call i64 @llvm.x86.avx512.mask.ucmp.b.512(<64 x i8> %a0, <64 x i8> %a1, i32 1, i64 -1)
  %ret1 = add i64 %res0, %res1
  %res2 = call i64 @llvm.x86.avx512.mask.ucmp.b.512(<64 x i8> %a0, <64 x i8> %a1, i32 2, i64 -1)
  %ret2 = add i64 %ret1, %res2
  %res3 = call i64 @llvm.x86.avx512.mask.ucmp.b.512(<64 x i8> %a0, <64 x i8> %a1, i32 3, i64 -1)
  %ret3 = add i64 %ret2, %res3
  %res4 = call i64 @llvm.x86.avx512.mask.ucmp.b.512(<64 x i8> %a0, <64 x i8> %a1, i32 4, i64 -1)
  %ret4 = add i64 %ret3, %res4
  %res5 = call i64 @llvm.x86.avx512.mask.ucmp.b.512(<64 x i8> %a0, <64 x i8> %a1, i32 5, i64 -1)
  %ret5 = add i64 %ret4, %res5
  %res6 = call i64 @llvm.x86.avx512.mask.ucmp.b.512(<64 x i8> %a0, <64 x i8> %a1, i32 6, i64 -1)
  %ret6 = add i64 %ret5, %res6
  %res7 = call i64 @llvm.x86.avx512.mask.ucmp.b.512(<64 x i8> %a0, <64 x i8> %a1, i32 7, i64 -1)
  %ret7 = add i64 %ret6, %res7
  ret i64 %ret7
}

define i64 @test_mask_x86_avx512_ucmp_b_512(<64 x i8> %a0, <64 x i8> %a1, i64 %mask) {
; AVX512BW-LABEL: test_mask_x86_avx512_ucmp_b_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovq %rdi, %k1
; AVX512BW-NEXT:    vpcmpequb %zmm1, %zmm0, %k0 {%k1}
; AVX512BW-NEXT:    kmovq %k0, %rax
; AVX512BW-NEXT:    vpcmpltub %zmm1, %zmm0, %k0 {%k1}
; AVX512BW-NEXT:    kmovq %k0, %rcx
; AVX512BW-NEXT:    addq %rax, %rcx
; AVX512BW-NEXT:    vpcmpleub %zmm1, %zmm0, %k0 {%k1}
; AVX512BW-NEXT:    kmovq %k0, %rax
; AVX512BW-NEXT:    addq %rcx, %rax
; AVX512BW-NEXT:    vpcmpunordub %zmm1, %zmm0, %k0 {%k1}
; AVX512BW-NEXT:    kmovq %k0, %rcx
; AVX512BW-NEXT:    addq %rax, %rcx
; AVX512BW-NEXT:    vpcmpnequb %zmm1, %zmm0, %k0 {%k1}
; AVX512BW-NEXT:    kmovq %k0, %rax
; AVX512BW-NEXT:    addq %rcx, %rax
; AVX512BW-NEXT:    vpcmpnltub %zmm1, %zmm0, %k0 {%k1}
; AVX512BW-NEXT:    kmovq %k0, %rcx
; AVX512BW-NEXT:    addq %rax, %rcx
; AVX512BW-NEXT:    vpcmpnleub %zmm1, %zmm0, %k0 {%k1}
; AVX512BW-NEXT:    kmovq %k0, %rdx
; AVX512BW-NEXT:    addq %rcx, %rdx
; AVX512BW-NEXT:    vpcmpordub %zmm1, %zmm0, %k0 {%k1}
; AVX512BW-NEXT:    kmovq %k0, %rax
; AVX512BW-NEXT:    addq %rdx, %rax
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_mask_x86_avx512_ucmp_b_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    subl $68, %esp
; AVX512F-32-NEXT:  .Ltmp7:
; AVX512F-32-NEXT:    .cfi_def_cfa_offset 72
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k0
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    kunpckdq %k0, %k1, %k1
; AVX512F-32-NEXT:    vpcmpequb %zmm1, %zmm0, %k0 {%k1}
; AVX512F-32-NEXT:    kmovq %k0, (%esp)
; AVX512F-32-NEXT:    movl (%esp), %eax
; AVX512F-32-NEXT:    movl {{[0-9]+}}(%esp), %edx
; AVX512F-32-NEXT:    vpcmpltub %zmm1, %zmm0, %k0 {%k1}
; AVX512F-32-NEXT:    kmovq %k0, {{[0-9]+}}(%esp)
; AVX512F-32-NEXT:    addl {{[0-9]+}}(%esp), %eax
; AVX512F-32-NEXT:    adcl {{[0-9]+}}(%esp), %edx
; AVX512F-32-NEXT:    vpcmpleub %zmm1, %zmm0, %k0 {%k1}
; AVX512F-32-NEXT:    kmovq %k0, {{[0-9]+}}(%esp)
; AVX512F-32-NEXT:    addl {{[0-9]+}}(%esp), %eax
; AVX512F-32-NEXT:    adcl {{[0-9]+}}(%esp), %edx
; AVX512F-32-NEXT:    vpcmpunordub %zmm1, %zmm0, %k0 {%k1}
; AVX512F-32-NEXT:    kmovq %k0, {{[0-9]+}}(%esp)
; AVX512F-32-NEXT:    addl {{[0-9]+}}(%esp), %eax
; AVX512F-32-NEXT:    adcl {{[0-9]+}}(%esp), %edx
; AVX512F-32-NEXT:    vpcmpnequb %zmm1, %zmm0, %k0 {%k1}
; AVX512F-32-NEXT:    kmovq %k0, {{[0-9]+}}(%esp)
; AVX512F-32-NEXT:    addl {{[0-9]+}}(%esp), %eax
; AVX512F-32-NEXT:    adcl {{[0-9]+}}(%esp), %edx
; AVX512F-32-NEXT:    vpcmpnltub %zmm1, %zmm0, %k0 {%k1}
; AVX512F-32-NEXT:    kmovq %k0, {{[0-9]+}}(%esp)
; AVX512F-32-NEXT:    addl {{[0-9]+}}(%esp), %eax
; AVX512F-32-NEXT:    adcl {{[0-9]+}}(%esp), %edx
; AVX512F-32-NEXT:    vpcmpnleub %zmm1, %zmm0, %k0 {%k1}
; AVX512F-32-NEXT:    kmovq %k0, {{[0-9]+}}(%esp)
; AVX512F-32-NEXT:    addl {{[0-9]+}}(%esp), %eax
; AVX512F-32-NEXT:    adcl {{[0-9]+}}(%esp), %edx
; AVX512F-32-NEXT:    vpcmpordub %zmm1, %zmm0, %k0 {%k1}
; AVX512F-32-NEXT:    kmovq %k0, {{[0-9]+}}(%esp)
; AVX512F-32-NEXT:    addl {{[0-9]+}}(%esp), %eax
; AVX512F-32-NEXT:    adcl {{[0-9]+}}(%esp), %edx
; AVX512F-32-NEXT:    addl $68, %esp
; AVX512F-32-NEXT:    retl
  %res0 = call i64 @llvm.x86.avx512.mask.ucmp.b.512(<64 x i8> %a0, <64 x i8> %a1, i32 0, i64 %mask)
  %res1 = call i64 @llvm.x86.avx512.mask.ucmp.b.512(<64 x i8> %a0, <64 x i8> %a1, i32 1, i64 %mask)
  %ret1 = add i64 %res0, %res1
  %res2 = call i64 @llvm.x86.avx512.mask.ucmp.b.512(<64 x i8> %a0, <64 x i8> %a1, i32 2, i64 %mask)
  %ret2 = add i64 %ret1, %res2
  %res3 = call i64 @llvm.x86.avx512.mask.ucmp.b.512(<64 x i8> %a0, <64 x i8> %a1, i32 3, i64 %mask)
  %ret3 = add i64 %ret2, %res3
  %res4 = call i64 @llvm.x86.avx512.mask.ucmp.b.512(<64 x i8> %a0, <64 x i8> %a1, i32 4, i64 %mask)
  %ret4 = add i64 %ret3, %res4
  %res5 = call i64 @llvm.x86.avx512.mask.ucmp.b.512(<64 x i8> %a0, <64 x i8> %a1, i32 5, i64 %mask)
  %ret5 = add i64 %ret4, %res5
  %res6 = call i64 @llvm.x86.avx512.mask.ucmp.b.512(<64 x i8> %a0, <64 x i8> %a1, i32 6, i64 %mask)
  %ret6 = add i64 %ret5, %res6
  %res7 = call i64 @llvm.x86.avx512.mask.ucmp.b.512(<64 x i8> %a0, <64 x i8> %a1, i32 7, i64 %mask)
  %ret7 = add i64 %ret6, %res7
  ret i64 %ret7
}

declare i64 @llvm.x86.avx512.mask.ucmp.b.512(<64 x i8>, <64 x i8>, i32, i64) nounwind readnone

define i32 @test_cmp_w_512(<32 x i16> %a0, <32 x i16> %a1) {
; AVX512BW-LABEL: test_cmp_w_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    vpcmpeqw %zmm1, %zmm0, %k0
; AVX512BW-NEXT:    kmovd %k0, %eax
; AVX512BW-NEXT:    vpcmpltw %zmm1, %zmm0, %k0
; AVX512BW-NEXT:    kmovd %k0, %ecx
; AVX512BW-NEXT:    addl %eax, %ecx
; AVX512BW-NEXT:    vpcmplew %zmm1, %zmm0, %k0
; AVX512BW-NEXT:    kmovd %k0, %eax
; AVX512BW-NEXT:    addl %ecx, %eax
; AVX512BW-NEXT:    vpcmpunordw %zmm1, %zmm0, %k0
; AVX512BW-NEXT:    kmovd %k0, %ecx
; AVX512BW-NEXT:    addl %eax, %ecx
; AVX512BW-NEXT:    vpcmpneqw %zmm1, %zmm0, %k0
; AVX512BW-NEXT:    kmovd %k0, %eax
; AVX512BW-NEXT:    addl %ecx, %eax
; AVX512BW-NEXT:    vpcmpnltw %zmm1, %zmm0, %k0
; AVX512BW-NEXT:    kmovd %k0, %ecx
; AVX512BW-NEXT:    addl %eax, %ecx
; AVX512BW-NEXT:    vpcmpnlew %zmm1, %zmm0, %k0
; AVX512BW-NEXT:    kmovd %k0, %edx
; AVX512BW-NEXT:    addl %ecx, %edx
; AVX512BW-NEXT:    vpcmpordw %zmm1, %zmm0, %k0
; AVX512BW-NEXT:    kmovd %k0, %eax
; AVX512BW-NEXT:    addl %edx, %eax
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_cmp_w_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    vpcmpeqw %zmm1, %zmm0, %k0
; AVX512F-32-NEXT:    kmovd %k0, %eax
; AVX512F-32-NEXT:    vpcmpltw %zmm1, %zmm0, %k0
; AVX512F-32-NEXT:    kmovd %k0, %ecx
; AVX512F-32-NEXT:    addl %eax, %ecx
; AVX512F-32-NEXT:    vpcmplew %zmm1, %zmm0, %k0
; AVX512F-32-NEXT:    kmovd %k0, %eax
; AVX512F-32-NEXT:    addl %ecx, %eax
; AVX512F-32-NEXT:    vpcmpunordw %zmm1, %zmm0, %k0
; AVX512F-32-NEXT:    kmovd %k0, %ecx
; AVX512F-32-NEXT:    addl %eax, %ecx
; AVX512F-32-NEXT:    vpcmpneqw %zmm1, %zmm0, %k0
; AVX512F-32-NEXT:    kmovd %k0, %eax
; AVX512F-32-NEXT:    addl %ecx, %eax
; AVX512F-32-NEXT:    vpcmpnltw %zmm1, %zmm0, %k0
; AVX512F-32-NEXT:    kmovd %k0, %ecx
; AVX512F-32-NEXT:    addl %eax, %ecx
; AVX512F-32-NEXT:    vpcmpnlew %zmm1, %zmm0, %k0
; AVX512F-32-NEXT:    kmovd %k0, %edx
; AVX512F-32-NEXT:    addl %ecx, %edx
; AVX512F-32-NEXT:    vpcmpordw %zmm1, %zmm0, %k0
; AVX512F-32-NEXT:    kmovd %k0, %eax
; AVX512F-32-NEXT:    addl %edx, %eax
; AVX512F-32-NEXT:    retl
  %res0 = call i32 @llvm.x86.avx512.mask.cmp.w.512(<32 x i16> %a0, <32 x i16> %a1, i32 0, i32 -1)
  %res1 = call i32 @llvm.x86.avx512.mask.cmp.w.512(<32 x i16> %a0, <32 x i16> %a1, i32 1, i32 -1)
  %ret1 = add i32 %res0, %res1
  %res2 = call i32 @llvm.x86.avx512.mask.cmp.w.512(<32 x i16> %a0, <32 x i16> %a1, i32 2, i32 -1)
  %ret2 = add i32 %ret1, %res2
  %res3 = call i32 @llvm.x86.avx512.mask.cmp.w.512(<32 x i16> %a0, <32 x i16> %a1, i32 3, i32 -1)
  %ret3 = add i32 %ret2, %res3
  %res4 = call i32 @llvm.x86.avx512.mask.cmp.w.512(<32 x i16> %a0, <32 x i16> %a1, i32 4, i32 -1)
  %ret4 = add i32 %ret3, %res4
  %res5 = call i32 @llvm.x86.avx512.mask.cmp.w.512(<32 x i16> %a0, <32 x i16> %a1, i32 5, i32 -1)
  %ret5 = add i32 %ret4, %res5
  %res6 = call i32 @llvm.x86.avx512.mask.cmp.w.512(<32 x i16> %a0, <32 x i16> %a1, i32 6, i32 -1)
  %ret6 = add i32 %ret5, %res6
  %res7 = call i32 @llvm.x86.avx512.mask.cmp.w.512(<32 x i16> %a0, <32 x i16> %a1, i32 7, i32 -1)
  %ret7 = add i32 %ret6, %res7
  ret i32 %ret7
}

define i32 @test_mask_cmp_w_512(<32 x i16> %a0, <32 x i16> %a1, i32 %mask) {
; AVX512BW-LABEL: test_mask_cmp_w_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovd %edi, %k1
; AVX512BW-NEXT:    vpcmpeqw %zmm1, %zmm0, %k0 {%k1}
; AVX512BW-NEXT:    kmovd %k0, %eax
; AVX512BW-NEXT:    vpcmpltw %zmm1, %zmm0, %k0 {%k1}
; AVX512BW-NEXT:    kmovd %k0, %ecx
; AVX512BW-NEXT:    addl %eax, %ecx
; AVX512BW-NEXT:    vpcmplew %zmm1, %zmm0, %k0 {%k1}
; AVX512BW-NEXT:    kmovd %k0, %eax
; AVX512BW-NEXT:    addl %ecx, %eax
; AVX512BW-NEXT:    vpcmpunordw %zmm1, %zmm0, %k0 {%k1}
; AVX512BW-NEXT:    kmovd %k0, %ecx
; AVX512BW-NEXT:    addl %eax, %ecx
; AVX512BW-NEXT:    vpcmpneqw %zmm1, %zmm0, %k0 {%k1}
; AVX512BW-NEXT:    kmovd %k0, %eax
; AVX512BW-NEXT:    addl %ecx, %eax
; AVX512BW-NEXT:    vpcmpnltw %zmm1, %zmm0, %k0 {%k1}
; AVX512BW-NEXT:    kmovd %k0, %ecx
; AVX512BW-NEXT:    addl %eax, %ecx
; AVX512BW-NEXT:    vpcmpnlew %zmm1, %zmm0, %k0 {%k1}
; AVX512BW-NEXT:    kmovd %k0, %edx
; AVX512BW-NEXT:    addl %ecx, %edx
; AVX512BW-NEXT:    vpcmpordw %zmm1, %zmm0, %k0 {%k1}
; AVX512BW-NEXT:    kmovd %k0, %eax
; AVX512BW-NEXT:    addl %edx, %eax
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_mask_cmp_w_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    vpcmpeqw %zmm1, %zmm0, %k0 {%k1}
; AVX512F-32-NEXT:    kmovd %k0, %eax
; AVX512F-32-NEXT:    vpcmpltw %zmm1, %zmm0, %k0 {%k1}
; AVX512F-32-NEXT:    kmovd %k0, %ecx
; AVX512F-32-NEXT:    addl %eax, %ecx
; AVX512F-32-NEXT:    vpcmplew %zmm1, %zmm0, %k0 {%k1}
; AVX512F-32-NEXT:    kmovd %k0, %eax
; AVX512F-32-NEXT:    addl %ecx, %eax
; AVX512F-32-NEXT:    vpcmpunordw %zmm1, %zmm0, %k0 {%k1}
; AVX512F-32-NEXT:    kmovd %k0, %ecx
; AVX512F-32-NEXT:    addl %eax, %ecx
; AVX512F-32-NEXT:    vpcmpneqw %zmm1, %zmm0, %k0 {%k1}
; AVX512F-32-NEXT:    kmovd %k0, %eax
; AVX512F-32-NEXT:    addl %ecx, %eax
; AVX512F-32-NEXT:    vpcmpnltw %zmm1, %zmm0, %k0 {%k1}
; AVX512F-32-NEXT:    kmovd %k0, %ecx
; AVX512F-32-NEXT:    addl %eax, %ecx
; AVX512F-32-NEXT:    vpcmpnlew %zmm1, %zmm0, %k0 {%k1}
; AVX512F-32-NEXT:    kmovd %k0, %edx
; AVX512F-32-NEXT:    addl %ecx, %edx
; AVX512F-32-NEXT:    vpcmpordw %zmm1, %zmm0, %k0 {%k1}
; AVX512F-32-NEXT:    kmovd %k0, %eax
; AVX512F-32-NEXT:    addl %edx, %eax
; AVX512F-32-NEXT:    retl
  %res0 = call i32 @llvm.x86.avx512.mask.cmp.w.512(<32 x i16> %a0, <32 x i16> %a1, i32 0, i32 %mask)
  %res1 = call i32 @llvm.x86.avx512.mask.cmp.w.512(<32 x i16> %a0, <32 x i16> %a1, i32 1, i32 %mask)
  %ret1 = add i32 %res0, %res1
  %res2 = call i32 @llvm.x86.avx512.mask.cmp.w.512(<32 x i16> %a0, <32 x i16> %a1, i32 2, i32 %mask)
  %ret2 = add i32 %ret1, %res2
  %res3 = call i32 @llvm.x86.avx512.mask.cmp.w.512(<32 x i16> %a0, <32 x i16> %a1, i32 3, i32 %mask)
  %ret3 = add i32 %ret2, %res3
  %res4 = call i32 @llvm.x86.avx512.mask.cmp.w.512(<32 x i16> %a0, <32 x i16> %a1, i32 4, i32 %mask)
  %ret4 = add i32 %ret3, %res4
  %res5 = call i32 @llvm.x86.avx512.mask.cmp.w.512(<32 x i16> %a0, <32 x i16> %a1, i32 5, i32 %mask)
  %ret5 = add i32 %ret4, %res5
  %res6 = call i32 @llvm.x86.avx512.mask.cmp.w.512(<32 x i16> %a0, <32 x i16> %a1, i32 6, i32 %mask)
  %ret6 = add i32 %ret5, %res6
  %res7 = call i32 @llvm.x86.avx512.mask.cmp.w.512(<32 x i16> %a0, <32 x i16> %a1, i32 7, i32 %mask)
  %ret7 = add i32 %ret6, %res7
  ret i32 %ret7
}

declare i32 @llvm.x86.avx512.mask.cmp.w.512(<32 x i16>, <32 x i16>, i32, i32) nounwind readnone

define i32 @test_ucmp_w_512(<32 x i16> %a0, <32 x i16> %a1) {
; AVX512BW-LABEL: test_ucmp_w_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    vpcmpequw %zmm1, %zmm0, %k0
; AVX512BW-NEXT:    kmovd %k0, %eax
; AVX512BW-NEXT:    vpcmpltuw %zmm1, %zmm0, %k0
; AVX512BW-NEXT:    kmovd %k0, %ecx
; AVX512BW-NEXT:    addl %eax, %ecx
; AVX512BW-NEXT:    vpcmpleuw %zmm1, %zmm0, %k0
; AVX512BW-NEXT:    kmovd %k0, %eax
; AVX512BW-NEXT:    addl %ecx, %eax
; AVX512BW-NEXT:    vpcmpunorduw %zmm1, %zmm0, %k0
; AVX512BW-NEXT:    kmovd %k0, %ecx
; AVX512BW-NEXT:    addl %eax, %ecx
; AVX512BW-NEXT:    vpcmpnequw %zmm1, %zmm0, %k0
; AVX512BW-NEXT:    kmovd %k0, %eax
; AVX512BW-NEXT:    addl %ecx, %eax
; AVX512BW-NEXT:    vpcmpnltuw %zmm1, %zmm0, %k0
; AVX512BW-NEXT:    kmovd %k0, %ecx
; AVX512BW-NEXT:    addl %eax, %ecx
; AVX512BW-NEXT:    vpcmpnleuw %zmm1, %zmm0, %k0
; AVX512BW-NEXT:    kmovd %k0, %edx
; AVX512BW-NEXT:    addl %ecx, %edx
; AVX512BW-NEXT:    vpcmporduw %zmm1, %zmm0, %k0
; AVX512BW-NEXT:    kmovd %k0, %eax
; AVX512BW-NEXT:    addl %edx, %eax
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_ucmp_w_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    vpcmpequw %zmm1, %zmm0, %k0
; AVX512F-32-NEXT:    kmovd %k0, %eax
; AVX512F-32-NEXT:    vpcmpltuw %zmm1, %zmm0, %k0
; AVX512F-32-NEXT:    kmovd %k0, %ecx
; AVX512F-32-NEXT:    addl %eax, %ecx
; AVX512F-32-NEXT:    vpcmpleuw %zmm1, %zmm0, %k0
; AVX512F-32-NEXT:    kmovd %k0, %eax
; AVX512F-32-NEXT:    addl %ecx, %eax
; AVX512F-32-NEXT:    vpcmpunorduw %zmm1, %zmm0, %k0
; AVX512F-32-NEXT:    kmovd %k0, %ecx
; AVX512F-32-NEXT:    addl %eax, %ecx
; AVX512F-32-NEXT:    vpcmpnequw %zmm1, %zmm0, %k0
; AVX512F-32-NEXT:    kmovd %k0, %eax
; AVX512F-32-NEXT:    addl %ecx, %eax
; AVX512F-32-NEXT:    vpcmpnltuw %zmm1, %zmm0, %k0
; AVX512F-32-NEXT:    kmovd %k0, %ecx
; AVX512F-32-NEXT:    addl %eax, %ecx
; AVX512F-32-NEXT:    vpcmpnleuw %zmm1, %zmm0, %k0
; AVX512F-32-NEXT:    kmovd %k0, %edx
; AVX512F-32-NEXT:    addl %ecx, %edx
; AVX512F-32-NEXT:    vpcmporduw %zmm1, %zmm0, %k0
; AVX512F-32-NEXT:    kmovd %k0, %eax
; AVX512F-32-NEXT:    addl %edx, %eax
; AVX512F-32-NEXT:    retl
  %res0 = call i32 @llvm.x86.avx512.mask.ucmp.w.512(<32 x i16> %a0, <32 x i16> %a1, i32 0, i32 -1)
  %res1 = call i32 @llvm.x86.avx512.mask.ucmp.w.512(<32 x i16> %a0, <32 x i16> %a1, i32 1, i32 -1)
  %ret1 = add i32 %res0, %res1
  %res2 = call i32 @llvm.x86.avx512.mask.ucmp.w.512(<32 x i16> %a0, <32 x i16> %a1, i32 2, i32 -1)
  %ret2 = add i32 %ret1, %res2
  %res3 = call i32 @llvm.x86.avx512.mask.ucmp.w.512(<32 x i16> %a0, <32 x i16> %a1, i32 3, i32 -1)
  %ret3 = add i32 %ret2, %res3
  %res4 = call i32 @llvm.x86.avx512.mask.ucmp.w.512(<32 x i16> %a0, <32 x i16> %a1, i32 4, i32 -1)
  %ret4 = add i32 %ret3, %res4
  %res5 = call i32 @llvm.x86.avx512.mask.ucmp.w.512(<32 x i16> %a0, <32 x i16> %a1, i32 5, i32 -1)
  %ret5 = add i32 %ret4, %res5
  %res6 = call i32 @llvm.x86.avx512.mask.ucmp.w.512(<32 x i16> %a0, <32 x i16> %a1, i32 6, i32 -1)
  %ret6 = add i32 %ret5, %res6
  %res7 = call i32 @llvm.x86.avx512.mask.ucmp.w.512(<32 x i16> %a0, <32 x i16> %a1, i32 7, i32 -1)
  %ret7 = add i32 %ret6, %res7
  ret i32 %ret7
}

define i32 @test_mask_ucmp_w_512(<32 x i16> %a0, <32 x i16> %a1, i32 %mask) {
; AVX512BW-LABEL: test_mask_ucmp_w_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovd %edi, %k1
; AVX512BW-NEXT:    vpcmpequw %zmm1, %zmm0, %k0 {%k1}
; AVX512BW-NEXT:    kmovd %k0, %eax
; AVX512BW-NEXT:    vpcmpltuw %zmm1, %zmm0, %k0 {%k1}
; AVX512BW-NEXT:    kmovd %k0, %ecx
; AVX512BW-NEXT:    addl %eax, %ecx
; AVX512BW-NEXT:    vpcmpleuw %zmm1, %zmm0, %k0 {%k1}
; AVX512BW-NEXT:    kmovd %k0, %eax
; AVX512BW-NEXT:    addl %ecx, %eax
; AVX512BW-NEXT:    vpcmpunorduw %zmm1, %zmm0, %k0 {%k1}
; AVX512BW-NEXT:    kmovd %k0, %ecx
; AVX512BW-NEXT:    addl %eax, %ecx
; AVX512BW-NEXT:    vpcmpnequw %zmm1, %zmm0, %k0 {%k1}
; AVX512BW-NEXT:    kmovd %k0, %eax
; AVX512BW-NEXT:    addl %ecx, %eax
; AVX512BW-NEXT:    vpcmpnltuw %zmm1, %zmm0, %k0 {%k1}
; AVX512BW-NEXT:    kmovd %k0, %ecx
; AVX512BW-NEXT:    addl %eax, %ecx
; AVX512BW-NEXT:    vpcmpnleuw %zmm1, %zmm0, %k0 {%k1}
; AVX512BW-NEXT:    kmovd %k0, %edx
; AVX512BW-NEXT:    addl %ecx, %edx
; AVX512BW-NEXT:    vpcmporduw %zmm1, %zmm0, %k0 {%k1}
; AVX512BW-NEXT:    kmovd %k0, %eax
; AVX512BW-NEXT:    addl %edx, %eax
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_mask_ucmp_w_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    vpcmpequw %zmm1, %zmm0, %k0 {%k1}
; AVX512F-32-NEXT:    kmovd %k0, %eax
; AVX512F-32-NEXT:    vpcmpltuw %zmm1, %zmm0, %k0 {%k1}
; AVX512F-32-NEXT:    kmovd %k0, %ecx
; AVX512F-32-NEXT:    addl %eax, %ecx
; AVX512F-32-NEXT:    vpcmpleuw %zmm1, %zmm0, %k0 {%k1}
; AVX512F-32-NEXT:    kmovd %k0, %eax
; AVX512F-32-NEXT:    addl %ecx, %eax
; AVX512F-32-NEXT:    vpcmpunorduw %zmm1, %zmm0, %k0 {%k1}
; AVX512F-32-NEXT:    kmovd %k0, %ecx
; AVX512F-32-NEXT:    addl %eax, %ecx
; AVX512F-32-NEXT:    vpcmpnequw %zmm1, %zmm0, %k0 {%k1}
; AVX512F-32-NEXT:    kmovd %k0, %eax
; AVX512F-32-NEXT:    addl %ecx, %eax
; AVX512F-32-NEXT:    vpcmpnltuw %zmm1, %zmm0, %k0 {%k1}
; AVX512F-32-NEXT:    kmovd %k0, %ecx
; AVX512F-32-NEXT:    addl %eax, %ecx
; AVX512F-32-NEXT:    vpcmpnleuw %zmm1, %zmm0, %k0 {%k1}
; AVX512F-32-NEXT:    kmovd %k0, %edx
; AVX512F-32-NEXT:    addl %ecx, %edx
; AVX512F-32-NEXT:    vpcmporduw %zmm1, %zmm0, %k0 {%k1}
; AVX512F-32-NEXT:    kmovd %k0, %eax
; AVX512F-32-NEXT:    addl %edx, %eax
; AVX512F-32-NEXT:    retl
  %res0 = call i32 @llvm.x86.avx512.mask.ucmp.w.512(<32 x i16> %a0, <32 x i16> %a1, i32 0, i32 %mask)
  %res1 = call i32 @llvm.x86.avx512.mask.ucmp.w.512(<32 x i16> %a0, <32 x i16> %a1, i32 1, i32 %mask)
  %ret1 = add i32 %res0, %res1
  %res2 = call i32 @llvm.x86.avx512.mask.ucmp.w.512(<32 x i16> %a0, <32 x i16> %a1, i32 2, i32 %mask)
  %ret2 = add i32 %ret1, %res2
  %res3 = call i32 @llvm.x86.avx512.mask.ucmp.w.512(<32 x i16> %a0, <32 x i16> %a1, i32 3, i32 %mask)
  %ret3 = add i32 %ret2, %res3
  %res4 = call i32 @llvm.x86.avx512.mask.ucmp.w.512(<32 x i16> %a0, <32 x i16> %a1, i32 4, i32 %mask)
  %ret4 = add i32 %ret3, %res4
  %res5 = call i32 @llvm.x86.avx512.mask.ucmp.w.512(<32 x i16> %a0, <32 x i16> %a1, i32 5, i32 %mask)
  %ret5 = add i32 %ret4, %res5
  %res6 = call i32 @llvm.x86.avx512.mask.ucmp.w.512(<32 x i16> %a0, <32 x i16> %a1, i32 6, i32 %mask)
  %ret6 = add i32 %ret5, %res6
  %res7 = call i32 @llvm.x86.avx512.mask.ucmp.w.512(<32 x i16> %a0, <32 x i16> %a1, i32 7, i32 %mask)
  %ret7 = add i32 %ret6, %res7
  ret i32 %ret7
}

declare i32 @llvm.x86.avx512.mask.ucmp.w.512(<32 x i16>, <32 x i16>, i32, i32) nounwind readnone

declare <64 x i8> @llvm.x86.avx512.mask.blend.b.512(<64 x i8>, <64 x i8>, i64) nounwind readonly

define <32 x i16> @test_x86_mask_blend_w_512(i32 %mask, <32 x i16> %a1, <32 x i16> %a2) {
; AVX512BW-LABEL: test_x86_mask_blend_w_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovd %edi, %k1
; AVX512BW-NEXT:    vpblendmw %zmm1, %zmm0, %zmm0 {%k1}
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_x86_mask_blend_w_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    vpblendmw %zmm1, %zmm0, %zmm0 {%k1}
; AVX512F-32-NEXT:    retl
    %res = call <32 x i16> @llvm.x86.avx512.mask.blend.w.512(<32 x i16> %a1, <32 x i16> %a2, i32 %mask) ; <<32 x i16>> [#uses=1]
  ret <32 x i16> %res
}
declare <32 x i16> @llvm.x86.avx512.mask.blend.w.512(<32 x i16>, <32 x i16>, i32) nounwind readonly

define <64 x i8> @test_x86_mask_blend_b_512(i64 %a0, <64 x i8> %a1, <64 x i8> %a2) {
; AVX512BW-LABEL: test_x86_mask_blend_b_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovq %rdi, %k1
; AVX512BW-NEXT:    vpblendmb %zmm1, %zmm0, %zmm0 {%k1}
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_x86_mask_blend_b_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k0
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    kunpckdq %k0, %k1, %k1
; AVX512F-32-NEXT:    vpblendmb %zmm1, %zmm0, %zmm0 {%k1}
; AVX512F-32-NEXT:    retl
  %res = call <64 x i8> @llvm.x86.avx512.mask.blend.b.512(<64 x i8> %a1, <64 x i8> %a2, i64 %a0) ; <<64 x i8>> [#uses=1]
  ret <64 x i8> %res
}

define <32 x i16> @test_mask_packs_epi32_rr_512(<16 x i32> %a, <16 x i32> %b) {
; AVX512BW-LABEL: test_mask_packs_epi32_rr_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    vpackssdw %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_mask_packs_epi32_rr_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    vpackssdw %zmm1, %zmm0, %zmm0
; AVX512F-32-NEXT:    retl
  %res = call <32 x i16> @llvm.x86.avx512.mask.packssdw.512(<16 x i32> %a, <16 x i32> %b, <32 x i16> zeroinitializer, i32 -1)
  ret <32 x i16> %res
}

define <32 x i16> @test_mask_packs_epi32_rrk_512(<16 x i32> %a, <16 x i32> %b, <32 x i16> %passThru, i32 %mask) {
; AVX512BW-LABEL: test_mask_packs_epi32_rrk_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovd %edi, %k1
; AVX512BW-NEXT:    vpackssdw %zmm1, %zmm0, %zmm2 {%k1}
; AVX512BW-NEXT:    vmovaps %zmm2, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_mask_packs_epi32_rrk_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    vpackssdw %zmm1, %zmm0, %zmm2 {%k1}
; AVX512F-32-NEXT:    vmovaps %zmm2, %zmm0
; AVX512F-32-NEXT:    retl
  %res = call <32 x i16> @llvm.x86.avx512.mask.packssdw.512(<16 x i32> %a, <16 x i32> %b, <32 x i16> %passThru, i32 %mask)
  ret <32 x i16> %res
}

define <32 x i16> @test_mask_packs_epi32_rrkz_512(<16 x i32> %a, <16 x i32> %b, i32 %mask) {
; AVX512BW-LABEL: test_mask_packs_epi32_rrkz_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovd %edi, %k1
; AVX512BW-NEXT:    vpackssdw %zmm1, %zmm0, %zmm0 {%k1} {z}
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_mask_packs_epi32_rrkz_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    vpackssdw %zmm1, %zmm0, %zmm0 {%k1} {z}
; AVX512F-32-NEXT:    retl
  %res = call <32 x i16> @llvm.x86.avx512.mask.packssdw.512(<16 x i32> %a, <16 x i32> %b, <32 x i16> zeroinitializer, i32 %mask)
  ret <32 x i16> %res
}

define <32 x i16> @test_mask_packs_epi32_rm_512(<16 x i32> %a, <16 x i32>* %ptr_b) {
; AVX512BW-LABEL: test_mask_packs_epi32_rm_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    vpackssdw (%rdi), %zmm0, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_mask_packs_epi32_rm_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX512F-32-NEXT:    vpackssdw (%eax), %zmm0, %zmm0
; AVX512F-32-NEXT:    retl
  %b = load <16 x i32>, <16 x i32>* %ptr_b
  %res = call <32 x i16> @llvm.x86.avx512.mask.packssdw.512(<16 x i32> %a, <16 x i32> %b, <32 x i16> zeroinitializer, i32 -1)
  ret <32 x i16> %res
}

define <32 x i16> @test_mask_packs_epi32_rmk_512(<16 x i32> %a, <16 x i32>* %ptr_b, <32 x i16> %passThru, i32 %mask) {
; AVX512BW-LABEL: test_mask_packs_epi32_rmk_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovd %esi, %k1
; AVX512BW-NEXT:    vpackssdw (%rdi), %zmm0, %zmm1 {%k1}
; AVX512BW-NEXT:    vmovaps %zmm1, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_mask_packs_epi32_rmk_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    vpackssdw (%eax), %zmm0, %zmm1 {%k1}
; AVX512F-32-NEXT:    vmovaps %zmm1, %zmm0
; AVX512F-32-NEXT:    retl
  %b = load <16 x i32>, <16 x i32>* %ptr_b
  %res = call <32 x i16> @llvm.x86.avx512.mask.packssdw.512(<16 x i32> %a, <16 x i32> %b, <32 x i16> %passThru, i32 %mask)
  ret <32 x i16> %res
}

define <32 x i16> @test_mask_packs_epi32_rmkz_512(<16 x i32> %a, <16 x i32>* %ptr_b, i32 %mask) {
; AVX512BW-LABEL: test_mask_packs_epi32_rmkz_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovd %esi, %k1
; AVX512BW-NEXT:    vpackssdw (%rdi), %zmm0, %zmm0 {%k1} {z}
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_mask_packs_epi32_rmkz_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    vpackssdw (%eax), %zmm0, %zmm0 {%k1} {z}
; AVX512F-32-NEXT:    retl
  %b = load <16 x i32>, <16 x i32>* %ptr_b
  %res = call <32 x i16> @llvm.x86.avx512.mask.packssdw.512(<16 x i32> %a, <16 x i32> %b, <32 x i16> zeroinitializer, i32 %mask)
  ret <32 x i16> %res
}

define <32 x i16> @test_mask_packs_epi32_rmb_512(<16 x i32> %a, i32* %ptr_b) {
; AVX512BW-LABEL: test_mask_packs_epi32_rmb_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    vpackssdw (%rdi){1to16}, %zmm0, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_mask_packs_epi32_rmb_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX512F-32-NEXT:    vpackssdw (%eax){1to16}, %zmm0, %zmm0
; AVX512F-32-NEXT:    retl
  %q = load i32, i32* %ptr_b
  %vecinit.i = insertelement <16 x i32> undef, i32 %q, i32 0
  %b = shufflevector <16 x i32> %vecinit.i, <16 x i32> undef, <16 x i32> zeroinitializer
  %res = call <32 x i16> @llvm.x86.avx512.mask.packssdw.512(<16 x i32> %a, <16 x i32> %b, <32 x i16> zeroinitializer, i32 -1)
  ret <32 x i16> %res
}

define <32 x i16> @test_mask_packs_epi32_rmbk_512(<16 x i32> %a, i32* %ptr_b, <32 x i16> %passThru, i32 %mask) {
; AVX512BW-LABEL: test_mask_packs_epi32_rmbk_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovd %esi, %k1
; AVX512BW-NEXT:    vpackssdw (%rdi){1to16}, %zmm0, %zmm1 {%k1}
; AVX512BW-NEXT:    vmovaps %zmm1, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_mask_packs_epi32_rmbk_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    vpackssdw (%eax){1to16}, %zmm0, %zmm1 {%k1}
; AVX512F-32-NEXT:    vmovaps %zmm1, %zmm0
; AVX512F-32-NEXT:    retl
  %q = load i32, i32* %ptr_b
  %vecinit.i = insertelement <16 x i32> undef, i32 %q, i32 0
  %b = shufflevector <16 x i32> %vecinit.i, <16 x i32> undef, <16 x i32> zeroinitializer
  %res = call <32 x i16> @llvm.x86.avx512.mask.packssdw.512(<16 x i32> %a, <16 x i32> %b, <32 x i16> %passThru, i32 %mask)
  ret <32 x i16> %res
}

define <32 x i16> @test_mask_packs_epi32_rmbkz_512(<16 x i32> %a, i32* %ptr_b, i32 %mask) {
; AVX512BW-LABEL: test_mask_packs_epi32_rmbkz_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovd %esi, %k1
; AVX512BW-NEXT:    vpackssdw (%rdi){1to16}, %zmm0, %zmm0 {%k1} {z}
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_mask_packs_epi32_rmbkz_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    vpackssdw (%eax){1to16}, %zmm0, %zmm0 {%k1} {z}
; AVX512F-32-NEXT:    retl
  %q = load i32, i32* %ptr_b
  %vecinit.i = insertelement <16 x i32> undef, i32 %q, i32 0
  %b = shufflevector <16 x i32> %vecinit.i, <16 x i32> undef, <16 x i32> zeroinitializer
  %res = call <32 x i16> @llvm.x86.avx512.mask.packssdw.512(<16 x i32> %a, <16 x i32> %b, <32 x i16> zeroinitializer, i32 %mask)
  ret <32 x i16> %res
}

declare <32 x i16> @llvm.x86.avx512.mask.packssdw.512(<16 x i32>, <16 x i32>, <32 x i16>, i32)

define <64 x i8> @test_mask_packs_epi16_rr_512(<32 x i16> %a, <32 x i16> %b) {
; AVX512BW-LABEL: test_mask_packs_epi16_rr_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    vpacksswb %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_mask_packs_epi16_rr_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    vpacksswb %zmm1, %zmm0, %zmm0
; AVX512F-32-NEXT:    retl
  %res = call <64 x i8> @llvm.x86.avx512.mask.packsswb.512(<32 x i16> %a, <32 x i16> %b, <64 x i8> zeroinitializer, i64 -1)
  ret <64 x i8> %res
}

define <64 x i8> @test_mask_packs_epi16_rrk_512(<32 x i16> %a, <32 x i16> %b, <64 x i8> %passThru, i64 %mask) {
; AVX512BW-LABEL: test_mask_packs_epi16_rrk_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovq %rdi, %k1
; AVX512BW-NEXT:    vpacksswb %zmm1, %zmm0, %zmm2 {%k1}
; AVX512BW-NEXT:    vmovaps %zmm2, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_mask_packs_epi16_rrk_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k0
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    kunpckdq %k0, %k1, %k1
; AVX512F-32-NEXT:    vpacksswb %zmm1, %zmm0, %zmm2 {%k1}
; AVX512F-32-NEXT:    vmovaps %zmm2, %zmm0
; AVX512F-32-NEXT:    retl
  %res = call <64 x i8> @llvm.x86.avx512.mask.packsswb.512(<32 x i16> %a, <32 x i16> %b, <64 x i8> %passThru, i64 %mask)
  ret <64 x i8> %res
}

define <64 x i8> @test_mask_packs_epi16_rrkz_512(<32 x i16> %a, <32 x i16> %b, i64 %mask) {
; AVX512BW-LABEL: test_mask_packs_epi16_rrkz_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovq %rdi, %k1
; AVX512BW-NEXT:    vpacksswb %zmm1, %zmm0, %zmm0 {%k1} {z}
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_mask_packs_epi16_rrkz_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k0
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    kunpckdq %k0, %k1, %k1
; AVX512F-32-NEXT:    vpacksswb %zmm1, %zmm0, %zmm0 {%k1} {z}
; AVX512F-32-NEXT:    retl
  %res = call <64 x i8> @llvm.x86.avx512.mask.packsswb.512(<32 x i16> %a, <32 x i16> %b, <64 x i8> zeroinitializer, i64 %mask)
  ret <64 x i8> %res
}

define <64 x i8> @test_mask_packs_epi16_rm_512(<32 x i16> %a, <32 x i16>* %ptr_b) {
; AVX512BW-LABEL: test_mask_packs_epi16_rm_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    vpacksswb (%rdi), %zmm0, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_mask_packs_epi16_rm_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX512F-32-NEXT:    vpacksswb (%eax), %zmm0, %zmm0
; AVX512F-32-NEXT:    retl
  %b = load <32 x i16>, <32 x i16>* %ptr_b
  %res = call <64 x i8> @llvm.x86.avx512.mask.packsswb.512(<32 x i16> %a, <32 x i16> %b, <64 x i8> zeroinitializer, i64 -1)
  ret <64 x i8> %res
}

define <64 x i8> @test_mask_packs_epi16_rmk_512(<32 x i16> %a, <32 x i16>* %ptr_b, <64 x i8> %passThru, i64 %mask) {
; AVX512BW-LABEL: test_mask_packs_epi16_rmk_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovq %rsi, %k1
; AVX512BW-NEXT:    vpacksswb (%rdi), %zmm0, %zmm1 {%k1}
; AVX512BW-NEXT:    vmovaps %zmm1, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_mask_packs_epi16_rmk_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k0
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    kunpckdq %k0, %k1, %k1
; AVX512F-32-NEXT:    vpacksswb (%eax), %zmm0, %zmm1 {%k1}
; AVX512F-32-NEXT:    vmovaps %zmm1, %zmm0
; AVX512F-32-NEXT:    retl
  %b = load <32 x i16>, <32 x i16>* %ptr_b
  %res = call <64 x i8> @llvm.x86.avx512.mask.packsswb.512(<32 x i16> %a, <32 x i16> %b, <64 x i8> %passThru, i64 %mask)
  ret <64 x i8> %res
}

define <64 x i8> @test_mask_packs_epi16_rmkz_512(<32 x i16> %a, <32 x i16>* %ptr_b, i64 %mask) {
; AVX512BW-LABEL: test_mask_packs_epi16_rmkz_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovq %rsi, %k1
; AVX512BW-NEXT:    vpacksswb (%rdi), %zmm0, %zmm0 {%k1} {z}
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_mask_packs_epi16_rmkz_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k0
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    kunpckdq %k0, %k1, %k1
; AVX512F-32-NEXT:    vpacksswb (%eax), %zmm0, %zmm0 {%k1} {z}
; AVX512F-32-NEXT:    retl
  %b = load <32 x i16>, <32 x i16>* %ptr_b
  %res = call <64 x i8> @llvm.x86.avx512.mask.packsswb.512(<32 x i16> %a, <32 x i16> %b, <64 x i8> zeroinitializer, i64 %mask)
  ret <64 x i8> %res
}

declare <64 x i8> @llvm.x86.avx512.mask.packsswb.512(<32 x i16>, <32 x i16>, <64 x i8>, i64)


define <32 x i16> @test_mask_packus_epi32_rr_512(<16 x i32> %a, <16 x i32> %b) {
; AVX512BW-LABEL: test_mask_packus_epi32_rr_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    vpackusdw %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_mask_packus_epi32_rr_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    vpackusdw %zmm1, %zmm0, %zmm0
; AVX512F-32-NEXT:    retl
  %res = call <32 x i16> @llvm.x86.avx512.mask.packusdw.512(<16 x i32> %a, <16 x i32> %b, <32 x i16> zeroinitializer, i32 -1)
  ret <32 x i16> %res
}

define <32 x i16> @test_mask_packus_epi32_rrk_512(<16 x i32> %a, <16 x i32> %b, <32 x i16> %passThru, i32 %mask) {
; AVX512BW-LABEL: test_mask_packus_epi32_rrk_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovd %edi, %k1
; AVX512BW-NEXT:    vpackusdw %zmm1, %zmm0, %zmm2 {%k1}
; AVX512BW-NEXT:    vmovaps %zmm2, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_mask_packus_epi32_rrk_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    vpackusdw %zmm1, %zmm0, %zmm2 {%k1}
; AVX512F-32-NEXT:    vmovaps %zmm2, %zmm0
; AVX512F-32-NEXT:    retl
  %res = call <32 x i16> @llvm.x86.avx512.mask.packusdw.512(<16 x i32> %a, <16 x i32> %b, <32 x i16> %passThru, i32 %mask)
  ret <32 x i16> %res
}

define <32 x i16> @test_mask_packus_epi32_rrkz_512(<16 x i32> %a, <16 x i32> %b, i32 %mask) {
; AVX512BW-LABEL: test_mask_packus_epi32_rrkz_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovd %edi, %k1
; AVX512BW-NEXT:    vpackusdw %zmm1, %zmm0, %zmm0 {%k1} {z}
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_mask_packus_epi32_rrkz_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    vpackusdw %zmm1, %zmm0, %zmm0 {%k1} {z}
; AVX512F-32-NEXT:    retl
  %res = call <32 x i16> @llvm.x86.avx512.mask.packusdw.512(<16 x i32> %a, <16 x i32> %b, <32 x i16> zeroinitializer, i32 %mask)
  ret <32 x i16> %res
}

define <32 x i16> @test_mask_packus_epi32_rm_512(<16 x i32> %a, <16 x i32>* %ptr_b) {
; AVX512BW-LABEL: test_mask_packus_epi32_rm_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    vpackusdw (%rdi), %zmm0, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_mask_packus_epi32_rm_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX512F-32-NEXT:    vpackusdw (%eax), %zmm0, %zmm0
; AVX512F-32-NEXT:    retl
  %b = load <16 x i32>, <16 x i32>* %ptr_b
  %res = call <32 x i16> @llvm.x86.avx512.mask.packusdw.512(<16 x i32> %a, <16 x i32> %b, <32 x i16> zeroinitializer, i32 -1)
  ret <32 x i16> %res
}

define <32 x i16> @test_mask_packus_epi32_rmk_512(<16 x i32> %a, <16 x i32>* %ptr_b, <32 x i16> %passThru, i32 %mask) {
; AVX512BW-LABEL: test_mask_packus_epi32_rmk_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovd %esi, %k1
; AVX512BW-NEXT:    vpackusdw (%rdi), %zmm0, %zmm1 {%k1}
; AVX512BW-NEXT:    vmovaps %zmm1, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_mask_packus_epi32_rmk_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    vpackusdw (%eax), %zmm0, %zmm1 {%k1}
; AVX512F-32-NEXT:    vmovaps %zmm1, %zmm0
; AVX512F-32-NEXT:    retl
  %b = load <16 x i32>, <16 x i32>* %ptr_b
  %res = call <32 x i16> @llvm.x86.avx512.mask.packusdw.512(<16 x i32> %a, <16 x i32> %b, <32 x i16> %passThru, i32 %mask)
  ret <32 x i16> %res
}

define <32 x i16> @test_mask_packus_epi32_rmkz_512(<16 x i32> %a, <16 x i32>* %ptr_b, i32 %mask) {
; AVX512BW-LABEL: test_mask_packus_epi32_rmkz_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovd %esi, %k1
; AVX512BW-NEXT:    vpackusdw (%rdi), %zmm0, %zmm0 {%k1} {z}
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_mask_packus_epi32_rmkz_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    vpackusdw (%eax), %zmm0, %zmm0 {%k1} {z}
; AVX512F-32-NEXT:    retl
  %b = load <16 x i32>, <16 x i32>* %ptr_b
  %res = call <32 x i16> @llvm.x86.avx512.mask.packusdw.512(<16 x i32> %a, <16 x i32> %b, <32 x i16> zeroinitializer, i32 %mask)
  ret <32 x i16> %res
}

define <32 x i16> @test_mask_packus_epi32_rmb_512(<16 x i32> %a, i32* %ptr_b) {
; AVX512BW-LABEL: test_mask_packus_epi32_rmb_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    vpackusdw (%rdi){1to16}, %zmm0, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_mask_packus_epi32_rmb_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX512F-32-NEXT:    vpackusdw (%eax){1to16}, %zmm0, %zmm0
; AVX512F-32-NEXT:    retl
  %q = load i32, i32* %ptr_b
  %vecinit.i = insertelement <16 x i32> undef, i32 %q, i32 0
  %b = shufflevector <16 x i32> %vecinit.i, <16 x i32> undef, <16 x i32> zeroinitializer
  %res = call <32 x i16> @llvm.x86.avx512.mask.packusdw.512(<16 x i32> %a, <16 x i32> %b, <32 x i16> zeroinitializer, i32 -1)
  ret <32 x i16> %res
}

define <32 x i16> @test_mask_packus_epi32_rmbk_512(<16 x i32> %a, i32* %ptr_b, <32 x i16> %passThru, i32 %mask) {
; AVX512BW-LABEL: test_mask_packus_epi32_rmbk_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovd %esi, %k1
; AVX512BW-NEXT:    vpackusdw (%rdi){1to16}, %zmm0, %zmm1 {%k1}
; AVX512BW-NEXT:    vmovaps %zmm1, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_mask_packus_epi32_rmbk_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    vpackusdw (%eax){1to16}, %zmm0, %zmm1 {%k1}
; AVX512F-32-NEXT:    vmovaps %zmm1, %zmm0
; AVX512F-32-NEXT:    retl
  %q = load i32, i32* %ptr_b
  %vecinit.i = insertelement <16 x i32> undef, i32 %q, i32 0
  %b = shufflevector <16 x i32> %vecinit.i, <16 x i32> undef, <16 x i32> zeroinitializer
  %res = call <32 x i16> @llvm.x86.avx512.mask.packusdw.512(<16 x i32> %a, <16 x i32> %b, <32 x i16> %passThru, i32 %mask)
  ret <32 x i16> %res
}

define <32 x i16> @test_mask_packus_epi32_rmbkz_512(<16 x i32> %a, i32* %ptr_b, i32 %mask) {
; AVX512BW-LABEL: test_mask_packus_epi32_rmbkz_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovd %esi, %k1
; AVX512BW-NEXT:    vpackusdw (%rdi){1to16}, %zmm0, %zmm0 {%k1} {z}
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_mask_packus_epi32_rmbkz_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    vpackusdw (%eax){1to16}, %zmm0, %zmm0 {%k1} {z}
; AVX512F-32-NEXT:    retl
  %q = load i32, i32* %ptr_b
  %vecinit.i = insertelement <16 x i32> undef, i32 %q, i32 0
  %b = shufflevector <16 x i32> %vecinit.i, <16 x i32> undef, <16 x i32> zeroinitializer
  %res = call <32 x i16> @llvm.x86.avx512.mask.packusdw.512(<16 x i32> %a, <16 x i32> %b, <32 x i16> zeroinitializer, i32 %mask)
  ret <32 x i16> %res
}

declare <32 x i16> @llvm.x86.avx512.mask.packusdw.512(<16 x i32>, <16 x i32>, <32 x i16>, i32)

define <64 x i8> @test_mask_packus_epi16_rr_512(<32 x i16> %a, <32 x i16> %b) {
; AVX512BW-LABEL: test_mask_packus_epi16_rr_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    vpackuswb %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_mask_packus_epi16_rr_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    vpackuswb %zmm1, %zmm0, %zmm0
; AVX512F-32-NEXT:    retl
  %res = call <64 x i8> @llvm.x86.avx512.mask.packuswb.512(<32 x i16> %a, <32 x i16> %b, <64 x i8> zeroinitializer, i64 -1)
  ret <64 x i8> %res
}

define <64 x i8> @test_mask_packus_epi16_rrk_512(<32 x i16> %a, <32 x i16> %b, <64 x i8> %passThru, i64 %mask) {
; AVX512BW-LABEL: test_mask_packus_epi16_rrk_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovq %rdi, %k1
; AVX512BW-NEXT:    vpackuswb %zmm1, %zmm0, %zmm2 {%k1}
; AVX512BW-NEXT:    vmovaps %zmm2, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_mask_packus_epi16_rrk_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k0
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    kunpckdq %k0, %k1, %k1
; AVX512F-32-NEXT:    vpackuswb %zmm1, %zmm0, %zmm2 {%k1}
; AVX512F-32-NEXT:    vmovaps %zmm2, %zmm0
; AVX512F-32-NEXT:    retl
  %res = call <64 x i8> @llvm.x86.avx512.mask.packuswb.512(<32 x i16> %a, <32 x i16> %b, <64 x i8> %passThru, i64 %mask)
  ret <64 x i8> %res
}

define <64 x i8> @test_mask_packus_epi16_rrkz_512(<32 x i16> %a, <32 x i16> %b, i64 %mask) {
; AVX512BW-LABEL: test_mask_packus_epi16_rrkz_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovq %rdi, %k1
; AVX512BW-NEXT:    vpackuswb %zmm1, %zmm0, %zmm0 {%k1} {z}
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_mask_packus_epi16_rrkz_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k0
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    kunpckdq %k0, %k1, %k1
; AVX512F-32-NEXT:    vpackuswb %zmm1, %zmm0, %zmm0 {%k1} {z}
; AVX512F-32-NEXT:    retl
  %res = call <64 x i8> @llvm.x86.avx512.mask.packuswb.512(<32 x i16> %a, <32 x i16> %b, <64 x i8> zeroinitializer, i64 %mask)
  ret <64 x i8> %res
}

define <64 x i8> @test_mask_packus_epi16_rm_512(<32 x i16> %a, <32 x i16>* %ptr_b) {
; AVX512BW-LABEL: test_mask_packus_epi16_rm_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    vpackuswb (%rdi), %zmm0, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_mask_packus_epi16_rm_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX512F-32-NEXT:    vpackuswb (%eax), %zmm0, %zmm0
; AVX512F-32-NEXT:    retl
  %b = load <32 x i16>, <32 x i16>* %ptr_b
  %res = call <64 x i8> @llvm.x86.avx512.mask.packuswb.512(<32 x i16> %a, <32 x i16> %b, <64 x i8> zeroinitializer, i64 -1)
  ret <64 x i8> %res
}

define <64 x i8> @test_mask_packus_epi16_rmk_512(<32 x i16> %a, <32 x i16>* %ptr_b, <64 x i8> %passThru, i64 %mask) {
; AVX512BW-LABEL: test_mask_packus_epi16_rmk_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovq %rsi, %k1
; AVX512BW-NEXT:    vpackuswb (%rdi), %zmm0, %zmm1 {%k1}
; AVX512BW-NEXT:    vmovaps %zmm1, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_mask_packus_epi16_rmk_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k0
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    kunpckdq %k0, %k1, %k1
; AVX512F-32-NEXT:    vpackuswb (%eax), %zmm0, %zmm1 {%k1}
; AVX512F-32-NEXT:    vmovaps %zmm1, %zmm0
; AVX512F-32-NEXT:    retl
  %b = load <32 x i16>, <32 x i16>* %ptr_b
  %res = call <64 x i8> @llvm.x86.avx512.mask.packuswb.512(<32 x i16> %a, <32 x i16> %b, <64 x i8> %passThru, i64 %mask)
  ret <64 x i8> %res
}

define <64 x i8> @test_mask_packus_epi16_rmkz_512(<32 x i16> %a, <32 x i16>* %ptr_b, i64 %mask) {
; AVX512BW-LABEL: test_mask_packus_epi16_rmkz_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovq %rsi, %k1
; AVX512BW-NEXT:    vpackuswb (%rdi), %zmm0, %zmm0 {%k1} {z}
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_mask_packus_epi16_rmkz_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k0
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    kunpckdq %k0, %k1, %k1
; AVX512F-32-NEXT:    vpackuswb (%eax), %zmm0, %zmm0 {%k1} {z}
; AVX512F-32-NEXT:    retl
  %b = load <32 x i16>, <32 x i16>* %ptr_b
  %res = call <64 x i8> @llvm.x86.avx512.mask.packuswb.512(<32 x i16> %a, <32 x i16> %b, <64 x i8> zeroinitializer, i64 %mask)
  ret <64 x i8> %res
}

declare <64 x i8> @llvm.x86.avx512.mask.packuswb.512(<32 x i16>, <32 x i16>, <64 x i8>, i64)

define <32 x i16> @test_mask_adds_epi16_rr_512(<32 x i16> %a, <32 x i16> %b) {
; AVX512BW-LABEL: test_mask_adds_epi16_rr_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    vpaddsw %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_mask_adds_epi16_rr_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    vpaddsw %zmm1, %zmm0, %zmm0
; AVX512F-32-NEXT:    retl
  %res = call <32 x i16> @llvm.x86.avx512.mask.padds.w.512(<32 x i16> %a, <32 x i16> %b, <32 x i16> zeroinitializer, i32 -1)
  ret <32 x i16> %res
}

define <32 x i16> @test_mask_adds_epi16_rrk_512(<32 x i16> %a, <32 x i16> %b, <32 x i16> %passThru, i32 %mask) {
; AVX512BW-LABEL: test_mask_adds_epi16_rrk_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovd %edi, %k1
; AVX512BW-NEXT:    vpaddsw %zmm1, %zmm0, %zmm2 {%k1}
; AVX512BW-NEXT:    vmovaps %zmm2, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_mask_adds_epi16_rrk_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    vpaddsw %zmm1, %zmm0, %zmm2 {%k1}
; AVX512F-32-NEXT:    vmovaps %zmm2, %zmm0
; AVX512F-32-NEXT:    retl
  %res = call <32 x i16> @llvm.x86.avx512.mask.padds.w.512(<32 x i16> %a, <32 x i16> %b, <32 x i16> %passThru, i32 %mask)
  ret <32 x i16> %res
}

define <32 x i16> @test_mask_adds_epi16_rrkz_512(<32 x i16> %a, <32 x i16> %b, i32 %mask) {
; AVX512BW-LABEL: test_mask_adds_epi16_rrkz_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovd %edi, %k1
; AVX512BW-NEXT:    vpaddsw %zmm1, %zmm0, %zmm0 {%k1} {z}
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_mask_adds_epi16_rrkz_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    vpaddsw %zmm1, %zmm0, %zmm0 {%k1} {z}
; AVX512F-32-NEXT:    retl
  %res = call <32 x i16> @llvm.x86.avx512.mask.padds.w.512(<32 x i16> %a, <32 x i16> %b, <32 x i16> zeroinitializer, i32 %mask)
  ret <32 x i16> %res
}

define <32 x i16> @test_mask_adds_epi16_rm_512(<32 x i16> %a, <32 x i16>* %ptr_b) {
; AVX512BW-LABEL: test_mask_adds_epi16_rm_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    vpaddsw (%rdi), %zmm0, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_mask_adds_epi16_rm_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX512F-32-NEXT:    vpaddsw (%eax), %zmm0, %zmm0
; AVX512F-32-NEXT:    retl
  %b = load <32 x i16>, <32 x i16>* %ptr_b
  %res = call <32 x i16> @llvm.x86.avx512.mask.padds.w.512(<32 x i16> %a, <32 x i16> %b, <32 x i16> zeroinitializer, i32 -1)
  ret <32 x i16> %res
}

define <32 x i16> @test_mask_adds_epi16_rmk_512(<32 x i16> %a, <32 x i16>* %ptr_b, <32 x i16> %passThru, i32 %mask) {
; AVX512BW-LABEL: test_mask_adds_epi16_rmk_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovd %esi, %k1
; AVX512BW-NEXT:    vpaddsw (%rdi), %zmm0, %zmm1 {%k1}
; AVX512BW-NEXT:    vmovaps %zmm1, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_mask_adds_epi16_rmk_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    vpaddsw (%eax), %zmm0, %zmm1 {%k1}
; AVX512F-32-NEXT:    vmovaps %zmm1, %zmm0
; AVX512F-32-NEXT:    retl
  %b = load <32 x i16>, <32 x i16>* %ptr_b
  %res = call <32 x i16> @llvm.x86.avx512.mask.padds.w.512(<32 x i16> %a, <32 x i16> %b, <32 x i16> %passThru, i32 %mask)
  ret <32 x i16> %res
}

define <32 x i16> @test_mask_adds_epi16_rmkz_512(<32 x i16> %a, <32 x i16>* %ptr_b, i32 %mask) {
; AVX512BW-LABEL: test_mask_adds_epi16_rmkz_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovd %esi, %k1
; AVX512BW-NEXT:    vpaddsw (%rdi), %zmm0, %zmm0 {%k1} {z}
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_mask_adds_epi16_rmkz_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    vpaddsw (%eax), %zmm0, %zmm0 {%k1} {z}
; AVX512F-32-NEXT:    retl
  %b = load <32 x i16>, <32 x i16>* %ptr_b
  %res = call <32 x i16> @llvm.x86.avx512.mask.padds.w.512(<32 x i16> %a, <32 x i16> %b, <32 x i16> zeroinitializer, i32 %mask)
  ret <32 x i16> %res
}

declare <32 x i16> @llvm.x86.avx512.mask.padds.w.512(<32 x i16>, <32 x i16>, <32 x i16>, i32)

define <32 x i16> @test_mask_subs_epi16_rr_512(<32 x i16> %a, <32 x i16> %b) {
; AVX512BW-LABEL: test_mask_subs_epi16_rr_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    vpsubsw %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_mask_subs_epi16_rr_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    vpsubsw %zmm1, %zmm0, %zmm0
; AVX512F-32-NEXT:    retl
  %res = call <32 x i16> @llvm.x86.avx512.mask.psubs.w.512(<32 x i16> %a, <32 x i16> %b, <32 x i16> zeroinitializer, i32 -1)
  ret <32 x i16> %res
}

define <32 x i16> @test_mask_subs_epi16_rrk_512(<32 x i16> %a, <32 x i16> %b, <32 x i16> %passThru, i32 %mask) {
; AVX512BW-LABEL: test_mask_subs_epi16_rrk_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovd %edi, %k1
; AVX512BW-NEXT:    vpsubsw %zmm1, %zmm0, %zmm2 {%k1}
; AVX512BW-NEXT:    vmovaps %zmm2, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_mask_subs_epi16_rrk_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    vpsubsw %zmm1, %zmm0, %zmm2 {%k1}
; AVX512F-32-NEXT:    vmovaps %zmm2, %zmm0
; AVX512F-32-NEXT:    retl
  %res = call <32 x i16> @llvm.x86.avx512.mask.psubs.w.512(<32 x i16> %a, <32 x i16> %b, <32 x i16> %passThru, i32 %mask)
  ret <32 x i16> %res
}

define <32 x i16> @test_mask_subs_epi16_rrkz_512(<32 x i16> %a, <32 x i16> %b, i32 %mask) {
; AVX512BW-LABEL: test_mask_subs_epi16_rrkz_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovd %edi, %k1
; AVX512BW-NEXT:    vpsubsw %zmm1, %zmm0, %zmm0 {%k1} {z}
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_mask_subs_epi16_rrkz_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    vpsubsw %zmm1, %zmm0, %zmm0 {%k1} {z}
; AVX512F-32-NEXT:    retl
  %res = call <32 x i16> @llvm.x86.avx512.mask.psubs.w.512(<32 x i16> %a, <32 x i16> %b, <32 x i16> zeroinitializer, i32 %mask)
  ret <32 x i16> %res
}

define <32 x i16> @test_mask_subs_epi16_rm_512(<32 x i16> %a, <32 x i16>* %ptr_b) {
; AVX512BW-LABEL: test_mask_subs_epi16_rm_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    vpsubsw (%rdi), %zmm0, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_mask_subs_epi16_rm_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX512F-32-NEXT:    vpsubsw (%eax), %zmm0, %zmm0
; AVX512F-32-NEXT:    retl
  %b = load <32 x i16>, <32 x i16>* %ptr_b
  %res = call <32 x i16> @llvm.x86.avx512.mask.psubs.w.512(<32 x i16> %a, <32 x i16> %b, <32 x i16> zeroinitializer, i32 -1)
  ret <32 x i16> %res
}

define <32 x i16> @test_mask_subs_epi16_rmk_512(<32 x i16> %a, <32 x i16>* %ptr_b, <32 x i16> %passThru, i32 %mask) {
; AVX512BW-LABEL: test_mask_subs_epi16_rmk_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovd %esi, %k1
; AVX512BW-NEXT:    vpsubsw (%rdi), %zmm0, %zmm1 {%k1}
; AVX512BW-NEXT:    vmovaps %zmm1, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_mask_subs_epi16_rmk_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    vpsubsw (%eax), %zmm0, %zmm1 {%k1}
; AVX512F-32-NEXT:    vmovaps %zmm1, %zmm0
; AVX512F-32-NEXT:    retl
  %b = load <32 x i16>, <32 x i16>* %ptr_b
  %res = call <32 x i16> @llvm.x86.avx512.mask.psubs.w.512(<32 x i16> %a, <32 x i16> %b, <32 x i16> %passThru, i32 %mask)
  ret <32 x i16> %res
}

define <32 x i16> @test_mask_subs_epi16_rmkz_512(<32 x i16> %a, <32 x i16>* %ptr_b, i32 %mask) {
; AVX512BW-LABEL: test_mask_subs_epi16_rmkz_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovd %esi, %k1
; AVX512BW-NEXT:    vpsubsw (%rdi), %zmm0, %zmm0 {%k1} {z}
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_mask_subs_epi16_rmkz_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    vpsubsw (%eax), %zmm0, %zmm0 {%k1} {z}
; AVX512F-32-NEXT:    retl
  %b = load <32 x i16>, <32 x i16>* %ptr_b
  %res = call <32 x i16> @llvm.x86.avx512.mask.psubs.w.512(<32 x i16> %a, <32 x i16> %b, <32 x i16> zeroinitializer, i32 %mask)
  ret <32 x i16> %res
}

declare <32 x i16> @llvm.x86.avx512.mask.psubs.w.512(<32 x i16>, <32 x i16>, <32 x i16>, i32)

define <32 x i16> @test_mask_adds_epu16_rr_512(<32 x i16> %a, <32 x i16> %b) {
; AVX512BW-LABEL: test_mask_adds_epu16_rr_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    vpaddusw %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_mask_adds_epu16_rr_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    vpaddusw %zmm1, %zmm0, %zmm0
; AVX512F-32-NEXT:    retl
  %res = call <32 x i16> @llvm.x86.avx512.mask.paddus.w.512(<32 x i16> %a, <32 x i16> %b, <32 x i16> zeroinitializer, i32 -1)
  ret <32 x i16> %res
}

define <32 x i16> @test_mask_adds_epu16_rrk_512(<32 x i16> %a, <32 x i16> %b, <32 x i16> %passThru, i32 %mask) {
; AVX512BW-LABEL: test_mask_adds_epu16_rrk_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovd %edi, %k1
; AVX512BW-NEXT:    vpaddusw %zmm1, %zmm0, %zmm2 {%k1}
; AVX512BW-NEXT:    vmovaps %zmm2, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_mask_adds_epu16_rrk_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    vpaddusw %zmm1, %zmm0, %zmm2 {%k1}
; AVX512F-32-NEXT:    vmovaps %zmm2, %zmm0
; AVX512F-32-NEXT:    retl
  %res = call <32 x i16> @llvm.x86.avx512.mask.paddus.w.512(<32 x i16> %a, <32 x i16> %b, <32 x i16> %passThru, i32 %mask)
  ret <32 x i16> %res
}

define <32 x i16> @test_mask_adds_epu16_rrkz_512(<32 x i16> %a, <32 x i16> %b, i32 %mask) {
; AVX512BW-LABEL: test_mask_adds_epu16_rrkz_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovd %edi, %k1
; AVX512BW-NEXT:    vpaddusw %zmm1, %zmm0, %zmm0 {%k1} {z}
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_mask_adds_epu16_rrkz_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    vpaddusw %zmm1, %zmm0, %zmm0 {%k1} {z}
; AVX512F-32-NEXT:    retl
  %res = call <32 x i16> @llvm.x86.avx512.mask.paddus.w.512(<32 x i16> %a, <32 x i16> %b, <32 x i16> zeroinitializer, i32 %mask)
  ret <32 x i16> %res
}

define <32 x i16> @test_mask_adds_epu16_rm_512(<32 x i16> %a, <32 x i16>* %ptr_b) {
; AVX512BW-LABEL: test_mask_adds_epu16_rm_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    vpaddusw (%rdi), %zmm0, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_mask_adds_epu16_rm_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX512F-32-NEXT:    vpaddusw (%eax), %zmm0, %zmm0
; AVX512F-32-NEXT:    retl
  %b = load <32 x i16>, <32 x i16>* %ptr_b
  %res = call <32 x i16> @llvm.x86.avx512.mask.paddus.w.512(<32 x i16> %a, <32 x i16> %b, <32 x i16> zeroinitializer, i32 -1)
  ret <32 x i16> %res
}

define <32 x i16> @test_mask_adds_epu16_rmk_512(<32 x i16> %a, <32 x i16>* %ptr_b, <32 x i16> %passThru, i32 %mask) {
; AVX512BW-LABEL: test_mask_adds_epu16_rmk_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovd %esi, %k1
; AVX512BW-NEXT:    vpaddusw (%rdi), %zmm0, %zmm1 {%k1}
; AVX512BW-NEXT:    vmovaps %zmm1, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_mask_adds_epu16_rmk_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    vpaddusw (%eax), %zmm0, %zmm1 {%k1}
; AVX512F-32-NEXT:    vmovaps %zmm1, %zmm0
; AVX512F-32-NEXT:    retl
  %b = load <32 x i16>, <32 x i16>* %ptr_b
  %res = call <32 x i16> @llvm.x86.avx512.mask.paddus.w.512(<32 x i16> %a, <32 x i16> %b, <32 x i16> %passThru, i32 %mask)
  ret <32 x i16> %res
}

define <32 x i16> @test_mask_adds_epu16_rmkz_512(<32 x i16> %a, <32 x i16>* %ptr_b, i32 %mask) {
; AVX512BW-LABEL: test_mask_adds_epu16_rmkz_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovd %esi, %k1
; AVX512BW-NEXT:    vpaddusw (%rdi), %zmm0, %zmm0 {%k1} {z}
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_mask_adds_epu16_rmkz_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    vpaddusw (%eax), %zmm0, %zmm0 {%k1} {z}
; AVX512F-32-NEXT:    retl
  %b = load <32 x i16>, <32 x i16>* %ptr_b
  %res = call <32 x i16> @llvm.x86.avx512.mask.paddus.w.512(<32 x i16> %a, <32 x i16> %b, <32 x i16> zeroinitializer, i32 %mask)
  ret <32 x i16> %res
}

declare <32 x i16> @llvm.x86.avx512.mask.paddus.w.512(<32 x i16>, <32 x i16>, <32 x i16>, i32)

define <32 x i16> @test_mask_subs_epu16_rr_512(<32 x i16> %a, <32 x i16> %b) {
; AVX512BW-LABEL: test_mask_subs_epu16_rr_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    vpsubusw %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_mask_subs_epu16_rr_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    vpsubusw %zmm1, %zmm0, %zmm0
; AVX512F-32-NEXT:    retl
  %res = call <32 x i16> @llvm.x86.avx512.mask.psubus.w.512(<32 x i16> %a, <32 x i16> %b, <32 x i16> zeroinitializer, i32 -1)
  ret <32 x i16> %res
}

define <32 x i16> @test_mask_subs_epu16_rrk_512(<32 x i16> %a, <32 x i16> %b, <32 x i16> %passThru, i32 %mask) {
; AVX512BW-LABEL: test_mask_subs_epu16_rrk_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovd %edi, %k1
; AVX512BW-NEXT:    vpsubusw %zmm1, %zmm0, %zmm2 {%k1}
; AVX512BW-NEXT:    vmovaps %zmm2, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_mask_subs_epu16_rrk_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    vpsubusw %zmm1, %zmm0, %zmm2 {%k1}
; AVX512F-32-NEXT:    vmovaps %zmm2, %zmm0
; AVX512F-32-NEXT:    retl
  %res = call <32 x i16> @llvm.x86.avx512.mask.psubus.w.512(<32 x i16> %a, <32 x i16> %b, <32 x i16> %passThru, i32 %mask)
  ret <32 x i16> %res
}

define <32 x i16> @test_mask_subs_epu16_rrkz_512(<32 x i16> %a, <32 x i16> %b, i32 %mask) {
; AVX512BW-LABEL: test_mask_subs_epu16_rrkz_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovd %edi, %k1
; AVX512BW-NEXT:    vpsubusw %zmm1, %zmm0, %zmm0 {%k1} {z}
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_mask_subs_epu16_rrkz_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    vpsubusw %zmm1, %zmm0, %zmm0 {%k1} {z}
; AVX512F-32-NEXT:    retl
  %res = call <32 x i16> @llvm.x86.avx512.mask.psubus.w.512(<32 x i16> %a, <32 x i16> %b, <32 x i16> zeroinitializer, i32 %mask)
  ret <32 x i16> %res
}

define <32 x i16> @test_mask_subs_epu16_rm_512(<32 x i16> %a, <32 x i16>* %ptr_b) {
; AVX512BW-LABEL: test_mask_subs_epu16_rm_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    vpsubusw (%rdi), %zmm0, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_mask_subs_epu16_rm_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX512F-32-NEXT:    vpsubusw (%eax), %zmm0, %zmm0
; AVX512F-32-NEXT:    retl
  %b = load <32 x i16>, <32 x i16>* %ptr_b
  %res = call <32 x i16> @llvm.x86.avx512.mask.psubus.w.512(<32 x i16> %a, <32 x i16> %b, <32 x i16> zeroinitializer, i32 -1)
  ret <32 x i16> %res
}

define <32 x i16> @test_mask_subs_epu16_rmk_512(<32 x i16> %a, <32 x i16>* %ptr_b, <32 x i16> %passThru, i32 %mask) {
; AVX512BW-LABEL: test_mask_subs_epu16_rmk_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovd %esi, %k1
; AVX512BW-NEXT:    vpsubusw (%rdi), %zmm0, %zmm1 {%k1}
; AVX512BW-NEXT:    vmovaps %zmm1, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_mask_subs_epu16_rmk_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    vpsubusw (%eax), %zmm0, %zmm1 {%k1}
; AVX512F-32-NEXT:    vmovaps %zmm1, %zmm0
; AVX512F-32-NEXT:    retl
  %b = load <32 x i16>, <32 x i16>* %ptr_b
  %res = call <32 x i16> @llvm.x86.avx512.mask.psubus.w.512(<32 x i16> %a, <32 x i16> %b, <32 x i16> %passThru, i32 %mask)
  ret <32 x i16> %res
}

define <32 x i16> @test_mask_subs_epu16_rmkz_512(<32 x i16> %a, <32 x i16>* %ptr_b, i32 %mask) {
; AVX512BW-LABEL: test_mask_subs_epu16_rmkz_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovd %esi, %k1
; AVX512BW-NEXT:    vpsubusw (%rdi), %zmm0, %zmm0 {%k1} {z}
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_mask_subs_epu16_rmkz_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    vpsubusw (%eax), %zmm0, %zmm0 {%k1} {z}
; AVX512F-32-NEXT:    retl
  %b = load <32 x i16>, <32 x i16>* %ptr_b
  %res = call <32 x i16> @llvm.x86.avx512.mask.psubus.w.512(<32 x i16> %a, <32 x i16> %b, <32 x i16> zeroinitializer, i32 %mask)
  ret <32 x i16> %res
}

declare <32 x i16> @llvm.x86.avx512.mask.psubus.w.512(<32 x i16>, <32 x i16>, <32 x i16>, i32)

declare <64 x i8> @llvm.x86.avx512.mask.pmaxs.b.512(<64 x i8>, <64 x i8>, <64 x i8>, i64)

define <64 x i8>@test_int_x86_avx512_mask_pmaxs_b_512(<64 x i8> %x0, <64 x i8> %x1, <64 x i8> %x2, i64 %x3) {
; AVX512BW-LABEL: test_int_x86_avx512_mask_pmaxs_b_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovq %rdi, %k1
; AVX512BW-NEXT:    vpmaxsb %zmm1, %zmm0, %zmm2 {%k1}
; AVX512BW-NEXT:    vpmaxsb %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vpaddb %zmm0, %zmm2, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_int_x86_avx512_mask_pmaxs_b_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k0
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    kunpckdq %k0, %k1, %k1
; AVX512F-32-NEXT:    vpmaxsb %zmm1, %zmm0, %zmm2 {%k1}
; AVX512F-32-NEXT:    vpmaxsb %zmm1, %zmm0, %zmm0
; AVX512F-32-NEXT:    vpaddb %zmm0, %zmm2, %zmm0
; AVX512F-32-NEXT:    retl
  %res = call <64 x i8> @llvm.x86.avx512.mask.pmaxs.b.512(<64 x i8> %x0, <64 x i8> %x1, <64 x i8> %x2, i64 %x3)
  %res1 = call <64 x i8> @llvm.x86.avx512.mask.pmaxs.b.512(<64 x i8> %x0, <64 x i8> %x1, <64 x i8> %x2, i64 -1)
  %res2 = add <64 x i8> %res, %res1
  ret <64 x i8> %res2
}

declare <32 x i16> @llvm.x86.avx512.mask.pmaxs.w.512(<32 x i16>, <32 x i16>, <32 x i16>, i32)

define <32 x i16>@test_int_x86_avx512_mask_pmaxs_w_512(<32 x i16> %x0, <32 x i16> %x1, <32 x i16> %x2, i32 %x3) {
; AVX512BW-LABEL: test_int_x86_avx512_mask_pmaxs_w_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovd %edi, %k1
; AVX512BW-NEXT:    vpmaxsw %zmm1, %zmm0, %zmm2 {%k1}
; AVX512BW-NEXT:    vpmaxsw %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vpaddw %zmm0, %zmm2, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_int_x86_avx512_mask_pmaxs_w_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    vpmaxsw %zmm1, %zmm0, %zmm2 {%k1}
; AVX512F-32-NEXT:    vpmaxsw %zmm1, %zmm0, %zmm0
; AVX512F-32-NEXT:    vpaddw %zmm0, %zmm2, %zmm0
; AVX512F-32-NEXT:    retl
  %res = call <32 x i16> @llvm.x86.avx512.mask.pmaxs.w.512(<32 x i16> %x0, <32 x i16> %x1, <32 x i16> %x2, i32 %x3)
  %res1 = call <32 x i16> @llvm.x86.avx512.mask.pmaxs.w.512(<32 x i16> %x0, <32 x i16> %x1, <32 x i16> %x2, i32 -1)
  %res2 = add <32 x i16> %res, %res1
  ret <32 x i16> %res2
}

declare <64 x i8> @llvm.x86.avx512.mask.pmaxu.b.512(<64 x i8>, <64 x i8>, <64 x i8>, i64)

define <64 x i8>@test_int_x86_avx512_mask_pmaxu_b_512(<64 x i8> %x0, <64 x i8> %x1, <64 x i8> %x2, i64 %x3) {
; AVX512BW-LABEL: test_int_x86_avx512_mask_pmaxu_b_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovq %rdi, %k1
; AVX512BW-NEXT:    vpmaxub %zmm1, %zmm0, %zmm2 {%k1}
; AVX512BW-NEXT:    vpmaxub %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vpaddb %zmm0, %zmm2, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_int_x86_avx512_mask_pmaxu_b_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k0
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    kunpckdq %k0, %k1, %k1
; AVX512F-32-NEXT:    vpmaxub %zmm1, %zmm0, %zmm2 {%k1}
; AVX512F-32-NEXT:    vpmaxub %zmm1, %zmm0, %zmm0
; AVX512F-32-NEXT:    vpaddb %zmm0, %zmm2, %zmm0
; AVX512F-32-NEXT:    retl
  %res = call <64 x i8> @llvm.x86.avx512.mask.pmaxu.b.512(<64 x i8> %x0, <64 x i8> %x1, <64 x i8> %x2, i64 %x3)
  %res1 = call <64 x i8> @llvm.x86.avx512.mask.pmaxu.b.512(<64 x i8> %x0, <64 x i8> %x1, <64 x i8> %x2, i64 -1)
  %res2 = add <64 x i8> %res, %res1
  ret <64 x i8> %res2
}

declare <32 x i16> @llvm.x86.avx512.mask.pmaxu.w.512(<32 x i16>, <32 x i16>, <32 x i16>, i32)

define <32 x i16>@test_int_x86_avx512_mask_pmaxu_w_512(<32 x i16> %x0, <32 x i16> %x1, <32 x i16> %x2, i32 %x3) {
; AVX512BW-LABEL: test_int_x86_avx512_mask_pmaxu_w_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovd %edi, %k1
; AVX512BW-NEXT:    vpmaxuw %zmm1, %zmm0, %zmm2 {%k1}
; AVX512BW-NEXT:    vpmaxuw %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vpaddw %zmm0, %zmm2, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_int_x86_avx512_mask_pmaxu_w_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    vpmaxuw %zmm1, %zmm0, %zmm2 {%k1}
; AVX512F-32-NEXT:    vpmaxuw %zmm1, %zmm0, %zmm0
; AVX512F-32-NEXT:    vpaddw %zmm0, %zmm2, %zmm0
; AVX512F-32-NEXT:    retl
  %res = call <32 x i16> @llvm.x86.avx512.mask.pmaxu.w.512(<32 x i16> %x0, <32 x i16> %x1, <32 x i16> %x2, i32 %x3)
  %res1 = call <32 x i16> @llvm.x86.avx512.mask.pmaxu.w.512(<32 x i16> %x0, <32 x i16> %x1, <32 x i16> %x2, i32 -1)
  %res2 = add <32 x i16> %res, %res1
  ret <32 x i16> %res2
}

declare <64 x i8> @llvm.x86.avx512.mask.pmins.b.512(<64 x i8>, <64 x i8>, <64 x i8>, i64)

define <64 x i8>@test_int_x86_avx512_mask_pmins_b_512(<64 x i8> %x0, <64 x i8> %x1, <64 x i8> %x2, i64 %x3) {
; AVX512BW-LABEL: test_int_x86_avx512_mask_pmins_b_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovq %rdi, %k1
; AVX512BW-NEXT:    vpminsb %zmm1, %zmm0, %zmm2 {%k1}
; AVX512BW-NEXT:    vpminsb %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vpaddb %zmm0, %zmm2, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_int_x86_avx512_mask_pmins_b_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k0
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    kunpckdq %k0, %k1, %k1
; AVX512F-32-NEXT:    vpminsb %zmm1, %zmm0, %zmm2 {%k1}
; AVX512F-32-NEXT:    vpminsb %zmm1, %zmm0, %zmm0
; AVX512F-32-NEXT:    vpaddb %zmm0, %zmm2, %zmm0
; AVX512F-32-NEXT:    retl
  %res = call <64 x i8> @llvm.x86.avx512.mask.pmins.b.512(<64 x i8> %x0, <64 x i8> %x1, <64 x i8> %x2, i64 %x3)
  %res1 = call <64 x i8> @llvm.x86.avx512.mask.pmins.b.512(<64 x i8> %x0, <64 x i8> %x1, <64 x i8> %x2, i64 -1)
  %res2 = add <64 x i8> %res, %res1
  ret <64 x i8> %res2
}

declare <32 x i16> @llvm.x86.avx512.mask.pmins.w.512(<32 x i16>, <32 x i16>, <32 x i16>, i32)

define <32 x i16>@test_int_x86_avx512_mask_pmins_w_512(<32 x i16> %x0, <32 x i16> %x1, <32 x i16> %x2, i32 %x3) {
; AVX512BW-LABEL: test_int_x86_avx512_mask_pmins_w_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovd %edi, %k1
; AVX512BW-NEXT:    vpminsw %zmm1, %zmm0, %zmm2 {%k1}
; AVX512BW-NEXT:    vpminsw %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vpaddw %zmm0, %zmm2, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_int_x86_avx512_mask_pmins_w_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    vpminsw %zmm1, %zmm0, %zmm2 {%k1}
; AVX512F-32-NEXT:    vpminsw %zmm1, %zmm0, %zmm0
; AVX512F-32-NEXT:    vpaddw %zmm0, %zmm2, %zmm0
; AVX512F-32-NEXT:    retl
  %res = call <32 x i16> @llvm.x86.avx512.mask.pmins.w.512(<32 x i16> %x0, <32 x i16> %x1, <32 x i16> %x2, i32 %x3)
  %res1 = call <32 x i16> @llvm.x86.avx512.mask.pmins.w.512(<32 x i16> %x0, <32 x i16> %x1, <32 x i16> %x2, i32 -1)
  %res2 = add <32 x i16> %res, %res1
  ret <32 x i16> %res2
}

declare <64 x i8> @llvm.x86.avx512.mask.pminu.b.512(<64 x i8>, <64 x i8>, <64 x i8>, i64)

define <64 x i8>@test_int_x86_avx512_mask_pminu_b_512(<64 x i8> %x0, <64 x i8> %x1, <64 x i8> %x2, i64 %x3) {
; AVX512BW-LABEL: test_int_x86_avx512_mask_pminu_b_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovq %rdi, %k1
; AVX512BW-NEXT:    vpminub %zmm1, %zmm0, %zmm2 {%k1}
; AVX512BW-NEXT:    vpminub %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vpaddb %zmm0, %zmm2, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_int_x86_avx512_mask_pminu_b_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k0
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    kunpckdq %k0, %k1, %k1
; AVX512F-32-NEXT:    vpminub %zmm1, %zmm0, %zmm2 {%k1}
; AVX512F-32-NEXT:    vpminub %zmm1, %zmm0, %zmm0
; AVX512F-32-NEXT:    vpaddb %zmm0, %zmm2, %zmm0
; AVX512F-32-NEXT:    retl
  %res = call <64 x i8> @llvm.x86.avx512.mask.pminu.b.512(<64 x i8> %x0, <64 x i8> %x1, <64 x i8> %x2, i64 %x3)
  %res1 = call <64 x i8> @llvm.x86.avx512.mask.pminu.b.512(<64 x i8> %x0, <64 x i8> %x1, <64 x i8> %x2, i64 -1)
  %res2 = add <64 x i8> %res, %res1
  ret <64 x i8> %res2
}

declare <32 x i16> @llvm.x86.avx512.mask.pminu.w.512(<32 x i16>, <32 x i16>, <32 x i16>, i32)

define <32 x i16>@test_int_x86_avx512_mask_pminu_w_512(<32 x i16> %x0, <32 x i16> %x1, <32 x i16> %x2, i32 %x3) {
; AVX512BW-LABEL: test_int_x86_avx512_mask_pminu_w_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovd %edi, %k1
; AVX512BW-NEXT:    vpminuw %zmm1, %zmm0, %zmm2 {%k1}
; AVX512BW-NEXT:    vpminuw %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vpaddw %zmm0, %zmm2, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_int_x86_avx512_mask_pminu_w_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    vpminuw %zmm1, %zmm0, %zmm2 {%k1}
; AVX512F-32-NEXT:    vpminuw %zmm1, %zmm0, %zmm0
; AVX512F-32-NEXT:    vpaddw %zmm0, %zmm2, %zmm0
; AVX512F-32-NEXT:    retl
  %res = call <32 x i16> @llvm.x86.avx512.mask.pminu.w.512(<32 x i16> %x0, <32 x i16> %x1, <32 x i16> %x2, i32 %x3)
  %res1 = call <32 x i16> @llvm.x86.avx512.mask.pminu.w.512(<32 x i16> %x0, <32 x i16> %x1, <32 x i16> %x2, i32 -1)
  %res2 = add <32 x i16> %res, %res1
  ret <32 x i16> %res2
}

declare <32 x i16> @llvm.x86.avx512.mask.vpermt2var.hi.512(<32 x i16>, <32 x i16>, <32 x i16>, i32)

define <32 x i16>@test_int_x86_avx512_mask_vpermt2var_hi_512(<32 x i16> %x0, <32 x i16> %x1, <32 x i16> %x2, i32 %x3) {
; AVX512BW-LABEL: test_int_x86_avx512_mask_vpermt2var_hi_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovd %edi, %k1
; AVX512BW-NEXT:    vmovaps %zmm1, %zmm3
; AVX512BW-NEXT:    vpermt2w %zmm2, %zmm0, %zmm3 {%k1}
; AVX512BW-NEXT:    vpermt2w %zmm2, %zmm0, %zmm1
; AVX512BW-NEXT:    vpaddw %zmm1, %zmm3, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_int_x86_avx512_mask_vpermt2var_hi_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    vmovaps %zmm1, %zmm3
; AVX512F-32-NEXT:    vpermt2w %zmm2, %zmm0, %zmm3 {%k1}
; AVX512F-32-NEXT:    vpermt2w %zmm2, %zmm0, %zmm1
; AVX512F-32-NEXT:    vpaddw %zmm1, %zmm3, %zmm0
; AVX512F-32-NEXT:    retl
  %res = call <32 x i16> @llvm.x86.avx512.mask.vpermt2var.hi.512(<32 x i16> %x0, <32 x i16> %x1, <32 x i16> %x2, i32 %x3)
  %res1 = call <32 x i16> @llvm.x86.avx512.mask.vpermt2var.hi.512(<32 x i16> %x0, <32 x i16> %x1, <32 x i16> %x2, i32 -1)
  %res2 = add <32 x i16> %res, %res1
  ret <32 x i16> %res2
}

declare <32 x i16> @llvm.x86.avx512.maskz.vpermt2var.hi.512(<32 x i16>, <32 x i16>, <32 x i16>, i32)

define <32 x i16>@test_int_x86_avx512_maskz_vpermt2var_hi_512(<32 x i16> %x0, <32 x i16> %x1, <32 x i16> %x2, i32 %x3) {
; AVX512BW-LABEL: test_int_x86_avx512_maskz_vpermt2var_hi_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovd %edi, %k1
; AVX512BW-NEXT:    vmovaps %zmm1, %zmm3
; AVX512BW-NEXT:    vpermt2w %zmm2, %zmm0, %zmm3 {%k1} {z}
; AVX512BW-NEXT:    vpermt2w %zmm2, %zmm0, %zmm1
; AVX512BW-NEXT:    vpaddw %zmm1, %zmm3, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_int_x86_avx512_maskz_vpermt2var_hi_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    vmovaps %zmm1, %zmm3
; AVX512F-32-NEXT:    vpermt2w %zmm2, %zmm0, %zmm3 {%k1} {z}
; AVX512F-32-NEXT:    vpermt2w %zmm2, %zmm0, %zmm1
; AVX512F-32-NEXT:    vpaddw %zmm1, %zmm3, %zmm0
; AVX512F-32-NEXT:    retl
  %res = call <32 x i16> @llvm.x86.avx512.maskz.vpermt2var.hi.512(<32 x i16> %x0, <32 x i16> %x1, <32 x i16> %x2, i32 %x3)
  %res1 = call <32 x i16> @llvm.x86.avx512.maskz.vpermt2var.hi.512(<32 x i16> %x0, <32 x i16> %x1, <32 x i16> %x2, i32 -1)
  %res2 = add <32 x i16> %res, %res1
  ret <32 x i16> %res2
}

declare <32 x i16> @llvm.x86.avx512.mask.vpermi2var.hi.512(<32 x i16>, <32 x i16>, <32 x i16>, i32)

define <32 x i16>@test_int_x86_avx512_mask_vpermi2var_hi_512(<32 x i16> %x0, <32 x i16> %x1, <32 x i16> %x2, i32 %x3) {
; AVX512BW-LABEL: test_int_x86_avx512_mask_vpermi2var_hi_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovd %edi, %k1
; AVX512BW-NEXT:    vmovaps %zmm1, %zmm3
; AVX512BW-NEXT:    vpermi2w %zmm2, %zmm0, %zmm3 {%k1}
; AVX512BW-NEXT:    vpermi2w %zmm2, %zmm0, %zmm1
; AVX512BW-NEXT:    vpaddw %zmm1, %zmm3, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_int_x86_avx512_mask_vpermi2var_hi_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    vmovaps %zmm1, %zmm3
; AVX512F-32-NEXT:    vpermi2w %zmm2, %zmm0, %zmm3 {%k1}
; AVX512F-32-NEXT:    vpermi2w %zmm2, %zmm0, %zmm1
; AVX512F-32-NEXT:    vpaddw %zmm1, %zmm3, %zmm0
; AVX512F-32-NEXT:    retl
  %res = call <32 x i16> @llvm.x86.avx512.mask.vpermi2var.hi.512(<32 x i16> %x0, <32 x i16> %x1, <32 x i16> %x2, i32 %x3)
  %res1 = call <32 x i16> @llvm.x86.avx512.mask.vpermi2var.hi.512(<32 x i16> %x0, <32 x i16> %x1, <32 x i16> %x2, i32 -1)
  %res2 = add <32 x i16> %res, %res1
  ret <32 x i16> %res2
}

declare <64 x i8> @llvm.x86.avx512.mask.pavg.b.512(<64 x i8>, <64 x i8>, <64 x i8>, i64)

define <64 x i8>@test_int_x86_avx512_mask_pavg_b_512(<64 x i8> %x0, <64 x i8> %x1, <64 x i8> %x2, i64 %x3) {
; AVX512BW-LABEL: test_int_x86_avx512_mask_pavg_b_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovq %rdi, %k1
; AVX512BW-NEXT:    vpavgb %zmm1, %zmm0, %zmm2 {%k1}
; AVX512BW-NEXT:    vpavgb %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vpaddb %zmm0, %zmm2, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_int_x86_avx512_mask_pavg_b_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k0
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    kunpckdq %k0, %k1, %k1
; AVX512F-32-NEXT:    vpavgb %zmm1, %zmm0, %zmm2 {%k1}
; AVX512F-32-NEXT:    vpavgb %zmm1, %zmm0, %zmm0
; AVX512F-32-NEXT:    vpaddb %zmm0, %zmm2, %zmm0
; AVX512F-32-NEXT:    retl
  %res = call <64 x i8> @llvm.x86.avx512.mask.pavg.b.512(<64 x i8> %x0, <64 x i8> %x1, <64 x i8> %x2, i64 %x3)
  %res1 = call <64 x i8> @llvm.x86.avx512.mask.pavg.b.512(<64 x i8> %x0, <64 x i8> %x1, <64 x i8> %x2, i64 -1)
  %res2 = add <64 x i8> %res, %res1
  ret <64 x i8> %res2
}

declare <32 x i16> @llvm.x86.avx512.mask.pavg.w.512(<32 x i16>, <32 x i16>, <32 x i16>, i32)

define <32 x i16>@test_int_x86_avx512_mask_pavg_w_512(<32 x i16> %x0, <32 x i16> %x1, <32 x i16> %x2, i32 %x3) {
; AVX512BW-LABEL: test_int_x86_avx512_mask_pavg_w_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovd %edi, %k1
; AVX512BW-NEXT:    vpavgw %zmm1, %zmm0, %zmm2 {%k1}
; AVX512BW-NEXT:    vpavgw %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vpaddw %zmm0, %zmm2, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_int_x86_avx512_mask_pavg_w_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    vpavgw %zmm1, %zmm0, %zmm2 {%k1}
; AVX512F-32-NEXT:    vpavgw %zmm1, %zmm0, %zmm0
; AVX512F-32-NEXT:    vpaddw %zmm0, %zmm2, %zmm0
; AVX512F-32-NEXT:    retl
  %res = call <32 x i16> @llvm.x86.avx512.mask.pavg.w.512(<32 x i16> %x0, <32 x i16> %x1, <32 x i16> %x2, i32 %x3)
  %res1 = call <32 x i16> @llvm.x86.avx512.mask.pavg.w.512(<32 x i16> %x0, <32 x i16> %x1, <32 x i16> %x2, i32 -1)
  %res2 = add <32 x i16> %res, %res1
  ret <32 x i16> %res2
}

declare <64 x i8> @llvm.x86.avx512.mask.pshuf.b.512(<64 x i8>, <64 x i8>, <64 x i8>, i64)

define <64 x i8>@test_int_x86_avx512_mask_pshuf_b_512(<64 x i8> %x0, <64 x i8> %x1, <64 x i8> %x2, i64 %x3) {
; AVX512BW-LABEL: test_int_x86_avx512_mask_pshuf_b_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovq %rdi, %k1
; AVX512BW-NEXT:    vpshufb %zmm1, %zmm0, %zmm2 {%k1}
; AVX512BW-NEXT:    vpshufb %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vpaddb %zmm0, %zmm2, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_int_x86_avx512_mask_pshuf_b_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k0
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    kunpckdq %k0, %k1, %k1
; AVX512F-32-NEXT:    vpshufb %zmm1, %zmm0, %zmm2 {%k1}
; AVX512F-32-NEXT:    vpshufb %zmm1, %zmm0, %zmm0
; AVX512F-32-NEXT:    vpaddb %zmm0, %zmm2, %zmm0
; AVX512F-32-NEXT:    retl
  %res = call <64 x i8> @llvm.x86.avx512.mask.pshuf.b.512(<64 x i8> %x0, <64 x i8> %x1, <64 x i8> %x2, i64 %x3)
  %res1 = call <64 x i8> @llvm.x86.avx512.mask.pshuf.b.512(<64 x i8> %x0, <64 x i8> %x1, <64 x i8> %x2, i64 -1)
  %res2 = add <64 x i8> %res, %res1
  ret <64 x i8> %res2
}

declare <32 x i16> @llvm.x86.avx512.mask.pabs.w.512(<32 x i16>, <32 x i16>, i32)

define <32 x i16>@test_int_x86_avx512_mask_pabs_w_512(<32 x i16> %x0, <32 x i16> %x1, i32 %x2) {
; AVX512BW-LABEL: test_int_x86_avx512_mask_pabs_w_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovd %edi, %k1
; AVX512BW-NEXT:    vpabsw %zmm0, %zmm1 {%k1}
; AVX512BW-NEXT:    vpabsw %zmm0, %zmm0
; AVX512BW-NEXT:    vpaddw %zmm0, %zmm1, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_int_x86_avx512_mask_pabs_w_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    vpabsw %zmm0, %zmm1 {%k1}
; AVX512F-32-NEXT:    vpabsw %zmm0, %zmm0
; AVX512F-32-NEXT:    vpaddw %zmm0, %zmm1, %zmm0
; AVX512F-32-NEXT:    retl
  %res = call <32 x i16> @llvm.x86.avx512.mask.pabs.w.512(<32 x i16> %x0, <32 x i16> %x1, i32 %x2)
  %res1 = call <32 x i16> @llvm.x86.avx512.mask.pabs.w.512(<32 x i16> %x0, <32 x i16> %x1, i32 -1)
  %res2 = add <32 x i16> %res, %res1
  ret <32 x i16> %res2
}

declare <64 x i8> @llvm.x86.avx512.mask.pabs.b.512(<64 x i8>, <64 x i8>, i64)

define <64 x i8>@test_int_x86_avx512_mask_pabs_b_512(<64 x i8> %x0, <64 x i8> %x1, i64 %x2) {
; AVX512BW-LABEL: test_int_x86_avx512_mask_pabs_b_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovq %rdi, %k1
; AVX512BW-NEXT:    vpabsb %zmm0, %zmm1 {%k1}
; AVX512BW-NEXT:    vpabsb %zmm0, %zmm0
; AVX512BW-NEXT:    vpaddb %zmm0, %zmm1, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_int_x86_avx512_mask_pabs_b_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k0
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    kunpckdq %k0, %k1, %k1
; AVX512F-32-NEXT:    vpabsb %zmm0, %zmm1 {%k1}
; AVX512F-32-NEXT:    vpabsb %zmm0, %zmm0
; AVX512F-32-NEXT:    vpaddb %zmm0, %zmm1, %zmm0
; AVX512F-32-NEXT:    retl
  %res = call <64 x i8> @llvm.x86.avx512.mask.pabs.b.512(<64 x i8> %x0, <64 x i8> %x1, i64 %x2)
  %res1 = call <64 x i8> @llvm.x86.avx512.mask.pabs.b.512(<64 x i8> %x0, <64 x i8> %x1, i64 -1)
  %res2 = add <64 x i8> %res, %res1
  ret <64 x i8> %res2
}

declare <32 x i16> @llvm.x86.avx512.mask.pmulhu.w.512(<32 x i16>, <32 x i16>, <32 x i16>, i32)

define <32 x i16>@test_int_x86_avx512_mask_pmulhu_w_512(<32 x i16> %x0, <32 x i16> %x1, <32 x i16> %x2, i32 %x3) {
; AVX512BW-LABEL: test_int_x86_avx512_mask_pmulhu_w_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovd %edi, %k1
; AVX512BW-NEXT:    vpmulhuw %zmm1, %zmm0, %zmm2 {%k1}
; AVX512BW-NEXT:    vpmulhuw %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vpaddw %zmm0, %zmm2, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_int_x86_avx512_mask_pmulhu_w_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    vpmulhuw %zmm1, %zmm0, %zmm2 {%k1}
; AVX512F-32-NEXT:    vpmulhuw %zmm1, %zmm0, %zmm0
; AVX512F-32-NEXT:    vpaddw %zmm0, %zmm2, %zmm0
; AVX512F-32-NEXT:    retl
  %res = call <32 x i16> @llvm.x86.avx512.mask.pmulhu.w.512(<32 x i16> %x0, <32 x i16> %x1, <32 x i16> %x2, i32 %x3)
  %res1 = call <32 x i16> @llvm.x86.avx512.mask.pmulhu.w.512(<32 x i16> %x0, <32 x i16> %x1, <32 x i16> %x2, i32 -1)
  %res2 = add <32 x i16> %res, %res1
  ret <32 x i16> %res2
}

declare <32 x i16> @llvm.x86.avx512.mask.pmulh.w.512(<32 x i16>, <32 x i16>, <32 x i16>, i32)

define <32 x i16>@test_int_x86_avx512_mask_pmulh_w_512(<32 x i16> %x0, <32 x i16> %x1, <32 x i16> %x2, i32 %x3) {
; AVX512BW-LABEL: test_int_x86_avx512_mask_pmulh_w_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovd %edi, %k1
; AVX512BW-NEXT:    vpmulhw %zmm1, %zmm0, %zmm2 {%k1}
; AVX512BW-NEXT:    vpmulhw %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vpaddw %zmm0, %zmm2, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_int_x86_avx512_mask_pmulh_w_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    vpmulhw %zmm1, %zmm0, %zmm2 {%k1}
; AVX512F-32-NEXT:    vpmulhw %zmm1, %zmm0, %zmm0
; AVX512F-32-NEXT:    vpaddw %zmm0, %zmm2, %zmm0
; AVX512F-32-NEXT:    retl
  %res = call <32 x i16> @llvm.x86.avx512.mask.pmulh.w.512(<32 x i16> %x0, <32 x i16> %x1, <32 x i16> %x2, i32 %x3)
  %res1 = call <32 x i16> @llvm.x86.avx512.mask.pmulh.w.512(<32 x i16> %x0, <32 x i16> %x1, <32 x i16> %x2, i32 -1)
  %res2 = add <32 x i16> %res, %res1
  ret <32 x i16> %res2
}

declare <32 x i16> @llvm.x86.avx512.mask.pmul.hr.sw.512(<32 x i16>, <32 x i16>, <32 x i16>, i32)

define <32 x i16>@test_int_x86_avx512_mask_pmulhr_sw_512(<32 x i16> %x0, <32 x i16> %x1, <32 x i16> %x2, i32 %x3) {
; AVX512BW-LABEL: test_int_x86_avx512_mask_pmulhr_sw_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovd %edi, %k1
; AVX512BW-NEXT:    vpmulhrsw %zmm1, %zmm0, %zmm2 {%k1}
; AVX512BW-NEXT:    vpmulhrsw %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vpaddw %zmm0, %zmm2, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_int_x86_avx512_mask_pmulhr_sw_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    vpmulhrsw %zmm1, %zmm0, %zmm2 {%k1}
; AVX512F-32-NEXT:    vpmulhrsw %zmm1, %zmm0, %zmm0
; AVX512F-32-NEXT:    vpaddw %zmm0, %zmm2, %zmm0
; AVX512F-32-NEXT:    retl
  %res = call <32 x i16> @llvm.x86.avx512.mask.pmul.hr.sw.512(<32 x i16> %x0, <32 x i16> %x1, <32 x i16> %x2, i32 %x3)
  %res1 = call <32 x i16> @llvm.x86.avx512.mask.pmul.hr.sw.512(<32 x i16> %x0, <32 x i16> %x1, <32 x i16> %x2, i32 -1)
  %res2 = add <32 x i16> %res, %res1
  ret <32 x i16> %res2
}

declare <32 x i8> @llvm.x86.avx512.mask.pmov.wb.512(<32 x i16>, <32 x i8>, i32)

define <32 x i8>@test_int_x86_avx512_mask_pmov_wb_512(<32 x i16> %x0, <32 x i8> %x1, i32 %x2) {
; AVX512BW-LABEL: test_int_x86_avx512_mask_pmov_wb_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovd %edi, %k1
; AVX512BW-NEXT:    vpmovwb %zmm0, %ymm1 {%k1}
; AVX512BW-NEXT:    vpmovwb %zmm0, %ymm2 {%k1} {z}
; AVX512BW-NEXT:    vpmovwb %zmm0, %ymm0
; AVX512BW-NEXT:    vpaddb %ymm1, %ymm0, %ymm0
; AVX512BW-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_int_x86_avx512_mask_pmov_wb_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    vpmovwb %zmm0, %ymm1 {%k1}
; AVX512F-32-NEXT:    vpmovwb %zmm0, %ymm2 {%k1} {z}
; AVX512F-32-NEXT:    vpmovwb %zmm0, %ymm0
; AVX512F-32-NEXT:    vpaddb %ymm1, %ymm0, %ymm0
; AVX512F-32-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX512F-32-NEXT:    retl
    %res0 = call <32 x i8> @llvm.x86.avx512.mask.pmov.wb.512(<32 x i16> %x0, <32 x i8> %x1, i32 -1)
    %res1 = call <32 x i8> @llvm.x86.avx512.mask.pmov.wb.512(<32 x i16> %x0, <32 x i8> %x1, i32 %x2)
    %res2 = call <32 x i8> @llvm.x86.avx512.mask.pmov.wb.512(<32 x i16> %x0, <32 x i8> zeroinitializer, i32 %x2)
    %res3 = add <32 x i8> %res0, %res1
    %res4 = add <32 x i8> %res3, %res2
    ret <32 x i8> %res4
}

declare void @llvm.x86.avx512.mask.pmov.wb.mem.512(i8* %ptr, <32 x i16>, i32)

define void @test_int_x86_avx512_mask_pmov_wb_mem_512(i8* %ptr, <32 x i16> %x1, i32 %x2) {
; AVX512BW-LABEL: test_int_x86_avx512_mask_pmov_wb_mem_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovd %esi, %k1
; AVX512BW-NEXT:    vpmovwb %zmm0, (%rdi)
; AVX512BW-NEXT:    vpmovwb %zmm0, (%rdi) {%k1}
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_int_x86_avx512_mask_pmov_wb_mem_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX512F-32-NEXT:    vpmovwb %zmm0, (%eax)
; AVX512F-32-NEXT:    vpmovwb %zmm0, (%eax) {%k1}
; AVX512F-32-NEXT:    retl
    call void @llvm.x86.avx512.mask.pmov.wb.mem.512(i8* %ptr, <32 x i16> %x1, i32 -1)
    call void @llvm.x86.avx512.mask.pmov.wb.mem.512(i8* %ptr, <32 x i16> %x1, i32 %x2)
    ret void
}

declare <32 x i8> @llvm.x86.avx512.mask.pmovs.wb.512(<32 x i16>, <32 x i8>, i32)

define <32 x i8>@test_int_x86_avx512_mask_pmovs_wb_512(<32 x i16> %x0, <32 x i8> %x1, i32 %x2) {
; AVX512BW-LABEL: test_int_x86_avx512_mask_pmovs_wb_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovd %edi, %k1
; AVX512BW-NEXT:    vpmovswb %zmm0, %ymm1 {%k1}
; AVX512BW-NEXT:    vpmovswb %zmm0, %ymm2 {%k1} {z}
; AVX512BW-NEXT:    vpmovswb %zmm0, %ymm0
; AVX512BW-NEXT:    vpaddb %ymm1, %ymm0, %ymm0
; AVX512BW-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_int_x86_avx512_mask_pmovs_wb_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    vpmovswb %zmm0, %ymm1 {%k1}
; AVX512F-32-NEXT:    vpmovswb %zmm0, %ymm2 {%k1} {z}
; AVX512F-32-NEXT:    vpmovswb %zmm0, %ymm0
; AVX512F-32-NEXT:    vpaddb %ymm1, %ymm0, %ymm0
; AVX512F-32-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX512F-32-NEXT:    retl
    %res0 = call <32 x i8> @llvm.x86.avx512.mask.pmovs.wb.512(<32 x i16> %x0, <32 x i8> %x1, i32 -1)
    %res1 = call <32 x i8> @llvm.x86.avx512.mask.pmovs.wb.512(<32 x i16> %x0, <32 x i8> %x1, i32 %x2)
    %res2 = call <32 x i8> @llvm.x86.avx512.mask.pmovs.wb.512(<32 x i16> %x0, <32 x i8> zeroinitializer, i32 %x2)
    %res3 = add <32 x i8> %res0, %res1
    %res4 = add <32 x i8> %res3, %res2
    ret <32 x i8> %res4
}

declare void @llvm.x86.avx512.mask.pmovs.wb.mem.512(i8* %ptr, <32 x i16>, i32)

define void @test_int_x86_avx512_mask_pmovs_wb_mem_512(i8* %ptr, <32 x i16> %x1, i32 %x2) {
; AVX512BW-LABEL: test_int_x86_avx512_mask_pmovs_wb_mem_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    vpmovswb %zmm0, (%rdi)
; AVX512BW-NEXT:    kmovd %esi, %k1
; AVX512BW-NEXT:    vpmovswb %zmm0, (%rdi) {%k1}
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_int_x86_avx512_mask_pmovs_wb_mem_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX512F-32-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; AVX512F-32-NEXT:    vpmovswb %zmm0, (%ecx)
; AVX512F-32-NEXT:    kmovd %eax, %k1
; AVX512F-32-NEXT:    vpmovswb %zmm0, (%ecx) {%k1}
; AVX512F-32-NEXT:    retl
    call void @llvm.x86.avx512.mask.pmovs.wb.mem.512(i8* %ptr, <32 x i16> %x1, i32 -1)
    call void @llvm.x86.avx512.mask.pmovs.wb.mem.512(i8* %ptr, <32 x i16> %x1, i32 %x2)
    ret void
}

declare <32 x i8> @llvm.x86.avx512.mask.pmovus.wb.512(<32 x i16>, <32 x i8>, i32)

define <32 x i8>@test_int_x86_avx512_mask_pmovus_wb_512(<32 x i16> %x0, <32 x i8> %x1, i32 %x2) {
; AVX512BW-LABEL: test_int_x86_avx512_mask_pmovus_wb_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovd %edi, %k1
; AVX512BW-NEXT:    vpmovuswb %zmm0, %ymm1 {%k1}
; AVX512BW-NEXT:    vpmovuswb %zmm0, %ymm2 {%k1} {z}
; AVX512BW-NEXT:    vpmovuswb %zmm0, %ymm0
; AVX512BW-NEXT:    vpaddb %ymm1, %ymm0, %ymm0
; AVX512BW-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_int_x86_avx512_mask_pmovus_wb_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    vpmovuswb %zmm0, %ymm1 {%k1}
; AVX512F-32-NEXT:    vpmovuswb %zmm0, %ymm2 {%k1} {z}
; AVX512F-32-NEXT:    vpmovuswb %zmm0, %ymm0
; AVX512F-32-NEXT:    vpaddb %ymm1, %ymm0, %ymm0
; AVX512F-32-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX512F-32-NEXT:    retl
    %res0 = call <32 x i8> @llvm.x86.avx512.mask.pmovus.wb.512(<32 x i16> %x0, <32 x i8> %x1, i32 -1)
    %res1 = call <32 x i8> @llvm.x86.avx512.mask.pmovus.wb.512(<32 x i16> %x0, <32 x i8> %x1, i32 %x2)
    %res2 = call <32 x i8> @llvm.x86.avx512.mask.pmovus.wb.512(<32 x i16> %x0, <32 x i8> zeroinitializer, i32 %x2)
    %res3 = add <32 x i8> %res0, %res1
    %res4 = add <32 x i8> %res3, %res2
    ret <32 x i8> %res4
}

declare void @llvm.x86.avx512.mask.pmovus.wb.mem.512(i8* %ptr, <32 x i16>, i32)

define void @test_int_x86_avx512_mask_pmovus_wb_mem_512(i8* %ptr, <32 x i16> %x1, i32 %x2) {
; AVX512BW-LABEL: test_int_x86_avx512_mask_pmovus_wb_mem_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    vpmovuswb %zmm0, (%rdi)
; AVX512BW-NEXT:    kmovd %esi, %k1
; AVX512BW-NEXT:    vpmovuswb %zmm0, (%rdi) {%k1}
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_int_x86_avx512_mask_pmovus_wb_mem_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX512F-32-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; AVX512F-32-NEXT:    vpmovuswb %zmm0, (%ecx)
; AVX512F-32-NEXT:    kmovd %eax, %k1
; AVX512F-32-NEXT:    vpmovuswb %zmm0, (%ecx) {%k1}
; AVX512F-32-NEXT:    retl
    call void @llvm.x86.avx512.mask.pmovus.wb.mem.512(i8* %ptr, <32 x i16> %x1, i32 -1)
    call void @llvm.x86.avx512.mask.pmovus.wb.mem.512(i8* %ptr, <32 x i16> %x1, i32 %x2)
    ret void
}

declare <32 x i16> @llvm.x86.avx512.mask.pmaddubs.w.512(<64 x i8>, <64 x i8>, <32 x i16>, i32)

define <32 x i16>@test_int_x86_avx512_mask_pmaddubs_w_512(<64 x i8> %x0, <64 x i8> %x1, <32 x i16> %x2, i32 %x3) {
; AVX512BW-LABEL: test_int_x86_avx512_mask_pmaddubs_w_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovd %edi, %k1
; AVX512BW-NEXT:    vpmaddubsw %zmm1, %zmm0, %zmm2 {%k1}
; AVX512BW-NEXT:    vpmaddubsw %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vpaddw %zmm0, %zmm2, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_int_x86_avx512_mask_pmaddubs_w_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    vpmaddubsw %zmm1, %zmm0, %zmm2 {%k1}
; AVX512F-32-NEXT:    vpmaddubsw %zmm1, %zmm0, %zmm0
; AVX512F-32-NEXT:    vpaddw %zmm0, %zmm2, %zmm0
; AVX512F-32-NEXT:    retl
  %res = call <32 x i16> @llvm.x86.avx512.mask.pmaddubs.w.512(<64 x i8> %x0, <64 x i8> %x1, <32 x i16> %x2, i32 %x3)
  %res1 = call <32 x i16> @llvm.x86.avx512.mask.pmaddubs.w.512(<64 x i8> %x0, <64 x i8> %x1, <32 x i16> %x2, i32 -1)
  %res2 = add <32 x i16> %res, %res1
  ret <32 x i16> %res2
}

declare <16 x i32> @llvm.x86.avx512.mask.pmaddw.d.512(<32 x i16>, <32 x i16>, <16 x i32>, i16)

define <16 x i32>@test_int_x86_avx512_mask_pmaddw_d_512(<32 x i16> %x0, <32 x i16> %x1, <16 x i32> %x2, i16 %x3) {
; AVX512BW-LABEL: test_int_x86_avx512_mask_pmaddw_d_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovw %edi, %k1
; AVX512BW-NEXT:    vpmaddwd %zmm1, %zmm0, %zmm2 {%k1}
; AVX512BW-NEXT:    vpmaddwd %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vpaddd %zmm0, %zmm2, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_int_x86_avx512_mask_pmaddw_d_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    kmovw {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    vpmaddwd %zmm1, %zmm0, %zmm2 {%k1}
; AVX512F-32-NEXT:    vpmaddwd %zmm1, %zmm0, %zmm0
; AVX512F-32-NEXT:    vpaddd %zmm0, %zmm2, %zmm0
; AVX512F-32-NEXT:    retl
  %res = call <16 x i32> @llvm.x86.avx512.mask.pmaddw.d.512(<32 x i16> %x0, <32 x i16> %x1, <16 x i32> %x2, i16 %x3)
  %res1 = call <16 x i32> @llvm.x86.avx512.mask.pmaddw.d.512(<32 x i16> %x0, <32 x i16> %x1, <16 x i32> %x2, i16 -1)
  %res2 = add <16 x i32> %res, %res1
  ret <16 x i32> %res2
}

declare <64 x i8> @llvm.x86.avx512.mask.punpckhb.w.512(<64 x i8>, <64 x i8>, <64 x i8>, i64)

define <64 x i8>@test_int_x86_avx512_mask_punpckhb_w_512(<64 x i8> %x0, <64 x i8> %x1, <64 x i8> %x2, i64 %x3) {
; AVX512BW-LABEL: test_int_x86_avx512_mask_punpckhb_w_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovq %rdi, %k1
; AVX512BW-NEXT:    vpunpckhbw {{.*#+}} zmm2 = zmm2[8],k1[8],zmm2[9],k1[9],zmm2[10],k1[10],zmm2[11],k1[11],zmm2[12],k1[12],zmm2[13],k1[13],zmm2[14],k1[14],zmm2[15],k1[15],zmm2[24],k1[24],zmm2[25],k1[25],zmm2[26],k1[26],zmm2[27],k1[27],zmm2[28],k1[28],zmm2[29],k1[29],zmm2[30],k1[30],zmm2[31],k1[31],zmm2[40],k1[40],zmm2[41],k1[41],zmm2[42],k1[42],zmm2[43],k1[43],zmm2[44],k1[44],zmm2[45],k1[45],zmm2[46],k1[46],zmm2[47],k1[47],zmm2[56],k1[56],zmm2[57],k1[57],zmm2[58],k1[58],zmm2[59],k1[59],zmm2[60],k1[60],zmm2[61],k1[61],zmm2[62],k1[62],zmm2[63],k1[63]
; AVX512BW-NEXT:    vpunpckhbw {{.*#+}} zmm0 = zmm0[8],zmm1[8],zmm0[9],zmm1[9],zmm0[10],zmm1[10],zmm0[11],zmm1[11],zmm0[12],zmm1[12],zmm0[13],zmm1[13],zmm0[14],zmm1[14],zmm0[15],zmm1[15],zmm0[24],zmm1[24],zmm0[25],zmm1[25],zmm0[26],zmm1[26],zmm0[27],zmm1[27],zmm0[28],zmm1[28],zmm0[29],zmm1[29],zmm0[30],zmm1[30],zmm0[31],zmm1[31],zmm0[40],zmm1[40],zmm0[41],zmm1[41],zmm0[42],zmm1[42],zmm0[43],zmm1[43],zmm0[44],zmm1[44],zmm0[45],zmm1[45],zmm0[46],zmm1[46],zmm0[47],zmm1[47],zmm0[56],zmm1[56],zmm0[57],zmm1[57],zmm0[58],zmm1[58],zmm0[59],zmm1[59],zmm0[60],zmm1[60],zmm0[61],zmm1[61],zmm0[62],zmm1[62],zmm0[63],zmm1[63]
; AVX512BW-NEXT:    vpaddb %zmm0, %zmm2, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_int_x86_avx512_mask_punpckhb_w_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k0
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    kunpckdq %k0, %k1, %k1
; AVX512F-32-NEXT:    vpunpckhbw {{.*#+}} zmm2 = zmm2[8],k1[8],zmm2[9],k1[9],zmm2[10],k1[10],zmm2[11],k1[11],zmm2[12],k1[12],zmm2[13],k1[13],zmm2[14],k1[14],zmm2[15],k1[15],zmm2[24],k1[24],zmm2[25],k1[25],zmm2[26],k1[26],zmm2[27],k1[27],zmm2[28],k1[28],zmm2[29],k1[29],zmm2[30],k1[30],zmm2[31],k1[31],zmm2[40],k1[40],zmm2[41],k1[41],zmm2[42],k1[42],zmm2[43],k1[43],zmm2[44],k1[44],zmm2[45],k1[45],zmm2[46],k1[46],zmm2[47],k1[47],zmm2[56],k1[56],zmm2[57],k1[57],zmm2[58],k1[58],zmm2[59],k1[59],zmm2[60],k1[60],zmm2[61],k1[61],zmm2[62],k1[62],zmm2[63],k1[63]
; AVX512F-32-NEXT:    vpunpckhbw {{.*#+}} zmm0 = zmm0[8],zmm1[8],zmm0[9],zmm1[9],zmm0[10],zmm1[10],zmm0[11],zmm1[11],zmm0[12],zmm1[12],zmm0[13],zmm1[13],zmm0[14],zmm1[14],zmm0[15],zmm1[15],zmm0[24],zmm1[24],zmm0[25],zmm1[25],zmm0[26],zmm1[26],zmm0[27],zmm1[27],zmm0[28],zmm1[28],zmm0[29],zmm1[29],zmm0[30],zmm1[30],zmm0[31],zmm1[31],zmm0[40],zmm1[40],zmm0[41],zmm1[41],zmm0[42],zmm1[42],zmm0[43],zmm1[43],zmm0[44],zmm1[44],zmm0[45],zmm1[45],zmm0[46],zmm1[46],zmm0[47],zmm1[47],zmm0[56],zmm1[56],zmm0[57],zmm1[57],zmm0[58],zmm1[58],zmm0[59],zmm1[59],zmm0[60],zmm1[60],zmm0[61],zmm1[61],zmm0[62],zmm1[62],zmm0[63],zmm1[63]
; AVX512F-32-NEXT:    vpaddb %zmm0, %zmm2, %zmm0
; AVX512F-32-NEXT:    retl
  %res = call <64 x i8> @llvm.x86.avx512.mask.punpckhb.w.512(<64 x i8> %x0, <64 x i8> %x1, <64 x i8> %x2, i64 %x3)
  %res1 = call <64 x i8> @llvm.x86.avx512.mask.punpckhb.w.512(<64 x i8> %x0, <64 x i8> %x1, <64 x i8> %x2, i64 -1)
  %res2 = add <64 x i8> %res, %res1
  ret <64 x i8> %res2
}

declare <64 x i8> @llvm.x86.avx512.mask.punpcklb.w.512(<64 x i8>, <64 x i8>, <64 x i8>, i64)

define <64 x i8>@test_int_x86_avx512_mask_punpcklb_w_512(<64 x i8> %x0, <64 x i8> %x1, <64 x i8> %x2, i64 %x3) {
; AVX512BW-LABEL: test_int_x86_avx512_mask_punpcklb_w_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovq %rdi, %k1
; AVX512BW-NEXT:    vpunpcklbw {{.*#+}} zmm2 = zmm2[0],k1[0],zmm2[1],k1[1],zmm2[2],k1[2],zmm2[3],k1[3],zmm2[4],k1[4],zmm2[5],k1[5],zmm2[6],k1[6],zmm2[7],k1[7],zmm2[16],k1[16],zmm2[17],k1[17],zmm2[18],k1[18],zmm2[19],k1[19],zmm2[20],k1[20],zmm2[21],k1[21],zmm2[22],k1[22],zmm2[23],k1[23],zmm2[32],k1[32],zmm2[33],k1[33],zmm2[34],k1[34],zmm2[35],k1[35],zmm2[36],k1[36],zmm2[37],k1[37],zmm2[38],k1[38],zmm2[39],k1[39],zmm2[48],k1[48],zmm2[49],k1[49],zmm2[50],k1[50],zmm2[51],k1[51],zmm2[52],k1[52],zmm2[53],k1[53],zmm2[54],k1[54],zmm2[55],k1[55]
; AVX512BW-NEXT:    vpunpcklbw {{.*#+}} zmm0 = zmm0[0],zmm1[0],zmm0[1],zmm1[1],zmm0[2],zmm1[2],zmm0[3],zmm1[3],zmm0[4],zmm1[4],zmm0[5],zmm1[5],zmm0[6],zmm1[6],zmm0[7],zmm1[7],zmm0[16],zmm1[16],zmm0[17],zmm1[17],zmm0[18],zmm1[18],zmm0[19],zmm1[19],zmm0[20],zmm1[20],zmm0[21],zmm1[21],zmm0[22],zmm1[22],zmm0[23],zmm1[23],zmm0[32],zmm1[32],zmm0[33],zmm1[33],zmm0[34],zmm1[34],zmm0[35],zmm1[35],zmm0[36],zmm1[36],zmm0[37],zmm1[37],zmm0[38],zmm1[38],zmm0[39],zmm1[39],zmm0[48],zmm1[48],zmm0[49],zmm1[49],zmm0[50],zmm1[50],zmm0[51],zmm1[51],zmm0[52],zmm1[52],zmm0[53],zmm1[53],zmm0[54],zmm1[54],zmm0[55],zmm1[55]
; AVX512BW-NEXT:    vpaddb %zmm0, %zmm2, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_int_x86_avx512_mask_punpcklb_w_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k0
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    kunpckdq %k0, %k1, %k1
; AVX512F-32-NEXT:    vpunpcklbw {{.*#+}} zmm2 = zmm2[0],k1[0],zmm2[1],k1[1],zmm2[2],k1[2],zmm2[3],k1[3],zmm2[4],k1[4],zmm2[5],k1[5],zmm2[6],k1[6],zmm2[7],k1[7],zmm2[16],k1[16],zmm2[17],k1[17],zmm2[18],k1[18],zmm2[19],k1[19],zmm2[20],k1[20],zmm2[21],k1[21],zmm2[22],k1[22],zmm2[23],k1[23],zmm2[32],k1[32],zmm2[33],k1[33],zmm2[34],k1[34],zmm2[35],k1[35],zmm2[36],k1[36],zmm2[37],k1[37],zmm2[38],k1[38],zmm2[39],k1[39],zmm2[48],k1[48],zmm2[49],k1[49],zmm2[50],k1[50],zmm2[51],k1[51],zmm2[52],k1[52],zmm2[53],k1[53],zmm2[54],k1[54],zmm2[55],k1[55]
; AVX512F-32-NEXT:    vpunpcklbw {{.*#+}} zmm0 = zmm0[0],zmm1[0],zmm0[1],zmm1[1],zmm0[2],zmm1[2],zmm0[3],zmm1[3],zmm0[4],zmm1[4],zmm0[5],zmm1[5],zmm0[6],zmm1[6],zmm0[7],zmm1[7],zmm0[16],zmm1[16],zmm0[17],zmm1[17],zmm0[18],zmm1[18],zmm0[19],zmm1[19],zmm0[20],zmm1[20],zmm0[21],zmm1[21],zmm0[22],zmm1[22],zmm0[23],zmm1[23],zmm0[32],zmm1[32],zmm0[33],zmm1[33],zmm0[34],zmm1[34],zmm0[35],zmm1[35],zmm0[36],zmm1[36],zmm0[37],zmm1[37],zmm0[38],zmm1[38],zmm0[39],zmm1[39],zmm0[48],zmm1[48],zmm0[49],zmm1[49],zmm0[50],zmm1[50],zmm0[51],zmm1[51],zmm0[52],zmm1[52],zmm0[53],zmm1[53],zmm0[54],zmm1[54],zmm0[55],zmm1[55]
; AVX512F-32-NEXT:    vpaddb %zmm0, %zmm2, %zmm0
; AVX512F-32-NEXT:    retl
  %res = call <64 x i8> @llvm.x86.avx512.mask.punpcklb.w.512(<64 x i8> %x0, <64 x i8> %x1, <64 x i8> %x2, i64 %x3)
  %res1 = call <64 x i8> @llvm.x86.avx512.mask.punpcklb.w.512(<64 x i8> %x0, <64 x i8> %x1, <64 x i8> %x2, i64 -1)
  %res2 = add <64 x i8> %res, %res1
  ret <64 x i8> %res2
}

declare <32 x i16> @llvm.x86.avx512.mask.punpckhw.d.512(<32 x i16>, <32 x i16>, <32 x i16>, i32)

define <32 x i16>@test_int_x86_avx512_mask_punpckhw_d_512(<32 x i16> %x0, <32 x i16> %x1, <32 x i16> %x2, i32 %x3) {
; AVX512BW-LABEL: test_int_x86_avx512_mask_punpckhw_d_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovd %edi, %k1
; AVX512BW-NEXT:    vpunpckhwd {{.*#+}} zmm2 = zmm2[4],k1[4],zmm2[5],k1[5],zmm2[6],k1[6],zmm2[7],k1[7],zmm2[12],k1[12],zmm2[13],k1[13],zmm2[14],k1[14],zmm2[15],k1[15],zmm2[20],k1[20],zmm2[21],k1[21],zmm2[22],k1[22],zmm2[23],k1[23],zmm2[28],k1[28],zmm2[29],k1[29],zmm2[30],k1[30],zmm2[31],k1[31]
; AVX512BW-NEXT:    vpunpckhwd {{.*#+}} zmm0 = zmm0[4],zmm1[4],zmm0[5],zmm1[5],zmm0[6],zmm1[6],zmm0[7],zmm1[7],zmm0[12],zmm1[12],zmm0[13],zmm1[13],zmm0[14],zmm1[14],zmm0[15],zmm1[15],zmm0[20],zmm1[20],zmm0[21],zmm1[21],zmm0[22],zmm1[22],zmm0[23],zmm1[23],zmm0[28],zmm1[28],zmm0[29],zmm1[29],zmm0[30],zmm1[30],zmm0[31],zmm1[31]
; AVX512BW-NEXT:    vpaddw %zmm0, %zmm2, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_int_x86_avx512_mask_punpckhw_d_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    vpunpckhwd {{.*#+}} zmm2 = zmm2[4],k1[4],zmm2[5],k1[5],zmm2[6],k1[6],zmm2[7],k1[7],zmm2[12],k1[12],zmm2[13],k1[13],zmm2[14],k1[14],zmm2[15],k1[15],zmm2[20],k1[20],zmm2[21],k1[21],zmm2[22],k1[22],zmm2[23],k1[23],zmm2[28],k1[28],zmm2[29],k1[29],zmm2[30],k1[30],zmm2[31],k1[31]
; AVX512F-32-NEXT:    vpunpckhwd {{.*#+}} zmm0 = zmm0[4],zmm1[4],zmm0[5],zmm1[5],zmm0[6],zmm1[6],zmm0[7],zmm1[7],zmm0[12],zmm1[12],zmm0[13],zmm1[13],zmm0[14],zmm1[14],zmm0[15],zmm1[15],zmm0[20],zmm1[20],zmm0[21],zmm1[21],zmm0[22],zmm1[22],zmm0[23],zmm1[23],zmm0[28],zmm1[28],zmm0[29],zmm1[29],zmm0[30],zmm1[30],zmm0[31],zmm1[31]
; AVX512F-32-NEXT:    vpaddw %zmm0, %zmm2, %zmm0
; AVX512F-32-NEXT:    retl
  %res = call <32 x i16> @llvm.x86.avx512.mask.punpckhw.d.512(<32 x i16> %x0, <32 x i16> %x1, <32 x i16> %x2, i32 %x3)
  %res1 = call <32 x i16> @llvm.x86.avx512.mask.punpckhw.d.512(<32 x i16> %x0, <32 x i16> %x1, <32 x i16> %x2, i32 -1)
  %res2 = add <32 x i16> %res, %res1
  ret <32 x i16> %res2
}

declare <32 x i16> @llvm.x86.avx512.mask.punpcklw.d.512(<32 x i16>, <32 x i16>, <32 x i16>, i32)

define <32 x i16>@test_int_x86_avx512_mask_punpcklw_d_512(<32 x i16> %x0, <32 x i16> %x1, <32 x i16> %x2, i32 %x3) {
; AVX512BW-LABEL: test_int_x86_avx512_mask_punpcklw_d_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovd %edi, %k1
; AVX512BW-NEXT:    vpunpcklwd {{.*#+}} zmm2 = zmm2[0],k1[0],zmm2[1],k1[1],zmm2[2],k1[2],zmm2[3],k1[3],zmm2[8],k1[8],zmm2[9],k1[9],zmm2[10],k1[10],zmm2[11],k1[11],zmm2[16],k1[16],zmm2[17],k1[17],zmm2[18],k1[18],zmm2[19],k1[19],zmm2[24],k1[24],zmm2[25],k1[25],zmm2[26],k1[26],zmm2[27],k1[27]
; AVX512BW-NEXT:    vpunpcklwd {{.*#+}} zmm0 = zmm0[0],zmm1[0],zmm0[1],zmm1[1],zmm0[2],zmm1[2],zmm0[3],zmm1[3],zmm0[8],zmm1[8],zmm0[9],zmm1[9],zmm0[10],zmm1[10],zmm0[11],zmm1[11],zmm0[16],zmm1[16],zmm0[17],zmm1[17],zmm0[18],zmm1[18],zmm0[19],zmm1[19],zmm0[24],zmm1[24],zmm0[25],zmm1[25],zmm0[26],zmm1[26],zmm0[27],zmm1[27]
; AVX512BW-NEXT:    vpaddw %zmm0, %zmm2, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_int_x86_avx512_mask_punpcklw_d_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    vpunpcklwd {{.*#+}} zmm2 = zmm2[0],k1[0],zmm2[1],k1[1],zmm2[2],k1[2],zmm2[3],k1[3],zmm2[8],k1[8],zmm2[9],k1[9],zmm2[10],k1[10],zmm2[11],k1[11],zmm2[16],k1[16],zmm2[17],k1[17],zmm2[18],k1[18],zmm2[19],k1[19],zmm2[24],k1[24],zmm2[25],k1[25],zmm2[26],k1[26],zmm2[27],k1[27]
; AVX512F-32-NEXT:    vpunpcklwd {{.*#+}} zmm0 = zmm0[0],zmm1[0],zmm0[1],zmm1[1],zmm0[2],zmm1[2],zmm0[3],zmm1[3],zmm0[8],zmm1[8],zmm0[9],zmm1[9],zmm0[10],zmm1[10],zmm0[11],zmm1[11],zmm0[16],zmm1[16],zmm0[17],zmm1[17],zmm0[18],zmm1[18],zmm0[19],zmm1[19],zmm0[24],zmm1[24],zmm0[25],zmm1[25],zmm0[26],zmm1[26],zmm0[27],zmm1[27]
; AVX512F-32-NEXT:    vpaddw %zmm0, %zmm2, %zmm0
; AVX512F-32-NEXT:    retl
  %res = call <32 x i16> @llvm.x86.avx512.mask.punpcklw.d.512(<32 x i16> %x0, <32 x i16> %x1, <32 x i16> %x2, i32 %x3)
  %res1 = call <32 x i16> @llvm.x86.avx512.mask.punpcklw.d.512(<32 x i16> %x0, <32 x i16> %x1, <32 x i16> %x2, i32 -1)
  %res2 = add <32 x i16> %res, %res1
  ret <32 x i16> %res2
}

declare <64 x i8> @llvm.x86.avx512.mask.palignr.512(<64 x i8>, <64 x i8>, i32, <64 x i8>, i64)

define <64 x i8>@test_int_x86_avx512_mask_palignr_512(<64 x i8> %x0, <64 x i8> %x1, <64 x i8> %x3, i64 %x4) {
; AVX512BW-LABEL: test_int_x86_avx512_mask_palignr_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovq %rdi, %k1
; AVX512BW-NEXT:    vpalignr $2, %zmm1, %zmm0, %zmm2 {%k1}
; AVX512BW-NEXT:    vpalignr $2, %zmm1, %zmm0, %zmm3 {%k1} {z}
; AVX512BW-NEXT:    vpalignr $2, %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vpaddb %zmm3, %zmm2, %zmm1
; AVX512BW-NEXT:    vpaddb %zmm0, %zmm1, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_int_x86_avx512_mask_palignr_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    vpalignr $2, %zmm1, %zmm0, %zmm3
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k0
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    kunpckdq %k0, %k1, %k1
; AVX512F-32-NEXT:    vpalignr $2, %zmm1, %zmm0, %zmm2 {%k1}
; AVX512F-32-NEXT:    vpalignr $2, %zmm1, %zmm0, %zmm0 {%k1} {z}
; AVX512F-32-NEXT:    vpaddb %zmm0, %zmm2, %zmm0
; AVX512F-32-NEXT:    vpaddb %zmm3, %zmm0, %zmm0
; AVX512F-32-NEXT:    retl
  %res = call <64 x i8> @llvm.x86.avx512.mask.palignr.512(<64 x i8> %x0, <64 x i8> %x1, i32 2, <64 x i8> %x3, i64 %x4)
  %res1 = call <64 x i8> @llvm.x86.avx512.mask.palignr.512(<64 x i8> %x0, <64 x i8> %x1, i32 2, <64 x i8> zeroinitializer, i64 %x4)
  %res2 = call <64 x i8> @llvm.x86.avx512.mask.palignr.512(<64 x i8> %x0, <64 x i8> %x1, i32 2, <64 x i8> %x3, i64 -1)
  %res3 = add <64 x i8> %res, %res1
  %res4 = add <64 x i8> %res3, %res2
  ret <64 x i8> %res4
}

declare <32 x i16> @llvm.x86.avx512.mask.dbpsadbw.512(<64 x i8>, <64 x i8>, i32, <32 x i16>, i32)

define <32 x i16>@test_int_x86_avx512_mask_dbpsadbw_512(<64 x i8> %x0, <64 x i8> %x1, <32 x i16> %x3, i32 %x4) {
; AVX512BW-LABEL: test_int_x86_avx512_mask_dbpsadbw_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovd %edi, %k1
; AVX512BW-NEXT:    vdbpsadbw $2, %zmm1, %zmm0, %zmm2 {%k1}
; AVX512BW-NEXT:    vdbpsadbw $2, %zmm1, %zmm0, %zmm3 {%k1} {z}
; AVX512BW-NEXT:    vdbpsadbw $2, %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vpaddw %zmm3, %zmm2, %zmm1
; AVX512BW-NEXT:    vpaddw %zmm0, %zmm1, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_int_x86_avx512_mask_dbpsadbw_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    vdbpsadbw $2, %zmm1, %zmm0, %zmm2 {%k1}
; AVX512F-32-NEXT:    vdbpsadbw $2, %zmm1, %zmm0, %zmm3 {%k1} {z}
; AVX512F-32-NEXT:    vdbpsadbw $2, %zmm1, %zmm0, %zmm0
; AVX512F-32-NEXT:    vpaddw %zmm3, %zmm2, %zmm1
; AVX512F-32-NEXT:    vpaddw %zmm0, %zmm1, %zmm0
; AVX512F-32-NEXT:    retl
  %res = call <32 x i16> @llvm.x86.avx512.mask.dbpsadbw.512(<64 x i8> %x0, <64 x i8> %x1, i32 2, <32 x i16> %x3, i32 %x4)
  %res1 = call <32 x i16> @llvm.x86.avx512.mask.dbpsadbw.512(<64 x i8> %x0, <64 x i8> %x1, i32 2, <32 x i16> zeroinitializer, i32 %x4)
  %res2 = call <32 x i16> @llvm.x86.avx512.mask.dbpsadbw.512(<64 x i8> %x0, <64 x i8> %x1, i32 2, <32 x i16> %x3, i32 -1)
  %res3 = add <32 x i16> %res, %res1
  %res4 = add <32 x i16> %res3, %res2
  ret <32 x i16> %res4
}

declare <8 x i64> @llvm.x86.avx512.psll.dq.512(<8 x i64>, i32)

define <8 x i64>@test_int_x86_avx512_mask_psll_dq_512(<8 x i64> %x0) {
; AVX512BW-LABEL: test_int_x86_avx512_mask_psll_dq_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    vpslldq $8, %zmm0, %zmm1
; AVX512BW-NEXT:    vpslldq $4, %zmm0, %zmm0
; AVX512BW-NEXT:    vpaddq %zmm0, %zmm1, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_int_x86_avx512_mask_psll_dq_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    vpslldq $8, %zmm0, %zmm1
; AVX512F-32-NEXT:    vpslldq $4, %zmm0, %zmm0
; AVX512F-32-NEXT:    vpaddq %zmm0, %zmm1, %zmm0
; AVX512F-32-NEXT:    retl
  %res = call <8 x i64> @llvm.x86.avx512.psll.dq.512(<8 x i64> %x0, i32 8)
  %res1 = call <8 x i64> @llvm.x86.avx512.psll.dq.512(<8 x i64> %x0, i32 4)
  %res2 = add <8 x i64> %res, %res1
  ret <8 x i64> %res2
}

declare <8 x i64> @llvm.x86.avx512.psrl.dq.512(<8 x i64>, i32)

define <8 x i64>@test_int_x86_avx512_mask_psrl_dq_512(<8 x i64> %x0) {
; AVX512BW-LABEL: test_int_x86_avx512_mask_psrl_dq_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    vpsrldq $8, %zmm0, %zmm1
; AVX512BW-NEXT:    vpsrldq $4, %zmm0, %zmm0
; AVX512BW-NEXT:    vpaddq %zmm0, %zmm1, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_int_x86_avx512_mask_psrl_dq_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    vpsrldq $8, %zmm0, %zmm1
; AVX512F-32-NEXT:    vpsrldq $4, %zmm0, %zmm0
; AVX512F-32-NEXT:    vpaddq %zmm0, %zmm1, %zmm0
; AVX512F-32-NEXT:    retl
  %res = call <8 x i64> @llvm.x86.avx512.psrl.dq.512(<8 x i64> %x0, i32 8)
  %res1 = call <8 x i64> @llvm.x86.avx512.psrl.dq.512(<8 x i64> %x0, i32 4)
  %res2 = add <8 x i64> %res, %res1
  ret <8 x i64> %res2
}
declare  <8 x i64> @llvm.x86.avx512.psad.bw.512(<64 x i8>, <64 x i8>)

define  <8 x i64>@test_int_x86_avx512_mask_psadb_w_512(<64 x i8> %x0, <64 x i8> %x1, <64 x i8> %x2){
; AVX512BW-LABEL: test_int_x86_avx512_mask_psadb_w_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    vpsadbw %zmm1, %zmm0, %zmm1
; AVX512BW-NEXT:    vpsadbw %zmm2, %zmm0, %zmm0
; AVX512BW-NEXT:    vpaddq %zmm0, %zmm1, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_int_x86_avx512_mask_psadb_w_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    vpsadbw %zmm1, %zmm0, %zmm1
; AVX512F-32-NEXT:    vpsadbw %zmm2, %zmm0, %zmm0
; AVX512F-32-NEXT:    vpaddq %zmm0, %zmm1, %zmm0
; AVX512F-32-NEXT:    retl
  %res = call  <8 x i64> @llvm.x86.avx512.psad.bw.512(<64 x i8> %x0, <64 x i8> %x1)
  %res1 = call  <8 x i64> @llvm.x86.avx512.psad.bw.512(<64 x i8> %x0, <64 x i8> %x2)
  %res2 = add  <8 x i64> %res, %res1
  ret  <8 x i64> %res2
}

declare i32 @llvm.x86.avx512.kunpck.wd(i32, i32)

define i32@test_int_x86_avx512_kunpck_wd(i32 %x0, i32 %x1) {
; AVX512BW-LABEL: test_int_x86_avx512_kunpck_wd:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovd %edi, %k0
; AVX512BW-NEXT:    kmovd %esi, %k1
; AVX512BW-NEXT:    kunpckwd %k1, %k0, %k0
; AVX512BW-NEXT:    kmovd %k0, %eax
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_int_x86_avx512_kunpck_wd:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k0
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    kunpckwd %k1, %k0, %k0
; AVX512F-32-NEXT:    kmovd %k0, %eax
; AVX512F-32-NEXT:    retl
  %res = call i32 @llvm.x86.avx512.kunpck.wd(i32 %x0, i32 %x1)
  ret i32 %res
}

declare i64 @llvm.x86.avx512.kunpck.dq(i64, i64)

define i64@test_int_x86_avx512_kunpck_qd(i64 %x0, i64 %x1) {
; AVX512BW-LABEL: test_int_x86_avx512_kunpck_qd:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovq %rdi, %k0
; AVX512BW-NEXT:    kmovq %rsi, %k1
; AVX512BW-NEXT:    kunpckdq %k1, %k0, %k0
; AVX512BW-NEXT:    kmovq %k0, %rax
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_int_x86_avx512_kunpck_qd:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    subl $12, %esp
; AVX512F-32-NEXT:  .Ltmp8:
; AVX512F-32-NEXT:    .cfi_def_cfa_offset 16
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k0
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    kunpckdq %k0, %k1, %k0
; AVX512F-32-NEXT:    kmovq %k0, (%esp)
; AVX512F-32-NEXT:    movl (%esp), %eax
; AVX512F-32-NEXT:    movl {{[0-9]+}}(%esp), %edx
; AVX512F-32-NEXT:    addl $12, %esp
; AVX512F-32-NEXT:    retl
  %res = call i64 @llvm.x86.avx512.kunpck.dq(i64 %x0, i64 %x1)
  ret i64 %res
}

declare i64 @llvm.x86.avx512.cvtb2mask.512(<64 x i8>)

define i64@test_int_x86_avx512_cvtb2mask_512(<64 x i8> %x0) {
; AVX512BW-LABEL: test_int_x86_avx512_cvtb2mask_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    vpmovb2m %zmm0, %k0
; AVX512BW-NEXT:    kmovq %k0, %rax
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_int_x86_avx512_cvtb2mask_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    subl $12, %esp
; AVX512F-32-NEXT:  .Ltmp9:
; AVX512F-32-NEXT:    .cfi_def_cfa_offset 16
; AVX512F-32-NEXT:    vpmovb2m %zmm0, %k0
; AVX512F-32-NEXT:    kmovq %k0, (%esp)
; AVX512F-32-NEXT:    movl (%esp), %eax
; AVX512F-32-NEXT:    movl {{[0-9]+}}(%esp), %edx
; AVX512F-32-NEXT:    addl $12, %esp
; AVX512F-32-NEXT:    retl
    %res = call i64 @llvm.x86.avx512.cvtb2mask.512(<64 x i8> %x0)
    ret i64 %res
}

declare i32 @llvm.x86.avx512.cvtw2mask.512(<32 x i16>)

define i32@test_int_x86_avx512_cvtw2mask_512(<32 x i16> %x0) {
; AVX512BW-LABEL: test_int_x86_avx512_cvtw2mask_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    vpmovw2m %zmm0, %k0
; AVX512BW-NEXT:    kmovd %k0, %eax
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_int_x86_avx512_cvtw2mask_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    vpmovw2m %zmm0, %k0
; AVX512F-32-NEXT:    kmovd %k0, %eax
; AVX512F-32-NEXT:    retl
    %res = call i32 @llvm.x86.avx512.cvtw2mask.512(<32 x i16> %x0)
    ret i32 %res
}

declare <64 x i8> @llvm.x86.avx512.cvtmask2b.512(i64)

define <64 x i8>@test_int_x86_avx512_cvtmask2b_512(i64 %x0) {
; AVX512BW-LABEL: test_int_x86_avx512_cvtmask2b_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovq %rdi, %k0
; AVX512BW-NEXT:    vpmovm2b %k0, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_int_x86_avx512_cvtmask2b_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k0
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k1
; AVX512F-32-NEXT:    kunpckdq %k0, %k1, %k0
; AVX512F-32-NEXT:    vpmovm2b %k0, %zmm0
; AVX512F-32-NEXT:    retl
  %res = call <64 x i8> @llvm.x86.avx512.cvtmask2b.512(i64 %x0)
  ret <64 x i8> %res
}

declare <32 x i16> @llvm.x86.avx512.cvtmask2w.512(i32)

define <32 x i16>@test_int_x86_avx512_cvtmask2w_512(i32 %x0) {
; AVX512BW-LABEL: test_int_x86_avx512_cvtmask2w_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovd %edi, %k0
; AVX512BW-NEXT:    vpmovm2w %k0, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512F-32-LABEL: test_int_x86_avx512_cvtmask2w_512:
; AVX512F-32:       # BB#0:
; AVX512F-32-NEXT:    kmovd {{[0-9]+}}(%esp), %k0
; AVX512F-32-NEXT:    vpmovm2w %k0, %zmm0
; AVX512F-32-NEXT:    retl
  %res = call <32 x i16> @llvm.x86.avx512.cvtmask2w.512(i32 %x0)
  ret <32 x i16> %res
}

declare <32 x i16> @llvm.x86.avx512.mask.psrl.w.512(<32 x i16>, <8 x i16>, <32 x i16>, i32)

define <32 x i16>@test_int_x86_avx512_mask_psrl_w_512(<32 x i16> %x0, <8 x i16> %x1, <32 x i16> %x2, i32 %x3) {
; AVX512BW-LABEL: test_int_x86_avx512_mask_psrl_w_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovd %edi, %k1
; AVX512BW-NEXT:    vpsrlw %xmm1, %zmm0, %zmm2 {%k1}
; AVX512BW-NEXT:    vpsrlw %xmm1, %zmm0, %zmm3 {%k1} {z}
; AVX512BW-NEXT:    vpsrlw %xmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vpaddw %zmm0, %zmm2, %zmm0
; AVX512BW-NEXT:    vpaddw %zmm3, %zmm0, %zmm0
; AVX512BW-NEXT:    retq
  %res = call <32 x i16> @llvm.x86.avx512.mask.psrl.w.512(<32 x i16> %x0, <8 x i16> %x1, <32 x i16> %x2, i32 %x3)
  %res1 = call <32 x i16> @llvm.x86.avx512.mask.psrl.w.512(<32 x i16> %x0, <8 x i16> %x1, <32 x i16> %x2, i32 -1)
  %res2 = call <32 x i16> @llvm.x86.avx512.mask.psrl.w.512(<32 x i16> %x0, <8 x i16> %x1, <32 x i16> zeroinitializer, i32 %x3)
  %res3 = add <32 x i16> %res, %res1
  %res4 = add <32 x i16> %res3, %res2
  ret <32 x i16> %res4
}

declare <32 x i16> @llvm.x86.avx512.mask.psrl.wi.512(<32 x i16>, i8, <32 x i16>, i32)

define <32 x i16>@test_int_x86_avx512_mask_psrl_wi_512(<32 x i16> %x0, i8 %x1, <32 x i16> %x2, i32 %x3) {
; AVX512BW-LABEL: test_int_x86_avx512_mask_psrl_wi_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovd %esi, %k1
; AVX512BW-NEXT:    vpsrlw $3, %zmm0, %zmm1 {%k1}
; AVX512BW-NEXT:    vpsrlw $3, %zmm0, %zmm2 {%k1} {z}
; AVX512BW-NEXT:    vpsrlw $3, %zmm0, %zmm0
; AVX512BW-NEXT:    vpaddw %zmm0, %zmm1, %zmm0
; AVX512BW-NEXT:    vpaddw %zmm2, %zmm0, %zmm0
; AVX512BW-NEXT:    retq
  %res = call <32 x i16> @llvm.x86.avx512.mask.psrl.wi.512(<32 x i16> %x0, i8 3, <32 x i16> %x2, i32 %x3)
  %res1 = call <32 x i16> @llvm.x86.avx512.mask.psrl.wi.512(<32 x i16> %x0, i8 3, <32 x i16> %x2, i32 -1)
  %res2 = call <32 x i16> @llvm.x86.avx512.mask.psrl.wi.512(<32 x i16> %x0, i8 3, <32 x i16> zeroinitializer, i32 %x3)
  %res3 = add <32 x i16> %res, %res1
  %res4 = add <32 x i16> %res3, %res2
  ret <32 x i16> %res4
}

declare <32 x i16> @llvm.x86.avx512.mask.psrlv32hi(<32 x i16>, <32 x i16>, <32 x i16>, i32)

define <32 x i16>@test_int_x86_avx512_mask_psrlv32hi(<32 x i16> %x0, <32 x i16> %x1, <32 x i16> %x2, i32 %x3) {
; AVX512BW-LABEL: test_int_x86_avx512_mask_psrlv32hi:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovd %edi, %k1
; AVX512BW-NEXT:    vpsrlvw %zmm1, %zmm0, %zmm2 {%k1}
; AVX512BW-NEXT:    vpsrlvw %zmm1, %zmm0, %zmm3 {%k1} {z}
; AVX512BW-NEXT:    vpsrlvw %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vpaddw %zmm3, %zmm2, %zmm1
; AVX512BW-NEXT:    vpaddw %zmm0, %zmm1, %zmm0
; AVX512BW-NEXT:    retq
  %res = call <32 x i16> @llvm.x86.avx512.mask.psrlv32hi(<32 x i16> %x0, <32 x i16> %x1, <32 x i16> %x2, i32 %x3)
  %res1 = call <32 x i16> @llvm.x86.avx512.mask.psrlv32hi(<32 x i16> %x0, <32 x i16> %x1, <32 x i16> zeroinitializer, i32 %x3)
  %res2 = call <32 x i16> @llvm.x86.avx512.mask.psrlv32hi(<32 x i16> %x0, <32 x i16> %x1, <32 x i16> %x2, i32 -1)
  %res3 = add <32 x i16> %res, %res1
  %res4 = add <32 x i16> %res3, %res2
  ret <32 x i16> %res4
}

declare <32 x i16> @llvm.x86.avx512.mask.psra.w.512(<32 x i16>, <8 x i16>, <32 x i16>, i32)

define <32 x i16>@test_int_x86_avx512_mask_psra_w_512(<32 x i16> %x0, <8 x i16> %x1, <32 x i16> %x2, i32 %x3) {
; AVX512BW-LABEL: test_int_x86_avx512_mask_psra_w_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovd %edi, %k1
; AVX512BW-NEXT:    vpsraw %xmm1, %zmm0, %zmm2 {%k1}
; AVX512BW-NEXT:    vpsraw %xmm1, %zmm0, %zmm3 {%k1} {z}
; AVX512BW-NEXT:    vpsraw %xmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vpaddw %zmm3, %zmm2, %zmm1
; AVX512BW-NEXT:    vpaddw %zmm0, %zmm1, %zmm0
; AVX512BW-NEXT:    retq
  %res = call <32 x i16> @llvm.x86.avx512.mask.psra.w.512(<32 x i16> %x0, <8 x i16> %x1, <32 x i16> %x2, i32 %x3)
  %res1 = call <32 x i16> @llvm.x86.avx512.mask.psra.w.512(<32 x i16> %x0, <8 x i16> %x1, <32 x i16> zeroinitializer, i32 %x3)
  %res2 = call <32 x i16> @llvm.x86.avx512.mask.psra.w.512(<32 x i16> %x0, <8 x i16> %x1, <32 x i16> %x2, i32 -1)
  %res3 = add <32 x i16> %res, %res1
  %res4 = add <32 x i16> %res3, %res2
  ret <32 x i16> %res4
}

declare <32 x i16> @llvm.x86.avx512.mask.psra.wi.512(<32 x i16>, i8, <32 x i16>, i32)

define <32 x i16>@test_int_x86_avx512_mask_psra_wi_512(<32 x i16> %x0, i8 %x1, <32 x i16> %x2, i32 %x3) {
; AVX512BW-LABEL: test_int_x86_avx512_mask_psra_wi_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovd %esi, %k1
; AVX512BW-NEXT:    vpsraw $3, %zmm0, %zmm1 {%k1}
; AVX512BW-NEXT:    vpsraw $3, %zmm0, %zmm2 {%k1} {z}
; AVX512BW-NEXT:    vpsraw $3, %zmm0, %zmm0
; AVX512BW-NEXT:    vpaddw %zmm2, %zmm1, %zmm1
; AVX512BW-NEXT:    vpaddw %zmm0, %zmm1, %zmm0
; AVX512BW-NEXT:    retq
  %res = call <32 x i16> @llvm.x86.avx512.mask.psra.wi.512(<32 x i16> %x0, i8 3, <32 x i16> %x2, i32 %x3)
  %res1 = call <32 x i16> @llvm.x86.avx512.mask.psra.wi.512(<32 x i16> %x0, i8 3, <32 x i16> zeroinitializer, i32 %x3)
  %res2 = call <32 x i16> @llvm.x86.avx512.mask.psra.wi.512(<32 x i16> %x0, i8 3, <32 x i16> %x2, i32 -1)
  %res3 = add <32 x i16> %res, %res1
  %res4 = add <32 x i16> %res3, %res2
  ret <32 x i16> %res4
}

declare <32 x i16> @llvm.x86.avx512.mask.pshufh.w.512(<32 x i16>, i8, <32 x i16>, i32)

define <32 x i16>@test_int_x86_avx512_mask_pshufh_w_512(<32 x i16> %x0, i8 %x1, <32 x i16> %x2, i32 %x3) {
; AVX512BW-LABEL: test_int_x86_avx512_mask_pshufh_w_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovd %esi, %k1
; AVX512BW-NEXT:    vpshufhw $3, %zmm0, %zmm1 {%k1}
; AVX512BW-NEXT:    vpshufhw $3, %zmm0, %zmm2 {%k1} {z}
; AVX512BW-NEXT:    vpshufhw $3, %zmm0, %zmm0
; AVX512BW-NEXT:    vpaddw %zmm2, %zmm1, %zmm1
; AVX512BW-NEXT:    vpaddw %zmm0, %zmm1, %zmm0
; AVX512BW-NEXT:    retq
  %res = call <32 x i16> @llvm.x86.avx512.mask.pshufh.w.512(<32 x i16> %x0, i8 3, <32 x i16> %x2, i32 %x3)
  %res1 = call <32 x i16> @llvm.x86.avx512.mask.pshufh.w.512(<32 x i16> %x0, i8 3, <32 x i16> zeroinitializer, i32 %x3)
  %res2 = call <32 x i16> @llvm.x86.avx512.mask.pshufh.w.512(<32 x i16> %x0, i8 3, <32 x i16> %x2, i32 -1)
  %res3 = add <32 x i16> %res, %res1
  %res4 = add <32 x i16> %res3, %res2
  ret <32 x i16> %res4
}

declare <32 x i16> @llvm.x86.avx512.mask.pshufl.w.512(<32 x i16>, i8, <32 x i16>, i32)

define <32 x i16>@test_int_x86_avx512_mask_pshufl_w_512(<32 x i16> %x0, i8 %x1, <32 x i16> %x2, i32 %x3) {
; AVX512BW-LABEL: test_int_x86_avx512_mask_pshufl_w_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovd %esi, %k1 
; AVX512BW-NEXT:    vpshuflw $3, %zmm0, %zmm1 {%k1} 
; AVX512BW-NEXT:    vpshuflw $3, %zmm0, %zmm2 {%k1} {z} 
; AVX512BW-NEXT:    vpshuflw $3, %zmm0, %zmm0 
; AVX512BW-NEXT:    vpaddw %zmm2, %zmm1, %zmm1 
; AVX512BW-NEXT:    vpaddw %zmm0, %zmm1, %zmm0 
; AVX512BW-NEXT:    retq 
  %res = call <32 x i16> @llvm.x86.avx512.mask.pshufl.w.512(<32 x i16> %x0, i8 3, <32 x i16> %x2, i32 %x3)
  %res1 = call <32 x i16> @llvm.x86.avx512.mask.pshufl.w.512(<32 x i16> %x0, i8 3, <32 x i16> zeroinitializer, i32 %x3)
  %res2 = call <32 x i16> @llvm.x86.avx512.mask.pshufl.w.512(<32 x i16> %x0, i8 3, <32 x i16> %x2, i32 -1)
  %res3 = add <32 x i16> %res, %res1
  %res4 = add <32 x i16> %res3, %res2
  ret <32 x i16> %res4
}

declare <32 x i16> @llvm.x86.avx512.mask.psrav32.hi(<32 x i16>, <32 x i16>, <32 x i16>, i32)

define <32 x i16>@test_int_x86_avx512_mask_psrav32_hi(<32 x i16> %x0, <32 x i16> %x1, <32 x i16> %x2, i32 %x3) {
; AVX512BW-LABEL: test_int_x86_avx512_mask_psrav32_hi:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovd %edi, %k1
; AVX512BW-NEXT:    vpsravw %zmm1, %zmm0, %zmm2 {%k1}
; AVX512BW-NEXT:    vpsravw %zmm1, %zmm0, %zmm3 {%k1} {z}
; AVX512BW-NEXT:    vpsravw %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vpaddw %zmm3, %zmm2, %zmm1
; AVX512BW-NEXT:    vpaddw %zmm0, %zmm1, %zmm0
; AVX512BW-NEXT:    retq
  %res = call <32 x i16> @llvm.x86.avx512.mask.psrav32.hi(<32 x i16> %x0, <32 x i16> %x1, <32 x i16> %x2, i32 %x3)
  %res1 = call <32 x i16> @llvm.x86.avx512.mask.psrav32.hi(<32 x i16> %x0, <32 x i16> %x1, <32 x i16> zeroinitializer, i32 %x3)
  %res2 = call <32 x i16> @llvm.x86.avx512.mask.psrav32.hi(<32 x i16> %x0, <32 x i16> %x1, <32 x i16> %x2, i32 -1)
  %res3 = add <32 x i16> %res, %res1
  %res4 = add <32 x i16> %res3, %res2
  ret <32 x i16> %res4
}

declare <32 x i16> @llvm.x86.avx512.mask.psll.w.512(<32 x i16>, <8 x i16>, <32 x i16>, i32)

define <32 x i16>@test_int_x86_avx512_mask_psll_w_512(<32 x i16> %x0, <8 x i16> %x1, <32 x i16> %x2, i32 %x3) {
; AVX512BW-LABEL: test_int_x86_avx512_mask_psll_w_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovd %edi, %k1
; AVX512BW-NEXT:    vpsllw %xmm1, %zmm0, %zmm2 {%k1}
; AVX512BW-NEXT:    vpsllw %xmm1, %zmm0, %zmm3 {%k1} {z}
; AVX512BW-NEXT:    vpsllw %xmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vpaddw %zmm3, %zmm2, %zmm1
; AVX512BW-NEXT:    vpaddw %zmm0, %zmm1, %zmm0
; AVX512BW-NEXT:    retq
  %res = call <32 x i16> @llvm.x86.avx512.mask.psll.w.512(<32 x i16> %x0, <8 x i16> %x1, <32 x i16> %x2, i32 %x3)
  %res1 = call <32 x i16> @llvm.x86.avx512.mask.psll.w.512(<32 x i16> %x0, <8 x i16> %x1, <32 x i16> zeroinitializer, i32 %x3)
  %res2 = call <32 x i16> @llvm.x86.avx512.mask.psll.w.512(<32 x i16> %x0, <8 x i16> %x1, <32 x i16> %x2, i32 -1)
  %res3 = add <32 x i16> %res, %res1
  %res4 = add <32 x i16> %res3, %res2
  ret <32 x i16> %res4
}

declare <32 x i16> @llvm.x86.avx512.mask.psll.wi.512(<32 x i16>, i8, <32 x i16>, i32)

define <32 x i16>@test_int_x86_avx512_mask_psll_wi_512(<32 x i16> %x0, i8 %x1, <32 x i16> %x2, i32 %x3) {
; AVX512BW-LABEL: test_int_x86_avx512_mask_psll_wi_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovd %esi, %k1
; AVX512BW-NEXT:    vpsllw $3, %zmm0, %zmm1 {%k1}
; AVX512BW-NEXT:    vpsllw $3, %zmm0, %zmm2 {%k1} {z}
; AVX512BW-NEXT:    vpsllw $3, %zmm0, %zmm0
; AVX512BW-NEXT:    vpaddw %zmm2, %zmm1, %zmm1
; AVX512BW-NEXT:    vpaddw %zmm0, %zmm1, %zmm0
; AVX512BW-NEXT:    retq
  %res = call <32 x i16> @llvm.x86.avx512.mask.psll.wi.512(<32 x i16> %x0, i8 3, <32 x i16> %x2, i32 %x3)
  %res1 = call <32 x i16> @llvm.x86.avx512.mask.psll.wi.512(<32 x i16> %x0, i8 3, <32 x i16> zeroinitializer, i32 %x3)
  %res2 = call <32 x i16> @llvm.x86.avx512.mask.psll.wi.512(<32 x i16> %x0, i8 3, <32 x i16> %x2, i32 -1)
  %res3 = add <32 x i16> %res, %res1
  %res4 = add <32 x i16> %res3, %res2
  ret <32 x i16> %res4
}

declare <32 x i16> @llvm.x86.avx512.mask.psllv32hi(<32 x i16>, <32 x i16>, <32 x i16>, i32)

define <32 x i16>@test_int_x86_avx512_mask_psllv32hi(<32 x i16> %x0, <32 x i16> %x1, <32 x i16> %x2, i32 %x3) {
; AVX512BW-LABEL: test_int_x86_avx512_mask_psllv32hi:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovd %edi, %k1
; AVX512BW-NEXT:    vpsllvw %zmm1, %zmm0, %zmm2 {%k1}
; AVX512BW-NEXT:    vpsllvw %zmm1, %zmm0, %zmm3 {%k1} {z}
; AVX512BW-NEXT:    vpsllvw %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vpaddw %zmm3, %zmm2, %zmm1
; AVX512BW-NEXT:    vpaddw %zmm0, %zmm1, %zmm0
; AVX512BW-NEXT:    retq
  %res = call <32 x i16> @llvm.x86.avx512.mask.psllv32hi(<32 x i16> %x0, <32 x i16> %x1, <32 x i16> %x2, i32 %x3)
  %res1 = call <32 x i16> @llvm.x86.avx512.mask.psllv32hi(<32 x i16> %x0, <32 x i16> %x1, <32 x i16> zeroinitializer, i32 %x3)
  %res2 = call <32 x i16> @llvm.x86.avx512.mask.psllv32hi(<32 x i16> %x0, <32 x i16> %x1, <32 x i16> %x2, i32 -1)
  %res3 = add <32 x i16> %res, %res1
  %res4 = add <32 x i16> %res3, %res2
  ret <32 x i16> %res4
}

declare <32 x i16> @llvm.x86.avx512.mask.pmovzxb.w.512(<32 x i8>, <32 x i16>, i32)

define <32 x i16>@test_int_x86_avx512_mask_pmovzxb_w_512(<32 x i8> %x0, <32 x i16> %x1, i32 %x2) {
; AVX512BW-LABEL: test_int_x86_avx512_mask_pmovzxb_w_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovd %edi, %k1 
; AVX512BW-NEXT:    vpmovzxbw %ymm0, %zmm1 {%k1} 
; AVX512BW-NEXT:    vpmovzxbw %ymm0, %zmm2 {%k1} {z} 
; AVX512BW-NEXT:    vpmovzxbw %ymm0, %zmm0 
; AVX512BW-NEXT:    vpaddw %zmm2, %zmm1, %zmm1 
; AVX512BW-NEXT:    vpaddw %zmm0, %zmm1, %zmm0 
; AVX512BW-NEXT:    retq 
  %res = call <32 x i16> @llvm.x86.avx512.mask.pmovzxb.w.512(<32 x i8> %x0, <32 x i16> %x1, i32 %x2)
  %res1 = call <32 x i16> @llvm.x86.avx512.mask.pmovzxb.w.512(<32 x i8> %x0, <32 x i16> zeroinitializer, i32 %x2)
  %res2 = call <32 x i16> @llvm.x86.avx512.mask.pmovzxb.w.512(<32 x i8> %x0, <32 x i16> %x1, i32 -1)
  %res3 = add <32 x i16> %res, %res1
  %res4 = add <32 x i16> %res3, %res2
  ret <32 x i16> %res4
}


declare <32 x i16> @llvm.x86.avx512.mask.pmovsxb.w.512(<32 x i8>, <32 x i16>, i32)

define <32 x i16>@test_int_x86_avx512_mask_pmovsxb_w_512(<32 x i8> %x0, <32 x i16> %x1, i32 %x2) {
; AVX512BW-LABEL: test_int_x86_avx512_mask_pmovsxb_w_512:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    kmovd %edi, %k1 
; AVX512BW-NEXT:    vpmovsxbw %ymm0, %zmm1 {%k1} 
; AVX512BW-NEXT:    vpmovsxbw %ymm0, %zmm2 {%k1} {z} 
; AVX512BW-NEXT:    vpmovsxbw %ymm0, %zmm0 
; AVX512BW-NEXT:    vpaddw %zmm2, %zmm1, %zmm1 
; AVX512BW-NEXT:    vpaddw %zmm0, %zmm1, %zmm0 
; AVX512BW-NEXT:    retq 
  %res = call <32 x i16> @llvm.x86.avx512.mask.pmovsxb.w.512(<32 x i8> %x0, <32 x i16> %x1, i32 %x2)
  %res1 = call <32 x i16> @llvm.x86.avx512.mask.pmovsxb.w.512(<32 x i8> %x0, <32 x i16> zeroinitializer, i32 %x2)
  %res2 = call <32 x i16> @llvm.x86.avx512.mask.pmovsxb.w.512(<32 x i8> %x0, <32 x i16> %x1, i32 -1)
  %res3 = add <32 x i16> %res, %res1
  %res4 = add <32 x i16> %res3, %res2
  ret <32 x i16> %res4
}