# NOTE: Assertions have been autogenerated by utils/update_mca_test_checks.py
# RUN: llvm-mca -mtriple=x86_64-unknown-unknown -mcpu=sapphirerapids -instruction-tables < %s | FileCheck %s

addsubpd  %xmm0, %xmm2
addsubpd  (%rax),  %xmm2

addsubps  %xmm0, %xmm2
addsubps  (%rax), %xmm2

haddpd    %xmm0, %xmm2
haddpd    (%rax), %xmm2

haddps    %xmm0, %xmm2
haddps    (%rax), %xmm2

hsubpd    %xmm0, %xmm2
hsubpd    (%rax), %xmm2

hsubps    %xmm0, %xmm2
hsubps    (%rax), %xmm2

lddqu     (%rax), %xmm2

monitor

movddup   %xmm0, %xmm2
movddup   (%rax), %xmm2

movshdup  %xmm0, %xmm2
movshdup  (%rax), %xmm2

movsldup  %xmm0, %xmm2
movsldup  (%rax), %xmm2

mwait

# CHECK:      Instruction Info:
# CHECK-NEXT: [1]: #uOps
# CHECK-NEXT: [2]: Latency
# CHECK-NEXT: [3]: RThroughput
# CHECK-NEXT: [4]: MayLoad
# CHECK-NEXT: [5]: MayStore
# CHECK-NEXT: [6]: HasSideEffects (U)

# CHECK:      [1]    [2]    [3]    [4]    [5]    [6]    Instructions:
# CHECK-NEXT:  1      3     0.50                        addsubpd	%xmm0, %xmm2
# CHECK-NEXT:  2      10    0.50    *                   addsubpd	(%rax), %xmm2
# CHECK-NEXT:  1      3     0.50                        addsubps	%xmm0, %xmm2
# CHECK-NEXT:  2      10    0.50    *                   addsubps	(%rax), %xmm2
# CHECK-NEXT:  3      6     2.00                        haddpd	%xmm0, %xmm2
# CHECK-NEXT:  4      12    2.00    *                   haddpd	(%rax), %xmm2
# CHECK-NEXT:  3      6     2.00                        haddps	%xmm0, %xmm2
# CHECK-NEXT:  4      12    2.00    *                   haddps	(%rax), %xmm2
# CHECK-NEXT:  3      6     2.00                        hsubpd	%xmm0, %xmm2
# CHECK-NEXT:  4      12    2.00    *                   hsubpd	(%rax), %xmm2
# CHECK-NEXT:  3      6     2.00                        hsubps	%xmm0, %xmm2
# CHECK-NEXT:  4      12    2.00    *                   hsubps	(%rax), %xmm2
# CHECK-NEXT:  1      7     0.33    *                   lddqu	(%rax), %xmm2
# CHECK-NEXT:  1      100   0.25                  U     monitor
# CHECK-NEXT:  1      1     1.00                        movddup	%xmm0, %xmm2
# CHECK-NEXT:  1      7     0.33    *                   movddup	(%rax), %xmm2
# CHECK-NEXT:  1      1     0.50                        movshdup	%xmm0, %xmm2
# CHECK-NEXT:  1      7     0.33    *                   movshdup	(%rax), %xmm2
# CHECK-NEXT:  1      1     0.50                        movsldup	%xmm0, %xmm2
# CHECK-NEXT:  1      7     0.33    *                   movsldup	(%rax), %xmm2
# CHECK-NEXT:  10     20    2.50    *      *      U     mwait

# CHECK:      Resources:
# CHECK-NEXT: [0]   - SPRPort00
# CHECK-NEXT: [1]   - SPRPort01
# CHECK-NEXT: [2]   - SPRPort02
# CHECK-NEXT: [3]   - SPRPort03
# CHECK-NEXT: [4]   - SPRPort04
# CHECK-NEXT: [5]   - SPRPort05
# CHECK-NEXT: [6]   - SPRPort06
# CHECK-NEXT: [7]   - SPRPort07
# CHECK-NEXT: [8]   - SPRPort08
# CHECK-NEXT: [9]   - SPRPort09
# CHECK-NEXT: [10]  - SPRPort10
# CHECK-NEXT: [11]  - SPRPort11
# CHECK-NEXT: [12]  - SPRPortInvalid

# CHECK:      Resource pressure per iteration:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]    [9]    [10]   [11]   [12]
# CHECK-NEXT: 2.00   9.00   3.33   3.33    -     27.00  4.00    -      -      -      -     3.33    -

# CHECK:      Resource pressure by instruction:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]    [9]    [10]   [11]   [12]   Instructions:
# CHECK-NEXT:  -     0.50    -      -      -     0.50    -      -      -      -      -      -      -     addsubpd	%xmm0, %xmm2
# CHECK-NEXT:  -     0.50   0.33   0.33    -     0.50    -      -      -      -      -     0.33    -     addsubpd	(%rax), %xmm2
# CHECK-NEXT:  -     0.50    -      -      -     0.50    -      -      -      -      -      -      -     addsubps	%xmm0, %xmm2
# CHECK-NEXT:  -     0.50   0.33   0.33    -     0.50    -      -      -      -      -     0.33    -     addsubps	(%rax), %xmm2
# CHECK-NEXT:  -     0.50    -      -      -     2.50    -      -      -      -      -      -      -     haddpd	%xmm0, %xmm2
# CHECK-NEXT:  -     0.50   0.33   0.33    -     2.50    -      -      -      -      -     0.33    -     haddpd	(%rax), %xmm2
# CHECK-NEXT:  -     0.50    -      -      -     2.50    -      -      -      -      -      -      -     haddps	%xmm0, %xmm2
# CHECK-NEXT:  -     0.50   0.33   0.33    -     2.50    -      -      -      -      -     0.33    -     haddps	(%rax), %xmm2
# CHECK-NEXT:  -     0.50    -      -      -     2.50    -      -      -      -      -      -      -     hsubpd	%xmm0, %xmm2
# CHECK-NEXT:  -     0.50   0.33   0.33    -     2.50    -      -      -      -      -     0.33    -     hsubpd	(%rax), %xmm2
# CHECK-NEXT:  -     0.50    -      -      -     2.50    -      -      -      -      -      -      -     hsubps	%xmm0, %xmm2
# CHECK-NEXT:  -     0.50   0.33   0.33    -     2.50    -      -      -      -      -     0.33    -     hsubps	(%rax), %xmm2
# CHECK-NEXT:  -      -     0.33   0.33    -      -      -      -      -      -      -     0.33    -     lddqu	(%rax), %xmm2
# CHECK-NEXT: 0.25   0.25    -      -      -     0.25   0.25    -      -      -      -      -      -     monitor
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -      -      -      -      -      -     movddup	%xmm0, %xmm2
# CHECK-NEXT:  -      -     0.33   0.33    -      -      -      -      -      -      -     0.33    -     movddup	(%rax), %xmm2
# CHECK-NEXT:  -     0.50    -      -      -     0.50    -      -      -      -      -      -      -     movshdup	%xmm0, %xmm2
# CHECK-NEXT:  -      -     0.33   0.33    -      -      -      -      -      -      -     0.33    -     movshdup	(%rax), %xmm2
# CHECK-NEXT:  -     0.50    -      -      -     0.50    -      -      -      -      -      -      -     movsldup	%xmm0, %xmm2
# CHECK-NEXT:  -      -     0.33   0.33    -      -      -      -      -      -      -     0.33    -     movsldup	(%rax), %xmm2
# CHECK-NEXT: 1.75   1.75    -      -      -     2.75   3.75    -      -      -      -      -      -     mwait
