; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -passes=ipsccp -S < %s | FileCheck %s
;
;    #include <pthread.h>
;
;    ptr GlobalVPtr;
;
;    static ptr foo(ptr arg) { return arg; }
;    static ptr bar(ptr arg) { return arg; }
;
;    int main() {
;      pthread_t thread;
;      pthread_create(&thread, NULL, foo, NULL);
;      pthread_create(&thread, NULL, bar, &GlobalVPtr);
;      return 0;
;    }
;
; Verify the constant values NULL and &GlobalVPtr are propagated into foo and
; bar, respectively.
;
target datalayout = "e-m:e-i64:64-f80:128-n8:16:32:64-S128"

%union.pthread_attr_t = type { i64, [48 x i8] }

@GlobalVPtr = common dso_local global ptr null, align 8

define dso_local i32 @main() {
; CHECK-LABEL: @main(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[THREAD:%.*]] = alloca i64, align 8
; CHECK-NEXT:    [[CALL:%.*]] = call i32 @pthread_create(ptr nonnull [[THREAD]], ptr null, ptr nonnull @foo, ptr null)
; CHECK-NEXT:    [[CALL1:%.*]] = call i32 @pthread_create(ptr nonnull [[THREAD]], ptr null, ptr nonnull @bar, ptr @GlobalVPtr)
; CHECK-NEXT:    ret i32 0
;
entry:
  %thread = alloca i64, align 8
  %call = call i32 @pthread_create(ptr nonnull %thread, ptr null, ptr nonnull @foo, ptr null)
  %call1 = call i32 @pthread_create(ptr nonnull %thread, ptr null, ptr nonnull @bar, ptr @GlobalVPtr)
  ret i32 0
}

declare !callback !0 dso_local i32 @pthread_create(ptr, ptr, ptr, ptr)

define internal ptr @foo(ptr %arg) {
; CHECK-LABEL: @foo(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    ret ptr [[ARG:%.*]]
;
entry:
  ret ptr %arg
}

define internal ptr @bar(ptr %arg) {
; CHECK-LABEL: @bar(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    ret ptr [[ARG:%.*]]
;
entry:
  ret ptr %arg
}

!1 = !{i64 2, i64 3, i1 false}
!0 = !{!1}
