; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 3
; RUN: opt -S -expand-memcmp -memcmp-num-loads-per-block=1 -mtriple=aarch64-unknown-unknown < %s | FileCheck %s
; RUN: opt -S -passes=expand-memcmp -memcmp-num-loads-per-block=1 -mtriple=aarch64-unknown-unknown < %s | FileCheck %s

declare i32 @memcmp(ptr nocapture, ptr nocapture, i64)

define i32 @cmp2(ptr nocapture readonly %x, ptr nocapture readonly %y)  {
; CHECK-LABEL: define i32 @cmp2(
; CHECK-SAME: ptr nocapture readonly [[X:%.*]], ptr nocapture readonly [[Y:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = load i16, ptr [[X]], align 1
; CHECK-NEXT:    [[TMP2:%.*]] = load i16, ptr [[Y]], align 1
; CHECK-NEXT:    [[TMP3:%.*]] = call i16 @llvm.bswap.i16(i16 [[TMP1]])
; CHECK-NEXT:    [[TMP4:%.*]] = call i16 @llvm.bswap.i16(i16 [[TMP2]])
; CHECK-NEXT:    [[TMP5:%.*]] = zext i16 [[TMP3]] to i32
; CHECK-NEXT:    [[TMP6:%.*]] = zext i16 [[TMP4]] to i32
; CHECK-NEXT:    [[TMP7:%.*]] = sub i32 [[TMP5]], [[TMP6]]
; CHECK-NEXT:    ret i32 [[TMP7]]
;
  %call = tail call i32 @memcmp(ptr %x, ptr %y, i64 2)
  ret i32 %call
}

define i32 @cmp2_align2(ptr nocapture readonly align 2 %x, ptr nocapture readonly align 2 %y)  {
; CHECK-LABEL: define i32 @cmp2_align2(
; CHECK-SAME: ptr nocapture readonly align 2 [[X:%.*]], ptr nocapture readonly align 2 [[Y:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = load i16, ptr [[X]], align 2
; CHECK-NEXT:    [[TMP2:%.*]] = load i16, ptr [[Y]], align 2
; CHECK-NEXT:    [[TMP3:%.*]] = call i16 @llvm.bswap.i16(i16 [[TMP1]])
; CHECK-NEXT:    [[TMP4:%.*]] = call i16 @llvm.bswap.i16(i16 [[TMP2]])
; CHECK-NEXT:    [[TMP5:%.*]] = zext i16 [[TMP3]] to i32
; CHECK-NEXT:    [[TMP6:%.*]] = zext i16 [[TMP4]] to i32
; CHECK-NEXT:    [[TMP7:%.*]] = sub i32 [[TMP5]], [[TMP6]]
; CHECK-NEXT:    ret i32 [[TMP7]]
;
  %call = tail call i32 @memcmp(ptr %x, ptr %y, i64 2)
  ret i32 %call
}

define i32 @cmp3(ptr nocapture readonly %x, ptr nocapture readonly %y)  {
; CHECK-LABEL: define i32 @cmp3(
; CHECK-SAME: ptr nocapture readonly [[X:%.*]], ptr nocapture readonly [[Y:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = load i24, ptr [[X]], align 1
; CHECK-NEXT:    [[TMP2:%.*]] = load i24, ptr [[Y]], align 1
; CHECK-NEXT:    [[TMP3:%.*]] = zext i24 [[TMP1]] to i32
; CHECK-NEXT:    [[TMP4:%.*]] = zext i24 [[TMP2]] to i32
; CHECK-NEXT:    [[TMP5:%.*]] = call i32 @llvm.bswap.i32(i32 [[TMP3]])
; CHECK-NEXT:    [[TMP6:%.*]] = call i32 @llvm.bswap.i32(i32 [[TMP4]])
; CHECK-NEXT:    [[TMP7:%.*]] = icmp ugt i32 [[TMP5]], [[TMP6]]
; CHECK-NEXT:    [[TMP8:%.*]] = icmp ult i32 [[TMP5]], [[TMP6]]
; CHECK-NEXT:    [[TMP9:%.*]] = zext i1 [[TMP7]] to i32
; CHECK-NEXT:    [[TMP10:%.*]] = zext i1 [[TMP8]] to i32
; CHECK-NEXT:    [[TMP11:%.*]] = sub i32 [[TMP9]], [[TMP10]]
; CHECK-NEXT:    ret i32 [[TMP11]]
;
  %call = tail call i32 @memcmp(ptr %x, ptr %y, i64 3)
  ret i32 %call
}

define i32 @cmp4(ptr nocapture readonly %x, ptr nocapture readonly %y)  {
; CHECK-LABEL: define i32 @cmp4(
; CHECK-SAME: ptr nocapture readonly [[X:%.*]], ptr nocapture readonly [[Y:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = load i32, ptr [[X]], align 1
; CHECK-NEXT:    [[TMP2:%.*]] = load i32, ptr [[Y]], align 1
; CHECK-NEXT:    [[TMP3:%.*]] = call i32 @llvm.bswap.i32(i32 [[TMP1]])
; CHECK-NEXT:    [[TMP4:%.*]] = call i32 @llvm.bswap.i32(i32 [[TMP2]])
; CHECK-NEXT:    [[TMP5:%.*]] = icmp ugt i32 [[TMP3]], [[TMP4]]
; CHECK-NEXT:    [[TMP6:%.*]] = icmp ult i32 [[TMP3]], [[TMP4]]
; CHECK-NEXT:    [[TMP7:%.*]] = zext i1 [[TMP5]] to i32
; CHECK-NEXT:    [[TMP8:%.*]] = zext i1 [[TMP6]] to i32
; CHECK-NEXT:    [[TMP9:%.*]] = sub i32 [[TMP7]], [[TMP8]]
; CHECK-NEXT:    ret i32 [[TMP9]]
;
  %call = tail call i32 @memcmp(ptr %x, ptr %y, i64 4)
  ret i32 %call
}

define i32 @cmp5(ptr nocapture readonly %x, ptr nocapture readonly %y)  {
; CHECK-LABEL: define i32 @cmp5(
; CHECK-SAME: ptr nocapture readonly [[X:%.*]], ptr nocapture readonly [[Y:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = load i40, ptr [[X]], align 1
; CHECK-NEXT:    [[TMP2:%.*]] = load i40, ptr [[Y]], align 1
; CHECK-NEXT:    [[TMP3:%.*]] = zext i40 [[TMP1]] to i64
; CHECK-NEXT:    [[TMP4:%.*]] = zext i40 [[TMP2]] to i64
; CHECK-NEXT:    [[TMP5:%.*]] = call i64 @llvm.bswap.i64(i64 [[TMP3]])
; CHECK-NEXT:    [[TMP6:%.*]] = call i64 @llvm.bswap.i64(i64 [[TMP4]])
; CHECK-NEXT:    [[TMP7:%.*]] = icmp ugt i64 [[TMP5]], [[TMP6]]
; CHECK-NEXT:    [[TMP8:%.*]] = icmp ult i64 [[TMP5]], [[TMP6]]
; CHECK-NEXT:    [[TMP9:%.*]] = zext i1 [[TMP7]] to i32
; CHECK-NEXT:    [[TMP10:%.*]] = zext i1 [[TMP8]] to i32
; CHECK-NEXT:    [[TMP11:%.*]] = sub i32 [[TMP9]], [[TMP10]]
; CHECK-NEXT:    ret i32 [[TMP11]]
;
  %call = tail call i32 @memcmp(ptr %x, ptr %y, i64 5)
  ret i32 %call
}

define i32 @cmp6(ptr nocapture readonly %x, ptr nocapture readonly %y)  {
; CHECK-LABEL: define i32 @cmp6(
; CHECK-SAME: ptr nocapture readonly [[X:%.*]], ptr nocapture readonly [[Y:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = load i48, ptr [[X]], align 1
; CHECK-NEXT:    [[TMP2:%.*]] = load i48, ptr [[Y]], align 1
; CHECK-NEXT:    [[TMP3:%.*]] = zext i48 [[TMP1]] to i64
; CHECK-NEXT:    [[TMP4:%.*]] = zext i48 [[TMP2]] to i64
; CHECK-NEXT:    [[TMP5:%.*]] = call i64 @llvm.bswap.i64(i64 [[TMP3]])
; CHECK-NEXT:    [[TMP6:%.*]] = call i64 @llvm.bswap.i64(i64 [[TMP4]])
; CHECK-NEXT:    [[TMP7:%.*]] = icmp ugt i64 [[TMP5]], [[TMP6]]
; CHECK-NEXT:    [[TMP8:%.*]] = icmp ult i64 [[TMP5]], [[TMP6]]
; CHECK-NEXT:    [[TMP9:%.*]] = zext i1 [[TMP7]] to i32
; CHECK-NEXT:    [[TMP10:%.*]] = zext i1 [[TMP8]] to i32
; CHECK-NEXT:    [[TMP11:%.*]] = sub i32 [[TMP9]], [[TMP10]]
; CHECK-NEXT:    ret i32 [[TMP11]]
;
  %call = tail call i32 @memcmp(ptr %x, ptr %y, i64 6)
  ret i32 %call
}

define i32 @cmp7(ptr nocapture readonly %x, ptr nocapture readonly %y)  {
; CHECK-LABEL: define i32 @cmp7(
; CHECK-SAME: ptr nocapture readonly [[X:%.*]], ptr nocapture readonly [[Y:%.*]]) {
; CHECK-NEXT:    br label [[LOADBB:%.*]]
; CHECK:       res_block:
; CHECK-NEXT:    [[PHI_SRC1:%.*]] = phi i32 [ [[TMP5:%.*]], [[LOADBB]] ], [ [[TMP12:%.*]], [[LOADBB1:%.*]] ]
; CHECK-NEXT:    [[PHI_SRC2:%.*]] = phi i32 [ [[TMP6:%.*]], [[LOADBB]] ], [ [[TMP13:%.*]], [[LOADBB1]] ]
; CHECK-NEXT:    [[TMP1:%.*]] = icmp ult i32 [[PHI_SRC1]], [[PHI_SRC2]]
; CHECK-NEXT:    [[TMP2:%.*]] = select i1 [[TMP1]], i32 -1, i32 1
; CHECK-NEXT:    br label [[ENDBLOCK:%.*]]
; CHECK:       loadbb:
; CHECK-NEXT:    [[TMP3:%.*]] = load i32, ptr [[X]], align 1
; CHECK-NEXT:    [[TMP4:%.*]] = load i32, ptr [[Y]], align 1
; CHECK-NEXT:    [[TMP5]] = call i32 @llvm.bswap.i32(i32 [[TMP3]])
; CHECK-NEXT:    [[TMP6]] = call i32 @llvm.bswap.i32(i32 [[TMP4]])
; CHECK-NEXT:    [[TMP7:%.*]] = icmp eq i32 [[TMP5]], [[TMP6]]
; CHECK-NEXT:    br i1 [[TMP7]], label [[LOADBB1]], label [[RES_BLOCK:%.*]]
; CHECK:       loadbb1:
; CHECK-NEXT:    [[TMP8:%.*]] = getelementptr i8, ptr [[X]], i64 3
; CHECK-NEXT:    [[TMP9:%.*]] = getelementptr i8, ptr [[Y]], i64 3
; CHECK-NEXT:    [[TMP10:%.*]] = load i32, ptr [[TMP8]], align 1
; CHECK-NEXT:    [[TMP11:%.*]] = load i32, ptr [[TMP9]], align 1
; CHECK-NEXT:    [[TMP12]] = call i32 @llvm.bswap.i32(i32 [[TMP10]])
; CHECK-NEXT:    [[TMP13]] = call i32 @llvm.bswap.i32(i32 [[TMP11]])
; CHECK-NEXT:    [[TMP14:%.*]] = icmp eq i32 [[TMP12]], [[TMP13]]
; CHECK-NEXT:    br i1 [[TMP14]], label [[ENDBLOCK]], label [[RES_BLOCK]]
; CHECK:       endblock:
; CHECK-NEXT:    [[PHI_RES:%.*]] = phi i32 [ 0, [[LOADBB1]] ], [ [[TMP2]], [[RES_BLOCK]] ]
; CHECK-NEXT:    ret i32 [[PHI_RES]]
;
  %call = tail call i32 @memcmp(ptr %x, ptr %y, i64 7)
  ret i32 %call
}

define i32 @cmp8(ptr nocapture readonly %x, ptr nocapture readonly %y)  {
; CHECK-LABEL: define i32 @cmp8(
; CHECK-SAME: ptr nocapture readonly [[X:%.*]], ptr nocapture readonly [[Y:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = load i64, ptr [[X]], align 1
; CHECK-NEXT:    [[TMP2:%.*]] = load i64, ptr [[Y]], align 1
; CHECK-NEXT:    [[TMP3:%.*]] = call i64 @llvm.bswap.i64(i64 [[TMP1]])
; CHECK-NEXT:    [[TMP4:%.*]] = call i64 @llvm.bswap.i64(i64 [[TMP2]])
; CHECK-NEXT:    [[TMP5:%.*]] = icmp ugt i64 [[TMP3]], [[TMP4]]
; CHECK-NEXT:    [[TMP6:%.*]] = icmp ult i64 [[TMP3]], [[TMP4]]
; CHECK-NEXT:    [[TMP7:%.*]] = zext i1 [[TMP5]] to i32
; CHECK-NEXT:    [[TMP8:%.*]] = zext i1 [[TMP6]] to i32
; CHECK-NEXT:    [[TMP9:%.*]] = sub i32 [[TMP7]], [[TMP8]]
; CHECK-NEXT:    ret i32 [[TMP9]]
;
  %call = tail call i32 @memcmp(ptr %x, ptr %y, i64 8)
  ret i32 %call
}

define i32 @cmp9(ptr nocapture readonly %x, ptr nocapture readonly %y)  {
; CHECK-LABEL: define i32 @cmp9(
; CHECK-SAME: ptr nocapture readonly [[X:%.*]], ptr nocapture readonly [[Y:%.*]]) {
; CHECK-NEXT:    br label [[LOADBB:%.*]]
; CHECK:       res_block:
; CHECK-NEXT:    [[TMP1:%.*]] = icmp ult i64 [[TMP5:%.*]], [[TMP6:%.*]]
; CHECK-NEXT:    [[TMP2:%.*]] = select i1 [[TMP1]], i32 -1, i32 1
; CHECK-NEXT:    br label [[ENDBLOCK:%.*]]
; CHECK:       loadbb:
; CHECK-NEXT:    [[TMP3:%.*]] = load i64, ptr [[X]], align 1
; CHECK-NEXT:    [[TMP4:%.*]] = load i64, ptr [[Y]], align 1
; CHECK-NEXT:    [[TMP5]] = call i64 @llvm.bswap.i64(i64 [[TMP3]])
; CHECK-NEXT:    [[TMP6]] = call i64 @llvm.bswap.i64(i64 [[TMP4]])
; CHECK-NEXT:    [[TMP7:%.*]] = icmp eq i64 [[TMP5]], [[TMP6]]
; CHECK-NEXT:    br i1 [[TMP7]], label [[LOADBB1:%.*]], label [[RES_BLOCK:%.*]]
; CHECK:       loadbb1:
; CHECK-NEXT:    [[TMP8:%.*]] = getelementptr i8, ptr [[X]], i64 8
; CHECK-NEXT:    [[TMP9:%.*]] = getelementptr i8, ptr [[Y]], i64 8
; CHECK-NEXT:    [[TMP10:%.*]] = load i8, ptr [[TMP8]], align 1
; CHECK-NEXT:    [[TMP11:%.*]] = load i8, ptr [[TMP9]], align 1
; CHECK-NEXT:    [[TMP12:%.*]] = zext i8 [[TMP10]] to i32
; CHECK-NEXT:    [[TMP13:%.*]] = zext i8 [[TMP11]] to i32
; CHECK-NEXT:    [[TMP14:%.*]] = sub i32 [[TMP12]], [[TMP13]]
; CHECK-NEXT:    br label [[ENDBLOCK]]
; CHECK:       endblock:
; CHECK-NEXT:    [[PHI_RES:%.*]] = phi i32 [ [[TMP14]], [[LOADBB1]] ], [ [[TMP2]], [[RES_BLOCK]] ]
; CHECK-NEXT:    ret i32 [[PHI_RES]]
;
  %call = tail call i32 @memcmp(ptr %x, ptr %y, i64 9)
  ret i32 %call
}

define i32 @cmp10(ptr nocapture readonly %x, ptr nocapture readonly %y)  {
; CHECK-LABEL: define i32 @cmp10(
; CHECK-SAME: ptr nocapture readonly [[X:%.*]], ptr nocapture readonly [[Y:%.*]]) {
; CHECK-NEXT:    br label [[LOADBB:%.*]]
; CHECK:       res_block:
; CHECK-NEXT:    [[PHI_SRC1:%.*]] = phi i64 [ [[TMP5:%.*]], [[LOADBB]] ], [ [[TMP14:%.*]], [[LOADBB1:%.*]] ]
; CHECK-NEXT:    [[PHI_SRC2:%.*]] = phi i64 [ [[TMP6:%.*]], [[LOADBB]] ], [ [[TMP15:%.*]], [[LOADBB1]] ]
; CHECK-NEXT:    [[TMP1:%.*]] = icmp ult i64 [[PHI_SRC1]], [[PHI_SRC2]]
; CHECK-NEXT:    [[TMP2:%.*]] = select i1 [[TMP1]], i32 -1, i32 1
; CHECK-NEXT:    br label [[ENDBLOCK:%.*]]
; CHECK:       loadbb:
; CHECK-NEXT:    [[TMP3:%.*]] = load i64, ptr [[X]], align 1
; CHECK-NEXT:    [[TMP4:%.*]] = load i64, ptr [[Y]], align 1
; CHECK-NEXT:    [[TMP5]] = call i64 @llvm.bswap.i64(i64 [[TMP3]])
; CHECK-NEXT:    [[TMP6]] = call i64 @llvm.bswap.i64(i64 [[TMP4]])
; CHECK-NEXT:    [[TMP7:%.*]] = icmp eq i64 [[TMP5]], [[TMP6]]
; CHECK-NEXT:    br i1 [[TMP7]], label [[LOADBB1]], label [[RES_BLOCK:%.*]]
; CHECK:       loadbb1:
; CHECK-NEXT:    [[TMP8:%.*]] = getelementptr i8, ptr [[X]], i64 8
; CHECK-NEXT:    [[TMP9:%.*]] = getelementptr i8, ptr [[Y]], i64 8
; CHECK-NEXT:    [[TMP10:%.*]] = load i16, ptr [[TMP8]], align 1
; CHECK-NEXT:    [[TMP11:%.*]] = load i16, ptr [[TMP9]], align 1
; CHECK-NEXT:    [[TMP12:%.*]] = call i16 @llvm.bswap.i16(i16 [[TMP10]])
; CHECK-NEXT:    [[TMP13:%.*]] = call i16 @llvm.bswap.i16(i16 [[TMP11]])
; CHECK-NEXT:    [[TMP14]] = zext i16 [[TMP12]] to i64
; CHECK-NEXT:    [[TMP15]] = zext i16 [[TMP13]] to i64
; CHECK-NEXT:    [[TMP16:%.*]] = icmp eq i64 [[TMP14]], [[TMP15]]
; CHECK-NEXT:    br i1 [[TMP16]], label [[ENDBLOCK]], label [[RES_BLOCK]]
; CHECK:       endblock:
; CHECK-NEXT:    [[PHI_RES:%.*]] = phi i32 [ 0, [[LOADBB1]] ], [ [[TMP2]], [[RES_BLOCK]] ]
; CHECK-NEXT:    ret i32 [[PHI_RES]]
;
  %call = tail call i32 @memcmp(ptr %x, ptr %y, i64 10)
  ret i32 %call
}

define i32 @cmp11(ptr nocapture readonly %x, ptr nocapture readonly %y)  {
; CHECK-LABEL: define i32 @cmp11(
; CHECK-SAME: ptr nocapture readonly [[X:%.*]], ptr nocapture readonly [[Y:%.*]]) {
; CHECK-NEXT:    br label [[LOADBB:%.*]]
; CHECK:       res_block:
; CHECK-NEXT:    [[PHI_SRC1:%.*]] = phi i64 [ [[TMP5:%.*]], [[LOADBB]] ], [ [[TMP12:%.*]], [[LOADBB1:%.*]] ]
; CHECK-NEXT:    [[PHI_SRC2:%.*]] = phi i64 [ [[TMP6:%.*]], [[LOADBB]] ], [ [[TMP13:%.*]], [[LOADBB1]] ]
; CHECK-NEXT:    [[TMP1:%.*]] = icmp ult i64 [[PHI_SRC1]], [[PHI_SRC2]]
; CHECK-NEXT:    [[TMP2:%.*]] = select i1 [[TMP1]], i32 -1, i32 1
; CHECK-NEXT:    br label [[ENDBLOCK:%.*]]
; CHECK:       loadbb:
; CHECK-NEXT:    [[TMP3:%.*]] = load i64, ptr [[X]], align 1
; CHECK-NEXT:    [[TMP4:%.*]] = load i64, ptr [[Y]], align 1
; CHECK-NEXT:    [[TMP5]] = call i64 @llvm.bswap.i64(i64 [[TMP3]])
; CHECK-NEXT:    [[TMP6]] = call i64 @llvm.bswap.i64(i64 [[TMP4]])
; CHECK-NEXT:    [[TMP7:%.*]] = icmp eq i64 [[TMP5]], [[TMP6]]
; CHECK-NEXT:    br i1 [[TMP7]], label [[LOADBB1]], label [[RES_BLOCK:%.*]]
; CHECK:       loadbb1:
; CHECK-NEXT:    [[TMP8:%.*]] = getelementptr i8, ptr [[X]], i64 3
; CHECK-NEXT:    [[TMP9:%.*]] = getelementptr i8, ptr [[Y]], i64 3
; CHECK-NEXT:    [[TMP10:%.*]] = load i64, ptr [[TMP8]], align 1
; CHECK-NEXT:    [[TMP11:%.*]] = load i64, ptr [[TMP9]], align 1
; CHECK-NEXT:    [[TMP12]] = call i64 @llvm.bswap.i64(i64 [[TMP10]])
; CHECK-NEXT:    [[TMP13]] = call i64 @llvm.bswap.i64(i64 [[TMP11]])
; CHECK-NEXT:    [[TMP14:%.*]] = icmp eq i64 [[TMP12]], [[TMP13]]
; CHECK-NEXT:    br i1 [[TMP14]], label [[ENDBLOCK]], label [[RES_BLOCK]]
; CHECK:       endblock:
; CHECK-NEXT:    [[PHI_RES:%.*]] = phi i32 [ 0, [[LOADBB1]] ], [ [[TMP2]], [[RES_BLOCK]] ]
; CHECK-NEXT:    ret i32 [[PHI_RES]]
;
  %call = tail call i32 @memcmp(ptr %x, ptr %y, i64 11)
  ret i32 %call
}

define i32 @cmp12(ptr nocapture readonly %x, ptr nocapture readonly %y)  {
; CHECK-LABEL: define i32 @cmp12(
; CHECK-SAME: ptr nocapture readonly [[X:%.*]], ptr nocapture readonly [[Y:%.*]]) {
; CHECK-NEXT:    br label [[LOADBB:%.*]]
; CHECK:       res_block:
; CHECK-NEXT:    [[PHI_SRC1:%.*]] = phi i64 [ [[TMP5:%.*]], [[LOADBB]] ], [ [[TMP14:%.*]], [[LOADBB1:%.*]] ]
; CHECK-NEXT:    [[PHI_SRC2:%.*]] = phi i64 [ [[TMP6:%.*]], [[LOADBB]] ], [ [[TMP15:%.*]], [[LOADBB1]] ]
; CHECK-NEXT:    [[TMP1:%.*]] = icmp ult i64 [[PHI_SRC1]], [[PHI_SRC2]]
; CHECK-NEXT:    [[TMP2:%.*]] = select i1 [[TMP1]], i32 -1, i32 1
; CHECK-NEXT:    br label [[ENDBLOCK:%.*]]
; CHECK:       loadbb:
; CHECK-NEXT:    [[TMP3:%.*]] = load i64, ptr [[X]], align 1
; CHECK-NEXT:    [[TMP4:%.*]] = load i64, ptr [[Y]], align 1
; CHECK-NEXT:    [[TMP5]] = call i64 @llvm.bswap.i64(i64 [[TMP3]])
; CHECK-NEXT:    [[TMP6]] = call i64 @llvm.bswap.i64(i64 [[TMP4]])
; CHECK-NEXT:    [[TMP7:%.*]] = icmp eq i64 [[TMP5]], [[TMP6]]
; CHECK-NEXT:    br i1 [[TMP7]], label [[LOADBB1]], label [[RES_BLOCK:%.*]]
; CHECK:       loadbb1:
; CHECK-NEXT:    [[TMP8:%.*]] = getelementptr i8, ptr [[X]], i64 8
; CHECK-NEXT:    [[TMP9:%.*]] = getelementptr i8, ptr [[Y]], i64 8
; CHECK-NEXT:    [[TMP10:%.*]] = load i32, ptr [[TMP8]], align 1
; CHECK-NEXT:    [[TMP11:%.*]] = load i32, ptr [[TMP9]], align 1
; CHECK-NEXT:    [[TMP12:%.*]] = call i32 @llvm.bswap.i32(i32 [[TMP10]])
; CHECK-NEXT:    [[TMP13:%.*]] = call i32 @llvm.bswap.i32(i32 [[TMP11]])
; CHECK-NEXT:    [[TMP14]] = zext i32 [[TMP12]] to i64
; CHECK-NEXT:    [[TMP15]] = zext i32 [[TMP13]] to i64
; CHECK-NEXT:    [[TMP16:%.*]] = icmp eq i64 [[TMP14]], [[TMP15]]
; CHECK-NEXT:    br i1 [[TMP16]], label [[ENDBLOCK]], label [[RES_BLOCK]]
; CHECK:       endblock:
; CHECK-NEXT:    [[PHI_RES:%.*]] = phi i32 [ 0, [[LOADBB1]] ], [ [[TMP2]], [[RES_BLOCK]] ]
; CHECK-NEXT:    ret i32 [[PHI_RES]]
;
  %call = tail call i32 @memcmp(ptr %x, ptr %y, i64 12)
  ret i32 %call
}

define i32 @cmp13(ptr nocapture readonly %x, ptr nocapture readonly %y)  {
; CHECK-LABEL: define i32 @cmp13(
; CHECK-SAME: ptr nocapture readonly [[X:%.*]], ptr nocapture readonly [[Y:%.*]]) {
; CHECK-NEXT:    br label [[LOADBB:%.*]]
; CHECK:       res_block:
; CHECK-NEXT:    [[PHI_SRC1:%.*]] = phi i64 [ [[TMP5:%.*]], [[LOADBB]] ], [ [[TMP12:%.*]], [[LOADBB1:%.*]] ]
; CHECK-NEXT:    [[PHI_SRC2:%.*]] = phi i64 [ [[TMP6:%.*]], [[LOADBB]] ], [ [[TMP13:%.*]], [[LOADBB1]] ]
; CHECK-NEXT:    [[TMP1:%.*]] = icmp ult i64 [[PHI_SRC1]], [[PHI_SRC2]]
; CHECK-NEXT:    [[TMP2:%.*]] = select i1 [[TMP1]], i32 -1, i32 1
; CHECK-NEXT:    br label [[ENDBLOCK:%.*]]
; CHECK:       loadbb:
; CHECK-NEXT:    [[TMP3:%.*]] = load i64, ptr [[X]], align 1
; CHECK-NEXT:    [[TMP4:%.*]] = load i64, ptr [[Y]], align 1
; CHECK-NEXT:    [[TMP5]] = call i64 @llvm.bswap.i64(i64 [[TMP3]])
; CHECK-NEXT:    [[TMP6]] = call i64 @llvm.bswap.i64(i64 [[TMP4]])
; CHECK-NEXT:    [[TMP7:%.*]] = icmp eq i64 [[TMP5]], [[TMP6]]
; CHECK-NEXT:    br i1 [[TMP7]], label [[LOADBB1]], label [[RES_BLOCK:%.*]]
; CHECK:       loadbb1:
; CHECK-NEXT:    [[TMP8:%.*]] = getelementptr i8, ptr [[X]], i64 5
; CHECK-NEXT:    [[TMP9:%.*]] = getelementptr i8, ptr [[Y]], i64 5
; CHECK-NEXT:    [[TMP10:%.*]] = load i64, ptr [[TMP8]], align 1
; CHECK-NEXT:    [[TMP11:%.*]] = load i64, ptr [[TMP9]], align 1
; CHECK-NEXT:    [[TMP12]] = call i64 @llvm.bswap.i64(i64 [[TMP10]])
; CHECK-NEXT:    [[TMP13]] = call i64 @llvm.bswap.i64(i64 [[TMP11]])
; CHECK-NEXT:    [[TMP14:%.*]] = icmp eq i64 [[TMP12]], [[TMP13]]
; CHECK-NEXT:    br i1 [[TMP14]], label [[ENDBLOCK]], label [[RES_BLOCK]]
; CHECK:       endblock:
; CHECK-NEXT:    [[PHI_RES:%.*]] = phi i32 [ 0, [[LOADBB1]] ], [ [[TMP2]], [[RES_BLOCK]] ]
; CHECK-NEXT:    ret i32 [[PHI_RES]]
;
  %call = tail call i32 @memcmp(ptr %x, ptr %y, i64 13)
  ret i32 %call
}

define i32 @cmp14(ptr nocapture readonly %x, ptr nocapture readonly %y)  {
; CHECK-LABEL: define i32 @cmp14(
; CHECK-SAME: ptr nocapture readonly [[X:%.*]], ptr nocapture readonly [[Y:%.*]]) {
; CHECK-NEXT:    br label [[LOADBB:%.*]]
; CHECK:       res_block:
; CHECK-NEXT:    [[PHI_SRC1:%.*]] = phi i64 [ [[TMP5:%.*]], [[LOADBB]] ], [ [[TMP12:%.*]], [[LOADBB1:%.*]] ]
; CHECK-NEXT:    [[PHI_SRC2:%.*]] = phi i64 [ [[TMP6:%.*]], [[LOADBB]] ], [ [[TMP13:%.*]], [[LOADBB1]] ]
; CHECK-NEXT:    [[TMP1:%.*]] = icmp ult i64 [[PHI_SRC1]], [[PHI_SRC2]]
; CHECK-NEXT:    [[TMP2:%.*]] = select i1 [[TMP1]], i32 -1, i32 1
; CHECK-NEXT:    br label [[ENDBLOCK:%.*]]
; CHECK:       loadbb:
; CHECK-NEXT:    [[TMP3:%.*]] = load i64, ptr [[X]], align 1
; CHECK-NEXT:    [[TMP4:%.*]] = load i64, ptr [[Y]], align 1
; CHECK-NEXT:    [[TMP5]] = call i64 @llvm.bswap.i64(i64 [[TMP3]])
; CHECK-NEXT:    [[TMP6]] = call i64 @llvm.bswap.i64(i64 [[TMP4]])
; CHECK-NEXT:    [[TMP7:%.*]] = icmp eq i64 [[TMP5]], [[TMP6]]
; CHECK-NEXT:    br i1 [[TMP7]], label [[LOADBB1]], label [[RES_BLOCK:%.*]]
; CHECK:       loadbb1:
; CHECK-NEXT:    [[TMP8:%.*]] = getelementptr i8, ptr [[X]], i64 6
; CHECK-NEXT:    [[TMP9:%.*]] = getelementptr i8, ptr [[Y]], i64 6
; CHECK-NEXT:    [[TMP10:%.*]] = load i64, ptr [[TMP8]], align 1
; CHECK-NEXT:    [[TMP11:%.*]] = load i64, ptr [[TMP9]], align 1
; CHECK-NEXT:    [[TMP12]] = call i64 @llvm.bswap.i64(i64 [[TMP10]])
; CHECK-NEXT:    [[TMP13]] = call i64 @llvm.bswap.i64(i64 [[TMP11]])
; CHECK-NEXT:    [[TMP14:%.*]] = icmp eq i64 [[TMP12]], [[TMP13]]
; CHECK-NEXT:    br i1 [[TMP14]], label [[ENDBLOCK]], label [[RES_BLOCK]]
; CHECK:       endblock:
; CHECK-NEXT:    [[PHI_RES:%.*]] = phi i32 [ 0, [[LOADBB1]] ], [ [[TMP2]], [[RES_BLOCK]] ]
; CHECK-NEXT:    ret i32 [[PHI_RES]]
;
  %call = tail call i32 @memcmp(ptr %x, ptr %y, i64 14)
  ret i32 %call
}

define i32 @cmp15(ptr nocapture readonly %x, ptr nocapture readonly %y)  {
; CHECK-LABEL: define i32 @cmp15(
; CHECK-SAME: ptr nocapture readonly [[X:%.*]], ptr nocapture readonly [[Y:%.*]]) {
; CHECK-NEXT:    br label [[LOADBB:%.*]]
; CHECK:       res_block:
; CHECK-NEXT:    [[PHI_SRC1:%.*]] = phi i64 [ [[TMP5:%.*]], [[LOADBB]] ], [ [[TMP12:%.*]], [[LOADBB1:%.*]] ]
; CHECK-NEXT:    [[PHI_SRC2:%.*]] = phi i64 [ [[TMP6:%.*]], [[LOADBB]] ], [ [[TMP13:%.*]], [[LOADBB1]] ]
; CHECK-NEXT:    [[TMP1:%.*]] = icmp ult i64 [[PHI_SRC1]], [[PHI_SRC2]]
; CHECK-NEXT:    [[TMP2:%.*]] = select i1 [[TMP1]], i32 -1, i32 1
; CHECK-NEXT:    br label [[ENDBLOCK:%.*]]
; CHECK:       loadbb:
; CHECK-NEXT:    [[TMP3:%.*]] = load i64, ptr [[X]], align 1
; CHECK-NEXT:    [[TMP4:%.*]] = load i64, ptr [[Y]], align 1
; CHECK-NEXT:    [[TMP5]] = call i64 @llvm.bswap.i64(i64 [[TMP3]])
; CHECK-NEXT:    [[TMP6]] = call i64 @llvm.bswap.i64(i64 [[TMP4]])
; CHECK-NEXT:    [[TMP7:%.*]] = icmp eq i64 [[TMP5]], [[TMP6]]
; CHECK-NEXT:    br i1 [[TMP7]], label [[LOADBB1]], label [[RES_BLOCK:%.*]]
; CHECK:       loadbb1:
; CHECK-NEXT:    [[TMP8:%.*]] = getelementptr i8, ptr [[X]], i64 7
; CHECK-NEXT:    [[TMP9:%.*]] = getelementptr i8, ptr [[Y]], i64 7
; CHECK-NEXT:    [[TMP10:%.*]] = load i64, ptr [[TMP8]], align 1
; CHECK-NEXT:    [[TMP11:%.*]] = load i64, ptr [[TMP9]], align 1
; CHECK-NEXT:    [[TMP12]] = call i64 @llvm.bswap.i64(i64 [[TMP10]])
; CHECK-NEXT:    [[TMP13]] = call i64 @llvm.bswap.i64(i64 [[TMP11]])
; CHECK-NEXT:    [[TMP14:%.*]] = icmp eq i64 [[TMP12]], [[TMP13]]
; CHECK-NEXT:    br i1 [[TMP14]], label [[ENDBLOCK]], label [[RES_BLOCK]]
; CHECK:       endblock:
; CHECK-NEXT:    [[PHI_RES:%.*]] = phi i32 [ 0, [[LOADBB1]] ], [ [[TMP2]], [[RES_BLOCK]] ]
; CHECK-NEXT:    ret i32 [[PHI_RES]]
;
  %call = tail call i32 @memcmp(ptr %x, ptr %y, i64 15)
  ret i32 %call
}

define i32 @cmp16(ptr nocapture readonly %x, ptr nocapture readonly %y)  {
; CHECK-LABEL: define i32 @cmp16(
; CHECK-SAME: ptr nocapture readonly [[X:%.*]], ptr nocapture readonly [[Y:%.*]]) {
; CHECK-NEXT:    br label [[LOADBB:%.*]]
; CHECK:       res_block:
; CHECK-NEXT:    [[PHI_SRC1:%.*]] = phi i64 [ [[TMP5:%.*]], [[LOADBB]] ], [ [[TMP12:%.*]], [[LOADBB1:%.*]] ]
; CHECK-NEXT:    [[PHI_SRC2:%.*]] = phi i64 [ [[TMP6:%.*]], [[LOADBB]] ], [ [[TMP13:%.*]], [[LOADBB1]] ]
; CHECK-NEXT:    [[TMP1:%.*]] = icmp ult i64 [[PHI_SRC1]], [[PHI_SRC2]]
; CHECK-NEXT:    [[TMP2:%.*]] = select i1 [[TMP1]], i32 -1, i32 1
; CHECK-NEXT:    br label [[ENDBLOCK:%.*]]
; CHECK:       loadbb:
; CHECK-NEXT:    [[TMP3:%.*]] = load i64, ptr [[X]], align 1
; CHECK-NEXT:    [[TMP4:%.*]] = load i64, ptr [[Y]], align 1
; CHECK-NEXT:    [[TMP5]] = call i64 @llvm.bswap.i64(i64 [[TMP3]])
; CHECK-NEXT:    [[TMP6]] = call i64 @llvm.bswap.i64(i64 [[TMP4]])
; CHECK-NEXT:    [[TMP7:%.*]] = icmp eq i64 [[TMP5]], [[TMP6]]
; CHECK-NEXT:    br i1 [[TMP7]], label [[LOADBB1]], label [[RES_BLOCK:%.*]]
; CHECK:       loadbb1:
; CHECK-NEXT:    [[TMP8:%.*]] = getelementptr i8, ptr [[X]], i64 8
; CHECK-NEXT:    [[TMP9:%.*]] = getelementptr i8, ptr [[Y]], i64 8
; CHECK-NEXT:    [[TMP10:%.*]] = load i64, ptr [[TMP8]], align 1
; CHECK-NEXT:    [[TMP11:%.*]] = load i64, ptr [[TMP9]], align 1
; CHECK-NEXT:    [[TMP12]] = call i64 @llvm.bswap.i64(i64 [[TMP10]])
; CHECK-NEXT:    [[TMP13]] = call i64 @llvm.bswap.i64(i64 [[TMP11]])
; CHECK-NEXT:    [[TMP14:%.*]] = icmp eq i64 [[TMP12]], [[TMP13]]
; CHECK-NEXT:    br i1 [[TMP14]], label [[ENDBLOCK]], label [[RES_BLOCK]]
; CHECK:       endblock:
; CHECK-NEXT:    [[PHI_RES:%.*]] = phi i32 [ 0, [[LOADBB1]] ], [ [[TMP2]], [[RES_BLOCK]] ]
; CHECK-NEXT:    ret i32 [[PHI_RES]]
;
  %call = tail call i32 @memcmp(ptr %x, ptr %y, i64 16)
  ret i32 %call
}

define i32 @cmp_eq2(ptr nocapture readonly %x, ptr nocapture readonly %y)  {
; CHECK-LABEL: define i32 @cmp_eq2(
; CHECK-SAME: ptr nocapture readonly [[X:%.*]], ptr nocapture readonly [[Y:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = load i16, ptr [[X]], align 1
; CHECK-NEXT:    [[TMP2:%.*]] = load i16, ptr [[Y]], align 1
; CHECK-NEXT:    [[TMP3:%.*]] = icmp ne i16 [[TMP1]], [[TMP2]]
; CHECK-NEXT:    [[TMP4:%.*]] = zext i1 [[TMP3]] to i32
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i32 [[TMP4]], 0
; CHECK-NEXT:    [[CONV:%.*]] = zext i1 [[CMP]] to i32
; CHECK-NEXT:    ret i32 [[CONV]]
;
  %call = tail call i32 @memcmp(ptr %x, ptr %y, i64 2)
  %cmp = icmp eq i32 %call, 0
  %conv = zext i1 %cmp to i32
  ret i32 %conv
}

define i32 @cmp_eq3(ptr nocapture readonly %x, ptr nocapture readonly %y)  {
; CHECK-LABEL: define i32 @cmp_eq3(
; CHECK-SAME: ptr nocapture readonly [[X:%.*]], ptr nocapture readonly [[Y:%.*]]) {
; CHECK-NEXT:    br label [[LOADBB:%.*]]
; CHECK:       res_block:
; CHECK-NEXT:    br label [[ENDBLOCK:%.*]]
; CHECK:       loadbb:
; CHECK-NEXT:    [[TMP1:%.*]] = load i16, ptr [[X]], align 1
; CHECK-NEXT:    [[TMP2:%.*]] = load i16, ptr [[Y]], align 1
; CHECK-NEXT:    [[TMP3:%.*]] = icmp ne i16 [[TMP1]], [[TMP2]]
; CHECK-NEXT:    br i1 [[TMP3]], label [[RES_BLOCK:%.*]], label [[LOADBB1:%.*]]
; CHECK:       loadbb1:
; CHECK-NEXT:    [[TMP4:%.*]] = getelementptr i8, ptr [[X]], i64 2
; CHECK-NEXT:    [[TMP5:%.*]] = getelementptr i8, ptr [[Y]], i64 2
; CHECK-NEXT:    [[TMP6:%.*]] = load i8, ptr [[TMP4]], align 1
; CHECK-NEXT:    [[TMP7:%.*]] = load i8, ptr [[TMP5]], align 1
; CHECK-NEXT:    [[TMP8:%.*]] = icmp ne i8 [[TMP6]], [[TMP7]]
; CHECK-NEXT:    br i1 [[TMP8]], label [[RES_BLOCK]], label [[ENDBLOCK]]
; CHECK:       endblock:
; CHECK-NEXT:    [[PHI_RES:%.*]] = phi i32 [ 0, [[LOADBB1]] ], [ 1, [[RES_BLOCK]] ]
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i32 [[PHI_RES]], 0
; CHECK-NEXT:    [[CONV:%.*]] = zext i1 [[CMP]] to i32
; CHECK-NEXT:    ret i32 [[CONV]]
;
  %call = tail call i32 @memcmp(ptr %x, ptr %y, i64 3)
  %cmp = icmp eq i32 %call, 0
  %conv = zext i1 %cmp to i32
  ret i32 %conv
}

define i32 @cmp_eq4(ptr nocapture readonly %x, ptr nocapture readonly %y)  {
; CHECK-LABEL: define i32 @cmp_eq4(
; CHECK-SAME: ptr nocapture readonly [[X:%.*]], ptr nocapture readonly [[Y:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = load i32, ptr [[X]], align 1
; CHECK-NEXT:    [[TMP2:%.*]] = load i32, ptr [[Y]], align 1
; CHECK-NEXT:    [[TMP3:%.*]] = icmp ne i32 [[TMP1]], [[TMP2]]
; CHECK-NEXT:    [[TMP4:%.*]] = zext i1 [[TMP3]] to i32
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i32 [[TMP4]], 0
; CHECK-NEXT:    [[CONV:%.*]] = zext i1 [[CMP]] to i32
; CHECK-NEXT:    ret i32 [[CONV]]
;
  %call = tail call i32 @memcmp(ptr %x, ptr %y, i64 4)
  %cmp = icmp eq i32 %call, 0
  %conv = zext i1 %cmp to i32
  ret i32 %conv
}

define i32 @cmp_eq5(ptr nocapture readonly %x, ptr nocapture readonly %y)  {
; CHECK-LABEL: define i32 @cmp_eq5(
; CHECK-SAME: ptr nocapture readonly [[X:%.*]], ptr nocapture readonly [[Y:%.*]]) {
; CHECK-NEXT:    br label [[LOADBB:%.*]]
; CHECK:       res_block:
; CHECK-NEXT:    br label [[ENDBLOCK:%.*]]
; CHECK:       loadbb:
; CHECK-NEXT:    [[TMP1:%.*]] = load i32, ptr [[X]], align 1
; CHECK-NEXT:    [[TMP2:%.*]] = load i32, ptr [[Y]], align 1
; CHECK-NEXT:    [[TMP3:%.*]] = icmp ne i32 [[TMP1]], [[TMP2]]
; CHECK-NEXT:    br i1 [[TMP3]], label [[RES_BLOCK:%.*]], label [[LOADBB1:%.*]]
; CHECK:       loadbb1:
; CHECK-NEXT:    [[TMP4:%.*]] = getelementptr i8, ptr [[X]], i64 4
; CHECK-NEXT:    [[TMP5:%.*]] = getelementptr i8, ptr [[Y]], i64 4
; CHECK-NEXT:    [[TMP6:%.*]] = load i8, ptr [[TMP4]], align 1
; CHECK-NEXT:    [[TMP7:%.*]] = load i8, ptr [[TMP5]], align 1
; CHECK-NEXT:    [[TMP8:%.*]] = icmp ne i8 [[TMP6]], [[TMP7]]
; CHECK-NEXT:    br i1 [[TMP8]], label [[RES_BLOCK]], label [[ENDBLOCK]]
; CHECK:       endblock:
; CHECK-NEXT:    [[PHI_RES:%.*]] = phi i32 [ 0, [[LOADBB1]] ], [ 1, [[RES_BLOCK]] ]
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i32 [[PHI_RES]], 0
; CHECK-NEXT:    [[CONV:%.*]] = zext i1 [[CMP]] to i32
; CHECK-NEXT:    ret i32 [[CONV]]
;
  %call = tail call i32 @memcmp(ptr %x, ptr %y, i64 5)
  %cmp = icmp eq i32 %call, 0
  %conv = zext i1 %cmp to i32
  ret i32 %conv
}

define i32 @cmp_eq6(ptr nocapture readonly %x, ptr nocapture readonly %y)  {
; CHECK-LABEL: define i32 @cmp_eq6(
; CHECK-SAME: ptr nocapture readonly [[X:%.*]], ptr nocapture readonly [[Y:%.*]]) {
; CHECK-NEXT:    br label [[LOADBB:%.*]]
; CHECK:       res_block:
; CHECK-NEXT:    br label [[ENDBLOCK:%.*]]
; CHECK:       loadbb:
; CHECK-NEXT:    [[TMP1:%.*]] = load i32, ptr [[X]], align 1
; CHECK-NEXT:    [[TMP2:%.*]] = load i32, ptr [[Y]], align 1
; CHECK-NEXT:    [[TMP3:%.*]] = icmp ne i32 [[TMP1]], [[TMP2]]
; CHECK-NEXT:    br i1 [[TMP3]], label [[RES_BLOCK:%.*]], label [[LOADBB1:%.*]]
; CHECK:       loadbb1:
; CHECK-NEXT:    [[TMP4:%.*]] = getelementptr i8, ptr [[X]], i64 4
; CHECK-NEXT:    [[TMP5:%.*]] = getelementptr i8, ptr [[Y]], i64 4
; CHECK-NEXT:    [[TMP6:%.*]] = load i16, ptr [[TMP4]], align 1
; CHECK-NEXT:    [[TMP7:%.*]] = load i16, ptr [[TMP5]], align 1
; CHECK-NEXT:    [[TMP8:%.*]] = icmp ne i16 [[TMP6]], [[TMP7]]
; CHECK-NEXT:    br i1 [[TMP8]], label [[RES_BLOCK]], label [[ENDBLOCK]]
; CHECK:       endblock:
; CHECK-NEXT:    [[PHI_RES:%.*]] = phi i32 [ 0, [[LOADBB1]] ], [ 1, [[RES_BLOCK]] ]
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i32 [[PHI_RES]], 0
; CHECK-NEXT:    [[CONV:%.*]] = zext i1 [[CMP]] to i32
; CHECK-NEXT:    ret i32 [[CONV]]
;
  %call = tail call i32 @memcmp(ptr %x, ptr %y, i64 6)
  %cmp = icmp eq i32 %call, 0
  %conv = zext i1 %cmp to i32
  ret i32 %conv
}

define i32 @cmp_eq6_align4(ptr nocapture readonly align 4 %x, ptr nocapture readonly align 4 %y)  {
; CHECK-LABEL: define i32 @cmp_eq6_align4(
; CHECK-SAME: ptr nocapture readonly align 4 [[X:%.*]], ptr nocapture readonly align 4 [[Y:%.*]]) {
; CHECK-NEXT:    br label [[LOADBB:%.*]]
; CHECK:       res_block:
; CHECK-NEXT:    br label [[ENDBLOCK:%.*]]
; CHECK:       loadbb:
; CHECK-NEXT:    [[TMP1:%.*]] = load i32, ptr [[X]], align 4
; CHECK-NEXT:    [[TMP2:%.*]] = load i32, ptr [[Y]], align 4
; CHECK-NEXT:    [[TMP3:%.*]] = icmp ne i32 [[TMP1]], [[TMP2]]
; CHECK-NEXT:    br i1 [[TMP3]], label [[RES_BLOCK:%.*]], label [[LOADBB1:%.*]]
; CHECK:       loadbb1:
; CHECK-NEXT:    [[TMP4:%.*]] = getelementptr i8, ptr [[X]], i64 4
; CHECK-NEXT:    [[TMP5:%.*]] = getelementptr i8, ptr [[Y]], i64 4
; CHECK-NEXT:    [[TMP6:%.*]] = load i16, ptr [[TMP4]], align 4
; CHECK-NEXT:    [[TMP7:%.*]] = load i16, ptr [[TMP5]], align 4
; CHECK-NEXT:    [[TMP8:%.*]] = icmp ne i16 [[TMP6]], [[TMP7]]
; CHECK-NEXT:    br i1 [[TMP8]], label [[RES_BLOCK]], label [[ENDBLOCK]]
; CHECK:       endblock:
; CHECK-NEXT:    [[PHI_RES:%.*]] = phi i32 [ 0, [[LOADBB1]] ], [ 1, [[RES_BLOCK]] ]
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i32 [[PHI_RES]], 0
; CHECK-NEXT:    [[CONV:%.*]] = zext i1 [[CMP]] to i32
; CHECK-NEXT:    ret i32 [[CONV]]
;
  %call = tail call i32 @memcmp(ptr %x, ptr %y, i64 6)
  %cmp = icmp eq i32 %call, 0
  %conv = zext i1 %cmp to i32
  ret i32 %conv
}

define i32 @cmp_eq7(ptr nocapture readonly %x, ptr nocapture readonly %y)  {
; CHECK-LABEL: define i32 @cmp_eq7(
; CHECK-SAME: ptr nocapture readonly [[X:%.*]], ptr nocapture readonly [[Y:%.*]]) {
; CHECK-NEXT:    br label [[LOADBB:%.*]]
; CHECK:       res_block:
; CHECK-NEXT:    br label [[ENDBLOCK:%.*]]
; CHECK:       loadbb:
; CHECK-NEXT:    [[TMP1:%.*]] = load i32, ptr [[X]], align 1
; CHECK-NEXT:    [[TMP2:%.*]] = load i32, ptr [[Y]], align 1
; CHECK-NEXT:    [[TMP3:%.*]] = icmp ne i32 [[TMP1]], [[TMP2]]
; CHECK-NEXT:    br i1 [[TMP3]], label [[RES_BLOCK:%.*]], label [[LOADBB1:%.*]]
; CHECK:       loadbb1:
; CHECK-NEXT:    [[TMP4:%.*]] = getelementptr i8, ptr [[X]], i64 3
; CHECK-NEXT:    [[TMP5:%.*]] = getelementptr i8, ptr [[Y]], i64 3
; CHECK-NEXT:    [[TMP6:%.*]] = load i32, ptr [[TMP4]], align 1
; CHECK-NEXT:    [[TMP7:%.*]] = load i32, ptr [[TMP5]], align 1
; CHECK-NEXT:    [[TMP8:%.*]] = icmp ne i32 [[TMP6]], [[TMP7]]
; CHECK-NEXT:    br i1 [[TMP8]], label [[RES_BLOCK]], label [[ENDBLOCK]]
; CHECK:       endblock:
; CHECK-NEXT:    [[PHI_RES:%.*]] = phi i32 [ 0, [[LOADBB1]] ], [ 1, [[RES_BLOCK]] ]
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i32 [[PHI_RES]], 0
; CHECK-NEXT:    [[CONV:%.*]] = zext i1 [[CMP]] to i32
; CHECK-NEXT:    ret i32 [[CONV]]
;
  %call = tail call i32 @memcmp(ptr %x, ptr %y, i64 7)
  %cmp = icmp eq i32 %call, 0
  %conv = zext i1 %cmp to i32
  ret i32 %conv
}

define i32 @cmp_eq8(ptr nocapture readonly %x, ptr nocapture readonly %y)  {
; CHECK-LABEL: define i32 @cmp_eq8(
; CHECK-SAME: ptr nocapture readonly [[X:%.*]], ptr nocapture readonly [[Y:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = load i64, ptr [[X]], align 1
; CHECK-NEXT:    [[TMP2:%.*]] = load i64, ptr [[Y]], align 1
; CHECK-NEXT:    [[TMP3:%.*]] = icmp ne i64 [[TMP1]], [[TMP2]]
; CHECK-NEXT:    [[TMP4:%.*]] = zext i1 [[TMP3]] to i32
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i32 [[TMP4]], 0
; CHECK-NEXT:    [[CONV:%.*]] = zext i1 [[CMP]] to i32
; CHECK-NEXT:    ret i32 [[CONV]]
;
  %call = tail call i32 @memcmp(ptr %x, ptr %y, i64 8)
  %cmp = icmp eq i32 %call, 0
  %conv = zext i1 %cmp to i32
  ret i32 %conv
}

define i32 @cmp_eq9(ptr nocapture readonly %x, ptr nocapture readonly %y)  {
; CHECK-LABEL: define i32 @cmp_eq9(
; CHECK-SAME: ptr nocapture readonly [[X:%.*]], ptr nocapture readonly [[Y:%.*]]) {
; CHECK-NEXT:    br label [[LOADBB:%.*]]
; CHECK:       res_block:
; CHECK-NEXT:    br label [[ENDBLOCK:%.*]]
; CHECK:       loadbb:
; CHECK-NEXT:    [[TMP1:%.*]] = load i64, ptr [[X]], align 1
; CHECK-NEXT:    [[TMP2:%.*]] = load i64, ptr [[Y]], align 1
; CHECK-NEXT:    [[TMP3:%.*]] = icmp ne i64 [[TMP1]], [[TMP2]]
; CHECK-NEXT:    br i1 [[TMP3]], label [[RES_BLOCK:%.*]], label [[LOADBB1:%.*]]
; CHECK:       loadbb1:
; CHECK-NEXT:    [[TMP4:%.*]] = getelementptr i8, ptr [[X]], i64 8
; CHECK-NEXT:    [[TMP5:%.*]] = getelementptr i8, ptr [[Y]], i64 8
; CHECK-NEXT:    [[TMP6:%.*]] = load i8, ptr [[TMP4]], align 1
; CHECK-NEXT:    [[TMP7:%.*]] = load i8, ptr [[TMP5]], align 1
; CHECK-NEXT:    [[TMP8:%.*]] = icmp ne i8 [[TMP6]], [[TMP7]]
; CHECK-NEXT:    br i1 [[TMP8]], label [[RES_BLOCK]], label [[ENDBLOCK]]
; CHECK:       endblock:
; CHECK-NEXT:    [[PHI_RES:%.*]] = phi i32 [ 0, [[LOADBB1]] ], [ 1, [[RES_BLOCK]] ]
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i32 [[PHI_RES]], 0
; CHECK-NEXT:    [[CONV:%.*]] = zext i1 [[CMP]] to i32
; CHECK-NEXT:    ret i32 [[CONV]]
;
  %call = tail call i32 @memcmp(ptr %x, ptr %y, i64 9)
  %cmp = icmp eq i32 %call, 0
  %conv = zext i1 %cmp to i32
  ret i32 %conv
}

define i32 @cmp_eq10(ptr nocapture readonly %x, ptr nocapture readonly %y)  {
; CHECK-LABEL: define i32 @cmp_eq10(
; CHECK-SAME: ptr nocapture readonly [[X:%.*]], ptr nocapture readonly [[Y:%.*]]) {
; CHECK-NEXT:    br label [[LOADBB:%.*]]
; CHECK:       res_block:
; CHECK-NEXT:    br label [[ENDBLOCK:%.*]]
; CHECK:       loadbb:
; CHECK-NEXT:    [[TMP1:%.*]] = load i64, ptr [[X]], align 1
; CHECK-NEXT:    [[TMP2:%.*]] = load i64, ptr [[Y]], align 1
; CHECK-NEXT:    [[TMP3:%.*]] = icmp ne i64 [[TMP1]], [[TMP2]]
; CHECK-NEXT:    br i1 [[TMP3]], label [[RES_BLOCK:%.*]], label [[LOADBB1:%.*]]
; CHECK:       loadbb1:
; CHECK-NEXT:    [[TMP4:%.*]] = getelementptr i8, ptr [[X]], i64 8
; CHECK-NEXT:    [[TMP5:%.*]] = getelementptr i8, ptr [[Y]], i64 8
; CHECK-NEXT:    [[TMP6:%.*]] = load i16, ptr [[TMP4]], align 1
; CHECK-NEXT:    [[TMP7:%.*]] = load i16, ptr [[TMP5]], align 1
; CHECK-NEXT:    [[TMP8:%.*]] = icmp ne i16 [[TMP6]], [[TMP7]]
; CHECK-NEXT:    br i1 [[TMP8]], label [[RES_BLOCK]], label [[ENDBLOCK]]
; CHECK:       endblock:
; CHECK-NEXT:    [[PHI_RES:%.*]] = phi i32 [ 0, [[LOADBB1]] ], [ 1, [[RES_BLOCK]] ]
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i32 [[PHI_RES]], 0
; CHECK-NEXT:    [[CONV:%.*]] = zext i1 [[CMP]] to i32
; CHECK-NEXT:    ret i32 [[CONV]]
;
  %call = tail call i32 @memcmp(ptr %x, ptr %y, i64 10)
  %cmp = icmp eq i32 %call, 0
  %conv = zext i1 %cmp to i32
  ret i32 %conv
}

define i32 @cmp_eq11(ptr nocapture readonly %x, ptr nocapture readonly %y)  {
; CHECK-LABEL: define i32 @cmp_eq11(
; CHECK-SAME: ptr nocapture readonly [[X:%.*]], ptr nocapture readonly [[Y:%.*]]) {
; CHECK-NEXT:    br label [[LOADBB:%.*]]
; CHECK:       res_block:
; CHECK-NEXT:    br label [[ENDBLOCK:%.*]]
; CHECK:       loadbb:
; CHECK-NEXT:    [[TMP1:%.*]] = load i64, ptr [[X]], align 1
; CHECK-NEXT:    [[TMP2:%.*]] = load i64, ptr [[Y]], align 1
; CHECK-NEXT:    [[TMP3:%.*]] = icmp ne i64 [[TMP1]], [[TMP2]]
; CHECK-NEXT:    br i1 [[TMP3]], label [[RES_BLOCK:%.*]], label [[LOADBB1:%.*]]
; CHECK:       loadbb1:
; CHECK-NEXT:    [[TMP4:%.*]] = getelementptr i8, ptr [[X]], i64 3
; CHECK-NEXT:    [[TMP5:%.*]] = getelementptr i8, ptr [[Y]], i64 3
; CHECK-NEXT:    [[TMP6:%.*]] = load i64, ptr [[TMP4]], align 1
; CHECK-NEXT:    [[TMP7:%.*]] = load i64, ptr [[TMP5]], align 1
; CHECK-NEXT:    [[TMP8:%.*]] = icmp ne i64 [[TMP6]], [[TMP7]]
; CHECK-NEXT:    br i1 [[TMP8]], label [[RES_BLOCK]], label [[ENDBLOCK]]
; CHECK:       endblock:
; CHECK-NEXT:    [[PHI_RES:%.*]] = phi i32 [ 0, [[LOADBB1]] ], [ 1, [[RES_BLOCK]] ]
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i32 [[PHI_RES]], 0
; CHECK-NEXT:    [[CONV:%.*]] = zext i1 [[CMP]] to i32
; CHECK-NEXT:    ret i32 [[CONV]]
;
  %call = tail call i32 @memcmp(ptr %x, ptr %y, i64 11)
  %cmp = icmp eq i32 %call, 0
  %conv = zext i1 %cmp to i32
  ret i32 %conv
}

define i32 @cmp_eq12(ptr nocapture readonly %x, ptr nocapture readonly %y)  {
; CHECK-LABEL: define i32 @cmp_eq12(
; CHECK-SAME: ptr nocapture readonly [[X:%.*]], ptr nocapture readonly [[Y:%.*]]) {
; CHECK-NEXT:    br label [[LOADBB:%.*]]
; CHECK:       res_block:
; CHECK-NEXT:    br label [[ENDBLOCK:%.*]]
; CHECK:       loadbb:
; CHECK-NEXT:    [[TMP1:%.*]] = load i64, ptr [[X]], align 1
; CHECK-NEXT:    [[TMP2:%.*]] = load i64, ptr [[Y]], align 1
; CHECK-NEXT:    [[TMP3:%.*]] = icmp ne i64 [[TMP1]], [[TMP2]]
; CHECK-NEXT:    br i1 [[TMP3]], label [[RES_BLOCK:%.*]], label [[LOADBB1:%.*]]
; CHECK:       loadbb1:
; CHECK-NEXT:    [[TMP4:%.*]] = getelementptr i8, ptr [[X]], i64 8
; CHECK-NEXT:    [[TMP5:%.*]] = getelementptr i8, ptr [[Y]], i64 8
; CHECK-NEXT:    [[TMP6:%.*]] = load i32, ptr [[TMP4]], align 1
; CHECK-NEXT:    [[TMP7:%.*]] = load i32, ptr [[TMP5]], align 1
; CHECK-NEXT:    [[TMP8:%.*]] = icmp ne i32 [[TMP6]], [[TMP7]]
; CHECK-NEXT:    br i1 [[TMP8]], label [[RES_BLOCK]], label [[ENDBLOCK]]
; CHECK:       endblock:
; CHECK-NEXT:    [[PHI_RES:%.*]] = phi i32 [ 0, [[LOADBB1]] ], [ 1, [[RES_BLOCK]] ]
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i32 [[PHI_RES]], 0
; CHECK-NEXT:    [[CONV:%.*]] = zext i1 [[CMP]] to i32
; CHECK-NEXT:    ret i32 [[CONV]]
;
  %call = tail call i32 @memcmp(ptr %x, ptr %y, i64 12)
  %cmp = icmp eq i32 %call, 0
  %conv = zext i1 %cmp to i32
  ret i32 %conv
}

define i32 @cmp_eq13(ptr nocapture readonly %x, ptr nocapture readonly %y)  {
; CHECK-LABEL: define i32 @cmp_eq13(
; CHECK-SAME: ptr nocapture readonly [[X:%.*]], ptr nocapture readonly [[Y:%.*]]) {
; CHECK-NEXT:    br label [[LOADBB:%.*]]
; CHECK:       res_block:
; CHECK-NEXT:    br label [[ENDBLOCK:%.*]]
; CHECK:       loadbb:
; CHECK-NEXT:    [[TMP1:%.*]] = load i64, ptr [[X]], align 1
; CHECK-NEXT:    [[TMP2:%.*]] = load i64, ptr [[Y]], align 1
; CHECK-NEXT:    [[TMP3:%.*]] = icmp ne i64 [[TMP1]], [[TMP2]]
; CHECK-NEXT:    br i1 [[TMP3]], label [[RES_BLOCK:%.*]], label [[LOADBB1:%.*]]
; CHECK:       loadbb1:
; CHECK-NEXT:    [[TMP4:%.*]] = getelementptr i8, ptr [[X]], i64 5
; CHECK-NEXT:    [[TMP5:%.*]] = getelementptr i8, ptr [[Y]], i64 5
; CHECK-NEXT:    [[TMP6:%.*]] = load i64, ptr [[TMP4]], align 1
; CHECK-NEXT:    [[TMP7:%.*]] = load i64, ptr [[TMP5]], align 1
; CHECK-NEXT:    [[TMP8:%.*]] = icmp ne i64 [[TMP6]], [[TMP7]]
; CHECK-NEXT:    br i1 [[TMP8]], label [[RES_BLOCK]], label [[ENDBLOCK]]
; CHECK:       endblock:
; CHECK-NEXT:    [[PHI_RES:%.*]] = phi i32 [ 0, [[LOADBB1]] ], [ 1, [[RES_BLOCK]] ]
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i32 [[PHI_RES]], 0
; CHECK-NEXT:    [[CONV:%.*]] = zext i1 [[CMP]] to i32
; CHECK-NEXT:    ret i32 [[CONV]]
;
  %call = tail call i32 @memcmp(ptr %x, ptr %y, i64 13)
  %cmp = icmp eq i32 %call, 0
  %conv = zext i1 %cmp to i32
  ret i32 %conv
}

define i32 @cmp_eq14(ptr nocapture readonly %x, ptr nocapture readonly %y)  {
; CHECK-LABEL: define i32 @cmp_eq14(
; CHECK-SAME: ptr nocapture readonly [[X:%.*]], ptr nocapture readonly [[Y:%.*]]) {
; CHECK-NEXT:    br label [[LOADBB:%.*]]
; CHECK:       res_block:
; CHECK-NEXT:    br label [[ENDBLOCK:%.*]]
; CHECK:       loadbb:
; CHECK-NEXT:    [[TMP1:%.*]] = load i64, ptr [[X]], align 1
; CHECK-NEXT:    [[TMP2:%.*]] = load i64, ptr [[Y]], align 1
; CHECK-NEXT:    [[TMP3:%.*]] = icmp ne i64 [[TMP1]], [[TMP2]]
; CHECK-NEXT:    br i1 [[TMP3]], label [[RES_BLOCK:%.*]], label [[LOADBB1:%.*]]
; CHECK:       loadbb1:
; CHECK-NEXT:    [[TMP4:%.*]] = getelementptr i8, ptr [[X]], i64 6
; CHECK-NEXT:    [[TMP5:%.*]] = getelementptr i8, ptr [[Y]], i64 6
; CHECK-NEXT:    [[TMP6:%.*]] = load i64, ptr [[TMP4]], align 1
; CHECK-NEXT:    [[TMP7:%.*]] = load i64, ptr [[TMP5]], align 1
; CHECK-NEXT:    [[TMP8:%.*]] = icmp ne i64 [[TMP6]], [[TMP7]]
; CHECK-NEXT:    br i1 [[TMP8]], label [[RES_BLOCK]], label [[ENDBLOCK]]
; CHECK:       endblock:
; CHECK-NEXT:    [[PHI_RES:%.*]] = phi i32 [ 0, [[LOADBB1]] ], [ 1, [[RES_BLOCK]] ]
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i32 [[PHI_RES]], 0
; CHECK-NEXT:    [[CONV:%.*]] = zext i1 [[CMP]] to i32
; CHECK-NEXT:    ret i32 [[CONV]]
;
  %call = tail call i32 @memcmp(ptr %x, ptr %y, i64 14)
  %cmp = icmp eq i32 %call, 0
  %conv = zext i1 %cmp to i32
  ret i32 %conv
}

define i32 @cmp_eq15(ptr nocapture readonly %x, ptr nocapture readonly %y)  {
; CHECK-LABEL: define i32 @cmp_eq15(
; CHECK-SAME: ptr nocapture readonly [[X:%.*]], ptr nocapture readonly [[Y:%.*]]) {
; CHECK-NEXT:    br label [[LOADBB:%.*]]
; CHECK:       res_block:
; CHECK-NEXT:    br label [[ENDBLOCK:%.*]]
; CHECK:       loadbb:
; CHECK-NEXT:    [[TMP1:%.*]] = load i64, ptr [[X]], align 1
; CHECK-NEXT:    [[TMP2:%.*]] = load i64, ptr [[Y]], align 1
; CHECK-NEXT:    [[TMP3:%.*]] = icmp ne i64 [[TMP1]], [[TMP2]]
; CHECK-NEXT:    br i1 [[TMP3]], label [[RES_BLOCK:%.*]], label [[LOADBB1:%.*]]
; CHECK:       loadbb1:
; CHECK-NEXT:    [[TMP4:%.*]] = getelementptr i8, ptr [[X]], i64 7
; CHECK-NEXT:    [[TMP5:%.*]] = getelementptr i8, ptr [[Y]], i64 7
; CHECK-NEXT:    [[TMP6:%.*]] = load i64, ptr [[TMP4]], align 1
; CHECK-NEXT:    [[TMP7:%.*]] = load i64, ptr [[TMP5]], align 1
; CHECK-NEXT:    [[TMP8:%.*]] = icmp ne i64 [[TMP6]], [[TMP7]]
; CHECK-NEXT:    br i1 [[TMP8]], label [[RES_BLOCK]], label [[ENDBLOCK]]
; CHECK:       endblock:
; CHECK-NEXT:    [[PHI_RES:%.*]] = phi i32 [ 0, [[LOADBB1]] ], [ 1, [[RES_BLOCK]] ]
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i32 [[PHI_RES]], 0
; CHECK-NEXT:    [[CONV:%.*]] = zext i1 [[CMP]] to i32
; CHECK-NEXT:    ret i32 [[CONV]]
;
  %call = tail call i32 @memcmp(ptr %x, ptr %y, i64 15)
  %cmp = icmp eq i32 %call, 0
  %conv = zext i1 %cmp to i32
  ret i32 %conv
}

define i32 @cmp_eq16(ptr nocapture readonly %x, ptr nocapture readonly %y)  {
; CHECK-LABEL: define i32 @cmp_eq16(
; CHECK-SAME: ptr nocapture readonly [[X:%.*]], ptr nocapture readonly [[Y:%.*]]) {
; CHECK-NEXT:    br label [[LOADBB:%.*]]
; CHECK:       res_block:
; CHECK-NEXT:    br label [[ENDBLOCK:%.*]]
; CHECK:       loadbb:
; CHECK-NEXT:    [[TMP1:%.*]] = load i64, ptr [[X]], align 1
; CHECK-NEXT:    [[TMP2:%.*]] = load i64, ptr [[Y]], align 1
; CHECK-NEXT:    [[TMP3:%.*]] = icmp ne i64 [[TMP1]], [[TMP2]]
; CHECK-NEXT:    br i1 [[TMP3]], label [[RES_BLOCK:%.*]], label [[LOADBB1:%.*]]
; CHECK:       loadbb1:
; CHECK-NEXT:    [[TMP4:%.*]] = getelementptr i8, ptr [[X]], i64 8
; CHECK-NEXT:    [[TMP5:%.*]] = getelementptr i8, ptr [[Y]], i64 8
; CHECK-NEXT:    [[TMP6:%.*]] = load i64, ptr [[TMP4]], align 1
; CHECK-NEXT:    [[TMP7:%.*]] = load i64, ptr [[TMP5]], align 1
; CHECK-NEXT:    [[TMP8:%.*]] = icmp ne i64 [[TMP6]], [[TMP7]]
; CHECK-NEXT:    br i1 [[TMP8]], label [[RES_BLOCK]], label [[ENDBLOCK]]
; CHECK:       endblock:
; CHECK-NEXT:    [[PHI_RES:%.*]] = phi i32 [ 0, [[LOADBB1]] ], [ 1, [[RES_BLOCK]] ]
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i32 [[PHI_RES]], 0
; CHECK-NEXT:    [[CONV:%.*]] = zext i1 [[CMP]] to i32
; CHECK-NEXT:    ret i32 [[CONV]]
;
  %call = tail call i32 @memcmp(ptr %x, ptr %y, i64 16)
  %cmp = icmp eq i32 %call, 0
  %conv = zext i1 %cmp to i32
  ret i32 %conv
}
