; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -S -passes=memcpyopt -opaque-pointers < %s | FileCheck %s --check-prefixes=CHECK,LIBCALLS
; RUN: opt -S -passes=memcpyopt -mtriple=amdgcn-- -opaque-pointers < %s | FileCheck %s --check-prefixes=CHECK,NO-LIBCALLS
; RUN: opt -S -passes=memcpyopt -mtriple=amdgcn-- -enable-memcpyopt-without-libcalls -opaque-pointers < %s \
; RUN:     | FileCheck %s --check-prefixes=CHECK,LIBCALLS

; REQUIRES: amdgpu-registered-target

define void @dont_create_memset(ptr %p) {
; LIBCALLS-LABEL: @dont_create_memset(
; LIBCALLS-NEXT:    [[P1:%.*]] = getelementptr i32, ptr [[P:%.*]], i64 1
; LIBCALLS-NEXT:    [[P2:%.*]] = getelementptr i32, ptr [[P]], i64 2
; LIBCALLS-NEXT:    [[P3:%.*]] = getelementptr i32, ptr [[P]], i64 3
; LIBCALLS-NEXT:    call void @llvm.memset.p0.i64(ptr align 4 [[P]], i8 0, i64 16, i1 false)
; LIBCALLS-NEXT:    ret void
;
; NO-LIBCALLS-LABEL: @dont_create_memset(
; NO-LIBCALLS-NEXT:    store i32 0, ptr [[P:%.*]], align 4
; NO-LIBCALLS-NEXT:    [[P1:%.*]] = getelementptr i32, ptr [[P]], i64 1
; NO-LIBCALLS-NEXT:    store i32 0, ptr [[P1]], align 4
; NO-LIBCALLS-NEXT:    [[P2:%.*]] = getelementptr i32, ptr [[P]], i64 2
; NO-LIBCALLS-NEXT:    store i32 0, ptr [[P2]], align 4
; NO-LIBCALLS-NEXT:    [[P3:%.*]] = getelementptr i32, ptr [[P]], i64 3
; NO-LIBCALLS-NEXT:    store i32 0, ptr [[P3]], align 4
; NO-LIBCALLS-NEXT:    ret void
;
  store i32 0, ptr %p
  %p1 = getelementptr i32, ptr %p, i64 1
  store i32 0, ptr %p1
  %p2 = getelementptr i32, ptr %p, i64 2
  store i32 0, ptr %p2
  %p3 = getelementptr i32, ptr %p, i64 3
  store i32 0, ptr %p3
  ret void
}

%ty = type { i64 }

define void @dont_create_memcpy(ptr %p1, ptr %p2) {
; LIBCALLS-LABEL: @dont_create_memcpy(
; LIBCALLS-NEXT:    call void @llvm.memmove.p0.p0.i64(ptr align 4 [[P2:%.*]], ptr align 4 [[P1:%.*]], i64 8, i1 false)
; LIBCALLS-NEXT:    ret void
;
; NO-LIBCALLS-LABEL: @dont_create_memcpy(
; NO-LIBCALLS-NEXT:    [[V:%.*]] = load [[TY:%.*]], ptr [[P1:%.*]], align 4
; NO-LIBCALLS-NEXT:    store [[TY]] [[V]], ptr [[P2:%.*]], align 4
; NO-LIBCALLS-NEXT:    ret void
;
  %v = load %ty, ptr %p1
  store %ty %v, ptr %p2
  ret void
}

define void @forward_memcpy(ptr noalias %p1, ptr noalias %p2, ptr noalias %p3) {
; CHECK-LABEL: @forward_memcpy(
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr [[P2:%.*]], ptr [[P1:%.*]], i64 16, i1 false)
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr [[P3:%.*]], ptr [[P1]], i64 16, i1 false)
; CHECK-NEXT:    ret void
;
  call void @llvm.memcpy.p0.p0.i64(ptr %p2, ptr %p1, i64 16, i1 false)
  call void @llvm.memcpy.p0.p0.i64(ptr %p3, ptr %p2, i64 16, i1 false)
  ret void
}

declare void @llvm.memcpy.p0.p0.i64(ptr, ptr, i64, i1)
