; Verify that calls to known stdio library functions declared with
; incompatible signatures are handled gracefully and without aborting.
;
; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=instcombine -opaque-pointers -S | FileCheck %s

declare i32 @fwrite(ptr, i64, i64, ptr)
declare i8 @fputc(ptr, ptr)

declare void @printf(ptr)
declare i8 @fprintf(ptr, ptr)
declare i8 @sprintf(ptr, ptr)


@ca1 = constant [1 x i8] c"1"
@pcnt_s = constant [3 x i8] c"%s\00"


; Verify that a call to fwrite isn't transformed into one to fputc when
; the latter is declared with an incompatible signature (which might
; trigger an abort).

define void @call_fwrite(ptr %fp) {
  call i32 @fwrite(ptr @ca1, i64 1, i64 1, ptr %fp)
  ret void
}


; Verify that a call to an incompatible void printf(char*) with just "%s"
; isn't transformed.

define void @call_printf(ptr %s) {
; CHECK-LABEL: @call_printf(
;
  call i32 @printf(ptr @pcnt_s)
  ret void
}

; Verify that a call to an incompatible int fprintf(FILE*, char*) isn't
; transformed.

define i8 @call_fprintf(ptr %fp, ptr %p) {
; CHECK-LABEL: @call_fprintf(
;
  %call = call i8 (ptr, ptr, ...) @fprintf(ptr %fp, ptr @pcnt_s, ptr %p)
  ret i8 %call
}

; Verify that a call to an incompatible int sprintf(FILE*, char*) isn't
; transformed.

define i8 @call_sprintf(ptr %p, ptr %q) {
; CHECK-LABEL: @call_sprintf(
;
  %call = call i8 (ptr, ptr, ...) @sprintf(ptr %p, ptr @pcnt_s, ptr %q)
  ret i8 %call
}

