; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -passes=instcombine -S < %s | FileCheck %s

; Given:
;   icmp eq/ne (urem %x, C), 0
; Iff C is not a power of two (those should not get to here though),
; and %x may have at most one bit set, omit the 'urem':
;   icmp eq/ne %x, 0

;------------------------------------------------------------------------------;
; Basic scalar tests
;------------------------------------------------------------------------------;

define i1 @p0_scalar_urem_by_const(i32 %x, i32 %y) {
; CHECK-LABEL: @p0_scalar_urem_by_const(
; CHECK-NEXT:    [[T0:%.*]] = and i32 [[X:%.*]], 128
; CHECK-NEXT:    [[T2:%.*]] = icmp eq i32 [[T0]], 0
; CHECK-NEXT:    ret i1 [[T2]]
;
  %t0 = and i32 %x, 128 ; clearly a power-of-two or zero
  %t1 = urem i32 %t0, 6 ; '6' is clearly not a power of two
  %t2 = icmp eq i32 %t1, 0
  ret i1 %t2
}

define i1 @p1_scalar_urem_by_nonconst(i32 %x, i32 %y) {
; CHECK-LABEL: @p1_scalar_urem_by_nonconst(
; CHECK-NEXT:    [[T0:%.*]] = and i32 [[X:%.*]], 128
; CHECK-NEXT:    [[T3:%.*]] = icmp eq i32 [[T0]], 0
; CHECK-NEXT:    ret i1 [[T3]]
;
  %t0 = and i32 %x, 128 ; clearly a power-of-two or zero
  %t1 = or i32 %y, 6 ; two bits set, clearly not a power of two
  %t2 = urem i32 %t0, %t1
  %t3 = icmp eq i32 %t2, 0
  ret i1 %t3
}

define i1 @p2_scalar_shifted_urem_by_const(i32 %x, i32 %y) {
; CHECK-LABEL: @p2_scalar_shifted_urem_by_const(
; CHECK-NEXT:    [[T0:%.*]] = and i32 [[X:%.*]], 1
; CHECK-NEXT:    [[T1:%.*]] = shl i32 [[T0]], [[Y:%.*]]
; CHECK-NEXT:    [[T2:%.*]] = urem i32 [[T1]], 3
; CHECK-NEXT:    [[T3:%.*]] = icmp eq i32 [[T2]], 0
; CHECK-NEXT:    ret i1 [[T3]]
;
  %t0 = and i32 %x, 1 ; clearly a power-of-two or zero
  %t1 = shl i32 %t0, %y ; will still be a power-of-two or zero with any %y
  %t2 = urem i32 %t1, 3 ; '3' is clearly not a power of two
  %t3 = icmp eq i32 %t2, 0
  ret i1 %t3
}

define i1 @p3_scalar_shifted2_urem_by_const(i32 %x, i32 %y) {
; CHECK-LABEL: @p3_scalar_shifted2_urem_by_const(
; CHECK-NEXT:    [[T0:%.*]] = and i32 [[X:%.*]], 2
; CHECK-NEXT:    [[T1:%.*]] = shl i32 [[T0]], [[Y:%.*]]
; CHECK-NEXT:    [[T2:%.*]] = urem i32 [[T1]], 3
; CHECK-NEXT:    [[T3:%.*]] = icmp eq i32 [[T2]], 0
; CHECK-NEXT:    ret i1 [[T3]]
;
  %t0 = and i32 %x, 2 ; clearly a power-of-two or zero
  %t1 = shl i32 %t0, %y ; will still be a power-of-two or zero with any %y
  %t2 = urem i32 %t1, 3 ; '3' is clearly not a power of two
  %t3 = icmp eq i32 %t2, 0
  ret i1 %t3
}

;------------------------------------------------------------------------------;
; Basic vector tests
;------------------------------------------------------------------------------;

define <4 x i1> @p4_vector_urem_by_const__splat(<4 x i32> %x, <4 x i32> %y) {
; CHECK-LABEL: @p4_vector_urem_by_const__splat(
; CHECK-NEXT:    [[T0:%.*]] = and <4 x i32> [[X:%.*]], <i32 128, i32 128, i32 128, i32 128>
; CHECK-NEXT:    [[T2:%.*]] = icmp eq <4 x i32> [[T0]], zeroinitializer
; CHECK-NEXT:    ret <4 x i1> [[T2]]
;
  %t0 = and <4 x i32> %x, <i32 128, i32 128, i32 128, i32 128> ; clearly a power-of-two or zero
  %t1 = urem <4 x i32> %t0, <i32 6, i32 6, i32 6, i32 6> ; '6' is clearly not a power of two
  %t2 = icmp eq <4 x i32> %t1, <i32 0, i32 0, i32 0, i32 0>
  ret <4 x i1> %t2
}

define <4 x i1> @p5_vector_urem_by_const__nonsplat(<4 x i32> %x, <4 x i32> %y) {
; CHECK-LABEL: @p5_vector_urem_by_const__nonsplat(
; CHECK-NEXT:    [[T0:%.*]] = and <4 x i32> [[X:%.*]], <i32 128, i32 2, i32 4, i32 8>
; CHECK-NEXT:    [[T1:%.*]] = urem <4 x i32> [[T0]], <i32 3, i32 5, i32 6, i32 9>
; CHECK-NEXT:    [[T2:%.*]] = icmp eq <4 x i32> [[T1]], zeroinitializer
; CHECK-NEXT:    ret <4 x i1> [[T2]]
;
  %t0 = and <4 x i32> %x, <i32 128, i32 2, i32 4, i32 8>
  %t1 = urem <4 x i32> %t0, <i32 3, i32 5, i32 6, i32 9>
  %t2 = icmp eq <4 x i32> %t1, <i32 0, i32 0, i32 0, i32 0>
  ret <4 x i1> %t2
}

define <4 x i1> @p6_vector_urem_by_const__nonsplat_undef0(<4 x i32> %x, <4 x i32> %y) {
; CHECK-LABEL: @p6_vector_urem_by_const__nonsplat_undef0(
; CHECK-NEXT:    [[T0:%.*]] = and <4 x i32> [[X:%.*]], <i32 128, i32 128, i32 undef, i32 128>
; CHECK-NEXT:    [[T1:%.*]] = urem <4 x i32> [[T0]], <i32 6, i32 6, i32 6, i32 6>
; CHECK-NEXT:    [[T2:%.*]] = icmp eq <4 x i32> [[T1]], zeroinitializer
; CHECK-NEXT:    ret <4 x i1> [[T2]]
;
  %t0 = and <4 x i32> %x, <i32 128, i32 128, i32 undef, i32 128>
  %t1 = urem <4 x i32> %t0, <i32 6, i32 6, i32 6, i32 6> ; '6' is clearly not a power of two
  %t2 = icmp eq <4 x i32> %t1, <i32 0, i32 0, i32 0, i32 0>
  ret <4 x i1> %t2
}

define <4 x i1> @p7_vector_urem_by_const__nonsplat_undef2(<4 x i32> %x, <4 x i32> %y) {
; CHECK-LABEL: @p7_vector_urem_by_const__nonsplat_undef2(
; CHECK-NEXT:    [[T0:%.*]] = and <4 x i32> [[X:%.*]], <i32 128, i32 128, i32 128, i32 128>
; CHECK-NEXT:    [[T2:%.*]] = icmp eq <4 x i32> [[T0]], <i32 0, i32 0, i32 undef, i32 0>
; CHECK-NEXT:    ret <4 x i1> [[T2]]
;
  %t0 = and <4 x i32> %x, <i32 128, i32 128, i32 128, i32 128> ; clearly a power-of-two or zero
  %t1 = urem <4 x i32> %t0, <i32 6, i32 6, i32 6, i32 6> ; '6' is clearly not a power of two
  %t2 = icmp eq <4 x i32> %t1, <i32 0, i32 0, i32 undef, i32 0>
  ret <4 x i1> %t2
}

define <4 x i1> @p8_vector_urem_by_const__nonsplat_undef3(<4 x i32> %x, <4 x i32> %y) {
; CHECK-LABEL: @p8_vector_urem_by_const__nonsplat_undef3(
; CHECK-NEXT:    [[T0:%.*]] = and <4 x i32> [[X:%.*]], <i32 128, i32 128, i32 undef, i32 128>
; CHECK-NEXT:    [[T1:%.*]] = urem <4 x i32> [[T0]], <i32 6, i32 6, i32 6, i32 6>
; CHECK-NEXT:    [[T2:%.*]] = icmp eq <4 x i32> [[T1]], <i32 0, i32 0, i32 undef, i32 0>
; CHECK-NEXT:    ret <4 x i1> [[T2]]
;
  %t0 = and <4 x i32> %x, <i32 128, i32 128, i32 undef, i32 128>
  %t1 = urem <4 x i32> %t0, <i32 6, i32 6, i32 6, i32 6> ; '6' is clearly not a power of two
  %t2 = icmp eq <4 x i32> %t1, <i32 0, i32 0, i32 undef, i32 0>
  ret <4 x i1> %t2
}

;------------------------------------------------------------------------------;
; Basic negative tests
;------------------------------------------------------------------------------;

define i1 @n0_urem_of_maybe_not_power_of_two(i32 %x, i32 %y) {
; CHECK-LABEL: @n0_urem_of_maybe_not_power_of_two(
; CHECK-NEXT:    [[T0:%.*]] = and i32 [[X:%.*]], 3
; CHECK-NEXT:    [[T1:%.*]] = urem i32 [[T0]], 3
; CHECK-NEXT:    [[T2:%.*]] = icmp eq i32 [[T1]], 0
; CHECK-NEXT:    ret i1 [[T2]]
;
  %t0 = and i32 %x, 3 ; up to two bits set, not power-of-two
  %t1 = urem i32 %t0, 3
  %t2 = icmp eq i32 %t1, 0
  ret i1 %t2
}

define i1 @n1_urem_by_maybe_power_of_two(i32 %x, i32 %y) {
; CHECK-LABEL: @n1_urem_by_maybe_power_of_two(
; CHECK-NEXT:    [[T0:%.*]] = and i32 [[X:%.*]], 128
; CHECK-NEXT:    [[T1:%.*]] = or i32 [[Y:%.*]], 1
; CHECK-NEXT:    [[T2:%.*]] = urem i32 [[T0]], [[T1]]
; CHECK-NEXT:    [[T3:%.*]] = icmp eq i32 [[T2]], 0
; CHECK-NEXT:    ret i1 [[T3]]
;
  %t0 = and i32 %x, 128 ; clearly a power-of-two or zero
  %t1 = or i32 %y, 1 ; one low bit set, may be a power of two
  %t2 = urem i32 %t0, %t1
  %t3 = icmp eq i32 %t2, 0
  ret i1 %t3
}
