; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -passes=gvn -S %s | FileCheck %s

; Test for PR46054. Make sure we correctly invalidate MemoryDependenceAnalysis,
; after removing a nonlocaldef.

target datalayout = "e-m:e-i64:64-f80:128-n8:16:32:64-S128"

define void @test_double(ptr %data) {
; CHECK-LABEL: @test_double(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[LUC:%.*]] = tail call noalias nonnull ptr @data()
; CHECK-NEXT:    store i64 1, ptr [[LUC]], align 8, !invariant.group !0
; CHECK-NEXT:    call void @fn(i64 1)
; CHECK-NEXT:    br i1 true, label [[A:%.*]], label [[ENTRY_B_CRIT_EDGE:%.*]]
; CHECK:       entry.B_crit_edge:
; CHECK-NEXT:    br label [[B:%.*]]
; CHECK:       A:
; CHECK-NEXT:    br label [[B]]
; CHECK:       B:
; CHECK-NEXT:    call void @fn(i64 1)
; CHECK-NEXT:    ret void
;
entry:
  %luc = tail call noalias nonnull ptr @data()
  store i64 1, ptr %luc, !invariant.group !0
  %QQ = load i64, ptr %luc, !invariant.group !0
  call void @fn(i64 %QQ)
  br i1 true, label %A, label %B

A:                                                ; preds = %loop
  br label %B

B:                                                ; preds = %A, %loop
  %QQ.1 = load i64, ptr %luc, !invariant.group !0
  call void @fn(i64 %QQ.1)
  ret void
}

declare void @fn(i64)

declare noalias ptr @data()


define void @test_double_ptr(ptr %data) {
; CHECK-LABEL: @test_double_ptr(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[LUC:%.*]] = tail call noalias nonnull ptr @data.ptr()
; CHECK-NEXT:    store ptr null, ptr [[LUC]], align 8, !invariant.group !0
; CHECK-NEXT:    call void @fn.ptr(ptr null)
; CHECK-NEXT:    br i1 true, label [[A:%.*]], label [[ENTRY_B_CRIT_EDGE:%.*]]
; CHECK:       entry.B_crit_edge:
; CHECK-NEXT:    br label [[B:%.*]]
; CHECK:       A:
; CHECK-NEXT:    br label [[B]]
; CHECK:       B:
; CHECK-NEXT:    call void @fn.ptr(ptr null)
; CHECK-NEXT:    ret void
;
entry:
  %luc = tail call noalias nonnull ptr @data.ptr()
  store ptr null, ptr %luc, !invariant.group !0
  %QQ = load ptr, ptr %luc, !invariant.group !0
  call void @fn.ptr(ptr %QQ)
  br i1 true, label %A, label %B

A:                                                ; preds = %loop
  br label %B

B:                                                ; preds = %A, %loop
  %QQ.1 = load ptr, ptr %luc, !invariant.group !0
  call void @fn.ptr(ptr %QQ.1)
  ret void
}


declare void @fn.ptr(ptr)

declare noalias ptr @data.ptr()

!0 = distinct !{}
