; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=dse -S | FileCheck %s
; RUN: opt < %s -aa-pipeline=basic-aa -passes=dse -S | FileCheck %s

declare void @use(ptr)

define void @test1() {
; CHECK-LABEL: @test1(
; CHECK-NEXT:    [[A:%.*]] = alloca i64, align 8
; CHECK-NEXT:    call void @use(ptr [[A]])
; CHECK-NEXT:    [[PTR2:%.*]] = getelementptr i8, ptr [[A]], i32 1
; CHECK-NEXT:    store i8 10, ptr [[A]], align 1
; CHECK-NEXT:    store i8 20, ptr [[PTR2]], align 1
; CHECK-NEXT:    [[LV:%.*]] = load i64, ptr [[A]], align 4
; CHECK-NEXT:    store i8 0, ptr [[A]], align 1
; CHECK-NEXT:    call void @use(ptr [[A]])
; CHECK-NEXT:    ret void
;
  %a = alloca i64
  call void @use(ptr %a)
  %ptr2 = getelementptr i8, ptr %a, i32 1

  store i8 10, ptr %a
  store i8 20, ptr %ptr2
  %lv = load i64, ptr %a
  store i8 0, ptr %a

  call void @use(ptr %a)
  ret void
}

define void @test2() {
; CHECK-LABEL: @test2(
; CHECK-NEXT:    [[A:%.*]] = alloca i64, align 8
; CHECK-NEXT:    call void @use(ptr [[A]])
; CHECK-NEXT:    [[PTR2:%.*]] = getelementptr i8, ptr [[A]], i32 1
; CHECK-NEXT:    store i8 10, ptr [[A]], align 1
; CHECK-NEXT:    store i8 20, ptr [[PTR2]], align 1
; CHECK-NEXT:    br i1 undef, label [[BB1:%.*]], label [[END:%.*]]
; CHECK:       bb1:
; CHECK-NEXT:    [[LV:%.*]] = load i64, ptr [[A]], align 4
; CHECK-NEXT:    br label [[END]]
; CHECK:       end:
; CHECK-NEXT:    store i8 0, ptr [[A]], align 1
; CHECK-NEXT:    call void @use(ptr [[A]])
; CHECK-NEXT:    ret void
;
  %a = alloca i64
  call void @use(ptr %a)
  %ptr2 = getelementptr i8, ptr %a, i32 1

  store i8 10, ptr %a
  store i8 20, ptr %ptr2
  br i1 undef, label %bb1, label %end

bb1:
  %lv = load i64, ptr %a
  br label %end

end:
  store i8 0, ptr %a
  call void @use(ptr %a)
  ret void
}

; The store to %a0 is dead, because only %a1 is read later.
define void @test3(i1 %c) {
; CHECK-LABEL: @test3(
; CHECK-NEXT:    [[A:%.*]] = alloca [2 x i8], align 1
; CHECK-NEXT:    [[A1:%.*]] = getelementptr [2 x i8], ptr [[A]], i32 0, i32 1
; CHECK-NEXT:    br i1 [[C:%.*]], label [[IF:%.*]], label [[ELSE:%.*]]
; CHECK:       if:
; CHECK-NEXT:    store [2 x i8] zeroinitializer, ptr [[A]], align 1
; CHECK-NEXT:    br label [[ELSE]]
; CHECK:       else:
; CHECK-NEXT:    [[TMP1:%.*]] = load i8, ptr [[A1]], align 1
; CHECK-NEXT:    ret void
;
  %a = alloca [2 x i8]
  %a1 = getelementptr [2 x i8], ptr %a, i32 0, i32 1
  store i8 1, ptr %a
  br i1 %c, label %if, label %else

if:
  store [2 x i8] zeroinitializer, ptr %a
  br label %else

else:
  load i8, ptr %a1
  ret void
}

; Variation on the previous test case, where only the store to %a is dead,
; but not the one to %a1. This tests for a potential caching bug.
define void @test4(i1 %c) {
; CHECK-LABEL: @test4(
; CHECK-NEXT:    [[A:%.*]] = alloca [2 x i8], align 1
; CHECK-NEXT:    [[A1:%.*]] = getelementptr [2 x i8], ptr [[A]], i32 0, i32 1
; CHECK-NEXT:    store i8 1, ptr [[A1]], align 1
; CHECK-NEXT:    br i1 [[C:%.*]], label [[IF:%.*]], label [[ELSE:%.*]]
; CHECK:       if:
; CHECK-NEXT:    store [2 x i8] zeroinitializer, ptr [[A]], align 1
; CHECK-NEXT:    br label [[ELSE]]
; CHECK:       else:
; CHECK-NEXT:    [[TMP1:%.*]] = load i8, ptr [[A1]], align 1
; CHECK-NEXT:    ret void
;
  %a = alloca [2 x i8]
  %a1 = getelementptr [2 x i8], ptr %a, i32 0, i32 1
  store i8 1, ptr %a1
  store i8 1, ptr %a
  br i1 %c, label %if, label %else

if:
  store [2 x i8] zeroinitializer, ptr %a
  br label %else

else:
  load i8, ptr %a1
  ret void
}
