// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py
// RUN: %clang_cc1 -triple thumbv8.1m.main-none-none-eabi -target-feature +mve.fp -mfloat-abi hard -fallow-half-arguments-and-returns -O0 -disable-O0-optnone -S -emit-llvm -o - %s | opt -S -mem2reg -sroa -early-cse | FileCheck %s --check-prefix=BOTH --check-prefix=LE
// RUN: %clang_cc1 -triple thumbv8.1m.main-none-none-eabi -target-feature +mve.fp -mfloat-abi hard -fallow-half-arguments-and-returns -O0 -disable-O0-optnone -DPOLYMORPHIC -S -emit-llvm -o - %s | opt -S -mem2reg -sroa -early-cse | FileCheck %s --check-prefix=BOTH --check-prefix=LE
// RUN: %clang_cc1 -triple thumbebv8.1m.main-arm-none-eabi -target-feature +mve.fp -mfloat-abi hard -fallow-half-arguments-and-returns -O0 -disable-O0-optnone -S -emit-llvm -o - %s | opt -S -mem2reg -sroa -early-cse | FileCheck %s --check-prefix=BOTH --check-prefix=BE
// RUN: %clang_cc1 -triple thumbebv8.1m.main-arm-none-eabi -target-feature +mve.fp -mfloat-abi hard -fallow-half-arguments-and-returns -O0 -disable-O0-optnone -DPOLYMORPHIC -S -emit-llvm -o - %s | opt -S -mem2reg -sroa -early-cse | FileCheck %s --check-prefix=BOTH --check-prefix=BE

#include <arm_mve.h>

// LE-LABEL: @test_vreinterpretq_f16_f32(
// LE-NEXT:  entry:
// LE-NEXT:    [[TMP0:%.*]] = bitcast <4 x float> [[A:%.*]] to <8 x half>
// LE-NEXT:    ret <8 x half> [[TMP0]]
//
// BE-LABEL: @test_vreinterpretq_f16_f32(
// BE-NEXT:  entry:
// BE-NEXT:    [[TMP0:%.*]] = call <8 x half> @llvm.arm.mve.vreinterpretq.v8f16.v4f32(<4 x float> [[A:%.*]])
// BE-NEXT:    ret <8 x half> [[TMP0]]
//
float16x8_t test_vreinterpretq_f16_f32(float32x4_t a)
{
#ifdef POLYMORPHIC
    return vreinterpretq_f16(a);
#else /* POLYMORPHIC */
    return vreinterpretq_f16_f32(a);
#endif /* POLYMORPHIC */
}

// BOTH-LABEL: @test_vreinterpretq_f16_s16(
// BOTH-NEXT:  entry:
// BOTH-NEXT:    [[TMP0:%.*]] = bitcast <8 x i16> [[A:%.*]] to <8 x half>
// BOTH-NEXT:    ret <8 x half> [[TMP0]]
//
float16x8_t test_vreinterpretq_f16_s16(int16x8_t a)
{
#ifdef POLYMORPHIC
    return vreinterpretq_f16(a);
#else /* POLYMORPHIC */
    return vreinterpretq_f16_s16(a);
#endif /* POLYMORPHIC */
}

// LE-LABEL: @test_vreinterpretq_f16_s32(
// LE-NEXT:  entry:
// LE-NEXT:    [[TMP0:%.*]] = bitcast <4 x i32> [[A:%.*]] to <8 x half>
// LE-NEXT:    ret <8 x half> [[TMP0]]
//
// BE-LABEL: @test_vreinterpretq_f16_s32(
// BE-NEXT:  entry:
// BE-NEXT:    [[TMP0:%.*]] = call <8 x half> @llvm.arm.mve.vreinterpretq.v8f16.v4i32(<4 x i32> [[A:%.*]])
// BE-NEXT:    ret <8 x half> [[TMP0]]
//
float16x8_t test_vreinterpretq_f16_s32(int32x4_t a)
{
#ifdef POLYMORPHIC
    return vreinterpretq_f16(a);
#else /* POLYMORPHIC */
    return vreinterpretq_f16_s32(a);
#endif /* POLYMORPHIC */
}

// LE-LABEL: @test_vreinterpretq_f16_s64(
// LE-NEXT:  entry:
// LE-NEXT:    [[TMP0:%.*]] = bitcast <2 x i64> [[A:%.*]] to <8 x half>
// LE-NEXT:    ret <8 x half> [[TMP0]]
//
// BE-LABEL: @test_vreinterpretq_f16_s64(
// BE-NEXT:  entry:
// BE-NEXT:    [[TMP0:%.*]] = call <8 x half> @llvm.arm.mve.vreinterpretq.v8f16.v2i64(<2 x i64> [[A:%.*]])
// BE-NEXT:    ret <8 x half> [[TMP0]]
//
float16x8_t test_vreinterpretq_f16_s64(int64x2_t a)
{
#ifdef POLYMORPHIC
    return vreinterpretq_f16(a);
#else /* POLYMORPHIC */
    return vreinterpretq_f16_s64(a);
#endif /* POLYMORPHIC */
}

// LE-LABEL: @test_vreinterpretq_f16_s8(
// LE-NEXT:  entry:
// LE-NEXT:    [[TMP0:%.*]] = bitcast <16 x i8> [[A:%.*]] to <8 x half>
// LE-NEXT:    ret <8 x half> [[TMP0]]
//
// BE-LABEL: @test_vreinterpretq_f16_s8(
// BE-NEXT:  entry:
// BE-NEXT:    [[TMP0:%.*]] = call <8 x half> @llvm.arm.mve.vreinterpretq.v8f16.v16i8(<16 x i8> [[A:%.*]])
// BE-NEXT:    ret <8 x half> [[TMP0]]
//
float16x8_t test_vreinterpretq_f16_s8(int8x16_t a)
{
#ifdef POLYMORPHIC
    return vreinterpretq_f16(a);
#else /* POLYMORPHIC */
    return vreinterpretq_f16_s8(a);
#endif /* POLYMORPHIC */
}

// BOTH-LABEL: @test_vreinterpretq_f16_u16(
// BOTH-NEXT:  entry:
// BOTH-NEXT:    [[TMP0:%.*]] = bitcast <8 x i16> [[A:%.*]] to <8 x half>
// BOTH-NEXT:    ret <8 x half> [[TMP0]]
//
float16x8_t test_vreinterpretq_f16_u16(uint16x8_t a)
{
#ifdef POLYMORPHIC
    return vreinterpretq_f16(a);
#else /* POLYMORPHIC */
    return vreinterpretq_f16_u16(a);
#endif /* POLYMORPHIC */
}

// LE-LABEL: @test_vreinterpretq_f16_u32(
// LE-NEXT:  entry:
// LE-NEXT:    [[TMP0:%.*]] = bitcast <4 x i32> [[A:%.*]] to <8 x half>
// LE-NEXT:    ret <8 x half> [[TMP0]]
//
// BE-LABEL: @test_vreinterpretq_f16_u32(
// BE-NEXT:  entry:
// BE-NEXT:    [[TMP0:%.*]] = call <8 x half> @llvm.arm.mve.vreinterpretq.v8f16.v4i32(<4 x i32> [[A:%.*]])
// BE-NEXT:    ret <8 x half> [[TMP0]]
//
float16x8_t test_vreinterpretq_f16_u32(uint32x4_t a)
{
#ifdef POLYMORPHIC
    return vreinterpretq_f16(a);
#else /* POLYMORPHIC */
    return vreinterpretq_f16_u32(a);
#endif /* POLYMORPHIC */
}

// LE-LABEL: @test_vreinterpretq_f16_u64(
// LE-NEXT:  entry:
// LE-NEXT:    [[TMP0:%.*]] = bitcast <2 x i64> [[A:%.*]] to <8 x half>
// LE-NEXT:    ret <8 x half> [[TMP0]]
//
// BE-LABEL: @test_vreinterpretq_f16_u64(
// BE-NEXT:  entry:
// BE-NEXT:    [[TMP0:%.*]] = call <8 x half> @llvm.arm.mve.vreinterpretq.v8f16.v2i64(<2 x i64> [[A:%.*]])
// BE-NEXT:    ret <8 x half> [[TMP0]]
//
float16x8_t test_vreinterpretq_f16_u64(uint64x2_t a)
{
#ifdef POLYMORPHIC
    return vreinterpretq_f16(a);
#else /* POLYMORPHIC */
    return vreinterpretq_f16_u64(a);
#endif /* POLYMORPHIC */
}

// LE-LABEL: @test_vreinterpretq_f16_u8(
// LE-NEXT:  entry:
// LE-NEXT:    [[TMP0:%.*]] = bitcast <16 x i8> [[A:%.*]] to <8 x half>
// LE-NEXT:    ret <8 x half> [[TMP0]]
//
// BE-LABEL: @test_vreinterpretq_f16_u8(
// BE-NEXT:  entry:
// BE-NEXT:    [[TMP0:%.*]] = call <8 x half> @llvm.arm.mve.vreinterpretq.v8f16.v16i8(<16 x i8> [[A:%.*]])
// BE-NEXT:    ret <8 x half> [[TMP0]]
//
float16x8_t test_vreinterpretq_f16_u8(uint8x16_t a)
{
#ifdef POLYMORPHIC
    return vreinterpretq_f16(a);
#else /* POLYMORPHIC */
    return vreinterpretq_f16_u8(a);
#endif /* POLYMORPHIC */
}

// LE-LABEL: @test_vreinterpretq_f32_f16(
// LE-NEXT:  entry:
// LE-NEXT:    [[TMP0:%.*]] = bitcast <8 x half> [[A:%.*]] to <4 x float>
// LE-NEXT:    ret <4 x float> [[TMP0]]
//
// BE-LABEL: @test_vreinterpretq_f32_f16(
// BE-NEXT:  entry:
// BE-NEXT:    [[TMP0:%.*]] = call <4 x float> @llvm.arm.mve.vreinterpretq.v4f32.v8f16(<8 x half> [[A:%.*]])
// BE-NEXT:    ret <4 x float> [[TMP0]]
//
float32x4_t test_vreinterpretq_f32_f16(float16x8_t a)
{
#ifdef POLYMORPHIC
    return vreinterpretq_f32(a);
#else /* POLYMORPHIC */
    return vreinterpretq_f32_f16(a);
#endif /* POLYMORPHIC */
}

// LE-LABEL: @test_vreinterpretq_f32_s16(
// LE-NEXT:  entry:
// LE-NEXT:    [[TMP0:%.*]] = bitcast <8 x i16> [[A:%.*]] to <4 x float>
// LE-NEXT:    ret <4 x float> [[TMP0]]
//
// BE-LABEL: @test_vreinterpretq_f32_s16(
// BE-NEXT:  entry:
// BE-NEXT:    [[TMP0:%.*]] = call <4 x float> @llvm.arm.mve.vreinterpretq.v4f32.v8i16(<8 x i16> [[A:%.*]])
// BE-NEXT:    ret <4 x float> [[TMP0]]
//
float32x4_t test_vreinterpretq_f32_s16(int16x8_t a)
{
#ifdef POLYMORPHIC
    return vreinterpretq_f32(a);
#else /* POLYMORPHIC */
    return vreinterpretq_f32_s16(a);
#endif /* POLYMORPHIC */
}

// BOTH-LABEL: @test_vreinterpretq_f32_s32(
// BOTH-NEXT:  entry:
// BOTH-NEXT:    [[TMP0:%.*]] = bitcast <4 x i32> [[A:%.*]] to <4 x float>
// BOTH-NEXT:    ret <4 x float> [[TMP0]]
//
float32x4_t test_vreinterpretq_f32_s32(int32x4_t a)
{
#ifdef POLYMORPHIC
    return vreinterpretq_f32(a);
#else /* POLYMORPHIC */
    return vreinterpretq_f32_s32(a);
#endif /* POLYMORPHIC */
}

// LE-LABEL: @test_vreinterpretq_f32_s64(
// LE-NEXT:  entry:
// LE-NEXT:    [[TMP0:%.*]] = bitcast <2 x i64> [[A:%.*]] to <4 x float>
// LE-NEXT:    ret <4 x float> [[TMP0]]
//
// BE-LABEL: @test_vreinterpretq_f32_s64(
// BE-NEXT:  entry:
// BE-NEXT:    [[TMP0:%.*]] = call <4 x float> @llvm.arm.mve.vreinterpretq.v4f32.v2i64(<2 x i64> [[A:%.*]])
// BE-NEXT:    ret <4 x float> [[TMP0]]
//
float32x4_t test_vreinterpretq_f32_s64(int64x2_t a)
{
#ifdef POLYMORPHIC
    return vreinterpretq_f32(a);
#else /* POLYMORPHIC */
    return vreinterpretq_f32_s64(a);
#endif /* POLYMORPHIC */
}

// LE-LABEL: @test_vreinterpretq_f32_s8(
// LE-NEXT:  entry:
// LE-NEXT:    [[TMP0:%.*]] = bitcast <16 x i8> [[A:%.*]] to <4 x float>
// LE-NEXT:    ret <4 x float> [[TMP0]]
//
// BE-LABEL: @test_vreinterpretq_f32_s8(
// BE-NEXT:  entry:
// BE-NEXT:    [[TMP0:%.*]] = call <4 x float> @llvm.arm.mve.vreinterpretq.v4f32.v16i8(<16 x i8> [[A:%.*]])
// BE-NEXT:    ret <4 x float> [[TMP0]]
//
float32x4_t test_vreinterpretq_f32_s8(int8x16_t a)
{
#ifdef POLYMORPHIC
    return vreinterpretq_f32(a);
#else /* POLYMORPHIC */
    return vreinterpretq_f32_s8(a);
#endif /* POLYMORPHIC */
}

// LE-LABEL: @test_vreinterpretq_f32_u16(
// LE-NEXT:  entry:
// LE-NEXT:    [[TMP0:%.*]] = bitcast <8 x i16> [[A:%.*]] to <4 x float>
// LE-NEXT:    ret <4 x float> [[TMP0]]
//
// BE-LABEL: @test_vreinterpretq_f32_u16(
// BE-NEXT:  entry:
// BE-NEXT:    [[TMP0:%.*]] = call <4 x float> @llvm.arm.mve.vreinterpretq.v4f32.v8i16(<8 x i16> [[A:%.*]])
// BE-NEXT:    ret <4 x float> [[TMP0]]
//
float32x4_t test_vreinterpretq_f32_u16(uint16x8_t a)
{
#ifdef POLYMORPHIC
    return vreinterpretq_f32(a);
#else /* POLYMORPHIC */
    return vreinterpretq_f32_u16(a);
#endif /* POLYMORPHIC */
}

// BOTH-LABEL: @test_vreinterpretq_f32_u32(
// BOTH-NEXT:  entry:
// BOTH-NEXT:    [[TMP0:%.*]] = bitcast <4 x i32> [[A:%.*]] to <4 x float>
// BOTH-NEXT:    ret <4 x float> [[TMP0]]
//
float32x4_t test_vreinterpretq_f32_u32(uint32x4_t a)
{
#ifdef POLYMORPHIC
    return vreinterpretq_f32(a);
#else /* POLYMORPHIC */
    return vreinterpretq_f32_u32(a);
#endif /* POLYMORPHIC */
}

// LE-LABEL: @test_vreinterpretq_f32_u64(
// LE-NEXT:  entry:
// LE-NEXT:    [[TMP0:%.*]] = bitcast <2 x i64> [[A:%.*]] to <4 x float>
// LE-NEXT:    ret <4 x float> [[TMP0]]
//
// BE-LABEL: @test_vreinterpretq_f32_u64(
// BE-NEXT:  entry:
// BE-NEXT:    [[TMP0:%.*]] = call <4 x float> @llvm.arm.mve.vreinterpretq.v4f32.v2i64(<2 x i64> [[A:%.*]])
// BE-NEXT:    ret <4 x float> [[TMP0]]
//
float32x4_t test_vreinterpretq_f32_u64(uint64x2_t a)
{
#ifdef POLYMORPHIC
    return vreinterpretq_f32(a);
#else /* POLYMORPHIC */
    return vreinterpretq_f32_u64(a);
#endif /* POLYMORPHIC */
}

// LE-LABEL: @test_vreinterpretq_f32_u8(
// LE-NEXT:  entry:
// LE-NEXT:    [[TMP0:%.*]] = bitcast <16 x i8> [[A:%.*]] to <4 x float>
// LE-NEXT:    ret <4 x float> [[TMP0]]
//
// BE-LABEL: @test_vreinterpretq_f32_u8(
// BE-NEXT:  entry:
// BE-NEXT:    [[TMP0:%.*]] = call <4 x float> @llvm.arm.mve.vreinterpretq.v4f32.v16i8(<16 x i8> [[A:%.*]])
// BE-NEXT:    ret <4 x float> [[TMP0]]
//
float32x4_t test_vreinterpretq_f32_u8(uint8x16_t a)
{
#ifdef POLYMORPHIC
    return vreinterpretq_f32(a);
#else /* POLYMORPHIC */
    return vreinterpretq_f32_u8(a);
#endif /* POLYMORPHIC */
}

// BOTH-LABEL: @test_vreinterpretq_s16_f16(
// BOTH-NEXT:  entry:
// BOTH-NEXT:    [[TMP0:%.*]] = bitcast <8 x half> [[A:%.*]] to <8 x i16>
// BOTH-NEXT:    ret <8 x i16> [[TMP0]]
//
int16x8_t test_vreinterpretq_s16_f16(float16x8_t a)
{
#ifdef POLYMORPHIC
    return vreinterpretq_s16(a);
#else /* POLYMORPHIC */
    return vreinterpretq_s16_f16(a);
#endif /* POLYMORPHIC */
}

// LE-LABEL: @test_vreinterpretq_s16_f32(
// LE-NEXT:  entry:
// LE-NEXT:    [[TMP0:%.*]] = bitcast <4 x float> [[A:%.*]] to <8 x i16>
// LE-NEXT:    ret <8 x i16> [[TMP0]]
//
// BE-LABEL: @test_vreinterpretq_s16_f32(
// BE-NEXT:  entry:
// BE-NEXT:    [[TMP0:%.*]] = call <8 x i16> @llvm.arm.mve.vreinterpretq.v8i16.v4f32(<4 x float> [[A:%.*]])
// BE-NEXT:    ret <8 x i16> [[TMP0]]
//
int16x8_t test_vreinterpretq_s16_f32(float32x4_t a)
{
#ifdef POLYMORPHIC
    return vreinterpretq_s16(a);
#else /* POLYMORPHIC */
    return vreinterpretq_s16_f32(a);
#endif /* POLYMORPHIC */
}

// LE-LABEL: @test_vreinterpretq_s16_s32(
// LE-NEXT:  entry:
// LE-NEXT:    [[TMP0:%.*]] = bitcast <4 x i32> [[A:%.*]] to <8 x i16>
// LE-NEXT:    ret <8 x i16> [[TMP0]]
//
// BE-LABEL: @test_vreinterpretq_s16_s32(
// BE-NEXT:  entry:
// BE-NEXT:    [[TMP0:%.*]] = call <8 x i16> @llvm.arm.mve.vreinterpretq.v8i16.v4i32(<4 x i32> [[A:%.*]])
// BE-NEXT:    ret <8 x i16> [[TMP0]]
//
int16x8_t test_vreinterpretq_s16_s32(int32x4_t a)
{
#ifdef POLYMORPHIC
    return vreinterpretq_s16(a);
#else /* POLYMORPHIC */
    return vreinterpretq_s16_s32(a);
#endif /* POLYMORPHIC */
}

// LE-LABEL: @test_vreinterpretq_s16_s64(
// LE-NEXT:  entry:
// LE-NEXT:    [[TMP0:%.*]] = bitcast <2 x i64> [[A:%.*]] to <8 x i16>
// LE-NEXT:    ret <8 x i16> [[TMP0]]
//
// BE-LABEL: @test_vreinterpretq_s16_s64(
// BE-NEXT:  entry:
// BE-NEXT:    [[TMP0:%.*]] = call <8 x i16> @llvm.arm.mve.vreinterpretq.v8i16.v2i64(<2 x i64> [[A:%.*]])
// BE-NEXT:    ret <8 x i16> [[TMP0]]
//
int16x8_t test_vreinterpretq_s16_s64(int64x2_t a)
{
#ifdef POLYMORPHIC
    return vreinterpretq_s16(a);
#else /* POLYMORPHIC */
    return vreinterpretq_s16_s64(a);
#endif /* POLYMORPHIC */
}

// LE-LABEL: @test_vreinterpretq_s16_s8(
// LE-NEXT:  entry:
// LE-NEXT:    [[TMP0:%.*]] = bitcast <16 x i8> [[A:%.*]] to <8 x i16>
// LE-NEXT:    ret <8 x i16> [[TMP0]]
//
// BE-LABEL: @test_vreinterpretq_s16_s8(
// BE-NEXT:  entry:
// BE-NEXT:    [[TMP0:%.*]] = call <8 x i16> @llvm.arm.mve.vreinterpretq.v8i16.v16i8(<16 x i8> [[A:%.*]])
// BE-NEXT:    ret <8 x i16> [[TMP0]]
//
int16x8_t test_vreinterpretq_s16_s8(int8x16_t a)
{
#ifdef POLYMORPHIC
    return vreinterpretq_s16(a);
#else /* POLYMORPHIC */
    return vreinterpretq_s16_s8(a);
#endif /* POLYMORPHIC */
}

// BOTH-LABEL: @test_vreinterpretq_s16_u16(
// BOTH-NEXT:  entry:
// BOTH-NEXT:    ret <8 x i16> [[A:%.*]]
//
int16x8_t test_vreinterpretq_s16_u16(uint16x8_t a)
{
#ifdef POLYMORPHIC
    return vreinterpretq_s16(a);
#else /* POLYMORPHIC */
    return vreinterpretq_s16_u16(a);
#endif /* POLYMORPHIC */
}

// LE-LABEL: @test_vreinterpretq_s16_u32(
// LE-NEXT:  entry:
// LE-NEXT:    [[TMP0:%.*]] = bitcast <4 x i32> [[A:%.*]] to <8 x i16>
// LE-NEXT:    ret <8 x i16> [[TMP0]]
//
// BE-LABEL: @test_vreinterpretq_s16_u32(
// BE-NEXT:  entry:
// BE-NEXT:    [[TMP0:%.*]] = call <8 x i16> @llvm.arm.mve.vreinterpretq.v8i16.v4i32(<4 x i32> [[A:%.*]])
// BE-NEXT:    ret <8 x i16> [[TMP0]]
//
int16x8_t test_vreinterpretq_s16_u32(uint32x4_t a)
{
#ifdef POLYMORPHIC
    return vreinterpretq_s16(a);
#else /* POLYMORPHIC */
    return vreinterpretq_s16_u32(a);
#endif /* POLYMORPHIC */
}

// LE-LABEL: @test_vreinterpretq_s16_u64(
// LE-NEXT:  entry:
// LE-NEXT:    [[TMP0:%.*]] = bitcast <2 x i64> [[A:%.*]] to <8 x i16>
// LE-NEXT:    ret <8 x i16> [[TMP0]]
//
// BE-LABEL: @test_vreinterpretq_s16_u64(
// BE-NEXT:  entry:
// BE-NEXT:    [[TMP0:%.*]] = call <8 x i16> @llvm.arm.mve.vreinterpretq.v8i16.v2i64(<2 x i64> [[A:%.*]])
// BE-NEXT:    ret <8 x i16> [[TMP0]]
//
int16x8_t test_vreinterpretq_s16_u64(uint64x2_t a)
{
#ifdef POLYMORPHIC
    return vreinterpretq_s16(a);
#else /* POLYMORPHIC */
    return vreinterpretq_s16_u64(a);
#endif /* POLYMORPHIC */
}

// LE-LABEL: @test_vreinterpretq_s16_u8(
// LE-NEXT:  entry:
// LE-NEXT:    [[TMP0:%.*]] = bitcast <16 x i8> [[A:%.*]] to <8 x i16>
// LE-NEXT:    ret <8 x i16> [[TMP0]]
//
// BE-LABEL: @test_vreinterpretq_s16_u8(
// BE-NEXT:  entry:
// BE-NEXT:    [[TMP0:%.*]] = call <8 x i16> @llvm.arm.mve.vreinterpretq.v8i16.v16i8(<16 x i8> [[A:%.*]])
// BE-NEXT:    ret <8 x i16> [[TMP0]]
//
int16x8_t test_vreinterpretq_s16_u8(uint8x16_t a)
{
#ifdef POLYMORPHIC
    return vreinterpretq_s16(a);
#else /* POLYMORPHIC */
    return vreinterpretq_s16_u8(a);
#endif /* POLYMORPHIC */
}

// LE-LABEL: @test_vreinterpretq_s32_f16(
// LE-NEXT:  entry:
// LE-NEXT:    [[TMP0:%.*]] = bitcast <8 x half> [[A:%.*]] to <4 x i32>
// LE-NEXT:    ret <4 x i32> [[TMP0]]
//
// BE-LABEL: @test_vreinterpretq_s32_f16(
// BE-NEXT:  entry:
// BE-NEXT:    [[TMP0:%.*]] = call <4 x i32> @llvm.arm.mve.vreinterpretq.v4i32.v8f16(<8 x half> [[A:%.*]])
// BE-NEXT:    ret <4 x i32> [[TMP0]]
//
int32x4_t test_vreinterpretq_s32_f16(float16x8_t a)
{
#ifdef POLYMORPHIC
    return vreinterpretq_s32(a);
#else /* POLYMORPHIC */
    return vreinterpretq_s32_f16(a);
#endif /* POLYMORPHIC */
}

// BOTH-LABEL: @test_vreinterpretq_s32_f32(
// BOTH-NEXT:  entry:
// BOTH-NEXT:    [[TMP0:%.*]] = bitcast <4 x float> [[A:%.*]] to <4 x i32>
// BOTH-NEXT:    ret <4 x i32> [[TMP0]]
//
int32x4_t test_vreinterpretq_s32_f32(float32x4_t a)
{
#ifdef POLYMORPHIC
    return vreinterpretq_s32(a);
#else /* POLYMORPHIC */
    return vreinterpretq_s32_f32(a);
#endif /* POLYMORPHIC */
}

// LE-LABEL: @test_vreinterpretq_s32_s16(
// LE-NEXT:  entry:
// LE-NEXT:    [[TMP0:%.*]] = bitcast <8 x i16> [[A:%.*]] to <4 x i32>
// LE-NEXT:    ret <4 x i32> [[TMP0]]
//
// BE-LABEL: @test_vreinterpretq_s32_s16(
// BE-NEXT:  entry:
// BE-NEXT:    [[TMP0:%.*]] = call <4 x i32> @llvm.arm.mve.vreinterpretq.v4i32.v8i16(<8 x i16> [[A:%.*]])
// BE-NEXT:    ret <4 x i32> [[TMP0]]
//
int32x4_t test_vreinterpretq_s32_s16(int16x8_t a)
{
#ifdef POLYMORPHIC
    return vreinterpretq_s32(a);
#else /* POLYMORPHIC */
    return vreinterpretq_s32_s16(a);
#endif /* POLYMORPHIC */
}

// LE-LABEL: @test_vreinterpretq_s32_s64(
// LE-NEXT:  entry:
// LE-NEXT:    [[TMP0:%.*]] = bitcast <2 x i64> [[A:%.*]] to <4 x i32>
// LE-NEXT:    ret <4 x i32> [[TMP0]]
//
// BE-LABEL: @test_vreinterpretq_s32_s64(
// BE-NEXT:  entry:
// BE-NEXT:    [[TMP0:%.*]] = call <4 x i32> @llvm.arm.mve.vreinterpretq.v4i32.v2i64(<2 x i64> [[A:%.*]])
// BE-NEXT:    ret <4 x i32> [[TMP0]]
//
int32x4_t test_vreinterpretq_s32_s64(int64x2_t a)
{
#ifdef POLYMORPHIC
    return vreinterpretq_s32(a);
#else /* POLYMORPHIC */
    return vreinterpretq_s32_s64(a);
#endif /* POLYMORPHIC */
}

// LE-LABEL: @test_vreinterpretq_s32_s8(
// LE-NEXT:  entry:
// LE-NEXT:    [[TMP0:%.*]] = bitcast <16 x i8> [[A:%.*]] to <4 x i32>
// LE-NEXT:    ret <4 x i32> [[TMP0]]
//
// BE-LABEL: @test_vreinterpretq_s32_s8(
// BE-NEXT:  entry:
// BE-NEXT:    [[TMP0:%.*]] = call <4 x i32> @llvm.arm.mve.vreinterpretq.v4i32.v16i8(<16 x i8> [[A:%.*]])
// BE-NEXT:    ret <4 x i32> [[TMP0]]
//
int32x4_t test_vreinterpretq_s32_s8(int8x16_t a)
{
#ifdef POLYMORPHIC
    return vreinterpretq_s32(a);
#else /* POLYMORPHIC */
    return vreinterpretq_s32_s8(a);
#endif /* POLYMORPHIC */
}

// LE-LABEL: @test_vreinterpretq_s32_u16(
// LE-NEXT:  entry:
// LE-NEXT:    [[TMP0:%.*]] = bitcast <8 x i16> [[A:%.*]] to <4 x i32>
// LE-NEXT:    ret <4 x i32> [[TMP0]]
//
// BE-LABEL: @test_vreinterpretq_s32_u16(
// BE-NEXT:  entry:
// BE-NEXT:    [[TMP0:%.*]] = call <4 x i32> @llvm.arm.mve.vreinterpretq.v4i32.v8i16(<8 x i16> [[A:%.*]])
// BE-NEXT:    ret <4 x i32> [[TMP0]]
//
int32x4_t test_vreinterpretq_s32_u16(uint16x8_t a)
{
#ifdef POLYMORPHIC
    return vreinterpretq_s32(a);
#else /* POLYMORPHIC */
    return vreinterpretq_s32_u16(a);
#endif /* POLYMORPHIC */
}

// BOTH-LABEL: @test_vreinterpretq_s32_u32(
// BOTH-NEXT:  entry:
// BOTH-NEXT:    ret <4 x i32> [[A:%.*]]
//
int32x4_t test_vreinterpretq_s32_u32(uint32x4_t a)
{
#ifdef POLYMORPHIC
    return vreinterpretq_s32(a);
#else /* POLYMORPHIC */
    return vreinterpretq_s32_u32(a);
#endif /* POLYMORPHIC */
}

// LE-LABEL: @test_vreinterpretq_s32_u64(
// LE-NEXT:  entry:
// LE-NEXT:    [[TMP0:%.*]] = bitcast <2 x i64> [[A:%.*]] to <4 x i32>
// LE-NEXT:    ret <4 x i32> [[TMP0]]
//
// BE-LABEL: @test_vreinterpretq_s32_u64(
// BE-NEXT:  entry:
// BE-NEXT:    [[TMP0:%.*]] = call <4 x i32> @llvm.arm.mve.vreinterpretq.v4i32.v2i64(<2 x i64> [[A:%.*]])
// BE-NEXT:    ret <4 x i32> [[TMP0]]
//
int32x4_t test_vreinterpretq_s32_u64(uint64x2_t a)
{
#ifdef POLYMORPHIC
    return vreinterpretq_s32(a);
#else /* POLYMORPHIC */
    return vreinterpretq_s32_u64(a);
#endif /* POLYMORPHIC */
}

// LE-LABEL: @test_vreinterpretq_s32_u8(
// LE-NEXT:  entry:
// LE-NEXT:    [[TMP0:%.*]] = bitcast <16 x i8> [[A:%.*]] to <4 x i32>
// LE-NEXT:    ret <4 x i32> [[TMP0]]
//
// BE-LABEL: @test_vreinterpretq_s32_u8(
// BE-NEXT:  entry:
// BE-NEXT:    [[TMP0:%.*]] = call <4 x i32> @llvm.arm.mve.vreinterpretq.v4i32.v16i8(<16 x i8> [[A:%.*]])
// BE-NEXT:    ret <4 x i32> [[TMP0]]
//
int32x4_t test_vreinterpretq_s32_u8(uint8x16_t a)
{
#ifdef POLYMORPHIC
    return vreinterpretq_s32(a);
#else /* POLYMORPHIC */
    return vreinterpretq_s32_u8(a);
#endif /* POLYMORPHIC */
}

// LE-LABEL: @test_vreinterpretq_s64_f16(
// LE-NEXT:  entry:
// LE-NEXT:    [[TMP0:%.*]] = bitcast <8 x half> [[A:%.*]] to <2 x i64>
// LE-NEXT:    ret <2 x i64> [[TMP0]]
//
// BE-LABEL: @test_vreinterpretq_s64_f16(
// BE-NEXT:  entry:
// BE-NEXT:    [[TMP0:%.*]] = call <2 x i64> @llvm.arm.mve.vreinterpretq.v2i64.v8f16(<8 x half> [[A:%.*]])
// BE-NEXT:    ret <2 x i64> [[TMP0]]
//
int64x2_t test_vreinterpretq_s64_f16(float16x8_t a)
{
#ifdef POLYMORPHIC
    return vreinterpretq_s64(a);
#else /* POLYMORPHIC */
    return vreinterpretq_s64_f16(a);
#endif /* POLYMORPHIC */
}

// LE-LABEL: @test_vreinterpretq_s64_f32(
// LE-NEXT:  entry:
// LE-NEXT:    [[TMP0:%.*]] = bitcast <4 x float> [[A:%.*]] to <2 x i64>
// LE-NEXT:    ret <2 x i64> [[TMP0]]
//
// BE-LABEL: @test_vreinterpretq_s64_f32(
// BE-NEXT:  entry:
// BE-NEXT:    [[TMP0:%.*]] = call <2 x i64> @llvm.arm.mve.vreinterpretq.v2i64.v4f32(<4 x float> [[A:%.*]])
// BE-NEXT:    ret <2 x i64> [[TMP0]]
//
int64x2_t test_vreinterpretq_s64_f32(float32x4_t a)
{
#ifdef POLYMORPHIC
    return vreinterpretq_s64(a);
#else /* POLYMORPHIC */
    return vreinterpretq_s64_f32(a);
#endif /* POLYMORPHIC */
}

// LE-LABEL: @test_vreinterpretq_s64_s16(
// LE-NEXT:  entry:
// LE-NEXT:    [[TMP0:%.*]] = bitcast <8 x i16> [[A:%.*]] to <2 x i64>
// LE-NEXT:    ret <2 x i64> [[TMP0]]
//
// BE-LABEL: @test_vreinterpretq_s64_s16(
// BE-NEXT:  entry:
// BE-NEXT:    [[TMP0:%.*]] = call <2 x i64> @llvm.arm.mve.vreinterpretq.v2i64.v8i16(<8 x i16> [[A:%.*]])
// BE-NEXT:    ret <2 x i64> [[TMP0]]
//
int64x2_t test_vreinterpretq_s64_s16(int16x8_t a)
{
#ifdef POLYMORPHIC
    return vreinterpretq_s64(a);
#else /* POLYMORPHIC */
    return vreinterpretq_s64_s16(a);
#endif /* POLYMORPHIC */
}

// LE-LABEL: @test_vreinterpretq_s64_s32(
// LE-NEXT:  entry:
// LE-NEXT:    [[TMP0:%.*]] = bitcast <4 x i32> [[A:%.*]] to <2 x i64>
// LE-NEXT:    ret <2 x i64> [[TMP0]]
//
// BE-LABEL: @test_vreinterpretq_s64_s32(
// BE-NEXT:  entry:
// BE-NEXT:    [[TMP0:%.*]] = call <2 x i64> @llvm.arm.mve.vreinterpretq.v2i64.v4i32(<4 x i32> [[A:%.*]])
// BE-NEXT:    ret <2 x i64> [[TMP0]]
//
int64x2_t test_vreinterpretq_s64_s32(int32x4_t a)
{
#ifdef POLYMORPHIC
    return vreinterpretq_s64(a);
#else /* POLYMORPHIC */
    return vreinterpretq_s64_s32(a);
#endif /* POLYMORPHIC */
}

// LE-LABEL: @test_vreinterpretq_s64_s8(
// LE-NEXT:  entry:
// LE-NEXT:    [[TMP0:%.*]] = bitcast <16 x i8> [[A:%.*]] to <2 x i64>
// LE-NEXT:    ret <2 x i64> [[TMP0]]
//
// BE-LABEL: @test_vreinterpretq_s64_s8(
// BE-NEXT:  entry:
// BE-NEXT:    [[TMP0:%.*]] = call <2 x i64> @llvm.arm.mve.vreinterpretq.v2i64.v16i8(<16 x i8> [[A:%.*]])
// BE-NEXT:    ret <2 x i64> [[TMP0]]
//
int64x2_t test_vreinterpretq_s64_s8(int8x16_t a)
{
#ifdef POLYMORPHIC
    return vreinterpretq_s64(a);
#else /* POLYMORPHIC */
    return vreinterpretq_s64_s8(a);
#endif /* POLYMORPHIC */
}

// LE-LABEL: @test_vreinterpretq_s64_u16(
// LE-NEXT:  entry:
// LE-NEXT:    [[TMP0:%.*]] = bitcast <8 x i16> [[A:%.*]] to <2 x i64>
// LE-NEXT:    ret <2 x i64> [[TMP0]]
//
// BE-LABEL: @test_vreinterpretq_s64_u16(
// BE-NEXT:  entry:
// BE-NEXT:    [[TMP0:%.*]] = call <2 x i64> @llvm.arm.mve.vreinterpretq.v2i64.v8i16(<8 x i16> [[A:%.*]])
// BE-NEXT:    ret <2 x i64> [[TMP0]]
//
int64x2_t test_vreinterpretq_s64_u16(uint16x8_t a)
{
#ifdef POLYMORPHIC
    return vreinterpretq_s64(a);
#else /* POLYMORPHIC */
    return vreinterpretq_s64_u16(a);
#endif /* POLYMORPHIC */
}

// LE-LABEL: @test_vreinterpretq_s64_u32(
// LE-NEXT:  entry:
// LE-NEXT:    [[TMP0:%.*]] = bitcast <4 x i32> [[A:%.*]] to <2 x i64>
// LE-NEXT:    ret <2 x i64> [[TMP0]]
//
// BE-LABEL: @test_vreinterpretq_s64_u32(
// BE-NEXT:  entry:
// BE-NEXT:    [[TMP0:%.*]] = call <2 x i64> @llvm.arm.mve.vreinterpretq.v2i64.v4i32(<4 x i32> [[A:%.*]])
// BE-NEXT:    ret <2 x i64> [[TMP0]]
//
int64x2_t test_vreinterpretq_s64_u32(uint32x4_t a)
{
#ifdef POLYMORPHIC
    return vreinterpretq_s64(a);
#else /* POLYMORPHIC */
    return vreinterpretq_s64_u32(a);
#endif /* POLYMORPHIC */
}

// BOTH-LABEL: @test_vreinterpretq_s64_u64(
// BOTH-NEXT:  entry:
// BOTH-NEXT:    ret <2 x i64> [[A:%.*]]
//
int64x2_t test_vreinterpretq_s64_u64(uint64x2_t a)
{
#ifdef POLYMORPHIC
    return vreinterpretq_s64(a);
#else /* POLYMORPHIC */
    return vreinterpretq_s64_u64(a);
#endif /* POLYMORPHIC */
}

// LE-LABEL: @test_vreinterpretq_s64_u8(
// LE-NEXT:  entry:
// LE-NEXT:    [[TMP0:%.*]] = bitcast <16 x i8> [[A:%.*]] to <2 x i64>
// LE-NEXT:    ret <2 x i64> [[TMP0]]
//
// BE-LABEL: @test_vreinterpretq_s64_u8(
// BE-NEXT:  entry:
// BE-NEXT:    [[TMP0:%.*]] = call <2 x i64> @llvm.arm.mve.vreinterpretq.v2i64.v16i8(<16 x i8> [[A:%.*]])
// BE-NEXT:    ret <2 x i64> [[TMP0]]
//
int64x2_t test_vreinterpretq_s64_u8(uint8x16_t a)
{
#ifdef POLYMORPHIC
    return vreinterpretq_s64(a);
#else /* POLYMORPHIC */
    return vreinterpretq_s64_u8(a);
#endif /* POLYMORPHIC */
}

// LE-LABEL: @test_vreinterpretq_s8_f16(
// LE-NEXT:  entry:
// LE-NEXT:    [[TMP0:%.*]] = bitcast <8 x half> [[A:%.*]] to <16 x i8>
// LE-NEXT:    ret <16 x i8> [[TMP0]]
//
// BE-LABEL: @test_vreinterpretq_s8_f16(
// BE-NEXT:  entry:
// BE-NEXT:    [[TMP0:%.*]] = call <16 x i8> @llvm.arm.mve.vreinterpretq.v16i8.v8f16(<8 x half> [[A:%.*]])
// BE-NEXT:    ret <16 x i8> [[TMP0]]
//
int8x16_t test_vreinterpretq_s8_f16(float16x8_t a)
{
#ifdef POLYMORPHIC
    return vreinterpretq_s8(a);
#else /* POLYMORPHIC */
    return vreinterpretq_s8_f16(a);
#endif /* POLYMORPHIC */
}

// LE-LABEL: @test_vreinterpretq_s8_f32(
// LE-NEXT:  entry:
// LE-NEXT:    [[TMP0:%.*]] = bitcast <4 x float> [[A:%.*]] to <16 x i8>
// LE-NEXT:    ret <16 x i8> [[TMP0]]
//
// BE-LABEL: @test_vreinterpretq_s8_f32(
// BE-NEXT:  entry:
// BE-NEXT:    [[TMP0:%.*]] = call <16 x i8> @llvm.arm.mve.vreinterpretq.v16i8.v4f32(<4 x float> [[A:%.*]])
// BE-NEXT:    ret <16 x i8> [[TMP0]]
//
int8x16_t test_vreinterpretq_s8_f32(float32x4_t a)
{
#ifdef POLYMORPHIC
    return vreinterpretq_s8(a);
#else /* POLYMORPHIC */
    return vreinterpretq_s8_f32(a);
#endif /* POLYMORPHIC */
}

// LE-LABEL: @test_vreinterpretq_s8_s16(
// LE-NEXT:  entry:
// LE-NEXT:    [[TMP0:%.*]] = bitcast <8 x i16> [[A:%.*]] to <16 x i8>
// LE-NEXT:    ret <16 x i8> [[TMP0]]
//
// BE-LABEL: @test_vreinterpretq_s8_s16(
// BE-NEXT:  entry:
// BE-NEXT:    [[TMP0:%.*]] = call <16 x i8> @llvm.arm.mve.vreinterpretq.v16i8.v8i16(<8 x i16> [[A:%.*]])
// BE-NEXT:    ret <16 x i8> [[TMP0]]
//
int8x16_t test_vreinterpretq_s8_s16(int16x8_t a)
{
#ifdef POLYMORPHIC
    return vreinterpretq_s8(a);
#else /* POLYMORPHIC */
    return vreinterpretq_s8_s16(a);
#endif /* POLYMORPHIC */
}

// LE-LABEL: @test_vreinterpretq_s8_s32(
// LE-NEXT:  entry:
// LE-NEXT:    [[TMP0:%.*]] = bitcast <4 x i32> [[A:%.*]] to <16 x i8>
// LE-NEXT:    ret <16 x i8> [[TMP0]]
//
// BE-LABEL: @test_vreinterpretq_s8_s32(
// BE-NEXT:  entry:
// BE-NEXT:    [[TMP0:%.*]] = call <16 x i8> @llvm.arm.mve.vreinterpretq.v16i8.v4i32(<4 x i32> [[A:%.*]])
// BE-NEXT:    ret <16 x i8> [[TMP0]]
//
int8x16_t test_vreinterpretq_s8_s32(int32x4_t a)
{
#ifdef POLYMORPHIC
    return vreinterpretq_s8(a);
#else /* POLYMORPHIC */
    return vreinterpretq_s8_s32(a);
#endif /* POLYMORPHIC */
}

// LE-LABEL: @test_vreinterpretq_s8_s64(
// LE-NEXT:  entry:
// LE-NEXT:    [[TMP0:%.*]] = bitcast <2 x i64> [[A:%.*]] to <16 x i8>
// LE-NEXT:    ret <16 x i8> [[TMP0]]
//
// BE-LABEL: @test_vreinterpretq_s8_s64(
// BE-NEXT:  entry:
// BE-NEXT:    [[TMP0:%.*]] = call <16 x i8> @llvm.arm.mve.vreinterpretq.v16i8.v2i64(<2 x i64> [[A:%.*]])
// BE-NEXT:    ret <16 x i8> [[TMP0]]
//
int8x16_t test_vreinterpretq_s8_s64(int64x2_t a)
{
#ifdef POLYMORPHIC
    return vreinterpretq_s8(a);
#else /* POLYMORPHIC */
    return vreinterpretq_s8_s64(a);
#endif /* POLYMORPHIC */
}

// LE-LABEL: @test_vreinterpretq_s8_u16(
// LE-NEXT:  entry:
// LE-NEXT:    [[TMP0:%.*]] = bitcast <8 x i16> [[A:%.*]] to <16 x i8>
// LE-NEXT:    ret <16 x i8> [[TMP0]]
//
// BE-LABEL: @test_vreinterpretq_s8_u16(
// BE-NEXT:  entry:
// BE-NEXT:    [[TMP0:%.*]] = call <16 x i8> @llvm.arm.mve.vreinterpretq.v16i8.v8i16(<8 x i16> [[A:%.*]])
// BE-NEXT:    ret <16 x i8> [[TMP0]]
//
int8x16_t test_vreinterpretq_s8_u16(uint16x8_t a)
{
#ifdef POLYMORPHIC
    return vreinterpretq_s8(a);
#else /* POLYMORPHIC */
    return vreinterpretq_s8_u16(a);
#endif /* POLYMORPHIC */
}

// LE-LABEL: @test_vreinterpretq_s8_u32(
// LE-NEXT:  entry:
// LE-NEXT:    [[TMP0:%.*]] = bitcast <4 x i32> [[A:%.*]] to <16 x i8>
// LE-NEXT:    ret <16 x i8> [[TMP0]]
//
// BE-LABEL: @test_vreinterpretq_s8_u32(
// BE-NEXT:  entry:
// BE-NEXT:    [[TMP0:%.*]] = call <16 x i8> @llvm.arm.mve.vreinterpretq.v16i8.v4i32(<4 x i32> [[A:%.*]])
// BE-NEXT:    ret <16 x i8> [[TMP0]]
//
int8x16_t test_vreinterpretq_s8_u32(uint32x4_t a)
{
#ifdef POLYMORPHIC
    return vreinterpretq_s8(a);
#else /* POLYMORPHIC */
    return vreinterpretq_s8_u32(a);
#endif /* POLYMORPHIC */
}

// LE-LABEL: @test_vreinterpretq_s8_u64(
// LE-NEXT:  entry:
// LE-NEXT:    [[TMP0:%.*]] = bitcast <2 x i64> [[A:%.*]] to <16 x i8>
// LE-NEXT:    ret <16 x i8> [[TMP0]]
//
// BE-LABEL: @test_vreinterpretq_s8_u64(
// BE-NEXT:  entry:
// BE-NEXT:    [[TMP0:%.*]] = call <16 x i8> @llvm.arm.mve.vreinterpretq.v16i8.v2i64(<2 x i64> [[A:%.*]])
// BE-NEXT:    ret <16 x i8> [[TMP0]]
//
int8x16_t test_vreinterpretq_s8_u64(uint64x2_t a)
{
#ifdef POLYMORPHIC
    return vreinterpretq_s8(a);
#else /* POLYMORPHIC */
    return vreinterpretq_s8_u64(a);
#endif /* POLYMORPHIC */
}

// BOTH-LABEL: @test_vreinterpretq_s8_u8(
// BOTH-NEXT:  entry:
// BOTH-NEXT:    ret <16 x i8> [[A:%.*]]
//
int8x16_t test_vreinterpretq_s8_u8(uint8x16_t a)
{
#ifdef POLYMORPHIC
    return vreinterpretq_s8(a);
#else /* POLYMORPHIC */
    return vreinterpretq_s8_u8(a);
#endif /* POLYMORPHIC */
}

// BOTH-LABEL: @test_vreinterpretq_u16_f16(
// BOTH-NEXT:  entry:
// BOTH-NEXT:    [[TMP0:%.*]] = bitcast <8 x half> [[A:%.*]] to <8 x i16>
// BOTH-NEXT:    ret <8 x i16> [[TMP0]]
//
uint16x8_t test_vreinterpretq_u16_f16(float16x8_t a)
{
#ifdef POLYMORPHIC
    return vreinterpretq_u16(a);
#else /* POLYMORPHIC */
    return vreinterpretq_u16_f16(a);
#endif /* POLYMORPHIC */
}

// LE-LABEL: @test_vreinterpretq_u16_f32(
// LE-NEXT:  entry:
// LE-NEXT:    [[TMP0:%.*]] = bitcast <4 x float> [[A:%.*]] to <8 x i16>
// LE-NEXT:    ret <8 x i16> [[TMP0]]
//
// BE-LABEL: @test_vreinterpretq_u16_f32(
// BE-NEXT:  entry:
// BE-NEXT:    [[TMP0:%.*]] = call <8 x i16> @llvm.arm.mve.vreinterpretq.v8i16.v4f32(<4 x float> [[A:%.*]])
// BE-NEXT:    ret <8 x i16> [[TMP0]]
//
uint16x8_t test_vreinterpretq_u16_f32(float32x4_t a)
{
#ifdef POLYMORPHIC
    return vreinterpretq_u16(a);
#else /* POLYMORPHIC */
    return vreinterpretq_u16_f32(a);
#endif /* POLYMORPHIC */
}

// BOTH-LABEL: @test_vreinterpretq_u16_s16(
// BOTH-NEXT:  entry:
// BOTH-NEXT:    ret <8 x i16> [[A:%.*]]
//
uint16x8_t test_vreinterpretq_u16_s16(int16x8_t a)
{
#ifdef POLYMORPHIC
    return vreinterpretq_u16(a);
#else /* POLYMORPHIC */
    return vreinterpretq_u16_s16(a);
#endif /* POLYMORPHIC */
}

// LE-LABEL: @test_vreinterpretq_u16_s32(
// LE-NEXT:  entry:
// LE-NEXT:    [[TMP0:%.*]] = bitcast <4 x i32> [[A:%.*]] to <8 x i16>
// LE-NEXT:    ret <8 x i16> [[TMP0]]
//
// BE-LABEL: @test_vreinterpretq_u16_s32(
// BE-NEXT:  entry:
// BE-NEXT:    [[TMP0:%.*]] = call <8 x i16> @llvm.arm.mve.vreinterpretq.v8i16.v4i32(<4 x i32> [[A:%.*]])
// BE-NEXT:    ret <8 x i16> [[TMP0]]
//
uint16x8_t test_vreinterpretq_u16_s32(int32x4_t a)
{
#ifdef POLYMORPHIC
    return vreinterpretq_u16(a);
#else /* POLYMORPHIC */
    return vreinterpretq_u16_s32(a);
#endif /* POLYMORPHIC */
}

// LE-LABEL: @test_vreinterpretq_u16_s64(
// LE-NEXT:  entry:
// LE-NEXT:    [[TMP0:%.*]] = bitcast <2 x i64> [[A:%.*]] to <8 x i16>
// LE-NEXT:    ret <8 x i16> [[TMP0]]
//
// BE-LABEL: @test_vreinterpretq_u16_s64(
// BE-NEXT:  entry:
// BE-NEXT:    [[TMP0:%.*]] = call <8 x i16> @llvm.arm.mve.vreinterpretq.v8i16.v2i64(<2 x i64> [[A:%.*]])
// BE-NEXT:    ret <8 x i16> [[TMP0]]
//
uint16x8_t test_vreinterpretq_u16_s64(int64x2_t a)
{
#ifdef POLYMORPHIC
    return vreinterpretq_u16(a);
#else /* POLYMORPHIC */
    return vreinterpretq_u16_s64(a);
#endif /* POLYMORPHIC */
}

// LE-LABEL: @test_vreinterpretq_u16_s8(
// LE-NEXT:  entry:
// LE-NEXT:    [[TMP0:%.*]] = bitcast <16 x i8> [[A:%.*]] to <8 x i16>
// LE-NEXT:    ret <8 x i16> [[TMP0]]
//
// BE-LABEL: @test_vreinterpretq_u16_s8(
// BE-NEXT:  entry:
// BE-NEXT:    [[TMP0:%.*]] = call <8 x i16> @llvm.arm.mve.vreinterpretq.v8i16.v16i8(<16 x i8> [[A:%.*]])
// BE-NEXT:    ret <8 x i16> [[TMP0]]
//
uint16x8_t test_vreinterpretq_u16_s8(int8x16_t a)
{
#ifdef POLYMORPHIC
    return vreinterpretq_u16(a);
#else /* POLYMORPHIC */
    return vreinterpretq_u16_s8(a);
#endif /* POLYMORPHIC */
}

// LE-LABEL: @test_vreinterpretq_u16_u32(
// LE-NEXT:  entry:
// LE-NEXT:    [[TMP0:%.*]] = bitcast <4 x i32> [[A:%.*]] to <8 x i16>
// LE-NEXT:    ret <8 x i16> [[TMP0]]
//
// BE-LABEL: @test_vreinterpretq_u16_u32(
// BE-NEXT:  entry:
// BE-NEXT:    [[TMP0:%.*]] = call <8 x i16> @llvm.arm.mve.vreinterpretq.v8i16.v4i32(<4 x i32> [[A:%.*]])
// BE-NEXT:    ret <8 x i16> [[TMP0]]
//
uint16x8_t test_vreinterpretq_u16_u32(uint32x4_t a)
{
#ifdef POLYMORPHIC
    return vreinterpretq_u16(a);
#else /* POLYMORPHIC */
    return vreinterpretq_u16_u32(a);
#endif /* POLYMORPHIC */
}

// LE-LABEL: @test_vreinterpretq_u16_u64(
// LE-NEXT:  entry:
// LE-NEXT:    [[TMP0:%.*]] = bitcast <2 x i64> [[A:%.*]] to <8 x i16>
// LE-NEXT:    ret <8 x i16> [[TMP0]]
//
// BE-LABEL: @test_vreinterpretq_u16_u64(
// BE-NEXT:  entry:
// BE-NEXT:    [[TMP0:%.*]] = call <8 x i16> @llvm.arm.mve.vreinterpretq.v8i16.v2i64(<2 x i64> [[A:%.*]])
// BE-NEXT:    ret <8 x i16> [[TMP0]]
//
uint16x8_t test_vreinterpretq_u16_u64(uint64x2_t a)
{
#ifdef POLYMORPHIC
    return vreinterpretq_u16(a);
#else /* POLYMORPHIC */
    return vreinterpretq_u16_u64(a);
#endif /* POLYMORPHIC */
}

// LE-LABEL: @test_vreinterpretq_u16_u8(
// LE-NEXT:  entry:
// LE-NEXT:    [[TMP0:%.*]] = bitcast <16 x i8> [[A:%.*]] to <8 x i16>
// LE-NEXT:    ret <8 x i16> [[TMP0]]
//
// BE-LABEL: @test_vreinterpretq_u16_u8(
// BE-NEXT:  entry:
// BE-NEXT:    [[TMP0:%.*]] = call <8 x i16> @llvm.arm.mve.vreinterpretq.v8i16.v16i8(<16 x i8> [[A:%.*]])
// BE-NEXT:    ret <8 x i16> [[TMP0]]
//
uint16x8_t test_vreinterpretq_u16_u8(uint8x16_t a)
{
#ifdef POLYMORPHIC
    return vreinterpretq_u16(a);
#else /* POLYMORPHIC */
    return vreinterpretq_u16_u8(a);
#endif /* POLYMORPHIC */
}

// LE-LABEL: @test_vreinterpretq_u32_f16(
// LE-NEXT:  entry:
// LE-NEXT:    [[TMP0:%.*]] = bitcast <8 x half> [[A:%.*]] to <4 x i32>
// LE-NEXT:    ret <4 x i32> [[TMP0]]
//
// BE-LABEL: @test_vreinterpretq_u32_f16(
// BE-NEXT:  entry:
// BE-NEXT:    [[TMP0:%.*]] = call <4 x i32> @llvm.arm.mve.vreinterpretq.v4i32.v8f16(<8 x half> [[A:%.*]])
// BE-NEXT:    ret <4 x i32> [[TMP0]]
//
uint32x4_t test_vreinterpretq_u32_f16(float16x8_t a)
{
#ifdef POLYMORPHIC
    return vreinterpretq_u32(a);
#else /* POLYMORPHIC */
    return vreinterpretq_u32_f16(a);
#endif /* POLYMORPHIC */
}

// BOTH-LABEL: @test_vreinterpretq_u32_f32(
// BOTH-NEXT:  entry:
// BOTH-NEXT:    [[TMP0:%.*]] = bitcast <4 x float> [[A:%.*]] to <4 x i32>
// BOTH-NEXT:    ret <4 x i32> [[TMP0]]
//
uint32x4_t test_vreinterpretq_u32_f32(float32x4_t a)
{
#ifdef POLYMORPHIC
    return vreinterpretq_u32(a);
#else /* POLYMORPHIC */
    return vreinterpretq_u32_f32(a);
#endif /* POLYMORPHIC */
}

// LE-LABEL: @test_vreinterpretq_u32_s16(
// LE-NEXT:  entry:
// LE-NEXT:    [[TMP0:%.*]] = bitcast <8 x i16> [[A:%.*]] to <4 x i32>
// LE-NEXT:    ret <4 x i32> [[TMP0]]
//
// BE-LABEL: @test_vreinterpretq_u32_s16(
// BE-NEXT:  entry:
// BE-NEXT:    [[TMP0:%.*]] = call <4 x i32> @llvm.arm.mve.vreinterpretq.v4i32.v8i16(<8 x i16> [[A:%.*]])
// BE-NEXT:    ret <4 x i32> [[TMP0]]
//
uint32x4_t test_vreinterpretq_u32_s16(int16x8_t a)
{
#ifdef POLYMORPHIC
    return vreinterpretq_u32(a);
#else /* POLYMORPHIC */
    return vreinterpretq_u32_s16(a);
#endif /* POLYMORPHIC */
}

// BOTH-LABEL: @test_vreinterpretq_u32_s32(
// BOTH-NEXT:  entry:
// BOTH-NEXT:    ret <4 x i32> [[A:%.*]]
//
uint32x4_t test_vreinterpretq_u32_s32(int32x4_t a)
{
#ifdef POLYMORPHIC
    return vreinterpretq_u32(a);
#else /* POLYMORPHIC */
    return vreinterpretq_u32_s32(a);
#endif /* POLYMORPHIC */
}

// LE-LABEL: @test_vreinterpretq_u32_s64(
// LE-NEXT:  entry:
// LE-NEXT:    [[TMP0:%.*]] = bitcast <2 x i64> [[A:%.*]] to <4 x i32>
// LE-NEXT:    ret <4 x i32> [[TMP0]]
//
// BE-LABEL: @test_vreinterpretq_u32_s64(
// BE-NEXT:  entry:
// BE-NEXT:    [[TMP0:%.*]] = call <4 x i32> @llvm.arm.mve.vreinterpretq.v4i32.v2i64(<2 x i64> [[A:%.*]])
// BE-NEXT:    ret <4 x i32> [[TMP0]]
//
uint32x4_t test_vreinterpretq_u32_s64(int64x2_t a)
{
#ifdef POLYMORPHIC
    return vreinterpretq_u32(a);
#else /* POLYMORPHIC */
    return vreinterpretq_u32_s64(a);
#endif /* POLYMORPHIC */
}

// LE-LABEL: @test_vreinterpretq_u32_s8(
// LE-NEXT:  entry:
// LE-NEXT:    [[TMP0:%.*]] = bitcast <16 x i8> [[A:%.*]] to <4 x i32>
// LE-NEXT:    ret <4 x i32> [[TMP0]]
//
// BE-LABEL: @test_vreinterpretq_u32_s8(
// BE-NEXT:  entry:
// BE-NEXT:    [[TMP0:%.*]] = call <4 x i32> @llvm.arm.mve.vreinterpretq.v4i32.v16i8(<16 x i8> [[A:%.*]])
// BE-NEXT:    ret <4 x i32> [[TMP0]]
//
uint32x4_t test_vreinterpretq_u32_s8(int8x16_t a)
{
#ifdef POLYMORPHIC
    return vreinterpretq_u32(a);
#else /* POLYMORPHIC */
    return vreinterpretq_u32_s8(a);
#endif /* POLYMORPHIC */
}

// LE-LABEL: @test_vreinterpretq_u32_u16(
// LE-NEXT:  entry:
// LE-NEXT:    [[TMP0:%.*]] = bitcast <8 x i16> [[A:%.*]] to <4 x i32>
// LE-NEXT:    ret <4 x i32> [[TMP0]]
//
// BE-LABEL: @test_vreinterpretq_u32_u16(
// BE-NEXT:  entry:
// BE-NEXT:    [[TMP0:%.*]] = call <4 x i32> @llvm.arm.mve.vreinterpretq.v4i32.v8i16(<8 x i16> [[A:%.*]])
// BE-NEXT:    ret <4 x i32> [[TMP0]]
//
uint32x4_t test_vreinterpretq_u32_u16(uint16x8_t a)
{
#ifdef POLYMORPHIC
    return vreinterpretq_u32(a);
#else /* POLYMORPHIC */
    return vreinterpretq_u32_u16(a);
#endif /* POLYMORPHIC */
}

// LE-LABEL: @test_vreinterpretq_u32_u64(
// LE-NEXT:  entry:
// LE-NEXT:    [[TMP0:%.*]] = bitcast <2 x i64> [[A:%.*]] to <4 x i32>
// LE-NEXT:    ret <4 x i32> [[TMP0]]
//
// BE-LABEL: @test_vreinterpretq_u32_u64(
// BE-NEXT:  entry:
// BE-NEXT:    [[TMP0:%.*]] = call <4 x i32> @llvm.arm.mve.vreinterpretq.v4i32.v2i64(<2 x i64> [[A:%.*]])
// BE-NEXT:    ret <4 x i32> [[TMP0]]
//
uint32x4_t test_vreinterpretq_u32_u64(uint64x2_t a)
{
#ifdef POLYMORPHIC
    return vreinterpretq_u32(a);
#else /* POLYMORPHIC */
    return vreinterpretq_u32_u64(a);
#endif /* POLYMORPHIC */
}

// LE-LABEL: @test_vreinterpretq_u32_u8(
// LE-NEXT:  entry:
// LE-NEXT:    [[TMP0:%.*]] = bitcast <16 x i8> [[A:%.*]] to <4 x i32>
// LE-NEXT:    ret <4 x i32> [[TMP0]]
//
// BE-LABEL: @test_vreinterpretq_u32_u8(
// BE-NEXT:  entry:
// BE-NEXT:    [[TMP0:%.*]] = call <4 x i32> @llvm.arm.mve.vreinterpretq.v4i32.v16i8(<16 x i8> [[A:%.*]])
// BE-NEXT:    ret <4 x i32> [[TMP0]]
//
uint32x4_t test_vreinterpretq_u32_u8(uint8x16_t a)
{
#ifdef POLYMORPHIC
    return vreinterpretq_u32(a);
#else /* POLYMORPHIC */
    return vreinterpretq_u32_u8(a);
#endif /* POLYMORPHIC */
}

// LE-LABEL: @test_vreinterpretq_u64_f16(
// LE-NEXT:  entry:
// LE-NEXT:    [[TMP0:%.*]] = bitcast <8 x half> [[A:%.*]] to <2 x i64>
// LE-NEXT:    ret <2 x i64> [[TMP0]]
//
// BE-LABEL: @test_vreinterpretq_u64_f16(
// BE-NEXT:  entry:
// BE-NEXT:    [[TMP0:%.*]] = call <2 x i64> @llvm.arm.mve.vreinterpretq.v2i64.v8f16(<8 x half> [[A:%.*]])
// BE-NEXT:    ret <2 x i64> [[TMP0]]
//
uint64x2_t test_vreinterpretq_u64_f16(float16x8_t a)
{
#ifdef POLYMORPHIC
    return vreinterpretq_u64(a);
#else /* POLYMORPHIC */
    return vreinterpretq_u64_f16(a);
#endif /* POLYMORPHIC */
}

// LE-LABEL: @test_vreinterpretq_u64_f32(
// LE-NEXT:  entry:
// LE-NEXT:    [[TMP0:%.*]] = bitcast <4 x float> [[A:%.*]] to <2 x i64>
// LE-NEXT:    ret <2 x i64> [[TMP0]]
//
// BE-LABEL: @test_vreinterpretq_u64_f32(
// BE-NEXT:  entry:
// BE-NEXT:    [[TMP0:%.*]] = call <2 x i64> @llvm.arm.mve.vreinterpretq.v2i64.v4f32(<4 x float> [[A:%.*]])
// BE-NEXT:    ret <2 x i64> [[TMP0]]
//
uint64x2_t test_vreinterpretq_u64_f32(float32x4_t a)
{
#ifdef POLYMORPHIC
    return vreinterpretq_u64(a);
#else /* POLYMORPHIC */
    return vreinterpretq_u64_f32(a);
#endif /* POLYMORPHIC */
}

// LE-LABEL: @test_vreinterpretq_u64_s16(
// LE-NEXT:  entry:
// LE-NEXT:    [[TMP0:%.*]] = bitcast <8 x i16> [[A:%.*]] to <2 x i64>
// LE-NEXT:    ret <2 x i64> [[TMP0]]
//
// BE-LABEL: @test_vreinterpretq_u64_s16(
// BE-NEXT:  entry:
// BE-NEXT:    [[TMP0:%.*]] = call <2 x i64> @llvm.arm.mve.vreinterpretq.v2i64.v8i16(<8 x i16> [[A:%.*]])
// BE-NEXT:    ret <2 x i64> [[TMP0]]
//
uint64x2_t test_vreinterpretq_u64_s16(int16x8_t a)
{
#ifdef POLYMORPHIC
    return vreinterpretq_u64(a);
#else /* POLYMORPHIC */
    return vreinterpretq_u64_s16(a);
#endif /* POLYMORPHIC */
}

// LE-LABEL: @test_vreinterpretq_u64_s32(
// LE-NEXT:  entry:
// LE-NEXT:    [[TMP0:%.*]] = bitcast <4 x i32> [[A:%.*]] to <2 x i64>
// LE-NEXT:    ret <2 x i64> [[TMP0]]
//
// BE-LABEL: @test_vreinterpretq_u64_s32(
// BE-NEXT:  entry:
// BE-NEXT:    [[TMP0:%.*]] = call <2 x i64> @llvm.arm.mve.vreinterpretq.v2i64.v4i32(<4 x i32> [[A:%.*]])
// BE-NEXT:    ret <2 x i64> [[TMP0]]
//
uint64x2_t test_vreinterpretq_u64_s32(int32x4_t a)
{
#ifdef POLYMORPHIC
    return vreinterpretq_u64(a);
#else /* POLYMORPHIC */
    return vreinterpretq_u64_s32(a);
#endif /* POLYMORPHIC */
}

// BOTH-LABEL: @test_vreinterpretq_u64_s64(
// BOTH-NEXT:  entry:
// BOTH-NEXT:    ret <2 x i64> [[A:%.*]]
//
uint64x2_t test_vreinterpretq_u64_s64(int64x2_t a)
{
#ifdef POLYMORPHIC
    return vreinterpretq_u64(a);
#else /* POLYMORPHIC */
    return vreinterpretq_u64_s64(a);
#endif /* POLYMORPHIC */
}

// LE-LABEL: @test_vreinterpretq_u64_s8(
// LE-NEXT:  entry:
// LE-NEXT:    [[TMP0:%.*]] = bitcast <16 x i8> [[A:%.*]] to <2 x i64>
// LE-NEXT:    ret <2 x i64> [[TMP0]]
//
// BE-LABEL: @test_vreinterpretq_u64_s8(
// BE-NEXT:  entry:
// BE-NEXT:    [[TMP0:%.*]] = call <2 x i64> @llvm.arm.mve.vreinterpretq.v2i64.v16i8(<16 x i8> [[A:%.*]])
// BE-NEXT:    ret <2 x i64> [[TMP0]]
//
uint64x2_t test_vreinterpretq_u64_s8(int8x16_t a)
{
#ifdef POLYMORPHIC
    return vreinterpretq_u64(a);
#else /* POLYMORPHIC */
    return vreinterpretq_u64_s8(a);
#endif /* POLYMORPHIC */
}

// LE-LABEL: @test_vreinterpretq_u64_u16(
// LE-NEXT:  entry:
// LE-NEXT:    [[TMP0:%.*]] = bitcast <8 x i16> [[A:%.*]] to <2 x i64>
// LE-NEXT:    ret <2 x i64> [[TMP0]]
//
// BE-LABEL: @test_vreinterpretq_u64_u16(
// BE-NEXT:  entry:
// BE-NEXT:    [[TMP0:%.*]] = call <2 x i64> @llvm.arm.mve.vreinterpretq.v2i64.v8i16(<8 x i16> [[A:%.*]])
// BE-NEXT:    ret <2 x i64> [[TMP0]]
//
uint64x2_t test_vreinterpretq_u64_u16(uint16x8_t a)
{
#ifdef POLYMORPHIC
    return vreinterpretq_u64(a);
#else /* POLYMORPHIC */
    return vreinterpretq_u64_u16(a);
#endif /* POLYMORPHIC */
}

// LE-LABEL: @test_vreinterpretq_u64_u32(
// LE-NEXT:  entry:
// LE-NEXT:    [[TMP0:%.*]] = bitcast <4 x i32> [[A:%.*]] to <2 x i64>
// LE-NEXT:    ret <2 x i64> [[TMP0]]
//
// BE-LABEL: @test_vreinterpretq_u64_u32(
// BE-NEXT:  entry:
// BE-NEXT:    [[TMP0:%.*]] = call <2 x i64> @llvm.arm.mve.vreinterpretq.v2i64.v4i32(<4 x i32> [[A:%.*]])
// BE-NEXT:    ret <2 x i64> [[TMP0]]
//
uint64x2_t test_vreinterpretq_u64_u32(uint32x4_t a)
{
#ifdef POLYMORPHIC
    return vreinterpretq_u64(a);
#else /* POLYMORPHIC */
    return vreinterpretq_u64_u32(a);
#endif /* POLYMORPHIC */
}

// LE-LABEL: @test_vreinterpretq_u64_u8(
// LE-NEXT:  entry:
// LE-NEXT:    [[TMP0:%.*]] = bitcast <16 x i8> [[A:%.*]] to <2 x i64>
// LE-NEXT:    ret <2 x i64> [[TMP0]]
//
// BE-LABEL: @test_vreinterpretq_u64_u8(
// BE-NEXT:  entry:
// BE-NEXT:    [[TMP0:%.*]] = call <2 x i64> @llvm.arm.mve.vreinterpretq.v2i64.v16i8(<16 x i8> [[A:%.*]])
// BE-NEXT:    ret <2 x i64> [[TMP0]]
//
uint64x2_t test_vreinterpretq_u64_u8(uint8x16_t a)
{
#ifdef POLYMORPHIC
    return vreinterpretq_u64(a);
#else /* POLYMORPHIC */
    return vreinterpretq_u64_u8(a);
#endif /* POLYMORPHIC */
}

// LE-LABEL: @test_vreinterpretq_u8_f16(
// LE-NEXT:  entry:
// LE-NEXT:    [[TMP0:%.*]] = bitcast <8 x half> [[A:%.*]] to <16 x i8>
// LE-NEXT:    ret <16 x i8> [[TMP0]]
//
// BE-LABEL: @test_vreinterpretq_u8_f16(
// BE-NEXT:  entry:
// BE-NEXT:    [[TMP0:%.*]] = call <16 x i8> @llvm.arm.mve.vreinterpretq.v16i8.v8f16(<8 x half> [[A:%.*]])
// BE-NEXT:    ret <16 x i8> [[TMP0]]
//
uint8x16_t test_vreinterpretq_u8_f16(float16x8_t a)
{
#ifdef POLYMORPHIC
    return vreinterpretq_u8(a);
#else /* POLYMORPHIC */
    return vreinterpretq_u8_f16(a);
#endif /* POLYMORPHIC */
}

// LE-LABEL: @test_vreinterpretq_u8_f32(
// LE-NEXT:  entry:
// LE-NEXT:    [[TMP0:%.*]] = bitcast <4 x float> [[A:%.*]] to <16 x i8>
// LE-NEXT:    ret <16 x i8> [[TMP0]]
//
// BE-LABEL: @test_vreinterpretq_u8_f32(
// BE-NEXT:  entry:
// BE-NEXT:    [[TMP0:%.*]] = call <16 x i8> @llvm.arm.mve.vreinterpretq.v16i8.v4f32(<4 x float> [[A:%.*]])
// BE-NEXT:    ret <16 x i8> [[TMP0]]
//
uint8x16_t test_vreinterpretq_u8_f32(float32x4_t a)
{
#ifdef POLYMORPHIC
    return vreinterpretq_u8(a);
#else /* POLYMORPHIC */
    return vreinterpretq_u8_f32(a);
#endif /* POLYMORPHIC */
}

// LE-LABEL: @test_vreinterpretq_u8_s16(
// LE-NEXT:  entry:
// LE-NEXT:    [[TMP0:%.*]] = bitcast <8 x i16> [[A:%.*]] to <16 x i8>
// LE-NEXT:    ret <16 x i8> [[TMP0]]
//
// BE-LABEL: @test_vreinterpretq_u8_s16(
// BE-NEXT:  entry:
// BE-NEXT:    [[TMP0:%.*]] = call <16 x i8> @llvm.arm.mve.vreinterpretq.v16i8.v8i16(<8 x i16> [[A:%.*]])
// BE-NEXT:    ret <16 x i8> [[TMP0]]
//
uint8x16_t test_vreinterpretq_u8_s16(int16x8_t a)
{
#ifdef POLYMORPHIC
    return vreinterpretq_u8(a);
#else /* POLYMORPHIC */
    return vreinterpretq_u8_s16(a);
#endif /* POLYMORPHIC */
}

// LE-LABEL: @test_vreinterpretq_u8_s32(
// LE-NEXT:  entry:
// LE-NEXT:    [[TMP0:%.*]] = bitcast <4 x i32> [[A:%.*]] to <16 x i8>
// LE-NEXT:    ret <16 x i8> [[TMP0]]
//
// BE-LABEL: @test_vreinterpretq_u8_s32(
// BE-NEXT:  entry:
// BE-NEXT:    [[TMP0:%.*]] = call <16 x i8> @llvm.arm.mve.vreinterpretq.v16i8.v4i32(<4 x i32> [[A:%.*]])
// BE-NEXT:    ret <16 x i8> [[TMP0]]
//
uint8x16_t test_vreinterpretq_u8_s32(int32x4_t a)
{
#ifdef POLYMORPHIC
    return vreinterpretq_u8(a);
#else /* POLYMORPHIC */
    return vreinterpretq_u8_s32(a);
#endif /* POLYMORPHIC */
}

// LE-LABEL: @test_vreinterpretq_u8_s64(
// LE-NEXT:  entry:
// LE-NEXT:    [[TMP0:%.*]] = bitcast <2 x i64> [[A:%.*]] to <16 x i8>
// LE-NEXT:    ret <16 x i8> [[TMP0]]
//
// BE-LABEL: @test_vreinterpretq_u8_s64(
// BE-NEXT:  entry:
// BE-NEXT:    [[TMP0:%.*]] = call <16 x i8> @llvm.arm.mve.vreinterpretq.v16i8.v2i64(<2 x i64> [[A:%.*]])
// BE-NEXT:    ret <16 x i8> [[TMP0]]
//
uint8x16_t test_vreinterpretq_u8_s64(int64x2_t a)
{
#ifdef POLYMORPHIC
    return vreinterpretq_u8(a);
#else /* POLYMORPHIC */
    return vreinterpretq_u8_s64(a);
#endif /* POLYMORPHIC */
}

// BOTH-LABEL: @test_vreinterpretq_u8_s8(
// BOTH-NEXT:  entry:
// BOTH-NEXT:    ret <16 x i8> [[A:%.*]]
//
uint8x16_t test_vreinterpretq_u8_s8(int8x16_t a)
{
#ifdef POLYMORPHIC
    return vreinterpretq_u8(a);
#else /* POLYMORPHIC */
    return vreinterpretq_u8_s8(a);
#endif /* POLYMORPHIC */
}

// LE-LABEL: @test_vreinterpretq_u8_u16(
// LE-NEXT:  entry:
// LE-NEXT:    [[TMP0:%.*]] = bitcast <8 x i16> [[A:%.*]] to <16 x i8>
// LE-NEXT:    ret <16 x i8> [[TMP0]]
//
// BE-LABEL: @test_vreinterpretq_u8_u16(
// BE-NEXT:  entry:
// BE-NEXT:    [[TMP0:%.*]] = call <16 x i8> @llvm.arm.mve.vreinterpretq.v16i8.v8i16(<8 x i16> [[A:%.*]])
// BE-NEXT:    ret <16 x i8> [[TMP0]]
//
uint8x16_t test_vreinterpretq_u8_u16(uint16x8_t a)
{
#ifdef POLYMORPHIC
    return vreinterpretq_u8(a);
#else /* POLYMORPHIC */
    return vreinterpretq_u8_u16(a);
#endif /* POLYMORPHIC */
}

// LE-LABEL: @test_vreinterpretq_u8_u32(
// LE-NEXT:  entry:
// LE-NEXT:    [[TMP0:%.*]] = bitcast <4 x i32> [[A:%.*]] to <16 x i8>
// LE-NEXT:    ret <16 x i8> [[TMP0]]
//
// BE-LABEL: @test_vreinterpretq_u8_u32(
// BE-NEXT:  entry:
// BE-NEXT:    [[TMP0:%.*]] = call <16 x i8> @llvm.arm.mve.vreinterpretq.v16i8.v4i32(<4 x i32> [[A:%.*]])
// BE-NEXT:    ret <16 x i8> [[TMP0]]
//
uint8x16_t test_vreinterpretq_u8_u32(uint32x4_t a)
{
#ifdef POLYMORPHIC
    return vreinterpretq_u8(a);
#else /* POLYMORPHIC */
    return vreinterpretq_u8_u32(a);
#endif /* POLYMORPHIC */
}

// LE-LABEL: @test_vreinterpretq_u8_u64(
// LE-NEXT:  entry:
// LE-NEXT:    [[TMP0:%.*]] = bitcast <2 x i64> [[A:%.*]] to <16 x i8>
// LE-NEXT:    ret <16 x i8> [[TMP0]]
//
// BE-LABEL: @test_vreinterpretq_u8_u64(
// BE-NEXT:  entry:
// BE-NEXT:    [[TMP0:%.*]] = call <16 x i8> @llvm.arm.mve.vreinterpretq.v16i8.v2i64(<2 x i64> [[A:%.*]])
// BE-NEXT:    ret <16 x i8> [[TMP0]]
//
uint8x16_t test_vreinterpretq_u8_u64(uint64x2_t a)
{
#ifdef POLYMORPHIC
    return vreinterpretq_u8(a);
#else /* POLYMORPHIC */
    return vreinterpretq_u8_u64(a);
#endif /* POLYMORPHIC */
}
