; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -instcombine -S | FileCheck %s

; For pattern (X & (signbit << Y)) ==/!= 0
; it may be optimal to fold into (X l>> Y) >=/< 0

; Scalar tests

define i1 @scalar_i8_signbit_shl_and_eq(i8 %x, i8 %y) {
; CHECK-LABEL: @scalar_i8_signbit_shl_and_eq(
; CHECK-NEXT:    [[SHL:%.*]] = shl i8 -128, [[Y:%.*]]
; CHECK-NEXT:    [[AND:%.*]] = and i8 [[SHL]], [[X:%.*]]
; CHECK-NEXT:    [[R:%.*]] = icmp eq i8 [[AND]], 0
; CHECK-NEXT:    ret i1 [[R]]
;
  %shl = shl i8 128, %y
  %and = and i8 %shl, %x
  %r = icmp eq i8 %and, 0
  ret i1 %r
}

define i1 @scalar_i16_signbit_shl_and_eq(i16 %x, i16 %y) {
; CHECK-LABEL: @scalar_i16_signbit_shl_and_eq(
; CHECK-NEXT:    [[SHL:%.*]] = shl i16 -32768, [[Y:%.*]]
; CHECK-NEXT:    [[AND:%.*]] = and i16 [[SHL]], [[X:%.*]]
; CHECK-NEXT:    [[R:%.*]] = icmp eq i16 [[AND]], 0
; CHECK-NEXT:    ret i1 [[R]]
;
  %shl = shl i16 32768, %y
  %and = and i16 %shl, %x
  %r = icmp eq i16 %and, 0
  ret i1 %r
}

define i1 @scalar_i32_signbit_shl_and_eq(i32 %x, i32 %y) {
; CHECK-LABEL: @scalar_i32_signbit_shl_and_eq(
; CHECK-NEXT:    [[SHL:%.*]] = shl i32 -2147483648, [[Y:%.*]]
; CHECK-NEXT:    [[AND:%.*]] = and i32 [[SHL]], [[X:%.*]]
; CHECK-NEXT:    [[R:%.*]] = icmp eq i32 [[AND]], 0
; CHECK-NEXT:    ret i1 [[R]]
;
  %shl = shl i32 2147483648, %y
  %and = and i32 %shl, %x
  %r = icmp eq i32 %and, 0
  ret i1 %r
}

define i1 @scalar_i64_signbit_shl_and_eq(i64 %x, i64 %y) {
; CHECK-LABEL: @scalar_i64_signbit_shl_and_eq(
; CHECK-NEXT:    [[SHL:%.*]] = shl i64 -9223372036854775808, [[Y:%.*]]
; CHECK-NEXT:    [[AND:%.*]] = and i64 [[SHL]], [[X:%.*]]
; CHECK-NEXT:    [[R:%.*]] = icmp eq i64 [[AND]], 0
; CHECK-NEXT:    ret i1 [[R]]
;
  %shl = shl i64 9223372036854775808, %y
  %and = and i64 %shl, %x
  %r = icmp eq i64 %and, 0
  ret i1 %r
}

define i1 @scalar_i32_signbit_shl_and_ne(i32 %x, i32 %y) {
; CHECK-LABEL: @scalar_i32_signbit_shl_and_ne(
; CHECK-NEXT:    [[SHL:%.*]] = shl i32 -2147483648, [[Y:%.*]]
; CHECK-NEXT:    [[AND:%.*]] = and i32 [[SHL]], [[X:%.*]]
; CHECK-NEXT:    [[R:%.*]] = icmp ne i32 [[AND]], 0
; CHECK-NEXT:    ret i1 [[R]]
;
  %shl = shl i32 2147483648, %y
  %and = and i32 %shl, %x
  %r = icmp ne i32 %and, 0  ; check 'ne' predicate
  ret i1 %r
}

; Vector tests

define <4 x i1> @vec_4xi32_signbit_shl_and_eq(<4 x i32> %x, <4 x i32> %y) {
; CHECK-LABEL: @vec_4xi32_signbit_shl_and_eq(
; CHECK-NEXT:    [[SHL:%.*]] = shl <4 x i32> <i32 -2147483648, i32 -2147483648, i32 -2147483648, i32 -2147483648>, [[Y:%.*]]
; CHECK-NEXT:    [[AND:%.*]] = and <4 x i32> [[SHL]], [[X:%.*]]
; CHECK-NEXT:    [[R:%.*]] = icmp eq <4 x i32> [[AND]], zeroinitializer
; CHECK-NEXT:    ret <4 x i1> [[R]]
;
  %shl = shl <4 x i32> <i32 2147483648, i32 2147483648, i32 2147483648, i32 2147483648>, %y
  %and = and <4 x i32> %shl, %x
  %r = icmp eq <4 x i32> %and, <i32 0, i32 0, i32 0, i32 0>
  ret <4 x i1> %r
}

define <4 x i1> @vec_4xi32_signbit_shl_and_eq_undef1(<4 x i32> %x, <4 x i32> %y) {
; CHECK-LABEL: @vec_4xi32_signbit_shl_and_eq_undef1(
; CHECK-NEXT:    [[SHL:%.*]] = shl <4 x i32> <i32 -2147483648, i32 undef, i32 -2147483648, i32 2147473648>, [[Y:%.*]]
; CHECK-NEXT:    [[AND:%.*]] = and <4 x i32> [[SHL]], [[X:%.*]]
; CHECK-NEXT:    [[R:%.*]] = icmp eq <4 x i32> [[AND]], zeroinitializer
; CHECK-NEXT:    ret <4 x i1> [[R]]
;
  %shl = shl <4 x i32> <i32 2147483648, i32 undef, i32 2147483648, i32 2147473648>, %y
  %and = and <4 x i32> %shl, %x
  %r = icmp eq <4 x i32> %and, <i32 0, i32 0, i32 0, i32 0>
  ret <4 x i1> %r
}

define <4 x i1> @vec_4xi32_signbit_shl_and_eq_undef2(<4 x i32> %x, <4 x i32> %y) {
; CHECK-LABEL: @vec_4xi32_signbit_shl_and_eq_undef2(
; CHECK-NEXT:    [[SHL:%.*]] = shl <4 x i32> <i32 -2147483648, i32 -2147483648, i32 -2147483648, i32 2147473648>, [[Y:%.*]]
; CHECK-NEXT:    [[AND:%.*]] = and <4 x i32> [[SHL]], [[X:%.*]]
; CHECK-NEXT:    [[R:%.*]] = icmp eq <4 x i32> [[AND]], <i32 0, i32 0, i32 0, i32 undef>
; CHECK-NEXT:    ret <4 x i1> [[R]]
;
  %shl = shl <4 x i32> <i32 2147483648, i32 2147483648, i32 2147483648, i32 2147473648>, %y
  %and = and <4 x i32> %shl, %x
  %r = icmp eq <4 x i32> %and, <i32 0, i32 0, i32 0, i32 undef>
  ret <4 x i1> %r
}

define <4 x i1> @vec_4xi32_signbit_shl_and_eq_undef3(<4 x i32> %x, <4 x i32> %y) {
; CHECK-LABEL: @vec_4xi32_signbit_shl_and_eq_undef3(
; CHECK-NEXT:    [[SHL:%.*]] = shl <4 x i32> <i32 -2147483648, i32 undef, i32 -2147483648, i32 2147473648>, [[Y:%.*]]
; CHECK-NEXT:    [[AND:%.*]] = and <4 x i32> [[SHL]], [[X:%.*]]
; CHECK-NEXT:    [[R:%.*]] = icmp eq <4 x i32> [[AND]], <i32 undef, i32 0, i32 0, i32 0>
; CHECK-NEXT:    ret <4 x i1> [[R]]
;
  %shl = shl <4 x i32> <i32 2147483648, i32 undef, i32 2147483648, i32 2147473648>, %y
  %and = and <4 x i32> %shl, %x
  %r = icmp eq <4 x i32> %and, <i32 undef, i32 0, i32 0, i32 0>
  ret <4 x i1> %r
}

; Extra use

; Fold happened
define i1 @scalar_i32_signbit_shl_and_eq_extra_use_shl(i32 %x, i32 %y, i32 %z, i32* %p) {
; CHECK-LABEL: @scalar_i32_signbit_shl_and_eq_extra_use_shl(
; CHECK-NEXT:    [[SHL:%.*]] = shl i32 -2147483648, [[Y:%.*]]
; CHECK-NEXT:    [[XOR:%.*]] = xor i32 [[SHL]], [[Z:%.*]]
; CHECK-NEXT:    store i32 [[XOR]], i32* [[P:%.*]], align 4
; CHECK-NEXT:    [[AND:%.*]] = and i32 [[SHL]], [[X:%.*]]
; CHECK-NEXT:    [[R:%.*]] = icmp eq i32 [[AND]], 0
; CHECK-NEXT:    ret i1 [[R]]
;
  %shl = shl i32 2147483648, %y
  %xor = xor i32 %shl, %z  ; extra use of shl
  store i32 %xor, i32* %p
  %and = and i32 %shl, %x
  %r = icmp eq i32 %and, 0
  ret i1 %r
}

; Not fold
define i1 @scalar_i32_signbit_shl_and_eq_extra_use_and(i32 %x, i32 %y, i32 %z, i32* %p) {
; CHECK-LABEL: @scalar_i32_signbit_shl_and_eq_extra_use_and(
; CHECK-NEXT:    [[SHL:%.*]] = shl i32 -2147483648, [[Y:%.*]]
; CHECK-NEXT:    [[AND:%.*]] = and i32 [[SHL]], [[X:%.*]]
; CHECK-NEXT:    [[MUL:%.*]] = mul i32 [[AND]], [[Z:%.*]]
; CHECK-NEXT:    store i32 [[MUL]], i32* [[P:%.*]], align 4
; CHECK-NEXT:    [[R:%.*]] = icmp eq i32 [[AND]], 0
; CHECK-NEXT:    ret i1 [[R]]
;
  %shl = shl i32 2147483648, %y
  %and = and i32 %shl, %x
  %mul = mul i32 %and, %z  ; extra use of and
  store i32 %mul, i32* %p
  %r = icmp eq i32 %and, 0
  ret i1 %r
}

; Not fold
define i1 @scalar_i32_signbit_shl_and_eq_extra_use_shl_and(i32 %x, i32 %y, i32 %z, i32* %p, i32* %q) {
; CHECK-LABEL: @scalar_i32_signbit_shl_and_eq_extra_use_shl_and(
; CHECK-NEXT:    [[SHL:%.*]] = shl i32 -2147483648, [[Y:%.*]]
; CHECK-NEXT:    [[AND:%.*]] = and i32 [[SHL]], [[X:%.*]]
; CHECK-NEXT:    store i32 [[AND]], i32* [[P:%.*]], align 4
; CHECK-NEXT:    [[ADD:%.*]] = add i32 [[SHL]], [[Z:%.*]]
; CHECK-NEXT:    store i32 [[ADD]], i32* [[Q:%.*]], align 4
; CHECK-NEXT:    [[R:%.*]] = icmp eq i32 [[AND]], 0
; CHECK-NEXT:    ret i1 [[R]]
;
  %shl = shl i32 2147483648, %y
  %and = and i32 %shl, %x
  store i32 %and, i32* %p  ; extra use of and
  %add = add i32 %shl, %z  ; extra use of shl
  store i32 %add, i32* %q
  %r = icmp eq i32 %and, 0
  ret i1 %r
}

; X is constant

define i1 @scalar_i32_signbit_shl_and_eq_X_is_constant1(i32 %y) {
; CHECK-LABEL: @scalar_i32_signbit_shl_and_eq_X_is_constant1(
; CHECK-NEXT:    [[SHL:%.*]] = shl i32 -2147483648, [[Y:%.*]]
; CHECK-NEXT:    [[AND:%.*]] = and i32 [[SHL]], 12345
; CHECK-NEXT:    [[R:%.*]] = icmp eq i32 [[AND]], 0
; CHECK-NEXT:    ret i1 [[R]]
;
  %shl = shl i32 2147483648, %y
  %and = and i32 %shl, 12345
  %r = icmp eq i32 %and, 0
  ret i1 %r
}

define i1 @scalar_i32_signbit_shl_and_eq_X_is_constant2(i32 %y) {
; CHECK-LABEL: @scalar_i32_signbit_shl_and_eq_X_is_constant2(
; CHECK-NEXT:    [[SHL:%.*]] = shl i32 -2147483648, [[Y:%.*]]
; CHECK-NEXT:    [[AND:%.*]] = and i32 [[SHL]], 1
; CHECK-NEXT:    [[R:%.*]] = icmp eq i32 [[AND]], 0
; CHECK-NEXT:    ret i1 [[R]]
;
  %shl = shl i32 2147483648, %y
  %and = and i32 %shl, 1
  %r = icmp eq i32 %and, 0
  ret i1 %r
}

; Negative tests

; Check 'slt' predicate

define i1 @scalar_i32_signbit_shl_and_slt(i32 %x, i32 %y) {
; CHECK-LABEL: @scalar_i32_signbit_shl_and_slt(
; CHECK-NEXT:    [[SHL:%.*]] = shl i32 -2147483648, [[Y:%.*]]
; CHECK-NEXT:    [[AND:%.*]] = and i32 [[SHL]], [[X:%.*]]
; CHECK-NEXT:    [[R:%.*]] = icmp slt i32 [[AND]], 0
; CHECK-NEXT:    ret i1 [[R]]
;
  %shl = shl i32 2147483648, %y
  %and = and i32 %shl, %x
  %r = icmp slt i32 %and, 0
  ret i1 %r
}

; Compare with nonzero

define i1 @scalar_i32_signbit_shl_and_eq_nonzero(i32 %x, i32 %y) {
; CHECK-LABEL: @scalar_i32_signbit_shl_and_eq_nonzero(
; CHECK-NEXT:    [[SHL:%.*]] = shl i32 -2147483648, [[Y:%.*]]
; CHECK-NEXT:    [[AND:%.*]] = and i32 [[SHL]], [[X:%.*]]
; CHECK-NEXT:    [[R:%.*]] = icmp eq i32 [[AND]], 1
; CHECK-NEXT:    ret i1 [[R]]
;
  %shl = shl i32 2147483648, %y
  %and = and i32 %shl, %x
  %r = icmp eq i32 %and, 1  ; should be comparing with 0
  ret i1 %r
}
