// RUN: llvm-mc -arch=amdgcn -mcpu=gfx1010 -mattr=+wavefrontsize32,-wavefrontsize64 -show-encoding %s | FileCheck --check-prefix=GFX10 %s
// RUN: llvm-mc -arch=amdgcn -mcpu=gfx1010 -mattr=-wavefrontsize32,+wavefrontsize64 -show-encoding %s | FileCheck --check-prefix=GFX10 %s

//===----------------------------------------------------------------------===//
// ENC_VOPC - v_cmpx_* opcodes.
//===----------------------------------------------------------------------===//

v_cmpx_f_f32 v1, v2
// GFX10: encoding: [0x01,0x05,0x20,0x7c]

v_cmpx_f_f32 v255, v2
// GFX10: encoding: [0xff,0x05,0x20,0x7c]

v_cmpx_f_f32 s1, v2
// GFX10: encoding: [0x01,0x04,0x20,0x7c]

v_cmpx_f_f32 s101, v2
// GFX10: encoding: [0x65,0x04,0x20,0x7c]

v_cmpx_f_f32 vcc_lo, v2
// GFX10: encoding: [0x6a,0x04,0x20,0x7c]

v_cmpx_f_f32 vcc_hi, v2
// GFX10: encoding: [0x6b,0x04,0x20,0x7c]

v_cmpx_f_f32 m0, v2
// GFX10: encoding: [0x7c,0x04,0x20,0x7c]

v_cmpx_f_f32 exec_lo, v2
// GFX10: encoding: [0x7e,0x04,0x20,0x7c]

v_cmpx_f_f32 exec_hi, v2
// GFX10: encoding: [0x7f,0x04,0x20,0x7c]

v_cmpx_f_f32 0, v2
// GFX10: encoding: [0x80,0x04,0x20,0x7c]

v_cmpx_f_f32 -1, v2
// GFX10: encoding: [0xc1,0x04,0x20,0x7c]

v_cmpx_f_f32 0.5, v2
// GFX10: encoding: [0xf0,0x04,0x20,0x7c]

v_cmpx_f_f32 -4.0, v2
// GFX10: encoding: [0xf7,0x04,0x20,0x7c]

v_cmpx_f_f32 0xaf123456, v2
// GFX10: encoding: [0xff,0x04,0x20,0x7c,0x56,0x34,0x12,0xaf]

v_cmpx_f_f32 0x3f717273, v2
// GFX10: encoding: [0xff,0x04,0x20,0x7c,0x73,0x72,0x71,0x3f]

v_cmpx_f_f32 v1, v255
// GFX10: encoding: [0x01,0xff,0x21,0x7c]

v_cmpx_f_f32_e64 v1, v2
// GFX10: encoding: [0x00,0x00,0x10,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_f_f32_e64 v255, v2
// GFX10: encoding: [0x00,0x00,0x10,0xd4,0xff,0x05,0x02,0x00]

v_cmpx_f_f32_e64 s1, v2
// GFX10: encoding: [0x00,0x00,0x10,0xd4,0x01,0x04,0x02,0x00]

v_cmpx_f_f32_e64 s101, v2
// GFX10: encoding: [0x00,0x00,0x10,0xd4,0x65,0x04,0x02,0x00]

v_cmpx_f_f32_e64 vcc_lo, v2
// GFX10: encoding: [0x00,0x00,0x10,0xd4,0x6a,0x04,0x02,0x00]

v_cmpx_f_f32_e64 vcc_hi, v2
// GFX10: encoding: [0x00,0x00,0x10,0xd4,0x6b,0x04,0x02,0x00]

v_cmpx_f_f32_e64 m0, v2
// GFX10: encoding: [0x00,0x00,0x10,0xd4,0x7c,0x04,0x02,0x00]

v_cmpx_f_f32_e64 exec_lo, v2
// GFX10: encoding: [0x00,0x00,0x10,0xd4,0x7e,0x04,0x02,0x00]

v_cmpx_f_f32_e64 exec_hi, v2
// GFX10: encoding: [0x00,0x00,0x10,0xd4,0x7f,0x04,0x02,0x00]

v_cmpx_f_f32_e64 0, v2
// GFX10: encoding: [0x00,0x00,0x10,0xd4,0x80,0x04,0x02,0x00]

v_cmpx_f_f32_e64 -1, v2
// GFX10: encoding: [0x00,0x00,0x10,0xd4,0xc1,0x04,0x02,0x00]

v_cmpx_f_f32_e64 0.5, v2
// GFX10: encoding: [0x00,0x00,0x10,0xd4,0xf0,0x04,0x02,0x00]

v_cmpx_f_f32_e64 -4.0, v2
// GFX10: encoding: [0x00,0x00,0x10,0xd4,0xf7,0x04,0x02,0x00]

v_cmpx_f_f32_e64 v1, v255
// GFX10: encoding: [0x00,0x00,0x10,0xd4,0x01,0xff,0x03,0x00]

v_cmpx_f_f32_e64 v1, s2
// GFX10: encoding: [0x00,0x00,0x10,0xd4,0x01,0x05,0x00,0x00]

v_cmpx_f_f32_e64 v1, s101
// GFX10: encoding: [0x00,0x00,0x10,0xd4,0x01,0xcb,0x00,0x00]

v_cmpx_f_f32_e64 v1, vcc_lo
// GFX10: encoding: [0x00,0x00,0x10,0xd4,0x01,0xd5,0x00,0x00]

v_cmpx_f_f32_e64 v1, vcc_hi
// GFX10: encoding: [0x00,0x00,0x10,0xd4,0x01,0xd7,0x00,0x00]

v_cmpx_f_f32_e64 v1, m0
// GFX10: encoding: [0x00,0x00,0x10,0xd4,0x01,0xf9,0x00,0x00]

v_cmpx_f_f32_e64 v1, exec_lo
// GFX10: encoding: [0x00,0x00,0x10,0xd4,0x01,0xfd,0x00,0x00]

v_cmpx_f_f32_e64 v1, exec_hi
// GFX10: encoding: [0x00,0x00,0x10,0xd4,0x01,0xff,0x00,0x00]

v_cmpx_f_f32_e64 v1, 0
// GFX10: encoding: [0x00,0x00,0x10,0xd4,0x01,0x01,0x01,0x00]

v_cmpx_f_f32_e64 v1, -1
// GFX10: encoding: [0x00,0x00,0x10,0xd4,0x01,0x83,0x01,0x00]

v_cmpx_f_f32_e64 v1, 0.5
// GFX10: encoding: [0x00,0x00,0x10,0xd4,0x01,0xe1,0x01,0x00]

v_cmpx_f_f32_e64 v1, -4.0
// GFX10: encoding: [0x00,0x00,0x10,0xd4,0x01,0xef,0x01,0x00]

v_cmpx_f_f32_e64 -v1, v2
// GFX10: encoding: [0x00,0x00,0x10,0xd4,0x01,0x05,0x02,0x20]

v_cmpx_f_f32_e64 v1, -v2
// GFX10: encoding: [0x00,0x00,0x10,0xd4,0x01,0x05,0x02,0x40]

v_cmpx_f_f32_e64 -v1, -v2
// GFX10: encoding: [0x00,0x00,0x10,0xd4,0x01,0x05,0x02,0x60]

v_cmpx_lt_f32 v1, v2
// GFX10: encoding: [0x01,0x05,0x22,0x7c]

v_cmpx_lt_f32 v255, v2
// GFX10: encoding: [0xff,0x05,0x22,0x7c]

v_cmpx_lt_f32 s1, v2
// GFX10: encoding: [0x01,0x04,0x22,0x7c]

v_cmpx_lt_f32 s101, v2
// GFX10: encoding: [0x65,0x04,0x22,0x7c]

v_cmpx_lt_f32 vcc_lo, v2
// GFX10: encoding: [0x6a,0x04,0x22,0x7c]

v_cmpx_lt_f32 vcc_hi, v2
// GFX10: encoding: [0x6b,0x04,0x22,0x7c]

v_cmpx_lt_f32 m0, v2
// GFX10: encoding: [0x7c,0x04,0x22,0x7c]

v_cmpx_lt_f32 exec_lo, v2
// GFX10: encoding: [0x7e,0x04,0x22,0x7c]

v_cmpx_lt_f32 exec_hi, v2
// GFX10: encoding: [0x7f,0x04,0x22,0x7c]

v_cmpx_lt_f32 0, v2
// GFX10: encoding: [0x80,0x04,0x22,0x7c]

v_cmpx_lt_f32 -1, v2
// GFX10: encoding: [0xc1,0x04,0x22,0x7c]

v_cmpx_lt_f32 0.5, v2
// GFX10: encoding: [0xf0,0x04,0x22,0x7c]

v_cmpx_lt_f32 -4.0, v2
// GFX10: encoding: [0xf7,0x04,0x22,0x7c]

v_cmpx_lt_f32 0xaf123456, v2
// GFX10: encoding: [0xff,0x04,0x22,0x7c,0x56,0x34,0x12,0xaf]

v_cmpx_lt_f32 0x3f717273, v2
// GFX10: encoding: [0xff,0x04,0x22,0x7c,0x73,0x72,0x71,0x3f]

v_cmpx_lt_f32 v1, v255
// GFX10: encoding: [0x01,0xff,0x23,0x7c]

v_cmpx_lt_f32_e64 v1, v2
// GFX10: encoding: [0x00,0x00,0x11,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_lt_f32_e64 v255, v2
// GFX10: encoding: [0x00,0x00,0x11,0xd4,0xff,0x05,0x02,0x00]

v_cmpx_lt_f32_e64 s1, v2
// GFX10: encoding: [0x00,0x00,0x11,0xd4,0x01,0x04,0x02,0x00]

v_cmpx_lt_f32_e64 s101, v2
// GFX10: encoding: [0x00,0x00,0x11,0xd4,0x65,0x04,0x02,0x00]

v_cmpx_lt_f32_e64 vcc_lo, v2
// GFX10: encoding: [0x00,0x00,0x11,0xd4,0x6a,0x04,0x02,0x00]

v_cmpx_lt_f32_e64 vcc_hi, v2
// GFX10: encoding: [0x00,0x00,0x11,0xd4,0x6b,0x04,0x02,0x00]

v_cmpx_lt_f32_e64 m0, v2
// GFX10: encoding: [0x00,0x00,0x11,0xd4,0x7c,0x04,0x02,0x00]

v_cmpx_lt_f32_e64 exec_lo, v2
// GFX10: encoding: [0x00,0x00,0x11,0xd4,0x7e,0x04,0x02,0x00]

v_cmpx_lt_f32_e64 exec_hi, v2
// GFX10: encoding: [0x00,0x00,0x11,0xd4,0x7f,0x04,0x02,0x00]

v_cmpx_lt_f32_e64 0, v2
// GFX10: encoding: [0x00,0x00,0x11,0xd4,0x80,0x04,0x02,0x00]

v_cmpx_lt_f32_e64 -1, v2
// GFX10: encoding: [0x00,0x00,0x11,0xd4,0xc1,0x04,0x02,0x00]

v_cmpx_lt_f32_e64 0.5, v2
// GFX10: encoding: [0x00,0x00,0x11,0xd4,0xf0,0x04,0x02,0x00]

v_cmpx_lt_f32_e64 -4.0, v2
// GFX10: encoding: [0x00,0x00,0x11,0xd4,0xf7,0x04,0x02,0x00]

v_cmpx_lt_f32_e64 v1, v255
// GFX10: encoding: [0x00,0x00,0x11,0xd4,0x01,0xff,0x03,0x00]

v_cmpx_lt_f32_e64 v1, s2
// GFX10: encoding: [0x00,0x00,0x11,0xd4,0x01,0x05,0x00,0x00]

v_cmpx_lt_f32_e64 v1, s101
// GFX10: encoding: [0x00,0x00,0x11,0xd4,0x01,0xcb,0x00,0x00]

v_cmpx_lt_f32_e64 v1, vcc_lo
// GFX10: encoding: [0x00,0x00,0x11,0xd4,0x01,0xd5,0x00,0x00]

v_cmpx_lt_f32_e64 v1, vcc_hi
// GFX10: encoding: [0x00,0x00,0x11,0xd4,0x01,0xd7,0x00,0x00]

v_cmpx_lt_f32_e64 v1, m0
// GFX10: encoding: [0x00,0x00,0x11,0xd4,0x01,0xf9,0x00,0x00]

v_cmpx_lt_f32_e64 v1, exec_lo
// GFX10: encoding: [0x00,0x00,0x11,0xd4,0x01,0xfd,0x00,0x00]

v_cmpx_lt_f32_e64 v1, exec_hi
// GFX10: encoding: [0x00,0x00,0x11,0xd4,0x01,0xff,0x00,0x00]

v_cmpx_lt_f32_e64 v1, 0
// GFX10: encoding: [0x00,0x00,0x11,0xd4,0x01,0x01,0x01,0x00]

v_cmpx_lt_f32_e64 v1, -1
// GFX10: encoding: [0x00,0x00,0x11,0xd4,0x01,0x83,0x01,0x00]

v_cmpx_lt_f32_e64 v1, 0.5
// GFX10: encoding: [0x00,0x00,0x11,0xd4,0x01,0xe1,0x01,0x00]

v_cmpx_lt_f32_e64 v1, -4.0
// GFX10: encoding: [0x00,0x00,0x11,0xd4,0x01,0xef,0x01,0x00]

v_cmpx_lt_f32_e64 -v1, v2
// GFX10: encoding: [0x00,0x00,0x11,0xd4,0x01,0x05,0x02,0x20]

v_cmpx_lt_f32_e64 v1, -v2
// GFX10: encoding: [0x00,0x00,0x11,0xd4,0x01,0x05,0x02,0x40]

v_cmpx_lt_f32_e64 -v1, -v2
// GFX10: encoding: [0x00,0x00,0x11,0xd4,0x01,0x05,0x02,0x60]

v_cmpx_eq_f32 v1, v2
// GFX10: encoding: [0x01,0x05,0x24,0x7c]

v_cmpx_eq_f32 v255, v2
// GFX10: encoding: [0xff,0x05,0x24,0x7c]

v_cmpx_eq_f32 s1, v2
// GFX10: encoding: [0x01,0x04,0x24,0x7c]

v_cmpx_eq_f32 s101, v2
// GFX10: encoding: [0x65,0x04,0x24,0x7c]

v_cmpx_eq_f32 vcc_lo, v2
// GFX10: encoding: [0x6a,0x04,0x24,0x7c]

v_cmpx_eq_f32 vcc_hi, v2
// GFX10: encoding: [0x6b,0x04,0x24,0x7c]

v_cmpx_eq_f32 m0, v2
// GFX10: encoding: [0x7c,0x04,0x24,0x7c]

v_cmpx_eq_f32 exec_lo, v2
// GFX10: encoding: [0x7e,0x04,0x24,0x7c]

v_cmpx_eq_f32 exec_hi, v2
// GFX10: encoding: [0x7f,0x04,0x24,0x7c]

v_cmpx_eq_f32 0, v2
// GFX10: encoding: [0x80,0x04,0x24,0x7c]

v_cmpx_eq_f32 -1, v2
// GFX10: encoding: [0xc1,0x04,0x24,0x7c]

v_cmpx_eq_f32 0.5, v2
// GFX10: encoding: [0xf0,0x04,0x24,0x7c]

v_cmpx_eq_f32 -4.0, v2
// GFX10: encoding: [0xf7,0x04,0x24,0x7c]

v_cmpx_eq_f32 0xaf123456, v2
// GFX10: encoding: [0xff,0x04,0x24,0x7c,0x56,0x34,0x12,0xaf]

v_cmpx_eq_f32 0x3f717273, v2
// GFX10: encoding: [0xff,0x04,0x24,0x7c,0x73,0x72,0x71,0x3f]

v_cmpx_eq_f32 v1, v255
// GFX10: encoding: [0x01,0xff,0x25,0x7c]

v_cmpx_eq_f32_e64 v1, v2
// GFX10: encoding: [0x00,0x00,0x12,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_eq_f32_e64 v255, v2
// GFX10: encoding: [0x00,0x00,0x12,0xd4,0xff,0x05,0x02,0x00]

v_cmpx_eq_f32_e64 s1, v2
// GFX10: encoding: [0x00,0x00,0x12,0xd4,0x01,0x04,0x02,0x00]

v_cmpx_eq_f32_e64 s101, v2
// GFX10: encoding: [0x00,0x00,0x12,0xd4,0x65,0x04,0x02,0x00]

v_cmpx_eq_f32_e64 vcc_lo, v2
// GFX10: encoding: [0x00,0x00,0x12,0xd4,0x6a,0x04,0x02,0x00]

v_cmpx_eq_f32_e64 vcc_hi, v2
// GFX10: encoding: [0x00,0x00,0x12,0xd4,0x6b,0x04,0x02,0x00]

v_cmpx_eq_f32_e64 m0, v2
// GFX10: encoding: [0x00,0x00,0x12,0xd4,0x7c,0x04,0x02,0x00]

v_cmpx_eq_f32_e64 exec_lo, v2
// GFX10: encoding: [0x00,0x00,0x12,0xd4,0x7e,0x04,0x02,0x00]

v_cmpx_eq_f32_e64 exec_hi, v2
// GFX10: encoding: [0x00,0x00,0x12,0xd4,0x7f,0x04,0x02,0x00]

v_cmpx_eq_f32_e64 0, v2
// GFX10: encoding: [0x00,0x00,0x12,0xd4,0x80,0x04,0x02,0x00]

v_cmpx_eq_f32_e64 -1, v2
// GFX10: encoding: [0x00,0x00,0x12,0xd4,0xc1,0x04,0x02,0x00]

v_cmpx_eq_f32_e64 0.5, v2
// GFX10: encoding: [0x00,0x00,0x12,0xd4,0xf0,0x04,0x02,0x00]

v_cmpx_eq_f32_e64 -4.0, v2
// GFX10: encoding: [0x00,0x00,0x12,0xd4,0xf7,0x04,0x02,0x00]

v_cmpx_eq_f32_e64 v1, v255
// GFX10: encoding: [0x00,0x00,0x12,0xd4,0x01,0xff,0x03,0x00]

v_cmpx_eq_f32_e64 v1, s2
// GFX10: encoding: [0x00,0x00,0x12,0xd4,0x01,0x05,0x00,0x00]

v_cmpx_eq_f32_e64 v1, s101
// GFX10: encoding: [0x00,0x00,0x12,0xd4,0x01,0xcb,0x00,0x00]

v_cmpx_eq_f32_e64 v1, vcc_lo
// GFX10: encoding: [0x00,0x00,0x12,0xd4,0x01,0xd5,0x00,0x00]

v_cmpx_eq_f32_e64 v1, vcc_hi
// GFX10: encoding: [0x00,0x00,0x12,0xd4,0x01,0xd7,0x00,0x00]

v_cmpx_eq_f32_e64 v1, m0
// GFX10: encoding: [0x00,0x00,0x12,0xd4,0x01,0xf9,0x00,0x00]

v_cmpx_eq_f32_e64 v1, exec_lo
// GFX10: encoding: [0x00,0x00,0x12,0xd4,0x01,0xfd,0x00,0x00]

v_cmpx_eq_f32_e64 v1, exec_hi
// GFX10: encoding: [0x00,0x00,0x12,0xd4,0x01,0xff,0x00,0x00]

v_cmpx_eq_f32_e64 v1, 0
// GFX10: encoding: [0x00,0x00,0x12,0xd4,0x01,0x01,0x01,0x00]

v_cmpx_eq_f32_e64 v1, -1
// GFX10: encoding: [0x00,0x00,0x12,0xd4,0x01,0x83,0x01,0x00]

v_cmpx_eq_f32_e64 v1, 0.5
// GFX10: encoding: [0x00,0x00,0x12,0xd4,0x01,0xe1,0x01,0x00]

v_cmpx_eq_f32_e64 v1, -4.0
// GFX10: encoding: [0x00,0x00,0x12,0xd4,0x01,0xef,0x01,0x00]

v_cmpx_eq_f32_e64 -v1, v2
// GFX10: encoding: [0x00,0x00,0x12,0xd4,0x01,0x05,0x02,0x20]

v_cmpx_eq_f32_e64 v1, -v2
// GFX10: encoding: [0x00,0x00,0x12,0xd4,0x01,0x05,0x02,0x40]

v_cmpx_eq_f32_e64 -v1, -v2
// GFX10: encoding: [0x00,0x00,0x12,0xd4,0x01,0x05,0x02,0x60]

v_cmpx_le_f32 v1, v2
// GFX10: encoding: [0x01,0x05,0x26,0x7c]

v_cmpx_le_f32 v255, v2
// GFX10: encoding: [0xff,0x05,0x26,0x7c]

v_cmpx_le_f32 s1, v2
// GFX10: encoding: [0x01,0x04,0x26,0x7c]

v_cmpx_le_f32 s101, v2
// GFX10: encoding: [0x65,0x04,0x26,0x7c]

v_cmpx_le_f32 vcc_lo, v2
// GFX10: encoding: [0x6a,0x04,0x26,0x7c]

v_cmpx_le_f32 vcc_hi, v2
// GFX10: encoding: [0x6b,0x04,0x26,0x7c]

v_cmpx_le_f32 m0, v2
// GFX10: encoding: [0x7c,0x04,0x26,0x7c]

v_cmpx_le_f32 exec_lo, v2
// GFX10: encoding: [0x7e,0x04,0x26,0x7c]

v_cmpx_le_f32 exec_hi, v2
// GFX10: encoding: [0x7f,0x04,0x26,0x7c]

v_cmpx_le_f32 0, v2
// GFX10: encoding: [0x80,0x04,0x26,0x7c]

v_cmpx_le_f32 -1, v2
// GFX10: encoding: [0xc1,0x04,0x26,0x7c]

v_cmpx_le_f32 0.5, v2
// GFX10: encoding: [0xf0,0x04,0x26,0x7c]

v_cmpx_le_f32 -4.0, v2
// GFX10: encoding: [0xf7,0x04,0x26,0x7c]

v_cmpx_le_f32 0xaf123456, v2
// GFX10: encoding: [0xff,0x04,0x26,0x7c,0x56,0x34,0x12,0xaf]

v_cmpx_le_f32 0x3f717273, v2
// GFX10: encoding: [0xff,0x04,0x26,0x7c,0x73,0x72,0x71,0x3f]

v_cmpx_le_f32 v1, v255
// GFX10: encoding: [0x01,0xff,0x27,0x7c]

v_cmpx_le_f32_e64 v1, v2
// GFX10: encoding: [0x00,0x00,0x13,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_le_f32_e64 v255, v2
// GFX10: encoding: [0x00,0x00,0x13,0xd4,0xff,0x05,0x02,0x00]

v_cmpx_le_f32_e64 s1, v2
// GFX10: encoding: [0x00,0x00,0x13,0xd4,0x01,0x04,0x02,0x00]

v_cmpx_le_f32_e64 s101, v2
// GFX10: encoding: [0x00,0x00,0x13,0xd4,0x65,0x04,0x02,0x00]

v_cmpx_le_f32_e64 vcc_lo, v2
// GFX10: encoding: [0x00,0x00,0x13,0xd4,0x6a,0x04,0x02,0x00]

v_cmpx_le_f32_e64 vcc_hi, v2
// GFX10: encoding: [0x00,0x00,0x13,0xd4,0x6b,0x04,0x02,0x00]

v_cmpx_le_f32_e64 m0, v2
// GFX10: encoding: [0x00,0x00,0x13,0xd4,0x7c,0x04,0x02,0x00]

v_cmpx_le_f32_e64 exec_lo, v2
// GFX10: encoding: [0x00,0x00,0x13,0xd4,0x7e,0x04,0x02,0x00]

v_cmpx_le_f32_e64 exec_hi, v2
// GFX10: encoding: [0x00,0x00,0x13,0xd4,0x7f,0x04,0x02,0x00]

v_cmpx_le_f32_e64 0, v2
// GFX10: encoding: [0x00,0x00,0x13,0xd4,0x80,0x04,0x02,0x00]

v_cmpx_le_f32_e64 -1, v2
// GFX10: encoding: [0x00,0x00,0x13,0xd4,0xc1,0x04,0x02,0x00]

v_cmpx_le_f32_e64 0.5, v2
// GFX10: encoding: [0x00,0x00,0x13,0xd4,0xf0,0x04,0x02,0x00]

v_cmpx_le_f32_e64 -4.0, v2
// GFX10: encoding: [0x00,0x00,0x13,0xd4,0xf7,0x04,0x02,0x00]

v_cmpx_le_f32_e64 v1, v255
// GFX10: encoding: [0x00,0x00,0x13,0xd4,0x01,0xff,0x03,0x00]

v_cmpx_le_f32_e64 v1, s2
// GFX10: encoding: [0x00,0x00,0x13,0xd4,0x01,0x05,0x00,0x00]

v_cmpx_le_f32_e64 v1, s101
// GFX10: encoding: [0x00,0x00,0x13,0xd4,0x01,0xcb,0x00,0x00]

v_cmpx_le_f32_e64 v1, vcc_lo
// GFX10: encoding: [0x00,0x00,0x13,0xd4,0x01,0xd5,0x00,0x00]

v_cmpx_le_f32_e64 v1, vcc_hi
// GFX10: encoding: [0x00,0x00,0x13,0xd4,0x01,0xd7,0x00,0x00]

v_cmpx_le_f32_e64 v1, m0
// GFX10: encoding: [0x00,0x00,0x13,0xd4,0x01,0xf9,0x00,0x00]

v_cmpx_le_f32_e64 v1, exec_lo
// GFX10: encoding: [0x00,0x00,0x13,0xd4,0x01,0xfd,0x00,0x00]

v_cmpx_le_f32_e64 v1, exec_hi
// GFX10: encoding: [0x00,0x00,0x13,0xd4,0x01,0xff,0x00,0x00]

v_cmpx_le_f32_e64 v1, 0
// GFX10: encoding: [0x00,0x00,0x13,0xd4,0x01,0x01,0x01,0x00]

v_cmpx_le_f32_e64 v1, -1
// GFX10: encoding: [0x00,0x00,0x13,0xd4,0x01,0x83,0x01,0x00]

v_cmpx_le_f32_e64 v1, 0.5
// GFX10: encoding: [0x00,0x00,0x13,0xd4,0x01,0xe1,0x01,0x00]

v_cmpx_le_f32_e64 v1, -4.0
// GFX10: encoding: [0x00,0x00,0x13,0xd4,0x01,0xef,0x01,0x00]

v_cmpx_le_f32_e64 -v1, v2
// GFX10: encoding: [0x00,0x00,0x13,0xd4,0x01,0x05,0x02,0x20]

v_cmpx_le_f32_e64 v1, -v2
// GFX10: encoding: [0x00,0x00,0x13,0xd4,0x01,0x05,0x02,0x40]

v_cmpx_le_f32_e64 -v1, -v2
// GFX10: encoding: [0x00,0x00,0x13,0xd4,0x01,0x05,0x02,0x60]

v_cmpx_gt_f32 v1, v2
// GFX10: encoding: [0x01,0x05,0x28,0x7c]

v_cmpx_gt_f32 v255, v2
// GFX10: encoding: [0xff,0x05,0x28,0x7c]

v_cmpx_gt_f32 s1, v2
// GFX10: encoding: [0x01,0x04,0x28,0x7c]

v_cmpx_gt_f32 s101, v2
// GFX10: encoding: [0x65,0x04,0x28,0x7c]

v_cmpx_gt_f32 vcc_lo, v2
// GFX10: encoding: [0x6a,0x04,0x28,0x7c]

v_cmpx_gt_f32 vcc_hi, v2
// GFX10: encoding: [0x6b,0x04,0x28,0x7c]

v_cmpx_gt_f32 m0, v2
// GFX10: encoding: [0x7c,0x04,0x28,0x7c]

v_cmpx_gt_f32 exec_lo, v2
// GFX10: encoding: [0x7e,0x04,0x28,0x7c]

v_cmpx_gt_f32 exec_hi, v2
// GFX10: encoding: [0x7f,0x04,0x28,0x7c]

v_cmpx_gt_f32 0, v2
// GFX10: encoding: [0x80,0x04,0x28,0x7c]

v_cmpx_gt_f32 -1, v2
// GFX10: encoding: [0xc1,0x04,0x28,0x7c]

v_cmpx_gt_f32 0.5, v2
// GFX10: encoding: [0xf0,0x04,0x28,0x7c]

v_cmpx_gt_f32 -4.0, v2
// GFX10: encoding: [0xf7,0x04,0x28,0x7c]

v_cmpx_gt_f32 0xaf123456, v2
// GFX10: encoding: [0xff,0x04,0x28,0x7c,0x56,0x34,0x12,0xaf]

v_cmpx_gt_f32 0x3f717273, v2
// GFX10: encoding: [0xff,0x04,0x28,0x7c,0x73,0x72,0x71,0x3f]

v_cmpx_gt_f32 v1, v255
// GFX10: encoding: [0x01,0xff,0x29,0x7c]

v_cmpx_gt_f32_e64 v1, v2
// GFX10: encoding: [0x00,0x00,0x14,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_gt_f32_e64 v255, v2
// GFX10: encoding: [0x00,0x00,0x14,0xd4,0xff,0x05,0x02,0x00]

v_cmpx_gt_f32_e64 s1, v2
// GFX10: encoding: [0x00,0x00,0x14,0xd4,0x01,0x04,0x02,0x00]

v_cmpx_gt_f32_e64 s101, v2
// GFX10: encoding: [0x00,0x00,0x14,0xd4,0x65,0x04,0x02,0x00]

v_cmpx_gt_f32_e64 vcc_lo, v2
// GFX10: encoding: [0x00,0x00,0x14,0xd4,0x6a,0x04,0x02,0x00]

v_cmpx_gt_f32_e64 vcc_hi, v2
// GFX10: encoding: [0x00,0x00,0x14,0xd4,0x6b,0x04,0x02,0x00]

v_cmpx_gt_f32_e64 m0, v2
// GFX10: encoding: [0x00,0x00,0x14,0xd4,0x7c,0x04,0x02,0x00]

v_cmpx_gt_f32_e64 exec_lo, v2
// GFX10: encoding: [0x00,0x00,0x14,0xd4,0x7e,0x04,0x02,0x00]

v_cmpx_gt_f32_e64 exec_hi, v2
// GFX10: encoding: [0x00,0x00,0x14,0xd4,0x7f,0x04,0x02,0x00]

v_cmpx_gt_f32_e64 0, v2
// GFX10: encoding: [0x00,0x00,0x14,0xd4,0x80,0x04,0x02,0x00]

v_cmpx_gt_f32_e64 -1, v2
// GFX10: encoding: [0x00,0x00,0x14,0xd4,0xc1,0x04,0x02,0x00]

v_cmpx_gt_f32_e64 0.5, v2
// GFX10: encoding: [0x00,0x00,0x14,0xd4,0xf0,0x04,0x02,0x00]

v_cmpx_gt_f32_e64 -4.0, v2
// GFX10: encoding: [0x00,0x00,0x14,0xd4,0xf7,0x04,0x02,0x00]

v_cmpx_gt_f32_e64 v1, v255
// GFX10: encoding: [0x00,0x00,0x14,0xd4,0x01,0xff,0x03,0x00]

v_cmpx_gt_f32_e64 v1, s2
// GFX10: encoding: [0x00,0x00,0x14,0xd4,0x01,0x05,0x00,0x00]

v_cmpx_gt_f32_e64 v1, s101
// GFX10: encoding: [0x00,0x00,0x14,0xd4,0x01,0xcb,0x00,0x00]

v_cmpx_gt_f32_e64 v1, vcc_lo
// GFX10: encoding: [0x00,0x00,0x14,0xd4,0x01,0xd5,0x00,0x00]

v_cmpx_gt_f32_e64 v1, vcc_hi
// GFX10: encoding: [0x00,0x00,0x14,0xd4,0x01,0xd7,0x00,0x00]

v_cmpx_gt_f32_e64 v1, m0
// GFX10: encoding: [0x00,0x00,0x14,0xd4,0x01,0xf9,0x00,0x00]

v_cmpx_gt_f32_e64 v1, exec_lo
// GFX10: encoding: [0x00,0x00,0x14,0xd4,0x01,0xfd,0x00,0x00]

v_cmpx_gt_f32_e64 v1, exec_hi
// GFX10: encoding: [0x00,0x00,0x14,0xd4,0x01,0xff,0x00,0x00]

v_cmpx_gt_f32_e64 v1, 0
// GFX10: encoding: [0x00,0x00,0x14,0xd4,0x01,0x01,0x01,0x00]

v_cmpx_gt_f32_e64 v1, -1
// GFX10: encoding: [0x00,0x00,0x14,0xd4,0x01,0x83,0x01,0x00]

v_cmpx_gt_f32_e64 v1, 0.5
// GFX10: encoding: [0x00,0x00,0x14,0xd4,0x01,0xe1,0x01,0x00]

v_cmpx_gt_f32_e64 v1, -4.0
// GFX10: encoding: [0x00,0x00,0x14,0xd4,0x01,0xef,0x01,0x00]

v_cmpx_gt_f32_e64 -v1, v2
// GFX10: encoding: [0x00,0x00,0x14,0xd4,0x01,0x05,0x02,0x20]

v_cmpx_gt_f32_e64 v1, -v2
// GFX10: encoding: [0x00,0x00,0x14,0xd4,0x01,0x05,0x02,0x40]

v_cmpx_gt_f32_e64 -v1, -v2
// GFX10: encoding: [0x00,0x00,0x14,0xd4,0x01,0x05,0x02,0x60]

v_cmpx_lg_f32 v1, v2
// GFX10: encoding: [0x01,0x05,0x2a,0x7c]

v_cmpx_lg_f32 v255, v2
// GFX10: encoding: [0xff,0x05,0x2a,0x7c]

v_cmpx_lg_f32 s1, v2
// GFX10: encoding: [0x01,0x04,0x2a,0x7c]

v_cmpx_lg_f32 s101, v2
// GFX10: encoding: [0x65,0x04,0x2a,0x7c]

v_cmpx_lg_f32 vcc_lo, v2
// GFX10: encoding: [0x6a,0x04,0x2a,0x7c]

v_cmpx_lg_f32 vcc_hi, v2
// GFX10: encoding: [0x6b,0x04,0x2a,0x7c]

v_cmpx_lg_f32 m0, v2
// GFX10: encoding: [0x7c,0x04,0x2a,0x7c]

v_cmpx_lg_f32 exec_lo, v2
// GFX10: encoding: [0x7e,0x04,0x2a,0x7c]

v_cmpx_lg_f32 exec_hi, v2
// GFX10: encoding: [0x7f,0x04,0x2a,0x7c]

v_cmpx_lg_f32 0, v2
// GFX10: encoding: [0x80,0x04,0x2a,0x7c]

v_cmpx_lg_f32 -1, v2
// GFX10: encoding: [0xc1,0x04,0x2a,0x7c]

v_cmpx_lg_f32 0.5, v2
// GFX10: encoding: [0xf0,0x04,0x2a,0x7c]

v_cmpx_lg_f32 -4.0, v2
// GFX10: encoding: [0xf7,0x04,0x2a,0x7c]

v_cmpx_lg_f32 0xaf123456, v2
// GFX10: encoding: [0xff,0x04,0x2a,0x7c,0x56,0x34,0x12,0xaf]

v_cmpx_lg_f32 0x3f717273, v2
// GFX10: encoding: [0xff,0x04,0x2a,0x7c,0x73,0x72,0x71,0x3f]

v_cmpx_lg_f32 v1, v255
// GFX10: encoding: [0x01,0xff,0x2b,0x7c]

v_cmpx_lg_f32_e64 v1, v2
// GFX10: encoding: [0x00,0x00,0x15,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_lg_f32_e64 v255, v2
// GFX10: encoding: [0x00,0x00,0x15,0xd4,0xff,0x05,0x02,0x00]

v_cmpx_lg_f32_e64 s1, v2
// GFX10: encoding: [0x00,0x00,0x15,0xd4,0x01,0x04,0x02,0x00]

v_cmpx_lg_f32_e64 s101, v2
// GFX10: encoding: [0x00,0x00,0x15,0xd4,0x65,0x04,0x02,0x00]

v_cmpx_lg_f32_e64 vcc_lo, v2
// GFX10: encoding: [0x00,0x00,0x15,0xd4,0x6a,0x04,0x02,0x00]

v_cmpx_lg_f32_e64 vcc_hi, v2
// GFX10: encoding: [0x00,0x00,0x15,0xd4,0x6b,0x04,0x02,0x00]

v_cmpx_lg_f32_e64 m0, v2
// GFX10: encoding: [0x00,0x00,0x15,0xd4,0x7c,0x04,0x02,0x00]

v_cmpx_lg_f32_e64 exec_lo, v2
// GFX10: encoding: [0x00,0x00,0x15,0xd4,0x7e,0x04,0x02,0x00]

v_cmpx_lg_f32_e64 exec_hi, v2
// GFX10: encoding: [0x00,0x00,0x15,0xd4,0x7f,0x04,0x02,0x00]

v_cmpx_lg_f32_e64 0, v2
// GFX10: encoding: [0x00,0x00,0x15,0xd4,0x80,0x04,0x02,0x00]

v_cmpx_lg_f32_e64 -1, v2
// GFX10: encoding: [0x00,0x00,0x15,0xd4,0xc1,0x04,0x02,0x00]

v_cmpx_lg_f32_e64 0.5, v2
// GFX10: encoding: [0x00,0x00,0x15,0xd4,0xf0,0x04,0x02,0x00]

v_cmpx_lg_f32_e64 -4.0, v2
// GFX10: encoding: [0x00,0x00,0x15,0xd4,0xf7,0x04,0x02,0x00]

v_cmpx_lg_f32_e64 v1, v255
// GFX10: encoding: [0x00,0x00,0x15,0xd4,0x01,0xff,0x03,0x00]

v_cmpx_lg_f32_e64 v1, s2
// GFX10: encoding: [0x00,0x00,0x15,0xd4,0x01,0x05,0x00,0x00]

v_cmpx_lg_f32_e64 v1, s101
// GFX10: encoding: [0x00,0x00,0x15,0xd4,0x01,0xcb,0x00,0x00]

v_cmpx_lg_f32_e64 v1, vcc_lo
// GFX10: encoding: [0x00,0x00,0x15,0xd4,0x01,0xd5,0x00,0x00]

v_cmpx_lg_f32_e64 v1, vcc_hi
// GFX10: encoding: [0x00,0x00,0x15,0xd4,0x01,0xd7,0x00,0x00]

v_cmpx_lg_f32_e64 v1, m0
// GFX10: encoding: [0x00,0x00,0x15,0xd4,0x01,0xf9,0x00,0x00]

v_cmpx_lg_f32_e64 v1, exec_lo
// GFX10: encoding: [0x00,0x00,0x15,0xd4,0x01,0xfd,0x00,0x00]

v_cmpx_lg_f32_e64 v1, exec_hi
// GFX10: encoding: [0x00,0x00,0x15,0xd4,0x01,0xff,0x00,0x00]

v_cmpx_lg_f32_e64 v1, 0
// GFX10: encoding: [0x00,0x00,0x15,0xd4,0x01,0x01,0x01,0x00]

v_cmpx_lg_f32_e64 v1, -1
// GFX10: encoding: [0x00,0x00,0x15,0xd4,0x01,0x83,0x01,0x00]

v_cmpx_lg_f32_e64 v1, 0.5
// GFX10: encoding: [0x00,0x00,0x15,0xd4,0x01,0xe1,0x01,0x00]

v_cmpx_lg_f32_e64 v1, -4.0
// GFX10: encoding: [0x00,0x00,0x15,0xd4,0x01,0xef,0x01,0x00]

v_cmpx_lg_f32_e64 -v1, v2
// GFX10: encoding: [0x00,0x00,0x15,0xd4,0x01,0x05,0x02,0x20]

v_cmpx_lg_f32_e64 v1, -v2
// GFX10: encoding: [0x00,0x00,0x15,0xd4,0x01,0x05,0x02,0x40]

v_cmpx_lg_f32_e64 -v1, -v2
// GFX10: encoding: [0x00,0x00,0x15,0xd4,0x01,0x05,0x02,0x60]

v_cmpx_ge_f32 v1, v2
// GFX10: encoding: [0x01,0x05,0x2c,0x7c]

v_cmpx_ge_f32 v255, v2
// GFX10: encoding: [0xff,0x05,0x2c,0x7c]

v_cmpx_ge_f32 s1, v2
// GFX10: encoding: [0x01,0x04,0x2c,0x7c]

v_cmpx_ge_f32 s101, v2
// GFX10: encoding: [0x65,0x04,0x2c,0x7c]

v_cmpx_ge_f32 vcc_lo, v2
// GFX10: encoding: [0x6a,0x04,0x2c,0x7c]

v_cmpx_ge_f32 vcc_hi, v2
// GFX10: encoding: [0x6b,0x04,0x2c,0x7c]

v_cmpx_ge_f32 m0, v2
// GFX10: encoding: [0x7c,0x04,0x2c,0x7c]

v_cmpx_ge_f32 exec_lo, v2
// GFX10: encoding: [0x7e,0x04,0x2c,0x7c]

v_cmpx_ge_f32 exec_hi, v2
// GFX10: encoding: [0x7f,0x04,0x2c,0x7c]

v_cmpx_ge_f32 0, v2
// GFX10: encoding: [0x80,0x04,0x2c,0x7c]

v_cmpx_ge_f32 -1, v2
// GFX10: encoding: [0xc1,0x04,0x2c,0x7c]

v_cmpx_ge_f32 0.5, v2
// GFX10: encoding: [0xf0,0x04,0x2c,0x7c]

v_cmpx_ge_f32 -4.0, v2
// GFX10: encoding: [0xf7,0x04,0x2c,0x7c]

v_cmpx_ge_f32 0xaf123456, v2
// GFX10: encoding: [0xff,0x04,0x2c,0x7c,0x56,0x34,0x12,0xaf]

v_cmpx_ge_f32 0x3f717273, v2
// GFX10: encoding: [0xff,0x04,0x2c,0x7c,0x73,0x72,0x71,0x3f]

v_cmpx_ge_f32 v1, v255
// GFX10: encoding: [0x01,0xff,0x2d,0x7c]

v_cmpx_ge_f32_e64 v1, v2
// GFX10: encoding: [0x00,0x00,0x16,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_ge_f32_e64 v255, v2
// GFX10: encoding: [0x00,0x00,0x16,0xd4,0xff,0x05,0x02,0x00]

v_cmpx_ge_f32_e64 s1, v2
// GFX10: encoding: [0x00,0x00,0x16,0xd4,0x01,0x04,0x02,0x00]

v_cmpx_ge_f32_e64 s101, v2
// GFX10: encoding: [0x00,0x00,0x16,0xd4,0x65,0x04,0x02,0x00]

v_cmpx_ge_f32_e64 vcc_lo, v2
// GFX10: encoding: [0x00,0x00,0x16,0xd4,0x6a,0x04,0x02,0x00]

v_cmpx_ge_f32_e64 vcc_hi, v2
// GFX10: encoding: [0x00,0x00,0x16,0xd4,0x6b,0x04,0x02,0x00]

v_cmpx_ge_f32_e64 m0, v2
// GFX10: encoding: [0x00,0x00,0x16,0xd4,0x7c,0x04,0x02,0x00]

v_cmpx_ge_f32_e64 exec_lo, v2
// GFX10: encoding: [0x00,0x00,0x16,0xd4,0x7e,0x04,0x02,0x00]

v_cmpx_ge_f32_e64 exec_hi, v2
// GFX10: encoding: [0x00,0x00,0x16,0xd4,0x7f,0x04,0x02,0x00]

v_cmpx_ge_f32_e64 0, v2
// GFX10: encoding: [0x00,0x00,0x16,0xd4,0x80,0x04,0x02,0x00]

v_cmpx_ge_f32_e64 -1, v2
// GFX10: encoding: [0x00,0x00,0x16,0xd4,0xc1,0x04,0x02,0x00]

v_cmpx_ge_f32_e64 0.5, v2
// GFX10: encoding: [0x00,0x00,0x16,0xd4,0xf0,0x04,0x02,0x00]

v_cmpx_ge_f32_e64 -4.0, v2
// GFX10: encoding: [0x00,0x00,0x16,0xd4,0xf7,0x04,0x02,0x00]

v_cmpx_ge_f32_e64 v1, v255
// GFX10: encoding: [0x00,0x00,0x16,0xd4,0x01,0xff,0x03,0x00]

v_cmpx_ge_f32_e64 v1, s2
// GFX10: encoding: [0x00,0x00,0x16,0xd4,0x01,0x05,0x00,0x00]

v_cmpx_ge_f32_e64 v1, s101
// GFX10: encoding: [0x00,0x00,0x16,0xd4,0x01,0xcb,0x00,0x00]

v_cmpx_ge_f32_e64 v1, vcc_lo
// GFX10: encoding: [0x00,0x00,0x16,0xd4,0x01,0xd5,0x00,0x00]

v_cmpx_ge_f32_e64 v1, vcc_hi
// GFX10: encoding: [0x00,0x00,0x16,0xd4,0x01,0xd7,0x00,0x00]

v_cmpx_ge_f32_e64 v1, m0
// GFX10: encoding: [0x00,0x00,0x16,0xd4,0x01,0xf9,0x00,0x00]

v_cmpx_ge_f32_e64 v1, exec_lo
// GFX10: encoding: [0x00,0x00,0x16,0xd4,0x01,0xfd,0x00,0x00]

v_cmpx_ge_f32_e64 v1, exec_hi
// GFX10: encoding: [0x00,0x00,0x16,0xd4,0x01,0xff,0x00,0x00]

v_cmpx_ge_f32_e64 v1, 0
// GFX10: encoding: [0x00,0x00,0x16,0xd4,0x01,0x01,0x01,0x00]

v_cmpx_ge_f32_e64 v1, -1
// GFX10: encoding: [0x00,0x00,0x16,0xd4,0x01,0x83,0x01,0x00]

v_cmpx_ge_f32_e64 v1, 0.5
// GFX10: encoding: [0x00,0x00,0x16,0xd4,0x01,0xe1,0x01,0x00]

v_cmpx_ge_f32_e64 v1, -4.0
// GFX10: encoding: [0x00,0x00,0x16,0xd4,0x01,0xef,0x01,0x00]

v_cmpx_ge_f32_e64 -v1, v2
// GFX10: encoding: [0x00,0x00,0x16,0xd4,0x01,0x05,0x02,0x20]

v_cmpx_ge_f32_e64 v1, -v2
// GFX10: encoding: [0x00,0x00,0x16,0xd4,0x01,0x05,0x02,0x40]

v_cmpx_ge_f32_e64 -v1, -v2
// GFX10: encoding: [0x00,0x00,0x16,0xd4,0x01,0x05,0x02,0x60]

v_cmpx_o_f32 v1, v2
// GFX10: encoding: [0x01,0x05,0x2e,0x7c]

v_cmpx_o_f32 v255, v2
// GFX10: encoding: [0xff,0x05,0x2e,0x7c]

v_cmpx_o_f32 s1, v2
// GFX10: encoding: [0x01,0x04,0x2e,0x7c]

v_cmpx_o_f32 s101, v2
// GFX10: encoding: [0x65,0x04,0x2e,0x7c]

v_cmpx_o_f32 vcc_lo, v2
// GFX10: encoding: [0x6a,0x04,0x2e,0x7c]

v_cmpx_o_f32 vcc_hi, v2
// GFX10: encoding: [0x6b,0x04,0x2e,0x7c]

v_cmpx_o_f32 m0, v2
// GFX10: encoding: [0x7c,0x04,0x2e,0x7c]

v_cmpx_o_f32 exec_lo, v2
// GFX10: encoding: [0x7e,0x04,0x2e,0x7c]

v_cmpx_o_f32 exec_hi, v2
// GFX10: encoding: [0x7f,0x04,0x2e,0x7c]

v_cmpx_o_f32 0, v2
// GFX10: encoding: [0x80,0x04,0x2e,0x7c]

v_cmpx_o_f32 -1, v2
// GFX10: encoding: [0xc1,0x04,0x2e,0x7c]

v_cmpx_o_f32 0.5, v2
// GFX10: encoding: [0xf0,0x04,0x2e,0x7c]

v_cmpx_o_f32 -4.0, v2
// GFX10: encoding: [0xf7,0x04,0x2e,0x7c]

v_cmpx_o_f32 0xaf123456, v2
// GFX10: encoding: [0xff,0x04,0x2e,0x7c,0x56,0x34,0x12,0xaf]

v_cmpx_o_f32 0x3f717273, v2
// GFX10: encoding: [0xff,0x04,0x2e,0x7c,0x73,0x72,0x71,0x3f]

v_cmpx_o_f32 v1, v255
// GFX10: encoding: [0x01,0xff,0x2f,0x7c]

v_cmpx_o_f32_e64 v1, v2
// GFX10: encoding: [0x00,0x00,0x17,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_o_f32_e64 v255, v2
// GFX10: encoding: [0x00,0x00,0x17,0xd4,0xff,0x05,0x02,0x00]

v_cmpx_o_f32_e64 s1, v2
// GFX10: encoding: [0x00,0x00,0x17,0xd4,0x01,0x04,0x02,0x00]

v_cmpx_o_f32_e64 s101, v2
// GFX10: encoding: [0x00,0x00,0x17,0xd4,0x65,0x04,0x02,0x00]

v_cmpx_o_f32_e64 vcc_lo, v2
// GFX10: encoding: [0x00,0x00,0x17,0xd4,0x6a,0x04,0x02,0x00]

v_cmpx_o_f32_e64 vcc_hi, v2
// GFX10: encoding: [0x00,0x00,0x17,0xd4,0x6b,0x04,0x02,0x00]

v_cmpx_o_f32_e64 m0, v2
// GFX10: encoding: [0x00,0x00,0x17,0xd4,0x7c,0x04,0x02,0x00]

v_cmpx_o_f32_e64 exec_lo, v2
// GFX10: encoding: [0x00,0x00,0x17,0xd4,0x7e,0x04,0x02,0x00]

v_cmpx_o_f32_e64 exec_hi, v2
// GFX10: encoding: [0x00,0x00,0x17,0xd4,0x7f,0x04,0x02,0x00]

v_cmpx_o_f32_e64 0, v2
// GFX10: encoding: [0x00,0x00,0x17,0xd4,0x80,0x04,0x02,0x00]

v_cmpx_o_f32_e64 -1, v2
// GFX10: encoding: [0x00,0x00,0x17,0xd4,0xc1,0x04,0x02,0x00]

v_cmpx_o_f32_e64 0.5, v2
// GFX10: encoding: [0x00,0x00,0x17,0xd4,0xf0,0x04,0x02,0x00]

v_cmpx_o_f32_e64 -4.0, v2
// GFX10: encoding: [0x00,0x00,0x17,0xd4,0xf7,0x04,0x02,0x00]

v_cmpx_o_f32_e64 v1, v255
// GFX10: encoding: [0x00,0x00,0x17,0xd4,0x01,0xff,0x03,0x00]

v_cmpx_o_f32_e64 v1, s2
// GFX10: encoding: [0x00,0x00,0x17,0xd4,0x01,0x05,0x00,0x00]

v_cmpx_o_f32_e64 v1, s101
// GFX10: encoding: [0x00,0x00,0x17,0xd4,0x01,0xcb,0x00,0x00]

v_cmpx_o_f32_e64 v1, vcc_lo
// GFX10: encoding: [0x00,0x00,0x17,0xd4,0x01,0xd5,0x00,0x00]

v_cmpx_o_f32_e64 v1, vcc_hi
// GFX10: encoding: [0x00,0x00,0x17,0xd4,0x01,0xd7,0x00,0x00]

v_cmpx_o_f32_e64 v1, m0
// GFX10: encoding: [0x00,0x00,0x17,0xd4,0x01,0xf9,0x00,0x00]

v_cmpx_o_f32_e64 v1, exec_lo
// GFX10: encoding: [0x00,0x00,0x17,0xd4,0x01,0xfd,0x00,0x00]

v_cmpx_o_f32_e64 v1, exec_hi
// GFX10: encoding: [0x00,0x00,0x17,0xd4,0x01,0xff,0x00,0x00]

v_cmpx_o_f32_e64 v1, 0
// GFX10: encoding: [0x00,0x00,0x17,0xd4,0x01,0x01,0x01,0x00]

v_cmpx_o_f32_e64 v1, -1
// GFX10: encoding: [0x00,0x00,0x17,0xd4,0x01,0x83,0x01,0x00]

v_cmpx_o_f32_e64 v1, 0.5
// GFX10: encoding: [0x00,0x00,0x17,0xd4,0x01,0xe1,0x01,0x00]

v_cmpx_o_f32_e64 v1, -4.0
// GFX10: encoding: [0x00,0x00,0x17,0xd4,0x01,0xef,0x01,0x00]

v_cmpx_o_f32_e64 -v1, v2
// GFX10: encoding: [0x00,0x00,0x17,0xd4,0x01,0x05,0x02,0x20]

v_cmpx_o_f32_e64 v1, -v2
// GFX10: encoding: [0x00,0x00,0x17,0xd4,0x01,0x05,0x02,0x40]

v_cmpx_o_f32_e64 -v1, -v2
// GFX10: encoding: [0x00,0x00,0x17,0xd4,0x01,0x05,0x02,0x60]

v_cmpx_u_f32 v1, v2
// GFX10: encoding: [0x01,0x05,0x30,0x7c]

v_cmpx_u_f32 v255, v2
// GFX10: encoding: [0xff,0x05,0x30,0x7c]

v_cmpx_u_f32 s1, v2
// GFX10: encoding: [0x01,0x04,0x30,0x7c]

v_cmpx_u_f32 s101, v2
// GFX10: encoding: [0x65,0x04,0x30,0x7c]

v_cmpx_u_f32 vcc_lo, v2
// GFX10: encoding: [0x6a,0x04,0x30,0x7c]

v_cmpx_u_f32 vcc_hi, v2
// GFX10: encoding: [0x6b,0x04,0x30,0x7c]

v_cmpx_u_f32 m0, v2
// GFX10: encoding: [0x7c,0x04,0x30,0x7c]

v_cmpx_u_f32 exec_lo, v2
// GFX10: encoding: [0x7e,0x04,0x30,0x7c]

v_cmpx_u_f32 exec_hi, v2
// GFX10: encoding: [0x7f,0x04,0x30,0x7c]

v_cmpx_u_f32 0, v2
// GFX10: encoding: [0x80,0x04,0x30,0x7c]

v_cmpx_u_f32 -1, v2
// GFX10: encoding: [0xc1,0x04,0x30,0x7c]

v_cmpx_u_f32 0.5, v2
// GFX10: encoding: [0xf0,0x04,0x30,0x7c]

v_cmpx_u_f32 -4.0, v2
// GFX10: encoding: [0xf7,0x04,0x30,0x7c]

v_cmpx_u_f32 0xaf123456, v2
// GFX10: encoding: [0xff,0x04,0x30,0x7c,0x56,0x34,0x12,0xaf]

v_cmpx_u_f32 0x3f717273, v2
// GFX10: encoding: [0xff,0x04,0x30,0x7c,0x73,0x72,0x71,0x3f]

v_cmpx_u_f32 v1, v255
// GFX10: encoding: [0x01,0xff,0x31,0x7c]

v_cmpx_u_f32_e64 v1, v2
// GFX10: encoding: [0x00,0x00,0x18,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_u_f32_e64 v255, v2
// GFX10: encoding: [0x00,0x00,0x18,0xd4,0xff,0x05,0x02,0x00]

v_cmpx_u_f32_e64 s1, v2
// GFX10: encoding: [0x00,0x00,0x18,0xd4,0x01,0x04,0x02,0x00]

v_cmpx_u_f32_e64 s101, v2
// GFX10: encoding: [0x00,0x00,0x18,0xd4,0x65,0x04,0x02,0x00]

v_cmpx_u_f32_e64 vcc_lo, v2
// GFX10: encoding: [0x00,0x00,0x18,0xd4,0x6a,0x04,0x02,0x00]

v_cmpx_u_f32_e64 vcc_hi, v2
// GFX10: encoding: [0x00,0x00,0x18,0xd4,0x6b,0x04,0x02,0x00]

v_cmpx_u_f32_e64 m0, v2
// GFX10: encoding: [0x00,0x00,0x18,0xd4,0x7c,0x04,0x02,0x00]

v_cmpx_u_f32_e64 exec_lo, v2
// GFX10: encoding: [0x00,0x00,0x18,0xd4,0x7e,0x04,0x02,0x00]

v_cmpx_u_f32_e64 exec_hi, v2
// GFX10: encoding: [0x00,0x00,0x18,0xd4,0x7f,0x04,0x02,0x00]

v_cmpx_u_f32_e64 0, v2
// GFX10: encoding: [0x00,0x00,0x18,0xd4,0x80,0x04,0x02,0x00]

v_cmpx_u_f32_e64 -1, v2
// GFX10: encoding: [0x00,0x00,0x18,0xd4,0xc1,0x04,0x02,0x00]

v_cmpx_u_f32_e64 0.5, v2
// GFX10: encoding: [0x00,0x00,0x18,0xd4,0xf0,0x04,0x02,0x00]

v_cmpx_u_f32_e64 -4.0, v2
// GFX10: encoding: [0x00,0x00,0x18,0xd4,0xf7,0x04,0x02,0x00]

v_cmpx_u_f32_e64 v1, v255
// GFX10: encoding: [0x00,0x00,0x18,0xd4,0x01,0xff,0x03,0x00]

v_cmpx_u_f32_e64 v1, s2
// GFX10: encoding: [0x00,0x00,0x18,0xd4,0x01,0x05,0x00,0x00]

v_cmpx_u_f32_e64 v1, s101
// GFX10: encoding: [0x00,0x00,0x18,0xd4,0x01,0xcb,0x00,0x00]

v_cmpx_u_f32_e64 v1, vcc_lo
// GFX10: encoding: [0x00,0x00,0x18,0xd4,0x01,0xd5,0x00,0x00]

v_cmpx_u_f32_e64 v1, vcc_hi
// GFX10: encoding: [0x00,0x00,0x18,0xd4,0x01,0xd7,0x00,0x00]

v_cmpx_u_f32_e64 v1, m0
// GFX10: encoding: [0x00,0x00,0x18,0xd4,0x01,0xf9,0x00,0x00]

v_cmpx_u_f32_e64 v1, exec_lo
// GFX10: encoding: [0x00,0x00,0x18,0xd4,0x01,0xfd,0x00,0x00]

v_cmpx_u_f32_e64 v1, exec_hi
// GFX10: encoding: [0x00,0x00,0x18,0xd4,0x01,0xff,0x00,0x00]

v_cmpx_u_f32_e64 v1, 0
// GFX10: encoding: [0x00,0x00,0x18,0xd4,0x01,0x01,0x01,0x00]

v_cmpx_u_f32_e64 v1, -1
// GFX10: encoding: [0x00,0x00,0x18,0xd4,0x01,0x83,0x01,0x00]

v_cmpx_u_f32_e64 v1, 0.5
// GFX10: encoding: [0x00,0x00,0x18,0xd4,0x01,0xe1,0x01,0x00]

v_cmpx_u_f32_e64 v1, -4.0
// GFX10: encoding: [0x00,0x00,0x18,0xd4,0x01,0xef,0x01,0x00]

v_cmpx_u_f32_e64 -v1, v2
// GFX10: encoding: [0x00,0x00,0x18,0xd4,0x01,0x05,0x02,0x20]

v_cmpx_u_f32_e64 v1, -v2
// GFX10: encoding: [0x00,0x00,0x18,0xd4,0x01,0x05,0x02,0x40]

v_cmpx_u_f32_e64 -v1, -v2
// GFX10: encoding: [0x00,0x00,0x18,0xd4,0x01,0x05,0x02,0x60]

v_cmpx_nge_f32 v1, v2
// GFX10: encoding: [0x01,0x05,0x32,0x7c]

v_cmpx_nge_f32 v255, v2
// GFX10: encoding: [0xff,0x05,0x32,0x7c]

v_cmpx_nge_f32 s1, v2
// GFX10: encoding: [0x01,0x04,0x32,0x7c]

v_cmpx_nge_f32 s101, v2
// GFX10: encoding: [0x65,0x04,0x32,0x7c]

v_cmpx_nge_f32 vcc_lo, v2
// GFX10: encoding: [0x6a,0x04,0x32,0x7c]

v_cmpx_nge_f32 vcc_hi, v2
// GFX10: encoding: [0x6b,0x04,0x32,0x7c]

v_cmpx_nge_f32 m0, v2
// GFX10: encoding: [0x7c,0x04,0x32,0x7c]

v_cmpx_nge_f32 exec_lo, v2
// GFX10: encoding: [0x7e,0x04,0x32,0x7c]

v_cmpx_nge_f32 exec_hi, v2
// GFX10: encoding: [0x7f,0x04,0x32,0x7c]

v_cmpx_nge_f32 0, v2
// GFX10: encoding: [0x80,0x04,0x32,0x7c]

v_cmpx_nge_f32 -1, v2
// GFX10: encoding: [0xc1,0x04,0x32,0x7c]

v_cmpx_nge_f32 0.5, v2
// GFX10: encoding: [0xf0,0x04,0x32,0x7c]

v_cmpx_nge_f32 -4.0, v2
// GFX10: encoding: [0xf7,0x04,0x32,0x7c]

v_cmpx_nge_f32 0xaf123456, v2
// GFX10: encoding: [0xff,0x04,0x32,0x7c,0x56,0x34,0x12,0xaf]

v_cmpx_nge_f32 0x3f717273, v2
// GFX10: encoding: [0xff,0x04,0x32,0x7c,0x73,0x72,0x71,0x3f]

v_cmpx_nge_f32 v1, v255
// GFX10: encoding: [0x01,0xff,0x33,0x7c]

v_cmpx_nge_f32_e64 v1, v2
// GFX10: encoding: [0x00,0x00,0x19,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_nge_f32_e64 v255, v2
// GFX10: encoding: [0x00,0x00,0x19,0xd4,0xff,0x05,0x02,0x00]

v_cmpx_nge_f32_e64 s1, v2
// GFX10: encoding: [0x00,0x00,0x19,0xd4,0x01,0x04,0x02,0x00]

v_cmpx_nge_f32_e64 s101, v2
// GFX10: encoding: [0x00,0x00,0x19,0xd4,0x65,0x04,0x02,0x00]

v_cmpx_nge_f32_e64 vcc_lo, v2
// GFX10: encoding: [0x00,0x00,0x19,0xd4,0x6a,0x04,0x02,0x00]

v_cmpx_nge_f32_e64 vcc_hi, v2
// GFX10: encoding: [0x00,0x00,0x19,0xd4,0x6b,0x04,0x02,0x00]

v_cmpx_nge_f32_e64 m0, v2
// GFX10: encoding: [0x00,0x00,0x19,0xd4,0x7c,0x04,0x02,0x00]

v_cmpx_nge_f32_e64 exec_lo, v2
// GFX10: encoding: [0x00,0x00,0x19,0xd4,0x7e,0x04,0x02,0x00]

v_cmpx_nge_f32_e64 exec_hi, v2
// GFX10: encoding: [0x00,0x00,0x19,0xd4,0x7f,0x04,0x02,0x00]

v_cmpx_nge_f32_e64 0, v2
// GFX10: encoding: [0x00,0x00,0x19,0xd4,0x80,0x04,0x02,0x00]

v_cmpx_nge_f32_e64 -1, v2
// GFX10: encoding: [0x00,0x00,0x19,0xd4,0xc1,0x04,0x02,0x00]

v_cmpx_nge_f32_e64 0.5, v2
// GFX10: encoding: [0x00,0x00,0x19,0xd4,0xf0,0x04,0x02,0x00]

v_cmpx_nge_f32_e64 -4.0, v2
// GFX10: encoding: [0x00,0x00,0x19,0xd4,0xf7,0x04,0x02,0x00]

v_cmpx_nge_f32_e64 v1, v255
// GFX10: encoding: [0x00,0x00,0x19,0xd4,0x01,0xff,0x03,0x00]

v_cmpx_nge_f32_e64 v1, s2
// GFX10: encoding: [0x00,0x00,0x19,0xd4,0x01,0x05,0x00,0x00]

v_cmpx_nge_f32_e64 v1, s101
// GFX10: encoding: [0x00,0x00,0x19,0xd4,0x01,0xcb,0x00,0x00]

v_cmpx_nge_f32_e64 v1, vcc_lo
// GFX10: encoding: [0x00,0x00,0x19,0xd4,0x01,0xd5,0x00,0x00]

v_cmpx_nge_f32_e64 v1, vcc_hi
// GFX10: encoding: [0x00,0x00,0x19,0xd4,0x01,0xd7,0x00,0x00]

v_cmpx_nge_f32_e64 v1, m0
// GFX10: encoding: [0x00,0x00,0x19,0xd4,0x01,0xf9,0x00,0x00]

v_cmpx_nge_f32_e64 v1, exec_lo
// GFX10: encoding: [0x00,0x00,0x19,0xd4,0x01,0xfd,0x00,0x00]

v_cmpx_nge_f32_e64 v1, exec_hi
// GFX10: encoding: [0x00,0x00,0x19,0xd4,0x01,0xff,0x00,0x00]

v_cmpx_nge_f32_e64 v1, 0
// GFX10: encoding: [0x00,0x00,0x19,0xd4,0x01,0x01,0x01,0x00]

v_cmpx_nge_f32_e64 v1, -1
// GFX10: encoding: [0x00,0x00,0x19,0xd4,0x01,0x83,0x01,0x00]

v_cmpx_nge_f32_e64 v1, 0.5
// GFX10: encoding: [0x00,0x00,0x19,0xd4,0x01,0xe1,0x01,0x00]

v_cmpx_nge_f32_e64 v1, -4.0
// GFX10: encoding: [0x00,0x00,0x19,0xd4,0x01,0xef,0x01,0x00]

v_cmpx_nge_f32_e64 -v1, v2
// GFX10: encoding: [0x00,0x00,0x19,0xd4,0x01,0x05,0x02,0x20]

v_cmpx_nge_f32_e64 v1, -v2
// GFX10: encoding: [0x00,0x00,0x19,0xd4,0x01,0x05,0x02,0x40]

v_cmpx_nge_f32_e64 -v1, -v2
// GFX10: encoding: [0x00,0x00,0x19,0xd4,0x01,0x05,0x02,0x60]

v_cmpx_nlg_f32 v1, v2
// GFX10: encoding: [0x01,0x05,0x34,0x7c]

v_cmpx_nlg_f32 v255, v2
// GFX10: encoding: [0xff,0x05,0x34,0x7c]

v_cmpx_nlg_f32 s1, v2
// GFX10: encoding: [0x01,0x04,0x34,0x7c]

v_cmpx_nlg_f32 s101, v2
// GFX10: encoding: [0x65,0x04,0x34,0x7c]

v_cmpx_nlg_f32 vcc_lo, v2
// GFX10: encoding: [0x6a,0x04,0x34,0x7c]

v_cmpx_nlg_f32 vcc_hi, v2
// GFX10: encoding: [0x6b,0x04,0x34,0x7c]

v_cmpx_nlg_f32 m0, v2
// GFX10: encoding: [0x7c,0x04,0x34,0x7c]

v_cmpx_nlg_f32 exec_lo, v2
// GFX10: encoding: [0x7e,0x04,0x34,0x7c]

v_cmpx_nlg_f32 exec_hi, v2
// GFX10: encoding: [0x7f,0x04,0x34,0x7c]

v_cmpx_nlg_f32 0, v2
// GFX10: encoding: [0x80,0x04,0x34,0x7c]

v_cmpx_nlg_f32 -1, v2
// GFX10: encoding: [0xc1,0x04,0x34,0x7c]

v_cmpx_nlg_f32 0.5, v2
// GFX10: encoding: [0xf0,0x04,0x34,0x7c]

v_cmpx_nlg_f32 -4.0, v2
// GFX10: encoding: [0xf7,0x04,0x34,0x7c]

v_cmpx_nlg_f32 0xaf123456, v2
// GFX10: encoding: [0xff,0x04,0x34,0x7c,0x56,0x34,0x12,0xaf]

v_cmpx_nlg_f32 0x3f717273, v2
// GFX10: encoding: [0xff,0x04,0x34,0x7c,0x73,0x72,0x71,0x3f]

v_cmpx_nlg_f32 v1, v255
// GFX10: encoding: [0x01,0xff,0x35,0x7c]

v_cmpx_nlg_f32_e64 v1, v2
// GFX10: encoding: [0x00,0x00,0x1a,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_nlg_f32_e64 v255, v2
// GFX10: encoding: [0x00,0x00,0x1a,0xd4,0xff,0x05,0x02,0x00]

v_cmpx_nlg_f32_e64 s1, v2
// GFX10: encoding: [0x00,0x00,0x1a,0xd4,0x01,0x04,0x02,0x00]

v_cmpx_nlg_f32_e64 s101, v2
// GFX10: encoding: [0x00,0x00,0x1a,0xd4,0x65,0x04,0x02,0x00]

v_cmpx_nlg_f32_e64 vcc_lo, v2
// GFX10: encoding: [0x00,0x00,0x1a,0xd4,0x6a,0x04,0x02,0x00]

v_cmpx_nlg_f32_e64 vcc_hi, v2
// GFX10: encoding: [0x00,0x00,0x1a,0xd4,0x6b,0x04,0x02,0x00]

v_cmpx_nlg_f32_e64 m0, v2
// GFX10: encoding: [0x00,0x00,0x1a,0xd4,0x7c,0x04,0x02,0x00]

v_cmpx_nlg_f32_e64 exec_lo, v2
// GFX10: encoding: [0x00,0x00,0x1a,0xd4,0x7e,0x04,0x02,0x00]

v_cmpx_nlg_f32_e64 exec_hi, v2
// GFX10: encoding: [0x00,0x00,0x1a,0xd4,0x7f,0x04,0x02,0x00]

v_cmpx_nlg_f32_e64 0, v2
// GFX10: encoding: [0x00,0x00,0x1a,0xd4,0x80,0x04,0x02,0x00]

v_cmpx_nlg_f32_e64 -1, v2
// GFX10: encoding: [0x00,0x00,0x1a,0xd4,0xc1,0x04,0x02,0x00]

v_cmpx_nlg_f32_e64 0.5, v2
// GFX10: encoding: [0x00,0x00,0x1a,0xd4,0xf0,0x04,0x02,0x00]

v_cmpx_nlg_f32_e64 -4.0, v2
// GFX10: encoding: [0x00,0x00,0x1a,0xd4,0xf7,0x04,0x02,0x00]

v_cmpx_nlg_f32_e64 v1, v255
// GFX10: encoding: [0x00,0x00,0x1a,0xd4,0x01,0xff,0x03,0x00]

v_cmpx_nlg_f32_e64 v1, s2
// GFX10: encoding: [0x00,0x00,0x1a,0xd4,0x01,0x05,0x00,0x00]

v_cmpx_nlg_f32_e64 v1, s101
// GFX10: encoding: [0x00,0x00,0x1a,0xd4,0x01,0xcb,0x00,0x00]

v_cmpx_nlg_f32_e64 v1, vcc_lo
// GFX10: encoding: [0x00,0x00,0x1a,0xd4,0x01,0xd5,0x00,0x00]

v_cmpx_nlg_f32_e64 v1, vcc_hi
// GFX10: encoding: [0x00,0x00,0x1a,0xd4,0x01,0xd7,0x00,0x00]

v_cmpx_nlg_f32_e64 v1, m0
// GFX10: encoding: [0x00,0x00,0x1a,0xd4,0x01,0xf9,0x00,0x00]

v_cmpx_nlg_f32_e64 v1, exec_lo
// GFX10: encoding: [0x00,0x00,0x1a,0xd4,0x01,0xfd,0x00,0x00]

v_cmpx_nlg_f32_e64 v1, exec_hi
// GFX10: encoding: [0x00,0x00,0x1a,0xd4,0x01,0xff,0x00,0x00]

v_cmpx_nlg_f32_e64 v1, 0
// GFX10: encoding: [0x00,0x00,0x1a,0xd4,0x01,0x01,0x01,0x00]

v_cmpx_nlg_f32_e64 v1, -1
// GFX10: encoding: [0x00,0x00,0x1a,0xd4,0x01,0x83,0x01,0x00]

v_cmpx_nlg_f32_e64 v1, 0.5
// GFX10: encoding: [0x00,0x00,0x1a,0xd4,0x01,0xe1,0x01,0x00]

v_cmpx_nlg_f32_e64 v1, -4.0
// GFX10: encoding: [0x00,0x00,0x1a,0xd4,0x01,0xef,0x01,0x00]

v_cmpx_nlg_f32_e64 -v1, v2
// GFX10: encoding: [0x00,0x00,0x1a,0xd4,0x01,0x05,0x02,0x20]

v_cmpx_nlg_f32_e64 v1, -v2
// GFX10: encoding: [0x00,0x00,0x1a,0xd4,0x01,0x05,0x02,0x40]

v_cmpx_nlg_f32_e64 -v1, -v2
// GFX10: encoding: [0x00,0x00,0x1a,0xd4,0x01,0x05,0x02,0x60]

v_cmpx_ngt_f32 v1, v2
// GFX10: encoding: [0x01,0x05,0x36,0x7c]

v_cmpx_ngt_f32 v255, v2
// GFX10: encoding: [0xff,0x05,0x36,0x7c]

v_cmpx_ngt_f32 s1, v2
// GFX10: encoding: [0x01,0x04,0x36,0x7c]

v_cmpx_ngt_f32 s101, v2
// GFX10: encoding: [0x65,0x04,0x36,0x7c]

v_cmpx_ngt_f32 vcc_lo, v2
// GFX10: encoding: [0x6a,0x04,0x36,0x7c]

v_cmpx_ngt_f32 vcc_hi, v2
// GFX10: encoding: [0x6b,0x04,0x36,0x7c]

v_cmpx_ngt_f32 m0, v2
// GFX10: encoding: [0x7c,0x04,0x36,0x7c]

v_cmpx_ngt_f32 exec_lo, v2
// GFX10: encoding: [0x7e,0x04,0x36,0x7c]

v_cmpx_ngt_f32 exec_hi, v2
// GFX10: encoding: [0x7f,0x04,0x36,0x7c]

v_cmpx_ngt_f32 0, v2
// GFX10: encoding: [0x80,0x04,0x36,0x7c]

v_cmpx_ngt_f32 -1, v2
// GFX10: encoding: [0xc1,0x04,0x36,0x7c]

v_cmpx_ngt_f32 0.5, v2
// GFX10: encoding: [0xf0,0x04,0x36,0x7c]

v_cmpx_ngt_f32 -4.0, v2
// GFX10: encoding: [0xf7,0x04,0x36,0x7c]

v_cmpx_ngt_f32 0xaf123456, v2
// GFX10: encoding: [0xff,0x04,0x36,0x7c,0x56,0x34,0x12,0xaf]

v_cmpx_ngt_f32 0x3f717273, v2
// GFX10: encoding: [0xff,0x04,0x36,0x7c,0x73,0x72,0x71,0x3f]

v_cmpx_ngt_f32 v1, v255
// GFX10: encoding: [0x01,0xff,0x37,0x7c]

v_cmpx_ngt_f32_e64 v1, v2
// GFX10: encoding: [0x00,0x00,0x1b,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_ngt_f32_e64 v255, v2
// GFX10: encoding: [0x00,0x00,0x1b,0xd4,0xff,0x05,0x02,0x00]

v_cmpx_ngt_f32_e64 s1, v2
// GFX10: encoding: [0x00,0x00,0x1b,0xd4,0x01,0x04,0x02,0x00]

v_cmpx_ngt_f32_e64 s101, v2
// GFX10: encoding: [0x00,0x00,0x1b,0xd4,0x65,0x04,0x02,0x00]

v_cmpx_ngt_f32_e64 vcc_lo, v2
// GFX10: encoding: [0x00,0x00,0x1b,0xd4,0x6a,0x04,0x02,0x00]

v_cmpx_ngt_f32_e64 vcc_hi, v2
// GFX10: encoding: [0x00,0x00,0x1b,0xd4,0x6b,0x04,0x02,0x00]

v_cmpx_ngt_f32_e64 m0, v2
// GFX10: encoding: [0x00,0x00,0x1b,0xd4,0x7c,0x04,0x02,0x00]

v_cmpx_ngt_f32_e64 exec_lo, v2
// GFX10: encoding: [0x00,0x00,0x1b,0xd4,0x7e,0x04,0x02,0x00]

v_cmpx_ngt_f32_e64 exec_hi, v2
// GFX10: encoding: [0x00,0x00,0x1b,0xd4,0x7f,0x04,0x02,0x00]

v_cmpx_ngt_f32_e64 0, v2
// GFX10: encoding: [0x00,0x00,0x1b,0xd4,0x80,0x04,0x02,0x00]

v_cmpx_ngt_f32_e64 -1, v2
// GFX10: encoding: [0x00,0x00,0x1b,0xd4,0xc1,0x04,0x02,0x00]

v_cmpx_ngt_f32_e64 0.5, v2
// GFX10: encoding: [0x00,0x00,0x1b,0xd4,0xf0,0x04,0x02,0x00]

v_cmpx_ngt_f32_e64 -4.0, v2
// GFX10: encoding: [0x00,0x00,0x1b,0xd4,0xf7,0x04,0x02,0x00]

v_cmpx_ngt_f32_e64 v1, v255
// GFX10: encoding: [0x00,0x00,0x1b,0xd4,0x01,0xff,0x03,0x00]

v_cmpx_ngt_f32_e64 v1, s2
// GFX10: encoding: [0x00,0x00,0x1b,0xd4,0x01,0x05,0x00,0x00]

v_cmpx_ngt_f32_e64 v1, s101
// GFX10: encoding: [0x00,0x00,0x1b,0xd4,0x01,0xcb,0x00,0x00]

v_cmpx_ngt_f32_e64 v1, vcc_lo
// GFX10: encoding: [0x00,0x00,0x1b,0xd4,0x01,0xd5,0x00,0x00]

v_cmpx_ngt_f32_e64 v1, vcc_hi
// GFX10: encoding: [0x00,0x00,0x1b,0xd4,0x01,0xd7,0x00,0x00]

v_cmpx_ngt_f32_e64 v1, m0
// GFX10: encoding: [0x00,0x00,0x1b,0xd4,0x01,0xf9,0x00,0x00]

v_cmpx_ngt_f32_e64 v1, exec_lo
// GFX10: encoding: [0x00,0x00,0x1b,0xd4,0x01,0xfd,0x00,0x00]

v_cmpx_ngt_f32_e64 v1, exec_hi
// GFX10: encoding: [0x00,0x00,0x1b,0xd4,0x01,0xff,0x00,0x00]

v_cmpx_ngt_f32_e64 v1, 0
// GFX10: encoding: [0x00,0x00,0x1b,0xd4,0x01,0x01,0x01,0x00]

v_cmpx_ngt_f32_e64 v1, -1
// GFX10: encoding: [0x00,0x00,0x1b,0xd4,0x01,0x83,0x01,0x00]

v_cmpx_ngt_f32_e64 v1, 0.5
// GFX10: encoding: [0x00,0x00,0x1b,0xd4,0x01,0xe1,0x01,0x00]

v_cmpx_ngt_f32_e64 v1, -4.0
// GFX10: encoding: [0x00,0x00,0x1b,0xd4,0x01,0xef,0x01,0x00]

v_cmpx_ngt_f32_e64 -v1, v2
// GFX10: encoding: [0x00,0x00,0x1b,0xd4,0x01,0x05,0x02,0x20]

v_cmpx_ngt_f32_e64 v1, -v2
// GFX10: encoding: [0x00,0x00,0x1b,0xd4,0x01,0x05,0x02,0x40]

v_cmpx_ngt_f32_e64 -v1, -v2
// GFX10: encoding: [0x00,0x00,0x1b,0xd4,0x01,0x05,0x02,0x60]

v_cmpx_nle_f32 v1, v2
// GFX10: encoding: [0x01,0x05,0x38,0x7c]

v_cmpx_nle_f32 v255, v2
// GFX10: encoding: [0xff,0x05,0x38,0x7c]

v_cmpx_nle_f32 s1, v2
// GFX10: encoding: [0x01,0x04,0x38,0x7c]

v_cmpx_nle_f32 s101, v2
// GFX10: encoding: [0x65,0x04,0x38,0x7c]

v_cmpx_nle_f32 vcc_lo, v2
// GFX10: encoding: [0x6a,0x04,0x38,0x7c]

v_cmpx_nle_f32 vcc_hi, v2
// GFX10: encoding: [0x6b,0x04,0x38,0x7c]

v_cmpx_nle_f32 m0, v2
// GFX10: encoding: [0x7c,0x04,0x38,0x7c]

v_cmpx_nle_f32 exec_lo, v2
// GFX10: encoding: [0x7e,0x04,0x38,0x7c]

v_cmpx_nle_f32 exec_hi, v2
// GFX10: encoding: [0x7f,0x04,0x38,0x7c]

v_cmpx_nle_f32 0, v2
// GFX10: encoding: [0x80,0x04,0x38,0x7c]

v_cmpx_nle_f32 -1, v2
// GFX10: encoding: [0xc1,0x04,0x38,0x7c]

v_cmpx_nle_f32 0.5, v2
// GFX10: encoding: [0xf0,0x04,0x38,0x7c]

v_cmpx_nle_f32 -4.0, v2
// GFX10: encoding: [0xf7,0x04,0x38,0x7c]

v_cmpx_nle_f32 0xaf123456, v2
// GFX10: encoding: [0xff,0x04,0x38,0x7c,0x56,0x34,0x12,0xaf]

v_cmpx_nle_f32 0x3f717273, v2
// GFX10: encoding: [0xff,0x04,0x38,0x7c,0x73,0x72,0x71,0x3f]

v_cmpx_nle_f32 v1, v255
// GFX10: encoding: [0x01,0xff,0x39,0x7c]

v_cmpx_nle_f32_e64 v1, v2
// GFX10: encoding: [0x00,0x00,0x1c,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_nle_f32_e64 v255, v2
// GFX10: encoding: [0x00,0x00,0x1c,0xd4,0xff,0x05,0x02,0x00]

v_cmpx_nle_f32_e64 s1, v2
// GFX10: encoding: [0x00,0x00,0x1c,0xd4,0x01,0x04,0x02,0x00]

v_cmpx_nle_f32_e64 s101, v2
// GFX10: encoding: [0x00,0x00,0x1c,0xd4,0x65,0x04,0x02,0x00]

v_cmpx_nle_f32_e64 vcc_lo, v2
// GFX10: encoding: [0x00,0x00,0x1c,0xd4,0x6a,0x04,0x02,0x00]

v_cmpx_nle_f32_e64 vcc_hi, v2
// GFX10: encoding: [0x00,0x00,0x1c,0xd4,0x6b,0x04,0x02,0x00]

v_cmpx_nle_f32_e64 m0, v2
// GFX10: encoding: [0x00,0x00,0x1c,0xd4,0x7c,0x04,0x02,0x00]

v_cmpx_nle_f32_e64 exec_lo, v2
// GFX10: encoding: [0x00,0x00,0x1c,0xd4,0x7e,0x04,0x02,0x00]

v_cmpx_nle_f32_e64 exec_hi, v2
// GFX10: encoding: [0x00,0x00,0x1c,0xd4,0x7f,0x04,0x02,0x00]

v_cmpx_nle_f32_e64 0, v2
// GFX10: encoding: [0x00,0x00,0x1c,0xd4,0x80,0x04,0x02,0x00]

v_cmpx_nle_f32_e64 -1, v2
// GFX10: encoding: [0x00,0x00,0x1c,0xd4,0xc1,0x04,0x02,0x00]

v_cmpx_nle_f32_e64 0.5, v2
// GFX10: encoding: [0x00,0x00,0x1c,0xd4,0xf0,0x04,0x02,0x00]

v_cmpx_nle_f32_e64 -4.0, v2
// GFX10: encoding: [0x00,0x00,0x1c,0xd4,0xf7,0x04,0x02,0x00]

v_cmpx_nle_f32_e64 v1, v255
// GFX10: encoding: [0x00,0x00,0x1c,0xd4,0x01,0xff,0x03,0x00]

v_cmpx_nle_f32_e64 v1, s2
// GFX10: encoding: [0x00,0x00,0x1c,0xd4,0x01,0x05,0x00,0x00]

v_cmpx_nle_f32_e64 v1, s101
// GFX10: encoding: [0x00,0x00,0x1c,0xd4,0x01,0xcb,0x00,0x00]

v_cmpx_nle_f32_e64 v1, vcc_lo
// GFX10: encoding: [0x00,0x00,0x1c,0xd4,0x01,0xd5,0x00,0x00]

v_cmpx_nle_f32_e64 v1, vcc_hi
// GFX10: encoding: [0x00,0x00,0x1c,0xd4,0x01,0xd7,0x00,0x00]

v_cmpx_nle_f32_e64 v1, m0
// GFX10: encoding: [0x00,0x00,0x1c,0xd4,0x01,0xf9,0x00,0x00]

v_cmpx_nle_f32_e64 v1, exec_lo
// GFX10: encoding: [0x00,0x00,0x1c,0xd4,0x01,0xfd,0x00,0x00]

v_cmpx_nle_f32_e64 v1, exec_hi
// GFX10: encoding: [0x00,0x00,0x1c,0xd4,0x01,0xff,0x00,0x00]

v_cmpx_nle_f32_e64 v1, 0
// GFX10: encoding: [0x00,0x00,0x1c,0xd4,0x01,0x01,0x01,0x00]

v_cmpx_nle_f32_e64 v1, -1
// GFX10: encoding: [0x00,0x00,0x1c,0xd4,0x01,0x83,0x01,0x00]

v_cmpx_nle_f32_e64 v1, 0.5
// GFX10: encoding: [0x00,0x00,0x1c,0xd4,0x01,0xe1,0x01,0x00]

v_cmpx_nle_f32_e64 v1, -4.0
// GFX10: encoding: [0x00,0x00,0x1c,0xd4,0x01,0xef,0x01,0x00]

v_cmpx_nle_f32_e64 -v1, v2
// GFX10: encoding: [0x00,0x00,0x1c,0xd4,0x01,0x05,0x02,0x20]

v_cmpx_nle_f32_e64 v1, -v2
// GFX10: encoding: [0x00,0x00,0x1c,0xd4,0x01,0x05,0x02,0x40]

v_cmpx_nle_f32_e64 -v1, -v2
// GFX10: encoding: [0x00,0x00,0x1c,0xd4,0x01,0x05,0x02,0x60]

v_cmpx_neq_f32 v1, v2
// GFX10: encoding: [0x01,0x05,0x3a,0x7c]

v_cmpx_neq_f32 v255, v2
// GFX10: encoding: [0xff,0x05,0x3a,0x7c]

v_cmpx_neq_f32 s1, v2
// GFX10: encoding: [0x01,0x04,0x3a,0x7c]

v_cmpx_neq_f32 s101, v2
// GFX10: encoding: [0x65,0x04,0x3a,0x7c]

v_cmpx_neq_f32 vcc_lo, v2
// GFX10: encoding: [0x6a,0x04,0x3a,0x7c]

v_cmpx_neq_f32 vcc_hi, v2
// GFX10: encoding: [0x6b,0x04,0x3a,0x7c]

v_cmpx_neq_f32 m0, v2
// GFX10: encoding: [0x7c,0x04,0x3a,0x7c]

v_cmpx_neq_f32 exec_lo, v2
// GFX10: encoding: [0x7e,0x04,0x3a,0x7c]

v_cmpx_neq_f32 exec_hi, v2
// GFX10: encoding: [0x7f,0x04,0x3a,0x7c]

v_cmpx_neq_f32 0, v2
// GFX10: encoding: [0x80,0x04,0x3a,0x7c]

v_cmpx_neq_f32 -1, v2
// GFX10: encoding: [0xc1,0x04,0x3a,0x7c]

v_cmpx_neq_f32 0.5, v2
// GFX10: encoding: [0xf0,0x04,0x3a,0x7c]

v_cmpx_neq_f32 -4.0, v2
// GFX10: encoding: [0xf7,0x04,0x3a,0x7c]

v_cmpx_neq_f32 0xaf123456, v2
// GFX10: encoding: [0xff,0x04,0x3a,0x7c,0x56,0x34,0x12,0xaf]

v_cmpx_neq_f32 0x3f717273, v2
// GFX10: encoding: [0xff,0x04,0x3a,0x7c,0x73,0x72,0x71,0x3f]

v_cmpx_neq_f32 v1, v255
// GFX10: encoding: [0x01,0xff,0x3b,0x7c]

v_cmpx_neq_f32_e64 v1, v2
// GFX10: encoding: [0x00,0x00,0x1d,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_neq_f32_e64 v255, v2
// GFX10: encoding: [0x00,0x00,0x1d,0xd4,0xff,0x05,0x02,0x00]

v_cmpx_neq_f32_e64 s1, v2
// GFX10: encoding: [0x00,0x00,0x1d,0xd4,0x01,0x04,0x02,0x00]

v_cmpx_neq_f32_e64 s101, v2
// GFX10: encoding: [0x00,0x00,0x1d,0xd4,0x65,0x04,0x02,0x00]

v_cmpx_neq_f32_e64 vcc_lo, v2
// GFX10: encoding: [0x00,0x00,0x1d,0xd4,0x6a,0x04,0x02,0x00]

v_cmpx_neq_f32_e64 vcc_hi, v2
// GFX10: encoding: [0x00,0x00,0x1d,0xd4,0x6b,0x04,0x02,0x00]

v_cmpx_neq_f32_e64 m0, v2
// GFX10: encoding: [0x00,0x00,0x1d,0xd4,0x7c,0x04,0x02,0x00]

v_cmpx_neq_f32_e64 exec_lo, v2
// GFX10: encoding: [0x00,0x00,0x1d,0xd4,0x7e,0x04,0x02,0x00]

v_cmpx_neq_f32_e64 exec_hi, v2
// GFX10: encoding: [0x00,0x00,0x1d,0xd4,0x7f,0x04,0x02,0x00]

v_cmpx_neq_f32_e64 0, v2
// GFX10: encoding: [0x00,0x00,0x1d,0xd4,0x80,0x04,0x02,0x00]

v_cmpx_neq_f32_e64 -1, v2
// GFX10: encoding: [0x00,0x00,0x1d,0xd4,0xc1,0x04,0x02,0x00]

v_cmpx_neq_f32_e64 0.5, v2
// GFX10: encoding: [0x00,0x00,0x1d,0xd4,0xf0,0x04,0x02,0x00]

v_cmpx_neq_f32_e64 -4.0, v2
// GFX10: encoding: [0x00,0x00,0x1d,0xd4,0xf7,0x04,0x02,0x00]

v_cmpx_neq_f32_e64 v1, v255
// GFX10: encoding: [0x00,0x00,0x1d,0xd4,0x01,0xff,0x03,0x00]

v_cmpx_neq_f32_e64 v1, s2
// GFX10: encoding: [0x00,0x00,0x1d,0xd4,0x01,0x05,0x00,0x00]

v_cmpx_neq_f32_e64 v1, s101
// GFX10: encoding: [0x00,0x00,0x1d,0xd4,0x01,0xcb,0x00,0x00]

v_cmpx_neq_f32_e64 v1, vcc_lo
// GFX10: encoding: [0x00,0x00,0x1d,0xd4,0x01,0xd5,0x00,0x00]

v_cmpx_neq_f32_e64 v1, vcc_hi
// GFX10: encoding: [0x00,0x00,0x1d,0xd4,0x01,0xd7,0x00,0x00]

v_cmpx_neq_f32_e64 v1, m0
// GFX10: encoding: [0x00,0x00,0x1d,0xd4,0x01,0xf9,0x00,0x00]

v_cmpx_neq_f32_e64 v1, exec_lo
// GFX10: encoding: [0x00,0x00,0x1d,0xd4,0x01,0xfd,0x00,0x00]

v_cmpx_neq_f32_e64 v1, exec_hi
// GFX10: encoding: [0x00,0x00,0x1d,0xd4,0x01,0xff,0x00,0x00]

v_cmpx_neq_f32_e64 v1, 0
// GFX10: encoding: [0x00,0x00,0x1d,0xd4,0x01,0x01,0x01,0x00]

v_cmpx_neq_f32_e64 v1, -1
// GFX10: encoding: [0x00,0x00,0x1d,0xd4,0x01,0x83,0x01,0x00]

v_cmpx_neq_f32_e64 v1, 0.5
// GFX10: encoding: [0x00,0x00,0x1d,0xd4,0x01,0xe1,0x01,0x00]

v_cmpx_neq_f32_e64 v1, -4.0
// GFX10: encoding: [0x00,0x00,0x1d,0xd4,0x01,0xef,0x01,0x00]

v_cmpx_neq_f32_e64 -v1, v2
// GFX10: encoding: [0x00,0x00,0x1d,0xd4,0x01,0x05,0x02,0x20]

v_cmpx_neq_f32_e64 v1, -v2
// GFX10: encoding: [0x00,0x00,0x1d,0xd4,0x01,0x05,0x02,0x40]

v_cmpx_neq_f32_e64 -v1, -v2
// GFX10: encoding: [0x00,0x00,0x1d,0xd4,0x01,0x05,0x02,0x60]

v_cmpx_nlt_f32 v1, v2
// GFX10: encoding: [0x01,0x05,0x3c,0x7c]

v_cmpx_nlt_f32 v255, v2
// GFX10: encoding: [0xff,0x05,0x3c,0x7c]

v_cmpx_nlt_f32 s1, v2
// GFX10: encoding: [0x01,0x04,0x3c,0x7c]

v_cmpx_nlt_f32 s101, v2
// GFX10: encoding: [0x65,0x04,0x3c,0x7c]

v_cmpx_nlt_f32 vcc_lo, v2
// GFX10: encoding: [0x6a,0x04,0x3c,0x7c]

v_cmpx_nlt_f32 vcc_hi, v2
// GFX10: encoding: [0x6b,0x04,0x3c,0x7c]

v_cmpx_nlt_f32 m0, v2
// GFX10: encoding: [0x7c,0x04,0x3c,0x7c]

v_cmpx_nlt_f32 exec_lo, v2
// GFX10: encoding: [0x7e,0x04,0x3c,0x7c]

v_cmpx_nlt_f32 exec_hi, v2
// GFX10: encoding: [0x7f,0x04,0x3c,0x7c]

v_cmpx_nlt_f32 0, v2
// GFX10: encoding: [0x80,0x04,0x3c,0x7c]

v_cmpx_nlt_f32 -1, v2
// GFX10: encoding: [0xc1,0x04,0x3c,0x7c]

v_cmpx_nlt_f32 0.5, v2
// GFX10: encoding: [0xf0,0x04,0x3c,0x7c]

v_cmpx_nlt_f32 -4.0, v2
// GFX10: encoding: [0xf7,0x04,0x3c,0x7c]

v_cmpx_nlt_f32 0xaf123456, v2
// GFX10: encoding: [0xff,0x04,0x3c,0x7c,0x56,0x34,0x12,0xaf]

v_cmpx_nlt_f32 0x3f717273, v2
// GFX10: encoding: [0xff,0x04,0x3c,0x7c,0x73,0x72,0x71,0x3f]

v_cmpx_nlt_f32 v1, v255
// GFX10: encoding: [0x01,0xff,0x3d,0x7c]

v_cmpx_nlt_f32_e64 v1, v2
// GFX10: encoding: [0x00,0x00,0x1e,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_nlt_f32_e64 v255, v2
// GFX10: encoding: [0x00,0x00,0x1e,0xd4,0xff,0x05,0x02,0x00]

v_cmpx_nlt_f32_e64 s1, v2
// GFX10: encoding: [0x00,0x00,0x1e,0xd4,0x01,0x04,0x02,0x00]

v_cmpx_nlt_f32_e64 s101, v2
// GFX10: encoding: [0x00,0x00,0x1e,0xd4,0x65,0x04,0x02,0x00]

v_cmpx_nlt_f32_e64 vcc_lo, v2
// GFX10: encoding: [0x00,0x00,0x1e,0xd4,0x6a,0x04,0x02,0x00]

v_cmpx_nlt_f32_e64 vcc_hi, v2
// GFX10: encoding: [0x00,0x00,0x1e,0xd4,0x6b,0x04,0x02,0x00]

v_cmpx_nlt_f32_e64 m0, v2
// GFX10: encoding: [0x00,0x00,0x1e,0xd4,0x7c,0x04,0x02,0x00]

v_cmpx_nlt_f32_e64 exec_lo, v2
// GFX10: encoding: [0x00,0x00,0x1e,0xd4,0x7e,0x04,0x02,0x00]

v_cmpx_nlt_f32_e64 exec_hi, v2
// GFX10: encoding: [0x00,0x00,0x1e,0xd4,0x7f,0x04,0x02,0x00]

v_cmpx_nlt_f32_e64 0, v2
// GFX10: encoding: [0x00,0x00,0x1e,0xd4,0x80,0x04,0x02,0x00]

v_cmpx_nlt_f32_e64 -1, v2
// GFX10: encoding: [0x00,0x00,0x1e,0xd4,0xc1,0x04,0x02,0x00]

v_cmpx_nlt_f32_e64 0.5, v2
// GFX10: encoding: [0x00,0x00,0x1e,0xd4,0xf0,0x04,0x02,0x00]

v_cmpx_nlt_f32_e64 -4.0, v2
// GFX10: encoding: [0x00,0x00,0x1e,0xd4,0xf7,0x04,0x02,0x00]

v_cmpx_nlt_f32_e64 v1, v255
// GFX10: encoding: [0x00,0x00,0x1e,0xd4,0x01,0xff,0x03,0x00]

v_cmpx_nlt_f32_e64 v1, s2
// GFX10: encoding: [0x00,0x00,0x1e,0xd4,0x01,0x05,0x00,0x00]

v_cmpx_nlt_f32_e64 v1, s101
// GFX10: encoding: [0x00,0x00,0x1e,0xd4,0x01,0xcb,0x00,0x00]

v_cmpx_nlt_f32_e64 v1, vcc_lo
// GFX10: encoding: [0x00,0x00,0x1e,0xd4,0x01,0xd5,0x00,0x00]

v_cmpx_nlt_f32_e64 v1, vcc_hi
// GFX10: encoding: [0x00,0x00,0x1e,0xd4,0x01,0xd7,0x00,0x00]

v_cmpx_nlt_f32_e64 v1, m0
// GFX10: encoding: [0x00,0x00,0x1e,0xd4,0x01,0xf9,0x00,0x00]

v_cmpx_nlt_f32_e64 v1, exec_lo
// GFX10: encoding: [0x00,0x00,0x1e,0xd4,0x01,0xfd,0x00,0x00]

v_cmpx_nlt_f32_e64 v1, exec_hi
// GFX10: encoding: [0x00,0x00,0x1e,0xd4,0x01,0xff,0x00,0x00]

v_cmpx_nlt_f32_e64 v1, 0
// GFX10: encoding: [0x00,0x00,0x1e,0xd4,0x01,0x01,0x01,0x00]

v_cmpx_nlt_f32_e64 v1, -1
// GFX10: encoding: [0x00,0x00,0x1e,0xd4,0x01,0x83,0x01,0x00]

v_cmpx_nlt_f32_e64 v1, 0.5
// GFX10: encoding: [0x00,0x00,0x1e,0xd4,0x01,0xe1,0x01,0x00]

v_cmpx_nlt_f32_e64 v1, -4.0
// GFX10: encoding: [0x00,0x00,0x1e,0xd4,0x01,0xef,0x01,0x00]

v_cmpx_nlt_f32_e64 -v1, v2
// GFX10: encoding: [0x00,0x00,0x1e,0xd4,0x01,0x05,0x02,0x20]

v_cmpx_nlt_f32_e64 v1, -v2
// GFX10: encoding: [0x00,0x00,0x1e,0xd4,0x01,0x05,0x02,0x40]

v_cmpx_nlt_f32_e64 -v1, -v2
// GFX10: encoding: [0x00,0x00,0x1e,0xd4,0x01,0x05,0x02,0x60]

v_cmpx_tru_f32 v1, v2
// GFX10: encoding: [0x01,0x05,0x3e,0x7c]

v_cmpx_tru_f32 v255, v2
// GFX10: encoding: [0xff,0x05,0x3e,0x7c]

v_cmpx_tru_f32 s1, v2
// GFX10: encoding: [0x01,0x04,0x3e,0x7c]

v_cmpx_tru_f32 s101, v2
// GFX10: encoding: [0x65,0x04,0x3e,0x7c]

v_cmpx_tru_f32 vcc_lo, v2
// GFX10: encoding: [0x6a,0x04,0x3e,0x7c]

v_cmpx_tru_f32 vcc_hi, v2
// GFX10: encoding: [0x6b,0x04,0x3e,0x7c]

v_cmpx_tru_f32 m0, v2
// GFX10: encoding: [0x7c,0x04,0x3e,0x7c]

v_cmpx_tru_f32 exec_lo, v2
// GFX10: encoding: [0x7e,0x04,0x3e,0x7c]

v_cmpx_tru_f32 exec_hi, v2
// GFX10: encoding: [0x7f,0x04,0x3e,0x7c]

v_cmpx_tru_f32 0, v2
// GFX10: encoding: [0x80,0x04,0x3e,0x7c]

v_cmpx_tru_f32 -1, v2
// GFX10: encoding: [0xc1,0x04,0x3e,0x7c]

v_cmpx_tru_f32 0.5, v2
// GFX10: encoding: [0xf0,0x04,0x3e,0x7c]

v_cmpx_tru_f32 -4.0, v2
// GFX10: encoding: [0xf7,0x04,0x3e,0x7c]

v_cmpx_tru_f32 0xaf123456, v2
// GFX10: encoding: [0xff,0x04,0x3e,0x7c,0x56,0x34,0x12,0xaf]

v_cmpx_tru_f32 0x3f717273, v2
// GFX10: encoding: [0xff,0x04,0x3e,0x7c,0x73,0x72,0x71,0x3f]

v_cmpx_tru_f32 v1, v255
// GFX10: encoding: [0x01,0xff,0x3f,0x7c]

v_cmpx_tru_f32_e64 v1, v2
// GFX10: encoding: [0x00,0x00,0x1f,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_tru_f32_e64 v255, v2
// GFX10: encoding: [0x00,0x00,0x1f,0xd4,0xff,0x05,0x02,0x00]

v_cmpx_tru_f32_e64 s1, v2
// GFX10: encoding: [0x00,0x00,0x1f,0xd4,0x01,0x04,0x02,0x00]

v_cmpx_tru_f32_e64 s101, v2
// GFX10: encoding: [0x00,0x00,0x1f,0xd4,0x65,0x04,0x02,0x00]

v_cmpx_tru_f32_e64 vcc_lo, v2
// GFX10: encoding: [0x00,0x00,0x1f,0xd4,0x6a,0x04,0x02,0x00]

v_cmpx_tru_f32_e64 vcc_hi, v2
// GFX10: encoding: [0x00,0x00,0x1f,0xd4,0x6b,0x04,0x02,0x00]

v_cmpx_tru_f32_e64 m0, v2
// GFX10: encoding: [0x00,0x00,0x1f,0xd4,0x7c,0x04,0x02,0x00]

v_cmpx_tru_f32_e64 exec_lo, v2
// GFX10: encoding: [0x00,0x00,0x1f,0xd4,0x7e,0x04,0x02,0x00]

v_cmpx_tru_f32_e64 exec_hi, v2
// GFX10: encoding: [0x00,0x00,0x1f,0xd4,0x7f,0x04,0x02,0x00]

v_cmpx_tru_f32_e64 0, v2
// GFX10: encoding: [0x00,0x00,0x1f,0xd4,0x80,0x04,0x02,0x00]

v_cmpx_tru_f32_e64 -1, v2
// GFX10: encoding: [0x00,0x00,0x1f,0xd4,0xc1,0x04,0x02,0x00]

v_cmpx_tru_f32_e64 0.5, v2
// GFX10: encoding: [0x00,0x00,0x1f,0xd4,0xf0,0x04,0x02,0x00]

v_cmpx_tru_f32_e64 -4.0, v2
// GFX10: encoding: [0x00,0x00,0x1f,0xd4,0xf7,0x04,0x02,0x00]

v_cmpx_tru_f32_e64 v1, v255
// GFX10: encoding: [0x00,0x00,0x1f,0xd4,0x01,0xff,0x03,0x00]

v_cmpx_tru_f32_e64 v1, s2
// GFX10: encoding: [0x00,0x00,0x1f,0xd4,0x01,0x05,0x00,0x00]

v_cmpx_tru_f32_e64 v1, s101
// GFX10: encoding: [0x00,0x00,0x1f,0xd4,0x01,0xcb,0x00,0x00]

v_cmpx_tru_f32_e64 v1, vcc_lo
// GFX10: encoding: [0x00,0x00,0x1f,0xd4,0x01,0xd5,0x00,0x00]

v_cmpx_tru_f32_e64 v1, vcc_hi
// GFX10: encoding: [0x00,0x00,0x1f,0xd4,0x01,0xd7,0x00,0x00]

v_cmpx_tru_f32_e64 v1, m0
// GFX10: encoding: [0x00,0x00,0x1f,0xd4,0x01,0xf9,0x00,0x00]

v_cmpx_tru_f32_e64 v1, exec_lo
// GFX10: encoding: [0x00,0x00,0x1f,0xd4,0x01,0xfd,0x00,0x00]

v_cmpx_tru_f32_e64 v1, exec_hi
// GFX10: encoding: [0x00,0x00,0x1f,0xd4,0x01,0xff,0x00,0x00]

v_cmpx_tru_f32_e64 v1, 0
// GFX10: encoding: [0x00,0x00,0x1f,0xd4,0x01,0x01,0x01,0x00]

v_cmpx_tru_f32_e64 v1, -1
// GFX10: encoding: [0x00,0x00,0x1f,0xd4,0x01,0x83,0x01,0x00]

v_cmpx_tru_f32_e64 v1, 0.5
// GFX10: encoding: [0x00,0x00,0x1f,0xd4,0x01,0xe1,0x01,0x00]

v_cmpx_tru_f32_e64 v1, -4.0
// GFX10: encoding: [0x00,0x00,0x1f,0xd4,0x01,0xef,0x01,0x00]

v_cmpx_tru_f32_e64 -v1, v2
// GFX10: encoding: [0x00,0x00,0x1f,0xd4,0x01,0x05,0x02,0x20]

v_cmpx_tru_f32_e64 v1, -v2
// GFX10: encoding: [0x00,0x00,0x1f,0xd4,0x01,0x05,0x02,0x40]

v_cmpx_tru_f32_e64 -v1, -v2
// GFX10: encoding: [0x00,0x00,0x1f,0xd4,0x01,0x05,0x02,0x60]

v_cmpx_f_f32_sdwa v1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x20,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_f_f32_sdwa v255, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x20,0x7c,0xff,0x00,0x06,0x06]

v_cmpx_f_f32_sdwa s1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x20,0x7c,0x01,0x00,0x86,0x06]

v_cmpx_f_f32_sdwa s101, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x20,0x7c,0x65,0x00,0x86,0x06]

v_cmpx_f_f32_sdwa vcc_lo, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x20,0x7c,0x6a,0x00,0x86,0x06]

v_cmpx_f_f32_sdwa vcc_hi, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x20,0x7c,0x6b,0x00,0x86,0x06]

v_cmpx_f_f32_sdwa m0, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x20,0x7c,0x7c,0x00,0x86,0x06]

v_cmpx_f_f32_sdwa exec_lo, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x20,0x7c,0x7e,0x00,0x86,0x06]

v_cmpx_f_f32_sdwa exec_hi, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x20,0x7c,0x7f,0x00,0x86,0x06]

v_cmpx_f_f32_sdwa v1, v255 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0xfe,0x21,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_f_f32_sdwa v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x20,0x7c,0x01,0x00,0x00,0x06]

v_cmpx_f_f32_sdwa v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x20,0x7c,0x01,0x00,0x01,0x06]

v_cmpx_f_f32_sdwa v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x20,0x7c,0x01,0x00,0x02,0x06]

v_cmpx_f_f32_sdwa v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x20,0x7c,0x01,0x00,0x03,0x06]

v_cmpx_f_f32_sdwa v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x20,0x7c,0x01,0x00,0x04,0x06]

v_cmpx_f_f32_sdwa v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x20,0x7c,0x01,0x00,0x05,0x06]

v_cmpx_f_f32_sdwa -v1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x20,0x7c,0x01,0x00,0x16,0x06]

v_cmpx_f_f32_sdwa |v1|, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x20,0x7c,0x01,0x00,0x26,0x06]

v_cmpx_f_f32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// GFX10: encoding: [0xf9,0x04,0x20,0x7c,0x01,0x00,0x06,0x00]

v_cmpx_f_f32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// GFX10: encoding: [0xf9,0x04,0x20,0x7c,0x01,0x00,0x06,0x01]

v_cmpx_f_f32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// GFX10: encoding: [0xf9,0x04,0x20,0x7c,0x01,0x00,0x06,0x02]

v_cmpx_f_f32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// GFX10: encoding: [0xf9,0x04,0x20,0x7c,0x01,0x00,0x06,0x03]

v_cmpx_f_f32_sdwa v1, v2 src0_sel:DWORD src1_sel:WORD_0
// GFX10: encoding: [0xf9,0x04,0x20,0x7c,0x01,0x00,0x06,0x04]

v_cmpx_f_f32_sdwa v1, v2 src0_sel:DWORD src1_sel:WORD_1
// GFX10: encoding: [0xf9,0x04,0x20,0x7c,0x01,0x00,0x06,0x05]

v_cmpx_f_f32_sdwa v1, -v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x20,0x7c,0x01,0x00,0x06,0x16]

v_cmpx_f_f32_sdwa v1, |v2| src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x20,0x7c,0x01,0x00,0x06,0x26]

v_cmpx_lt_f32_sdwa v1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x22,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_lt_f32_sdwa v255, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x22,0x7c,0xff,0x00,0x06,0x06]

v_cmpx_lt_f32_sdwa s1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x22,0x7c,0x01,0x00,0x86,0x06]

v_cmpx_lt_f32_sdwa s101, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x22,0x7c,0x65,0x00,0x86,0x06]

v_cmpx_lt_f32_sdwa vcc_lo, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x22,0x7c,0x6a,0x00,0x86,0x06]

v_cmpx_lt_f32_sdwa vcc_hi, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x22,0x7c,0x6b,0x00,0x86,0x06]

v_cmpx_lt_f32_sdwa m0, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x22,0x7c,0x7c,0x00,0x86,0x06]

v_cmpx_lt_f32_sdwa exec_lo, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x22,0x7c,0x7e,0x00,0x86,0x06]

v_cmpx_lt_f32_sdwa exec_hi, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x22,0x7c,0x7f,0x00,0x86,0x06]

v_cmpx_lt_f32_sdwa v1, v255 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0xfe,0x23,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_lt_f32_sdwa v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x22,0x7c,0x01,0x00,0x00,0x06]

v_cmpx_lt_f32_sdwa v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x22,0x7c,0x01,0x00,0x01,0x06]

v_cmpx_lt_f32_sdwa v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x22,0x7c,0x01,0x00,0x02,0x06]

v_cmpx_lt_f32_sdwa v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x22,0x7c,0x01,0x00,0x03,0x06]

v_cmpx_lt_f32_sdwa v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x22,0x7c,0x01,0x00,0x04,0x06]

v_cmpx_lt_f32_sdwa v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x22,0x7c,0x01,0x00,0x05,0x06]

v_cmpx_lt_f32_sdwa -v1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x22,0x7c,0x01,0x00,0x16,0x06]

v_cmpx_lt_f32_sdwa |v1|, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x22,0x7c,0x01,0x00,0x26,0x06]

v_cmpx_lt_f32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// GFX10: encoding: [0xf9,0x04,0x22,0x7c,0x01,0x00,0x06,0x00]

v_cmpx_lt_f32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// GFX10: encoding: [0xf9,0x04,0x22,0x7c,0x01,0x00,0x06,0x01]

v_cmpx_lt_f32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// GFX10: encoding: [0xf9,0x04,0x22,0x7c,0x01,0x00,0x06,0x02]

v_cmpx_lt_f32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// GFX10: encoding: [0xf9,0x04,0x22,0x7c,0x01,0x00,0x06,0x03]

v_cmpx_lt_f32_sdwa v1, v2 src0_sel:DWORD src1_sel:WORD_0
// GFX10: encoding: [0xf9,0x04,0x22,0x7c,0x01,0x00,0x06,0x04]

v_cmpx_lt_f32_sdwa v1, v2 src0_sel:DWORD src1_sel:WORD_1
// GFX10: encoding: [0xf9,0x04,0x22,0x7c,0x01,0x00,0x06,0x05]

v_cmpx_lt_f32_sdwa v1, -v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x22,0x7c,0x01,0x00,0x06,0x16]

v_cmpx_lt_f32_sdwa v1, |v2| src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x22,0x7c,0x01,0x00,0x06,0x26]

v_cmpx_eq_f32_sdwa v1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x24,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_eq_f32_sdwa v255, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x24,0x7c,0xff,0x00,0x06,0x06]

v_cmpx_eq_f32_sdwa s1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x24,0x7c,0x01,0x00,0x86,0x06]

v_cmpx_eq_f32_sdwa s101, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x24,0x7c,0x65,0x00,0x86,0x06]

v_cmpx_eq_f32_sdwa vcc_lo, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x24,0x7c,0x6a,0x00,0x86,0x06]

v_cmpx_eq_f32_sdwa vcc_hi, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x24,0x7c,0x6b,0x00,0x86,0x06]

v_cmpx_eq_f32_sdwa m0, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x24,0x7c,0x7c,0x00,0x86,0x06]

v_cmpx_eq_f32_sdwa exec_lo, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x24,0x7c,0x7e,0x00,0x86,0x06]

v_cmpx_eq_f32_sdwa exec_hi, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x24,0x7c,0x7f,0x00,0x86,0x06]

v_cmpx_eq_f32_sdwa v1, v255 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0xfe,0x25,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_eq_f32_sdwa v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x24,0x7c,0x01,0x00,0x00,0x06]

v_cmpx_eq_f32_sdwa v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x24,0x7c,0x01,0x00,0x01,0x06]

v_cmpx_eq_f32_sdwa v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x24,0x7c,0x01,0x00,0x02,0x06]

v_cmpx_eq_f32_sdwa v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x24,0x7c,0x01,0x00,0x03,0x06]

v_cmpx_eq_f32_sdwa v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x24,0x7c,0x01,0x00,0x04,0x06]

v_cmpx_eq_f32_sdwa v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x24,0x7c,0x01,0x00,0x05,0x06]

v_cmpx_eq_f32_sdwa -v1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x24,0x7c,0x01,0x00,0x16,0x06]

v_cmpx_eq_f32_sdwa |v1|, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x24,0x7c,0x01,0x00,0x26,0x06]

v_cmpx_eq_f32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// GFX10: encoding: [0xf9,0x04,0x24,0x7c,0x01,0x00,0x06,0x00]

v_cmpx_eq_f32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// GFX10: encoding: [0xf9,0x04,0x24,0x7c,0x01,0x00,0x06,0x01]

v_cmpx_eq_f32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// GFX10: encoding: [0xf9,0x04,0x24,0x7c,0x01,0x00,0x06,0x02]

v_cmpx_eq_f32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// GFX10: encoding: [0xf9,0x04,0x24,0x7c,0x01,0x00,0x06,0x03]

v_cmpx_eq_f32_sdwa v1, v2 src0_sel:DWORD src1_sel:WORD_0
// GFX10: encoding: [0xf9,0x04,0x24,0x7c,0x01,0x00,0x06,0x04]

v_cmpx_eq_f32_sdwa v1, v2 src0_sel:DWORD src1_sel:WORD_1
// GFX10: encoding: [0xf9,0x04,0x24,0x7c,0x01,0x00,0x06,0x05]

v_cmpx_eq_f32_sdwa v1, -v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x24,0x7c,0x01,0x00,0x06,0x16]

v_cmpx_eq_f32_sdwa v1, |v2| src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x24,0x7c,0x01,0x00,0x06,0x26]

v_cmpx_le_f32_sdwa v1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x26,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_le_f32_sdwa v255, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x26,0x7c,0xff,0x00,0x06,0x06]

v_cmpx_le_f32_sdwa s1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x26,0x7c,0x01,0x00,0x86,0x06]

v_cmpx_le_f32_sdwa s101, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x26,0x7c,0x65,0x00,0x86,0x06]

v_cmpx_le_f32_sdwa vcc_lo, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x26,0x7c,0x6a,0x00,0x86,0x06]

v_cmpx_le_f32_sdwa vcc_hi, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x26,0x7c,0x6b,0x00,0x86,0x06]

v_cmpx_le_f32_sdwa m0, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x26,0x7c,0x7c,0x00,0x86,0x06]

v_cmpx_le_f32_sdwa exec_lo, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x26,0x7c,0x7e,0x00,0x86,0x06]

v_cmpx_le_f32_sdwa exec_hi, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x26,0x7c,0x7f,0x00,0x86,0x06]

v_cmpx_le_f32_sdwa v1, v255 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0xfe,0x27,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_le_f32_sdwa v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x26,0x7c,0x01,0x00,0x00,0x06]

v_cmpx_le_f32_sdwa v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x26,0x7c,0x01,0x00,0x01,0x06]

v_cmpx_le_f32_sdwa v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x26,0x7c,0x01,0x00,0x02,0x06]

v_cmpx_le_f32_sdwa v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x26,0x7c,0x01,0x00,0x03,0x06]

v_cmpx_le_f32_sdwa v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x26,0x7c,0x01,0x00,0x04,0x06]

v_cmpx_le_f32_sdwa v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x26,0x7c,0x01,0x00,0x05,0x06]

v_cmpx_le_f32_sdwa -v1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x26,0x7c,0x01,0x00,0x16,0x06]

v_cmpx_le_f32_sdwa |v1|, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x26,0x7c,0x01,0x00,0x26,0x06]

v_cmpx_le_f32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// GFX10: encoding: [0xf9,0x04,0x26,0x7c,0x01,0x00,0x06,0x00]

v_cmpx_le_f32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// GFX10: encoding: [0xf9,0x04,0x26,0x7c,0x01,0x00,0x06,0x01]

v_cmpx_le_f32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// GFX10: encoding: [0xf9,0x04,0x26,0x7c,0x01,0x00,0x06,0x02]

v_cmpx_le_f32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// GFX10: encoding: [0xf9,0x04,0x26,0x7c,0x01,0x00,0x06,0x03]

v_cmpx_le_f32_sdwa v1, v2 src0_sel:DWORD src1_sel:WORD_0
// GFX10: encoding: [0xf9,0x04,0x26,0x7c,0x01,0x00,0x06,0x04]

v_cmpx_le_f32_sdwa v1, v2 src0_sel:DWORD src1_sel:WORD_1
// GFX10: encoding: [0xf9,0x04,0x26,0x7c,0x01,0x00,0x06,0x05]

v_cmpx_le_f32_sdwa v1, -v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x26,0x7c,0x01,0x00,0x06,0x16]

v_cmpx_le_f32_sdwa v1, |v2| src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x26,0x7c,0x01,0x00,0x06,0x26]

v_cmpx_gt_f32_sdwa v1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x28,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_gt_f32_sdwa v255, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x28,0x7c,0xff,0x00,0x06,0x06]

v_cmpx_gt_f32_sdwa s1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x28,0x7c,0x01,0x00,0x86,0x06]

v_cmpx_gt_f32_sdwa s101, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x28,0x7c,0x65,0x00,0x86,0x06]

v_cmpx_gt_f32_sdwa vcc_lo, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x28,0x7c,0x6a,0x00,0x86,0x06]

v_cmpx_gt_f32_sdwa vcc_hi, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x28,0x7c,0x6b,0x00,0x86,0x06]

v_cmpx_gt_f32_sdwa m0, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x28,0x7c,0x7c,0x00,0x86,0x06]

v_cmpx_gt_f32_sdwa exec_lo, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x28,0x7c,0x7e,0x00,0x86,0x06]

v_cmpx_gt_f32_sdwa exec_hi, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x28,0x7c,0x7f,0x00,0x86,0x06]

v_cmpx_gt_f32_sdwa v1, v255 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0xfe,0x29,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_gt_f32_sdwa v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x28,0x7c,0x01,0x00,0x00,0x06]

v_cmpx_gt_f32_sdwa v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x28,0x7c,0x01,0x00,0x01,0x06]

v_cmpx_gt_f32_sdwa v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x28,0x7c,0x01,0x00,0x02,0x06]

v_cmpx_gt_f32_sdwa v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x28,0x7c,0x01,0x00,0x03,0x06]

v_cmpx_gt_f32_sdwa v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x28,0x7c,0x01,0x00,0x04,0x06]

v_cmpx_gt_f32_sdwa v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x28,0x7c,0x01,0x00,0x05,0x06]

v_cmpx_gt_f32_sdwa -v1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x28,0x7c,0x01,0x00,0x16,0x06]

v_cmpx_gt_f32_sdwa |v1|, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x28,0x7c,0x01,0x00,0x26,0x06]

v_cmpx_gt_f32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// GFX10: encoding: [0xf9,0x04,0x28,0x7c,0x01,0x00,0x06,0x00]

v_cmpx_gt_f32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// GFX10: encoding: [0xf9,0x04,0x28,0x7c,0x01,0x00,0x06,0x01]

v_cmpx_gt_f32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// GFX10: encoding: [0xf9,0x04,0x28,0x7c,0x01,0x00,0x06,0x02]

v_cmpx_gt_f32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// GFX10: encoding: [0xf9,0x04,0x28,0x7c,0x01,0x00,0x06,0x03]

v_cmpx_gt_f32_sdwa v1, v2 src0_sel:DWORD src1_sel:WORD_0
// GFX10: encoding: [0xf9,0x04,0x28,0x7c,0x01,0x00,0x06,0x04]

v_cmpx_gt_f32_sdwa v1, v2 src0_sel:DWORD src1_sel:WORD_1
// GFX10: encoding: [0xf9,0x04,0x28,0x7c,0x01,0x00,0x06,0x05]

v_cmpx_gt_f32_sdwa v1, -v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x28,0x7c,0x01,0x00,0x06,0x16]

v_cmpx_gt_f32_sdwa v1, |v2| src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x28,0x7c,0x01,0x00,0x06,0x26]

v_cmpx_lg_f32_sdwa v1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x2a,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_lg_f32_sdwa v255, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x2a,0x7c,0xff,0x00,0x06,0x06]

v_cmpx_lg_f32_sdwa s1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x2a,0x7c,0x01,0x00,0x86,0x06]

v_cmpx_lg_f32_sdwa s101, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x2a,0x7c,0x65,0x00,0x86,0x06]

v_cmpx_lg_f32_sdwa vcc_lo, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x2a,0x7c,0x6a,0x00,0x86,0x06]

v_cmpx_lg_f32_sdwa vcc_hi, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x2a,0x7c,0x6b,0x00,0x86,0x06]

v_cmpx_lg_f32_sdwa m0, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x2a,0x7c,0x7c,0x00,0x86,0x06]

v_cmpx_lg_f32_sdwa exec_lo, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x2a,0x7c,0x7e,0x00,0x86,0x06]

v_cmpx_lg_f32_sdwa exec_hi, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x2a,0x7c,0x7f,0x00,0x86,0x06]

v_cmpx_lg_f32_sdwa v1, v255 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0xfe,0x2b,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_lg_f32_sdwa v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x2a,0x7c,0x01,0x00,0x00,0x06]

v_cmpx_lg_f32_sdwa v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x2a,0x7c,0x01,0x00,0x01,0x06]

v_cmpx_lg_f32_sdwa v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x2a,0x7c,0x01,0x00,0x02,0x06]

v_cmpx_lg_f32_sdwa v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x2a,0x7c,0x01,0x00,0x03,0x06]

v_cmpx_lg_f32_sdwa v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x2a,0x7c,0x01,0x00,0x04,0x06]

v_cmpx_lg_f32_sdwa v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x2a,0x7c,0x01,0x00,0x05,0x06]

v_cmpx_lg_f32_sdwa -v1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x2a,0x7c,0x01,0x00,0x16,0x06]

v_cmpx_lg_f32_sdwa |v1|, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x2a,0x7c,0x01,0x00,0x26,0x06]

v_cmpx_lg_f32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// GFX10: encoding: [0xf9,0x04,0x2a,0x7c,0x01,0x00,0x06,0x00]

v_cmpx_lg_f32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// GFX10: encoding: [0xf9,0x04,0x2a,0x7c,0x01,0x00,0x06,0x01]

v_cmpx_lg_f32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// GFX10: encoding: [0xf9,0x04,0x2a,0x7c,0x01,0x00,0x06,0x02]

v_cmpx_lg_f32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// GFX10: encoding: [0xf9,0x04,0x2a,0x7c,0x01,0x00,0x06,0x03]

v_cmpx_lg_f32_sdwa v1, v2 src0_sel:DWORD src1_sel:WORD_0
// GFX10: encoding: [0xf9,0x04,0x2a,0x7c,0x01,0x00,0x06,0x04]

v_cmpx_lg_f32_sdwa v1, v2 src0_sel:DWORD src1_sel:WORD_1
// GFX10: encoding: [0xf9,0x04,0x2a,0x7c,0x01,0x00,0x06,0x05]

v_cmpx_lg_f32_sdwa v1, -v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x2a,0x7c,0x01,0x00,0x06,0x16]

v_cmpx_lg_f32_sdwa v1, |v2| src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x2a,0x7c,0x01,0x00,0x06,0x26]

v_cmpx_ge_f32_sdwa v1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x2c,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_ge_f32_sdwa v255, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x2c,0x7c,0xff,0x00,0x06,0x06]

v_cmpx_ge_f32_sdwa s1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x2c,0x7c,0x01,0x00,0x86,0x06]

v_cmpx_ge_f32_sdwa s101, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x2c,0x7c,0x65,0x00,0x86,0x06]

v_cmpx_ge_f32_sdwa vcc_lo, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x2c,0x7c,0x6a,0x00,0x86,0x06]

v_cmpx_ge_f32_sdwa vcc_hi, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x2c,0x7c,0x6b,0x00,0x86,0x06]

v_cmpx_ge_f32_sdwa m0, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x2c,0x7c,0x7c,0x00,0x86,0x06]

v_cmpx_ge_f32_sdwa exec_lo, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x2c,0x7c,0x7e,0x00,0x86,0x06]

v_cmpx_ge_f32_sdwa exec_hi, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x2c,0x7c,0x7f,0x00,0x86,0x06]

v_cmpx_ge_f32_sdwa v1, v255 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0xfe,0x2d,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_ge_f32_sdwa v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x2c,0x7c,0x01,0x00,0x00,0x06]

v_cmpx_ge_f32_sdwa v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x2c,0x7c,0x01,0x00,0x01,0x06]

v_cmpx_ge_f32_sdwa v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x2c,0x7c,0x01,0x00,0x02,0x06]

v_cmpx_ge_f32_sdwa v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x2c,0x7c,0x01,0x00,0x03,0x06]

v_cmpx_ge_f32_sdwa v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x2c,0x7c,0x01,0x00,0x04,0x06]

v_cmpx_ge_f32_sdwa v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x2c,0x7c,0x01,0x00,0x05,0x06]

v_cmpx_ge_f32_sdwa -v1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x2c,0x7c,0x01,0x00,0x16,0x06]

v_cmpx_ge_f32_sdwa |v1|, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x2c,0x7c,0x01,0x00,0x26,0x06]

v_cmpx_ge_f32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// GFX10: encoding: [0xf9,0x04,0x2c,0x7c,0x01,0x00,0x06,0x00]

v_cmpx_ge_f32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// GFX10: encoding: [0xf9,0x04,0x2c,0x7c,0x01,0x00,0x06,0x01]

v_cmpx_ge_f32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// GFX10: encoding: [0xf9,0x04,0x2c,0x7c,0x01,0x00,0x06,0x02]

v_cmpx_ge_f32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// GFX10: encoding: [0xf9,0x04,0x2c,0x7c,0x01,0x00,0x06,0x03]

v_cmpx_ge_f32_sdwa v1, v2 src0_sel:DWORD src1_sel:WORD_0
// GFX10: encoding: [0xf9,0x04,0x2c,0x7c,0x01,0x00,0x06,0x04]

v_cmpx_ge_f32_sdwa v1, v2 src0_sel:DWORD src1_sel:WORD_1
// GFX10: encoding: [0xf9,0x04,0x2c,0x7c,0x01,0x00,0x06,0x05]

v_cmpx_ge_f32_sdwa v1, -v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x2c,0x7c,0x01,0x00,0x06,0x16]

v_cmpx_ge_f32_sdwa v1, |v2| src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x2c,0x7c,0x01,0x00,0x06,0x26]

v_cmpx_o_f32_sdwa v1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x2e,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_o_f32_sdwa v255, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x2e,0x7c,0xff,0x00,0x06,0x06]

v_cmpx_o_f32_sdwa s1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x2e,0x7c,0x01,0x00,0x86,0x06]

v_cmpx_o_f32_sdwa s101, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x2e,0x7c,0x65,0x00,0x86,0x06]

v_cmpx_o_f32_sdwa vcc_lo, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x2e,0x7c,0x6a,0x00,0x86,0x06]

v_cmpx_o_f32_sdwa vcc_hi, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x2e,0x7c,0x6b,0x00,0x86,0x06]

v_cmpx_o_f32_sdwa m0, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x2e,0x7c,0x7c,0x00,0x86,0x06]

v_cmpx_o_f32_sdwa exec_lo, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x2e,0x7c,0x7e,0x00,0x86,0x06]

v_cmpx_o_f32_sdwa exec_hi, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x2e,0x7c,0x7f,0x00,0x86,0x06]

v_cmpx_o_f32_sdwa v1, v255 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0xfe,0x2f,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_o_f32_sdwa v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x2e,0x7c,0x01,0x00,0x00,0x06]

v_cmpx_o_f32_sdwa v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x2e,0x7c,0x01,0x00,0x01,0x06]

v_cmpx_o_f32_sdwa v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x2e,0x7c,0x01,0x00,0x02,0x06]

v_cmpx_o_f32_sdwa v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x2e,0x7c,0x01,0x00,0x03,0x06]

v_cmpx_o_f32_sdwa v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x2e,0x7c,0x01,0x00,0x04,0x06]

v_cmpx_o_f32_sdwa v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x2e,0x7c,0x01,0x00,0x05,0x06]

v_cmpx_o_f32_sdwa -v1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x2e,0x7c,0x01,0x00,0x16,0x06]

v_cmpx_o_f32_sdwa |v1|, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x2e,0x7c,0x01,0x00,0x26,0x06]

v_cmpx_o_f32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// GFX10: encoding: [0xf9,0x04,0x2e,0x7c,0x01,0x00,0x06,0x00]

v_cmpx_o_f32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// GFX10: encoding: [0xf9,0x04,0x2e,0x7c,0x01,0x00,0x06,0x01]

v_cmpx_o_f32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// GFX10: encoding: [0xf9,0x04,0x2e,0x7c,0x01,0x00,0x06,0x02]

v_cmpx_o_f32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// GFX10: encoding: [0xf9,0x04,0x2e,0x7c,0x01,0x00,0x06,0x03]

v_cmpx_o_f32_sdwa v1, v2 src0_sel:DWORD src1_sel:WORD_0
// GFX10: encoding: [0xf9,0x04,0x2e,0x7c,0x01,0x00,0x06,0x04]

v_cmpx_o_f32_sdwa v1, v2 src0_sel:DWORD src1_sel:WORD_1
// GFX10: encoding: [0xf9,0x04,0x2e,0x7c,0x01,0x00,0x06,0x05]

v_cmpx_o_f32_sdwa v1, -v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x2e,0x7c,0x01,0x00,0x06,0x16]

v_cmpx_o_f32_sdwa v1, |v2| src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x2e,0x7c,0x01,0x00,0x06,0x26]

v_cmpx_u_f32_sdwa v1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x30,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_u_f32_sdwa v255, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x30,0x7c,0xff,0x00,0x06,0x06]

v_cmpx_u_f32_sdwa s1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x30,0x7c,0x01,0x00,0x86,0x06]

v_cmpx_u_f32_sdwa s101, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x30,0x7c,0x65,0x00,0x86,0x06]

v_cmpx_u_f32_sdwa vcc_lo, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x30,0x7c,0x6a,0x00,0x86,0x06]

v_cmpx_u_f32_sdwa vcc_hi, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x30,0x7c,0x6b,0x00,0x86,0x06]

v_cmpx_u_f32_sdwa m0, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x30,0x7c,0x7c,0x00,0x86,0x06]

v_cmpx_u_f32_sdwa exec_lo, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x30,0x7c,0x7e,0x00,0x86,0x06]

v_cmpx_u_f32_sdwa exec_hi, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x30,0x7c,0x7f,0x00,0x86,0x06]

v_cmpx_u_f32_sdwa v1, v255 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0xfe,0x31,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_u_f32_sdwa v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x30,0x7c,0x01,0x00,0x00,0x06]

v_cmpx_u_f32_sdwa v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x30,0x7c,0x01,0x00,0x01,0x06]

v_cmpx_u_f32_sdwa v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x30,0x7c,0x01,0x00,0x02,0x06]

v_cmpx_u_f32_sdwa v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x30,0x7c,0x01,0x00,0x03,0x06]

v_cmpx_u_f32_sdwa v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x30,0x7c,0x01,0x00,0x04,0x06]

v_cmpx_u_f32_sdwa v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x30,0x7c,0x01,0x00,0x05,0x06]

v_cmpx_u_f32_sdwa -v1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x30,0x7c,0x01,0x00,0x16,0x06]

v_cmpx_u_f32_sdwa |v1|, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x30,0x7c,0x01,0x00,0x26,0x06]

v_cmpx_u_f32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// GFX10: encoding: [0xf9,0x04,0x30,0x7c,0x01,0x00,0x06,0x00]

v_cmpx_u_f32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// GFX10: encoding: [0xf9,0x04,0x30,0x7c,0x01,0x00,0x06,0x01]

v_cmpx_u_f32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// GFX10: encoding: [0xf9,0x04,0x30,0x7c,0x01,0x00,0x06,0x02]

v_cmpx_u_f32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// GFX10: encoding: [0xf9,0x04,0x30,0x7c,0x01,0x00,0x06,0x03]

v_cmpx_u_f32_sdwa v1, v2 src0_sel:DWORD src1_sel:WORD_0
// GFX10: encoding: [0xf9,0x04,0x30,0x7c,0x01,0x00,0x06,0x04]

v_cmpx_u_f32_sdwa v1, v2 src0_sel:DWORD src1_sel:WORD_1
// GFX10: encoding: [0xf9,0x04,0x30,0x7c,0x01,0x00,0x06,0x05]

v_cmpx_u_f32_sdwa v1, -v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x30,0x7c,0x01,0x00,0x06,0x16]

v_cmpx_u_f32_sdwa v1, |v2| src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x30,0x7c,0x01,0x00,0x06,0x26]

v_cmpx_nge_f32_sdwa v1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x32,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_nge_f32_sdwa v255, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x32,0x7c,0xff,0x00,0x06,0x06]

v_cmpx_nge_f32_sdwa s1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x32,0x7c,0x01,0x00,0x86,0x06]

v_cmpx_nge_f32_sdwa s101, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x32,0x7c,0x65,0x00,0x86,0x06]

v_cmpx_nge_f32_sdwa vcc_lo, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x32,0x7c,0x6a,0x00,0x86,0x06]

v_cmpx_nge_f32_sdwa vcc_hi, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x32,0x7c,0x6b,0x00,0x86,0x06]

v_cmpx_nge_f32_sdwa m0, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x32,0x7c,0x7c,0x00,0x86,0x06]

v_cmpx_nge_f32_sdwa exec_lo, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x32,0x7c,0x7e,0x00,0x86,0x06]

v_cmpx_nge_f32_sdwa exec_hi, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x32,0x7c,0x7f,0x00,0x86,0x06]

v_cmpx_nge_f32_sdwa v1, v255 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0xfe,0x33,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_nge_f32_sdwa v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x32,0x7c,0x01,0x00,0x00,0x06]

v_cmpx_nge_f32_sdwa v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x32,0x7c,0x01,0x00,0x01,0x06]

v_cmpx_nge_f32_sdwa v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x32,0x7c,0x01,0x00,0x02,0x06]

v_cmpx_nge_f32_sdwa v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x32,0x7c,0x01,0x00,0x03,0x06]

v_cmpx_nge_f32_sdwa v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x32,0x7c,0x01,0x00,0x04,0x06]

v_cmpx_nge_f32_sdwa v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x32,0x7c,0x01,0x00,0x05,0x06]

v_cmpx_nge_f32_sdwa -v1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x32,0x7c,0x01,0x00,0x16,0x06]

v_cmpx_nge_f32_sdwa |v1|, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x32,0x7c,0x01,0x00,0x26,0x06]

v_cmpx_nge_f32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// GFX10: encoding: [0xf9,0x04,0x32,0x7c,0x01,0x00,0x06,0x00]

v_cmpx_nge_f32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// GFX10: encoding: [0xf9,0x04,0x32,0x7c,0x01,0x00,0x06,0x01]

v_cmpx_nge_f32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// GFX10: encoding: [0xf9,0x04,0x32,0x7c,0x01,0x00,0x06,0x02]

v_cmpx_nge_f32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// GFX10: encoding: [0xf9,0x04,0x32,0x7c,0x01,0x00,0x06,0x03]

v_cmpx_nge_f32_sdwa v1, v2 src0_sel:DWORD src1_sel:WORD_0
// GFX10: encoding: [0xf9,0x04,0x32,0x7c,0x01,0x00,0x06,0x04]

v_cmpx_nge_f32_sdwa v1, v2 src0_sel:DWORD src1_sel:WORD_1
// GFX10: encoding: [0xf9,0x04,0x32,0x7c,0x01,0x00,0x06,0x05]

v_cmpx_nge_f32_sdwa v1, -v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x32,0x7c,0x01,0x00,0x06,0x16]

v_cmpx_nge_f32_sdwa v1, |v2| src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x32,0x7c,0x01,0x00,0x06,0x26]

v_cmpx_nlg_f32_sdwa v1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x34,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_nlg_f32_sdwa v255, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x34,0x7c,0xff,0x00,0x06,0x06]

v_cmpx_nlg_f32_sdwa s1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x34,0x7c,0x01,0x00,0x86,0x06]

v_cmpx_nlg_f32_sdwa s101, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x34,0x7c,0x65,0x00,0x86,0x06]

v_cmpx_nlg_f32_sdwa vcc_lo, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x34,0x7c,0x6a,0x00,0x86,0x06]

v_cmpx_nlg_f32_sdwa vcc_hi, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x34,0x7c,0x6b,0x00,0x86,0x06]

v_cmpx_nlg_f32_sdwa m0, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x34,0x7c,0x7c,0x00,0x86,0x06]

v_cmpx_nlg_f32_sdwa exec_lo, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x34,0x7c,0x7e,0x00,0x86,0x06]

v_cmpx_nlg_f32_sdwa exec_hi, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x34,0x7c,0x7f,0x00,0x86,0x06]

v_cmpx_nlg_f32_sdwa v1, v255 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0xfe,0x35,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_nlg_f32_sdwa v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x34,0x7c,0x01,0x00,0x00,0x06]

v_cmpx_nlg_f32_sdwa v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x34,0x7c,0x01,0x00,0x01,0x06]

v_cmpx_nlg_f32_sdwa v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x34,0x7c,0x01,0x00,0x02,0x06]

v_cmpx_nlg_f32_sdwa v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x34,0x7c,0x01,0x00,0x03,0x06]

v_cmpx_nlg_f32_sdwa v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x34,0x7c,0x01,0x00,0x04,0x06]

v_cmpx_nlg_f32_sdwa v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x34,0x7c,0x01,0x00,0x05,0x06]

v_cmpx_nlg_f32_sdwa -v1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x34,0x7c,0x01,0x00,0x16,0x06]

v_cmpx_nlg_f32_sdwa |v1|, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x34,0x7c,0x01,0x00,0x26,0x06]

v_cmpx_nlg_f32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// GFX10: encoding: [0xf9,0x04,0x34,0x7c,0x01,0x00,0x06,0x00]

v_cmpx_nlg_f32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// GFX10: encoding: [0xf9,0x04,0x34,0x7c,0x01,0x00,0x06,0x01]

v_cmpx_nlg_f32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// GFX10: encoding: [0xf9,0x04,0x34,0x7c,0x01,0x00,0x06,0x02]

v_cmpx_nlg_f32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// GFX10: encoding: [0xf9,0x04,0x34,0x7c,0x01,0x00,0x06,0x03]

v_cmpx_nlg_f32_sdwa v1, v2 src0_sel:DWORD src1_sel:WORD_0
// GFX10: encoding: [0xf9,0x04,0x34,0x7c,0x01,0x00,0x06,0x04]

v_cmpx_nlg_f32_sdwa v1, v2 src0_sel:DWORD src1_sel:WORD_1
// GFX10: encoding: [0xf9,0x04,0x34,0x7c,0x01,0x00,0x06,0x05]

v_cmpx_nlg_f32_sdwa v1, -v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x34,0x7c,0x01,0x00,0x06,0x16]

v_cmpx_nlg_f32_sdwa v1, |v2| src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x34,0x7c,0x01,0x00,0x06,0x26]

v_cmpx_ngt_f32_sdwa v1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x36,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_ngt_f32_sdwa v255, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x36,0x7c,0xff,0x00,0x06,0x06]

v_cmpx_ngt_f32_sdwa s1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x36,0x7c,0x01,0x00,0x86,0x06]

v_cmpx_ngt_f32_sdwa s101, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x36,0x7c,0x65,0x00,0x86,0x06]

v_cmpx_ngt_f32_sdwa vcc_lo, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x36,0x7c,0x6a,0x00,0x86,0x06]

v_cmpx_ngt_f32_sdwa vcc_hi, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x36,0x7c,0x6b,0x00,0x86,0x06]

v_cmpx_ngt_f32_sdwa m0, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x36,0x7c,0x7c,0x00,0x86,0x06]

v_cmpx_ngt_f32_sdwa exec_lo, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x36,0x7c,0x7e,0x00,0x86,0x06]

v_cmpx_ngt_f32_sdwa exec_hi, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x36,0x7c,0x7f,0x00,0x86,0x06]

v_cmpx_ngt_f32_sdwa v1, v255 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0xfe,0x37,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_ngt_f32_sdwa v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x36,0x7c,0x01,0x00,0x00,0x06]

v_cmpx_ngt_f32_sdwa v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x36,0x7c,0x01,0x00,0x01,0x06]

v_cmpx_ngt_f32_sdwa v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x36,0x7c,0x01,0x00,0x02,0x06]

v_cmpx_ngt_f32_sdwa v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x36,0x7c,0x01,0x00,0x03,0x06]

v_cmpx_ngt_f32_sdwa v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x36,0x7c,0x01,0x00,0x04,0x06]

v_cmpx_ngt_f32_sdwa v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x36,0x7c,0x01,0x00,0x05,0x06]

v_cmpx_ngt_f32_sdwa -v1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x36,0x7c,0x01,0x00,0x16,0x06]

v_cmpx_ngt_f32_sdwa |v1|, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x36,0x7c,0x01,0x00,0x26,0x06]

v_cmpx_ngt_f32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// GFX10: encoding: [0xf9,0x04,0x36,0x7c,0x01,0x00,0x06,0x00]

v_cmpx_ngt_f32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// GFX10: encoding: [0xf9,0x04,0x36,0x7c,0x01,0x00,0x06,0x01]

v_cmpx_ngt_f32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// GFX10: encoding: [0xf9,0x04,0x36,0x7c,0x01,0x00,0x06,0x02]

v_cmpx_ngt_f32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// GFX10: encoding: [0xf9,0x04,0x36,0x7c,0x01,0x00,0x06,0x03]

v_cmpx_ngt_f32_sdwa v1, v2 src0_sel:DWORD src1_sel:WORD_0
// GFX10: encoding: [0xf9,0x04,0x36,0x7c,0x01,0x00,0x06,0x04]

v_cmpx_ngt_f32_sdwa v1, v2 src0_sel:DWORD src1_sel:WORD_1
// GFX10: encoding: [0xf9,0x04,0x36,0x7c,0x01,0x00,0x06,0x05]

v_cmpx_ngt_f32_sdwa v1, -v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x36,0x7c,0x01,0x00,0x06,0x16]

v_cmpx_ngt_f32_sdwa v1, |v2| src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x36,0x7c,0x01,0x00,0x06,0x26]

v_cmpx_nle_f32_sdwa v1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x38,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_nle_f32_sdwa v255, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x38,0x7c,0xff,0x00,0x06,0x06]

v_cmpx_nle_f32_sdwa s1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x38,0x7c,0x01,0x00,0x86,0x06]

v_cmpx_nle_f32_sdwa s101, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x38,0x7c,0x65,0x00,0x86,0x06]

v_cmpx_nle_f32_sdwa vcc_lo, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x38,0x7c,0x6a,0x00,0x86,0x06]

v_cmpx_nle_f32_sdwa vcc_hi, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x38,0x7c,0x6b,0x00,0x86,0x06]

v_cmpx_nle_f32_sdwa m0, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x38,0x7c,0x7c,0x00,0x86,0x06]

v_cmpx_nle_f32_sdwa exec_lo, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x38,0x7c,0x7e,0x00,0x86,0x06]

v_cmpx_nle_f32_sdwa exec_hi, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x38,0x7c,0x7f,0x00,0x86,0x06]

v_cmpx_nle_f32_sdwa v1, v255 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0xfe,0x39,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_nle_f32_sdwa v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x38,0x7c,0x01,0x00,0x00,0x06]

v_cmpx_nle_f32_sdwa v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x38,0x7c,0x01,0x00,0x01,0x06]

v_cmpx_nle_f32_sdwa v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x38,0x7c,0x01,0x00,0x02,0x06]

v_cmpx_nle_f32_sdwa v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x38,0x7c,0x01,0x00,0x03,0x06]

v_cmpx_nle_f32_sdwa v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x38,0x7c,0x01,0x00,0x04,0x06]

v_cmpx_nle_f32_sdwa v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x38,0x7c,0x01,0x00,0x05,0x06]

v_cmpx_nle_f32_sdwa -v1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x38,0x7c,0x01,0x00,0x16,0x06]

v_cmpx_nle_f32_sdwa |v1|, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x38,0x7c,0x01,0x00,0x26,0x06]

v_cmpx_nle_f32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// GFX10: encoding: [0xf9,0x04,0x38,0x7c,0x01,0x00,0x06,0x00]

v_cmpx_nle_f32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// GFX10: encoding: [0xf9,0x04,0x38,0x7c,0x01,0x00,0x06,0x01]

v_cmpx_nle_f32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// GFX10: encoding: [0xf9,0x04,0x38,0x7c,0x01,0x00,0x06,0x02]

v_cmpx_nle_f32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// GFX10: encoding: [0xf9,0x04,0x38,0x7c,0x01,0x00,0x06,0x03]

v_cmpx_nle_f32_sdwa v1, v2 src0_sel:DWORD src1_sel:WORD_0
// GFX10: encoding: [0xf9,0x04,0x38,0x7c,0x01,0x00,0x06,0x04]

v_cmpx_nle_f32_sdwa v1, v2 src0_sel:DWORD src1_sel:WORD_1
// GFX10: encoding: [0xf9,0x04,0x38,0x7c,0x01,0x00,0x06,0x05]

v_cmpx_nle_f32_sdwa v1, -v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x38,0x7c,0x01,0x00,0x06,0x16]

v_cmpx_nle_f32_sdwa v1, |v2| src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x38,0x7c,0x01,0x00,0x06,0x26]

v_cmpx_neq_f32_sdwa v1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x3a,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_neq_f32_sdwa v255, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x3a,0x7c,0xff,0x00,0x06,0x06]

v_cmpx_neq_f32_sdwa s1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x3a,0x7c,0x01,0x00,0x86,0x06]

v_cmpx_neq_f32_sdwa s101, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x3a,0x7c,0x65,0x00,0x86,0x06]

v_cmpx_neq_f32_sdwa vcc_lo, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x3a,0x7c,0x6a,0x00,0x86,0x06]

v_cmpx_neq_f32_sdwa vcc_hi, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x3a,0x7c,0x6b,0x00,0x86,0x06]

v_cmpx_neq_f32_sdwa m0, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x3a,0x7c,0x7c,0x00,0x86,0x06]

v_cmpx_neq_f32_sdwa exec_lo, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x3a,0x7c,0x7e,0x00,0x86,0x06]

v_cmpx_neq_f32_sdwa exec_hi, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x3a,0x7c,0x7f,0x00,0x86,0x06]

v_cmpx_neq_f32_sdwa v1, v255 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0xfe,0x3b,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_neq_f32_sdwa v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x3a,0x7c,0x01,0x00,0x00,0x06]

v_cmpx_neq_f32_sdwa v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x3a,0x7c,0x01,0x00,0x01,0x06]

v_cmpx_neq_f32_sdwa v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x3a,0x7c,0x01,0x00,0x02,0x06]

v_cmpx_neq_f32_sdwa v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x3a,0x7c,0x01,0x00,0x03,0x06]

v_cmpx_neq_f32_sdwa v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x3a,0x7c,0x01,0x00,0x04,0x06]

v_cmpx_neq_f32_sdwa v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x3a,0x7c,0x01,0x00,0x05,0x06]

v_cmpx_neq_f32_sdwa -v1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x3a,0x7c,0x01,0x00,0x16,0x06]

v_cmpx_neq_f32_sdwa |v1|, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x3a,0x7c,0x01,0x00,0x26,0x06]

v_cmpx_neq_f32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// GFX10: encoding: [0xf9,0x04,0x3a,0x7c,0x01,0x00,0x06,0x00]

v_cmpx_neq_f32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// GFX10: encoding: [0xf9,0x04,0x3a,0x7c,0x01,0x00,0x06,0x01]

v_cmpx_neq_f32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// GFX10: encoding: [0xf9,0x04,0x3a,0x7c,0x01,0x00,0x06,0x02]

v_cmpx_neq_f32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// GFX10: encoding: [0xf9,0x04,0x3a,0x7c,0x01,0x00,0x06,0x03]

v_cmpx_neq_f32_sdwa v1, v2 src0_sel:DWORD src1_sel:WORD_0
// GFX10: encoding: [0xf9,0x04,0x3a,0x7c,0x01,0x00,0x06,0x04]

v_cmpx_neq_f32_sdwa v1, v2 src0_sel:DWORD src1_sel:WORD_1
// GFX10: encoding: [0xf9,0x04,0x3a,0x7c,0x01,0x00,0x06,0x05]

v_cmpx_neq_f32_sdwa v1, -v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x3a,0x7c,0x01,0x00,0x06,0x16]

v_cmpx_neq_f32_sdwa v1, |v2| src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x3a,0x7c,0x01,0x00,0x06,0x26]

v_cmpx_nlt_f32_sdwa v1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x3c,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_nlt_f32_sdwa v255, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x3c,0x7c,0xff,0x00,0x06,0x06]

v_cmpx_nlt_f32_sdwa s1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x3c,0x7c,0x01,0x00,0x86,0x06]

v_cmpx_nlt_f32_sdwa s101, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x3c,0x7c,0x65,0x00,0x86,0x06]

v_cmpx_nlt_f32_sdwa vcc_lo, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x3c,0x7c,0x6a,0x00,0x86,0x06]

v_cmpx_nlt_f32_sdwa vcc_hi, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x3c,0x7c,0x6b,0x00,0x86,0x06]

v_cmpx_nlt_f32_sdwa m0, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x3c,0x7c,0x7c,0x00,0x86,0x06]

v_cmpx_nlt_f32_sdwa exec_lo, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x3c,0x7c,0x7e,0x00,0x86,0x06]

v_cmpx_nlt_f32_sdwa exec_hi, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x3c,0x7c,0x7f,0x00,0x86,0x06]

v_cmpx_nlt_f32_sdwa v1, v255 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0xfe,0x3d,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_nlt_f32_sdwa v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x3c,0x7c,0x01,0x00,0x00,0x06]

v_cmpx_nlt_f32_sdwa v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x3c,0x7c,0x01,0x00,0x01,0x06]

v_cmpx_nlt_f32_sdwa v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x3c,0x7c,0x01,0x00,0x02,0x06]

v_cmpx_nlt_f32_sdwa v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x3c,0x7c,0x01,0x00,0x03,0x06]

v_cmpx_nlt_f32_sdwa v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x3c,0x7c,0x01,0x00,0x04,0x06]

v_cmpx_nlt_f32_sdwa v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x3c,0x7c,0x01,0x00,0x05,0x06]

v_cmpx_nlt_f32_sdwa -v1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x3c,0x7c,0x01,0x00,0x16,0x06]

v_cmpx_nlt_f32_sdwa |v1|, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x3c,0x7c,0x01,0x00,0x26,0x06]

v_cmpx_nlt_f32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// GFX10: encoding: [0xf9,0x04,0x3c,0x7c,0x01,0x00,0x06,0x00]

v_cmpx_nlt_f32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// GFX10: encoding: [0xf9,0x04,0x3c,0x7c,0x01,0x00,0x06,0x01]

v_cmpx_nlt_f32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// GFX10: encoding: [0xf9,0x04,0x3c,0x7c,0x01,0x00,0x06,0x02]

v_cmpx_nlt_f32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// GFX10: encoding: [0xf9,0x04,0x3c,0x7c,0x01,0x00,0x06,0x03]

v_cmpx_nlt_f32_sdwa v1, v2 src0_sel:DWORD src1_sel:WORD_0
// GFX10: encoding: [0xf9,0x04,0x3c,0x7c,0x01,0x00,0x06,0x04]

v_cmpx_nlt_f32_sdwa v1, v2 src0_sel:DWORD src1_sel:WORD_1
// GFX10: encoding: [0xf9,0x04,0x3c,0x7c,0x01,0x00,0x06,0x05]

v_cmpx_nlt_f32_sdwa v1, -v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x3c,0x7c,0x01,0x00,0x06,0x16]

v_cmpx_nlt_f32_sdwa v1, |v2| src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x3c,0x7c,0x01,0x00,0x06,0x26]

v_cmpx_tru_f32_sdwa v1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x3e,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_tru_f32_sdwa v255, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x3e,0x7c,0xff,0x00,0x06,0x06]

v_cmpx_tru_f32_sdwa s1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x3e,0x7c,0x01,0x00,0x86,0x06]

v_cmpx_tru_f32_sdwa s101, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x3e,0x7c,0x65,0x00,0x86,0x06]

v_cmpx_tru_f32_sdwa vcc_lo, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x3e,0x7c,0x6a,0x00,0x86,0x06]

v_cmpx_tru_f32_sdwa vcc_hi, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x3e,0x7c,0x6b,0x00,0x86,0x06]

v_cmpx_tru_f32_sdwa m0, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x3e,0x7c,0x7c,0x00,0x86,0x06]

v_cmpx_tru_f32_sdwa exec_lo, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x3e,0x7c,0x7e,0x00,0x86,0x06]

v_cmpx_tru_f32_sdwa exec_hi, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x3e,0x7c,0x7f,0x00,0x86,0x06]

v_cmpx_tru_f32_sdwa v1, v255 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0xfe,0x3f,0x7c,0x01,0x00,0x06,0x06]

v_cmpx_tru_f32_sdwa v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x3e,0x7c,0x01,0x00,0x00,0x06]

v_cmpx_tru_f32_sdwa v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x3e,0x7c,0x01,0x00,0x01,0x06]

v_cmpx_tru_f32_sdwa v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x3e,0x7c,0x01,0x00,0x02,0x06]

v_cmpx_tru_f32_sdwa v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x3e,0x7c,0x01,0x00,0x03,0x06]

v_cmpx_tru_f32_sdwa v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x3e,0x7c,0x01,0x00,0x04,0x06]

v_cmpx_tru_f32_sdwa v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x3e,0x7c,0x01,0x00,0x05,0x06]

v_cmpx_tru_f32_sdwa -v1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x3e,0x7c,0x01,0x00,0x16,0x06]

v_cmpx_tru_f32_sdwa |v1|, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x3e,0x7c,0x01,0x00,0x26,0x06]

v_cmpx_tru_f32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// GFX10: encoding: [0xf9,0x04,0x3e,0x7c,0x01,0x00,0x06,0x00]

v_cmpx_tru_f32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// GFX10: encoding: [0xf9,0x04,0x3e,0x7c,0x01,0x00,0x06,0x01]

v_cmpx_tru_f32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// GFX10: encoding: [0xf9,0x04,0x3e,0x7c,0x01,0x00,0x06,0x02]

v_cmpx_tru_f32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// GFX10: encoding: [0xf9,0x04,0x3e,0x7c,0x01,0x00,0x06,0x03]

v_cmpx_tru_f32_sdwa v1, v2 src0_sel:DWORD src1_sel:WORD_0
// GFX10: encoding: [0xf9,0x04,0x3e,0x7c,0x01,0x00,0x06,0x04]

v_cmpx_tru_f32_sdwa v1, v2 src0_sel:DWORD src1_sel:WORD_1
// GFX10: encoding: [0xf9,0x04,0x3e,0x7c,0x01,0x00,0x06,0x05]

v_cmpx_tru_f32_sdwa v1, -v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x3e,0x7c,0x01,0x00,0x06,0x16]

v_cmpx_tru_f32_sdwa v1, |v2| src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x3e,0x7c,0x01,0x00,0x06,0x26]

v_cmpx_f_f64 v[1:2], v[2:3]
// GFX10: encoding: [0x01,0x05,0x60,0x7c]

v_cmpx_f_f64 v[254:255], v[2:3]
// GFX10: encoding: [0xfe,0x05,0x60,0x7c]

v_cmpx_f_f64 s[2:3], v[2:3]
// GFX10: encoding: [0x02,0x04,0x60,0x7c]

v_cmpx_f_f64 s[4:5], v[2:3]
// GFX10: encoding: [0x04,0x04,0x60,0x7c]

v_cmpx_f_f64 s[100:101], v[2:3]
// GFX10: encoding: [0x64,0x04,0x60,0x7c]

v_cmpx_f_f64 vcc, v[2:3]
// GFX10: encoding: [0x6a,0x04,0x60,0x7c]

v_cmpx_f_f64 exec, v[2:3]
// GFX10: encoding: [0x7e,0x04,0x60,0x7c]

v_cmpx_f_f64 0, v[2:3]
// GFX10: encoding: [0x80,0x04,0x60,0x7c]

v_cmpx_f_f64 -1, v[2:3]
// GFX10: encoding: [0xc1,0x04,0x60,0x7c]

v_cmpx_f_f64 0.5, v[2:3]
// GFX10: encoding: [0xf0,0x04,0x60,0x7c]

v_cmpx_f_f64 -4.0, v[2:3]
// GFX10: encoding: [0xf7,0x04,0x60,0x7c]

v_cmpx_f_f64 0xaf123456, v[2:3]
// GFX10: encoding: [0xff,0x04,0x60,0x7c,0x56,0x34,0x12,0xaf]

v_cmpx_f_f64 0x3f717273, v[2:3]
// GFX10: encoding: [0xff,0x04,0x60,0x7c,0x73,0x72,0x71,0x3f]

v_cmpx_f_f64 v[1:2], v[254:255]
// GFX10: encoding: [0x01,0xfd,0x61,0x7c]

v_cmpx_f_f64_e64 v[1:2], v[2:3]
// GFX10: encoding: [0x00,0x00,0x30,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_f_f64_e64 exec, v[1:2]
// GFX10: encoding: [0x00,0x00,0x30,0xd4,0x7e,0x02,0x02,0x00]

v_cmpx_f_f64_e64 v[254:255], v[2:3]
// GFX10: encoding: [0x00,0x00,0x30,0xd4,0xfe,0x05,0x02,0x00]

v_cmpx_f_f64_e64 s[2:3], v[2:3]
// GFX10: encoding: [0x00,0x00,0x30,0xd4,0x02,0x04,0x02,0x00]

v_cmpx_f_f64_e64 s[4:5], v[2:3]
// GFX10: encoding: [0x00,0x00,0x30,0xd4,0x04,0x04,0x02,0x00]

v_cmpx_f_f64_e64 exec, v[2:3]
// GFX10: encoding: [0x00,0x00,0x30,0xd4,0x7e,0x04,0x02,0x00]

v_cmpx_f_f64_e64 vcc, v[2:3]
// GFX10: encoding: [0x00,0x00,0x30,0xd4,0x6a,0x04,0x02,0x00]

v_cmpx_f_f64_e64 0, v[2:3]
// GFX10: encoding: [0x00,0x00,0x30,0xd4,0x80,0x04,0x02,0x00]

v_cmpx_f_f64_e64 -1, v[2:3]
// GFX10: encoding: [0x00,0x00,0x30,0xd4,0xc1,0x04,0x02,0x00]

v_cmpx_f_f64_e64 0.5, v[2:3]
// GFX10: encoding: [0x00,0x00,0x30,0xd4,0xf0,0x04,0x02,0x00]

v_cmpx_f_f64_e64 -4.0, v[2:3]
// GFX10: encoding: [0x00,0x00,0x30,0xd4,0xf7,0x04,0x02,0x00]

v_cmpx_f_f64_e64 v[1:2], v[254:255]
// GFX10: encoding: [0x00,0x00,0x30,0xd4,0x01,0xfd,0x03,0x00]

v_cmpx_f_f64_e64 v[1:2], s[4:5]
// GFX10: encoding: [0x00,0x00,0x30,0xd4,0x01,0x09,0x00,0x00]

v_cmpx_f_f64_e64 v[1:2], s[6:7]
// GFX10: encoding: [0x00,0x00,0x30,0xd4,0x01,0x0d,0x00,0x00]

v_cmpx_f_f64_e64 v[1:2], s[100:101]
// GFX10: encoding: [0x00,0x00,0x30,0xd4,0x01,0xc9,0x00,0x00]

v_cmpx_f_f64_e64 v[1:2], vcc
// GFX10: encoding: [0x00,0x00,0x30,0xd4,0x01,0xd5,0x00,0x00]

v_cmpx_f_f64_e64 v[1:2], exec
// GFX10: encoding: [0x00,0x00,0x30,0xd4,0x01,0xfd,0x00,0x00]

v_cmpx_f_f64_e64 v[1:2], 0
// GFX10: encoding: [0x00,0x00,0x30,0xd4,0x01,0x01,0x01,0x00]

v_cmpx_f_f64_e64 v[1:2], -1
// GFX10: encoding: [0x00,0x00,0x30,0xd4,0x01,0x83,0x01,0x00]

v_cmpx_f_f64_e64 v[1:2], 0.5
// GFX10: encoding: [0x00,0x00,0x30,0xd4,0x01,0xe1,0x01,0x00]

v_cmpx_f_f64_e64 v[1:2], -4.0
// GFX10: encoding: [0x00,0x00,0x30,0xd4,0x01,0xef,0x01,0x00]

v_cmpx_f_f64_e64 -v[1:2], v[2:3]
// GFX10: encoding: [0x00,0x00,0x30,0xd4,0x01,0x05,0x02,0x20]

v_cmpx_f_f64_e64 v[1:2], -v[2:3]
// GFX10: encoding: [0x00,0x00,0x30,0xd4,0x01,0x05,0x02,0x40]

v_cmpx_f_f64_e64 -v[1:2], -v[2:3]
// GFX10: encoding: [0x00,0x00,0x30,0xd4,0x01,0x05,0x02,0x60]

v_cmpx_lt_f64 v[1:2], v[2:3]
// GFX10: encoding: [0x01,0x05,0x62,0x7c]

v_cmpx_lt_f64 v[254:255], v[2:3]
// GFX10: encoding: [0xfe,0x05,0x62,0x7c]

v_cmpx_lt_f64 s[2:3], v[2:3]
// GFX10: encoding: [0x02,0x04,0x62,0x7c]

v_cmpx_lt_f64 s[4:5], v[2:3]
// GFX10: encoding: [0x04,0x04,0x62,0x7c]

v_cmpx_lt_f64 s[100:101], v[2:3]
// GFX10: encoding: [0x64,0x04,0x62,0x7c]

v_cmpx_lt_f64 vcc, v[2:3]
// GFX10: encoding: [0x6a,0x04,0x62,0x7c]

v_cmpx_lt_f64 exec, v[2:3]
// GFX10: encoding: [0x7e,0x04,0x62,0x7c]

v_cmpx_lt_f64 0, v[2:3]
// GFX10: encoding: [0x80,0x04,0x62,0x7c]

v_cmpx_lt_f64 -1, v[2:3]
// GFX10: encoding: [0xc1,0x04,0x62,0x7c]

v_cmpx_lt_f64 0.5, v[2:3]
// GFX10: encoding: [0xf0,0x04,0x62,0x7c]

v_cmpx_lt_f64 -4.0, v[2:3]
// GFX10: encoding: [0xf7,0x04,0x62,0x7c]

v_cmpx_lt_f64 0xaf123456, v[2:3]
// GFX10: encoding: [0xff,0x04,0x62,0x7c,0x56,0x34,0x12,0xaf]

v_cmpx_lt_f64 0x3f717273, v[2:3]
// GFX10: encoding: [0xff,0x04,0x62,0x7c,0x73,0x72,0x71,0x3f]

v_cmpx_lt_f64 v[1:2], v[254:255]
// GFX10: encoding: [0x01,0xfd,0x63,0x7c]

v_cmpx_lt_f64_e64 v[1:2], v[2:3]
// GFX10: encoding: [0x00,0x00,0x31,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_lt_f64_e64 v[254:255], v[2:3]
// GFX10: encoding: [0x00,0x00,0x31,0xd4,0xfe,0x05,0x02,0x00]

v_cmpx_lt_f64_e64 s[2:3], v[2:3]
// GFX10: encoding: [0x00,0x00,0x31,0xd4,0x02,0x04,0x02,0x00]

v_cmpx_lt_f64_e64 s[4:5], v[2:3]
// GFX10: encoding: [0x00,0x00,0x31,0xd4,0x04,0x04,0x02,0x00]

v_cmpx_lt_f64_e64 exec, v[2:3]
// GFX10: encoding: [0x00,0x00,0x31,0xd4,0x7e,0x04,0x02,0x00]

v_cmpx_lt_f64_e64 vcc, v[2:3]
// GFX10: encoding: [0x00,0x00,0x31,0xd4,0x6a,0x04,0x02,0x00]

v_cmpx_lt_f64_e64 0, v[2:3]
// GFX10: encoding: [0x00,0x00,0x31,0xd4,0x80,0x04,0x02,0x00]

v_cmpx_lt_f64_e64 -1, v[2:3]
// GFX10: encoding: [0x00,0x00,0x31,0xd4,0xc1,0x04,0x02,0x00]

v_cmpx_lt_f64_e64 0.5, v[2:3]
// GFX10: encoding: [0x00,0x00,0x31,0xd4,0xf0,0x04,0x02,0x00]

v_cmpx_lt_f64_e64 -4.0, v[2:3]
// GFX10: encoding: [0x00,0x00,0x31,0xd4,0xf7,0x04,0x02,0x00]

v_cmpx_lt_f64_e64 v[1:2], v[254:255]
// GFX10: encoding: [0x00,0x00,0x31,0xd4,0x01,0xfd,0x03,0x00]

v_cmpx_lt_f64_e64 v[1:2], s[4:5]
// GFX10: encoding: [0x00,0x00,0x31,0xd4,0x01,0x09,0x00,0x00]

v_cmpx_lt_f64_e64 v[1:2], s[6:7]
// GFX10: encoding: [0x00,0x00,0x31,0xd4,0x01,0x0d,0x00,0x00]

v_cmpx_lt_f64_e64 v[1:2], s[100:101]
// GFX10: encoding: [0x00,0x00,0x31,0xd4,0x01,0xc9,0x00,0x00]

v_cmpx_lt_f64_e64 v[1:2], vcc
// GFX10: encoding: [0x00,0x00,0x31,0xd4,0x01,0xd5,0x00,0x00]

v_cmpx_lt_f64_e64 v[1:2], exec
// GFX10: encoding: [0x00,0x00,0x31,0xd4,0x01,0xfd,0x00,0x00]

v_cmpx_lt_f64_e64 v[1:2], 0
// GFX10: encoding: [0x00,0x00,0x31,0xd4,0x01,0x01,0x01,0x00]

v_cmpx_lt_f64_e64 v[1:2], -1
// GFX10: encoding: [0x00,0x00,0x31,0xd4,0x01,0x83,0x01,0x00]

v_cmpx_lt_f64_e64 v[1:2], 0.5
// GFX10: encoding: [0x00,0x00,0x31,0xd4,0x01,0xe1,0x01,0x00]

v_cmpx_lt_f64_e64 v[1:2], -4.0
// GFX10: encoding: [0x00,0x00,0x31,0xd4,0x01,0xef,0x01,0x00]

v_cmpx_lt_f64_e64 -v[1:2], v[2:3]
// GFX10: encoding: [0x00,0x00,0x31,0xd4,0x01,0x05,0x02,0x20]

v_cmpx_lt_f64_e64 v[1:2], -v[2:3]
// GFX10: encoding: [0x00,0x00,0x31,0xd4,0x01,0x05,0x02,0x40]

v_cmpx_lt_f64_e64 -v[1:2], -v[2:3]
// GFX10: encoding: [0x00,0x00,0x31,0xd4,0x01,0x05,0x02,0x60]

v_cmpx_eq_f64 v[1:2], v[2:3]
// GFX10: encoding: [0x01,0x05,0x64,0x7c]

v_cmpx_eq_f64 v[254:255], v[2:3]
// GFX10: encoding: [0xfe,0x05,0x64,0x7c]

v_cmpx_eq_f64 s[2:3], v[2:3]
// GFX10: encoding: [0x02,0x04,0x64,0x7c]

v_cmpx_eq_f64 s[4:5], v[2:3]
// GFX10: encoding: [0x04,0x04,0x64,0x7c]

v_cmpx_eq_f64 s[100:101], v[2:3]
// GFX10: encoding: [0x64,0x04,0x64,0x7c]

v_cmpx_eq_f64 vcc, v[2:3]
// GFX10: encoding: [0x6a,0x04,0x64,0x7c]

v_cmpx_eq_f64 exec, v[2:3]
// GFX10: encoding: [0x7e,0x04,0x64,0x7c]

v_cmpx_eq_f64 0, v[2:3]
// GFX10: encoding: [0x80,0x04,0x64,0x7c]

v_cmpx_eq_f64 -1, v[2:3]
// GFX10: encoding: [0xc1,0x04,0x64,0x7c]

v_cmpx_eq_f64 0.5, v[2:3]
// GFX10: encoding: [0xf0,0x04,0x64,0x7c]

v_cmpx_eq_f64 -4.0, v[2:3]
// GFX10: encoding: [0xf7,0x04,0x64,0x7c]

v_cmpx_eq_f64 0xaf123456, v[2:3]
// GFX10: encoding: [0xff,0x04,0x64,0x7c,0x56,0x34,0x12,0xaf]

v_cmpx_eq_f64 0x3f717273, v[2:3]
// GFX10: encoding: [0xff,0x04,0x64,0x7c,0x73,0x72,0x71,0x3f]

v_cmpx_eq_f64 v[1:2], v[254:255]
// GFX10: encoding: [0x01,0xfd,0x65,0x7c]

v_cmpx_eq_f64_e64 v[1:2], v[2:3]
// GFX10: encoding: [0x00,0x00,0x32,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_eq_f64_e64 exec, v[1:2]
// GFX10: encoding: [0x00,0x00,0x32,0xd4,0x7e,0x02,0x02,0x00]

v_cmpx_eq_f64_e64 v[254:255], v[2:3]
// GFX10: encoding: [0x00,0x00,0x32,0xd4,0xfe,0x05,0x02,0x00]

v_cmpx_eq_f64_e64 s[2:3], v[2:3]
// GFX10: encoding: [0x00,0x00,0x32,0xd4,0x02,0x04,0x02,0x00]

v_cmpx_eq_f64_e64 s[4:5], v[2:3]
// GFX10: encoding: [0x00,0x00,0x32,0xd4,0x04,0x04,0x02,0x00]

v_cmpx_eq_f64_e64 exec, v[2:3]
// GFX10: encoding: [0x00,0x00,0x32,0xd4,0x7e,0x04,0x02,0x00]

v_cmpx_eq_f64_e64 vcc, v[2:3]
// GFX10: encoding: [0x00,0x00,0x32,0xd4,0x6a,0x04,0x02,0x00]

v_cmpx_eq_f64_e64 0, v[2:3]
// GFX10: encoding: [0x00,0x00,0x32,0xd4,0x80,0x04,0x02,0x00]

v_cmpx_eq_f64_e64 -1, v[2:3]
// GFX10: encoding: [0x00,0x00,0x32,0xd4,0xc1,0x04,0x02,0x00]

v_cmpx_eq_f64_e64 0.5, v[2:3]
// GFX10: encoding: [0x00,0x00,0x32,0xd4,0xf0,0x04,0x02,0x00]

v_cmpx_eq_f64_e64 -4.0, v[2:3]
// GFX10: encoding: [0x00,0x00,0x32,0xd4,0xf7,0x04,0x02,0x00]

v_cmpx_eq_f64_e64 v[1:2], v[254:255]
// GFX10: encoding: [0x00,0x00,0x32,0xd4,0x01,0xfd,0x03,0x00]

v_cmpx_eq_f64_e64 v[1:2], s[4:5]
// GFX10: encoding: [0x00,0x00,0x32,0xd4,0x01,0x09,0x00,0x00]

v_cmpx_eq_f64_e64 v[1:2], s[6:7]
// GFX10: encoding: [0x00,0x00,0x32,0xd4,0x01,0x0d,0x00,0x00]

v_cmpx_eq_f64_e64 v[1:2], s[100:101]
// GFX10: encoding: [0x00,0x00,0x32,0xd4,0x01,0xc9,0x00,0x00]

v_cmpx_eq_f64_e64 v[1:2], vcc
// GFX10: encoding: [0x00,0x00,0x32,0xd4,0x01,0xd5,0x00,0x00]

v_cmpx_eq_f64_e64 v[1:2], exec
// GFX10: encoding: [0x00,0x00,0x32,0xd4,0x01,0xfd,0x00,0x00]

v_cmpx_eq_f64_e64 v[1:2], 0
// GFX10: encoding: [0x00,0x00,0x32,0xd4,0x01,0x01,0x01,0x00]

v_cmpx_eq_f64_e64 v[1:2], -1
// GFX10: encoding: [0x00,0x00,0x32,0xd4,0x01,0x83,0x01,0x00]

v_cmpx_eq_f64_e64 v[1:2], 0.5
// GFX10: encoding: [0x00,0x00,0x32,0xd4,0x01,0xe1,0x01,0x00]

v_cmpx_eq_f64_e64 v[1:2], -4.0
// GFX10: encoding: [0x00,0x00,0x32,0xd4,0x01,0xef,0x01,0x00]

v_cmpx_eq_f64_e64 -v[1:2], v[2:3]
// GFX10: encoding: [0x00,0x00,0x32,0xd4,0x01,0x05,0x02,0x20]

v_cmpx_eq_f64_e64 v[1:2], -v[2:3]
// GFX10: encoding: [0x00,0x00,0x32,0xd4,0x01,0x05,0x02,0x40]

v_cmpx_eq_f64_e64 -v[1:2], -v[2:3]
// GFX10: encoding: [0x00,0x00,0x32,0xd4,0x01,0x05,0x02,0x60]

v_cmpx_le_f64 v[1:2], v[2:3]
// GFX10: encoding: [0x01,0x05,0x66,0x7c]

v_cmpx_le_f64 v[254:255], v[2:3]
// GFX10: encoding: [0xfe,0x05,0x66,0x7c]

v_cmpx_le_f64 s[2:3], v[2:3]
// GFX10: encoding: [0x02,0x04,0x66,0x7c]

v_cmpx_le_f64 s[4:5], v[2:3]
// GFX10: encoding: [0x04,0x04,0x66,0x7c]

v_cmpx_le_f64 s[100:101], v[2:3]
// GFX10: encoding: [0x64,0x04,0x66,0x7c]

v_cmpx_le_f64 vcc, v[2:3]
// GFX10: encoding: [0x6a,0x04,0x66,0x7c]

v_cmpx_le_f64 exec, v[2:3]
// GFX10: encoding: [0x7e,0x04,0x66,0x7c]

v_cmpx_le_f64 0, v[2:3]
// GFX10: encoding: [0x80,0x04,0x66,0x7c]

v_cmpx_le_f64 -1, v[2:3]
// GFX10: encoding: [0xc1,0x04,0x66,0x7c]

v_cmpx_le_f64 0.5, v[2:3]
// GFX10: encoding: [0xf0,0x04,0x66,0x7c]

v_cmpx_le_f64 -4.0, v[2:3]
// GFX10: encoding: [0xf7,0x04,0x66,0x7c]

v_cmpx_le_f64 0xaf123456, v[2:3]
// GFX10: encoding: [0xff,0x04,0x66,0x7c,0x56,0x34,0x12,0xaf]

v_cmpx_le_f64 0x3f717273, v[2:3]
// GFX10: encoding: [0xff,0x04,0x66,0x7c,0x73,0x72,0x71,0x3f]

v_cmpx_le_f64 v[1:2], v[254:255]
// GFX10: encoding: [0x01,0xfd,0x67,0x7c]

v_cmpx_le_f64_e64 v[1:2], v[2:3]
// GFX10: encoding: [0x00,0x00,0x33,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_le_f64_e64 exec, v[1:2]
// GFX10: encoding: [0x00,0x00,0x33,0xd4,0x7e,0x02,0x02,0x00]

v_cmpx_le_f64_e64 v[254:255], v[2:3]
// GFX10: encoding: [0x00,0x00,0x33,0xd4,0xfe,0x05,0x02,0x00]

v_cmpx_le_f64_e64 s[2:3], v[2:3]
// GFX10: encoding: [0x00,0x00,0x33,0xd4,0x02,0x04,0x02,0x00]

v_cmpx_le_f64_e64 s[4:5], v[2:3]
// GFX10: encoding: [0x00,0x00,0x33,0xd4,0x04,0x04,0x02,0x00]

v_cmpx_le_f64_e64 exec, v[2:3]
// GFX10: encoding: [0x00,0x00,0x33,0xd4,0x7e,0x04,0x02,0x00]

v_cmpx_le_f64_e64 vcc, v[2:3]
// GFX10: encoding: [0x00,0x00,0x33,0xd4,0x6a,0x04,0x02,0x00]

v_cmpx_le_f64_e64 0, v[2:3]
// GFX10: encoding: [0x00,0x00,0x33,0xd4,0x80,0x04,0x02,0x00]

v_cmpx_le_f64_e64 -1, v[2:3]
// GFX10: encoding: [0x00,0x00,0x33,0xd4,0xc1,0x04,0x02,0x00]

v_cmpx_le_f64_e64 0.5, v[2:3]
// GFX10: encoding: [0x00,0x00,0x33,0xd4,0xf0,0x04,0x02,0x00]

v_cmpx_le_f64_e64 -4.0, v[2:3]
// GFX10: encoding: [0x00,0x00,0x33,0xd4,0xf7,0x04,0x02,0x00]

v_cmpx_le_f64_e64 v[1:2], v[254:255]
// GFX10: encoding: [0x00,0x00,0x33,0xd4,0x01,0xfd,0x03,0x00]

v_cmpx_le_f64_e64 v[1:2], s[4:5]
// GFX10: encoding: [0x00,0x00,0x33,0xd4,0x01,0x09,0x00,0x00]

v_cmpx_le_f64_e64 v[1:2], s[6:7]
// GFX10: encoding: [0x00,0x00,0x33,0xd4,0x01,0x0d,0x00,0x00]

v_cmpx_le_f64_e64 v[1:2], s[100:101]
// GFX10: encoding: [0x00,0x00,0x33,0xd4,0x01,0xc9,0x00,0x00]

v_cmpx_le_f64_e64 v[1:2], vcc
// GFX10: encoding: [0x00,0x00,0x33,0xd4,0x01,0xd5,0x00,0x00]

v_cmpx_le_f64_e64 v[1:2], exec
// GFX10: encoding: [0x00,0x00,0x33,0xd4,0x01,0xfd,0x00,0x00]

v_cmpx_le_f64_e64 v[1:2], 0
// GFX10: encoding: [0x00,0x00,0x33,0xd4,0x01,0x01,0x01,0x00]

v_cmpx_le_f64_e64 v[1:2], -1
// GFX10: encoding: [0x00,0x00,0x33,0xd4,0x01,0x83,0x01,0x00]

v_cmpx_le_f64_e64 v[1:2], 0.5
// GFX10: encoding: [0x00,0x00,0x33,0xd4,0x01,0xe1,0x01,0x00]

v_cmpx_le_f64_e64 v[1:2], -4.0
// GFX10: encoding: [0x00,0x00,0x33,0xd4,0x01,0xef,0x01,0x00]

v_cmpx_le_f64_e64 -v[1:2], v[2:3]
// GFX10: encoding: [0x00,0x00,0x33,0xd4,0x01,0x05,0x02,0x20]

v_cmpx_le_f64_e64 v[1:2], -v[2:3]
// GFX10: encoding: [0x00,0x00,0x33,0xd4,0x01,0x05,0x02,0x40]

v_cmpx_le_f64_e64 -v[1:2], -v[2:3]
// GFX10: encoding: [0x00,0x00,0x33,0xd4,0x01,0x05,0x02,0x60]

v_cmpx_gt_f64 v[1:2], v[2:3]
// GFX10: encoding: [0x01,0x05,0x68,0x7c]

v_cmpx_gt_f64 v[254:255], v[2:3]
// GFX10: encoding: [0xfe,0x05,0x68,0x7c]

v_cmpx_gt_f64 s[2:3], v[2:3]
// GFX10: encoding: [0x02,0x04,0x68,0x7c]

v_cmpx_gt_f64 s[4:5], v[2:3]
// GFX10: encoding: [0x04,0x04,0x68,0x7c]

v_cmpx_gt_f64 s[100:101], v[2:3]
// GFX10: encoding: [0x64,0x04,0x68,0x7c]

v_cmpx_gt_f64 vcc, v[2:3]
// GFX10: encoding: [0x6a,0x04,0x68,0x7c]

v_cmpx_gt_f64 exec, v[2:3]
// GFX10: encoding: [0x7e,0x04,0x68,0x7c]

v_cmpx_gt_f64 0, v[2:3]
// GFX10: encoding: [0x80,0x04,0x68,0x7c]

v_cmpx_gt_f64 -1, v[2:3]
// GFX10: encoding: [0xc1,0x04,0x68,0x7c]

v_cmpx_gt_f64 0.5, v[2:3]
// GFX10: encoding: [0xf0,0x04,0x68,0x7c]

v_cmpx_gt_f64 -4.0, v[2:3]
// GFX10: encoding: [0xf7,0x04,0x68,0x7c]

v_cmpx_gt_f64 0xaf123456, v[2:3]
// GFX10: encoding: [0xff,0x04,0x68,0x7c,0x56,0x34,0x12,0xaf]

v_cmpx_gt_f64 0x3f717273, v[2:3]
// GFX10: encoding: [0xff,0x04,0x68,0x7c,0x73,0x72,0x71,0x3f]

v_cmpx_gt_f64 v[1:2], v[254:255]
// GFX10: encoding: [0x01,0xfd,0x69,0x7c]

v_cmpx_gt_f64_e64 v[1:2], v[2:3]
// GFX10: encoding: [0x00,0x00,0x34,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_gt_f64_e64 exec, v[1:2]
// GFX10: encoding: [0x00,0x00,0x34,0xd4,0x7e,0x02,0x02,0x00]

v_cmpx_gt_f64_e64 v[254:255], v[2:3]
// GFX10: encoding: [0x00,0x00,0x34,0xd4,0xfe,0x05,0x02,0x00]

v_cmpx_gt_f64_e64 s[2:3], v[2:3]
// GFX10: encoding: [0x00,0x00,0x34,0xd4,0x02,0x04,0x02,0x00]

v_cmpx_gt_f64_e64 s[4:5], v[2:3]
// GFX10: encoding: [0x00,0x00,0x34,0xd4,0x04,0x04,0x02,0x00]

v_cmpx_gt_f64_e64 exec, v[2:3]
// GFX10: encoding: [0x00,0x00,0x34,0xd4,0x7e,0x04,0x02,0x00]

v_cmpx_gt_f64_e64 vcc, v[2:3]
// GFX10: encoding: [0x00,0x00,0x34,0xd4,0x6a,0x04,0x02,0x00]

v_cmpx_gt_f64_e64 0, v[2:3]
// GFX10: encoding: [0x00,0x00,0x34,0xd4,0x80,0x04,0x02,0x00]

v_cmpx_gt_f64_e64 -1, v[2:3]
// GFX10: encoding: [0x00,0x00,0x34,0xd4,0xc1,0x04,0x02,0x00]

v_cmpx_gt_f64_e64 0.5, v[2:3]
// GFX10: encoding: [0x00,0x00,0x34,0xd4,0xf0,0x04,0x02,0x00]

v_cmpx_gt_f64_e64 -4.0, v[2:3]
// GFX10: encoding: [0x00,0x00,0x34,0xd4,0xf7,0x04,0x02,0x00]

v_cmpx_gt_f64_e64 v[1:2], v[254:255]
// GFX10: encoding: [0x00,0x00,0x34,0xd4,0x01,0xfd,0x03,0x00]

v_cmpx_gt_f64_e64 v[1:2], s[4:5]
// GFX10: encoding: [0x00,0x00,0x34,0xd4,0x01,0x09,0x00,0x00]

v_cmpx_gt_f64_e64 v[1:2], s[6:7]
// GFX10: encoding: [0x00,0x00,0x34,0xd4,0x01,0x0d,0x00,0x00]

v_cmpx_gt_f64_e64 v[1:2], s[100:101]
// GFX10: encoding: [0x00,0x00,0x34,0xd4,0x01,0xc9,0x00,0x00]

v_cmpx_gt_f64_e64 v[1:2], vcc
// GFX10: encoding: [0x00,0x00,0x34,0xd4,0x01,0xd5,0x00,0x00]

v_cmpx_gt_f64_e64 v[1:2], exec
// GFX10: encoding: [0x00,0x00,0x34,0xd4,0x01,0xfd,0x00,0x00]

v_cmpx_gt_f64_e64 v[1:2], 0
// GFX10: encoding: [0x00,0x00,0x34,0xd4,0x01,0x01,0x01,0x00]

v_cmpx_gt_f64_e64 v[1:2], -1
// GFX10: encoding: [0x00,0x00,0x34,0xd4,0x01,0x83,0x01,0x00]

v_cmpx_gt_f64_e64 v[1:2], 0.5
// GFX10: encoding: [0x00,0x00,0x34,0xd4,0x01,0xe1,0x01,0x00]

v_cmpx_gt_f64_e64 v[1:2], -4.0
// GFX10: encoding: [0x00,0x00,0x34,0xd4,0x01,0xef,0x01,0x00]

v_cmpx_gt_f64_e64 -v[1:2], v[2:3]
// GFX10: encoding: [0x00,0x00,0x34,0xd4,0x01,0x05,0x02,0x20]

v_cmpx_gt_f64_e64 v[1:2], -v[2:3]
// GFX10: encoding: [0x00,0x00,0x34,0xd4,0x01,0x05,0x02,0x40]

v_cmpx_gt_f64_e64 -v[1:2], -v[2:3]
// GFX10: encoding: [0x00,0x00,0x34,0xd4,0x01,0x05,0x02,0x60]

v_cmpx_lg_f64 v[1:2], v[2:3]
// GFX10: encoding: [0x01,0x05,0x6a,0x7c]

v_cmpx_lg_f64 v[254:255], v[2:3]
// GFX10: encoding: [0xfe,0x05,0x6a,0x7c]

v_cmpx_lg_f64 s[2:3], v[2:3]
// GFX10: encoding: [0x02,0x04,0x6a,0x7c]

v_cmpx_lg_f64 s[4:5], v[2:3]
// GFX10: encoding: [0x04,0x04,0x6a,0x7c]

v_cmpx_lg_f64 s[100:101], v[2:3]
// GFX10: encoding: [0x64,0x04,0x6a,0x7c]

v_cmpx_lg_f64 vcc, v[2:3]
// GFX10: encoding: [0x6a,0x04,0x6a,0x7c]

v_cmpx_lg_f64 exec, v[2:3]
// GFX10: encoding: [0x7e,0x04,0x6a,0x7c]

v_cmpx_lg_f64 0, v[2:3]
// GFX10: encoding: [0x80,0x04,0x6a,0x7c]

v_cmpx_lg_f64 -1, v[2:3]
// GFX10: encoding: [0xc1,0x04,0x6a,0x7c]

v_cmpx_lg_f64 0.5, v[2:3]
// GFX10: encoding: [0xf0,0x04,0x6a,0x7c]

v_cmpx_lg_f64 -4.0, v[2:3]
// GFX10: encoding: [0xf7,0x04,0x6a,0x7c]

v_cmpx_lg_f64 0xaf123456, v[2:3]
// GFX10: encoding: [0xff,0x04,0x6a,0x7c,0x56,0x34,0x12,0xaf]

v_cmpx_lg_f64 0x3f717273, v[2:3]
// GFX10: encoding: [0xff,0x04,0x6a,0x7c,0x73,0x72,0x71,0x3f]

v_cmpx_lg_f64 v[1:2], v[254:255]
// GFX10: encoding: [0x01,0xfd,0x6b,0x7c]

v_cmpx_lg_f64_e64 v[1:2], v[2:3]
// GFX10: encoding: [0x00,0x00,0x35,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_lg_f64_e64 exec, v[1:2]
// GFX10: encoding: [0x00,0x00,0x35,0xd4,0x7e,0x02,0x02,0x00]

v_cmpx_lg_f64_e64 v[254:255], v[2:3]
// GFX10: encoding: [0x00,0x00,0x35,0xd4,0xfe,0x05,0x02,0x00]

v_cmpx_lg_f64_e64 s[2:3], v[2:3]
// GFX10: encoding: [0x00,0x00,0x35,0xd4,0x02,0x04,0x02,0x00]

v_cmpx_lg_f64_e64 s[4:5], v[2:3]
// GFX10: encoding: [0x00,0x00,0x35,0xd4,0x04,0x04,0x02,0x00]

v_cmpx_lg_f64_e64 exec, v[2:3]
// GFX10: encoding: [0x00,0x00,0x35,0xd4,0x7e,0x04,0x02,0x00]

v_cmpx_lg_f64_e64 vcc, v[2:3]
// GFX10: encoding: [0x00,0x00,0x35,0xd4,0x6a,0x04,0x02,0x00]

v_cmpx_lg_f64_e64 0, v[2:3]
// GFX10: encoding: [0x00,0x00,0x35,0xd4,0x80,0x04,0x02,0x00]

v_cmpx_lg_f64_e64 -1, v[2:3]
// GFX10: encoding: [0x00,0x00,0x35,0xd4,0xc1,0x04,0x02,0x00]

v_cmpx_lg_f64_e64 0.5, v[2:3]
// GFX10: encoding: [0x00,0x00,0x35,0xd4,0xf0,0x04,0x02,0x00]

v_cmpx_lg_f64_e64 -4.0, v[2:3]
// GFX10: encoding: [0x00,0x00,0x35,0xd4,0xf7,0x04,0x02,0x00]

v_cmpx_lg_f64_e64 v[1:2], v[254:255]
// GFX10: encoding: [0x00,0x00,0x35,0xd4,0x01,0xfd,0x03,0x00]

v_cmpx_lg_f64_e64 v[1:2], s[4:5]
// GFX10: encoding: [0x00,0x00,0x35,0xd4,0x01,0x09,0x00,0x00]

v_cmpx_lg_f64_e64 v[1:2], s[6:7]
// GFX10: encoding: [0x00,0x00,0x35,0xd4,0x01,0x0d,0x00,0x00]

v_cmpx_lg_f64_e64 v[1:2], s[100:101]
// GFX10: encoding: [0x00,0x00,0x35,0xd4,0x01,0xc9,0x00,0x00]

v_cmpx_lg_f64_e64 v[1:2], vcc
// GFX10: encoding: [0x00,0x00,0x35,0xd4,0x01,0xd5,0x00,0x00]

v_cmpx_lg_f64_e64 v[1:2], exec
// GFX10: encoding: [0x00,0x00,0x35,0xd4,0x01,0xfd,0x00,0x00]

v_cmpx_lg_f64_e64 v[1:2], 0
// GFX10: encoding: [0x00,0x00,0x35,0xd4,0x01,0x01,0x01,0x00]

v_cmpx_lg_f64_e64 v[1:2], -1
// GFX10: encoding: [0x00,0x00,0x35,0xd4,0x01,0x83,0x01,0x00]

v_cmpx_lg_f64_e64 v[1:2], 0.5
// GFX10: encoding: [0x00,0x00,0x35,0xd4,0x01,0xe1,0x01,0x00]

v_cmpx_lg_f64_e64 v[1:2], -4.0
// GFX10: encoding: [0x00,0x00,0x35,0xd4,0x01,0xef,0x01,0x00]

v_cmpx_lg_f64_e64 -v[1:2], v[2:3]
// GFX10: encoding: [0x00,0x00,0x35,0xd4,0x01,0x05,0x02,0x20]

v_cmpx_lg_f64_e64 v[1:2], -v[2:3]
// GFX10: encoding: [0x00,0x00,0x35,0xd4,0x01,0x05,0x02,0x40]

v_cmpx_lg_f64_e64 -v[1:2], -v[2:3]
// GFX10: encoding: [0x00,0x00,0x35,0xd4,0x01,0x05,0x02,0x60]

v_cmpx_ge_f64 v[1:2], v[2:3]
// GFX10: encoding: [0x01,0x05,0x6c,0x7c]

v_cmpx_ge_f64 v[254:255], v[2:3]
// GFX10: encoding: [0xfe,0x05,0x6c,0x7c]

v_cmpx_ge_f64 s[2:3], v[2:3]
// GFX10: encoding: [0x02,0x04,0x6c,0x7c]

v_cmpx_ge_f64 s[4:5], v[2:3]
// GFX10: encoding: [0x04,0x04,0x6c,0x7c]

v_cmpx_ge_f64 s[100:101], v[2:3]
// GFX10: encoding: [0x64,0x04,0x6c,0x7c]

v_cmpx_ge_f64 vcc, v[2:3]
// GFX10: encoding: [0x6a,0x04,0x6c,0x7c]

v_cmpx_ge_f64 exec, v[2:3]
// GFX10: encoding: [0x7e,0x04,0x6c,0x7c]

v_cmpx_ge_f64 0, v[2:3]
// GFX10: encoding: [0x80,0x04,0x6c,0x7c]

v_cmpx_ge_f64 -1, v[2:3]
// GFX10: encoding: [0xc1,0x04,0x6c,0x7c]

v_cmpx_ge_f64 0.5, v[2:3]
// GFX10: encoding: [0xf0,0x04,0x6c,0x7c]

v_cmpx_ge_f64 -4.0, v[2:3]
// GFX10: encoding: [0xf7,0x04,0x6c,0x7c]

v_cmpx_ge_f64 0xaf123456, v[2:3]
// GFX10: encoding: [0xff,0x04,0x6c,0x7c,0x56,0x34,0x12,0xaf]

v_cmpx_ge_f64 0x3f717273, v[2:3]
// GFX10: encoding: [0xff,0x04,0x6c,0x7c,0x73,0x72,0x71,0x3f]

v_cmpx_ge_f64 v[1:2], v[254:255]
// GFX10: encoding: [0x01,0xfd,0x6d,0x7c]

v_cmpx_ge_f64_e64 v[1:2], v[2:3]
// GFX10: encoding: [0x00,0x00,0x36,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_ge_f64_e64 exec, v[1:2]
// GFX10: encoding: [0x00,0x00,0x36,0xd4,0x7e,0x02,0x02,0x00]

v_cmpx_ge_f64_e64 v[254:255], v[2:3]
// GFX10: encoding: [0x00,0x00,0x36,0xd4,0xfe,0x05,0x02,0x00]

v_cmpx_ge_f64_e64 s[2:3], v[2:3]
// GFX10: encoding: [0x00,0x00,0x36,0xd4,0x02,0x04,0x02,0x00]

v_cmpx_ge_f64_e64 s[4:5], v[2:3]
// GFX10: encoding: [0x00,0x00,0x36,0xd4,0x04,0x04,0x02,0x00]

v_cmpx_ge_f64_e64 exec, v[2:3]
// GFX10: encoding: [0x00,0x00,0x36,0xd4,0x7e,0x04,0x02,0x00]

v_cmpx_ge_f64_e64 vcc, v[2:3]
// GFX10: encoding: [0x00,0x00,0x36,0xd4,0x6a,0x04,0x02,0x00]

v_cmpx_ge_f64_e64 0, v[2:3]
// GFX10: encoding: [0x00,0x00,0x36,0xd4,0x80,0x04,0x02,0x00]

v_cmpx_ge_f64_e64 -1, v[2:3]
// GFX10: encoding: [0x00,0x00,0x36,0xd4,0xc1,0x04,0x02,0x00]

v_cmpx_ge_f64_e64 0.5, v[2:3]
// GFX10: encoding: [0x00,0x00,0x36,0xd4,0xf0,0x04,0x02,0x00]

v_cmpx_ge_f64_e64 -4.0, v[2:3]
// GFX10: encoding: [0x00,0x00,0x36,0xd4,0xf7,0x04,0x02,0x00]

v_cmpx_ge_f64_e64 v[1:2], v[254:255]
// GFX10: encoding: [0x00,0x00,0x36,0xd4,0x01,0xfd,0x03,0x00]

v_cmpx_ge_f64_e64 v[1:2], s[4:5]
// GFX10: encoding: [0x00,0x00,0x36,0xd4,0x01,0x09,0x00,0x00]

v_cmpx_ge_f64_e64 v[1:2], s[6:7]
// GFX10: encoding: [0x00,0x00,0x36,0xd4,0x01,0x0d,0x00,0x00]

v_cmpx_ge_f64_e64 v[1:2], s[100:101]
// GFX10: encoding: [0x00,0x00,0x36,0xd4,0x01,0xc9,0x00,0x00]

v_cmpx_ge_f64_e64 v[1:2], vcc
// GFX10: encoding: [0x00,0x00,0x36,0xd4,0x01,0xd5,0x00,0x00]

v_cmpx_ge_f64_e64 v[1:2], exec
// GFX10: encoding: [0x00,0x00,0x36,0xd4,0x01,0xfd,0x00,0x00]

v_cmpx_ge_f64_e64 v[1:2], 0
// GFX10: encoding: [0x00,0x00,0x36,0xd4,0x01,0x01,0x01,0x00]

v_cmpx_ge_f64_e64 v[1:2], -1
// GFX10: encoding: [0x00,0x00,0x36,0xd4,0x01,0x83,0x01,0x00]

v_cmpx_ge_f64_e64 v[1:2], 0.5
// GFX10: encoding: [0x00,0x00,0x36,0xd4,0x01,0xe1,0x01,0x00]

v_cmpx_ge_f64_e64 v[1:2], -4.0
// GFX10: encoding: [0x00,0x00,0x36,0xd4,0x01,0xef,0x01,0x00]

v_cmpx_ge_f64_e64 -v[1:2], v[2:3]
// GFX10: encoding: [0x00,0x00,0x36,0xd4,0x01,0x05,0x02,0x20]

v_cmpx_ge_f64_e64 v[1:2], -v[2:3]
// GFX10: encoding: [0x00,0x00,0x36,0xd4,0x01,0x05,0x02,0x40]

v_cmpx_ge_f64_e64 -v[1:2], -v[2:3]
// GFX10: encoding: [0x00,0x00,0x36,0xd4,0x01,0x05,0x02,0x60]

v_cmpx_o_f64 v[1:2], v[2:3]
// GFX10: encoding: [0x01,0x05,0x6e,0x7c]

v_cmpx_o_f64 v[254:255], v[2:3]
// GFX10: encoding: [0xfe,0x05,0x6e,0x7c]

v_cmpx_o_f64 s[2:3], v[2:3]
// GFX10: encoding: [0x02,0x04,0x6e,0x7c]

v_cmpx_o_f64 s[4:5], v[2:3]
// GFX10: encoding: [0x04,0x04,0x6e,0x7c]

v_cmpx_o_f64 s[100:101], v[2:3]
// GFX10: encoding: [0x64,0x04,0x6e,0x7c]

v_cmpx_o_f64 vcc, v[2:3]
// GFX10: encoding: [0x6a,0x04,0x6e,0x7c]

v_cmpx_o_f64 exec, v[2:3]
// GFX10: encoding: [0x7e,0x04,0x6e,0x7c]

v_cmpx_o_f64 0, v[2:3]
// GFX10: encoding: [0x80,0x04,0x6e,0x7c]

v_cmpx_o_f64 -1, v[2:3]
// GFX10: encoding: [0xc1,0x04,0x6e,0x7c]

v_cmpx_o_f64 0.5, v[2:3]
// GFX10: encoding: [0xf0,0x04,0x6e,0x7c]

v_cmpx_o_f64 -4.0, v[2:3]
// GFX10: encoding: [0xf7,0x04,0x6e,0x7c]

v_cmpx_o_f64 0xaf123456, v[2:3]
// GFX10: encoding: [0xff,0x04,0x6e,0x7c,0x56,0x34,0x12,0xaf]

v_cmpx_o_f64 0x3f717273, v[2:3]
// GFX10: encoding: [0xff,0x04,0x6e,0x7c,0x73,0x72,0x71,0x3f]

v_cmpx_o_f64 v[1:2], v[254:255]
// GFX10: encoding: [0x01,0xfd,0x6f,0x7c]

v_cmpx_o_f64_e64 v[1:2], v[2:3]
// GFX10: encoding: [0x00,0x00,0x37,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_o_f64_e64 exec, v[1:2]
// GFX10: encoding: [0x00,0x00,0x37,0xd4,0x7e,0x02,0x02,0x00]

v_cmpx_o_f64_e64 v[254:255], v[2:3]
// GFX10: encoding: [0x00,0x00,0x37,0xd4,0xfe,0x05,0x02,0x00]

v_cmpx_o_f64_e64 s[2:3], v[2:3]
// GFX10: encoding: [0x00,0x00,0x37,0xd4,0x02,0x04,0x02,0x00]

v_cmpx_o_f64_e64 s[4:5], v[2:3]
// GFX10: encoding: [0x00,0x00,0x37,0xd4,0x04,0x04,0x02,0x00]

v_cmpx_o_f64_e64 exec, v[2:3]
// GFX10: encoding: [0x00,0x00,0x37,0xd4,0x7e,0x04,0x02,0x00]

v_cmpx_o_f64_e64 vcc, v[2:3]
// GFX10: encoding: [0x00,0x00,0x37,0xd4,0x6a,0x04,0x02,0x00]

v_cmpx_o_f64_e64 0, v[2:3]
// GFX10: encoding: [0x00,0x00,0x37,0xd4,0x80,0x04,0x02,0x00]

v_cmpx_o_f64_e64 -1, v[2:3]
// GFX10: encoding: [0x00,0x00,0x37,0xd4,0xc1,0x04,0x02,0x00]

v_cmpx_o_f64_e64 0.5, v[2:3]
// GFX10: encoding: [0x00,0x00,0x37,0xd4,0xf0,0x04,0x02,0x00]

v_cmpx_o_f64_e64 -4.0, v[2:3]
// GFX10: encoding: [0x00,0x00,0x37,0xd4,0xf7,0x04,0x02,0x00]

v_cmpx_o_f64_e64 v[1:2], v[254:255]
// GFX10: encoding: [0x00,0x00,0x37,0xd4,0x01,0xfd,0x03,0x00]

v_cmpx_o_f64_e64 v[1:2], s[4:5]
// GFX10: encoding: [0x00,0x00,0x37,0xd4,0x01,0x09,0x00,0x00]

v_cmpx_o_f64_e64 v[1:2], s[6:7]
// GFX10: encoding: [0x00,0x00,0x37,0xd4,0x01,0x0d,0x00,0x00]

v_cmpx_o_f64_e64 v[1:2], s[100:101]
// GFX10: encoding: [0x00,0x00,0x37,0xd4,0x01,0xc9,0x00,0x00]

v_cmpx_o_f64_e64 v[1:2], vcc
// GFX10: encoding: [0x00,0x00,0x37,0xd4,0x01,0xd5,0x00,0x00]

v_cmpx_o_f64_e64 v[1:2], exec
// GFX10: encoding: [0x00,0x00,0x37,0xd4,0x01,0xfd,0x00,0x00]

v_cmpx_o_f64_e64 v[1:2], 0
// GFX10: encoding: [0x00,0x00,0x37,0xd4,0x01,0x01,0x01,0x00]

v_cmpx_o_f64_e64 v[1:2], -1
// GFX10: encoding: [0x00,0x00,0x37,0xd4,0x01,0x83,0x01,0x00]

v_cmpx_o_f64_e64 v[1:2], 0.5
// GFX10: encoding: [0x00,0x00,0x37,0xd4,0x01,0xe1,0x01,0x00]

v_cmpx_o_f64_e64 v[1:2], -4.0
// GFX10: encoding: [0x00,0x00,0x37,0xd4,0x01,0xef,0x01,0x00]

v_cmpx_o_f64_e64 -v[1:2], v[2:3]
// GFX10: encoding: [0x00,0x00,0x37,0xd4,0x01,0x05,0x02,0x20]

v_cmpx_o_f64_e64 v[1:2], -v[2:3]
// GFX10: encoding: [0x00,0x00,0x37,0xd4,0x01,0x05,0x02,0x40]

v_cmpx_o_f64_e64 -v[1:2], -v[2:3]
// GFX10: encoding: [0x00,0x00,0x37,0xd4,0x01,0x05,0x02,0x60]

v_cmpx_u_f64 v[1:2], v[2:3]
// GFX10: encoding: [0x01,0x05,0x70,0x7c]

v_cmpx_u_f64 v[254:255], v[2:3]
// GFX10: encoding: [0xfe,0x05,0x70,0x7c]

v_cmpx_u_f64 s[2:3], v[2:3]
// GFX10: encoding: [0x02,0x04,0x70,0x7c]

v_cmpx_u_f64 s[4:5], v[2:3]
// GFX10: encoding: [0x04,0x04,0x70,0x7c]

v_cmpx_u_f64 s[100:101], v[2:3]
// GFX10: encoding: [0x64,0x04,0x70,0x7c]

v_cmpx_u_f64 vcc, v[2:3]
// GFX10: encoding: [0x6a,0x04,0x70,0x7c]

v_cmpx_u_f64 exec, v[2:3]
// GFX10: encoding: [0x7e,0x04,0x70,0x7c]

v_cmpx_u_f64 0, v[2:3]
// GFX10: encoding: [0x80,0x04,0x70,0x7c]

v_cmpx_u_f64 -1, v[2:3]
// GFX10: encoding: [0xc1,0x04,0x70,0x7c]

v_cmpx_u_f64 0.5, v[2:3]
// GFX10: encoding: [0xf0,0x04,0x70,0x7c]

v_cmpx_u_f64 -4.0, v[2:3]
// GFX10: encoding: [0xf7,0x04,0x70,0x7c]

v_cmpx_u_f64 0xaf123456, v[2:3]
// GFX10: encoding: [0xff,0x04,0x70,0x7c,0x56,0x34,0x12,0xaf]

v_cmpx_u_f64 0x3f717273, v[2:3]
// GFX10: encoding: [0xff,0x04,0x70,0x7c,0x73,0x72,0x71,0x3f]

v_cmpx_u_f64 v[1:2], v[254:255]
// GFX10: encoding: [0x01,0xfd,0x71,0x7c]

v_cmpx_u_f64_e64 v[1:2], v[2:3]
// GFX10: encoding: [0x00,0x00,0x38,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_u_f64_e64 exec, v[1:2]
// GFX10: encoding: [0x00,0x00,0x38,0xd4,0x7e,0x02,0x02,0x00]

v_cmpx_u_f64_e64 v[254:255], v[2:3]
// GFX10: encoding: [0x00,0x00,0x38,0xd4,0xfe,0x05,0x02,0x00]

v_cmpx_u_f64_e64 s[2:3], v[2:3]
// GFX10: encoding: [0x00,0x00,0x38,0xd4,0x02,0x04,0x02,0x00]

v_cmpx_u_f64_e64 s[4:5], v[2:3]
// GFX10: encoding: [0x00,0x00,0x38,0xd4,0x04,0x04,0x02,0x00]

v_cmpx_u_f64_e64 exec, v[2:3]
// GFX10: encoding: [0x00,0x00,0x38,0xd4,0x7e,0x04,0x02,0x00]

v_cmpx_u_f64_e64 vcc, v[2:3]
// GFX10: encoding: [0x00,0x00,0x38,0xd4,0x6a,0x04,0x02,0x00]

v_cmpx_u_f64_e64 0, v[2:3]
// GFX10: encoding: [0x00,0x00,0x38,0xd4,0x80,0x04,0x02,0x00]

v_cmpx_u_f64_e64 -1, v[2:3]
// GFX10: encoding: [0x00,0x00,0x38,0xd4,0xc1,0x04,0x02,0x00]

v_cmpx_u_f64_e64 0.5, v[2:3]
// GFX10: encoding: [0x00,0x00,0x38,0xd4,0xf0,0x04,0x02,0x00]

v_cmpx_u_f64_e64 -4.0, v[2:3]
// GFX10: encoding: [0x00,0x00,0x38,0xd4,0xf7,0x04,0x02,0x00]

v_cmpx_u_f64_e64 v[1:2], v[254:255]
// GFX10: encoding: [0x00,0x00,0x38,0xd4,0x01,0xfd,0x03,0x00]

v_cmpx_u_f64_e64 v[1:2], s[4:5]
// GFX10: encoding: [0x00,0x00,0x38,0xd4,0x01,0x09,0x00,0x00]

v_cmpx_u_f64_e64 v[1:2], s[6:7]
// GFX10: encoding: [0x00,0x00,0x38,0xd4,0x01,0x0d,0x00,0x00]

v_cmpx_u_f64_e64 v[1:2], s[100:101]
// GFX10: encoding: [0x00,0x00,0x38,0xd4,0x01,0xc9,0x00,0x00]

v_cmpx_u_f64_e64 v[1:2], vcc
// GFX10: encoding: [0x00,0x00,0x38,0xd4,0x01,0xd5,0x00,0x00]

v_cmpx_u_f64_e64 v[1:2], exec
// GFX10: encoding: [0x00,0x00,0x38,0xd4,0x01,0xfd,0x00,0x00]

v_cmpx_u_f64_e64 v[1:2], 0
// GFX10: encoding: [0x00,0x00,0x38,0xd4,0x01,0x01,0x01,0x00]

v_cmpx_u_f64_e64 v[1:2], -1
// GFX10: encoding: [0x00,0x00,0x38,0xd4,0x01,0x83,0x01,0x00]

v_cmpx_u_f64_e64 v[1:2], 0.5
// GFX10: encoding: [0x00,0x00,0x38,0xd4,0x01,0xe1,0x01,0x00]

v_cmpx_u_f64_e64 v[1:2], -4.0
// GFX10: encoding: [0x00,0x00,0x38,0xd4,0x01,0xef,0x01,0x00]

v_cmpx_u_f64_e64 -v[1:2], v[2:3]
// GFX10: encoding: [0x00,0x00,0x38,0xd4,0x01,0x05,0x02,0x20]

v_cmpx_u_f64_e64 v[1:2], -v[2:3]
// GFX10: encoding: [0x00,0x00,0x38,0xd4,0x01,0x05,0x02,0x40]

v_cmpx_u_f64_e64 -v[1:2], -v[2:3]
// GFX10: encoding: [0x00,0x00,0x38,0xd4,0x01,0x05,0x02,0x60]

v_cmpx_nge_f64 v[1:2], v[2:3]
// GFX10: encoding: [0x01,0x05,0x72,0x7c]

v_cmpx_nge_f64 v[254:255], v[2:3]
// GFX10: encoding: [0xfe,0x05,0x72,0x7c]

v_cmpx_nge_f64 s[2:3], v[2:3]
// GFX10: encoding: [0x02,0x04,0x72,0x7c]

v_cmpx_nge_f64 s[4:5], v[2:3]
// GFX10: encoding: [0x04,0x04,0x72,0x7c]

v_cmpx_nge_f64 s[100:101], v[2:3]
// GFX10: encoding: [0x64,0x04,0x72,0x7c]

v_cmpx_nge_f64 vcc, v[2:3]
// GFX10: encoding: [0x6a,0x04,0x72,0x7c]

v_cmpx_nge_f64 exec, v[2:3]
// GFX10: encoding: [0x7e,0x04,0x72,0x7c]

v_cmpx_nge_f64 0, v[2:3]
// GFX10: encoding: [0x80,0x04,0x72,0x7c]

v_cmpx_nge_f64 -1, v[2:3]
// GFX10: encoding: [0xc1,0x04,0x72,0x7c]

v_cmpx_nge_f64 0.5, v[2:3]
// GFX10: encoding: [0xf0,0x04,0x72,0x7c]

v_cmpx_nge_f64 -4.0, v[2:3]
// GFX10: encoding: [0xf7,0x04,0x72,0x7c]

v_cmpx_nge_f64 0xaf123456, v[2:3]
// GFX10: encoding: [0xff,0x04,0x72,0x7c,0x56,0x34,0x12,0xaf]

v_cmpx_nge_f64 0x3f717273, v[2:3]
// GFX10: encoding: [0xff,0x04,0x72,0x7c,0x73,0x72,0x71,0x3f]

v_cmpx_nge_f64 v[1:2], v[254:255]
// GFX10: encoding: [0x01,0xfd,0x73,0x7c]

v_cmpx_nge_f64_e64 v[1:2], v[2:3]
// GFX10: encoding: [0x00,0x00,0x39,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_nge_f64_e64 exec, v[1:2]
// GFX10: encoding: [0x00,0x00,0x39,0xd4,0x7e,0x02,0x02,0x00]

v_cmpx_nge_f64_e64 v[254:255], v[2:3]
// GFX10: encoding: [0x00,0x00,0x39,0xd4,0xfe,0x05,0x02,0x00]

v_cmpx_nge_f64_e64 s[2:3], v[2:3]
// GFX10: encoding: [0x00,0x00,0x39,0xd4,0x02,0x04,0x02,0x00]

v_cmpx_nge_f64_e64 s[4:5], v[2:3]
// GFX10: encoding: [0x00,0x00,0x39,0xd4,0x04,0x04,0x02,0x00]

v_cmpx_nge_f64_e64 exec, v[2:3]
// GFX10: encoding: [0x00,0x00,0x39,0xd4,0x7e,0x04,0x02,0x00]

v_cmpx_nge_f64_e64 vcc, v[2:3]
// GFX10: encoding: [0x00,0x00,0x39,0xd4,0x6a,0x04,0x02,0x00]

v_cmpx_nge_f64_e64 0, v[2:3]
// GFX10: encoding: [0x00,0x00,0x39,0xd4,0x80,0x04,0x02,0x00]

v_cmpx_nge_f64_e64 -1, v[2:3]
// GFX10: encoding: [0x00,0x00,0x39,0xd4,0xc1,0x04,0x02,0x00]

v_cmpx_nge_f64_e64 0.5, v[2:3]
// GFX10: encoding: [0x00,0x00,0x39,0xd4,0xf0,0x04,0x02,0x00]

v_cmpx_nge_f64_e64 -4.0, v[2:3]
// GFX10: encoding: [0x00,0x00,0x39,0xd4,0xf7,0x04,0x02,0x00]

v_cmpx_nge_f64_e64 v[1:2], v[254:255]
// GFX10: encoding: [0x00,0x00,0x39,0xd4,0x01,0xfd,0x03,0x00]

v_cmpx_nge_f64_e64 v[1:2], s[4:5]
// GFX10: encoding: [0x00,0x00,0x39,0xd4,0x01,0x09,0x00,0x00]

v_cmpx_nge_f64_e64 v[1:2], s[6:7]
// GFX10: encoding: [0x00,0x00,0x39,0xd4,0x01,0x0d,0x00,0x00]

v_cmpx_nge_f64_e64 v[1:2], s[100:101]
// GFX10: encoding: [0x00,0x00,0x39,0xd4,0x01,0xc9,0x00,0x00]

v_cmpx_nge_f64_e64 v[1:2], vcc
// GFX10: encoding: [0x00,0x00,0x39,0xd4,0x01,0xd5,0x00,0x00]

v_cmpx_nge_f64_e64 v[1:2], exec
// GFX10: encoding: [0x00,0x00,0x39,0xd4,0x01,0xfd,0x00,0x00]

v_cmpx_nge_f64_e64 v[1:2], 0
// GFX10: encoding: [0x00,0x00,0x39,0xd4,0x01,0x01,0x01,0x00]

v_cmpx_nge_f64_e64 v[1:2], -1
// GFX10: encoding: [0x00,0x00,0x39,0xd4,0x01,0x83,0x01,0x00]

v_cmpx_nge_f64_e64 v[1:2], 0.5
// GFX10: encoding: [0x00,0x00,0x39,0xd4,0x01,0xe1,0x01,0x00]

v_cmpx_nge_f64_e64 v[1:2], -4.0
// GFX10: encoding: [0x00,0x00,0x39,0xd4,0x01,0xef,0x01,0x00]

v_cmpx_nge_f64_e64 -v[1:2], v[2:3]
// GFX10: encoding: [0x00,0x00,0x39,0xd4,0x01,0x05,0x02,0x20]

v_cmpx_nge_f64_e64 v[1:2], -v[2:3]
// GFX10: encoding: [0x00,0x00,0x39,0xd4,0x01,0x05,0x02,0x40]

v_cmpx_nge_f64_e64 -v[1:2], -v[2:3]
// GFX10: encoding: [0x00,0x00,0x39,0xd4,0x01,0x05,0x02,0x60]

v_cmpx_nlg_f64 v[1:2], v[2:3]
// GFX10: encoding: [0x01,0x05,0x74,0x7c]

v_cmpx_nlg_f64 v[254:255], v[2:3]
// GFX10: encoding: [0xfe,0x05,0x74,0x7c]

v_cmpx_nlg_f64 s[2:3], v[2:3]
// GFX10: encoding: [0x02,0x04,0x74,0x7c]

v_cmpx_nlg_f64 s[4:5], v[2:3]
// GFX10: encoding: [0x04,0x04,0x74,0x7c]

v_cmpx_nlg_f64 s[100:101], v[2:3]
// GFX10: encoding: [0x64,0x04,0x74,0x7c]

v_cmpx_nlg_f64 vcc, v[2:3]
// GFX10: encoding: [0x6a,0x04,0x74,0x7c]

v_cmpx_nlg_f64 exec, v[2:3]
// GFX10: encoding: [0x7e,0x04,0x74,0x7c]

v_cmpx_nlg_f64 0, v[2:3]
// GFX10: encoding: [0x80,0x04,0x74,0x7c]

v_cmpx_nlg_f64 -1, v[2:3]
// GFX10: encoding: [0xc1,0x04,0x74,0x7c]

v_cmpx_nlg_f64 0.5, v[2:3]
// GFX10: encoding: [0xf0,0x04,0x74,0x7c]

v_cmpx_nlg_f64 -4.0, v[2:3]
// GFX10: encoding: [0xf7,0x04,0x74,0x7c]

v_cmpx_nlg_f64 0xaf123456, v[2:3]
// GFX10: encoding: [0xff,0x04,0x74,0x7c,0x56,0x34,0x12,0xaf]

v_cmpx_nlg_f64 0x3f717273, v[2:3]
// GFX10: encoding: [0xff,0x04,0x74,0x7c,0x73,0x72,0x71,0x3f]

v_cmpx_nlg_f64 v[1:2], v[254:255]
// GFX10: encoding: [0x01,0xfd,0x75,0x7c]

v_cmpx_nlg_f64_e64 v[1:2], v[2:3]
// GFX10: encoding: [0x00,0x00,0x3a,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_nlg_f64_e64 exec, v[1:2]
// GFX10: encoding: [0x00,0x00,0x3a,0xd4,0x7e,0x02,0x02,0x00]

v_cmpx_nlg_f64_e64 v[254:255], v[2:3]
// GFX10: encoding: [0x00,0x00,0x3a,0xd4,0xfe,0x05,0x02,0x00]

v_cmpx_nlg_f64_e64 s[2:3], v[2:3]
// GFX10: encoding: [0x00,0x00,0x3a,0xd4,0x02,0x04,0x02,0x00]

v_cmpx_nlg_f64_e64 s[4:5], v[2:3]
// GFX10: encoding: [0x00,0x00,0x3a,0xd4,0x04,0x04,0x02,0x00]

v_cmpx_nlg_f64_e64 exec, v[2:3]
// GFX10: encoding: [0x00,0x00,0x3a,0xd4,0x7e,0x04,0x02,0x00]

v_cmpx_nlg_f64_e64 vcc, v[2:3]
// GFX10: encoding: [0x00,0x00,0x3a,0xd4,0x6a,0x04,0x02,0x00]

v_cmpx_nlg_f64_e64 0, v[2:3]
// GFX10: encoding: [0x00,0x00,0x3a,0xd4,0x80,0x04,0x02,0x00]

v_cmpx_nlg_f64_e64 -1, v[2:3]
// GFX10: encoding: [0x00,0x00,0x3a,0xd4,0xc1,0x04,0x02,0x00]

v_cmpx_nlg_f64_e64 0.5, v[2:3]
// GFX10: encoding: [0x00,0x00,0x3a,0xd4,0xf0,0x04,0x02,0x00]

v_cmpx_nlg_f64_e64 -4.0, v[2:3]
// GFX10: encoding: [0x00,0x00,0x3a,0xd4,0xf7,0x04,0x02,0x00]

v_cmpx_nlg_f64_e64 v[1:2], v[254:255]
// GFX10: encoding: [0x00,0x00,0x3a,0xd4,0x01,0xfd,0x03,0x00]

v_cmpx_nlg_f64_e64 v[1:2], s[4:5]
// GFX10: encoding: [0x00,0x00,0x3a,0xd4,0x01,0x09,0x00,0x00]

v_cmpx_nlg_f64_e64 v[1:2], s[6:7]
// GFX10: encoding: [0x00,0x00,0x3a,0xd4,0x01,0x0d,0x00,0x00]

v_cmpx_nlg_f64_e64 v[1:2], s[100:101]
// GFX10: encoding: [0x00,0x00,0x3a,0xd4,0x01,0xc9,0x00,0x00]

v_cmpx_nlg_f64_e64 v[1:2], vcc
// GFX10: encoding: [0x00,0x00,0x3a,0xd4,0x01,0xd5,0x00,0x00]

v_cmpx_nlg_f64_e64 v[1:2], exec
// GFX10: encoding: [0x00,0x00,0x3a,0xd4,0x01,0xfd,0x00,0x00]

v_cmpx_nlg_f64_e64 v[1:2], 0
// GFX10: encoding: [0x00,0x00,0x3a,0xd4,0x01,0x01,0x01,0x00]

v_cmpx_nlg_f64_e64 v[1:2], -1
// GFX10: encoding: [0x00,0x00,0x3a,0xd4,0x01,0x83,0x01,0x00]

v_cmpx_nlg_f64_e64 v[1:2], 0.5
// GFX10: encoding: [0x00,0x00,0x3a,0xd4,0x01,0xe1,0x01,0x00]

v_cmpx_nlg_f64_e64 v[1:2], -4.0
// GFX10: encoding: [0x00,0x00,0x3a,0xd4,0x01,0xef,0x01,0x00]

v_cmpx_nlg_f64_e64 -v[1:2], v[2:3]
// GFX10: encoding: [0x00,0x00,0x3a,0xd4,0x01,0x05,0x02,0x20]

v_cmpx_nlg_f64_e64 v[1:2], -v[2:3]
// GFX10: encoding: [0x00,0x00,0x3a,0xd4,0x01,0x05,0x02,0x40]

v_cmpx_nlg_f64_e64 -v[1:2], -v[2:3]
// GFX10: encoding: [0x00,0x00,0x3a,0xd4,0x01,0x05,0x02,0x60]

v_cmpx_ngt_f64 v[1:2], v[2:3]
// GFX10: encoding: [0x01,0x05,0x76,0x7c]

v_cmpx_ngt_f64 v[254:255], v[2:3]
// GFX10: encoding: [0xfe,0x05,0x76,0x7c]

v_cmpx_ngt_f64 s[2:3], v[2:3]
// GFX10: encoding: [0x02,0x04,0x76,0x7c]

v_cmpx_ngt_f64 s[4:5], v[2:3]
// GFX10: encoding: [0x04,0x04,0x76,0x7c]

v_cmpx_ngt_f64 s[100:101], v[2:3]
// GFX10: encoding: [0x64,0x04,0x76,0x7c]

v_cmpx_ngt_f64 vcc, v[2:3]
// GFX10: encoding: [0x6a,0x04,0x76,0x7c]

v_cmpx_ngt_f64 exec, v[2:3]
// GFX10: encoding: [0x7e,0x04,0x76,0x7c]

v_cmpx_ngt_f64 0, v[2:3]
// GFX10: encoding: [0x80,0x04,0x76,0x7c]

v_cmpx_ngt_f64 -1, v[2:3]
// GFX10: encoding: [0xc1,0x04,0x76,0x7c]

v_cmpx_ngt_f64 0.5, v[2:3]
// GFX10: encoding: [0xf0,0x04,0x76,0x7c]

v_cmpx_ngt_f64 -4.0, v[2:3]
// GFX10: encoding: [0xf7,0x04,0x76,0x7c]

v_cmpx_ngt_f64 0xaf123456, v[2:3]
// GFX10: encoding: [0xff,0x04,0x76,0x7c,0x56,0x34,0x12,0xaf]

v_cmpx_ngt_f64 0x3f717273, v[2:3]
// GFX10: encoding: [0xff,0x04,0x76,0x7c,0x73,0x72,0x71,0x3f]

v_cmpx_ngt_f64 v[1:2], v[254:255]
// GFX10: encoding: [0x01,0xfd,0x77,0x7c]

v_cmpx_ngt_f64_e64 v[1:2], v[2:3]
// GFX10: encoding: [0x00,0x00,0x3b,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_ngt_f64_e64 exec, v[1:2]
// GFX10: encoding: [0x00,0x00,0x3b,0xd4,0x7e,0x02,0x02,0x00]

v_cmpx_ngt_f64_e64 v[254:255], v[2:3]
// GFX10: encoding: [0x00,0x00,0x3b,0xd4,0xfe,0x05,0x02,0x00]

v_cmpx_ngt_f64_e64 s[2:3], v[2:3]
// GFX10: encoding: [0x00,0x00,0x3b,0xd4,0x02,0x04,0x02,0x00]

v_cmpx_ngt_f64_e64 s[4:5], v[2:3]
// GFX10: encoding: [0x00,0x00,0x3b,0xd4,0x04,0x04,0x02,0x00]

v_cmpx_ngt_f64_e64 exec, v[2:3]
// GFX10: encoding: [0x00,0x00,0x3b,0xd4,0x7e,0x04,0x02,0x00]

v_cmpx_ngt_f64_e64 vcc, v[2:3]
// GFX10: encoding: [0x00,0x00,0x3b,0xd4,0x6a,0x04,0x02,0x00]

v_cmpx_ngt_f64_e64 0, v[2:3]
// GFX10: encoding: [0x00,0x00,0x3b,0xd4,0x80,0x04,0x02,0x00]

v_cmpx_ngt_f64_e64 -1, v[2:3]
// GFX10: encoding: [0x00,0x00,0x3b,0xd4,0xc1,0x04,0x02,0x00]

v_cmpx_ngt_f64_e64 0.5, v[2:3]
// GFX10: encoding: [0x00,0x00,0x3b,0xd4,0xf0,0x04,0x02,0x00]

v_cmpx_ngt_f64_e64 -4.0, v[2:3]
// GFX10: encoding: [0x00,0x00,0x3b,0xd4,0xf7,0x04,0x02,0x00]

v_cmpx_ngt_f64_e64 v[1:2], v[254:255]
// GFX10: encoding: [0x00,0x00,0x3b,0xd4,0x01,0xfd,0x03,0x00]

v_cmpx_ngt_f64_e64 v[1:2], s[4:5]
// GFX10: encoding: [0x00,0x00,0x3b,0xd4,0x01,0x09,0x00,0x00]

v_cmpx_ngt_f64_e64 v[1:2], s[6:7]
// GFX10: encoding: [0x00,0x00,0x3b,0xd4,0x01,0x0d,0x00,0x00]

v_cmpx_ngt_f64_e64 v[1:2], s[100:101]
// GFX10: encoding: [0x00,0x00,0x3b,0xd4,0x01,0xc9,0x00,0x00]

v_cmpx_ngt_f64_e64 v[1:2], vcc
// GFX10: encoding: [0x00,0x00,0x3b,0xd4,0x01,0xd5,0x00,0x00]

v_cmpx_ngt_f64_e64 v[1:2], exec
// GFX10: encoding: [0x00,0x00,0x3b,0xd4,0x01,0xfd,0x00,0x00]

v_cmpx_ngt_f64_e64 v[1:2], 0
// GFX10: encoding: [0x00,0x00,0x3b,0xd4,0x01,0x01,0x01,0x00]

v_cmpx_ngt_f64_e64 v[1:2], -1
// GFX10: encoding: [0x00,0x00,0x3b,0xd4,0x01,0x83,0x01,0x00]

v_cmpx_ngt_f64_e64 v[1:2], 0.5
// GFX10: encoding: [0x00,0x00,0x3b,0xd4,0x01,0xe1,0x01,0x00]

v_cmpx_ngt_f64_e64 v[1:2], -4.0
// GFX10: encoding: [0x00,0x00,0x3b,0xd4,0x01,0xef,0x01,0x00]

v_cmpx_ngt_f64_e64 -v[1:2], v[2:3]
// GFX10: encoding: [0x00,0x00,0x3b,0xd4,0x01,0x05,0x02,0x20]

v_cmpx_ngt_f64_e64 v[1:2], -v[2:3]
// GFX10: encoding: [0x00,0x00,0x3b,0xd4,0x01,0x05,0x02,0x40]

v_cmpx_ngt_f64_e64 -v[1:2], -v[2:3]
// GFX10: encoding: [0x00,0x00,0x3b,0xd4,0x01,0x05,0x02,0x60]

v_cmpx_nle_f64 v[1:2], v[2:3]
// GFX10: encoding: [0x01,0x05,0x78,0x7c]

v_cmpx_nle_f64 v[254:255], v[2:3]
// GFX10: encoding: [0xfe,0x05,0x78,0x7c]

v_cmpx_nle_f64 s[2:3], v[2:3]
// GFX10: encoding: [0x02,0x04,0x78,0x7c]

v_cmpx_nle_f64 s[4:5], v[2:3]
// GFX10: encoding: [0x04,0x04,0x78,0x7c]

v_cmpx_nle_f64 s[100:101], v[2:3]
// GFX10: encoding: [0x64,0x04,0x78,0x7c]

v_cmpx_nle_f64 vcc, v[2:3]
// GFX10: encoding: [0x6a,0x04,0x78,0x7c]

v_cmpx_nle_f64 exec, v[2:3]
// GFX10: encoding: [0x7e,0x04,0x78,0x7c]

v_cmpx_nle_f64 0, v[2:3]
// GFX10: encoding: [0x80,0x04,0x78,0x7c]

v_cmpx_nle_f64 -1, v[2:3]
// GFX10: encoding: [0xc1,0x04,0x78,0x7c]

v_cmpx_nle_f64 0.5, v[2:3]
// GFX10: encoding: [0xf0,0x04,0x78,0x7c]

v_cmpx_nle_f64 -4.0, v[2:3]
// GFX10: encoding: [0xf7,0x04,0x78,0x7c]

v_cmpx_nle_f64 0xaf123456, v[2:3]
// GFX10: encoding: [0xff,0x04,0x78,0x7c,0x56,0x34,0x12,0xaf]

v_cmpx_nle_f64 0x3f717273, v[2:3]
// GFX10: encoding: [0xff,0x04,0x78,0x7c,0x73,0x72,0x71,0x3f]

v_cmpx_nle_f64 v[1:2], v[254:255]
// GFX10: encoding: [0x01,0xfd,0x79,0x7c]

v_cmpx_nle_f64_e64 v[1:2], v[2:3]
// GFX10: encoding: [0x00,0x00,0x3c,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_nle_f64_e64 exec, v[1:2]
// GFX10: encoding: [0x00,0x00,0x3c,0xd4,0x7e,0x02,0x02,0x00]

v_cmpx_nle_f64_e64 v[254:255], v[2:3]
// GFX10: encoding: [0x00,0x00,0x3c,0xd4,0xfe,0x05,0x02,0x00]

v_cmpx_nle_f64_e64 s[2:3], v[2:3]
// GFX10: encoding: [0x00,0x00,0x3c,0xd4,0x02,0x04,0x02,0x00]

v_cmpx_nle_f64_e64 s[4:5], v[2:3]
// GFX10: encoding: [0x00,0x00,0x3c,0xd4,0x04,0x04,0x02,0x00]

v_cmpx_nle_f64_e64 exec, v[2:3]
// GFX10: encoding: [0x00,0x00,0x3c,0xd4,0x7e,0x04,0x02,0x00]

v_cmpx_nle_f64_e64 vcc, v[2:3]
// GFX10: encoding: [0x00,0x00,0x3c,0xd4,0x6a,0x04,0x02,0x00]

v_cmpx_nle_f64_e64 0, v[2:3]
// GFX10: encoding: [0x00,0x00,0x3c,0xd4,0x80,0x04,0x02,0x00]

v_cmpx_nle_f64_e64 -1, v[2:3]
// GFX10: encoding: [0x00,0x00,0x3c,0xd4,0xc1,0x04,0x02,0x00]

v_cmpx_nle_f64_e64 0.5, v[2:3]
// GFX10: encoding: [0x00,0x00,0x3c,0xd4,0xf0,0x04,0x02,0x00]

v_cmpx_nle_f64_e64 -4.0, v[2:3]
// GFX10: encoding: [0x00,0x00,0x3c,0xd4,0xf7,0x04,0x02,0x00]

v_cmpx_nle_f64_e64 v[1:2], v[254:255]
// GFX10: encoding: [0x00,0x00,0x3c,0xd4,0x01,0xfd,0x03,0x00]

v_cmpx_nle_f64_e64 v[1:2], s[4:5]
// GFX10: encoding: [0x00,0x00,0x3c,0xd4,0x01,0x09,0x00,0x00]

v_cmpx_nle_f64_e64 v[1:2], s[6:7]
// GFX10: encoding: [0x00,0x00,0x3c,0xd4,0x01,0x0d,0x00,0x00]

v_cmpx_nle_f64_e64 v[1:2], s[100:101]
// GFX10: encoding: [0x00,0x00,0x3c,0xd4,0x01,0xc9,0x00,0x00]

v_cmpx_nle_f64_e64 v[1:2], vcc
// GFX10: encoding: [0x00,0x00,0x3c,0xd4,0x01,0xd5,0x00,0x00]

v_cmpx_nle_f64_e64 v[1:2], exec
// GFX10: encoding: [0x00,0x00,0x3c,0xd4,0x01,0xfd,0x00,0x00]

v_cmpx_nle_f64_e64 v[1:2], 0
// GFX10: encoding: [0x00,0x00,0x3c,0xd4,0x01,0x01,0x01,0x00]

v_cmpx_nle_f64_e64 v[1:2], -1
// GFX10: encoding: [0x00,0x00,0x3c,0xd4,0x01,0x83,0x01,0x00]

v_cmpx_nle_f64_e64 v[1:2], 0.5
// GFX10: encoding: [0x00,0x00,0x3c,0xd4,0x01,0xe1,0x01,0x00]

v_cmpx_nle_f64_e64 v[1:2], -4.0
// GFX10: encoding: [0x00,0x00,0x3c,0xd4,0x01,0xef,0x01,0x00]

v_cmpx_nle_f64_e64 -v[1:2], v[2:3]
// GFX10: encoding: [0x00,0x00,0x3c,0xd4,0x01,0x05,0x02,0x20]

v_cmpx_nle_f64_e64 v[1:2], -v[2:3]
// GFX10: encoding: [0x00,0x00,0x3c,0xd4,0x01,0x05,0x02,0x40]

v_cmpx_nle_f64_e64 -v[1:2], -v[2:3]
// GFX10: encoding: [0x00,0x00,0x3c,0xd4,0x01,0x05,0x02,0x60]

v_cmpx_neq_f64 v[1:2], v[2:3]
// GFX10: encoding: [0x01,0x05,0x7a,0x7c]

v_cmpx_neq_f64 v[254:255], v[2:3]
// GFX10: encoding: [0xfe,0x05,0x7a,0x7c]

v_cmpx_neq_f64 s[2:3], v[2:3]
// GFX10: encoding: [0x02,0x04,0x7a,0x7c]

v_cmpx_neq_f64 s[4:5], v[2:3]
// GFX10: encoding: [0x04,0x04,0x7a,0x7c]

v_cmpx_neq_f64 s[100:101], v[2:3]
// GFX10: encoding: [0x64,0x04,0x7a,0x7c]

v_cmpx_neq_f64 vcc, v[2:3]
// GFX10: encoding: [0x6a,0x04,0x7a,0x7c]

v_cmpx_neq_f64 exec, v[2:3]
// GFX10: encoding: [0x7e,0x04,0x7a,0x7c]

v_cmpx_neq_f64 0, v[2:3]
// GFX10: encoding: [0x80,0x04,0x7a,0x7c]

v_cmpx_neq_f64 -1, v[2:3]
// GFX10: encoding: [0xc1,0x04,0x7a,0x7c]

v_cmpx_neq_f64 0.5, v[2:3]
// GFX10: encoding: [0xf0,0x04,0x7a,0x7c]

v_cmpx_neq_f64 -4.0, v[2:3]
// GFX10: encoding: [0xf7,0x04,0x7a,0x7c]

v_cmpx_neq_f64 0xaf123456, v[2:3]
// GFX10: encoding: [0xff,0x04,0x7a,0x7c,0x56,0x34,0x12,0xaf]

v_cmpx_neq_f64 0x3f717273, v[2:3]
// GFX10: encoding: [0xff,0x04,0x7a,0x7c,0x73,0x72,0x71,0x3f]

v_cmpx_neq_f64 v[1:2], v[254:255]
// GFX10: encoding: [0x01,0xfd,0x7b,0x7c]

v_cmpx_neq_f64_e64 v[1:2], v[2:3]
// GFX10: encoding: [0x00,0x00,0x3d,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_neq_f64_e64 exec, v[1:2]
// GFX10: encoding: [0x00,0x00,0x3d,0xd4,0x7e,0x02,0x02,0x00]

v_cmpx_neq_f64_e64 v[254:255], v[2:3]
// GFX10: encoding: [0x00,0x00,0x3d,0xd4,0xfe,0x05,0x02,0x00]

v_cmpx_neq_f64_e64 s[2:3], v[2:3]
// GFX10: encoding: [0x00,0x00,0x3d,0xd4,0x02,0x04,0x02,0x00]

v_cmpx_neq_f64_e64 s[4:5], v[2:3]
// GFX10: encoding: [0x00,0x00,0x3d,0xd4,0x04,0x04,0x02,0x00]

v_cmpx_neq_f64_e64 exec, v[2:3]
// GFX10: encoding: [0x00,0x00,0x3d,0xd4,0x7e,0x04,0x02,0x00]

v_cmpx_neq_f64_e64 vcc, v[2:3]
// GFX10: encoding: [0x00,0x00,0x3d,0xd4,0x6a,0x04,0x02,0x00]

v_cmpx_neq_f64_e64 0, v[2:3]
// GFX10: encoding: [0x00,0x00,0x3d,0xd4,0x80,0x04,0x02,0x00]

v_cmpx_neq_f64_e64 -1, v[2:3]
// GFX10: encoding: [0x00,0x00,0x3d,0xd4,0xc1,0x04,0x02,0x00]

v_cmpx_neq_f64_e64 0.5, v[2:3]
// GFX10: encoding: [0x00,0x00,0x3d,0xd4,0xf0,0x04,0x02,0x00]

v_cmpx_neq_f64_e64 -4.0, v[2:3]
// GFX10: encoding: [0x00,0x00,0x3d,0xd4,0xf7,0x04,0x02,0x00]

v_cmpx_neq_f64_e64 v[1:2], v[254:255]
// GFX10: encoding: [0x00,0x00,0x3d,0xd4,0x01,0xfd,0x03,0x00]

v_cmpx_neq_f64_e64 v[1:2], s[4:5]
// GFX10: encoding: [0x00,0x00,0x3d,0xd4,0x01,0x09,0x00,0x00]

v_cmpx_neq_f64_e64 v[1:2], s[6:7]
// GFX10: encoding: [0x00,0x00,0x3d,0xd4,0x01,0x0d,0x00,0x00]

v_cmpx_neq_f64_e64 v[1:2], s[100:101]
// GFX10: encoding: [0x00,0x00,0x3d,0xd4,0x01,0xc9,0x00,0x00]

v_cmpx_neq_f64_e64 v[1:2], vcc
// GFX10: encoding: [0x00,0x00,0x3d,0xd4,0x01,0xd5,0x00,0x00]

v_cmpx_neq_f64_e64 v[1:2], exec
// GFX10: encoding: [0x00,0x00,0x3d,0xd4,0x01,0xfd,0x00,0x00]

v_cmpx_neq_f64_e64 v[1:2], 0
// GFX10: encoding: [0x00,0x00,0x3d,0xd4,0x01,0x01,0x01,0x00]

v_cmpx_neq_f64_e64 v[1:2], -1
// GFX10: encoding: [0x00,0x00,0x3d,0xd4,0x01,0x83,0x01,0x00]

v_cmpx_neq_f64_e64 v[1:2], 0.5
// GFX10: encoding: [0x00,0x00,0x3d,0xd4,0x01,0xe1,0x01,0x00]

v_cmpx_neq_f64_e64 v[1:2], -4.0
// GFX10: encoding: [0x00,0x00,0x3d,0xd4,0x01,0xef,0x01,0x00]

v_cmpx_neq_f64_e64 -v[1:2], v[2:3]
// GFX10: encoding: [0x00,0x00,0x3d,0xd4,0x01,0x05,0x02,0x20]

v_cmpx_neq_f64_e64 v[1:2], -v[2:3]
// GFX10: encoding: [0x00,0x00,0x3d,0xd4,0x01,0x05,0x02,0x40]

v_cmpx_neq_f64_e64 -v[1:2], -v[2:3]
// GFX10: encoding: [0x00,0x00,0x3d,0xd4,0x01,0x05,0x02,0x60]

v_cmpx_nlt_f64 v[1:2], v[2:3]
// GFX10: encoding: [0x01,0x05,0x7c,0x7c]

v_cmpx_nlt_f64 v[254:255], v[2:3]
// GFX10: encoding: [0xfe,0x05,0x7c,0x7c]

v_cmpx_nlt_f64 s[2:3], v[2:3]
// GFX10: encoding: [0x02,0x04,0x7c,0x7c]

v_cmpx_nlt_f64 s[4:5], v[2:3]
// GFX10: encoding: [0x04,0x04,0x7c,0x7c]

v_cmpx_nlt_f64 s[100:101], v[2:3]
// GFX10: encoding: [0x64,0x04,0x7c,0x7c]

v_cmpx_nlt_f64 vcc, v[2:3]
// GFX10: encoding: [0x6a,0x04,0x7c,0x7c]

v_cmpx_nlt_f64 exec, v[2:3]
// GFX10: encoding: [0x7e,0x04,0x7c,0x7c]

v_cmpx_nlt_f64 0, v[2:3]
// GFX10: encoding: [0x80,0x04,0x7c,0x7c]

v_cmpx_nlt_f64 -1, v[2:3]
// GFX10: encoding: [0xc1,0x04,0x7c,0x7c]

v_cmpx_nlt_f64 0.5, v[2:3]
// GFX10: encoding: [0xf0,0x04,0x7c,0x7c]

v_cmpx_nlt_f64 -4.0, v[2:3]
// GFX10: encoding: [0xf7,0x04,0x7c,0x7c]

v_cmpx_nlt_f64 0xaf123456, v[2:3]
// GFX10: encoding: [0xff,0x04,0x7c,0x7c,0x56,0x34,0x12,0xaf]

v_cmpx_nlt_f64 0x3f717273, v[2:3]
// GFX10: encoding: [0xff,0x04,0x7c,0x7c,0x73,0x72,0x71,0x3f]

v_cmpx_nlt_f64 v[1:2], v[254:255]
// GFX10: encoding: [0x01,0xfd,0x7d,0x7c]

v_cmpx_nlt_f64_e64 v[1:2], v[2:3]
// GFX10: encoding: [0x00,0x00,0x3e,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_nlt_f64_e64 exec, v[1:2]
// GFX10: encoding: [0x00,0x00,0x3e,0xd4,0x7e,0x02,0x02,0x00]

v_cmpx_nlt_f64_e64 v[254:255], v[2:3]
// GFX10: encoding: [0x00,0x00,0x3e,0xd4,0xfe,0x05,0x02,0x00]

v_cmpx_nlt_f64_e64 s[2:3], v[2:3]
// GFX10: encoding: [0x00,0x00,0x3e,0xd4,0x02,0x04,0x02,0x00]

v_cmpx_nlt_f64_e64 s[4:5], v[2:3]
// GFX10: encoding: [0x00,0x00,0x3e,0xd4,0x04,0x04,0x02,0x00]

v_cmpx_nlt_f64_e64 exec, v[2:3]
// GFX10: encoding: [0x00,0x00,0x3e,0xd4,0x7e,0x04,0x02,0x00]

v_cmpx_nlt_f64_e64 vcc, v[2:3]
// GFX10: encoding: [0x00,0x00,0x3e,0xd4,0x6a,0x04,0x02,0x00]

v_cmpx_nlt_f64_e64 0, v[2:3]
// GFX10: encoding: [0x00,0x00,0x3e,0xd4,0x80,0x04,0x02,0x00]

v_cmpx_nlt_f64_e64 -1, v[2:3]
// GFX10: encoding: [0x00,0x00,0x3e,0xd4,0xc1,0x04,0x02,0x00]

v_cmpx_nlt_f64_e64 0.5, v[2:3]
// GFX10: encoding: [0x00,0x00,0x3e,0xd4,0xf0,0x04,0x02,0x00]

v_cmpx_nlt_f64_e64 -4.0, v[2:3]
// GFX10: encoding: [0x00,0x00,0x3e,0xd4,0xf7,0x04,0x02,0x00]

v_cmpx_nlt_f64_e64 v[1:2], v[254:255]
// GFX10: encoding: [0x00,0x00,0x3e,0xd4,0x01,0xfd,0x03,0x00]

v_cmpx_nlt_f64_e64 v[1:2], s[4:5]
// GFX10: encoding: [0x00,0x00,0x3e,0xd4,0x01,0x09,0x00,0x00]

v_cmpx_nlt_f64_e64 v[1:2], s[6:7]
// GFX10: encoding: [0x00,0x00,0x3e,0xd4,0x01,0x0d,0x00,0x00]

v_cmpx_nlt_f64_e64 v[1:2], s[100:101]
// GFX10: encoding: [0x00,0x00,0x3e,0xd4,0x01,0xc9,0x00,0x00]

v_cmpx_nlt_f64_e64 v[1:2], vcc
// GFX10: encoding: [0x00,0x00,0x3e,0xd4,0x01,0xd5,0x00,0x00]

v_cmpx_nlt_f64_e64 v[1:2], exec
// GFX10: encoding: [0x00,0x00,0x3e,0xd4,0x01,0xfd,0x00,0x00]

v_cmpx_nlt_f64_e64 v[1:2], 0
// GFX10: encoding: [0x00,0x00,0x3e,0xd4,0x01,0x01,0x01,0x00]

v_cmpx_nlt_f64_e64 v[1:2], -1
// GFX10: encoding: [0x00,0x00,0x3e,0xd4,0x01,0x83,0x01,0x00]

v_cmpx_nlt_f64_e64 v[1:2], 0.5
// GFX10: encoding: [0x00,0x00,0x3e,0xd4,0x01,0xe1,0x01,0x00]

v_cmpx_nlt_f64_e64 v[1:2], -4.0
// GFX10: encoding: [0x00,0x00,0x3e,0xd4,0x01,0xef,0x01,0x00]

v_cmpx_nlt_f64_e64 -v[1:2], v[2:3]
// GFX10: encoding: [0x00,0x00,0x3e,0xd4,0x01,0x05,0x02,0x20]

v_cmpx_nlt_f64_e64 v[1:2], -v[2:3]
// GFX10: encoding: [0x00,0x00,0x3e,0xd4,0x01,0x05,0x02,0x40]

v_cmpx_nlt_f64_e64 -v[1:2], -v[2:3]
// GFX10: encoding: [0x00,0x00,0x3e,0xd4,0x01,0x05,0x02,0x60]

v_cmpx_tru_f64 v[1:2], v[2:3]
// GFX10: encoding: [0x01,0x05,0x7e,0x7c]

v_cmpx_tru_f64 v[254:255], v[2:3]
// GFX10: encoding: [0xfe,0x05,0x7e,0x7c]

v_cmpx_tru_f64 s[2:3], v[2:3]
// GFX10: encoding: [0x02,0x04,0x7e,0x7c]

v_cmpx_tru_f64 s[4:5], v[2:3]
// GFX10: encoding: [0x04,0x04,0x7e,0x7c]

v_cmpx_tru_f64 s[100:101], v[2:3]
// GFX10: encoding: [0x64,0x04,0x7e,0x7c]

v_cmpx_tru_f64 vcc, v[2:3]
// GFX10: encoding: [0x6a,0x04,0x7e,0x7c]

v_cmpx_tru_f64 exec, v[2:3]
// GFX10: encoding: [0x7e,0x04,0x7e,0x7c]

v_cmpx_tru_f64 0, v[2:3]
// GFX10: encoding: [0x80,0x04,0x7e,0x7c]

v_cmpx_tru_f64 -1, v[2:3]
// GFX10: encoding: [0xc1,0x04,0x7e,0x7c]

v_cmpx_tru_f64 0.5, v[2:3]
// GFX10: encoding: [0xf0,0x04,0x7e,0x7c]

v_cmpx_tru_f64 -4.0, v[2:3]
// GFX10: encoding: [0xf7,0x04,0x7e,0x7c]

v_cmpx_tru_f64 0xaf123456, v[2:3]
// GFX10: encoding: [0xff,0x04,0x7e,0x7c,0x56,0x34,0x12,0xaf]

v_cmpx_tru_f64 0x3f717273, v[2:3]
// GFX10: encoding: [0xff,0x04,0x7e,0x7c,0x73,0x72,0x71,0x3f]

v_cmpx_tru_f64 v[1:2], v[254:255]
// GFX10: encoding: [0x01,0xfd,0x7f,0x7c]

v_cmpx_tru_f64_e64 v[1:2], v[2:3]
// GFX10: encoding: [0x00,0x00,0x3f,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_tru_f64_e64 exec, v[1:2]
// GFX10: encoding: [0x00,0x00,0x3f,0xd4,0x7e,0x02,0x02,0x00]

v_cmpx_tru_f64_e64 v[254:255], v[2:3]
// GFX10: encoding: [0x00,0x00,0x3f,0xd4,0xfe,0x05,0x02,0x00]

v_cmpx_tru_f64_e64 s[2:3], v[2:3]
// GFX10: encoding: [0x00,0x00,0x3f,0xd4,0x02,0x04,0x02,0x00]

v_cmpx_tru_f64_e64 s[4:5], v[2:3]
// GFX10: encoding: [0x00,0x00,0x3f,0xd4,0x04,0x04,0x02,0x00]

v_cmpx_tru_f64_e64 exec, v[2:3]
// GFX10: encoding: [0x00,0x00,0x3f,0xd4,0x7e,0x04,0x02,0x00]

v_cmpx_tru_f64_e64 vcc, v[2:3]
// GFX10: encoding: [0x00,0x00,0x3f,0xd4,0x6a,0x04,0x02,0x00]

v_cmpx_tru_f64_e64 0, v[2:3]
// GFX10: encoding: [0x00,0x00,0x3f,0xd4,0x80,0x04,0x02,0x00]

v_cmpx_tru_f64_e64 -1, v[2:3]
// GFX10: encoding: [0x00,0x00,0x3f,0xd4,0xc1,0x04,0x02,0x00]

v_cmpx_tru_f64_e64 0.5, v[2:3]
// GFX10: encoding: [0x00,0x00,0x3f,0xd4,0xf0,0x04,0x02,0x00]

v_cmpx_tru_f64_e64 -4.0, v[2:3]
// GFX10: encoding: [0x00,0x00,0x3f,0xd4,0xf7,0x04,0x02,0x00]

v_cmpx_tru_f64_e64 v[1:2], v[254:255]
// GFX10: encoding: [0x00,0x00,0x3f,0xd4,0x01,0xfd,0x03,0x00]

v_cmpx_tru_f64_e64 v[1:2], s[4:5]
// GFX10: encoding: [0x00,0x00,0x3f,0xd4,0x01,0x09,0x00,0x00]

v_cmpx_tru_f64_e64 v[1:2], s[6:7]
// GFX10: encoding: [0x00,0x00,0x3f,0xd4,0x01,0x0d,0x00,0x00]

v_cmpx_tru_f64_e64 v[1:2], s[100:101]
// GFX10: encoding: [0x00,0x00,0x3f,0xd4,0x01,0xc9,0x00,0x00]

v_cmpx_tru_f64_e64 v[1:2], vcc
// GFX10: encoding: [0x00,0x00,0x3f,0xd4,0x01,0xd5,0x00,0x00]

v_cmpx_tru_f64_e64 v[1:2], exec
// GFX10: encoding: [0x00,0x00,0x3f,0xd4,0x01,0xfd,0x00,0x00]

v_cmpx_tru_f64_e64 v[1:2], 0
// GFX10: encoding: [0x00,0x00,0x3f,0xd4,0x01,0x01,0x01,0x00]

v_cmpx_tru_f64_e64 v[1:2], -1
// GFX10: encoding: [0x00,0x00,0x3f,0xd4,0x01,0x83,0x01,0x00]

v_cmpx_tru_f64_e64 v[1:2], 0.5
// GFX10: encoding: [0x00,0x00,0x3f,0xd4,0x01,0xe1,0x01,0x00]

v_cmpx_tru_f64_e64 v[1:2], -4.0
// GFX10: encoding: [0x00,0x00,0x3f,0xd4,0x01,0xef,0x01,0x00]

v_cmpx_tru_f64_e64 -v[1:2], v[2:3]
// GFX10: encoding: [0x00,0x00,0x3f,0xd4,0x01,0x05,0x02,0x20]

v_cmpx_tru_f64_e64 v[1:2], -v[2:3]
// GFX10: encoding: [0x00,0x00,0x3f,0xd4,0x01,0x05,0x02,0x40]

v_cmpx_tru_f64_e64 -v[1:2], -v[2:3]
// GFX10: encoding: [0x00,0x00,0x3f,0xd4,0x01,0x05,0x02,0x60]

v_cmpx_f_i32 v1, v2
// GFX10: encoding: [0x01,0x05,0x20,0x7d]

v_cmpx_f_i32 v255, v2
// GFX10: encoding: [0xff,0x05,0x20,0x7d]

v_cmpx_f_i32 s1, v2
// GFX10: encoding: [0x01,0x04,0x20,0x7d]

v_cmpx_f_i32 s101, v2
// GFX10: encoding: [0x65,0x04,0x20,0x7d]

v_cmpx_f_i32 vcc_lo, v2
// GFX10: encoding: [0x6a,0x04,0x20,0x7d]

v_cmpx_f_i32 vcc_hi, v2
// GFX10: encoding: [0x6b,0x04,0x20,0x7d]

v_cmpx_f_i32 m0, v2
// GFX10: encoding: [0x7c,0x04,0x20,0x7d]

v_cmpx_f_i32 exec_lo, v2
// GFX10: encoding: [0x7e,0x04,0x20,0x7d]

v_cmpx_f_i32 exec_hi, v2
// GFX10: encoding: [0x7f,0x04,0x20,0x7d]

v_cmpx_f_i32 0, v2
// GFX10: encoding: [0x80,0x04,0x20,0x7d]

v_cmpx_f_i32 -1, v2
// GFX10: encoding: [0xc1,0x04,0x20,0x7d]

v_cmpx_f_i32 0.5, v2
// GFX10: encoding: [0xf0,0x04,0x20,0x7d]

v_cmpx_f_i32 -4.0, v2
// GFX10: encoding: [0xf7,0x04,0x20,0x7d]

v_cmpx_f_i32 0xaf123456, v2
// GFX10: encoding: [0xff,0x04,0x20,0x7d,0x56,0x34,0x12,0xaf]

v_cmpx_f_i32 0x3f717273, v2
// GFX10: encoding: [0xff,0x04,0x20,0x7d,0x73,0x72,0x71,0x3f]

v_cmpx_f_i32 v1, v255
// GFX10: encoding: [0x01,0xff,0x21,0x7d]

v_cmpx_f_i32_e64 v1, v2
// GFX10: encoding: [0x00,0x00,0x90,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_f_i32_e64 v255, v2
// GFX10: encoding: [0x00,0x00,0x90,0xd4,0xff,0x05,0x02,0x00]

v_cmpx_f_i32_e64 s1, v2
// GFX10: encoding: [0x00,0x00,0x90,0xd4,0x01,0x04,0x02,0x00]

v_cmpx_f_i32_e64 s101, v2
// GFX10: encoding: [0x00,0x00,0x90,0xd4,0x65,0x04,0x02,0x00]

v_cmpx_f_i32_e64 vcc_lo, v2
// GFX10: encoding: [0x00,0x00,0x90,0xd4,0x6a,0x04,0x02,0x00]

v_cmpx_f_i32_e64 vcc_hi, v2
// GFX10: encoding: [0x00,0x00,0x90,0xd4,0x6b,0x04,0x02,0x00]

v_cmpx_f_i32_e64 m0, v2
// GFX10: encoding: [0x00,0x00,0x90,0xd4,0x7c,0x04,0x02,0x00]

v_cmpx_f_i32_e64 exec_lo, v2
// GFX10: encoding: [0x00,0x00,0x90,0xd4,0x7e,0x04,0x02,0x00]

v_cmpx_f_i32_e64 exec_hi, v2
// GFX10: encoding: [0x00,0x00,0x90,0xd4,0x7f,0x04,0x02,0x00]

v_cmpx_f_i32_e64 0, v2
// GFX10: encoding: [0x00,0x00,0x90,0xd4,0x80,0x04,0x02,0x00]

v_cmpx_f_i32_e64 -1, v2
// GFX10: encoding: [0x00,0x00,0x90,0xd4,0xc1,0x04,0x02,0x00]

v_cmpx_f_i32_e64 0.5, v2
// GFX10: encoding: [0x00,0x00,0x90,0xd4,0xf0,0x04,0x02,0x00]

v_cmpx_f_i32_e64 -4.0, v2
// GFX10: encoding: [0x00,0x00,0x90,0xd4,0xf7,0x04,0x02,0x00]

v_cmpx_f_i32_e64 v1, v255
// GFX10: encoding: [0x00,0x00,0x90,0xd4,0x01,0xff,0x03,0x00]

v_cmpx_f_i32_e64 v1, s2
// GFX10: encoding: [0x00,0x00,0x90,0xd4,0x01,0x05,0x00,0x00]

v_cmpx_f_i32_e64 v1, s101
// GFX10: encoding: [0x00,0x00,0x90,0xd4,0x01,0xcb,0x00,0x00]

v_cmpx_f_i32_e64 v1, vcc_lo
// GFX10: encoding: [0x00,0x00,0x90,0xd4,0x01,0xd5,0x00,0x00]

v_cmpx_f_i32_e64 v1, vcc_hi
// GFX10: encoding: [0x00,0x00,0x90,0xd4,0x01,0xd7,0x00,0x00]

v_cmpx_f_i32_e64 v1, m0
// GFX10: encoding: [0x00,0x00,0x90,0xd4,0x01,0xf9,0x00,0x00]

v_cmpx_f_i32_e64 v1, exec_lo
// GFX10: encoding: [0x00,0x00,0x90,0xd4,0x01,0xfd,0x00,0x00]

v_cmpx_f_i32_e64 v1, exec_hi
// GFX10: encoding: [0x00,0x00,0x90,0xd4,0x01,0xff,0x00,0x00]

v_cmpx_f_i32_e64 v1, 0
// GFX10: encoding: [0x00,0x00,0x90,0xd4,0x01,0x01,0x01,0x00]

v_cmpx_f_i32_e64 v1, -1
// GFX10: encoding: [0x00,0x00,0x90,0xd4,0x01,0x83,0x01,0x00]

v_cmpx_f_i32_e64 v1, 0.5
// GFX10: encoding: [0x00,0x00,0x90,0xd4,0x01,0xe1,0x01,0x00]

v_cmpx_f_i32_e64 v1, -4.0
// GFX10: encoding: [0x00,0x00,0x90,0xd4,0x01,0xef,0x01,0x00]

v_cmpx_lt_i32 v1, v2
// GFX10: encoding: [0x01,0x05,0x22,0x7d]

v_cmpx_lt_i32 v255, v2
// GFX10: encoding: [0xff,0x05,0x22,0x7d]

v_cmpx_lt_i32 s1, v2
// GFX10: encoding: [0x01,0x04,0x22,0x7d]

v_cmpx_lt_i32 s101, v2
// GFX10: encoding: [0x65,0x04,0x22,0x7d]

v_cmpx_lt_i32 vcc_lo, v2
// GFX10: encoding: [0x6a,0x04,0x22,0x7d]

v_cmpx_lt_i32 vcc_hi, v2
// GFX10: encoding: [0x6b,0x04,0x22,0x7d]

v_cmpx_lt_i32 m0, v2
// GFX10: encoding: [0x7c,0x04,0x22,0x7d]

v_cmpx_lt_i32 exec_lo, v2
// GFX10: encoding: [0x7e,0x04,0x22,0x7d]

v_cmpx_lt_i32 exec_hi, v2
// GFX10: encoding: [0x7f,0x04,0x22,0x7d]

v_cmpx_lt_i32 0, v2
// GFX10: encoding: [0x80,0x04,0x22,0x7d]

v_cmpx_lt_i32 -1, v2
// GFX10: encoding: [0xc1,0x04,0x22,0x7d]

v_cmpx_lt_i32 0.5, v2
// GFX10: encoding: [0xf0,0x04,0x22,0x7d]

v_cmpx_lt_i32 -4.0, v2
// GFX10: encoding: [0xf7,0x04,0x22,0x7d]

v_cmpx_lt_i32 0xaf123456, v2
// GFX10: encoding: [0xff,0x04,0x22,0x7d,0x56,0x34,0x12,0xaf]

v_cmpx_lt_i32 0x3f717273, v2
// GFX10: encoding: [0xff,0x04,0x22,0x7d,0x73,0x72,0x71,0x3f]

v_cmpx_lt_i32 v1, v255
// GFX10: encoding: [0x01,0xff,0x23,0x7d]

v_cmpx_lt_i32_e64 v1, v2
// GFX10: encoding: [0x00,0x00,0x91,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_lt_i32_e64 v255, v2
// GFX10: encoding: [0x00,0x00,0x91,0xd4,0xff,0x05,0x02,0x00]

v_cmpx_lt_i32_e64 s1, v2
// GFX10: encoding: [0x00,0x00,0x91,0xd4,0x01,0x04,0x02,0x00]

v_cmpx_lt_i32_e64 s101, v2
// GFX10: encoding: [0x00,0x00,0x91,0xd4,0x65,0x04,0x02,0x00]

v_cmpx_lt_i32_e64 vcc_lo, v2
// GFX10: encoding: [0x00,0x00,0x91,0xd4,0x6a,0x04,0x02,0x00]

v_cmpx_lt_i32_e64 vcc_hi, v2
// GFX10: encoding: [0x00,0x00,0x91,0xd4,0x6b,0x04,0x02,0x00]

v_cmpx_lt_i32_e64 m0, v2
// GFX10: encoding: [0x00,0x00,0x91,0xd4,0x7c,0x04,0x02,0x00]

v_cmpx_lt_i32_e64 exec_lo, v2
// GFX10: encoding: [0x00,0x00,0x91,0xd4,0x7e,0x04,0x02,0x00]

v_cmpx_lt_i32_e64 exec_hi, v2
// GFX10: encoding: [0x00,0x00,0x91,0xd4,0x7f,0x04,0x02,0x00]

v_cmpx_lt_i32_e64 0, v2
// GFX10: encoding: [0x00,0x00,0x91,0xd4,0x80,0x04,0x02,0x00]

v_cmpx_lt_i32_e64 -1, v2
// GFX10: encoding: [0x00,0x00,0x91,0xd4,0xc1,0x04,0x02,0x00]

v_cmpx_lt_i32_e64 0.5, v2
// GFX10: encoding: [0x00,0x00,0x91,0xd4,0xf0,0x04,0x02,0x00]

v_cmpx_lt_i32_e64 -4.0, v2
// GFX10: encoding: [0x00,0x00,0x91,0xd4,0xf7,0x04,0x02,0x00]

v_cmpx_lt_i32_e64 v1, v255
// GFX10: encoding: [0x00,0x00,0x91,0xd4,0x01,0xff,0x03,0x00]

v_cmpx_lt_i32_e64 v1, s2
// GFX10: encoding: [0x00,0x00,0x91,0xd4,0x01,0x05,0x00,0x00]

v_cmpx_lt_i32_e64 v1, s101
// GFX10: encoding: [0x00,0x00,0x91,0xd4,0x01,0xcb,0x00,0x00]

v_cmpx_lt_i32_e64 v1, vcc_lo
// GFX10: encoding: [0x00,0x00,0x91,0xd4,0x01,0xd5,0x00,0x00]

v_cmpx_lt_i32_e64 v1, vcc_hi
// GFX10: encoding: [0x00,0x00,0x91,0xd4,0x01,0xd7,0x00,0x00]

v_cmpx_lt_i32_e64 v1, m0
// GFX10: encoding: [0x00,0x00,0x91,0xd4,0x01,0xf9,0x00,0x00]

v_cmpx_lt_i32_e64 v1, exec_lo
// GFX10: encoding: [0x00,0x00,0x91,0xd4,0x01,0xfd,0x00,0x00]

v_cmpx_lt_i32_e64 v1, exec_hi
// GFX10: encoding: [0x00,0x00,0x91,0xd4,0x01,0xff,0x00,0x00]

v_cmpx_lt_i32_e64 v1, 0
// GFX10: encoding: [0x00,0x00,0x91,0xd4,0x01,0x01,0x01,0x00]

v_cmpx_lt_i32_e64 v1, -1
// GFX10: encoding: [0x00,0x00,0x91,0xd4,0x01,0x83,0x01,0x00]

v_cmpx_lt_i32_e64 v1, 0.5
// GFX10: encoding: [0x00,0x00,0x91,0xd4,0x01,0xe1,0x01,0x00]

v_cmpx_lt_i32_e64 v1, -4.0
// GFX10: encoding: [0x00,0x00,0x91,0xd4,0x01,0xef,0x01,0x00]

v_cmpx_eq_i32 v1, v2
// GFX10: encoding: [0x01,0x05,0x24,0x7d]

v_cmpx_eq_i32 v255, v2
// GFX10: encoding: [0xff,0x05,0x24,0x7d]

v_cmpx_eq_i32 s1, v2
// GFX10: encoding: [0x01,0x04,0x24,0x7d]

v_cmpx_eq_i32 s101, v2
// GFX10: encoding: [0x65,0x04,0x24,0x7d]

v_cmpx_eq_i32 vcc_lo, v2
// GFX10: encoding: [0x6a,0x04,0x24,0x7d]

v_cmpx_eq_i32 vcc_hi, v2
// GFX10: encoding: [0x6b,0x04,0x24,0x7d]

v_cmpx_eq_i32 m0, v2
// GFX10: encoding: [0x7c,0x04,0x24,0x7d]

v_cmpx_eq_i32 exec_lo, v2
// GFX10: encoding: [0x7e,0x04,0x24,0x7d]

v_cmpx_eq_i32 exec_hi, v2
// GFX10: encoding: [0x7f,0x04,0x24,0x7d]

v_cmpx_eq_i32 0, v2
// GFX10: encoding: [0x80,0x04,0x24,0x7d]

v_cmpx_eq_i32 -1, v2
// GFX10: encoding: [0xc1,0x04,0x24,0x7d]

v_cmpx_eq_i32 0.5, v2
// GFX10: encoding: [0xf0,0x04,0x24,0x7d]

v_cmpx_eq_i32 -4.0, v2
// GFX10: encoding: [0xf7,0x04,0x24,0x7d]

v_cmpx_eq_i32 0xaf123456, v2
// GFX10: encoding: [0xff,0x04,0x24,0x7d,0x56,0x34,0x12,0xaf]

v_cmpx_eq_i32 0x3f717273, v2
// GFX10: encoding: [0xff,0x04,0x24,0x7d,0x73,0x72,0x71,0x3f]

v_cmpx_eq_i32 v1, v255
// GFX10: encoding: [0x01,0xff,0x25,0x7d]

v_cmpx_eq_i32_e64 v1, v2
// GFX10: encoding: [0x00,0x00,0x92,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_eq_i32_e64 v255, v2
// GFX10: encoding: [0x00,0x00,0x92,0xd4,0xff,0x05,0x02,0x00]

v_cmpx_eq_i32_e64 s1, v2
// GFX10: encoding: [0x00,0x00,0x92,0xd4,0x01,0x04,0x02,0x00]

v_cmpx_eq_i32_e64 s101, v2
// GFX10: encoding: [0x00,0x00,0x92,0xd4,0x65,0x04,0x02,0x00]

v_cmpx_eq_i32_e64 vcc_lo, v2
// GFX10: encoding: [0x00,0x00,0x92,0xd4,0x6a,0x04,0x02,0x00]

v_cmpx_eq_i32_e64 vcc_hi, v2
// GFX10: encoding: [0x00,0x00,0x92,0xd4,0x6b,0x04,0x02,0x00]

v_cmpx_eq_i32_e64 m0, v2
// GFX10: encoding: [0x00,0x00,0x92,0xd4,0x7c,0x04,0x02,0x00]

v_cmpx_eq_i32_e64 exec_lo, v2
// GFX10: encoding: [0x00,0x00,0x92,0xd4,0x7e,0x04,0x02,0x00]

v_cmpx_eq_i32_e64 exec_hi, v2
// GFX10: encoding: [0x00,0x00,0x92,0xd4,0x7f,0x04,0x02,0x00]

v_cmpx_eq_i32_e64 0, v2
// GFX10: encoding: [0x00,0x00,0x92,0xd4,0x80,0x04,0x02,0x00]

v_cmpx_eq_i32_e64 -1, v2
// GFX10: encoding: [0x00,0x00,0x92,0xd4,0xc1,0x04,0x02,0x00]

v_cmpx_eq_i32_e64 0.5, v2
// GFX10: encoding: [0x00,0x00,0x92,0xd4,0xf0,0x04,0x02,0x00]

v_cmpx_eq_i32_e64 -4.0, v2
// GFX10: encoding: [0x00,0x00,0x92,0xd4,0xf7,0x04,0x02,0x00]

v_cmpx_eq_i32_e64 v1, v255
// GFX10: encoding: [0x00,0x00,0x92,0xd4,0x01,0xff,0x03,0x00]

v_cmpx_eq_i32_e64 v1, s2
// GFX10: encoding: [0x00,0x00,0x92,0xd4,0x01,0x05,0x00,0x00]

v_cmpx_eq_i32_e64 v1, s101
// GFX10: encoding: [0x00,0x00,0x92,0xd4,0x01,0xcb,0x00,0x00]

v_cmpx_eq_i32_e64 v1, vcc_lo
// GFX10: encoding: [0x00,0x00,0x92,0xd4,0x01,0xd5,0x00,0x00]

v_cmpx_eq_i32_e64 v1, vcc_hi
// GFX10: encoding: [0x00,0x00,0x92,0xd4,0x01,0xd7,0x00,0x00]

v_cmpx_eq_i32_e64 v1, m0
// GFX10: encoding: [0x00,0x00,0x92,0xd4,0x01,0xf9,0x00,0x00]

v_cmpx_eq_i32_e64 v1, exec_lo
// GFX10: encoding: [0x00,0x00,0x92,0xd4,0x01,0xfd,0x00,0x00]

v_cmpx_eq_i32_e64 v1, exec_hi
// GFX10: encoding: [0x00,0x00,0x92,0xd4,0x01,0xff,0x00,0x00]

v_cmpx_eq_i32_e64 v1, 0
// GFX10: encoding: [0x00,0x00,0x92,0xd4,0x01,0x01,0x01,0x00]

v_cmpx_eq_i32_e64 v1, -1
// GFX10: encoding: [0x00,0x00,0x92,0xd4,0x01,0x83,0x01,0x00]

v_cmpx_eq_i32_e64 v1, 0.5
// GFX10: encoding: [0x00,0x00,0x92,0xd4,0x01,0xe1,0x01,0x00]

v_cmpx_eq_i32_e64 v1, -4.0
// GFX10: encoding: [0x00,0x00,0x92,0xd4,0x01,0xef,0x01,0x00]

v_cmpx_le_i32 v1, v2
// GFX10: encoding: [0x01,0x05,0x26,0x7d]

v_cmpx_le_i32 v255, v2
// GFX10: encoding: [0xff,0x05,0x26,0x7d]

v_cmpx_le_i32 s1, v2
// GFX10: encoding: [0x01,0x04,0x26,0x7d]

v_cmpx_le_i32 s101, v2
// GFX10: encoding: [0x65,0x04,0x26,0x7d]

v_cmpx_le_i32 vcc_lo, v2
// GFX10: encoding: [0x6a,0x04,0x26,0x7d]

v_cmpx_le_i32 vcc_hi, v2
// GFX10: encoding: [0x6b,0x04,0x26,0x7d]

v_cmpx_le_i32 m0, v2
// GFX10: encoding: [0x7c,0x04,0x26,0x7d]

v_cmpx_le_i32 exec_lo, v2
// GFX10: encoding: [0x7e,0x04,0x26,0x7d]

v_cmpx_le_i32 exec_hi, v2
// GFX10: encoding: [0x7f,0x04,0x26,0x7d]

v_cmpx_le_i32 0, v2
// GFX10: encoding: [0x80,0x04,0x26,0x7d]

v_cmpx_le_i32 -1, v2
// GFX10: encoding: [0xc1,0x04,0x26,0x7d]

v_cmpx_le_i32 0.5, v2
// GFX10: encoding: [0xf0,0x04,0x26,0x7d]

v_cmpx_le_i32 -4.0, v2
// GFX10: encoding: [0xf7,0x04,0x26,0x7d]

v_cmpx_le_i32 0xaf123456, v2
// GFX10: encoding: [0xff,0x04,0x26,0x7d,0x56,0x34,0x12,0xaf]

v_cmpx_le_i32 0x3f717273, v2
// GFX10: encoding: [0xff,0x04,0x26,0x7d,0x73,0x72,0x71,0x3f]

v_cmpx_le_i32 v1, v255
// GFX10: encoding: [0x01,0xff,0x27,0x7d]

v_cmpx_le_i32_e64 v1, v2
// GFX10: encoding: [0x00,0x00,0x93,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_le_i32_e64 v255, v2
// GFX10: encoding: [0x00,0x00,0x93,0xd4,0xff,0x05,0x02,0x00]

v_cmpx_le_i32_e64 s1, v2
// GFX10: encoding: [0x00,0x00,0x93,0xd4,0x01,0x04,0x02,0x00]

v_cmpx_le_i32_e64 s101, v2
// GFX10: encoding: [0x00,0x00,0x93,0xd4,0x65,0x04,0x02,0x00]

v_cmpx_le_i32_e64 vcc_lo, v2
// GFX10: encoding: [0x00,0x00,0x93,0xd4,0x6a,0x04,0x02,0x00]

v_cmpx_le_i32_e64 vcc_hi, v2
// GFX10: encoding: [0x00,0x00,0x93,0xd4,0x6b,0x04,0x02,0x00]

v_cmpx_le_i32_e64 m0, v2
// GFX10: encoding: [0x00,0x00,0x93,0xd4,0x7c,0x04,0x02,0x00]

v_cmpx_le_i32_e64 exec_lo, v2
// GFX10: encoding: [0x00,0x00,0x93,0xd4,0x7e,0x04,0x02,0x00]

v_cmpx_le_i32_e64 exec_hi, v2
// GFX10: encoding: [0x00,0x00,0x93,0xd4,0x7f,0x04,0x02,0x00]

v_cmpx_le_i32_e64 0, v2
// GFX10: encoding: [0x00,0x00,0x93,0xd4,0x80,0x04,0x02,0x00]

v_cmpx_le_i32_e64 -1, v2
// GFX10: encoding: [0x00,0x00,0x93,0xd4,0xc1,0x04,0x02,0x00]

v_cmpx_le_i32_e64 0.5, v2
// GFX10: encoding: [0x00,0x00,0x93,0xd4,0xf0,0x04,0x02,0x00]

v_cmpx_le_i32_e64 -4.0, v2
// GFX10: encoding: [0x00,0x00,0x93,0xd4,0xf7,0x04,0x02,0x00]

v_cmpx_le_i32_e64 v1, v255
// GFX10: encoding: [0x00,0x00,0x93,0xd4,0x01,0xff,0x03,0x00]

v_cmpx_le_i32_e64 v1, s2
// GFX10: encoding: [0x00,0x00,0x93,0xd4,0x01,0x05,0x00,0x00]

v_cmpx_le_i32_e64 v1, s101
// GFX10: encoding: [0x00,0x00,0x93,0xd4,0x01,0xcb,0x00,0x00]

v_cmpx_le_i32_e64 v1, vcc_lo
// GFX10: encoding: [0x00,0x00,0x93,0xd4,0x01,0xd5,0x00,0x00]

v_cmpx_le_i32_e64 v1, vcc_hi
// GFX10: encoding: [0x00,0x00,0x93,0xd4,0x01,0xd7,0x00,0x00]

v_cmpx_le_i32_e64 v1, m0
// GFX10: encoding: [0x00,0x00,0x93,0xd4,0x01,0xf9,0x00,0x00]

v_cmpx_le_i32_e64 v1, exec_lo
// GFX10: encoding: [0x00,0x00,0x93,0xd4,0x01,0xfd,0x00,0x00]

v_cmpx_le_i32_e64 v1, exec_hi
// GFX10: encoding: [0x00,0x00,0x93,0xd4,0x01,0xff,0x00,0x00]

v_cmpx_le_i32_e64 v1, 0
// GFX10: encoding: [0x00,0x00,0x93,0xd4,0x01,0x01,0x01,0x00]

v_cmpx_le_i32_e64 v1, -1
// GFX10: encoding: [0x00,0x00,0x93,0xd4,0x01,0x83,0x01,0x00]

v_cmpx_le_i32_e64 v1, 0.5
// GFX10: encoding: [0x00,0x00,0x93,0xd4,0x01,0xe1,0x01,0x00]

v_cmpx_le_i32_e64 v1, -4.0
// GFX10: encoding: [0x00,0x00,0x93,0xd4,0x01,0xef,0x01,0x00]

v_cmpx_gt_i32 v1, v2
// GFX10: encoding: [0x01,0x05,0x28,0x7d]

v_cmpx_gt_i32 v255, v2
// GFX10: encoding: [0xff,0x05,0x28,0x7d]

v_cmpx_gt_i32 s1, v2
// GFX10: encoding: [0x01,0x04,0x28,0x7d]

v_cmpx_gt_i32 s101, v2
// GFX10: encoding: [0x65,0x04,0x28,0x7d]

v_cmpx_gt_i32 vcc_lo, v2
// GFX10: encoding: [0x6a,0x04,0x28,0x7d]

v_cmpx_gt_i32 vcc_hi, v2
// GFX10: encoding: [0x6b,0x04,0x28,0x7d]

v_cmpx_gt_i32 m0, v2
// GFX10: encoding: [0x7c,0x04,0x28,0x7d]

v_cmpx_gt_i32 exec_lo, v2
// GFX10: encoding: [0x7e,0x04,0x28,0x7d]

v_cmpx_gt_i32 exec_hi, v2
// GFX10: encoding: [0x7f,0x04,0x28,0x7d]

v_cmpx_gt_i32 0, v2
// GFX10: encoding: [0x80,0x04,0x28,0x7d]

v_cmpx_gt_i32 -1, v2
// GFX10: encoding: [0xc1,0x04,0x28,0x7d]

v_cmpx_gt_i32 0.5, v2
// GFX10: encoding: [0xf0,0x04,0x28,0x7d]

v_cmpx_gt_i32 -4.0, v2
// GFX10: encoding: [0xf7,0x04,0x28,0x7d]

v_cmpx_gt_i32 0xaf123456, v2
// GFX10: encoding: [0xff,0x04,0x28,0x7d,0x56,0x34,0x12,0xaf]

v_cmpx_gt_i32 0x3f717273, v2
// GFX10: encoding: [0xff,0x04,0x28,0x7d,0x73,0x72,0x71,0x3f]

v_cmpx_gt_i32 v1, v255
// GFX10: encoding: [0x01,0xff,0x29,0x7d]

v_cmpx_gt_i32_e64 v1, v2
// GFX10: encoding: [0x00,0x00,0x94,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_gt_i32_e64 v255, v2
// GFX10: encoding: [0x00,0x00,0x94,0xd4,0xff,0x05,0x02,0x00]

v_cmpx_gt_i32_e64 s1, v2
// GFX10: encoding: [0x00,0x00,0x94,0xd4,0x01,0x04,0x02,0x00]

v_cmpx_gt_i32_e64 s101, v2
// GFX10: encoding: [0x00,0x00,0x94,0xd4,0x65,0x04,0x02,0x00]

v_cmpx_gt_i32_e64 vcc_lo, v2
// GFX10: encoding: [0x00,0x00,0x94,0xd4,0x6a,0x04,0x02,0x00]

v_cmpx_gt_i32_e64 vcc_hi, v2
// GFX10: encoding: [0x00,0x00,0x94,0xd4,0x6b,0x04,0x02,0x00]

v_cmpx_gt_i32_e64 m0, v2
// GFX10: encoding: [0x00,0x00,0x94,0xd4,0x7c,0x04,0x02,0x00]

v_cmpx_gt_i32_e64 exec_lo, v2
// GFX10: encoding: [0x00,0x00,0x94,0xd4,0x7e,0x04,0x02,0x00]

v_cmpx_gt_i32_e64 exec_hi, v2
// GFX10: encoding: [0x00,0x00,0x94,0xd4,0x7f,0x04,0x02,0x00]

v_cmpx_gt_i32_e64 0, v2
// GFX10: encoding: [0x00,0x00,0x94,0xd4,0x80,0x04,0x02,0x00]

v_cmpx_gt_i32_e64 -1, v2
// GFX10: encoding: [0x00,0x00,0x94,0xd4,0xc1,0x04,0x02,0x00]

v_cmpx_gt_i32_e64 0.5, v2
// GFX10: encoding: [0x00,0x00,0x94,0xd4,0xf0,0x04,0x02,0x00]

v_cmpx_gt_i32_e64 -4.0, v2
// GFX10: encoding: [0x00,0x00,0x94,0xd4,0xf7,0x04,0x02,0x00]

v_cmpx_gt_i32_e64 v1, v255
// GFX10: encoding: [0x00,0x00,0x94,0xd4,0x01,0xff,0x03,0x00]

v_cmpx_gt_i32_e64 v1, s2
// GFX10: encoding: [0x00,0x00,0x94,0xd4,0x01,0x05,0x00,0x00]

v_cmpx_gt_i32_e64 v1, s101
// GFX10: encoding: [0x00,0x00,0x94,0xd4,0x01,0xcb,0x00,0x00]

v_cmpx_gt_i32_e64 v1, vcc_lo
// GFX10: encoding: [0x00,0x00,0x94,0xd4,0x01,0xd5,0x00,0x00]

v_cmpx_gt_i32_e64 v1, vcc_hi
// GFX10: encoding: [0x00,0x00,0x94,0xd4,0x01,0xd7,0x00,0x00]

v_cmpx_gt_i32_e64 v1, m0
// GFX10: encoding: [0x00,0x00,0x94,0xd4,0x01,0xf9,0x00,0x00]

v_cmpx_gt_i32_e64 v1, exec_lo
// GFX10: encoding: [0x00,0x00,0x94,0xd4,0x01,0xfd,0x00,0x00]

v_cmpx_gt_i32_e64 v1, exec_hi
// GFX10: encoding: [0x00,0x00,0x94,0xd4,0x01,0xff,0x00,0x00]

v_cmpx_gt_i32_e64 v1, 0
// GFX10: encoding: [0x00,0x00,0x94,0xd4,0x01,0x01,0x01,0x00]

v_cmpx_gt_i32_e64 v1, -1
// GFX10: encoding: [0x00,0x00,0x94,0xd4,0x01,0x83,0x01,0x00]

v_cmpx_gt_i32_e64 v1, 0.5
// GFX10: encoding: [0x00,0x00,0x94,0xd4,0x01,0xe1,0x01,0x00]

v_cmpx_gt_i32_e64 v1, -4.0
// GFX10: encoding: [0x00,0x00,0x94,0xd4,0x01,0xef,0x01,0x00]

v_cmpx_ne_i32 v1, v2
// GFX10: encoding: [0x01,0x05,0x2a,0x7d]

v_cmpx_ne_i32 v255, v2
// GFX10: encoding: [0xff,0x05,0x2a,0x7d]

v_cmpx_ne_i32 s1, v2
// GFX10: encoding: [0x01,0x04,0x2a,0x7d]

v_cmpx_ne_i32 s101, v2
// GFX10: encoding: [0x65,0x04,0x2a,0x7d]

v_cmpx_ne_i32 vcc_lo, v2
// GFX10: encoding: [0x6a,0x04,0x2a,0x7d]

v_cmpx_ne_i32 vcc_hi, v2
// GFX10: encoding: [0x6b,0x04,0x2a,0x7d]

v_cmpx_ne_i32 m0, v2
// GFX10: encoding: [0x7c,0x04,0x2a,0x7d]

v_cmpx_ne_i32 exec_lo, v2
// GFX10: encoding: [0x7e,0x04,0x2a,0x7d]

v_cmpx_ne_i32 exec_hi, v2
// GFX10: encoding: [0x7f,0x04,0x2a,0x7d]

v_cmpx_ne_i32 0, v2
// GFX10: encoding: [0x80,0x04,0x2a,0x7d]

v_cmpx_ne_i32 -1, v2
// GFX10: encoding: [0xc1,0x04,0x2a,0x7d]

v_cmpx_ne_i32 0.5, v2
// GFX10: encoding: [0xf0,0x04,0x2a,0x7d]

v_cmpx_ne_i32 -4.0, v2
// GFX10: encoding: [0xf7,0x04,0x2a,0x7d]

v_cmpx_ne_i32 0xaf123456, v2
// GFX10: encoding: [0xff,0x04,0x2a,0x7d,0x56,0x34,0x12,0xaf]

v_cmpx_ne_i32 0x3f717273, v2
// GFX10: encoding: [0xff,0x04,0x2a,0x7d,0x73,0x72,0x71,0x3f]

v_cmpx_ne_i32 v1, v255
// GFX10: encoding: [0x01,0xff,0x2b,0x7d]

v_cmpx_ne_i32_e64 v1, v2
// GFX10: encoding: [0x00,0x00,0x95,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_ne_i32_e64 v255, v2
// GFX10: encoding: [0x00,0x00,0x95,0xd4,0xff,0x05,0x02,0x00]

v_cmpx_ne_i32_e64 s1, v2
// GFX10: encoding: [0x00,0x00,0x95,0xd4,0x01,0x04,0x02,0x00]

v_cmpx_ne_i32_e64 s101, v2
// GFX10: encoding: [0x00,0x00,0x95,0xd4,0x65,0x04,0x02,0x00]

v_cmpx_ne_i32_e64 vcc_lo, v2
// GFX10: encoding: [0x00,0x00,0x95,0xd4,0x6a,0x04,0x02,0x00]

v_cmpx_ne_i32_e64 vcc_hi, v2
// GFX10: encoding: [0x00,0x00,0x95,0xd4,0x6b,0x04,0x02,0x00]

v_cmpx_ne_i32_e64 m0, v2
// GFX10: encoding: [0x00,0x00,0x95,0xd4,0x7c,0x04,0x02,0x00]

v_cmpx_ne_i32_e64 exec_lo, v2
// GFX10: encoding: [0x00,0x00,0x95,0xd4,0x7e,0x04,0x02,0x00]

v_cmpx_ne_i32_e64 exec_hi, v2
// GFX10: encoding: [0x00,0x00,0x95,0xd4,0x7f,0x04,0x02,0x00]

v_cmpx_ne_i32_e64 0, v2
// GFX10: encoding: [0x00,0x00,0x95,0xd4,0x80,0x04,0x02,0x00]

v_cmpx_ne_i32_e64 -1, v2
// GFX10: encoding: [0x00,0x00,0x95,0xd4,0xc1,0x04,0x02,0x00]

v_cmpx_ne_i32_e64 0.5, v2
// GFX10: encoding: [0x00,0x00,0x95,0xd4,0xf0,0x04,0x02,0x00]

v_cmpx_ne_i32_e64 -4.0, v2
// GFX10: encoding: [0x00,0x00,0x95,0xd4,0xf7,0x04,0x02,0x00]

v_cmpx_ne_i32_e64 v1, v255
// GFX10: encoding: [0x00,0x00,0x95,0xd4,0x01,0xff,0x03,0x00]

v_cmpx_ne_i32_e64 v1, s2
// GFX10: encoding: [0x00,0x00,0x95,0xd4,0x01,0x05,0x00,0x00]

v_cmpx_ne_i32_e64 v1, s101
// GFX10: encoding: [0x00,0x00,0x95,0xd4,0x01,0xcb,0x00,0x00]

v_cmpx_ne_i32_e64 v1, vcc_lo
// GFX10: encoding: [0x00,0x00,0x95,0xd4,0x01,0xd5,0x00,0x00]

v_cmpx_ne_i32_e64 v1, vcc_hi
// GFX10: encoding: [0x00,0x00,0x95,0xd4,0x01,0xd7,0x00,0x00]

v_cmpx_ne_i32_e64 v1, m0
// GFX10: encoding: [0x00,0x00,0x95,0xd4,0x01,0xf9,0x00,0x00]

v_cmpx_ne_i32_e64 v1, exec_lo
// GFX10: encoding: [0x00,0x00,0x95,0xd4,0x01,0xfd,0x00,0x00]

v_cmpx_ne_i32_e64 v1, exec_hi
// GFX10: encoding: [0x00,0x00,0x95,0xd4,0x01,0xff,0x00,0x00]

v_cmpx_ne_i32_e64 v1, 0
// GFX10: encoding: [0x00,0x00,0x95,0xd4,0x01,0x01,0x01,0x00]

v_cmpx_ne_i32_e64 v1, -1
// GFX10: encoding: [0x00,0x00,0x95,0xd4,0x01,0x83,0x01,0x00]

v_cmpx_ne_i32_e64 v1, 0.5
// GFX10: encoding: [0x00,0x00,0x95,0xd4,0x01,0xe1,0x01,0x00]

v_cmpx_ne_i32_e64 v1, -4.0
// GFX10: encoding: [0x00,0x00,0x95,0xd4,0x01,0xef,0x01,0x00]

v_cmpx_ge_i32 v1, v2
// GFX10: encoding: [0x01,0x05,0x2c,0x7d]

v_cmpx_ge_i32 v255, v2
// GFX10: encoding: [0xff,0x05,0x2c,0x7d]

v_cmpx_ge_i32 s1, v2
// GFX10: encoding: [0x01,0x04,0x2c,0x7d]

v_cmpx_ge_i32 s101, v2
// GFX10: encoding: [0x65,0x04,0x2c,0x7d]

v_cmpx_ge_i32 vcc_lo, v2
// GFX10: encoding: [0x6a,0x04,0x2c,0x7d]

v_cmpx_ge_i32 vcc_hi, v2
// GFX10: encoding: [0x6b,0x04,0x2c,0x7d]

v_cmpx_ge_i32 m0, v2
// GFX10: encoding: [0x7c,0x04,0x2c,0x7d]

v_cmpx_ge_i32 exec_lo, v2
// GFX10: encoding: [0x7e,0x04,0x2c,0x7d]

v_cmpx_ge_i32 exec_hi, v2
// GFX10: encoding: [0x7f,0x04,0x2c,0x7d]

v_cmpx_ge_i32 0, v2
// GFX10: encoding: [0x80,0x04,0x2c,0x7d]

v_cmpx_ge_i32 -1, v2
// GFX10: encoding: [0xc1,0x04,0x2c,0x7d]

v_cmpx_ge_i32 0.5, v2
// GFX10: encoding: [0xf0,0x04,0x2c,0x7d]

v_cmpx_ge_i32 -4.0, v2
// GFX10: encoding: [0xf7,0x04,0x2c,0x7d]

v_cmpx_ge_i32 0xaf123456, v2
// GFX10: encoding: [0xff,0x04,0x2c,0x7d,0x56,0x34,0x12,0xaf]

v_cmpx_ge_i32 0x3f717273, v2
// GFX10: encoding: [0xff,0x04,0x2c,0x7d,0x73,0x72,0x71,0x3f]

v_cmpx_ge_i32 v1, v255
// GFX10: encoding: [0x01,0xff,0x2d,0x7d]

v_cmpx_ge_i32_e64 v1, v2
// GFX10: encoding: [0x00,0x00,0x96,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_ge_i32_e64 v255, v2
// GFX10: encoding: [0x00,0x00,0x96,0xd4,0xff,0x05,0x02,0x00]

v_cmpx_ge_i32_e64 s1, v2
// GFX10: encoding: [0x00,0x00,0x96,0xd4,0x01,0x04,0x02,0x00]

v_cmpx_ge_i32_e64 s101, v2
// GFX10: encoding: [0x00,0x00,0x96,0xd4,0x65,0x04,0x02,0x00]

v_cmpx_ge_i32_e64 vcc_lo, v2
// GFX10: encoding: [0x00,0x00,0x96,0xd4,0x6a,0x04,0x02,0x00]

v_cmpx_ge_i32_e64 vcc_hi, v2
// GFX10: encoding: [0x00,0x00,0x96,0xd4,0x6b,0x04,0x02,0x00]

v_cmpx_ge_i32_e64 m0, v2
// GFX10: encoding: [0x00,0x00,0x96,0xd4,0x7c,0x04,0x02,0x00]

v_cmpx_ge_i32_e64 exec_lo, v2
// GFX10: encoding: [0x00,0x00,0x96,0xd4,0x7e,0x04,0x02,0x00]

v_cmpx_ge_i32_e64 exec_hi, v2
// GFX10: encoding: [0x00,0x00,0x96,0xd4,0x7f,0x04,0x02,0x00]

v_cmpx_ge_i32_e64 0, v2
// GFX10: encoding: [0x00,0x00,0x96,0xd4,0x80,0x04,0x02,0x00]

v_cmpx_ge_i32_e64 -1, v2
// GFX10: encoding: [0x00,0x00,0x96,0xd4,0xc1,0x04,0x02,0x00]

v_cmpx_ge_i32_e64 0.5, v2
// GFX10: encoding: [0x00,0x00,0x96,0xd4,0xf0,0x04,0x02,0x00]

v_cmpx_ge_i32_e64 -4.0, v2
// GFX10: encoding: [0x00,0x00,0x96,0xd4,0xf7,0x04,0x02,0x00]

v_cmpx_ge_i32_e64 v1, v255
// GFX10: encoding: [0x00,0x00,0x96,0xd4,0x01,0xff,0x03,0x00]

v_cmpx_ge_i32_e64 v1, s2
// GFX10: encoding: [0x00,0x00,0x96,0xd4,0x01,0x05,0x00,0x00]

v_cmpx_ge_i32_e64 v1, s101
// GFX10: encoding: [0x00,0x00,0x96,0xd4,0x01,0xcb,0x00,0x00]

v_cmpx_ge_i32_e64 v1, vcc_lo
// GFX10: encoding: [0x00,0x00,0x96,0xd4,0x01,0xd5,0x00,0x00]

v_cmpx_ge_i32_e64 v1, vcc_hi
// GFX10: encoding: [0x00,0x00,0x96,0xd4,0x01,0xd7,0x00,0x00]

v_cmpx_ge_i32_e64 v1, m0
// GFX10: encoding: [0x00,0x00,0x96,0xd4,0x01,0xf9,0x00,0x00]

v_cmpx_ge_i32_e64 v1, exec_lo
// GFX10: encoding: [0x00,0x00,0x96,0xd4,0x01,0xfd,0x00,0x00]

v_cmpx_ge_i32_e64 v1, exec_hi
// GFX10: encoding: [0x00,0x00,0x96,0xd4,0x01,0xff,0x00,0x00]

v_cmpx_ge_i32_e64 v1, 0
// GFX10: encoding: [0x00,0x00,0x96,0xd4,0x01,0x01,0x01,0x00]

v_cmpx_ge_i32_e64 v1, -1
// GFX10: encoding: [0x00,0x00,0x96,0xd4,0x01,0x83,0x01,0x00]

v_cmpx_ge_i32_e64 v1, 0.5
// GFX10: encoding: [0x00,0x00,0x96,0xd4,0x01,0xe1,0x01,0x00]

v_cmpx_ge_i32_e64 v1, -4.0
// GFX10: encoding: [0x00,0x00,0x96,0xd4,0x01,0xef,0x01,0x00]

v_cmpx_t_i32 v1, v2
// GFX10: encoding: [0x01,0x05,0x2e,0x7d]

v_cmpx_t_i32 v255, v2
// GFX10: encoding: [0xff,0x05,0x2e,0x7d]

v_cmpx_t_i32 s1, v2
// GFX10: encoding: [0x01,0x04,0x2e,0x7d]

v_cmpx_t_i32 s101, v2
// GFX10: encoding: [0x65,0x04,0x2e,0x7d]

v_cmpx_t_i32 vcc_lo, v2
// GFX10: encoding: [0x6a,0x04,0x2e,0x7d]

v_cmpx_t_i32 vcc_hi, v2
// GFX10: encoding: [0x6b,0x04,0x2e,0x7d]

v_cmpx_t_i32 m0, v2
// GFX10: encoding: [0x7c,0x04,0x2e,0x7d]

v_cmpx_t_i32 exec_lo, v2
// GFX10: encoding: [0x7e,0x04,0x2e,0x7d]

v_cmpx_t_i32 exec_hi, v2
// GFX10: encoding: [0x7f,0x04,0x2e,0x7d]

v_cmpx_t_i32 0, v2
// GFX10: encoding: [0x80,0x04,0x2e,0x7d]

v_cmpx_t_i32 -1, v2
// GFX10: encoding: [0xc1,0x04,0x2e,0x7d]

v_cmpx_t_i32 0.5, v2
// GFX10: encoding: [0xf0,0x04,0x2e,0x7d]

v_cmpx_t_i32 -4.0, v2
// GFX10: encoding: [0xf7,0x04,0x2e,0x7d]

v_cmpx_t_i32 0xaf123456, v2
// GFX10: encoding: [0xff,0x04,0x2e,0x7d,0x56,0x34,0x12,0xaf]

v_cmpx_t_i32 0x3f717273, v2
// GFX10: encoding: [0xff,0x04,0x2e,0x7d,0x73,0x72,0x71,0x3f]

v_cmpx_t_i32 v1, v255
// GFX10: encoding: [0x01,0xff,0x2f,0x7d]

v_cmpx_t_i32_e64 v1, v2
// GFX10: encoding: [0x00,0x00,0x97,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_t_i32_e64 v255, v2
// GFX10: encoding: [0x00,0x00,0x97,0xd4,0xff,0x05,0x02,0x00]

v_cmpx_t_i32_e64 s1, v2
// GFX10: encoding: [0x00,0x00,0x97,0xd4,0x01,0x04,0x02,0x00]

v_cmpx_t_i32_e64 s101, v2
// GFX10: encoding: [0x00,0x00,0x97,0xd4,0x65,0x04,0x02,0x00]

v_cmpx_t_i32_e64 vcc_lo, v2
// GFX10: encoding: [0x00,0x00,0x97,0xd4,0x6a,0x04,0x02,0x00]

v_cmpx_t_i32_e64 vcc_hi, v2
// GFX10: encoding: [0x00,0x00,0x97,0xd4,0x6b,0x04,0x02,0x00]

v_cmpx_t_i32_e64 m0, v2
// GFX10: encoding: [0x00,0x00,0x97,0xd4,0x7c,0x04,0x02,0x00]

v_cmpx_t_i32_e64 exec_lo, v2
// GFX10: encoding: [0x00,0x00,0x97,0xd4,0x7e,0x04,0x02,0x00]

v_cmpx_t_i32_e64 exec_hi, v2
// GFX10: encoding: [0x00,0x00,0x97,0xd4,0x7f,0x04,0x02,0x00]

v_cmpx_t_i32_e64 0, v2
// GFX10: encoding: [0x00,0x00,0x97,0xd4,0x80,0x04,0x02,0x00]

v_cmpx_t_i32_e64 -1, v2
// GFX10: encoding: [0x00,0x00,0x97,0xd4,0xc1,0x04,0x02,0x00]

v_cmpx_t_i32_e64 0.5, v2
// GFX10: encoding: [0x00,0x00,0x97,0xd4,0xf0,0x04,0x02,0x00]

v_cmpx_t_i32_e64 -4.0, v2
// GFX10: encoding: [0x00,0x00,0x97,0xd4,0xf7,0x04,0x02,0x00]

v_cmpx_t_i32_e64 v1, v255
// GFX10: encoding: [0x00,0x00,0x97,0xd4,0x01,0xff,0x03,0x00]

v_cmpx_t_i32_e64 v1, s2
// GFX10: encoding: [0x00,0x00,0x97,0xd4,0x01,0x05,0x00,0x00]

v_cmpx_t_i32_e64 v1, s101
// GFX10: encoding: [0x00,0x00,0x97,0xd4,0x01,0xcb,0x00,0x00]

v_cmpx_t_i32_e64 v1, vcc_lo
// GFX10: encoding: [0x00,0x00,0x97,0xd4,0x01,0xd5,0x00,0x00]

v_cmpx_t_i32_e64 v1, vcc_hi
// GFX10: encoding: [0x00,0x00,0x97,0xd4,0x01,0xd7,0x00,0x00]

v_cmpx_t_i32_e64 v1, m0
// GFX10: encoding: [0x00,0x00,0x97,0xd4,0x01,0xf9,0x00,0x00]

v_cmpx_t_i32_e64 v1, exec_lo
// GFX10: encoding: [0x00,0x00,0x97,0xd4,0x01,0xfd,0x00,0x00]

v_cmpx_t_i32_e64 v1, exec_hi
// GFX10: encoding: [0x00,0x00,0x97,0xd4,0x01,0xff,0x00,0x00]

v_cmpx_t_i32_e64 v1, 0
// GFX10: encoding: [0x00,0x00,0x97,0xd4,0x01,0x01,0x01,0x00]

v_cmpx_t_i32_e64 v1, -1
// GFX10: encoding: [0x00,0x00,0x97,0xd4,0x01,0x83,0x01,0x00]

v_cmpx_t_i32_e64 v1, 0.5
// GFX10: encoding: [0x00,0x00,0x97,0xd4,0x01,0xe1,0x01,0x00]

v_cmpx_t_i32_e64 v1, -4.0
// GFX10: encoding: [0x00,0x00,0x97,0xd4,0x01,0xef,0x01,0x00]

v_cmpx_class_f32 v1, v2
// GFX10: encoding: [0x01,0x05,0x30,0x7d]

v_cmpx_class_f32 v255, v2
// GFX10: encoding: [0xff,0x05,0x30,0x7d]

v_cmpx_class_f32 s1, v2
// GFX10: encoding: [0x01,0x04,0x30,0x7d]

v_cmpx_class_f32 s101, v2
// GFX10: encoding: [0x65,0x04,0x30,0x7d]

v_cmpx_class_f32 vcc_lo, v2
// GFX10: encoding: [0x6a,0x04,0x30,0x7d]

v_cmpx_class_f32 vcc_hi, v2
// GFX10: encoding: [0x6b,0x04,0x30,0x7d]

v_cmpx_class_f32 m0, v2
// GFX10: encoding: [0x7c,0x04,0x30,0x7d]

v_cmpx_class_f32 exec_lo, v2
// GFX10: encoding: [0x7e,0x04,0x30,0x7d]

v_cmpx_class_f32 exec_hi, v2
// GFX10: encoding: [0x7f,0x04,0x30,0x7d]

v_cmpx_class_f32 0, v2
// GFX10: encoding: [0x80,0x04,0x30,0x7d]

v_cmpx_class_f32 -1, v2
// GFX10: encoding: [0xc1,0x04,0x30,0x7d]

v_cmpx_class_f32 0.5, v2
// GFX10: encoding: [0xf0,0x04,0x30,0x7d]

v_cmpx_class_f32 -4.0, v2
// GFX10: encoding: [0xf7,0x04,0x30,0x7d]

v_cmpx_class_f32 0xaf123456, v2
// GFX10: encoding: [0xff,0x04,0x30,0x7d,0x56,0x34,0x12,0xaf]

v_cmpx_class_f32 0x3f717273, v2
// GFX10: encoding: [0xff,0x04,0x30,0x7d,0x73,0x72,0x71,0x3f]

v_cmpx_class_f32 v1, v255
// GFX10: encoding: [0x01,0xff,0x31,0x7d]

v_cmpx_class_f32_e64 v1, v2
// GFX10: encoding: [0x00,0x00,0x98,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_class_f32_e64 v255, v2
// GFX10: encoding: [0x00,0x00,0x98,0xd4,0xff,0x05,0x02,0x00]

v_cmpx_class_f32_e64 s1, v2
// GFX10: encoding: [0x00,0x00,0x98,0xd4,0x01,0x04,0x02,0x00]

v_cmpx_class_f32_e64 s101, v2
// GFX10: encoding: [0x00,0x00,0x98,0xd4,0x65,0x04,0x02,0x00]

v_cmpx_class_f32_e64 vcc_lo, v2
// GFX10: encoding: [0x00,0x00,0x98,0xd4,0x6a,0x04,0x02,0x00]

v_cmpx_class_f32_e64 vcc_hi, v2
// GFX10: encoding: [0x00,0x00,0x98,0xd4,0x6b,0x04,0x02,0x00]

v_cmpx_class_f32_e64 m0, v2
// GFX10: encoding: [0x00,0x00,0x98,0xd4,0x7c,0x04,0x02,0x00]

v_cmpx_class_f32_e64 exec_lo, v2
// GFX10: encoding: [0x00,0x00,0x98,0xd4,0x7e,0x04,0x02,0x00]

v_cmpx_class_f32_e64 exec_hi, v2
// GFX10: encoding: [0x00,0x00,0x98,0xd4,0x7f,0x04,0x02,0x00]

v_cmpx_class_f32_e64 0, v2
// GFX10: encoding: [0x00,0x00,0x98,0xd4,0x80,0x04,0x02,0x00]

v_cmpx_class_f32_e64 -1, v2
// GFX10: encoding: [0x00,0x00,0x98,0xd4,0xc1,0x04,0x02,0x00]

v_cmpx_class_f32_e64 0.5, v2
// GFX10: encoding: [0x00,0x00,0x98,0xd4,0xf0,0x04,0x02,0x00]

v_cmpx_class_f32_e64 -4.0, v2
// GFX10: encoding: [0x00,0x00,0x98,0xd4,0xf7,0x04,0x02,0x00]

v_cmpx_class_f32_e64 v1, v255
// GFX10: encoding: [0x00,0x00,0x98,0xd4,0x01,0xff,0x03,0x00]

v_cmpx_class_f32_e64 v1, s2
// GFX10: encoding: [0x00,0x00,0x98,0xd4,0x01,0x05,0x00,0x00]

v_cmpx_class_f32_e64 v1, s101
// GFX10: encoding: [0x00,0x00,0x98,0xd4,0x01,0xcb,0x00,0x00]

v_cmpx_class_f32_e64 v1, vcc_lo
// GFX10: encoding: [0x00,0x00,0x98,0xd4,0x01,0xd5,0x00,0x00]

v_cmpx_class_f32_e64 v1, vcc_hi
// GFX10: encoding: [0x00,0x00,0x98,0xd4,0x01,0xd7,0x00,0x00]

v_cmpx_class_f32_e64 v1, m0
// GFX10: encoding: [0x00,0x00,0x98,0xd4,0x01,0xf9,0x00,0x00]

v_cmpx_class_f32_e64 v1, exec_lo
// GFX10: encoding: [0x00,0x00,0x98,0xd4,0x01,0xfd,0x00,0x00]

v_cmpx_class_f32_e64 v1, exec_hi
// GFX10: encoding: [0x00,0x00,0x98,0xd4,0x01,0xff,0x00,0x00]

v_cmpx_class_f32_e64 v1, 0
// GFX10: encoding: [0x00,0x00,0x98,0xd4,0x01,0x01,0x01,0x00]

v_cmpx_class_f32_e64 v1, -1
// GFX10: encoding: [0x00,0x00,0x98,0xd4,0x01,0x83,0x01,0x00]

v_cmpx_class_f32_e64 v1, 0.5
// GFX10: encoding: [0x00,0x00,0x98,0xd4,0x01,0xe1,0x01,0x00]

v_cmpx_class_f32_e64 v1, -4.0
// GFX10: encoding: [0x00,0x00,0x98,0xd4,0x01,0xef,0x01,0x00]

v_cmpx_class_f32_e64 -v1, v2
// GFX10: encoding: [0x00,0x00,0x98,0xd4,0x01,0x05,0x02,0x20]

v_cmpx_lt_i16 v1, v2
// GFX10: encoding: [0x01,0x05,0x32,0x7d]

v_cmpx_lt_i16 v255, v2
// GFX10: encoding: [0xff,0x05,0x32,0x7d]

v_cmpx_lt_i16 s1, v2
// GFX10: encoding: [0x01,0x04,0x32,0x7d]

v_cmpx_lt_i16 s101, v2
// GFX10: encoding: [0x65,0x04,0x32,0x7d]

v_cmpx_lt_i16 vcc_lo, v2
// GFX10: encoding: [0x6a,0x04,0x32,0x7d]

v_cmpx_lt_i16 vcc_hi, v2
// GFX10: encoding: [0x6b,0x04,0x32,0x7d]

v_cmpx_lt_i16 m0, v2
// GFX10: encoding: [0x7c,0x04,0x32,0x7d]

v_cmpx_lt_i16 exec_lo, v2
// GFX10: encoding: [0x7e,0x04,0x32,0x7d]

v_cmpx_lt_i16 exec_hi, v2
// GFX10: encoding: [0x7f,0x04,0x32,0x7d]

v_cmpx_lt_i16 0, v2
// GFX10: encoding: [0x80,0x04,0x32,0x7d]

v_cmpx_lt_i16 -1, v2
// GFX10: encoding: [0xc1,0x04,0x32,0x7d]

v_cmpx_lt_i16 0.5, v2
// GFX10: encoding: [0xff,0x04,0x32,0x7d,0x00,0x38,0x00,0x00]

v_cmpx_lt_i16 -4.0, v2
// GFX10: encoding: [0xff,0x04,0x32,0x7d,0x00,0xc4,0x00,0x00]

v_cmpx_lt_i16 0xfe0b, v2
// GFX10: encoding: [0xff,0x04,0x32,0x7d,0x0b,0xfe,0x00,0x00]

v_cmpx_lt_i16 0x3456, v2
// GFX10: encoding: [0xff,0x04,0x32,0x7d,0x56,0x34,0x00,0x00]

v_cmpx_lt_i16 v1, v255
// GFX10: encoding: [0x01,0xff,0x33,0x7d]

v_cmpx_lt_i16_e64 v1, v2
// GFX10: encoding: [0x00,0x00,0x99,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_lt_i16_e64 v255, v2
// GFX10: encoding: [0x00,0x00,0x99,0xd4,0xff,0x05,0x02,0x00]

v_cmpx_lt_i16_e64 s1, v2
// GFX10: encoding: [0x00,0x00,0x99,0xd4,0x01,0x04,0x02,0x00]

v_cmpx_lt_i16_e64 s101, v2
// GFX10: encoding: [0x00,0x00,0x99,0xd4,0x65,0x04,0x02,0x00]

v_cmpx_lt_i16_e64 vcc_lo, v2
// GFX10: encoding: [0x00,0x00,0x99,0xd4,0x6a,0x04,0x02,0x00]

v_cmpx_lt_i16_e64 vcc_hi, v2
// GFX10: encoding: [0x00,0x00,0x99,0xd4,0x6b,0x04,0x02,0x00]

v_cmpx_lt_i16_e64 m0, v2
// GFX10: encoding: [0x00,0x00,0x99,0xd4,0x7c,0x04,0x02,0x00]

v_cmpx_lt_i16_e64 exec_lo, v2
// GFX10: encoding: [0x00,0x00,0x99,0xd4,0x7e,0x04,0x02,0x00]

v_cmpx_lt_i16_e64 exec_hi, v2
// GFX10: encoding: [0x00,0x00,0x99,0xd4,0x7f,0x04,0x02,0x00]

v_cmpx_lt_i16_e64 0, v2
// GFX10: encoding: [0x00,0x00,0x99,0xd4,0x80,0x04,0x02,0x00]

v_cmpx_lt_i16_e64 -1, v2
// GFX10: encoding: [0x00,0x00,0x99,0xd4,0xc1,0x04,0x02,0x00]

v_cmpx_lt_i16_e64 0.5, v2
// GFX10: encoding: [0x00,0x00,0x99,0xd4,0xff,0x04,0x02,0x00,0x00,0x38,0x00,0x00]

v_cmpx_lt_i16_e64 -4.0, v2
// GFX10: encoding: [0x00,0x00,0x99,0xd4,0xff,0x04,0x02,0x00,0x00,0xc4,0x00,0x00]

v_cmpx_lt_i16_e64 v1, v255
// GFX10: encoding: [0x00,0x00,0x99,0xd4,0x01,0xff,0x03,0x00]

v_cmpx_lt_i16_e64 v1, s2
// GFX10: encoding: [0x00,0x00,0x99,0xd4,0x01,0x05,0x00,0x00]

v_cmpx_lt_i16_e64 v1, s101
// GFX10: encoding: [0x00,0x00,0x99,0xd4,0x01,0xcb,0x00,0x00]

v_cmpx_lt_i16_e64 v1, vcc_lo
// GFX10: encoding: [0x00,0x00,0x99,0xd4,0x01,0xd5,0x00,0x00]

v_cmpx_lt_i16_e64 v1, vcc_hi
// GFX10: encoding: [0x00,0x00,0x99,0xd4,0x01,0xd7,0x00,0x00]

v_cmpx_lt_i16_e64 v1, m0
// GFX10: encoding: [0x00,0x00,0x99,0xd4,0x01,0xf9,0x00,0x00]

v_cmpx_lt_i16_e64 v1, exec_lo
// GFX10: encoding: [0x00,0x00,0x99,0xd4,0x01,0xfd,0x00,0x00]

v_cmpx_lt_i16_e64 v1, exec_hi
// GFX10: encoding: [0x00,0x00,0x99,0xd4,0x01,0xff,0x00,0x00]

v_cmpx_lt_i16_e64 v1, 0
// GFX10: encoding: [0x00,0x00,0x99,0xd4,0x01,0x01,0x01,0x00]

v_cmpx_lt_i16_e64 v1, -1
// GFX10: encoding: [0x00,0x00,0x99,0xd4,0x01,0x83,0x01,0x00]

v_cmpx_lt_i16_e64 v1, 0.5
// GFX10: encoding: [0x00,0x00,0x99,0xd4,0x01,0xff,0x01,0x00,0x00,0x38,0x00,0x00]

v_cmpx_lt_i16_e64 v1, -4.0
// GFX10: encoding: [0x00,0x00,0x99,0xd4,0x01,0xff,0x01,0x00,0x00,0xc4,0x00,0x00]

v_cmpx_eq_i16 v1, v2
// GFX10: encoding: [0x01,0x05,0x34,0x7d]

v_cmpx_eq_i16 v255, v2
// GFX10: encoding: [0xff,0x05,0x34,0x7d]

v_cmpx_eq_i16 s1, v2
// GFX10: encoding: [0x01,0x04,0x34,0x7d]

v_cmpx_eq_i16 s101, v2
// GFX10: encoding: [0x65,0x04,0x34,0x7d]

v_cmpx_eq_i16 vcc_lo, v2
// GFX10: encoding: [0x6a,0x04,0x34,0x7d]

v_cmpx_eq_i16 vcc_hi, v2
// GFX10: encoding: [0x6b,0x04,0x34,0x7d]

v_cmpx_eq_i16 m0, v2
// GFX10: encoding: [0x7c,0x04,0x34,0x7d]

v_cmpx_eq_i16 exec_lo, v2
// GFX10: encoding: [0x7e,0x04,0x34,0x7d]

v_cmpx_eq_i16 exec_hi, v2
// GFX10: encoding: [0x7f,0x04,0x34,0x7d]

v_cmpx_eq_i16 0, v2
// GFX10: encoding: [0x80,0x04,0x34,0x7d]

v_cmpx_eq_i16 -1, v2
// GFX10: encoding: [0xc1,0x04,0x34,0x7d]

v_cmpx_eq_i16 0.5, v2
// GFX10: encoding: [0xff,0x04,0x34,0x7d,0x00,0x38,0x00,0x00]

v_cmpx_eq_i16 -4.0, v2
// GFX10: encoding: [0xff,0x04,0x34,0x7d,0x00,0xc4,0x00,0x00]

v_cmpx_eq_i16 0xfe0b, v2
// GFX10: encoding: [0xff,0x04,0x34,0x7d,0x0b,0xfe,0x00,0x00]

v_cmpx_eq_i16 0x3456, v2
// GFX10: encoding: [0xff,0x04,0x34,0x7d,0x56,0x34,0x00,0x00]

v_cmpx_eq_i16 v1, v255
// GFX10: encoding: [0x01,0xff,0x35,0x7d]

v_cmpx_eq_i16_e64 v1, v2
// GFX10: encoding: [0x00,0x00,0x9a,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_eq_i16_e64 v255, v2
// GFX10: encoding: [0x00,0x00,0x9a,0xd4,0xff,0x05,0x02,0x00]

v_cmpx_eq_i16_e64 s1, v2
// GFX10: encoding: [0x00,0x00,0x9a,0xd4,0x01,0x04,0x02,0x00]

v_cmpx_eq_i16_e64 s101, v2
// GFX10: encoding: [0x00,0x00,0x9a,0xd4,0x65,0x04,0x02,0x00]

v_cmpx_eq_i16_e64 vcc_lo, v2
// GFX10: encoding: [0x00,0x00,0x9a,0xd4,0x6a,0x04,0x02,0x00]

v_cmpx_eq_i16_e64 vcc_hi, v2
// GFX10: encoding: [0x00,0x00,0x9a,0xd4,0x6b,0x04,0x02,0x00]

v_cmpx_eq_i16_e64 m0, v2
// GFX10: encoding: [0x00,0x00,0x9a,0xd4,0x7c,0x04,0x02,0x00]

v_cmpx_eq_i16_e64 exec_lo, v2
// GFX10: encoding: [0x00,0x00,0x9a,0xd4,0x7e,0x04,0x02,0x00]

v_cmpx_eq_i16_e64 exec_hi, v2
// GFX10: encoding: [0x00,0x00,0x9a,0xd4,0x7f,0x04,0x02,0x00]

v_cmpx_eq_i16_e64 0, v2
// GFX10: encoding: [0x00,0x00,0x9a,0xd4,0x80,0x04,0x02,0x00]

v_cmpx_eq_i16_e64 -1, v2
// GFX10: encoding: [0x00,0x00,0x9a,0xd4,0xc1,0x04,0x02,0x00]

v_cmpx_eq_i16_e64 0.5, v2
// GFX10: encoding: [0x00,0x00,0x9a,0xd4,0xff,0x04,0x02,0x00,0x00,0x38,0x00,0x00]

v_cmpx_eq_i16_e64 -4.0, v2
// GFX10: encoding: [0x00,0x00,0x9a,0xd4,0xff,0x04,0x02,0x00,0x00,0xc4,0x00,0x00]

v_cmpx_eq_i16_e64 v1, v255
// GFX10: encoding: [0x00,0x00,0x9a,0xd4,0x01,0xff,0x03,0x00]

v_cmpx_eq_i16_e64 v1, s2
// GFX10: encoding: [0x00,0x00,0x9a,0xd4,0x01,0x05,0x00,0x00]

v_cmpx_eq_i16_e64 v1, s101
// GFX10: encoding: [0x00,0x00,0x9a,0xd4,0x01,0xcb,0x00,0x00]

v_cmpx_eq_i16_e64 v1, vcc_lo
// GFX10: encoding: [0x00,0x00,0x9a,0xd4,0x01,0xd5,0x00,0x00]

v_cmpx_eq_i16_e64 v1, vcc_hi
// GFX10: encoding: [0x00,0x00,0x9a,0xd4,0x01,0xd7,0x00,0x00]

v_cmpx_eq_i16_e64 v1, m0
// GFX10: encoding: [0x00,0x00,0x9a,0xd4,0x01,0xf9,0x00,0x00]

v_cmpx_eq_i16_e64 v1, exec_lo
// GFX10: encoding: [0x00,0x00,0x9a,0xd4,0x01,0xfd,0x00,0x00]

v_cmpx_eq_i16_e64 v1, exec_hi
// GFX10: encoding: [0x00,0x00,0x9a,0xd4,0x01,0xff,0x00,0x00]

v_cmpx_eq_i16_e64 v1, 0
// GFX10: encoding: [0x00,0x00,0x9a,0xd4,0x01,0x01,0x01,0x00]

v_cmpx_eq_i16_e64 v1, -1
// GFX10: encoding: [0x00,0x00,0x9a,0xd4,0x01,0x83,0x01,0x00]

v_cmpx_eq_i16_e64 v1, 0.5
// GFX10: encoding: [0x00,0x00,0x9a,0xd4,0x01,0xff,0x01,0x00,0x00,0x38,0x00,0x00]

v_cmpx_eq_i16_e64 v1, -4.0
// GFX10: encoding: [0x00,0x00,0x9a,0xd4,0x01,0xff,0x01,0x00,0x00,0xc4,0x00,0x00]

v_cmpx_le_i16 v1, v2
// GFX10: encoding: [0x01,0x05,0x36,0x7d]

v_cmpx_le_i16 v255, v2
// GFX10: encoding: [0xff,0x05,0x36,0x7d]

v_cmpx_le_i16 s1, v2
// GFX10: encoding: [0x01,0x04,0x36,0x7d]

v_cmpx_le_i16 s101, v2
// GFX10: encoding: [0x65,0x04,0x36,0x7d]

v_cmpx_le_i16 vcc_lo, v2
// GFX10: encoding: [0x6a,0x04,0x36,0x7d]

v_cmpx_le_i16 vcc_hi, v2
// GFX10: encoding: [0x6b,0x04,0x36,0x7d]

v_cmpx_le_i16 m0, v2
// GFX10: encoding: [0x7c,0x04,0x36,0x7d]

v_cmpx_le_i16 exec_lo, v2
// GFX10: encoding: [0x7e,0x04,0x36,0x7d]

v_cmpx_le_i16 exec_hi, v2
// GFX10: encoding: [0x7f,0x04,0x36,0x7d]

v_cmpx_le_i16 0, v2
// GFX10: encoding: [0x80,0x04,0x36,0x7d]

v_cmpx_le_i16 -1, v2
// GFX10: encoding: [0xc1,0x04,0x36,0x7d]

v_cmpx_le_i16 0.5, v2
// GFX10: encoding: [0xff,0x04,0x36,0x7d,0x00,0x38,0x00,0x00]

v_cmpx_le_i16 -4.0, v2
// GFX10: encoding: [0xff,0x04,0x36,0x7d,0x00,0xc4,0x00,0x00]

v_cmpx_le_i16 0xfe0b, v2
// GFX10: encoding: [0xff,0x04,0x36,0x7d,0x0b,0xfe,0x00,0x00]

v_cmpx_le_i16 0x3456, v2
// GFX10: encoding: [0xff,0x04,0x36,0x7d,0x56,0x34,0x00,0x00]

v_cmpx_le_i16 v1, v255
// GFX10: encoding: [0x01,0xff,0x37,0x7d]

v_cmpx_le_i16_e64 v1, v2
// GFX10: encoding: [0x00,0x00,0x9b,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_le_i16_e64 v255, v2
// GFX10: encoding: [0x00,0x00,0x9b,0xd4,0xff,0x05,0x02,0x00]

v_cmpx_le_i16_e64 s1, v2
// GFX10: encoding: [0x00,0x00,0x9b,0xd4,0x01,0x04,0x02,0x00]

v_cmpx_le_i16_e64 s101, v2
// GFX10: encoding: [0x00,0x00,0x9b,0xd4,0x65,0x04,0x02,0x00]

v_cmpx_le_i16_e64 vcc_lo, v2
// GFX10: encoding: [0x00,0x00,0x9b,0xd4,0x6a,0x04,0x02,0x00]

v_cmpx_le_i16_e64 vcc_hi, v2
// GFX10: encoding: [0x00,0x00,0x9b,0xd4,0x6b,0x04,0x02,0x00]

v_cmpx_le_i16_e64 m0, v2
// GFX10: encoding: [0x00,0x00,0x9b,0xd4,0x7c,0x04,0x02,0x00]

v_cmpx_le_i16_e64 exec_lo, v2
// GFX10: encoding: [0x00,0x00,0x9b,0xd4,0x7e,0x04,0x02,0x00]

v_cmpx_le_i16_e64 exec_hi, v2
// GFX10: encoding: [0x00,0x00,0x9b,0xd4,0x7f,0x04,0x02,0x00]

v_cmpx_le_i16_e64 0, v2
// GFX10: encoding: [0x00,0x00,0x9b,0xd4,0x80,0x04,0x02,0x00]

v_cmpx_le_i16_e64 -1, v2
// GFX10: encoding: [0x00,0x00,0x9b,0xd4,0xc1,0x04,0x02,0x00]

v_cmpx_le_i16_e64 0.5, v2
// GFX10: encoding: [0x00,0x00,0x9b,0xd4,0xff,0x04,0x02,0x00,0x00,0x38,0x00,0x00]

v_cmpx_le_i16_e64 -4.0, v2
// GFX10: encoding: [0x00,0x00,0x9b,0xd4,0xff,0x04,0x02,0x00,0x00,0xc4,0x00,0x00]

v_cmpx_le_i16_e64 v1, v255
// GFX10: encoding: [0x00,0x00,0x9b,0xd4,0x01,0xff,0x03,0x00]

v_cmpx_le_i16_e64 v1, s2
// GFX10: encoding: [0x00,0x00,0x9b,0xd4,0x01,0x05,0x00,0x00]

v_cmpx_le_i16_e64 v1, s101
// GFX10: encoding: [0x00,0x00,0x9b,0xd4,0x01,0xcb,0x00,0x00]

v_cmpx_le_i16_e64 v1, vcc_lo
// GFX10: encoding: [0x00,0x00,0x9b,0xd4,0x01,0xd5,0x00,0x00]

v_cmpx_le_i16_e64 v1, vcc_hi
// GFX10: encoding: [0x00,0x00,0x9b,0xd4,0x01,0xd7,0x00,0x00]

v_cmpx_le_i16_e64 v1, m0
// GFX10: encoding: [0x00,0x00,0x9b,0xd4,0x01,0xf9,0x00,0x00]

v_cmpx_le_i16_e64 v1, exec_lo
// GFX10: encoding: [0x00,0x00,0x9b,0xd4,0x01,0xfd,0x00,0x00]

v_cmpx_le_i16_e64 v1, exec_hi
// GFX10: encoding: [0x00,0x00,0x9b,0xd4,0x01,0xff,0x00,0x00]

v_cmpx_le_i16_e64 v1, 0
// GFX10: encoding: [0x00,0x00,0x9b,0xd4,0x01,0x01,0x01,0x00]

v_cmpx_le_i16_e64 v1, -1
// GFX10: encoding: [0x00,0x00,0x9b,0xd4,0x01,0x83,0x01,0x00]

v_cmpx_le_i16_e64 v1, 0.5
// GFX10: encoding: [0x00,0x00,0x9b,0xd4,0x01,0xff,0x01,0x00,0x00,0x38,0x00,0x00]

v_cmpx_le_i16_e64 v1, -4.0
// GFX10: encoding: [0x00,0x00,0x9b,0xd4,0x01,0xff,0x01,0x00,0x00,0xc4,0x00,0x00]

v_cmpx_gt_i16 v1, v2
// GFX10: encoding: [0x01,0x05,0x38,0x7d]

v_cmpx_gt_i16 v255, v2
// GFX10: encoding: [0xff,0x05,0x38,0x7d]

v_cmpx_gt_i16 s1, v2
// GFX10: encoding: [0x01,0x04,0x38,0x7d]

v_cmpx_gt_i16 s101, v2
// GFX10: encoding: [0x65,0x04,0x38,0x7d]

v_cmpx_gt_i16 vcc_lo, v2
// GFX10: encoding: [0x6a,0x04,0x38,0x7d]

v_cmpx_gt_i16 vcc_hi, v2
// GFX10: encoding: [0x6b,0x04,0x38,0x7d]

v_cmpx_gt_i16 m0, v2
// GFX10: encoding: [0x7c,0x04,0x38,0x7d]

v_cmpx_gt_i16 exec_lo, v2
// GFX10: encoding: [0x7e,0x04,0x38,0x7d]

v_cmpx_gt_i16 exec_hi, v2
// GFX10: encoding: [0x7f,0x04,0x38,0x7d]

v_cmpx_gt_i16 0, v2
// GFX10: encoding: [0x80,0x04,0x38,0x7d]

v_cmpx_gt_i16 -1, v2
// GFX10: encoding: [0xc1,0x04,0x38,0x7d]

v_cmpx_gt_i16 0.5, v2
// GFX10: encoding: [0xff,0x04,0x38,0x7d,0x00,0x38,0x00,0x00]

v_cmpx_gt_i16 -4.0, v2
// GFX10: encoding: [0xff,0x04,0x38,0x7d,0x00,0xc4,0x00,0x00]

v_cmpx_gt_i16 0xfe0b, v2
// GFX10: encoding: [0xff,0x04,0x38,0x7d,0x0b,0xfe,0x00,0x00]

v_cmpx_gt_i16 0x3456, v2
// GFX10: encoding: [0xff,0x04,0x38,0x7d,0x56,0x34,0x00,0x00]

v_cmpx_gt_i16 v1, v255
// GFX10: encoding: [0x01,0xff,0x39,0x7d]

v_cmpx_gt_i16_e64 v1, v2
// GFX10: encoding: [0x00,0x00,0x9c,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_gt_i16_e64 v255, v2
// GFX10: encoding: [0x00,0x00,0x9c,0xd4,0xff,0x05,0x02,0x00]

v_cmpx_gt_i16_e64 s1, v2
// GFX10: encoding: [0x00,0x00,0x9c,0xd4,0x01,0x04,0x02,0x00]

v_cmpx_gt_i16_e64 s101, v2
// GFX10: encoding: [0x00,0x00,0x9c,0xd4,0x65,0x04,0x02,0x00]

v_cmpx_gt_i16_e64 vcc_lo, v2
// GFX10: encoding: [0x00,0x00,0x9c,0xd4,0x6a,0x04,0x02,0x00]

v_cmpx_gt_i16_e64 vcc_hi, v2
// GFX10: encoding: [0x00,0x00,0x9c,0xd4,0x6b,0x04,0x02,0x00]

v_cmpx_gt_i16_e64 m0, v2
// GFX10: encoding: [0x00,0x00,0x9c,0xd4,0x7c,0x04,0x02,0x00]

v_cmpx_gt_i16_e64 exec_lo, v2
// GFX10: encoding: [0x00,0x00,0x9c,0xd4,0x7e,0x04,0x02,0x00]

v_cmpx_gt_i16_e64 exec_hi, v2
// GFX10: encoding: [0x00,0x00,0x9c,0xd4,0x7f,0x04,0x02,0x00]

v_cmpx_gt_i16_e64 0, v2
// GFX10: encoding: [0x00,0x00,0x9c,0xd4,0x80,0x04,0x02,0x00]

v_cmpx_gt_i16_e64 -1, v2
// GFX10: encoding: [0x00,0x00,0x9c,0xd4,0xc1,0x04,0x02,0x00]

v_cmpx_gt_i16_e64 0.5, v2
// GFX10: encoding: [0x00,0x00,0x9c,0xd4,0xff,0x04,0x02,0x00,0x00,0x38,0x00,0x00]

v_cmpx_gt_i16_e64 -4.0, v2
// GFX10: encoding: [0x00,0x00,0x9c,0xd4,0xff,0x04,0x02,0x00,0x00,0xc4,0x00,0x00]

v_cmpx_gt_i16_e64 v1, v255
// GFX10: encoding: [0x00,0x00,0x9c,0xd4,0x01,0xff,0x03,0x00]

v_cmpx_gt_i16_e64 v1, s2
// GFX10: encoding: [0x00,0x00,0x9c,0xd4,0x01,0x05,0x00,0x00]

v_cmpx_gt_i16_e64 v1, s101
// GFX10: encoding: [0x00,0x00,0x9c,0xd4,0x01,0xcb,0x00,0x00]

v_cmpx_gt_i16_e64 v1, vcc_lo
// GFX10: encoding: [0x00,0x00,0x9c,0xd4,0x01,0xd5,0x00,0x00]

v_cmpx_gt_i16_e64 v1, vcc_hi
// GFX10: encoding: [0x00,0x00,0x9c,0xd4,0x01,0xd7,0x00,0x00]

v_cmpx_gt_i16_e64 v1, m0
// GFX10: encoding: [0x00,0x00,0x9c,0xd4,0x01,0xf9,0x00,0x00]

v_cmpx_gt_i16_e64 v1, exec_lo
// GFX10: encoding: [0x00,0x00,0x9c,0xd4,0x01,0xfd,0x00,0x00]

v_cmpx_gt_i16_e64 v1, exec_hi
// GFX10: encoding: [0x00,0x00,0x9c,0xd4,0x01,0xff,0x00,0x00]

v_cmpx_gt_i16_e64 v1, 0
// GFX10: encoding: [0x00,0x00,0x9c,0xd4,0x01,0x01,0x01,0x00]

v_cmpx_gt_i16_e64 v1, -1
// GFX10: encoding: [0x00,0x00,0x9c,0xd4,0x01,0x83,0x01,0x00]

v_cmpx_gt_i16_e64 v1, 0.5
// GFX10: encoding: [0x00,0x00,0x9c,0xd4,0x01,0xff,0x01,0x00,0x00,0x38,0x00,0x00]

v_cmpx_gt_i16_e64 v1, -4.0
// GFX10: encoding: [0x00,0x00,0x9c,0xd4,0x01,0xff,0x01,0x00,0x00,0xc4,0x00,0x00]

v_cmpx_ne_i16 v1, v2
// GFX10: encoding: [0x01,0x05,0x3a,0x7d]

v_cmpx_ne_i16 v255, v2
// GFX10: encoding: [0xff,0x05,0x3a,0x7d]

v_cmpx_ne_i16 s1, v2
// GFX10: encoding: [0x01,0x04,0x3a,0x7d]

v_cmpx_ne_i16 s101, v2
// GFX10: encoding: [0x65,0x04,0x3a,0x7d]

v_cmpx_ne_i16 vcc_lo, v2
// GFX10: encoding: [0x6a,0x04,0x3a,0x7d]

v_cmpx_ne_i16 vcc_hi, v2
// GFX10: encoding: [0x6b,0x04,0x3a,0x7d]

v_cmpx_ne_i16 m0, v2
// GFX10: encoding: [0x7c,0x04,0x3a,0x7d]

v_cmpx_ne_i16 exec_lo, v2
// GFX10: encoding: [0x7e,0x04,0x3a,0x7d]

v_cmpx_ne_i16 exec_hi, v2
// GFX10: encoding: [0x7f,0x04,0x3a,0x7d]

v_cmpx_ne_i16 0, v2
// GFX10: encoding: [0x80,0x04,0x3a,0x7d]

v_cmpx_ne_i16 -1, v2
// GFX10: encoding: [0xc1,0x04,0x3a,0x7d]

v_cmpx_ne_i16 0.5, v2
// GFX10: encoding: [0xff,0x04,0x3a,0x7d,0x00,0x38,0x00,0x00]

v_cmpx_ne_i16 -4.0, v2
// GFX10: encoding: [0xff,0x04,0x3a,0x7d,0x00,0xc4,0x00,0x00]

v_cmpx_ne_i16 0xfe0b, v2
// GFX10: encoding: [0xff,0x04,0x3a,0x7d,0x0b,0xfe,0x00,0x00]

v_cmpx_ne_i16 0x3456, v2
// GFX10: encoding: [0xff,0x04,0x3a,0x7d,0x56,0x34,0x00,0x00]

v_cmpx_ne_i16 v1, v255
// GFX10: encoding: [0x01,0xff,0x3b,0x7d]

v_cmpx_ne_i16_e64 v1, v2
// GFX10: encoding: [0x00,0x00,0x9d,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_ne_i16_e64 v255, v2
// GFX10: encoding: [0x00,0x00,0x9d,0xd4,0xff,0x05,0x02,0x00]

v_cmpx_ne_i16_e64 s1, v2
// GFX10: encoding: [0x00,0x00,0x9d,0xd4,0x01,0x04,0x02,0x00]

v_cmpx_ne_i16_e64 s101, v2
// GFX10: encoding: [0x00,0x00,0x9d,0xd4,0x65,0x04,0x02,0x00]

v_cmpx_ne_i16_e64 vcc_lo, v2
// GFX10: encoding: [0x00,0x00,0x9d,0xd4,0x6a,0x04,0x02,0x00]

v_cmpx_ne_i16_e64 vcc_hi, v2
// GFX10: encoding: [0x00,0x00,0x9d,0xd4,0x6b,0x04,0x02,0x00]

v_cmpx_ne_i16_e64 m0, v2
// GFX10: encoding: [0x00,0x00,0x9d,0xd4,0x7c,0x04,0x02,0x00]

v_cmpx_ne_i16_e64 exec_lo, v2
// GFX10: encoding: [0x00,0x00,0x9d,0xd4,0x7e,0x04,0x02,0x00]

v_cmpx_ne_i16_e64 exec_hi, v2
// GFX10: encoding: [0x00,0x00,0x9d,0xd4,0x7f,0x04,0x02,0x00]

v_cmpx_ne_i16_e64 0, v2
// GFX10: encoding: [0x00,0x00,0x9d,0xd4,0x80,0x04,0x02,0x00]

v_cmpx_ne_i16_e64 -1, v2
// GFX10: encoding: [0x00,0x00,0x9d,0xd4,0xc1,0x04,0x02,0x00]

v_cmpx_ne_i16_e64 0.5, v2
// GFX10: encoding: [0x00,0x00,0x9d,0xd4,0xff,0x04,0x02,0x00,0x00,0x38,0x00,0x00]

v_cmpx_ne_i16_e64 -4.0, v2
// GFX10: encoding: [0x00,0x00,0x9d,0xd4,0xff,0x04,0x02,0x00,0x00,0xc4,0x00,0x00]

v_cmpx_ne_i16_e64 v1, v255
// GFX10: encoding: [0x00,0x00,0x9d,0xd4,0x01,0xff,0x03,0x00]

v_cmpx_ne_i16_e64 v1, s2
// GFX10: encoding: [0x00,0x00,0x9d,0xd4,0x01,0x05,0x00,0x00]

v_cmpx_ne_i16_e64 v1, s101
// GFX10: encoding: [0x00,0x00,0x9d,0xd4,0x01,0xcb,0x00,0x00]

v_cmpx_ne_i16_e64 v1, vcc_lo
// GFX10: encoding: [0x00,0x00,0x9d,0xd4,0x01,0xd5,0x00,0x00]

v_cmpx_ne_i16_e64 v1, vcc_hi
// GFX10: encoding: [0x00,0x00,0x9d,0xd4,0x01,0xd7,0x00,0x00]

v_cmpx_ne_i16_e64 v1, m0
// GFX10: encoding: [0x00,0x00,0x9d,0xd4,0x01,0xf9,0x00,0x00]

v_cmpx_ne_i16_e64 v1, exec_lo
// GFX10: encoding: [0x00,0x00,0x9d,0xd4,0x01,0xfd,0x00,0x00]

v_cmpx_ne_i16_e64 v1, exec_hi
// GFX10: encoding: [0x00,0x00,0x9d,0xd4,0x01,0xff,0x00,0x00]

v_cmpx_ne_i16_e64 v1, 0
// GFX10: encoding: [0x00,0x00,0x9d,0xd4,0x01,0x01,0x01,0x00]

v_cmpx_ne_i16_e64 v1, -1
// GFX10: encoding: [0x00,0x00,0x9d,0xd4,0x01,0x83,0x01,0x00]

v_cmpx_ne_i16_e64 v1, 0.5
// GFX10: encoding: [0x00,0x00,0x9d,0xd4,0x01,0xff,0x01,0x00,0x00,0x38,0x00,0x00]

v_cmpx_ne_i16_e64 v1, -4.0
// GFX10: encoding: [0x00,0x00,0x9d,0xd4,0x01,0xff,0x01,0x00,0x00,0xc4,0x00,0x00]

v_cmpx_ge_i16 v1, v2
// GFX10: encoding: [0x01,0x05,0x3c,0x7d]

v_cmpx_ge_i16 v255, v2
// GFX10: encoding: [0xff,0x05,0x3c,0x7d]

v_cmpx_ge_i16 s1, v2
// GFX10: encoding: [0x01,0x04,0x3c,0x7d]

v_cmpx_ge_i16 s101, v2
// GFX10: encoding: [0x65,0x04,0x3c,0x7d]

v_cmpx_ge_i16 vcc_lo, v2
// GFX10: encoding: [0x6a,0x04,0x3c,0x7d]

v_cmpx_ge_i16 vcc_hi, v2
// GFX10: encoding: [0x6b,0x04,0x3c,0x7d]

v_cmpx_ge_i16 m0, v2
// GFX10: encoding: [0x7c,0x04,0x3c,0x7d]

v_cmpx_ge_i16 exec_lo, v2
// GFX10: encoding: [0x7e,0x04,0x3c,0x7d]

v_cmpx_ge_i16 exec_hi, v2
// GFX10: encoding: [0x7f,0x04,0x3c,0x7d]

v_cmpx_ge_i16 0, v2
// GFX10: encoding: [0x80,0x04,0x3c,0x7d]

v_cmpx_ge_i16 -1, v2
// GFX10: encoding: [0xc1,0x04,0x3c,0x7d]

v_cmpx_ge_i16 0.5, v2
// GFX10: encoding: [0xff,0x04,0x3c,0x7d,0x00,0x38,0x00,0x00]

v_cmpx_ge_i16 -4.0, v2
// GFX10: encoding: [0xff,0x04,0x3c,0x7d,0x00,0xc4,0x00,0x00]

v_cmpx_ge_i16 0xfe0b, v2
// GFX10: encoding: [0xff,0x04,0x3c,0x7d,0x0b,0xfe,0x00,0x00]

v_cmpx_ge_i16 0x3456, v2
// GFX10: encoding: [0xff,0x04,0x3c,0x7d,0x56,0x34,0x00,0x00]

v_cmpx_ge_i16 v1, v255
// GFX10: encoding: [0x01,0xff,0x3d,0x7d]

v_cmpx_ge_i16_e64 v1, v2
// GFX10: encoding: [0x00,0x00,0x9e,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_ge_i16_e64 v255, v2
// GFX10: encoding: [0x00,0x00,0x9e,0xd4,0xff,0x05,0x02,0x00]

v_cmpx_ge_i16_e64 s1, v2
// GFX10: encoding: [0x00,0x00,0x9e,0xd4,0x01,0x04,0x02,0x00]

v_cmpx_ge_i16_e64 s101, v2
// GFX10: encoding: [0x00,0x00,0x9e,0xd4,0x65,0x04,0x02,0x00]

v_cmpx_ge_i16_e64 vcc_lo, v2
// GFX10: encoding: [0x00,0x00,0x9e,0xd4,0x6a,0x04,0x02,0x00]

v_cmpx_ge_i16_e64 vcc_hi, v2
// GFX10: encoding: [0x00,0x00,0x9e,0xd4,0x6b,0x04,0x02,0x00]

v_cmpx_ge_i16_e64 m0, v2
// GFX10: encoding: [0x00,0x00,0x9e,0xd4,0x7c,0x04,0x02,0x00]

v_cmpx_ge_i16_e64 exec_lo, v2
// GFX10: encoding: [0x00,0x00,0x9e,0xd4,0x7e,0x04,0x02,0x00]

v_cmpx_ge_i16_e64 exec_hi, v2
// GFX10: encoding: [0x00,0x00,0x9e,0xd4,0x7f,0x04,0x02,0x00]

v_cmpx_ge_i16_e64 0, v2
// GFX10: encoding: [0x00,0x00,0x9e,0xd4,0x80,0x04,0x02,0x00]

v_cmpx_ge_i16_e64 -1, v2
// GFX10: encoding: [0x00,0x00,0x9e,0xd4,0xc1,0x04,0x02,0x00]

v_cmpx_ge_i16_e64 0.5, v2
// GFX10: encoding: [0x00,0x00,0x9e,0xd4,0xff,0x04,0x02,0x00,0x00,0x38,0x00,0x00]

v_cmpx_ge_i16_e64 -4.0, v2
// GFX10: encoding: [0x00,0x00,0x9e,0xd4,0xff,0x04,0x02,0x00,0x00,0xc4,0x00,0x00]

v_cmpx_ge_i16_e64 v1, v255
// GFX10: encoding: [0x00,0x00,0x9e,0xd4,0x01,0xff,0x03,0x00]

v_cmpx_ge_i16_e64 v1, s2
// GFX10: encoding: [0x00,0x00,0x9e,0xd4,0x01,0x05,0x00,0x00]

v_cmpx_ge_i16_e64 v1, s101
// GFX10: encoding: [0x00,0x00,0x9e,0xd4,0x01,0xcb,0x00,0x00]

v_cmpx_ge_i16_e64 v1, vcc_lo
// GFX10: encoding: [0x00,0x00,0x9e,0xd4,0x01,0xd5,0x00,0x00]

v_cmpx_ge_i16_e64 v1, vcc_hi
// GFX10: encoding: [0x00,0x00,0x9e,0xd4,0x01,0xd7,0x00,0x00]

v_cmpx_ge_i16_e64 v1, m0
// GFX10: encoding: [0x00,0x00,0x9e,0xd4,0x01,0xf9,0x00,0x00]

v_cmpx_ge_i16_e64 v1, exec_lo
// GFX10: encoding: [0x00,0x00,0x9e,0xd4,0x01,0xfd,0x00,0x00]

v_cmpx_ge_i16_e64 v1, exec_hi
// GFX10: encoding: [0x00,0x00,0x9e,0xd4,0x01,0xff,0x00,0x00]

v_cmpx_ge_i16_e64 v1, 0
// GFX10: encoding: [0x00,0x00,0x9e,0xd4,0x01,0x01,0x01,0x00]

v_cmpx_ge_i16_e64 v1, -1
// GFX10: encoding: [0x00,0x00,0x9e,0xd4,0x01,0x83,0x01,0x00]

v_cmpx_ge_i16_e64 v1, 0.5
// GFX10: encoding: [0x00,0x00,0x9e,0xd4,0x01,0xff,0x01,0x00,0x00,0x38,0x00,0x00]

v_cmpx_ge_i16_e64 v1, -4.0
// GFX10: encoding: [0x00,0x00,0x9e,0xd4,0x01,0xff,0x01,0x00,0x00,0xc4,0x00,0x00]

v_cmpx_class_f16 v1, v2
// GFX10: encoding: [0x01,0x05,0x3e,0x7d]

v_cmpx_class_f16 v255, v2
// GFX10: encoding: [0xff,0x05,0x3e,0x7d]

v_cmpx_class_f16 s1, v2
// GFX10: encoding: [0x01,0x04,0x3e,0x7d]

v_cmpx_class_f16 s101, v2
// GFX10: encoding: [0x65,0x04,0x3e,0x7d]

v_cmpx_class_f16 vcc_lo, v2
// GFX10: encoding: [0x6a,0x04,0x3e,0x7d]

v_cmpx_class_f16 vcc_hi, v2
// GFX10: encoding: [0x6b,0x04,0x3e,0x7d]

v_cmpx_class_f16 m0, v2
// GFX10: encoding: [0x7c,0x04,0x3e,0x7d]

v_cmpx_class_f16 exec_lo, v2
// GFX10: encoding: [0x7e,0x04,0x3e,0x7d]

v_cmpx_class_f16 exec_hi, v2
// GFX10: encoding: [0x7f,0x04,0x3e,0x7d]

v_cmpx_class_f16 0, v2
// GFX10: encoding: [0x80,0x04,0x3e,0x7d]

v_cmpx_class_f16 -1, v2
// GFX10: encoding: [0xc1,0x04,0x3e,0x7d]

v_cmpx_class_f16 0.5, v2
// GFX10: encoding: [0xf0,0x04,0x3e,0x7d]

v_cmpx_class_f16 -4.0, v2
// GFX10: encoding: [0xf7,0x04,0x3e,0x7d]

v_cmpx_class_f16 0xfe0b, v2
// GFX10: encoding: [0xff,0x04,0x3e,0x7d,0x0b,0xfe,0x00,0x00]

v_cmpx_class_f16 0x3456, v2
// GFX10: encoding: [0xff,0x04,0x3e,0x7d,0x56,0x34,0x00,0x00]

v_cmpx_class_f16 v1, v255
// GFX10: encoding: [0x01,0xff,0x3f,0x7d]

v_cmpx_class_f16_e64 v1, v2
// GFX10: encoding: [0x00,0x00,0x9f,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_class_f16_e64 v255, v2
// GFX10: encoding: [0x00,0x00,0x9f,0xd4,0xff,0x05,0x02,0x00]

v_cmpx_class_f16_e64 s1, v2
// GFX10: encoding: [0x00,0x00,0x9f,0xd4,0x01,0x04,0x02,0x00]

v_cmpx_class_f16_e64 s101, v2
// GFX10: encoding: [0x00,0x00,0x9f,0xd4,0x65,0x04,0x02,0x00]

v_cmpx_class_f16_e64 vcc_lo, v2
// GFX10: encoding: [0x00,0x00,0x9f,0xd4,0x6a,0x04,0x02,0x00]

v_cmpx_class_f16_e64 vcc_hi, v2
// GFX10: encoding: [0x00,0x00,0x9f,0xd4,0x6b,0x04,0x02,0x00]

v_cmpx_class_f16_e64 m0, v2
// GFX10: encoding: [0x00,0x00,0x9f,0xd4,0x7c,0x04,0x02,0x00]

v_cmpx_class_f16_e64 exec_lo, v2
// GFX10: encoding: [0x00,0x00,0x9f,0xd4,0x7e,0x04,0x02,0x00]

v_cmpx_class_f16_e64 exec_hi, v2
// GFX10: encoding: [0x00,0x00,0x9f,0xd4,0x7f,0x04,0x02,0x00]

v_cmpx_class_f16_e64 0, v2
// GFX10: encoding: [0x00,0x00,0x9f,0xd4,0x80,0x04,0x02,0x00]

v_cmpx_class_f16_e64 -1, v2
// GFX10: encoding: [0x00,0x00,0x9f,0xd4,0xc1,0x04,0x02,0x00]

v_cmpx_class_f16_e64 0.5, v2
// GFX10: encoding: [0x00,0x00,0x9f,0xd4,0xf0,0x04,0x02,0x00]

v_cmpx_class_f16_e64 -4.0, v2
// GFX10: encoding: [0x00,0x00,0x9f,0xd4,0xf7,0x04,0x02,0x00]

v_cmpx_class_f16_e64 v1, v255
// GFX10: encoding: [0x00,0x00,0x9f,0xd4,0x01,0xff,0x03,0x00]

v_cmpx_class_f16_e64 v1, s2
// GFX10: encoding: [0x00,0x00,0x9f,0xd4,0x01,0x05,0x00,0x00]

v_cmpx_class_f16_e64 v1, s101
// GFX10: encoding: [0x00,0x00,0x9f,0xd4,0x01,0xcb,0x00,0x00]

v_cmpx_class_f16_e64 v1, vcc_lo
// GFX10: encoding: [0x00,0x00,0x9f,0xd4,0x01,0xd5,0x00,0x00]

v_cmpx_class_f16_e64 v1, vcc_hi
// GFX10: encoding: [0x00,0x00,0x9f,0xd4,0x01,0xd7,0x00,0x00]

v_cmpx_class_f16_e64 v1, m0
// GFX10: encoding: [0x00,0x00,0x9f,0xd4,0x01,0xf9,0x00,0x00]

v_cmpx_class_f16_e64 v1, exec_lo
// GFX10: encoding: [0x00,0x00,0x9f,0xd4,0x01,0xfd,0x00,0x00]

v_cmpx_class_f16_e64 v1, exec_hi
// GFX10: encoding: [0x00,0x00,0x9f,0xd4,0x01,0xff,0x00,0x00]

v_cmpx_class_f16_e64 v1, 0
// GFX10: encoding: [0x00,0x00,0x9f,0xd4,0x01,0x01,0x01,0x00]

v_cmpx_class_f16_e64 v1, -1
// GFX10: encoding: [0x00,0x00,0x9f,0xd4,0x01,0x83,0x01,0x00]

v_cmpx_class_f16_e64 v1, 0.5
// GFX10: encoding: [0x00,0x00,0x9f,0xd4,0x01,0xe1,0x01,0x00]

v_cmpx_class_f16_e64 v1, -4.0
// GFX10: encoding: [0x00,0x00,0x9f,0xd4,0x01,0xef,0x01,0x00]

v_cmpx_class_f16_e64 -v1, v2
// GFX10: encoding: [0x00,0x00,0x9f,0xd4,0x01,0x05,0x02,0x20]

v_cmpx_f_i64 v[1:2], v[2:3]
// GFX10: encoding: [0x01,0x05,0x60,0x7d]

v_cmpx_f_i64 v[254:255], v[2:3]
// GFX10: encoding: [0xfe,0x05,0x60,0x7d]

v_cmpx_f_i64 s[2:3], v[2:3]
// GFX10: encoding: [0x02,0x04,0x60,0x7d]

v_cmpx_f_i64 s[4:5], v[2:3]
// GFX10: encoding: [0x04,0x04,0x60,0x7d]

v_cmpx_f_i64 s[100:101], v[2:3]
// GFX10: encoding: [0x64,0x04,0x60,0x7d]

v_cmpx_f_i64 vcc, v[2:3]
// GFX10: encoding: [0x6a,0x04,0x60,0x7d]

v_cmpx_f_i64 exec, v[2:3]
// GFX10: encoding: [0x7e,0x04,0x60,0x7d]

v_cmpx_f_i64 0, v[2:3]
// GFX10: encoding: [0x80,0x04,0x60,0x7d]

v_cmpx_f_i64 -1, v[2:3]
// GFX10: encoding: [0xc1,0x04,0x60,0x7d]

v_cmpx_f_i64 0.5, v[2:3]
// GFX10: encoding: [0xf0,0x04,0x60,0x7d]

v_cmpx_f_i64 -4.0, v[2:3]
// GFX10: encoding: [0xf7,0x04,0x60,0x7d]

v_cmpx_f_i64 0xaf123456, v[2:3]
// GFX10: encoding: [0xff,0x04,0x60,0x7d,0x56,0x34,0x12,0xaf]

v_cmpx_f_i64 0x3f717273, v[2:3]
// GFX10: encoding: [0xff,0x04,0x60,0x7d,0x73,0x72,0x71,0x3f]

v_cmpx_f_i64 v[1:2], v[254:255]
// GFX10: encoding: [0x01,0xfd,0x61,0x7d]

v_cmpx_f_i64_e64 v[1:2], v[2:3]
// GFX10: encoding: [0x00,0x00,0xb0,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_f_i64_e64 v[254:255], v[2:3]
// GFX10: encoding: [0x00,0x00,0xb0,0xd4,0xfe,0x05,0x02,0x00]

v_cmpx_f_i64_e64 s[2:3], v[2:3]
// GFX10: encoding: [0x00,0x00,0xb0,0xd4,0x02,0x04,0x02,0x00]

v_cmpx_f_i64_e64 s[4:5], v[2:3]
// GFX10: encoding: [0x00,0x00,0xb0,0xd4,0x04,0x04,0x02,0x00]

v_cmpx_f_i64_e64 vcc, v[2:3]
// GFX10: encoding: [0x00,0x00,0xb0,0xd4,0x6a,0x04,0x02,0x00]

v_cmpx_f_i64_e64 0, v[2:3]
// GFX10: encoding: [0x00,0x00,0xb0,0xd4,0x80,0x04,0x02,0x00]

v_cmpx_f_i64_e64 -1, v[2:3]
// GFX10: encoding: [0x00,0x00,0xb0,0xd4,0xc1,0x04,0x02,0x00]

v_cmpx_f_i64_e64 0.5, v[2:3]
// GFX10: encoding: [0x00,0x00,0xb0,0xd4,0xf0,0x04,0x02,0x00]

v_cmpx_f_i64_e64 -4.0, v[2:3]
// GFX10: encoding: [0x00,0x00,0xb0,0xd4,0xf7,0x04,0x02,0x00]

v_cmpx_f_i64_e64 v[1:2], v[254:255]
// GFX10: encoding: [0x00,0x00,0xb0,0xd4,0x01,0xfd,0x03,0x00]

v_cmpx_f_i64_e64 v[1:2], s[4:5]
// GFX10: encoding: [0x00,0x00,0xb0,0xd4,0x01,0x09,0x00,0x00]

v_cmpx_f_i64_e64 v[1:2], s[6:7]
// GFX10: encoding: [0x00,0x00,0xb0,0xd4,0x01,0x0d,0x00,0x00]

v_cmpx_f_i64_e64 v[1:2], s[100:101]
// GFX10: encoding: [0x00,0x00,0xb0,0xd4,0x01,0xc9,0x00,0x00]

v_cmpx_f_i64_e64 v[1:2], vcc
// GFX10: encoding: [0x00,0x00,0xb0,0xd4,0x01,0xd5,0x00,0x00]

v_cmpx_f_i64_e64 v[1:2], exec
// GFX10: encoding: [0x00,0x00,0xb0,0xd4,0x01,0xfd,0x00,0x00]

v_cmpx_f_i64_e64 v[1:2], 0
// GFX10: encoding: [0x00,0x00,0xb0,0xd4,0x01,0x01,0x01,0x00]

v_cmpx_f_i64_e64 v[1:2], -1
// GFX10: encoding: [0x00,0x00,0xb0,0xd4,0x01,0x83,0x01,0x00]

v_cmpx_f_i64_e64 v[1:2], 0.5
// GFX10: encoding: [0x00,0x00,0xb0,0xd4,0x01,0xe1,0x01,0x00]

v_cmpx_f_i64_e64 v[1:2], -4.0
// GFX10: encoding: [0x00,0x00,0xb0,0xd4,0x01,0xef,0x01,0x00]

v_cmpx_lt_i64 v[1:2], v[2:3]
// GFX10: encoding: [0x01,0x05,0x62,0x7d]

v_cmpx_lt_i64 v[254:255], v[2:3]
// GFX10: encoding: [0xfe,0x05,0x62,0x7d]

v_cmpx_lt_i64 s[2:3], v[2:3]
// GFX10: encoding: [0x02,0x04,0x62,0x7d]

v_cmpx_lt_i64 s[4:5], v[2:3]
// GFX10: encoding: [0x04,0x04,0x62,0x7d]

v_cmpx_lt_i64 s[100:101], v[2:3]
// GFX10: encoding: [0x64,0x04,0x62,0x7d]

v_cmpx_lt_i64 vcc, v[2:3]
// GFX10: encoding: [0x6a,0x04,0x62,0x7d]

v_cmpx_lt_i64 exec, v[2:3]
// GFX10: encoding: [0x7e,0x04,0x62,0x7d]

v_cmpx_lt_i64 0, v[2:3]
// GFX10: encoding: [0x80,0x04,0x62,0x7d]

v_cmpx_lt_i64 -1, v[2:3]
// GFX10: encoding: [0xc1,0x04,0x62,0x7d]

v_cmpx_lt_i64 0.5, v[2:3]
// GFX10: encoding: [0xf0,0x04,0x62,0x7d]

v_cmpx_lt_i64 -4.0, v[2:3]
// GFX10: encoding: [0xf7,0x04,0x62,0x7d]

v_cmpx_lt_i64 0xaf123456, v[2:3]
// GFX10: encoding: [0xff,0x04,0x62,0x7d,0x56,0x34,0x12,0xaf]

v_cmpx_lt_i64 0x3f717273, v[2:3]
// GFX10: encoding: [0xff,0x04,0x62,0x7d,0x73,0x72,0x71,0x3f]

v_cmpx_lt_i64 v[1:2], v[254:255]
// GFX10: encoding: [0x01,0xfd,0x63,0x7d]

v_cmpx_lt_i64_e64 v[1:2], v[2:3]
// GFX10: encoding: [0x00,0x00,0xb1,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_lt_i64_e64 v[254:255], v[2:3]
// GFX10: encoding: [0x00,0x00,0xb1,0xd4,0xfe,0x05,0x02,0x00]

v_cmpx_lt_i64_e64 s[2:3], v[2:3]
// GFX10: encoding: [0x00,0x00,0xb1,0xd4,0x02,0x04,0x02,0x00]

v_cmpx_lt_i64_e64 s[4:5], v[2:3]
// GFX10: encoding: [0x00,0x00,0xb1,0xd4,0x04,0x04,0x02,0x00]

v_cmpx_lt_i64_e64 vcc, v[2:3]
// GFX10: encoding: [0x00,0x00,0xb1,0xd4,0x6a,0x04,0x02,0x00]

v_cmpx_lt_i64_e64 0, v[2:3]
// GFX10: encoding: [0x00,0x00,0xb1,0xd4,0x80,0x04,0x02,0x00]

v_cmpx_lt_i64_e64 -1, v[2:3]
// GFX10: encoding: [0x00,0x00,0xb1,0xd4,0xc1,0x04,0x02,0x00]

v_cmpx_lt_i64_e64 0.5, v[2:3]
// GFX10: encoding: [0x00,0x00,0xb1,0xd4,0xf0,0x04,0x02,0x00]

v_cmpx_lt_i64_e64 -4.0, v[2:3]
// GFX10: encoding: [0x00,0x00,0xb1,0xd4,0xf7,0x04,0x02,0x00]

v_cmpx_lt_i64_e64 v[1:2], v[254:255]
// GFX10: encoding: [0x00,0x00,0xb1,0xd4,0x01,0xfd,0x03,0x00]

v_cmpx_lt_i64_e64 v[1:2], s[4:5]
// GFX10: encoding: [0x00,0x00,0xb1,0xd4,0x01,0x09,0x00,0x00]

v_cmpx_lt_i64_e64 v[1:2], s[6:7]
// GFX10: encoding: [0x00,0x00,0xb1,0xd4,0x01,0x0d,0x00,0x00]

v_cmpx_lt_i64_e64 v[1:2], s[100:101]
// GFX10: encoding: [0x00,0x00,0xb1,0xd4,0x01,0xc9,0x00,0x00]

v_cmpx_lt_i64_e64 v[1:2], vcc
// GFX10: encoding: [0x00,0x00,0xb1,0xd4,0x01,0xd5,0x00,0x00]

v_cmpx_lt_i64_e64 v[1:2], exec
// GFX10: encoding: [0x00,0x00,0xb1,0xd4,0x01,0xfd,0x00,0x00]

v_cmpx_lt_i64_e64 v[1:2], 0
// GFX10: encoding: [0x00,0x00,0xb1,0xd4,0x01,0x01,0x01,0x00]

v_cmpx_lt_i64_e64 v[1:2], -1
// GFX10: encoding: [0x00,0x00,0xb1,0xd4,0x01,0x83,0x01,0x00]

v_cmpx_lt_i64_e64 v[1:2], 0.5
// GFX10: encoding: [0x00,0x00,0xb1,0xd4,0x01,0xe1,0x01,0x00]

v_cmpx_lt_i64_e64 v[1:2], -4.0
// GFX10: encoding: [0x00,0x00,0xb1,0xd4,0x01,0xef,0x01,0x00]

v_cmpx_eq_i64 v[1:2], v[2:3]
// GFX10: encoding: [0x01,0x05,0x64,0x7d]

v_cmpx_eq_i64 v[254:255], v[2:3]
// GFX10: encoding: [0xfe,0x05,0x64,0x7d]

v_cmpx_eq_i64 s[2:3], v[2:3]
// GFX10: encoding: [0x02,0x04,0x64,0x7d]

v_cmpx_eq_i64 s[4:5], v[2:3]
// GFX10: encoding: [0x04,0x04,0x64,0x7d]

v_cmpx_eq_i64 s[100:101], v[2:3]
// GFX10: encoding: [0x64,0x04,0x64,0x7d]

v_cmpx_eq_i64 vcc, v[2:3]
// GFX10: encoding: [0x6a,0x04,0x64,0x7d]

v_cmpx_eq_i64 exec, v[2:3]
// GFX10: encoding: [0x7e,0x04,0x64,0x7d]

v_cmpx_eq_i64 0, v[2:3]
// GFX10: encoding: [0x80,0x04,0x64,0x7d]

v_cmpx_eq_i64 -1, v[2:3]
// GFX10: encoding: [0xc1,0x04,0x64,0x7d]

v_cmpx_eq_i64 0.5, v[2:3]
// GFX10: encoding: [0xf0,0x04,0x64,0x7d]

v_cmpx_eq_i64 -4.0, v[2:3]
// GFX10: encoding: [0xf7,0x04,0x64,0x7d]

v_cmpx_eq_i64 0xaf123456, v[2:3]
// GFX10: encoding: [0xff,0x04,0x64,0x7d,0x56,0x34,0x12,0xaf]

v_cmpx_eq_i64 0x3f717273, v[2:3]
// GFX10: encoding: [0xff,0x04,0x64,0x7d,0x73,0x72,0x71,0x3f]

v_cmpx_eq_i64 v[1:2], v[254:255]
// GFX10: encoding: [0x01,0xfd,0x65,0x7d]

v_cmpx_eq_i64_e64 v[1:2], v[2:3]
// GFX10: encoding: [0x00,0x00,0xb2,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_eq_i64_e64 v[254:255], v[2:3]
// GFX10: encoding: [0x00,0x00,0xb2,0xd4,0xfe,0x05,0x02,0x00]

v_cmpx_eq_i64_e64 s[2:3], v[2:3]
// GFX10: encoding: [0x00,0x00,0xb2,0xd4,0x02,0x04,0x02,0x00]

v_cmpx_eq_i64_e64 s[4:5], v[2:3]
// GFX10: encoding: [0x00,0x00,0xb2,0xd4,0x04,0x04,0x02,0x00]

v_cmpx_eq_i64_e64 vcc, v[2:3]
// GFX10: encoding: [0x00,0x00,0xb2,0xd4,0x6a,0x04,0x02,0x00]

v_cmpx_eq_i64_e64 0, v[2:3]
// GFX10: encoding: [0x00,0x00,0xb2,0xd4,0x80,0x04,0x02,0x00]

v_cmpx_eq_i64_e64 -1, v[2:3]
// GFX10: encoding: [0x00,0x00,0xb2,0xd4,0xc1,0x04,0x02,0x00]

v_cmpx_eq_i64_e64 0.5, v[2:3]
// GFX10: encoding: [0x00,0x00,0xb2,0xd4,0xf0,0x04,0x02,0x00]

v_cmpx_eq_i64_e64 -4.0, v[2:3]
// GFX10: encoding: [0x00,0x00,0xb2,0xd4,0xf7,0x04,0x02,0x00]

v_cmpx_eq_i64_e64 v[1:2], v[254:255]
// GFX10: encoding: [0x00,0x00,0xb2,0xd4,0x01,0xfd,0x03,0x00]

v_cmpx_eq_i64_e64 v[1:2], s[4:5]
// GFX10: encoding: [0x00,0x00,0xb2,0xd4,0x01,0x09,0x00,0x00]

v_cmpx_eq_i64_e64 v[1:2], s[6:7]
// GFX10: encoding: [0x00,0x00,0xb2,0xd4,0x01,0x0d,0x00,0x00]

v_cmpx_eq_i64_e64 v[1:2], s[100:101]
// GFX10: encoding: [0x00,0x00,0xb2,0xd4,0x01,0xc9,0x00,0x00]

v_cmpx_eq_i64_e64 v[1:2], vcc
// GFX10: encoding: [0x00,0x00,0xb2,0xd4,0x01,0xd5,0x00,0x00]

v_cmpx_eq_i64_e64 v[1:2], exec
// GFX10: encoding: [0x00,0x00,0xb2,0xd4,0x01,0xfd,0x00,0x00]

v_cmpx_eq_i64_e64 v[1:2], 0
// GFX10: encoding: [0x00,0x00,0xb2,0xd4,0x01,0x01,0x01,0x00]

v_cmpx_eq_i64_e64 v[1:2], -1
// GFX10: encoding: [0x00,0x00,0xb2,0xd4,0x01,0x83,0x01,0x00]

v_cmpx_eq_i64_e64 v[1:2], 0.5
// GFX10: encoding: [0x00,0x00,0xb2,0xd4,0x01,0xe1,0x01,0x00]

v_cmpx_eq_i64_e64 v[1:2], -4.0
// GFX10: encoding: [0x00,0x00,0xb2,0xd4,0x01,0xef,0x01,0x00]

v_cmpx_le_i64 v[1:2], v[2:3]
// GFX10: encoding: [0x01,0x05,0x66,0x7d]

v_cmpx_le_i64 v[254:255], v[2:3]
// GFX10: encoding: [0xfe,0x05,0x66,0x7d]

v_cmpx_le_i64 s[2:3], v[2:3]
// GFX10: encoding: [0x02,0x04,0x66,0x7d]

v_cmpx_le_i64 s[4:5], v[2:3]
// GFX10: encoding: [0x04,0x04,0x66,0x7d]

v_cmpx_le_i64 s[100:101], v[2:3]
// GFX10: encoding: [0x64,0x04,0x66,0x7d]

v_cmpx_le_i64 vcc, v[2:3]
// GFX10: encoding: [0x6a,0x04,0x66,0x7d]

v_cmpx_le_i64 exec, v[2:3]
// GFX10: encoding: [0x7e,0x04,0x66,0x7d]

v_cmpx_le_i64 0, v[2:3]
// GFX10: encoding: [0x80,0x04,0x66,0x7d]

v_cmpx_le_i64 -1, v[2:3]
// GFX10: encoding: [0xc1,0x04,0x66,0x7d]

v_cmpx_le_i64 0.5, v[2:3]
// GFX10: encoding: [0xf0,0x04,0x66,0x7d]

v_cmpx_le_i64 -4.0, v[2:3]
// GFX10: encoding: [0xf7,0x04,0x66,0x7d]

v_cmpx_le_i64 0xaf123456, v[2:3]
// GFX10: encoding: [0xff,0x04,0x66,0x7d,0x56,0x34,0x12,0xaf]

v_cmpx_le_i64 0x3f717273, v[2:3]
// GFX10: encoding: [0xff,0x04,0x66,0x7d,0x73,0x72,0x71,0x3f]

v_cmpx_le_i64 v[1:2], v[254:255]
// GFX10: encoding: [0x01,0xfd,0x67,0x7d]

v_cmpx_le_i64_e64 v[1:2], v[2:3]
// GFX10: encoding: [0x00,0x00,0xb3,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_le_i64_e64 v[254:255], v[2:3]
// GFX10: encoding: [0x00,0x00,0xb3,0xd4,0xfe,0x05,0x02,0x00]

v_cmpx_le_i64_e64 s[2:3], v[2:3]
// GFX10: encoding: [0x00,0x00,0xb3,0xd4,0x02,0x04,0x02,0x00]

v_cmpx_le_i64_e64 s[4:5], v[2:3]
// GFX10: encoding: [0x00,0x00,0xb3,0xd4,0x04,0x04,0x02,0x00]

v_cmpx_le_i64_e64 vcc, v[2:3]
// GFX10: encoding: [0x00,0x00,0xb3,0xd4,0x6a,0x04,0x02,0x00]

v_cmpx_le_i64_e64 0, v[2:3]
// GFX10: encoding: [0x00,0x00,0xb3,0xd4,0x80,0x04,0x02,0x00]

v_cmpx_le_i64_e64 -1, v[2:3]
// GFX10: encoding: [0x00,0x00,0xb3,0xd4,0xc1,0x04,0x02,0x00]

v_cmpx_le_i64_e64 0.5, v[2:3]
// GFX10: encoding: [0x00,0x00,0xb3,0xd4,0xf0,0x04,0x02,0x00]

v_cmpx_le_i64_e64 -4.0, v[2:3]
// GFX10: encoding: [0x00,0x00,0xb3,0xd4,0xf7,0x04,0x02,0x00]

v_cmpx_le_i64_e64 v[1:2], v[254:255]
// GFX10: encoding: [0x00,0x00,0xb3,0xd4,0x01,0xfd,0x03,0x00]

v_cmpx_le_i64_e64 v[1:2], s[4:5]
// GFX10: encoding: [0x00,0x00,0xb3,0xd4,0x01,0x09,0x00,0x00]

v_cmpx_le_i64_e64 v[1:2], s[6:7]
// GFX10: encoding: [0x00,0x00,0xb3,0xd4,0x01,0x0d,0x00,0x00]

v_cmpx_le_i64_e64 v[1:2], s[100:101]
// GFX10: encoding: [0x00,0x00,0xb3,0xd4,0x01,0xc9,0x00,0x00]

v_cmpx_le_i64_e64 v[1:2], vcc
// GFX10: encoding: [0x00,0x00,0xb3,0xd4,0x01,0xd5,0x00,0x00]

v_cmpx_le_i64_e64 v[1:2], exec
// GFX10: encoding: [0x00,0x00,0xb3,0xd4,0x01,0xfd,0x00,0x00]

v_cmpx_le_i64_e64 v[1:2], 0
// GFX10: encoding: [0x00,0x00,0xb3,0xd4,0x01,0x01,0x01,0x00]

v_cmpx_le_i64_e64 v[1:2], -1
// GFX10: encoding: [0x00,0x00,0xb3,0xd4,0x01,0x83,0x01,0x00]

v_cmpx_le_i64_e64 v[1:2], 0.5
// GFX10: encoding: [0x00,0x00,0xb3,0xd4,0x01,0xe1,0x01,0x00]

v_cmpx_le_i64_e64 v[1:2], -4.0
// GFX10: encoding: [0x00,0x00,0xb3,0xd4,0x01,0xef,0x01,0x00]

v_cmpx_gt_i64 v[1:2], v[2:3]
// GFX10: encoding: [0x01,0x05,0x68,0x7d]

v_cmpx_gt_i64 v[254:255], v[2:3]
// GFX10: encoding: [0xfe,0x05,0x68,0x7d]

v_cmpx_gt_i64 s[2:3], v[2:3]
// GFX10: encoding: [0x02,0x04,0x68,0x7d]

v_cmpx_gt_i64 s[4:5], v[2:3]
// GFX10: encoding: [0x04,0x04,0x68,0x7d]

v_cmpx_gt_i64 s[100:101], v[2:3]
// GFX10: encoding: [0x64,0x04,0x68,0x7d]

v_cmpx_gt_i64 vcc, v[2:3]
// GFX10: encoding: [0x6a,0x04,0x68,0x7d]

v_cmpx_gt_i64 exec, v[2:3]
// GFX10: encoding: [0x7e,0x04,0x68,0x7d]

v_cmpx_gt_i64 0, v[2:3]
// GFX10: encoding: [0x80,0x04,0x68,0x7d]

v_cmpx_gt_i64 -1, v[2:3]
// GFX10: encoding: [0xc1,0x04,0x68,0x7d]

v_cmpx_gt_i64 0.5, v[2:3]
// GFX10: encoding: [0xf0,0x04,0x68,0x7d]

v_cmpx_gt_i64 -4.0, v[2:3]
// GFX10: encoding: [0xf7,0x04,0x68,0x7d]

v_cmpx_gt_i64 0xaf123456, v[2:3]
// GFX10: encoding: [0xff,0x04,0x68,0x7d,0x56,0x34,0x12,0xaf]

v_cmpx_gt_i64 0x3f717273, v[2:3]
// GFX10: encoding: [0xff,0x04,0x68,0x7d,0x73,0x72,0x71,0x3f]

v_cmpx_gt_i64 v[1:2], v[254:255]
// GFX10: encoding: [0x01,0xfd,0x69,0x7d]

v_cmpx_gt_i64_e64 v[1:2], v[2:3]
// GFX10: encoding: [0x00,0x00,0xb4,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_gt_i64_e64 v[254:255], v[2:3]
// GFX10: encoding: [0x00,0x00,0xb4,0xd4,0xfe,0x05,0x02,0x00]

v_cmpx_gt_i64_e64 s[2:3], v[2:3]
// GFX10: encoding: [0x00,0x00,0xb4,0xd4,0x02,0x04,0x02,0x00]

v_cmpx_gt_i64_e64 s[4:5], v[2:3]
// GFX10: encoding: [0x00,0x00,0xb4,0xd4,0x04,0x04,0x02,0x00]

v_cmpx_gt_i64_e64 vcc, v[2:3]
// GFX10: encoding: [0x00,0x00,0xb4,0xd4,0x6a,0x04,0x02,0x00]

v_cmpx_gt_i64_e64 0, v[2:3]
// GFX10: encoding: [0x00,0x00,0xb4,0xd4,0x80,0x04,0x02,0x00]

v_cmpx_gt_i64_e64 -1, v[2:3]
// GFX10: encoding: [0x00,0x00,0xb4,0xd4,0xc1,0x04,0x02,0x00]

v_cmpx_gt_i64_e64 0.5, v[2:3]
// GFX10: encoding: [0x00,0x00,0xb4,0xd4,0xf0,0x04,0x02,0x00]

v_cmpx_gt_i64_e64 -4.0, v[2:3]
// GFX10: encoding: [0x00,0x00,0xb4,0xd4,0xf7,0x04,0x02,0x00]

v_cmpx_gt_i64_e64 v[1:2], v[254:255]
// GFX10: encoding: [0x00,0x00,0xb4,0xd4,0x01,0xfd,0x03,0x00]

v_cmpx_gt_i64_e64 v[1:2], s[4:5]
// GFX10: encoding: [0x00,0x00,0xb4,0xd4,0x01,0x09,0x00,0x00]

v_cmpx_gt_i64_e64 v[1:2], s[6:7]
// GFX10: encoding: [0x00,0x00,0xb4,0xd4,0x01,0x0d,0x00,0x00]

v_cmpx_gt_i64_e64 v[1:2], s[100:101]
// GFX10: encoding: [0x00,0x00,0xb4,0xd4,0x01,0xc9,0x00,0x00]

v_cmpx_gt_i64_e64 v[1:2], vcc
// GFX10: encoding: [0x00,0x00,0xb4,0xd4,0x01,0xd5,0x00,0x00]

v_cmpx_gt_i64_e64 v[1:2], exec
// GFX10: encoding: [0x00,0x00,0xb4,0xd4,0x01,0xfd,0x00,0x00]

v_cmpx_gt_i64_e64 v[1:2], 0
// GFX10: encoding: [0x00,0x00,0xb4,0xd4,0x01,0x01,0x01,0x00]

v_cmpx_gt_i64_e64 v[1:2], -1
// GFX10: encoding: [0x00,0x00,0xb4,0xd4,0x01,0x83,0x01,0x00]

v_cmpx_gt_i64_e64 v[1:2], 0.5
// GFX10: encoding: [0x00,0x00,0xb4,0xd4,0x01,0xe1,0x01,0x00]

v_cmpx_gt_i64_e64 v[1:2], -4.0
// GFX10: encoding: [0x00,0x00,0xb4,0xd4,0x01,0xef,0x01,0x00]

v_cmpx_ne_i64 v[1:2], v[2:3]
// GFX10: encoding: [0x01,0x05,0x6a,0x7d]

v_cmpx_ne_i64 v[254:255], v[2:3]
// GFX10: encoding: [0xfe,0x05,0x6a,0x7d]

v_cmpx_ne_i64 s[2:3], v[2:3]
// GFX10: encoding: [0x02,0x04,0x6a,0x7d]

v_cmpx_ne_i64 s[4:5], v[2:3]
// GFX10: encoding: [0x04,0x04,0x6a,0x7d]

v_cmpx_ne_i64 s[100:101], v[2:3]
// GFX10: encoding: [0x64,0x04,0x6a,0x7d]

v_cmpx_ne_i64 vcc, v[2:3]
// GFX10: encoding: [0x6a,0x04,0x6a,0x7d]

v_cmpx_ne_i64 exec, v[2:3]
// GFX10: encoding: [0x7e,0x04,0x6a,0x7d]

v_cmpx_ne_i64 0, v[2:3]
// GFX10: encoding: [0x80,0x04,0x6a,0x7d]

v_cmpx_ne_i64 -1, v[2:3]
// GFX10: encoding: [0xc1,0x04,0x6a,0x7d]

v_cmpx_ne_i64 0.5, v[2:3]
// GFX10: encoding: [0xf0,0x04,0x6a,0x7d]

v_cmpx_ne_i64 -4.0, v[2:3]
// GFX10: encoding: [0xf7,0x04,0x6a,0x7d]

v_cmpx_ne_i64 0xaf123456, v[2:3]
// GFX10: encoding: [0xff,0x04,0x6a,0x7d,0x56,0x34,0x12,0xaf]

v_cmpx_ne_i64 0x3f717273, v[2:3]
// GFX10: encoding: [0xff,0x04,0x6a,0x7d,0x73,0x72,0x71,0x3f]

v_cmpx_ne_i64 v[1:2], v[254:255]
// GFX10: encoding: [0x01,0xfd,0x6b,0x7d]

v_cmpx_ne_i64_e64 v[1:2], v[2:3]
// GFX10: encoding: [0x00,0x00,0xb5,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_ne_i64_e64 v[254:255], v[2:3]
// GFX10: encoding: [0x00,0x00,0xb5,0xd4,0xfe,0x05,0x02,0x00]

v_cmpx_ne_i64_e64 s[2:3], v[2:3]
// GFX10: encoding: [0x00,0x00,0xb5,0xd4,0x02,0x04,0x02,0x00]

v_cmpx_ne_i64_e64 s[4:5], v[2:3]
// GFX10: encoding: [0x00,0x00,0xb5,0xd4,0x04,0x04,0x02,0x00]

v_cmpx_ne_i64_e64 vcc, v[2:3]
// GFX10: encoding: [0x00,0x00,0xb5,0xd4,0x6a,0x04,0x02,0x00]

v_cmpx_ne_i64_e64 0, v[2:3]
// GFX10: encoding: [0x00,0x00,0xb5,0xd4,0x80,0x04,0x02,0x00]

v_cmpx_ne_i64_e64 -1, v[2:3]
// GFX10: encoding: [0x00,0x00,0xb5,0xd4,0xc1,0x04,0x02,0x00]

v_cmpx_ne_i64_e64 0.5, v[2:3]
// GFX10: encoding: [0x00,0x00,0xb5,0xd4,0xf0,0x04,0x02,0x00]

v_cmpx_ne_i64_e64 -4.0, v[2:3]
// GFX10: encoding: [0x00,0x00,0xb5,0xd4,0xf7,0x04,0x02,0x00]

v_cmpx_ne_i64_e64 v[1:2], v[254:255]
// GFX10: encoding: [0x00,0x00,0xb5,0xd4,0x01,0xfd,0x03,0x00]

v_cmpx_ne_i64_e64 v[1:2], s[4:5]
// GFX10: encoding: [0x00,0x00,0xb5,0xd4,0x01,0x09,0x00,0x00]

v_cmpx_ne_i64_e64 v[1:2], s[6:7]
// GFX10: encoding: [0x00,0x00,0xb5,0xd4,0x01,0x0d,0x00,0x00]

v_cmpx_ne_i64_e64 v[1:2], s[100:101]
// GFX10: encoding: [0x00,0x00,0xb5,0xd4,0x01,0xc9,0x00,0x00]

v_cmpx_ne_i64_e64 v[1:2], vcc
// GFX10: encoding: [0x00,0x00,0xb5,0xd4,0x01,0xd5,0x00,0x00]

v_cmpx_ne_i64_e64 v[1:2], exec
// GFX10: encoding: [0x00,0x00,0xb5,0xd4,0x01,0xfd,0x00,0x00]

v_cmpx_ne_i64_e64 v[1:2], 0
// GFX10: encoding: [0x00,0x00,0xb5,0xd4,0x01,0x01,0x01,0x00]

v_cmpx_ne_i64_e64 v[1:2], -1
// GFX10: encoding: [0x00,0x00,0xb5,0xd4,0x01,0x83,0x01,0x00]

v_cmpx_ne_i64_e64 v[1:2], 0.5
// GFX10: encoding: [0x00,0x00,0xb5,0xd4,0x01,0xe1,0x01,0x00]

v_cmpx_ne_i64_e64 v[1:2], -4.0
// GFX10: encoding: [0x00,0x00,0xb5,0xd4,0x01,0xef,0x01,0x00]

v_cmpx_ge_i64 v[1:2], v[2:3]
// GFX10: encoding: [0x01,0x05,0x6c,0x7d]

v_cmpx_ge_i64 v[254:255], v[2:3]
// GFX10: encoding: [0xfe,0x05,0x6c,0x7d]

v_cmpx_ge_i64 s[2:3], v[2:3]
// GFX10: encoding: [0x02,0x04,0x6c,0x7d]

v_cmpx_ge_i64 s[4:5], v[2:3]
// GFX10: encoding: [0x04,0x04,0x6c,0x7d]

v_cmpx_ge_i64 s[100:101], v[2:3]
// GFX10: encoding: [0x64,0x04,0x6c,0x7d]

v_cmpx_ge_i64 vcc, v[2:3]
// GFX10: encoding: [0x6a,0x04,0x6c,0x7d]

v_cmpx_ge_i64 exec, v[2:3]
// GFX10: encoding: [0x7e,0x04,0x6c,0x7d]

v_cmpx_ge_i64 0, v[2:3]
// GFX10: encoding: [0x80,0x04,0x6c,0x7d]

v_cmpx_ge_i64 -1, v[2:3]
// GFX10: encoding: [0xc1,0x04,0x6c,0x7d]

v_cmpx_ge_i64 0.5, v[2:3]
// GFX10: encoding: [0xf0,0x04,0x6c,0x7d]

v_cmpx_ge_i64 -4.0, v[2:3]
// GFX10: encoding: [0xf7,0x04,0x6c,0x7d]

v_cmpx_ge_i64 0xaf123456, v[2:3]
// GFX10: encoding: [0xff,0x04,0x6c,0x7d,0x56,0x34,0x12,0xaf]

v_cmpx_ge_i64 0x3f717273, v[2:3]
// GFX10: encoding: [0xff,0x04,0x6c,0x7d,0x73,0x72,0x71,0x3f]

v_cmpx_ge_i64 v[1:2], v[254:255]
// GFX10: encoding: [0x01,0xfd,0x6d,0x7d]

v_cmpx_ge_i64_e64 v[1:2], v[2:3]
// GFX10: encoding: [0x00,0x00,0xb6,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_ge_i64_e64 v[254:255], v[2:3]
// GFX10: encoding: [0x00,0x00,0xb6,0xd4,0xfe,0x05,0x02,0x00]

v_cmpx_ge_i64_e64 s[2:3], v[2:3]
// GFX10: encoding: [0x00,0x00,0xb6,0xd4,0x02,0x04,0x02,0x00]

v_cmpx_ge_i64_e64 s[4:5], v[2:3]
// GFX10: encoding: [0x00,0x00,0xb6,0xd4,0x04,0x04,0x02,0x00]

v_cmpx_ge_i64_e64 vcc, v[2:3]
// GFX10: encoding: [0x00,0x00,0xb6,0xd4,0x6a,0x04,0x02,0x00]

v_cmpx_ge_i64_e64 0, v[2:3]
// GFX10: encoding: [0x00,0x00,0xb6,0xd4,0x80,0x04,0x02,0x00]

v_cmpx_ge_i64_e64 -1, v[2:3]
// GFX10: encoding: [0x00,0x00,0xb6,0xd4,0xc1,0x04,0x02,0x00]

v_cmpx_ge_i64_e64 0.5, v[2:3]
// GFX10: encoding: [0x00,0x00,0xb6,0xd4,0xf0,0x04,0x02,0x00]

v_cmpx_ge_i64_e64 -4.0, v[2:3]
// GFX10: encoding: [0x00,0x00,0xb6,0xd4,0xf7,0x04,0x02,0x00]

v_cmpx_ge_i64_e64 v[1:2], v[254:255]
// GFX10: encoding: [0x00,0x00,0xb6,0xd4,0x01,0xfd,0x03,0x00]

v_cmpx_ge_i64_e64 v[1:2], s[4:5]
// GFX10: encoding: [0x00,0x00,0xb6,0xd4,0x01,0x09,0x00,0x00]

v_cmpx_ge_i64_e64 v[1:2], s[6:7]
// GFX10: encoding: [0x00,0x00,0xb6,0xd4,0x01,0x0d,0x00,0x00]

v_cmpx_ge_i64_e64 v[1:2], s[100:101]
// GFX10: encoding: [0x00,0x00,0xb6,0xd4,0x01,0xc9,0x00,0x00]

v_cmpx_ge_i64_e64 v[1:2], vcc
// GFX10: encoding: [0x00,0x00,0xb6,0xd4,0x01,0xd5,0x00,0x00]

v_cmpx_ge_i64_e64 v[1:2], exec
// GFX10: encoding: [0x00,0x00,0xb6,0xd4,0x01,0xfd,0x00,0x00]

v_cmpx_ge_i64_e64 v[1:2], 0
// GFX10: encoding: [0x00,0x00,0xb6,0xd4,0x01,0x01,0x01,0x00]

v_cmpx_ge_i64_e64 v[1:2], -1
// GFX10: encoding: [0x00,0x00,0xb6,0xd4,0x01,0x83,0x01,0x00]

v_cmpx_ge_i64_e64 v[1:2], 0.5
// GFX10: encoding: [0x00,0x00,0xb6,0xd4,0x01,0xe1,0x01,0x00]

v_cmpx_ge_i64_e64 v[1:2], -4.0
// GFX10: encoding: [0x00,0x00,0xb6,0xd4,0x01,0xef,0x01,0x00]

v_cmpx_t_i64 v[1:2], v[2:3]
// GFX10: encoding: [0x01,0x05,0x6e,0x7d]

v_cmpx_t_i64 v[254:255], v[2:3]
// GFX10: encoding: [0xfe,0x05,0x6e,0x7d]

v_cmpx_t_i64 s[2:3], v[2:3]
// GFX10: encoding: [0x02,0x04,0x6e,0x7d]

v_cmpx_t_i64 s[4:5], v[2:3]
// GFX10: encoding: [0x04,0x04,0x6e,0x7d]

v_cmpx_t_i64 s[100:101], v[2:3]
// GFX10: encoding: [0x64,0x04,0x6e,0x7d]

v_cmpx_t_i64 vcc, v[2:3]
// GFX10: encoding: [0x6a,0x04,0x6e,0x7d]

v_cmpx_t_i64 exec, v[2:3]
// GFX10: encoding: [0x7e,0x04,0x6e,0x7d]

v_cmpx_t_i64 0, v[2:3]
// GFX10: encoding: [0x80,0x04,0x6e,0x7d]

v_cmpx_t_i64 -1, v[2:3]
// GFX10: encoding: [0xc1,0x04,0x6e,0x7d]

v_cmpx_t_i64 0.5, v[2:3]
// GFX10: encoding: [0xf0,0x04,0x6e,0x7d]

v_cmpx_t_i64 -4.0, v[2:3]
// GFX10: encoding: [0xf7,0x04,0x6e,0x7d]

v_cmpx_t_i64 0xaf123456, v[2:3]
// GFX10: encoding: [0xff,0x04,0x6e,0x7d,0x56,0x34,0x12,0xaf]

v_cmpx_t_i64 0x3f717273, v[2:3]
// GFX10: encoding: [0xff,0x04,0x6e,0x7d,0x73,0x72,0x71,0x3f]

v_cmpx_t_i64 v[1:2], v[254:255]
// GFX10: encoding: [0x01,0xfd,0x6f,0x7d]

v_cmpx_t_i64_e64 v[1:2], v[2:3]
// GFX10: encoding: [0x00,0x00,0xb7,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_t_i64_e64 v[254:255], v[2:3]
// GFX10: encoding: [0x00,0x00,0xb7,0xd4,0xfe,0x05,0x02,0x00]

v_cmpx_t_i64_e64 s[2:3], v[2:3]
// GFX10: encoding: [0x00,0x00,0xb7,0xd4,0x02,0x04,0x02,0x00]

v_cmpx_t_i64_e64 s[4:5], v[2:3]
// GFX10: encoding: [0x00,0x00,0xb7,0xd4,0x04,0x04,0x02,0x00]

v_cmpx_t_i64_e64 vcc, v[2:3]
// GFX10: encoding: [0x00,0x00,0xb7,0xd4,0x6a,0x04,0x02,0x00]

v_cmpx_t_i64_e64 0, v[2:3]
// GFX10: encoding: [0x00,0x00,0xb7,0xd4,0x80,0x04,0x02,0x00]

v_cmpx_t_i64_e64 -1, v[2:3]
// GFX10: encoding: [0x00,0x00,0xb7,0xd4,0xc1,0x04,0x02,0x00]

v_cmpx_t_i64_e64 0.5, v[2:3]
// GFX10: encoding: [0x00,0x00,0xb7,0xd4,0xf0,0x04,0x02,0x00]

v_cmpx_t_i64_e64 -4.0, v[2:3]
// GFX10: encoding: [0x00,0x00,0xb7,0xd4,0xf7,0x04,0x02,0x00]

v_cmpx_t_i64_e64 v[1:2], v[254:255]
// GFX10: encoding: [0x00,0x00,0xb7,0xd4,0x01,0xfd,0x03,0x00]

v_cmpx_t_i64_e64 v[1:2], s[4:5]
// GFX10: encoding: [0x00,0x00,0xb7,0xd4,0x01,0x09,0x00,0x00]

v_cmpx_t_i64_e64 v[1:2], s[6:7]
// GFX10: encoding: [0x00,0x00,0xb7,0xd4,0x01,0x0d,0x00,0x00]

v_cmpx_t_i64_e64 v[1:2], s[100:101]
// GFX10: encoding: [0x00,0x00,0xb7,0xd4,0x01,0xc9,0x00,0x00]

v_cmpx_t_i64_e64 v[1:2], vcc
// GFX10: encoding: [0x00,0x00,0xb7,0xd4,0x01,0xd5,0x00,0x00]

v_cmpx_t_i64_e64 v[1:2], exec
// GFX10: encoding: [0x00,0x00,0xb7,0xd4,0x01,0xfd,0x00,0x00]

v_cmpx_t_i64_e64 v[1:2], 0
// GFX10: encoding: [0x00,0x00,0xb7,0xd4,0x01,0x01,0x01,0x00]

v_cmpx_t_i64_e64 v[1:2], -1
// GFX10: encoding: [0x00,0x00,0xb7,0xd4,0x01,0x83,0x01,0x00]

v_cmpx_t_i64_e64 v[1:2], 0.5
// GFX10: encoding: [0x00,0x00,0xb7,0xd4,0x01,0xe1,0x01,0x00]

v_cmpx_t_i64_e64 v[1:2], -4.0
// GFX10: encoding: [0x00,0x00,0xb7,0xd4,0x01,0xef,0x01,0x00]

v_cmpx_class_f64 v[1:2], v2
// GFX10: encoding: [0x01,0x05,0x70,0x7d]

v_cmpx_class_f64 v[254:255], v2
// GFX10: encoding: [0xfe,0x05,0x70,0x7d]

v_cmpx_class_f64 s[2:3], v2
// GFX10: encoding: [0x02,0x04,0x70,0x7d]

v_cmpx_class_f64 s[4:5], v2
// GFX10: encoding: [0x04,0x04,0x70,0x7d]

v_cmpx_class_f64 s[100:101], v2
// GFX10: encoding: [0x64,0x04,0x70,0x7d]

v_cmpx_class_f64 vcc, v2
// GFX10: encoding: [0x6a,0x04,0x70,0x7d]

v_cmpx_class_f64 exec, v2
// GFX10: encoding: [0x7e,0x04,0x70,0x7d]

v_cmpx_class_f64 0, v2
// GFX10: encoding: [0x80,0x04,0x70,0x7d]

v_cmpx_class_f64 -1, v2
// GFX10: encoding: [0xc1,0x04,0x70,0x7d]

v_cmpx_class_f64 0.5, v2
// GFX10: encoding: [0xf0,0x04,0x70,0x7d]

v_cmpx_class_f64 -4.0, v2
// GFX10: encoding: [0xf7,0x04,0x70,0x7d]

v_cmpx_class_f64 0xaf123456, v2
// GFX10: encoding: [0xff,0x04,0x70,0x7d,0x56,0x34,0x12,0xaf]

v_cmpx_class_f64 0x3f717273, v2
// GFX10: encoding: [0xff,0x04,0x70,0x7d,0x73,0x72,0x71,0x3f]

v_cmpx_class_f64 v[1:2], v255
// GFX10: encoding: [0x01,0xff,0x71,0x7d]

v_cmpx_class_f64_e64 v[1:2], v2
// GFX10: encoding: [0x00,0x00,0xb8,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_class_f64_e64 v[254:255], v2
// GFX10: encoding: [0x00,0x00,0xb8,0xd4,0xfe,0x05,0x02,0x00]

v_cmpx_class_f64_e64 s[2:3], v2
// GFX10: encoding: [0x00,0x00,0xb8,0xd4,0x02,0x04,0x02,0x00]

v_cmpx_class_f64_e64 s[4:5], v2
// GFX10: encoding: [0x00,0x00,0xb8,0xd4,0x04,0x04,0x02,0x00]

v_cmpx_class_f64_e64 vcc, v2
// GFX10: encoding: [0x00,0x00,0xb8,0xd4,0x6a,0x04,0x02,0x00]

v_cmpx_class_f64_e64 0, v2
// GFX10: encoding: [0x00,0x00,0xb8,0xd4,0x80,0x04,0x02,0x00]

v_cmpx_class_f64_e64 -1, v2
// GFX10: encoding: [0x00,0x00,0xb8,0xd4,0xc1,0x04,0x02,0x00]

v_cmpx_class_f64_e64 0.5, v2
// GFX10: encoding: [0x00,0x00,0xb8,0xd4,0xf0,0x04,0x02,0x00]

v_cmpx_class_f64_e64 -4.0, v2
// GFX10: encoding: [0x00,0x00,0xb8,0xd4,0xf7,0x04,0x02,0x00]

v_cmpx_class_f64_e64 v[1:2], v255
// GFX10: encoding: [0x00,0x00,0xb8,0xd4,0x01,0xff,0x03,0x00]

v_cmpx_class_f64_e64 v[1:2], s2
// GFX10: encoding: [0x00,0x00,0xb8,0xd4,0x01,0x05,0x00,0x00]

v_cmpx_class_f64_e64 v[1:2], s101
// GFX10: encoding: [0x00,0x00,0xb8,0xd4,0x01,0xcb,0x00,0x00]

v_cmpx_class_f64_e64 v[1:2], vcc_lo
// GFX10: encoding: [0x00,0x00,0xb8,0xd4,0x01,0xd5,0x00,0x00]

v_cmpx_class_f64_e64 v[1:2], vcc_hi
// GFX10: encoding: [0x00,0x00,0xb8,0xd4,0x01,0xd7,0x00,0x00]

v_cmpx_class_f64_e64 v[1:2], m0
// GFX10: encoding: [0x00,0x00,0xb8,0xd4,0x01,0xf9,0x00,0x00]

v_cmpx_class_f64_e64 v[1:2], exec_lo
// GFX10: encoding: [0x00,0x00,0xb8,0xd4,0x01,0xfd,0x00,0x00]

v_cmpx_class_f64_e64 v[1:2], exec_hi
// GFX10: encoding: [0x00,0x00,0xb8,0xd4,0x01,0xff,0x00,0x00]

v_cmpx_class_f64_e64 v[1:2], 0
// GFX10: encoding: [0x00,0x00,0xb8,0xd4,0x01,0x01,0x01,0x00]

v_cmpx_class_f64_e64 v[1:2], -1
// GFX10: encoding: [0x00,0x00,0xb8,0xd4,0x01,0x83,0x01,0x00]

v_cmpx_class_f64_e64 v[1:2], 0.5
// GFX10: encoding: [0x00,0x00,0xb8,0xd4,0x01,0xe1,0x01,0x00]

v_cmpx_class_f64_e64 v[1:2], -4.0
// GFX10: encoding: [0x00,0x00,0xb8,0xd4,0x01,0xef,0x01,0x00]

v_cmpx_class_f64_e64 -v[1:2], v2
// GFX10: encoding: [0x00,0x00,0xb8,0xd4,0x01,0x05,0x02,0x20]

v_cmpx_lt_u16 v1, v2
// GFX10: encoding: [0x01,0x05,0x72,0x7d]

v_cmpx_lt_u16 v255, v2
// GFX10: encoding: [0xff,0x05,0x72,0x7d]

v_cmpx_lt_u16 s1, v2
// GFX10: encoding: [0x01,0x04,0x72,0x7d]

v_cmpx_lt_u16 s101, v2
// GFX10: encoding: [0x65,0x04,0x72,0x7d]

v_cmpx_lt_u16 vcc_lo, v2
// GFX10: encoding: [0x6a,0x04,0x72,0x7d]

v_cmpx_lt_u16 vcc_hi, v2
// GFX10: encoding: [0x6b,0x04,0x72,0x7d]

v_cmpx_lt_u16 m0, v2
// GFX10: encoding: [0x7c,0x04,0x72,0x7d]

v_cmpx_lt_u16 exec_lo, v2
// GFX10: encoding: [0x7e,0x04,0x72,0x7d]

v_cmpx_lt_u16 exec_hi, v2
// GFX10: encoding: [0x7f,0x04,0x72,0x7d]

v_cmpx_lt_u16 0, v2
// GFX10: encoding: [0x80,0x04,0x72,0x7d]

v_cmpx_lt_u16 -1, v2
// GFX10: encoding: [0xc1,0x04,0x72,0x7d]

v_cmpx_lt_u16 0.5, v2
// GFX10: encoding: [0xff,0x04,0x72,0x7d,0x00,0x38,0x00,0x00]

v_cmpx_lt_u16 -4.0, v2
// GFX10: encoding: [0xff,0x04,0x72,0x7d,0x00,0xc4,0x00,0x00]

v_cmpx_lt_u16 0xfe0b, v2
// GFX10: encoding: [0xff,0x04,0x72,0x7d,0x0b,0xfe,0x00,0x00]

v_cmpx_lt_u16 0x3456, v2
// GFX10: encoding: [0xff,0x04,0x72,0x7d,0x56,0x34,0x00,0x00]

v_cmpx_lt_u16 v1, v255
// GFX10: encoding: [0x01,0xff,0x73,0x7d]

v_cmpx_lt_u16_e64 v1, v2
// GFX10: encoding: [0x00,0x00,0xb9,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_lt_u16_e64 v255, v2
// GFX10: encoding: [0x00,0x00,0xb9,0xd4,0xff,0x05,0x02,0x00]

v_cmpx_lt_u16_e64 s1, v2
// GFX10: encoding: [0x00,0x00,0xb9,0xd4,0x01,0x04,0x02,0x00]

v_cmpx_lt_u16_e64 s101, v2
// GFX10: encoding: [0x00,0x00,0xb9,0xd4,0x65,0x04,0x02,0x00]

v_cmpx_lt_u16_e64 vcc_lo, v2
// GFX10: encoding: [0x00,0x00,0xb9,0xd4,0x6a,0x04,0x02,0x00]

v_cmpx_lt_u16_e64 vcc_hi, v2
// GFX10: encoding: [0x00,0x00,0xb9,0xd4,0x6b,0x04,0x02,0x00]

v_cmpx_lt_u16_e64 m0, v2
// GFX10: encoding: [0x00,0x00,0xb9,0xd4,0x7c,0x04,0x02,0x00]

v_cmpx_lt_u16_e64 exec_lo, v2
// GFX10: encoding: [0x00,0x00,0xb9,0xd4,0x7e,0x04,0x02,0x00]

v_cmpx_lt_u16_e64 exec_hi, v2
// GFX10: encoding: [0x00,0x00,0xb9,0xd4,0x7f,0x04,0x02,0x00]

v_cmpx_lt_u16_e64 0, v2
// GFX10: encoding: [0x00,0x00,0xb9,0xd4,0x80,0x04,0x02,0x00]

v_cmpx_lt_u16_e64 -1, v2
// GFX10: encoding: [0x00,0x00,0xb9,0xd4,0xc1,0x04,0x02,0x00]

v_cmpx_lt_u16_e64 0.5, v2
// GFX10: encoding: [0x00,0x00,0xb9,0xd4,0xff,0x04,0x02,0x00,0x00,0x38,0x00,0x00]

v_cmpx_lt_u16_e64 -4.0, v2
// GFX10: encoding: [0x00,0x00,0xb9,0xd4,0xff,0x04,0x02,0x00,0x00,0xc4,0x00,0x00]

v_cmpx_lt_u16_e64 v1, v255
// GFX10: encoding: [0x00,0x00,0xb9,0xd4,0x01,0xff,0x03,0x00]

v_cmpx_lt_u16_e64 v1, s2
// GFX10: encoding: [0x00,0x00,0xb9,0xd4,0x01,0x05,0x00,0x00]

v_cmpx_lt_u16_e64 v1, s101
// GFX10: encoding: [0x00,0x00,0xb9,0xd4,0x01,0xcb,0x00,0x00]

v_cmpx_lt_u16_e64 v1, vcc_lo
// GFX10: encoding: [0x00,0x00,0xb9,0xd4,0x01,0xd5,0x00,0x00]

v_cmpx_lt_u16_e64 v1, vcc_hi
// GFX10: encoding: [0x00,0x00,0xb9,0xd4,0x01,0xd7,0x00,0x00]

v_cmpx_lt_u16_e64 v1, m0
// GFX10: encoding: [0x00,0x00,0xb9,0xd4,0x01,0xf9,0x00,0x00]

v_cmpx_lt_u16_e64 v1, exec_lo
// GFX10: encoding: [0x00,0x00,0xb9,0xd4,0x01,0xfd,0x00,0x00]

v_cmpx_lt_u16_e64 v1, exec_hi
// GFX10: encoding: [0x00,0x00,0xb9,0xd4,0x01,0xff,0x00,0x00]

v_cmpx_lt_u16_e64 v1, 0
// GFX10: encoding: [0x00,0x00,0xb9,0xd4,0x01,0x01,0x01,0x00]

v_cmpx_lt_u16_e64 v1, -1
// GFX10: encoding: [0x00,0x00,0xb9,0xd4,0x01,0x83,0x01,0x00]

v_cmpx_lt_u16_e64 v1, 0.5
// GFX10: encoding: [0x00,0x00,0xb9,0xd4,0x01,0xff,0x01,0x00,0x00,0x38,0x00,0x00]

v_cmpx_lt_u16_e64 v1, -4.0
// GFX10: encoding: [0x00,0x00,0xb9,0xd4,0x01,0xff,0x01,0x00,0x00,0xc4,0x00,0x00]

v_cmpx_eq_u16 v1, v2
// GFX10: encoding: [0x01,0x05,0x74,0x7d]

v_cmpx_eq_u16 v255, v2
// GFX10: encoding: [0xff,0x05,0x74,0x7d]

v_cmpx_eq_u16 s1, v2
// GFX10: encoding: [0x01,0x04,0x74,0x7d]

v_cmpx_eq_u16 s101, v2
// GFX10: encoding: [0x65,0x04,0x74,0x7d]

v_cmpx_eq_u16 vcc_lo, v2
// GFX10: encoding: [0x6a,0x04,0x74,0x7d]

v_cmpx_eq_u16 vcc_hi, v2
// GFX10: encoding: [0x6b,0x04,0x74,0x7d]

v_cmpx_eq_u16 m0, v2
// GFX10: encoding: [0x7c,0x04,0x74,0x7d]

v_cmpx_eq_u16 exec_lo, v2
// GFX10: encoding: [0x7e,0x04,0x74,0x7d]

v_cmpx_eq_u16 exec_hi, v2
// GFX10: encoding: [0x7f,0x04,0x74,0x7d]

v_cmpx_eq_u16 0, v2
// GFX10: encoding: [0x80,0x04,0x74,0x7d]

v_cmpx_eq_u16 -1, v2
// GFX10: encoding: [0xc1,0x04,0x74,0x7d]

v_cmpx_eq_u16 0.5, v2
// GFX10: encoding: [0xff,0x04,0x74,0x7d,0x00,0x38,0x00,0x00]

v_cmpx_eq_u16 -4.0, v2
// GFX10: encoding: [0xff,0x04,0x74,0x7d,0x00,0xc4,0x00,0x00]

v_cmpx_eq_u16 0xfe0b, v2
// GFX10: encoding: [0xff,0x04,0x74,0x7d,0x0b,0xfe,0x00,0x00]

v_cmpx_eq_u16 0x3456, v2
// GFX10: encoding: [0xff,0x04,0x74,0x7d,0x56,0x34,0x00,0x00]

v_cmpx_eq_u16 v1, v255
// GFX10: encoding: [0x01,0xff,0x75,0x7d]

v_cmpx_eq_u16_e64 v1, v2
// GFX10: encoding: [0x00,0x00,0xba,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_eq_u16_e64 v255, v2
// GFX10: encoding: [0x00,0x00,0xba,0xd4,0xff,0x05,0x02,0x00]

v_cmpx_eq_u16_e64 s1, v2
// GFX10: encoding: [0x00,0x00,0xba,0xd4,0x01,0x04,0x02,0x00]

v_cmpx_eq_u16_e64 s101, v2
// GFX10: encoding: [0x00,0x00,0xba,0xd4,0x65,0x04,0x02,0x00]

v_cmpx_eq_u16_e64 vcc_lo, v2
// GFX10: encoding: [0x00,0x00,0xba,0xd4,0x6a,0x04,0x02,0x00]

v_cmpx_eq_u16_e64 vcc_hi, v2
// GFX10: encoding: [0x00,0x00,0xba,0xd4,0x6b,0x04,0x02,0x00]

v_cmpx_eq_u16_e64 m0, v2
// GFX10: encoding: [0x00,0x00,0xba,0xd4,0x7c,0x04,0x02,0x00]

v_cmpx_eq_u16_e64 exec_lo, v2
// GFX10: encoding: [0x00,0x00,0xba,0xd4,0x7e,0x04,0x02,0x00]

v_cmpx_eq_u16_e64 exec_hi, v2
// GFX10: encoding: [0x00,0x00,0xba,0xd4,0x7f,0x04,0x02,0x00]

v_cmpx_eq_u16_e64 0, v2
// GFX10: encoding: [0x00,0x00,0xba,0xd4,0x80,0x04,0x02,0x00]

v_cmpx_eq_u16_e64 -1, v2
// GFX10: encoding: [0x00,0x00,0xba,0xd4,0xc1,0x04,0x02,0x00]

v_cmpx_eq_u16_e64 0.5, v2
// GFX10: encoding: [0x00,0x00,0xba,0xd4,0xff,0x04,0x02,0x00,0x00,0x38,0x00,0x00]

v_cmpx_eq_u16_e64 -4.0, v2
// GFX10: encoding: [0x00,0x00,0xba,0xd4,0xff,0x04,0x02,0x00,0x00,0xc4,0x00,0x00]

v_cmpx_eq_u16_e64 v1, v255
// GFX10: encoding: [0x00,0x00,0xba,0xd4,0x01,0xff,0x03,0x00]

v_cmpx_eq_u16_e64 v1, s2
// GFX10: encoding: [0x00,0x00,0xba,0xd4,0x01,0x05,0x00,0x00]

v_cmpx_eq_u16_e64 v1, s101
// GFX10: encoding: [0x00,0x00,0xba,0xd4,0x01,0xcb,0x00,0x00]

v_cmpx_eq_u16_e64 v1, vcc_lo
// GFX10: encoding: [0x00,0x00,0xba,0xd4,0x01,0xd5,0x00,0x00]

v_cmpx_eq_u16_e64 v1, vcc_hi
// GFX10: encoding: [0x00,0x00,0xba,0xd4,0x01,0xd7,0x00,0x00]

v_cmpx_eq_u16_e64 v1, m0
// GFX10: encoding: [0x00,0x00,0xba,0xd4,0x01,0xf9,0x00,0x00]

v_cmpx_eq_u16_e64 v1, exec_lo
// GFX10: encoding: [0x00,0x00,0xba,0xd4,0x01,0xfd,0x00,0x00]

v_cmpx_eq_u16_e64 v1, exec_hi
// GFX10: encoding: [0x00,0x00,0xba,0xd4,0x01,0xff,0x00,0x00]

v_cmpx_eq_u16_e64 v1, 0
// GFX10: encoding: [0x00,0x00,0xba,0xd4,0x01,0x01,0x01,0x00]

v_cmpx_eq_u16_e64 v1, -1
// GFX10: encoding: [0x00,0x00,0xba,0xd4,0x01,0x83,0x01,0x00]

v_cmpx_eq_u16_e64 v1, 0.5
// GFX10: encoding: [0x00,0x00,0xba,0xd4,0x01,0xff,0x01,0x00,0x00,0x38,0x00,0x00]

v_cmpx_eq_u16_e64 v1, -4.0
// GFX10: encoding: [0x00,0x00,0xba,0xd4,0x01,0xff,0x01,0x00,0x00,0xc4,0x00,0x00]

v_cmpx_le_u16 v1, v2
// GFX10: encoding: [0x01,0x05,0x76,0x7d]

v_cmpx_le_u16 v255, v2
// GFX10: encoding: [0xff,0x05,0x76,0x7d]

v_cmpx_le_u16 s1, v2
// GFX10: encoding: [0x01,0x04,0x76,0x7d]

v_cmpx_le_u16 s101, v2
// GFX10: encoding: [0x65,0x04,0x76,0x7d]

v_cmpx_le_u16 vcc_lo, v2
// GFX10: encoding: [0x6a,0x04,0x76,0x7d]

v_cmpx_le_u16 vcc_hi, v2
// GFX10: encoding: [0x6b,0x04,0x76,0x7d]

v_cmpx_le_u16 m0, v2
// GFX10: encoding: [0x7c,0x04,0x76,0x7d]

v_cmpx_le_u16 exec_lo, v2
// GFX10: encoding: [0x7e,0x04,0x76,0x7d]

v_cmpx_le_u16 exec_hi, v2
// GFX10: encoding: [0x7f,0x04,0x76,0x7d]

v_cmpx_le_u16 0, v2
// GFX10: encoding: [0x80,0x04,0x76,0x7d]

v_cmpx_le_u16 -1, v2
// GFX10: encoding: [0xc1,0x04,0x76,0x7d]

v_cmpx_le_u16 0.5, v2
// GFX10: encoding: [0xff,0x04,0x76,0x7d,0x00,0x38,0x00,0x00]

v_cmpx_le_u16 -4.0, v2
// GFX10: encoding: [0xff,0x04,0x76,0x7d,0x00,0xc4,0x00,0x00]

v_cmpx_le_u16 0xfe0b, v2
// GFX10: encoding: [0xff,0x04,0x76,0x7d,0x0b,0xfe,0x00,0x00]

v_cmpx_le_u16 0x3456, v2
// GFX10: encoding: [0xff,0x04,0x76,0x7d,0x56,0x34,0x00,0x00]

v_cmpx_le_u16 v1, v255
// GFX10: encoding: [0x01,0xff,0x77,0x7d]

v_cmpx_le_u16_e64 v1, v2
// GFX10: encoding: [0x00,0x00,0xbb,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_le_u16_e64 v255, v2
// GFX10: encoding: [0x00,0x00,0xbb,0xd4,0xff,0x05,0x02,0x00]

v_cmpx_le_u16_e64 s1, v2
// GFX10: encoding: [0x00,0x00,0xbb,0xd4,0x01,0x04,0x02,0x00]

v_cmpx_le_u16_e64 s101, v2
// GFX10: encoding: [0x00,0x00,0xbb,0xd4,0x65,0x04,0x02,0x00]

v_cmpx_le_u16_e64 vcc_lo, v2
// GFX10: encoding: [0x00,0x00,0xbb,0xd4,0x6a,0x04,0x02,0x00]

v_cmpx_le_u16_e64 vcc_hi, v2
// GFX10: encoding: [0x00,0x00,0xbb,0xd4,0x6b,0x04,0x02,0x00]

v_cmpx_le_u16_e64 m0, v2
// GFX10: encoding: [0x00,0x00,0xbb,0xd4,0x7c,0x04,0x02,0x00]

v_cmpx_le_u16_e64 exec_lo, v2
// GFX10: encoding: [0x00,0x00,0xbb,0xd4,0x7e,0x04,0x02,0x00]

v_cmpx_le_u16_e64 exec_hi, v2
// GFX10: encoding: [0x00,0x00,0xbb,0xd4,0x7f,0x04,0x02,0x00]

v_cmpx_le_u16_e64 0, v2
// GFX10: encoding: [0x00,0x00,0xbb,0xd4,0x80,0x04,0x02,0x00]

v_cmpx_le_u16_e64 -1, v2
// GFX10: encoding: [0x00,0x00,0xbb,0xd4,0xc1,0x04,0x02,0x00]

v_cmpx_le_u16_e64 0.5, v2
// GFX10: encoding: [0x00,0x00,0xbb,0xd4,0xff,0x04,0x02,0x00,0x00,0x38,0x00,0x00]

v_cmpx_le_u16_e64 -4.0, v2
// GFX10: encoding: [0x00,0x00,0xbb,0xd4,0xff,0x04,0x02,0x00,0x00,0xc4,0x00,0x00]

v_cmpx_le_u16_e64 v1, v255
// GFX10: encoding: [0x00,0x00,0xbb,0xd4,0x01,0xff,0x03,0x00]

v_cmpx_le_u16_e64 v1, s2
// GFX10: encoding: [0x00,0x00,0xbb,0xd4,0x01,0x05,0x00,0x00]

v_cmpx_le_u16_e64 v1, s101
// GFX10: encoding: [0x00,0x00,0xbb,0xd4,0x01,0xcb,0x00,0x00]

v_cmpx_le_u16_e64 v1, vcc_lo
// GFX10: encoding: [0x00,0x00,0xbb,0xd4,0x01,0xd5,0x00,0x00]

v_cmpx_le_u16_e64 v1, vcc_hi
// GFX10: encoding: [0x00,0x00,0xbb,0xd4,0x01,0xd7,0x00,0x00]

v_cmpx_le_u16_e64 v1, m0
// GFX10: encoding: [0x00,0x00,0xbb,0xd4,0x01,0xf9,0x00,0x00]

v_cmpx_le_u16_e64 v1, exec_lo
// GFX10: encoding: [0x00,0x00,0xbb,0xd4,0x01,0xfd,0x00,0x00]

v_cmpx_le_u16_e64 v1, exec_hi
// GFX10: encoding: [0x00,0x00,0xbb,0xd4,0x01,0xff,0x00,0x00]

v_cmpx_le_u16_e64 v1, 0
// GFX10: encoding: [0x00,0x00,0xbb,0xd4,0x01,0x01,0x01,0x00]

v_cmpx_le_u16_e64 v1, -1
// GFX10: encoding: [0x00,0x00,0xbb,0xd4,0x01,0x83,0x01,0x00]

v_cmpx_le_u16_e64 v1, 0.5
// GFX10: encoding: [0x00,0x00,0xbb,0xd4,0x01,0xff,0x01,0x00,0x00,0x38,0x00,0x00]

v_cmpx_le_u16_e64 v1, -4.0
// GFX10: encoding: [0x00,0x00,0xbb,0xd4,0x01,0xff,0x01,0x00,0x00,0xc4,0x00,0x00]

v_cmpx_gt_u16 v1, v2
// GFX10: encoding: [0x01,0x05,0x78,0x7d]

v_cmpx_gt_u16 v255, v2
// GFX10: encoding: [0xff,0x05,0x78,0x7d]

v_cmpx_gt_u16 s1, v2
// GFX10: encoding: [0x01,0x04,0x78,0x7d]

v_cmpx_gt_u16 s101, v2
// GFX10: encoding: [0x65,0x04,0x78,0x7d]

v_cmpx_gt_u16 vcc_lo, v2
// GFX10: encoding: [0x6a,0x04,0x78,0x7d]

v_cmpx_gt_u16 vcc_hi, v2
// GFX10: encoding: [0x6b,0x04,0x78,0x7d]

v_cmpx_gt_u16 m0, v2
// GFX10: encoding: [0x7c,0x04,0x78,0x7d]

v_cmpx_gt_u16 exec_lo, v2
// GFX10: encoding: [0x7e,0x04,0x78,0x7d]

v_cmpx_gt_u16 exec_hi, v2
// GFX10: encoding: [0x7f,0x04,0x78,0x7d]

v_cmpx_gt_u16 0, v2
// GFX10: encoding: [0x80,0x04,0x78,0x7d]

v_cmpx_gt_u16 -1, v2
// GFX10: encoding: [0xc1,0x04,0x78,0x7d]

v_cmpx_gt_u16 0.5, v2
// GFX10: encoding: [0xff,0x04,0x78,0x7d,0x00,0x38,0x00,0x00]

v_cmpx_gt_u16 -4.0, v2
// GFX10: encoding: [0xff,0x04,0x78,0x7d,0x00,0xc4,0x00,0x00]

v_cmpx_gt_u16 0xfe0b, v2
// GFX10: encoding: [0xff,0x04,0x78,0x7d,0x0b,0xfe,0x00,0x00]

v_cmpx_gt_u16 0x3456, v2
// GFX10: encoding: [0xff,0x04,0x78,0x7d,0x56,0x34,0x00,0x00]

v_cmpx_gt_u16 v1, v255
// GFX10: encoding: [0x01,0xff,0x79,0x7d]

v_cmpx_gt_u16_e64 v1, v2
// GFX10: encoding: [0x00,0x00,0xbc,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_gt_u16_e64 v255, v2
// GFX10: encoding: [0x00,0x00,0xbc,0xd4,0xff,0x05,0x02,0x00]

v_cmpx_gt_u16_e64 s1, v2
// GFX10: encoding: [0x00,0x00,0xbc,0xd4,0x01,0x04,0x02,0x00]

v_cmpx_gt_u16_e64 s101, v2
// GFX10: encoding: [0x00,0x00,0xbc,0xd4,0x65,0x04,0x02,0x00]

v_cmpx_gt_u16_e64 vcc_lo, v2
// GFX10: encoding: [0x00,0x00,0xbc,0xd4,0x6a,0x04,0x02,0x00]

v_cmpx_gt_u16_e64 vcc_hi, v2
// GFX10: encoding: [0x00,0x00,0xbc,0xd4,0x6b,0x04,0x02,0x00]

v_cmpx_gt_u16_e64 m0, v2
// GFX10: encoding: [0x00,0x00,0xbc,0xd4,0x7c,0x04,0x02,0x00]

v_cmpx_gt_u16_e64 exec_lo, v2
// GFX10: encoding: [0x00,0x00,0xbc,0xd4,0x7e,0x04,0x02,0x00]

v_cmpx_gt_u16_e64 exec_hi, v2
// GFX10: encoding: [0x00,0x00,0xbc,0xd4,0x7f,0x04,0x02,0x00]

v_cmpx_gt_u16_e64 0, v2
// GFX10: encoding: [0x00,0x00,0xbc,0xd4,0x80,0x04,0x02,0x00]

v_cmpx_gt_u16_e64 -1, v2
// GFX10: encoding: [0x00,0x00,0xbc,0xd4,0xc1,0x04,0x02,0x00]

v_cmpx_gt_u16_e64 0.5, v2
// GFX10: encoding: [0x00,0x00,0xbc,0xd4,0xff,0x04,0x02,0x00,0x00,0x38,0x00,0x00]

v_cmpx_gt_u16_e64 -4.0, v2
// GFX10: encoding: [0x00,0x00,0xbc,0xd4,0xff,0x04,0x02,0x00,0x00,0xc4,0x00,0x00]

v_cmpx_gt_u16_e64 v1, v255
// GFX10: encoding: [0x00,0x00,0xbc,0xd4,0x01,0xff,0x03,0x00]

v_cmpx_gt_u16_e64 v1, s2
// GFX10: encoding: [0x00,0x00,0xbc,0xd4,0x01,0x05,0x00,0x00]

v_cmpx_gt_u16_e64 v1, s101
// GFX10: encoding: [0x00,0x00,0xbc,0xd4,0x01,0xcb,0x00,0x00]

v_cmpx_gt_u16_e64 v1, vcc_lo
// GFX10: encoding: [0x00,0x00,0xbc,0xd4,0x01,0xd5,0x00,0x00]

v_cmpx_gt_u16_e64 v1, vcc_hi
// GFX10: encoding: [0x00,0x00,0xbc,0xd4,0x01,0xd7,0x00,0x00]

v_cmpx_gt_u16_e64 v1, m0
// GFX10: encoding: [0x00,0x00,0xbc,0xd4,0x01,0xf9,0x00,0x00]

v_cmpx_gt_u16_e64 v1, exec_lo
// GFX10: encoding: [0x00,0x00,0xbc,0xd4,0x01,0xfd,0x00,0x00]

v_cmpx_gt_u16_e64 v1, exec_hi
// GFX10: encoding: [0x00,0x00,0xbc,0xd4,0x01,0xff,0x00,0x00]

v_cmpx_gt_u16_e64 v1, 0
// GFX10: encoding: [0x00,0x00,0xbc,0xd4,0x01,0x01,0x01,0x00]

v_cmpx_gt_u16_e64 v1, -1
// GFX10: encoding: [0x00,0x00,0xbc,0xd4,0x01,0x83,0x01,0x00]

v_cmpx_gt_u16_e64 v1, 0.5
// GFX10: encoding: [0x00,0x00,0xbc,0xd4,0x01,0xff,0x01,0x00,0x00,0x38,0x00,0x00]

v_cmpx_gt_u16_e64 v1, -4.0
// GFX10: encoding: [0x00,0x00,0xbc,0xd4,0x01,0xff,0x01,0x00,0x00,0xc4,0x00,0x00]

v_cmpx_ne_u16 v1, v2
// GFX10: encoding: [0x01,0x05,0x7a,0x7d]

v_cmpx_ne_u16 v255, v2
// GFX10: encoding: [0xff,0x05,0x7a,0x7d]

v_cmpx_ne_u16 s1, v2
// GFX10: encoding: [0x01,0x04,0x7a,0x7d]

v_cmpx_ne_u16 s101, v2
// GFX10: encoding: [0x65,0x04,0x7a,0x7d]

v_cmpx_ne_u16 vcc_lo, v2
// GFX10: encoding: [0x6a,0x04,0x7a,0x7d]

v_cmpx_ne_u16 vcc_hi, v2
// GFX10: encoding: [0x6b,0x04,0x7a,0x7d]

v_cmpx_ne_u16 m0, v2
// GFX10: encoding: [0x7c,0x04,0x7a,0x7d]

v_cmpx_ne_u16 exec_lo, v2
// GFX10: encoding: [0x7e,0x04,0x7a,0x7d]

v_cmpx_ne_u16 exec_hi, v2
// GFX10: encoding: [0x7f,0x04,0x7a,0x7d]

v_cmpx_ne_u16 0, v2
// GFX10: encoding: [0x80,0x04,0x7a,0x7d]

v_cmpx_ne_u16 -1, v2
// GFX10: encoding: [0xc1,0x04,0x7a,0x7d]

v_cmpx_ne_u16 0.5, v2
// GFX10: encoding: [0xff,0x04,0x7a,0x7d,0x00,0x38,0x00,0x00]

v_cmpx_ne_u16 -4.0, v2
// GFX10: encoding: [0xff,0x04,0x7a,0x7d,0x00,0xc4,0x00,0x00]

v_cmpx_ne_u16 0xfe0b, v2
// GFX10: encoding: [0xff,0x04,0x7a,0x7d,0x0b,0xfe,0x00,0x00]

v_cmpx_ne_u16 0x3456, v2
// GFX10: encoding: [0xff,0x04,0x7a,0x7d,0x56,0x34,0x00,0x00]

v_cmpx_ne_u16 v1, v255
// GFX10: encoding: [0x01,0xff,0x7b,0x7d]

v_cmpx_ne_u16_e64 v1, v2
// GFX10: encoding: [0x00,0x00,0xbd,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_ne_u16_e64 v255, v2
// GFX10: encoding: [0x00,0x00,0xbd,0xd4,0xff,0x05,0x02,0x00]

v_cmpx_ne_u16_e64 s1, v2
// GFX10: encoding: [0x00,0x00,0xbd,0xd4,0x01,0x04,0x02,0x00]

v_cmpx_ne_u16_e64 s101, v2
// GFX10: encoding: [0x00,0x00,0xbd,0xd4,0x65,0x04,0x02,0x00]

v_cmpx_ne_u16_e64 vcc_lo, v2
// GFX10: encoding: [0x00,0x00,0xbd,0xd4,0x6a,0x04,0x02,0x00]

v_cmpx_ne_u16_e64 vcc_hi, v2
// GFX10: encoding: [0x00,0x00,0xbd,0xd4,0x6b,0x04,0x02,0x00]

v_cmpx_ne_u16_e64 m0, v2
// GFX10: encoding: [0x00,0x00,0xbd,0xd4,0x7c,0x04,0x02,0x00]

v_cmpx_ne_u16_e64 exec_lo, v2
// GFX10: encoding: [0x00,0x00,0xbd,0xd4,0x7e,0x04,0x02,0x00]

v_cmpx_ne_u16_e64 exec_hi, v2
// GFX10: encoding: [0x00,0x00,0xbd,0xd4,0x7f,0x04,0x02,0x00]

v_cmpx_ne_u16_e64 0, v2
// GFX10: encoding: [0x00,0x00,0xbd,0xd4,0x80,0x04,0x02,0x00]

v_cmpx_ne_u16_e64 -1, v2
// GFX10: encoding: [0x00,0x00,0xbd,0xd4,0xc1,0x04,0x02,0x00]

v_cmpx_ne_u16_e64 0.5, v2
// GFX10: encoding: [0x00,0x00,0xbd,0xd4,0xff,0x04,0x02,0x00,0x00,0x38,0x00,0x00]

v_cmpx_ne_u16_e64 -4.0, v2
// GFX10: encoding: [0x00,0x00,0xbd,0xd4,0xff,0x04,0x02,0x00,0x00,0xc4,0x00,0x00]

v_cmpx_ne_u16_e64 v1, v255
// GFX10: encoding: [0x00,0x00,0xbd,0xd4,0x01,0xff,0x03,0x00]

v_cmpx_ne_u16_e64 v1, s2
// GFX10: encoding: [0x00,0x00,0xbd,0xd4,0x01,0x05,0x00,0x00]

v_cmpx_ne_u16_e64 v1, s101
// GFX10: encoding: [0x00,0x00,0xbd,0xd4,0x01,0xcb,0x00,0x00]

v_cmpx_ne_u16_e64 v1, vcc_lo
// GFX10: encoding: [0x00,0x00,0xbd,0xd4,0x01,0xd5,0x00,0x00]

v_cmpx_ne_u16_e64 v1, vcc_hi
// GFX10: encoding: [0x00,0x00,0xbd,0xd4,0x01,0xd7,0x00,0x00]

v_cmpx_ne_u16_e64 v1, m0
// GFX10: encoding: [0x00,0x00,0xbd,0xd4,0x01,0xf9,0x00,0x00]

v_cmpx_ne_u16_e64 v1, exec_lo
// GFX10: encoding: [0x00,0x00,0xbd,0xd4,0x01,0xfd,0x00,0x00]

v_cmpx_ne_u16_e64 v1, exec_hi
// GFX10: encoding: [0x00,0x00,0xbd,0xd4,0x01,0xff,0x00,0x00]

v_cmpx_ne_u16_e64 v1, 0
// GFX10: encoding: [0x00,0x00,0xbd,0xd4,0x01,0x01,0x01,0x00]

v_cmpx_ne_u16_e64 v1, -1
// GFX10: encoding: [0x00,0x00,0xbd,0xd4,0x01,0x83,0x01,0x00]

v_cmpx_ne_u16_e64 v1, 0.5
// GFX10: encoding: [0x00,0x00,0xbd,0xd4,0x01,0xff,0x01,0x00,0x00,0x38,0x00,0x00]

v_cmpx_ne_u16_e64 v1, -4.0
// GFX10: encoding: [0x00,0x00,0xbd,0xd4,0x01,0xff,0x01,0x00,0x00,0xc4,0x00,0x00]

v_cmpx_ge_u16 v1, v2
// GFX10: encoding: [0x01,0x05,0x7c,0x7d]

v_cmpx_ge_u16 v255, v2
// GFX10: encoding: [0xff,0x05,0x7c,0x7d]

v_cmpx_ge_u16 s1, v2
// GFX10: encoding: [0x01,0x04,0x7c,0x7d]

v_cmpx_ge_u16 s101, v2
// GFX10: encoding: [0x65,0x04,0x7c,0x7d]

v_cmpx_ge_u16 vcc_lo, v2
// GFX10: encoding: [0x6a,0x04,0x7c,0x7d]

v_cmpx_ge_u16 vcc_hi, v2
// GFX10: encoding: [0x6b,0x04,0x7c,0x7d]

v_cmpx_ge_u16 m0, v2
// GFX10: encoding: [0x7c,0x04,0x7c,0x7d]

v_cmpx_ge_u16 exec_lo, v2
// GFX10: encoding: [0x7e,0x04,0x7c,0x7d]

v_cmpx_ge_u16 exec_hi, v2
// GFX10: encoding: [0x7f,0x04,0x7c,0x7d]

v_cmpx_ge_u16 0, v2
// GFX10: encoding: [0x80,0x04,0x7c,0x7d]

v_cmpx_ge_u16 -1, v2
// GFX10: encoding: [0xc1,0x04,0x7c,0x7d]

v_cmpx_ge_u16 0.5, v2
// GFX10: encoding: [0xff,0x04,0x7c,0x7d,0x00,0x38,0x00,0x00]

v_cmpx_ge_u16 -4.0, v2
// GFX10: encoding: [0xff,0x04,0x7c,0x7d,0x00,0xc4,0x00,0x00]

v_cmpx_ge_u16 0xfe0b, v2
// GFX10: encoding: [0xff,0x04,0x7c,0x7d,0x0b,0xfe,0x00,0x00]

v_cmpx_ge_u16 0x3456, v2
// GFX10: encoding: [0xff,0x04,0x7c,0x7d,0x56,0x34,0x00,0x00]

v_cmpx_ge_u16 v1, v255
// GFX10: encoding: [0x01,0xff,0x7d,0x7d]

v_cmpx_ge_u16_e64 v1, v2
// GFX10: encoding: [0x00,0x00,0xbe,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_ge_u16_e64 v255, v2
// GFX10: encoding: [0x00,0x00,0xbe,0xd4,0xff,0x05,0x02,0x00]

v_cmpx_ge_u16_e64 s1, v2
// GFX10: encoding: [0x00,0x00,0xbe,0xd4,0x01,0x04,0x02,0x00]

v_cmpx_ge_u16_e64 s101, v2
// GFX10: encoding: [0x00,0x00,0xbe,0xd4,0x65,0x04,0x02,0x00]

v_cmpx_ge_u16_e64 vcc_lo, v2
// GFX10: encoding: [0x00,0x00,0xbe,0xd4,0x6a,0x04,0x02,0x00]

v_cmpx_ge_u16_e64 vcc_hi, v2
// GFX10: encoding: [0x00,0x00,0xbe,0xd4,0x6b,0x04,0x02,0x00]

v_cmpx_ge_u16_e64 m0, v2
// GFX10: encoding: [0x00,0x00,0xbe,0xd4,0x7c,0x04,0x02,0x00]

v_cmpx_ge_u16_e64 exec_lo, v2
// GFX10: encoding: [0x00,0x00,0xbe,0xd4,0x7e,0x04,0x02,0x00]

v_cmpx_ge_u16_e64 exec_hi, v2
// GFX10: encoding: [0x00,0x00,0xbe,0xd4,0x7f,0x04,0x02,0x00]

v_cmpx_ge_u16_e64 0, v2
// GFX10: encoding: [0x00,0x00,0xbe,0xd4,0x80,0x04,0x02,0x00]

v_cmpx_ge_u16_e64 -1, v2
// GFX10: encoding: [0x00,0x00,0xbe,0xd4,0xc1,0x04,0x02,0x00]

v_cmpx_ge_u16_e64 0.5, v2
// GFX10: encoding: [0x00,0x00,0xbe,0xd4,0xff,0x04,0x02,0x00,0x00,0x38,0x00,0x00]

v_cmpx_ge_u16_e64 -4.0, v2
// GFX10: encoding: [0x00,0x00,0xbe,0xd4,0xff,0x04,0x02,0x00,0x00,0xc4,0x00,0x00]

v_cmpx_ge_u16_e64 v1, v255
// GFX10: encoding: [0x00,0x00,0xbe,0xd4,0x01,0xff,0x03,0x00]

v_cmpx_ge_u16_e64 v1, s2
// GFX10: encoding: [0x00,0x00,0xbe,0xd4,0x01,0x05,0x00,0x00]

v_cmpx_ge_u16_e64 v1, s101
// GFX10: encoding: [0x00,0x00,0xbe,0xd4,0x01,0xcb,0x00,0x00]

v_cmpx_ge_u16_e64 v1, vcc_lo
// GFX10: encoding: [0x00,0x00,0xbe,0xd4,0x01,0xd5,0x00,0x00]

v_cmpx_ge_u16_e64 v1, vcc_hi
// GFX10: encoding: [0x00,0x00,0xbe,0xd4,0x01,0xd7,0x00,0x00]

v_cmpx_ge_u16_e64 v1, m0
// GFX10: encoding: [0x00,0x00,0xbe,0xd4,0x01,0xf9,0x00,0x00]

v_cmpx_ge_u16_e64 v1, exec_lo
// GFX10: encoding: [0x00,0x00,0xbe,0xd4,0x01,0xfd,0x00,0x00]

v_cmpx_ge_u16_e64 v1, exec_hi
// GFX10: encoding: [0x00,0x00,0xbe,0xd4,0x01,0xff,0x00,0x00]

v_cmpx_ge_u16_e64 v1, 0
// GFX10: encoding: [0x00,0x00,0xbe,0xd4,0x01,0x01,0x01,0x00]

v_cmpx_ge_u16_e64 v1, -1
// GFX10: encoding: [0x00,0x00,0xbe,0xd4,0x01,0x83,0x01,0x00]

v_cmpx_ge_u16_e64 v1, 0.5
// GFX10: encoding: [0x00,0x00,0xbe,0xd4,0x01,0xff,0x01,0x00,0x00,0x38,0x00,0x00]

v_cmpx_ge_u16_e64 v1, -4.0
// GFX10: encoding: [0x00,0x00,0xbe,0xd4,0x01,0xff,0x01,0x00,0x00,0xc4,0x00,0x00]

v_cmpx_f_u32 v1, v2
// GFX10: encoding: [0x01,0x05,0xa0,0x7d]

v_cmpx_f_u32 v255, v2
// GFX10: encoding: [0xff,0x05,0xa0,0x7d]

v_cmpx_f_u32 s1, v2
// GFX10: encoding: [0x01,0x04,0xa0,0x7d]

v_cmpx_f_u32 s101, v2
// GFX10: encoding: [0x65,0x04,0xa0,0x7d]

v_cmpx_f_u32 vcc_lo, v2
// GFX10: encoding: [0x6a,0x04,0xa0,0x7d]

v_cmpx_f_u32 vcc_hi, v2
// GFX10: encoding: [0x6b,0x04,0xa0,0x7d]

v_cmpx_f_u32 m0, v2
// GFX10: encoding: [0x7c,0x04,0xa0,0x7d]

v_cmpx_f_u32 exec_lo, v2
// GFX10: encoding: [0x7e,0x04,0xa0,0x7d]

v_cmpx_f_u32 exec_hi, v2
// GFX10: encoding: [0x7f,0x04,0xa0,0x7d]

v_cmpx_f_u32 0, v2
// GFX10: encoding: [0x80,0x04,0xa0,0x7d]

v_cmpx_f_u32 -1, v2
// GFX10: encoding: [0xc1,0x04,0xa0,0x7d]

v_cmpx_f_u32 0.5, v2
// GFX10: encoding: [0xf0,0x04,0xa0,0x7d]

v_cmpx_f_u32 -4.0, v2
// GFX10: encoding: [0xf7,0x04,0xa0,0x7d]

v_cmpx_f_u32 0xaf123456, v2
// GFX10: encoding: [0xff,0x04,0xa0,0x7d,0x56,0x34,0x12,0xaf]

v_cmpx_f_u32 0x3f717273, v2
// GFX10: encoding: [0xff,0x04,0xa0,0x7d,0x73,0x72,0x71,0x3f]

v_cmpx_f_u32 v1, v255
// GFX10: encoding: [0x01,0xff,0xa1,0x7d]

v_cmpx_f_u32_e64 v1, v2
// GFX10: encoding: [0x00,0x00,0xd0,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_f_u32_e64 v255, v2
// GFX10: encoding: [0x00,0x00,0xd0,0xd4,0xff,0x05,0x02,0x00]

v_cmpx_f_u32_e64 s1, v2
// GFX10: encoding: [0x00,0x00,0xd0,0xd4,0x01,0x04,0x02,0x00]

v_cmpx_f_u32_e64 s101, v2
// GFX10: encoding: [0x00,0x00,0xd0,0xd4,0x65,0x04,0x02,0x00]

v_cmpx_f_u32_e64 vcc_lo, v2
// GFX10: encoding: [0x00,0x00,0xd0,0xd4,0x6a,0x04,0x02,0x00]

v_cmpx_f_u32_e64 vcc_hi, v2
// GFX10: encoding: [0x00,0x00,0xd0,0xd4,0x6b,0x04,0x02,0x00]

v_cmpx_f_u32_e64 m0, v2
// GFX10: encoding: [0x00,0x00,0xd0,0xd4,0x7c,0x04,0x02,0x00]

v_cmpx_f_u32_e64 exec_lo, v2
// GFX10: encoding: [0x00,0x00,0xd0,0xd4,0x7e,0x04,0x02,0x00]

v_cmpx_f_u32_e64 exec_hi, v2
// GFX10: encoding: [0x00,0x00,0xd0,0xd4,0x7f,0x04,0x02,0x00]

v_cmpx_f_u32_e64 0, v2
// GFX10: encoding: [0x00,0x00,0xd0,0xd4,0x80,0x04,0x02,0x00]

v_cmpx_f_u32_e64 -1, v2
// GFX10: encoding: [0x00,0x00,0xd0,0xd4,0xc1,0x04,0x02,0x00]

v_cmpx_f_u32_e64 0.5, v2
// GFX10: encoding: [0x00,0x00,0xd0,0xd4,0xf0,0x04,0x02,0x00]

v_cmpx_f_u32_e64 -4.0, v2
// GFX10: encoding: [0x00,0x00,0xd0,0xd4,0xf7,0x04,0x02,0x00]

v_cmpx_f_u32_e64 v1, v255
// GFX10: encoding: [0x00,0x00,0xd0,0xd4,0x01,0xff,0x03,0x00]

v_cmpx_f_u32_e64 v1, s2
// GFX10: encoding: [0x00,0x00,0xd0,0xd4,0x01,0x05,0x00,0x00]

v_cmpx_f_u32_e64 v1, s101
// GFX10: encoding: [0x00,0x00,0xd0,0xd4,0x01,0xcb,0x00,0x00]

v_cmpx_f_u32_e64 v1, vcc_lo
// GFX10: encoding: [0x00,0x00,0xd0,0xd4,0x01,0xd5,0x00,0x00]

v_cmpx_f_u32_e64 v1, vcc_hi
// GFX10: encoding: [0x00,0x00,0xd0,0xd4,0x01,0xd7,0x00,0x00]

v_cmpx_f_u32_e64 v1, m0
// GFX10: encoding: [0x00,0x00,0xd0,0xd4,0x01,0xf9,0x00,0x00]

v_cmpx_f_u32_e64 v1, exec_lo
// GFX10: encoding: [0x00,0x00,0xd0,0xd4,0x01,0xfd,0x00,0x00]

v_cmpx_f_u32_e64 v1, exec_hi
// GFX10: encoding: [0x00,0x00,0xd0,0xd4,0x01,0xff,0x00,0x00]

v_cmpx_f_u32_e64 v1, 0
// GFX10: encoding: [0x00,0x00,0xd0,0xd4,0x01,0x01,0x01,0x00]

v_cmpx_f_u32_e64 v1, -1
// GFX10: encoding: [0x00,0x00,0xd0,0xd4,0x01,0x83,0x01,0x00]

v_cmpx_f_u32_e64 v1, 0.5
// GFX10: encoding: [0x00,0x00,0xd0,0xd4,0x01,0xe1,0x01,0x00]

v_cmpx_f_u32_e64 v1, -4.0
// GFX10: encoding: [0x00,0x00,0xd0,0xd4,0x01,0xef,0x01,0x00]

v_cmpx_lt_u32 v1, v2
// GFX10: encoding: [0x01,0x05,0xa2,0x7d]

v_cmpx_lt_u32 v255, v2
// GFX10: encoding: [0xff,0x05,0xa2,0x7d]

v_cmpx_lt_u32 s1, v2
// GFX10: encoding: [0x01,0x04,0xa2,0x7d]

v_cmpx_lt_u32 s101, v2
// GFX10: encoding: [0x65,0x04,0xa2,0x7d]

v_cmpx_lt_u32 vcc_lo, v2
// GFX10: encoding: [0x6a,0x04,0xa2,0x7d]

v_cmpx_lt_u32 vcc_hi, v2
// GFX10: encoding: [0x6b,0x04,0xa2,0x7d]

v_cmpx_lt_u32 m0, v2
// GFX10: encoding: [0x7c,0x04,0xa2,0x7d]

v_cmpx_lt_u32 exec_lo, v2
// GFX10: encoding: [0x7e,0x04,0xa2,0x7d]

v_cmpx_lt_u32 exec_hi, v2
// GFX10: encoding: [0x7f,0x04,0xa2,0x7d]

v_cmpx_lt_u32 0, v2
// GFX10: encoding: [0x80,0x04,0xa2,0x7d]

v_cmpx_lt_u32 -1, v2
// GFX10: encoding: [0xc1,0x04,0xa2,0x7d]

v_cmpx_lt_u32 0.5, v2
// GFX10: encoding: [0xf0,0x04,0xa2,0x7d]

v_cmpx_lt_u32 -4.0, v2
// GFX10: encoding: [0xf7,0x04,0xa2,0x7d]

v_cmpx_lt_u32 0xaf123456, v2
// GFX10: encoding: [0xff,0x04,0xa2,0x7d,0x56,0x34,0x12,0xaf]

v_cmpx_lt_u32 0x3f717273, v2
// GFX10: encoding: [0xff,0x04,0xa2,0x7d,0x73,0x72,0x71,0x3f]

v_cmpx_lt_u32 v1, v255
// GFX10: encoding: [0x01,0xff,0xa3,0x7d]

v_cmpx_lt_u32_e64 v1, v2
// GFX10: encoding: [0x00,0x00,0xd1,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_lt_u32_e64 v255, v2
// GFX10: encoding: [0x00,0x00,0xd1,0xd4,0xff,0x05,0x02,0x00]

v_cmpx_lt_u32_e64 s1, v2
// GFX10: encoding: [0x00,0x00,0xd1,0xd4,0x01,0x04,0x02,0x00]

v_cmpx_lt_u32_e64 s101, v2
// GFX10: encoding: [0x00,0x00,0xd1,0xd4,0x65,0x04,0x02,0x00]

v_cmpx_lt_u32_e64 vcc_lo, v2
// GFX10: encoding: [0x00,0x00,0xd1,0xd4,0x6a,0x04,0x02,0x00]

v_cmpx_lt_u32_e64 vcc_hi, v2
// GFX10: encoding: [0x00,0x00,0xd1,0xd4,0x6b,0x04,0x02,0x00]

v_cmpx_lt_u32_e64 m0, v2
// GFX10: encoding: [0x00,0x00,0xd1,0xd4,0x7c,0x04,0x02,0x00]

v_cmpx_lt_u32_e64 exec_lo, v2
// GFX10: encoding: [0x00,0x00,0xd1,0xd4,0x7e,0x04,0x02,0x00]

v_cmpx_lt_u32_e64 exec_hi, v2
// GFX10: encoding: [0x00,0x00,0xd1,0xd4,0x7f,0x04,0x02,0x00]

v_cmpx_lt_u32_e64 0, v2
// GFX10: encoding: [0x00,0x00,0xd1,0xd4,0x80,0x04,0x02,0x00]

v_cmpx_lt_u32_e64 -1, v2
// GFX10: encoding: [0x00,0x00,0xd1,0xd4,0xc1,0x04,0x02,0x00]

v_cmpx_lt_u32_e64 0.5, v2
// GFX10: encoding: [0x00,0x00,0xd1,0xd4,0xf0,0x04,0x02,0x00]

v_cmpx_lt_u32_e64 -4.0, v2
// GFX10: encoding: [0x00,0x00,0xd1,0xd4,0xf7,0x04,0x02,0x00]

v_cmpx_lt_u32_e64 v1, v255
// GFX10: encoding: [0x00,0x00,0xd1,0xd4,0x01,0xff,0x03,0x00]

v_cmpx_lt_u32_e64 v1, s2
// GFX10: encoding: [0x00,0x00,0xd1,0xd4,0x01,0x05,0x00,0x00]

v_cmpx_lt_u32_e64 v1, s101
// GFX10: encoding: [0x00,0x00,0xd1,0xd4,0x01,0xcb,0x00,0x00]

v_cmpx_lt_u32_e64 v1, vcc_lo
// GFX10: encoding: [0x00,0x00,0xd1,0xd4,0x01,0xd5,0x00,0x00]

v_cmpx_lt_u32_e64 v1, vcc_hi
// GFX10: encoding: [0x00,0x00,0xd1,0xd4,0x01,0xd7,0x00,0x00]

v_cmpx_lt_u32_e64 v1, m0
// GFX10: encoding: [0x00,0x00,0xd1,0xd4,0x01,0xf9,0x00,0x00]

v_cmpx_lt_u32_e64 v1, exec_lo
// GFX10: encoding: [0x00,0x00,0xd1,0xd4,0x01,0xfd,0x00,0x00]

v_cmpx_lt_u32_e64 v1, exec_hi
// GFX10: encoding: [0x00,0x00,0xd1,0xd4,0x01,0xff,0x00,0x00]

v_cmpx_lt_u32_e64 v1, 0
// GFX10: encoding: [0x00,0x00,0xd1,0xd4,0x01,0x01,0x01,0x00]

v_cmpx_lt_u32_e64 v1, -1
// GFX10: encoding: [0x00,0x00,0xd1,0xd4,0x01,0x83,0x01,0x00]

v_cmpx_lt_u32_e64 v1, 0.5
// GFX10: encoding: [0x00,0x00,0xd1,0xd4,0x01,0xe1,0x01,0x00]

v_cmpx_lt_u32_e64 v1, -4.0
// GFX10: encoding: [0x00,0x00,0xd1,0xd4,0x01,0xef,0x01,0x00]

v_cmpx_eq_u32 v1, v2
// GFX10: encoding: [0x01,0x05,0xa4,0x7d]

v_cmpx_eq_u32 v255, v2
// GFX10: encoding: [0xff,0x05,0xa4,0x7d]

v_cmpx_eq_u32 s1, v2
// GFX10: encoding: [0x01,0x04,0xa4,0x7d]

v_cmpx_eq_u32 s101, v2
// GFX10: encoding: [0x65,0x04,0xa4,0x7d]

v_cmpx_eq_u32 vcc_lo, v2
// GFX10: encoding: [0x6a,0x04,0xa4,0x7d]

v_cmpx_eq_u32 vcc_hi, v2
// GFX10: encoding: [0x6b,0x04,0xa4,0x7d]

v_cmpx_eq_u32 m0, v2
// GFX10: encoding: [0x7c,0x04,0xa4,0x7d]

v_cmpx_eq_u32 exec_lo, v2
// GFX10: encoding: [0x7e,0x04,0xa4,0x7d]

v_cmpx_eq_u32 exec_hi, v2
// GFX10: encoding: [0x7f,0x04,0xa4,0x7d]

v_cmpx_eq_u32 0, v2
// GFX10: encoding: [0x80,0x04,0xa4,0x7d]

v_cmpx_eq_u32 -1, v2
// GFX10: encoding: [0xc1,0x04,0xa4,0x7d]

v_cmpx_eq_u32 0.5, v2
// GFX10: encoding: [0xf0,0x04,0xa4,0x7d]

v_cmpx_eq_u32 -4.0, v2
// GFX10: encoding: [0xf7,0x04,0xa4,0x7d]

v_cmpx_eq_u32 0xaf123456, v2
// GFX10: encoding: [0xff,0x04,0xa4,0x7d,0x56,0x34,0x12,0xaf]

v_cmpx_eq_u32 0x3f717273, v2
// GFX10: encoding: [0xff,0x04,0xa4,0x7d,0x73,0x72,0x71,0x3f]

v_cmpx_eq_u32 v1, v255
// GFX10: encoding: [0x01,0xff,0xa5,0x7d]

v_cmpx_eq_u32_e64 v1, v2
// GFX10: encoding: [0x00,0x00,0xd2,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_eq_u32_e64 v255, v2
// GFX10: encoding: [0x00,0x00,0xd2,0xd4,0xff,0x05,0x02,0x00]

v_cmpx_eq_u32_e64 s1, v2
// GFX10: encoding: [0x00,0x00,0xd2,0xd4,0x01,0x04,0x02,0x00]

v_cmpx_eq_u32_e64 s101, v2
// GFX10: encoding: [0x00,0x00,0xd2,0xd4,0x65,0x04,0x02,0x00]

v_cmpx_eq_u32_e64 vcc_lo, v2
// GFX10: encoding: [0x00,0x00,0xd2,0xd4,0x6a,0x04,0x02,0x00]

v_cmpx_eq_u32_e64 vcc_hi, v2
// GFX10: encoding: [0x00,0x00,0xd2,0xd4,0x6b,0x04,0x02,0x00]

v_cmpx_eq_u32_e64 m0, v2
// GFX10: encoding: [0x00,0x00,0xd2,0xd4,0x7c,0x04,0x02,0x00]

v_cmpx_eq_u32_e64 exec_lo, v2
// GFX10: encoding: [0x00,0x00,0xd2,0xd4,0x7e,0x04,0x02,0x00]

v_cmpx_eq_u32_e64 exec_hi, v2
// GFX10: encoding: [0x00,0x00,0xd2,0xd4,0x7f,0x04,0x02,0x00]

v_cmpx_eq_u32_e64 0, v2
// GFX10: encoding: [0x00,0x00,0xd2,0xd4,0x80,0x04,0x02,0x00]

v_cmpx_eq_u32_e64 -1, v2
// GFX10: encoding: [0x00,0x00,0xd2,0xd4,0xc1,0x04,0x02,0x00]

v_cmpx_eq_u32_e64 0.5, v2
// GFX10: encoding: [0x00,0x00,0xd2,0xd4,0xf0,0x04,0x02,0x00]

v_cmpx_eq_u32_e64 -4.0, v2
// GFX10: encoding: [0x00,0x00,0xd2,0xd4,0xf7,0x04,0x02,0x00]

v_cmpx_eq_u32_e64 v1, v255
// GFX10: encoding: [0x00,0x00,0xd2,0xd4,0x01,0xff,0x03,0x00]

v_cmpx_eq_u32_e64 v1, s2
// GFX10: encoding: [0x00,0x00,0xd2,0xd4,0x01,0x05,0x00,0x00]

v_cmpx_eq_u32_e64 v1, s101
// GFX10: encoding: [0x00,0x00,0xd2,0xd4,0x01,0xcb,0x00,0x00]

v_cmpx_eq_u32_e64 v1, vcc_lo
// GFX10: encoding: [0x00,0x00,0xd2,0xd4,0x01,0xd5,0x00,0x00]

v_cmpx_eq_u32_e64 v1, vcc_hi
// GFX10: encoding: [0x00,0x00,0xd2,0xd4,0x01,0xd7,0x00,0x00]

v_cmpx_eq_u32_e64 v1, m0
// GFX10: encoding: [0x00,0x00,0xd2,0xd4,0x01,0xf9,0x00,0x00]

v_cmpx_eq_u32_e64 v1, exec_lo
// GFX10: encoding: [0x00,0x00,0xd2,0xd4,0x01,0xfd,0x00,0x00]

v_cmpx_eq_u32_e64 v1, exec_hi
// GFX10: encoding: [0x00,0x00,0xd2,0xd4,0x01,0xff,0x00,0x00]

v_cmpx_eq_u32_e64 v1, 0
// GFX10: encoding: [0x00,0x00,0xd2,0xd4,0x01,0x01,0x01,0x00]

v_cmpx_eq_u32_e64 v1, -1
// GFX10: encoding: [0x00,0x00,0xd2,0xd4,0x01,0x83,0x01,0x00]

v_cmpx_eq_u32_e64 v1, 0.5
// GFX10: encoding: [0x00,0x00,0xd2,0xd4,0x01,0xe1,0x01,0x00]

v_cmpx_eq_u32_e64 v1, -4.0
// GFX10: encoding: [0x00,0x00,0xd2,0xd4,0x01,0xef,0x01,0x00]

v_cmpx_le_u32 v1, v2
// GFX10: encoding: [0x01,0x05,0xa6,0x7d]

v_cmpx_le_u32 v255, v2
// GFX10: encoding: [0xff,0x05,0xa6,0x7d]

v_cmpx_le_u32 s1, v2
// GFX10: encoding: [0x01,0x04,0xa6,0x7d]

v_cmpx_le_u32 s101, v2
// GFX10: encoding: [0x65,0x04,0xa6,0x7d]

v_cmpx_le_u32 vcc_lo, v2
// GFX10: encoding: [0x6a,0x04,0xa6,0x7d]

v_cmpx_le_u32 vcc_hi, v2
// GFX10: encoding: [0x6b,0x04,0xa6,0x7d]

v_cmpx_le_u32 m0, v2
// GFX10: encoding: [0x7c,0x04,0xa6,0x7d]

v_cmpx_le_u32 exec_lo, v2
// GFX10: encoding: [0x7e,0x04,0xa6,0x7d]

v_cmpx_le_u32 exec_hi, v2
// GFX10: encoding: [0x7f,0x04,0xa6,0x7d]

v_cmpx_le_u32 0, v2
// GFX10: encoding: [0x80,0x04,0xa6,0x7d]

v_cmpx_le_u32 -1, v2
// GFX10: encoding: [0xc1,0x04,0xa6,0x7d]

v_cmpx_le_u32 0.5, v2
// GFX10: encoding: [0xf0,0x04,0xa6,0x7d]

v_cmpx_le_u32 -4.0, v2
// GFX10: encoding: [0xf7,0x04,0xa6,0x7d]

v_cmpx_le_u32 0xaf123456, v2
// GFX10: encoding: [0xff,0x04,0xa6,0x7d,0x56,0x34,0x12,0xaf]

v_cmpx_le_u32 0x3f717273, v2
// GFX10: encoding: [0xff,0x04,0xa6,0x7d,0x73,0x72,0x71,0x3f]

v_cmpx_le_u32 v1, v255
// GFX10: encoding: [0x01,0xff,0xa7,0x7d]

v_cmpx_le_u32_e64 v1, v2
// GFX10: encoding: [0x00,0x00,0xd3,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_le_u32_e64 v255, v2
// GFX10: encoding: [0x00,0x00,0xd3,0xd4,0xff,0x05,0x02,0x00]

v_cmpx_le_u32_e64 s1, v2
// GFX10: encoding: [0x00,0x00,0xd3,0xd4,0x01,0x04,0x02,0x00]

v_cmpx_le_u32_e64 s101, v2
// GFX10: encoding: [0x00,0x00,0xd3,0xd4,0x65,0x04,0x02,0x00]

v_cmpx_le_u32_e64 vcc_lo, v2
// GFX10: encoding: [0x00,0x00,0xd3,0xd4,0x6a,0x04,0x02,0x00]

v_cmpx_le_u32_e64 vcc_hi, v2
// GFX10: encoding: [0x00,0x00,0xd3,0xd4,0x6b,0x04,0x02,0x00]

v_cmpx_le_u32_e64 m0, v2
// GFX10: encoding: [0x00,0x00,0xd3,0xd4,0x7c,0x04,0x02,0x00]

v_cmpx_le_u32_e64 exec_lo, v2
// GFX10: encoding: [0x00,0x00,0xd3,0xd4,0x7e,0x04,0x02,0x00]

v_cmpx_le_u32_e64 exec_hi, v2
// GFX10: encoding: [0x00,0x00,0xd3,0xd4,0x7f,0x04,0x02,0x00]

v_cmpx_le_u32_e64 0, v2
// GFX10: encoding: [0x00,0x00,0xd3,0xd4,0x80,0x04,0x02,0x00]

v_cmpx_le_u32_e64 -1, v2
// GFX10: encoding: [0x00,0x00,0xd3,0xd4,0xc1,0x04,0x02,0x00]

v_cmpx_le_u32_e64 0.5, v2
// GFX10: encoding: [0x00,0x00,0xd3,0xd4,0xf0,0x04,0x02,0x00]

v_cmpx_le_u32_e64 -4.0, v2
// GFX10: encoding: [0x00,0x00,0xd3,0xd4,0xf7,0x04,0x02,0x00]

v_cmpx_le_u32_e64 v1, v255
// GFX10: encoding: [0x00,0x00,0xd3,0xd4,0x01,0xff,0x03,0x00]

v_cmpx_le_u32_e64 v1, s2
// GFX10: encoding: [0x00,0x00,0xd3,0xd4,0x01,0x05,0x00,0x00]

v_cmpx_le_u32_e64 v1, s101
// GFX10: encoding: [0x00,0x00,0xd3,0xd4,0x01,0xcb,0x00,0x00]

v_cmpx_le_u32_e64 v1, vcc_lo
// GFX10: encoding: [0x00,0x00,0xd3,0xd4,0x01,0xd5,0x00,0x00]

v_cmpx_le_u32_e64 v1, vcc_hi
// GFX10: encoding: [0x00,0x00,0xd3,0xd4,0x01,0xd7,0x00,0x00]

v_cmpx_le_u32_e64 v1, m0
// GFX10: encoding: [0x00,0x00,0xd3,0xd4,0x01,0xf9,0x00,0x00]

v_cmpx_le_u32_e64 v1, exec_lo
// GFX10: encoding: [0x00,0x00,0xd3,0xd4,0x01,0xfd,0x00,0x00]

v_cmpx_le_u32_e64 v1, exec_hi
// GFX10: encoding: [0x00,0x00,0xd3,0xd4,0x01,0xff,0x00,0x00]

v_cmpx_le_u32_e64 v1, 0
// GFX10: encoding: [0x00,0x00,0xd3,0xd4,0x01,0x01,0x01,0x00]

v_cmpx_le_u32_e64 v1, -1
// GFX10: encoding: [0x00,0x00,0xd3,0xd4,0x01,0x83,0x01,0x00]

v_cmpx_le_u32_e64 v1, 0.5
// GFX10: encoding: [0x00,0x00,0xd3,0xd4,0x01,0xe1,0x01,0x00]

v_cmpx_le_u32_e64 v1, -4.0
// GFX10: encoding: [0x00,0x00,0xd3,0xd4,0x01,0xef,0x01,0x00]

v_cmpx_gt_u32 v1, v2
// GFX10: encoding: [0x01,0x05,0xa8,0x7d]

v_cmpx_gt_u32 v255, v2
// GFX10: encoding: [0xff,0x05,0xa8,0x7d]

v_cmpx_gt_u32 s1, v2
// GFX10: encoding: [0x01,0x04,0xa8,0x7d]

v_cmpx_gt_u32 s101, v2
// GFX10: encoding: [0x65,0x04,0xa8,0x7d]

v_cmpx_gt_u32 vcc_lo, v2
// GFX10: encoding: [0x6a,0x04,0xa8,0x7d]

v_cmpx_gt_u32 vcc_hi, v2
// GFX10: encoding: [0x6b,0x04,0xa8,0x7d]

v_cmpx_gt_u32 m0, v2
// GFX10: encoding: [0x7c,0x04,0xa8,0x7d]

v_cmpx_gt_u32 exec_lo, v2
// GFX10: encoding: [0x7e,0x04,0xa8,0x7d]

v_cmpx_gt_u32 exec_hi, v2
// GFX10: encoding: [0x7f,0x04,0xa8,0x7d]

v_cmpx_gt_u32 0, v2
// GFX10: encoding: [0x80,0x04,0xa8,0x7d]

v_cmpx_gt_u32 -1, v2
// GFX10: encoding: [0xc1,0x04,0xa8,0x7d]

v_cmpx_gt_u32 0.5, v2
// GFX10: encoding: [0xf0,0x04,0xa8,0x7d]

v_cmpx_gt_u32 -4.0, v2
// GFX10: encoding: [0xf7,0x04,0xa8,0x7d]

v_cmpx_gt_u32 0xaf123456, v2
// GFX10: encoding: [0xff,0x04,0xa8,0x7d,0x56,0x34,0x12,0xaf]

v_cmpx_gt_u32 0x3f717273, v2
// GFX10: encoding: [0xff,0x04,0xa8,0x7d,0x73,0x72,0x71,0x3f]

v_cmpx_gt_u32 v1, v255
// GFX10: encoding: [0x01,0xff,0xa9,0x7d]

v_cmpx_gt_u32_e64 v1, v2
// GFX10: encoding: [0x00,0x00,0xd4,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_gt_u32_e64 v255, v2
// GFX10: encoding: [0x00,0x00,0xd4,0xd4,0xff,0x05,0x02,0x00]

v_cmpx_gt_u32_e64 s1, v2
// GFX10: encoding: [0x00,0x00,0xd4,0xd4,0x01,0x04,0x02,0x00]

v_cmpx_gt_u32_e64 s101, v2
// GFX10: encoding: [0x00,0x00,0xd4,0xd4,0x65,0x04,0x02,0x00]

v_cmpx_gt_u32_e64 vcc_lo, v2
// GFX10: encoding: [0x00,0x00,0xd4,0xd4,0x6a,0x04,0x02,0x00]

v_cmpx_gt_u32_e64 vcc_hi, v2
// GFX10: encoding: [0x00,0x00,0xd4,0xd4,0x6b,0x04,0x02,0x00]

v_cmpx_gt_u32_e64 m0, v2
// GFX10: encoding: [0x00,0x00,0xd4,0xd4,0x7c,0x04,0x02,0x00]

v_cmpx_gt_u32_e64 exec_lo, v2
// GFX10: encoding: [0x00,0x00,0xd4,0xd4,0x7e,0x04,0x02,0x00]

v_cmpx_gt_u32_e64 exec_hi, v2
// GFX10: encoding: [0x00,0x00,0xd4,0xd4,0x7f,0x04,0x02,0x00]

v_cmpx_gt_u32_e64 0, v2
// GFX10: encoding: [0x00,0x00,0xd4,0xd4,0x80,0x04,0x02,0x00]

v_cmpx_gt_u32_e64 -1, v2
// GFX10: encoding: [0x00,0x00,0xd4,0xd4,0xc1,0x04,0x02,0x00]

v_cmpx_gt_u32_e64 0.5, v2
// GFX10: encoding: [0x00,0x00,0xd4,0xd4,0xf0,0x04,0x02,0x00]

v_cmpx_gt_u32_e64 -4.0, v2
// GFX10: encoding: [0x00,0x00,0xd4,0xd4,0xf7,0x04,0x02,0x00]

v_cmpx_gt_u32_e64 v1, v255
// GFX10: encoding: [0x00,0x00,0xd4,0xd4,0x01,0xff,0x03,0x00]

v_cmpx_gt_u32_e64 v1, s2
// GFX10: encoding: [0x00,0x00,0xd4,0xd4,0x01,0x05,0x00,0x00]

v_cmpx_gt_u32_e64 v1, s101
// GFX10: encoding: [0x00,0x00,0xd4,0xd4,0x01,0xcb,0x00,0x00]

v_cmpx_gt_u32_e64 v1, vcc_lo
// GFX10: encoding: [0x00,0x00,0xd4,0xd4,0x01,0xd5,0x00,0x00]

v_cmpx_gt_u32_e64 v1, vcc_hi
// GFX10: encoding: [0x00,0x00,0xd4,0xd4,0x01,0xd7,0x00,0x00]

v_cmpx_gt_u32_e64 v1, m0
// GFX10: encoding: [0x00,0x00,0xd4,0xd4,0x01,0xf9,0x00,0x00]

v_cmpx_gt_u32_e64 v1, exec_lo
// GFX10: encoding: [0x00,0x00,0xd4,0xd4,0x01,0xfd,0x00,0x00]

v_cmpx_gt_u32_e64 v1, exec_hi
// GFX10: encoding: [0x00,0x00,0xd4,0xd4,0x01,0xff,0x00,0x00]

v_cmpx_gt_u32_e64 v1, 0
// GFX10: encoding: [0x00,0x00,0xd4,0xd4,0x01,0x01,0x01,0x00]

v_cmpx_gt_u32_e64 v1, -1
// GFX10: encoding: [0x00,0x00,0xd4,0xd4,0x01,0x83,0x01,0x00]

v_cmpx_gt_u32_e64 v1, 0.5
// GFX10: encoding: [0x00,0x00,0xd4,0xd4,0x01,0xe1,0x01,0x00]

v_cmpx_gt_u32_e64 v1, -4.0
// GFX10: encoding: [0x00,0x00,0xd4,0xd4,0x01,0xef,0x01,0x00]

v_cmpx_ne_u32 v1, v2
// GFX10: encoding: [0x01,0x05,0xaa,0x7d]

v_cmpx_ne_u32 v255, v2
// GFX10: encoding: [0xff,0x05,0xaa,0x7d]

v_cmpx_ne_u32 s1, v2
// GFX10: encoding: [0x01,0x04,0xaa,0x7d]

v_cmpx_ne_u32 s101, v2
// GFX10: encoding: [0x65,0x04,0xaa,0x7d]

v_cmpx_ne_u32 vcc_lo, v2
// GFX10: encoding: [0x6a,0x04,0xaa,0x7d]

v_cmpx_ne_u32 vcc_hi, v2
// GFX10: encoding: [0x6b,0x04,0xaa,0x7d]

v_cmpx_ne_u32 m0, v2
// GFX10: encoding: [0x7c,0x04,0xaa,0x7d]

v_cmpx_ne_u32 exec_lo, v2
// GFX10: encoding: [0x7e,0x04,0xaa,0x7d]

v_cmpx_ne_u32 exec_hi, v2
// GFX10: encoding: [0x7f,0x04,0xaa,0x7d]

v_cmpx_ne_u32 0, v2
// GFX10: encoding: [0x80,0x04,0xaa,0x7d]

v_cmpx_ne_u32 -1, v2
// GFX10: encoding: [0xc1,0x04,0xaa,0x7d]

v_cmpx_ne_u32 0.5, v2
// GFX10: encoding: [0xf0,0x04,0xaa,0x7d]

v_cmpx_ne_u32 -4.0, v2
// GFX10: encoding: [0xf7,0x04,0xaa,0x7d]

v_cmpx_ne_u32 0xaf123456, v2
// GFX10: encoding: [0xff,0x04,0xaa,0x7d,0x56,0x34,0x12,0xaf]

v_cmpx_ne_u32 0x3f717273, v2
// GFX10: encoding: [0xff,0x04,0xaa,0x7d,0x73,0x72,0x71,0x3f]

v_cmpx_ne_u32 v1, v255
// GFX10: encoding: [0x01,0xff,0xab,0x7d]

v_cmpx_ne_u32_e64 v1, v2
// GFX10: encoding: [0x00,0x00,0xd5,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_ne_u32_e64 v255, v2
// GFX10: encoding: [0x00,0x00,0xd5,0xd4,0xff,0x05,0x02,0x00]

v_cmpx_ne_u32_e64 s1, v2
// GFX10: encoding: [0x00,0x00,0xd5,0xd4,0x01,0x04,0x02,0x00]

v_cmpx_ne_u32_e64 s101, v2
// GFX10: encoding: [0x00,0x00,0xd5,0xd4,0x65,0x04,0x02,0x00]

v_cmpx_ne_u32_e64 vcc_lo, v2
// GFX10: encoding: [0x00,0x00,0xd5,0xd4,0x6a,0x04,0x02,0x00]

v_cmpx_ne_u32_e64 vcc_hi, v2
// GFX10: encoding: [0x00,0x00,0xd5,0xd4,0x6b,0x04,0x02,0x00]

v_cmpx_ne_u32_e64 m0, v2
// GFX10: encoding: [0x00,0x00,0xd5,0xd4,0x7c,0x04,0x02,0x00]

v_cmpx_ne_u32_e64 exec_lo, v2
// GFX10: encoding: [0x00,0x00,0xd5,0xd4,0x7e,0x04,0x02,0x00]

v_cmpx_ne_u32_e64 exec_hi, v2
// GFX10: encoding: [0x00,0x00,0xd5,0xd4,0x7f,0x04,0x02,0x00]

v_cmpx_ne_u32_e64 0, v2
// GFX10: encoding: [0x00,0x00,0xd5,0xd4,0x80,0x04,0x02,0x00]

v_cmpx_ne_u32_e64 -1, v2
// GFX10: encoding: [0x00,0x00,0xd5,0xd4,0xc1,0x04,0x02,0x00]

v_cmpx_ne_u32_e64 0.5, v2
// GFX10: encoding: [0x00,0x00,0xd5,0xd4,0xf0,0x04,0x02,0x00]

v_cmpx_ne_u32_e64 -4.0, v2
// GFX10: encoding: [0x00,0x00,0xd5,0xd4,0xf7,0x04,0x02,0x00]

v_cmpx_ne_u32_e64 v1, v255
// GFX10: encoding: [0x00,0x00,0xd5,0xd4,0x01,0xff,0x03,0x00]

v_cmpx_ne_u32_e64 v1, s2
// GFX10: encoding: [0x00,0x00,0xd5,0xd4,0x01,0x05,0x00,0x00]

v_cmpx_ne_u32_e64 v1, s101
// GFX10: encoding: [0x00,0x00,0xd5,0xd4,0x01,0xcb,0x00,0x00]

v_cmpx_ne_u32_e64 v1, vcc_lo
// GFX10: encoding: [0x00,0x00,0xd5,0xd4,0x01,0xd5,0x00,0x00]

v_cmpx_ne_u32_e64 v1, vcc_hi
// GFX10: encoding: [0x00,0x00,0xd5,0xd4,0x01,0xd7,0x00,0x00]

v_cmpx_ne_u32_e64 v1, m0
// GFX10: encoding: [0x00,0x00,0xd5,0xd4,0x01,0xf9,0x00,0x00]

v_cmpx_ne_u32_e64 v1, exec_lo
// GFX10: encoding: [0x00,0x00,0xd5,0xd4,0x01,0xfd,0x00,0x00]

v_cmpx_ne_u32_e64 v1, exec_hi
// GFX10: encoding: [0x00,0x00,0xd5,0xd4,0x01,0xff,0x00,0x00]

v_cmpx_ne_u32_e64 v1, 0
// GFX10: encoding: [0x00,0x00,0xd5,0xd4,0x01,0x01,0x01,0x00]

v_cmpx_ne_u32_e64 v1, -1
// GFX10: encoding: [0x00,0x00,0xd5,0xd4,0x01,0x83,0x01,0x00]

v_cmpx_ne_u32_e64 v1, 0.5
// GFX10: encoding: [0x00,0x00,0xd5,0xd4,0x01,0xe1,0x01,0x00]

v_cmpx_ne_u32_e64 v1, -4.0
// GFX10: encoding: [0x00,0x00,0xd5,0xd4,0x01,0xef,0x01,0x00]

v_cmpx_ge_u32 v1, v2
// GFX10: encoding: [0x01,0x05,0xac,0x7d]

v_cmpx_ge_u32 v255, v2
// GFX10: encoding: [0xff,0x05,0xac,0x7d]

v_cmpx_ge_u32 s1, v2
// GFX10: encoding: [0x01,0x04,0xac,0x7d]

v_cmpx_ge_u32 s101, v2
// GFX10: encoding: [0x65,0x04,0xac,0x7d]

v_cmpx_ge_u32 vcc_lo, v2
// GFX10: encoding: [0x6a,0x04,0xac,0x7d]

v_cmpx_ge_u32 vcc_hi, v2
// GFX10: encoding: [0x6b,0x04,0xac,0x7d]

v_cmpx_ge_u32 m0, v2
// GFX10: encoding: [0x7c,0x04,0xac,0x7d]

v_cmpx_ge_u32 exec_lo, v2
// GFX10: encoding: [0x7e,0x04,0xac,0x7d]

v_cmpx_ge_u32 exec_hi, v2
// GFX10: encoding: [0x7f,0x04,0xac,0x7d]

v_cmpx_ge_u32 0, v2
// GFX10: encoding: [0x80,0x04,0xac,0x7d]

v_cmpx_ge_u32 -1, v2
// GFX10: encoding: [0xc1,0x04,0xac,0x7d]

v_cmpx_ge_u32 0.5, v2
// GFX10: encoding: [0xf0,0x04,0xac,0x7d]

v_cmpx_ge_u32 -4.0, v2
// GFX10: encoding: [0xf7,0x04,0xac,0x7d]

v_cmpx_ge_u32 0xaf123456, v2
// GFX10: encoding: [0xff,0x04,0xac,0x7d,0x56,0x34,0x12,0xaf]

v_cmpx_ge_u32 0x3f717273, v2
// GFX10: encoding: [0xff,0x04,0xac,0x7d,0x73,0x72,0x71,0x3f]

v_cmpx_ge_u32 v1, v255
// GFX10: encoding: [0x01,0xff,0xad,0x7d]

v_cmpx_ge_u32_e64 v1, v2
// GFX10: encoding: [0x00,0x00,0xd6,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_ge_u32_e64 v255, v2
// GFX10: encoding: [0x00,0x00,0xd6,0xd4,0xff,0x05,0x02,0x00]

v_cmpx_ge_u32_e64 s1, v2
// GFX10: encoding: [0x00,0x00,0xd6,0xd4,0x01,0x04,0x02,0x00]

v_cmpx_ge_u32_e64 s101, v2
// GFX10: encoding: [0x00,0x00,0xd6,0xd4,0x65,0x04,0x02,0x00]

v_cmpx_ge_u32_e64 vcc_lo, v2
// GFX10: encoding: [0x00,0x00,0xd6,0xd4,0x6a,0x04,0x02,0x00]

v_cmpx_ge_u32_e64 vcc_hi, v2
// GFX10: encoding: [0x00,0x00,0xd6,0xd4,0x6b,0x04,0x02,0x00]

v_cmpx_ge_u32_e64 m0, v2
// GFX10: encoding: [0x00,0x00,0xd6,0xd4,0x7c,0x04,0x02,0x00]

v_cmpx_ge_u32_e64 exec_lo, v2
// GFX10: encoding: [0x00,0x00,0xd6,0xd4,0x7e,0x04,0x02,0x00]

v_cmpx_ge_u32_e64 exec_hi, v2
// GFX10: encoding: [0x00,0x00,0xd6,0xd4,0x7f,0x04,0x02,0x00]

v_cmpx_ge_u32_e64 0, v2
// GFX10: encoding: [0x00,0x00,0xd6,0xd4,0x80,0x04,0x02,0x00]

v_cmpx_ge_u32_e64 -1, v2
// GFX10: encoding: [0x00,0x00,0xd6,0xd4,0xc1,0x04,0x02,0x00]

v_cmpx_ge_u32_e64 0.5, v2
// GFX10: encoding: [0x00,0x00,0xd6,0xd4,0xf0,0x04,0x02,0x00]

v_cmpx_ge_u32_e64 -4.0, v2
// GFX10: encoding: [0x00,0x00,0xd6,0xd4,0xf7,0x04,0x02,0x00]

v_cmpx_ge_u32_e64 v1, v255
// GFX10: encoding: [0x00,0x00,0xd6,0xd4,0x01,0xff,0x03,0x00]

v_cmpx_ge_u32_e64 v1, s2
// GFX10: encoding: [0x00,0x00,0xd6,0xd4,0x01,0x05,0x00,0x00]

v_cmpx_ge_u32_e64 v1, s101
// GFX10: encoding: [0x00,0x00,0xd6,0xd4,0x01,0xcb,0x00,0x00]

v_cmpx_ge_u32_e64 v1, vcc_lo
// GFX10: encoding: [0x00,0x00,0xd6,0xd4,0x01,0xd5,0x00,0x00]

v_cmpx_ge_u32_e64 v1, vcc_hi
// GFX10: encoding: [0x00,0x00,0xd6,0xd4,0x01,0xd7,0x00,0x00]

v_cmpx_ge_u32_e64 v1, m0
// GFX10: encoding: [0x00,0x00,0xd6,0xd4,0x01,0xf9,0x00,0x00]

v_cmpx_ge_u32_e64 v1, exec_lo
// GFX10: encoding: [0x00,0x00,0xd6,0xd4,0x01,0xfd,0x00,0x00]

v_cmpx_ge_u32_e64 v1, exec_hi
// GFX10: encoding: [0x00,0x00,0xd6,0xd4,0x01,0xff,0x00,0x00]

v_cmpx_ge_u32_e64 v1, 0
// GFX10: encoding: [0x00,0x00,0xd6,0xd4,0x01,0x01,0x01,0x00]

v_cmpx_ge_u32_e64 v1, -1
// GFX10: encoding: [0x00,0x00,0xd6,0xd4,0x01,0x83,0x01,0x00]

v_cmpx_ge_u32_e64 v1, 0.5
// GFX10: encoding: [0x00,0x00,0xd6,0xd4,0x01,0xe1,0x01,0x00]

v_cmpx_ge_u32_e64 v1, -4.0
// GFX10: encoding: [0x00,0x00,0xd6,0xd4,0x01,0xef,0x01,0x00]

v_cmpx_t_u32 v1, v2
// GFX10: encoding: [0x01,0x05,0xae,0x7d]

v_cmpx_t_u32 v255, v2
// GFX10: encoding: [0xff,0x05,0xae,0x7d]

v_cmpx_t_u32 s1, v2
// GFX10: encoding: [0x01,0x04,0xae,0x7d]

v_cmpx_t_u32 s101, v2
// GFX10: encoding: [0x65,0x04,0xae,0x7d]

v_cmpx_t_u32 vcc_lo, v2
// GFX10: encoding: [0x6a,0x04,0xae,0x7d]

v_cmpx_t_u32 vcc_hi, v2
// GFX10: encoding: [0x6b,0x04,0xae,0x7d]

v_cmpx_t_u32 m0, v2
// GFX10: encoding: [0x7c,0x04,0xae,0x7d]

v_cmpx_t_u32 exec_lo, v2
// GFX10: encoding: [0x7e,0x04,0xae,0x7d]

v_cmpx_t_u32 exec_hi, v2
// GFX10: encoding: [0x7f,0x04,0xae,0x7d]

v_cmpx_t_u32 0, v2
// GFX10: encoding: [0x80,0x04,0xae,0x7d]

v_cmpx_t_u32 -1, v2
// GFX10: encoding: [0xc1,0x04,0xae,0x7d]

v_cmpx_t_u32 0.5, v2
// GFX10: encoding: [0xf0,0x04,0xae,0x7d]

v_cmpx_t_u32 -4.0, v2
// GFX10: encoding: [0xf7,0x04,0xae,0x7d]

v_cmpx_t_u32 0xaf123456, v2
// GFX10: encoding: [0xff,0x04,0xae,0x7d,0x56,0x34,0x12,0xaf]

v_cmpx_t_u32 0x3f717273, v2
// GFX10: encoding: [0xff,0x04,0xae,0x7d,0x73,0x72,0x71,0x3f]

v_cmpx_t_u32 v1, v255
// GFX10: encoding: [0x01,0xff,0xaf,0x7d]

v_cmpx_t_u32_e64 v1, v2
// GFX10: encoding: [0x00,0x00,0xd7,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_t_u32_e64 v255, v2
// GFX10: encoding: [0x00,0x00,0xd7,0xd4,0xff,0x05,0x02,0x00]

v_cmpx_t_u32_e64 s1, v2
// GFX10: encoding: [0x00,0x00,0xd7,0xd4,0x01,0x04,0x02,0x00]

v_cmpx_t_u32_e64 s101, v2
// GFX10: encoding: [0x00,0x00,0xd7,0xd4,0x65,0x04,0x02,0x00]

v_cmpx_t_u32_e64 vcc_lo, v2
// GFX10: encoding: [0x00,0x00,0xd7,0xd4,0x6a,0x04,0x02,0x00]

v_cmpx_t_u32_e64 vcc_hi, v2
// GFX10: encoding: [0x00,0x00,0xd7,0xd4,0x6b,0x04,0x02,0x00]

v_cmpx_t_u32_e64 m0, v2
// GFX10: encoding: [0x00,0x00,0xd7,0xd4,0x7c,0x04,0x02,0x00]

v_cmpx_t_u32_e64 exec_lo, v2
// GFX10: encoding: [0x00,0x00,0xd7,0xd4,0x7e,0x04,0x02,0x00]

v_cmpx_t_u32_e64 exec_hi, v2
// GFX10: encoding: [0x00,0x00,0xd7,0xd4,0x7f,0x04,0x02,0x00]

v_cmpx_t_u32_e64 0, v2
// GFX10: encoding: [0x00,0x00,0xd7,0xd4,0x80,0x04,0x02,0x00]

v_cmpx_t_u32_e64 -1, v2
// GFX10: encoding: [0x00,0x00,0xd7,0xd4,0xc1,0x04,0x02,0x00]

v_cmpx_t_u32_e64 0.5, v2
// GFX10: encoding: [0x00,0x00,0xd7,0xd4,0xf0,0x04,0x02,0x00]

v_cmpx_t_u32_e64 -4.0, v2
// GFX10: encoding: [0x00,0x00,0xd7,0xd4,0xf7,0x04,0x02,0x00]

v_cmpx_t_u32_e64 v1, v255
// GFX10: encoding: [0x00,0x00,0xd7,0xd4,0x01,0xff,0x03,0x00]

v_cmpx_t_u32_e64 v1, s2
// GFX10: encoding: [0x00,0x00,0xd7,0xd4,0x01,0x05,0x00,0x00]

v_cmpx_t_u32_e64 v1, s101
// GFX10: encoding: [0x00,0x00,0xd7,0xd4,0x01,0xcb,0x00,0x00]

v_cmpx_t_u32_e64 v1, vcc_lo
// GFX10: encoding: [0x00,0x00,0xd7,0xd4,0x01,0xd5,0x00,0x00]

v_cmpx_t_u32_e64 v1, vcc_hi
// GFX10: encoding: [0x00,0x00,0xd7,0xd4,0x01,0xd7,0x00,0x00]

v_cmpx_t_u32_e64 v1, m0
// GFX10: encoding: [0x00,0x00,0xd7,0xd4,0x01,0xf9,0x00,0x00]

v_cmpx_t_u32_e64 v1, exec_lo
// GFX10: encoding: [0x00,0x00,0xd7,0xd4,0x01,0xfd,0x00,0x00]

v_cmpx_t_u32_e64 v1, exec_hi
// GFX10: encoding: [0x00,0x00,0xd7,0xd4,0x01,0xff,0x00,0x00]

v_cmpx_t_u32_e64 v1, 0
// GFX10: encoding: [0x00,0x00,0xd7,0xd4,0x01,0x01,0x01,0x00]

v_cmpx_t_u32_e64 v1, -1
// GFX10: encoding: [0x00,0x00,0xd7,0xd4,0x01,0x83,0x01,0x00]

v_cmpx_t_u32_e64 v1, 0.5
// GFX10: encoding: [0x00,0x00,0xd7,0xd4,0x01,0xe1,0x01,0x00]

v_cmpx_t_u32_e64 v1, -4.0
// GFX10: encoding: [0x00,0x00,0xd7,0xd4,0x01,0xef,0x01,0x00]

v_cmpx_f_f16 v1, v2
// GFX10: encoding: [0x01,0x05,0xb0,0x7d]

v_cmpx_f_f16 v255, v2
// GFX10: encoding: [0xff,0x05,0xb0,0x7d]

v_cmpx_f_f16 s1, v2
// GFX10: encoding: [0x01,0x04,0xb0,0x7d]

v_cmpx_f_f16 s101, v2
// GFX10: encoding: [0x65,0x04,0xb0,0x7d]

v_cmpx_f_f16 vcc_lo, v2
// GFX10: encoding: [0x6a,0x04,0xb0,0x7d]

v_cmpx_f_f16 vcc_hi, v2
// GFX10: encoding: [0x6b,0x04,0xb0,0x7d]

v_cmpx_f_f16 m0, v2
// GFX10: encoding: [0x7c,0x04,0xb0,0x7d]

v_cmpx_f_f16 exec_lo, v2
// GFX10: encoding: [0x7e,0x04,0xb0,0x7d]

v_cmpx_f_f16 exec_hi, v2
// GFX10: encoding: [0x7f,0x04,0xb0,0x7d]

v_cmpx_f_f16 0, v2
// GFX10: encoding: [0x80,0x04,0xb0,0x7d]

v_cmpx_f_f16 -1, v2
// GFX10: encoding: [0xc1,0x04,0xb0,0x7d]

v_cmpx_f_f16 0.5, v2
// GFX10: encoding: [0xf0,0x04,0xb0,0x7d]

v_cmpx_f_f16 -4.0, v2
// GFX10: encoding: [0xf7,0x04,0xb0,0x7d]

v_cmpx_f_f16 0xfe0b, v2
// GFX10: encoding: [0xff,0x04,0xb0,0x7d,0x0b,0xfe,0x00,0x00]

v_cmpx_f_f16 0x3456, v2
// GFX10: encoding: [0xff,0x04,0xb0,0x7d,0x56,0x34,0x00,0x00]

v_cmpx_f_f16 v1, v255
// GFX10: encoding: [0x01,0xff,0xb1,0x7d]

v_cmpx_f_f16_e64 v1, v2
// GFX10: encoding: [0x00,0x00,0xd8,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_f_f16_e64 v255, v2
// GFX10: encoding: [0x00,0x00,0xd8,0xd4,0xff,0x05,0x02,0x00]

v_cmpx_f_f16_e64 s1, v2
// GFX10: encoding: [0x00,0x00,0xd8,0xd4,0x01,0x04,0x02,0x00]

v_cmpx_f_f16_e64 s101, v2
// GFX10: encoding: [0x00,0x00,0xd8,0xd4,0x65,0x04,0x02,0x00]

v_cmpx_f_f16_e64 vcc_lo, v2
// GFX10: encoding: [0x00,0x00,0xd8,0xd4,0x6a,0x04,0x02,0x00]

v_cmpx_f_f16_e64 vcc_hi, v2
// GFX10: encoding: [0x00,0x00,0xd8,0xd4,0x6b,0x04,0x02,0x00]

v_cmpx_f_f16_e64 m0, v2
// GFX10: encoding: [0x00,0x00,0xd8,0xd4,0x7c,0x04,0x02,0x00]

v_cmpx_f_f16_e64 exec_lo, v2
// GFX10: encoding: [0x00,0x00,0xd8,0xd4,0x7e,0x04,0x02,0x00]

v_cmpx_f_f16_e64 exec_hi, v2
// GFX10: encoding: [0x00,0x00,0xd8,0xd4,0x7f,0x04,0x02,0x00]

v_cmpx_f_f16_e64 0, v2
// GFX10: encoding: [0x00,0x00,0xd8,0xd4,0x80,0x04,0x02,0x00]

v_cmpx_f_f16_e64 -1, v2
// GFX10: encoding: [0x00,0x00,0xd8,0xd4,0xc1,0x04,0x02,0x00]

v_cmpx_f_f16_e64 0.5, v2
// GFX10: encoding: [0x00,0x00,0xd8,0xd4,0xf0,0x04,0x02,0x00]

v_cmpx_f_f16_e64 -4.0, v2
// GFX10: encoding: [0x00,0x00,0xd8,0xd4,0xf7,0x04,0x02,0x00]

v_cmpx_f_f16_e64 v1, v255
// GFX10: encoding: [0x00,0x00,0xd8,0xd4,0x01,0xff,0x03,0x00]

v_cmpx_f_f16_e64 v1, s2
// GFX10: encoding: [0x00,0x00,0xd8,0xd4,0x01,0x05,0x00,0x00]

v_cmpx_f_f16_e64 v1, s101
// GFX10: encoding: [0x00,0x00,0xd8,0xd4,0x01,0xcb,0x00,0x00]

v_cmpx_f_f16_e64 v1, vcc_lo
// GFX10: encoding: [0x00,0x00,0xd8,0xd4,0x01,0xd5,0x00,0x00]

v_cmpx_f_f16_e64 v1, vcc_hi
// GFX10: encoding: [0x00,0x00,0xd8,0xd4,0x01,0xd7,0x00,0x00]

v_cmpx_f_f16_e64 v1, m0
// GFX10: encoding: [0x00,0x00,0xd8,0xd4,0x01,0xf9,0x00,0x00]

v_cmpx_f_f16_e64 v1, exec_lo
// GFX10: encoding: [0x00,0x00,0xd8,0xd4,0x01,0xfd,0x00,0x00]

v_cmpx_f_f16_e64 v1, exec_hi
// GFX10: encoding: [0x00,0x00,0xd8,0xd4,0x01,0xff,0x00,0x00]

v_cmpx_f_f16_e64 v1, 0
// GFX10: encoding: [0x00,0x00,0xd8,0xd4,0x01,0x01,0x01,0x00]

v_cmpx_f_f16_e64 v1, -1
// GFX10: encoding: [0x00,0x00,0xd8,0xd4,0x01,0x83,0x01,0x00]

v_cmpx_f_f16_e64 v1, 0.5
// GFX10: encoding: [0x00,0x00,0xd8,0xd4,0x01,0xe1,0x01,0x00]

v_cmpx_f_f16_e64 v1, -4.0
// GFX10: encoding: [0x00,0x00,0xd8,0xd4,0x01,0xef,0x01,0x00]

v_cmpx_f_f16_e64 -v1, v2
// GFX10: encoding: [0x00,0x00,0xd8,0xd4,0x01,0x05,0x02,0x20]

v_cmpx_f_f16_e64 v1, -v2
// GFX10: encoding: [0x00,0x00,0xd8,0xd4,0x01,0x05,0x02,0x40]

v_cmpx_f_f16_e64 -v1, -v2
// GFX10: encoding: [0x00,0x00,0xd8,0xd4,0x01,0x05,0x02,0x60]

v_cmpx_lt_f16 v1, v2
// GFX10: encoding: [0x01,0x05,0xb2,0x7d]

v_cmpx_lt_f16 v255, v2
// GFX10: encoding: [0xff,0x05,0xb2,0x7d]

v_cmpx_lt_f16 s1, v2
// GFX10: encoding: [0x01,0x04,0xb2,0x7d]

v_cmpx_lt_f16 s101, v2
// GFX10: encoding: [0x65,0x04,0xb2,0x7d]

v_cmpx_lt_f16 vcc_lo, v2
// GFX10: encoding: [0x6a,0x04,0xb2,0x7d]

v_cmpx_lt_f16 vcc_hi, v2
// GFX10: encoding: [0x6b,0x04,0xb2,0x7d]

v_cmpx_lt_f16 m0, v2
// GFX10: encoding: [0x7c,0x04,0xb2,0x7d]

v_cmpx_lt_f16 exec_lo, v2
// GFX10: encoding: [0x7e,0x04,0xb2,0x7d]

v_cmpx_lt_f16 exec_hi, v2
// GFX10: encoding: [0x7f,0x04,0xb2,0x7d]

v_cmpx_lt_f16 0, v2
// GFX10: encoding: [0x80,0x04,0xb2,0x7d]

v_cmpx_lt_f16 -1, v2
// GFX10: encoding: [0xc1,0x04,0xb2,0x7d]

v_cmpx_lt_f16 0.5, v2
// GFX10: encoding: [0xf0,0x04,0xb2,0x7d]

v_cmpx_lt_f16 -4.0, v2
// GFX10: encoding: [0xf7,0x04,0xb2,0x7d]

v_cmpx_lt_f16 0xfe0b, v2
// GFX10: encoding: [0xff,0x04,0xb2,0x7d,0x0b,0xfe,0x00,0x00]

v_cmpx_lt_f16 0x3456, v2
// GFX10: encoding: [0xff,0x04,0xb2,0x7d,0x56,0x34,0x00,0x00]

v_cmpx_lt_f16 v1, v255
// GFX10: encoding: [0x01,0xff,0xb3,0x7d]

v_cmpx_lt_f16_e64 v1, v2
// GFX10: encoding: [0x00,0x00,0xd9,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_lt_f16_e64 v255, v2
// GFX10: encoding: [0x00,0x00,0xd9,0xd4,0xff,0x05,0x02,0x00]

v_cmpx_lt_f16_e64 s1, v2
// GFX10: encoding: [0x00,0x00,0xd9,0xd4,0x01,0x04,0x02,0x00]

v_cmpx_lt_f16_e64 s101, v2
// GFX10: encoding: [0x00,0x00,0xd9,0xd4,0x65,0x04,0x02,0x00]

v_cmpx_lt_f16_e64 vcc_lo, v2
// GFX10: encoding: [0x00,0x00,0xd9,0xd4,0x6a,0x04,0x02,0x00]

v_cmpx_lt_f16_e64 vcc_hi, v2
// GFX10: encoding: [0x00,0x00,0xd9,0xd4,0x6b,0x04,0x02,0x00]

v_cmpx_lt_f16_e64 m0, v2
// GFX10: encoding: [0x00,0x00,0xd9,0xd4,0x7c,0x04,0x02,0x00]

v_cmpx_lt_f16_e64 exec_lo, v2
// GFX10: encoding: [0x00,0x00,0xd9,0xd4,0x7e,0x04,0x02,0x00]

v_cmpx_lt_f16_e64 exec_hi, v2
// GFX10: encoding: [0x00,0x00,0xd9,0xd4,0x7f,0x04,0x02,0x00]

v_cmpx_lt_f16_e64 0, v2
// GFX10: encoding: [0x00,0x00,0xd9,0xd4,0x80,0x04,0x02,0x00]

v_cmpx_lt_f16_e64 -1, v2
// GFX10: encoding: [0x00,0x00,0xd9,0xd4,0xc1,0x04,0x02,0x00]

v_cmpx_lt_f16_e64 0.5, v2
// GFX10: encoding: [0x00,0x00,0xd9,0xd4,0xf0,0x04,0x02,0x00]

v_cmpx_lt_f16_e64 -4.0, v2
// GFX10: encoding: [0x00,0x00,0xd9,0xd4,0xf7,0x04,0x02,0x00]

v_cmpx_lt_f16_e64 v1, v255
// GFX10: encoding: [0x00,0x00,0xd9,0xd4,0x01,0xff,0x03,0x00]

v_cmpx_lt_f16_e64 v1, s2
// GFX10: encoding: [0x00,0x00,0xd9,0xd4,0x01,0x05,0x00,0x00]

v_cmpx_lt_f16_e64 v1, s101
// GFX10: encoding: [0x00,0x00,0xd9,0xd4,0x01,0xcb,0x00,0x00]

v_cmpx_lt_f16_e64 v1, vcc_lo
// GFX10: encoding: [0x00,0x00,0xd9,0xd4,0x01,0xd5,0x00,0x00]

v_cmpx_lt_f16_e64 v1, vcc_hi
// GFX10: encoding: [0x00,0x00,0xd9,0xd4,0x01,0xd7,0x00,0x00]

v_cmpx_lt_f16_e64 v1, m0
// GFX10: encoding: [0x00,0x00,0xd9,0xd4,0x01,0xf9,0x00,0x00]

v_cmpx_lt_f16_e64 v1, exec_lo
// GFX10: encoding: [0x00,0x00,0xd9,0xd4,0x01,0xfd,0x00,0x00]

v_cmpx_lt_f16_e64 v1, exec_hi
// GFX10: encoding: [0x00,0x00,0xd9,0xd4,0x01,0xff,0x00,0x00]

v_cmpx_lt_f16_e64 v1, 0
// GFX10: encoding: [0x00,0x00,0xd9,0xd4,0x01,0x01,0x01,0x00]

v_cmpx_lt_f16_e64 v1, -1
// GFX10: encoding: [0x00,0x00,0xd9,0xd4,0x01,0x83,0x01,0x00]

v_cmpx_lt_f16_e64 v1, 0.5
// GFX10: encoding: [0x00,0x00,0xd9,0xd4,0x01,0xe1,0x01,0x00]

v_cmpx_lt_f16_e64 v1, -4.0
// GFX10: encoding: [0x00,0x00,0xd9,0xd4,0x01,0xef,0x01,0x00]

v_cmpx_lt_f16_e64 -v1, v2
// GFX10: encoding: [0x00,0x00,0xd9,0xd4,0x01,0x05,0x02,0x20]

v_cmpx_lt_f16_e64 v1, -v2
// GFX10: encoding: [0x00,0x00,0xd9,0xd4,0x01,0x05,0x02,0x40]

v_cmpx_lt_f16_e64 -v1, -v2
// GFX10: encoding: [0x00,0x00,0xd9,0xd4,0x01,0x05,0x02,0x60]

v_cmpx_eq_f16 v1, v2
// GFX10: encoding: [0x01,0x05,0xb4,0x7d]

v_cmpx_eq_f16 v255, v2
// GFX10: encoding: [0xff,0x05,0xb4,0x7d]

v_cmpx_eq_f16 s1, v2
// GFX10: encoding: [0x01,0x04,0xb4,0x7d]

v_cmpx_eq_f16 s101, v2
// GFX10: encoding: [0x65,0x04,0xb4,0x7d]

v_cmpx_eq_f16 vcc_lo, v2
// GFX10: encoding: [0x6a,0x04,0xb4,0x7d]

v_cmpx_eq_f16 vcc_hi, v2
// GFX10: encoding: [0x6b,0x04,0xb4,0x7d]

v_cmpx_eq_f16 m0, v2
// GFX10: encoding: [0x7c,0x04,0xb4,0x7d]

v_cmpx_eq_f16 exec_lo, v2
// GFX10: encoding: [0x7e,0x04,0xb4,0x7d]

v_cmpx_eq_f16 exec_hi, v2
// GFX10: encoding: [0x7f,0x04,0xb4,0x7d]

v_cmpx_eq_f16 0, v2
// GFX10: encoding: [0x80,0x04,0xb4,0x7d]

v_cmpx_eq_f16 -1, v2
// GFX10: encoding: [0xc1,0x04,0xb4,0x7d]

v_cmpx_eq_f16 0.5, v2
// GFX10: encoding: [0xf0,0x04,0xb4,0x7d]

v_cmpx_eq_f16 -4.0, v2
// GFX10: encoding: [0xf7,0x04,0xb4,0x7d]

v_cmpx_eq_f16 0xfe0b, v2
// GFX10: encoding: [0xff,0x04,0xb4,0x7d,0x0b,0xfe,0x00,0x00]

v_cmpx_eq_f16 0x3456, v2
// GFX10: encoding: [0xff,0x04,0xb4,0x7d,0x56,0x34,0x00,0x00]

v_cmpx_eq_f16 v1, v255
// GFX10: encoding: [0x01,0xff,0xb5,0x7d]

v_cmpx_eq_f16_e64 v1, v2
// GFX10: encoding: [0x00,0x00,0xda,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_eq_f16_e64 v255, v2
// GFX10: encoding: [0x00,0x00,0xda,0xd4,0xff,0x05,0x02,0x00]

v_cmpx_eq_f16_e64 s1, v2
// GFX10: encoding: [0x00,0x00,0xda,0xd4,0x01,0x04,0x02,0x00]

v_cmpx_eq_f16_e64 s101, v2
// GFX10: encoding: [0x00,0x00,0xda,0xd4,0x65,0x04,0x02,0x00]

v_cmpx_eq_f16_e64 vcc_lo, v2
// GFX10: encoding: [0x00,0x00,0xda,0xd4,0x6a,0x04,0x02,0x00]

v_cmpx_eq_f16_e64 vcc_hi, v2
// GFX10: encoding: [0x00,0x00,0xda,0xd4,0x6b,0x04,0x02,0x00]

v_cmpx_eq_f16_e64 m0, v2
// GFX10: encoding: [0x00,0x00,0xda,0xd4,0x7c,0x04,0x02,0x00]

v_cmpx_eq_f16_e64 exec_lo, v2
// GFX10: encoding: [0x00,0x00,0xda,0xd4,0x7e,0x04,0x02,0x00]

v_cmpx_eq_f16_e64 exec_hi, v2
// GFX10: encoding: [0x00,0x00,0xda,0xd4,0x7f,0x04,0x02,0x00]

v_cmpx_eq_f16_e64 0, v2
// GFX10: encoding: [0x00,0x00,0xda,0xd4,0x80,0x04,0x02,0x00]

v_cmpx_eq_f16_e64 -1, v2
// GFX10: encoding: [0x00,0x00,0xda,0xd4,0xc1,0x04,0x02,0x00]

v_cmpx_eq_f16_e64 0.5, v2
// GFX10: encoding: [0x00,0x00,0xda,0xd4,0xf0,0x04,0x02,0x00]

v_cmpx_eq_f16_e64 -4.0, v2
// GFX10: encoding: [0x00,0x00,0xda,0xd4,0xf7,0x04,0x02,0x00]

v_cmpx_eq_f16_e64 v1, v255
// GFX10: encoding: [0x00,0x00,0xda,0xd4,0x01,0xff,0x03,0x00]

v_cmpx_eq_f16_e64 v1, s2
// GFX10: encoding: [0x00,0x00,0xda,0xd4,0x01,0x05,0x00,0x00]

v_cmpx_eq_f16_e64 v1, s101
// GFX10: encoding: [0x00,0x00,0xda,0xd4,0x01,0xcb,0x00,0x00]

v_cmpx_eq_f16_e64 v1, vcc_lo
// GFX10: encoding: [0x00,0x00,0xda,0xd4,0x01,0xd5,0x00,0x00]

v_cmpx_eq_f16_e64 v1, vcc_hi
// GFX10: encoding: [0x00,0x00,0xda,0xd4,0x01,0xd7,0x00,0x00]

v_cmpx_eq_f16_e64 v1, m0
// GFX10: encoding: [0x00,0x00,0xda,0xd4,0x01,0xf9,0x00,0x00]

v_cmpx_eq_f16_e64 v1, exec_lo
// GFX10: encoding: [0x00,0x00,0xda,0xd4,0x01,0xfd,0x00,0x00]

v_cmpx_eq_f16_e64 v1, exec_hi
// GFX10: encoding: [0x00,0x00,0xda,0xd4,0x01,0xff,0x00,0x00]

v_cmpx_eq_f16_e64 v1, 0
// GFX10: encoding: [0x00,0x00,0xda,0xd4,0x01,0x01,0x01,0x00]

v_cmpx_eq_f16_e64 v1, -1
// GFX10: encoding: [0x00,0x00,0xda,0xd4,0x01,0x83,0x01,0x00]

v_cmpx_eq_f16_e64 v1, 0.5
// GFX10: encoding: [0x00,0x00,0xda,0xd4,0x01,0xe1,0x01,0x00]

v_cmpx_eq_f16_e64 v1, -4.0
// GFX10: encoding: [0x00,0x00,0xda,0xd4,0x01,0xef,0x01,0x00]

v_cmpx_eq_f16_e64 -v1, v2
// GFX10: encoding: [0x00,0x00,0xda,0xd4,0x01,0x05,0x02,0x20]

v_cmpx_eq_f16_e64 v1, -v2
// GFX10: encoding: [0x00,0x00,0xda,0xd4,0x01,0x05,0x02,0x40]

v_cmpx_eq_f16_e64 -v1, -v2
// GFX10: encoding: [0x00,0x00,0xda,0xd4,0x01,0x05,0x02,0x60]

v_cmpx_le_f16 v1, v2
// GFX10: encoding: [0x01,0x05,0xb6,0x7d]

v_cmpx_le_f16 v255, v2
// GFX10: encoding: [0xff,0x05,0xb6,0x7d]

v_cmpx_le_f16 s1, v2
// GFX10: encoding: [0x01,0x04,0xb6,0x7d]

v_cmpx_le_f16 s101, v2
// GFX10: encoding: [0x65,0x04,0xb6,0x7d]

v_cmpx_le_f16 vcc_lo, v2
// GFX10: encoding: [0x6a,0x04,0xb6,0x7d]

v_cmpx_le_f16 vcc_hi, v2
// GFX10: encoding: [0x6b,0x04,0xb6,0x7d]

v_cmpx_le_f16 m0, v2
// GFX10: encoding: [0x7c,0x04,0xb6,0x7d]

v_cmpx_le_f16 exec_lo, v2
// GFX10: encoding: [0x7e,0x04,0xb6,0x7d]

v_cmpx_le_f16 exec_hi, v2
// GFX10: encoding: [0x7f,0x04,0xb6,0x7d]

v_cmpx_le_f16 0, v2
// GFX10: encoding: [0x80,0x04,0xb6,0x7d]

v_cmpx_le_f16 -1, v2
// GFX10: encoding: [0xc1,0x04,0xb6,0x7d]

v_cmpx_le_f16 0.5, v2
// GFX10: encoding: [0xf0,0x04,0xb6,0x7d]

v_cmpx_le_f16 -4.0, v2
// GFX10: encoding: [0xf7,0x04,0xb6,0x7d]

v_cmpx_le_f16 0xfe0b, v2
// GFX10: encoding: [0xff,0x04,0xb6,0x7d,0x0b,0xfe,0x00,0x00]

v_cmpx_le_f16 0x3456, v2
// GFX10: encoding: [0xff,0x04,0xb6,0x7d,0x56,0x34,0x00,0x00]

v_cmpx_le_f16 v1, v255
// GFX10: encoding: [0x01,0xff,0xb7,0x7d]

v_cmpx_le_f16_e64 v1, v2
// GFX10: encoding: [0x00,0x00,0xdb,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_le_f16_e64 v255, v2
// GFX10: encoding: [0x00,0x00,0xdb,0xd4,0xff,0x05,0x02,0x00]

v_cmpx_le_f16_e64 s1, v2
// GFX10: encoding: [0x00,0x00,0xdb,0xd4,0x01,0x04,0x02,0x00]

v_cmpx_le_f16_e64 s101, v2
// GFX10: encoding: [0x00,0x00,0xdb,0xd4,0x65,0x04,0x02,0x00]

v_cmpx_le_f16_e64 vcc_lo, v2
// GFX10: encoding: [0x00,0x00,0xdb,0xd4,0x6a,0x04,0x02,0x00]

v_cmpx_le_f16_e64 vcc_hi, v2
// GFX10: encoding: [0x00,0x00,0xdb,0xd4,0x6b,0x04,0x02,0x00]

v_cmpx_le_f16_e64 m0, v2
// GFX10: encoding: [0x00,0x00,0xdb,0xd4,0x7c,0x04,0x02,0x00]

v_cmpx_le_f16_e64 exec_lo, v2
// GFX10: encoding: [0x00,0x00,0xdb,0xd4,0x7e,0x04,0x02,0x00]

v_cmpx_le_f16_e64 exec_hi, v2
// GFX10: encoding: [0x00,0x00,0xdb,0xd4,0x7f,0x04,0x02,0x00]

v_cmpx_le_f16_e64 0, v2
// GFX10: encoding: [0x00,0x00,0xdb,0xd4,0x80,0x04,0x02,0x00]

v_cmpx_le_f16_e64 -1, v2
// GFX10: encoding: [0x00,0x00,0xdb,0xd4,0xc1,0x04,0x02,0x00]

v_cmpx_le_f16_e64 0.5, v2
// GFX10: encoding: [0x00,0x00,0xdb,0xd4,0xf0,0x04,0x02,0x00]

v_cmpx_le_f16_e64 -4.0, v2
// GFX10: encoding: [0x00,0x00,0xdb,0xd4,0xf7,0x04,0x02,0x00]

v_cmpx_le_f16_e64 v1, v255
// GFX10: encoding: [0x00,0x00,0xdb,0xd4,0x01,0xff,0x03,0x00]

v_cmpx_le_f16_e64 v1, s2
// GFX10: encoding: [0x00,0x00,0xdb,0xd4,0x01,0x05,0x00,0x00]

v_cmpx_le_f16_e64 v1, s101
// GFX10: encoding: [0x00,0x00,0xdb,0xd4,0x01,0xcb,0x00,0x00]

v_cmpx_le_f16_e64 v1, vcc_lo
// GFX10: encoding: [0x00,0x00,0xdb,0xd4,0x01,0xd5,0x00,0x00]

v_cmpx_le_f16_e64 v1, vcc_hi
// GFX10: encoding: [0x00,0x00,0xdb,0xd4,0x01,0xd7,0x00,0x00]

v_cmpx_le_f16_e64 v1, m0
// GFX10: encoding: [0x00,0x00,0xdb,0xd4,0x01,0xf9,0x00,0x00]

v_cmpx_le_f16_e64 v1, exec_lo
// GFX10: encoding: [0x00,0x00,0xdb,0xd4,0x01,0xfd,0x00,0x00]

v_cmpx_le_f16_e64 v1, exec_hi
// GFX10: encoding: [0x00,0x00,0xdb,0xd4,0x01,0xff,0x00,0x00]

v_cmpx_le_f16_e64 v1, 0
// GFX10: encoding: [0x00,0x00,0xdb,0xd4,0x01,0x01,0x01,0x00]

v_cmpx_le_f16_e64 v1, -1
// GFX10: encoding: [0x00,0x00,0xdb,0xd4,0x01,0x83,0x01,0x00]

v_cmpx_le_f16_e64 v1, 0.5
// GFX10: encoding: [0x00,0x00,0xdb,0xd4,0x01,0xe1,0x01,0x00]

v_cmpx_le_f16_e64 v1, -4.0
// GFX10: encoding: [0x00,0x00,0xdb,0xd4,0x01,0xef,0x01,0x00]

v_cmpx_le_f16_e64 -v1, v2
// GFX10: encoding: [0x00,0x00,0xdb,0xd4,0x01,0x05,0x02,0x20]

v_cmpx_le_f16_e64 v1, -v2
// GFX10: encoding: [0x00,0x00,0xdb,0xd4,0x01,0x05,0x02,0x40]

v_cmpx_le_f16_e64 -v1, -v2
// GFX10: encoding: [0x00,0x00,0xdb,0xd4,0x01,0x05,0x02,0x60]

v_cmpx_gt_f16 v1, v2
// GFX10: encoding: [0x01,0x05,0xb8,0x7d]

v_cmpx_gt_f16 v255, v2
// GFX10: encoding: [0xff,0x05,0xb8,0x7d]

v_cmpx_gt_f16 s1, v2
// GFX10: encoding: [0x01,0x04,0xb8,0x7d]

v_cmpx_gt_f16 s101, v2
// GFX10: encoding: [0x65,0x04,0xb8,0x7d]

v_cmpx_gt_f16 vcc_lo, v2
// GFX10: encoding: [0x6a,0x04,0xb8,0x7d]

v_cmpx_gt_f16 vcc_hi, v2
// GFX10: encoding: [0x6b,0x04,0xb8,0x7d]

v_cmpx_gt_f16 m0, v2
// GFX10: encoding: [0x7c,0x04,0xb8,0x7d]

v_cmpx_gt_f16 exec_lo, v2
// GFX10: encoding: [0x7e,0x04,0xb8,0x7d]

v_cmpx_gt_f16 exec_hi, v2
// GFX10: encoding: [0x7f,0x04,0xb8,0x7d]

v_cmpx_gt_f16 0, v2
// GFX10: encoding: [0x80,0x04,0xb8,0x7d]

v_cmpx_gt_f16 -1, v2
// GFX10: encoding: [0xc1,0x04,0xb8,0x7d]

v_cmpx_gt_f16 0.5, v2
// GFX10: encoding: [0xf0,0x04,0xb8,0x7d]

v_cmpx_gt_f16 -4.0, v2
// GFX10: encoding: [0xf7,0x04,0xb8,0x7d]

v_cmpx_gt_f16 0xfe0b, v2
// GFX10: encoding: [0xff,0x04,0xb8,0x7d,0x0b,0xfe,0x00,0x00]

v_cmpx_gt_f16 0x3456, v2
// GFX10: encoding: [0xff,0x04,0xb8,0x7d,0x56,0x34,0x00,0x00]

v_cmpx_gt_f16 v1, v255
// GFX10: encoding: [0x01,0xff,0xb9,0x7d]

v_cmpx_gt_f16_e64 v1, v2
// GFX10: encoding: [0x00,0x00,0xdc,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_gt_f16_e64 v255, v2
// GFX10: encoding: [0x00,0x00,0xdc,0xd4,0xff,0x05,0x02,0x00]

v_cmpx_gt_f16_e64 s1, v2
// GFX10: encoding: [0x00,0x00,0xdc,0xd4,0x01,0x04,0x02,0x00]

v_cmpx_gt_f16_e64 s101, v2
// GFX10: encoding: [0x00,0x00,0xdc,0xd4,0x65,0x04,0x02,0x00]

v_cmpx_gt_f16_e64 vcc_lo, v2
// GFX10: encoding: [0x00,0x00,0xdc,0xd4,0x6a,0x04,0x02,0x00]

v_cmpx_gt_f16_e64 vcc_hi, v2
// GFX10: encoding: [0x00,0x00,0xdc,0xd4,0x6b,0x04,0x02,0x00]

v_cmpx_gt_f16_e64 m0, v2
// GFX10: encoding: [0x00,0x00,0xdc,0xd4,0x7c,0x04,0x02,0x00]

v_cmpx_gt_f16_e64 exec_lo, v2
// GFX10: encoding: [0x00,0x00,0xdc,0xd4,0x7e,0x04,0x02,0x00]

v_cmpx_gt_f16_e64 exec_hi, v2
// GFX10: encoding: [0x00,0x00,0xdc,0xd4,0x7f,0x04,0x02,0x00]

v_cmpx_gt_f16_e64 0, v2
// GFX10: encoding: [0x00,0x00,0xdc,0xd4,0x80,0x04,0x02,0x00]

v_cmpx_gt_f16_e64 -1, v2
// GFX10: encoding: [0x00,0x00,0xdc,0xd4,0xc1,0x04,0x02,0x00]

v_cmpx_gt_f16_e64 0.5, v2
// GFX10: encoding: [0x00,0x00,0xdc,0xd4,0xf0,0x04,0x02,0x00]

v_cmpx_gt_f16_e64 -4.0, v2
// GFX10: encoding: [0x00,0x00,0xdc,0xd4,0xf7,0x04,0x02,0x00]

v_cmpx_gt_f16_e64 v1, v255
// GFX10: encoding: [0x00,0x00,0xdc,0xd4,0x01,0xff,0x03,0x00]

v_cmpx_gt_f16_e64 v1, s2
// GFX10: encoding: [0x00,0x00,0xdc,0xd4,0x01,0x05,0x00,0x00]

v_cmpx_gt_f16_e64 v1, s101
// GFX10: encoding: [0x00,0x00,0xdc,0xd4,0x01,0xcb,0x00,0x00]

v_cmpx_gt_f16_e64 v1, vcc_lo
// GFX10: encoding: [0x00,0x00,0xdc,0xd4,0x01,0xd5,0x00,0x00]

v_cmpx_gt_f16_e64 v1, vcc_hi
// GFX10: encoding: [0x00,0x00,0xdc,0xd4,0x01,0xd7,0x00,0x00]

v_cmpx_gt_f16_e64 v1, m0
// GFX10: encoding: [0x00,0x00,0xdc,0xd4,0x01,0xf9,0x00,0x00]

v_cmpx_gt_f16_e64 v1, exec_lo
// GFX10: encoding: [0x00,0x00,0xdc,0xd4,0x01,0xfd,0x00,0x00]

v_cmpx_gt_f16_e64 v1, exec_hi
// GFX10: encoding: [0x00,0x00,0xdc,0xd4,0x01,0xff,0x00,0x00]

v_cmpx_gt_f16_e64 v1, 0
// GFX10: encoding: [0x00,0x00,0xdc,0xd4,0x01,0x01,0x01,0x00]

v_cmpx_gt_f16_e64 v1, -1
// GFX10: encoding: [0x00,0x00,0xdc,0xd4,0x01,0x83,0x01,0x00]

v_cmpx_gt_f16_e64 v1, 0.5
// GFX10: encoding: [0x00,0x00,0xdc,0xd4,0x01,0xe1,0x01,0x00]

v_cmpx_gt_f16_e64 v1, -4.0
// GFX10: encoding: [0x00,0x00,0xdc,0xd4,0x01,0xef,0x01,0x00]

v_cmpx_gt_f16_e64 -v1, v2
// GFX10: encoding: [0x00,0x00,0xdc,0xd4,0x01,0x05,0x02,0x20]

v_cmpx_gt_f16_e64 v1, -v2
// GFX10: encoding: [0x00,0x00,0xdc,0xd4,0x01,0x05,0x02,0x40]

v_cmpx_gt_f16_e64 -v1, -v2
// GFX10: encoding: [0x00,0x00,0xdc,0xd4,0x01,0x05,0x02,0x60]

v_cmpx_lg_f16 v1, v2
// GFX10: encoding: [0x01,0x05,0xba,0x7d]

v_cmpx_lg_f16 v255, v2
// GFX10: encoding: [0xff,0x05,0xba,0x7d]

v_cmpx_lg_f16 s1, v2
// GFX10: encoding: [0x01,0x04,0xba,0x7d]

v_cmpx_lg_f16 s101, v2
// GFX10: encoding: [0x65,0x04,0xba,0x7d]

v_cmpx_lg_f16 vcc_lo, v2
// GFX10: encoding: [0x6a,0x04,0xba,0x7d]

v_cmpx_lg_f16 vcc_hi, v2
// GFX10: encoding: [0x6b,0x04,0xba,0x7d]

v_cmpx_lg_f16 m0, v2
// GFX10: encoding: [0x7c,0x04,0xba,0x7d]

v_cmpx_lg_f16 exec_lo, v2
// GFX10: encoding: [0x7e,0x04,0xba,0x7d]

v_cmpx_lg_f16 exec_hi, v2
// GFX10: encoding: [0x7f,0x04,0xba,0x7d]

v_cmpx_lg_f16 0, v2
// GFX10: encoding: [0x80,0x04,0xba,0x7d]

v_cmpx_lg_f16 -1, v2
// GFX10: encoding: [0xc1,0x04,0xba,0x7d]

v_cmpx_lg_f16 0.5, v2
// GFX10: encoding: [0xf0,0x04,0xba,0x7d]

v_cmpx_lg_f16 -4.0, v2
// GFX10: encoding: [0xf7,0x04,0xba,0x7d]

v_cmpx_lg_f16 0xfe0b, v2
// GFX10: encoding: [0xff,0x04,0xba,0x7d,0x0b,0xfe,0x00,0x00]

v_cmpx_lg_f16 0x3456, v2
// GFX10: encoding: [0xff,0x04,0xba,0x7d,0x56,0x34,0x00,0x00]

v_cmpx_lg_f16 v1, v255
// GFX10: encoding: [0x01,0xff,0xbb,0x7d]

v_cmpx_lg_f16_e64 v1, v2
// GFX10: encoding: [0x00,0x00,0xdd,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_lg_f16_e64 v255, v2
// GFX10: encoding: [0x00,0x00,0xdd,0xd4,0xff,0x05,0x02,0x00]

v_cmpx_lg_f16_e64 s1, v2
// GFX10: encoding: [0x00,0x00,0xdd,0xd4,0x01,0x04,0x02,0x00]

v_cmpx_lg_f16_e64 s101, v2
// GFX10: encoding: [0x00,0x00,0xdd,0xd4,0x65,0x04,0x02,0x00]

v_cmpx_lg_f16_e64 vcc_lo, v2
// GFX10: encoding: [0x00,0x00,0xdd,0xd4,0x6a,0x04,0x02,0x00]

v_cmpx_lg_f16_e64 vcc_hi, v2
// GFX10: encoding: [0x00,0x00,0xdd,0xd4,0x6b,0x04,0x02,0x00]

v_cmpx_lg_f16_e64 m0, v2
// GFX10: encoding: [0x00,0x00,0xdd,0xd4,0x7c,0x04,0x02,0x00]

v_cmpx_lg_f16_e64 exec_lo, v2
// GFX10: encoding: [0x00,0x00,0xdd,0xd4,0x7e,0x04,0x02,0x00]

v_cmpx_lg_f16_e64 exec_hi, v2
// GFX10: encoding: [0x00,0x00,0xdd,0xd4,0x7f,0x04,0x02,0x00]

v_cmpx_lg_f16_e64 0, v2
// GFX10: encoding: [0x00,0x00,0xdd,0xd4,0x80,0x04,0x02,0x00]

v_cmpx_lg_f16_e64 -1, v2
// GFX10: encoding: [0x00,0x00,0xdd,0xd4,0xc1,0x04,0x02,0x00]

v_cmpx_lg_f16_e64 0.5, v2
// GFX10: encoding: [0x00,0x00,0xdd,0xd4,0xf0,0x04,0x02,0x00]

v_cmpx_lg_f16_e64 -4.0, v2
// GFX10: encoding: [0x00,0x00,0xdd,0xd4,0xf7,0x04,0x02,0x00]

v_cmpx_lg_f16_e64 v1, v255
// GFX10: encoding: [0x00,0x00,0xdd,0xd4,0x01,0xff,0x03,0x00]

v_cmpx_lg_f16_e64 v1, s2
// GFX10: encoding: [0x00,0x00,0xdd,0xd4,0x01,0x05,0x00,0x00]

v_cmpx_lg_f16_e64 v1, s101
// GFX10: encoding: [0x00,0x00,0xdd,0xd4,0x01,0xcb,0x00,0x00]

v_cmpx_lg_f16_e64 v1, vcc_lo
// GFX10: encoding: [0x00,0x00,0xdd,0xd4,0x01,0xd5,0x00,0x00]

v_cmpx_lg_f16_e64 v1, vcc_hi
// GFX10: encoding: [0x00,0x00,0xdd,0xd4,0x01,0xd7,0x00,0x00]

v_cmpx_lg_f16_e64 v1, m0
// GFX10: encoding: [0x00,0x00,0xdd,0xd4,0x01,0xf9,0x00,0x00]

v_cmpx_lg_f16_e64 v1, exec_lo
// GFX10: encoding: [0x00,0x00,0xdd,0xd4,0x01,0xfd,0x00,0x00]

v_cmpx_lg_f16_e64 v1, exec_hi
// GFX10: encoding: [0x00,0x00,0xdd,0xd4,0x01,0xff,0x00,0x00]

v_cmpx_lg_f16_e64 v1, 0
// GFX10: encoding: [0x00,0x00,0xdd,0xd4,0x01,0x01,0x01,0x00]

v_cmpx_lg_f16_e64 v1, -1
// GFX10: encoding: [0x00,0x00,0xdd,0xd4,0x01,0x83,0x01,0x00]

v_cmpx_lg_f16_e64 v1, 0.5
// GFX10: encoding: [0x00,0x00,0xdd,0xd4,0x01,0xe1,0x01,0x00]

v_cmpx_lg_f16_e64 v1, -4.0
// GFX10: encoding: [0x00,0x00,0xdd,0xd4,0x01,0xef,0x01,0x00]

v_cmpx_lg_f16_e64 -v1, v2
// GFX10: encoding: [0x00,0x00,0xdd,0xd4,0x01,0x05,0x02,0x20]

v_cmpx_lg_f16_e64 v1, -v2
// GFX10: encoding: [0x00,0x00,0xdd,0xd4,0x01,0x05,0x02,0x40]

v_cmpx_lg_f16_e64 -v1, -v2
// GFX10: encoding: [0x00,0x00,0xdd,0xd4,0x01,0x05,0x02,0x60]

v_cmpx_ge_f16 v1, v2
// GFX10: encoding: [0x01,0x05,0xbc,0x7d]

v_cmpx_ge_f16 v255, v2
// GFX10: encoding: [0xff,0x05,0xbc,0x7d]

v_cmpx_ge_f16 s1, v2
// GFX10: encoding: [0x01,0x04,0xbc,0x7d]

v_cmpx_ge_f16 s101, v2
// GFX10: encoding: [0x65,0x04,0xbc,0x7d]

v_cmpx_ge_f16 vcc_lo, v2
// GFX10: encoding: [0x6a,0x04,0xbc,0x7d]

v_cmpx_ge_f16 vcc_hi, v2
// GFX10: encoding: [0x6b,0x04,0xbc,0x7d]

v_cmpx_ge_f16 m0, v2
// GFX10: encoding: [0x7c,0x04,0xbc,0x7d]

v_cmpx_ge_f16 exec_lo, v2
// GFX10: encoding: [0x7e,0x04,0xbc,0x7d]

v_cmpx_ge_f16 exec_hi, v2
// GFX10: encoding: [0x7f,0x04,0xbc,0x7d]

v_cmpx_ge_f16 0, v2
// GFX10: encoding: [0x80,0x04,0xbc,0x7d]

v_cmpx_ge_f16 -1, v2
// GFX10: encoding: [0xc1,0x04,0xbc,0x7d]

v_cmpx_ge_f16 0.5, v2
// GFX10: encoding: [0xf0,0x04,0xbc,0x7d]

v_cmpx_ge_f16 -4.0, v2
// GFX10: encoding: [0xf7,0x04,0xbc,0x7d]

v_cmpx_ge_f16 0xfe0b, v2
// GFX10: encoding: [0xff,0x04,0xbc,0x7d,0x0b,0xfe,0x00,0x00]

v_cmpx_ge_f16 0x3456, v2
// GFX10: encoding: [0xff,0x04,0xbc,0x7d,0x56,0x34,0x00,0x00]

v_cmpx_ge_f16 v1, v255
// GFX10: encoding: [0x01,0xff,0xbd,0x7d]

v_cmpx_ge_f16_e64 v1, v2
// GFX10: encoding: [0x00,0x00,0xde,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_ge_f16_e64 v255, v2
// GFX10: encoding: [0x00,0x00,0xde,0xd4,0xff,0x05,0x02,0x00]

v_cmpx_ge_f16_e64 s1, v2
// GFX10: encoding: [0x00,0x00,0xde,0xd4,0x01,0x04,0x02,0x00]

v_cmpx_ge_f16_e64 s101, v2
// GFX10: encoding: [0x00,0x00,0xde,0xd4,0x65,0x04,0x02,0x00]

v_cmpx_ge_f16_e64 vcc_lo, v2
// GFX10: encoding: [0x00,0x00,0xde,0xd4,0x6a,0x04,0x02,0x00]

v_cmpx_ge_f16_e64 vcc_hi, v2
// GFX10: encoding: [0x00,0x00,0xde,0xd4,0x6b,0x04,0x02,0x00]

v_cmpx_ge_f16_e64 m0, v2
// GFX10: encoding: [0x00,0x00,0xde,0xd4,0x7c,0x04,0x02,0x00]

v_cmpx_ge_f16_e64 exec_lo, v2
// GFX10: encoding: [0x00,0x00,0xde,0xd4,0x7e,0x04,0x02,0x00]

v_cmpx_ge_f16_e64 exec_hi, v2
// GFX10: encoding: [0x00,0x00,0xde,0xd4,0x7f,0x04,0x02,0x00]

v_cmpx_ge_f16_e64 0, v2
// GFX10: encoding: [0x00,0x00,0xde,0xd4,0x80,0x04,0x02,0x00]

v_cmpx_ge_f16_e64 -1, v2
// GFX10: encoding: [0x00,0x00,0xde,0xd4,0xc1,0x04,0x02,0x00]

v_cmpx_ge_f16_e64 0.5, v2
// GFX10: encoding: [0x00,0x00,0xde,0xd4,0xf0,0x04,0x02,0x00]

v_cmpx_ge_f16_e64 -4.0, v2
// GFX10: encoding: [0x00,0x00,0xde,0xd4,0xf7,0x04,0x02,0x00]

v_cmpx_ge_f16_e64 v1, v255
// GFX10: encoding: [0x00,0x00,0xde,0xd4,0x01,0xff,0x03,0x00]

v_cmpx_ge_f16_e64 v1, s2
// GFX10: encoding: [0x00,0x00,0xde,0xd4,0x01,0x05,0x00,0x00]

v_cmpx_ge_f16_e64 v1, s101
// GFX10: encoding: [0x00,0x00,0xde,0xd4,0x01,0xcb,0x00,0x00]

v_cmpx_ge_f16_e64 v1, vcc_lo
// GFX10: encoding: [0x00,0x00,0xde,0xd4,0x01,0xd5,0x00,0x00]

v_cmpx_ge_f16_e64 v1, vcc_hi
// GFX10: encoding: [0x00,0x00,0xde,0xd4,0x01,0xd7,0x00,0x00]

v_cmpx_ge_f16_e64 v1, m0
// GFX10: encoding: [0x00,0x00,0xde,0xd4,0x01,0xf9,0x00,0x00]

v_cmpx_ge_f16_e64 v1, exec_lo
// GFX10: encoding: [0x00,0x00,0xde,0xd4,0x01,0xfd,0x00,0x00]

v_cmpx_ge_f16_e64 v1, exec_hi
// GFX10: encoding: [0x00,0x00,0xde,0xd4,0x01,0xff,0x00,0x00]

v_cmpx_ge_f16_e64 v1, 0
// GFX10: encoding: [0x00,0x00,0xde,0xd4,0x01,0x01,0x01,0x00]

v_cmpx_ge_f16_e64 v1, -1
// GFX10: encoding: [0x00,0x00,0xde,0xd4,0x01,0x83,0x01,0x00]

v_cmpx_ge_f16_e64 v1, 0.5
// GFX10: encoding: [0x00,0x00,0xde,0xd4,0x01,0xe1,0x01,0x00]

v_cmpx_ge_f16_e64 v1, -4.0
// GFX10: encoding: [0x00,0x00,0xde,0xd4,0x01,0xef,0x01,0x00]

v_cmpx_ge_f16_e64 -v1, v2
// GFX10: encoding: [0x00,0x00,0xde,0xd4,0x01,0x05,0x02,0x20]

v_cmpx_ge_f16_e64 v1, -v2
// GFX10: encoding: [0x00,0x00,0xde,0xd4,0x01,0x05,0x02,0x40]

v_cmpx_ge_f16_e64 -v1, -v2
// GFX10: encoding: [0x00,0x00,0xde,0xd4,0x01,0x05,0x02,0x60]

v_cmpx_o_f16 v1, v2
// GFX10: encoding: [0x01,0x05,0xbe,0x7d]

v_cmpx_o_f16 v255, v2
// GFX10: encoding: [0xff,0x05,0xbe,0x7d]

v_cmpx_o_f16 s1, v2
// GFX10: encoding: [0x01,0x04,0xbe,0x7d]

v_cmpx_o_f16 s101, v2
// GFX10: encoding: [0x65,0x04,0xbe,0x7d]

v_cmpx_o_f16 vcc_lo, v2
// GFX10: encoding: [0x6a,0x04,0xbe,0x7d]

v_cmpx_o_f16 vcc_hi, v2
// GFX10: encoding: [0x6b,0x04,0xbe,0x7d]

v_cmpx_o_f16 m0, v2
// GFX10: encoding: [0x7c,0x04,0xbe,0x7d]

v_cmpx_o_f16 exec_lo, v2
// GFX10: encoding: [0x7e,0x04,0xbe,0x7d]

v_cmpx_o_f16 exec_hi, v2
// GFX10: encoding: [0x7f,0x04,0xbe,0x7d]

v_cmpx_o_f16 0, v2
// GFX10: encoding: [0x80,0x04,0xbe,0x7d]

v_cmpx_o_f16 -1, v2
// GFX10: encoding: [0xc1,0x04,0xbe,0x7d]

v_cmpx_o_f16 0.5, v2
// GFX10: encoding: [0xf0,0x04,0xbe,0x7d]

v_cmpx_o_f16 -4.0, v2
// GFX10: encoding: [0xf7,0x04,0xbe,0x7d]

v_cmpx_o_f16 0xfe0b, v2
// GFX10: encoding: [0xff,0x04,0xbe,0x7d,0x0b,0xfe,0x00,0x00]

v_cmpx_o_f16 0x3456, v2
// GFX10: encoding: [0xff,0x04,0xbe,0x7d,0x56,0x34,0x00,0x00]

v_cmpx_o_f16 v1, v255
// GFX10: encoding: [0x01,0xff,0xbf,0x7d]

v_cmpx_o_f16_e64 v1, v2
// GFX10: encoding: [0x00,0x00,0xdf,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_o_f16_e64 v255, v2
// GFX10: encoding: [0x00,0x00,0xdf,0xd4,0xff,0x05,0x02,0x00]

v_cmpx_o_f16_e64 s1, v2
// GFX10: encoding: [0x00,0x00,0xdf,0xd4,0x01,0x04,0x02,0x00]

v_cmpx_o_f16_e64 s101, v2
// GFX10: encoding: [0x00,0x00,0xdf,0xd4,0x65,0x04,0x02,0x00]

v_cmpx_o_f16_e64 vcc_lo, v2
// GFX10: encoding: [0x00,0x00,0xdf,0xd4,0x6a,0x04,0x02,0x00]

v_cmpx_o_f16_e64 vcc_hi, v2
// GFX10: encoding: [0x00,0x00,0xdf,0xd4,0x6b,0x04,0x02,0x00]

v_cmpx_o_f16_e64 m0, v2
// GFX10: encoding: [0x00,0x00,0xdf,0xd4,0x7c,0x04,0x02,0x00]

v_cmpx_o_f16_e64 exec_lo, v2
// GFX10: encoding: [0x00,0x00,0xdf,0xd4,0x7e,0x04,0x02,0x00]

v_cmpx_o_f16_e64 exec_hi, v2
// GFX10: encoding: [0x00,0x00,0xdf,0xd4,0x7f,0x04,0x02,0x00]

v_cmpx_o_f16_e64 0, v2
// GFX10: encoding: [0x00,0x00,0xdf,0xd4,0x80,0x04,0x02,0x00]

v_cmpx_o_f16_e64 -1, v2
// GFX10: encoding: [0x00,0x00,0xdf,0xd4,0xc1,0x04,0x02,0x00]

v_cmpx_o_f16_e64 0.5, v2
// GFX10: encoding: [0x00,0x00,0xdf,0xd4,0xf0,0x04,0x02,0x00]

v_cmpx_o_f16_e64 -4.0, v2
// GFX10: encoding: [0x00,0x00,0xdf,0xd4,0xf7,0x04,0x02,0x00]

v_cmpx_o_f16_e64 v1, v255
// GFX10: encoding: [0x00,0x00,0xdf,0xd4,0x01,0xff,0x03,0x00]

v_cmpx_o_f16_e64 v1, s2
// GFX10: encoding: [0x00,0x00,0xdf,0xd4,0x01,0x05,0x00,0x00]

v_cmpx_o_f16_e64 v1, s101
// GFX10: encoding: [0x00,0x00,0xdf,0xd4,0x01,0xcb,0x00,0x00]

v_cmpx_o_f16_e64 v1, vcc_lo
// GFX10: encoding: [0x00,0x00,0xdf,0xd4,0x01,0xd5,0x00,0x00]

v_cmpx_o_f16_e64 v1, vcc_hi
// GFX10: encoding: [0x00,0x00,0xdf,0xd4,0x01,0xd7,0x00,0x00]

v_cmpx_o_f16_e64 v1, m0
// GFX10: encoding: [0x00,0x00,0xdf,0xd4,0x01,0xf9,0x00,0x00]

v_cmpx_o_f16_e64 v1, exec_lo
// GFX10: encoding: [0x00,0x00,0xdf,0xd4,0x01,0xfd,0x00,0x00]

v_cmpx_o_f16_e64 v1, exec_hi
// GFX10: encoding: [0x00,0x00,0xdf,0xd4,0x01,0xff,0x00,0x00]

v_cmpx_o_f16_e64 v1, 0
// GFX10: encoding: [0x00,0x00,0xdf,0xd4,0x01,0x01,0x01,0x00]

v_cmpx_o_f16_e64 v1, -1
// GFX10: encoding: [0x00,0x00,0xdf,0xd4,0x01,0x83,0x01,0x00]

v_cmpx_o_f16_e64 v1, 0.5
// GFX10: encoding: [0x00,0x00,0xdf,0xd4,0x01,0xe1,0x01,0x00]

v_cmpx_o_f16_e64 v1, -4.0
// GFX10: encoding: [0x00,0x00,0xdf,0xd4,0x01,0xef,0x01,0x00]

v_cmpx_o_f16_e64 -v1, v2
// GFX10: encoding: [0x00,0x00,0xdf,0xd4,0x01,0x05,0x02,0x20]

v_cmpx_o_f16_e64 v1, -v2
// GFX10: encoding: [0x00,0x00,0xdf,0xd4,0x01,0x05,0x02,0x40]

v_cmpx_o_f16_e64 -v1, -v2
// GFX10: encoding: [0x00,0x00,0xdf,0xd4,0x01,0x05,0x02,0x60]

v_cmpx_f_u64 v[1:2], v[2:3]
// GFX10: encoding: [0x01,0x05,0xe0,0x7d]

v_cmpx_f_u64 v[254:255], v[2:3]
// GFX10: encoding: [0xfe,0x05,0xe0,0x7d]

v_cmpx_f_u64 s[2:3], v[2:3]
// GFX10: encoding: [0x02,0x04,0xe0,0x7d]

v_cmpx_f_u64 s[4:5], v[2:3]
// GFX10: encoding: [0x04,0x04,0xe0,0x7d]

v_cmpx_f_u64 s[100:101], v[2:3]
// GFX10: encoding: [0x64,0x04,0xe0,0x7d]

v_cmpx_f_u64 vcc, v[2:3]
// GFX10: encoding: [0x6a,0x04,0xe0,0x7d]

v_cmpx_f_u64 exec, v[2:3]
// GFX10: encoding: [0x7e,0x04,0xe0,0x7d]

v_cmpx_f_u64 0, v[2:3]
// GFX10: encoding: [0x80,0x04,0xe0,0x7d]

v_cmpx_f_u64 -1, v[2:3]
// GFX10: encoding: [0xc1,0x04,0xe0,0x7d]

v_cmpx_f_u64 0.5, v[2:3]
// GFX10: encoding: [0xf0,0x04,0xe0,0x7d]

v_cmpx_f_u64 -4.0, v[2:3]
// GFX10: encoding: [0xf7,0x04,0xe0,0x7d]

v_cmpx_f_u64 0xaf123456, v[2:3]
// GFX10: encoding: [0xff,0x04,0xe0,0x7d,0x56,0x34,0x12,0xaf]

v_cmpx_f_u64 0x3f717273, v[2:3]
// GFX10: encoding: [0xff,0x04,0xe0,0x7d,0x73,0x72,0x71,0x3f]

v_cmpx_f_u64 v[1:2], v[254:255]
// GFX10: encoding: [0x01,0xfd,0xe1,0x7d]

v_cmpx_f_u64_e64 v[1:2], v[2:3]
// GFX10: encoding: [0x00,0x00,0xf0,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_f_u64_e64 v[254:255], v[2:3]
// GFX10: encoding: [0x00,0x00,0xf0,0xd4,0xfe,0x05,0x02,0x00]

v_cmpx_f_u64_e64 s[2:3], v[2:3]
// GFX10: encoding: [0x00,0x00,0xf0,0xd4,0x02,0x04,0x02,0x00]

v_cmpx_f_u64_e64 s[4:5], v[2:3]
// GFX10: encoding: [0x00,0x00,0xf0,0xd4,0x04,0x04,0x02,0x00]

v_cmpx_f_u64_e64 vcc, v[2:3]
// GFX10: encoding: [0x00,0x00,0xf0,0xd4,0x6a,0x04,0x02,0x00]

v_cmpx_f_u64_e64 0, v[2:3]
// GFX10: encoding: [0x00,0x00,0xf0,0xd4,0x80,0x04,0x02,0x00]

v_cmpx_f_u64_e64 -1, v[2:3]
// GFX10: encoding: [0x00,0x00,0xf0,0xd4,0xc1,0x04,0x02,0x00]

v_cmpx_f_u64_e64 0.5, v[2:3]
// GFX10: encoding: [0x00,0x00,0xf0,0xd4,0xf0,0x04,0x02,0x00]

v_cmpx_f_u64_e64 -4.0, v[2:3]
// GFX10: encoding: [0x00,0x00,0xf0,0xd4,0xf7,0x04,0x02,0x00]

v_cmpx_f_u64_e64 v[1:2], v[254:255]
// GFX10: encoding: [0x00,0x00,0xf0,0xd4,0x01,0xfd,0x03,0x00]

v_cmpx_f_u64_e64 v[1:2], s[4:5]
// GFX10: encoding: [0x00,0x00,0xf0,0xd4,0x01,0x09,0x00,0x00]

v_cmpx_f_u64_e64 v[1:2], s[6:7]
// GFX10: encoding: [0x00,0x00,0xf0,0xd4,0x01,0x0d,0x00,0x00]

v_cmpx_f_u64_e64 v[1:2], s[100:101]
// GFX10: encoding: [0x00,0x00,0xf0,0xd4,0x01,0xc9,0x00,0x00]

v_cmpx_f_u64_e64 v[1:2], vcc
// GFX10: encoding: [0x00,0x00,0xf0,0xd4,0x01,0xd5,0x00,0x00]

v_cmpx_f_u64_e64 v[1:2], exec
// GFX10: encoding: [0x00,0x00,0xf0,0xd4,0x01,0xfd,0x00,0x00]

v_cmpx_f_u64_e64 v[1:2], 0
// GFX10: encoding: [0x00,0x00,0xf0,0xd4,0x01,0x01,0x01,0x00]

v_cmpx_f_u64_e64 v[1:2], -1
// GFX10: encoding: [0x00,0x00,0xf0,0xd4,0x01,0x83,0x01,0x00]

v_cmpx_f_u64_e64 v[1:2], 0.5
// GFX10: encoding: [0x00,0x00,0xf0,0xd4,0x01,0xe1,0x01,0x00]

v_cmpx_f_u64_e64 v[1:2], -4.0
// GFX10: encoding: [0x00,0x00,0xf0,0xd4,0x01,0xef,0x01,0x00]

v_cmpx_lt_u64 v[1:2], v[2:3]
// GFX10: encoding: [0x01,0x05,0xe2,0x7d]

v_cmpx_lt_u64 v[254:255], v[2:3]
// GFX10: encoding: [0xfe,0x05,0xe2,0x7d]

v_cmpx_lt_u64 s[2:3], v[2:3]
// GFX10: encoding: [0x02,0x04,0xe2,0x7d]

v_cmpx_lt_u64 s[4:5], v[2:3]
// GFX10: encoding: [0x04,0x04,0xe2,0x7d]

v_cmpx_lt_u64 s[100:101], v[2:3]
// GFX10: encoding: [0x64,0x04,0xe2,0x7d]

v_cmpx_lt_u64 vcc, v[2:3]
// GFX10: encoding: [0x6a,0x04,0xe2,0x7d]

v_cmpx_lt_u64 exec, v[2:3]
// GFX10: encoding: [0x7e,0x04,0xe2,0x7d]

v_cmpx_lt_u64 0, v[2:3]
// GFX10: encoding: [0x80,0x04,0xe2,0x7d]

v_cmpx_lt_u64 -1, v[2:3]
// GFX10: encoding: [0xc1,0x04,0xe2,0x7d]

v_cmpx_lt_u64 0.5, v[2:3]
// GFX10: encoding: [0xf0,0x04,0xe2,0x7d]

v_cmpx_lt_u64 -4.0, v[2:3]
// GFX10: encoding: [0xf7,0x04,0xe2,0x7d]

v_cmpx_lt_u64 0xaf123456, v[2:3]
// GFX10: encoding: [0xff,0x04,0xe2,0x7d,0x56,0x34,0x12,0xaf]

v_cmpx_lt_u64 0x3f717273, v[2:3]
// GFX10: encoding: [0xff,0x04,0xe2,0x7d,0x73,0x72,0x71,0x3f]

v_cmpx_lt_u64 v[1:2], v[254:255]
// GFX10: encoding: [0x01,0xfd,0xe3,0x7d]

v_cmpx_lt_u64_e64 v[1:2], v[2:3]
// GFX10: encoding: [0x00,0x00,0xf1,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_lt_u64_e64 v[254:255], v[2:3]
// GFX10: encoding: [0x00,0x00,0xf1,0xd4,0xfe,0x05,0x02,0x00]

v_cmpx_lt_u64_e64 s[2:3], v[2:3]
// GFX10: encoding: [0x00,0x00,0xf1,0xd4,0x02,0x04,0x02,0x00]

v_cmpx_lt_u64_e64 s[4:5], v[2:3]
// GFX10: encoding: [0x00,0x00,0xf1,0xd4,0x04,0x04,0x02,0x00]

v_cmpx_lt_u64_e64 vcc, v[2:3]
// GFX10: encoding: [0x00,0x00,0xf1,0xd4,0x6a,0x04,0x02,0x00]

v_cmpx_lt_u64_e64 0, v[2:3]
// GFX10: encoding: [0x00,0x00,0xf1,0xd4,0x80,0x04,0x02,0x00]

v_cmpx_lt_u64_e64 -1, v[2:3]
// GFX10: encoding: [0x00,0x00,0xf1,0xd4,0xc1,0x04,0x02,0x00]

v_cmpx_lt_u64_e64 0.5, v[2:3]
// GFX10: encoding: [0x00,0x00,0xf1,0xd4,0xf0,0x04,0x02,0x00]

v_cmpx_lt_u64_e64 -4.0, v[2:3]
// GFX10: encoding: [0x00,0x00,0xf1,0xd4,0xf7,0x04,0x02,0x00]

v_cmpx_lt_u64_e64 v[1:2], v[254:255]
// GFX10: encoding: [0x00,0x00,0xf1,0xd4,0x01,0xfd,0x03,0x00]

v_cmpx_lt_u64_e64 v[1:2], s[4:5]
// GFX10: encoding: [0x00,0x00,0xf1,0xd4,0x01,0x09,0x00,0x00]

v_cmpx_lt_u64_e64 v[1:2], s[6:7]
// GFX10: encoding: [0x00,0x00,0xf1,0xd4,0x01,0x0d,0x00,0x00]

v_cmpx_lt_u64_e64 v[1:2], s[100:101]
// GFX10: encoding: [0x00,0x00,0xf1,0xd4,0x01,0xc9,0x00,0x00]

v_cmpx_lt_u64_e64 v[1:2], vcc
// GFX10: encoding: [0x00,0x00,0xf1,0xd4,0x01,0xd5,0x00,0x00]

v_cmpx_lt_u64_e64 v[1:2], exec
// GFX10: encoding: [0x00,0x00,0xf1,0xd4,0x01,0xfd,0x00,0x00]

v_cmpx_lt_u64_e64 v[1:2], 0
// GFX10: encoding: [0x00,0x00,0xf1,0xd4,0x01,0x01,0x01,0x00]

v_cmpx_lt_u64_e64 v[1:2], -1
// GFX10: encoding: [0x00,0x00,0xf1,0xd4,0x01,0x83,0x01,0x00]

v_cmpx_lt_u64_e64 v[1:2], 0.5
// GFX10: encoding: [0x00,0x00,0xf1,0xd4,0x01,0xe1,0x01,0x00]

v_cmpx_lt_u64_e64 v[1:2], -4.0
// GFX10: encoding: [0x00,0x00,0xf1,0xd4,0x01,0xef,0x01,0x00]

v_cmpx_eq_u64 v[1:2], v[2:3]
// GFX10: encoding: [0x01,0x05,0xe4,0x7d]

v_cmpx_eq_u64 v[254:255], v[2:3]
// GFX10: encoding: [0xfe,0x05,0xe4,0x7d]

v_cmpx_eq_u64 s[2:3], v[2:3]
// GFX10: encoding: [0x02,0x04,0xe4,0x7d]

v_cmpx_eq_u64 s[4:5], v[2:3]
// GFX10: encoding: [0x04,0x04,0xe4,0x7d]

v_cmpx_eq_u64 s[100:101], v[2:3]
// GFX10: encoding: [0x64,0x04,0xe4,0x7d]

v_cmpx_eq_u64 vcc, v[2:3]
// GFX10: encoding: [0x6a,0x04,0xe4,0x7d]

v_cmpx_eq_u64 exec, v[2:3]
// GFX10: encoding: [0x7e,0x04,0xe4,0x7d]

v_cmpx_eq_u64 0, v[2:3]
// GFX10: encoding: [0x80,0x04,0xe4,0x7d]

v_cmpx_eq_u64 -1, v[2:3]
// GFX10: encoding: [0xc1,0x04,0xe4,0x7d]

v_cmpx_eq_u64 0.5, v[2:3]
// GFX10: encoding: [0xf0,0x04,0xe4,0x7d]

v_cmpx_eq_u64 -4.0, v[2:3]
// GFX10: encoding: [0xf7,0x04,0xe4,0x7d]

v_cmpx_eq_u64 0xaf123456, v[2:3]
// GFX10: encoding: [0xff,0x04,0xe4,0x7d,0x56,0x34,0x12,0xaf]

v_cmpx_eq_u64 0x3f717273, v[2:3]
// GFX10: encoding: [0xff,0x04,0xe4,0x7d,0x73,0x72,0x71,0x3f]

v_cmpx_eq_u64 v[1:2], v[254:255]
// GFX10: encoding: [0x01,0xfd,0xe5,0x7d]

v_cmpx_eq_u64_e64 v[1:2], v[2:3]
// GFX10: encoding: [0x00,0x00,0xf2,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_eq_u64_e64 v[254:255], v[2:3]
// GFX10: encoding: [0x00,0x00,0xf2,0xd4,0xfe,0x05,0x02,0x00]

v_cmpx_eq_u64_e64 s[2:3], v[2:3]
// GFX10: encoding: [0x00,0x00,0xf2,0xd4,0x02,0x04,0x02,0x00]

v_cmpx_eq_u64_e64 s[4:5], v[2:3]
// GFX10: encoding: [0x00,0x00,0xf2,0xd4,0x04,0x04,0x02,0x00]

v_cmpx_eq_u64_e64 vcc, v[2:3]
// GFX10: encoding: [0x00,0x00,0xf2,0xd4,0x6a,0x04,0x02,0x00]

v_cmpx_eq_u64_e64 0, v[2:3]
// GFX10: encoding: [0x00,0x00,0xf2,0xd4,0x80,0x04,0x02,0x00]

v_cmpx_eq_u64_e64 -1, v[2:3]
// GFX10: encoding: [0x00,0x00,0xf2,0xd4,0xc1,0x04,0x02,0x00]

v_cmpx_eq_u64_e64 0.5, v[2:3]
// GFX10: encoding: [0x00,0x00,0xf2,0xd4,0xf0,0x04,0x02,0x00]

v_cmpx_eq_u64_e64 -4.0, v[2:3]
// GFX10: encoding: [0x00,0x00,0xf2,0xd4,0xf7,0x04,0x02,0x00]

v_cmpx_eq_u64_e64 v[1:2], v[254:255]
// GFX10: encoding: [0x00,0x00,0xf2,0xd4,0x01,0xfd,0x03,0x00]

v_cmpx_eq_u64_e64 v[1:2], s[4:5]
// GFX10: encoding: [0x00,0x00,0xf2,0xd4,0x01,0x09,0x00,0x00]

v_cmpx_eq_u64_e64 v[1:2], s[6:7]
// GFX10: encoding: [0x00,0x00,0xf2,0xd4,0x01,0x0d,0x00,0x00]

v_cmpx_eq_u64_e64 v[1:2], s[100:101]
// GFX10: encoding: [0x00,0x00,0xf2,0xd4,0x01,0xc9,0x00,0x00]

v_cmpx_eq_u64_e64 v[1:2], vcc
// GFX10: encoding: [0x00,0x00,0xf2,0xd4,0x01,0xd5,0x00,0x00]

v_cmpx_eq_u64_e64 v[1:2], exec
// GFX10: encoding: [0x00,0x00,0xf2,0xd4,0x01,0xfd,0x00,0x00]

v_cmpx_eq_u64_e64 v[1:2], 0
// GFX10: encoding: [0x00,0x00,0xf2,0xd4,0x01,0x01,0x01,0x00]

v_cmpx_eq_u64_e64 v[1:2], -1
// GFX10: encoding: [0x00,0x00,0xf2,0xd4,0x01,0x83,0x01,0x00]

v_cmpx_eq_u64_e64 v[1:2], 0.5
// GFX10: encoding: [0x00,0x00,0xf2,0xd4,0x01,0xe1,0x01,0x00]

v_cmpx_eq_u64_e64 v[1:2], -4.0
// GFX10: encoding: [0x00,0x00,0xf2,0xd4,0x01,0xef,0x01,0x00]

v_cmpx_le_u64 v[1:2], v[2:3]
// GFX10: encoding: [0x01,0x05,0xe6,0x7d]

v_cmpx_le_u64 v[254:255], v[2:3]
// GFX10: encoding: [0xfe,0x05,0xe6,0x7d]

v_cmpx_le_u64 s[2:3], v[2:3]
// GFX10: encoding: [0x02,0x04,0xe6,0x7d]

v_cmpx_le_u64 s[4:5], v[2:3]
// GFX10: encoding: [0x04,0x04,0xe6,0x7d]

v_cmpx_le_u64 s[100:101], v[2:3]
// GFX10: encoding: [0x64,0x04,0xe6,0x7d]

v_cmpx_le_u64 vcc, v[2:3]
// GFX10: encoding: [0x6a,0x04,0xe6,0x7d]

v_cmpx_le_u64 exec, v[2:3]
// GFX10: encoding: [0x7e,0x04,0xe6,0x7d]

v_cmpx_le_u64 0, v[2:3]
// GFX10: encoding: [0x80,0x04,0xe6,0x7d]

v_cmpx_le_u64 -1, v[2:3]
// GFX10: encoding: [0xc1,0x04,0xe6,0x7d]

v_cmpx_le_u64 0.5, v[2:3]
// GFX10: encoding: [0xf0,0x04,0xe6,0x7d]

v_cmpx_le_u64 -4.0, v[2:3]
// GFX10: encoding: [0xf7,0x04,0xe6,0x7d]

v_cmpx_le_u64 0xaf123456, v[2:3]
// GFX10: encoding: [0xff,0x04,0xe6,0x7d,0x56,0x34,0x12,0xaf]

v_cmpx_le_u64 0x3f717273, v[2:3]
// GFX10: encoding: [0xff,0x04,0xe6,0x7d,0x73,0x72,0x71,0x3f]

v_cmpx_le_u64 v[1:2], v[254:255]
// GFX10: encoding: [0x01,0xfd,0xe7,0x7d]

v_cmpx_le_u64_e64 v[1:2], v[2:3]
// GFX10: encoding: [0x00,0x00,0xf3,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_le_u64_e64 v[254:255], v[2:3]
// GFX10: encoding: [0x00,0x00,0xf3,0xd4,0xfe,0x05,0x02,0x00]

v_cmpx_le_u64_e64 s[2:3], v[2:3]
// GFX10: encoding: [0x00,0x00,0xf3,0xd4,0x02,0x04,0x02,0x00]

v_cmpx_le_u64_e64 s[4:5], v[2:3]
// GFX10: encoding: [0x00,0x00,0xf3,0xd4,0x04,0x04,0x02,0x00]

v_cmpx_le_u64_e64 vcc, v[2:3]
// GFX10: encoding: [0x00,0x00,0xf3,0xd4,0x6a,0x04,0x02,0x00]

v_cmpx_le_u64_e64 0, v[2:3]
// GFX10: encoding: [0x00,0x00,0xf3,0xd4,0x80,0x04,0x02,0x00]

v_cmpx_le_u64_e64 -1, v[2:3]
// GFX10: encoding: [0x00,0x00,0xf3,0xd4,0xc1,0x04,0x02,0x00]

v_cmpx_le_u64_e64 0.5, v[2:3]
// GFX10: encoding: [0x00,0x00,0xf3,0xd4,0xf0,0x04,0x02,0x00]

v_cmpx_le_u64_e64 -4.0, v[2:3]
// GFX10: encoding: [0x00,0x00,0xf3,0xd4,0xf7,0x04,0x02,0x00]

v_cmpx_le_u64_e64 v[1:2], v[254:255]
// GFX10: encoding: [0x00,0x00,0xf3,0xd4,0x01,0xfd,0x03,0x00]

v_cmpx_le_u64_e64 v[1:2], s[4:5]
// GFX10: encoding: [0x00,0x00,0xf3,0xd4,0x01,0x09,0x00,0x00]

v_cmpx_le_u64_e64 v[1:2], s[6:7]
// GFX10: encoding: [0x00,0x00,0xf3,0xd4,0x01,0x0d,0x00,0x00]

v_cmpx_le_u64_e64 v[1:2], s[100:101]
// GFX10: encoding: [0x00,0x00,0xf3,0xd4,0x01,0xc9,0x00,0x00]

v_cmpx_le_u64_e64 v[1:2], vcc
// GFX10: encoding: [0x00,0x00,0xf3,0xd4,0x01,0xd5,0x00,0x00]

v_cmpx_le_u64_e64 v[1:2], exec
// GFX10: encoding: [0x00,0x00,0xf3,0xd4,0x01,0xfd,0x00,0x00]

v_cmpx_le_u64_e64 v[1:2], 0
// GFX10: encoding: [0x00,0x00,0xf3,0xd4,0x01,0x01,0x01,0x00]

v_cmpx_le_u64_e64 v[1:2], -1
// GFX10: encoding: [0x00,0x00,0xf3,0xd4,0x01,0x83,0x01,0x00]

v_cmpx_le_u64_e64 v[1:2], 0.5
// GFX10: encoding: [0x00,0x00,0xf3,0xd4,0x01,0xe1,0x01,0x00]

v_cmpx_le_u64_e64 v[1:2], -4.0
// GFX10: encoding: [0x00,0x00,0xf3,0xd4,0x01,0xef,0x01,0x00]

v_cmpx_gt_u64 v[1:2], v[2:3]
// GFX10: encoding: [0x01,0x05,0xe8,0x7d]

v_cmpx_gt_u64 v[254:255], v[2:3]
// GFX10: encoding: [0xfe,0x05,0xe8,0x7d]

v_cmpx_gt_u64 s[2:3], v[2:3]
// GFX10: encoding: [0x02,0x04,0xe8,0x7d]

v_cmpx_gt_u64 s[4:5], v[2:3]
// GFX10: encoding: [0x04,0x04,0xe8,0x7d]

v_cmpx_gt_u64 s[100:101], v[2:3]
// GFX10: encoding: [0x64,0x04,0xe8,0x7d]

v_cmpx_gt_u64 vcc, v[2:3]
// GFX10: encoding: [0x6a,0x04,0xe8,0x7d]

v_cmpx_gt_u64 exec, v[2:3]
// GFX10: encoding: [0x7e,0x04,0xe8,0x7d]

v_cmpx_gt_u64 0, v[2:3]
// GFX10: encoding: [0x80,0x04,0xe8,0x7d]

v_cmpx_gt_u64 -1, v[2:3]
// GFX10: encoding: [0xc1,0x04,0xe8,0x7d]

v_cmpx_gt_u64 0.5, v[2:3]
// GFX10: encoding: [0xf0,0x04,0xe8,0x7d]

v_cmpx_gt_u64 -4.0, v[2:3]
// GFX10: encoding: [0xf7,0x04,0xe8,0x7d]

v_cmpx_gt_u64 0xaf123456, v[2:3]
// GFX10: encoding: [0xff,0x04,0xe8,0x7d,0x56,0x34,0x12,0xaf]

v_cmpx_gt_u64 0x3f717273, v[2:3]
// GFX10: encoding: [0xff,0x04,0xe8,0x7d,0x73,0x72,0x71,0x3f]

v_cmpx_gt_u64 v[1:2], v[254:255]
// GFX10: encoding: [0x01,0xfd,0xe9,0x7d]

v_cmpx_gt_u64_e64 v[1:2], v[2:3]
// GFX10: encoding: [0x00,0x00,0xf4,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_gt_u64_e64 v[254:255], v[2:3]
// GFX10: encoding: [0x00,0x00,0xf4,0xd4,0xfe,0x05,0x02,0x00]

v_cmpx_gt_u64_e64 s[2:3], v[2:3]
// GFX10: encoding: [0x00,0x00,0xf4,0xd4,0x02,0x04,0x02,0x00]

v_cmpx_gt_u64_e64 s[4:5], v[2:3]
// GFX10: encoding: [0x00,0x00,0xf4,0xd4,0x04,0x04,0x02,0x00]

v_cmpx_gt_u64_e64 vcc, v[2:3]
// GFX10: encoding: [0x00,0x00,0xf4,0xd4,0x6a,0x04,0x02,0x00]

v_cmpx_gt_u64_e64 0, v[2:3]
// GFX10: encoding: [0x00,0x00,0xf4,0xd4,0x80,0x04,0x02,0x00]

v_cmpx_gt_u64_e64 -1, v[2:3]
// GFX10: encoding: [0x00,0x00,0xf4,0xd4,0xc1,0x04,0x02,0x00]

v_cmpx_gt_u64_e64 0.5, v[2:3]
// GFX10: encoding: [0x00,0x00,0xf4,0xd4,0xf0,0x04,0x02,0x00]

v_cmpx_gt_u64_e64 -4.0, v[2:3]
// GFX10: encoding: [0x00,0x00,0xf4,0xd4,0xf7,0x04,0x02,0x00]

v_cmpx_gt_u64_e64 v[1:2], v[254:255]
// GFX10: encoding: [0x00,0x00,0xf4,0xd4,0x01,0xfd,0x03,0x00]

v_cmpx_gt_u64_e64 v[1:2], s[4:5]
// GFX10: encoding: [0x00,0x00,0xf4,0xd4,0x01,0x09,0x00,0x00]

v_cmpx_gt_u64_e64 v[1:2], s[6:7]
// GFX10: encoding: [0x00,0x00,0xf4,0xd4,0x01,0x0d,0x00,0x00]

v_cmpx_gt_u64_e64 v[1:2], s[100:101]
// GFX10: encoding: [0x00,0x00,0xf4,0xd4,0x01,0xc9,0x00,0x00]

v_cmpx_gt_u64_e64 v[1:2], vcc
// GFX10: encoding: [0x00,0x00,0xf4,0xd4,0x01,0xd5,0x00,0x00]

v_cmpx_gt_u64_e64 v[1:2], exec
// GFX10: encoding: [0x00,0x00,0xf4,0xd4,0x01,0xfd,0x00,0x00]

v_cmpx_gt_u64_e64 v[1:2], 0
// GFX10: encoding: [0x00,0x00,0xf4,0xd4,0x01,0x01,0x01,0x00]

v_cmpx_gt_u64_e64 v[1:2], -1
// GFX10: encoding: [0x00,0x00,0xf4,0xd4,0x01,0x83,0x01,0x00]

v_cmpx_gt_u64_e64 v[1:2], 0.5
// GFX10: encoding: [0x00,0x00,0xf4,0xd4,0x01,0xe1,0x01,0x00]

v_cmpx_gt_u64_e64 v[1:2], -4.0
// GFX10: encoding: [0x00,0x00,0xf4,0xd4,0x01,0xef,0x01,0x00]

v_cmpx_ne_u64 v[1:2], v[2:3]
// GFX10: encoding: [0x01,0x05,0xea,0x7d]

v_cmpx_ne_u64 v[254:255], v[2:3]
// GFX10: encoding: [0xfe,0x05,0xea,0x7d]

v_cmpx_ne_u64 s[2:3], v[2:3]
// GFX10: encoding: [0x02,0x04,0xea,0x7d]

v_cmpx_ne_u64 s[4:5], v[2:3]
// GFX10: encoding: [0x04,0x04,0xea,0x7d]

v_cmpx_ne_u64 s[100:101], v[2:3]
// GFX10: encoding: [0x64,0x04,0xea,0x7d]

v_cmpx_ne_u64 vcc, v[2:3]
// GFX10: encoding: [0x6a,0x04,0xea,0x7d]

v_cmpx_ne_u64 exec, v[2:3]
// GFX10: encoding: [0x7e,0x04,0xea,0x7d]

v_cmpx_ne_u64 0, v[2:3]
// GFX10: encoding: [0x80,0x04,0xea,0x7d]

v_cmpx_ne_u64 -1, v[2:3]
// GFX10: encoding: [0xc1,0x04,0xea,0x7d]

v_cmpx_ne_u64 0.5, v[2:3]
// GFX10: encoding: [0xf0,0x04,0xea,0x7d]

v_cmpx_ne_u64 -4.0, v[2:3]
// GFX10: encoding: [0xf7,0x04,0xea,0x7d]

v_cmpx_ne_u64 0xaf123456, v[2:3]
// GFX10: encoding: [0xff,0x04,0xea,0x7d,0x56,0x34,0x12,0xaf]

v_cmpx_ne_u64 0x3f717273, v[2:3]
// GFX10: encoding: [0xff,0x04,0xea,0x7d,0x73,0x72,0x71,0x3f]

v_cmpx_ne_u64 v[1:2], v[254:255]
// GFX10: encoding: [0x01,0xfd,0xeb,0x7d]

v_cmpx_ne_u64_e64 v[1:2], v[2:3]
// GFX10: encoding: [0x00,0x00,0xf5,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_ne_u64_e64 v[254:255], v[2:3]
// GFX10: encoding: [0x00,0x00,0xf5,0xd4,0xfe,0x05,0x02,0x00]

v_cmpx_ne_u64_e64 s[2:3], v[2:3]
// GFX10: encoding: [0x00,0x00,0xf5,0xd4,0x02,0x04,0x02,0x00]

v_cmpx_ne_u64_e64 s[4:5], v[2:3]
// GFX10: encoding: [0x00,0x00,0xf5,0xd4,0x04,0x04,0x02,0x00]

v_cmpx_ne_u64_e64 vcc, v[2:3]
// GFX10: encoding: [0x00,0x00,0xf5,0xd4,0x6a,0x04,0x02,0x00]

v_cmpx_ne_u64_e64 0, v[2:3]
// GFX10: encoding: [0x00,0x00,0xf5,0xd4,0x80,0x04,0x02,0x00]

v_cmpx_ne_u64_e64 -1, v[2:3]
// GFX10: encoding: [0x00,0x00,0xf5,0xd4,0xc1,0x04,0x02,0x00]

v_cmpx_ne_u64_e64 0.5, v[2:3]
// GFX10: encoding: [0x00,0x00,0xf5,0xd4,0xf0,0x04,0x02,0x00]

v_cmpx_ne_u64_e64 -4.0, v[2:3]
// GFX10: encoding: [0x00,0x00,0xf5,0xd4,0xf7,0x04,0x02,0x00]

v_cmpx_ne_u64_e64 v[1:2], v[254:255]
// GFX10: encoding: [0x00,0x00,0xf5,0xd4,0x01,0xfd,0x03,0x00]

v_cmpx_ne_u64_e64 v[1:2], s[4:5]
// GFX10: encoding: [0x00,0x00,0xf5,0xd4,0x01,0x09,0x00,0x00]

v_cmpx_ne_u64_e64 v[1:2], s[6:7]
// GFX10: encoding: [0x00,0x00,0xf5,0xd4,0x01,0x0d,0x00,0x00]

v_cmpx_ne_u64_e64 v[1:2], s[100:101]
// GFX10: encoding: [0x00,0x00,0xf5,0xd4,0x01,0xc9,0x00,0x00]

v_cmpx_ne_u64_e64 v[1:2], vcc
// GFX10: encoding: [0x00,0x00,0xf5,0xd4,0x01,0xd5,0x00,0x00]

v_cmpx_ne_u64_e64 v[1:2], exec
// GFX10: encoding: [0x00,0x00,0xf5,0xd4,0x01,0xfd,0x00,0x00]

v_cmpx_ne_u64_e64 v[1:2], 0
// GFX10: encoding: [0x00,0x00,0xf5,0xd4,0x01,0x01,0x01,0x00]

v_cmpx_ne_u64_e64 v[1:2], -1
// GFX10: encoding: [0x00,0x00,0xf5,0xd4,0x01,0x83,0x01,0x00]

v_cmpx_ne_u64_e64 v[1:2], 0.5
// GFX10: encoding: [0x00,0x00,0xf5,0xd4,0x01,0xe1,0x01,0x00]

v_cmpx_ne_u64_e64 v[1:2], -4.0
// GFX10: encoding: [0x00,0x00,0xf5,0xd4,0x01,0xef,0x01,0x00]

v_cmpx_ge_u64 v[1:2], v[2:3]
// GFX10: encoding: [0x01,0x05,0xec,0x7d]

v_cmpx_ge_u64 v[254:255], v[2:3]
// GFX10: encoding: [0xfe,0x05,0xec,0x7d]

v_cmpx_ge_u64 s[2:3], v[2:3]
// GFX10: encoding: [0x02,0x04,0xec,0x7d]

v_cmpx_ge_u64 s[4:5], v[2:3]
// GFX10: encoding: [0x04,0x04,0xec,0x7d]

v_cmpx_ge_u64 s[100:101], v[2:3]
// GFX10: encoding: [0x64,0x04,0xec,0x7d]

v_cmpx_ge_u64 vcc, v[2:3]
// GFX10: encoding: [0x6a,0x04,0xec,0x7d]

v_cmpx_ge_u64 exec, v[2:3]
// GFX10: encoding: [0x7e,0x04,0xec,0x7d]

v_cmpx_ge_u64 0, v[2:3]
// GFX10: encoding: [0x80,0x04,0xec,0x7d]

v_cmpx_ge_u64 -1, v[2:3]
// GFX10: encoding: [0xc1,0x04,0xec,0x7d]

v_cmpx_ge_u64 0.5, v[2:3]
// GFX10: encoding: [0xf0,0x04,0xec,0x7d]

v_cmpx_ge_u64 -4.0, v[2:3]
// GFX10: encoding: [0xf7,0x04,0xec,0x7d]

v_cmpx_ge_u64 0xaf123456, v[2:3]
// GFX10: encoding: [0xff,0x04,0xec,0x7d,0x56,0x34,0x12,0xaf]

v_cmpx_ge_u64 0x3f717273, v[2:3]
// GFX10: encoding: [0xff,0x04,0xec,0x7d,0x73,0x72,0x71,0x3f]

v_cmpx_ge_u64 v[1:2], v[254:255]
// GFX10: encoding: [0x01,0xfd,0xed,0x7d]

v_cmpx_ge_u64_e64 v[1:2], v[2:3]
// GFX10: encoding: [0x00,0x00,0xf6,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_ge_u64_e64 v[254:255], v[2:3]
// GFX10: encoding: [0x00,0x00,0xf6,0xd4,0xfe,0x05,0x02,0x00]

v_cmpx_ge_u64_e64 s[2:3], v[2:3]
// GFX10: encoding: [0x00,0x00,0xf6,0xd4,0x02,0x04,0x02,0x00]

v_cmpx_ge_u64_e64 s[4:5], v[2:3]
// GFX10: encoding: [0x00,0x00,0xf6,0xd4,0x04,0x04,0x02,0x00]

v_cmpx_ge_u64_e64 vcc, v[2:3]
// GFX10: encoding: [0x00,0x00,0xf6,0xd4,0x6a,0x04,0x02,0x00]

v_cmpx_ge_u64_e64 0, v[2:3]
// GFX10: encoding: [0x00,0x00,0xf6,0xd4,0x80,0x04,0x02,0x00]

v_cmpx_ge_u64_e64 -1, v[2:3]
// GFX10: encoding: [0x00,0x00,0xf6,0xd4,0xc1,0x04,0x02,0x00]

v_cmpx_ge_u64_e64 0.5, v[2:3]
// GFX10: encoding: [0x00,0x00,0xf6,0xd4,0xf0,0x04,0x02,0x00]

v_cmpx_ge_u64_e64 -4.0, v[2:3]
// GFX10: encoding: [0x00,0x00,0xf6,0xd4,0xf7,0x04,0x02,0x00]

v_cmpx_ge_u64_e64 v[1:2], v[254:255]
// GFX10: encoding: [0x00,0x00,0xf6,0xd4,0x01,0xfd,0x03,0x00]

v_cmpx_ge_u64_e64 v[1:2], s[4:5]
// GFX10: encoding: [0x00,0x00,0xf6,0xd4,0x01,0x09,0x00,0x00]

v_cmpx_ge_u64_e64 v[1:2], s[6:7]
// GFX10: encoding: [0x00,0x00,0xf6,0xd4,0x01,0x0d,0x00,0x00]

v_cmpx_ge_u64_e64 v[1:2], s[100:101]
// GFX10: encoding: [0x00,0x00,0xf6,0xd4,0x01,0xc9,0x00,0x00]

v_cmpx_ge_u64_e64 v[1:2], vcc
// GFX10: encoding: [0x00,0x00,0xf6,0xd4,0x01,0xd5,0x00,0x00]

v_cmpx_ge_u64_e64 v[1:2], exec
// GFX10: encoding: [0x00,0x00,0xf6,0xd4,0x01,0xfd,0x00,0x00]

v_cmpx_ge_u64_e64 v[1:2], 0
// GFX10: encoding: [0x00,0x00,0xf6,0xd4,0x01,0x01,0x01,0x00]

v_cmpx_ge_u64_e64 v[1:2], -1
// GFX10: encoding: [0x00,0x00,0xf6,0xd4,0x01,0x83,0x01,0x00]

v_cmpx_ge_u64_e64 v[1:2], 0.5
// GFX10: encoding: [0x00,0x00,0xf6,0xd4,0x01,0xe1,0x01,0x00]

v_cmpx_ge_u64_e64 v[1:2], -4.0
// GFX10: encoding: [0x00,0x00,0xf6,0xd4,0x01,0xef,0x01,0x00]

v_cmpx_t_u64 v[1:2], v[2:3]
// GFX10: encoding: [0x01,0x05,0xee,0x7d]

v_cmpx_t_u64 v[254:255], v[2:3]
// GFX10: encoding: [0xfe,0x05,0xee,0x7d]

v_cmpx_t_u64 s[2:3], v[2:3]
// GFX10: encoding: [0x02,0x04,0xee,0x7d]

v_cmpx_t_u64 s[4:5], v[2:3]
// GFX10: encoding: [0x04,0x04,0xee,0x7d]

v_cmpx_t_u64 s[100:101], v[2:3]
// GFX10: encoding: [0x64,0x04,0xee,0x7d]

v_cmpx_t_u64 vcc, v[2:3]
// GFX10: encoding: [0x6a,0x04,0xee,0x7d]

v_cmpx_t_u64 exec, v[2:3]
// GFX10: encoding: [0x7e,0x04,0xee,0x7d]

v_cmpx_t_u64 0, v[2:3]
// GFX10: encoding: [0x80,0x04,0xee,0x7d]

v_cmpx_t_u64 -1, v[2:3]
// GFX10: encoding: [0xc1,0x04,0xee,0x7d]

v_cmpx_t_u64 0.5, v[2:3]
// GFX10: encoding: [0xf0,0x04,0xee,0x7d]

v_cmpx_t_u64 -4.0, v[2:3]
// GFX10: encoding: [0xf7,0x04,0xee,0x7d]

v_cmpx_t_u64 0xaf123456, v[2:3]
// GFX10: encoding: [0xff,0x04,0xee,0x7d,0x56,0x34,0x12,0xaf]

v_cmpx_t_u64 0x3f717273, v[2:3]
// GFX10: encoding: [0xff,0x04,0xee,0x7d,0x73,0x72,0x71,0x3f]

v_cmpx_t_u64 v[1:2], v[254:255]
// GFX10: encoding: [0x01,0xfd,0xef,0x7d]

v_cmpx_t_u64_e64 v[1:2], v[2:3]
// GFX10: encoding: [0x00,0x00,0xf7,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_t_u64_e64 v[254:255], v[2:3]
// GFX10: encoding: [0x00,0x00,0xf7,0xd4,0xfe,0x05,0x02,0x00]

v_cmpx_t_u64_e64 s[2:3], v[2:3]
// GFX10: encoding: [0x00,0x00,0xf7,0xd4,0x02,0x04,0x02,0x00]

v_cmpx_t_u64_e64 s[4:5], v[2:3]
// GFX10: encoding: [0x00,0x00,0xf7,0xd4,0x04,0x04,0x02,0x00]

v_cmpx_t_u64_e64 vcc, v[2:3]
// GFX10: encoding: [0x00,0x00,0xf7,0xd4,0x6a,0x04,0x02,0x00]

v_cmpx_t_u64_e64 0, v[2:3]
// GFX10: encoding: [0x00,0x00,0xf7,0xd4,0x80,0x04,0x02,0x00]

v_cmpx_t_u64_e64 -1, v[2:3]
// GFX10: encoding: [0x00,0x00,0xf7,0xd4,0xc1,0x04,0x02,0x00]

v_cmpx_t_u64_e64 0.5, v[2:3]
// GFX10: encoding: [0x00,0x00,0xf7,0xd4,0xf0,0x04,0x02,0x00]

v_cmpx_t_u64_e64 -4.0, v[2:3]
// GFX10: encoding: [0x00,0x00,0xf7,0xd4,0xf7,0x04,0x02,0x00]

v_cmpx_t_u64_e64 v[1:2], v[254:255]
// GFX10: encoding: [0x00,0x00,0xf7,0xd4,0x01,0xfd,0x03,0x00]

v_cmpx_t_u64_e64 v[1:2], s[4:5]
// GFX10: encoding: [0x00,0x00,0xf7,0xd4,0x01,0x09,0x00,0x00]

v_cmpx_t_u64_e64 v[1:2], s[6:7]
// GFX10: encoding: [0x00,0x00,0xf7,0xd4,0x01,0x0d,0x00,0x00]

v_cmpx_t_u64_e64 v[1:2], s[100:101]
// GFX10: encoding: [0x00,0x00,0xf7,0xd4,0x01,0xc9,0x00,0x00]

v_cmpx_t_u64_e64 v[1:2], vcc
// GFX10: encoding: [0x00,0x00,0xf7,0xd4,0x01,0xd5,0x00,0x00]

v_cmpx_t_u64_e64 v[1:2], exec
// GFX10: encoding: [0x00,0x00,0xf7,0xd4,0x01,0xfd,0x00,0x00]

v_cmpx_t_u64_e64 v[1:2], 0
// GFX10: encoding: [0x00,0x00,0xf7,0xd4,0x01,0x01,0x01,0x00]

v_cmpx_t_u64_e64 v[1:2], -1
// GFX10: encoding: [0x00,0x00,0xf7,0xd4,0x01,0x83,0x01,0x00]

v_cmpx_t_u64_e64 v[1:2], 0.5
// GFX10: encoding: [0x00,0x00,0xf7,0xd4,0x01,0xe1,0x01,0x00]

v_cmpx_t_u64_e64 v[1:2], -4.0
// GFX10: encoding: [0x00,0x00,0xf7,0xd4,0x01,0xef,0x01,0x00]

v_cmpx_u_f16 v1, v2
// GFX10: encoding: [0x01,0x05,0xf0,0x7d]

v_cmpx_u_f16 v255, v2
// GFX10: encoding: [0xff,0x05,0xf0,0x7d]

v_cmpx_u_f16 s1, v2
// GFX10: encoding: [0x01,0x04,0xf0,0x7d]

v_cmpx_u_f16 s101, v2
// GFX10: encoding: [0x65,0x04,0xf0,0x7d]

v_cmpx_u_f16 vcc_lo, v2
// GFX10: encoding: [0x6a,0x04,0xf0,0x7d]

v_cmpx_u_f16 vcc_hi, v2
// GFX10: encoding: [0x6b,0x04,0xf0,0x7d]

v_cmpx_u_f16 m0, v2
// GFX10: encoding: [0x7c,0x04,0xf0,0x7d]

v_cmpx_u_f16 exec_lo, v2
// GFX10: encoding: [0x7e,0x04,0xf0,0x7d]

v_cmpx_u_f16 exec_hi, v2
// GFX10: encoding: [0x7f,0x04,0xf0,0x7d]

v_cmpx_u_f16 0, v2
// GFX10: encoding: [0x80,0x04,0xf0,0x7d]

v_cmpx_u_f16 -1, v2
// GFX10: encoding: [0xc1,0x04,0xf0,0x7d]

v_cmpx_u_f16 0.5, v2
// GFX10: encoding: [0xf0,0x04,0xf0,0x7d]

v_cmpx_u_f16 -4.0, v2
// GFX10: encoding: [0xf7,0x04,0xf0,0x7d]

v_cmpx_u_f16 0xfe0b, v2
// GFX10: encoding: [0xff,0x04,0xf0,0x7d,0x0b,0xfe,0x00,0x00]

v_cmpx_u_f16 0x3456, v2
// GFX10: encoding: [0xff,0x04,0xf0,0x7d,0x56,0x34,0x00,0x00]

v_cmpx_u_f16 v1, v255
// GFX10: encoding: [0x01,0xff,0xf1,0x7d]

v_cmpx_u_f16_e64 v1, v2
// GFX10: encoding: [0x00,0x00,0xf8,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_u_f16_e64 v255, v2
// GFX10: encoding: [0x00,0x00,0xf8,0xd4,0xff,0x05,0x02,0x00]

v_cmpx_u_f16_e64 s1, v2
// GFX10: encoding: [0x00,0x00,0xf8,0xd4,0x01,0x04,0x02,0x00]

v_cmpx_u_f16_e64 s101, v2
// GFX10: encoding: [0x00,0x00,0xf8,0xd4,0x65,0x04,0x02,0x00]

v_cmpx_u_f16_e64 vcc_lo, v2
// GFX10: encoding: [0x00,0x00,0xf8,0xd4,0x6a,0x04,0x02,0x00]

v_cmpx_u_f16_e64 vcc_hi, v2
// GFX10: encoding: [0x00,0x00,0xf8,0xd4,0x6b,0x04,0x02,0x00]

v_cmpx_u_f16_e64 m0, v2
// GFX10: encoding: [0x00,0x00,0xf8,0xd4,0x7c,0x04,0x02,0x00]

v_cmpx_u_f16_e64 exec_lo, v2
// GFX10: encoding: [0x00,0x00,0xf8,0xd4,0x7e,0x04,0x02,0x00]

v_cmpx_u_f16_e64 exec_hi, v2
// GFX10: encoding: [0x00,0x00,0xf8,0xd4,0x7f,0x04,0x02,0x00]

v_cmpx_u_f16_e64 0, v2
// GFX10: encoding: [0x00,0x00,0xf8,0xd4,0x80,0x04,0x02,0x00]

v_cmpx_u_f16_e64 -1, v2
// GFX10: encoding: [0x00,0x00,0xf8,0xd4,0xc1,0x04,0x02,0x00]

v_cmpx_u_f16_e64 0.5, v2
// GFX10: encoding: [0x00,0x00,0xf8,0xd4,0xf0,0x04,0x02,0x00]

v_cmpx_u_f16_e64 -4.0, v2
// GFX10: encoding: [0x00,0x00,0xf8,0xd4,0xf7,0x04,0x02,0x00]

v_cmpx_u_f16_e64 v1, v255
// GFX10: encoding: [0x00,0x00,0xf8,0xd4,0x01,0xff,0x03,0x00]

v_cmpx_u_f16_e64 v1, s2
// GFX10: encoding: [0x00,0x00,0xf8,0xd4,0x01,0x05,0x00,0x00]

v_cmpx_u_f16_e64 v1, s101
// GFX10: encoding: [0x00,0x00,0xf8,0xd4,0x01,0xcb,0x00,0x00]

v_cmpx_u_f16_e64 v1, vcc_lo
// GFX10: encoding: [0x00,0x00,0xf8,0xd4,0x01,0xd5,0x00,0x00]

v_cmpx_u_f16_e64 v1, vcc_hi
// GFX10: encoding: [0x00,0x00,0xf8,0xd4,0x01,0xd7,0x00,0x00]

v_cmpx_u_f16_e64 v1, m0
// GFX10: encoding: [0x00,0x00,0xf8,0xd4,0x01,0xf9,0x00,0x00]

v_cmpx_u_f16_e64 v1, exec_lo
// GFX10: encoding: [0x00,0x00,0xf8,0xd4,0x01,0xfd,0x00,0x00]

v_cmpx_u_f16_e64 v1, exec_hi
// GFX10: encoding: [0x00,0x00,0xf8,0xd4,0x01,0xff,0x00,0x00]

v_cmpx_u_f16_e64 v1, 0
// GFX10: encoding: [0x00,0x00,0xf8,0xd4,0x01,0x01,0x01,0x00]

v_cmpx_u_f16_e64 v1, -1
// GFX10: encoding: [0x00,0x00,0xf8,0xd4,0x01,0x83,0x01,0x00]

v_cmpx_u_f16_e64 v1, 0.5
// GFX10: encoding: [0x00,0x00,0xf8,0xd4,0x01,0xe1,0x01,0x00]

v_cmpx_u_f16_e64 v1, -4.0
// GFX10: encoding: [0x00,0x00,0xf8,0xd4,0x01,0xef,0x01,0x00]

v_cmpx_u_f16_e64 -v1, v2
// GFX10: encoding: [0x00,0x00,0xf8,0xd4,0x01,0x05,0x02,0x20]

v_cmpx_u_f16_e64 v1, -v2
// GFX10: encoding: [0x00,0x00,0xf8,0xd4,0x01,0x05,0x02,0x40]

v_cmpx_u_f16_e64 -v1, -v2
// GFX10: encoding: [0x00,0x00,0xf8,0xd4,0x01,0x05,0x02,0x60]

v_cmpx_nge_f16 v1, v2
// GFX10: encoding: [0x01,0x05,0xf2,0x7d]

v_cmpx_nge_f16 v255, v2
// GFX10: encoding: [0xff,0x05,0xf2,0x7d]

v_cmpx_nge_f16 s1, v2
// GFX10: encoding: [0x01,0x04,0xf2,0x7d]

v_cmpx_nge_f16 s101, v2
// GFX10: encoding: [0x65,0x04,0xf2,0x7d]

v_cmpx_nge_f16 vcc_lo, v2
// GFX10: encoding: [0x6a,0x04,0xf2,0x7d]

v_cmpx_nge_f16 vcc_hi, v2
// GFX10: encoding: [0x6b,0x04,0xf2,0x7d]

v_cmpx_nge_f16 m0, v2
// GFX10: encoding: [0x7c,0x04,0xf2,0x7d]

v_cmpx_nge_f16 exec_lo, v2
// GFX10: encoding: [0x7e,0x04,0xf2,0x7d]

v_cmpx_nge_f16 exec_hi, v2
// GFX10: encoding: [0x7f,0x04,0xf2,0x7d]

v_cmpx_nge_f16 0, v2
// GFX10: encoding: [0x80,0x04,0xf2,0x7d]

v_cmpx_nge_f16 -1, v2
// GFX10: encoding: [0xc1,0x04,0xf2,0x7d]

v_cmpx_nge_f16 0.5, v2
// GFX10: encoding: [0xf0,0x04,0xf2,0x7d]

v_cmpx_nge_f16 -4.0, v2
// GFX10: encoding: [0xf7,0x04,0xf2,0x7d]

v_cmpx_nge_f16 0xfe0b, v2
// GFX10: encoding: [0xff,0x04,0xf2,0x7d,0x0b,0xfe,0x00,0x00]

v_cmpx_nge_f16 0x3456, v2
// GFX10: encoding: [0xff,0x04,0xf2,0x7d,0x56,0x34,0x00,0x00]

v_cmpx_nge_f16 v1, v255
// GFX10: encoding: [0x01,0xff,0xf3,0x7d]

v_cmpx_nge_f16_e64 v1, v2
// GFX10: encoding: [0x00,0x00,0xf9,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_nge_f16_e64 v255, v2
// GFX10: encoding: [0x00,0x00,0xf9,0xd4,0xff,0x05,0x02,0x00]

v_cmpx_nge_f16_e64 s1, v2
// GFX10: encoding: [0x00,0x00,0xf9,0xd4,0x01,0x04,0x02,0x00]

v_cmpx_nge_f16_e64 s101, v2
// GFX10: encoding: [0x00,0x00,0xf9,0xd4,0x65,0x04,0x02,0x00]

v_cmpx_nge_f16_e64 vcc_lo, v2
// GFX10: encoding: [0x00,0x00,0xf9,0xd4,0x6a,0x04,0x02,0x00]

v_cmpx_nge_f16_e64 vcc_hi, v2
// GFX10: encoding: [0x00,0x00,0xf9,0xd4,0x6b,0x04,0x02,0x00]

v_cmpx_nge_f16_e64 m0, v2
// GFX10: encoding: [0x00,0x00,0xf9,0xd4,0x7c,0x04,0x02,0x00]

v_cmpx_nge_f16_e64 exec_lo, v2
// GFX10: encoding: [0x00,0x00,0xf9,0xd4,0x7e,0x04,0x02,0x00]

v_cmpx_nge_f16_e64 exec_hi, v2
// GFX10: encoding: [0x00,0x00,0xf9,0xd4,0x7f,0x04,0x02,0x00]

v_cmpx_nge_f16_e64 0, v2
// GFX10: encoding: [0x00,0x00,0xf9,0xd4,0x80,0x04,0x02,0x00]

v_cmpx_nge_f16_e64 -1, v2
// GFX10: encoding: [0x00,0x00,0xf9,0xd4,0xc1,0x04,0x02,0x00]

v_cmpx_nge_f16_e64 0.5, v2
// GFX10: encoding: [0x00,0x00,0xf9,0xd4,0xf0,0x04,0x02,0x00]

v_cmpx_nge_f16_e64 -4.0, v2
// GFX10: encoding: [0x00,0x00,0xf9,0xd4,0xf7,0x04,0x02,0x00]

v_cmpx_nge_f16_e64 v1, v255
// GFX10: encoding: [0x00,0x00,0xf9,0xd4,0x01,0xff,0x03,0x00]

v_cmpx_nge_f16_e64 v1, s2
// GFX10: encoding: [0x00,0x00,0xf9,0xd4,0x01,0x05,0x00,0x00]

v_cmpx_nge_f16_e64 v1, s101
// GFX10: encoding: [0x00,0x00,0xf9,0xd4,0x01,0xcb,0x00,0x00]

v_cmpx_nge_f16_e64 v1, vcc_lo
// GFX10: encoding: [0x00,0x00,0xf9,0xd4,0x01,0xd5,0x00,0x00]

v_cmpx_nge_f16_e64 v1, vcc_hi
// GFX10: encoding: [0x00,0x00,0xf9,0xd4,0x01,0xd7,0x00,0x00]

v_cmpx_nge_f16_e64 v1, m0
// GFX10: encoding: [0x00,0x00,0xf9,0xd4,0x01,0xf9,0x00,0x00]

v_cmpx_nge_f16_e64 v1, exec_lo
// GFX10: encoding: [0x00,0x00,0xf9,0xd4,0x01,0xfd,0x00,0x00]

v_cmpx_nge_f16_e64 v1, exec_hi
// GFX10: encoding: [0x00,0x00,0xf9,0xd4,0x01,0xff,0x00,0x00]

v_cmpx_nge_f16_e64 v1, 0
// GFX10: encoding: [0x00,0x00,0xf9,0xd4,0x01,0x01,0x01,0x00]

v_cmpx_nge_f16_e64 v1, -1
// GFX10: encoding: [0x00,0x00,0xf9,0xd4,0x01,0x83,0x01,0x00]

v_cmpx_nge_f16_e64 v1, 0.5
// GFX10: encoding: [0x00,0x00,0xf9,0xd4,0x01,0xe1,0x01,0x00]

v_cmpx_nge_f16_e64 v1, -4.0
// GFX10: encoding: [0x00,0x00,0xf9,0xd4,0x01,0xef,0x01,0x00]

v_cmpx_nge_f16_e64 -v1, v2
// GFX10: encoding: [0x00,0x00,0xf9,0xd4,0x01,0x05,0x02,0x20]

v_cmpx_nge_f16_e64 v1, -v2
// GFX10: encoding: [0x00,0x00,0xf9,0xd4,0x01,0x05,0x02,0x40]

v_cmpx_nge_f16_e64 -v1, -v2
// GFX10: encoding: [0x00,0x00,0xf9,0xd4,0x01,0x05,0x02,0x60]

v_cmpx_nlg_f16 v1, v2
// GFX10: encoding: [0x01,0x05,0xf4,0x7d]

v_cmpx_nlg_f16 v255, v2
// GFX10: encoding: [0xff,0x05,0xf4,0x7d]

v_cmpx_nlg_f16 s1, v2
// GFX10: encoding: [0x01,0x04,0xf4,0x7d]

v_cmpx_nlg_f16 s101, v2
// GFX10: encoding: [0x65,0x04,0xf4,0x7d]

v_cmpx_nlg_f16 vcc_lo, v2
// GFX10: encoding: [0x6a,0x04,0xf4,0x7d]

v_cmpx_nlg_f16 vcc_hi, v2
// GFX10: encoding: [0x6b,0x04,0xf4,0x7d]

v_cmpx_nlg_f16 m0, v2
// GFX10: encoding: [0x7c,0x04,0xf4,0x7d]

v_cmpx_nlg_f16 exec_lo, v2
// GFX10: encoding: [0x7e,0x04,0xf4,0x7d]

v_cmpx_nlg_f16 exec_hi, v2
// GFX10: encoding: [0x7f,0x04,0xf4,0x7d]

v_cmpx_nlg_f16 0, v2
// GFX10: encoding: [0x80,0x04,0xf4,0x7d]

v_cmpx_nlg_f16 -1, v2
// GFX10: encoding: [0xc1,0x04,0xf4,0x7d]

v_cmpx_nlg_f16 0.5, v2
// GFX10: encoding: [0xf0,0x04,0xf4,0x7d]

v_cmpx_nlg_f16 -4.0, v2
// GFX10: encoding: [0xf7,0x04,0xf4,0x7d]

v_cmpx_nlg_f16 0xfe0b, v2
// GFX10: encoding: [0xff,0x04,0xf4,0x7d,0x0b,0xfe,0x00,0x00]

v_cmpx_nlg_f16 0x3456, v2
// GFX10: encoding: [0xff,0x04,0xf4,0x7d,0x56,0x34,0x00,0x00]

v_cmpx_nlg_f16 v1, v255
// GFX10: encoding: [0x01,0xff,0xf5,0x7d]

v_cmpx_nlg_f16_e64 v1, v2
// GFX10: encoding: [0x00,0x00,0xfa,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_nlg_f16_e64 v255, v2
// GFX10: encoding: [0x00,0x00,0xfa,0xd4,0xff,0x05,0x02,0x00]

v_cmpx_nlg_f16_e64 s1, v2
// GFX10: encoding: [0x00,0x00,0xfa,0xd4,0x01,0x04,0x02,0x00]

v_cmpx_nlg_f16_e64 s101, v2
// GFX10: encoding: [0x00,0x00,0xfa,0xd4,0x65,0x04,0x02,0x00]

v_cmpx_nlg_f16_e64 vcc_lo, v2
// GFX10: encoding: [0x00,0x00,0xfa,0xd4,0x6a,0x04,0x02,0x00]

v_cmpx_nlg_f16_e64 vcc_hi, v2
// GFX10: encoding: [0x00,0x00,0xfa,0xd4,0x6b,0x04,0x02,0x00]

v_cmpx_nlg_f16_e64 m0, v2
// GFX10: encoding: [0x00,0x00,0xfa,0xd4,0x7c,0x04,0x02,0x00]

v_cmpx_nlg_f16_e64 exec_lo, v2
// GFX10: encoding: [0x00,0x00,0xfa,0xd4,0x7e,0x04,0x02,0x00]

v_cmpx_nlg_f16_e64 exec_hi, v2
// GFX10: encoding: [0x00,0x00,0xfa,0xd4,0x7f,0x04,0x02,0x00]

v_cmpx_nlg_f16_e64 0, v2
// GFX10: encoding: [0x00,0x00,0xfa,0xd4,0x80,0x04,0x02,0x00]

v_cmpx_nlg_f16_e64 -1, v2
// GFX10: encoding: [0x00,0x00,0xfa,0xd4,0xc1,0x04,0x02,0x00]

v_cmpx_nlg_f16_e64 0.5, v2
// GFX10: encoding: [0x00,0x00,0xfa,0xd4,0xf0,0x04,0x02,0x00]

v_cmpx_nlg_f16_e64 -4.0, v2
// GFX10: encoding: [0x00,0x00,0xfa,0xd4,0xf7,0x04,0x02,0x00]

v_cmpx_nlg_f16_e64 v1, v255
// GFX10: encoding: [0x00,0x00,0xfa,0xd4,0x01,0xff,0x03,0x00]

v_cmpx_nlg_f16_e64 v1, s2
// GFX10: encoding: [0x00,0x00,0xfa,0xd4,0x01,0x05,0x00,0x00]

v_cmpx_nlg_f16_e64 v1, s101
// GFX10: encoding: [0x00,0x00,0xfa,0xd4,0x01,0xcb,0x00,0x00]

v_cmpx_nlg_f16_e64 v1, vcc_lo
// GFX10: encoding: [0x00,0x00,0xfa,0xd4,0x01,0xd5,0x00,0x00]

v_cmpx_nlg_f16_e64 v1, vcc_hi
// GFX10: encoding: [0x00,0x00,0xfa,0xd4,0x01,0xd7,0x00,0x00]

v_cmpx_nlg_f16_e64 v1, m0
// GFX10: encoding: [0x00,0x00,0xfa,0xd4,0x01,0xf9,0x00,0x00]

v_cmpx_nlg_f16_e64 v1, exec_lo
// GFX10: encoding: [0x00,0x00,0xfa,0xd4,0x01,0xfd,0x00,0x00]

v_cmpx_nlg_f16_e64 v1, exec_hi
// GFX10: encoding: [0x00,0x00,0xfa,0xd4,0x01,0xff,0x00,0x00]

v_cmpx_nlg_f16_e64 v1, 0
// GFX10: encoding: [0x00,0x00,0xfa,0xd4,0x01,0x01,0x01,0x00]

v_cmpx_nlg_f16_e64 v1, -1
// GFX10: encoding: [0x00,0x00,0xfa,0xd4,0x01,0x83,0x01,0x00]

v_cmpx_nlg_f16_e64 v1, 0.5
// GFX10: encoding: [0x00,0x00,0xfa,0xd4,0x01,0xe1,0x01,0x00]

v_cmpx_nlg_f16_e64 v1, -4.0
// GFX10: encoding: [0x00,0x00,0xfa,0xd4,0x01,0xef,0x01,0x00]

v_cmpx_nlg_f16_e64 -v1, v2
// GFX10: encoding: [0x00,0x00,0xfa,0xd4,0x01,0x05,0x02,0x20]

v_cmpx_nlg_f16_e64 v1, -v2
// GFX10: encoding: [0x00,0x00,0xfa,0xd4,0x01,0x05,0x02,0x40]

v_cmpx_nlg_f16_e64 -v1, -v2
// GFX10: encoding: [0x00,0x00,0xfa,0xd4,0x01,0x05,0x02,0x60]

v_cmpx_ngt_f16 v1, v2
// GFX10: encoding: [0x01,0x05,0xf6,0x7d]

v_cmpx_ngt_f16 v255, v2
// GFX10: encoding: [0xff,0x05,0xf6,0x7d]

v_cmpx_ngt_f16 s1, v2
// GFX10: encoding: [0x01,0x04,0xf6,0x7d]

v_cmpx_ngt_f16 s101, v2
// GFX10: encoding: [0x65,0x04,0xf6,0x7d]

v_cmpx_ngt_f16 vcc_lo, v2
// GFX10: encoding: [0x6a,0x04,0xf6,0x7d]

v_cmpx_ngt_f16 vcc_hi, v2
// GFX10: encoding: [0x6b,0x04,0xf6,0x7d]

v_cmpx_ngt_f16 m0, v2
// GFX10: encoding: [0x7c,0x04,0xf6,0x7d]

v_cmpx_ngt_f16 exec_lo, v2
// GFX10: encoding: [0x7e,0x04,0xf6,0x7d]

v_cmpx_ngt_f16 exec_hi, v2
// GFX10: encoding: [0x7f,0x04,0xf6,0x7d]

v_cmpx_ngt_f16 0, v2
// GFX10: encoding: [0x80,0x04,0xf6,0x7d]

v_cmpx_ngt_f16 -1, v2
// GFX10: encoding: [0xc1,0x04,0xf6,0x7d]

v_cmpx_ngt_f16 0.5, v2
// GFX10: encoding: [0xf0,0x04,0xf6,0x7d]

v_cmpx_ngt_f16 -4.0, v2
// GFX10: encoding: [0xf7,0x04,0xf6,0x7d]

v_cmpx_ngt_f16 0xfe0b, v2
// GFX10: encoding: [0xff,0x04,0xf6,0x7d,0x0b,0xfe,0x00,0x00]

v_cmpx_ngt_f16 0x3456, v2
// GFX10: encoding: [0xff,0x04,0xf6,0x7d,0x56,0x34,0x00,0x00]

v_cmpx_ngt_f16 v1, v255
// GFX10: encoding: [0x01,0xff,0xf7,0x7d]

v_cmpx_ngt_f16_e64 v1, v2
// GFX10: encoding: [0x00,0x00,0xfb,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_ngt_f16_e64 v255, v2
// GFX10: encoding: [0x00,0x00,0xfb,0xd4,0xff,0x05,0x02,0x00]

v_cmpx_ngt_f16_e64 s1, v2
// GFX10: encoding: [0x00,0x00,0xfb,0xd4,0x01,0x04,0x02,0x00]

v_cmpx_ngt_f16_e64 s101, v2
// GFX10: encoding: [0x00,0x00,0xfb,0xd4,0x65,0x04,0x02,0x00]

v_cmpx_ngt_f16_e64 vcc_lo, v2
// GFX10: encoding: [0x00,0x00,0xfb,0xd4,0x6a,0x04,0x02,0x00]

v_cmpx_ngt_f16_e64 vcc_hi, v2
// GFX10: encoding: [0x00,0x00,0xfb,0xd4,0x6b,0x04,0x02,0x00]

v_cmpx_ngt_f16_e64 m0, v2
// GFX10: encoding: [0x00,0x00,0xfb,0xd4,0x7c,0x04,0x02,0x00]

v_cmpx_ngt_f16_e64 exec_lo, v2
// GFX10: encoding: [0x00,0x00,0xfb,0xd4,0x7e,0x04,0x02,0x00]

v_cmpx_ngt_f16_e64 exec_hi, v2
// GFX10: encoding: [0x00,0x00,0xfb,0xd4,0x7f,0x04,0x02,0x00]

v_cmpx_ngt_f16_e64 0, v2
// GFX10: encoding: [0x00,0x00,0xfb,0xd4,0x80,0x04,0x02,0x00]

v_cmpx_ngt_f16_e64 -1, v2
// GFX10: encoding: [0x00,0x00,0xfb,0xd4,0xc1,0x04,0x02,0x00]

v_cmpx_ngt_f16_e64 0.5, v2
// GFX10: encoding: [0x00,0x00,0xfb,0xd4,0xf0,0x04,0x02,0x00]

v_cmpx_ngt_f16_e64 -4.0, v2
// GFX10: encoding: [0x00,0x00,0xfb,0xd4,0xf7,0x04,0x02,0x00]

v_cmpx_ngt_f16_e64 v1, v255
// GFX10: encoding: [0x00,0x00,0xfb,0xd4,0x01,0xff,0x03,0x00]

v_cmpx_ngt_f16_e64 v1, s2
// GFX10: encoding: [0x00,0x00,0xfb,0xd4,0x01,0x05,0x00,0x00]

v_cmpx_ngt_f16_e64 v1, s101
// GFX10: encoding: [0x00,0x00,0xfb,0xd4,0x01,0xcb,0x00,0x00]

v_cmpx_ngt_f16_e64 v1, vcc_lo
// GFX10: encoding: [0x00,0x00,0xfb,0xd4,0x01,0xd5,0x00,0x00]

v_cmpx_ngt_f16_e64 v1, vcc_hi
// GFX10: encoding: [0x00,0x00,0xfb,0xd4,0x01,0xd7,0x00,0x00]

v_cmpx_ngt_f16_e64 v1, m0
// GFX10: encoding: [0x00,0x00,0xfb,0xd4,0x01,0xf9,0x00,0x00]

v_cmpx_ngt_f16_e64 v1, exec_lo
// GFX10: encoding: [0x00,0x00,0xfb,0xd4,0x01,0xfd,0x00,0x00]

v_cmpx_ngt_f16_e64 v1, exec_hi
// GFX10: encoding: [0x00,0x00,0xfb,0xd4,0x01,0xff,0x00,0x00]

v_cmpx_ngt_f16_e64 v1, 0
// GFX10: encoding: [0x00,0x00,0xfb,0xd4,0x01,0x01,0x01,0x00]

v_cmpx_ngt_f16_e64 v1, -1
// GFX10: encoding: [0x00,0x00,0xfb,0xd4,0x01,0x83,0x01,0x00]

v_cmpx_ngt_f16_e64 v1, 0.5
// GFX10: encoding: [0x00,0x00,0xfb,0xd4,0x01,0xe1,0x01,0x00]

v_cmpx_ngt_f16_e64 v1, -4.0
// GFX10: encoding: [0x00,0x00,0xfb,0xd4,0x01,0xef,0x01,0x00]

v_cmpx_ngt_f16_e64 -v1, v2
// GFX10: encoding: [0x00,0x00,0xfb,0xd4,0x01,0x05,0x02,0x20]

v_cmpx_ngt_f16_e64 v1, -v2
// GFX10: encoding: [0x00,0x00,0xfb,0xd4,0x01,0x05,0x02,0x40]

v_cmpx_ngt_f16_e64 -v1, -v2
// GFX10: encoding: [0x00,0x00,0xfb,0xd4,0x01,0x05,0x02,0x60]

v_cmpx_nle_f16 v1, v2
// GFX10: encoding: [0x01,0x05,0xf8,0x7d]

v_cmpx_nle_f16 v255, v2
// GFX10: encoding: [0xff,0x05,0xf8,0x7d]

v_cmpx_nle_f16 s1, v2
// GFX10: encoding: [0x01,0x04,0xf8,0x7d]

v_cmpx_nle_f16 s101, v2
// GFX10: encoding: [0x65,0x04,0xf8,0x7d]

v_cmpx_nle_f16 vcc_lo, v2
// GFX10: encoding: [0x6a,0x04,0xf8,0x7d]

v_cmpx_nle_f16 vcc_hi, v2
// GFX10: encoding: [0x6b,0x04,0xf8,0x7d]

v_cmpx_nle_f16 m0, v2
// GFX10: encoding: [0x7c,0x04,0xf8,0x7d]

v_cmpx_nle_f16 exec_lo, v2
// GFX10: encoding: [0x7e,0x04,0xf8,0x7d]

v_cmpx_nle_f16 exec_hi, v2
// GFX10: encoding: [0x7f,0x04,0xf8,0x7d]

v_cmpx_nle_f16 0, v2
// GFX10: encoding: [0x80,0x04,0xf8,0x7d]

v_cmpx_nle_f16 -1, v2
// GFX10: encoding: [0xc1,0x04,0xf8,0x7d]

v_cmpx_nle_f16 0.5, v2
// GFX10: encoding: [0xf0,0x04,0xf8,0x7d]

v_cmpx_nle_f16 -4.0, v2
// GFX10: encoding: [0xf7,0x04,0xf8,0x7d]

v_cmpx_nle_f16 0xfe0b, v2
// GFX10: encoding: [0xff,0x04,0xf8,0x7d,0x0b,0xfe,0x00,0x00]

v_cmpx_nle_f16 0x3456, v2
// GFX10: encoding: [0xff,0x04,0xf8,0x7d,0x56,0x34,0x00,0x00]

v_cmpx_nle_f16 v1, v255
// GFX10: encoding: [0x01,0xff,0xf9,0x7d]

v_cmpx_nle_f16_e64 v1, v2
// GFX10: encoding: [0x00,0x00,0xfc,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_nle_f16_e64 v255, v2
// GFX10: encoding: [0x00,0x00,0xfc,0xd4,0xff,0x05,0x02,0x00]

v_cmpx_nle_f16_e64 s1, v2
// GFX10: encoding: [0x00,0x00,0xfc,0xd4,0x01,0x04,0x02,0x00]

v_cmpx_nle_f16_e64 s101, v2
// GFX10: encoding: [0x00,0x00,0xfc,0xd4,0x65,0x04,0x02,0x00]

v_cmpx_nle_f16_e64 vcc_lo, v2
// GFX10: encoding: [0x00,0x00,0xfc,0xd4,0x6a,0x04,0x02,0x00]

v_cmpx_nle_f16_e64 vcc_hi, v2
// GFX10: encoding: [0x00,0x00,0xfc,0xd4,0x6b,0x04,0x02,0x00]

v_cmpx_nle_f16_e64 m0, v2
// GFX10: encoding: [0x00,0x00,0xfc,0xd4,0x7c,0x04,0x02,0x00]

v_cmpx_nle_f16_e64 exec_lo, v2
// GFX10: encoding: [0x00,0x00,0xfc,0xd4,0x7e,0x04,0x02,0x00]

v_cmpx_nle_f16_e64 exec_hi, v2
// GFX10: encoding: [0x00,0x00,0xfc,0xd4,0x7f,0x04,0x02,0x00]

v_cmpx_nle_f16_e64 0, v2
// GFX10: encoding: [0x00,0x00,0xfc,0xd4,0x80,0x04,0x02,0x00]

v_cmpx_nle_f16_e64 -1, v2
// GFX10: encoding: [0x00,0x00,0xfc,0xd4,0xc1,0x04,0x02,0x00]

v_cmpx_nle_f16_e64 0.5, v2
// GFX10: encoding: [0x00,0x00,0xfc,0xd4,0xf0,0x04,0x02,0x00]

v_cmpx_nle_f16_e64 -4.0, v2
// GFX10: encoding: [0x00,0x00,0xfc,0xd4,0xf7,0x04,0x02,0x00]

v_cmpx_nle_f16_e64 v1, v255
// GFX10: encoding: [0x00,0x00,0xfc,0xd4,0x01,0xff,0x03,0x00]

v_cmpx_nle_f16_e64 v1, s2
// GFX10: encoding: [0x00,0x00,0xfc,0xd4,0x01,0x05,0x00,0x00]

v_cmpx_nle_f16_e64 v1, s101
// GFX10: encoding: [0x00,0x00,0xfc,0xd4,0x01,0xcb,0x00,0x00]

v_cmpx_nle_f16_e64 v1, vcc_lo
// GFX10: encoding: [0x00,0x00,0xfc,0xd4,0x01,0xd5,0x00,0x00]

v_cmpx_nle_f16_e64 v1, vcc_hi
// GFX10: encoding: [0x00,0x00,0xfc,0xd4,0x01,0xd7,0x00,0x00]

v_cmpx_nle_f16_e64 v1, m0
// GFX10: encoding: [0x00,0x00,0xfc,0xd4,0x01,0xf9,0x00,0x00]

v_cmpx_nle_f16_e64 v1, exec_lo
// GFX10: encoding: [0x00,0x00,0xfc,0xd4,0x01,0xfd,0x00,0x00]

v_cmpx_nle_f16_e64 v1, exec_hi
// GFX10: encoding: [0x00,0x00,0xfc,0xd4,0x01,0xff,0x00,0x00]

v_cmpx_nle_f16_e64 v1, 0
// GFX10: encoding: [0x00,0x00,0xfc,0xd4,0x01,0x01,0x01,0x00]

v_cmpx_nle_f16_e64 v1, -1
// GFX10: encoding: [0x00,0x00,0xfc,0xd4,0x01,0x83,0x01,0x00]

v_cmpx_nle_f16_e64 v1, 0.5
// GFX10: encoding: [0x00,0x00,0xfc,0xd4,0x01,0xe1,0x01,0x00]

v_cmpx_nle_f16_e64 v1, -4.0
// GFX10: encoding: [0x00,0x00,0xfc,0xd4,0x01,0xef,0x01,0x00]

v_cmpx_nle_f16_e64 -v1, v2
// GFX10: encoding: [0x00,0x00,0xfc,0xd4,0x01,0x05,0x02,0x20]

v_cmpx_nle_f16_e64 v1, -v2
// GFX10: encoding: [0x00,0x00,0xfc,0xd4,0x01,0x05,0x02,0x40]

v_cmpx_nle_f16_e64 -v1, -v2
// GFX10: encoding: [0x00,0x00,0xfc,0xd4,0x01,0x05,0x02,0x60]

v_cmpx_neq_f16 v1, v2
// GFX10: encoding: [0x01,0x05,0xfa,0x7d]

v_cmpx_neq_f16 v255, v2
// GFX10: encoding: [0xff,0x05,0xfa,0x7d]

v_cmpx_neq_f16 s1, v2
// GFX10: encoding: [0x01,0x04,0xfa,0x7d]

v_cmpx_neq_f16 s101, v2
// GFX10: encoding: [0x65,0x04,0xfa,0x7d]

v_cmpx_neq_f16 vcc_lo, v2
// GFX10: encoding: [0x6a,0x04,0xfa,0x7d]

v_cmpx_neq_f16 vcc_hi, v2
// GFX10: encoding: [0x6b,0x04,0xfa,0x7d]

v_cmpx_neq_f16 m0, v2
// GFX10: encoding: [0x7c,0x04,0xfa,0x7d]

v_cmpx_neq_f16 exec_lo, v2
// GFX10: encoding: [0x7e,0x04,0xfa,0x7d]

v_cmpx_neq_f16 exec_hi, v2
// GFX10: encoding: [0x7f,0x04,0xfa,0x7d]

v_cmpx_neq_f16 0, v2
// GFX10: encoding: [0x80,0x04,0xfa,0x7d]

v_cmpx_neq_f16 -1, v2
// GFX10: encoding: [0xc1,0x04,0xfa,0x7d]

v_cmpx_neq_f16 0.5, v2
// GFX10: encoding: [0xf0,0x04,0xfa,0x7d]

v_cmpx_neq_f16 -4.0, v2
// GFX10: encoding: [0xf7,0x04,0xfa,0x7d]

v_cmpx_neq_f16 0xfe0b, v2
// GFX10: encoding: [0xff,0x04,0xfa,0x7d,0x0b,0xfe,0x00,0x00]

v_cmpx_neq_f16 0x3456, v2
// GFX10: encoding: [0xff,0x04,0xfa,0x7d,0x56,0x34,0x00,0x00]

v_cmpx_neq_f16 v1, v255
// GFX10: encoding: [0x01,0xff,0xfb,0x7d]

v_cmpx_neq_f16_e64 v1, v2
// GFX10: encoding: [0x00,0x00,0xfd,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_neq_f16_e64 v255, v2
// GFX10: encoding: [0x00,0x00,0xfd,0xd4,0xff,0x05,0x02,0x00]

v_cmpx_neq_f16_e64 s1, v2
// GFX10: encoding: [0x00,0x00,0xfd,0xd4,0x01,0x04,0x02,0x00]

v_cmpx_neq_f16_e64 s101, v2
// GFX10: encoding: [0x00,0x00,0xfd,0xd4,0x65,0x04,0x02,0x00]

v_cmpx_neq_f16_e64 vcc_lo, v2
// GFX10: encoding: [0x00,0x00,0xfd,0xd4,0x6a,0x04,0x02,0x00]

v_cmpx_neq_f16_e64 vcc_hi, v2
// GFX10: encoding: [0x00,0x00,0xfd,0xd4,0x6b,0x04,0x02,0x00]

v_cmpx_neq_f16_e64 m0, v2
// GFX10: encoding: [0x00,0x00,0xfd,0xd4,0x7c,0x04,0x02,0x00]

v_cmpx_neq_f16_e64 exec_lo, v2
// GFX10: encoding: [0x00,0x00,0xfd,0xd4,0x7e,0x04,0x02,0x00]

v_cmpx_neq_f16_e64 exec_hi, v2
// GFX10: encoding: [0x00,0x00,0xfd,0xd4,0x7f,0x04,0x02,0x00]

v_cmpx_neq_f16_e64 0, v2
// GFX10: encoding: [0x00,0x00,0xfd,0xd4,0x80,0x04,0x02,0x00]

v_cmpx_neq_f16_e64 -1, v2
// GFX10: encoding: [0x00,0x00,0xfd,0xd4,0xc1,0x04,0x02,0x00]

v_cmpx_neq_f16_e64 0.5, v2
// GFX10: encoding: [0x00,0x00,0xfd,0xd4,0xf0,0x04,0x02,0x00]

v_cmpx_neq_f16_e64 -4.0, v2
// GFX10: encoding: [0x00,0x00,0xfd,0xd4,0xf7,0x04,0x02,0x00]

v_cmpx_neq_f16_e64 v1, v255
// GFX10: encoding: [0x00,0x00,0xfd,0xd4,0x01,0xff,0x03,0x00]

v_cmpx_neq_f16_e64 v1, s2
// GFX10: encoding: [0x00,0x00,0xfd,0xd4,0x01,0x05,0x00,0x00]

v_cmpx_neq_f16_e64 v1, s101
// GFX10: encoding: [0x00,0x00,0xfd,0xd4,0x01,0xcb,0x00,0x00]

v_cmpx_neq_f16_e64 v1, vcc_lo
// GFX10: encoding: [0x00,0x00,0xfd,0xd4,0x01,0xd5,0x00,0x00]

v_cmpx_neq_f16_e64 v1, vcc_hi
// GFX10: encoding: [0x00,0x00,0xfd,0xd4,0x01,0xd7,0x00,0x00]

v_cmpx_neq_f16_e64 v1, m0
// GFX10: encoding: [0x00,0x00,0xfd,0xd4,0x01,0xf9,0x00,0x00]

v_cmpx_neq_f16_e64 v1, exec_lo
// GFX10: encoding: [0x00,0x00,0xfd,0xd4,0x01,0xfd,0x00,0x00]

v_cmpx_neq_f16_e64 v1, exec_hi
// GFX10: encoding: [0x00,0x00,0xfd,0xd4,0x01,0xff,0x00,0x00]

v_cmpx_neq_f16_e64 v1, 0
// GFX10: encoding: [0x00,0x00,0xfd,0xd4,0x01,0x01,0x01,0x00]

v_cmpx_neq_f16_e64 v1, -1
// GFX10: encoding: [0x00,0x00,0xfd,0xd4,0x01,0x83,0x01,0x00]

v_cmpx_neq_f16_e64 v1, 0.5
// GFX10: encoding: [0x00,0x00,0xfd,0xd4,0x01,0xe1,0x01,0x00]

v_cmpx_neq_f16_e64 v1, -4.0
// GFX10: encoding: [0x00,0x00,0xfd,0xd4,0x01,0xef,0x01,0x00]

v_cmpx_neq_f16_e64 -v1, v2
// GFX10: encoding: [0x00,0x00,0xfd,0xd4,0x01,0x05,0x02,0x20]

v_cmpx_neq_f16_e64 v1, -v2
// GFX10: encoding: [0x00,0x00,0xfd,0xd4,0x01,0x05,0x02,0x40]

v_cmpx_neq_f16_e64 -v1, -v2
// GFX10: encoding: [0x00,0x00,0xfd,0xd4,0x01,0x05,0x02,0x60]

v_cmpx_nlt_f16 v1, v2
// GFX10: encoding: [0x01,0x05,0xfc,0x7d]

v_cmpx_nlt_f16 v255, v2
// GFX10: encoding: [0xff,0x05,0xfc,0x7d]

v_cmpx_nlt_f16 s1, v2
// GFX10: encoding: [0x01,0x04,0xfc,0x7d]

v_cmpx_nlt_f16 s101, v2
// GFX10: encoding: [0x65,0x04,0xfc,0x7d]

v_cmpx_nlt_f16 vcc_lo, v2
// GFX10: encoding: [0x6a,0x04,0xfc,0x7d]

v_cmpx_nlt_f16 vcc_hi, v2
// GFX10: encoding: [0x6b,0x04,0xfc,0x7d]

v_cmpx_nlt_f16 m0, v2
// GFX10: encoding: [0x7c,0x04,0xfc,0x7d]

v_cmpx_nlt_f16 exec_lo, v2
// GFX10: encoding: [0x7e,0x04,0xfc,0x7d]

v_cmpx_nlt_f16 exec_hi, v2
// GFX10: encoding: [0x7f,0x04,0xfc,0x7d]

v_cmpx_nlt_f16 0, v2
// GFX10: encoding: [0x80,0x04,0xfc,0x7d]

v_cmpx_nlt_f16 -1, v2
// GFX10: encoding: [0xc1,0x04,0xfc,0x7d]

v_cmpx_nlt_f16 0.5, v2
// GFX10: encoding: [0xf0,0x04,0xfc,0x7d]

v_cmpx_nlt_f16 -4.0, v2
// GFX10: encoding: [0xf7,0x04,0xfc,0x7d]

v_cmpx_nlt_f16 0xfe0b, v2
// GFX10: encoding: [0xff,0x04,0xfc,0x7d,0x0b,0xfe,0x00,0x00]

v_cmpx_nlt_f16 0x3456, v2
// GFX10: encoding: [0xff,0x04,0xfc,0x7d,0x56,0x34,0x00,0x00]

v_cmpx_nlt_f16 v1, v255
// GFX10: encoding: [0x01,0xff,0xfd,0x7d]

v_cmpx_nlt_f16_e64 v1, v2
// GFX10: encoding: [0x00,0x00,0xfe,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_nlt_f16_e64 v255, v2
// GFX10: encoding: [0x00,0x00,0xfe,0xd4,0xff,0x05,0x02,0x00]

v_cmpx_nlt_f16_e64 s1, v2
// GFX10: encoding: [0x00,0x00,0xfe,0xd4,0x01,0x04,0x02,0x00]

v_cmpx_nlt_f16_e64 s101, v2
// GFX10: encoding: [0x00,0x00,0xfe,0xd4,0x65,0x04,0x02,0x00]

v_cmpx_nlt_f16_e64 vcc_lo, v2
// GFX10: encoding: [0x00,0x00,0xfe,0xd4,0x6a,0x04,0x02,0x00]

v_cmpx_nlt_f16_e64 vcc_hi, v2
// GFX10: encoding: [0x00,0x00,0xfe,0xd4,0x6b,0x04,0x02,0x00]

v_cmpx_nlt_f16_e64 m0, v2
// GFX10: encoding: [0x00,0x00,0xfe,0xd4,0x7c,0x04,0x02,0x00]

v_cmpx_nlt_f16_e64 exec_lo, v2
// GFX10: encoding: [0x00,0x00,0xfe,0xd4,0x7e,0x04,0x02,0x00]

v_cmpx_nlt_f16_e64 exec_hi, v2
// GFX10: encoding: [0x00,0x00,0xfe,0xd4,0x7f,0x04,0x02,0x00]

v_cmpx_nlt_f16_e64 0, v2
// GFX10: encoding: [0x00,0x00,0xfe,0xd4,0x80,0x04,0x02,0x00]

v_cmpx_nlt_f16_e64 -1, v2
// GFX10: encoding: [0x00,0x00,0xfe,0xd4,0xc1,0x04,0x02,0x00]

v_cmpx_nlt_f16_e64 0.5, v2
// GFX10: encoding: [0x00,0x00,0xfe,0xd4,0xf0,0x04,0x02,0x00]

v_cmpx_nlt_f16_e64 -4.0, v2
// GFX10: encoding: [0x00,0x00,0xfe,0xd4,0xf7,0x04,0x02,0x00]

v_cmpx_nlt_f16_e64 v1, v255
// GFX10: encoding: [0x00,0x00,0xfe,0xd4,0x01,0xff,0x03,0x00]

v_cmpx_nlt_f16_e64 v1, s2
// GFX10: encoding: [0x00,0x00,0xfe,0xd4,0x01,0x05,0x00,0x00]

v_cmpx_nlt_f16_e64 v1, s101
// GFX10: encoding: [0x00,0x00,0xfe,0xd4,0x01,0xcb,0x00,0x00]

v_cmpx_nlt_f16_e64 v1, vcc_lo
// GFX10: encoding: [0x00,0x00,0xfe,0xd4,0x01,0xd5,0x00,0x00]

v_cmpx_nlt_f16_e64 v1, vcc_hi
// GFX10: encoding: [0x00,0x00,0xfe,0xd4,0x01,0xd7,0x00,0x00]

v_cmpx_nlt_f16_e64 v1, m0
// GFX10: encoding: [0x00,0x00,0xfe,0xd4,0x01,0xf9,0x00,0x00]

v_cmpx_nlt_f16_e64 v1, exec_lo
// GFX10: encoding: [0x00,0x00,0xfe,0xd4,0x01,0xfd,0x00,0x00]

v_cmpx_nlt_f16_e64 v1, exec_hi
// GFX10: encoding: [0x00,0x00,0xfe,0xd4,0x01,0xff,0x00,0x00]

v_cmpx_nlt_f16_e64 v1, 0
// GFX10: encoding: [0x00,0x00,0xfe,0xd4,0x01,0x01,0x01,0x00]

v_cmpx_nlt_f16_e64 v1, -1
// GFX10: encoding: [0x00,0x00,0xfe,0xd4,0x01,0x83,0x01,0x00]

v_cmpx_nlt_f16_e64 v1, 0.5
// GFX10: encoding: [0x00,0x00,0xfe,0xd4,0x01,0xe1,0x01,0x00]

v_cmpx_nlt_f16_e64 v1, -4.0
// GFX10: encoding: [0x00,0x00,0xfe,0xd4,0x01,0xef,0x01,0x00]

v_cmpx_nlt_f16_e64 -v1, v2
// GFX10: encoding: [0x00,0x00,0xfe,0xd4,0x01,0x05,0x02,0x20]

v_cmpx_nlt_f16_e64 v1, -v2
// GFX10: encoding: [0x00,0x00,0xfe,0xd4,0x01,0x05,0x02,0x40]

v_cmpx_nlt_f16_e64 -v1, -v2
// GFX10: encoding: [0x00,0x00,0xfe,0xd4,0x01,0x05,0x02,0x60]

v_cmpx_tru_f16 v1, v2
// GFX10: encoding: [0x01,0x05,0xfe,0x7d]

v_cmpx_tru_f16 v255, v2
// GFX10: encoding: [0xff,0x05,0xfe,0x7d]

v_cmpx_tru_f16 s1, v2
// GFX10: encoding: [0x01,0x04,0xfe,0x7d]

v_cmpx_tru_f16 s101, v2
// GFX10: encoding: [0x65,0x04,0xfe,0x7d]

v_cmpx_tru_f16 vcc_lo, v2
// GFX10: encoding: [0x6a,0x04,0xfe,0x7d]

v_cmpx_tru_f16 vcc_hi, v2
// GFX10: encoding: [0x6b,0x04,0xfe,0x7d]

v_cmpx_tru_f16 m0, v2
// GFX10: encoding: [0x7c,0x04,0xfe,0x7d]

v_cmpx_tru_f16 exec_lo, v2
// GFX10: encoding: [0x7e,0x04,0xfe,0x7d]

v_cmpx_tru_f16 exec_hi, v2
// GFX10: encoding: [0x7f,0x04,0xfe,0x7d]

v_cmpx_tru_f16 0, v2
// GFX10: encoding: [0x80,0x04,0xfe,0x7d]

v_cmpx_tru_f16 -1, v2
// GFX10: encoding: [0xc1,0x04,0xfe,0x7d]

v_cmpx_tru_f16 0.5, v2
// GFX10: encoding: [0xf0,0x04,0xfe,0x7d]

v_cmpx_tru_f16 -4.0, v2
// GFX10: encoding: [0xf7,0x04,0xfe,0x7d]

v_cmpx_tru_f16 0xfe0b, v2
// GFX10: encoding: [0xff,0x04,0xfe,0x7d,0x0b,0xfe,0x00,0x00]

v_cmpx_tru_f16 0x3456, v2
// GFX10: encoding: [0xff,0x04,0xfe,0x7d,0x56,0x34,0x00,0x00]

v_cmpx_tru_f16 v1, v255
// GFX10: encoding: [0x01,0xff,0xff,0x7d]

v_cmpx_tru_f16_e64 v1, v2
// GFX10: encoding: [0x00,0x00,0xff,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_tru_f16_e64 v255, v2
// GFX10: encoding: [0x00,0x00,0xff,0xd4,0xff,0x05,0x02,0x00]

v_cmpx_tru_f16_e64 s1, v2
// GFX10: encoding: [0x00,0x00,0xff,0xd4,0x01,0x04,0x02,0x00]

v_cmpx_tru_f16_e64 s101, v2
// GFX10: encoding: [0x00,0x00,0xff,0xd4,0x65,0x04,0x02,0x00]

v_cmpx_tru_f16_e64 vcc_lo, v2
// GFX10: encoding: [0x00,0x00,0xff,0xd4,0x6a,0x04,0x02,0x00]

v_cmpx_tru_f16_e64 vcc_hi, v2
// GFX10: encoding: [0x00,0x00,0xff,0xd4,0x6b,0x04,0x02,0x00]

v_cmpx_tru_f16_e64 m0, v2
// GFX10: encoding: [0x00,0x00,0xff,0xd4,0x7c,0x04,0x02,0x00]

v_cmpx_tru_f16_e64 exec_lo, v2
// GFX10: encoding: [0x00,0x00,0xff,0xd4,0x7e,0x04,0x02,0x00]

v_cmpx_tru_f16_e64 exec_hi, v2
// GFX10: encoding: [0x00,0x00,0xff,0xd4,0x7f,0x04,0x02,0x00]

v_cmpx_tru_f16_e64 0, v2
// GFX10: encoding: [0x00,0x00,0xff,0xd4,0x80,0x04,0x02,0x00]

v_cmpx_tru_f16_e64 -1, v2
// GFX10: encoding: [0x00,0x00,0xff,0xd4,0xc1,0x04,0x02,0x00]

v_cmpx_tru_f16_e64 0.5, v2
// GFX10: encoding: [0x00,0x00,0xff,0xd4,0xf0,0x04,0x02,0x00]

v_cmpx_tru_f16_e64 -4.0, v2
// GFX10: encoding: [0x00,0x00,0xff,0xd4,0xf7,0x04,0x02,0x00]

v_cmpx_tru_f16_e64 v1, v255
// GFX10: encoding: [0x00,0x00,0xff,0xd4,0x01,0xff,0x03,0x00]

v_cmpx_tru_f16_e64 v1, s2
// GFX10: encoding: [0x00,0x00,0xff,0xd4,0x01,0x05,0x00,0x00]

v_cmpx_tru_f16_e64 v1, s101
// GFX10: encoding: [0x00,0x00,0xff,0xd4,0x01,0xcb,0x00,0x00]

v_cmpx_tru_f16_e64 v1, vcc_lo
// GFX10: encoding: [0x00,0x00,0xff,0xd4,0x01,0xd5,0x00,0x00]

v_cmpx_tru_f16_e64 v1, vcc_hi
// GFX10: encoding: [0x00,0x00,0xff,0xd4,0x01,0xd7,0x00,0x00]

v_cmpx_tru_f16_e64 v1, m0
// GFX10: encoding: [0x00,0x00,0xff,0xd4,0x01,0xf9,0x00,0x00]

v_cmpx_tru_f16_e64 v1, exec_lo
// GFX10: encoding: [0x00,0x00,0xff,0xd4,0x01,0xfd,0x00,0x00]

v_cmpx_tru_f16_e64 v1, exec_hi
// GFX10: encoding: [0x00,0x00,0xff,0xd4,0x01,0xff,0x00,0x00]

v_cmpx_tru_f16_e64 v1, 0
// GFX10: encoding: [0x00,0x00,0xff,0xd4,0x01,0x01,0x01,0x00]

v_cmpx_tru_f16_e64 v1, -1
// GFX10: encoding: [0x00,0x00,0xff,0xd4,0x01,0x83,0x01,0x00]

v_cmpx_tru_f16_e64 v1, 0.5
// GFX10: encoding: [0x00,0x00,0xff,0xd4,0x01,0xe1,0x01,0x00]

v_cmpx_tru_f16_e64 v1, -4.0
// GFX10: encoding: [0x00,0x00,0xff,0xd4,0x01,0xef,0x01,0x00]

v_cmpx_tru_f16_e64 -v1, v2
// GFX10: encoding: [0x00,0x00,0xff,0xd4,0x01,0x05,0x02,0x20]

v_cmpx_tru_f16_e64 v1, -v2
// GFX10: encoding: [0x00,0x00,0xff,0xd4,0x01,0x05,0x02,0x40]

v_cmpx_tru_f16_e64 -v1, -v2
// GFX10: encoding: [0x00,0x00,0xff,0xd4,0x01,0x05,0x02,0x60]

v_cmpx_f_i32_sdwa v1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x20,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_f_i32_sdwa v255, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x20,0x7d,0xff,0x00,0x06,0x06]

v_cmpx_f_i32_sdwa s1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x20,0x7d,0x01,0x00,0x86,0x06]

v_cmpx_f_i32_sdwa s101, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x20,0x7d,0x65,0x00,0x86,0x06]

v_cmpx_f_i32_sdwa vcc_lo, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x20,0x7d,0x6a,0x00,0x86,0x06]

v_cmpx_f_i32_sdwa vcc_hi, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x20,0x7d,0x6b,0x00,0x86,0x06]

v_cmpx_f_i32_sdwa m0, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x20,0x7d,0x7c,0x00,0x86,0x06]

v_cmpx_f_i32_sdwa exec_lo, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x20,0x7d,0x7e,0x00,0x86,0x06]

v_cmpx_f_i32_sdwa exec_hi, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x20,0x7d,0x7f,0x00,0x86,0x06]

v_cmpx_f_i32_sdwa v1, v255 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0xfe,0x21,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_f_i32_sdwa v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x20,0x7d,0x01,0x00,0x00,0x06]

v_cmpx_f_i32_sdwa v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x20,0x7d,0x01,0x00,0x01,0x06]

v_cmpx_f_i32_sdwa v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x20,0x7d,0x01,0x00,0x02,0x06]

v_cmpx_f_i32_sdwa v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x20,0x7d,0x01,0x00,0x03,0x06]

v_cmpx_f_i32_sdwa v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x20,0x7d,0x01,0x00,0x04,0x06]

v_cmpx_f_i32_sdwa v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x20,0x7d,0x01,0x00,0x05,0x06]

v_cmpx_f_i32_sdwa sext(v1), v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x20,0x7d,0x01,0x00,0x0e,0x06]

v_cmpx_f_i32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// GFX10: encoding: [0xf9,0x04,0x20,0x7d,0x01,0x00,0x06,0x00]

v_cmpx_f_i32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// GFX10: encoding: [0xf9,0x04,0x20,0x7d,0x01,0x00,0x06,0x01]

v_cmpx_f_i32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// GFX10: encoding: [0xf9,0x04,0x20,0x7d,0x01,0x00,0x06,0x02]

v_cmpx_f_i32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// GFX10: encoding: [0xf9,0x04,0x20,0x7d,0x01,0x00,0x06,0x03]

v_cmpx_f_i32_sdwa v1, v2 src0_sel:DWORD src1_sel:WORD_0
// GFX10: encoding: [0xf9,0x04,0x20,0x7d,0x01,0x00,0x06,0x04]

v_cmpx_f_i32_sdwa v1, v2 src0_sel:DWORD src1_sel:WORD_1
// GFX10: encoding: [0xf9,0x04,0x20,0x7d,0x01,0x00,0x06,0x05]

v_cmpx_f_i32_sdwa v1, sext(v2) src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x20,0x7d,0x01,0x00,0x06,0x0e]

v_cmpx_lt_i32_sdwa v1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x22,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_lt_i32_sdwa v255, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x22,0x7d,0xff,0x00,0x06,0x06]

v_cmpx_lt_i32_sdwa s1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x22,0x7d,0x01,0x00,0x86,0x06]

v_cmpx_lt_i32_sdwa s101, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x22,0x7d,0x65,0x00,0x86,0x06]

v_cmpx_lt_i32_sdwa vcc_lo, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x22,0x7d,0x6a,0x00,0x86,0x06]

v_cmpx_lt_i32_sdwa vcc_hi, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x22,0x7d,0x6b,0x00,0x86,0x06]

v_cmpx_lt_i32_sdwa m0, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x22,0x7d,0x7c,0x00,0x86,0x06]

v_cmpx_lt_i32_sdwa exec_lo, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x22,0x7d,0x7e,0x00,0x86,0x06]

v_cmpx_lt_i32_sdwa exec_hi, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x22,0x7d,0x7f,0x00,0x86,0x06]

v_cmpx_lt_i32_sdwa v1, v255 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0xfe,0x23,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_lt_i32_sdwa v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x22,0x7d,0x01,0x00,0x00,0x06]

v_cmpx_lt_i32_sdwa v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x22,0x7d,0x01,0x00,0x01,0x06]

v_cmpx_lt_i32_sdwa v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x22,0x7d,0x01,0x00,0x02,0x06]

v_cmpx_lt_i32_sdwa v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x22,0x7d,0x01,0x00,0x03,0x06]

v_cmpx_lt_i32_sdwa v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x22,0x7d,0x01,0x00,0x04,0x06]

v_cmpx_lt_i32_sdwa v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x22,0x7d,0x01,0x00,0x05,0x06]

v_cmpx_lt_i32_sdwa sext(v1), v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x22,0x7d,0x01,0x00,0x0e,0x06]

v_cmpx_lt_i32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// GFX10: encoding: [0xf9,0x04,0x22,0x7d,0x01,0x00,0x06,0x00]

v_cmpx_lt_i32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// GFX10: encoding: [0xf9,0x04,0x22,0x7d,0x01,0x00,0x06,0x01]

v_cmpx_lt_i32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// GFX10: encoding: [0xf9,0x04,0x22,0x7d,0x01,0x00,0x06,0x02]

v_cmpx_lt_i32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// GFX10: encoding: [0xf9,0x04,0x22,0x7d,0x01,0x00,0x06,0x03]

v_cmpx_lt_i32_sdwa v1, v2 src0_sel:DWORD src1_sel:WORD_0
// GFX10: encoding: [0xf9,0x04,0x22,0x7d,0x01,0x00,0x06,0x04]

v_cmpx_lt_i32_sdwa v1, v2 src0_sel:DWORD src1_sel:WORD_1
// GFX10: encoding: [0xf9,0x04,0x22,0x7d,0x01,0x00,0x06,0x05]

v_cmpx_lt_i32_sdwa v1, sext(v2) src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x22,0x7d,0x01,0x00,0x06,0x0e]

v_cmpx_eq_i32_sdwa v1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x24,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_eq_i32_sdwa v255, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x24,0x7d,0xff,0x00,0x06,0x06]

v_cmpx_eq_i32_sdwa s1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x24,0x7d,0x01,0x00,0x86,0x06]

v_cmpx_eq_i32_sdwa s101, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x24,0x7d,0x65,0x00,0x86,0x06]

v_cmpx_eq_i32_sdwa vcc_lo, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x24,0x7d,0x6a,0x00,0x86,0x06]

v_cmpx_eq_i32_sdwa vcc_hi, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x24,0x7d,0x6b,0x00,0x86,0x06]

v_cmpx_eq_i32_sdwa m0, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x24,0x7d,0x7c,0x00,0x86,0x06]

v_cmpx_eq_i32_sdwa exec_lo, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x24,0x7d,0x7e,0x00,0x86,0x06]

v_cmpx_eq_i32_sdwa exec_hi, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x24,0x7d,0x7f,0x00,0x86,0x06]

v_cmpx_eq_i32_sdwa v1, v255 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0xfe,0x25,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_eq_i32_sdwa v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x24,0x7d,0x01,0x00,0x00,0x06]

v_cmpx_eq_i32_sdwa v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x24,0x7d,0x01,0x00,0x01,0x06]

v_cmpx_eq_i32_sdwa v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x24,0x7d,0x01,0x00,0x02,0x06]

v_cmpx_eq_i32_sdwa v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x24,0x7d,0x01,0x00,0x03,0x06]

v_cmpx_eq_i32_sdwa v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x24,0x7d,0x01,0x00,0x04,0x06]

v_cmpx_eq_i32_sdwa v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x24,0x7d,0x01,0x00,0x05,0x06]

v_cmpx_eq_i32_sdwa sext(v1), v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x24,0x7d,0x01,0x00,0x0e,0x06]

v_cmpx_eq_i32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// GFX10: encoding: [0xf9,0x04,0x24,0x7d,0x01,0x00,0x06,0x00]

v_cmpx_eq_i32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// GFX10: encoding: [0xf9,0x04,0x24,0x7d,0x01,0x00,0x06,0x01]

v_cmpx_eq_i32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// GFX10: encoding: [0xf9,0x04,0x24,0x7d,0x01,0x00,0x06,0x02]

v_cmpx_eq_i32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// GFX10: encoding: [0xf9,0x04,0x24,0x7d,0x01,0x00,0x06,0x03]

v_cmpx_eq_i32_sdwa v1, v2 src0_sel:DWORD src1_sel:WORD_0
// GFX10: encoding: [0xf9,0x04,0x24,0x7d,0x01,0x00,0x06,0x04]

v_cmpx_eq_i32_sdwa v1, v2 src0_sel:DWORD src1_sel:WORD_1
// GFX10: encoding: [0xf9,0x04,0x24,0x7d,0x01,0x00,0x06,0x05]

v_cmpx_eq_i32_sdwa v1, sext(v2) src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x24,0x7d,0x01,0x00,0x06,0x0e]

v_cmpx_le_i32_sdwa v1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x26,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_le_i32_sdwa v255, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x26,0x7d,0xff,0x00,0x06,0x06]

v_cmpx_le_i32_sdwa s1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x26,0x7d,0x01,0x00,0x86,0x06]

v_cmpx_le_i32_sdwa s101, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x26,0x7d,0x65,0x00,0x86,0x06]

v_cmpx_le_i32_sdwa vcc_lo, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x26,0x7d,0x6a,0x00,0x86,0x06]

v_cmpx_le_i32_sdwa vcc_hi, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x26,0x7d,0x6b,0x00,0x86,0x06]

v_cmpx_le_i32_sdwa m0, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x26,0x7d,0x7c,0x00,0x86,0x06]

v_cmpx_le_i32_sdwa exec_lo, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x26,0x7d,0x7e,0x00,0x86,0x06]

v_cmpx_le_i32_sdwa exec_hi, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x26,0x7d,0x7f,0x00,0x86,0x06]

v_cmpx_le_i32_sdwa v1, v255 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0xfe,0x27,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_le_i32_sdwa v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x26,0x7d,0x01,0x00,0x00,0x06]

v_cmpx_le_i32_sdwa v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x26,0x7d,0x01,0x00,0x01,0x06]

v_cmpx_le_i32_sdwa v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x26,0x7d,0x01,0x00,0x02,0x06]

v_cmpx_le_i32_sdwa v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x26,0x7d,0x01,0x00,0x03,0x06]

v_cmpx_le_i32_sdwa v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x26,0x7d,0x01,0x00,0x04,0x06]

v_cmpx_le_i32_sdwa v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x26,0x7d,0x01,0x00,0x05,0x06]

v_cmpx_le_i32_sdwa sext(v1), v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x26,0x7d,0x01,0x00,0x0e,0x06]

v_cmpx_le_i32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// GFX10: encoding: [0xf9,0x04,0x26,0x7d,0x01,0x00,0x06,0x00]

v_cmpx_le_i32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// GFX10: encoding: [0xf9,0x04,0x26,0x7d,0x01,0x00,0x06,0x01]

v_cmpx_le_i32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// GFX10: encoding: [0xf9,0x04,0x26,0x7d,0x01,0x00,0x06,0x02]

v_cmpx_le_i32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// GFX10: encoding: [0xf9,0x04,0x26,0x7d,0x01,0x00,0x06,0x03]

v_cmpx_le_i32_sdwa v1, v2 src0_sel:DWORD src1_sel:WORD_0
// GFX10: encoding: [0xf9,0x04,0x26,0x7d,0x01,0x00,0x06,0x04]

v_cmpx_le_i32_sdwa v1, v2 src0_sel:DWORD src1_sel:WORD_1
// GFX10: encoding: [0xf9,0x04,0x26,0x7d,0x01,0x00,0x06,0x05]

v_cmpx_le_i32_sdwa v1, sext(v2) src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x26,0x7d,0x01,0x00,0x06,0x0e]

v_cmpx_gt_i32_sdwa v1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x28,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_gt_i32_sdwa v255, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x28,0x7d,0xff,0x00,0x06,0x06]

v_cmpx_gt_i32_sdwa s1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x28,0x7d,0x01,0x00,0x86,0x06]

v_cmpx_gt_i32_sdwa s101, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x28,0x7d,0x65,0x00,0x86,0x06]

v_cmpx_gt_i32_sdwa vcc_lo, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x28,0x7d,0x6a,0x00,0x86,0x06]

v_cmpx_gt_i32_sdwa vcc_hi, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x28,0x7d,0x6b,0x00,0x86,0x06]

v_cmpx_gt_i32_sdwa m0, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x28,0x7d,0x7c,0x00,0x86,0x06]

v_cmpx_gt_i32_sdwa exec_lo, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x28,0x7d,0x7e,0x00,0x86,0x06]

v_cmpx_gt_i32_sdwa exec_hi, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x28,0x7d,0x7f,0x00,0x86,0x06]

v_cmpx_gt_i32_sdwa v1, v255 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0xfe,0x29,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_gt_i32_sdwa v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x28,0x7d,0x01,0x00,0x00,0x06]

v_cmpx_gt_i32_sdwa v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x28,0x7d,0x01,0x00,0x01,0x06]

v_cmpx_gt_i32_sdwa v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x28,0x7d,0x01,0x00,0x02,0x06]

v_cmpx_gt_i32_sdwa v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x28,0x7d,0x01,0x00,0x03,0x06]

v_cmpx_gt_i32_sdwa v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x28,0x7d,0x01,0x00,0x04,0x06]

v_cmpx_gt_i32_sdwa v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x28,0x7d,0x01,0x00,0x05,0x06]

v_cmpx_gt_i32_sdwa sext(v1), v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x28,0x7d,0x01,0x00,0x0e,0x06]

v_cmpx_gt_i32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// GFX10: encoding: [0xf9,0x04,0x28,0x7d,0x01,0x00,0x06,0x00]

v_cmpx_gt_i32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// GFX10: encoding: [0xf9,0x04,0x28,0x7d,0x01,0x00,0x06,0x01]

v_cmpx_gt_i32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// GFX10: encoding: [0xf9,0x04,0x28,0x7d,0x01,0x00,0x06,0x02]

v_cmpx_gt_i32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// GFX10: encoding: [0xf9,0x04,0x28,0x7d,0x01,0x00,0x06,0x03]

v_cmpx_gt_i32_sdwa v1, v2 src0_sel:DWORD src1_sel:WORD_0
// GFX10: encoding: [0xf9,0x04,0x28,0x7d,0x01,0x00,0x06,0x04]

v_cmpx_gt_i32_sdwa v1, v2 src0_sel:DWORD src1_sel:WORD_1
// GFX10: encoding: [0xf9,0x04,0x28,0x7d,0x01,0x00,0x06,0x05]

v_cmpx_gt_i32_sdwa v1, sext(v2) src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x28,0x7d,0x01,0x00,0x06,0x0e]

v_cmpx_ne_i32_sdwa v1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x2a,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_ne_i32_sdwa v255, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x2a,0x7d,0xff,0x00,0x06,0x06]

v_cmpx_ne_i32_sdwa s1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x2a,0x7d,0x01,0x00,0x86,0x06]

v_cmpx_ne_i32_sdwa s101, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x2a,0x7d,0x65,0x00,0x86,0x06]

v_cmpx_ne_i32_sdwa vcc_lo, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x2a,0x7d,0x6a,0x00,0x86,0x06]

v_cmpx_ne_i32_sdwa vcc_hi, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x2a,0x7d,0x6b,0x00,0x86,0x06]

v_cmpx_ne_i32_sdwa m0, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x2a,0x7d,0x7c,0x00,0x86,0x06]

v_cmpx_ne_i32_sdwa exec_lo, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x2a,0x7d,0x7e,0x00,0x86,0x06]

v_cmpx_ne_i32_sdwa exec_hi, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x2a,0x7d,0x7f,0x00,0x86,0x06]

v_cmpx_ne_i32_sdwa v1, v255 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0xfe,0x2b,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_ne_i32_sdwa v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x2a,0x7d,0x01,0x00,0x00,0x06]

v_cmpx_ne_i32_sdwa v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x2a,0x7d,0x01,0x00,0x01,0x06]

v_cmpx_ne_i32_sdwa v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x2a,0x7d,0x01,0x00,0x02,0x06]

v_cmpx_ne_i32_sdwa v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x2a,0x7d,0x01,0x00,0x03,0x06]

v_cmpx_ne_i32_sdwa v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x2a,0x7d,0x01,0x00,0x04,0x06]

v_cmpx_ne_i32_sdwa v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x2a,0x7d,0x01,0x00,0x05,0x06]

v_cmpx_ne_i32_sdwa sext(v1), v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x2a,0x7d,0x01,0x00,0x0e,0x06]

v_cmpx_ne_i32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// GFX10: encoding: [0xf9,0x04,0x2a,0x7d,0x01,0x00,0x06,0x00]

v_cmpx_ne_i32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// GFX10: encoding: [0xf9,0x04,0x2a,0x7d,0x01,0x00,0x06,0x01]

v_cmpx_ne_i32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// GFX10: encoding: [0xf9,0x04,0x2a,0x7d,0x01,0x00,0x06,0x02]

v_cmpx_ne_i32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// GFX10: encoding: [0xf9,0x04,0x2a,0x7d,0x01,0x00,0x06,0x03]

v_cmpx_ne_i32_sdwa v1, v2 src0_sel:DWORD src1_sel:WORD_0
// GFX10: encoding: [0xf9,0x04,0x2a,0x7d,0x01,0x00,0x06,0x04]

v_cmpx_ne_i32_sdwa v1, v2 src0_sel:DWORD src1_sel:WORD_1
// GFX10: encoding: [0xf9,0x04,0x2a,0x7d,0x01,0x00,0x06,0x05]

v_cmpx_ne_i32_sdwa v1, sext(v2) src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x2a,0x7d,0x01,0x00,0x06,0x0e]

v_cmpx_ge_i32_sdwa v1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x2c,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_ge_i32_sdwa v255, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x2c,0x7d,0xff,0x00,0x06,0x06]

v_cmpx_ge_i32_sdwa s1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x2c,0x7d,0x01,0x00,0x86,0x06]

v_cmpx_ge_i32_sdwa s101, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x2c,0x7d,0x65,0x00,0x86,0x06]

v_cmpx_ge_i32_sdwa vcc_lo, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x2c,0x7d,0x6a,0x00,0x86,0x06]

v_cmpx_ge_i32_sdwa vcc_hi, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x2c,0x7d,0x6b,0x00,0x86,0x06]

v_cmpx_ge_i32_sdwa m0, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x2c,0x7d,0x7c,0x00,0x86,0x06]

v_cmpx_ge_i32_sdwa exec_lo, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x2c,0x7d,0x7e,0x00,0x86,0x06]

v_cmpx_ge_i32_sdwa exec_hi, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x2c,0x7d,0x7f,0x00,0x86,0x06]

v_cmpx_ge_i32_sdwa v1, v255 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0xfe,0x2d,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_ge_i32_sdwa v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x2c,0x7d,0x01,0x00,0x00,0x06]

v_cmpx_ge_i32_sdwa v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x2c,0x7d,0x01,0x00,0x01,0x06]

v_cmpx_ge_i32_sdwa v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x2c,0x7d,0x01,0x00,0x02,0x06]

v_cmpx_ge_i32_sdwa v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x2c,0x7d,0x01,0x00,0x03,0x06]

v_cmpx_ge_i32_sdwa v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x2c,0x7d,0x01,0x00,0x04,0x06]

v_cmpx_ge_i32_sdwa v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x2c,0x7d,0x01,0x00,0x05,0x06]

v_cmpx_ge_i32_sdwa sext(v1), v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x2c,0x7d,0x01,0x00,0x0e,0x06]

v_cmpx_ge_i32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// GFX10: encoding: [0xf9,0x04,0x2c,0x7d,0x01,0x00,0x06,0x00]

v_cmpx_ge_i32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// GFX10: encoding: [0xf9,0x04,0x2c,0x7d,0x01,0x00,0x06,0x01]

v_cmpx_ge_i32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// GFX10: encoding: [0xf9,0x04,0x2c,0x7d,0x01,0x00,0x06,0x02]

v_cmpx_ge_i32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// GFX10: encoding: [0xf9,0x04,0x2c,0x7d,0x01,0x00,0x06,0x03]

v_cmpx_ge_i32_sdwa v1, v2 src0_sel:DWORD src1_sel:WORD_0
// GFX10: encoding: [0xf9,0x04,0x2c,0x7d,0x01,0x00,0x06,0x04]

v_cmpx_ge_i32_sdwa v1, v2 src0_sel:DWORD src1_sel:WORD_1
// GFX10: encoding: [0xf9,0x04,0x2c,0x7d,0x01,0x00,0x06,0x05]

v_cmpx_ge_i32_sdwa v1, sext(v2) src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x2c,0x7d,0x01,0x00,0x06,0x0e]

v_cmpx_t_i32_sdwa v1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x2e,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_t_i32_sdwa v255, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x2e,0x7d,0xff,0x00,0x06,0x06]

v_cmpx_t_i32_sdwa s1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x2e,0x7d,0x01,0x00,0x86,0x06]

v_cmpx_t_i32_sdwa s101, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x2e,0x7d,0x65,0x00,0x86,0x06]

v_cmpx_t_i32_sdwa vcc_lo, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x2e,0x7d,0x6a,0x00,0x86,0x06]

v_cmpx_t_i32_sdwa vcc_hi, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x2e,0x7d,0x6b,0x00,0x86,0x06]

v_cmpx_t_i32_sdwa m0, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x2e,0x7d,0x7c,0x00,0x86,0x06]

v_cmpx_t_i32_sdwa exec_lo, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x2e,0x7d,0x7e,0x00,0x86,0x06]

v_cmpx_t_i32_sdwa exec_hi, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x2e,0x7d,0x7f,0x00,0x86,0x06]

v_cmpx_t_i32_sdwa v1, v255 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0xfe,0x2f,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_t_i32_sdwa v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x2e,0x7d,0x01,0x00,0x00,0x06]

v_cmpx_t_i32_sdwa v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x2e,0x7d,0x01,0x00,0x01,0x06]

v_cmpx_t_i32_sdwa v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x2e,0x7d,0x01,0x00,0x02,0x06]

v_cmpx_t_i32_sdwa v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x2e,0x7d,0x01,0x00,0x03,0x06]

v_cmpx_t_i32_sdwa v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x2e,0x7d,0x01,0x00,0x04,0x06]

v_cmpx_t_i32_sdwa v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x2e,0x7d,0x01,0x00,0x05,0x06]

v_cmpx_t_i32_sdwa sext(v1), v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x2e,0x7d,0x01,0x00,0x0e,0x06]

v_cmpx_t_i32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// GFX10: encoding: [0xf9,0x04,0x2e,0x7d,0x01,0x00,0x06,0x00]

v_cmpx_t_i32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// GFX10: encoding: [0xf9,0x04,0x2e,0x7d,0x01,0x00,0x06,0x01]

v_cmpx_t_i32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// GFX10: encoding: [0xf9,0x04,0x2e,0x7d,0x01,0x00,0x06,0x02]

v_cmpx_t_i32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// GFX10: encoding: [0xf9,0x04,0x2e,0x7d,0x01,0x00,0x06,0x03]

v_cmpx_t_i32_sdwa v1, v2 src0_sel:DWORD src1_sel:WORD_0
// GFX10: encoding: [0xf9,0x04,0x2e,0x7d,0x01,0x00,0x06,0x04]

v_cmpx_t_i32_sdwa v1, v2 src0_sel:DWORD src1_sel:WORD_1
// GFX10: encoding: [0xf9,0x04,0x2e,0x7d,0x01,0x00,0x06,0x05]

v_cmpx_t_i32_sdwa v1, sext(v2) src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x2e,0x7d,0x01,0x00,0x06,0x0e]

v_cmpx_lt_i16_sdwa v1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x32,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_lt_i16_sdwa v255, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x32,0x7d,0xff,0x00,0x06,0x06]

v_cmpx_lt_i16_sdwa s1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x32,0x7d,0x01,0x00,0x86,0x06]

v_cmpx_lt_i16_sdwa s101, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x32,0x7d,0x65,0x00,0x86,0x06]

v_cmpx_lt_i16_sdwa vcc_lo, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x32,0x7d,0x6a,0x00,0x86,0x06]

v_cmpx_lt_i16_sdwa vcc_hi, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x32,0x7d,0x6b,0x00,0x86,0x06]

v_cmpx_lt_i16_sdwa m0, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x32,0x7d,0x7c,0x00,0x86,0x06]

v_cmpx_lt_i16_sdwa exec_lo, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x32,0x7d,0x7e,0x00,0x86,0x06]

v_cmpx_lt_i16_sdwa exec_hi, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x32,0x7d,0x7f,0x00,0x86,0x06]

v_cmpx_lt_i16_sdwa v1, v255 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0xfe,0x33,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_lt_i16_sdwa v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x32,0x7d,0x01,0x00,0x00,0x06]

v_cmpx_lt_i16_sdwa v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x32,0x7d,0x01,0x00,0x01,0x06]

v_cmpx_lt_i16_sdwa v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x32,0x7d,0x01,0x00,0x02,0x06]

v_cmpx_lt_i16_sdwa v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x32,0x7d,0x01,0x00,0x03,0x06]

v_cmpx_lt_i16_sdwa v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x32,0x7d,0x01,0x00,0x04,0x06]

v_cmpx_lt_i16_sdwa v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x32,0x7d,0x01,0x00,0x05,0x06]

v_cmpx_lt_i16_sdwa sext(v1), v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x32,0x7d,0x01,0x00,0x0e,0x06]

v_cmpx_lt_i16_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// GFX10: encoding: [0xf9,0x04,0x32,0x7d,0x01,0x00,0x06,0x00]

v_cmpx_lt_i16_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// GFX10: encoding: [0xf9,0x04,0x32,0x7d,0x01,0x00,0x06,0x01]

v_cmpx_lt_i16_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// GFX10: encoding: [0xf9,0x04,0x32,0x7d,0x01,0x00,0x06,0x02]

v_cmpx_lt_i16_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// GFX10: encoding: [0xf9,0x04,0x32,0x7d,0x01,0x00,0x06,0x03]

v_cmpx_lt_i16_sdwa v1, v2 src0_sel:DWORD src1_sel:WORD_0
// GFX10: encoding: [0xf9,0x04,0x32,0x7d,0x01,0x00,0x06,0x04]

v_cmpx_lt_i16_sdwa v1, v2 src0_sel:DWORD src1_sel:WORD_1
// GFX10: encoding: [0xf9,0x04,0x32,0x7d,0x01,0x00,0x06,0x05]

v_cmpx_lt_i16_sdwa v1, sext(v2) src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x32,0x7d,0x01,0x00,0x06,0x0e]

v_cmpx_eq_i16_sdwa v1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x34,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_eq_i16_sdwa v255, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x34,0x7d,0xff,0x00,0x06,0x06]

v_cmpx_eq_i16_sdwa s1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x34,0x7d,0x01,0x00,0x86,0x06]

v_cmpx_eq_i16_sdwa s101, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x34,0x7d,0x65,0x00,0x86,0x06]

v_cmpx_eq_i16_sdwa vcc_lo, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x34,0x7d,0x6a,0x00,0x86,0x06]

v_cmpx_eq_i16_sdwa vcc_hi, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x34,0x7d,0x6b,0x00,0x86,0x06]

v_cmpx_eq_i16_sdwa m0, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x34,0x7d,0x7c,0x00,0x86,0x06]

v_cmpx_eq_i16_sdwa exec_lo, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x34,0x7d,0x7e,0x00,0x86,0x06]

v_cmpx_eq_i16_sdwa exec_hi, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x34,0x7d,0x7f,0x00,0x86,0x06]

v_cmpx_eq_i16_sdwa v1, v255 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0xfe,0x35,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_eq_i16_sdwa v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x34,0x7d,0x01,0x00,0x00,0x06]

v_cmpx_eq_i16_sdwa v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x34,0x7d,0x01,0x00,0x01,0x06]

v_cmpx_eq_i16_sdwa v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x34,0x7d,0x01,0x00,0x02,0x06]

v_cmpx_eq_i16_sdwa v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x34,0x7d,0x01,0x00,0x03,0x06]

v_cmpx_eq_i16_sdwa v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x34,0x7d,0x01,0x00,0x04,0x06]

v_cmpx_eq_i16_sdwa v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x34,0x7d,0x01,0x00,0x05,0x06]

v_cmpx_eq_i16_sdwa sext(v1), v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x34,0x7d,0x01,0x00,0x0e,0x06]

v_cmpx_eq_i16_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// GFX10: encoding: [0xf9,0x04,0x34,0x7d,0x01,0x00,0x06,0x00]

v_cmpx_eq_i16_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// GFX10: encoding: [0xf9,0x04,0x34,0x7d,0x01,0x00,0x06,0x01]

v_cmpx_eq_i16_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// GFX10: encoding: [0xf9,0x04,0x34,0x7d,0x01,0x00,0x06,0x02]

v_cmpx_eq_i16_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// GFX10: encoding: [0xf9,0x04,0x34,0x7d,0x01,0x00,0x06,0x03]

v_cmpx_eq_i16_sdwa v1, v2 src0_sel:DWORD src1_sel:WORD_0
// GFX10: encoding: [0xf9,0x04,0x34,0x7d,0x01,0x00,0x06,0x04]

v_cmpx_eq_i16_sdwa v1, v2 src0_sel:DWORD src1_sel:WORD_1
// GFX10: encoding: [0xf9,0x04,0x34,0x7d,0x01,0x00,0x06,0x05]

v_cmpx_eq_i16_sdwa v1, sext(v2) src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x34,0x7d,0x01,0x00,0x06,0x0e]

v_cmpx_le_i16_sdwa v1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x36,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_le_i16_sdwa v255, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x36,0x7d,0xff,0x00,0x06,0x06]

v_cmpx_le_i16_sdwa s1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x36,0x7d,0x01,0x00,0x86,0x06]

v_cmpx_le_i16_sdwa s101, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x36,0x7d,0x65,0x00,0x86,0x06]

v_cmpx_le_i16_sdwa vcc_lo, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x36,0x7d,0x6a,0x00,0x86,0x06]

v_cmpx_le_i16_sdwa vcc_hi, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x36,0x7d,0x6b,0x00,0x86,0x06]

v_cmpx_le_i16_sdwa m0, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x36,0x7d,0x7c,0x00,0x86,0x06]

v_cmpx_le_i16_sdwa exec_lo, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x36,0x7d,0x7e,0x00,0x86,0x06]

v_cmpx_le_i16_sdwa exec_hi, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x36,0x7d,0x7f,0x00,0x86,0x06]

v_cmpx_le_i16_sdwa v1, v255 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0xfe,0x37,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_le_i16_sdwa v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x36,0x7d,0x01,0x00,0x00,0x06]

v_cmpx_le_i16_sdwa v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x36,0x7d,0x01,0x00,0x01,0x06]

v_cmpx_le_i16_sdwa v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x36,0x7d,0x01,0x00,0x02,0x06]

v_cmpx_le_i16_sdwa v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x36,0x7d,0x01,0x00,0x03,0x06]

v_cmpx_le_i16_sdwa v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x36,0x7d,0x01,0x00,0x04,0x06]

v_cmpx_le_i16_sdwa v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x36,0x7d,0x01,0x00,0x05,0x06]

v_cmpx_le_i16_sdwa sext(v1), v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x36,0x7d,0x01,0x00,0x0e,0x06]

v_cmpx_le_i16_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// GFX10: encoding: [0xf9,0x04,0x36,0x7d,0x01,0x00,0x06,0x00]

v_cmpx_le_i16_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// GFX10: encoding: [0xf9,0x04,0x36,0x7d,0x01,0x00,0x06,0x01]

v_cmpx_le_i16_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// GFX10: encoding: [0xf9,0x04,0x36,0x7d,0x01,0x00,0x06,0x02]

v_cmpx_le_i16_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// GFX10: encoding: [0xf9,0x04,0x36,0x7d,0x01,0x00,0x06,0x03]

v_cmpx_le_i16_sdwa v1, v2 src0_sel:DWORD src1_sel:WORD_0
// GFX10: encoding: [0xf9,0x04,0x36,0x7d,0x01,0x00,0x06,0x04]

v_cmpx_le_i16_sdwa v1, v2 src0_sel:DWORD src1_sel:WORD_1
// GFX10: encoding: [0xf9,0x04,0x36,0x7d,0x01,0x00,0x06,0x05]

v_cmpx_le_i16_sdwa v1, sext(v2) src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x36,0x7d,0x01,0x00,0x06,0x0e]

v_cmpx_gt_i16_sdwa v1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x38,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_gt_i16_sdwa v255, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x38,0x7d,0xff,0x00,0x06,0x06]

v_cmpx_gt_i16_sdwa s1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x38,0x7d,0x01,0x00,0x86,0x06]

v_cmpx_gt_i16_sdwa s101, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x38,0x7d,0x65,0x00,0x86,0x06]

v_cmpx_gt_i16_sdwa vcc_lo, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x38,0x7d,0x6a,0x00,0x86,0x06]

v_cmpx_gt_i16_sdwa vcc_hi, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x38,0x7d,0x6b,0x00,0x86,0x06]

v_cmpx_gt_i16_sdwa m0, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x38,0x7d,0x7c,0x00,0x86,0x06]

v_cmpx_gt_i16_sdwa exec_lo, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x38,0x7d,0x7e,0x00,0x86,0x06]

v_cmpx_gt_i16_sdwa exec_hi, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x38,0x7d,0x7f,0x00,0x86,0x06]

v_cmpx_gt_i16_sdwa v1, v255 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0xfe,0x39,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_gt_i16_sdwa v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x38,0x7d,0x01,0x00,0x00,0x06]

v_cmpx_gt_i16_sdwa v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x38,0x7d,0x01,0x00,0x01,0x06]

v_cmpx_gt_i16_sdwa v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x38,0x7d,0x01,0x00,0x02,0x06]

v_cmpx_gt_i16_sdwa v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x38,0x7d,0x01,0x00,0x03,0x06]

v_cmpx_gt_i16_sdwa v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x38,0x7d,0x01,0x00,0x04,0x06]

v_cmpx_gt_i16_sdwa v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x38,0x7d,0x01,0x00,0x05,0x06]

v_cmpx_gt_i16_sdwa sext(v1), v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x38,0x7d,0x01,0x00,0x0e,0x06]

v_cmpx_gt_i16_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// GFX10: encoding: [0xf9,0x04,0x38,0x7d,0x01,0x00,0x06,0x00]

v_cmpx_gt_i16_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// GFX10: encoding: [0xf9,0x04,0x38,0x7d,0x01,0x00,0x06,0x01]

v_cmpx_gt_i16_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// GFX10: encoding: [0xf9,0x04,0x38,0x7d,0x01,0x00,0x06,0x02]

v_cmpx_gt_i16_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// GFX10: encoding: [0xf9,0x04,0x38,0x7d,0x01,0x00,0x06,0x03]

v_cmpx_gt_i16_sdwa v1, v2 src0_sel:DWORD src1_sel:WORD_0
// GFX10: encoding: [0xf9,0x04,0x38,0x7d,0x01,0x00,0x06,0x04]

v_cmpx_gt_i16_sdwa v1, v2 src0_sel:DWORD src1_sel:WORD_1
// GFX10: encoding: [0xf9,0x04,0x38,0x7d,0x01,0x00,0x06,0x05]

v_cmpx_gt_i16_sdwa v1, sext(v2) src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x38,0x7d,0x01,0x00,0x06,0x0e]

v_cmpx_ne_i16_sdwa v1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x3a,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_ne_i16_sdwa v255, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x3a,0x7d,0xff,0x00,0x06,0x06]

v_cmpx_ne_i16_sdwa s1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x3a,0x7d,0x01,0x00,0x86,0x06]

v_cmpx_ne_i16_sdwa s101, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x3a,0x7d,0x65,0x00,0x86,0x06]

v_cmpx_ne_i16_sdwa vcc_lo, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x3a,0x7d,0x6a,0x00,0x86,0x06]

v_cmpx_ne_i16_sdwa vcc_hi, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x3a,0x7d,0x6b,0x00,0x86,0x06]

v_cmpx_ne_i16_sdwa m0, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x3a,0x7d,0x7c,0x00,0x86,0x06]

v_cmpx_ne_i16_sdwa exec_lo, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x3a,0x7d,0x7e,0x00,0x86,0x06]

v_cmpx_ne_i16_sdwa exec_hi, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x3a,0x7d,0x7f,0x00,0x86,0x06]

v_cmpx_ne_i16_sdwa v1, v255 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0xfe,0x3b,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_ne_i16_sdwa v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x3a,0x7d,0x01,0x00,0x00,0x06]

v_cmpx_ne_i16_sdwa v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x3a,0x7d,0x01,0x00,0x01,0x06]

v_cmpx_ne_i16_sdwa v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x3a,0x7d,0x01,0x00,0x02,0x06]

v_cmpx_ne_i16_sdwa v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x3a,0x7d,0x01,0x00,0x03,0x06]

v_cmpx_ne_i16_sdwa v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x3a,0x7d,0x01,0x00,0x04,0x06]

v_cmpx_ne_i16_sdwa v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x3a,0x7d,0x01,0x00,0x05,0x06]

v_cmpx_ne_i16_sdwa sext(v1), v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x3a,0x7d,0x01,0x00,0x0e,0x06]

v_cmpx_ne_i16_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// GFX10: encoding: [0xf9,0x04,0x3a,0x7d,0x01,0x00,0x06,0x00]

v_cmpx_ne_i16_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// GFX10: encoding: [0xf9,0x04,0x3a,0x7d,0x01,0x00,0x06,0x01]

v_cmpx_ne_i16_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// GFX10: encoding: [0xf9,0x04,0x3a,0x7d,0x01,0x00,0x06,0x02]

v_cmpx_ne_i16_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// GFX10: encoding: [0xf9,0x04,0x3a,0x7d,0x01,0x00,0x06,0x03]

v_cmpx_ne_i16_sdwa v1, v2 src0_sel:DWORD src1_sel:WORD_0
// GFX10: encoding: [0xf9,0x04,0x3a,0x7d,0x01,0x00,0x06,0x04]

v_cmpx_ne_i16_sdwa v1, v2 src0_sel:DWORD src1_sel:WORD_1
// GFX10: encoding: [0xf9,0x04,0x3a,0x7d,0x01,0x00,0x06,0x05]

v_cmpx_ne_i16_sdwa v1, sext(v2) src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x3a,0x7d,0x01,0x00,0x06,0x0e]

v_cmpx_ge_i16_sdwa v1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x3c,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_ge_i16_sdwa v255, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x3c,0x7d,0xff,0x00,0x06,0x06]

v_cmpx_ge_i16_sdwa s1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x3c,0x7d,0x01,0x00,0x86,0x06]

v_cmpx_ge_i16_sdwa s101, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x3c,0x7d,0x65,0x00,0x86,0x06]

v_cmpx_ge_i16_sdwa vcc_lo, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x3c,0x7d,0x6a,0x00,0x86,0x06]

v_cmpx_ge_i16_sdwa vcc_hi, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x3c,0x7d,0x6b,0x00,0x86,0x06]

v_cmpx_ge_i16_sdwa m0, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x3c,0x7d,0x7c,0x00,0x86,0x06]

v_cmpx_ge_i16_sdwa exec_lo, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x3c,0x7d,0x7e,0x00,0x86,0x06]

v_cmpx_ge_i16_sdwa exec_hi, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x3c,0x7d,0x7f,0x00,0x86,0x06]

v_cmpx_ge_i16_sdwa v1, v255 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0xfe,0x3d,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_ge_i16_sdwa v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x3c,0x7d,0x01,0x00,0x00,0x06]

v_cmpx_ge_i16_sdwa v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x3c,0x7d,0x01,0x00,0x01,0x06]

v_cmpx_ge_i16_sdwa v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x3c,0x7d,0x01,0x00,0x02,0x06]

v_cmpx_ge_i16_sdwa v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x3c,0x7d,0x01,0x00,0x03,0x06]

v_cmpx_ge_i16_sdwa v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x3c,0x7d,0x01,0x00,0x04,0x06]

v_cmpx_ge_i16_sdwa v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x3c,0x7d,0x01,0x00,0x05,0x06]

v_cmpx_ge_i16_sdwa sext(v1), v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x3c,0x7d,0x01,0x00,0x0e,0x06]

v_cmpx_ge_i16_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// GFX10: encoding: [0xf9,0x04,0x3c,0x7d,0x01,0x00,0x06,0x00]

v_cmpx_ge_i16_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// GFX10: encoding: [0xf9,0x04,0x3c,0x7d,0x01,0x00,0x06,0x01]

v_cmpx_ge_i16_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// GFX10: encoding: [0xf9,0x04,0x3c,0x7d,0x01,0x00,0x06,0x02]

v_cmpx_ge_i16_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// GFX10: encoding: [0xf9,0x04,0x3c,0x7d,0x01,0x00,0x06,0x03]

v_cmpx_ge_i16_sdwa v1, v2 src0_sel:DWORD src1_sel:WORD_0
// GFX10: encoding: [0xf9,0x04,0x3c,0x7d,0x01,0x00,0x06,0x04]

v_cmpx_ge_i16_sdwa v1, v2 src0_sel:DWORD src1_sel:WORD_1
// GFX10: encoding: [0xf9,0x04,0x3c,0x7d,0x01,0x00,0x06,0x05]

v_cmpx_ge_i16_sdwa v1, sext(v2) src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x3c,0x7d,0x01,0x00,0x06,0x0e]

v_cmpx_lt_u16_sdwa v1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x72,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_lt_u16_sdwa v255, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x72,0x7d,0xff,0x00,0x06,0x06]

v_cmpx_lt_u16_sdwa s1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x72,0x7d,0x01,0x00,0x86,0x06]

v_cmpx_lt_u16_sdwa s101, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x72,0x7d,0x65,0x00,0x86,0x06]

v_cmpx_lt_u16_sdwa vcc_lo, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x72,0x7d,0x6a,0x00,0x86,0x06]

v_cmpx_lt_u16_sdwa vcc_hi, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x72,0x7d,0x6b,0x00,0x86,0x06]

v_cmpx_lt_u16_sdwa m0, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x72,0x7d,0x7c,0x00,0x86,0x06]

v_cmpx_lt_u16_sdwa exec_lo, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x72,0x7d,0x7e,0x00,0x86,0x06]

v_cmpx_lt_u16_sdwa exec_hi, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x72,0x7d,0x7f,0x00,0x86,0x06]

v_cmpx_lt_u16_sdwa v1, v255 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0xfe,0x73,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_lt_u16_sdwa v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x72,0x7d,0x01,0x00,0x00,0x06]

v_cmpx_lt_u16_sdwa v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x72,0x7d,0x01,0x00,0x01,0x06]

v_cmpx_lt_u16_sdwa v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x72,0x7d,0x01,0x00,0x02,0x06]

v_cmpx_lt_u16_sdwa v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x72,0x7d,0x01,0x00,0x03,0x06]

v_cmpx_lt_u16_sdwa v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x72,0x7d,0x01,0x00,0x04,0x06]

v_cmpx_lt_u16_sdwa v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x72,0x7d,0x01,0x00,0x05,0x06]

v_cmpx_lt_u16_sdwa sext(v1), v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x72,0x7d,0x01,0x00,0x0e,0x06]

v_cmpx_lt_u16_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// GFX10: encoding: [0xf9,0x04,0x72,0x7d,0x01,0x00,0x06,0x00]

v_cmpx_lt_u16_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// GFX10: encoding: [0xf9,0x04,0x72,0x7d,0x01,0x00,0x06,0x01]

v_cmpx_lt_u16_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// GFX10: encoding: [0xf9,0x04,0x72,0x7d,0x01,0x00,0x06,0x02]

v_cmpx_lt_u16_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// GFX10: encoding: [0xf9,0x04,0x72,0x7d,0x01,0x00,0x06,0x03]

v_cmpx_lt_u16_sdwa v1, v2 src0_sel:DWORD src1_sel:WORD_0
// GFX10: encoding: [0xf9,0x04,0x72,0x7d,0x01,0x00,0x06,0x04]

v_cmpx_lt_u16_sdwa v1, v2 src0_sel:DWORD src1_sel:WORD_1
// GFX10: encoding: [0xf9,0x04,0x72,0x7d,0x01,0x00,0x06,0x05]

v_cmpx_lt_u16_sdwa v1, sext(v2) src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x72,0x7d,0x01,0x00,0x06,0x0e]

v_cmpx_eq_u16_sdwa v1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x74,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_eq_u16_sdwa v255, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x74,0x7d,0xff,0x00,0x06,0x06]

v_cmpx_eq_u16_sdwa s1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x74,0x7d,0x01,0x00,0x86,0x06]

v_cmpx_eq_u16_sdwa s101, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x74,0x7d,0x65,0x00,0x86,0x06]

v_cmpx_eq_u16_sdwa vcc_lo, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x74,0x7d,0x6a,0x00,0x86,0x06]

v_cmpx_eq_u16_sdwa vcc_hi, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x74,0x7d,0x6b,0x00,0x86,0x06]

v_cmpx_eq_u16_sdwa m0, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x74,0x7d,0x7c,0x00,0x86,0x06]

v_cmpx_eq_u16_sdwa exec_lo, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x74,0x7d,0x7e,0x00,0x86,0x06]

v_cmpx_eq_u16_sdwa exec_hi, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x74,0x7d,0x7f,0x00,0x86,0x06]

v_cmpx_eq_u16_sdwa v1, v255 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0xfe,0x75,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_eq_u16_sdwa v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x74,0x7d,0x01,0x00,0x00,0x06]

v_cmpx_eq_u16_sdwa v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x74,0x7d,0x01,0x00,0x01,0x06]

v_cmpx_eq_u16_sdwa v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x74,0x7d,0x01,0x00,0x02,0x06]

v_cmpx_eq_u16_sdwa v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x74,0x7d,0x01,0x00,0x03,0x06]

v_cmpx_eq_u16_sdwa v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x74,0x7d,0x01,0x00,0x04,0x06]

v_cmpx_eq_u16_sdwa v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x74,0x7d,0x01,0x00,0x05,0x06]

v_cmpx_eq_u16_sdwa sext(v1), v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x74,0x7d,0x01,0x00,0x0e,0x06]

v_cmpx_eq_u16_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// GFX10: encoding: [0xf9,0x04,0x74,0x7d,0x01,0x00,0x06,0x00]

v_cmpx_eq_u16_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// GFX10: encoding: [0xf9,0x04,0x74,0x7d,0x01,0x00,0x06,0x01]

v_cmpx_eq_u16_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// GFX10: encoding: [0xf9,0x04,0x74,0x7d,0x01,0x00,0x06,0x02]

v_cmpx_eq_u16_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// GFX10: encoding: [0xf9,0x04,0x74,0x7d,0x01,0x00,0x06,0x03]

v_cmpx_eq_u16_sdwa v1, v2 src0_sel:DWORD src1_sel:WORD_0
// GFX10: encoding: [0xf9,0x04,0x74,0x7d,0x01,0x00,0x06,0x04]

v_cmpx_eq_u16_sdwa v1, v2 src0_sel:DWORD src1_sel:WORD_1
// GFX10: encoding: [0xf9,0x04,0x74,0x7d,0x01,0x00,0x06,0x05]

v_cmpx_eq_u16_sdwa v1, sext(v2) src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x74,0x7d,0x01,0x00,0x06,0x0e]

v_cmpx_le_u16_sdwa v1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x76,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_le_u16_sdwa v255, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x76,0x7d,0xff,0x00,0x06,0x06]

v_cmpx_le_u16_sdwa s1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x76,0x7d,0x01,0x00,0x86,0x06]

v_cmpx_le_u16_sdwa s101, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x76,0x7d,0x65,0x00,0x86,0x06]

v_cmpx_le_u16_sdwa vcc_lo, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x76,0x7d,0x6a,0x00,0x86,0x06]

v_cmpx_le_u16_sdwa vcc_hi, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x76,0x7d,0x6b,0x00,0x86,0x06]

v_cmpx_le_u16_sdwa m0, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x76,0x7d,0x7c,0x00,0x86,0x06]

v_cmpx_le_u16_sdwa exec_lo, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x76,0x7d,0x7e,0x00,0x86,0x06]

v_cmpx_le_u16_sdwa exec_hi, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x76,0x7d,0x7f,0x00,0x86,0x06]

v_cmpx_le_u16_sdwa v1, v255 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0xfe,0x77,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_le_u16_sdwa v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x76,0x7d,0x01,0x00,0x00,0x06]

v_cmpx_le_u16_sdwa v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x76,0x7d,0x01,0x00,0x01,0x06]

v_cmpx_le_u16_sdwa v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x76,0x7d,0x01,0x00,0x02,0x06]

v_cmpx_le_u16_sdwa v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x76,0x7d,0x01,0x00,0x03,0x06]

v_cmpx_le_u16_sdwa v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x76,0x7d,0x01,0x00,0x04,0x06]

v_cmpx_le_u16_sdwa v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x76,0x7d,0x01,0x00,0x05,0x06]

v_cmpx_le_u16_sdwa sext(v1), v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x76,0x7d,0x01,0x00,0x0e,0x06]

v_cmpx_le_u16_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// GFX10: encoding: [0xf9,0x04,0x76,0x7d,0x01,0x00,0x06,0x00]

v_cmpx_le_u16_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// GFX10: encoding: [0xf9,0x04,0x76,0x7d,0x01,0x00,0x06,0x01]

v_cmpx_le_u16_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// GFX10: encoding: [0xf9,0x04,0x76,0x7d,0x01,0x00,0x06,0x02]

v_cmpx_le_u16_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// GFX10: encoding: [0xf9,0x04,0x76,0x7d,0x01,0x00,0x06,0x03]

v_cmpx_le_u16_sdwa v1, v2 src0_sel:DWORD src1_sel:WORD_0
// GFX10: encoding: [0xf9,0x04,0x76,0x7d,0x01,0x00,0x06,0x04]

v_cmpx_le_u16_sdwa v1, v2 src0_sel:DWORD src1_sel:WORD_1
// GFX10: encoding: [0xf9,0x04,0x76,0x7d,0x01,0x00,0x06,0x05]

v_cmpx_le_u16_sdwa v1, sext(v2) src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x76,0x7d,0x01,0x00,0x06,0x0e]

v_cmpx_gt_u16_sdwa v1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x78,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_gt_u16_sdwa v255, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x78,0x7d,0xff,0x00,0x06,0x06]

v_cmpx_gt_u16_sdwa s1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x78,0x7d,0x01,0x00,0x86,0x06]

v_cmpx_gt_u16_sdwa s101, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x78,0x7d,0x65,0x00,0x86,0x06]

v_cmpx_gt_u16_sdwa vcc_lo, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x78,0x7d,0x6a,0x00,0x86,0x06]

v_cmpx_gt_u16_sdwa vcc_hi, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x78,0x7d,0x6b,0x00,0x86,0x06]

v_cmpx_gt_u16_sdwa m0, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x78,0x7d,0x7c,0x00,0x86,0x06]

v_cmpx_gt_u16_sdwa exec_lo, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x78,0x7d,0x7e,0x00,0x86,0x06]

v_cmpx_gt_u16_sdwa exec_hi, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x78,0x7d,0x7f,0x00,0x86,0x06]

v_cmpx_gt_u16_sdwa v1, v255 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0xfe,0x79,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_gt_u16_sdwa v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x78,0x7d,0x01,0x00,0x00,0x06]

v_cmpx_gt_u16_sdwa v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x78,0x7d,0x01,0x00,0x01,0x06]

v_cmpx_gt_u16_sdwa v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x78,0x7d,0x01,0x00,0x02,0x06]

v_cmpx_gt_u16_sdwa v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x78,0x7d,0x01,0x00,0x03,0x06]

v_cmpx_gt_u16_sdwa v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x78,0x7d,0x01,0x00,0x04,0x06]

v_cmpx_gt_u16_sdwa v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x78,0x7d,0x01,0x00,0x05,0x06]

v_cmpx_gt_u16_sdwa sext(v1), v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x78,0x7d,0x01,0x00,0x0e,0x06]

v_cmpx_gt_u16_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// GFX10: encoding: [0xf9,0x04,0x78,0x7d,0x01,0x00,0x06,0x00]

v_cmpx_gt_u16_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// GFX10: encoding: [0xf9,0x04,0x78,0x7d,0x01,0x00,0x06,0x01]

v_cmpx_gt_u16_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// GFX10: encoding: [0xf9,0x04,0x78,0x7d,0x01,0x00,0x06,0x02]

v_cmpx_gt_u16_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// GFX10: encoding: [0xf9,0x04,0x78,0x7d,0x01,0x00,0x06,0x03]

v_cmpx_gt_u16_sdwa v1, v2 src0_sel:DWORD src1_sel:WORD_0
// GFX10: encoding: [0xf9,0x04,0x78,0x7d,0x01,0x00,0x06,0x04]

v_cmpx_gt_u16_sdwa v1, v2 src0_sel:DWORD src1_sel:WORD_1
// GFX10: encoding: [0xf9,0x04,0x78,0x7d,0x01,0x00,0x06,0x05]

v_cmpx_gt_u16_sdwa v1, sext(v2) src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x78,0x7d,0x01,0x00,0x06,0x0e]

v_cmpx_ne_u16_sdwa v1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x7a,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_ne_u16_sdwa v255, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x7a,0x7d,0xff,0x00,0x06,0x06]

v_cmpx_ne_u16_sdwa s1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x7a,0x7d,0x01,0x00,0x86,0x06]

v_cmpx_ne_u16_sdwa s101, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x7a,0x7d,0x65,0x00,0x86,0x06]

v_cmpx_ne_u16_sdwa vcc_lo, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x7a,0x7d,0x6a,0x00,0x86,0x06]

v_cmpx_ne_u16_sdwa vcc_hi, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x7a,0x7d,0x6b,0x00,0x86,0x06]

v_cmpx_ne_u16_sdwa m0, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x7a,0x7d,0x7c,0x00,0x86,0x06]

v_cmpx_ne_u16_sdwa exec_lo, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x7a,0x7d,0x7e,0x00,0x86,0x06]

v_cmpx_ne_u16_sdwa exec_hi, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x7a,0x7d,0x7f,0x00,0x86,0x06]

v_cmpx_ne_u16_sdwa v1, v255 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0xfe,0x7b,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_ne_u16_sdwa v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x7a,0x7d,0x01,0x00,0x00,0x06]

v_cmpx_ne_u16_sdwa v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x7a,0x7d,0x01,0x00,0x01,0x06]

v_cmpx_ne_u16_sdwa v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x7a,0x7d,0x01,0x00,0x02,0x06]

v_cmpx_ne_u16_sdwa v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x7a,0x7d,0x01,0x00,0x03,0x06]

v_cmpx_ne_u16_sdwa v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x7a,0x7d,0x01,0x00,0x04,0x06]

v_cmpx_ne_u16_sdwa v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x7a,0x7d,0x01,0x00,0x05,0x06]

v_cmpx_ne_u16_sdwa sext(v1), v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x7a,0x7d,0x01,0x00,0x0e,0x06]

v_cmpx_ne_u16_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// GFX10: encoding: [0xf9,0x04,0x7a,0x7d,0x01,0x00,0x06,0x00]

v_cmpx_ne_u16_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// GFX10: encoding: [0xf9,0x04,0x7a,0x7d,0x01,0x00,0x06,0x01]

v_cmpx_ne_u16_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// GFX10: encoding: [0xf9,0x04,0x7a,0x7d,0x01,0x00,0x06,0x02]

v_cmpx_ne_u16_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// GFX10: encoding: [0xf9,0x04,0x7a,0x7d,0x01,0x00,0x06,0x03]

v_cmpx_ne_u16_sdwa v1, v2 src0_sel:DWORD src1_sel:WORD_0
// GFX10: encoding: [0xf9,0x04,0x7a,0x7d,0x01,0x00,0x06,0x04]

v_cmpx_ne_u16_sdwa v1, v2 src0_sel:DWORD src1_sel:WORD_1
// GFX10: encoding: [0xf9,0x04,0x7a,0x7d,0x01,0x00,0x06,0x05]

v_cmpx_ne_u16_sdwa v1, sext(v2) src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x7a,0x7d,0x01,0x00,0x06,0x0e]

v_cmpx_ge_u16_sdwa v1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x7c,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_ge_u16_sdwa v255, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x7c,0x7d,0xff,0x00,0x06,0x06]

v_cmpx_ge_u16_sdwa s1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x7c,0x7d,0x01,0x00,0x86,0x06]

v_cmpx_ge_u16_sdwa s101, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x7c,0x7d,0x65,0x00,0x86,0x06]

v_cmpx_ge_u16_sdwa vcc_lo, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x7c,0x7d,0x6a,0x00,0x86,0x06]

v_cmpx_ge_u16_sdwa vcc_hi, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x7c,0x7d,0x6b,0x00,0x86,0x06]

v_cmpx_ge_u16_sdwa m0, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x7c,0x7d,0x7c,0x00,0x86,0x06]

v_cmpx_ge_u16_sdwa exec_lo, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x7c,0x7d,0x7e,0x00,0x86,0x06]

v_cmpx_ge_u16_sdwa exec_hi, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x7c,0x7d,0x7f,0x00,0x86,0x06]

v_cmpx_ge_u16_sdwa v1, v255 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0xfe,0x7d,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_ge_u16_sdwa v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x7c,0x7d,0x01,0x00,0x00,0x06]

v_cmpx_ge_u16_sdwa v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x7c,0x7d,0x01,0x00,0x01,0x06]

v_cmpx_ge_u16_sdwa v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x7c,0x7d,0x01,0x00,0x02,0x06]

v_cmpx_ge_u16_sdwa v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x7c,0x7d,0x01,0x00,0x03,0x06]

v_cmpx_ge_u16_sdwa v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x7c,0x7d,0x01,0x00,0x04,0x06]

v_cmpx_ge_u16_sdwa v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x7c,0x7d,0x01,0x00,0x05,0x06]

v_cmpx_ge_u16_sdwa sext(v1), v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x7c,0x7d,0x01,0x00,0x0e,0x06]

v_cmpx_ge_u16_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// GFX10: encoding: [0xf9,0x04,0x7c,0x7d,0x01,0x00,0x06,0x00]

v_cmpx_ge_u16_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// GFX10: encoding: [0xf9,0x04,0x7c,0x7d,0x01,0x00,0x06,0x01]

v_cmpx_ge_u16_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// GFX10: encoding: [0xf9,0x04,0x7c,0x7d,0x01,0x00,0x06,0x02]

v_cmpx_ge_u16_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// GFX10: encoding: [0xf9,0x04,0x7c,0x7d,0x01,0x00,0x06,0x03]

v_cmpx_ge_u16_sdwa v1, v2 src0_sel:DWORD src1_sel:WORD_0
// GFX10: encoding: [0xf9,0x04,0x7c,0x7d,0x01,0x00,0x06,0x04]

v_cmpx_ge_u16_sdwa v1, v2 src0_sel:DWORD src1_sel:WORD_1
// GFX10: encoding: [0xf9,0x04,0x7c,0x7d,0x01,0x00,0x06,0x05]

v_cmpx_ge_u16_sdwa v1, sext(v2) src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x7c,0x7d,0x01,0x00,0x06,0x0e]

v_cmpx_f_u32_sdwa v1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xa0,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_f_u32_sdwa v255, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xa0,0x7d,0xff,0x00,0x06,0x06]

v_cmpx_f_u32_sdwa s1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xa0,0x7d,0x01,0x00,0x86,0x06]

v_cmpx_f_u32_sdwa s101, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xa0,0x7d,0x65,0x00,0x86,0x06]

v_cmpx_f_u32_sdwa vcc_lo, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xa0,0x7d,0x6a,0x00,0x86,0x06]

v_cmpx_f_u32_sdwa vcc_hi, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xa0,0x7d,0x6b,0x00,0x86,0x06]

v_cmpx_f_u32_sdwa m0, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xa0,0x7d,0x7c,0x00,0x86,0x06]

v_cmpx_f_u32_sdwa exec_lo, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xa0,0x7d,0x7e,0x00,0x86,0x06]

v_cmpx_f_u32_sdwa exec_hi, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xa0,0x7d,0x7f,0x00,0x86,0x06]

v_cmpx_f_u32_sdwa v1, v255 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0xfe,0xa1,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_f_u32_sdwa v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xa0,0x7d,0x01,0x00,0x00,0x06]

v_cmpx_f_u32_sdwa v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xa0,0x7d,0x01,0x00,0x01,0x06]

v_cmpx_f_u32_sdwa v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xa0,0x7d,0x01,0x00,0x02,0x06]

v_cmpx_f_u32_sdwa v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xa0,0x7d,0x01,0x00,0x03,0x06]

v_cmpx_f_u32_sdwa v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xa0,0x7d,0x01,0x00,0x04,0x06]

v_cmpx_f_u32_sdwa v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xa0,0x7d,0x01,0x00,0x05,0x06]

v_cmpx_f_u32_sdwa sext(v1), v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xa0,0x7d,0x01,0x00,0x0e,0x06]

v_cmpx_f_u32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// GFX10: encoding: [0xf9,0x04,0xa0,0x7d,0x01,0x00,0x06,0x00]

v_cmpx_f_u32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// GFX10: encoding: [0xf9,0x04,0xa0,0x7d,0x01,0x00,0x06,0x01]

v_cmpx_f_u32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// GFX10: encoding: [0xf9,0x04,0xa0,0x7d,0x01,0x00,0x06,0x02]

v_cmpx_f_u32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// GFX10: encoding: [0xf9,0x04,0xa0,0x7d,0x01,0x00,0x06,0x03]

v_cmpx_f_u32_sdwa v1, v2 src0_sel:DWORD src1_sel:WORD_0
// GFX10: encoding: [0xf9,0x04,0xa0,0x7d,0x01,0x00,0x06,0x04]

v_cmpx_f_u32_sdwa v1, v2 src0_sel:DWORD src1_sel:WORD_1
// GFX10: encoding: [0xf9,0x04,0xa0,0x7d,0x01,0x00,0x06,0x05]

v_cmpx_f_u32_sdwa v1, sext(v2) src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xa0,0x7d,0x01,0x00,0x06,0x0e]

v_cmpx_lt_u32_sdwa v1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xa2,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_lt_u32_sdwa v255, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xa2,0x7d,0xff,0x00,0x06,0x06]

v_cmpx_lt_u32_sdwa s1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xa2,0x7d,0x01,0x00,0x86,0x06]

v_cmpx_lt_u32_sdwa s101, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xa2,0x7d,0x65,0x00,0x86,0x06]

v_cmpx_lt_u32_sdwa vcc_lo, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xa2,0x7d,0x6a,0x00,0x86,0x06]

v_cmpx_lt_u32_sdwa vcc_hi, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xa2,0x7d,0x6b,0x00,0x86,0x06]

v_cmpx_lt_u32_sdwa m0, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xa2,0x7d,0x7c,0x00,0x86,0x06]

v_cmpx_lt_u32_sdwa exec_lo, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xa2,0x7d,0x7e,0x00,0x86,0x06]

v_cmpx_lt_u32_sdwa exec_hi, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xa2,0x7d,0x7f,0x00,0x86,0x06]

v_cmpx_lt_u32_sdwa v1, v255 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0xfe,0xa3,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_lt_u32_sdwa v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xa2,0x7d,0x01,0x00,0x00,0x06]

v_cmpx_lt_u32_sdwa v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xa2,0x7d,0x01,0x00,0x01,0x06]

v_cmpx_lt_u32_sdwa v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xa2,0x7d,0x01,0x00,0x02,0x06]

v_cmpx_lt_u32_sdwa v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xa2,0x7d,0x01,0x00,0x03,0x06]

v_cmpx_lt_u32_sdwa v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xa2,0x7d,0x01,0x00,0x04,0x06]

v_cmpx_lt_u32_sdwa v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xa2,0x7d,0x01,0x00,0x05,0x06]

v_cmpx_lt_u32_sdwa sext(v1), v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xa2,0x7d,0x01,0x00,0x0e,0x06]

v_cmpx_lt_u32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// GFX10: encoding: [0xf9,0x04,0xa2,0x7d,0x01,0x00,0x06,0x00]

v_cmpx_lt_u32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// GFX10: encoding: [0xf9,0x04,0xa2,0x7d,0x01,0x00,0x06,0x01]

v_cmpx_lt_u32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// GFX10: encoding: [0xf9,0x04,0xa2,0x7d,0x01,0x00,0x06,0x02]

v_cmpx_lt_u32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// GFX10: encoding: [0xf9,0x04,0xa2,0x7d,0x01,0x00,0x06,0x03]

v_cmpx_lt_u32_sdwa v1, v2 src0_sel:DWORD src1_sel:WORD_0
// GFX10: encoding: [0xf9,0x04,0xa2,0x7d,0x01,0x00,0x06,0x04]

v_cmpx_lt_u32_sdwa v1, v2 src0_sel:DWORD src1_sel:WORD_1
// GFX10: encoding: [0xf9,0x04,0xa2,0x7d,0x01,0x00,0x06,0x05]

v_cmpx_lt_u32_sdwa v1, sext(v2) src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xa2,0x7d,0x01,0x00,0x06,0x0e]

v_cmpx_eq_u32_sdwa v1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xa4,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_eq_u32_sdwa v255, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xa4,0x7d,0xff,0x00,0x06,0x06]

v_cmpx_eq_u32_sdwa s1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xa4,0x7d,0x01,0x00,0x86,0x06]

v_cmpx_eq_u32_sdwa s101, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xa4,0x7d,0x65,0x00,0x86,0x06]

v_cmpx_eq_u32_sdwa vcc_lo, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xa4,0x7d,0x6a,0x00,0x86,0x06]

v_cmpx_eq_u32_sdwa vcc_hi, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xa4,0x7d,0x6b,0x00,0x86,0x06]

v_cmpx_eq_u32_sdwa m0, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xa4,0x7d,0x7c,0x00,0x86,0x06]

v_cmpx_eq_u32_sdwa exec_lo, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xa4,0x7d,0x7e,0x00,0x86,0x06]

v_cmpx_eq_u32_sdwa exec_hi, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xa4,0x7d,0x7f,0x00,0x86,0x06]

v_cmpx_eq_u32_sdwa v1, v255 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0xfe,0xa5,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_eq_u32_sdwa v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xa4,0x7d,0x01,0x00,0x00,0x06]

v_cmpx_eq_u32_sdwa v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xa4,0x7d,0x01,0x00,0x01,0x06]

v_cmpx_eq_u32_sdwa v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xa4,0x7d,0x01,0x00,0x02,0x06]

v_cmpx_eq_u32_sdwa v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xa4,0x7d,0x01,0x00,0x03,0x06]

v_cmpx_eq_u32_sdwa v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xa4,0x7d,0x01,0x00,0x04,0x06]

v_cmpx_eq_u32_sdwa v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xa4,0x7d,0x01,0x00,0x05,0x06]

v_cmpx_eq_u32_sdwa sext(v1), v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xa4,0x7d,0x01,0x00,0x0e,0x06]

v_cmpx_eq_u32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// GFX10: encoding: [0xf9,0x04,0xa4,0x7d,0x01,0x00,0x06,0x00]

v_cmpx_eq_u32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// GFX10: encoding: [0xf9,0x04,0xa4,0x7d,0x01,0x00,0x06,0x01]

v_cmpx_eq_u32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// GFX10: encoding: [0xf9,0x04,0xa4,0x7d,0x01,0x00,0x06,0x02]

v_cmpx_eq_u32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// GFX10: encoding: [0xf9,0x04,0xa4,0x7d,0x01,0x00,0x06,0x03]

v_cmpx_eq_u32_sdwa v1, v2 src0_sel:DWORD src1_sel:WORD_0
// GFX10: encoding: [0xf9,0x04,0xa4,0x7d,0x01,0x00,0x06,0x04]

v_cmpx_eq_u32_sdwa v1, v2 src0_sel:DWORD src1_sel:WORD_1
// GFX10: encoding: [0xf9,0x04,0xa4,0x7d,0x01,0x00,0x06,0x05]

v_cmpx_eq_u32_sdwa v1, sext(v2) src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xa4,0x7d,0x01,0x00,0x06,0x0e]

v_cmpx_le_u32_sdwa v1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xa6,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_le_u32_sdwa v255, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xa6,0x7d,0xff,0x00,0x06,0x06]

v_cmpx_le_u32_sdwa s1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xa6,0x7d,0x01,0x00,0x86,0x06]

v_cmpx_le_u32_sdwa s101, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xa6,0x7d,0x65,0x00,0x86,0x06]

v_cmpx_le_u32_sdwa vcc_lo, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xa6,0x7d,0x6a,0x00,0x86,0x06]

v_cmpx_le_u32_sdwa vcc_hi, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xa6,0x7d,0x6b,0x00,0x86,0x06]

v_cmpx_le_u32_sdwa m0, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xa6,0x7d,0x7c,0x00,0x86,0x06]

v_cmpx_le_u32_sdwa exec_lo, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xa6,0x7d,0x7e,0x00,0x86,0x06]

v_cmpx_le_u32_sdwa exec_hi, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xa6,0x7d,0x7f,0x00,0x86,0x06]

v_cmpx_le_u32_sdwa v1, v255 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0xfe,0xa7,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_le_u32_sdwa v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xa6,0x7d,0x01,0x00,0x00,0x06]

v_cmpx_le_u32_sdwa v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xa6,0x7d,0x01,0x00,0x01,0x06]

v_cmpx_le_u32_sdwa v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xa6,0x7d,0x01,0x00,0x02,0x06]

v_cmpx_le_u32_sdwa v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xa6,0x7d,0x01,0x00,0x03,0x06]

v_cmpx_le_u32_sdwa v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xa6,0x7d,0x01,0x00,0x04,0x06]

v_cmpx_le_u32_sdwa v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xa6,0x7d,0x01,0x00,0x05,0x06]

v_cmpx_le_u32_sdwa sext(v1), v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xa6,0x7d,0x01,0x00,0x0e,0x06]

v_cmpx_le_u32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// GFX10: encoding: [0xf9,0x04,0xa6,0x7d,0x01,0x00,0x06,0x00]

v_cmpx_le_u32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// GFX10: encoding: [0xf9,0x04,0xa6,0x7d,0x01,0x00,0x06,0x01]

v_cmpx_le_u32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// GFX10: encoding: [0xf9,0x04,0xa6,0x7d,0x01,0x00,0x06,0x02]

v_cmpx_le_u32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// GFX10: encoding: [0xf9,0x04,0xa6,0x7d,0x01,0x00,0x06,0x03]

v_cmpx_le_u32_sdwa v1, v2 src0_sel:DWORD src1_sel:WORD_0
// GFX10: encoding: [0xf9,0x04,0xa6,0x7d,0x01,0x00,0x06,0x04]

v_cmpx_le_u32_sdwa v1, v2 src0_sel:DWORD src1_sel:WORD_1
// GFX10: encoding: [0xf9,0x04,0xa6,0x7d,0x01,0x00,0x06,0x05]

v_cmpx_le_u32_sdwa v1, sext(v2) src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xa6,0x7d,0x01,0x00,0x06,0x0e]

v_cmpx_gt_u32_sdwa v1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xa8,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_gt_u32_sdwa v255, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xa8,0x7d,0xff,0x00,0x06,0x06]

v_cmpx_gt_u32_sdwa s1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xa8,0x7d,0x01,0x00,0x86,0x06]

v_cmpx_gt_u32_sdwa s101, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xa8,0x7d,0x65,0x00,0x86,0x06]

v_cmpx_gt_u32_sdwa vcc_lo, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xa8,0x7d,0x6a,0x00,0x86,0x06]

v_cmpx_gt_u32_sdwa vcc_hi, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xa8,0x7d,0x6b,0x00,0x86,0x06]

v_cmpx_gt_u32_sdwa m0, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xa8,0x7d,0x7c,0x00,0x86,0x06]

v_cmpx_gt_u32_sdwa exec_lo, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xa8,0x7d,0x7e,0x00,0x86,0x06]

v_cmpx_gt_u32_sdwa exec_hi, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xa8,0x7d,0x7f,0x00,0x86,0x06]

v_cmpx_gt_u32_sdwa v1, v255 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0xfe,0xa9,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_gt_u32_sdwa v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xa8,0x7d,0x01,0x00,0x00,0x06]

v_cmpx_gt_u32_sdwa v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xa8,0x7d,0x01,0x00,0x01,0x06]

v_cmpx_gt_u32_sdwa v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xa8,0x7d,0x01,0x00,0x02,0x06]

v_cmpx_gt_u32_sdwa v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xa8,0x7d,0x01,0x00,0x03,0x06]

v_cmpx_gt_u32_sdwa v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xa8,0x7d,0x01,0x00,0x04,0x06]

v_cmpx_gt_u32_sdwa v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xa8,0x7d,0x01,0x00,0x05,0x06]

v_cmpx_gt_u32_sdwa sext(v1), v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xa8,0x7d,0x01,0x00,0x0e,0x06]

v_cmpx_gt_u32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// GFX10: encoding: [0xf9,0x04,0xa8,0x7d,0x01,0x00,0x06,0x00]

v_cmpx_gt_u32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// GFX10: encoding: [0xf9,0x04,0xa8,0x7d,0x01,0x00,0x06,0x01]

v_cmpx_gt_u32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// GFX10: encoding: [0xf9,0x04,0xa8,0x7d,0x01,0x00,0x06,0x02]

v_cmpx_gt_u32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// GFX10: encoding: [0xf9,0x04,0xa8,0x7d,0x01,0x00,0x06,0x03]

v_cmpx_gt_u32_sdwa v1, v2 src0_sel:DWORD src1_sel:WORD_0
// GFX10: encoding: [0xf9,0x04,0xa8,0x7d,0x01,0x00,0x06,0x04]

v_cmpx_gt_u32_sdwa v1, v2 src0_sel:DWORD src1_sel:WORD_1
// GFX10: encoding: [0xf9,0x04,0xa8,0x7d,0x01,0x00,0x06,0x05]

v_cmpx_gt_u32_sdwa v1, sext(v2) src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xa8,0x7d,0x01,0x00,0x06,0x0e]

v_cmpx_ne_u32_sdwa v1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xaa,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_ne_u32_sdwa v255, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xaa,0x7d,0xff,0x00,0x06,0x06]

v_cmpx_ne_u32_sdwa s1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xaa,0x7d,0x01,0x00,0x86,0x06]

v_cmpx_ne_u32_sdwa s101, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xaa,0x7d,0x65,0x00,0x86,0x06]

v_cmpx_ne_u32_sdwa vcc_lo, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xaa,0x7d,0x6a,0x00,0x86,0x06]

v_cmpx_ne_u32_sdwa vcc_hi, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xaa,0x7d,0x6b,0x00,0x86,0x06]

v_cmpx_ne_u32_sdwa m0, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xaa,0x7d,0x7c,0x00,0x86,0x06]

v_cmpx_ne_u32_sdwa exec_lo, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xaa,0x7d,0x7e,0x00,0x86,0x06]

v_cmpx_ne_u32_sdwa exec_hi, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xaa,0x7d,0x7f,0x00,0x86,0x06]

v_cmpx_ne_u32_sdwa v1, v255 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0xfe,0xab,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_ne_u32_sdwa v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xaa,0x7d,0x01,0x00,0x00,0x06]

v_cmpx_ne_u32_sdwa v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xaa,0x7d,0x01,0x00,0x01,0x06]

v_cmpx_ne_u32_sdwa v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xaa,0x7d,0x01,0x00,0x02,0x06]

v_cmpx_ne_u32_sdwa v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xaa,0x7d,0x01,0x00,0x03,0x06]

v_cmpx_ne_u32_sdwa v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xaa,0x7d,0x01,0x00,0x04,0x06]

v_cmpx_ne_u32_sdwa v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xaa,0x7d,0x01,0x00,0x05,0x06]

v_cmpx_ne_u32_sdwa sext(v1), v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xaa,0x7d,0x01,0x00,0x0e,0x06]

v_cmpx_ne_u32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// GFX10: encoding: [0xf9,0x04,0xaa,0x7d,0x01,0x00,0x06,0x00]

v_cmpx_ne_u32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// GFX10: encoding: [0xf9,0x04,0xaa,0x7d,0x01,0x00,0x06,0x01]

v_cmpx_ne_u32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// GFX10: encoding: [0xf9,0x04,0xaa,0x7d,0x01,0x00,0x06,0x02]

v_cmpx_ne_u32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// GFX10: encoding: [0xf9,0x04,0xaa,0x7d,0x01,0x00,0x06,0x03]

v_cmpx_ne_u32_sdwa v1, v2 src0_sel:DWORD src1_sel:WORD_0
// GFX10: encoding: [0xf9,0x04,0xaa,0x7d,0x01,0x00,0x06,0x04]

v_cmpx_ne_u32_sdwa v1, v2 src0_sel:DWORD src1_sel:WORD_1
// GFX10: encoding: [0xf9,0x04,0xaa,0x7d,0x01,0x00,0x06,0x05]

v_cmpx_ne_u32_sdwa v1, sext(v2) src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xaa,0x7d,0x01,0x00,0x06,0x0e]

v_cmpx_ge_u32_sdwa v1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xac,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_ge_u32_sdwa v255, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xac,0x7d,0xff,0x00,0x06,0x06]

v_cmpx_ge_u32_sdwa s1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xac,0x7d,0x01,0x00,0x86,0x06]

v_cmpx_ge_u32_sdwa s101, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xac,0x7d,0x65,0x00,0x86,0x06]

v_cmpx_ge_u32_sdwa vcc_lo, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xac,0x7d,0x6a,0x00,0x86,0x06]

v_cmpx_ge_u32_sdwa vcc_hi, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xac,0x7d,0x6b,0x00,0x86,0x06]

v_cmpx_ge_u32_sdwa m0, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xac,0x7d,0x7c,0x00,0x86,0x06]

v_cmpx_ge_u32_sdwa exec_lo, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xac,0x7d,0x7e,0x00,0x86,0x06]

v_cmpx_ge_u32_sdwa exec_hi, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xac,0x7d,0x7f,0x00,0x86,0x06]

v_cmpx_ge_u32_sdwa v1, v255 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0xfe,0xad,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_ge_u32_sdwa v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xac,0x7d,0x01,0x00,0x00,0x06]

v_cmpx_ge_u32_sdwa v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xac,0x7d,0x01,0x00,0x01,0x06]

v_cmpx_ge_u32_sdwa v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xac,0x7d,0x01,0x00,0x02,0x06]

v_cmpx_ge_u32_sdwa v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xac,0x7d,0x01,0x00,0x03,0x06]

v_cmpx_ge_u32_sdwa v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xac,0x7d,0x01,0x00,0x04,0x06]

v_cmpx_ge_u32_sdwa v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xac,0x7d,0x01,0x00,0x05,0x06]

v_cmpx_ge_u32_sdwa sext(v1), v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xac,0x7d,0x01,0x00,0x0e,0x06]

v_cmpx_ge_u32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// GFX10: encoding: [0xf9,0x04,0xac,0x7d,0x01,0x00,0x06,0x00]

v_cmpx_ge_u32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// GFX10: encoding: [0xf9,0x04,0xac,0x7d,0x01,0x00,0x06,0x01]

v_cmpx_ge_u32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// GFX10: encoding: [0xf9,0x04,0xac,0x7d,0x01,0x00,0x06,0x02]

v_cmpx_ge_u32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// GFX10: encoding: [0xf9,0x04,0xac,0x7d,0x01,0x00,0x06,0x03]

v_cmpx_ge_u32_sdwa v1, v2 src0_sel:DWORD src1_sel:WORD_0
// GFX10: encoding: [0xf9,0x04,0xac,0x7d,0x01,0x00,0x06,0x04]

v_cmpx_ge_u32_sdwa v1, v2 src0_sel:DWORD src1_sel:WORD_1
// GFX10: encoding: [0xf9,0x04,0xac,0x7d,0x01,0x00,0x06,0x05]

v_cmpx_ge_u32_sdwa v1, sext(v2) src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xac,0x7d,0x01,0x00,0x06,0x0e]

v_cmpx_t_u32_sdwa v1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xae,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_t_u32_sdwa v255, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xae,0x7d,0xff,0x00,0x06,0x06]

v_cmpx_t_u32_sdwa s1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xae,0x7d,0x01,0x00,0x86,0x06]

v_cmpx_t_u32_sdwa s101, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xae,0x7d,0x65,0x00,0x86,0x06]

v_cmpx_t_u32_sdwa vcc_lo, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xae,0x7d,0x6a,0x00,0x86,0x06]

v_cmpx_t_u32_sdwa vcc_hi, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xae,0x7d,0x6b,0x00,0x86,0x06]

v_cmpx_t_u32_sdwa m0, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xae,0x7d,0x7c,0x00,0x86,0x06]

v_cmpx_t_u32_sdwa exec_lo, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xae,0x7d,0x7e,0x00,0x86,0x06]

v_cmpx_t_u32_sdwa exec_hi, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xae,0x7d,0x7f,0x00,0x86,0x06]

v_cmpx_t_u32_sdwa v1, v255 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0xfe,0xaf,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_t_u32_sdwa v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xae,0x7d,0x01,0x00,0x00,0x06]

v_cmpx_t_u32_sdwa v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xae,0x7d,0x01,0x00,0x01,0x06]

v_cmpx_t_u32_sdwa v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xae,0x7d,0x01,0x00,0x02,0x06]

v_cmpx_t_u32_sdwa v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xae,0x7d,0x01,0x00,0x03,0x06]

v_cmpx_t_u32_sdwa v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xae,0x7d,0x01,0x00,0x04,0x06]

v_cmpx_t_u32_sdwa v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xae,0x7d,0x01,0x00,0x05,0x06]

v_cmpx_t_u32_sdwa sext(v1), v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xae,0x7d,0x01,0x00,0x0e,0x06]

v_cmpx_t_u32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// GFX10: encoding: [0xf9,0x04,0xae,0x7d,0x01,0x00,0x06,0x00]

v_cmpx_t_u32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// GFX10: encoding: [0xf9,0x04,0xae,0x7d,0x01,0x00,0x06,0x01]

v_cmpx_t_u32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// GFX10: encoding: [0xf9,0x04,0xae,0x7d,0x01,0x00,0x06,0x02]

v_cmpx_t_u32_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// GFX10: encoding: [0xf9,0x04,0xae,0x7d,0x01,0x00,0x06,0x03]

v_cmpx_t_u32_sdwa v1, v2 src0_sel:DWORD src1_sel:WORD_0
// GFX10: encoding: [0xf9,0x04,0xae,0x7d,0x01,0x00,0x06,0x04]

v_cmpx_t_u32_sdwa v1, v2 src0_sel:DWORD src1_sel:WORD_1
// GFX10: encoding: [0xf9,0x04,0xae,0x7d,0x01,0x00,0x06,0x05]

v_cmpx_t_u32_sdwa v1, sext(v2) src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xae,0x7d,0x01,0x00,0x06,0x0e]

v_cmpx_f_f16_sdwa v1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xb0,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_f_f16_sdwa v255, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xb0,0x7d,0xff,0x00,0x06,0x06]

v_cmpx_f_f16_sdwa s1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xb0,0x7d,0x01,0x00,0x86,0x06]

v_cmpx_f_f16_sdwa s101, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xb0,0x7d,0x65,0x00,0x86,0x06]

v_cmpx_f_f16_sdwa vcc_lo, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xb0,0x7d,0x6a,0x00,0x86,0x06]

v_cmpx_f_f16_sdwa vcc_hi, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xb0,0x7d,0x6b,0x00,0x86,0x06]

v_cmpx_f_f16_sdwa m0, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xb0,0x7d,0x7c,0x00,0x86,0x06]

v_cmpx_f_f16_sdwa exec_lo, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xb0,0x7d,0x7e,0x00,0x86,0x06]

v_cmpx_f_f16_sdwa exec_hi, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xb0,0x7d,0x7f,0x00,0x86,0x06]

v_cmpx_f_f16_sdwa v1, v255 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0xfe,0xb1,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_f_f16_sdwa v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xb0,0x7d,0x01,0x00,0x00,0x06]

v_cmpx_f_f16_sdwa v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xb0,0x7d,0x01,0x00,0x01,0x06]

v_cmpx_f_f16_sdwa v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xb0,0x7d,0x01,0x00,0x02,0x06]

v_cmpx_f_f16_sdwa v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xb0,0x7d,0x01,0x00,0x03,0x06]

v_cmpx_f_f16_sdwa v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xb0,0x7d,0x01,0x00,0x04,0x06]

v_cmpx_f_f16_sdwa v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xb0,0x7d,0x01,0x00,0x05,0x06]

v_cmpx_f_f16_sdwa -v1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xb0,0x7d,0x01,0x00,0x16,0x06]

v_cmpx_f_f16_sdwa |v1|, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xb0,0x7d,0x01,0x00,0x26,0x06]

v_cmpx_f_f16_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// GFX10: encoding: [0xf9,0x04,0xb0,0x7d,0x01,0x00,0x06,0x00]

v_cmpx_f_f16_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// GFX10: encoding: [0xf9,0x04,0xb0,0x7d,0x01,0x00,0x06,0x01]

v_cmpx_f_f16_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// GFX10: encoding: [0xf9,0x04,0xb0,0x7d,0x01,0x00,0x06,0x02]

v_cmpx_f_f16_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// GFX10: encoding: [0xf9,0x04,0xb0,0x7d,0x01,0x00,0x06,0x03]

v_cmpx_f_f16_sdwa v1, v2 src0_sel:DWORD src1_sel:WORD_0
// GFX10: encoding: [0xf9,0x04,0xb0,0x7d,0x01,0x00,0x06,0x04]

v_cmpx_f_f16_sdwa v1, v2 src0_sel:DWORD src1_sel:WORD_1
// GFX10: encoding: [0xf9,0x04,0xb0,0x7d,0x01,0x00,0x06,0x05]

v_cmpx_f_f16_sdwa v1, -v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xb0,0x7d,0x01,0x00,0x06,0x16]

v_cmpx_f_f16_sdwa v1, |v2| src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xb0,0x7d,0x01,0x00,0x06,0x26]

v_cmpx_lt_f16_sdwa v1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xb2,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_lt_f16_sdwa v255, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xb2,0x7d,0xff,0x00,0x06,0x06]

v_cmpx_lt_f16_sdwa s1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xb2,0x7d,0x01,0x00,0x86,0x06]

v_cmpx_lt_f16_sdwa s101, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xb2,0x7d,0x65,0x00,0x86,0x06]

v_cmpx_lt_f16_sdwa vcc_lo, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xb2,0x7d,0x6a,0x00,0x86,0x06]

v_cmpx_lt_f16_sdwa vcc_hi, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xb2,0x7d,0x6b,0x00,0x86,0x06]

v_cmpx_lt_f16_sdwa m0, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xb2,0x7d,0x7c,0x00,0x86,0x06]

v_cmpx_lt_f16_sdwa exec_lo, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xb2,0x7d,0x7e,0x00,0x86,0x06]

v_cmpx_lt_f16_sdwa exec_hi, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xb2,0x7d,0x7f,0x00,0x86,0x06]

v_cmpx_lt_f16_sdwa v1, v255 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0xfe,0xb3,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_lt_f16_sdwa v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xb2,0x7d,0x01,0x00,0x00,0x06]

v_cmpx_lt_f16_sdwa v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xb2,0x7d,0x01,0x00,0x01,0x06]

v_cmpx_lt_f16_sdwa v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xb2,0x7d,0x01,0x00,0x02,0x06]

v_cmpx_lt_f16_sdwa v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xb2,0x7d,0x01,0x00,0x03,0x06]

v_cmpx_lt_f16_sdwa v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xb2,0x7d,0x01,0x00,0x04,0x06]

v_cmpx_lt_f16_sdwa v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xb2,0x7d,0x01,0x00,0x05,0x06]

v_cmpx_lt_f16_sdwa -v1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xb2,0x7d,0x01,0x00,0x16,0x06]

v_cmpx_lt_f16_sdwa |v1|, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xb2,0x7d,0x01,0x00,0x26,0x06]

v_cmpx_lt_f16_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// GFX10: encoding: [0xf9,0x04,0xb2,0x7d,0x01,0x00,0x06,0x00]

v_cmpx_lt_f16_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// GFX10: encoding: [0xf9,0x04,0xb2,0x7d,0x01,0x00,0x06,0x01]

v_cmpx_lt_f16_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// GFX10: encoding: [0xf9,0x04,0xb2,0x7d,0x01,0x00,0x06,0x02]

v_cmpx_lt_f16_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// GFX10: encoding: [0xf9,0x04,0xb2,0x7d,0x01,0x00,0x06,0x03]

v_cmpx_lt_f16_sdwa v1, v2 src0_sel:DWORD src1_sel:WORD_0
// GFX10: encoding: [0xf9,0x04,0xb2,0x7d,0x01,0x00,0x06,0x04]

v_cmpx_lt_f16_sdwa v1, v2 src0_sel:DWORD src1_sel:WORD_1
// GFX10: encoding: [0xf9,0x04,0xb2,0x7d,0x01,0x00,0x06,0x05]

v_cmpx_lt_f16_sdwa v1, -v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xb2,0x7d,0x01,0x00,0x06,0x16]

v_cmpx_lt_f16_sdwa v1, |v2| src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xb2,0x7d,0x01,0x00,0x06,0x26]

v_cmpx_eq_f16_sdwa v1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xb4,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_eq_f16_sdwa v255, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xb4,0x7d,0xff,0x00,0x06,0x06]

v_cmpx_eq_f16_sdwa s1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xb4,0x7d,0x01,0x00,0x86,0x06]

v_cmpx_eq_f16_sdwa s101, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xb4,0x7d,0x65,0x00,0x86,0x06]

v_cmpx_eq_f16_sdwa vcc_lo, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xb4,0x7d,0x6a,0x00,0x86,0x06]

v_cmpx_eq_f16_sdwa vcc_hi, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xb4,0x7d,0x6b,0x00,0x86,0x06]

v_cmpx_eq_f16_sdwa m0, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xb4,0x7d,0x7c,0x00,0x86,0x06]

v_cmpx_eq_f16_sdwa exec_lo, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xb4,0x7d,0x7e,0x00,0x86,0x06]

v_cmpx_eq_f16_sdwa exec_hi, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xb4,0x7d,0x7f,0x00,0x86,0x06]

v_cmpx_eq_f16_sdwa v1, v255 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0xfe,0xb5,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_eq_f16_sdwa v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xb4,0x7d,0x01,0x00,0x00,0x06]

v_cmpx_eq_f16_sdwa v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xb4,0x7d,0x01,0x00,0x01,0x06]

v_cmpx_eq_f16_sdwa v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xb4,0x7d,0x01,0x00,0x02,0x06]

v_cmpx_eq_f16_sdwa v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xb4,0x7d,0x01,0x00,0x03,0x06]

v_cmpx_eq_f16_sdwa v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xb4,0x7d,0x01,0x00,0x04,0x06]

v_cmpx_eq_f16_sdwa v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xb4,0x7d,0x01,0x00,0x05,0x06]

v_cmpx_eq_f16_sdwa -v1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xb4,0x7d,0x01,0x00,0x16,0x06]

v_cmpx_eq_f16_sdwa |v1|, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xb4,0x7d,0x01,0x00,0x26,0x06]

v_cmpx_eq_f16_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// GFX10: encoding: [0xf9,0x04,0xb4,0x7d,0x01,0x00,0x06,0x00]

v_cmpx_eq_f16_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// GFX10: encoding: [0xf9,0x04,0xb4,0x7d,0x01,0x00,0x06,0x01]

v_cmpx_eq_f16_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// GFX10: encoding: [0xf9,0x04,0xb4,0x7d,0x01,0x00,0x06,0x02]

v_cmpx_eq_f16_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// GFX10: encoding: [0xf9,0x04,0xb4,0x7d,0x01,0x00,0x06,0x03]

v_cmpx_eq_f16_sdwa v1, v2 src0_sel:DWORD src1_sel:WORD_0
// GFX10: encoding: [0xf9,0x04,0xb4,0x7d,0x01,0x00,0x06,0x04]

v_cmpx_eq_f16_sdwa v1, v2 src0_sel:DWORD src1_sel:WORD_1
// GFX10: encoding: [0xf9,0x04,0xb4,0x7d,0x01,0x00,0x06,0x05]

v_cmpx_eq_f16_sdwa v1, -v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xb4,0x7d,0x01,0x00,0x06,0x16]

v_cmpx_eq_f16_sdwa v1, |v2| src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xb4,0x7d,0x01,0x00,0x06,0x26]

v_cmpx_le_f16_sdwa v1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xb6,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_le_f16_sdwa v255, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xb6,0x7d,0xff,0x00,0x06,0x06]

v_cmpx_le_f16_sdwa s1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xb6,0x7d,0x01,0x00,0x86,0x06]

v_cmpx_le_f16_sdwa s101, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xb6,0x7d,0x65,0x00,0x86,0x06]

v_cmpx_le_f16_sdwa vcc_lo, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xb6,0x7d,0x6a,0x00,0x86,0x06]

v_cmpx_le_f16_sdwa vcc_hi, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xb6,0x7d,0x6b,0x00,0x86,0x06]

v_cmpx_le_f16_sdwa m0, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xb6,0x7d,0x7c,0x00,0x86,0x06]

v_cmpx_le_f16_sdwa exec_lo, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xb6,0x7d,0x7e,0x00,0x86,0x06]

v_cmpx_le_f16_sdwa exec_hi, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xb6,0x7d,0x7f,0x00,0x86,0x06]

v_cmpx_le_f16_sdwa v1, v255 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0xfe,0xb7,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_le_f16_sdwa v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xb6,0x7d,0x01,0x00,0x00,0x06]

v_cmpx_le_f16_sdwa v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xb6,0x7d,0x01,0x00,0x01,0x06]

v_cmpx_le_f16_sdwa v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xb6,0x7d,0x01,0x00,0x02,0x06]

v_cmpx_le_f16_sdwa v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xb6,0x7d,0x01,0x00,0x03,0x06]

v_cmpx_le_f16_sdwa v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xb6,0x7d,0x01,0x00,0x04,0x06]

v_cmpx_le_f16_sdwa v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xb6,0x7d,0x01,0x00,0x05,0x06]

v_cmpx_le_f16_sdwa -v1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xb6,0x7d,0x01,0x00,0x16,0x06]

v_cmpx_le_f16_sdwa |v1|, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xb6,0x7d,0x01,0x00,0x26,0x06]

v_cmpx_le_f16_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// GFX10: encoding: [0xf9,0x04,0xb6,0x7d,0x01,0x00,0x06,0x00]

v_cmpx_le_f16_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// GFX10: encoding: [0xf9,0x04,0xb6,0x7d,0x01,0x00,0x06,0x01]

v_cmpx_le_f16_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// GFX10: encoding: [0xf9,0x04,0xb6,0x7d,0x01,0x00,0x06,0x02]

v_cmpx_le_f16_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// GFX10: encoding: [0xf9,0x04,0xb6,0x7d,0x01,0x00,0x06,0x03]

v_cmpx_le_f16_sdwa v1, v2 src0_sel:DWORD src1_sel:WORD_0
// GFX10: encoding: [0xf9,0x04,0xb6,0x7d,0x01,0x00,0x06,0x04]

v_cmpx_le_f16_sdwa v1, v2 src0_sel:DWORD src1_sel:WORD_1
// GFX10: encoding: [0xf9,0x04,0xb6,0x7d,0x01,0x00,0x06,0x05]

v_cmpx_le_f16_sdwa v1, -v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xb6,0x7d,0x01,0x00,0x06,0x16]

v_cmpx_le_f16_sdwa v1, |v2| src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xb6,0x7d,0x01,0x00,0x06,0x26]

v_cmpx_gt_f16_sdwa v1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xb8,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_gt_f16_sdwa v255, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xb8,0x7d,0xff,0x00,0x06,0x06]

v_cmpx_gt_f16_sdwa s1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xb8,0x7d,0x01,0x00,0x86,0x06]

v_cmpx_gt_f16_sdwa s101, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xb8,0x7d,0x65,0x00,0x86,0x06]

v_cmpx_gt_f16_sdwa vcc_lo, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xb8,0x7d,0x6a,0x00,0x86,0x06]

v_cmpx_gt_f16_sdwa vcc_hi, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xb8,0x7d,0x6b,0x00,0x86,0x06]

v_cmpx_gt_f16_sdwa m0, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xb8,0x7d,0x7c,0x00,0x86,0x06]

v_cmpx_gt_f16_sdwa exec_lo, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xb8,0x7d,0x7e,0x00,0x86,0x06]

v_cmpx_gt_f16_sdwa exec_hi, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xb8,0x7d,0x7f,0x00,0x86,0x06]

v_cmpx_gt_f16_sdwa v1, v255 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0xfe,0xb9,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_gt_f16_sdwa v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xb8,0x7d,0x01,0x00,0x00,0x06]

v_cmpx_gt_f16_sdwa v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xb8,0x7d,0x01,0x00,0x01,0x06]

v_cmpx_gt_f16_sdwa v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xb8,0x7d,0x01,0x00,0x02,0x06]

v_cmpx_gt_f16_sdwa v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xb8,0x7d,0x01,0x00,0x03,0x06]

v_cmpx_gt_f16_sdwa v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xb8,0x7d,0x01,0x00,0x04,0x06]

v_cmpx_gt_f16_sdwa v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xb8,0x7d,0x01,0x00,0x05,0x06]

v_cmpx_gt_f16_sdwa -v1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xb8,0x7d,0x01,0x00,0x16,0x06]

v_cmpx_gt_f16_sdwa |v1|, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xb8,0x7d,0x01,0x00,0x26,0x06]

v_cmpx_gt_f16_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// GFX10: encoding: [0xf9,0x04,0xb8,0x7d,0x01,0x00,0x06,0x00]

v_cmpx_gt_f16_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// GFX10: encoding: [0xf9,0x04,0xb8,0x7d,0x01,0x00,0x06,0x01]

v_cmpx_gt_f16_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// GFX10: encoding: [0xf9,0x04,0xb8,0x7d,0x01,0x00,0x06,0x02]

v_cmpx_gt_f16_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// GFX10: encoding: [0xf9,0x04,0xb8,0x7d,0x01,0x00,0x06,0x03]

v_cmpx_gt_f16_sdwa v1, v2 src0_sel:DWORD src1_sel:WORD_0
// GFX10: encoding: [0xf9,0x04,0xb8,0x7d,0x01,0x00,0x06,0x04]

v_cmpx_gt_f16_sdwa v1, v2 src0_sel:DWORD src1_sel:WORD_1
// GFX10: encoding: [0xf9,0x04,0xb8,0x7d,0x01,0x00,0x06,0x05]

v_cmpx_gt_f16_sdwa v1, -v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xb8,0x7d,0x01,0x00,0x06,0x16]

v_cmpx_gt_f16_sdwa v1, |v2| src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xb8,0x7d,0x01,0x00,0x06,0x26]

v_cmpx_lg_f16_sdwa v1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xba,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_lg_f16_sdwa v255, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xba,0x7d,0xff,0x00,0x06,0x06]

v_cmpx_lg_f16_sdwa s1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xba,0x7d,0x01,0x00,0x86,0x06]

v_cmpx_lg_f16_sdwa s101, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xba,0x7d,0x65,0x00,0x86,0x06]

v_cmpx_lg_f16_sdwa vcc_lo, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xba,0x7d,0x6a,0x00,0x86,0x06]

v_cmpx_lg_f16_sdwa vcc_hi, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xba,0x7d,0x6b,0x00,0x86,0x06]

v_cmpx_lg_f16_sdwa m0, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xba,0x7d,0x7c,0x00,0x86,0x06]

v_cmpx_lg_f16_sdwa exec_lo, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xba,0x7d,0x7e,0x00,0x86,0x06]

v_cmpx_lg_f16_sdwa exec_hi, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xba,0x7d,0x7f,0x00,0x86,0x06]

v_cmpx_lg_f16_sdwa v1, v255 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0xfe,0xbb,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_lg_f16_sdwa v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xba,0x7d,0x01,0x00,0x00,0x06]

v_cmpx_lg_f16_sdwa v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xba,0x7d,0x01,0x00,0x01,0x06]

v_cmpx_lg_f16_sdwa v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xba,0x7d,0x01,0x00,0x02,0x06]

v_cmpx_lg_f16_sdwa v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xba,0x7d,0x01,0x00,0x03,0x06]

v_cmpx_lg_f16_sdwa v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xba,0x7d,0x01,0x00,0x04,0x06]

v_cmpx_lg_f16_sdwa v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xba,0x7d,0x01,0x00,0x05,0x06]

v_cmpx_lg_f16_sdwa -v1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xba,0x7d,0x01,0x00,0x16,0x06]

v_cmpx_lg_f16_sdwa |v1|, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xba,0x7d,0x01,0x00,0x26,0x06]

v_cmpx_lg_f16_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// GFX10: encoding: [0xf9,0x04,0xba,0x7d,0x01,0x00,0x06,0x00]

v_cmpx_lg_f16_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// GFX10: encoding: [0xf9,0x04,0xba,0x7d,0x01,0x00,0x06,0x01]

v_cmpx_lg_f16_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// GFX10: encoding: [0xf9,0x04,0xba,0x7d,0x01,0x00,0x06,0x02]

v_cmpx_lg_f16_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// GFX10: encoding: [0xf9,0x04,0xba,0x7d,0x01,0x00,0x06,0x03]

v_cmpx_lg_f16_sdwa v1, v2 src0_sel:DWORD src1_sel:WORD_0
// GFX10: encoding: [0xf9,0x04,0xba,0x7d,0x01,0x00,0x06,0x04]

v_cmpx_lg_f16_sdwa v1, v2 src0_sel:DWORD src1_sel:WORD_1
// GFX10: encoding: [0xf9,0x04,0xba,0x7d,0x01,0x00,0x06,0x05]

v_cmpx_lg_f16_sdwa v1, -v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xba,0x7d,0x01,0x00,0x06,0x16]

v_cmpx_lg_f16_sdwa v1, |v2| src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xba,0x7d,0x01,0x00,0x06,0x26]

v_cmpx_ge_f16_sdwa v1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xbc,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_ge_f16_sdwa v255, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xbc,0x7d,0xff,0x00,0x06,0x06]

v_cmpx_ge_f16_sdwa s1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xbc,0x7d,0x01,0x00,0x86,0x06]

v_cmpx_ge_f16_sdwa s101, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xbc,0x7d,0x65,0x00,0x86,0x06]

v_cmpx_ge_f16_sdwa vcc_lo, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xbc,0x7d,0x6a,0x00,0x86,0x06]

v_cmpx_ge_f16_sdwa vcc_hi, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xbc,0x7d,0x6b,0x00,0x86,0x06]

v_cmpx_ge_f16_sdwa m0, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xbc,0x7d,0x7c,0x00,0x86,0x06]

v_cmpx_ge_f16_sdwa exec_lo, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xbc,0x7d,0x7e,0x00,0x86,0x06]

v_cmpx_ge_f16_sdwa exec_hi, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xbc,0x7d,0x7f,0x00,0x86,0x06]

v_cmpx_ge_f16_sdwa v1, v255 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0xfe,0xbd,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_ge_f16_sdwa v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xbc,0x7d,0x01,0x00,0x00,0x06]

v_cmpx_ge_f16_sdwa v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xbc,0x7d,0x01,0x00,0x01,0x06]

v_cmpx_ge_f16_sdwa v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xbc,0x7d,0x01,0x00,0x02,0x06]

v_cmpx_ge_f16_sdwa v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xbc,0x7d,0x01,0x00,0x03,0x06]

v_cmpx_ge_f16_sdwa v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xbc,0x7d,0x01,0x00,0x04,0x06]

v_cmpx_ge_f16_sdwa v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xbc,0x7d,0x01,0x00,0x05,0x06]

v_cmpx_ge_f16_sdwa -v1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xbc,0x7d,0x01,0x00,0x16,0x06]

v_cmpx_ge_f16_sdwa |v1|, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xbc,0x7d,0x01,0x00,0x26,0x06]

v_cmpx_ge_f16_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// GFX10: encoding: [0xf9,0x04,0xbc,0x7d,0x01,0x00,0x06,0x00]

v_cmpx_ge_f16_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// GFX10: encoding: [0xf9,0x04,0xbc,0x7d,0x01,0x00,0x06,0x01]

v_cmpx_ge_f16_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// GFX10: encoding: [0xf9,0x04,0xbc,0x7d,0x01,0x00,0x06,0x02]

v_cmpx_ge_f16_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// GFX10: encoding: [0xf9,0x04,0xbc,0x7d,0x01,0x00,0x06,0x03]

v_cmpx_ge_f16_sdwa v1, v2 src0_sel:DWORD src1_sel:WORD_0
// GFX10: encoding: [0xf9,0x04,0xbc,0x7d,0x01,0x00,0x06,0x04]

v_cmpx_ge_f16_sdwa v1, v2 src0_sel:DWORD src1_sel:WORD_1
// GFX10: encoding: [0xf9,0x04,0xbc,0x7d,0x01,0x00,0x06,0x05]

v_cmpx_ge_f16_sdwa v1, -v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xbc,0x7d,0x01,0x00,0x06,0x16]

v_cmpx_ge_f16_sdwa v1, |v2| src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xbc,0x7d,0x01,0x00,0x06,0x26]

v_cmpx_o_f16_sdwa v1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xbe,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_o_f16_sdwa v255, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xbe,0x7d,0xff,0x00,0x06,0x06]

v_cmpx_o_f16_sdwa s1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xbe,0x7d,0x01,0x00,0x86,0x06]

v_cmpx_o_f16_sdwa s101, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xbe,0x7d,0x65,0x00,0x86,0x06]

v_cmpx_o_f16_sdwa vcc_lo, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xbe,0x7d,0x6a,0x00,0x86,0x06]

v_cmpx_o_f16_sdwa vcc_hi, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xbe,0x7d,0x6b,0x00,0x86,0x06]

v_cmpx_o_f16_sdwa m0, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xbe,0x7d,0x7c,0x00,0x86,0x06]

v_cmpx_o_f16_sdwa exec_lo, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xbe,0x7d,0x7e,0x00,0x86,0x06]

v_cmpx_o_f16_sdwa exec_hi, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xbe,0x7d,0x7f,0x00,0x86,0x06]

v_cmpx_o_f16_sdwa v1, v255 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0xfe,0xbf,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_o_f16_sdwa v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xbe,0x7d,0x01,0x00,0x00,0x06]

v_cmpx_o_f16_sdwa v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xbe,0x7d,0x01,0x00,0x01,0x06]

v_cmpx_o_f16_sdwa v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xbe,0x7d,0x01,0x00,0x02,0x06]

v_cmpx_o_f16_sdwa v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xbe,0x7d,0x01,0x00,0x03,0x06]

v_cmpx_o_f16_sdwa v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xbe,0x7d,0x01,0x00,0x04,0x06]

v_cmpx_o_f16_sdwa v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xbe,0x7d,0x01,0x00,0x05,0x06]

v_cmpx_o_f16_sdwa -v1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xbe,0x7d,0x01,0x00,0x16,0x06]

v_cmpx_o_f16_sdwa |v1|, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xbe,0x7d,0x01,0x00,0x26,0x06]

v_cmpx_o_f16_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// GFX10: encoding: [0xf9,0x04,0xbe,0x7d,0x01,0x00,0x06,0x00]

v_cmpx_o_f16_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// GFX10: encoding: [0xf9,0x04,0xbe,0x7d,0x01,0x00,0x06,0x01]

v_cmpx_o_f16_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// GFX10: encoding: [0xf9,0x04,0xbe,0x7d,0x01,0x00,0x06,0x02]

v_cmpx_o_f16_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// GFX10: encoding: [0xf9,0x04,0xbe,0x7d,0x01,0x00,0x06,0x03]

v_cmpx_o_f16_sdwa v1, v2 src0_sel:DWORD src1_sel:WORD_0
// GFX10: encoding: [0xf9,0x04,0xbe,0x7d,0x01,0x00,0x06,0x04]

v_cmpx_o_f16_sdwa v1, v2 src0_sel:DWORD src1_sel:WORD_1
// GFX10: encoding: [0xf9,0x04,0xbe,0x7d,0x01,0x00,0x06,0x05]

v_cmpx_o_f16_sdwa v1, -v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xbe,0x7d,0x01,0x00,0x06,0x16]

v_cmpx_o_f16_sdwa v1, |v2| src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xbe,0x7d,0x01,0x00,0x06,0x26]

v_cmpx_u_f16_sdwa v1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xf0,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_u_f16_sdwa v255, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xf0,0x7d,0xff,0x00,0x06,0x06]

v_cmpx_u_f16_sdwa s1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xf0,0x7d,0x01,0x00,0x86,0x06]

v_cmpx_u_f16_sdwa s101, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xf0,0x7d,0x65,0x00,0x86,0x06]

v_cmpx_u_f16_sdwa vcc_lo, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xf0,0x7d,0x6a,0x00,0x86,0x06]

v_cmpx_u_f16_sdwa vcc_hi, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xf0,0x7d,0x6b,0x00,0x86,0x06]

v_cmpx_u_f16_sdwa m0, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xf0,0x7d,0x7c,0x00,0x86,0x06]

v_cmpx_u_f16_sdwa exec_lo, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xf0,0x7d,0x7e,0x00,0x86,0x06]

v_cmpx_u_f16_sdwa exec_hi, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xf0,0x7d,0x7f,0x00,0x86,0x06]

v_cmpx_u_f16_sdwa v1, v255 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0xfe,0xf1,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_u_f16_sdwa v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xf0,0x7d,0x01,0x00,0x00,0x06]

v_cmpx_u_f16_sdwa v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xf0,0x7d,0x01,0x00,0x01,0x06]

v_cmpx_u_f16_sdwa v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xf0,0x7d,0x01,0x00,0x02,0x06]

v_cmpx_u_f16_sdwa v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xf0,0x7d,0x01,0x00,0x03,0x06]

v_cmpx_u_f16_sdwa v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xf0,0x7d,0x01,0x00,0x04,0x06]

v_cmpx_u_f16_sdwa v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xf0,0x7d,0x01,0x00,0x05,0x06]

v_cmpx_u_f16_sdwa -v1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xf0,0x7d,0x01,0x00,0x16,0x06]

v_cmpx_u_f16_sdwa |v1|, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xf0,0x7d,0x01,0x00,0x26,0x06]

v_cmpx_u_f16_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// GFX10: encoding: [0xf9,0x04,0xf0,0x7d,0x01,0x00,0x06,0x00]

v_cmpx_u_f16_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// GFX10: encoding: [0xf9,0x04,0xf0,0x7d,0x01,0x00,0x06,0x01]

v_cmpx_u_f16_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// GFX10: encoding: [0xf9,0x04,0xf0,0x7d,0x01,0x00,0x06,0x02]

v_cmpx_u_f16_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// GFX10: encoding: [0xf9,0x04,0xf0,0x7d,0x01,0x00,0x06,0x03]

v_cmpx_u_f16_sdwa v1, v2 src0_sel:DWORD src1_sel:WORD_0
// GFX10: encoding: [0xf9,0x04,0xf0,0x7d,0x01,0x00,0x06,0x04]

v_cmpx_u_f16_sdwa v1, v2 src0_sel:DWORD src1_sel:WORD_1
// GFX10: encoding: [0xf9,0x04,0xf0,0x7d,0x01,0x00,0x06,0x05]

v_cmpx_u_f16_sdwa v1, -v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xf0,0x7d,0x01,0x00,0x06,0x16]

v_cmpx_u_f16_sdwa v1, |v2| src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xf0,0x7d,0x01,0x00,0x06,0x26]

v_cmpx_nge_f16_sdwa v1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xf2,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_nge_f16_sdwa v255, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xf2,0x7d,0xff,0x00,0x06,0x06]

v_cmpx_nge_f16_sdwa s1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xf2,0x7d,0x01,0x00,0x86,0x06]

v_cmpx_nge_f16_sdwa s101, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xf2,0x7d,0x65,0x00,0x86,0x06]

v_cmpx_nge_f16_sdwa vcc_lo, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xf2,0x7d,0x6a,0x00,0x86,0x06]

v_cmpx_nge_f16_sdwa vcc_hi, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xf2,0x7d,0x6b,0x00,0x86,0x06]

v_cmpx_nge_f16_sdwa m0, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xf2,0x7d,0x7c,0x00,0x86,0x06]

v_cmpx_nge_f16_sdwa exec_lo, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xf2,0x7d,0x7e,0x00,0x86,0x06]

v_cmpx_nge_f16_sdwa exec_hi, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xf2,0x7d,0x7f,0x00,0x86,0x06]

v_cmpx_nge_f16_sdwa v1, v255 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0xfe,0xf3,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_nge_f16_sdwa v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xf2,0x7d,0x01,0x00,0x00,0x06]

v_cmpx_nge_f16_sdwa v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xf2,0x7d,0x01,0x00,0x01,0x06]

v_cmpx_nge_f16_sdwa v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xf2,0x7d,0x01,0x00,0x02,0x06]

v_cmpx_nge_f16_sdwa v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xf2,0x7d,0x01,0x00,0x03,0x06]

v_cmpx_nge_f16_sdwa v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xf2,0x7d,0x01,0x00,0x04,0x06]

v_cmpx_nge_f16_sdwa v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xf2,0x7d,0x01,0x00,0x05,0x06]

v_cmpx_nge_f16_sdwa -v1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xf2,0x7d,0x01,0x00,0x16,0x06]

v_cmpx_nge_f16_sdwa |v1|, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xf2,0x7d,0x01,0x00,0x26,0x06]

v_cmpx_nge_f16_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// GFX10: encoding: [0xf9,0x04,0xf2,0x7d,0x01,0x00,0x06,0x00]

v_cmpx_nge_f16_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// GFX10: encoding: [0xf9,0x04,0xf2,0x7d,0x01,0x00,0x06,0x01]

v_cmpx_nge_f16_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// GFX10: encoding: [0xf9,0x04,0xf2,0x7d,0x01,0x00,0x06,0x02]

v_cmpx_nge_f16_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// GFX10: encoding: [0xf9,0x04,0xf2,0x7d,0x01,0x00,0x06,0x03]

v_cmpx_nge_f16_sdwa v1, v2 src0_sel:DWORD src1_sel:WORD_0
// GFX10: encoding: [0xf9,0x04,0xf2,0x7d,0x01,0x00,0x06,0x04]

v_cmpx_nge_f16_sdwa v1, v2 src0_sel:DWORD src1_sel:WORD_1
// GFX10: encoding: [0xf9,0x04,0xf2,0x7d,0x01,0x00,0x06,0x05]

v_cmpx_nge_f16_sdwa v1, -v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xf2,0x7d,0x01,0x00,0x06,0x16]

v_cmpx_nge_f16_sdwa v1, |v2| src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xf2,0x7d,0x01,0x00,0x06,0x26]

v_cmpx_nlg_f16_sdwa v1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xf4,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_nlg_f16_sdwa v255, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xf4,0x7d,0xff,0x00,0x06,0x06]

v_cmpx_nlg_f16_sdwa s1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xf4,0x7d,0x01,0x00,0x86,0x06]

v_cmpx_nlg_f16_sdwa s101, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xf4,0x7d,0x65,0x00,0x86,0x06]

v_cmpx_nlg_f16_sdwa vcc_lo, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xf4,0x7d,0x6a,0x00,0x86,0x06]

v_cmpx_nlg_f16_sdwa vcc_hi, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xf4,0x7d,0x6b,0x00,0x86,0x06]

v_cmpx_nlg_f16_sdwa m0, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xf4,0x7d,0x7c,0x00,0x86,0x06]

v_cmpx_nlg_f16_sdwa exec_lo, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xf4,0x7d,0x7e,0x00,0x86,0x06]

v_cmpx_nlg_f16_sdwa exec_hi, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xf4,0x7d,0x7f,0x00,0x86,0x06]

v_cmpx_nlg_f16_sdwa v1, v255 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0xfe,0xf5,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_nlg_f16_sdwa v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xf4,0x7d,0x01,0x00,0x00,0x06]

v_cmpx_nlg_f16_sdwa v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xf4,0x7d,0x01,0x00,0x01,0x06]

v_cmpx_nlg_f16_sdwa v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xf4,0x7d,0x01,0x00,0x02,0x06]

v_cmpx_nlg_f16_sdwa v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xf4,0x7d,0x01,0x00,0x03,0x06]

v_cmpx_nlg_f16_sdwa v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xf4,0x7d,0x01,0x00,0x04,0x06]

v_cmpx_nlg_f16_sdwa v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xf4,0x7d,0x01,0x00,0x05,0x06]

v_cmpx_nlg_f16_sdwa -v1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xf4,0x7d,0x01,0x00,0x16,0x06]

v_cmpx_nlg_f16_sdwa |v1|, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xf4,0x7d,0x01,0x00,0x26,0x06]

v_cmpx_nlg_f16_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// GFX10: encoding: [0xf9,0x04,0xf4,0x7d,0x01,0x00,0x06,0x00]

v_cmpx_nlg_f16_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// GFX10: encoding: [0xf9,0x04,0xf4,0x7d,0x01,0x00,0x06,0x01]

v_cmpx_nlg_f16_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// GFX10: encoding: [0xf9,0x04,0xf4,0x7d,0x01,0x00,0x06,0x02]

v_cmpx_nlg_f16_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// GFX10: encoding: [0xf9,0x04,0xf4,0x7d,0x01,0x00,0x06,0x03]

v_cmpx_nlg_f16_sdwa v1, v2 src0_sel:DWORD src1_sel:WORD_0
// GFX10: encoding: [0xf9,0x04,0xf4,0x7d,0x01,0x00,0x06,0x04]

v_cmpx_nlg_f16_sdwa v1, v2 src0_sel:DWORD src1_sel:WORD_1
// GFX10: encoding: [0xf9,0x04,0xf4,0x7d,0x01,0x00,0x06,0x05]

v_cmpx_nlg_f16_sdwa v1, -v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xf4,0x7d,0x01,0x00,0x06,0x16]

v_cmpx_nlg_f16_sdwa v1, |v2| src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xf4,0x7d,0x01,0x00,0x06,0x26]

v_cmpx_ngt_f16_sdwa v1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xf6,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_ngt_f16_sdwa v255, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xf6,0x7d,0xff,0x00,0x06,0x06]

v_cmpx_ngt_f16_sdwa s1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xf6,0x7d,0x01,0x00,0x86,0x06]

v_cmpx_ngt_f16_sdwa s101, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xf6,0x7d,0x65,0x00,0x86,0x06]

v_cmpx_ngt_f16_sdwa vcc_lo, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xf6,0x7d,0x6a,0x00,0x86,0x06]

v_cmpx_ngt_f16_sdwa vcc_hi, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xf6,0x7d,0x6b,0x00,0x86,0x06]

v_cmpx_ngt_f16_sdwa m0, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xf6,0x7d,0x7c,0x00,0x86,0x06]

v_cmpx_ngt_f16_sdwa exec_lo, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xf6,0x7d,0x7e,0x00,0x86,0x06]

v_cmpx_ngt_f16_sdwa exec_hi, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xf6,0x7d,0x7f,0x00,0x86,0x06]

v_cmpx_ngt_f16_sdwa v1, v255 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0xfe,0xf7,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_ngt_f16_sdwa v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xf6,0x7d,0x01,0x00,0x00,0x06]

v_cmpx_ngt_f16_sdwa v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xf6,0x7d,0x01,0x00,0x01,0x06]

v_cmpx_ngt_f16_sdwa v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xf6,0x7d,0x01,0x00,0x02,0x06]

v_cmpx_ngt_f16_sdwa v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xf6,0x7d,0x01,0x00,0x03,0x06]

v_cmpx_ngt_f16_sdwa v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xf6,0x7d,0x01,0x00,0x04,0x06]

v_cmpx_ngt_f16_sdwa v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xf6,0x7d,0x01,0x00,0x05,0x06]

v_cmpx_ngt_f16_sdwa -v1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xf6,0x7d,0x01,0x00,0x16,0x06]

v_cmpx_ngt_f16_sdwa |v1|, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xf6,0x7d,0x01,0x00,0x26,0x06]

v_cmpx_ngt_f16_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// GFX10: encoding: [0xf9,0x04,0xf6,0x7d,0x01,0x00,0x06,0x00]

v_cmpx_ngt_f16_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// GFX10: encoding: [0xf9,0x04,0xf6,0x7d,0x01,0x00,0x06,0x01]

v_cmpx_ngt_f16_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// GFX10: encoding: [0xf9,0x04,0xf6,0x7d,0x01,0x00,0x06,0x02]

v_cmpx_ngt_f16_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// GFX10: encoding: [0xf9,0x04,0xf6,0x7d,0x01,0x00,0x06,0x03]

v_cmpx_ngt_f16_sdwa v1, v2 src0_sel:DWORD src1_sel:WORD_0
// GFX10: encoding: [0xf9,0x04,0xf6,0x7d,0x01,0x00,0x06,0x04]

v_cmpx_ngt_f16_sdwa v1, v2 src0_sel:DWORD src1_sel:WORD_1
// GFX10: encoding: [0xf9,0x04,0xf6,0x7d,0x01,0x00,0x06,0x05]

v_cmpx_ngt_f16_sdwa v1, -v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xf6,0x7d,0x01,0x00,0x06,0x16]

v_cmpx_ngt_f16_sdwa v1, |v2| src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xf6,0x7d,0x01,0x00,0x06,0x26]

v_cmpx_nle_f16_sdwa v1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xf8,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_nle_f16_sdwa v255, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xf8,0x7d,0xff,0x00,0x06,0x06]

v_cmpx_nle_f16_sdwa s1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xf8,0x7d,0x01,0x00,0x86,0x06]

v_cmpx_nle_f16_sdwa s101, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xf8,0x7d,0x65,0x00,0x86,0x06]

v_cmpx_nle_f16_sdwa vcc_lo, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xf8,0x7d,0x6a,0x00,0x86,0x06]

v_cmpx_nle_f16_sdwa vcc_hi, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xf8,0x7d,0x6b,0x00,0x86,0x06]

v_cmpx_nle_f16_sdwa m0, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xf8,0x7d,0x7c,0x00,0x86,0x06]

v_cmpx_nle_f16_sdwa exec_lo, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xf8,0x7d,0x7e,0x00,0x86,0x06]

v_cmpx_nle_f16_sdwa exec_hi, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xf8,0x7d,0x7f,0x00,0x86,0x06]

v_cmpx_nle_f16_sdwa v1, v255 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0xfe,0xf9,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_nle_f16_sdwa v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xf8,0x7d,0x01,0x00,0x00,0x06]

v_cmpx_nle_f16_sdwa v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xf8,0x7d,0x01,0x00,0x01,0x06]

v_cmpx_nle_f16_sdwa v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xf8,0x7d,0x01,0x00,0x02,0x06]

v_cmpx_nle_f16_sdwa v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xf8,0x7d,0x01,0x00,0x03,0x06]

v_cmpx_nle_f16_sdwa v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xf8,0x7d,0x01,0x00,0x04,0x06]

v_cmpx_nle_f16_sdwa v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xf8,0x7d,0x01,0x00,0x05,0x06]

v_cmpx_nle_f16_sdwa -v1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xf8,0x7d,0x01,0x00,0x16,0x06]

v_cmpx_nle_f16_sdwa |v1|, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xf8,0x7d,0x01,0x00,0x26,0x06]

v_cmpx_nle_f16_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// GFX10: encoding: [0xf9,0x04,0xf8,0x7d,0x01,0x00,0x06,0x00]

v_cmpx_nle_f16_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// GFX10: encoding: [0xf9,0x04,0xf8,0x7d,0x01,0x00,0x06,0x01]

v_cmpx_nle_f16_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// GFX10: encoding: [0xf9,0x04,0xf8,0x7d,0x01,0x00,0x06,0x02]

v_cmpx_nle_f16_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// GFX10: encoding: [0xf9,0x04,0xf8,0x7d,0x01,0x00,0x06,0x03]

v_cmpx_nle_f16_sdwa v1, v2 src0_sel:DWORD src1_sel:WORD_0
// GFX10: encoding: [0xf9,0x04,0xf8,0x7d,0x01,0x00,0x06,0x04]

v_cmpx_nle_f16_sdwa v1, v2 src0_sel:DWORD src1_sel:WORD_1
// GFX10: encoding: [0xf9,0x04,0xf8,0x7d,0x01,0x00,0x06,0x05]

v_cmpx_nle_f16_sdwa v1, -v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xf8,0x7d,0x01,0x00,0x06,0x16]

v_cmpx_nle_f16_sdwa v1, |v2| src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xf8,0x7d,0x01,0x00,0x06,0x26]

v_cmpx_neq_f16_sdwa v1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xfa,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_neq_f16_sdwa v255, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xfa,0x7d,0xff,0x00,0x06,0x06]

v_cmpx_neq_f16_sdwa s1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xfa,0x7d,0x01,0x00,0x86,0x06]

v_cmpx_neq_f16_sdwa s101, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xfa,0x7d,0x65,0x00,0x86,0x06]

v_cmpx_neq_f16_sdwa vcc_lo, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xfa,0x7d,0x6a,0x00,0x86,0x06]

v_cmpx_neq_f16_sdwa vcc_hi, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xfa,0x7d,0x6b,0x00,0x86,0x06]

v_cmpx_neq_f16_sdwa m0, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xfa,0x7d,0x7c,0x00,0x86,0x06]

v_cmpx_neq_f16_sdwa exec_lo, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xfa,0x7d,0x7e,0x00,0x86,0x06]

v_cmpx_neq_f16_sdwa exec_hi, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xfa,0x7d,0x7f,0x00,0x86,0x06]

v_cmpx_neq_f16_sdwa v1, v255 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0xfe,0xfb,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_neq_f16_sdwa v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xfa,0x7d,0x01,0x00,0x00,0x06]

v_cmpx_neq_f16_sdwa v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xfa,0x7d,0x01,0x00,0x01,0x06]

v_cmpx_neq_f16_sdwa v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xfa,0x7d,0x01,0x00,0x02,0x06]

v_cmpx_neq_f16_sdwa v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xfa,0x7d,0x01,0x00,0x03,0x06]

v_cmpx_neq_f16_sdwa v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xfa,0x7d,0x01,0x00,0x04,0x06]

v_cmpx_neq_f16_sdwa v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xfa,0x7d,0x01,0x00,0x05,0x06]

v_cmpx_neq_f16_sdwa -v1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xfa,0x7d,0x01,0x00,0x16,0x06]

v_cmpx_neq_f16_sdwa |v1|, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xfa,0x7d,0x01,0x00,0x26,0x06]

v_cmpx_neq_f16_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// GFX10: encoding: [0xf9,0x04,0xfa,0x7d,0x01,0x00,0x06,0x00]

v_cmpx_neq_f16_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// GFX10: encoding: [0xf9,0x04,0xfa,0x7d,0x01,0x00,0x06,0x01]

v_cmpx_neq_f16_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// GFX10: encoding: [0xf9,0x04,0xfa,0x7d,0x01,0x00,0x06,0x02]

v_cmpx_neq_f16_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// GFX10: encoding: [0xf9,0x04,0xfa,0x7d,0x01,0x00,0x06,0x03]

v_cmpx_neq_f16_sdwa v1, v2 src0_sel:DWORD src1_sel:WORD_0
// GFX10: encoding: [0xf9,0x04,0xfa,0x7d,0x01,0x00,0x06,0x04]

v_cmpx_neq_f16_sdwa v1, v2 src0_sel:DWORD src1_sel:WORD_1
// GFX10: encoding: [0xf9,0x04,0xfa,0x7d,0x01,0x00,0x06,0x05]

v_cmpx_neq_f16_sdwa v1, -v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xfa,0x7d,0x01,0x00,0x06,0x16]

v_cmpx_neq_f16_sdwa v1, |v2| src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xfa,0x7d,0x01,0x00,0x06,0x26]

v_cmpx_nlt_f16_sdwa v1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xfc,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_nlt_f16_sdwa v255, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xfc,0x7d,0xff,0x00,0x06,0x06]

v_cmpx_nlt_f16_sdwa s1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xfc,0x7d,0x01,0x00,0x86,0x06]

v_cmpx_nlt_f16_sdwa s101, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xfc,0x7d,0x65,0x00,0x86,0x06]

v_cmpx_nlt_f16_sdwa vcc_lo, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xfc,0x7d,0x6a,0x00,0x86,0x06]

v_cmpx_nlt_f16_sdwa vcc_hi, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xfc,0x7d,0x6b,0x00,0x86,0x06]

v_cmpx_nlt_f16_sdwa m0, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xfc,0x7d,0x7c,0x00,0x86,0x06]

v_cmpx_nlt_f16_sdwa exec_lo, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xfc,0x7d,0x7e,0x00,0x86,0x06]

v_cmpx_nlt_f16_sdwa exec_hi, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xfc,0x7d,0x7f,0x00,0x86,0x06]

v_cmpx_nlt_f16_sdwa v1, v255 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0xfe,0xfd,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_nlt_f16_sdwa v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xfc,0x7d,0x01,0x00,0x00,0x06]

v_cmpx_nlt_f16_sdwa v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xfc,0x7d,0x01,0x00,0x01,0x06]

v_cmpx_nlt_f16_sdwa v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xfc,0x7d,0x01,0x00,0x02,0x06]

v_cmpx_nlt_f16_sdwa v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xfc,0x7d,0x01,0x00,0x03,0x06]

v_cmpx_nlt_f16_sdwa v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xfc,0x7d,0x01,0x00,0x04,0x06]

v_cmpx_nlt_f16_sdwa v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xfc,0x7d,0x01,0x00,0x05,0x06]

v_cmpx_nlt_f16_sdwa -v1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xfc,0x7d,0x01,0x00,0x16,0x06]

v_cmpx_nlt_f16_sdwa |v1|, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xfc,0x7d,0x01,0x00,0x26,0x06]

v_cmpx_nlt_f16_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// GFX10: encoding: [0xf9,0x04,0xfc,0x7d,0x01,0x00,0x06,0x00]

v_cmpx_nlt_f16_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// GFX10: encoding: [0xf9,0x04,0xfc,0x7d,0x01,0x00,0x06,0x01]

v_cmpx_nlt_f16_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// GFX10: encoding: [0xf9,0x04,0xfc,0x7d,0x01,0x00,0x06,0x02]

v_cmpx_nlt_f16_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// GFX10: encoding: [0xf9,0x04,0xfc,0x7d,0x01,0x00,0x06,0x03]

v_cmpx_nlt_f16_sdwa v1, v2 src0_sel:DWORD src1_sel:WORD_0
// GFX10: encoding: [0xf9,0x04,0xfc,0x7d,0x01,0x00,0x06,0x04]

v_cmpx_nlt_f16_sdwa v1, v2 src0_sel:DWORD src1_sel:WORD_1
// GFX10: encoding: [0xf9,0x04,0xfc,0x7d,0x01,0x00,0x06,0x05]

v_cmpx_nlt_f16_sdwa v1, -v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xfc,0x7d,0x01,0x00,0x06,0x16]

v_cmpx_nlt_f16_sdwa v1, |v2| src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xfc,0x7d,0x01,0x00,0x06,0x26]

v_cmpx_tru_f16_sdwa v1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xfe,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_tru_f16_sdwa v255, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xfe,0x7d,0xff,0x00,0x06,0x06]

v_cmpx_tru_f16_sdwa s1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xfe,0x7d,0x01,0x00,0x86,0x06]

v_cmpx_tru_f16_sdwa s101, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xfe,0x7d,0x65,0x00,0x86,0x06]

v_cmpx_tru_f16_sdwa vcc_lo, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xfe,0x7d,0x6a,0x00,0x86,0x06]

v_cmpx_tru_f16_sdwa vcc_hi, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xfe,0x7d,0x6b,0x00,0x86,0x06]

v_cmpx_tru_f16_sdwa m0, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xfe,0x7d,0x7c,0x00,0x86,0x06]

v_cmpx_tru_f16_sdwa exec_lo, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xfe,0x7d,0x7e,0x00,0x86,0x06]

v_cmpx_tru_f16_sdwa exec_hi, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xfe,0x7d,0x7f,0x00,0x86,0x06]

v_cmpx_tru_f16_sdwa v1, v255 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0xfe,0xff,0x7d,0x01,0x00,0x06,0x06]

v_cmpx_tru_f16_sdwa v1, v2 src0_sel:BYTE_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xfe,0x7d,0x01,0x00,0x00,0x06]

v_cmpx_tru_f16_sdwa v1, v2 src0_sel:BYTE_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xfe,0x7d,0x01,0x00,0x01,0x06]

v_cmpx_tru_f16_sdwa v1, v2 src0_sel:BYTE_2 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xfe,0x7d,0x01,0x00,0x02,0x06]

v_cmpx_tru_f16_sdwa v1, v2 src0_sel:BYTE_3 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xfe,0x7d,0x01,0x00,0x03,0x06]

v_cmpx_tru_f16_sdwa v1, v2 src0_sel:WORD_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xfe,0x7d,0x01,0x00,0x04,0x06]

v_cmpx_tru_f16_sdwa v1, v2 src0_sel:WORD_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xfe,0x7d,0x01,0x00,0x05,0x06]

v_cmpx_tru_f16_sdwa -v1, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xfe,0x7d,0x01,0x00,0x16,0x06]

v_cmpx_tru_f16_sdwa |v1|, v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xfe,0x7d,0x01,0x00,0x26,0x06]

v_cmpx_tru_f16_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_0
// GFX10: encoding: [0xf9,0x04,0xfe,0x7d,0x01,0x00,0x06,0x00]

v_cmpx_tru_f16_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_1
// GFX10: encoding: [0xf9,0x04,0xfe,0x7d,0x01,0x00,0x06,0x01]

v_cmpx_tru_f16_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_2
// GFX10: encoding: [0xf9,0x04,0xfe,0x7d,0x01,0x00,0x06,0x02]

v_cmpx_tru_f16_sdwa v1, v2 src0_sel:DWORD src1_sel:BYTE_3
// GFX10: encoding: [0xf9,0x04,0xfe,0x7d,0x01,0x00,0x06,0x03]

v_cmpx_tru_f16_sdwa v1, v2 src0_sel:DWORD src1_sel:WORD_0
// GFX10: encoding: [0xf9,0x04,0xfe,0x7d,0x01,0x00,0x06,0x04]

v_cmpx_tru_f16_sdwa v1, v2 src0_sel:DWORD src1_sel:WORD_1
// GFX10: encoding: [0xf9,0x04,0xfe,0x7d,0x01,0x00,0x06,0x05]

v_cmpx_tru_f16_sdwa v1, -v2 src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xfe,0x7d,0x01,0x00,0x06,0x16]

v_cmpx_tru_f16_sdwa v1, |v2| src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xfe,0x7d,0x01,0x00,0x06,0x26]

v_cmpx_f_u64_e64 exec, v[2:3]
// GFX10: encoding: [0x00,0x00,0xf0,0xd4,0x7e,0x04,0x02,0x00]

v_cmpx_lt_u64_e64 exec, v[2:3]
// GFX10: encoding: [0x00,0x00,0xf1,0xd4,0x7e,0x04,0x02,0x00]

v_cmpx_eq_u64_e64 exec, v[2:3]
// GFX10: encoding: [0x00,0x00,0xf2,0xd4,0x7e,0x04,0x02,0x00]

v_cmpx_le_u64_e64 exec, v[2:3]
// GFX10: encoding: [0x00,0x00,0xf3,0xd4,0x7e,0x04,0x02,0x00]

v_cmpx_gt_u64_e64 exec, v[2:3]
// GFX10: encoding: [0x00,0x00,0xf4,0xd4,0x7e,0x04,0x02,0x00]

v_cmpx_ne_u64_e64 exec, v[2:3]
// GFX10: encoding: [0x00,0x00,0xf5,0xd4,0x7e,0x04,0x02,0x00]

v_cmpx_ge_u64_e64 exec, v[2:3]
// GFX10: encoding: [0x00,0x00,0xf6,0xd4,0x7e,0x04,0x02,0x00]

v_cmpx_t_u64_e64 exec, v[2:3]
// GFX10: encoding: [0x00,0x00,0xf7,0xd4,0x7e,0x04,0x02,0x00]
