// RUN: not llvm-mc -arch=amdgcn -mcpu=gfx1010 -mattr=+wavefrontsize32,-wavefrontsize64 -show-encoding %s | FileCheck --check-prefixes=GFX10,W32 %s
// RUN: not llvm-mc -arch=amdgcn -mcpu=gfx1010 -mattr=-wavefrontsize32,+wavefrontsize64 -show-encoding %s | FileCheck --check-prefixes=GFX10,W64 %s
// RUN: not llvm-mc -arch=amdgcn -mcpu=gfx1010 -mattr=+wavefrontsize32,-wavefrontsize64 %s 2>&1 | FileCheck --check-prefixes=GFX10-ERR,W32-ERR --implicit-check-not=error: %s
// RUN: not llvm-mc -arch=amdgcn -mcpu=gfx1010 -mattr=-wavefrontsize32,+wavefrontsize64 %s 2>&1 | FileCheck --check-prefixes=GFX10-ERR,W64-ERR --implicit-check-not=error: %s

//===----------------------------------------------------------------------===//
// ENC_VOP3.
//===----------------------------------------------------------------------===//

v_readlane_b32 s5, v1, s2
// GFX10: encoding: [0x05,0x00,0x60,0xd7,0x01,0x05,0x00,0x00]

v_readlane_b32 s101, v1, s2
// GFX10: encoding: [0x65,0x00,0x60,0xd7,0x01,0x05,0x00,0x00]

v_readlane_b32 s5, v255, s2
// GFX10: encoding: [0x05,0x00,0x60,0xd7,0xff,0x05,0x00,0x00]

v_readlane_b32 s5, v1, s101
// GFX10: encoding: [0x05,0x00,0x60,0xd7,0x01,0xcb,0x00,0x00]

v_readlane_b32 s5, v1, vcc_lo
// GFX10: encoding: [0x05,0x00,0x60,0xd7,0x01,0xd5,0x00,0x00]

v_readlane_b32 s5, v1, vcc_hi
// GFX10: encoding: [0x05,0x00,0x60,0xd7,0x01,0xd7,0x00,0x00]

v_readlane_b32 s5, v1, m0
// GFX10: encoding: [0x05,0x00,0x60,0xd7,0x01,0xf9,0x00,0x00]

v_readlane_b32 s5, v1, 0
// GFX10: encoding: [0x05,0x00,0x60,0xd7,0x01,0x01,0x01,0x00]

v_writelane_b32 v5, 0, s2
// GFX10: encoding: [0x05,0x00,0x61,0xd7,0x80,0x04,0x00,0x00]

v_writelane_b32 v255, 0, s2
// GFX10: encoding: [0xff,0x00,0x61,0xd7,0x80,0x04,0x00,0x00]

v_writelane_b32 v5, -1, s2
// GFX10: encoding: [0x05,0x00,0x61,0xd7,0xc1,0x04,0x00,0x00]

v_writelane_b32 v5, 0.5, s2
// GFX10: encoding: [0x05,0x00,0x61,0xd7,0xf0,0x04,0x00,0x00]

v_writelane_b32 v5, -4.0, s2
// GFX10: encoding: [0x05,0x00,0x61,0xd7,0xf7,0x04,0x00,0x00]

v_writelane_b32 v5, 0, s101
// GFX10: encoding: [0x05,0x00,0x61,0xd7,0x80,0xca,0x00,0x00]

v_writelane_b32 v5, 0, vcc_lo
// GFX10: encoding: [0x05,0x00,0x61,0xd7,0x80,0xd4,0x00,0x00]

v_writelane_b32 v5, 0, vcc_hi
// GFX10: encoding: [0x05,0x00,0x61,0xd7,0x80,0xd6,0x00,0x00]

v_writelane_b32 v5, 0, m0
// GFX10: encoding: [0x05,0x00,0x61,0xd7,0x80,0xf8,0x00,0x00]

v_writelane_b32 v5, 0, 0
// GFX10: encoding: [0x05,0x00,0x61,0xd7,0x80,0x00,0x01,0x00]

v_bfm_b32 v5, v1, v2
// GFX10: encoding: [0x05,0x00,0x63,0xd7,0x01,0x05,0x02,0x00]

v_bfm_b32 v255, v1, v2
// GFX10: encoding: [0xff,0x00,0x63,0xd7,0x01,0x05,0x02,0x00]

v_bfm_b32 v5, v255, v2
// GFX10: encoding: [0x05,0x00,0x63,0xd7,0xff,0x05,0x02,0x00]

v_bfm_b32 v5, s1, v2
// GFX10: encoding: [0x05,0x00,0x63,0xd7,0x01,0x04,0x02,0x00]

v_bfm_b32 v5, s103, v2
// GFX10: encoding: [0x05,0x00,0x63,0xd7,0x67,0x04,0x02,0x00]

v_bfm_b32 v5, vcc_lo, v2
// GFX10: encoding: [0x05,0x00,0x63,0xd7,0x6a,0x04,0x02,0x00]

v_bfm_b32 v5, vcc_hi, v2
// GFX10: encoding: [0x05,0x00,0x63,0xd7,0x6b,0x04,0x02,0x00]

v_bfm_b32 v5, ttmp11, v2
// GFX10: encoding: [0x05,0x00,0x63,0xd7,0x77,0x04,0x02,0x00]

v_bfm_b32 v5, m0, v2
// GFX10: encoding: [0x05,0x00,0x63,0xd7,0x7c,0x04,0x02,0x00]

v_bfm_b32 v5, exec_lo, v2
// GFX10: encoding: [0x05,0x00,0x63,0xd7,0x7e,0x04,0x02,0x00]

v_bfm_b32 v5, exec_hi, v2
// GFX10: encoding: [0x05,0x00,0x63,0xd7,0x7f,0x04,0x02,0x00]

v_bfm_b32 v5, 0, v2
// GFX10: encoding: [0x05,0x00,0x63,0xd7,0x80,0x04,0x02,0x00]

v_bfm_b32 v5, -1, v2
// GFX10: encoding: [0x05,0x00,0x63,0xd7,0xc1,0x04,0x02,0x00]

v_bfm_b32 v5, 0.5, v2
// GFX10: encoding: [0x05,0x00,0x63,0xd7,0xf0,0x04,0x02,0x00]

v_bfm_b32 v5, -4.0, v2
// GFX10: encoding: [0x05,0x00,0x63,0xd7,0xf7,0x04,0x02,0x00]

v_bfm_b32 v5, v1, v255
// GFX10: encoding: [0x05,0x00,0x63,0xd7,0x01,0xff,0x03,0x00]

v_bfm_b32 v5, v1, s2
// GFX10: encoding: [0x05,0x00,0x63,0xd7,0x01,0x05,0x00,0x00]

v_bfm_b32 v5, v1, s103
// GFX10: encoding: [0x05,0x00,0x63,0xd7,0x01,0xcf,0x00,0x00]

v_bfm_b32 v5, v1, vcc_lo
// GFX10: encoding: [0x05,0x00,0x63,0xd7,0x01,0xd5,0x00,0x00]

v_bfm_b32 v5, v1, vcc_hi
// GFX10: encoding: [0x05,0x00,0x63,0xd7,0x01,0xd7,0x00,0x00]

v_bfm_b32 v5, v1, ttmp11
// GFX10: encoding: [0x05,0x00,0x63,0xd7,0x01,0xef,0x00,0x00]

v_bfm_b32 v5, v1, m0
// GFX10: encoding: [0x05,0x00,0x63,0xd7,0x01,0xf9,0x00,0x00]

v_bfm_b32 v5, v1, exec_lo
// GFX10: encoding: [0x05,0x00,0x63,0xd7,0x01,0xfd,0x00,0x00]

v_bfm_b32 v5, v1, exec_hi
// GFX10: encoding: [0x05,0x00,0x63,0xd7,0x01,0xff,0x00,0x00]

v_bfm_b32 v5, v1, 0
// GFX10: encoding: [0x05,0x00,0x63,0xd7,0x01,0x01,0x01,0x00]

v_bfm_b32 v5, v1, -1
// GFX10: encoding: [0x05,0x00,0x63,0xd7,0x01,0x83,0x01,0x00]

v_bfm_b32 v5, v1, 0.5
// GFX10: encoding: [0x05,0x00,0x63,0xd7,0x01,0xe1,0x01,0x00]

v_bfm_b32 v5, v1, -4.0
// GFX10: encoding: [0x05,0x00,0x63,0xd7,0x01,0xef,0x01,0x00]

v_bcnt_u32_b32 v5, v1, v2
// GFX10: encoding: [0x05,0x00,0x64,0xd7,0x01,0x05,0x02,0x00]

v_bcnt_u32_b32 v255, v1, v2
// GFX10: encoding: [0xff,0x00,0x64,0xd7,0x01,0x05,0x02,0x00]

v_bcnt_u32_b32 v5, v255, v2
// GFX10: encoding: [0x05,0x00,0x64,0xd7,0xff,0x05,0x02,0x00]

v_bcnt_u32_b32 v5, s1, v2
// GFX10: encoding: [0x05,0x00,0x64,0xd7,0x01,0x04,0x02,0x00]

v_bcnt_u32_b32 v5, s103, v2
// GFX10: encoding: [0x05,0x00,0x64,0xd7,0x67,0x04,0x02,0x00]

v_bcnt_u32_b32 v5, vcc_lo, v2
// GFX10: encoding: [0x05,0x00,0x64,0xd7,0x6a,0x04,0x02,0x00]

v_bcnt_u32_b32 v5, vcc_hi, v2
// GFX10: encoding: [0x05,0x00,0x64,0xd7,0x6b,0x04,0x02,0x00]

v_bcnt_u32_b32 v5, ttmp11, v2
// GFX10: encoding: [0x05,0x00,0x64,0xd7,0x77,0x04,0x02,0x00]

v_bcnt_u32_b32 v5, m0, v2
// GFX10: encoding: [0x05,0x00,0x64,0xd7,0x7c,0x04,0x02,0x00]

v_bcnt_u32_b32 v5, exec_lo, v2
// GFX10: encoding: [0x05,0x00,0x64,0xd7,0x7e,0x04,0x02,0x00]

v_bcnt_u32_b32 v5, exec_hi, v2
// GFX10: encoding: [0x05,0x00,0x64,0xd7,0x7f,0x04,0x02,0x00]

v_bcnt_u32_b32 v5, 0, v2
// GFX10: encoding: [0x05,0x00,0x64,0xd7,0x80,0x04,0x02,0x00]

v_bcnt_u32_b32 v5, -1, v2
// GFX10: encoding: [0x05,0x00,0x64,0xd7,0xc1,0x04,0x02,0x00]

v_bcnt_u32_b32 v5, 0.5, v2
// GFX10: encoding: [0x05,0x00,0x64,0xd7,0xf0,0x04,0x02,0x00]

v_bcnt_u32_b32 v5, -4.0, v2
// GFX10: encoding: [0x05,0x00,0x64,0xd7,0xf7,0x04,0x02,0x00]

v_bcnt_u32_b32 v5, v1, v255
// GFX10: encoding: [0x05,0x00,0x64,0xd7,0x01,0xff,0x03,0x00]

v_bcnt_u32_b32 v5, v1, s2
// GFX10: encoding: [0x05,0x00,0x64,0xd7,0x01,0x05,0x00,0x00]

v_bcnt_u32_b32 v5, v1, s103
// GFX10: encoding: [0x05,0x00,0x64,0xd7,0x01,0xcf,0x00,0x00]

v_bcnt_u32_b32 v5, v1, vcc_lo
// GFX10: encoding: [0x05,0x00,0x64,0xd7,0x01,0xd5,0x00,0x00]

v_bcnt_u32_b32 v5, v1, vcc_hi
// GFX10: encoding: [0x05,0x00,0x64,0xd7,0x01,0xd7,0x00,0x00]

v_bcnt_u32_b32 v5, v1, ttmp11
// GFX10: encoding: [0x05,0x00,0x64,0xd7,0x01,0xef,0x00,0x00]

v_bcnt_u32_b32 v5, v1, m0
// GFX10: encoding: [0x05,0x00,0x64,0xd7,0x01,0xf9,0x00,0x00]

v_bcnt_u32_b32 v5, v1, exec_lo
// GFX10: encoding: [0x05,0x00,0x64,0xd7,0x01,0xfd,0x00,0x00]

v_bcnt_u32_b32 v5, v1, exec_hi
// GFX10: encoding: [0x05,0x00,0x64,0xd7,0x01,0xff,0x00,0x00]

v_bcnt_u32_b32 v5, v1, 0
// GFX10: encoding: [0x05,0x00,0x64,0xd7,0x01,0x01,0x01,0x00]

v_bcnt_u32_b32 v5, v1, -1
// GFX10: encoding: [0x05,0x00,0x64,0xd7,0x01,0x83,0x01,0x00]

v_bcnt_u32_b32 v5, v1, 0.5
// GFX10: encoding: [0x05,0x00,0x64,0xd7,0x01,0xe1,0x01,0x00]

v_bcnt_u32_b32 v5, v1, -4.0
// GFX10: encoding: [0x05,0x00,0x64,0xd7,0x01,0xef,0x01,0x00]

v_mbcnt_lo_u32_b32 v5, v1, v2
// GFX10: encoding: [0x05,0x00,0x65,0xd7,0x01,0x05,0x02,0x00]

v_mbcnt_lo_u32_b32 v255, v1, v2
// GFX10: encoding: [0xff,0x00,0x65,0xd7,0x01,0x05,0x02,0x00]

v_mbcnt_lo_u32_b32 v5, v255, v2
// GFX10: encoding: [0x05,0x00,0x65,0xd7,0xff,0x05,0x02,0x00]

v_mbcnt_lo_u32_b32 v5, s1, v2
// GFX10: encoding: [0x05,0x00,0x65,0xd7,0x01,0x04,0x02,0x00]

v_mbcnt_lo_u32_b32 v5, s103, v2
// GFX10: encoding: [0x05,0x00,0x65,0xd7,0x67,0x04,0x02,0x00]

v_mbcnt_lo_u32_b32 v5, vcc_lo, v2
// GFX10: encoding: [0x05,0x00,0x65,0xd7,0x6a,0x04,0x02,0x00]

v_mbcnt_lo_u32_b32 v5, vcc_hi, v2
// GFX10: encoding: [0x05,0x00,0x65,0xd7,0x6b,0x04,0x02,0x00]

v_mbcnt_lo_u32_b32 v5, ttmp11, v2
// GFX10: encoding: [0x05,0x00,0x65,0xd7,0x77,0x04,0x02,0x00]

v_mbcnt_lo_u32_b32 v5, m0, v2
// GFX10: encoding: [0x05,0x00,0x65,0xd7,0x7c,0x04,0x02,0x00]

v_mbcnt_lo_u32_b32 v5, exec_lo, v2
// GFX10: encoding: [0x05,0x00,0x65,0xd7,0x7e,0x04,0x02,0x00]

v_mbcnt_lo_u32_b32 v5, exec_hi, v2
// GFX10: encoding: [0x05,0x00,0x65,0xd7,0x7f,0x04,0x02,0x00]

v_mbcnt_lo_u32_b32 v5, 0, v2
// GFX10: encoding: [0x05,0x00,0x65,0xd7,0x80,0x04,0x02,0x00]

v_mbcnt_lo_u32_b32 v5, -1, v2
// GFX10: encoding: [0x05,0x00,0x65,0xd7,0xc1,0x04,0x02,0x00]

v_mbcnt_lo_u32_b32 v5, 0.5, v2
// GFX10: encoding: [0x05,0x00,0x65,0xd7,0xf0,0x04,0x02,0x00]

v_mbcnt_lo_u32_b32 v5, -4.0, v2
// GFX10: encoding: [0x05,0x00,0x65,0xd7,0xf7,0x04,0x02,0x00]

v_mbcnt_lo_u32_b32 v5, v1, v255
// GFX10: encoding: [0x05,0x00,0x65,0xd7,0x01,0xff,0x03,0x00]

v_mbcnt_lo_u32_b32 v5, v1, s2
// GFX10: encoding: [0x05,0x00,0x65,0xd7,0x01,0x05,0x00,0x00]

v_mbcnt_lo_u32_b32 v5, v1, s103
// GFX10: encoding: [0x05,0x00,0x65,0xd7,0x01,0xcf,0x00,0x00]

v_mbcnt_lo_u32_b32 v5, v1, vcc_lo
// GFX10: encoding: [0x05,0x00,0x65,0xd7,0x01,0xd5,0x00,0x00]

v_mbcnt_lo_u32_b32 v5, v1, vcc_hi
// GFX10: encoding: [0x05,0x00,0x65,0xd7,0x01,0xd7,0x00,0x00]

v_mbcnt_lo_u32_b32 v5, v1, ttmp11
// GFX10: encoding: [0x05,0x00,0x65,0xd7,0x01,0xef,0x00,0x00]

v_mbcnt_lo_u32_b32 v5, v1, m0
// GFX10: encoding: [0x05,0x00,0x65,0xd7,0x01,0xf9,0x00,0x00]

v_mbcnt_lo_u32_b32 v5, v1, exec_lo
// GFX10: encoding: [0x05,0x00,0x65,0xd7,0x01,0xfd,0x00,0x00]

v_mbcnt_lo_u32_b32 v5, v1, exec_hi
// GFX10: encoding: [0x05,0x00,0x65,0xd7,0x01,0xff,0x00,0x00]

v_mbcnt_lo_u32_b32 v5, v1, 0
// GFX10: encoding: [0x05,0x00,0x65,0xd7,0x01,0x01,0x01,0x00]

v_mbcnt_lo_u32_b32 v5, v1, -1
// GFX10: encoding: [0x05,0x00,0x65,0xd7,0x01,0x83,0x01,0x00]

v_mbcnt_lo_u32_b32 v5, v1, 0.5
// GFX10: encoding: [0x05,0x00,0x65,0xd7,0x01,0xe1,0x01,0x00]

v_mbcnt_lo_u32_b32 v5, v1, -4.0
// GFX10: encoding: [0x05,0x00,0x65,0xd7,0x01,0xef,0x01,0x00]

v_mbcnt_hi_u32_b32 v5, v1, v2
// GFX10: encoding: [0x05,0x00,0x66,0xd7,0x01,0x05,0x02,0x00]

v_mbcnt_hi_u32_b32 v255, v1, v2
// GFX10: encoding: [0xff,0x00,0x66,0xd7,0x01,0x05,0x02,0x00]

v_mbcnt_hi_u32_b32 v5, v255, v2
// GFX10: encoding: [0x05,0x00,0x66,0xd7,0xff,0x05,0x02,0x00]

v_mbcnt_hi_u32_b32 v5, s1, v2
// GFX10: encoding: [0x05,0x00,0x66,0xd7,0x01,0x04,0x02,0x00]

v_mbcnt_hi_u32_b32 v5, s103, v2
// GFX10: encoding: [0x05,0x00,0x66,0xd7,0x67,0x04,0x02,0x00]

v_mbcnt_hi_u32_b32 v5, vcc_lo, v2
// GFX10: encoding: [0x05,0x00,0x66,0xd7,0x6a,0x04,0x02,0x00]

v_mbcnt_hi_u32_b32 v5, vcc_hi, v2
// GFX10: encoding: [0x05,0x00,0x66,0xd7,0x6b,0x04,0x02,0x00]

v_mbcnt_hi_u32_b32 v5, ttmp11, v2
// GFX10: encoding: [0x05,0x00,0x66,0xd7,0x77,0x04,0x02,0x00]

v_mbcnt_hi_u32_b32 v5, m0, v2
// GFX10: encoding: [0x05,0x00,0x66,0xd7,0x7c,0x04,0x02,0x00]

v_mbcnt_hi_u32_b32 v5, exec_lo, v2
// GFX10: encoding: [0x05,0x00,0x66,0xd7,0x7e,0x04,0x02,0x00]

v_mbcnt_hi_u32_b32 v5, exec_hi, v2
// GFX10: encoding: [0x05,0x00,0x66,0xd7,0x7f,0x04,0x02,0x00]

v_mbcnt_hi_u32_b32 v5, 0, v2
// GFX10: encoding: [0x05,0x00,0x66,0xd7,0x80,0x04,0x02,0x00]

v_mbcnt_hi_u32_b32 v5, -1, v2
// GFX10: encoding: [0x05,0x00,0x66,0xd7,0xc1,0x04,0x02,0x00]

v_mbcnt_hi_u32_b32 v5, 0.5, v2
// GFX10: encoding: [0x05,0x00,0x66,0xd7,0xf0,0x04,0x02,0x00]

v_mbcnt_hi_u32_b32 v5, -4.0, v2
// GFX10: encoding: [0x05,0x00,0x66,0xd7,0xf7,0x04,0x02,0x00]

v_mbcnt_hi_u32_b32 v5, v1, v255
// GFX10: encoding: [0x05,0x00,0x66,0xd7,0x01,0xff,0x03,0x00]

v_mbcnt_hi_u32_b32 v5, v1, s2
// GFX10: encoding: [0x05,0x00,0x66,0xd7,0x01,0x05,0x00,0x00]

v_mbcnt_hi_u32_b32 v5, v1, s103
// GFX10: encoding: [0x05,0x00,0x66,0xd7,0x01,0xcf,0x00,0x00]

v_mbcnt_hi_u32_b32 v5, v1, vcc_lo
// GFX10: encoding: [0x05,0x00,0x66,0xd7,0x01,0xd5,0x00,0x00]

v_mbcnt_hi_u32_b32 v5, v1, vcc_hi
// GFX10: encoding: [0x05,0x00,0x66,0xd7,0x01,0xd7,0x00,0x00]

v_mbcnt_hi_u32_b32 v5, v1, ttmp11
// GFX10: encoding: [0x05,0x00,0x66,0xd7,0x01,0xef,0x00,0x00]

v_mbcnt_hi_u32_b32 v5, v1, m0
// GFX10: encoding: [0x05,0x00,0x66,0xd7,0x01,0xf9,0x00,0x00]

v_mbcnt_hi_u32_b32 v5, v1, exec_lo
// GFX10: encoding: [0x05,0x00,0x66,0xd7,0x01,0xfd,0x00,0x00]

v_mbcnt_hi_u32_b32 v5, v1, exec_hi
// GFX10: encoding: [0x05,0x00,0x66,0xd7,0x01,0xff,0x00,0x00]

v_mbcnt_hi_u32_b32 v5, v1, 0
// GFX10: encoding: [0x05,0x00,0x66,0xd7,0x01,0x01,0x01,0x00]

v_mbcnt_hi_u32_b32 v5, v1, -1
// GFX10: encoding: [0x05,0x00,0x66,0xd7,0x01,0x83,0x01,0x00]

v_mbcnt_hi_u32_b32 v5, v1, 0.5
// GFX10: encoding: [0x05,0x00,0x66,0xd7,0x01,0xe1,0x01,0x00]

v_mbcnt_hi_u32_b32 v5, v1, -4.0
// GFX10: encoding: [0x05,0x00,0x66,0xd7,0x01,0xef,0x01,0x00]

v_add_co_u32 v5, s0, v1, v2
// W32: encoding: [0x05,0x00,0x0f,0xd7,0x01,0x05,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_u32 v255, s0, v1, v2
// W32: encoding: [0xff,0x00,0x0f,0xd7,0x01,0x05,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_u32 v5, s0, v255, v2
// W32: encoding: [0x05,0x00,0x0f,0xd7,0xff,0x05,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_u32 v5, s0, s1, v2
// W32: encoding: [0x05,0x00,0x0f,0xd7,0x01,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_u32 v5, s0, s103, v2
// W32: encoding: [0x05,0x00,0x0f,0xd7,0x67,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_u32 v5, s0, vcc_lo, v2
// W32: encoding: [0x05,0x00,0x0f,0xd7,0x6a,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_u32 v5, s0, vcc_hi, v2
// W32: encoding: [0x05,0x00,0x0f,0xd7,0x6b,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_u32 v5, s0, ttmp11, v2
// W32: encoding: [0x05,0x00,0x0f,0xd7,0x77,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_u32 v5, s0, m0, v2
// W32: encoding: [0x05,0x00,0x0f,0xd7,0x7c,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_u32 v5, s0, exec_lo, v2
// W32: encoding: [0x05,0x00,0x0f,0xd7,0x7e,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_u32 v5, s0, exec_hi, v2
// W32: encoding: [0x05,0x00,0x0f,0xd7,0x7f,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_u32 v5, s0, 0, v2
// W32: encoding: [0x05,0x00,0x0f,0xd7,0x80,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_u32 v5, s0, -1, v2
// W32: encoding: [0x05,0x00,0x0f,0xd7,0xc1,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_u32 v5, s0, 0.5, v2
// W32: encoding: [0x05,0x00,0x0f,0xd7,0xf0,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_u32 v5, s0, -4.0, v2
// W32: encoding: [0x05,0x00,0x0f,0xd7,0xf7,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_u32 v5, s0, v1, v255
// W32: encoding: [0x05,0x00,0x0f,0xd7,0x01,0xff,0x03,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_u32 v5, s0, v1, s2
// W32: encoding: [0x05,0x00,0x0f,0xd7,0x01,0x05,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_u32 v5, s0, v1, s103
// W32: encoding: [0x05,0x00,0x0f,0xd7,0x01,0xcf,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_u32 v5, s0, v1, vcc_lo
// W32: encoding: [0x05,0x00,0x0f,0xd7,0x01,0xd5,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_u32 v5, s0, v1, vcc_hi
// W32: encoding: [0x05,0x00,0x0f,0xd7,0x01,0xd7,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_u32 v5, s0, v1, ttmp11
// W32: encoding: [0x05,0x00,0x0f,0xd7,0x01,0xef,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_u32 v5, s0, v1, m0
// W32: encoding: [0x05,0x00,0x0f,0xd7,0x01,0xf9,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_u32 v5, s0, v1, exec_lo
// W32: encoding: [0x05,0x00,0x0f,0xd7,0x01,0xfd,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_u32 v5, s0, v1, exec_hi
// W32: encoding: [0x05,0x00,0x0f,0xd7,0x01,0xff,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_u32 v5, s0, v1, 0
// W32: encoding: [0x05,0x00,0x0f,0xd7,0x01,0x01,0x01,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_u32 v5, s0, v1, -1
// W32: encoding: [0x05,0x00,0x0f,0xd7,0x01,0x83,0x01,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_u32 v5, s0, v1, 0.5
// W32: encoding: [0x05,0x00,0x0f,0xd7,0x01,0xe1,0x01,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_u32 v5, s0, v1, -4.0
// W32: encoding: [0x05,0x00,0x0f,0xd7,0x01,0xef,0x01,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_u32 v5, s[0:1], v1, v2
// W64: encoding: [0x05,0x00,0x0f,0xd7,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_u32 v255, s[0:1], v1, v2
// W64: encoding: [0xff,0x00,0x0f,0xd7,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_u32 v5, s[0:1], v255, v2
// W64: encoding: [0x05,0x00,0x0f,0xd7,0xff,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_u32 v5, s[0:1], s1, v2
// W64: encoding: [0x05,0x00,0x0f,0xd7,0x01,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_u32 v5, s[0:1], s103, v2
// W64: encoding: [0x05,0x00,0x0f,0xd7,0x67,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_u32 v5, s[0:1], vcc_lo, v2
// W64: encoding: [0x05,0x00,0x0f,0xd7,0x6a,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_u32 v5, s[0:1], vcc_hi, v2
// W64: encoding: [0x05,0x00,0x0f,0xd7,0x6b,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_u32 v5, s[0:1], ttmp11, v2
// W64: encoding: [0x05,0x00,0x0f,0xd7,0x77,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_u32 v5, s[0:1], m0, v2
// W64: encoding: [0x05,0x00,0x0f,0xd7,0x7c,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_u32 v5, s[0:1], exec_lo, v2
// W64: encoding: [0x05,0x00,0x0f,0xd7,0x7e,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_u32 v5, s[0:1], exec_hi, v2
// W64: encoding: [0x05,0x00,0x0f,0xd7,0x7f,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_u32 v5, s[0:1], 0, v2
// W64: encoding: [0x05,0x00,0x0f,0xd7,0x80,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_u32 v5, s[0:1], -1, v2
// W64: encoding: [0x05,0x00,0x0f,0xd7,0xc1,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_u32 v5, s[0:1], 0.5, v2
// W64: encoding: [0x05,0x00,0x0f,0xd7,0xf0,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_u32 v5, s[0:1], -4.0, v2
// W64: encoding: [0x05,0x00,0x0f,0xd7,0xf7,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_u32 v5, s[0:1], v1, v255
// W64: encoding: [0x05,0x00,0x0f,0xd7,0x01,0xff,0x03,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_u32 v5, s[0:1], v1, s2
// W64: encoding: [0x05,0x00,0x0f,0xd7,0x01,0x05,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_u32 v5, s[0:1], v1, s103
// W64: encoding: [0x05,0x00,0x0f,0xd7,0x01,0xcf,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_u32 v5, s[0:1], v1, vcc_lo
// W64: encoding: [0x05,0x00,0x0f,0xd7,0x01,0xd5,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_u32 v5, s[0:1], v1, vcc_hi
// W64: encoding: [0x05,0x00,0x0f,0xd7,0x01,0xd7,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_u32 v5, s[0:1], v1, ttmp11
// W64: encoding: [0x05,0x00,0x0f,0xd7,0x01,0xef,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_u32 v5, s[0:1], v1, m0
// W64: encoding: [0x05,0x00,0x0f,0xd7,0x01,0xf9,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_u32 v5, s[0:1], v1, exec_lo
// W64: encoding: [0x05,0x00,0x0f,0xd7,0x01,0xfd,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_u32 v5, s[0:1], v1, exec_hi
// W64: encoding: [0x05,0x00,0x0f,0xd7,0x01,0xff,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_u32 v5, s[0:1], v1, 0
// W64: encoding: [0x05,0x00,0x0f,0xd7,0x01,0x01,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_u32 v5, s[0:1], v1, -1
// W64: encoding: [0x05,0x00,0x0f,0xd7,0x01,0x83,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_u32 v5, s[0:1], v1, 0.5
// W64: encoding: [0x05,0x00,0x0f,0xd7,0x01,0xe1,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_u32 v5, s[0:1], v1, -4.0
// W64: encoding: [0x05,0x00,0x0f,0xd7,0x01,0xef,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_u32 v5, s0, v1, v2
// W32: encoding: [0x05,0x00,0x10,0xd7,0x01,0x05,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_u32 v255, s0, v1, v2
// W32: encoding: [0xff,0x00,0x10,0xd7,0x01,0x05,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_u32 v5, s0, v255, v2
// W32: encoding: [0x05,0x00,0x10,0xd7,0xff,0x05,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_u32 v5, s0, s1, v2
// W32: encoding: [0x05,0x00,0x10,0xd7,0x01,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_u32 v5, s0, s103, v2
// W32: encoding: [0x05,0x00,0x10,0xd7,0x67,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_u32 v5, s0, vcc_lo, v2
// W32: encoding: [0x05,0x00,0x10,0xd7,0x6a,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_u32 v5, s0, vcc_hi, v2
// W32: encoding: [0x05,0x00,0x10,0xd7,0x6b,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_u32 v5, s0, ttmp11, v2
// W32: encoding: [0x05,0x00,0x10,0xd7,0x77,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_u32 v5, s0, m0, v2
// W32: encoding: [0x05,0x00,0x10,0xd7,0x7c,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_u32 v5, s0, exec_lo, v2
// W32: encoding: [0x05,0x00,0x10,0xd7,0x7e,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_u32 v5, s0, exec_hi, v2
// W32: encoding: [0x05,0x00,0x10,0xd7,0x7f,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_u32 v5, s0, 0, v2
// W32: encoding: [0x05,0x00,0x10,0xd7,0x80,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_u32 v5, s0, -1, v2
// W32: encoding: [0x05,0x00,0x10,0xd7,0xc1,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_u32 v5, s0, 0.5, v2
// W32: encoding: [0x05,0x00,0x10,0xd7,0xf0,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_u32 v5, s0, -4.0, v2
// W32: encoding: [0x05,0x00,0x10,0xd7,0xf7,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_u32 v5, s0, v1, v255
// W32: encoding: [0x05,0x00,0x10,0xd7,0x01,0xff,0x03,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_u32 v5, s0, v1, s2
// W32: encoding: [0x05,0x00,0x10,0xd7,0x01,0x05,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_u32 v5, s0, v1, s103
// W32: encoding: [0x05,0x00,0x10,0xd7,0x01,0xcf,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_u32 v5, s0, v1, vcc_lo
// W32: encoding: [0x05,0x00,0x10,0xd7,0x01,0xd5,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_u32 v5, s0, v1, vcc_hi
// W32: encoding: [0x05,0x00,0x10,0xd7,0x01,0xd7,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_u32 v5, s0, v1, ttmp11
// W32: encoding: [0x05,0x00,0x10,0xd7,0x01,0xef,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_u32 v5, s0, v1, m0
// W32: encoding: [0x05,0x00,0x10,0xd7,0x01,0xf9,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_u32 v5, s0, v1, exec_lo
// W32: encoding: [0x05,0x00,0x10,0xd7,0x01,0xfd,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_u32 v5, s0, v1, exec_hi
// W32: encoding: [0x05,0x00,0x10,0xd7,0x01,0xff,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_u32 v5, s0, v1, 0
// W32: encoding: [0x05,0x00,0x10,0xd7,0x01,0x01,0x01,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_u32 v5, s0, v1, -1
// W32: encoding: [0x05,0x00,0x10,0xd7,0x01,0x83,0x01,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_u32 v5, s0, v1, 0.5
// W32: encoding: [0x05,0x00,0x10,0xd7,0x01,0xe1,0x01,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_u32 v5, s0, v1, -4.0
// W32: encoding: [0x05,0x00,0x10,0xd7,0x01,0xef,0x01,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_u32 v5, s[0:1], v1, v2
// W64: encoding: [0x05,0x00,0x10,0xd7,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_u32 v255, s[0:1], v1, v2
// W64: encoding: [0xff,0x00,0x10,0xd7,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_u32 v5, s[0:1], v255, v2
// W64: encoding: [0x05,0x00,0x10,0xd7,0xff,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_u32 v5, s[0:1], s1, v2
// W64: encoding: [0x05,0x00,0x10,0xd7,0x01,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_u32 v5, s[0:1], s103, v2
// W64: encoding: [0x05,0x00,0x10,0xd7,0x67,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_u32 v5, s[0:1], vcc_lo, v2
// W64: encoding: [0x05,0x00,0x10,0xd7,0x6a,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_u32 v5, s[0:1], vcc_hi, v2
// W64: encoding: [0x05,0x00,0x10,0xd7,0x6b,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_u32 v5, s[0:1], ttmp11, v2
// W64: encoding: [0x05,0x00,0x10,0xd7,0x77,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_u32 v5, s[0:1], m0, v2
// W64: encoding: [0x05,0x00,0x10,0xd7,0x7c,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_u32 v5, s[0:1], exec_lo, v2
// W64: encoding: [0x05,0x00,0x10,0xd7,0x7e,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_u32 v5, s[0:1], exec_hi, v2
// W64: encoding: [0x05,0x00,0x10,0xd7,0x7f,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_u32 v5, s[0:1], 0, v2
// W64: encoding: [0x05,0x00,0x10,0xd7,0x80,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_u32 v5, s[0:1], -1, v2
// W64: encoding: [0x05,0x00,0x10,0xd7,0xc1,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_u32 v5, s[0:1], 0.5, v2
// W64: encoding: [0x05,0x00,0x10,0xd7,0xf0,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_u32 v5, s[0:1], -4.0, v2
// W64: encoding: [0x05,0x00,0x10,0xd7,0xf7,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_u32 v5, s[0:1], v1, v255
// W64: encoding: [0x05,0x00,0x10,0xd7,0x01,0xff,0x03,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_u32 v5, s[0:1], v1, s2
// W64: encoding: [0x05,0x00,0x10,0xd7,0x01,0x05,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_u32 v5, s[0:1], v1, s103
// W64: encoding: [0x05,0x00,0x10,0xd7,0x01,0xcf,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_u32 v5, s[0:1], v1, vcc_lo
// W64: encoding: [0x05,0x00,0x10,0xd7,0x01,0xd5,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_u32 v5, s[0:1], v1, vcc_hi
// W64: encoding: [0x05,0x00,0x10,0xd7,0x01,0xd7,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_u32 v5, s[0:1], v1, ttmp11
// W64: encoding: [0x05,0x00,0x10,0xd7,0x01,0xef,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_u32 v5, s[0:1], v1, m0
// W64: encoding: [0x05,0x00,0x10,0xd7,0x01,0xf9,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_u32 v5, s[0:1], v1, exec_lo
// W64: encoding: [0x05,0x00,0x10,0xd7,0x01,0xfd,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_u32 v5, s[0:1], v1, exec_hi
// W64: encoding: [0x05,0x00,0x10,0xd7,0x01,0xff,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_u32 v5, s[0:1], v1, 0
// W64: encoding: [0x05,0x00,0x10,0xd7,0x01,0x01,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_u32 v5, s[0:1], v1, -1
// W64: encoding: [0x05,0x00,0x10,0xd7,0x01,0x83,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_u32 v5, s[0:1], v1, 0.5
// W64: encoding: [0x05,0x00,0x10,0xd7,0x01,0xe1,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_u32 v5, s[0:1], v1, -4.0
// W64: encoding: [0x05,0x00,0x10,0xd7,0x01,0xef,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_u32 v5, s0, v1, v2
// W32: encoding: [0x05,0x00,0x19,0xd7,0x01,0x05,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_u32 v255, s0, v1, v2
// W32: encoding: [0xff,0x00,0x19,0xd7,0x01,0x05,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_u32 v5, s0, v255, v2
// W32: encoding: [0x05,0x00,0x19,0xd7,0xff,0x05,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_u32 v5, s0, s1, v2
// W32: encoding: [0x05,0x00,0x19,0xd7,0x01,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_u32 v5, s0, s103, v2
// W32: encoding: [0x05,0x00,0x19,0xd7,0x67,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_u32 v5, s0, vcc_lo, v2
// W32: encoding: [0x05,0x00,0x19,0xd7,0x6a,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_u32 v5, s0, vcc_hi, v2
// W32: encoding: [0x05,0x00,0x19,0xd7,0x6b,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_u32 v5, s0, ttmp11, v2
// W32: encoding: [0x05,0x00,0x19,0xd7,0x77,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_u32 v5, s0, m0, v2
// W32: encoding: [0x05,0x00,0x19,0xd7,0x7c,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_u32 v5, s0, exec_lo, v2
// W32: encoding: [0x05,0x00,0x19,0xd7,0x7e,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_u32 v5, s0, exec_hi, v2
// W32: encoding: [0x05,0x00,0x19,0xd7,0x7f,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_u32 v5, s0, 0, v2
// W32: encoding: [0x05,0x00,0x19,0xd7,0x80,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_u32 v5, s0, -1, v2
// W32: encoding: [0x05,0x00,0x19,0xd7,0xc1,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_u32 v5, s0, 0.5, v2
// W32: encoding: [0x05,0x00,0x19,0xd7,0xf0,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_u32 v5, s0, -4.0, v2
// W32: encoding: [0x05,0x00,0x19,0xd7,0xf7,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_u32 v5, s0, v1, v255
// W32: encoding: [0x05,0x00,0x19,0xd7,0x01,0xff,0x03,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_u32 v5, s0, v1, s2
// W32: encoding: [0x05,0x00,0x19,0xd7,0x01,0x05,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_u32 v5, s0, v1, s103
// W32: encoding: [0x05,0x00,0x19,0xd7,0x01,0xcf,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_u32 v5, s0, v1, vcc_lo
// W32: encoding: [0x05,0x00,0x19,0xd7,0x01,0xd5,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_u32 v5, s0, v1, vcc_hi
// W32: encoding: [0x05,0x00,0x19,0xd7,0x01,0xd7,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_u32 v5, s0, v1, ttmp11
// W32: encoding: [0x05,0x00,0x19,0xd7,0x01,0xef,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_u32 v5, s0, v1, m0
// W32: encoding: [0x05,0x00,0x19,0xd7,0x01,0xf9,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_u32 v5, s0, v1, exec_lo
// W32: encoding: [0x05,0x00,0x19,0xd7,0x01,0xfd,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_u32 v5, s0, v1, exec_hi
// W32: encoding: [0x05,0x00,0x19,0xd7,0x01,0xff,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_u32 v5, s0, v1, 0
// W32: encoding: [0x05,0x00,0x19,0xd7,0x01,0x01,0x01,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_u32 v5, s0, v1, -1
// W32: encoding: [0x05,0x00,0x19,0xd7,0x01,0x83,0x01,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_u32 v5, s0, v1, 0.5
// W32: encoding: [0x05,0x00,0x19,0xd7,0x01,0xe1,0x01,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_u32 v5, s0, v1, -4.0
// W32: encoding: [0x05,0x00,0x19,0xd7,0x01,0xef,0x01,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_u32 v5, s[0:1], v1, v2
// W64: encoding: [0x05,0x00,0x19,0xd7,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_u32 v255, s[0:1], v1, v2
// W64: encoding: [0xff,0x00,0x19,0xd7,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_u32 v5, s[0:1], v255, v2
// W64: encoding: [0x05,0x00,0x19,0xd7,0xff,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_u32 v5, s[0:1], s1, v2
// W64: encoding: [0x05,0x00,0x19,0xd7,0x01,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_u32 v5, s[0:1], s103, v2
// W64: encoding: [0x05,0x00,0x19,0xd7,0x67,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_u32 v5, s[0:1], vcc_lo, v2
// W64: encoding: [0x05,0x00,0x19,0xd7,0x6a,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_u32 v5, s[0:1], vcc_hi, v2
// W64: encoding: [0x05,0x00,0x19,0xd7,0x6b,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_u32 v5, s[0:1], ttmp11, v2
// W64: encoding: [0x05,0x00,0x19,0xd7,0x77,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_u32 v5, s[0:1], m0, v2
// W64: encoding: [0x05,0x00,0x19,0xd7,0x7c,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_u32 v5, s[0:1], exec_lo, v2
// W64: encoding: [0x05,0x00,0x19,0xd7,0x7e,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_u32 v5, s[0:1], exec_hi, v2
// W64: encoding: [0x05,0x00,0x19,0xd7,0x7f,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_u32 v5, s[0:1], 0, v2
// W64: encoding: [0x05,0x00,0x19,0xd7,0x80,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_u32 v5, s[0:1], -1, v2
// W64: encoding: [0x05,0x00,0x19,0xd7,0xc1,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_u32 v5, s[0:1], 0.5, v2
// W64: encoding: [0x05,0x00,0x19,0xd7,0xf0,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_u32 v5, s[0:1], -4.0, v2
// W64: encoding: [0x05,0x00,0x19,0xd7,0xf7,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_u32 v5, s[0:1], v1, v255
// W64: encoding: [0x05,0x00,0x19,0xd7,0x01,0xff,0x03,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_u32 v5, s[0:1], v1, s2
// W64: encoding: [0x05,0x00,0x19,0xd7,0x01,0x05,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_u32 v5, s[0:1], v1, s103
// W64: encoding: [0x05,0x00,0x19,0xd7,0x01,0xcf,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_u32 v5, s[0:1], v1, vcc_lo
// W64: encoding: [0x05,0x00,0x19,0xd7,0x01,0xd5,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_u32 v5, s[0:1], v1, vcc_hi
// W64: encoding: [0x05,0x00,0x19,0xd7,0x01,0xd7,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_u32 v5, s[0:1], v1, ttmp11
// W64: encoding: [0x05,0x00,0x19,0xd7,0x01,0xef,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_u32 v5, s[0:1], v1, m0
// W64: encoding: [0x05,0x00,0x19,0xd7,0x01,0xf9,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_u32 v5, s[0:1], v1, exec_lo
// W64: encoding: [0x05,0x00,0x19,0xd7,0x01,0xfd,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_u32 v5, s[0:1], v1, exec_hi
// W64: encoding: [0x05,0x00,0x19,0xd7,0x01,0xff,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_u32 v5, s[0:1], v1, 0
// W64: encoding: [0x05,0x00,0x19,0xd7,0x01,0x01,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_u32 v5, s[0:1], v1, -1
// W64: encoding: [0x05,0x00,0x19,0xd7,0x01,0x83,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_u32 v5, s[0:1], v1, 0.5
// W64: encoding: [0x05,0x00,0x19,0xd7,0x01,0xe1,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_u32 v5, s[0:1], v1, -4.0
// W64: encoding: [0x05,0x00,0x19,0xd7,0x01,0xef,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_ldexp_f32 v5, v1, v2
// GFX10: encoding: [0x05,0x00,0x62,0xd7,0x01,0x05,0x02,0x00]

v_ldexp_f32 v255, v1, v2
// GFX10: encoding: [0xff,0x00,0x62,0xd7,0x01,0x05,0x02,0x00]

v_ldexp_f32 v5, v255, v2
// GFX10: encoding: [0x05,0x00,0x62,0xd7,0xff,0x05,0x02,0x00]

v_ldexp_f32 v5, s1, v2
// GFX10: encoding: [0x05,0x00,0x62,0xd7,0x01,0x04,0x02,0x00]

v_ldexp_f32 v5, s103, v2
// GFX10: encoding: [0x05,0x00,0x62,0xd7,0x67,0x04,0x02,0x00]

v_ldexp_f32 v5, vcc_lo, v2
// GFX10: encoding: [0x05,0x00,0x62,0xd7,0x6a,0x04,0x02,0x00]

v_ldexp_f32 v5, vcc_hi, v2
// GFX10: encoding: [0x05,0x00,0x62,0xd7,0x6b,0x04,0x02,0x00]

v_ldexp_f32 v5, ttmp11, v2
// GFX10: encoding: [0x05,0x00,0x62,0xd7,0x77,0x04,0x02,0x00]

v_ldexp_f32 v5, m0, v2
// GFX10: encoding: [0x05,0x00,0x62,0xd7,0x7c,0x04,0x02,0x00]

v_ldexp_f32 v5, exec_lo, v2
// GFX10: encoding: [0x05,0x00,0x62,0xd7,0x7e,0x04,0x02,0x00]

v_ldexp_f32 v5, exec_hi, v2
// GFX10: encoding: [0x05,0x00,0x62,0xd7,0x7f,0x04,0x02,0x00]

v_ldexp_f32 v5, 0, v2
// GFX10: encoding: [0x05,0x00,0x62,0xd7,0x80,0x04,0x02,0x00]

v_ldexp_f32 v5, -1, v2
// GFX10: encoding: [0x05,0x00,0x62,0xd7,0xc1,0x04,0x02,0x00]

v_ldexp_f32 v5, 0.5, v2
// GFX10: encoding: [0x05,0x00,0x62,0xd7,0xf0,0x04,0x02,0x00]

v_ldexp_f32 v5, -4.0, v2
// GFX10: encoding: [0x05,0x00,0x62,0xd7,0xf7,0x04,0x02,0x00]

v_ldexp_f32 v5, v1, v255
// GFX10: encoding: [0x05,0x00,0x62,0xd7,0x01,0xff,0x03,0x00]

v_ldexp_f32 v5, v1, s2
// GFX10: encoding: [0x05,0x00,0x62,0xd7,0x01,0x05,0x00,0x00]

v_ldexp_f32 v5, v1, s103
// GFX10: encoding: [0x05,0x00,0x62,0xd7,0x01,0xcf,0x00,0x00]

v_ldexp_f32 v5, v1, vcc_lo
// GFX10: encoding: [0x05,0x00,0x62,0xd7,0x01,0xd5,0x00,0x00]

v_ldexp_f32 v5, v1, vcc_hi
// GFX10: encoding: [0x05,0x00,0x62,0xd7,0x01,0xd7,0x00,0x00]

v_ldexp_f32 v5, v1, ttmp11
// GFX10: encoding: [0x05,0x00,0x62,0xd7,0x01,0xef,0x00,0x00]

v_ldexp_f32 v5, v1, m0
// GFX10: encoding: [0x05,0x00,0x62,0xd7,0x01,0xf9,0x00,0x00]

v_ldexp_f32 v5, v1, exec_lo
// GFX10: encoding: [0x05,0x00,0x62,0xd7,0x01,0xfd,0x00,0x00]

v_ldexp_f32 v5, v1, exec_hi
// GFX10: encoding: [0x05,0x00,0x62,0xd7,0x01,0xff,0x00,0x00]

v_ldexp_f32 v5, v1, 0
// GFX10: encoding: [0x05,0x00,0x62,0xd7,0x01,0x01,0x01,0x00]

v_ldexp_f32 v5, v1, -1
// GFX10: encoding: [0x05,0x00,0x62,0xd7,0x01,0x83,0x01,0x00]

v_ldexp_f32 v5, v1, 0.5
// GFX10: encoding: [0x05,0x00,0x62,0xd7,0x01,0xe1,0x01,0x00]

v_ldexp_f32 v5, v1, -4.0
// GFX10: encoding: [0x05,0x00,0x62,0xd7,0x01,0xef,0x01,0x00]

v_ldexp_f32 v5, -v1, v2
// GFX10: encoding: [0x05,0x00,0x62,0xd7,0x01,0x05,0x02,0x20]

v_ldexp_f32 v5, |v1|, v2
// GFX10: encoding: [0x05,0x01,0x62,0xd7,0x01,0x05,0x02,0x00]

v_ldexp_f32 v5, v1, v2 clamp
// GFX10: encoding: [0x05,0x80,0x62,0xd7,0x01,0x05,0x02,0x00]

v_ldexp_f32 v5, v1, v2 mul:2
// GFX10: encoding: [0x05,0x00,0x62,0xd7,0x01,0x05,0x02,0x08]

v_ldexp_f32 v5, v1, v2 mul:4
// GFX10: encoding: [0x05,0x00,0x62,0xd7,0x01,0x05,0x02,0x10]

v_ldexp_f32 v5, v1, v2 div:2
// GFX10: encoding: [0x05,0x00,0x62,0xd7,0x01,0x05,0x02,0x18]

v_cvt_pknorm_i16_f32 v5, v1, v2
// GFX10: encoding: [0x05,0x00,0x68,0xd7,0x01,0x05,0x02,0x00]

v_cvt_pknorm_i16_f32 v255, v1, v2
// GFX10: encoding: [0xff,0x00,0x68,0xd7,0x01,0x05,0x02,0x00]

v_cvt_pknorm_i16_f32 v5, v255, v2
// GFX10: encoding: [0x05,0x00,0x68,0xd7,0xff,0x05,0x02,0x00]

v_cvt_pknorm_i16_f32 v5, s1, v2
// GFX10: encoding: [0x05,0x00,0x68,0xd7,0x01,0x04,0x02,0x00]

v_cvt_pknorm_i16_f32 v5, s103, v2
// GFX10: encoding: [0x05,0x00,0x68,0xd7,0x67,0x04,0x02,0x00]

v_cvt_pknorm_i16_f32 v5, vcc_lo, v2
// GFX10: encoding: [0x05,0x00,0x68,0xd7,0x6a,0x04,0x02,0x00]

v_cvt_pknorm_i16_f32 v5, vcc_hi, v2
// GFX10: encoding: [0x05,0x00,0x68,0xd7,0x6b,0x04,0x02,0x00]

v_cvt_pknorm_i16_f32 v5, ttmp11, v2
// GFX10: encoding: [0x05,0x00,0x68,0xd7,0x77,0x04,0x02,0x00]

v_cvt_pknorm_i16_f32 v5, m0, v2
// GFX10: encoding: [0x05,0x00,0x68,0xd7,0x7c,0x04,0x02,0x00]

v_cvt_pknorm_i16_f32 v5, exec_lo, v2
// GFX10: encoding: [0x05,0x00,0x68,0xd7,0x7e,0x04,0x02,0x00]

v_cvt_pknorm_i16_f32 v5, exec_hi, v2
// GFX10: encoding: [0x05,0x00,0x68,0xd7,0x7f,0x04,0x02,0x00]

v_cvt_pknorm_i16_f32 v5, 0, v2
// GFX10: encoding: [0x05,0x00,0x68,0xd7,0x80,0x04,0x02,0x00]

v_cvt_pknorm_i16_f32 v5, -1, v2
// GFX10: encoding: [0x05,0x00,0x68,0xd7,0xc1,0x04,0x02,0x00]

v_cvt_pknorm_i16_f32 v5, 0.5, v2
// GFX10: encoding: [0x05,0x00,0x68,0xd7,0xf0,0x04,0x02,0x00]

v_cvt_pknorm_i16_f32 v5, -4.0, v2
// GFX10: encoding: [0x05,0x00,0x68,0xd7,0xf7,0x04,0x02,0x00]

v_cvt_pknorm_i16_f32 v5, v1, v255
// GFX10: encoding: [0x05,0x00,0x68,0xd7,0x01,0xff,0x03,0x00]

v_cvt_pknorm_i16_f32 v5, v1, s2
// GFX10: encoding: [0x05,0x00,0x68,0xd7,0x01,0x05,0x00,0x00]

v_cvt_pknorm_i16_f32 v5, v1, s103
// GFX10: encoding: [0x05,0x00,0x68,0xd7,0x01,0xcf,0x00,0x00]

v_cvt_pknorm_i16_f32 v5, v1, vcc_lo
// GFX10: encoding: [0x05,0x00,0x68,0xd7,0x01,0xd5,0x00,0x00]

v_cvt_pknorm_i16_f32 v5, v1, vcc_hi
// GFX10: encoding: [0x05,0x00,0x68,0xd7,0x01,0xd7,0x00,0x00]

v_cvt_pknorm_i16_f32 v5, v1, ttmp11
// GFX10: encoding: [0x05,0x00,0x68,0xd7,0x01,0xef,0x00,0x00]

v_cvt_pknorm_i16_f32 v5, v1, m0
// GFX10: encoding: [0x05,0x00,0x68,0xd7,0x01,0xf9,0x00,0x00]

v_cvt_pknorm_i16_f32 v5, v1, exec_lo
// GFX10: encoding: [0x05,0x00,0x68,0xd7,0x01,0xfd,0x00,0x00]

v_cvt_pknorm_i16_f32 v5, v1, exec_hi
// GFX10: encoding: [0x05,0x00,0x68,0xd7,0x01,0xff,0x00,0x00]

v_cvt_pknorm_i16_f32 v5, v1, 0
// GFX10: encoding: [0x05,0x00,0x68,0xd7,0x01,0x01,0x01,0x00]

v_cvt_pknorm_i16_f32 v5, v1, -1
// GFX10: encoding: [0x05,0x00,0x68,0xd7,0x01,0x83,0x01,0x00]

v_cvt_pknorm_i16_f32 v5, v1, 0.5
// GFX10: encoding: [0x05,0x00,0x68,0xd7,0x01,0xe1,0x01,0x00]

v_cvt_pknorm_i16_f32 v5, v1, -4.0
// GFX10: encoding: [0x05,0x00,0x68,0xd7,0x01,0xef,0x01,0x00]

v_cvt_pknorm_i16_f32 v5, -v1, v2
// GFX10: encoding: [0x05,0x00,0x68,0xd7,0x01,0x05,0x02,0x20]

v_cvt_pknorm_i16_f32 v5, v1, -v2
// GFX10: encoding: [0x05,0x00,0x68,0xd7,0x01,0x05,0x02,0x40]

v_cvt_pknorm_i16_f32 v5, -v1, -v2
// GFX10: encoding: [0x05,0x00,0x68,0xd7,0x01,0x05,0x02,0x60]

v_cvt_pknorm_i16_f32 v5, |v1|, v2
// GFX10: encoding: [0x05,0x01,0x68,0xd7,0x01,0x05,0x02,0x00]

v_cvt_pknorm_i16_f32 v5, v1, |v2|
// GFX10: encoding: [0x05,0x02,0x68,0xd7,0x01,0x05,0x02,0x00]

v_cvt_pknorm_i16_f32 v5, |v1|, |v2|
// GFX10: encoding: [0x05,0x03,0x68,0xd7,0x01,0x05,0x02,0x00]

v_cvt_pknorm_i16_f32 v5, v1, v2 clamp
// GFX10: encoding: [0x05,0x80,0x68,0xd7,0x01,0x05,0x02,0x00]

v_cvt_pknorm_u16_f32 v5, v1, v2
// GFX10: encoding: [0x05,0x00,0x69,0xd7,0x01,0x05,0x02,0x00]

v_cvt_pknorm_u16_f32 v255, v1, v2
// GFX10: encoding: [0xff,0x00,0x69,0xd7,0x01,0x05,0x02,0x00]

v_cvt_pknorm_u16_f32 v5, v255, v2
// GFX10: encoding: [0x05,0x00,0x69,0xd7,0xff,0x05,0x02,0x00]

v_cvt_pknorm_u16_f32 v5, s1, v2
// GFX10: encoding: [0x05,0x00,0x69,0xd7,0x01,0x04,0x02,0x00]

v_cvt_pknorm_u16_f32 v5, s103, v2
// GFX10: encoding: [0x05,0x00,0x69,0xd7,0x67,0x04,0x02,0x00]

v_cvt_pknorm_u16_f32 v5, vcc_lo, v2
// GFX10: encoding: [0x05,0x00,0x69,0xd7,0x6a,0x04,0x02,0x00]

v_cvt_pknorm_u16_f32 v5, vcc_hi, v2
// GFX10: encoding: [0x05,0x00,0x69,0xd7,0x6b,0x04,0x02,0x00]

v_cvt_pknorm_u16_f32 v5, ttmp11, v2
// GFX10: encoding: [0x05,0x00,0x69,0xd7,0x77,0x04,0x02,0x00]

v_cvt_pknorm_u16_f32 v5, m0, v2
// GFX10: encoding: [0x05,0x00,0x69,0xd7,0x7c,0x04,0x02,0x00]

v_cvt_pknorm_u16_f32 v5, exec_lo, v2
// GFX10: encoding: [0x05,0x00,0x69,0xd7,0x7e,0x04,0x02,0x00]

v_cvt_pknorm_u16_f32 v5, exec_hi, v2
// GFX10: encoding: [0x05,0x00,0x69,0xd7,0x7f,0x04,0x02,0x00]

v_cvt_pknorm_u16_f32 v5, 0, v2
// GFX10: encoding: [0x05,0x00,0x69,0xd7,0x80,0x04,0x02,0x00]

v_cvt_pknorm_u16_f32 v5, -1, v2
// GFX10: encoding: [0x05,0x00,0x69,0xd7,0xc1,0x04,0x02,0x00]

v_cvt_pknorm_u16_f32 v5, 0.5, v2
// GFX10: encoding: [0x05,0x00,0x69,0xd7,0xf0,0x04,0x02,0x00]

v_cvt_pknorm_u16_f32 v5, -4.0, v2
// GFX10: encoding: [0x05,0x00,0x69,0xd7,0xf7,0x04,0x02,0x00]

v_cvt_pknorm_u16_f32 v5, v1, v255
// GFX10: encoding: [0x05,0x00,0x69,0xd7,0x01,0xff,0x03,0x00]

v_cvt_pknorm_u16_f32 v5, v1, s2
// GFX10: encoding: [0x05,0x00,0x69,0xd7,0x01,0x05,0x00,0x00]

v_cvt_pknorm_u16_f32 v5, v1, s103
// GFX10: encoding: [0x05,0x00,0x69,0xd7,0x01,0xcf,0x00,0x00]

v_cvt_pknorm_u16_f32 v5, v1, vcc_lo
// GFX10: encoding: [0x05,0x00,0x69,0xd7,0x01,0xd5,0x00,0x00]

v_cvt_pknorm_u16_f32 v5, v1, vcc_hi
// GFX10: encoding: [0x05,0x00,0x69,0xd7,0x01,0xd7,0x00,0x00]

v_cvt_pknorm_u16_f32 v5, v1, ttmp11
// GFX10: encoding: [0x05,0x00,0x69,0xd7,0x01,0xef,0x00,0x00]

v_cvt_pknorm_u16_f32 v5, v1, m0
// GFX10: encoding: [0x05,0x00,0x69,0xd7,0x01,0xf9,0x00,0x00]

v_cvt_pknorm_u16_f32 v5, v1, exec_lo
// GFX10: encoding: [0x05,0x00,0x69,0xd7,0x01,0xfd,0x00,0x00]

v_cvt_pknorm_u16_f32 v5, v1, exec_hi
// GFX10: encoding: [0x05,0x00,0x69,0xd7,0x01,0xff,0x00,0x00]

v_cvt_pknorm_u16_f32 v5, v1, 0
// GFX10: encoding: [0x05,0x00,0x69,0xd7,0x01,0x01,0x01,0x00]

v_cvt_pknorm_u16_f32 v5, v1, -1
// GFX10: encoding: [0x05,0x00,0x69,0xd7,0x01,0x83,0x01,0x00]

v_cvt_pknorm_u16_f32 v5, v1, 0.5
// GFX10: encoding: [0x05,0x00,0x69,0xd7,0x01,0xe1,0x01,0x00]

v_cvt_pknorm_u16_f32 v5, v1, -4.0
// GFX10: encoding: [0x05,0x00,0x69,0xd7,0x01,0xef,0x01,0x00]

v_cvt_pknorm_u16_f32 v5, -v1, v2
// GFX10: encoding: [0x05,0x00,0x69,0xd7,0x01,0x05,0x02,0x20]

v_cvt_pknorm_u16_f32 v5, v1, -v2
// GFX10: encoding: [0x05,0x00,0x69,0xd7,0x01,0x05,0x02,0x40]

v_cvt_pknorm_u16_f32 v5, -v1, -v2
// GFX10: encoding: [0x05,0x00,0x69,0xd7,0x01,0x05,0x02,0x60]

v_cvt_pknorm_u16_f32 v5, |v1|, v2
// GFX10: encoding: [0x05,0x01,0x69,0xd7,0x01,0x05,0x02,0x00]

v_cvt_pknorm_u16_f32 v5, v1, |v2|
// GFX10: encoding: [0x05,0x02,0x69,0xd7,0x01,0x05,0x02,0x00]

v_cvt_pknorm_u16_f32 v5, |v1|, |v2|
// GFX10: encoding: [0x05,0x03,0x69,0xd7,0x01,0x05,0x02,0x00]

v_cvt_pknorm_u16_f32 v5, v1, v2 clamp
// GFX10: encoding: [0x05,0x80,0x69,0xd7,0x01,0x05,0x02,0x00]

v_cvt_pk_u16_u32 v5, v1, v2
// GFX10: encoding: [0x05,0x00,0x6a,0xd7,0x01,0x05,0x02,0x00]

v_cvt_pk_u16_u32 v255, v1, v2
// GFX10: encoding: [0xff,0x00,0x6a,0xd7,0x01,0x05,0x02,0x00]

v_cvt_pk_u16_u32 v5, v255, v2
// GFX10: encoding: [0x05,0x00,0x6a,0xd7,0xff,0x05,0x02,0x00]

v_cvt_pk_u16_u32 v5, s1, v2
// GFX10: encoding: [0x05,0x00,0x6a,0xd7,0x01,0x04,0x02,0x00]

v_cvt_pk_u16_u32 v5, s103, v2
// GFX10: encoding: [0x05,0x00,0x6a,0xd7,0x67,0x04,0x02,0x00]

v_cvt_pk_u16_u32 v5, vcc_lo, v2
// GFX10: encoding: [0x05,0x00,0x6a,0xd7,0x6a,0x04,0x02,0x00]

v_cvt_pk_u16_u32 v5, vcc_hi, v2
// GFX10: encoding: [0x05,0x00,0x6a,0xd7,0x6b,0x04,0x02,0x00]

v_cvt_pk_u16_u32 v5, ttmp11, v2
// GFX10: encoding: [0x05,0x00,0x6a,0xd7,0x77,0x04,0x02,0x00]

v_cvt_pk_u16_u32 v5, m0, v2
// GFX10: encoding: [0x05,0x00,0x6a,0xd7,0x7c,0x04,0x02,0x00]

v_cvt_pk_u16_u32 v5, exec_lo, v2
// GFX10: encoding: [0x05,0x00,0x6a,0xd7,0x7e,0x04,0x02,0x00]

v_cvt_pk_u16_u32 v5, exec_hi, v2
// GFX10: encoding: [0x05,0x00,0x6a,0xd7,0x7f,0x04,0x02,0x00]

v_cvt_pk_u16_u32 v5, 0, v2
// GFX10: encoding: [0x05,0x00,0x6a,0xd7,0x80,0x04,0x02,0x00]

v_cvt_pk_u16_u32 v5, -1, v2
// GFX10: encoding: [0x05,0x00,0x6a,0xd7,0xc1,0x04,0x02,0x00]

v_cvt_pk_u16_u32 v5, 0.5, v2
// GFX10: encoding: [0x05,0x00,0x6a,0xd7,0xf0,0x04,0x02,0x00]

v_cvt_pk_u16_u32 v5, -4.0, v2
// GFX10: encoding: [0x05,0x00,0x6a,0xd7,0xf7,0x04,0x02,0x00]

v_cvt_pk_u16_u32 v5, v1, v255
// GFX10: encoding: [0x05,0x00,0x6a,0xd7,0x01,0xff,0x03,0x00]

v_cvt_pk_u16_u32 v5, v1, s2
// GFX10: encoding: [0x05,0x00,0x6a,0xd7,0x01,0x05,0x00,0x00]

v_cvt_pk_u16_u32 v5, v1, s103
// GFX10: encoding: [0x05,0x00,0x6a,0xd7,0x01,0xcf,0x00,0x00]

v_cvt_pk_u16_u32 v5, v1, vcc_lo
// GFX10: encoding: [0x05,0x00,0x6a,0xd7,0x01,0xd5,0x00,0x00]

v_cvt_pk_u16_u32 v5, v1, vcc_hi
// GFX10: encoding: [0x05,0x00,0x6a,0xd7,0x01,0xd7,0x00,0x00]

v_cvt_pk_u16_u32 v5, v1, ttmp11
// GFX10: encoding: [0x05,0x00,0x6a,0xd7,0x01,0xef,0x00,0x00]

v_cvt_pk_u16_u32 v5, v1, m0
// GFX10: encoding: [0x05,0x00,0x6a,0xd7,0x01,0xf9,0x00,0x00]

v_cvt_pk_u16_u32 v5, v1, exec_lo
// GFX10: encoding: [0x05,0x00,0x6a,0xd7,0x01,0xfd,0x00,0x00]

v_cvt_pk_u16_u32 v5, v1, exec_hi
// GFX10: encoding: [0x05,0x00,0x6a,0xd7,0x01,0xff,0x00,0x00]

v_cvt_pk_u16_u32 v5, v1, 0
// GFX10: encoding: [0x05,0x00,0x6a,0xd7,0x01,0x01,0x01,0x00]

v_cvt_pk_u16_u32 v5, v1, -1
// GFX10: encoding: [0x05,0x00,0x6a,0xd7,0x01,0x83,0x01,0x00]

v_cvt_pk_u16_u32 v5, v1, 0.5
// GFX10: encoding: [0x05,0x00,0x6a,0xd7,0x01,0xe1,0x01,0x00]

v_cvt_pk_u16_u32 v5, v1, -4.0
// GFX10: encoding: [0x05,0x00,0x6a,0xd7,0x01,0xef,0x01,0x00]

v_cvt_pk_i16_i32 v5, v1, v2
// GFX10: encoding: [0x05,0x00,0x6b,0xd7,0x01,0x05,0x02,0x00]

v_cvt_pk_i16_i32 v255, v1, v2
// GFX10: encoding: [0xff,0x00,0x6b,0xd7,0x01,0x05,0x02,0x00]

v_cvt_pk_i16_i32 v5, v255, v2
// GFX10: encoding: [0x05,0x00,0x6b,0xd7,0xff,0x05,0x02,0x00]

v_cvt_pk_i16_i32 v5, s1, v2
// GFX10: encoding: [0x05,0x00,0x6b,0xd7,0x01,0x04,0x02,0x00]

v_cvt_pk_i16_i32 v5, s103, v2
// GFX10: encoding: [0x05,0x00,0x6b,0xd7,0x67,0x04,0x02,0x00]

v_cvt_pk_i16_i32 v5, vcc_lo, v2
// GFX10: encoding: [0x05,0x00,0x6b,0xd7,0x6a,0x04,0x02,0x00]

v_cvt_pk_i16_i32 v5, vcc_hi, v2
// GFX10: encoding: [0x05,0x00,0x6b,0xd7,0x6b,0x04,0x02,0x00]

v_cvt_pk_i16_i32 v5, ttmp11, v2
// GFX10: encoding: [0x05,0x00,0x6b,0xd7,0x77,0x04,0x02,0x00]

v_cvt_pk_i16_i32 v5, m0, v2
// GFX10: encoding: [0x05,0x00,0x6b,0xd7,0x7c,0x04,0x02,0x00]

v_cvt_pk_i16_i32 v5, exec_lo, v2
// GFX10: encoding: [0x05,0x00,0x6b,0xd7,0x7e,0x04,0x02,0x00]

v_cvt_pk_i16_i32 v5, exec_hi, v2
// GFX10: encoding: [0x05,0x00,0x6b,0xd7,0x7f,0x04,0x02,0x00]

v_cvt_pk_i16_i32 v5, 0, v2
// GFX10: encoding: [0x05,0x00,0x6b,0xd7,0x80,0x04,0x02,0x00]

v_cvt_pk_i16_i32 v5, -1, v2
// GFX10: encoding: [0x05,0x00,0x6b,0xd7,0xc1,0x04,0x02,0x00]

v_cvt_pk_i16_i32 v5, 0.5, v2
// GFX10: encoding: [0x05,0x00,0x6b,0xd7,0xf0,0x04,0x02,0x00]

v_cvt_pk_i16_i32 v5, -4.0, v2
// GFX10: encoding: [0x05,0x00,0x6b,0xd7,0xf7,0x04,0x02,0x00]

v_cvt_pk_i16_i32 v5, v1, v255
// GFX10: encoding: [0x05,0x00,0x6b,0xd7,0x01,0xff,0x03,0x00]

v_cvt_pk_i16_i32 v5, v1, s2
// GFX10: encoding: [0x05,0x00,0x6b,0xd7,0x01,0x05,0x00,0x00]

v_cvt_pk_i16_i32 v5, v1, s103
// GFX10: encoding: [0x05,0x00,0x6b,0xd7,0x01,0xcf,0x00,0x00]

v_cvt_pk_i16_i32 v5, v1, vcc_lo
// GFX10: encoding: [0x05,0x00,0x6b,0xd7,0x01,0xd5,0x00,0x00]

v_cvt_pk_i16_i32 v5, v1, vcc_hi
// GFX10: encoding: [0x05,0x00,0x6b,0xd7,0x01,0xd7,0x00,0x00]

v_cvt_pk_i16_i32 v5, v1, ttmp11
// GFX10: encoding: [0x05,0x00,0x6b,0xd7,0x01,0xef,0x00,0x00]

v_cvt_pk_i16_i32 v5, v1, m0
// GFX10: encoding: [0x05,0x00,0x6b,0xd7,0x01,0xf9,0x00,0x00]

v_cvt_pk_i16_i32 v5, v1, exec_lo
// GFX10: encoding: [0x05,0x00,0x6b,0xd7,0x01,0xfd,0x00,0x00]

v_cvt_pk_i16_i32 v5, v1, exec_hi
// GFX10: encoding: [0x05,0x00,0x6b,0xd7,0x01,0xff,0x00,0x00]

v_cvt_pk_i16_i32 v5, v1, 0
// GFX10: encoding: [0x05,0x00,0x6b,0xd7,0x01,0x01,0x01,0x00]

v_cvt_pk_i16_i32 v5, v1, -1
// GFX10: encoding: [0x05,0x00,0x6b,0xd7,0x01,0x83,0x01,0x00]

v_cvt_pk_i16_i32 v5, v1, 0.5
// GFX10: encoding: [0x05,0x00,0x6b,0xd7,0x01,0xe1,0x01,0x00]

v_cvt_pk_i16_i32 v5, v1, -4.0
// GFX10: encoding: [0x05,0x00,0x6b,0xd7,0x01,0xef,0x01,0x00]

v_mad_legacy_f32 v5, v1, v2, v3
// GFX10: encoding: [0x05,0x00,0x40,0xd5,0x01,0x05,0x0e,0x04]

v_mad_legacy_f32 v255, v1, v2, v3
// GFX10: encoding: [0xff,0x00,0x40,0xd5,0x01,0x05,0x0e,0x04]

v_mad_legacy_f32 v5, v255, v2, v3
// GFX10: encoding: [0x05,0x00,0x40,0xd5,0xff,0x05,0x0e,0x04]

v_mad_legacy_f32 v5, s1, v2, v3
// GFX10: encoding: [0x05,0x00,0x40,0xd5,0x01,0x04,0x0e,0x04]

v_mad_legacy_f32 v5, s103, v2, v3
// GFX10: encoding: [0x05,0x00,0x40,0xd5,0x67,0x04,0x0e,0x04]

v_mad_legacy_f32 v5, vcc_lo, v2, v3
// GFX10: encoding: [0x05,0x00,0x40,0xd5,0x6a,0x04,0x0e,0x04]

v_mad_legacy_f32 v5, vcc_hi, v2, v3
// GFX10: encoding: [0x05,0x00,0x40,0xd5,0x6b,0x04,0x0e,0x04]

v_mad_legacy_f32 v5, ttmp11, v2, v3
// GFX10: encoding: [0x05,0x00,0x40,0xd5,0x77,0x04,0x0e,0x04]

v_mad_legacy_f32 v5, m0, v2, v3
// GFX10: encoding: [0x05,0x00,0x40,0xd5,0x7c,0x04,0x0e,0x04]

v_mad_legacy_f32 v5, exec_lo, v2, v3
// GFX10: encoding: [0x05,0x00,0x40,0xd5,0x7e,0x04,0x0e,0x04]

v_mad_legacy_f32 v5, exec_hi, v2, v3
// GFX10: encoding: [0x05,0x00,0x40,0xd5,0x7f,0x04,0x0e,0x04]

v_mad_legacy_f32 v5, 0, v2, v3
// GFX10: encoding: [0x05,0x00,0x40,0xd5,0x80,0x04,0x0e,0x04]

v_mad_legacy_f32 v5, -1, v2, v3
// GFX10: encoding: [0x05,0x00,0x40,0xd5,0xc1,0x04,0x0e,0x04]

v_mad_legacy_f32 v5, 0.5, v2, v3
// GFX10: encoding: [0x05,0x00,0x40,0xd5,0xf0,0x04,0x0e,0x04]

v_mad_legacy_f32 v5, -4.0, v2, v3
// GFX10: encoding: [0x05,0x00,0x40,0xd5,0xf7,0x04,0x0e,0x04]

v_mad_legacy_f32 v5, v1, v255, v3
// GFX10: encoding: [0x05,0x00,0x40,0xd5,0x01,0xff,0x0f,0x04]

v_mad_legacy_f32 v5, v1, s2, v3
// GFX10: encoding: [0x05,0x00,0x40,0xd5,0x01,0x05,0x0c,0x04]

v_mad_legacy_f32 v5, v1, s103, v3
// GFX10: encoding: [0x05,0x00,0x40,0xd5,0x01,0xcf,0x0c,0x04]

v_mad_legacy_f32 v5, v1, vcc_lo, v3
// GFX10: encoding: [0x05,0x00,0x40,0xd5,0x01,0xd5,0x0c,0x04]

v_mad_legacy_f32 v5, v1, vcc_hi, v3
// GFX10: encoding: [0x05,0x00,0x40,0xd5,0x01,0xd7,0x0c,0x04]

v_mad_legacy_f32 v5, v1, ttmp11, v3
// GFX10: encoding: [0x05,0x00,0x40,0xd5,0x01,0xef,0x0c,0x04]

v_mad_legacy_f32 v5, v1, m0, v3
// GFX10: encoding: [0x05,0x00,0x40,0xd5,0x01,0xf9,0x0c,0x04]

v_mad_legacy_f32 v5, v1, exec_lo, v3
// GFX10: encoding: [0x05,0x00,0x40,0xd5,0x01,0xfd,0x0c,0x04]

v_mad_legacy_f32 v5, v1, exec_hi, v3
// GFX10: encoding: [0x05,0x00,0x40,0xd5,0x01,0xff,0x0c,0x04]

v_mad_legacy_f32 v5, v1, 0, v3
// GFX10: encoding: [0x05,0x00,0x40,0xd5,0x01,0x01,0x0d,0x04]

v_mad_legacy_f32 v5, v1, -1, v3
// GFX10: encoding: [0x05,0x00,0x40,0xd5,0x01,0x83,0x0d,0x04]

v_mad_legacy_f32 v5, v1, 0.5, v3
// GFX10: encoding: [0x05,0x00,0x40,0xd5,0x01,0xe1,0x0d,0x04]

v_mad_legacy_f32 v5, v1, -4.0, v3
// GFX10: encoding: [0x05,0x00,0x40,0xd5,0x01,0xef,0x0d,0x04]

v_mad_legacy_f32 v5, v1, v2, v255
// GFX10: encoding: [0x05,0x00,0x40,0xd5,0x01,0x05,0xfe,0x07]

v_mad_legacy_f32 v5, v1, v2, s3
// GFX10: encoding: [0x05,0x00,0x40,0xd5,0x01,0x05,0x0e,0x00]

v_mad_legacy_f32 v5, v1, v2, s103
// GFX10: encoding: [0x05,0x00,0x40,0xd5,0x01,0x05,0x9e,0x01]

v_mad_legacy_f32 v5, v1, v2, vcc_lo
// GFX10: encoding: [0x05,0x00,0x40,0xd5,0x01,0x05,0xaa,0x01]

v_mad_legacy_f32 v5, v1, v2, vcc_hi
// GFX10: encoding: [0x05,0x00,0x40,0xd5,0x01,0x05,0xae,0x01]

v_mad_legacy_f32 v5, v1, v2, ttmp11
// GFX10: encoding: [0x05,0x00,0x40,0xd5,0x01,0x05,0xde,0x01]

v_mad_legacy_f32 v5, v1, v2, m0
// GFX10: encoding: [0x05,0x00,0x40,0xd5,0x01,0x05,0xf2,0x01]

v_mad_legacy_f32 v5, v1, v2, exec_lo
// GFX10: encoding: [0x05,0x00,0x40,0xd5,0x01,0x05,0xfa,0x01]

v_mad_legacy_f32 v5, v1, v2, exec_hi
// GFX10: encoding: [0x05,0x00,0x40,0xd5,0x01,0x05,0xfe,0x01]

v_mad_legacy_f32 v5, v1, v2, 0
// GFX10: encoding: [0x05,0x00,0x40,0xd5,0x01,0x05,0x02,0x02]

v_mad_legacy_f32 v5, v1, v2, -1
// GFX10: encoding: [0x05,0x00,0x40,0xd5,0x01,0x05,0x06,0x03]

v_mad_legacy_f32 v5, v1, v2, 0.5
// GFX10: encoding: [0x05,0x00,0x40,0xd5,0x01,0x05,0xc2,0x03]

v_mad_legacy_f32 v5, v1, v2, -4.0
// GFX10: encoding: [0x05,0x00,0x40,0xd5,0x01,0x05,0xde,0x03]

v_mad_legacy_f32 v5, -v1, v2, v3
// GFX10: encoding: [0x05,0x00,0x40,0xd5,0x01,0x05,0x0e,0x24]

v_mad_legacy_f32 v5, v1, -v2, v3
// GFX10: encoding: [0x05,0x00,0x40,0xd5,0x01,0x05,0x0e,0x44]

v_mad_legacy_f32 v5, v1, v2, -v3
// GFX10: encoding: [0x05,0x00,0x40,0xd5,0x01,0x05,0x0e,0x84]

v_mad_legacy_f32 v5, -v1, -v2, -v3
// GFX10: encoding: [0x05,0x00,0x40,0xd5,0x01,0x05,0x0e,0xe4]

v_mad_legacy_f32 v5, |v1|, v2, v3
// GFX10: encoding: [0x05,0x01,0x40,0xd5,0x01,0x05,0x0e,0x04]

v_mad_legacy_f32 v5, v1, |v2|, v3
// GFX10: encoding: [0x05,0x02,0x40,0xd5,0x01,0x05,0x0e,0x04]

v_mad_legacy_f32 v5, v1, v2, |v3|
// GFX10: encoding: [0x05,0x04,0x40,0xd5,0x01,0x05,0x0e,0x04]

v_mad_legacy_f32 v5, |v1|, |v2|, |v3|
// GFX10: encoding: [0x05,0x07,0x40,0xd5,0x01,0x05,0x0e,0x04]

v_mad_legacy_f32 v5, v1, v2, v3 clamp
// GFX10: encoding: [0x05,0x80,0x40,0xd5,0x01,0x05,0x0e,0x04]

v_mad_legacy_f32 v5, v1, v2, v3 mul:2
// GFX10: encoding: [0x05,0x00,0x40,0xd5,0x01,0x05,0x0e,0x0c]

v_mad_legacy_f32 v5, v1, v2, v3 mul:4
// GFX10: encoding: [0x05,0x00,0x40,0xd5,0x01,0x05,0x0e,0x14]

v_mad_legacy_f32 v5, v1, v2, v3 div:2
// GFX10: encoding: [0x05,0x00,0x40,0xd5,0x01,0x05,0x0e,0x1c]

v_mad_f32 v5, v1, v2, v3
// GFX10: encoding: [0x05,0x00,0x41,0xd5,0x01,0x05,0x0e,0x04]

v_mad_f32 v255, v1, v2, v3
// GFX10: encoding: [0xff,0x00,0x41,0xd5,0x01,0x05,0x0e,0x04]

v_mad_f32 v5, v255, v2, v3
// GFX10: encoding: [0x05,0x00,0x41,0xd5,0xff,0x05,0x0e,0x04]

v_mad_f32 v5, s1, v2, v3
// GFX10: encoding: [0x05,0x00,0x41,0xd5,0x01,0x04,0x0e,0x04]

v_mad_f32 v5, s103, v2, v3
// GFX10: encoding: [0x05,0x00,0x41,0xd5,0x67,0x04,0x0e,0x04]

v_mad_f32 v5, vcc_lo, v2, v3
// GFX10: encoding: [0x05,0x00,0x41,0xd5,0x6a,0x04,0x0e,0x04]

v_mad_f32 v5, vcc_hi, v2, v3
// GFX10: encoding: [0x05,0x00,0x41,0xd5,0x6b,0x04,0x0e,0x04]

v_mad_f32 v5, ttmp11, v2, v3
// GFX10: encoding: [0x05,0x00,0x41,0xd5,0x77,0x04,0x0e,0x04]

v_mad_f32 v5, m0, v2, v3
// GFX10: encoding: [0x05,0x00,0x41,0xd5,0x7c,0x04,0x0e,0x04]

v_mad_f32 v5, exec_lo, v2, v3
// GFX10: encoding: [0x05,0x00,0x41,0xd5,0x7e,0x04,0x0e,0x04]

v_mad_f32 v5, exec_hi, v2, v3
// GFX10: encoding: [0x05,0x00,0x41,0xd5,0x7f,0x04,0x0e,0x04]

v_mad_f32 v5, 0, v2, v3
// GFX10: encoding: [0x05,0x00,0x41,0xd5,0x80,0x04,0x0e,0x04]

v_mad_f32 v5, -1, v2, v3
// GFX10: encoding: [0x05,0x00,0x41,0xd5,0xc1,0x04,0x0e,0x04]

v_mad_f32 v5, 0.5, v2, v3
// GFX10: encoding: [0x05,0x00,0x41,0xd5,0xf0,0x04,0x0e,0x04]

v_mad_f32 v5, -4.0, v2, v3
// GFX10: encoding: [0x05,0x00,0x41,0xd5,0xf7,0x04,0x0e,0x04]

v_mad_f32 v5, v1, v255, v3
// GFX10: encoding: [0x05,0x00,0x41,0xd5,0x01,0xff,0x0f,0x04]

v_mad_f32 v5, v1, s2, v3
// GFX10: encoding: [0x05,0x00,0x41,0xd5,0x01,0x05,0x0c,0x04]

v_mad_f32 v5, v1, s103, v3
// GFX10: encoding: [0x05,0x00,0x41,0xd5,0x01,0xcf,0x0c,0x04]

v_mad_f32 v5, v1, vcc_lo, v3
// GFX10: encoding: [0x05,0x00,0x41,0xd5,0x01,0xd5,0x0c,0x04]

v_mad_f32 v5, v1, vcc_hi, v3
// GFX10: encoding: [0x05,0x00,0x41,0xd5,0x01,0xd7,0x0c,0x04]

v_mad_f32 v5, v1, ttmp11, v3
// GFX10: encoding: [0x05,0x00,0x41,0xd5,0x01,0xef,0x0c,0x04]

v_mad_f32 v5, v1, m0, v3
// GFX10: encoding: [0x05,0x00,0x41,0xd5,0x01,0xf9,0x0c,0x04]

v_mad_f32 v5, v1, exec_lo, v3
// GFX10: encoding: [0x05,0x00,0x41,0xd5,0x01,0xfd,0x0c,0x04]

v_mad_f32 v5, v1, exec_hi, v3
// GFX10: encoding: [0x05,0x00,0x41,0xd5,0x01,0xff,0x0c,0x04]

v_mad_f32 v5, v1, 0, v3
// GFX10: encoding: [0x05,0x00,0x41,0xd5,0x01,0x01,0x0d,0x04]

v_mad_f32 v5, v1, -1, v3
// GFX10: encoding: [0x05,0x00,0x41,0xd5,0x01,0x83,0x0d,0x04]

v_mad_f32 v5, v1, 0.5, v3
// GFX10: encoding: [0x05,0x00,0x41,0xd5,0x01,0xe1,0x0d,0x04]

v_mad_f32 v5, v1, -4.0, v3
// GFX10: encoding: [0x05,0x00,0x41,0xd5,0x01,0xef,0x0d,0x04]

v_mad_f32 v5, v1, v2, v255
// GFX10: encoding: [0x05,0x00,0x41,0xd5,0x01,0x05,0xfe,0x07]

v_mad_f32 v5, v1, v2, s3
// GFX10: encoding: [0x05,0x00,0x41,0xd5,0x01,0x05,0x0e,0x00]

v_mad_f32 v5, v1, v2, s103
// GFX10: encoding: [0x05,0x00,0x41,0xd5,0x01,0x05,0x9e,0x01]

v_mad_f32 v5, v1, v2, vcc_lo
// GFX10: encoding: [0x05,0x00,0x41,0xd5,0x01,0x05,0xaa,0x01]

v_mad_f32 v5, v1, v2, vcc_hi
// GFX10: encoding: [0x05,0x00,0x41,0xd5,0x01,0x05,0xae,0x01]

v_mad_f32 v5, v1, v2, ttmp11
// GFX10: encoding: [0x05,0x00,0x41,0xd5,0x01,0x05,0xde,0x01]

v_mad_f32 v5, v1, v2, m0
// GFX10: encoding: [0x05,0x00,0x41,0xd5,0x01,0x05,0xf2,0x01]

v_mad_f32 v5, v1, v2, exec_lo
// GFX10: encoding: [0x05,0x00,0x41,0xd5,0x01,0x05,0xfa,0x01]

v_mad_f32 v5, v1, v2, exec_hi
// GFX10: encoding: [0x05,0x00,0x41,0xd5,0x01,0x05,0xfe,0x01]

v_mad_f32 v5, v1, v2, 0
// GFX10: encoding: [0x05,0x00,0x41,0xd5,0x01,0x05,0x02,0x02]

v_mad_f32 v5, v1, v2, -1
// GFX10: encoding: [0x05,0x00,0x41,0xd5,0x01,0x05,0x06,0x03]

v_mad_f32 v5, v1, v2, 0.5
// GFX10: encoding: [0x05,0x00,0x41,0xd5,0x01,0x05,0xc2,0x03]

v_mad_f32 v5, v1, v2, -4.0
// GFX10: encoding: [0x05,0x00,0x41,0xd5,0x01,0x05,0xde,0x03]

v_mad_f32 v5, -v1, v2, v3
// GFX10: encoding: [0x05,0x00,0x41,0xd5,0x01,0x05,0x0e,0x24]

v_mad_f32 v5, v1, -v2, v3
// GFX10: encoding: [0x05,0x00,0x41,0xd5,0x01,0x05,0x0e,0x44]

v_mad_f32 v5, v1, v2, -v3
// GFX10: encoding: [0x05,0x00,0x41,0xd5,0x01,0x05,0x0e,0x84]

v_mad_f32 v5, -v1, -v2, -v3
// GFX10: encoding: [0x05,0x00,0x41,0xd5,0x01,0x05,0x0e,0xe4]

v_mad_f32 v5, |v1|, v2, v3
// GFX10: encoding: [0x05,0x01,0x41,0xd5,0x01,0x05,0x0e,0x04]

v_mad_f32 v5, v1, |v2|, v3
// GFX10: encoding: [0x05,0x02,0x41,0xd5,0x01,0x05,0x0e,0x04]

v_mad_f32 v5, v1, v2, |v3|
// GFX10: encoding: [0x05,0x04,0x41,0xd5,0x01,0x05,0x0e,0x04]

v_mad_f32 v5, |v1|, |v2|, |v3|
// GFX10: encoding: [0x05,0x07,0x41,0xd5,0x01,0x05,0x0e,0x04]

v_mad_f32 v5, v1, v2, v3 clamp
// GFX10: encoding: [0x05,0x80,0x41,0xd5,0x01,0x05,0x0e,0x04]

v_mad_f32 v5, v1, v2, v3 mul:2
// GFX10: encoding: [0x05,0x00,0x41,0xd5,0x01,0x05,0x0e,0x0c]

v_mad_f32 v5, v1, v2, v3 mul:4
// GFX10: encoding: [0x05,0x00,0x41,0xd5,0x01,0x05,0x0e,0x14]

v_mad_f32 v5, v1, v2, v3 div:2
// GFX10: encoding: [0x05,0x00,0x41,0xd5,0x01,0x05,0x0e,0x1c]

v_mad_i32_i24 v5, v1, v2, v3
// GFX10: encoding: [0x05,0x00,0x42,0xd5,0x01,0x05,0x0e,0x04]

v_mad_i32_i24 v255, v1, v2, v3
// GFX10: encoding: [0xff,0x00,0x42,0xd5,0x01,0x05,0x0e,0x04]

v_mad_i32_i24 v5, v255, v2, v3
// GFX10: encoding: [0x05,0x00,0x42,0xd5,0xff,0x05,0x0e,0x04]

v_mad_i32_i24 v5, s1, v2, v3
// GFX10: encoding: [0x05,0x00,0x42,0xd5,0x01,0x04,0x0e,0x04]

v_mad_i32_i24 v5, s103, v2, v3
// GFX10: encoding: [0x05,0x00,0x42,0xd5,0x67,0x04,0x0e,0x04]

v_mad_i32_i24 v5, vcc_lo, v2, v3
// GFX10: encoding: [0x05,0x00,0x42,0xd5,0x6a,0x04,0x0e,0x04]

v_mad_i32_i24 v5, vcc_hi, v2, v3
// GFX10: encoding: [0x05,0x00,0x42,0xd5,0x6b,0x04,0x0e,0x04]

v_mad_i32_i24 v5, ttmp11, v2, v3
// GFX10: encoding: [0x05,0x00,0x42,0xd5,0x77,0x04,0x0e,0x04]

v_mad_i32_i24 v5, m0, v2, v3
// GFX10: encoding: [0x05,0x00,0x42,0xd5,0x7c,0x04,0x0e,0x04]

v_mad_i32_i24 v5, exec_lo, v2, v3
// GFX10: encoding: [0x05,0x00,0x42,0xd5,0x7e,0x04,0x0e,0x04]

v_mad_i32_i24 v5, exec_hi, v2, v3
// GFX10: encoding: [0x05,0x00,0x42,0xd5,0x7f,0x04,0x0e,0x04]

v_mad_i32_i24 v5, 0, v2, v3
// GFX10: encoding: [0x05,0x00,0x42,0xd5,0x80,0x04,0x0e,0x04]

v_mad_i32_i24 v5, -1, v2, v3
// GFX10: encoding: [0x05,0x00,0x42,0xd5,0xc1,0x04,0x0e,0x04]

v_mad_i32_i24 v5, 0.5, v2, v3
// GFX10: encoding: [0x05,0x00,0x42,0xd5,0xf0,0x04,0x0e,0x04]

v_mad_i32_i24 v5, -4.0, v2, v3
// GFX10: encoding: [0x05,0x00,0x42,0xd5,0xf7,0x04,0x0e,0x04]

v_mad_i32_i24 v5, v1, v255, v3
// GFX10: encoding: [0x05,0x00,0x42,0xd5,0x01,0xff,0x0f,0x04]

v_mad_i32_i24 v5, v1, s2, v3
// GFX10: encoding: [0x05,0x00,0x42,0xd5,0x01,0x05,0x0c,0x04]

v_mad_i32_i24 v5, v1, s103, v3
// GFX10: encoding: [0x05,0x00,0x42,0xd5,0x01,0xcf,0x0c,0x04]

v_mad_i32_i24 v5, v1, vcc_lo, v3
// GFX10: encoding: [0x05,0x00,0x42,0xd5,0x01,0xd5,0x0c,0x04]

v_mad_i32_i24 v5, v1, vcc_hi, v3
// GFX10: encoding: [0x05,0x00,0x42,0xd5,0x01,0xd7,0x0c,0x04]

v_mad_i32_i24 v5, v1, ttmp11, v3
// GFX10: encoding: [0x05,0x00,0x42,0xd5,0x01,0xef,0x0c,0x04]

v_mad_i32_i24 v5, v1, m0, v3
// GFX10: encoding: [0x05,0x00,0x42,0xd5,0x01,0xf9,0x0c,0x04]

v_mad_i32_i24 v5, v1, exec_lo, v3
// GFX10: encoding: [0x05,0x00,0x42,0xd5,0x01,0xfd,0x0c,0x04]

v_mad_i32_i24 v5, v1, exec_hi, v3
// GFX10: encoding: [0x05,0x00,0x42,0xd5,0x01,0xff,0x0c,0x04]

v_mad_i32_i24 v5, v1, 0, v3
// GFX10: encoding: [0x05,0x00,0x42,0xd5,0x01,0x01,0x0d,0x04]

v_mad_i32_i24 v5, v1, -1, v3
// GFX10: encoding: [0x05,0x00,0x42,0xd5,0x01,0x83,0x0d,0x04]

v_mad_i32_i24 v5, v1, 0.5, v3
// GFX10: encoding: [0x05,0x00,0x42,0xd5,0x01,0xe1,0x0d,0x04]

v_mad_i32_i24 v5, v1, -4.0, v3
// GFX10: encoding: [0x05,0x00,0x42,0xd5,0x01,0xef,0x0d,0x04]

v_mad_i32_i24 v5, v1, v2, v255
// GFX10: encoding: [0x05,0x00,0x42,0xd5,0x01,0x05,0xfe,0x07]

v_mad_i32_i24 v5, v1, v2, s3
// GFX10: encoding: [0x05,0x00,0x42,0xd5,0x01,0x05,0x0e,0x00]

v_mad_i32_i24 v5, v1, v2, s103
// GFX10: encoding: [0x05,0x00,0x42,0xd5,0x01,0x05,0x9e,0x01]

v_mad_i32_i24 v5, v1, v2, vcc_lo
// GFX10: encoding: [0x05,0x00,0x42,0xd5,0x01,0x05,0xaa,0x01]

v_mad_i32_i24 v5, v1, v2, vcc_hi
// GFX10: encoding: [0x05,0x00,0x42,0xd5,0x01,0x05,0xae,0x01]

v_mad_i32_i24 v5, v1, v2, ttmp11
// GFX10: encoding: [0x05,0x00,0x42,0xd5,0x01,0x05,0xde,0x01]

v_mad_i32_i24 v5, v1, v2, m0
// GFX10: encoding: [0x05,0x00,0x42,0xd5,0x01,0x05,0xf2,0x01]

v_mad_i32_i24 v5, v1, v2, exec_lo
// GFX10: encoding: [0x05,0x00,0x42,0xd5,0x01,0x05,0xfa,0x01]

v_mad_i32_i24 v5, v1, v2, exec_hi
// GFX10: encoding: [0x05,0x00,0x42,0xd5,0x01,0x05,0xfe,0x01]

v_mad_i32_i24 v5, v1, v2, 0
// GFX10: encoding: [0x05,0x00,0x42,0xd5,0x01,0x05,0x02,0x02]

v_mad_i32_i24 v5, v1, v2, -1
// GFX10: encoding: [0x05,0x00,0x42,0xd5,0x01,0x05,0x06,0x03]

v_mad_i32_i24 v5, v1, v2, 0.5
// GFX10: encoding: [0x05,0x00,0x42,0xd5,0x01,0x05,0xc2,0x03]

v_mad_i32_i24 v5, v1, v2, -4.0
// GFX10: encoding: [0x05,0x00,0x42,0xd5,0x01,0x05,0xde,0x03]

v_mad_u32_u24 v5, v1, v2, v3
// GFX10: encoding: [0x05,0x00,0x43,0xd5,0x01,0x05,0x0e,0x04]

v_mad_u32_u24 v255, v1, v2, v3
// GFX10: encoding: [0xff,0x00,0x43,0xd5,0x01,0x05,0x0e,0x04]

v_mad_u32_u24 v5, v255, v2, v3
// GFX10: encoding: [0x05,0x00,0x43,0xd5,0xff,0x05,0x0e,0x04]

v_mad_u32_u24 v5, s1, v2, v3
// GFX10: encoding: [0x05,0x00,0x43,0xd5,0x01,0x04,0x0e,0x04]

v_mad_u32_u24 v5, s103, v2, v3
// GFX10: encoding: [0x05,0x00,0x43,0xd5,0x67,0x04,0x0e,0x04]

v_mad_u32_u24 v5, vcc_lo, v2, v3
// GFX10: encoding: [0x05,0x00,0x43,0xd5,0x6a,0x04,0x0e,0x04]

v_mad_u32_u24 v5, vcc_hi, v2, v3
// GFX10: encoding: [0x05,0x00,0x43,0xd5,0x6b,0x04,0x0e,0x04]

v_mad_u32_u24 v5, ttmp11, v2, v3
// GFX10: encoding: [0x05,0x00,0x43,0xd5,0x77,0x04,0x0e,0x04]

v_mad_u32_u24 v5, m0, v2, v3
// GFX10: encoding: [0x05,0x00,0x43,0xd5,0x7c,0x04,0x0e,0x04]

v_mad_u32_u24 v5, exec_lo, v2, v3
// GFX10: encoding: [0x05,0x00,0x43,0xd5,0x7e,0x04,0x0e,0x04]

v_mad_u32_u24 v5, exec_hi, v2, v3
// GFX10: encoding: [0x05,0x00,0x43,0xd5,0x7f,0x04,0x0e,0x04]

v_mad_u32_u24 v5, 0, v2, v3
// GFX10: encoding: [0x05,0x00,0x43,0xd5,0x80,0x04,0x0e,0x04]

v_mad_u32_u24 v5, -1, v2, v3
// GFX10: encoding: [0x05,0x00,0x43,0xd5,0xc1,0x04,0x0e,0x04]

v_mad_u32_u24 v5, 0.5, v2, v3
// GFX10: encoding: [0x05,0x00,0x43,0xd5,0xf0,0x04,0x0e,0x04]

v_mad_u32_u24 v5, -4.0, v2, v3
// GFX10: encoding: [0x05,0x00,0x43,0xd5,0xf7,0x04,0x0e,0x04]

v_mad_u32_u24 v5, v1, v255, v3
// GFX10: encoding: [0x05,0x00,0x43,0xd5,0x01,0xff,0x0f,0x04]

v_mad_u32_u24 v5, v1, s2, v3
// GFX10: encoding: [0x05,0x00,0x43,0xd5,0x01,0x05,0x0c,0x04]

v_mad_u32_u24 v5, v1, s103, v3
// GFX10: encoding: [0x05,0x00,0x43,0xd5,0x01,0xcf,0x0c,0x04]

v_mad_u32_u24 v5, v1, vcc_lo, v3
// GFX10: encoding: [0x05,0x00,0x43,0xd5,0x01,0xd5,0x0c,0x04]

v_mad_u32_u24 v5, v1, vcc_hi, v3
// GFX10: encoding: [0x05,0x00,0x43,0xd5,0x01,0xd7,0x0c,0x04]

v_mad_u32_u24 v5, v1, ttmp11, v3
// GFX10: encoding: [0x05,0x00,0x43,0xd5,0x01,0xef,0x0c,0x04]

v_mad_u32_u24 v5, v1, m0, v3
// GFX10: encoding: [0x05,0x00,0x43,0xd5,0x01,0xf9,0x0c,0x04]

v_mad_u32_u24 v5, v1, exec_lo, v3
// GFX10: encoding: [0x05,0x00,0x43,0xd5,0x01,0xfd,0x0c,0x04]

v_mad_u32_u24 v5, v1, exec_hi, v3
// GFX10: encoding: [0x05,0x00,0x43,0xd5,0x01,0xff,0x0c,0x04]

v_mad_u32_u24 v5, v1, 0, v3
// GFX10: encoding: [0x05,0x00,0x43,0xd5,0x01,0x01,0x0d,0x04]

v_mad_u32_u24 v5, v1, -1, v3
// GFX10: encoding: [0x05,0x00,0x43,0xd5,0x01,0x83,0x0d,0x04]

v_mad_u32_u24 v5, v1, 0.5, v3
// GFX10: encoding: [0x05,0x00,0x43,0xd5,0x01,0xe1,0x0d,0x04]

v_mad_u32_u24 v5, v1, -4.0, v3
// GFX10: encoding: [0x05,0x00,0x43,0xd5,0x01,0xef,0x0d,0x04]

v_mad_u32_u24 v5, v1, v2, v255
// GFX10: encoding: [0x05,0x00,0x43,0xd5,0x01,0x05,0xfe,0x07]

v_mad_u32_u24 v5, v1, v2, s3
// GFX10: encoding: [0x05,0x00,0x43,0xd5,0x01,0x05,0x0e,0x00]

v_mad_u32_u24 v5, v1, v2, s103
// GFX10: encoding: [0x05,0x00,0x43,0xd5,0x01,0x05,0x9e,0x01]

v_mad_u32_u24 v5, v1, v2, vcc_lo
// GFX10: encoding: [0x05,0x00,0x43,0xd5,0x01,0x05,0xaa,0x01]

v_mad_u32_u24 v5, v1, v2, vcc_hi
// GFX10: encoding: [0x05,0x00,0x43,0xd5,0x01,0x05,0xae,0x01]

v_mad_u32_u24 v5, v1, v2, ttmp11
// GFX10: encoding: [0x05,0x00,0x43,0xd5,0x01,0x05,0xde,0x01]

v_mad_u32_u24 v5, v1, v2, m0
// GFX10: encoding: [0x05,0x00,0x43,0xd5,0x01,0x05,0xf2,0x01]

v_mad_u32_u24 v5, v1, v2, exec_lo
// GFX10: encoding: [0x05,0x00,0x43,0xd5,0x01,0x05,0xfa,0x01]

v_mad_u32_u24 v5, v1, v2, exec_hi
// GFX10: encoding: [0x05,0x00,0x43,0xd5,0x01,0x05,0xfe,0x01]

v_mad_u32_u24 v5, v1, v2, 0
// GFX10: encoding: [0x05,0x00,0x43,0xd5,0x01,0x05,0x02,0x02]

v_mad_u32_u24 v5, v1, v2, -1
// GFX10: encoding: [0x05,0x00,0x43,0xd5,0x01,0x05,0x06,0x03]

v_mad_u32_u24 v5, v1, v2, 0.5
// GFX10: encoding: [0x05,0x00,0x43,0xd5,0x01,0x05,0xc2,0x03]

v_mad_u32_u24 v5, v1, v2, -4.0
// GFX10: encoding: [0x05,0x00,0x43,0xd5,0x01,0x05,0xde,0x03]

v_cubeid_f32 v5, v1, v2, v3
// GFX10: encoding: [0x05,0x00,0x44,0xd5,0x01,0x05,0x0e,0x04]

v_cubeid_f32 v255, v1, v2, v3
// GFX10: encoding: [0xff,0x00,0x44,0xd5,0x01,0x05,0x0e,0x04]

v_cubeid_f32 v5, v255, v2, v3
// GFX10: encoding: [0x05,0x00,0x44,0xd5,0xff,0x05,0x0e,0x04]

v_cubeid_f32 v5, s1, v2, v3
// GFX10: encoding: [0x05,0x00,0x44,0xd5,0x01,0x04,0x0e,0x04]

v_cubeid_f32 v5, s103, v2, v3
// GFX10: encoding: [0x05,0x00,0x44,0xd5,0x67,0x04,0x0e,0x04]

v_cubeid_f32 v5, vcc_lo, v2, v3
// GFX10: encoding: [0x05,0x00,0x44,0xd5,0x6a,0x04,0x0e,0x04]

v_cubeid_f32 v5, vcc_hi, v2, v3
// GFX10: encoding: [0x05,0x00,0x44,0xd5,0x6b,0x04,0x0e,0x04]

v_cubeid_f32 v5, ttmp11, v2, v3
// GFX10: encoding: [0x05,0x00,0x44,0xd5,0x77,0x04,0x0e,0x04]

v_cubeid_f32 v5, m0, v2, v3
// GFX10: encoding: [0x05,0x00,0x44,0xd5,0x7c,0x04,0x0e,0x04]

v_cubeid_f32 v5, exec_lo, v2, v3
// GFX10: encoding: [0x05,0x00,0x44,0xd5,0x7e,0x04,0x0e,0x04]

v_cubeid_f32 v5, exec_hi, v2, v3
// GFX10: encoding: [0x05,0x00,0x44,0xd5,0x7f,0x04,0x0e,0x04]

v_cubeid_f32 v5, 0, v2, v3
// GFX10: encoding: [0x05,0x00,0x44,0xd5,0x80,0x04,0x0e,0x04]

v_cubeid_f32 v5, -1, v2, v3
// GFX10: encoding: [0x05,0x00,0x44,0xd5,0xc1,0x04,0x0e,0x04]

v_cubeid_f32 v5, 0.5, v2, v3
// GFX10: encoding: [0x05,0x00,0x44,0xd5,0xf0,0x04,0x0e,0x04]

v_cubeid_f32 v5, -4.0, v2, v3
// GFX10: encoding: [0x05,0x00,0x44,0xd5,0xf7,0x04,0x0e,0x04]

v_cubeid_f32 v5, v1, v255, v3
// GFX10: encoding: [0x05,0x00,0x44,0xd5,0x01,0xff,0x0f,0x04]

v_cubeid_f32 v5, v1, s2, v3
// GFX10: encoding: [0x05,0x00,0x44,0xd5,0x01,0x05,0x0c,0x04]

v_cubeid_f32 v5, v1, s103, v3
// GFX10: encoding: [0x05,0x00,0x44,0xd5,0x01,0xcf,0x0c,0x04]

v_cubeid_f32 v5, v1, vcc_lo, v3
// GFX10: encoding: [0x05,0x00,0x44,0xd5,0x01,0xd5,0x0c,0x04]

v_cubeid_f32 v5, v1, vcc_hi, v3
// GFX10: encoding: [0x05,0x00,0x44,0xd5,0x01,0xd7,0x0c,0x04]

v_cubeid_f32 v5, v1, ttmp11, v3
// GFX10: encoding: [0x05,0x00,0x44,0xd5,0x01,0xef,0x0c,0x04]

v_cubeid_f32 v5, v1, m0, v3
// GFX10: encoding: [0x05,0x00,0x44,0xd5,0x01,0xf9,0x0c,0x04]

v_cubeid_f32 v5, v1, exec_lo, v3
// GFX10: encoding: [0x05,0x00,0x44,0xd5,0x01,0xfd,0x0c,0x04]

v_cubeid_f32 v5, v1, exec_hi, v3
// GFX10: encoding: [0x05,0x00,0x44,0xd5,0x01,0xff,0x0c,0x04]

v_cubeid_f32 v5, v1, 0, v3
// GFX10: encoding: [0x05,0x00,0x44,0xd5,0x01,0x01,0x0d,0x04]

v_cubeid_f32 v5, v1, -1, v3
// GFX10: encoding: [0x05,0x00,0x44,0xd5,0x01,0x83,0x0d,0x04]

v_cubeid_f32 v5, v1, 0.5, v3
// GFX10: encoding: [0x05,0x00,0x44,0xd5,0x01,0xe1,0x0d,0x04]

v_cubeid_f32 v5, v1, -4.0, v3
// GFX10: encoding: [0x05,0x00,0x44,0xd5,0x01,0xef,0x0d,0x04]

v_cubeid_f32 v5, v1, v2, v255
// GFX10: encoding: [0x05,0x00,0x44,0xd5,0x01,0x05,0xfe,0x07]

v_cubeid_f32 v5, v1, v2, s3
// GFX10: encoding: [0x05,0x00,0x44,0xd5,0x01,0x05,0x0e,0x00]

v_cubeid_f32 v5, v1, v2, s103
// GFX10: encoding: [0x05,0x00,0x44,0xd5,0x01,0x05,0x9e,0x01]

v_cubeid_f32 v5, v1, v2, vcc_lo
// GFX10: encoding: [0x05,0x00,0x44,0xd5,0x01,0x05,0xaa,0x01]

v_cubeid_f32 v5, v1, v2, vcc_hi
// GFX10: encoding: [0x05,0x00,0x44,0xd5,0x01,0x05,0xae,0x01]

v_cubeid_f32 v5, v1, v2, ttmp11
// GFX10: encoding: [0x05,0x00,0x44,0xd5,0x01,0x05,0xde,0x01]

v_cubeid_f32 v5, v1, v2, m0
// GFX10: encoding: [0x05,0x00,0x44,0xd5,0x01,0x05,0xf2,0x01]

v_cubeid_f32 v5, v1, v2, exec_lo
// GFX10: encoding: [0x05,0x00,0x44,0xd5,0x01,0x05,0xfa,0x01]

v_cubeid_f32 v5, v1, v2, exec_hi
// GFX10: encoding: [0x05,0x00,0x44,0xd5,0x01,0x05,0xfe,0x01]

v_cubeid_f32 v5, v1, v2, 0
// GFX10: encoding: [0x05,0x00,0x44,0xd5,0x01,0x05,0x02,0x02]

v_cubeid_f32 v5, v1, v2, -1
// GFX10: encoding: [0x05,0x00,0x44,0xd5,0x01,0x05,0x06,0x03]

v_cubeid_f32 v5, v1, v2, 0.5
// GFX10: encoding: [0x05,0x00,0x44,0xd5,0x01,0x05,0xc2,0x03]

v_cubeid_f32 v5, v1, v2, -4.0
// GFX10: encoding: [0x05,0x00,0x44,0xd5,0x01,0x05,0xde,0x03]

v_cubeid_f32 v5, -v1, v2, v3
// GFX10: encoding: [0x05,0x00,0x44,0xd5,0x01,0x05,0x0e,0x24]

v_cubeid_f32 v5, v1, -v2, v3
// GFX10: encoding: [0x05,0x00,0x44,0xd5,0x01,0x05,0x0e,0x44]

v_cubeid_f32 v5, v1, v2, -v3
// GFX10: encoding: [0x05,0x00,0x44,0xd5,0x01,0x05,0x0e,0x84]

v_cubeid_f32 v5, -v1, -v2, -v3
// GFX10: encoding: [0x05,0x00,0x44,0xd5,0x01,0x05,0x0e,0xe4]

v_cubeid_f32 v5, |v1|, v2, v3
// GFX10: encoding: [0x05,0x01,0x44,0xd5,0x01,0x05,0x0e,0x04]

v_cubeid_f32 v5, v1, |v2|, v3
// GFX10: encoding: [0x05,0x02,0x44,0xd5,0x01,0x05,0x0e,0x04]

v_cubeid_f32 v5, v1, v2, |v3|
// GFX10: encoding: [0x05,0x04,0x44,0xd5,0x01,0x05,0x0e,0x04]

v_cubeid_f32 v5, |v1|, |v2|, |v3|
// GFX10: encoding: [0x05,0x07,0x44,0xd5,0x01,0x05,0x0e,0x04]

v_cubeid_f32 v5, v1, v2, v3 clamp
// GFX10: encoding: [0x05,0x80,0x44,0xd5,0x01,0x05,0x0e,0x04]

v_cubeid_f32 v5, v1, v2, v3 mul:2
// GFX10: encoding: [0x05,0x00,0x44,0xd5,0x01,0x05,0x0e,0x0c]

v_cubeid_f32 v5, v1, v2, v3 mul:4
// GFX10: encoding: [0x05,0x00,0x44,0xd5,0x01,0x05,0x0e,0x14]

v_cubeid_f32 v5, v1, v2, v3 div:2
// GFX10: encoding: [0x05,0x00,0x44,0xd5,0x01,0x05,0x0e,0x1c]

v_cubesc_f32 v5, v1, v2, v3
// GFX10: encoding: [0x05,0x00,0x45,0xd5,0x01,0x05,0x0e,0x04]

v_cubesc_f32 v255, v1, v2, v3
// GFX10: encoding: [0xff,0x00,0x45,0xd5,0x01,0x05,0x0e,0x04]

v_cubesc_f32 v5, v255, v2, v3
// GFX10: encoding: [0x05,0x00,0x45,0xd5,0xff,0x05,0x0e,0x04]

v_cubesc_f32 v5, s1, v2, v3
// GFX10: encoding: [0x05,0x00,0x45,0xd5,0x01,0x04,0x0e,0x04]

v_cubesc_f32 v5, s103, v2, v3
// GFX10: encoding: [0x05,0x00,0x45,0xd5,0x67,0x04,0x0e,0x04]

v_cubesc_f32 v5, vcc_lo, v2, v3
// GFX10: encoding: [0x05,0x00,0x45,0xd5,0x6a,0x04,0x0e,0x04]

v_cubesc_f32 v5, vcc_hi, v2, v3
// GFX10: encoding: [0x05,0x00,0x45,0xd5,0x6b,0x04,0x0e,0x04]

v_cubesc_f32 v5, ttmp11, v2, v3
// GFX10: encoding: [0x05,0x00,0x45,0xd5,0x77,0x04,0x0e,0x04]

v_cubesc_f32 v5, m0, v2, v3
// GFX10: encoding: [0x05,0x00,0x45,0xd5,0x7c,0x04,0x0e,0x04]

v_cubesc_f32 v5, exec_lo, v2, v3
// GFX10: encoding: [0x05,0x00,0x45,0xd5,0x7e,0x04,0x0e,0x04]

v_cubesc_f32 v5, exec_hi, v2, v3
// GFX10: encoding: [0x05,0x00,0x45,0xd5,0x7f,0x04,0x0e,0x04]

v_cubesc_f32 v5, 0, v2, v3
// GFX10: encoding: [0x05,0x00,0x45,0xd5,0x80,0x04,0x0e,0x04]

v_cubesc_f32 v5, -1, v2, v3
// GFX10: encoding: [0x05,0x00,0x45,0xd5,0xc1,0x04,0x0e,0x04]

v_cubesc_f32 v5, 0.5, v2, v3
// GFX10: encoding: [0x05,0x00,0x45,0xd5,0xf0,0x04,0x0e,0x04]

v_cubesc_f32 v5, -4.0, v2, v3
// GFX10: encoding: [0x05,0x00,0x45,0xd5,0xf7,0x04,0x0e,0x04]

v_cubesc_f32 v5, v1, v255, v3
// GFX10: encoding: [0x05,0x00,0x45,0xd5,0x01,0xff,0x0f,0x04]

v_cubesc_f32 v5, v1, s2, v3
// GFX10: encoding: [0x05,0x00,0x45,0xd5,0x01,0x05,0x0c,0x04]

v_cubesc_f32 v5, v1, s103, v3
// GFX10: encoding: [0x05,0x00,0x45,0xd5,0x01,0xcf,0x0c,0x04]

v_cubesc_f32 v5, v1, vcc_lo, v3
// GFX10: encoding: [0x05,0x00,0x45,0xd5,0x01,0xd5,0x0c,0x04]

v_cubesc_f32 v5, v1, vcc_hi, v3
// GFX10: encoding: [0x05,0x00,0x45,0xd5,0x01,0xd7,0x0c,0x04]

v_cubesc_f32 v5, v1, ttmp11, v3
// GFX10: encoding: [0x05,0x00,0x45,0xd5,0x01,0xef,0x0c,0x04]

v_cubesc_f32 v5, v1, m0, v3
// GFX10: encoding: [0x05,0x00,0x45,0xd5,0x01,0xf9,0x0c,0x04]

v_cubesc_f32 v5, v1, exec_lo, v3
// GFX10: encoding: [0x05,0x00,0x45,0xd5,0x01,0xfd,0x0c,0x04]

v_cubesc_f32 v5, v1, exec_hi, v3
// GFX10: encoding: [0x05,0x00,0x45,0xd5,0x01,0xff,0x0c,0x04]

v_cubesc_f32 v5, v1, 0, v3
// GFX10: encoding: [0x05,0x00,0x45,0xd5,0x01,0x01,0x0d,0x04]

v_cubesc_f32 v5, v1, -1, v3
// GFX10: encoding: [0x05,0x00,0x45,0xd5,0x01,0x83,0x0d,0x04]

v_cubesc_f32 v5, v1, 0.5, v3
// GFX10: encoding: [0x05,0x00,0x45,0xd5,0x01,0xe1,0x0d,0x04]

v_cubesc_f32 v5, v1, -4.0, v3
// GFX10: encoding: [0x05,0x00,0x45,0xd5,0x01,0xef,0x0d,0x04]

v_cubesc_f32 v5, v1, v2, v255
// GFX10: encoding: [0x05,0x00,0x45,0xd5,0x01,0x05,0xfe,0x07]

v_cubesc_f32 v5, v1, v2, s3
// GFX10: encoding: [0x05,0x00,0x45,0xd5,0x01,0x05,0x0e,0x00]

v_cubesc_f32 v5, v1, v2, s103
// GFX10: encoding: [0x05,0x00,0x45,0xd5,0x01,0x05,0x9e,0x01]

v_cubesc_f32 v5, v1, v2, vcc_lo
// GFX10: encoding: [0x05,0x00,0x45,0xd5,0x01,0x05,0xaa,0x01]

v_cubesc_f32 v5, v1, v2, vcc_hi
// GFX10: encoding: [0x05,0x00,0x45,0xd5,0x01,0x05,0xae,0x01]

v_cubesc_f32 v5, v1, v2, ttmp11
// GFX10: encoding: [0x05,0x00,0x45,0xd5,0x01,0x05,0xde,0x01]

v_cubesc_f32 v5, v1, v2, m0
// GFX10: encoding: [0x05,0x00,0x45,0xd5,0x01,0x05,0xf2,0x01]

v_cubesc_f32 v5, v1, v2, exec_lo
// GFX10: encoding: [0x05,0x00,0x45,0xd5,0x01,0x05,0xfa,0x01]

v_cubesc_f32 v5, v1, v2, exec_hi
// GFX10: encoding: [0x05,0x00,0x45,0xd5,0x01,0x05,0xfe,0x01]

v_cubesc_f32 v5, v1, v2, 0
// GFX10: encoding: [0x05,0x00,0x45,0xd5,0x01,0x05,0x02,0x02]

v_cubesc_f32 v5, v1, v2, -1
// GFX10: encoding: [0x05,0x00,0x45,0xd5,0x01,0x05,0x06,0x03]

v_cubesc_f32 v5, v1, v2, 0.5
// GFX10: encoding: [0x05,0x00,0x45,0xd5,0x01,0x05,0xc2,0x03]

v_cubesc_f32 v5, v1, v2, -4.0
// GFX10: encoding: [0x05,0x00,0x45,0xd5,0x01,0x05,0xde,0x03]

v_cubesc_f32 v5, -v1, v2, v3
// GFX10: encoding: [0x05,0x00,0x45,0xd5,0x01,0x05,0x0e,0x24]

v_cubesc_f32 v5, v1, -v2, v3
// GFX10: encoding: [0x05,0x00,0x45,0xd5,0x01,0x05,0x0e,0x44]

v_cubesc_f32 v5, v1, v2, -v3
// GFX10: encoding: [0x05,0x00,0x45,0xd5,0x01,0x05,0x0e,0x84]

v_cubesc_f32 v5, -v1, -v2, -v3
// GFX10: encoding: [0x05,0x00,0x45,0xd5,0x01,0x05,0x0e,0xe4]

v_cubesc_f32 v5, |v1|, v2, v3
// GFX10: encoding: [0x05,0x01,0x45,0xd5,0x01,0x05,0x0e,0x04]

v_cubesc_f32 v5, v1, |v2|, v3
// GFX10: encoding: [0x05,0x02,0x45,0xd5,0x01,0x05,0x0e,0x04]

v_cubesc_f32 v5, v1, v2, |v3|
// GFX10: encoding: [0x05,0x04,0x45,0xd5,0x01,0x05,0x0e,0x04]

v_cubesc_f32 v5, |v1|, |v2|, |v3|
// GFX10: encoding: [0x05,0x07,0x45,0xd5,0x01,0x05,0x0e,0x04]

v_cubesc_f32 v5, v1, v2, v3 clamp
// GFX10: encoding: [0x05,0x80,0x45,0xd5,0x01,0x05,0x0e,0x04]

v_cubesc_f32 v5, v1, v2, v3 mul:2
// GFX10: encoding: [0x05,0x00,0x45,0xd5,0x01,0x05,0x0e,0x0c]

v_cubesc_f32 v5, v1, v2, v3 mul:4
// GFX10: encoding: [0x05,0x00,0x45,0xd5,0x01,0x05,0x0e,0x14]

v_cubesc_f32 v5, v1, v2, v3 div:2
// GFX10: encoding: [0x05,0x00,0x45,0xd5,0x01,0x05,0x0e,0x1c]

v_cubetc_f32 v5, v1, v2, v3
// GFX10: encoding: [0x05,0x00,0x46,0xd5,0x01,0x05,0x0e,0x04]

v_cubetc_f32 v255, v1, v2, v3
// GFX10: encoding: [0xff,0x00,0x46,0xd5,0x01,0x05,0x0e,0x04]

v_cubetc_f32 v5, v255, v2, v3
// GFX10: encoding: [0x05,0x00,0x46,0xd5,0xff,0x05,0x0e,0x04]

v_cubetc_f32 v5, s1, v2, v3
// GFX10: encoding: [0x05,0x00,0x46,0xd5,0x01,0x04,0x0e,0x04]

v_cubetc_f32 v5, s103, v2, v3
// GFX10: encoding: [0x05,0x00,0x46,0xd5,0x67,0x04,0x0e,0x04]

v_cubetc_f32 v5, vcc_lo, v2, v3
// GFX10: encoding: [0x05,0x00,0x46,0xd5,0x6a,0x04,0x0e,0x04]

v_cubetc_f32 v5, vcc_hi, v2, v3
// GFX10: encoding: [0x05,0x00,0x46,0xd5,0x6b,0x04,0x0e,0x04]

v_cubetc_f32 v5, ttmp11, v2, v3
// GFX10: encoding: [0x05,0x00,0x46,0xd5,0x77,0x04,0x0e,0x04]

v_cubetc_f32 v5, m0, v2, v3
// GFX10: encoding: [0x05,0x00,0x46,0xd5,0x7c,0x04,0x0e,0x04]

v_cubetc_f32 v5, exec_lo, v2, v3
// GFX10: encoding: [0x05,0x00,0x46,0xd5,0x7e,0x04,0x0e,0x04]

v_cubetc_f32 v5, exec_hi, v2, v3
// GFX10: encoding: [0x05,0x00,0x46,0xd5,0x7f,0x04,0x0e,0x04]

v_cubetc_f32 v5, 0, v2, v3
// GFX10: encoding: [0x05,0x00,0x46,0xd5,0x80,0x04,0x0e,0x04]

v_cubetc_f32 v5, -1, v2, v3
// GFX10: encoding: [0x05,0x00,0x46,0xd5,0xc1,0x04,0x0e,0x04]

v_cubetc_f32 v5, 0.5, v2, v3
// GFX10: encoding: [0x05,0x00,0x46,0xd5,0xf0,0x04,0x0e,0x04]

v_cubetc_f32 v5, -4.0, v2, v3
// GFX10: encoding: [0x05,0x00,0x46,0xd5,0xf7,0x04,0x0e,0x04]

v_cubetc_f32 v5, v1, v255, v3
// GFX10: encoding: [0x05,0x00,0x46,0xd5,0x01,0xff,0x0f,0x04]

v_cubetc_f32 v5, v1, s2, v3
// GFX10: encoding: [0x05,0x00,0x46,0xd5,0x01,0x05,0x0c,0x04]

v_cubetc_f32 v5, v1, s103, v3
// GFX10: encoding: [0x05,0x00,0x46,0xd5,0x01,0xcf,0x0c,0x04]

v_cubetc_f32 v5, v1, vcc_lo, v3
// GFX10: encoding: [0x05,0x00,0x46,0xd5,0x01,0xd5,0x0c,0x04]

v_cubetc_f32 v5, v1, vcc_hi, v3
// GFX10: encoding: [0x05,0x00,0x46,0xd5,0x01,0xd7,0x0c,0x04]

v_cubetc_f32 v5, v1, ttmp11, v3
// GFX10: encoding: [0x05,0x00,0x46,0xd5,0x01,0xef,0x0c,0x04]

v_cubetc_f32 v5, v1, m0, v3
// GFX10: encoding: [0x05,0x00,0x46,0xd5,0x01,0xf9,0x0c,0x04]

v_cubetc_f32 v5, v1, exec_lo, v3
// GFX10: encoding: [0x05,0x00,0x46,0xd5,0x01,0xfd,0x0c,0x04]

v_cubetc_f32 v5, v1, exec_hi, v3
// GFX10: encoding: [0x05,0x00,0x46,0xd5,0x01,0xff,0x0c,0x04]

v_cubetc_f32 v5, v1, 0, v3
// GFX10: encoding: [0x05,0x00,0x46,0xd5,0x01,0x01,0x0d,0x04]

v_cubetc_f32 v5, v1, -1, v3
// GFX10: encoding: [0x05,0x00,0x46,0xd5,0x01,0x83,0x0d,0x04]

v_cubetc_f32 v5, v1, 0.5, v3
// GFX10: encoding: [0x05,0x00,0x46,0xd5,0x01,0xe1,0x0d,0x04]

v_cubetc_f32 v5, v1, -4.0, v3
// GFX10: encoding: [0x05,0x00,0x46,0xd5,0x01,0xef,0x0d,0x04]

v_cubetc_f32 v5, v1, v2, v255
// GFX10: encoding: [0x05,0x00,0x46,0xd5,0x01,0x05,0xfe,0x07]

v_cubetc_f32 v5, v1, v2, s3
// GFX10: encoding: [0x05,0x00,0x46,0xd5,0x01,0x05,0x0e,0x00]

v_cubetc_f32 v5, v1, v2, s103
// GFX10: encoding: [0x05,0x00,0x46,0xd5,0x01,0x05,0x9e,0x01]

v_cubetc_f32 v5, v1, v2, vcc_lo
// GFX10: encoding: [0x05,0x00,0x46,0xd5,0x01,0x05,0xaa,0x01]

v_cubetc_f32 v5, v1, v2, vcc_hi
// GFX10: encoding: [0x05,0x00,0x46,0xd5,0x01,0x05,0xae,0x01]

v_cubetc_f32 v5, v1, v2, ttmp11
// GFX10: encoding: [0x05,0x00,0x46,0xd5,0x01,0x05,0xde,0x01]

v_cubetc_f32 v5, v1, v2, m0
// GFX10: encoding: [0x05,0x00,0x46,0xd5,0x01,0x05,0xf2,0x01]

v_cubetc_f32 v5, v1, v2, exec_lo
// GFX10: encoding: [0x05,0x00,0x46,0xd5,0x01,0x05,0xfa,0x01]

v_cubetc_f32 v5, v1, v2, exec_hi
// GFX10: encoding: [0x05,0x00,0x46,0xd5,0x01,0x05,0xfe,0x01]

v_cubetc_f32 v5, v1, v2, 0
// GFX10: encoding: [0x05,0x00,0x46,0xd5,0x01,0x05,0x02,0x02]

v_cubetc_f32 v5, v1, v2, -1
// GFX10: encoding: [0x05,0x00,0x46,0xd5,0x01,0x05,0x06,0x03]

v_cubetc_f32 v5, v1, v2, 0.5
// GFX10: encoding: [0x05,0x00,0x46,0xd5,0x01,0x05,0xc2,0x03]

v_cubetc_f32 v5, v1, v2, -4.0
// GFX10: encoding: [0x05,0x00,0x46,0xd5,0x01,0x05,0xde,0x03]

v_cubetc_f32 v5, -v1, v2, v3
// GFX10: encoding: [0x05,0x00,0x46,0xd5,0x01,0x05,0x0e,0x24]

v_cubetc_f32 v5, v1, -v2, v3
// GFX10: encoding: [0x05,0x00,0x46,0xd5,0x01,0x05,0x0e,0x44]

v_cubetc_f32 v5, v1, v2, -v3
// GFX10: encoding: [0x05,0x00,0x46,0xd5,0x01,0x05,0x0e,0x84]

v_cubetc_f32 v5, -v1, -v2, -v3
// GFX10: encoding: [0x05,0x00,0x46,0xd5,0x01,0x05,0x0e,0xe4]

v_cubetc_f32 v5, |v1|, v2, v3
// GFX10: encoding: [0x05,0x01,0x46,0xd5,0x01,0x05,0x0e,0x04]

v_cubetc_f32 v5, v1, |v2|, v3
// GFX10: encoding: [0x05,0x02,0x46,0xd5,0x01,0x05,0x0e,0x04]

v_cubetc_f32 v5, v1, v2, |v3|
// GFX10: encoding: [0x05,0x04,0x46,0xd5,0x01,0x05,0x0e,0x04]

v_cubetc_f32 v5, |v1|, |v2|, |v3|
// GFX10: encoding: [0x05,0x07,0x46,0xd5,0x01,0x05,0x0e,0x04]

v_cubetc_f32 v5, v1, v2, v3 clamp
// GFX10: encoding: [0x05,0x80,0x46,0xd5,0x01,0x05,0x0e,0x04]

v_cubetc_f32 v5, v1, v2, v3 mul:2
// GFX10: encoding: [0x05,0x00,0x46,0xd5,0x01,0x05,0x0e,0x0c]

v_cubetc_f32 v5, v1, v2, v3 mul:4
// GFX10: encoding: [0x05,0x00,0x46,0xd5,0x01,0x05,0x0e,0x14]

v_cubetc_f32 v5, v1, v2, v3 div:2
// GFX10: encoding: [0x05,0x00,0x46,0xd5,0x01,0x05,0x0e,0x1c]

v_cubema_f32 v5, v1, v2, v3
// GFX10: encoding: [0x05,0x00,0x47,0xd5,0x01,0x05,0x0e,0x04]

v_cubema_f32 v255, v1, v2, v3
// GFX10: encoding: [0xff,0x00,0x47,0xd5,0x01,0x05,0x0e,0x04]

v_cubema_f32 v5, v255, v2, v3
// GFX10: encoding: [0x05,0x00,0x47,0xd5,0xff,0x05,0x0e,0x04]

v_cubema_f32 v5, s1, v2, v3
// GFX10: encoding: [0x05,0x00,0x47,0xd5,0x01,0x04,0x0e,0x04]

v_cubema_f32 v5, s103, v2, v3
// GFX10: encoding: [0x05,0x00,0x47,0xd5,0x67,0x04,0x0e,0x04]

v_cubema_f32 v5, vcc_lo, v2, v3
// GFX10: encoding: [0x05,0x00,0x47,0xd5,0x6a,0x04,0x0e,0x04]

v_cubema_f32 v5, vcc_hi, v2, v3
// GFX10: encoding: [0x05,0x00,0x47,0xd5,0x6b,0x04,0x0e,0x04]

v_cubema_f32 v5, ttmp11, v2, v3
// GFX10: encoding: [0x05,0x00,0x47,0xd5,0x77,0x04,0x0e,0x04]

v_cubema_f32 v5, m0, v2, v3
// GFX10: encoding: [0x05,0x00,0x47,0xd5,0x7c,0x04,0x0e,0x04]

v_cubema_f32 v5, exec_lo, v2, v3
// GFX10: encoding: [0x05,0x00,0x47,0xd5,0x7e,0x04,0x0e,0x04]

v_cubema_f32 v5, exec_hi, v2, v3
// GFX10: encoding: [0x05,0x00,0x47,0xd5,0x7f,0x04,0x0e,0x04]

v_cubema_f32 v5, 0, v2, v3
// GFX10: encoding: [0x05,0x00,0x47,0xd5,0x80,0x04,0x0e,0x04]

v_cubema_f32 v5, -1, v2, v3
// GFX10: encoding: [0x05,0x00,0x47,0xd5,0xc1,0x04,0x0e,0x04]

v_cubema_f32 v5, 0.5, v2, v3
// GFX10: encoding: [0x05,0x00,0x47,0xd5,0xf0,0x04,0x0e,0x04]

v_cubema_f32 v5, -4.0, v2, v3
// GFX10: encoding: [0x05,0x00,0x47,0xd5,0xf7,0x04,0x0e,0x04]

v_cubema_f32 v5, v1, v255, v3
// GFX10: encoding: [0x05,0x00,0x47,0xd5,0x01,0xff,0x0f,0x04]

v_cubema_f32 v5, v1, s2, v3
// GFX10: encoding: [0x05,0x00,0x47,0xd5,0x01,0x05,0x0c,0x04]

v_cubema_f32 v5, v1, s103, v3
// GFX10: encoding: [0x05,0x00,0x47,0xd5,0x01,0xcf,0x0c,0x04]

v_cubema_f32 v5, v1, vcc_lo, v3
// GFX10: encoding: [0x05,0x00,0x47,0xd5,0x01,0xd5,0x0c,0x04]

v_cubema_f32 v5, v1, vcc_hi, v3
// GFX10: encoding: [0x05,0x00,0x47,0xd5,0x01,0xd7,0x0c,0x04]

v_cubema_f32 v5, v1, ttmp11, v3
// GFX10: encoding: [0x05,0x00,0x47,0xd5,0x01,0xef,0x0c,0x04]

v_cubema_f32 v5, v1, m0, v3
// GFX10: encoding: [0x05,0x00,0x47,0xd5,0x01,0xf9,0x0c,0x04]

v_cubema_f32 v5, v1, exec_lo, v3
// GFX10: encoding: [0x05,0x00,0x47,0xd5,0x01,0xfd,0x0c,0x04]

v_cubema_f32 v5, v1, exec_hi, v3
// GFX10: encoding: [0x05,0x00,0x47,0xd5,0x01,0xff,0x0c,0x04]

v_cubema_f32 v5, v1, 0, v3
// GFX10: encoding: [0x05,0x00,0x47,0xd5,0x01,0x01,0x0d,0x04]

v_cubema_f32 v5, v1, -1, v3
// GFX10: encoding: [0x05,0x00,0x47,0xd5,0x01,0x83,0x0d,0x04]

v_cubema_f32 v5, v1, 0.5, v3
// GFX10: encoding: [0x05,0x00,0x47,0xd5,0x01,0xe1,0x0d,0x04]

v_cubema_f32 v5, v1, -4.0, v3
// GFX10: encoding: [0x05,0x00,0x47,0xd5,0x01,0xef,0x0d,0x04]

v_cubema_f32 v5, v1, v2, v255
// GFX10: encoding: [0x05,0x00,0x47,0xd5,0x01,0x05,0xfe,0x07]

v_cubema_f32 v5, v1, v2, s3
// GFX10: encoding: [0x05,0x00,0x47,0xd5,0x01,0x05,0x0e,0x00]

v_cubema_f32 v5, v1, v2, s103
// GFX10: encoding: [0x05,0x00,0x47,0xd5,0x01,0x05,0x9e,0x01]

v_cubema_f32 v5, v1, v2, vcc_lo
// GFX10: encoding: [0x05,0x00,0x47,0xd5,0x01,0x05,0xaa,0x01]

v_cubema_f32 v5, v1, v2, vcc_hi
// GFX10: encoding: [0x05,0x00,0x47,0xd5,0x01,0x05,0xae,0x01]

v_cubema_f32 v5, v1, v2, ttmp11
// GFX10: encoding: [0x05,0x00,0x47,0xd5,0x01,0x05,0xde,0x01]

v_cubema_f32 v5, v1, v2, m0
// GFX10: encoding: [0x05,0x00,0x47,0xd5,0x01,0x05,0xf2,0x01]

v_cubema_f32 v5, v1, v2, exec_lo
// GFX10: encoding: [0x05,0x00,0x47,0xd5,0x01,0x05,0xfa,0x01]

v_cubema_f32 v5, v1, v2, exec_hi
// GFX10: encoding: [0x05,0x00,0x47,0xd5,0x01,0x05,0xfe,0x01]

v_cubema_f32 v5, v1, v2, 0
// GFX10: encoding: [0x05,0x00,0x47,0xd5,0x01,0x05,0x02,0x02]

v_cubema_f32 v5, v1, v2, -1
// GFX10: encoding: [0x05,0x00,0x47,0xd5,0x01,0x05,0x06,0x03]

v_cubema_f32 v5, v1, v2, 0.5
// GFX10: encoding: [0x05,0x00,0x47,0xd5,0x01,0x05,0xc2,0x03]

v_cubema_f32 v5, v1, v2, -4.0
// GFX10: encoding: [0x05,0x00,0x47,0xd5,0x01,0x05,0xde,0x03]

v_cubema_f32 v5, -v1, v2, v3
// GFX10: encoding: [0x05,0x00,0x47,0xd5,0x01,0x05,0x0e,0x24]

v_cubema_f32 v5, v1, -v2, v3
// GFX10: encoding: [0x05,0x00,0x47,0xd5,0x01,0x05,0x0e,0x44]

v_cubema_f32 v5, v1, v2, -v3
// GFX10: encoding: [0x05,0x00,0x47,0xd5,0x01,0x05,0x0e,0x84]

v_cubema_f32 v5, -v1, -v2, -v3
// GFX10: encoding: [0x05,0x00,0x47,0xd5,0x01,0x05,0x0e,0xe4]

v_cubema_f32 v5, |v1|, v2, v3
// GFX10: encoding: [0x05,0x01,0x47,0xd5,0x01,0x05,0x0e,0x04]

v_cubema_f32 v5, v1, |v2|, v3
// GFX10: encoding: [0x05,0x02,0x47,0xd5,0x01,0x05,0x0e,0x04]

v_cubema_f32 v5, v1, v2, |v3|
// GFX10: encoding: [0x05,0x04,0x47,0xd5,0x01,0x05,0x0e,0x04]

v_cubema_f32 v5, |v1|, |v2|, |v3|
// GFX10: encoding: [0x05,0x07,0x47,0xd5,0x01,0x05,0x0e,0x04]

v_cubema_f32 v5, v1, v2, v3 clamp
// GFX10: encoding: [0x05,0x80,0x47,0xd5,0x01,0x05,0x0e,0x04]

v_cubema_f32 v5, v1, v2, v3 mul:2
// GFX10: encoding: [0x05,0x00,0x47,0xd5,0x01,0x05,0x0e,0x0c]

v_cubema_f32 v5, v1, v2, v3 mul:4
// GFX10: encoding: [0x05,0x00,0x47,0xd5,0x01,0x05,0x0e,0x14]

v_cubema_f32 v5, v1, v2, v3 div:2
// GFX10: encoding: [0x05,0x00,0x47,0xd5,0x01,0x05,0x0e,0x1c]

v_bfe_u32 v5, v1, v2, v3
// GFX10: encoding: [0x05,0x00,0x48,0xd5,0x01,0x05,0x0e,0x04]

v_bfe_u32 v255, v1, v2, v3
// GFX10: encoding: [0xff,0x00,0x48,0xd5,0x01,0x05,0x0e,0x04]

v_bfe_u32 v5, v255, v2, v3
// GFX10: encoding: [0x05,0x00,0x48,0xd5,0xff,0x05,0x0e,0x04]

v_bfe_u32 v5, s1, v2, v3
// GFX10: encoding: [0x05,0x00,0x48,0xd5,0x01,0x04,0x0e,0x04]

v_bfe_u32 v5, s103, v2, v3
// GFX10: encoding: [0x05,0x00,0x48,0xd5,0x67,0x04,0x0e,0x04]

v_bfe_u32 v5, vcc_lo, v2, v3
// GFX10: encoding: [0x05,0x00,0x48,0xd5,0x6a,0x04,0x0e,0x04]

v_bfe_u32 v5, vcc_hi, v2, v3
// GFX10: encoding: [0x05,0x00,0x48,0xd5,0x6b,0x04,0x0e,0x04]

v_bfe_u32 v5, ttmp11, v2, v3
// GFX10: encoding: [0x05,0x00,0x48,0xd5,0x77,0x04,0x0e,0x04]

v_bfe_u32 v5, m0, v2, v3
// GFX10: encoding: [0x05,0x00,0x48,0xd5,0x7c,0x04,0x0e,0x04]

v_bfe_u32 v5, exec_lo, v2, v3
// GFX10: encoding: [0x05,0x00,0x48,0xd5,0x7e,0x04,0x0e,0x04]

v_bfe_u32 v5, exec_hi, v2, v3
// GFX10: encoding: [0x05,0x00,0x48,0xd5,0x7f,0x04,0x0e,0x04]

v_bfe_u32 v5, 0, v2, v3
// GFX10: encoding: [0x05,0x00,0x48,0xd5,0x80,0x04,0x0e,0x04]

v_bfe_u32 v5, -1, v2, v3
// GFX10: encoding: [0x05,0x00,0x48,0xd5,0xc1,0x04,0x0e,0x04]

v_bfe_u32 v5, 0.5, v2, v3
// GFX10: encoding: [0x05,0x00,0x48,0xd5,0xf0,0x04,0x0e,0x04]

v_bfe_u32 v5, -4.0, v2, v3
// GFX10: encoding: [0x05,0x00,0x48,0xd5,0xf7,0x04,0x0e,0x04]

v_bfe_u32 v5, v1, v255, v3
// GFX10: encoding: [0x05,0x00,0x48,0xd5,0x01,0xff,0x0f,0x04]

v_bfe_u32 v5, v1, s2, v3
// GFX10: encoding: [0x05,0x00,0x48,0xd5,0x01,0x05,0x0c,0x04]

v_bfe_u32 v5, v1, s103, v3
// GFX10: encoding: [0x05,0x00,0x48,0xd5,0x01,0xcf,0x0c,0x04]

v_bfe_u32 v5, v1, vcc_lo, v3
// GFX10: encoding: [0x05,0x00,0x48,0xd5,0x01,0xd5,0x0c,0x04]

v_bfe_u32 v5, v1, vcc_hi, v3
// GFX10: encoding: [0x05,0x00,0x48,0xd5,0x01,0xd7,0x0c,0x04]

v_bfe_u32 v5, v1, ttmp11, v3
// GFX10: encoding: [0x05,0x00,0x48,0xd5,0x01,0xef,0x0c,0x04]

v_bfe_u32 v5, v1, m0, v3
// GFX10: encoding: [0x05,0x00,0x48,0xd5,0x01,0xf9,0x0c,0x04]

v_bfe_u32 v5, v1, exec_lo, v3
// GFX10: encoding: [0x05,0x00,0x48,0xd5,0x01,0xfd,0x0c,0x04]

v_bfe_u32 v5, v1, exec_hi, v3
// GFX10: encoding: [0x05,0x00,0x48,0xd5,0x01,0xff,0x0c,0x04]

v_bfe_u32 v5, v1, 0, v3
// GFX10: encoding: [0x05,0x00,0x48,0xd5,0x01,0x01,0x0d,0x04]

v_bfe_u32 v5, v1, -1, v3
// GFX10: encoding: [0x05,0x00,0x48,0xd5,0x01,0x83,0x0d,0x04]

v_bfe_u32 v5, v1, 0.5, v3
// GFX10: encoding: [0x05,0x00,0x48,0xd5,0x01,0xe1,0x0d,0x04]

v_bfe_u32 v5, v1, -4.0, v3
// GFX10: encoding: [0x05,0x00,0x48,0xd5,0x01,0xef,0x0d,0x04]

v_bfe_u32 v5, v1, v2, v255
// GFX10: encoding: [0x05,0x00,0x48,0xd5,0x01,0x05,0xfe,0x07]

v_bfe_u32 v5, v1, v2, s3
// GFX10: encoding: [0x05,0x00,0x48,0xd5,0x01,0x05,0x0e,0x00]

v_bfe_u32 v5, v1, v2, s103
// GFX10: encoding: [0x05,0x00,0x48,0xd5,0x01,0x05,0x9e,0x01]

v_bfe_u32 v5, v1, v2, vcc_lo
// GFX10: encoding: [0x05,0x00,0x48,0xd5,0x01,0x05,0xaa,0x01]

v_bfe_u32 v5, v1, v2, vcc_hi
// GFX10: encoding: [0x05,0x00,0x48,0xd5,0x01,0x05,0xae,0x01]

v_bfe_u32 v5, v1, v2, ttmp11
// GFX10: encoding: [0x05,0x00,0x48,0xd5,0x01,0x05,0xde,0x01]

v_bfe_u32 v5, v1, v2, m0
// GFX10: encoding: [0x05,0x00,0x48,0xd5,0x01,0x05,0xf2,0x01]

v_bfe_u32 v5, v1, v2, exec_lo
// GFX10: encoding: [0x05,0x00,0x48,0xd5,0x01,0x05,0xfa,0x01]

v_bfe_u32 v5, v1, v2, exec_hi
// GFX10: encoding: [0x05,0x00,0x48,0xd5,0x01,0x05,0xfe,0x01]

v_bfe_u32 v5, v1, v2, 0
// GFX10: encoding: [0x05,0x00,0x48,0xd5,0x01,0x05,0x02,0x02]

v_bfe_u32 v5, v1, v2, -1
// GFX10: encoding: [0x05,0x00,0x48,0xd5,0x01,0x05,0x06,0x03]

v_bfe_u32 v5, v1, v2, 0.5
// GFX10: encoding: [0x05,0x00,0x48,0xd5,0x01,0x05,0xc2,0x03]

v_bfe_u32 v5, v1, v2, -4.0
// GFX10: encoding: [0x05,0x00,0x48,0xd5,0x01,0x05,0xde,0x03]

v_bfe_i32 v5, v1, v2, v3
// GFX10: encoding: [0x05,0x00,0x49,0xd5,0x01,0x05,0x0e,0x04]

v_bfe_i32 v255, v1, v2, v3
// GFX10: encoding: [0xff,0x00,0x49,0xd5,0x01,0x05,0x0e,0x04]

v_bfe_i32 v5, v255, v2, v3
// GFX10: encoding: [0x05,0x00,0x49,0xd5,0xff,0x05,0x0e,0x04]

v_bfe_i32 v5, s1, v2, v3
// GFX10: encoding: [0x05,0x00,0x49,0xd5,0x01,0x04,0x0e,0x04]

v_bfe_i32 v5, s103, v2, v3
// GFX10: encoding: [0x05,0x00,0x49,0xd5,0x67,0x04,0x0e,0x04]

v_bfe_i32 v5, vcc_lo, v2, v3
// GFX10: encoding: [0x05,0x00,0x49,0xd5,0x6a,0x04,0x0e,0x04]

v_bfe_i32 v5, vcc_hi, v2, v3
// GFX10: encoding: [0x05,0x00,0x49,0xd5,0x6b,0x04,0x0e,0x04]

v_bfe_i32 v5, ttmp11, v2, v3
// GFX10: encoding: [0x05,0x00,0x49,0xd5,0x77,0x04,0x0e,0x04]

v_bfe_i32 v5, m0, v2, v3
// GFX10: encoding: [0x05,0x00,0x49,0xd5,0x7c,0x04,0x0e,0x04]

v_bfe_i32 v5, exec_lo, v2, v3
// GFX10: encoding: [0x05,0x00,0x49,0xd5,0x7e,0x04,0x0e,0x04]

v_bfe_i32 v5, exec_hi, v2, v3
// GFX10: encoding: [0x05,0x00,0x49,0xd5,0x7f,0x04,0x0e,0x04]

v_bfe_i32 v5, 0, v2, v3
// GFX10: encoding: [0x05,0x00,0x49,0xd5,0x80,0x04,0x0e,0x04]

v_bfe_i32 v5, -1, v2, v3
// GFX10: encoding: [0x05,0x00,0x49,0xd5,0xc1,0x04,0x0e,0x04]

v_bfe_i32 v5, 0.5, v2, v3
// GFX10: encoding: [0x05,0x00,0x49,0xd5,0xf0,0x04,0x0e,0x04]

v_bfe_i32 v5, -4.0, v2, v3
// GFX10: encoding: [0x05,0x00,0x49,0xd5,0xf7,0x04,0x0e,0x04]

v_bfe_i32 v5, v1, v255, v3
// GFX10: encoding: [0x05,0x00,0x49,0xd5,0x01,0xff,0x0f,0x04]

v_bfe_i32 v5, v1, s2, v3
// GFX10: encoding: [0x05,0x00,0x49,0xd5,0x01,0x05,0x0c,0x04]

v_bfe_i32 v5, v1, s103, v3
// GFX10: encoding: [0x05,0x00,0x49,0xd5,0x01,0xcf,0x0c,0x04]

v_bfe_i32 v5, v1, vcc_lo, v3
// GFX10: encoding: [0x05,0x00,0x49,0xd5,0x01,0xd5,0x0c,0x04]

v_bfe_i32 v5, v1, vcc_hi, v3
// GFX10: encoding: [0x05,0x00,0x49,0xd5,0x01,0xd7,0x0c,0x04]

v_bfe_i32 v5, v1, ttmp11, v3
// GFX10: encoding: [0x05,0x00,0x49,0xd5,0x01,0xef,0x0c,0x04]

v_bfe_i32 v5, v1, m0, v3
// GFX10: encoding: [0x05,0x00,0x49,0xd5,0x01,0xf9,0x0c,0x04]

v_bfe_i32 v5, v1, exec_lo, v3
// GFX10: encoding: [0x05,0x00,0x49,0xd5,0x01,0xfd,0x0c,0x04]

v_bfe_i32 v5, v1, exec_hi, v3
// GFX10: encoding: [0x05,0x00,0x49,0xd5,0x01,0xff,0x0c,0x04]

v_bfe_i32 v5, v1, 0, v3
// GFX10: encoding: [0x05,0x00,0x49,0xd5,0x01,0x01,0x0d,0x04]

v_bfe_i32 v5, v1, -1, v3
// GFX10: encoding: [0x05,0x00,0x49,0xd5,0x01,0x83,0x0d,0x04]

v_bfe_i32 v5, v1, 0.5, v3
// GFX10: encoding: [0x05,0x00,0x49,0xd5,0x01,0xe1,0x0d,0x04]

v_bfe_i32 v5, v1, -4.0, v3
// GFX10: encoding: [0x05,0x00,0x49,0xd5,0x01,0xef,0x0d,0x04]

v_bfe_i32 v5, v1, v2, v255
// GFX10: encoding: [0x05,0x00,0x49,0xd5,0x01,0x05,0xfe,0x07]

v_bfe_i32 v5, v1, v2, s3
// GFX10: encoding: [0x05,0x00,0x49,0xd5,0x01,0x05,0x0e,0x00]

v_bfe_i32 v5, v1, v2, s103
// GFX10: encoding: [0x05,0x00,0x49,0xd5,0x01,0x05,0x9e,0x01]

v_bfe_i32 v5, v1, v2, vcc_lo
// GFX10: encoding: [0x05,0x00,0x49,0xd5,0x01,0x05,0xaa,0x01]

v_bfe_i32 v5, v1, v2, vcc_hi
// GFX10: encoding: [0x05,0x00,0x49,0xd5,0x01,0x05,0xae,0x01]

v_bfe_i32 v5, v1, v2, ttmp11
// GFX10: encoding: [0x05,0x00,0x49,0xd5,0x01,0x05,0xde,0x01]

v_bfe_i32 v5, v1, v2, m0
// GFX10: encoding: [0x05,0x00,0x49,0xd5,0x01,0x05,0xf2,0x01]

v_bfe_i32 v5, v1, v2, exec_lo
// GFX10: encoding: [0x05,0x00,0x49,0xd5,0x01,0x05,0xfa,0x01]

v_bfe_i32 v5, v1, v2, exec_hi
// GFX10: encoding: [0x05,0x00,0x49,0xd5,0x01,0x05,0xfe,0x01]

v_bfe_i32 v5, v1, v2, 0
// GFX10: encoding: [0x05,0x00,0x49,0xd5,0x01,0x05,0x02,0x02]

v_bfe_i32 v5, v1, v2, -1
// GFX10: encoding: [0x05,0x00,0x49,0xd5,0x01,0x05,0x06,0x03]

v_bfe_i32 v5, v1, v2, 0.5
// GFX10: encoding: [0x05,0x00,0x49,0xd5,0x01,0x05,0xc2,0x03]

v_bfe_i32 v5, v1, v2, -4.0
// GFX10: encoding: [0x05,0x00,0x49,0xd5,0x01,0x05,0xde,0x03]

v_bfi_b32 v5, v1, v2, v3
// GFX10: encoding: [0x05,0x00,0x4a,0xd5,0x01,0x05,0x0e,0x04]

v_bfi_b32 v255, v1, v2, v3
// GFX10: encoding: [0xff,0x00,0x4a,0xd5,0x01,0x05,0x0e,0x04]

v_bfi_b32 v5, v255, v2, v3
// GFX10: encoding: [0x05,0x00,0x4a,0xd5,0xff,0x05,0x0e,0x04]

v_bfi_b32 v5, s1, v2, v3
// GFX10: encoding: [0x05,0x00,0x4a,0xd5,0x01,0x04,0x0e,0x04]

v_bfi_b32 v5, s103, v2, v3
// GFX10: encoding: [0x05,0x00,0x4a,0xd5,0x67,0x04,0x0e,0x04]

v_bfi_b32 v5, vcc_lo, v2, v3
// GFX10: encoding: [0x05,0x00,0x4a,0xd5,0x6a,0x04,0x0e,0x04]

v_bfi_b32 v5, vcc_hi, v2, v3
// GFX10: encoding: [0x05,0x00,0x4a,0xd5,0x6b,0x04,0x0e,0x04]

v_bfi_b32 v5, ttmp11, v2, v3
// GFX10: encoding: [0x05,0x00,0x4a,0xd5,0x77,0x04,0x0e,0x04]

v_bfi_b32 v5, m0, v2, v3
// GFX10: encoding: [0x05,0x00,0x4a,0xd5,0x7c,0x04,0x0e,0x04]

v_bfi_b32 v5, exec_lo, v2, v3
// GFX10: encoding: [0x05,0x00,0x4a,0xd5,0x7e,0x04,0x0e,0x04]

v_bfi_b32 v5, exec_hi, v2, v3
// GFX10: encoding: [0x05,0x00,0x4a,0xd5,0x7f,0x04,0x0e,0x04]

v_bfi_b32 v5, 0, v2, v3
// GFX10: encoding: [0x05,0x00,0x4a,0xd5,0x80,0x04,0x0e,0x04]

v_bfi_b32 v5, -1, v2, v3
// GFX10: encoding: [0x05,0x00,0x4a,0xd5,0xc1,0x04,0x0e,0x04]

v_bfi_b32 v5, 0.5, v2, v3
// GFX10: encoding: [0x05,0x00,0x4a,0xd5,0xf0,0x04,0x0e,0x04]

v_bfi_b32 v5, -4.0, v2, v3
// GFX10: encoding: [0x05,0x00,0x4a,0xd5,0xf7,0x04,0x0e,0x04]

v_bfi_b32 v5, v1, v255, v3
// GFX10: encoding: [0x05,0x00,0x4a,0xd5,0x01,0xff,0x0f,0x04]

v_bfi_b32 v5, v1, s2, v3
// GFX10: encoding: [0x05,0x00,0x4a,0xd5,0x01,0x05,0x0c,0x04]

v_bfi_b32 v5, v1, s103, v3
// GFX10: encoding: [0x05,0x00,0x4a,0xd5,0x01,0xcf,0x0c,0x04]

v_bfi_b32 v5, v1, vcc_lo, v3
// GFX10: encoding: [0x05,0x00,0x4a,0xd5,0x01,0xd5,0x0c,0x04]

v_bfi_b32 v5, v1, vcc_hi, v3
// GFX10: encoding: [0x05,0x00,0x4a,0xd5,0x01,0xd7,0x0c,0x04]

v_bfi_b32 v5, v1, ttmp11, v3
// GFX10: encoding: [0x05,0x00,0x4a,0xd5,0x01,0xef,0x0c,0x04]

v_bfi_b32 v5, v1, m0, v3
// GFX10: encoding: [0x05,0x00,0x4a,0xd5,0x01,0xf9,0x0c,0x04]

v_bfi_b32 v5, v1, exec_lo, v3
// GFX10: encoding: [0x05,0x00,0x4a,0xd5,0x01,0xfd,0x0c,0x04]

v_bfi_b32 v5, v1, exec_hi, v3
// GFX10: encoding: [0x05,0x00,0x4a,0xd5,0x01,0xff,0x0c,0x04]

v_bfi_b32 v5, v1, 0, v3
// GFX10: encoding: [0x05,0x00,0x4a,0xd5,0x01,0x01,0x0d,0x04]

v_bfi_b32 v5, v1, -1, v3
// GFX10: encoding: [0x05,0x00,0x4a,0xd5,0x01,0x83,0x0d,0x04]

v_bfi_b32 v5, v1, 0.5, v3
// GFX10: encoding: [0x05,0x00,0x4a,0xd5,0x01,0xe1,0x0d,0x04]

v_bfi_b32 v5, v1, -4.0, v3
// GFX10: encoding: [0x05,0x00,0x4a,0xd5,0x01,0xef,0x0d,0x04]

v_bfi_b32 v5, v1, v2, v255
// GFX10: encoding: [0x05,0x00,0x4a,0xd5,0x01,0x05,0xfe,0x07]

v_bfi_b32 v5, v1, v2, s3
// GFX10: encoding: [0x05,0x00,0x4a,0xd5,0x01,0x05,0x0e,0x00]

v_bfi_b32 v5, v1, v2, s103
// GFX10: encoding: [0x05,0x00,0x4a,0xd5,0x01,0x05,0x9e,0x01]

v_bfi_b32 v5, v1, v2, vcc_lo
// GFX10: encoding: [0x05,0x00,0x4a,0xd5,0x01,0x05,0xaa,0x01]

v_bfi_b32 v5, v1, v2, vcc_hi
// GFX10: encoding: [0x05,0x00,0x4a,0xd5,0x01,0x05,0xae,0x01]

v_bfi_b32 v5, v1, v2, ttmp11
// GFX10: encoding: [0x05,0x00,0x4a,0xd5,0x01,0x05,0xde,0x01]

v_bfi_b32 v5, v1, v2, m0
// GFX10: encoding: [0x05,0x00,0x4a,0xd5,0x01,0x05,0xf2,0x01]

v_bfi_b32 v5, v1, v2, exec_lo
// GFX10: encoding: [0x05,0x00,0x4a,0xd5,0x01,0x05,0xfa,0x01]

v_bfi_b32 v5, v1, v2, exec_hi
// GFX10: encoding: [0x05,0x00,0x4a,0xd5,0x01,0x05,0xfe,0x01]

v_bfi_b32 v5, v1, v2, 0
// GFX10: encoding: [0x05,0x00,0x4a,0xd5,0x01,0x05,0x02,0x02]

v_bfi_b32 v5, v1, v2, -1
// GFX10: encoding: [0x05,0x00,0x4a,0xd5,0x01,0x05,0x06,0x03]

v_bfi_b32 v5, v1, v2, 0.5
// GFX10: encoding: [0x05,0x00,0x4a,0xd5,0x01,0x05,0xc2,0x03]

v_bfi_b32 v5, v1, v2, -4.0
// GFX10: encoding: [0x05,0x00,0x4a,0xd5,0x01,0x05,0xde,0x03]

v_fma_f32 v5, v1, v2, v3
// GFX10: encoding: [0x05,0x00,0x4b,0xd5,0x01,0x05,0x0e,0x04]

v_fma_f32 v255, v1, v2, v3
// GFX10: encoding: [0xff,0x00,0x4b,0xd5,0x01,0x05,0x0e,0x04]

v_fma_f32 v5, v255, v2, v3
// GFX10: encoding: [0x05,0x00,0x4b,0xd5,0xff,0x05,0x0e,0x04]

v_fma_f32 v5, s1, v2, v3
// GFX10: encoding: [0x05,0x00,0x4b,0xd5,0x01,0x04,0x0e,0x04]

v_fma_f32 v5, s103, v2, v3
// GFX10: encoding: [0x05,0x00,0x4b,0xd5,0x67,0x04,0x0e,0x04]

v_fma_f32 v5, vcc_lo, v2, v3
// GFX10: encoding: [0x05,0x00,0x4b,0xd5,0x6a,0x04,0x0e,0x04]

v_fma_f32 v5, vcc_hi, v2, v3
// GFX10: encoding: [0x05,0x00,0x4b,0xd5,0x6b,0x04,0x0e,0x04]

v_fma_f32 v5, ttmp11, v2, v3
// GFX10: encoding: [0x05,0x00,0x4b,0xd5,0x77,0x04,0x0e,0x04]

v_fma_f32 v5, m0, v2, v3
// GFX10: encoding: [0x05,0x00,0x4b,0xd5,0x7c,0x04,0x0e,0x04]

v_fma_f32 v5, exec_lo, v2, v3
// GFX10: encoding: [0x05,0x00,0x4b,0xd5,0x7e,0x04,0x0e,0x04]

v_fma_f32 v5, exec_hi, v2, v3
// GFX10: encoding: [0x05,0x00,0x4b,0xd5,0x7f,0x04,0x0e,0x04]

v_fma_f32 v5, 0, v2, v3
// GFX10: encoding: [0x05,0x00,0x4b,0xd5,0x80,0x04,0x0e,0x04]

v_fma_f32 v5, -1, v2, v3
// GFX10: encoding: [0x05,0x00,0x4b,0xd5,0xc1,0x04,0x0e,0x04]

v_fma_f32 v5, 0.5, v2, v3
// GFX10: encoding: [0x05,0x00,0x4b,0xd5,0xf0,0x04,0x0e,0x04]

v_fma_f32 v5, -4.0, v2, v3
// GFX10: encoding: [0x05,0x00,0x4b,0xd5,0xf7,0x04,0x0e,0x04]

v_fma_f32 v5, v1, v255, v3
// GFX10: encoding: [0x05,0x00,0x4b,0xd5,0x01,0xff,0x0f,0x04]

v_fma_f32 v5, v1, s2, v3
// GFX10: encoding: [0x05,0x00,0x4b,0xd5,0x01,0x05,0x0c,0x04]

v_fma_f32 v5, v1, s103, v3
// GFX10: encoding: [0x05,0x00,0x4b,0xd5,0x01,0xcf,0x0c,0x04]

v_fma_f32 v5, v1, vcc_lo, v3
// GFX10: encoding: [0x05,0x00,0x4b,0xd5,0x01,0xd5,0x0c,0x04]

v_fma_f32 v5, v1, vcc_hi, v3
// GFX10: encoding: [0x05,0x00,0x4b,0xd5,0x01,0xd7,0x0c,0x04]

v_fma_f32 v5, v1, ttmp11, v3
// GFX10: encoding: [0x05,0x00,0x4b,0xd5,0x01,0xef,0x0c,0x04]

v_fma_f32 v5, v1, m0, v3
// GFX10: encoding: [0x05,0x00,0x4b,0xd5,0x01,0xf9,0x0c,0x04]

v_fma_f32 v5, v1, exec_lo, v3
// GFX10: encoding: [0x05,0x00,0x4b,0xd5,0x01,0xfd,0x0c,0x04]

v_fma_f32 v5, v1, exec_hi, v3
// GFX10: encoding: [0x05,0x00,0x4b,0xd5,0x01,0xff,0x0c,0x04]

v_fma_f32 v5, v1, 0, v3
// GFX10: encoding: [0x05,0x00,0x4b,0xd5,0x01,0x01,0x0d,0x04]

v_fma_f32 v5, v1, -1, v3
// GFX10: encoding: [0x05,0x00,0x4b,0xd5,0x01,0x83,0x0d,0x04]

v_fma_f32 v5, v1, 0.5, v3
// GFX10: encoding: [0x05,0x00,0x4b,0xd5,0x01,0xe1,0x0d,0x04]

v_fma_f32 v5, v1, -4.0, v3
// GFX10: encoding: [0x05,0x00,0x4b,0xd5,0x01,0xef,0x0d,0x04]

v_fma_f32 v5, v1, v2, v255
// GFX10: encoding: [0x05,0x00,0x4b,0xd5,0x01,0x05,0xfe,0x07]

v_fma_f32 v5, v1, v2, s3
// GFX10: encoding: [0x05,0x00,0x4b,0xd5,0x01,0x05,0x0e,0x00]

v_fma_f32 v5, v1, v2, s103
// GFX10: encoding: [0x05,0x00,0x4b,0xd5,0x01,0x05,0x9e,0x01]

v_fma_f32 v5, v1, v2, vcc_lo
// GFX10: encoding: [0x05,0x00,0x4b,0xd5,0x01,0x05,0xaa,0x01]

v_fma_f32 v5, v1, v2, vcc_hi
// GFX10: encoding: [0x05,0x00,0x4b,0xd5,0x01,0x05,0xae,0x01]

v_fma_f32 v5, v1, v2, ttmp11
// GFX10: encoding: [0x05,0x00,0x4b,0xd5,0x01,0x05,0xde,0x01]

v_fma_f32 v5, v1, v2, m0
// GFX10: encoding: [0x05,0x00,0x4b,0xd5,0x01,0x05,0xf2,0x01]

v_fma_f32 v5, v1, v2, exec_lo
// GFX10: encoding: [0x05,0x00,0x4b,0xd5,0x01,0x05,0xfa,0x01]

v_fma_f32 v5, v1, v2, exec_hi
// GFX10: encoding: [0x05,0x00,0x4b,0xd5,0x01,0x05,0xfe,0x01]

v_fma_f32 v5, v1, v2, 0
// GFX10: encoding: [0x05,0x00,0x4b,0xd5,0x01,0x05,0x02,0x02]

v_fma_f32 v5, v1, v2, -1
// GFX10: encoding: [0x05,0x00,0x4b,0xd5,0x01,0x05,0x06,0x03]

v_fma_f32 v5, v1, v2, 0.5
// GFX10: encoding: [0x05,0x00,0x4b,0xd5,0x01,0x05,0xc2,0x03]

v_fma_f32 v5, v1, v2, -4.0
// GFX10: encoding: [0x05,0x00,0x4b,0xd5,0x01,0x05,0xde,0x03]

v_fma_f32 v5, -v1, v2, v3
// GFX10: encoding: [0x05,0x00,0x4b,0xd5,0x01,0x05,0x0e,0x24]

v_fma_f32 v5, v1, -v2, v3
// GFX10: encoding: [0x05,0x00,0x4b,0xd5,0x01,0x05,0x0e,0x44]

v_fma_f32 v5, v1, v2, -v3
// GFX10: encoding: [0x05,0x00,0x4b,0xd5,0x01,0x05,0x0e,0x84]

v_fma_f32 v5, -v1, -v2, -v3
// GFX10: encoding: [0x05,0x00,0x4b,0xd5,0x01,0x05,0x0e,0xe4]

v_fma_f32 v5, |v1|, v2, v3
// GFX10: encoding: [0x05,0x01,0x4b,0xd5,0x01,0x05,0x0e,0x04]

v_fma_f32 v5, v1, |v2|, v3
// GFX10: encoding: [0x05,0x02,0x4b,0xd5,0x01,0x05,0x0e,0x04]

v_fma_f32 v5, v1, v2, |v3|
// GFX10: encoding: [0x05,0x04,0x4b,0xd5,0x01,0x05,0x0e,0x04]

v_fma_f32 v5, |v1|, |v2|, |v3|
// GFX10: encoding: [0x05,0x07,0x4b,0xd5,0x01,0x05,0x0e,0x04]

v_fma_f32 v5, v1, v2, v3 clamp
// GFX10: encoding: [0x05,0x80,0x4b,0xd5,0x01,0x05,0x0e,0x04]

v_fma_f32 v5, v1, v2, v3 mul:2
// GFX10: encoding: [0x05,0x00,0x4b,0xd5,0x01,0x05,0x0e,0x0c]

v_fma_f32 v5, v1, v2, v3 mul:4
// GFX10: encoding: [0x05,0x00,0x4b,0xd5,0x01,0x05,0x0e,0x14]

v_fma_f32 v5, v1, v2, v3 div:2
// GFX10: encoding: [0x05,0x00,0x4b,0xd5,0x01,0x05,0x0e,0x1c]

v_fma_f64 v[5:6], v[1:2], v[2:3], v[3:4]
// GFX10: encoding: [0x05,0x00,0x4c,0xd5,0x01,0x05,0x0e,0x04]

v_fma_f64 v[254:255], v[1:2], v[2:3], v[3:4]
// GFX10: encoding: [0xfe,0x00,0x4c,0xd5,0x01,0x05,0x0e,0x04]

v_fma_f64 v[5:6], v[254:255], v[2:3], v[3:4]
// GFX10: encoding: [0x05,0x00,0x4c,0xd5,0xfe,0x05,0x0e,0x04]

v_fma_f64 v[5:6], s[2:3], v[2:3], v[3:4]
// GFX10: encoding: [0x05,0x00,0x4c,0xd5,0x02,0x04,0x0e,0x04]

v_fma_f64 v[5:6], s[4:5], v[2:3], v[3:4]
// GFX10: encoding: [0x05,0x00,0x4c,0xd5,0x04,0x04,0x0e,0x04]

v_fma_f64 v[5:6], s[102:103], v[2:3], v[3:4]
// GFX10: encoding: [0x05,0x00,0x4c,0xd5,0x66,0x04,0x0e,0x04]

v_fma_f64 v[5:6], vcc, v[2:3], v[3:4]
// GFX10: encoding: [0x05,0x00,0x4c,0xd5,0x6a,0x04,0x0e,0x04]

v_fma_f64 v[5:6], ttmp[10:11], v[2:3], v[3:4]
// GFX10: encoding: [0x05,0x00,0x4c,0xd5,0x76,0x04,0x0e,0x04]

v_fma_f64 v[5:6], exec, v[2:3], v[3:4]
// GFX10: encoding: [0x05,0x00,0x4c,0xd5,0x7e,0x04,0x0e,0x04]

v_fma_f64 v[5:6], 0, v[2:3], v[3:4]
// GFX10: encoding: [0x05,0x00,0x4c,0xd5,0x80,0x04,0x0e,0x04]

v_fma_f64 v[5:6], -1, v[2:3], v[3:4]
// GFX10: encoding: [0x05,0x00,0x4c,0xd5,0xc1,0x04,0x0e,0x04]

v_fma_f64 v[5:6], 0.5, v[2:3], v[3:4]
// GFX10: encoding: [0x05,0x00,0x4c,0xd5,0xf0,0x04,0x0e,0x04]

v_fma_f64 v[5:6], -4.0, v[2:3], v[3:4]
// GFX10: encoding: [0x05,0x00,0x4c,0xd5,0xf7,0x04,0x0e,0x04]

v_fma_f64 v[5:6], v[1:2], v[254:255], v[3:4]
// GFX10: encoding: [0x05,0x00,0x4c,0xd5,0x01,0xfd,0x0f,0x04]

v_fma_f64 v[5:6], v[1:2], s[4:5], v[3:4]
// GFX10: encoding: [0x05,0x00,0x4c,0xd5,0x01,0x09,0x0c,0x04]

v_fma_f64 v[5:6], v[1:2], s[6:7], v[3:4]
// GFX10: encoding: [0x05,0x00,0x4c,0xd5,0x01,0x0d,0x0c,0x04]

v_fma_f64 v[5:6], v[1:2], s[102:103], v[3:4]
// GFX10: encoding: [0x05,0x00,0x4c,0xd5,0x01,0xcd,0x0c,0x04]

v_fma_f64 v[5:6], v[1:2], vcc, v[3:4]
// GFX10: encoding: [0x05,0x00,0x4c,0xd5,0x01,0xd5,0x0c,0x04]

v_fma_f64 v[5:6], v[1:2], ttmp[10:11], v[3:4]
// GFX10: encoding: [0x05,0x00,0x4c,0xd5,0x01,0xed,0x0c,0x04]

v_fma_f64 v[5:6], v[1:2], exec, v[3:4]
// GFX10: encoding: [0x05,0x00,0x4c,0xd5,0x01,0xfd,0x0c,0x04]

v_fma_f64 v[5:6], v[1:2], 0, v[3:4]
// GFX10: encoding: [0x05,0x00,0x4c,0xd5,0x01,0x01,0x0d,0x04]

v_fma_f64 v[5:6], v[1:2], -1, v[3:4]
// GFX10: encoding: [0x05,0x00,0x4c,0xd5,0x01,0x83,0x0d,0x04]

v_fma_f64 v[5:6], v[1:2], 0.5, v[3:4]
// GFX10: encoding: [0x05,0x00,0x4c,0xd5,0x01,0xe1,0x0d,0x04]

v_fma_f64 v[5:6], v[1:2], -4.0, v[3:4]
// GFX10: encoding: [0x05,0x00,0x4c,0xd5,0x01,0xef,0x0d,0x04]

v_fma_f64 v[5:6], v[1:2], v[2:3], v[254:255]
// GFX10: encoding: [0x05,0x00,0x4c,0xd5,0x01,0x05,0xfa,0x07]

v_fma_f64 v[5:6], v[1:2], v[2:3], s[6:7]
// GFX10: encoding: [0x05,0x00,0x4c,0xd5,0x01,0x05,0x1a,0x00]

v_fma_f64 v[5:6], v[1:2], v[2:3], s[8:9]
// GFX10: encoding: [0x05,0x00,0x4c,0xd5,0x01,0x05,0x22,0x00]

v_fma_f64 v[5:6], v[1:2], v[2:3], s[102:103]
// GFX10: encoding: [0x05,0x00,0x4c,0xd5,0x01,0x05,0x9a,0x01]

v_fma_f64 v[5:6], v[1:2], v[2:3], vcc
// GFX10: encoding: [0x05,0x00,0x4c,0xd5,0x01,0x05,0xaa,0x01]

v_fma_f64 v[5:6], v[1:2], v[2:3], ttmp[10:11]
// GFX10: encoding: [0x05,0x00,0x4c,0xd5,0x01,0x05,0xda,0x01]

v_fma_f64 v[5:6], v[1:2], v[2:3], exec
// GFX10: encoding: [0x05,0x00,0x4c,0xd5,0x01,0x05,0xfa,0x01]

v_fma_f64 v[5:6], v[1:2], v[2:3], 0
// GFX10: encoding: [0x05,0x00,0x4c,0xd5,0x01,0x05,0x02,0x02]

v_fma_f64 v[5:6], v[1:2], v[2:3], -1
// GFX10: encoding: [0x05,0x00,0x4c,0xd5,0x01,0x05,0x06,0x03]

v_fma_f64 v[5:6], v[1:2], v[2:3], 0.5
// GFX10: encoding: [0x05,0x00,0x4c,0xd5,0x01,0x05,0xc2,0x03]

v_fma_f64 v[5:6], v[1:2], v[2:3], -4.0
// GFX10: encoding: [0x05,0x00,0x4c,0xd5,0x01,0x05,0xde,0x03]

v_fma_f64 v[5:6], -v[1:2], v[2:3], v[3:4]
// GFX10: encoding: [0x05,0x00,0x4c,0xd5,0x01,0x05,0x0e,0x24]

v_fma_f64 v[5:6], v[1:2], -v[2:3], v[3:4]
// GFX10: encoding: [0x05,0x00,0x4c,0xd5,0x01,0x05,0x0e,0x44]

v_fma_f64 v[5:6], v[1:2], v[2:3], -v[3:4]
// GFX10: encoding: [0x05,0x00,0x4c,0xd5,0x01,0x05,0x0e,0x84]

v_fma_f64 v[5:6], -v[1:2], -v[2:3], -v[3:4]
// GFX10: encoding: [0x05,0x00,0x4c,0xd5,0x01,0x05,0x0e,0xe4]

v_fma_f64 v[5:6], |v[1:2]|, v[2:3], v[3:4]
// GFX10: encoding: [0x05,0x01,0x4c,0xd5,0x01,0x05,0x0e,0x04]

v_fma_f64 v[5:6], v[1:2], |v[2:3]|, v[3:4]
// GFX10: encoding: [0x05,0x02,0x4c,0xd5,0x01,0x05,0x0e,0x04]

v_fma_f64 v[5:6], v[1:2], v[2:3], |v[3:4]|
// GFX10: encoding: [0x05,0x04,0x4c,0xd5,0x01,0x05,0x0e,0x04]

v_fma_f64 v[5:6], |v[1:2]|, |v[2:3]|, |v[3:4]|
// GFX10: encoding: [0x05,0x07,0x4c,0xd5,0x01,0x05,0x0e,0x04]

v_fma_f64 v[5:6], v[1:2], v[2:3], v[3:4] clamp
// GFX10: encoding: [0x05,0x80,0x4c,0xd5,0x01,0x05,0x0e,0x04]

v_fma_f64 v[5:6], v[1:2], v[2:3], v[3:4] mul:2
// GFX10: encoding: [0x05,0x00,0x4c,0xd5,0x01,0x05,0x0e,0x0c]

v_fma_f64 v[5:6], v[1:2], v[2:3], v[3:4] mul:4
// GFX10: encoding: [0x05,0x00,0x4c,0xd5,0x01,0x05,0x0e,0x14]

v_fma_f64 v[5:6], v[1:2], v[2:3], v[3:4] div:2
// GFX10: encoding: [0x05,0x00,0x4c,0xd5,0x01,0x05,0x0e,0x1c]

v_lerp_u8 v5, v1, v2, v3
// GFX10: encoding: [0x05,0x00,0x4d,0xd5,0x01,0x05,0x0e,0x04]

v_lerp_u8 v255, v1, v2, v3
// GFX10: encoding: [0xff,0x00,0x4d,0xd5,0x01,0x05,0x0e,0x04]

v_lerp_u8 v5, v255, v2, v3
// GFX10: encoding: [0x05,0x00,0x4d,0xd5,0xff,0x05,0x0e,0x04]

v_lerp_u8 v5, s1, v2, v3
// GFX10: encoding: [0x05,0x00,0x4d,0xd5,0x01,0x04,0x0e,0x04]

v_lerp_u8 v5, s103, v2, v3
// GFX10: encoding: [0x05,0x00,0x4d,0xd5,0x67,0x04,0x0e,0x04]

v_lerp_u8 v5, vcc_lo, v2, v3
// GFX10: encoding: [0x05,0x00,0x4d,0xd5,0x6a,0x04,0x0e,0x04]

v_lerp_u8 v5, vcc_hi, v2, v3
// GFX10: encoding: [0x05,0x00,0x4d,0xd5,0x6b,0x04,0x0e,0x04]

v_lerp_u8 v5, ttmp11, v2, v3
// GFX10: encoding: [0x05,0x00,0x4d,0xd5,0x77,0x04,0x0e,0x04]

v_lerp_u8 v5, m0, v2, v3
// GFX10: encoding: [0x05,0x00,0x4d,0xd5,0x7c,0x04,0x0e,0x04]

v_lerp_u8 v5, exec_lo, v2, v3
// GFX10: encoding: [0x05,0x00,0x4d,0xd5,0x7e,0x04,0x0e,0x04]

v_lerp_u8 v5, exec_hi, v2, v3
// GFX10: encoding: [0x05,0x00,0x4d,0xd5,0x7f,0x04,0x0e,0x04]

v_lerp_u8 v5, 0, v2, v3
// GFX10: encoding: [0x05,0x00,0x4d,0xd5,0x80,0x04,0x0e,0x04]

v_lerp_u8 v5, -1, v2, v3
// GFX10: encoding: [0x05,0x00,0x4d,0xd5,0xc1,0x04,0x0e,0x04]

v_lerp_u8 v5, 0.5, v2, v3
// GFX10: encoding: [0x05,0x00,0x4d,0xd5,0xf0,0x04,0x0e,0x04]

v_lerp_u8 v5, -4.0, v2, v3
// GFX10: encoding: [0x05,0x00,0x4d,0xd5,0xf7,0x04,0x0e,0x04]

v_lerp_u8 v5, v1, v255, v3
// GFX10: encoding: [0x05,0x00,0x4d,0xd5,0x01,0xff,0x0f,0x04]

v_lerp_u8 v5, v1, s2, v3
// GFX10: encoding: [0x05,0x00,0x4d,0xd5,0x01,0x05,0x0c,0x04]

v_lerp_u8 v5, v1, s103, v3
// GFX10: encoding: [0x05,0x00,0x4d,0xd5,0x01,0xcf,0x0c,0x04]

v_lerp_u8 v5, v1, vcc_lo, v3
// GFX10: encoding: [0x05,0x00,0x4d,0xd5,0x01,0xd5,0x0c,0x04]

v_lerp_u8 v5, v1, vcc_hi, v3
// GFX10: encoding: [0x05,0x00,0x4d,0xd5,0x01,0xd7,0x0c,0x04]

v_lerp_u8 v5, v1, ttmp11, v3
// GFX10: encoding: [0x05,0x00,0x4d,0xd5,0x01,0xef,0x0c,0x04]

v_lerp_u8 v5, v1, m0, v3
// GFX10: encoding: [0x05,0x00,0x4d,0xd5,0x01,0xf9,0x0c,0x04]

v_lerp_u8 v5, v1, exec_lo, v3
// GFX10: encoding: [0x05,0x00,0x4d,0xd5,0x01,0xfd,0x0c,0x04]

v_lerp_u8 v5, v1, exec_hi, v3
// GFX10: encoding: [0x05,0x00,0x4d,0xd5,0x01,0xff,0x0c,0x04]

v_lerp_u8 v5, v1, 0, v3
// GFX10: encoding: [0x05,0x00,0x4d,0xd5,0x01,0x01,0x0d,0x04]

v_lerp_u8 v5, v1, -1, v3
// GFX10: encoding: [0x05,0x00,0x4d,0xd5,0x01,0x83,0x0d,0x04]

v_lerp_u8 v5, v1, 0.5, v3
// GFX10: encoding: [0x05,0x00,0x4d,0xd5,0x01,0xe1,0x0d,0x04]

v_lerp_u8 v5, v1, -4.0, v3
// GFX10: encoding: [0x05,0x00,0x4d,0xd5,0x01,0xef,0x0d,0x04]

v_lerp_u8 v5, v1, v2, v255
// GFX10: encoding: [0x05,0x00,0x4d,0xd5,0x01,0x05,0xfe,0x07]

v_lerp_u8 v5, v1, v2, s3
// GFX10: encoding: [0x05,0x00,0x4d,0xd5,0x01,0x05,0x0e,0x00]

v_lerp_u8 v5, v1, v2, s103
// GFX10: encoding: [0x05,0x00,0x4d,0xd5,0x01,0x05,0x9e,0x01]

v_lerp_u8 v5, v1, v2, vcc_lo
// GFX10: encoding: [0x05,0x00,0x4d,0xd5,0x01,0x05,0xaa,0x01]

v_lerp_u8 v5, v1, v2, vcc_hi
// GFX10: encoding: [0x05,0x00,0x4d,0xd5,0x01,0x05,0xae,0x01]

v_lerp_u8 v5, v1, v2, ttmp11
// GFX10: encoding: [0x05,0x00,0x4d,0xd5,0x01,0x05,0xde,0x01]

v_lerp_u8 v5, v1, v2, m0
// GFX10: encoding: [0x05,0x00,0x4d,0xd5,0x01,0x05,0xf2,0x01]

v_lerp_u8 v5, v1, v2, exec_lo
// GFX10: encoding: [0x05,0x00,0x4d,0xd5,0x01,0x05,0xfa,0x01]

v_lerp_u8 v5, v1, v2, exec_hi
// GFX10: encoding: [0x05,0x00,0x4d,0xd5,0x01,0x05,0xfe,0x01]

v_lerp_u8 v5, v1, v2, 0
// GFX10: encoding: [0x05,0x00,0x4d,0xd5,0x01,0x05,0x02,0x02]

v_lerp_u8 v5, v1, v2, -1
// GFX10: encoding: [0x05,0x00,0x4d,0xd5,0x01,0x05,0x06,0x03]

v_lerp_u8 v5, v1, v2, 0.5
// GFX10: encoding: [0x05,0x00,0x4d,0xd5,0x01,0x05,0xc2,0x03]

v_lerp_u8 v5, v1, v2, -4.0
// GFX10: encoding: [0x05,0x00,0x4d,0xd5,0x01,0x05,0xde,0x03]

v_alignbit_b32 v5, v1, v2, v3
// GFX10: encoding: [0x05,0x00,0x4e,0xd5,0x01,0x05,0x0e,0x04]

v_alignbit_b32 v255, v1, v2, v3
// GFX10: encoding: [0xff,0x00,0x4e,0xd5,0x01,0x05,0x0e,0x04]

v_alignbit_b32 v5, v255, v2, v3
// GFX10: encoding: [0x05,0x00,0x4e,0xd5,0xff,0x05,0x0e,0x04]

v_alignbit_b32 v5, s1, v2, v3
// GFX10: encoding: [0x05,0x00,0x4e,0xd5,0x01,0x04,0x0e,0x04]

v_alignbit_b32 v5, s103, v2, v3
// GFX10: encoding: [0x05,0x00,0x4e,0xd5,0x67,0x04,0x0e,0x04]

v_alignbit_b32 v5, vcc_lo, v2, v3
// GFX10: encoding: [0x05,0x00,0x4e,0xd5,0x6a,0x04,0x0e,0x04]

v_alignbit_b32 v5, vcc_hi, v2, v3
// GFX10: encoding: [0x05,0x00,0x4e,0xd5,0x6b,0x04,0x0e,0x04]

v_alignbit_b32 v5, ttmp11, v2, v3
// GFX10: encoding: [0x05,0x00,0x4e,0xd5,0x77,0x04,0x0e,0x04]

v_alignbit_b32 v5, m0, v2, v3
// GFX10: encoding: [0x05,0x00,0x4e,0xd5,0x7c,0x04,0x0e,0x04]

v_alignbit_b32 v5, exec_lo, v2, v3
// GFX10: encoding: [0x05,0x00,0x4e,0xd5,0x7e,0x04,0x0e,0x04]

v_alignbit_b32 v5, exec_hi, v2, v3
// GFX10: encoding: [0x05,0x00,0x4e,0xd5,0x7f,0x04,0x0e,0x04]

v_alignbit_b32 v5, v1, v255, v3
// GFX10: encoding: [0x05,0x00,0x4e,0xd5,0x01,0xff,0x0f,0x04]

v_alignbit_b32 v5, v1, s2, v3
// GFX10: encoding: [0x05,0x00,0x4e,0xd5,0x01,0x05,0x0c,0x04]

v_alignbit_b32 v5, v1, s103, v3
// GFX10: encoding: [0x05,0x00,0x4e,0xd5,0x01,0xcf,0x0c,0x04]

v_alignbit_b32 v5, v1, vcc_lo, v3
// GFX10: encoding: [0x05,0x00,0x4e,0xd5,0x01,0xd5,0x0c,0x04]

v_alignbit_b32 v5, v1, vcc_hi, v3
// GFX10: encoding: [0x05,0x00,0x4e,0xd5,0x01,0xd7,0x0c,0x04]

v_alignbit_b32 v5, v1, ttmp11, v3
// GFX10: encoding: [0x05,0x00,0x4e,0xd5,0x01,0xef,0x0c,0x04]

v_alignbit_b32 v5, v1, m0, v3
// GFX10: encoding: [0x05,0x00,0x4e,0xd5,0x01,0xf9,0x0c,0x04]

v_alignbit_b32 v5, v1, exec_lo, v3
// GFX10: encoding: [0x05,0x00,0x4e,0xd5,0x01,0xfd,0x0c,0x04]

v_alignbit_b32 v5, v1, exec_hi, v3
// GFX10: encoding: [0x05,0x00,0x4e,0xd5,0x01,0xff,0x0c,0x04]

v_alignbit_b32 v5, v1, v2, v255
// GFX10: encoding: [0x05,0x00,0x4e,0xd5,0x01,0x05,0xfe,0x07]

v_alignbit_b32 v5, v1, v2, s3
// GFX10: encoding: [0x05,0x00,0x4e,0xd5,0x01,0x05,0x0e,0x00]

v_alignbit_b32 v5, v1, v2, s103
// GFX10: encoding: [0x05,0x00,0x4e,0xd5,0x01,0x05,0x9e,0x01]

v_alignbit_b32 v5, v1, v2, vcc_lo
// GFX10: encoding: [0x05,0x00,0x4e,0xd5,0x01,0x05,0xaa,0x01]

v_alignbit_b32 v5, v1, v2, vcc_hi
// GFX10: encoding: [0x05,0x00,0x4e,0xd5,0x01,0x05,0xae,0x01]

v_alignbit_b32 v5, v1, v2, ttmp11
// GFX10: encoding: [0x05,0x00,0x4e,0xd5,0x01,0x05,0xde,0x01]

v_alignbit_b32 v5, v1, v2, m0
// GFX10: encoding: [0x05,0x00,0x4e,0xd5,0x01,0x05,0xf2,0x01]

v_alignbit_b32 v5, v1, v2, exec_lo
// GFX10: encoding: [0x05,0x00,0x4e,0xd5,0x01,0x05,0xfa,0x01]

v_alignbit_b32 v5, v1, v2, exec_hi
// GFX10: encoding: [0x05,0x00,0x4e,0xd5,0x01,0x05,0xfe,0x01]

v_alignbyte_b32 v5, v1, v2, v3
// GFX10: encoding: [0x05,0x00,0x4f,0xd5,0x01,0x05,0x0e,0x04]

v_alignbyte_b32 v255, v1, v2, v3
// GFX10: encoding: [0xff,0x00,0x4f,0xd5,0x01,0x05,0x0e,0x04]

v_alignbyte_b32 v5, v255, v2, v3
// GFX10: encoding: [0x05,0x00,0x4f,0xd5,0xff,0x05,0x0e,0x04]

v_alignbyte_b32 v5, s1, v2, v3
// GFX10: encoding: [0x05,0x00,0x4f,0xd5,0x01,0x04,0x0e,0x04]

v_alignbyte_b32 v5, s103, v2, v3
// GFX10: encoding: [0x05,0x00,0x4f,0xd5,0x67,0x04,0x0e,0x04]

v_alignbyte_b32 v5, vcc_lo, v2, v3
// GFX10: encoding: [0x05,0x00,0x4f,0xd5,0x6a,0x04,0x0e,0x04]

v_alignbyte_b32 v5, vcc_hi, v2, v3
// GFX10: encoding: [0x05,0x00,0x4f,0xd5,0x6b,0x04,0x0e,0x04]

v_alignbyte_b32 v5, ttmp11, v2, v3
// GFX10: encoding: [0x05,0x00,0x4f,0xd5,0x77,0x04,0x0e,0x04]

v_alignbyte_b32 v5, m0, v2, v3
// GFX10: encoding: [0x05,0x00,0x4f,0xd5,0x7c,0x04,0x0e,0x04]

v_alignbyte_b32 v5, exec_lo, v2, v3
// GFX10: encoding: [0x05,0x00,0x4f,0xd5,0x7e,0x04,0x0e,0x04]

v_alignbyte_b32 v5, exec_hi, v2, v3
// GFX10: encoding: [0x05,0x00,0x4f,0xd5,0x7f,0x04,0x0e,0x04]

v_alignbyte_b32 v5, v1, v255, v3
// GFX10: encoding: [0x05,0x00,0x4f,0xd5,0x01,0xff,0x0f,0x04]

v_alignbyte_b32 v5, v1, s2, v3
// GFX10: encoding: [0x05,0x00,0x4f,0xd5,0x01,0x05,0x0c,0x04]

v_alignbyte_b32 v5, v1, s103, v3
// GFX10: encoding: [0x05,0x00,0x4f,0xd5,0x01,0xcf,0x0c,0x04]

v_alignbyte_b32 v5, v1, vcc_lo, v3
// GFX10: encoding: [0x05,0x00,0x4f,0xd5,0x01,0xd5,0x0c,0x04]

v_alignbyte_b32 v5, v1, vcc_hi, v3
// GFX10: encoding: [0x05,0x00,0x4f,0xd5,0x01,0xd7,0x0c,0x04]

v_alignbyte_b32 v5, v1, ttmp11, v3
// GFX10: encoding: [0x05,0x00,0x4f,0xd5,0x01,0xef,0x0c,0x04]

v_alignbyte_b32 v5, v1, m0, v3
// GFX10: encoding: [0x05,0x00,0x4f,0xd5,0x01,0xf9,0x0c,0x04]

v_alignbyte_b32 v5, v1, exec_lo, v3
// GFX10: encoding: [0x05,0x00,0x4f,0xd5,0x01,0xfd,0x0c,0x04]

v_alignbyte_b32 v5, v1, exec_hi, v3
// GFX10: encoding: [0x05,0x00,0x4f,0xd5,0x01,0xff,0x0c,0x04]

v_alignbyte_b32 v5, v1, v2, v255
// GFX10: encoding: [0x05,0x00,0x4f,0xd5,0x01,0x05,0xfe,0x07]

v_alignbyte_b32 v5, v1, v2, s3
// GFX10: encoding: [0x05,0x00,0x4f,0xd5,0x01,0x05,0x0e,0x00]

v_alignbyte_b32 v5, v1, v2, s103
// GFX10: encoding: [0x05,0x00,0x4f,0xd5,0x01,0x05,0x9e,0x01]

v_alignbyte_b32 v5, v1, v2, vcc_lo
// GFX10: encoding: [0x05,0x00,0x4f,0xd5,0x01,0x05,0xaa,0x01]

v_alignbyte_b32 v5, v1, v2, vcc_hi
// GFX10: encoding: [0x05,0x00,0x4f,0xd5,0x01,0x05,0xae,0x01]

v_alignbyte_b32 v5, v1, v2, ttmp11
// GFX10: encoding: [0x05,0x00,0x4f,0xd5,0x01,0x05,0xde,0x01]

v_alignbyte_b32 v5, v1, v2, m0
// GFX10: encoding: [0x05,0x00,0x4f,0xd5,0x01,0x05,0xf2,0x01]

v_alignbyte_b32 v5, v1, v2, exec_lo
// GFX10: encoding: [0x05,0x00,0x4f,0xd5,0x01,0x05,0xfa,0x01]

v_alignbyte_b32 v5, v1, v2, exec_hi
// GFX10: encoding: [0x05,0x00,0x4f,0xd5,0x01,0x05,0xfe,0x01]

v_mullit_f32 v5, v1, v2, v3
// GFX10: encoding: [0x05,0x00,0x50,0xd5,0x01,0x05,0x0e,0x04]

v_mullit_f32 v255, v1, v2, v3
// GFX10: encoding: [0xff,0x00,0x50,0xd5,0x01,0x05,0x0e,0x04]

v_mullit_f32 v5, v255, v2, v3
// GFX10: encoding: [0x05,0x00,0x50,0xd5,0xff,0x05,0x0e,0x04]

v_mullit_f32 v5, s1, v2, v3
// GFX10: encoding: [0x05,0x00,0x50,0xd5,0x01,0x04,0x0e,0x04]

v_mullit_f32 v5, s103, v2, v3
// GFX10: encoding: [0x05,0x00,0x50,0xd5,0x67,0x04,0x0e,0x04]

v_mullit_f32 v5, vcc_lo, v2, v3
// GFX10: encoding: [0x05,0x00,0x50,0xd5,0x6a,0x04,0x0e,0x04]

v_mullit_f32 v5, vcc_hi, v2, v3
// GFX10: encoding: [0x05,0x00,0x50,0xd5,0x6b,0x04,0x0e,0x04]

v_mullit_f32 v5, ttmp11, v2, v3
// GFX10: encoding: [0x05,0x00,0x50,0xd5,0x77,0x04,0x0e,0x04]

v_mullit_f32 v5, m0, v2, v3
// GFX10: encoding: [0x05,0x00,0x50,0xd5,0x7c,0x04,0x0e,0x04]

v_mullit_f32 v5, exec_lo, v2, v3
// GFX10: encoding: [0x05,0x00,0x50,0xd5,0x7e,0x04,0x0e,0x04]

v_mullit_f32 v5, exec_hi, v2, v3
// GFX10: encoding: [0x05,0x00,0x50,0xd5,0x7f,0x04,0x0e,0x04]

v_mullit_f32 v5, 0, v2, v3
// GFX10: encoding: [0x05,0x00,0x50,0xd5,0x80,0x04,0x0e,0x04]

v_mullit_f32 v5, -1, v2, v3
// GFX10: encoding: [0x05,0x00,0x50,0xd5,0xc1,0x04,0x0e,0x04]

v_mullit_f32 v5, 0.5, v2, v3
// GFX10: encoding: [0x05,0x00,0x50,0xd5,0xf0,0x04,0x0e,0x04]

v_mullit_f32 v5, -4.0, v2, v3
// GFX10: encoding: [0x05,0x00,0x50,0xd5,0xf7,0x04,0x0e,0x04]

v_mullit_f32 v5, v1, v255, v3
// GFX10: encoding: [0x05,0x00,0x50,0xd5,0x01,0xff,0x0f,0x04]

v_mullit_f32 v5, v1, s2, v3
// GFX10: encoding: [0x05,0x00,0x50,0xd5,0x01,0x05,0x0c,0x04]

v_mullit_f32 v5, v1, s103, v3
// GFX10: encoding: [0x05,0x00,0x50,0xd5,0x01,0xcf,0x0c,0x04]

v_mullit_f32 v5, v1, vcc_lo, v3
// GFX10: encoding: [0x05,0x00,0x50,0xd5,0x01,0xd5,0x0c,0x04]

v_mullit_f32 v5, v1, vcc_hi, v3
// GFX10: encoding: [0x05,0x00,0x50,0xd5,0x01,0xd7,0x0c,0x04]

v_mullit_f32 v5, v1, ttmp11, v3
// GFX10: encoding: [0x05,0x00,0x50,0xd5,0x01,0xef,0x0c,0x04]

v_mullit_f32 v5, v1, m0, v3
// GFX10: encoding: [0x05,0x00,0x50,0xd5,0x01,0xf9,0x0c,0x04]

v_mullit_f32 v5, v1, exec_lo, v3
// GFX10: encoding: [0x05,0x00,0x50,0xd5,0x01,0xfd,0x0c,0x04]

v_mullit_f32 v5, v1, exec_hi, v3
// GFX10: encoding: [0x05,0x00,0x50,0xd5,0x01,0xff,0x0c,0x04]

v_mullit_f32 v5, v1, 0, v3
// GFX10: encoding: [0x05,0x00,0x50,0xd5,0x01,0x01,0x0d,0x04]

v_mullit_f32 v5, v1, -1, v3
// GFX10: encoding: [0x05,0x00,0x50,0xd5,0x01,0x83,0x0d,0x04]

v_mullit_f32 v5, v1, 0.5, v3
// GFX10: encoding: [0x05,0x00,0x50,0xd5,0x01,0xe1,0x0d,0x04]

v_mullit_f32 v5, v1, -4.0, v3
// GFX10: encoding: [0x05,0x00,0x50,0xd5,0x01,0xef,0x0d,0x04]

v_mullit_f32 v5, v1, v2, v255
// GFX10: encoding: [0x05,0x00,0x50,0xd5,0x01,0x05,0xfe,0x07]

v_mullit_f32 v5, v1, v2, s3
// GFX10: encoding: [0x05,0x00,0x50,0xd5,0x01,0x05,0x0e,0x00]

v_mullit_f32 v5, v1, v2, s103
// GFX10: encoding: [0x05,0x00,0x50,0xd5,0x01,0x05,0x9e,0x01]

v_mullit_f32 v5, v1, v2, vcc_lo
// GFX10: encoding: [0x05,0x00,0x50,0xd5,0x01,0x05,0xaa,0x01]

v_mullit_f32 v5, v1, v2, vcc_hi
// GFX10: encoding: [0x05,0x00,0x50,0xd5,0x01,0x05,0xae,0x01]

v_mullit_f32 v5, v1, v2, ttmp11
// GFX10: encoding: [0x05,0x00,0x50,0xd5,0x01,0x05,0xde,0x01]

v_mullit_f32 v5, v1, v2, m0
// GFX10: encoding: [0x05,0x00,0x50,0xd5,0x01,0x05,0xf2,0x01]

v_mullit_f32 v5, v1, v2, exec_lo
// GFX10: encoding: [0x05,0x00,0x50,0xd5,0x01,0x05,0xfa,0x01]

v_mullit_f32 v5, v1, v2, exec_hi
// GFX10: encoding: [0x05,0x00,0x50,0xd5,0x01,0x05,0xfe,0x01]

v_mullit_f32 v5, v1, v2, 0
// GFX10: encoding: [0x05,0x00,0x50,0xd5,0x01,0x05,0x02,0x02]

v_mullit_f32 v5, v1, v2, -1
// GFX10: encoding: [0x05,0x00,0x50,0xd5,0x01,0x05,0x06,0x03]

v_mullit_f32 v5, v1, v2, 0.5
// GFX10: encoding: [0x05,0x00,0x50,0xd5,0x01,0x05,0xc2,0x03]

v_mullit_f32 v5, v1, v2, -4.0
// GFX10: encoding: [0x05,0x00,0x50,0xd5,0x01,0x05,0xde,0x03]

v_mullit_f32 v5, -v1, v2, v3
// GFX10: encoding: [0x05,0x00,0x50,0xd5,0x01,0x05,0x0e,0x24]

v_mullit_f32 v5, v1, -v2, v3
// GFX10: encoding: [0x05,0x00,0x50,0xd5,0x01,0x05,0x0e,0x44]

v_mullit_f32 v5, v1, v2, -v3
// GFX10: encoding: [0x05,0x00,0x50,0xd5,0x01,0x05,0x0e,0x84]

v_mullit_f32 v5, -v1, -v2, -v3
// GFX10: encoding: [0x05,0x00,0x50,0xd5,0x01,0x05,0x0e,0xe4]

v_mullit_f32 v5, |v1|, v2, v3
// GFX10: encoding: [0x05,0x01,0x50,0xd5,0x01,0x05,0x0e,0x04]

v_mullit_f32 v5, v1, |v2|, v3
// GFX10: encoding: [0x05,0x02,0x50,0xd5,0x01,0x05,0x0e,0x04]

v_mullit_f32 v5, v1, v2, |v3|
// GFX10: encoding: [0x05,0x04,0x50,0xd5,0x01,0x05,0x0e,0x04]

v_mullit_f32 v5, |v1|, |v2|, |v3|
// GFX10: encoding: [0x05,0x07,0x50,0xd5,0x01,0x05,0x0e,0x04]

v_mullit_f32 v5, v1, v2, v3 clamp
// GFX10: encoding: [0x05,0x80,0x50,0xd5,0x01,0x05,0x0e,0x04]

v_mullit_f32 v5, v1, v2, v3 mul:2
// GFX10: encoding: [0x05,0x00,0x50,0xd5,0x01,0x05,0x0e,0x0c]

v_mullit_f32 v5, v1, v2, v3 mul:4
// GFX10: encoding: [0x05,0x00,0x50,0xd5,0x01,0x05,0x0e,0x14]

v_mullit_f32 v5, v1, v2, v3 div:2
// GFX10: encoding: [0x05,0x00,0x50,0xd5,0x01,0x05,0x0e,0x1c]

v_min3_f32 v5, v1, v2, v3
// GFX10: encoding: [0x05,0x00,0x51,0xd5,0x01,0x05,0x0e,0x04]

v_min3_f32 v255, v1, v2, v3
// GFX10: encoding: [0xff,0x00,0x51,0xd5,0x01,0x05,0x0e,0x04]

v_min3_f32 v5, v255, v2, v3
// GFX10: encoding: [0x05,0x00,0x51,0xd5,0xff,0x05,0x0e,0x04]

v_min3_f32 v5, s1, v2, v3
// GFX10: encoding: [0x05,0x00,0x51,0xd5,0x01,0x04,0x0e,0x04]

v_min3_f32 v5, s103, v2, v3
// GFX10: encoding: [0x05,0x00,0x51,0xd5,0x67,0x04,0x0e,0x04]

v_min3_f32 v5, vcc_lo, v2, v3
// GFX10: encoding: [0x05,0x00,0x51,0xd5,0x6a,0x04,0x0e,0x04]

v_min3_f32 v5, vcc_hi, v2, v3
// GFX10: encoding: [0x05,0x00,0x51,0xd5,0x6b,0x04,0x0e,0x04]

v_min3_f32 v5, ttmp11, v2, v3
// GFX10: encoding: [0x05,0x00,0x51,0xd5,0x77,0x04,0x0e,0x04]

v_min3_f32 v5, m0, v2, v3
// GFX10: encoding: [0x05,0x00,0x51,0xd5,0x7c,0x04,0x0e,0x04]

v_min3_f32 v5, exec_lo, v2, v3
// GFX10: encoding: [0x05,0x00,0x51,0xd5,0x7e,0x04,0x0e,0x04]

v_min3_f32 v5, exec_hi, v2, v3
// GFX10: encoding: [0x05,0x00,0x51,0xd5,0x7f,0x04,0x0e,0x04]

v_min3_f32 v5, 0, v2, v3
// GFX10: encoding: [0x05,0x00,0x51,0xd5,0x80,0x04,0x0e,0x04]

v_min3_f32 v5, -1, v2, v3
// GFX10: encoding: [0x05,0x00,0x51,0xd5,0xc1,0x04,0x0e,0x04]

v_min3_f32 v5, 0.5, v2, v3
// GFX10: encoding: [0x05,0x00,0x51,0xd5,0xf0,0x04,0x0e,0x04]

v_min3_f32 v5, -4.0, v2, v3
// GFX10: encoding: [0x05,0x00,0x51,0xd5,0xf7,0x04,0x0e,0x04]

v_min3_f32 v5, v1, v255, v3
// GFX10: encoding: [0x05,0x00,0x51,0xd5,0x01,0xff,0x0f,0x04]

v_min3_f32 v5, v1, s2, v3
// GFX10: encoding: [0x05,0x00,0x51,0xd5,0x01,0x05,0x0c,0x04]

v_min3_f32 v5, v1, s103, v3
// GFX10: encoding: [0x05,0x00,0x51,0xd5,0x01,0xcf,0x0c,0x04]

v_min3_f32 v5, v1, vcc_lo, v3
// GFX10: encoding: [0x05,0x00,0x51,0xd5,0x01,0xd5,0x0c,0x04]

v_min3_f32 v5, v1, vcc_hi, v3
// GFX10: encoding: [0x05,0x00,0x51,0xd5,0x01,0xd7,0x0c,0x04]

v_min3_f32 v5, v1, ttmp11, v3
// GFX10: encoding: [0x05,0x00,0x51,0xd5,0x01,0xef,0x0c,0x04]

v_min3_f32 v5, v1, m0, v3
// GFX10: encoding: [0x05,0x00,0x51,0xd5,0x01,0xf9,0x0c,0x04]

v_min3_f32 v5, v1, exec_lo, v3
// GFX10: encoding: [0x05,0x00,0x51,0xd5,0x01,0xfd,0x0c,0x04]

v_min3_f32 v5, v1, exec_hi, v3
// GFX10: encoding: [0x05,0x00,0x51,0xd5,0x01,0xff,0x0c,0x04]

v_min3_f32 v5, v1, 0, v3
// GFX10: encoding: [0x05,0x00,0x51,0xd5,0x01,0x01,0x0d,0x04]

v_min3_f32 v5, v1, -1, v3
// GFX10: encoding: [0x05,0x00,0x51,0xd5,0x01,0x83,0x0d,0x04]

v_min3_f32 v5, v1, 0.5, v3
// GFX10: encoding: [0x05,0x00,0x51,0xd5,0x01,0xe1,0x0d,0x04]

v_min3_f32 v5, v1, -4.0, v3
// GFX10: encoding: [0x05,0x00,0x51,0xd5,0x01,0xef,0x0d,0x04]

v_min3_f32 v5, v1, v2, v255
// GFX10: encoding: [0x05,0x00,0x51,0xd5,0x01,0x05,0xfe,0x07]

v_min3_f32 v5, v1, v2, s3
// GFX10: encoding: [0x05,0x00,0x51,0xd5,0x01,0x05,0x0e,0x00]

v_min3_f32 v5, v1, v2, s103
// GFX10: encoding: [0x05,0x00,0x51,0xd5,0x01,0x05,0x9e,0x01]

v_min3_f32 v5, v1, v2, vcc_lo
// GFX10: encoding: [0x05,0x00,0x51,0xd5,0x01,0x05,0xaa,0x01]

v_min3_f32 v5, v1, v2, vcc_hi
// GFX10: encoding: [0x05,0x00,0x51,0xd5,0x01,0x05,0xae,0x01]

v_min3_f32 v5, v1, v2, ttmp11
// GFX10: encoding: [0x05,0x00,0x51,0xd5,0x01,0x05,0xde,0x01]

v_min3_f32 v5, v1, v2, m0
// GFX10: encoding: [0x05,0x00,0x51,0xd5,0x01,0x05,0xf2,0x01]

v_min3_f32 v5, v1, v2, exec_lo
// GFX10: encoding: [0x05,0x00,0x51,0xd5,0x01,0x05,0xfa,0x01]

v_min3_f32 v5, v1, v2, exec_hi
// GFX10: encoding: [0x05,0x00,0x51,0xd5,0x01,0x05,0xfe,0x01]

v_min3_f32 v5, v1, v2, 0
// GFX10: encoding: [0x05,0x00,0x51,0xd5,0x01,0x05,0x02,0x02]

v_min3_f32 v5, v1, v2, -1
// GFX10: encoding: [0x05,0x00,0x51,0xd5,0x01,0x05,0x06,0x03]

v_min3_f32 v5, v1, v2, 0.5
// GFX10: encoding: [0x05,0x00,0x51,0xd5,0x01,0x05,0xc2,0x03]

v_min3_f32 v5, v1, v2, -4.0
// GFX10: encoding: [0x05,0x00,0x51,0xd5,0x01,0x05,0xde,0x03]

v_min3_f32 v5, -v1, v2, v3
// GFX10: encoding: [0x05,0x00,0x51,0xd5,0x01,0x05,0x0e,0x24]

v_min3_f32 v5, v1, -v2, v3
// GFX10: encoding: [0x05,0x00,0x51,0xd5,0x01,0x05,0x0e,0x44]

v_min3_f32 v5, v1, v2, -v3
// GFX10: encoding: [0x05,0x00,0x51,0xd5,0x01,0x05,0x0e,0x84]

v_min3_f32 v5, -v1, -v2, -v3
// GFX10: encoding: [0x05,0x00,0x51,0xd5,0x01,0x05,0x0e,0xe4]

v_min3_f32 v5, |v1|, v2, v3
// GFX10: encoding: [0x05,0x01,0x51,0xd5,0x01,0x05,0x0e,0x04]

v_min3_f32 v5, v1, |v2|, v3
// GFX10: encoding: [0x05,0x02,0x51,0xd5,0x01,0x05,0x0e,0x04]

v_min3_f32 v5, v1, v2, |v3|
// GFX10: encoding: [0x05,0x04,0x51,0xd5,0x01,0x05,0x0e,0x04]

v_min3_f32 v5, |v1|, |v2|, |v3|
// GFX10: encoding: [0x05,0x07,0x51,0xd5,0x01,0x05,0x0e,0x04]

v_min3_f32 v5, v1, v2, v3 clamp
// GFX10: encoding: [0x05,0x80,0x51,0xd5,0x01,0x05,0x0e,0x04]

v_min3_f32 v5, v1, v2, v3 mul:2
// GFX10: encoding: [0x05,0x00,0x51,0xd5,0x01,0x05,0x0e,0x0c]

v_min3_f32 v5, v1, v2, v3 mul:4
// GFX10: encoding: [0x05,0x00,0x51,0xd5,0x01,0x05,0x0e,0x14]

v_min3_f32 v5, v1, v2, v3 div:2
// GFX10: encoding: [0x05,0x00,0x51,0xd5,0x01,0x05,0x0e,0x1c]

v_min3_i32 v5, v1, v2, v3
// GFX10: encoding: [0x05,0x00,0x52,0xd5,0x01,0x05,0x0e,0x04]

v_min3_i32 v255, v1, v2, v3
// GFX10: encoding: [0xff,0x00,0x52,0xd5,0x01,0x05,0x0e,0x04]

v_min3_i32 v5, v255, v2, v3
// GFX10: encoding: [0x05,0x00,0x52,0xd5,0xff,0x05,0x0e,0x04]

v_min3_i32 v5, s1, v2, v3
// GFX10: encoding: [0x05,0x00,0x52,0xd5,0x01,0x04,0x0e,0x04]

v_min3_i32 v5, s103, v2, v3
// GFX10: encoding: [0x05,0x00,0x52,0xd5,0x67,0x04,0x0e,0x04]

v_min3_i32 v5, vcc_lo, v2, v3
// GFX10: encoding: [0x05,0x00,0x52,0xd5,0x6a,0x04,0x0e,0x04]

v_min3_i32 v5, vcc_hi, v2, v3
// GFX10: encoding: [0x05,0x00,0x52,0xd5,0x6b,0x04,0x0e,0x04]

v_min3_i32 v5, ttmp11, v2, v3
// GFX10: encoding: [0x05,0x00,0x52,0xd5,0x77,0x04,0x0e,0x04]

v_min3_i32 v5, m0, v2, v3
// GFX10: encoding: [0x05,0x00,0x52,0xd5,0x7c,0x04,0x0e,0x04]

v_min3_i32 v5, exec_lo, v2, v3
// GFX10: encoding: [0x05,0x00,0x52,0xd5,0x7e,0x04,0x0e,0x04]

v_min3_i32 v5, exec_hi, v2, v3
// GFX10: encoding: [0x05,0x00,0x52,0xd5,0x7f,0x04,0x0e,0x04]

v_min3_i32 v5, 0, v2, v3
// GFX10: encoding: [0x05,0x00,0x52,0xd5,0x80,0x04,0x0e,0x04]

v_min3_i32 v5, -1, v2, v3
// GFX10: encoding: [0x05,0x00,0x52,0xd5,0xc1,0x04,0x0e,0x04]

v_min3_i32 v5, 0.5, v2, v3
// GFX10: encoding: [0x05,0x00,0x52,0xd5,0xf0,0x04,0x0e,0x04]

v_min3_i32 v5, -4.0, v2, v3
// GFX10: encoding: [0x05,0x00,0x52,0xd5,0xf7,0x04,0x0e,0x04]

v_min3_i32 v5, v1, v255, v3
// GFX10: encoding: [0x05,0x00,0x52,0xd5,0x01,0xff,0x0f,0x04]

v_min3_i32 v5, v1, s2, v3
// GFX10: encoding: [0x05,0x00,0x52,0xd5,0x01,0x05,0x0c,0x04]

v_min3_i32 v5, v1, s103, v3
// GFX10: encoding: [0x05,0x00,0x52,0xd5,0x01,0xcf,0x0c,0x04]

v_min3_i32 v5, v1, vcc_lo, v3
// GFX10: encoding: [0x05,0x00,0x52,0xd5,0x01,0xd5,0x0c,0x04]

v_min3_i32 v5, v1, vcc_hi, v3
// GFX10: encoding: [0x05,0x00,0x52,0xd5,0x01,0xd7,0x0c,0x04]

v_min3_i32 v5, v1, ttmp11, v3
// GFX10: encoding: [0x05,0x00,0x52,0xd5,0x01,0xef,0x0c,0x04]

v_min3_i32 v5, v1, m0, v3
// GFX10: encoding: [0x05,0x00,0x52,0xd5,0x01,0xf9,0x0c,0x04]

v_min3_i32 v5, v1, exec_lo, v3
// GFX10: encoding: [0x05,0x00,0x52,0xd5,0x01,0xfd,0x0c,0x04]

v_min3_i32 v5, v1, exec_hi, v3
// GFX10: encoding: [0x05,0x00,0x52,0xd5,0x01,0xff,0x0c,0x04]

v_min3_i32 v5, v1, 0, v3
// GFX10: encoding: [0x05,0x00,0x52,0xd5,0x01,0x01,0x0d,0x04]

v_min3_i32 v5, v1, -1, v3
// GFX10: encoding: [0x05,0x00,0x52,0xd5,0x01,0x83,0x0d,0x04]

v_min3_i32 v5, v1, 0.5, v3
// GFX10: encoding: [0x05,0x00,0x52,0xd5,0x01,0xe1,0x0d,0x04]

v_min3_i32 v5, v1, -4.0, v3
// GFX10: encoding: [0x05,0x00,0x52,0xd5,0x01,0xef,0x0d,0x04]

v_min3_i32 v5, v1, v2, v255
// GFX10: encoding: [0x05,0x00,0x52,0xd5,0x01,0x05,0xfe,0x07]

v_min3_i32 v5, v1, v2, s3
// GFX10: encoding: [0x05,0x00,0x52,0xd5,0x01,0x05,0x0e,0x00]

v_min3_i32 v5, v1, v2, s103
// GFX10: encoding: [0x05,0x00,0x52,0xd5,0x01,0x05,0x9e,0x01]

v_min3_i32 v5, v1, v2, vcc_lo
// GFX10: encoding: [0x05,0x00,0x52,0xd5,0x01,0x05,0xaa,0x01]

v_min3_i32 v5, v1, v2, vcc_hi
// GFX10: encoding: [0x05,0x00,0x52,0xd5,0x01,0x05,0xae,0x01]

v_min3_i32 v5, v1, v2, ttmp11
// GFX10: encoding: [0x05,0x00,0x52,0xd5,0x01,0x05,0xde,0x01]

v_min3_i32 v5, v1, v2, m0
// GFX10: encoding: [0x05,0x00,0x52,0xd5,0x01,0x05,0xf2,0x01]

v_min3_i32 v5, v1, v2, exec_lo
// GFX10: encoding: [0x05,0x00,0x52,0xd5,0x01,0x05,0xfa,0x01]

v_min3_i32 v5, v1, v2, exec_hi
// GFX10: encoding: [0x05,0x00,0x52,0xd5,0x01,0x05,0xfe,0x01]

v_min3_i32 v5, v1, v2, 0
// GFX10: encoding: [0x05,0x00,0x52,0xd5,0x01,0x05,0x02,0x02]

v_min3_i32 v5, v1, v2, -1
// GFX10: encoding: [0x05,0x00,0x52,0xd5,0x01,0x05,0x06,0x03]

v_min3_i32 v5, v1, v2, 0.5
// GFX10: encoding: [0x05,0x00,0x52,0xd5,0x01,0x05,0xc2,0x03]

v_min3_i32 v5, v1, v2, -4.0
// GFX10: encoding: [0x05,0x00,0x52,0xd5,0x01,0x05,0xde,0x03]

v_min3_u32 v5, v1, v2, v3
// GFX10: encoding: [0x05,0x00,0x53,0xd5,0x01,0x05,0x0e,0x04]

v_min3_u32 v255, v1, v2, v3
// GFX10: encoding: [0xff,0x00,0x53,0xd5,0x01,0x05,0x0e,0x04]

v_min3_u32 v5, v255, v2, v3
// GFX10: encoding: [0x05,0x00,0x53,0xd5,0xff,0x05,0x0e,0x04]

v_min3_u32 v5, s1, v2, v3
// GFX10: encoding: [0x05,0x00,0x53,0xd5,0x01,0x04,0x0e,0x04]

v_min3_u32 v5, s103, v2, v3
// GFX10: encoding: [0x05,0x00,0x53,0xd5,0x67,0x04,0x0e,0x04]

v_min3_u32 v5, vcc_lo, v2, v3
// GFX10: encoding: [0x05,0x00,0x53,0xd5,0x6a,0x04,0x0e,0x04]

v_min3_u32 v5, vcc_hi, v2, v3
// GFX10: encoding: [0x05,0x00,0x53,0xd5,0x6b,0x04,0x0e,0x04]

v_min3_u32 v5, ttmp11, v2, v3
// GFX10: encoding: [0x05,0x00,0x53,0xd5,0x77,0x04,0x0e,0x04]

v_min3_u32 v5, m0, v2, v3
// GFX10: encoding: [0x05,0x00,0x53,0xd5,0x7c,0x04,0x0e,0x04]

v_min3_u32 v5, exec_lo, v2, v3
// GFX10: encoding: [0x05,0x00,0x53,0xd5,0x7e,0x04,0x0e,0x04]

v_min3_u32 v5, exec_hi, v2, v3
// GFX10: encoding: [0x05,0x00,0x53,0xd5,0x7f,0x04,0x0e,0x04]

v_min3_u32 v5, 0, v2, v3
// GFX10: encoding: [0x05,0x00,0x53,0xd5,0x80,0x04,0x0e,0x04]

v_min3_u32 v5, -1, v2, v3
// GFX10: encoding: [0x05,0x00,0x53,0xd5,0xc1,0x04,0x0e,0x04]

v_min3_u32 v5, 0.5, v2, v3
// GFX10: encoding: [0x05,0x00,0x53,0xd5,0xf0,0x04,0x0e,0x04]

v_min3_u32 v5, -4.0, v2, v3
// GFX10: encoding: [0x05,0x00,0x53,0xd5,0xf7,0x04,0x0e,0x04]

v_min3_u32 v5, v1, v255, v3
// GFX10: encoding: [0x05,0x00,0x53,0xd5,0x01,0xff,0x0f,0x04]

v_min3_u32 v5, v1, s2, v3
// GFX10: encoding: [0x05,0x00,0x53,0xd5,0x01,0x05,0x0c,0x04]

v_min3_u32 v5, v1, s103, v3
// GFX10: encoding: [0x05,0x00,0x53,0xd5,0x01,0xcf,0x0c,0x04]

v_min3_u32 v5, v1, vcc_lo, v3
// GFX10: encoding: [0x05,0x00,0x53,0xd5,0x01,0xd5,0x0c,0x04]

v_min3_u32 v5, v1, vcc_hi, v3
// GFX10: encoding: [0x05,0x00,0x53,0xd5,0x01,0xd7,0x0c,0x04]

v_min3_u32 v5, v1, ttmp11, v3
// GFX10: encoding: [0x05,0x00,0x53,0xd5,0x01,0xef,0x0c,0x04]

v_min3_u32 v5, v1, m0, v3
// GFX10: encoding: [0x05,0x00,0x53,0xd5,0x01,0xf9,0x0c,0x04]

v_min3_u32 v5, v1, exec_lo, v3
// GFX10: encoding: [0x05,0x00,0x53,0xd5,0x01,0xfd,0x0c,0x04]

v_min3_u32 v5, v1, exec_hi, v3
// GFX10: encoding: [0x05,0x00,0x53,0xd5,0x01,0xff,0x0c,0x04]

v_min3_u32 v5, v1, 0, v3
// GFX10: encoding: [0x05,0x00,0x53,0xd5,0x01,0x01,0x0d,0x04]

v_min3_u32 v5, v1, -1, v3
// GFX10: encoding: [0x05,0x00,0x53,0xd5,0x01,0x83,0x0d,0x04]

v_min3_u32 v5, v1, 0.5, v3
// GFX10: encoding: [0x05,0x00,0x53,0xd5,0x01,0xe1,0x0d,0x04]

v_min3_u32 v5, v1, -4.0, v3
// GFX10: encoding: [0x05,0x00,0x53,0xd5,0x01,0xef,0x0d,0x04]

v_min3_u32 v5, v1, v2, v255
// GFX10: encoding: [0x05,0x00,0x53,0xd5,0x01,0x05,0xfe,0x07]

v_min3_u32 v5, v1, v2, s3
// GFX10: encoding: [0x05,0x00,0x53,0xd5,0x01,0x05,0x0e,0x00]

v_min3_u32 v5, v1, v2, s103
// GFX10: encoding: [0x05,0x00,0x53,0xd5,0x01,0x05,0x9e,0x01]

v_min3_u32 v5, v1, v2, vcc_lo
// GFX10: encoding: [0x05,0x00,0x53,0xd5,0x01,0x05,0xaa,0x01]

v_min3_u32 v5, v1, v2, vcc_hi
// GFX10: encoding: [0x05,0x00,0x53,0xd5,0x01,0x05,0xae,0x01]

v_min3_u32 v5, v1, v2, ttmp11
// GFX10: encoding: [0x05,0x00,0x53,0xd5,0x01,0x05,0xde,0x01]

v_min3_u32 v5, v1, v2, m0
// GFX10: encoding: [0x05,0x00,0x53,0xd5,0x01,0x05,0xf2,0x01]

v_min3_u32 v5, v1, v2, exec_lo
// GFX10: encoding: [0x05,0x00,0x53,0xd5,0x01,0x05,0xfa,0x01]

v_min3_u32 v5, v1, v2, exec_hi
// GFX10: encoding: [0x05,0x00,0x53,0xd5,0x01,0x05,0xfe,0x01]

v_min3_u32 v5, v1, v2, 0
// GFX10: encoding: [0x05,0x00,0x53,0xd5,0x01,0x05,0x02,0x02]

v_min3_u32 v5, v1, v2, -1
// GFX10: encoding: [0x05,0x00,0x53,0xd5,0x01,0x05,0x06,0x03]

v_min3_u32 v5, v1, v2, 0.5
// GFX10: encoding: [0x05,0x00,0x53,0xd5,0x01,0x05,0xc2,0x03]

v_min3_u32 v5, v1, v2, -4.0
// GFX10: encoding: [0x05,0x00,0x53,0xd5,0x01,0x05,0xde,0x03]

v_max3_f32 v5, v1, v2, v3
// GFX10: encoding: [0x05,0x00,0x54,0xd5,0x01,0x05,0x0e,0x04]

v_max3_f32 v255, v1, v2, v3
// GFX10: encoding: [0xff,0x00,0x54,0xd5,0x01,0x05,0x0e,0x04]

v_max3_f32 v5, v255, v2, v3
// GFX10: encoding: [0x05,0x00,0x54,0xd5,0xff,0x05,0x0e,0x04]

v_max3_f32 v5, s1, v2, v3
// GFX10: encoding: [0x05,0x00,0x54,0xd5,0x01,0x04,0x0e,0x04]

v_max3_f32 v5, s103, v2, v3
// GFX10: encoding: [0x05,0x00,0x54,0xd5,0x67,0x04,0x0e,0x04]

v_max3_f32 v5, vcc_lo, v2, v3
// GFX10: encoding: [0x05,0x00,0x54,0xd5,0x6a,0x04,0x0e,0x04]

v_max3_f32 v5, vcc_hi, v2, v3
// GFX10: encoding: [0x05,0x00,0x54,0xd5,0x6b,0x04,0x0e,0x04]

v_max3_f32 v5, ttmp11, v2, v3
// GFX10: encoding: [0x05,0x00,0x54,0xd5,0x77,0x04,0x0e,0x04]

v_max3_f32 v5, m0, v2, v3
// GFX10: encoding: [0x05,0x00,0x54,0xd5,0x7c,0x04,0x0e,0x04]

v_max3_f32 v5, exec_lo, v2, v3
// GFX10: encoding: [0x05,0x00,0x54,0xd5,0x7e,0x04,0x0e,0x04]

v_max3_f32 v5, exec_hi, v2, v3
// GFX10: encoding: [0x05,0x00,0x54,0xd5,0x7f,0x04,0x0e,0x04]

v_max3_f32 v5, 0, v2, v3
// GFX10: encoding: [0x05,0x00,0x54,0xd5,0x80,0x04,0x0e,0x04]

v_max3_f32 v5, -1, v2, v3
// GFX10: encoding: [0x05,0x00,0x54,0xd5,0xc1,0x04,0x0e,0x04]

v_max3_f32 v5, 0.5, v2, v3
// GFX10: encoding: [0x05,0x00,0x54,0xd5,0xf0,0x04,0x0e,0x04]

v_max3_f32 v5, -4.0, v2, v3
// GFX10: encoding: [0x05,0x00,0x54,0xd5,0xf7,0x04,0x0e,0x04]

v_max3_f32 v5, v1, v255, v3
// GFX10: encoding: [0x05,0x00,0x54,0xd5,0x01,0xff,0x0f,0x04]

v_max3_f32 v5, v1, s2, v3
// GFX10: encoding: [0x05,0x00,0x54,0xd5,0x01,0x05,0x0c,0x04]

v_max3_f32 v5, v1, s103, v3
// GFX10: encoding: [0x05,0x00,0x54,0xd5,0x01,0xcf,0x0c,0x04]

v_max3_f32 v5, v1, vcc_lo, v3
// GFX10: encoding: [0x05,0x00,0x54,0xd5,0x01,0xd5,0x0c,0x04]

v_max3_f32 v5, v1, vcc_hi, v3
// GFX10: encoding: [0x05,0x00,0x54,0xd5,0x01,0xd7,0x0c,0x04]

v_max3_f32 v5, v1, ttmp11, v3
// GFX10: encoding: [0x05,0x00,0x54,0xd5,0x01,0xef,0x0c,0x04]

v_max3_f32 v5, v1, m0, v3
// GFX10: encoding: [0x05,0x00,0x54,0xd5,0x01,0xf9,0x0c,0x04]

v_max3_f32 v5, v1, exec_lo, v3
// GFX10: encoding: [0x05,0x00,0x54,0xd5,0x01,0xfd,0x0c,0x04]

v_max3_f32 v5, v1, exec_hi, v3
// GFX10: encoding: [0x05,0x00,0x54,0xd5,0x01,0xff,0x0c,0x04]

v_max3_f32 v5, v1, 0, v3
// GFX10: encoding: [0x05,0x00,0x54,0xd5,0x01,0x01,0x0d,0x04]

v_max3_f32 v5, v1, -1, v3
// GFX10: encoding: [0x05,0x00,0x54,0xd5,0x01,0x83,0x0d,0x04]

v_max3_f32 v5, v1, 0.5, v3
// GFX10: encoding: [0x05,0x00,0x54,0xd5,0x01,0xe1,0x0d,0x04]

v_max3_f32 v5, v1, -4.0, v3
// GFX10: encoding: [0x05,0x00,0x54,0xd5,0x01,0xef,0x0d,0x04]

v_max3_f32 v5, v1, v2, v255
// GFX10: encoding: [0x05,0x00,0x54,0xd5,0x01,0x05,0xfe,0x07]

v_max3_f32 v5, v1, v2, s3
// GFX10: encoding: [0x05,0x00,0x54,0xd5,0x01,0x05,0x0e,0x00]

v_max3_f32 v5, v1, v2, s103
// GFX10: encoding: [0x05,0x00,0x54,0xd5,0x01,0x05,0x9e,0x01]

v_max3_f32 v5, v1, v2, vcc_lo
// GFX10: encoding: [0x05,0x00,0x54,0xd5,0x01,0x05,0xaa,0x01]

v_max3_f32 v5, v1, v2, vcc_hi
// GFX10: encoding: [0x05,0x00,0x54,0xd5,0x01,0x05,0xae,0x01]

v_max3_f32 v5, v1, v2, ttmp11
// GFX10: encoding: [0x05,0x00,0x54,0xd5,0x01,0x05,0xde,0x01]

v_max3_f32 v5, v1, v2, m0
// GFX10: encoding: [0x05,0x00,0x54,0xd5,0x01,0x05,0xf2,0x01]

v_max3_f32 v5, v1, v2, exec_lo
// GFX10: encoding: [0x05,0x00,0x54,0xd5,0x01,0x05,0xfa,0x01]

v_max3_f32 v5, v1, v2, exec_hi
// GFX10: encoding: [0x05,0x00,0x54,0xd5,0x01,0x05,0xfe,0x01]

v_max3_f32 v5, v1, v2, 0
// GFX10: encoding: [0x05,0x00,0x54,0xd5,0x01,0x05,0x02,0x02]

v_max3_f32 v5, v1, v2, -1
// GFX10: encoding: [0x05,0x00,0x54,0xd5,0x01,0x05,0x06,0x03]

v_max3_f32 v5, v1, v2, 0.5
// GFX10: encoding: [0x05,0x00,0x54,0xd5,0x01,0x05,0xc2,0x03]

v_max3_f32 v5, v1, v2, -4.0
// GFX10: encoding: [0x05,0x00,0x54,0xd5,0x01,0x05,0xde,0x03]

v_max3_f32 v5, -v1, v2, v3
// GFX10: encoding: [0x05,0x00,0x54,0xd5,0x01,0x05,0x0e,0x24]

v_max3_f32 v5, v1, -v2, v3
// GFX10: encoding: [0x05,0x00,0x54,0xd5,0x01,0x05,0x0e,0x44]

v_max3_f32 v5, v1, v2, -v3
// GFX10: encoding: [0x05,0x00,0x54,0xd5,0x01,0x05,0x0e,0x84]

v_max3_f32 v5, -v1, -v2, -v3
// GFX10: encoding: [0x05,0x00,0x54,0xd5,0x01,0x05,0x0e,0xe4]

v_max3_f32 v5, |v1|, v2, v3
// GFX10: encoding: [0x05,0x01,0x54,0xd5,0x01,0x05,0x0e,0x04]

v_max3_f32 v5, v1, |v2|, v3
// GFX10: encoding: [0x05,0x02,0x54,0xd5,0x01,0x05,0x0e,0x04]

v_max3_f32 v5, v1, v2, |v3|
// GFX10: encoding: [0x05,0x04,0x54,0xd5,0x01,0x05,0x0e,0x04]

v_max3_f32 v5, |v1|, |v2|, |v3|
// GFX10: encoding: [0x05,0x07,0x54,0xd5,0x01,0x05,0x0e,0x04]

v_max3_f32 v5, v1, v2, v3 clamp
// GFX10: encoding: [0x05,0x80,0x54,0xd5,0x01,0x05,0x0e,0x04]

v_max3_f32 v5, v1, v2, v3 mul:2
// GFX10: encoding: [0x05,0x00,0x54,0xd5,0x01,0x05,0x0e,0x0c]

v_max3_f32 v5, v1, v2, v3 mul:4
// GFX10: encoding: [0x05,0x00,0x54,0xd5,0x01,0x05,0x0e,0x14]

v_max3_f32 v5, v1, v2, v3 div:2
// GFX10: encoding: [0x05,0x00,0x54,0xd5,0x01,0x05,0x0e,0x1c]

v_max3_i32 v5, v1, v2, v3
// GFX10: encoding: [0x05,0x00,0x55,0xd5,0x01,0x05,0x0e,0x04]

v_max3_i32 v255, v1, v2, v3
// GFX10: encoding: [0xff,0x00,0x55,0xd5,0x01,0x05,0x0e,0x04]

v_max3_i32 v5, v255, v2, v3
// GFX10: encoding: [0x05,0x00,0x55,0xd5,0xff,0x05,0x0e,0x04]

v_max3_i32 v5, s1, v2, v3
// GFX10: encoding: [0x05,0x00,0x55,0xd5,0x01,0x04,0x0e,0x04]

v_max3_i32 v5, s103, v2, v3
// GFX10: encoding: [0x05,0x00,0x55,0xd5,0x67,0x04,0x0e,0x04]

v_max3_i32 v5, vcc_lo, v2, v3
// GFX10: encoding: [0x05,0x00,0x55,0xd5,0x6a,0x04,0x0e,0x04]

v_max3_i32 v5, vcc_hi, v2, v3
// GFX10: encoding: [0x05,0x00,0x55,0xd5,0x6b,0x04,0x0e,0x04]

v_max3_i32 v5, ttmp11, v2, v3
// GFX10: encoding: [0x05,0x00,0x55,0xd5,0x77,0x04,0x0e,0x04]

v_max3_i32 v5, m0, v2, v3
// GFX10: encoding: [0x05,0x00,0x55,0xd5,0x7c,0x04,0x0e,0x04]

v_max3_i32 v5, exec_lo, v2, v3
// GFX10: encoding: [0x05,0x00,0x55,0xd5,0x7e,0x04,0x0e,0x04]

v_max3_i32 v5, exec_hi, v2, v3
// GFX10: encoding: [0x05,0x00,0x55,0xd5,0x7f,0x04,0x0e,0x04]

v_max3_i32 v5, 0, v2, v3
// GFX10: encoding: [0x05,0x00,0x55,0xd5,0x80,0x04,0x0e,0x04]

v_max3_i32 v5, -1, v2, v3
// GFX10: encoding: [0x05,0x00,0x55,0xd5,0xc1,0x04,0x0e,0x04]

v_max3_i32 v5, 0.5, v2, v3
// GFX10: encoding: [0x05,0x00,0x55,0xd5,0xf0,0x04,0x0e,0x04]

v_max3_i32 v5, -4.0, v2, v3
// GFX10: encoding: [0x05,0x00,0x55,0xd5,0xf7,0x04,0x0e,0x04]

v_max3_i32 v5, v1, v255, v3
// GFX10: encoding: [0x05,0x00,0x55,0xd5,0x01,0xff,0x0f,0x04]

v_max3_i32 v5, v1, s2, v3
// GFX10: encoding: [0x05,0x00,0x55,0xd5,0x01,0x05,0x0c,0x04]

v_max3_i32 v5, v1, s103, v3
// GFX10: encoding: [0x05,0x00,0x55,0xd5,0x01,0xcf,0x0c,0x04]

v_max3_i32 v5, v1, vcc_lo, v3
// GFX10: encoding: [0x05,0x00,0x55,0xd5,0x01,0xd5,0x0c,0x04]

v_max3_i32 v5, v1, vcc_hi, v3
// GFX10: encoding: [0x05,0x00,0x55,0xd5,0x01,0xd7,0x0c,0x04]

v_max3_i32 v5, v1, ttmp11, v3
// GFX10: encoding: [0x05,0x00,0x55,0xd5,0x01,0xef,0x0c,0x04]

v_max3_i32 v5, v1, m0, v3
// GFX10: encoding: [0x05,0x00,0x55,0xd5,0x01,0xf9,0x0c,0x04]

v_max3_i32 v5, v1, exec_lo, v3
// GFX10: encoding: [0x05,0x00,0x55,0xd5,0x01,0xfd,0x0c,0x04]

v_max3_i32 v5, v1, exec_hi, v3
// GFX10: encoding: [0x05,0x00,0x55,0xd5,0x01,0xff,0x0c,0x04]

v_max3_i32 v5, v1, 0, v3
// GFX10: encoding: [0x05,0x00,0x55,0xd5,0x01,0x01,0x0d,0x04]

v_max3_i32 v5, v1, -1, v3
// GFX10: encoding: [0x05,0x00,0x55,0xd5,0x01,0x83,0x0d,0x04]

v_max3_i32 v5, v1, 0.5, v3
// GFX10: encoding: [0x05,0x00,0x55,0xd5,0x01,0xe1,0x0d,0x04]

v_max3_i32 v5, v1, -4.0, v3
// GFX10: encoding: [0x05,0x00,0x55,0xd5,0x01,0xef,0x0d,0x04]

v_max3_i32 v5, v1, v2, v255
// GFX10: encoding: [0x05,0x00,0x55,0xd5,0x01,0x05,0xfe,0x07]

v_max3_i32 v5, v1, v2, s3
// GFX10: encoding: [0x05,0x00,0x55,0xd5,0x01,0x05,0x0e,0x00]

v_max3_i32 v5, v1, v2, s103
// GFX10: encoding: [0x05,0x00,0x55,0xd5,0x01,0x05,0x9e,0x01]

v_max3_i32 v5, v1, v2, vcc_lo
// GFX10: encoding: [0x05,0x00,0x55,0xd5,0x01,0x05,0xaa,0x01]

v_max3_i32 v5, v1, v2, vcc_hi
// GFX10: encoding: [0x05,0x00,0x55,0xd5,0x01,0x05,0xae,0x01]

v_max3_i32 v5, v1, v2, ttmp11
// GFX10: encoding: [0x05,0x00,0x55,0xd5,0x01,0x05,0xde,0x01]

v_max3_i32 v5, v1, v2, m0
// GFX10: encoding: [0x05,0x00,0x55,0xd5,0x01,0x05,0xf2,0x01]

v_max3_i32 v5, v1, v2, exec_lo
// GFX10: encoding: [0x05,0x00,0x55,0xd5,0x01,0x05,0xfa,0x01]

v_max3_i32 v5, v1, v2, exec_hi
// GFX10: encoding: [0x05,0x00,0x55,0xd5,0x01,0x05,0xfe,0x01]

v_max3_i32 v5, v1, v2, 0
// GFX10: encoding: [0x05,0x00,0x55,0xd5,0x01,0x05,0x02,0x02]

v_max3_i32 v5, v1, v2, -1
// GFX10: encoding: [0x05,0x00,0x55,0xd5,0x01,0x05,0x06,0x03]

v_max3_i32 v5, v1, v2, 0.5
// GFX10: encoding: [0x05,0x00,0x55,0xd5,0x01,0x05,0xc2,0x03]

v_max3_i32 v5, v1, v2, -4.0
// GFX10: encoding: [0x05,0x00,0x55,0xd5,0x01,0x05,0xde,0x03]

v_max3_u32 v5, v1, v2, v3
// GFX10: encoding: [0x05,0x00,0x56,0xd5,0x01,0x05,0x0e,0x04]

v_max3_u32 v255, v1, v2, v3
// GFX10: encoding: [0xff,0x00,0x56,0xd5,0x01,0x05,0x0e,0x04]

v_max3_u32 v5, v255, v2, v3
// GFX10: encoding: [0x05,0x00,0x56,0xd5,0xff,0x05,0x0e,0x04]

v_max3_u32 v5, s1, v2, v3
// GFX10: encoding: [0x05,0x00,0x56,0xd5,0x01,0x04,0x0e,0x04]

v_max3_u32 v5, s103, v2, v3
// GFX10: encoding: [0x05,0x00,0x56,0xd5,0x67,0x04,0x0e,0x04]

v_max3_u32 v5, vcc_lo, v2, v3
// GFX10: encoding: [0x05,0x00,0x56,0xd5,0x6a,0x04,0x0e,0x04]

v_max3_u32 v5, vcc_hi, v2, v3
// GFX10: encoding: [0x05,0x00,0x56,0xd5,0x6b,0x04,0x0e,0x04]

v_max3_u32 v5, ttmp11, v2, v3
// GFX10: encoding: [0x05,0x00,0x56,0xd5,0x77,0x04,0x0e,0x04]

v_max3_u32 v5, m0, v2, v3
// GFX10: encoding: [0x05,0x00,0x56,0xd5,0x7c,0x04,0x0e,0x04]

v_max3_u32 v5, exec_lo, v2, v3
// GFX10: encoding: [0x05,0x00,0x56,0xd5,0x7e,0x04,0x0e,0x04]

v_max3_u32 v5, exec_hi, v2, v3
// GFX10: encoding: [0x05,0x00,0x56,0xd5,0x7f,0x04,0x0e,0x04]

v_max3_u32 v5, 0, v2, v3
// GFX10: encoding: [0x05,0x00,0x56,0xd5,0x80,0x04,0x0e,0x04]

v_max3_u32 v5, -1, v2, v3
// GFX10: encoding: [0x05,0x00,0x56,0xd5,0xc1,0x04,0x0e,0x04]

v_max3_u32 v5, 0.5, v2, v3
// GFX10: encoding: [0x05,0x00,0x56,0xd5,0xf0,0x04,0x0e,0x04]

v_max3_u32 v5, -4.0, v2, v3
// GFX10: encoding: [0x05,0x00,0x56,0xd5,0xf7,0x04,0x0e,0x04]

v_max3_u32 v5, v1, v255, v3
// GFX10: encoding: [0x05,0x00,0x56,0xd5,0x01,0xff,0x0f,0x04]

v_max3_u32 v5, v1, s2, v3
// GFX10: encoding: [0x05,0x00,0x56,0xd5,0x01,0x05,0x0c,0x04]

v_max3_u32 v5, v1, s103, v3
// GFX10: encoding: [0x05,0x00,0x56,0xd5,0x01,0xcf,0x0c,0x04]

v_max3_u32 v5, v1, vcc_lo, v3
// GFX10: encoding: [0x05,0x00,0x56,0xd5,0x01,0xd5,0x0c,0x04]

v_max3_u32 v5, v1, vcc_hi, v3
// GFX10: encoding: [0x05,0x00,0x56,0xd5,0x01,0xd7,0x0c,0x04]

v_max3_u32 v5, v1, ttmp11, v3
// GFX10: encoding: [0x05,0x00,0x56,0xd5,0x01,0xef,0x0c,0x04]

v_max3_u32 v5, v1, m0, v3
// GFX10: encoding: [0x05,0x00,0x56,0xd5,0x01,0xf9,0x0c,0x04]

v_max3_u32 v5, v1, exec_lo, v3
// GFX10: encoding: [0x05,0x00,0x56,0xd5,0x01,0xfd,0x0c,0x04]

v_max3_u32 v5, v1, exec_hi, v3
// GFX10: encoding: [0x05,0x00,0x56,0xd5,0x01,0xff,0x0c,0x04]

v_max3_u32 v5, v1, 0, v3
// GFX10: encoding: [0x05,0x00,0x56,0xd5,0x01,0x01,0x0d,0x04]

v_max3_u32 v5, v1, -1, v3
// GFX10: encoding: [0x05,0x00,0x56,0xd5,0x01,0x83,0x0d,0x04]

v_max3_u32 v5, v1, 0.5, v3
// GFX10: encoding: [0x05,0x00,0x56,0xd5,0x01,0xe1,0x0d,0x04]

v_max3_u32 v5, v1, -4.0, v3
// GFX10: encoding: [0x05,0x00,0x56,0xd5,0x01,0xef,0x0d,0x04]

v_max3_u32 v5, v1, v2, v255
// GFX10: encoding: [0x05,0x00,0x56,0xd5,0x01,0x05,0xfe,0x07]

v_max3_u32 v5, v1, v2, s3
// GFX10: encoding: [0x05,0x00,0x56,0xd5,0x01,0x05,0x0e,0x00]

v_max3_u32 v5, v1, v2, s103
// GFX10: encoding: [0x05,0x00,0x56,0xd5,0x01,0x05,0x9e,0x01]

v_max3_u32 v5, v1, v2, vcc_lo
// GFX10: encoding: [0x05,0x00,0x56,0xd5,0x01,0x05,0xaa,0x01]

v_max3_u32 v5, v1, v2, vcc_hi
// GFX10: encoding: [0x05,0x00,0x56,0xd5,0x01,0x05,0xae,0x01]

v_max3_u32 v5, v1, v2, ttmp11
// GFX10: encoding: [0x05,0x00,0x56,0xd5,0x01,0x05,0xde,0x01]

v_max3_u32 v5, v1, v2, m0
// GFX10: encoding: [0x05,0x00,0x56,0xd5,0x01,0x05,0xf2,0x01]

v_max3_u32 v5, v1, v2, exec_lo
// GFX10: encoding: [0x05,0x00,0x56,0xd5,0x01,0x05,0xfa,0x01]

v_max3_u32 v5, v1, v2, exec_hi
// GFX10: encoding: [0x05,0x00,0x56,0xd5,0x01,0x05,0xfe,0x01]

v_max3_u32 v5, v1, v2, 0
// GFX10: encoding: [0x05,0x00,0x56,0xd5,0x01,0x05,0x02,0x02]

v_max3_u32 v5, v1, v2, -1
// GFX10: encoding: [0x05,0x00,0x56,0xd5,0x01,0x05,0x06,0x03]

v_max3_u32 v5, v1, v2, 0.5
// GFX10: encoding: [0x05,0x00,0x56,0xd5,0x01,0x05,0xc2,0x03]

v_max3_u32 v5, v1, v2, -4.0
// GFX10: encoding: [0x05,0x00,0x56,0xd5,0x01,0x05,0xde,0x03]

v_med3_f32 v5, v1, v2, v3
// GFX10: encoding: [0x05,0x00,0x57,0xd5,0x01,0x05,0x0e,0x04]

v_med3_f32 v255, v1, v2, v3
// GFX10: encoding: [0xff,0x00,0x57,0xd5,0x01,0x05,0x0e,0x04]

v_med3_f32 v5, v255, v2, v3
// GFX10: encoding: [0x05,0x00,0x57,0xd5,0xff,0x05,0x0e,0x04]

v_med3_f32 v5, s1, v2, v3
// GFX10: encoding: [0x05,0x00,0x57,0xd5,0x01,0x04,0x0e,0x04]

v_med3_f32 v5, s103, v2, v3
// GFX10: encoding: [0x05,0x00,0x57,0xd5,0x67,0x04,0x0e,0x04]

v_med3_f32 v5, vcc_lo, v2, v3
// GFX10: encoding: [0x05,0x00,0x57,0xd5,0x6a,0x04,0x0e,0x04]

v_med3_f32 v5, vcc_hi, v2, v3
// GFX10: encoding: [0x05,0x00,0x57,0xd5,0x6b,0x04,0x0e,0x04]

v_med3_f32 v5, ttmp11, v2, v3
// GFX10: encoding: [0x05,0x00,0x57,0xd5,0x77,0x04,0x0e,0x04]

v_med3_f32 v5, m0, v2, v3
// GFX10: encoding: [0x05,0x00,0x57,0xd5,0x7c,0x04,0x0e,0x04]

v_med3_f32 v5, exec_lo, v2, v3
// GFX10: encoding: [0x05,0x00,0x57,0xd5,0x7e,0x04,0x0e,0x04]

v_med3_f32 v5, exec_hi, v2, v3
// GFX10: encoding: [0x05,0x00,0x57,0xd5,0x7f,0x04,0x0e,0x04]

v_med3_f32 v5, 0, v2, v3
// GFX10: encoding: [0x05,0x00,0x57,0xd5,0x80,0x04,0x0e,0x04]

v_med3_f32 v5, -1, v2, v3
// GFX10: encoding: [0x05,0x00,0x57,0xd5,0xc1,0x04,0x0e,0x04]

v_med3_f32 v5, 0.5, v2, v3
// GFX10: encoding: [0x05,0x00,0x57,0xd5,0xf0,0x04,0x0e,0x04]

v_med3_f32 v5, -4.0, v2, v3
// GFX10: encoding: [0x05,0x00,0x57,0xd5,0xf7,0x04,0x0e,0x04]

v_med3_f32 v5, v1, v255, v3
// GFX10: encoding: [0x05,0x00,0x57,0xd5,0x01,0xff,0x0f,0x04]

v_med3_f32 v5, v1, s2, v3
// GFX10: encoding: [0x05,0x00,0x57,0xd5,0x01,0x05,0x0c,0x04]

v_med3_f32 v5, v1, s103, v3
// GFX10: encoding: [0x05,0x00,0x57,0xd5,0x01,0xcf,0x0c,0x04]

v_med3_f32 v5, v1, vcc_lo, v3
// GFX10: encoding: [0x05,0x00,0x57,0xd5,0x01,0xd5,0x0c,0x04]

v_med3_f32 v5, v1, vcc_hi, v3
// GFX10: encoding: [0x05,0x00,0x57,0xd5,0x01,0xd7,0x0c,0x04]

v_med3_f32 v5, v1, ttmp11, v3
// GFX10: encoding: [0x05,0x00,0x57,0xd5,0x01,0xef,0x0c,0x04]

v_med3_f32 v5, v1, m0, v3
// GFX10: encoding: [0x05,0x00,0x57,0xd5,0x01,0xf9,0x0c,0x04]

v_med3_f32 v5, v1, exec_lo, v3
// GFX10: encoding: [0x05,0x00,0x57,0xd5,0x01,0xfd,0x0c,0x04]

v_med3_f32 v5, v1, exec_hi, v3
// GFX10: encoding: [0x05,0x00,0x57,0xd5,0x01,0xff,0x0c,0x04]

v_med3_f32 v5, v1, 0, v3
// GFX10: encoding: [0x05,0x00,0x57,0xd5,0x01,0x01,0x0d,0x04]

v_med3_f32 v5, v1, -1, v3
// GFX10: encoding: [0x05,0x00,0x57,0xd5,0x01,0x83,0x0d,0x04]

v_med3_f32 v5, v1, 0.5, v3
// GFX10: encoding: [0x05,0x00,0x57,0xd5,0x01,0xe1,0x0d,0x04]

v_med3_f32 v5, v1, -4.0, v3
// GFX10: encoding: [0x05,0x00,0x57,0xd5,0x01,0xef,0x0d,0x04]

v_med3_f32 v5, v1, v2, v255
// GFX10: encoding: [0x05,0x00,0x57,0xd5,0x01,0x05,0xfe,0x07]

v_med3_f32 v5, v1, v2, s3
// GFX10: encoding: [0x05,0x00,0x57,0xd5,0x01,0x05,0x0e,0x00]

v_med3_f32 v5, v1, v2, s103
// GFX10: encoding: [0x05,0x00,0x57,0xd5,0x01,0x05,0x9e,0x01]

v_med3_f32 v5, v1, v2, vcc_lo
// GFX10: encoding: [0x05,0x00,0x57,0xd5,0x01,0x05,0xaa,0x01]

v_med3_f32 v5, v1, v2, vcc_hi
// GFX10: encoding: [0x05,0x00,0x57,0xd5,0x01,0x05,0xae,0x01]

v_med3_f32 v5, v1, v2, ttmp11
// GFX10: encoding: [0x05,0x00,0x57,0xd5,0x01,0x05,0xde,0x01]

v_med3_f32 v5, v1, v2, m0
// GFX10: encoding: [0x05,0x00,0x57,0xd5,0x01,0x05,0xf2,0x01]

v_med3_f32 v5, v1, v2, exec_lo
// GFX10: encoding: [0x05,0x00,0x57,0xd5,0x01,0x05,0xfa,0x01]

v_med3_f32 v5, v1, v2, exec_hi
// GFX10: encoding: [0x05,0x00,0x57,0xd5,0x01,0x05,0xfe,0x01]

v_med3_f32 v5, v1, v2, 0
// GFX10: encoding: [0x05,0x00,0x57,0xd5,0x01,0x05,0x02,0x02]

v_med3_f32 v5, v1, v2, -1
// GFX10: encoding: [0x05,0x00,0x57,0xd5,0x01,0x05,0x06,0x03]

v_med3_f32 v5, v1, v2, 0.5
// GFX10: encoding: [0x05,0x00,0x57,0xd5,0x01,0x05,0xc2,0x03]

v_med3_f32 v5, v1, v2, -4.0
// GFX10: encoding: [0x05,0x00,0x57,0xd5,0x01,0x05,0xde,0x03]

v_med3_f32 v5, -v1, v2, v3
// GFX10: encoding: [0x05,0x00,0x57,0xd5,0x01,0x05,0x0e,0x24]

v_med3_f32 v5, v1, -v2, v3
// GFX10: encoding: [0x05,0x00,0x57,0xd5,0x01,0x05,0x0e,0x44]

v_med3_f32 v5, v1, v2, -v3
// GFX10: encoding: [0x05,0x00,0x57,0xd5,0x01,0x05,0x0e,0x84]

v_med3_f32 v5, -v1, -v2, -v3
// GFX10: encoding: [0x05,0x00,0x57,0xd5,0x01,0x05,0x0e,0xe4]

v_med3_f32 v5, |v1|, v2, v3
// GFX10: encoding: [0x05,0x01,0x57,0xd5,0x01,0x05,0x0e,0x04]

v_med3_f32 v5, v1, |v2|, v3
// GFX10: encoding: [0x05,0x02,0x57,0xd5,0x01,0x05,0x0e,0x04]

v_med3_f32 v5, v1, v2, |v3|
// GFX10: encoding: [0x05,0x04,0x57,0xd5,0x01,0x05,0x0e,0x04]

v_med3_f32 v5, |v1|, |v2|, |v3|
// GFX10: encoding: [0x05,0x07,0x57,0xd5,0x01,0x05,0x0e,0x04]

v_med3_f32 v5, v1, v2, v3 clamp
// GFX10: encoding: [0x05,0x80,0x57,0xd5,0x01,0x05,0x0e,0x04]

v_med3_f32 v5, v1, v2, v3 mul:2
// GFX10: encoding: [0x05,0x00,0x57,0xd5,0x01,0x05,0x0e,0x0c]

v_med3_f32 v5, v1, v2, v3 mul:4
// GFX10: encoding: [0x05,0x00,0x57,0xd5,0x01,0x05,0x0e,0x14]

v_med3_f32 v5, v1, v2, v3 div:2
// GFX10: encoding: [0x05,0x00,0x57,0xd5,0x01,0x05,0x0e,0x1c]

v_med3_i32 v5, v1, v2, v3
// GFX10: encoding: [0x05,0x00,0x58,0xd5,0x01,0x05,0x0e,0x04]

v_med3_i32 v255, v1, v2, v3
// GFX10: encoding: [0xff,0x00,0x58,0xd5,0x01,0x05,0x0e,0x04]

v_med3_i32 v5, v255, v2, v3
// GFX10: encoding: [0x05,0x00,0x58,0xd5,0xff,0x05,0x0e,0x04]

v_med3_i32 v5, s1, v2, v3
// GFX10: encoding: [0x05,0x00,0x58,0xd5,0x01,0x04,0x0e,0x04]

v_med3_i32 v5, s103, v2, v3
// GFX10: encoding: [0x05,0x00,0x58,0xd5,0x67,0x04,0x0e,0x04]

v_med3_i32 v5, vcc_lo, v2, v3
// GFX10: encoding: [0x05,0x00,0x58,0xd5,0x6a,0x04,0x0e,0x04]

v_med3_i32 v5, vcc_hi, v2, v3
// GFX10: encoding: [0x05,0x00,0x58,0xd5,0x6b,0x04,0x0e,0x04]

v_med3_i32 v5, ttmp11, v2, v3
// GFX10: encoding: [0x05,0x00,0x58,0xd5,0x77,0x04,0x0e,0x04]

v_med3_i32 v5, m0, v2, v3
// GFX10: encoding: [0x05,0x00,0x58,0xd5,0x7c,0x04,0x0e,0x04]

v_med3_i32 v5, exec_lo, v2, v3
// GFX10: encoding: [0x05,0x00,0x58,0xd5,0x7e,0x04,0x0e,0x04]

v_med3_i32 v5, exec_hi, v2, v3
// GFX10: encoding: [0x05,0x00,0x58,0xd5,0x7f,0x04,0x0e,0x04]

v_med3_i32 v5, 0, v2, v3
// GFX10: encoding: [0x05,0x00,0x58,0xd5,0x80,0x04,0x0e,0x04]

v_med3_i32 v5, -1, v2, v3
// GFX10: encoding: [0x05,0x00,0x58,0xd5,0xc1,0x04,0x0e,0x04]

v_med3_i32 v5, 0.5, v2, v3
// GFX10: encoding: [0x05,0x00,0x58,0xd5,0xf0,0x04,0x0e,0x04]

v_med3_i32 v5, -4.0, v2, v3
// GFX10: encoding: [0x05,0x00,0x58,0xd5,0xf7,0x04,0x0e,0x04]

v_med3_i32 v5, v1, v255, v3
// GFX10: encoding: [0x05,0x00,0x58,0xd5,0x01,0xff,0x0f,0x04]

v_med3_i32 v5, v1, s2, v3
// GFX10: encoding: [0x05,0x00,0x58,0xd5,0x01,0x05,0x0c,0x04]

v_med3_i32 v5, v1, s103, v3
// GFX10: encoding: [0x05,0x00,0x58,0xd5,0x01,0xcf,0x0c,0x04]

v_med3_i32 v5, v1, vcc_lo, v3
// GFX10: encoding: [0x05,0x00,0x58,0xd5,0x01,0xd5,0x0c,0x04]

v_med3_i32 v5, v1, vcc_hi, v3
// GFX10: encoding: [0x05,0x00,0x58,0xd5,0x01,0xd7,0x0c,0x04]

v_med3_i32 v5, v1, ttmp11, v3
// GFX10: encoding: [0x05,0x00,0x58,0xd5,0x01,0xef,0x0c,0x04]

v_med3_i32 v5, v1, m0, v3
// GFX10: encoding: [0x05,0x00,0x58,0xd5,0x01,0xf9,0x0c,0x04]

v_med3_i32 v5, v1, exec_lo, v3
// GFX10: encoding: [0x05,0x00,0x58,0xd5,0x01,0xfd,0x0c,0x04]

v_med3_i32 v5, v1, exec_hi, v3
// GFX10: encoding: [0x05,0x00,0x58,0xd5,0x01,0xff,0x0c,0x04]

v_med3_i32 v5, v1, 0, v3
// GFX10: encoding: [0x05,0x00,0x58,0xd5,0x01,0x01,0x0d,0x04]

v_med3_i32 v5, v1, -1, v3
// GFX10: encoding: [0x05,0x00,0x58,0xd5,0x01,0x83,0x0d,0x04]

v_med3_i32 v5, v1, 0.5, v3
// GFX10: encoding: [0x05,0x00,0x58,0xd5,0x01,0xe1,0x0d,0x04]

v_med3_i32 v5, v1, -4.0, v3
// GFX10: encoding: [0x05,0x00,0x58,0xd5,0x01,0xef,0x0d,0x04]

v_med3_i32 v5, v1, v2, v255
// GFX10: encoding: [0x05,0x00,0x58,0xd5,0x01,0x05,0xfe,0x07]

v_med3_i32 v5, v1, v2, s3
// GFX10: encoding: [0x05,0x00,0x58,0xd5,0x01,0x05,0x0e,0x00]

v_med3_i32 v5, v1, v2, s103
// GFX10: encoding: [0x05,0x00,0x58,0xd5,0x01,0x05,0x9e,0x01]

v_med3_i32 v5, v1, v2, vcc_lo
// GFX10: encoding: [0x05,0x00,0x58,0xd5,0x01,0x05,0xaa,0x01]

v_med3_i32 v5, v1, v2, vcc_hi
// GFX10: encoding: [0x05,0x00,0x58,0xd5,0x01,0x05,0xae,0x01]

v_med3_i32 v5, v1, v2, ttmp11
// GFX10: encoding: [0x05,0x00,0x58,0xd5,0x01,0x05,0xde,0x01]

v_med3_i32 v5, v1, v2, m0
// GFX10: encoding: [0x05,0x00,0x58,0xd5,0x01,0x05,0xf2,0x01]

v_med3_i32 v5, v1, v2, exec_lo
// GFX10: encoding: [0x05,0x00,0x58,0xd5,0x01,0x05,0xfa,0x01]

v_med3_i32 v5, v1, v2, exec_hi
// GFX10: encoding: [0x05,0x00,0x58,0xd5,0x01,0x05,0xfe,0x01]

v_med3_i32 v5, v1, v2, 0
// GFX10: encoding: [0x05,0x00,0x58,0xd5,0x01,0x05,0x02,0x02]

v_med3_i32 v5, v1, v2, -1
// GFX10: encoding: [0x05,0x00,0x58,0xd5,0x01,0x05,0x06,0x03]

v_med3_i32 v5, v1, v2, 0.5
// GFX10: encoding: [0x05,0x00,0x58,0xd5,0x01,0x05,0xc2,0x03]

v_med3_i32 v5, v1, v2, -4.0
// GFX10: encoding: [0x05,0x00,0x58,0xd5,0x01,0x05,0xde,0x03]

v_med3_u32 v5, v1, v2, v3
// GFX10: encoding: [0x05,0x00,0x59,0xd5,0x01,0x05,0x0e,0x04]

v_med3_u32 v255, v1, v2, v3
// GFX10: encoding: [0xff,0x00,0x59,0xd5,0x01,0x05,0x0e,0x04]

v_med3_u32 v5, v255, v2, v3
// GFX10: encoding: [0x05,0x00,0x59,0xd5,0xff,0x05,0x0e,0x04]

v_med3_u32 v5, s1, v2, v3
// GFX10: encoding: [0x05,0x00,0x59,0xd5,0x01,0x04,0x0e,0x04]

v_med3_u32 v5, s103, v2, v3
// GFX10: encoding: [0x05,0x00,0x59,0xd5,0x67,0x04,0x0e,0x04]

v_med3_u32 v5, vcc_lo, v2, v3
// GFX10: encoding: [0x05,0x00,0x59,0xd5,0x6a,0x04,0x0e,0x04]

v_med3_u32 v5, vcc_hi, v2, v3
// GFX10: encoding: [0x05,0x00,0x59,0xd5,0x6b,0x04,0x0e,0x04]

v_med3_u32 v5, ttmp11, v2, v3
// GFX10: encoding: [0x05,0x00,0x59,0xd5,0x77,0x04,0x0e,0x04]

v_med3_u32 v5, m0, v2, v3
// GFX10: encoding: [0x05,0x00,0x59,0xd5,0x7c,0x04,0x0e,0x04]

v_med3_u32 v5, exec_lo, v2, v3
// GFX10: encoding: [0x05,0x00,0x59,0xd5,0x7e,0x04,0x0e,0x04]

v_med3_u32 v5, exec_hi, v2, v3
// GFX10: encoding: [0x05,0x00,0x59,0xd5,0x7f,0x04,0x0e,0x04]

v_med3_u32 v5, 0, v2, v3
// GFX10: encoding: [0x05,0x00,0x59,0xd5,0x80,0x04,0x0e,0x04]

v_med3_u32 v5, -1, v2, v3
// GFX10: encoding: [0x05,0x00,0x59,0xd5,0xc1,0x04,0x0e,0x04]

v_med3_u32 v5, 0.5, v2, v3
// GFX10: encoding: [0x05,0x00,0x59,0xd5,0xf0,0x04,0x0e,0x04]

v_med3_u32 v5, -4.0, v2, v3
// GFX10: encoding: [0x05,0x00,0x59,0xd5,0xf7,0x04,0x0e,0x04]

v_med3_u32 v5, v1, v255, v3
// GFX10: encoding: [0x05,0x00,0x59,0xd5,0x01,0xff,0x0f,0x04]

v_med3_u32 v5, v1, s2, v3
// GFX10: encoding: [0x05,0x00,0x59,0xd5,0x01,0x05,0x0c,0x04]

v_med3_u32 v5, v1, s103, v3
// GFX10: encoding: [0x05,0x00,0x59,0xd5,0x01,0xcf,0x0c,0x04]

v_med3_u32 v5, v1, vcc_lo, v3
// GFX10: encoding: [0x05,0x00,0x59,0xd5,0x01,0xd5,0x0c,0x04]

v_med3_u32 v5, v1, vcc_hi, v3
// GFX10: encoding: [0x05,0x00,0x59,0xd5,0x01,0xd7,0x0c,0x04]

v_med3_u32 v5, v1, ttmp11, v3
// GFX10: encoding: [0x05,0x00,0x59,0xd5,0x01,0xef,0x0c,0x04]

v_med3_u32 v5, v1, m0, v3
// GFX10: encoding: [0x05,0x00,0x59,0xd5,0x01,0xf9,0x0c,0x04]

v_med3_u32 v5, v1, exec_lo, v3
// GFX10: encoding: [0x05,0x00,0x59,0xd5,0x01,0xfd,0x0c,0x04]

v_med3_u32 v5, v1, exec_hi, v3
// GFX10: encoding: [0x05,0x00,0x59,0xd5,0x01,0xff,0x0c,0x04]

v_med3_u32 v5, v1, 0, v3
// GFX10: encoding: [0x05,0x00,0x59,0xd5,0x01,0x01,0x0d,0x04]

v_med3_u32 v5, v1, -1, v3
// GFX10: encoding: [0x05,0x00,0x59,0xd5,0x01,0x83,0x0d,0x04]

v_med3_u32 v5, v1, 0.5, v3
// GFX10: encoding: [0x05,0x00,0x59,0xd5,0x01,0xe1,0x0d,0x04]

v_med3_u32 v5, v1, -4.0, v3
// GFX10: encoding: [0x05,0x00,0x59,0xd5,0x01,0xef,0x0d,0x04]

v_med3_u32 v5, v1, v2, v255
// GFX10: encoding: [0x05,0x00,0x59,0xd5,0x01,0x05,0xfe,0x07]

v_med3_u32 v5, v1, v2, s3
// GFX10: encoding: [0x05,0x00,0x59,0xd5,0x01,0x05,0x0e,0x00]

v_med3_u32 v5, v1, v2, s103
// GFX10: encoding: [0x05,0x00,0x59,0xd5,0x01,0x05,0x9e,0x01]

v_med3_u32 v5, v1, v2, vcc_lo
// GFX10: encoding: [0x05,0x00,0x59,0xd5,0x01,0x05,0xaa,0x01]

v_med3_u32 v5, v1, v2, vcc_hi
// GFX10: encoding: [0x05,0x00,0x59,0xd5,0x01,0x05,0xae,0x01]

v_med3_u32 v5, v1, v2, ttmp11
// GFX10: encoding: [0x05,0x00,0x59,0xd5,0x01,0x05,0xde,0x01]

v_med3_u32 v5, v1, v2, m0
// GFX10: encoding: [0x05,0x00,0x59,0xd5,0x01,0x05,0xf2,0x01]

v_med3_u32 v5, v1, v2, exec_lo
// GFX10: encoding: [0x05,0x00,0x59,0xd5,0x01,0x05,0xfa,0x01]

v_med3_u32 v5, v1, v2, exec_hi
// GFX10: encoding: [0x05,0x00,0x59,0xd5,0x01,0x05,0xfe,0x01]

v_med3_u32 v5, v1, v2, 0
// GFX10: encoding: [0x05,0x00,0x59,0xd5,0x01,0x05,0x02,0x02]

v_med3_u32 v5, v1, v2, -1
// GFX10: encoding: [0x05,0x00,0x59,0xd5,0x01,0x05,0x06,0x03]

v_med3_u32 v5, v1, v2, 0.5
// GFX10: encoding: [0x05,0x00,0x59,0xd5,0x01,0x05,0xc2,0x03]

v_med3_u32 v5, v1, v2, -4.0
// GFX10: encoding: [0x05,0x00,0x59,0xd5,0x01,0x05,0xde,0x03]

v_sad_u8 v5, v1, v2, v3
// GFX10: encoding: [0x05,0x00,0x5a,0xd5,0x01,0x05,0x0e,0x04]

v_sad_u8 v255, v1, v2, v3
// GFX10: encoding: [0xff,0x00,0x5a,0xd5,0x01,0x05,0x0e,0x04]

v_sad_u8 v5, v255, v2, v3
// GFX10: encoding: [0x05,0x00,0x5a,0xd5,0xff,0x05,0x0e,0x04]

v_sad_u8 v5, s1, v2, v3
// GFX10: encoding: [0x05,0x00,0x5a,0xd5,0x01,0x04,0x0e,0x04]

v_sad_u8 v5, s103, v2, v3
// GFX10: encoding: [0x05,0x00,0x5a,0xd5,0x67,0x04,0x0e,0x04]

v_sad_u8 v5, vcc_lo, v2, v3
// GFX10: encoding: [0x05,0x00,0x5a,0xd5,0x6a,0x04,0x0e,0x04]

v_sad_u8 v5, vcc_hi, v2, v3
// GFX10: encoding: [0x05,0x00,0x5a,0xd5,0x6b,0x04,0x0e,0x04]

v_sad_u8 v5, ttmp11, v2, v3
// GFX10: encoding: [0x05,0x00,0x5a,0xd5,0x77,0x04,0x0e,0x04]

v_sad_u8 v5, m0, v2, v3
// GFX10: encoding: [0x05,0x00,0x5a,0xd5,0x7c,0x04,0x0e,0x04]

v_sad_u8 v5, exec_lo, v2, v3
// GFX10: encoding: [0x05,0x00,0x5a,0xd5,0x7e,0x04,0x0e,0x04]

v_sad_u8 v5, exec_hi, v2, v3
// GFX10: encoding: [0x05,0x00,0x5a,0xd5,0x7f,0x04,0x0e,0x04]

v_sad_u8 v5, 0, v2, v3
// GFX10: encoding: [0x05,0x00,0x5a,0xd5,0x80,0x04,0x0e,0x04]

v_sad_u8 v5, -1, v2, v3
// GFX10: encoding: [0x05,0x00,0x5a,0xd5,0xc1,0x04,0x0e,0x04]

v_sad_u8 v5, 0.5, v2, v3
// GFX10: encoding: [0x05,0x00,0x5a,0xd5,0xf0,0x04,0x0e,0x04]

v_sad_u8 v5, -4.0, v2, v3
// GFX10: encoding: [0x05,0x00,0x5a,0xd5,0xf7,0x04,0x0e,0x04]

v_sad_u8 v5, v1, v255, v3
// GFX10: encoding: [0x05,0x00,0x5a,0xd5,0x01,0xff,0x0f,0x04]

v_sad_u8 v5, v1, s2, v3
// GFX10: encoding: [0x05,0x00,0x5a,0xd5,0x01,0x05,0x0c,0x04]

v_sad_u8 v5, v1, s103, v3
// GFX10: encoding: [0x05,0x00,0x5a,0xd5,0x01,0xcf,0x0c,0x04]

v_sad_u8 v5, v1, vcc_lo, v3
// GFX10: encoding: [0x05,0x00,0x5a,0xd5,0x01,0xd5,0x0c,0x04]

v_sad_u8 v5, v1, vcc_hi, v3
// GFX10: encoding: [0x05,0x00,0x5a,0xd5,0x01,0xd7,0x0c,0x04]

v_sad_u8 v5, v1, ttmp11, v3
// GFX10: encoding: [0x05,0x00,0x5a,0xd5,0x01,0xef,0x0c,0x04]

v_sad_u8 v5, v1, m0, v3
// GFX10: encoding: [0x05,0x00,0x5a,0xd5,0x01,0xf9,0x0c,0x04]

v_sad_u8 v5, v1, exec_lo, v3
// GFX10: encoding: [0x05,0x00,0x5a,0xd5,0x01,0xfd,0x0c,0x04]

v_sad_u8 v5, v1, exec_hi, v3
// GFX10: encoding: [0x05,0x00,0x5a,0xd5,0x01,0xff,0x0c,0x04]

v_sad_u8 v5, v1, 0, v3
// GFX10: encoding: [0x05,0x00,0x5a,0xd5,0x01,0x01,0x0d,0x04]

v_sad_u8 v5, v1, -1, v3
// GFX10: encoding: [0x05,0x00,0x5a,0xd5,0x01,0x83,0x0d,0x04]

v_sad_u8 v5, v1, 0.5, v3
// GFX10: encoding: [0x05,0x00,0x5a,0xd5,0x01,0xe1,0x0d,0x04]

v_sad_u8 v5, v1, -4.0, v3
// GFX10: encoding: [0x05,0x00,0x5a,0xd5,0x01,0xef,0x0d,0x04]

v_sad_u8 v5, v1, v2, v255
// GFX10: encoding: [0x05,0x00,0x5a,0xd5,0x01,0x05,0xfe,0x07]

v_sad_u8 v5, v1, v2, s3
// GFX10: encoding: [0x05,0x00,0x5a,0xd5,0x01,0x05,0x0e,0x00]

v_sad_u8 v5, v1, v2, s103
// GFX10: encoding: [0x05,0x00,0x5a,0xd5,0x01,0x05,0x9e,0x01]

v_sad_u8 v5, v1, v2, vcc_lo
// GFX10: encoding: [0x05,0x00,0x5a,0xd5,0x01,0x05,0xaa,0x01]

v_sad_u8 v5, v1, v2, vcc_hi
// GFX10: encoding: [0x05,0x00,0x5a,0xd5,0x01,0x05,0xae,0x01]

v_sad_u8 v5, v1, v2, ttmp11
// GFX10: encoding: [0x05,0x00,0x5a,0xd5,0x01,0x05,0xde,0x01]

v_sad_u8 v5, v1, v2, m0
// GFX10: encoding: [0x05,0x00,0x5a,0xd5,0x01,0x05,0xf2,0x01]

v_sad_u8 v5, v1, v2, exec_lo
// GFX10: encoding: [0x05,0x00,0x5a,0xd5,0x01,0x05,0xfa,0x01]

v_sad_u8 v5, v1, v2, exec_hi
// GFX10: encoding: [0x05,0x00,0x5a,0xd5,0x01,0x05,0xfe,0x01]

v_sad_u8 v5, v1, v2, 0
// GFX10: encoding: [0x05,0x00,0x5a,0xd5,0x01,0x05,0x02,0x02]

v_sad_u8 v5, v1, v2, -1
// GFX10: encoding: [0x05,0x00,0x5a,0xd5,0x01,0x05,0x06,0x03]

v_sad_u8 v5, v1, v2, 0.5
// GFX10: encoding: [0x05,0x00,0x5a,0xd5,0x01,0x05,0xc2,0x03]

v_sad_u8 v5, v1, v2, -4.0
// GFX10: encoding: [0x05,0x00,0x5a,0xd5,0x01,0x05,0xde,0x03]

v_sad_hi_u8 v5, v1, v2, v3
// GFX10: encoding: [0x05,0x00,0x5b,0xd5,0x01,0x05,0x0e,0x04]

v_sad_hi_u8 v255, v1, v2, v3
// GFX10: encoding: [0xff,0x00,0x5b,0xd5,0x01,0x05,0x0e,0x04]

v_sad_hi_u8 v5, v255, v2, v3
// GFX10: encoding: [0x05,0x00,0x5b,0xd5,0xff,0x05,0x0e,0x04]

v_sad_hi_u8 v5, s1, v2, v3
// GFX10: encoding: [0x05,0x00,0x5b,0xd5,0x01,0x04,0x0e,0x04]

v_sad_hi_u8 v5, s103, v2, v3
// GFX10: encoding: [0x05,0x00,0x5b,0xd5,0x67,0x04,0x0e,0x04]

v_sad_hi_u8 v5, vcc_lo, v2, v3
// GFX10: encoding: [0x05,0x00,0x5b,0xd5,0x6a,0x04,0x0e,0x04]

v_sad_hi_u8 v5, vcc_hi, v2, v3
// GFX10: encoding: [0x05,0x00,0x5b,0xd5,0x6b,0x04,0x0e,0x04]

v_sad_hi_u8 v5, ttmp11, v2, v3
// GFX10: encoding: [0x05,0x00,0x5b,0xd5,0x77,0x04,0x0e,0x04]

v_sad_hi_u8 v5, m0, v2, v3
// GFX10: encoding: [0x05,0x00,0x5b,0xd5,0x7c,0x04,0x0e,0x04]

v_sad_hi_u8 v5, exec_lo, v2, v3
// GFX10: encoding: [0x05,0x00,0x5b,0xd5,0x7e,0x04,0x0e,0x04]

v_sad_hi_u8 v5, exec_hi, v2, v3
// GFX10: encoding: [0x05,0x00,0x5b,0xd5,0x7f,0x04,0x0e,0x04]

v_sad_hi_u8 v5, 0, v2, v3
// GFX10: encoding: [0x05,0x00,0x5b,0xd5,0x80,0x04,0x0e,0x04]

v_sad_hi_u8 v5, -1, v2, v3
// GFX10: encoding: [0x05,0x00,0x5b,0xd5,0xc1,0x04,0x0e,0x04]

v_sad_hi_u8 v5, 0.5, v2, v3
// GFX10: encoding: [0x05,0x00,0x5b,0xd5,0xf0,0x04,0x0e,0x04]

v_sad_hi_u8 v5, -4.0, v2, v3
// GFX10: encoding: [0x05,0x00,0x5b,0xd5,0xf7,0x04,0x0e,0x04]

v_sad_hi_u8 v5, v1, v255, v3
// GFX10: encoding: [0x05,0x00,0x5b,0xd5,0x01,0xff,0x0f,0x04]

v_sad_hi_u8 v5, v1, s2, v3
// GFX10: encoding: [0x05,0x00,0x5b,0xd5,0x01,0x05,0x0c,0x04]

v_sad_hi_u8 v5, v1, s103, v3
// GFX10: encoding: [0x05,0x00,0x5b,0xd5,0x01,0xcf,0x0c,0x04]

v_sad_hi_u8 v5, v1, vcc_lo, v3
// GFX10: encoding: [0x05,0x00,0x5b,0xd5,0x01,0xd5,0x0c,0x04]

v_sad_hi_u8 v5, v1, vcc_hi, v3
// GFX10: encoding: [0x05,0x00,0x5b,0xd5,0x01,0xd7,0x0c,0x04]

v_sad_hi_u8 v5, v1, ttmp11, v3
// GFX10: encoding: [0x05,0x00,0x5b,0xd5,0x01,0xef,0x0c,0x04]

v_sad_hi_u8 v5, v1, m0, v3
// GFX10: encoding: [0x05,0x00,0x5b,0xd5,0x01,0xf9,0x0c,0x04]

v_sad_hi_u8 v5, v1, exec_lo, v3
// GFX10: encoding: [0x05,0x00,0x5b,0xd5,0x01,0xfd,0x0c,0x04]

v_sad_hi_u8 v5, v1, exec_hi, v3
// GFX10: encoding: [0x05,0x00,0x5b,0xd5,0x01,0xff,0x0c,0x04]

v_sad_hi_u8 v5, v1, 0, v3
// GFX10: encoding: [0x05,0x00,0x5b,0xd5,0x01,0x01,0x0d,0x04]

v_sad_hi_u8 v5, v1, -1, v3
// GFX10: encoding: [0x05,0x00,0x5b,0xd5,0x01,0x83,0x0d,0x04]

v_sad_hi_u8 v5, v1, 0.5, v3
// GFX10: encoding: [0x05,0x00,0x5b,0xd5,0x01,0xe1,0x0d,0x04]

v_sad_hi_u8 v5, v1, -4.0, v3
// GFX10: encoding: [0x05,0x00,0x5b,0xd5,0x01,0xef,0x0d,0x04]

v_sad_hi_u8 v5, v1, v2, v255
// GFX10: encoding: [0x05,0x00,0x5b,0xd5,0x01,0x05,0xfe,0x07]

v_sad_hi_u8 v5, v1, v2, s3
// GFX10: encoding: [0x05,0x00,0x5b,0xd5,0x01,0x05,0x0e,0x00]

v_sad_hi_u8 v5, v1, v2, s103
// GFX10: encoding: [0x05,0x00,0x5b,0xd5,0x01,0x05,0x9e,0x01]

v_sad_hi_u8 v5, v1, v2, vcc_lo
// GFX10: encoding: [0x05,0x00,0x5b,0xd5,0x01,0x05,0xaa,0x01]

v_sad_hi_u8 v5, v1, v2, vcc_hi
// GFX10: encoding: [0x05,0x00,0x5b,0xd5,0x01,0x05,0xae,0x01]

v_sad_hi_u8 v5, v1, v2, ttmp11
// GFX10: encoding: [0x05,0x00,0x5b,0xd5,0x01,0x05,0xde,0x01]

v_sad_hi_u8 v5, v1, v2, m0
// GFX10: encoding: [0x05,0x00,0x5b,0xd5,0x01,0x05,0xf2,0x01]

v_sad_hi_u8 v5, v1, v2, exec_lo
// GFX10: encoding: [0x05,0x00,0x5b,0xd5,0x01,0x05,0xfa,0x01]

v_sad_hi_u8 v5, v1, v2, exec_hi
// GFX10: encoding: [0x05,0x00,0x5b,0xd5,0x01,0x05,0xfe,0x01]

v_sad_hi_u8 v5, v1, v2, 0
// GFX10: encoding: [0x05,0x00,0x5b,0xd5,0x01,0x05,0x02,0x02]

v_sad_hi_u8 v5, v1, v2, -1
// GFX10: encoding: [0x05,0x00,0x5b,0xd5,0x01,0x05,0x06,0x03]

v_sad_hi_u8 v5, v1, v2, 0.5
// GFX10: encoding: [0x05,0x00,0x5b,0xd5,0x01,0x05,0xc2,0x03]

v_sad_hi_u8 v5, v1, v2, -4.0
// GFX10: encoding: [0x05,0x00,0x5b,0xd5,0x01,0x05,0xde,0x03]

v_sad_u16 v5, v1, v2, v3
// GFX10: encoding: [0x05,0x00,0x5c,0xd5,0x01,0x05,0x0e,0x04]

v_sad_u16 v255, v1, v2, v3
// GFX10: encoding: [0xff,0x00,0x5c,0xd5,0x01,0x05,0x0e,0x04]

v_sad_u16 v5, v255, v2, v3
// GFX10: encoding: [0x05,0x00,0x5c,0xd5,0xff,0x05,0x0e,0x04]

v_sad_u16 v5, s1, v2, v3
// GFX10: encoding: [0x05,0x00,0x5c,0xd5,0x01,0x04,0x0e,0x04]

v_sad_u16 v5, s103, v2, v3
// GFX10: encoding: [0x05,0x00,0x5c,0xd5,0x67,0x04,0x0e,0x04]

v_sad_u16 v5, vcc_lo, v2, v3
// GFX10: encoding: [0x05,0x00,0x5c,0xd5,0x6a,0x04,0x0e,0x04]

v_sad_u16 v5, vcc_hi, v2, v3
// GFX10: encoding: [0x05,0x00,0x5c,0xd5,0x6b,0x04,0x0e,0x04]

v_sad_u16 v5, ttmp11, v2, v3
// GFX10: encoding: [0x05,0x00,0x5c,0xd5,0x77,0x04,0x0e,0x04]

v_sad_u16 v5, m0, v2, v3
// GFX10: encoding: [0x05,0x00,0x5c,0xd5,0x7c,0x04,0x0e,0x04]

v_sad_u16 v5, exec_lo, v2, v3
// GFX10: encoding: [0x05,0x00,0x5c,0xd5,0x7e,0x04,0x0e,0x04]

v_sad_u16 v5, exec_hi, v2, v3
// GFX10: encoding: [0x05,0x00,0x5c,0xd5,0x7f,0x04,0x0e,0x04]

v_sad_u16 v5, 0, v2, v3
// GFX10: encoding: [0x05,0x00,0x5c,0xd5,0x80,0x04,0x0e,0x04]

v_sad_u16 v5, -1, v2, v3
// GFX10: encoding: [0x05,0x00,0x5c,0xd5,0xc1,0x04,0x0e,0x04]

v_sad_u16 v5, 0.5, v2, v3
// GFX10: encoding: [0x05,0x00,0x5c,0xd5,0xf0,0x04,0x0e,0x04]

v_sad_u16 v5, -4.0, v2, v3
// GFX10: encoding: [0x05,0x00,0x5c,0xd5,0xf7,0x04,0x0e,0x04]

v_sad_u16 v5, v1, v255, v3
// GFX10: encoding: [0x05,0x00,0x5c,0xd5,0x01,0xff,0x0f,0x04]

v_sad_u16 v5, v1, s2, v3
// GFX10: encoding: [0x05,0x00,0x5c,0xd5,0x01,0x05,0x0c,0x04]

v_sad_u16 v5, v1, s103, v3
// GFX10: encoding: [0x05,0x00,0x5c,0xd5,0x01,0xcf,0x0c,0x04]

v_sad_u16 v5, v1, vcc_lo, v3
// GFX10: encoding: [0x05,0x00,0x5c,0xd5,0x01,0xd5,0x0c,0x04]

v_sad_u16 v5, v1, vcc_hi, v3
// GFX10: encoding: [0x05,0x00,0x5c,0xd5,0x01,0xd7,0x0c,0x04]

v_sad_u16 v5, v1, ttmp11, v3
// GFX10: encoding: [0x05,0x00,0x5c,0xd5,0x01,0xef,0x0c,0x04]

v_sad_u16 v5, v1, m0, v3
// GFX10: encoding: [0x05,0x00,0x5c,0xd5,0x01,0xf9,0x0c,0x04]

v_sad_u16 v5, v1, exec_lo, v3
// GFX10: encoding: [0x05,0x00,0x5c,0xd5,0x01,0xfd,0x0c,0x04]

v_sad_u16 v5, v1, exec_hi, v3
// GFX10: encoding: [0x05,0x00,0x5c,0xd5,0x01,0xff,0x0c,0x04]

v_sad_u16 v5, v1, 0, v3
// GFX10: encoding: [0x05,0x00,0x5c,0xd5,0x01,0x01,0x0d,0x04]

v_sad_u16 v5, v1, -1, v3
// GFX10: encoding: [0x05,0x00,0x5c,0xd5,0x01,0x83,0x0d,0x04]

v_sad_u16 v5, v1, 0.5, v3
// GFX10: encoding: [0x05,0x00,0x5c,0xd5,0x01,0xe1,0x0d,0x04]

v_sad_u16 v5, v1, -4.0, v3
// GFX10: encoding: [0x05,0x00,0x5c,0xd5,0x01,0xef,0x0d,0x04]

v_sad_u16 v5, v1, v2, v255
// GFX10: encoding: [0x05,0x00,0x5c,0xd5,0x01,0x05,0xfe,0x07]

v_sad_u16 v5, v1, v2, s3
// GFX10: encoding: [0x05,0x00,0x5c,0xd5,0x01,0x05,0x0e,0x00]

v_sad_u16 v5, v1, v2, s103
// GFX10: encoding: [0x05,0x00,0x5c,0xd5,0x01,0x05,0x9e,0x01]

v_sad_u16 v5, v1, v2, vcc_lo
// GFX10: encoding: [0x05,0x00,0x5c,0xd5,0x01,0x05,0xaa,0x01]

v_sad_u16 v5, v1, v2, vcc_hi
// GFX10: encoding: [0x05,0x00,0x5c,0xd5,0x01,0x05,0xae,0x01]

v_sad_u16 v5, v1, v2, ttmp11
// GFX10: encoding: [0x05,0x00,0x5c,0xd5,0x01,0x05,0xde,0x01]

v_sad_u16 v5, v1, v2, m0
// GFX10: encoding: [0x05,0x00,0x5c,0xd5,0x01,0x05,0xf2,0x01]

v_sad_u16 v5, v1, v2, exec_lo
// GFX10: encoding: [0x05,0x00,0x5c,0xd5,0x01,0x05,0xfa,0x01]

v_sad_u16 v5, v1, v2, exec_hi
// GFX10: encoding: [0x05,0x00,0x5c,0xd5,0x01,0x05,0xfe,0x01]

v_sad_u16 v5, v1, v2, 0
// GFX10: encoding: [0x05,0x00,0x5c,0xd5,0x01,0x05,0x02,0x02]

v_sad_u16 v5, v1, v2, -1
// GFX10: encoding: [0x05,0x00,0x5c,0xd5,0x01,0x05,0x06,0x03]

v_sad_u16 v5, v1, v2, 0.5
// GFX10: encoding: [0x05,0x00,0x5c,0xd5,0x01,0x05,0xc2,0x03]

v_sad_u16 v5, v1, v2, -4.0
// GFX10: encoding: [0x05,0x00,0x5c,0xd5,0x01,0x05,0xde,0x03]

v_sad_u32 v5, v1, v2, v3
// GFX10: encoding: [0x05,0x00,0x5d,0xd5,0x01,0x05,0x0e,0x04]

v_sad_u32 v255, v1, v2, v3
// GFX10: encoding: [0xff,0x00,0x5d,0xd5,0x01,0x05,0x0e,0x04]

v_sad_u32 v5, v255, v2, v3
// GFX10: encoding: [0x05,0x00,0x5d,0xd5,0xff,0x05,0x0e,0x04]

v_sad_u32 v5, s1, v2, v3
// GFX10: encoding: [0x05,0x00,0x5d,0xd5,0x01,0x04,0x0e,0x04]

v_sad_u32 v5, s103, v2, v3
// GFX10: encoding: [0x05,0x00,0x5d,0xd5,0x67,0x04,0x0e,0x04]

v_sad_u32 v5, vcc_lo, v2, v3
// GFX10: encoding: [0x05,0x00,0x5d,0xd5,0x6a,0x04,0x0e,0x04]

v_sad_u32 v5, vcc_hi, v2, v3
// GFX10: encoding: [0x05,0x00,0x5d,0xd5,0x6b,0x04,0x0e,0x04]

v_sad_u32 v5, ttmp11, v2, v3
// GFX10: encoding: [0x05,0x00,0x5d,0xd5,0x77,0x04,0x0e,0x04]

v_sad_u32 v5, m0, v2, v3
// GFX10: encoding: [0x05,0x00,0x5d,0xd5,0x7c,0x04,0x0e,0x04]

v_sad_u32 v5, exec_lo, v2, v3
// GFX10: encoding: [0x05,0x00,0x5d,0xd5,0x7e,0x04,0x0e,0x04]

v_sad_u32 v5, exec_hi, v2, v3
// GFX10: encoding: [0x05,0x00,0x5d,0xd5,0x7f,0x04,0x0e,0x04]

v_sad_u32 v5, 0, v2, v3
// GFX10: encoding: [0x05,0x00,0x5d,0xd5,0x80,0x04,0x0e,0x04]

v_sad_u32 v5, -1, v2, v3
// GFX10: encoding: [0x05,0x00,0x5d,0xd5,0xc1,0x04,0x0e,0x04]

v_sad_u32 v5, 0.5, v2, v3
// GFX10: encoding: [0x05,0x00,0x5d,0xd5,0xf0,0x04,0x0e,0x04]

v_sad_u32 v5, -4.0, v2, v3
// GFX10: encoding: [0x05,0x00,0x5d,0xd5,0xf7,0x04,0x0e,0x04]

v_sad_u32 v5, v1, v255, v3
// GFX10: encoding: [0x05,0x00,0x5d,0xd5,0x01,0xff,0x0f,0x04]

v_sad_u32 v5, v1, s2, v3
// GFX10: encoding: [0x05,0x00,0x5d,0xd5,0x01,0x05,0x0c,0x04]

v_sad_u32 v5, v1, s103, v3
// GFX10: encoding: [0x05,0x00,0x5d,0xd5,0x01,0xcf,0x0c,0x04]

v_sad_u32 v5, v1, vcc_lo, v3
// GFX10: encoding: [0x05,0x00,0x5d,0xd5,0x01,0xd5,0x0c,0x04]

v_sad_u32 v5, v1, vcc_hi, v3
// GFX10: encoding: [0x05,0x00,0x5d,0xd5,0x01,0xd7,0x0c,0x04]

v_sad_u32 v5, v1, ttmp11, v3
// GFX10: encoding: [0x05,0x00,0x5d,0xd5,0x01,0xef,0x0c,0x04]

v_sad_u32 v5, v1, m0, v3
// GFX10: encoding: [0x05,0x00,0x5d,0xd5,0x01,0xf9,0x0c,0x04]

v_sad_u32 v5, v1, exec_lo, v3
// GFX10: encoding: [0x05,0x00,0x5d,0xd5,0x01,0xfd,0x0c,0x04]

v_sad_u32 v5, v1, exec_hi, v3
// GFX10: encoding: [0x05,0x00,0x5d,0xd5,0x01,0xff,0x0c,0x04]

v_sad_u32 v5, v1, 0, v3
// GFX10: encoding: [0x05,0x00,0x5d,0xd5,0x01,0x01,0x0d,0x04]

v_sad_u32 v5, v1, -1, v3
// GFX10: encoding: [0x05,0x00,0x5d,0xd5,0x01,0x83,0x0d,0x04]

v_sad_u32 v5, v1, 0.5, v3
// GFX10: encoding: [0x05,0x00,0x5d,0xd5,0x01,0xe1,0x0d,0x04]

v_sad_u32 v5, v1, -4.0, v3
// GFX10: encoding: [0x05,0x00,0x5d,0xd5,0x01,0xef,0x0d,0x04]

v_sad_u32 v5, v1, v2, v255
// GFX10: encoding: [0x05,0x00,0x5d,0xd5,0x01,0x05,0xfe,0x07]

v_sad_u32 v5, v1, v2, s3
// GFX10: encoding: [0x05,0x00,0x5d,0xd5,0x01,0x05,0x0e,0x00]

v_sad_u32 v5, v1, v2, s103
// GFX10: encoding: [0x05,0x00,0x5d,0xd5,0x01,0x05,0x9e,0x01]

v_sad_u32 v5, v1, v2, vcc_lo
// GFX10: encoding: [0x05,0x00,0x5d,0xd5,0x01,0x05,0xaa,0x01]

v_sad_u32 v5, v1, v2, vcc_hi
// GFX10: encoding: [0x05,0x00,0x5d,0xd5,0x01,0x05,0xae,0x01]

v_sad_u32 v5, v1, v2, ttmp11
// GFX10: encoding: [0x05,0x00,0x5d,0xd5,0x01,0x05,0xde,0x01]

v_sad_u32 v5, v1, v2, m0
// GFX10: encoding: [0x05,0x00,0x5d,0xd5,0x01,0x05,0xf2,0x01]

v_sad_u32 v5, v1, v2, exec_lo
// GFX10: encoding: [0x05,0x00,0x5d,0xd5,0x01,0x05,0xfa,0x01]

v_sad_u32 v5, v1, v2, exec_hi
// GFX10: encoding: [0x05,0x00,0x5d,0xd5,0x01,0x05,0xfe,0x01]

v_sad_u32 v5, v1, v2, 0
// GFX10: encoding: [0x05,0x00,0x5d,0xd5,0x01,0x05,0x02,0x02]

v_sad_u32 v5, v1, v2, -1
// GFX10: encoding: [0x05,0x00,0x5d,0xd5,0x01,0x05,0x06,0x03]

v_sad_u32 v5, v1, v2, 0.5
// GFX10: encoding: [0x05,0x00,0x5d,0xd5,0x01,0x05,0xc2,0x03]

v_sad_u32 v5, v1, v2, -4.0
// GFX10: encoding: [0x05,0x00,0x5d,0xd5,0x01,0x05,0xde,0x03]

v_cvt_pk_u8_f32 v5, v1, v2, v3
// GFX10: encoding: [0x05,0x00,0x5e,0xd5,0x01,0x05,0x0e,0x04]

v_cvt_pk_u8_f32 v255, v1, v2, v3
// GFX10: encoding: [0xff,0x00,0x5e,0xd5,0x01,0x05,0x0e,0x04]

v_cvt_pk_u8_f32 v5, v255, v2, v3
// GFX10: encoding: [0x05,0x00,0x5e,0xd5,0xff,0x05,0x0e,0x04]

v_cvt_pk_u8_f32 v5, s1, v2, v3
// GFX10: encoding: [0x05,0x00,0x5e,0xd5,0x01,0x04,0x0e,0x04]

v_cvt_pk_u8_f32 v5, s103, v2, v3
// GFX10: encoding: [0x05,0x00,0x5e,0xd5,0x67,0x04,0x0e,0x04]

v_cvt_pk_u8_f32 v5, vcc_lo, v2, v3
// GFX10: encoding: [0x05,0x00,0x5e,0xd5,0x6a,0x04,0x0e,0x04]

v_cvt_pk_u8_f32 v5, vcc_hi, v2, v3
// GFX10: encoding: [0x05,0x00,0x5e,0xd5,0x6b,0x04,0x0e,0x04]

v_cvt_pk_u8_f32 v5, ttmp11, v2, v3
// GFX10: encoding: [0x05,0x00,0x5e,0xd5,0x77,0x04,0x0e,0x04]

v_cvt_pk_u8_f32 v5, m0, v2, v3
// GFX10: encoding: [0x05,0x00,0x5e,0xd5,0x7c,0x04,0x0e,0x04]

v_cvt_pk_u8_f32 v5, exec_lo, v2, v3
// GFX10: encoding: [0x05,0x00,0x5e,0xd5,0x7e,0x04,0x0e,0x04]

v_cvt_pk_u8_f32 v5, exec_hi, v2, v3
// GFX10: encoding: [0x05,0x00,0x5e,0xd5,0x7f,0x04,0x0e,0x04]

v_cvt_pk_u8_f32 v5, 0, v2, v3
// GFX10: encoding: [0x05,0x00,0x5e,0xd5,0x80,0x04,0x0e,0x04]

v_cvt_pk_u8_f32 v5, -1, v2, v3
// GFX10: encoding: [0x05,0x00,0x5e,0xd5,0xc1,0x04,0x0e,0x04]

v_cvt_pk_u8_f32 v5, 0.5, v2, v3
// GFX10: encoding: [0x05,0x00,0x5e,0xd5,0xf0,0x04,0x0e,0x04]

v_cvt_pk_u8_f32 v5, -4.0, v2, v3
// GFX10: encoding: [0x05,0x00,0x5e,0xd5,0xf7,0x04,0x0e,0x04]

v_cvt_pk_u8_f32 v5, v1, v255, v3
// GFX10: encoding: [0x05,0x00,0x5e,0xd5,0x01,0xff,0x0f,0x04]

v_cvt_pk_u8_f32 v5, v1, s2, v3
// GFX10: encoding: [0x05,0x00,0x5e,0xd5,0x01,0x05,0x0c,0x04]

v_cvt_pk_u8_f32 v5, v1, s103, v3
// GFX10: encoding: [0x05,0x00,0x5e,0xd5,0x01,0xcf,0x0c,0x04]

v_cvt_pk_u8_f32 v5, v1, vcc_lo, v3
// GFX10: encoding: [0x05,0x00,0x5e,0xd5,0x01,0xd5,0x0c,0x04]

v_cvt_pk_u8_f32 v5, v1, vcc_hi, v3
// GFX10: encoding: [0x05,0x00,0x5e,0xd5,0x01,0xd7,0x0c,0x04]

v_cvt_pk_u8_f32 v5, v1, ttmp11, v3
// GFX10: encoding: [0x05,0x00,0x5e,0xd5,0x01,0xef,0x0c,0x04]

v_cvt_pk_u8_f32 v5, v1, m0, v3
// GFX10: encoding: [0x05,0x00,0x5e,0xd5,0x01,0xf9,0x0c,0x04]

v_cvt_pk_u8_f32 v5, v1, exec_lo, v3
// GFX10: encoding: [0x05,0x00,0x5e,0xd5,0x01,0xfd,0x0c,0x04]

v_cvt_pk_u8_f32 v5, v1, exec_hi, v3
// GFX10: encoding: [0x05,0x00,0x5e,0xd5,0x01,0xff,0x0c,0x04]

v_cvt_pk_u8_f32 v5, v1, 0, v3
// GFX10: encoding: [0x05,0x00,0x5e,0xd5,0x01,0x01,0x0d,0x04]

v_cvt_pk_u8_f32 v5, v1, -1, v3
// GFX10: encoding: [0x05,0x00,0x5e,0xd5,0x01,0x83,0x0d,0x04]

v_cvt_pk_u8_f32 v5, v1, 0.5, v3
// GFX10: encoding: [0x05,0x00,0x5e,0xd5,0x01,0xe1,0x0d,0x04]

v_cvt_pk_u8_f32 v5, v1, -4.0, v3
// GFX10: encoding: [0x05,0x00,0x5e,0xd5,0x01,0xef,0x0d,0x04]

v_cvt_pk_u8_f32 v5, v1, v2, v255
// GFX10: encoding: [0x05,0x00,0x5e,0xd5,0x01,0x05,0xfe,0x07]

v_cvt_pk_u8_f32 v5, v1, v2, s3
// GFX10: encoding: [0x05,0x00,0x5e,0xd5,0x01,0x05,0x0e,0x00]

v_cvt_pk_u8_f32 v5, v1, v2, s103
// GFX10: encoding: [0x05,0x00,0x5e,0xd5,0x01,0x05,0x9e,0x01]

v_cvt_pk_u8_f32 v5, v1, v2, vcc_lo
// GFX10: encoding: [0x05,0x00,0x5e,0xd5,0x01,0x05,0xaa,0x01]

v_cvt_pk_u8_f32 v5, v1, v2, vcc_hi
// GFX10: encoding: [0x05,0x00,0x5e,0xd5,0x01,0x05,0xae,0x01]

v_cvt_pk_u8_f32 v5, v1, v2, ttmp11
// GFX10: encoding: [0x05,0x00,0x5e,0xd5,0x01,0x05,0xde,0x01]

v_cvt_pk_u8_f32 v5, v1, v2, m0
// GFX10: encoding: [0x05,0x00,0x5e,0xd5,0x01,0x05,0xf2,0x01]

v_cvt_pk_u8_f32 v5, v1, v2, exec_lo
// GFX10: encoding: [0x05,0x00,0x5e,0xd5,0x01,0x05,0xfa,0x01]

v_cvt_pk_u8_f32 v5, v1, v2, exec_hi
// GFX10: encoding: [0x05,0x00,0x5e,0xd5,0x01,0x05,0xfe,0x01]

v_cvt_pk_u8_f32 v5, v1, v2, 0
// GFX10: encoding: [0x05,0x00,0x5e,0xd5,0x01,0x05,0x02,0x02]

v_cvt_pk_u8_f32 v5, v1, v2, -1
// GFX10: encoding: [0x05,0x00,0x5e,0xd5,0x01,0x05,0x06,0x03]

v_cvt_pk_u8_f32 v5, v1, v2, 0.5
// GFX10: encoding: [0x05,0x00,0x5e,0xd5,0x01,0x05,0xc2,0x03]

v_cvt_pk_u8_f32 v5, v1, v2, -4.0
// GFX10: encoding: [0x05,0x00,0x5e,0xd5,0x01,0x05,0xde,0x03]

v_cvt_pk_u8_f32 v5, -v1, v2, v3
// GFX10: encoding: [0x05,0x00,0x5e,0xd5,0x01,0x05,0x0e,0x24]

v_cvt_pk_u8_f32 v5, |v1|, v2, v3
// GFX10: encoding: [0x05,0x01,0x5e,0xd5,0x01,0x05,0x0e,0x04]

v_cvt_pk_u8_f32 v5, v1, v2, v3 clamp
// GFX10: encoding: [0x05,0x80,0x5e,0xd5,0x01,0x05,0x0e,0x04]

v_div_fixup_f32 v5, v1, v2, v3
// GFX10: encoding: [0x05,0x00,0x5f,0xd5,0x01,0x05,0x0e,0x04]

v_div_fixup_f32 v255, v1, v2, v3
// GFX10: encoding: [0xff,0x00,0x5f,0xd5,0x01,0x05,0x0e,0x04]

v_div_fixup_f32 v5, v255, v2, v3
// GFX10: encoding: [0x05,0x00,0x5f,0xd5,0xff,0x05,0x0e,0x04]

v_div_fixup_f32 v5, s1, v2, v3
// GFX10: encoding: [0x05,0x00,0x5f,0xd5,0x01,0x04,0x0e,0x04]

v_div_fixup_f32 v5, s103, v2, v3
// GFX10: encoding: [0x05,0x00,0x5f,0xd5,0x67,0x04,0x0e,0x04]

v_div_fixup_f32 v5, vcc_lo, v2, v3
// GFX10: encoding: [0x05,0x00,0x5f,0xd5,0x6a,0x04,0x0e,0x04]

v_div_fixup_f32 v5, vcc_hi, v2, v3
// GFX10: encoding: [0x05,0x00,0x5f,0xd5,0x6b,0x04,0x0e,0x04]

v_div_fixup_f32 v5, ttmp11, v2, v3
// GFX10: encoding: [0x05,0x00,0x5f,0xd5,0x77,0x04,0x0e,0x04]

v_div_fixup_f32 v5, m0, v2, v3
// GFX10: encoding: [0x05,0x00,0x5f,0xd5,0x7c,0x04,0x0e,0x04]

v_div_fixup_f32 v5, exec_lo, v2, v3
// GFX10: encoding: [0x05,0x00,0x5f,0xd5,0x7e,0x04,0x0e,0x04]

v_div_fixup_f32 v5, exec_hi, v2, v3
// GFX10: encoding: [0x05,0x00,0x5f,0xd5,0x7f,0x04,0x0e,0x04]

v_div_fixup_f32 v5, 0, v2, v3
// GFX10: encoding: [0x05,0x00,0x5f,0xd5,0x80,0x04,0x0e,0x04]

v_div_fixup_f32 v5, -1, v2, v3
// GFX10: encoding: [0x05,0x00,0x5f,0xd5,0xc1,0x04,0x0e,0x04]

v_div_fixup_f32 v5, 0.5, v2, v3
// GFX10: encoding: [0x05,0x00,0x5f,0xd5,0xf0,0x04,0x0e,0x04]

v_div_fixup_f32 v5, -4.0, v2, v3
// GFX10: encoding: [0x05,0x00,0x5f,0xd5,0xf7,0x04,0x0e,0x04]

v_div_fixup_f32 v5, v1, v255, v3
// GFX10: encoding: [0x05,0x00,0x5f,0xd5,0x01,0xff,0x0f,0x04]

v_div_fixup_f32 v5, v1, s2, v3
// GFX10: encoding: [0x05,0x00,0x5f,0xd5,0x01,0x05,0x0c,0x04]

v_div_fixup_f32 v5, v1, s103, v3
// GFX10: encoding: [0x05,0x00,0x5f,0xd5,0x01,0xcf,0x0c,0x04]

v_div_fixup_f32 v5, v1, vcc_lo, v3
// GFX10: encoding: [0x05,0x00,0x5f,0xd5,0x01,0xd5,0x0c,0x04]

v_div_fixup_f32 v5, v1, vcc_hi, v3
// GFX10: encoding: [0x05,0x00,0x5f,0xd5,0x01,0xd7,0x0c,0x04]

v_div_fixup_f32 v5, v1, ttmp11, v3
// GFX10: encoding: [0x05,0x00,0x5f,0xd5,0x01,0xef,0x0c,0x04]

v_div_fixup_f32 v5, v1, m0, v3
// GFX10: encoding: [0x05,0x00,0x5f,0xd5,0x01,0xf9,0x0c,0x04]

v_div_fixup_f32 v5, v1, exec_lo, v3
// GFX10: encoding: [0x05,0x00,0x5f,0xd5,0x01,0xfd,0x0c,0x04]

v_div_fixup_f32 v5, v1, exec_hi, v3
// GFX10: encoding: [0x05,0x00,0x5f,0xd5,0x01,0xff,0x0c,0x04]

v_div_fixup_f32 v5, v1, 0, v3
// GFX10: encoding: [0x05,0x00,0x5f,0xd5,0x01,0x01,0x0d,0x04]

v_div_fixup_f32 v5, v1, -1, v3
// GFX10: encoding: [0x05,0x00,0x5f,0xd5,0x01,0x83,0x0d,0x04]

v_div_fixup_f32 v5, v1, 0.5, v3
// GFX10: encoding: [0x05,0x00,0x5f,0xd5,0x01,0xe1,0x0d,0x04]

v_div_fixup_f32 v5, v1, -4.0, v3
// GFX10: encoding: [0x05,0x00,0x5f,0xd5,0x01,0xef,0x0d,0x04]

v_div_fixup_f32 v5, v1, v2, v255
// GFX10: encoding: [0x05,0x00,0x5f,0xd5,0x01,0x05,0xfe,0x07]

v_div_fixup_f32 v5, v1, v2, s3
// GFX10: encoding: [0x05,0x00,0x5f,0xd5,0x01,0x05,0x0e,0x00]

v_div_fixup_f32 v5, v1, v2, s103
// GFX10: encoding: [0x05,0x00,0x5f,0xd5,0x01,0x05,0x9e,0x01]

v_div_fixup_f32 v5, v1, v2, vcc_lo
// GFX10: encoding: [0x05,0x00,0x5f,0xd5,0x01,0x05,0xaa,0x01]

v_div_fixup_f32 v5, v1, v2, vcc_hi
// GFX10: encoding: [0x05,0x00,0x5f,0xd5,0x01,0x05,0xae,0x01]

v_div_fixup_f32 v5, v1, v2, ttmp11
// GFX10: encoding: [0x05,0x00,0x5f,0xd5,0x01,0x05,0xde,0x01]

v_div_fixup_f32 v5, v1, v2, m0
// GFX10: encoding: [0x05,0x00,0x5f,0xd5,0x01,0x05,0xf2,0x01]

v_div_fixup_f32 v5, v1, v2, exec_lo
// GFX10: encoding: [0x05,0x00,0x5f,0xd5,0x01,0x05,0xfa,0x01]

v_div_fixup_f32 v5, v1, v2, exec_hi
// GFX10: encoding: [0x05,0x00,0x5f,0xd5,0x01,0x05,0xfe,0x01]

v_div_fixup_f32 v5, v1, v2, 0
// GFX10: encoding: [0x05,0x00,0x5f,0xd5,0x01,0x05,0x02,0x02]

v_div_fixup_f32 v5, v1, v2, -1
// GFX10: encoding: [0x05,0x00,0x5f,0xd5,0x01,0x05,0x06,0x03]

v_div_fixup_f32 v5, v1, v2, 0.5
// GFX10: encoding: [0x05,0x00,0x5f,0xd5,0x01,0x05,0xc2,0x03]

v_div_fixup_f32 v5, v1, v2, -4.0
// GFX10: encoding: [0x05,0x00,0x5f,0xd5,0x01,0x05,0xde,0x03]

v_div_fixup_f32 v5, -v1, v2, v3
// GFX10: encoding: [0x05,0x00,0x5f,0xd5,0x01,0x05,0x0e,0x24]

v_div_fixup_f32 v5, v1, -v2, v3
// GFX10: encoding: [0x05,0x00,0x5f,0xd5,0x01,0x05,0x0e,0x44]

v_div_fixup_f32 v5, v1, v2, -v3
// GFX10: encoding: [0x05,0x00,0x5f,0xd5,0x01,0x05,0x0e,0x84]

v_div_fixup_f32 v5, -v1, -v2, -v3
// GFX10: encoding: [0x05,0x00,0x5f,0xd5,0x01,0x05,0x0e,0xe4]

v_div_fixup_f32 v5, |v1|, v2, v3
// GFX10: encoding: [0x05,0x01,0x5f,0xd5,0x01,0x05,0x0e,0x04]

v_div_fixup_f32 v5, v1, |v2|, v3
// GFX10: encoding: [0x05,0x02,0x5f,0xd5,0x01,0x05,0x0e,0x04]

v_div_fixup_f32 v5, v1, v2, |v3|
// GFX10: encoding: [0x05,0x04,0x5f,0xd5,0x01,0x05,0x0e,0x04]

v_div_fixup_f32 v5, |v1|, |v2|, |v3|
// GFX10: encoding: [0x05,0x07,0x5f,0xd5,0x01,0x05,0x0e,0x04]

v_div_fixup_f32 v5, v1, v2, v3 clamp
// GFX10: encoding: [0x05,0x80,0x5f,0xd5,0x01,0x05,0x0e,0x04]

v_div_fixup_f32 v5, v1, v2, v3 mul:2
// GFX10: encoding: [0x05,0x00,0x5f,0xd5,0x01,0x05,0x0e,0x0c]

v_div_fixup_f32 v5, v1, v2, v3 mul:4
// GFX10: encoding: [0x05,0x00,0x5f,0xd5,0x01,0x05,0x0e,0x14]

v_div_fixup_f32 v5, v1, v2, v3 div:2
// GFX10: encoding: [0x05,0x00,0x5f,0xd5,0x01,0x05,0x0e,0x1c]

v_div_fixup_f64 v[5:6], v[1:2], v[2:3], v[3:4]
// GFX10: encoding: [0x05,0x00,0x60,0xd5,0x01,0x05,0x0e,0x04]

v_div_fixup_f64 v[254:255], v[1:2], v[2:3], v[3:4]
// GFX10: encoding: [0xfe,0x00,0x60,0xd5,0x01,0x05,0x0e,0x04]

v_div_fixup_f64 v[5:6], v[254:255], v[2:3], v[3:4]
// GFX10: encoding: [0x05,0x00,0x60,0xd5,0xfe,0x05,0x0e,0x04]

v_div_fixup_f64 v[5:6], s[2:3], v[2:3], v[3:4]
// GFX10: encoding: [0x05,0x00,0x60,0xd5,0x02,0x04,0x0e,0x04]

v_div_fixup_f64 v[5:6], s[4:5], v[2:3], v[3:4]
// GFX10: encoding: [0x05,0x00,0x60,0xd5,0x04,0x04,0x0e,0x04]

v_div_fixup_f64 v[5:6], s[102:103], v[2:3], v[3:4]
// GFX10: encoding: [0x05,0x00,0x60,0xd5,0x66,0x04,0x0e,0x04]

v_div_fixup_f64 v[5:6], vcc, v[2:3], v[3:4]
// GFX10: encoding: [0x05,0x00,0x60,0xd5,0x6a,0x04,0x0e,0x04]

v_div_fixup_f64 v[5:6], ttmp[10:11], v[2:3], v[3:4]
// GFX10: encoding: [0x05,0x00,0x60,0xd5,0x76,0x04,0x0e,0x04]

v_div_fixup_f64 v[5:6], exec, v[2:3], v[3:4]
// GFX10: encoding: [0x05,0x00,0x60,0xd5,0x7e,0x04,0x0e,0x04]

v_div_fixup_f64 v[5:6], 0, v[2:3], v[3:4]
// GFX10: encoding: [0x05,0x00,0x60,0xd5,0x80,0x04,0x0e,0x04]

v_div_fixup_f64 v[5:6], -1, v[2:3], v[3:4]
// GFX10: encoding: [0x05,0x00,0x60,0xd5,0xc1,0x04,0x0e,0x04]

v_div_fixup_f64 v[5:6], 0.5, v[2:3], v[3:4]
// GFX10: encoding: [0x05,0x00,0x60,0xd5,0xf0,0x04,0x0e,0x04]

v_div_fixup_f64 v[5:6], -4.0, v[2:3], v[3:4]
// GFX10: encoding: [0x05,0x00,0x60,0xd5,0xf7,0x04,0x0e,0x04]

v_div_fixup_f64 v[5:6], v[1:2], v[254:255], v[3:4]
// GFX10: encoding: [0x05,0x00,0x60,0xd5,0x01,0xfd,0x0f,0x04]

v_div_fixup_f64 v[5:6], v[1:2], s[4:5], v[3:4]
// GFX10: encoding: [0x05,0x00,0x60,0xd5,0x01,0x09,0x0c,0x04]

v_div_fixup_f64 v[5:6], v[1:2], s[6:7], v[3:4]
// GFX10: encoding: [0x05,0x00,0x60,0xd5,0x01,0x0d,0x0c,0x04]

v_div_fixup_f64 v[5:6], v[1:2], s[102:103], v[3:4]
// GFX10: encoding: [0x05,0x00,0x60,0xd5,0x01,0xcd,0x0c,0x04]

v_div_fixup_f64 v[5:6], v[1:2], vcc, v[3:4]
// GFX10: encoding: [0x05,0x00,0x60,0xd5,0x01,0xd5,0x0c,0x04]

v_div_fixup_f64 v[5:6], v[1:2], ttmp[10:11], v[3:4]
// GFX10: encoding: [0x05,0x00,0x60,0xd5,0x01,0xed,0x0c,0x04]

v_div_fixup_f64 v[5:6], v[1:2], exec, v[3:4]
// GFX10: encoding: [0x05,0x00,0x60,0xd5,0x01,0xfd,0x0c,0x04]

v_div_fixup_f64 v[5:6], v[1:2], 0, v[3:4]
// GFX10: encoding: [0x05,0x00,0x60,0xd5,0x01,0x01,0x0d,0x04]

v_div_fixup_f64 v[5:6], v[1:2], -1, v[3:4]
// GFX10: encoding: [0x05,0x00,0x60,0xd5,0x01,0x83,0x0d,0x04]

v_div_fixup_f64 v[5:6], v[1:2], 0.5, v[3:4]
// GFX10: encoding: [0x05,0x00,0x60,0xd5,0x01,0xe1,0x0d,0x04]

v_div_fixup_f64 v[5:6], v[1:2], -4.0, v[3:4]
// GFX10: encoding: [0x05,0x00,0x60,0xd5,0x01,0xef,0x0d,0x04]

v_div_fixup_f64 v[5:6], v[1:2], v[2:3], v[254:255]
// GFX10: encoding: [0x05,0x00,0x60,0xd5,0x01,0x05,0xfa,0x07]

v_div_fixup_f64 v[5:6], v[1:2], v[2:3], s[6:7]
// GFX10: encoding: [0x05,0x00,0x60,0xd5,0x01,0x05,0x1a,0x00]

v_div_fixup_f64 v[5:6], v[1:2], v[2:3], s[8:9]
// GFX10: encoding: [0x05,0x00,0x60,0xd5,0x01,0x05,0x22,0x00]

v_div_fixup_f64 v[5:6], v[1:2], v[2:3], s[102:103]
// GFX10: encoding: [0x05,0x00,0x60,0xd5,0x01,0x05,0x9a,0x01]

v_div_fixup_f64 v[5:6], v[1:2], v[2:3], vcc
// GFX10: encoding: [0x05,0x00,0x60,0xd5,0x01,0x05,0xaa,0x01]

v_div_fixup_f64 v[5:6], v[1:2], v[2:3], ttmp[10:11]
// GFX10: encoding: [0x05,0x00,0x60,0xd5,0x01,0x05,0xda,0x01]

v_div_fixup_f64 v[5:6], v[1:2], v[2:3], exec
// GFX10: encoding: [0x05,0x00,0x60,0xd5,0x01,0x05,0xfa,0x01]

v_div_fixup_f64 v[5:6], v[1:2], v[2:3], 0
// GFX10: encoding: [0x05,0x00,0x60,0xd5,0x01,0x05,0x02,0x02]

v_div_fixup_f64 v[5:6], v[1:2], v[2:3], -1
// GFX10: encoding: [0x05,0x00,0x60,0xd5,0x01,0x05,0x06,0x03]

v_div_fixup_f64 v[5:6], v[1:2], v[2:3], 0.5
// GFX10: encoding: [0x05,0x00,0x60,0xd5,0x01,0x05,0xc2,0x03]

v_div_fixup_f64 v[5:6], v[1:2], v[2:3], -4.0
// GFX10: encoding: [0x05,0x00,0x60,0xd5,0x01,0x05,0xde,0x03]

v_div_fixup_f64 v[5:6], -v[1:2], v[2:3], v[3:4]
// GFX10: encoding: [0x05,0x00,0x60,0xd5,0x01,0x05,0x0e,0x24]

v_div_fixup_f64 v[5:6], v[1:2], -v[2:3], v[3:4]
// GFX10: encoding: [0x05,0x00,0x60,0xd5,0x01,0x05,0x0e,0x44]

v_div_fixup_f64 v[5:6], v[1:2], v[2:3], -v[3:4]
// GFX10: encoding: [0x05,0x00,0x60,0xd5,0x01,0x05,0x0e,0x84]

v_div_fixup_f64 v[5:6], -v[1:2], -v[2:3], -v[3:4]
// GFX10: encoding: [0x05,0x00,0x60,0xd5,0x01,0x05,0x0e,0xe4]

v_div_fixup_f64 v[5:6], |v[1:2]|, v[2:3], v[3:4]
// GFX10: encoding: [0x05,0x01,0x60,0xd5,0x01,0x05,0x0e,0x04]

v_div_fixup_f64 v[5:6], v[1:2], |v[2:3]|, v[3:4]
// GFX10: encoding: [0x05,0x02,0x60,0xd5,0x01,0x05,0x0e,0x04]

v_div_fixup_f64 v[5:6], v[1:2], v[2:3], |v[3:4]|
// GFX10: encoding: [0x05,0x04,0x60,0xd5,0x01,0x05,0x0e,0x04]

v_div_fixup_f64 v[5:6], |v[1:2]|, |v[2:3]|, |v[3:4]|
// GFX10: encoding: [0x05,0x07,0x60,0xd5,0x01,0x05,0x0e,0x04]

v_div_fixup_f64 v[5:6], v[1:2], v[2:3], v[3:4] clamp
// GFX10: encoding: [0x05,0x80,0x60,0xd5,0x01,0x05,0x0e,0x04]

v_div_fixup_f64 v[5:6], v[1:2], v[2:3], v[3:4] mul:2
// GFX10: encoding: [0x05,0x00,0x60,0xd5,0x01,0x05,0x0e,0x0c]

v_div_fixup_f64 v[5:6], v[1:2], v[2:3], v[3:4] mul:4
// GFX10: encoding: [0x05,0x00,0x60,0xd5,0x01,0x05,0x0e,0x14]

v_div_fixup_f64 v[5:6], v[1:2], v[2:3], v[3:4] div:2
// GFX10: encoding: [0x05,0x00,0x60,0xd5,0x01,0x05,0x0e,0x1c]

v_add_f64 v[5:6], v[1:2], v[2:3]
// GFX10: encoding: [0x05,0x00,0x64,0xd5,0x01,0x05,0x02,0x00]

v_add_f64 v[254:255], v[1:2], v[2:3]
// GFX10: encoding: [0xfe,0x00,0x64,0xd5,0x01,0x05,0x02,0x00]

v_add_f64 v[5:6], v[254:255], v[2:3]
// GFX10: encoding: [0x05,0x00,0x64,0xd5,0xfe,0x05,0x02,0x00]

v_add_f64 v[5:6], s[2:3], v[2:3]
// GFX10: encoding: [0x05,0x00,0x64,0xd5,0x02,0x04,0x02,0x00]

v_add_f64 v[5:6], s[4:5], v[2:3]
// GFX10: encoding: [0x05,0x00,0x64,0xd5,0x04,0x04,0x02,0x00]

v_add_f64 v[5:6], s[102:103], v[2:3]
// GFX10: encoding: [0x05,0x00,0x64,0xd5,0x66,0x04,0x02,0x00]

v_add_f64 v[5:6], vcc, v[2:3]
// GFX10: encoding: [0x05,0x00,0x64,0xd5,0x6a,0x04,0x02,0x00]

v_add_f64 v[5:6], ttmp[10:11], v[2:3]
// GFX10: encoding: [0x05,0x00,0x64,0xd5,0x76,0x04,0x02,0x00]

v_add_f64 v[5:6], exec, v[2:3]
// GFX10: encoding: [0x05,0x00,0x64,0xd5,0x7e,0x04,0x02,0x00]

v_add_f64 v[5:6], 0, v[2:3]
// GFX10: encoding: [0x05,0x00,0x64,0xd5,0x80,0x04,0x02,0x00]

v_add_f64 v[5:6], -1, v[2:3]
// GFX10: encoding: [0x05,0x00,0x64,0xd5,0xc1,0x04,0x02,0x00]

v_add_f64 v[5:6], 0.5, v[2:3]
// GFX10: encoding: [0x05,0x00,0x64,0xd5,0xf0,0x04,0x02,0x00]

v_add_f64 v[5:6], -4.0, v[2:3]
// GFX10: encoding: [0x05,0x00,0x64,0xd5,0xf7,0x04,0x02,0x00]

v_add_f64 v[5:6], v[1:2], v[254:255]
// GFX10: encoding: [0x05,0x00,0x64,0xd5,0x01,0xfd,0x03,0x00]

v_add_f64 v[5:6], v[1:2], s[4:5]
// GFX10: encoding: [0x05,0x00,0x64,0xd5,0x01,0x09,0x00,0x00]

v_add_f64 v[5:6], v[1:2], s[6:7]
// GFX10: encoding: [0x05,0x00,0x64,0xd5,0x01,0x0d,0x00,0x00]

v_add_f64 v[5:6], v[1:2], s[102:103]
// GFX10: encoding: [0x05,0x00,0x64,0xd5,0x01,0xcd,0x00,0x00]

v_add_f64 v[5:6], v[1:2], vcc
// GFX10: encoding: [0x05,0x00,0x64,0xd5,0x01,0xd5,0x00,0x00]

v_add_f64 v[5:6], v[1:2], ttmp[10:11]
// GFX10: encoding: [0x05,0x00,0x64,0xd5,0x01,0xed,0x00,0x00]

v_add_f64 v[5:6], v[1:2], exec
// GFX10: encoding: [0x05,0x00,0x64,0xd5,0x01,0xfd,0x00,0x00]

v_add_f64 v[5:6], v[1:2], 0
// GFX10: encoding: [0x05,0x00,0x64,0xd5,0x01,0x01,0x01,0x00]

v_add_f64 v[5:6], v[1:2], -1
// GFX10: encoding: [0x05,0x00,0x64,0xd5,0x01,0x83,0x01,0x00]

v_add_f64 v[5:6], v[1:2], 0.5
// GFX10: encoding: [0x05,0x00,0x64,0xd5,0x01,0xe1,0x01,0x00]

v_add_f64 v[5:6], v[1:2], -4.0
// GFX10: encoding: [0x05,0x00,0x64,0xd5,0x01,0xef,0x01,0x00]

v_add_f64 v[5:6], -v[1:2], v[2:3]
// GFX10: encoding: [0x05,0x00,0x64,0xd5,0x01,0x05,0x02,0x20]

v_add_f64 v[5:6], v[1:2], -v[2:3]
// GFX10: encoding: [0x05,0x00,0x64,0xd5,0x01,0x05,0x02,0x40]

v_add_f64 v[5:6], -v[1:2], -v[2:3]
// GFX10: encoding: [0x05,0x00,0x64,0xd5,0x01,0x05,0x02,0x60]

v_add_f64 v[5:6], |v[1:2]|, v[2:3]
// GFX10: encoding: [0x05,0x01,0x64,0xd5,0x01,0x05,0x02,0x00]

v_add_f64 v[5:6], v[1:2], |v[2:3]|
// GFX10: encoding: [0x05,0x02,0x64,0xd5,0x01,0x05,0x02,0x00]

v_add_f64 v[5:6], |v[1:2]|, |v[2:3]|
// GFX10: encoding: [0x05,0x03,0x64,0xd5,0x01,0x05,0x02,0x00]

v_add_f64 v[5:6], v[1:2], v[2:3] clamp
// GFX10: encoding: [0x05,0x80,0x64,0xd5,0x01,0x05,0x02,0x00]

v_add_f64 v[5:6], v[1:2], v[2:3] mul:2
// GFX10: encoding: [0x05,0x00,0x64,0xd5,0x01,0x05,0x02,0x08]

v_add_f64 v[5:6], v[1:2], v[2:3] mul:4
// GFX10: encoding: [0x05,0x00,0x64,0xd5,0x01,0x05,0x02,0x10]

v_add_f64 v[5:6], v[1:2], v[2:3] div:2
// GFX10: encoding: [0x05,0x00,0x64,0xd5,0x01,0x05,0x02,0x18]

v_mul_f64 v[5:6], v[1:2], v[2:3]
// GFX10: encoding: [0x05,0x00,0x65,0xd5,0x01,0x05,0x02,0x00]

v_mul_f64 v[254:255], v[1:2], v[2:3]
// GFX10: encoding: [0xfe,0x00,0x65,0xd5,0x01,0x05,0x02,0x00]

v_mul_f64 v[5:6], v[254:255], v[2:3]
// GFX10: encoding: [0x05,0x00,0x65,0xd5,0xfe,0x05,0x02,0x00]

v_mul_f64 v[5:6], s[2:3], v[2:3]
// GFX10: encoding: [0x05,0x00,0x65,0xd5,0x02,0x04,0x02,0x00]

v_mul_f64 v[5:6], s[4:5], v[2:3]
// GFX10: encoding: [0x05,0x00,0x65,0xd5,0x04,0x04,0x02,0x00]

v_mul_f64 v[5:6], s[102:103], v[2:3]
// GFX10: encoding: [0x05,0x00,0x65,0xd5,0x66,0x04,0x02,0x00]

v_mul_f64 v[5:6], vcc, v[2:3]
// GFX10: encoding: [0x05,0x00,0x65,0xd5,0x6a,0x04,0x02,0x00]

v_mul_f64 v[5:6], ttmp[10:11], v[2:3]
// GFX10: encoding: [0x05,0x00,0x65,0xd5,0x76,0x04,0x02,0x00]

v_mul_f64 v[5:6], exec, v[2:3]
// GFX10: encoding: [0x05,0x00,0x65,0xd5,0x7e,0x04,0x02,0x00]

v_mul_f64 v[5:6], 0, v[2:3]
// GFX10: encoding: [0x05,0x00,0x65,0xd5,0x80,0x04,0x02,0x00]

v_mul_f64 v[5:6], -1, v[2:3]
// GFX10: encoding: [0x05,0x00,0x65,0xd5,0xc1,0x04,0x02,0x00]

v_mul_f64 v[5:6], 0.5, v[2:3]
// GFX10: encoding: [0x05,0x00,0x65,0xd5,0xf0,0x04,0x02,0x00]

v_mul_f64 v[5:6], -4.0, v[2:3]
// GFX10: encoding: [0x05,0x00,0x65,0xd5,0xf7,0x04,0x02,0x00]

v_mul_f64 v[5:6], v[1:2], v[254:255]
// GFX10: encoding: [0x05,0x00,0x65,0xd5,0x01,0xfd,0x03,0x00]

v_mul_f64 v[5:6], v[1:2], s[4:5]
// GFX10: encoding: [0x05,0x00,0x65,0xd5,0x01,0x09,0x00,0x00]

v_mul_f64 v[5:6], v[1:2], s[6:7]
// GFX10: encoding: [0x05,0x00,0x65,0xd5,0x01,0x0d,0x00,0x00]

v_mul_f64 v[5:6], v[1:2], s[102:103]
// GFX10: encoding: [0x05,0x00,0x65,0xd5,0x01,0xcd,0x00,0x00]

v_mul_f64 v[5:6], v[1:2], vcc
// GFX10: encoding: [0x05,0x00,0x65,0xd5,0x01,0xd5,0x00,0x00]

v_mul_f64 v[5:6], v[1:2], ttmp[10:11]
// GFX10: encoding: [0x05,0x00,0x65,0xd5,0x01,0xed,0x00,0x00]

v_mul_f64 v[5:6], v[1:2], exec
// GFX10: encoding: [0x05,0x00,0x65,0xd5,0x01,0xfd,0x00,0x00]

v_mul_f64 v[5:6], v[1:2], 0
// GFX10: encoding: [0x05,0x00,0x65,0xd5,0x01,0x01,0x01,0x00]

v_mul_f64 v[5:6], v[1:2], -1
// GFX10: encoding: [0x05,0x00,0x65,0xd5,0x01,0x83,0x01,0x00]

v_mul_f64 v[5:6], v[1:2], 0.5
// GFX10: encoding: [0x05,0x00,0x65,0xd5,0x01,0xe1,0x01,0x00]

v_mul_f64 v[5:6], v[1:2], -4.0
// GFX10: encoding: [0x05,0x00,0x65,0xd5,0x01,0xef,0x01,0x00]

v_mul_f64 v[5:6], -v[1:2], v[2:3]
// GFX10: encoding: [0x05,0x00,0x65,0xd5,0x01,0x05,0x02,0x20]

v_mul_f64 v[5:6], v[1:2], -v[2:3]
// GFX10: encoding: [0x05,0x00,0x65,0xd5,0x01,0x05,0x02,0x40]

v_mul_f64 v[5:6], -v[1:2], -v[2:3]
// GFX10: encoding: [0x05,0x00,0x65,0xd5,0x01,0x05,0x02,0x60]

v_mul_f64 v[5:6], |v[1:2]|, v[2:3]
// GFX10: encoding: [0x05,0x01,0x65,0xd5,0x01,0x05,0x02,0x00]

v_mul_f64 v[5:6], v[1:2], |v[2:3]|
// GFX10: encoding: [0x05,0x02,0x65,0xd5,0x01,0x05,0x02,0x00]

v_mul_f64 v[5:6], |v[1:2]|, |v[2:3]|
// GFX10: encoding: [0x05,0x03,0x65,0xd5,0x01,0x05,0x02,0x00]

v_mul_f64 v[5:6], v[1:2], v[2:3] clamp
// GFX10: encoding: [0x05,0x80,0x65,0xd5,0x01,0x05,0x02,0x00]

v_mul_f64 v[5:6], v[1:2], v[2:3] mul:2
// GFX10: encoding: [0x05,0x00,0x65,0xd5,0x01,0x05,0x02,0x08]

v_mul_f64 v[5:6], v[1:2], v[2:3] mul:4
// GFX10: encoding: [0x05,0x00,0x65,0xd5,0x01,0x05,0x02,0x10]

v_mul_f64 v[5:6], v[1:2], v[2:3] div:2
// GFX10: encoding: [0x05,0x00,0x65,0xd5,0x01,0x05,0x02,0x18]

v_min_f64 v[5:6], v[1:2], v[2:3]
// GFX10: encoding: [0x05,0x00,0x66,0xd5,0x01,0x05,0x02,0x00]

v_min_f64 v[254:255], v[1:2], v[2:3]
// GFX10: encoding: [0xfe,0x00,0x66,0xd5,0x01,0x05,0x02,0x00]

v_min_f64 v[5:6], v[254:255], v[2:3]
// GFX10: encoding: [0x05,0x00,0x66,0xd5,0xfe,0x05,0x02,0x00]

v_min_f64 v[5:6], s[2:3], v[2:3]
// GFX10: encoding: [0x05,0x00,0x66,0xd5,0x02,0x04,0x02,0x00]

v_min_f64 v[5:6], s[4:5], v[2:3]
// GFX10: encoding: [0x05,0x00,0x66,0xd5,0x04,0x04,0x02,0x00]

v_min_f64 v[5:6], s[102:103], v[2:3]
// GFX10: encoding: [0x05,0x00,0x66,0xd5,0x66,0x04,0x02,0x00]

v_min_f64 v[5:6], vcc, v[2:3]
// GFX10: encoding: [0x05,0x00,0x66,0xd5,0x6a,0x04,0x02,0x00]

v_min_f64 v[5:6], ttmp[10:11], v[2:3]
// GFX10: encoding: [0x05,0x00,0x66,0xd5,0x76,0x04,0x02,0x00]

v_min_f64 v[5:6], exec, v[2:3]
// GFX10: encoding: [0x05,0x00,0x66,0xd5,0x7e,0x04,0x02,0x00]

v_min_f64 v[5:6], 0, v[2:3]
// GFX10: encoding: [0x05,0x00,0x66,0xd5,0x80,0x04,0x02,0x00]

v_min_f64 v[5:6], -1, v[2:3]
// GFX10: encoding: [0x05,0x00,0x66,0xd5,0xc1,0x04,0x02,0x00]

v_min_f64 v[5:6], 0.5, v[2:3]
// GFX10: encoding: [0x05,0x00,0x66,0xd5,0xf0,0x04,0x02,0x00]

v_min_f64 v[5:6], -4.0, v[2:3]
// GFX10: encoding: [0x05,0x00,0x66,0xd5,0xf7,0x04,0x02,0x00]

v_min_f64 v[5:6], v[1:2], v[254:255]
// GFX10: encoding: [0x05,0x00,0x66,0xd5,0x01,0xfd,0x03,0x00]

v_min_f64 v[5:6], v[1:2], s[4:5]
// GFX10: encoding: [0x05,0x00,0x66,0xd5,0x01,0x09,0x00,0x00]

v_min_f64 v[5:6], v[1:2], s[6:7]
// GFX10: encoding: [0x05,0x00,0x66,0xd5,0x01,0x0d,0x00,0x00]

v_min_f64 v[5:6], v[1:2], s[102:103]
// GFX10: encoding: [0x05,0x00,0x66,0xd5,0x01,0xcd,0x00,0x00]

v_min_f64 v[5:6], v[1:2], vcc
// GFX10: encoding: [0x05,0x00,0x66,0xd5,0x01,0xd5,0x00,0x00]

v_min_f64 v[5:6], v[1:2], ttmp[10:11]
// GFX10: encoding: [0x05,0x00,0x66,0xd5,0x01,0xed,0x00,0x00]

v_min_f64 v[5:6], v[1:2], exec
// GFX10: encoding: [0x05,0x00,0x66,0xd5,0x01,0xfd,0x00,0x00]

v_min_f64 v[5:6], v[1:2], 0
// GFX10: encoding: [0x05,0x00,0x66,0xd5,0x01,0x01,0x01,0x00]

v_min_f64 v[5:6], v[1:2], -1
// GFX10: encoding: [0x05,0x00,0x66,0xd5,0x01,0x83,0x01,0x00]

v_min_f64 v[5:6], v[1:2], 0.5
// GFX10: encoding: [0x05,0x00,0x66,0xd5,0x01,0xe1,0x01,0x00]

v_min_f64 v[5:6], v[1:2], -4.0
// GFX10: encoding: [0x05,0x00,0x66,0xd5,0x01,0xef,0x01,0x00]

v_min_f64 v[5:6], -v[1:2], v[2:3]
// GFX10: encoding: [0x05,0x00,0x66,0xd5,0x01,0x05,0x02,0x20]

v_min_f64 v[5:6], v[1:2], -v[2:3]
// GFX10: encoding: [0x05,0x00,0x66,0xd5,0x01,0x05,0x02,0x40]

v_min_f64 v[5:6], -v[1:2], -v[2:3]
// GFX10: encoding: [0x05,0x00,0x66,0xd5,0x01,0x05,0x02,0x60]

v_min_f64 v[5:6], |v[1:2]|, v[2:3]
// GFX10: encoding: [0x05,0x01,0x66,0xd5,0x01,0x05,0x02,0x00]

v_min_f64 v[5:6], v[1:2], |v[2:3]|
// GFX10: encoding: [0x05,0x02,0x66,0xd5,0x01,0x05,0x02,0x00]

v_min_f64 v[5:6], |v[1:2]|, |v[2:3]|
// GFX10: encoding: [0x05,0x03,0x66,0xd5,0x01,0x05,0x02,0x00]

v_min_f64 v[5:6], v[1:2], v[2:3] clamp
// GFX10: encoding: [0x05,0x80,0x66,0xd5,0x01,0x05,0x02,0x00]

v_min_f64 v[5:6], v[1:2], v[2:3] mul:2
// GFX10: encoding: [0x05,0x00,0x66,0xd5,0x01,0x05,0x02,0x08]

v_min_f64 v[5:6], v[1:2], v[2:3] mul:4
// GFX10: encoding: [0x05,0x00,0x66,0xd5,0x01,0x05,0x02,0x10]

v_min_f64 v[5:6], v[1:2], v[2:3] div:2
// GFX10: encoding: [0x05,0x00,0x66,0xd5,0x01,0x05,0x02,0x18]

v_max_f64 v[5:6], v[1:2], v[2:3]
// GFX10: encoding: [0x05,0x00,0x67,0xd5,0x01,0x05,0x02,0x00]

v_max_f64 v[254:255], v[1:2], v[2:3]
// GFX10: encoding: [0xfe,0x00,0x67,0xd5,0x01,0x05,0x02,0x00]

v_max_f64 v[5:6], v[254:255], v[2:3]
// GFX10: encoding: [0x05,0x00,0x67,0xd5,0xfe,0x05,0x02,0x00]

v_max_f64 v[5:6], s[2:3], v[2:3]
// GFX10: encoding: [0x05,0x00,0x67,0xd5,0x02,0x04,0x02,0x00]

v_max_f64 v[5:6], s[4:5], v[2:3]
// GFX10: encoding: [0x05,0x00,0x67,0xd5,0x04,0x04,0x02,0x00]

v_max_f64 v[5:6], s[102:103], v[2:3]
// GFX10: encoding: [0x05,0x00,0x67,0xd5,0x66,0x04,0x02,0x00]

v_max_f64 v[5:6], vcc, v[2:3]
// GFX10: encoding: [0x05,0x00,0x67,0xd5,0x6a,0x04,0x02,0x00]

v_max_f64 v[5:6], ttmp[10:11], v[2:3]
// GFX10: encoding: [0x05,0x00,0x67,0xd5,0x76,0x04,0x02,0x00]

v_max_f64 v[5:6], exec, v[2:3]
// GFX10: encoding: [0x05,0x00,0x67,0xd5,0x7e,0x04,0x02,0x00]

v_max_f64 v[5:6], 0, v[2:3]
// GFX10: encoding: [0x05,0x00,0x67,0xd5,0x80,0x04,0x02,0x00]

v_max_f64 v[5:6], -1, v[2:3]
// GFX10: encoding: [0x05,0x00,0x67,0xd5,0xc1,0x04,0x02,0x00]

v_max_f64 v[5:6], 0.5, v[2:3]
// GFX10: encoding: [0x05,0x00,0x67,0xd5,0xf0,0x04,0x02,0x00]

v_max_f64 v[5:6], -4.0, v[2:3]
// GFX10: encoding: [0x05,0x00,0x67,0xd5,0xf7,0x04,0x02,0x00]

v_max_f64 v[5:6], v[1:2], v[254:255]
// GFX10: encoding: [0x05,0x00,0x67,0xd5,0x01,0xfd,0x03,0x00]

v_max_f64 v[5:6], v[1:2], s[4:5]
// GFX10: encoding: [0x05,0x00,0x67,0xd5,0x01,0x09,0x00,0x00]

v_max_f64 v[5:6], v[1:2], s[6:7]
// GFX10: encoding: [0x05,0x00,0x67,0xd5,0x01,0x0d,0x00,0x00]

v_max_f64 v[5:6], v[1:2], s[102:103]
// GFX10: encoding: [0x05,0x00,0x67,0xd5,0x01,0xcd,0x00,0x00]

v_max_f64 v[5:6], v[1:2], vcc
// GFX10: encoding: [0x05,0x00,0x67,0xd5,0x01,0xd5,0x00,0x00]

v_max_f64 v[5:6], v[1:2], ttmp[10:11]
// GFX10: encoding: [0x05,0x00,0x67,0xd5,0x01,0xed,0x00,0x00]

v_max_f64 v[5:6], v[1:2], exec
// GFX10: encoding: [0x05,0x00,0x67,0xd5,0x01,0xfd,0x00,0x00]

v_max_f64 v[5:6], v[1:2], 0
// GFX10: encoding: [0x05,0x00,0x67,0xd5,0x01,0x01,0x01,0x00]

v_max_f64 v[5:6], v[1:2], -1
// GFX10: encoding: [0x05,0x00,0x67,0xd5,0x01,0x83,0x01,0x00]

v_max_f64 v[5:6], v[1:2], 0.5
// GFX10: encoding: [0x05,0x00,0x67,0xd5,0x01,0xe1,0x01,0x00]

v_max_f64 v[5:6], v[1:2], -4.0
// GFX10: encoding: [0x05,0x00,0x67,0xd5,0x01,0xef,0x01,0x00]

v_max_f64 v[5:6], -v[1:2], v[2:3]
// GFX10: encoding: [0x05,0x00,0x67,0xd5,0x01,0x05,0x02,0x20]

v_max_f64 v[5:6], v[1:2], -v[2:3]
// GFX10: encoding: [0x05,0x00,0x67,0xd5,0x01,0x05,0x02,0x40]

v_max_f64 v[5:6], -v[1:2], -v[2:3]
// GFX10: encoding: [0x05,0x00,0x67,0xd5,0x01,0x05,0x02,0x60]

v_max_f64 v[5:6], |v[1:2]|, v[2:3]
// GFX10: encoding: [0x05,0x01,0x67,0xd5,0x01,0x05,0x02,0x00]

v_max_f64 v[5:6], v[1:2], |v[2:3]|
// GFX10: encoding: [0x05,0x02,0x67,0xd5,0x01,0x05,0x02,0x00]

v_max_f64 v[5:6], |v[1:2]|, |v[2:3]|
// GFX10: encoding: [0x05,0x03,0x67,0xd5,0x01,0x05,0x02,0x00]

v_max_f64 v[5:6], v[1:2], v[2:3] clamp
// GFX10: encoding: [0x05,0x80,0x67,0xd5,0x01,0x05,0x02,0x00]

v_max_f64 v[5:6], v[1:2], v[2:3] mul:2
// GFX10: encoding: [0x05,0x00,0x67,0xd5,0x01,0x05,0x02,0x08]

v_max_f64 v[5:6], v[1:2], v[2:3] mul:4
// GFX10: encoding: [0x05,0x00,0x67,0xd5,0x01,0x05,0x02,0x10]

v_max_f64 v[5:6], v[1:2], v[2:3] div:2
// GFX10: encoding: [0x05,0x00,0x67,0xd5,0x01,0x05,0x02,0x18]

v_ldexp_f64 v[5:6], v[1:2], v2
// GFX10: encoding: [0x05,0x00,0x68,0xd5,0x01,0x05,0x02,0x00]

v_ldexp_f64 v[254:255], v[1:2], v2
// GFX10: encoding: [0xfe,0x00,0x68,0xd5,0x01,0x05,0x02,0x00]

v_ldexp_f64 v[5:6], v[254:255], v2
// GFX10: encoding: [0x05,0x00,0x68,0xd5,0xfe,0x05,0x02,0x00]

v_ldexp_f64 v[5:6], s[2:3], v2
// GFX10: encoding: [0x05,0x00,0x68,0xd5,0x02,0x04,0x02,0x00]

v_ldexp_f64 v[5:6], s[4:5], v2
// GFX10: encoding: [0x05,0x00,0x68,0xd5,0x04,0x04,0x02,0x00]

v_ldexp_f64 v[5:6], s[102:103], v2
// GFX10: encoding: [0x05,0x00,0x68,0xd5,0x66,0x04,0x02,0x00]

v_ldexp_f64 v[5:6], vcc, v2
// GFX10: encoding: [0x05,0x00,0x68,0xd5,0x6a,0x04,0x02,0x00]

v_ldexp_f64 v[5:6], ttmp[10:11], v2
// GFX10: encoding: [0x05,0x00,0x68,0xd5,0x76,0x04,0x02,0x00]

v_ldexp_f64 v[5:6], exec, v2
// GFX10: encoding: [0x05,0x00,0x68,0xd5,0x7e,0x04,0x02,0x00]

v_ldexp_f64 v[5:6], 0, v2
// GFX10: encoding: [0x05,0x00,0x68,0xd5,0x80,0x04,0x02,0x00]

v_ldexp_f64 v[5:6], -1, v2
// GFX10: encoding: [0x05,0x00,0x68,0xd5,0xc1,0x04,0x02,0x00]

v_ldexp_f64 v[5:6], 0.5, v2
// GFX10: encoding: [0x05,0x00,0x68,0xd5,0xf0,0x04,0x02,0x00]

v_ldexp_f64 v[5:6], -4.0, v2
// GFX10: encoding: [0x05,0x00,0x68,0xd5,0xf7,0x04,0x02,0x00]

v_ldexp_f64 v[5:6], v[1:2], v255
// GFX10: encoding: [0x05,0x00,0x68,0xd5,0x01,0xff,0x03,0x00]

v_ldexp_f64 v[5:6], v[1:2], s2
// GFX10: encoding: [0x05,0x00,0x68,0xd5,0x01,0x05,0x00,0x00]

v_ldexp_f64 v[5:6], v[1:2], s103
// GFX10: encoding: [0x05,0x00,0x68,0xd5,0x01,0xcf,0x00,0x00]

v_ldexp_f64 v[5:6], v[1:2], vcc_lo
// GFX10: encoding: [0x05,0x00,0x68,0xd5,0x01,0xd5,0x00,0x00]

v_ldexp_f64 v[5:6], v[1:2], vcc_hi
// GFX10: encoding: [0x05,0x00,0x68,0xd5,0x01,0xd7,0x00,0x00]

v_ldexp_f64 v[5:6], v[1:2], ttmp11
// GFX10: encoding: [0x05,0x00,0x68,0xd5,0x01,0xef,0x00,0x00]

v_ldexp_f64 v[5:6], v[1:2], m0
// GFX10: encoding: [0x05,0x00,0x68,0xd5,0x01,0xf9,0x00,0x00]

v_ldexp_f64 v[5:6], v[1:2], exec_lo
// GFX10: encoding: [0x05,0x00,0x68,0xd5,0x01,0xfd,0x00,0x00]

v_ldexp_f64 v[5:6], v[1:2], exec_hi
// GFX10: encoding: [0x05,0x00,0x68,0xd5,0x01,0xff,0x00,0x00]

v_ldexp_f64 v[5:6], v[1:2], 0
// GFX10: encoding: [0x05,0x00,0x68,0xd5,0x01,0x01,0x01,0x00]

v_ldexp_f64 v[5:6], v[1:2], -1
// GFX10: encoding: [0x05,0x00,0x68,0xd5,0x01,0x83,0x01,0x00]

v_ldexp_f64 v[5:6], v[1:2], 0.5
// GFX10: encoding: [0x05,0x00,0x68,0xd5,0x01,0xe1,0x01,0x00]

v_ldexp_f64 v[5:6], v[1:2], -4.0
// GFX10: encoding: [0x05,0x00,0x68,0xd5,0x01,0xef,0x01,0x00]

v_ldexp_f64 v[5:6], -v[1:2], v2
// GFX10: encoding: [0x05,0x00,0x68,0xd5,0x01,0x05,0x02,0x20]

v_ldexp_f64 v[5:6], |v[1:2]|, v2
// GFX10: encoding: [0x05,0x01,0x68,0xd5,0x01,0x05,0x02,0x00]

v_ldexp_f64 v[5:6], v[1:2], v2 clamp
// GFX10: encoding: [0x05,0x80,0x68,0xd5,0x01,0x05,0x02,0x00]

v_ldexp_f64 v[5:6], v[1:2], v2 mul:2
// GFX10: encoding: [0x05,0x00,0x68,0xd5,0x01,0x05,0x02,0x08]

v_ldexp_f64 v[5:6], v[1:2], v2 mul:4
// GFX10: encoding: [0x05,0x00,0x68,0xd5,0x01,0x05,0x02,0x10]

v_ldexp_f64 v[5:6], v[1:2], v2 div:2
// GFX10: encoding: [0x05,0x00,0x68,0xd5,0x01,0x05,0x02,0x18]

v_mul_lo_u32 v5, v1, v2
// GFX10: encoding: [0x05,0x00,0x69,0xd5,0x01,0x05,0x02,0x00]

v_mul_lo_u32 v255, v1, v2
// GFX10: encoding: [0xff,0x00,0x69,0xd5,0x01,0x05,0x02,0x00]

v_mul_lo_u32 v5, v255, v2
// GFX10: encoding: [0x05,0x00,0x69,0xd5,0xff,0x05,0x02,0x00]

v_mul_lo_u32 v5, s1, v2
// GFX10: encoding: [0x05,0x00,0x69,0xd5,0x01,0x04,0x02,0x00]

v_mul_lo_u32 v5, s103, v2
// GFX10: encoding: [0x05,0x00,0x69,0xd5,0x67,0x04,0x02,0x00]

v_mul_lo_u32 v5, vcc_lo, v2
// GFX10: encoding: [0x05,0x00,0x69,0xd5,0x6a,0x04,0x02,0x00]

v_mul_lo_u32 v5, vcc_hi, v2
// GFX10: encoding: [0x05,0x00,0x69,0xd5,0x6b,0x04,0x02,0x00]

v_mul_lo_u32 v5, ttmp11, v2
// GFX10: encoding: [0x05,0x00,0x69,0xd5,0x77,0x04,0x02,0x00]

v_mul_lo_u32 v5, m0, v2
// GFX10: encoding: [0x05,0x00,0x69,0xd5,0x7c,0x04,0x02,0x00]

v_mul_lo_u32 v5, exec_lo, v2
// GFX10: encoding: [0x05,0x00,0x69,0xd5,0x7e,0x04,0x02,0x00]

v_mul_lo_u32 v5, exec_hi, v2
// GFX10: encoding: [0x05,0x00,0x69,0xd5,0x7f,0x04,0x02,0x00]

v_mul_lo_u32 v5, 0, v2
// GFX10: encoding: [0x05,0x00,0x69,0xd5,0x80,0x04,0x02,0x00]

v_mul_lo_u32 v5, -1, v2
// GFX10: encoding: [0x05,0x00,0x69,0xd5,0xc1,0x04,0x02,0x00]

v_mul_lo_u32 v5, 0.5, v2
// GFX10: encoding: [0x05,0x00,0x69,0xd5,0xf0,0x04,0x02,0x00]

v_mul_lo_u32 v5, -4.0, v2
// GFX10: encoding: [0x05,0x00,0x69,0xd5,0xf7,0x04,0x02,0x00]

v_mul_lo_u32 v5, v1, v255
// GFX10: encoding: [0x05,0x00,0x69,0xd5,0x01,0xff,0x03,0x00]

v_mul_lo_u32 v5, v1, s2
// GFX10: encoding: [0x05,0x00,0x69,0xd5,0x01,0x05,0x00,0x00]

v_mul_lo_u32 v5, v1, s103
// GFX10: encoding: [0x05,0x00,0x69,0xd5,0x01,0xcf,0x00,0x00]

v_mul_lo_u32 v5, v1, vcc_lo
// GFX10: encoding: [0x05,0x00,0x69,0xd5,0x01,0xd5,0x00,0x00]

v_mul_lo_u32 v5, v1, vcc_hi
// GFX10: encoding: [0x05,0x00,0x69,0xd5,0x01,0xd7,0x00,0x00]

v_mul_lo_u32 v5, v1, ttmp11
// GFX10: encoding: [0x05,0x00,0x69,0xd5,0x01,0xef,0x00,0x00]

v_mul_lo_u32 v5, v1, m0
// GFX10: encoding: [0x05,0x00,0x69,0xd5,0x01,0xf9,0x00,0x00]

v_mul_lo_u32 v5, v1, exec_lo
// GFX10: encoding: [0x05,0x00,0x69,0xd5,0x01,0xfd,0x00,0x00]

v_mul_lo_u32 v5, v1, exec_hi
// GFX10: encoding: [0x05,0x00,0x69,0xd5,0x01,0xff,0x00,0x00]

v_mul_lo_u32 v5, v1, 0
// GFX10: encoding: [0x05,0x00,0x69,0xd5,0x01,0x01,0x01,0x00]

v_mul_lo_u32 v5, v1, -1
// GFX10: encoding: [0x05,0x00,0x69,0xd5,0x01,0x83,0x01,0x00]

v_mul_lo_u32 v5, v1, 0.5
// GFX10: encoding: [0x05,0x00,0x69,0xd5,0x01,0xe1,0x01,0x00]

v_mul_lo_u32 v5, v1, -4.0
// GFX10: encoding: [0x05,0x00,0x69,0xd5,0x01,0xef,0x01,0x00]

v_mul_hi_u32 v5, v1, v2
// GFX10: encoding: [0x05,0x00,0x6a,0xd5,0x01,0x05,0x02,0x00]

v_mul_hi_u32 v255, v1, v2
// GFX10: encoding: [0xff,0x00,0x6a,0xd5,0x01,0x05,0x02,0x00]

v_mul_hi_u32 v5, v255, v2
// GFX10: encoding: [0x05,0x00,0x6a,0xd5,0xff,0x05,0x02,0x00]

v_mul_hi_u32 v5, s1, v2
// GFX10: encoding: [0x05,0x00,0x6a,0xd5,0x01,0x04,0x02,0x00]

v_mul_hi_u32 v5, s103, v2
// GFX10: encoding: [0x05,0x00,0x6a,0xd5,0x67,0x04,0x02,0x00]

v_mul_hi_u32 v5, vcc_lo, v2
// GFX10: encoding: [0x05,0x00,0x6a,0xd5,0x6a,0x04,0x02,0x00]

v_mul_hi_u32 v5, vcc_hi, v2
// GFX10: encoding: [0x05,0x00,0x6a,0xd5,0x6b,0x04,0x02,0x00]

v_mul_hi_u32 v5, ttmp11, v2
// GFX10: encoding: [0x05,0x00,0x6a,0xd5,0x77,0x04,0x02,0x00]

v_mul_hi_u32 v5, m0, v2
// GFX10: encoding: [0x05,0x00,0x6a,0xd5,0x7c,0x04,0x02,0x00]

v_mul_hi_u32 v5, exec_lo, v2
// GFX10: encoding: [0x05,0x00,0x6a,0xd5,0x7e,0x04,0x02,0x00]

v_mul_hi_u32 v5, exec_hi, v2
// GFX10: encoding: [0x05,0x00,0x6a,0xd5,0x7f,0x04,0x02,0x00]

v_mul_hi_u32 v5, 0, v2
// GFX10: encoding: [0x05,0x00,0x6a,0xd5,0x80,0x04,0x02,0x00]

v_mul_hi_u32 v5, -1, v2
// GFX10: encoding: [0x05,0x00,0x6a,0xd5,0xc1,0x04,0x02,0x00]

v_mul_hi_u32 v5, 0.5, v2
// GFX10: encoding: [0x05,0x00,0x6a,0xd5,0xf0,0x04,0x02,0x00]

v_mul_hi_u32 v5, -4.0, v2
// GFX10: encoding: [0x05,0x00,0x6a,0xd5,0xf7,0x04,0x02,0x00]

v_mul_hi_u32 v5, v1, v255
// GFX10: encoding: [0x05,0x00,0x6a,0xd5,0x01,0xff,0x03,0x00]

v_mul_hi_u32 v5, v1, s2
// GFX10: encoding: [0x05,0x00,0x6a,0xd5,0x01,0x05,0x00,0x00]

v_mul_hi_u32 v5, v1, s103
// GFX10: encoding: [0x05,0x00,0x6a,0xd5,0x01,0xcf,0x00,0x00]

v_mul_hi_u32 v5, v1, vcc_lo
// GFX10: encoding: [0x05,0x00,0x6a,0xd5,0x01,0xd5,0x00,0x00]

v_mul_hi_u32 v5, v1, vcc_hi
// GFX10: encoding: [0x05,0x00,0x6a,0xd5,0x01,0xd7,0x00,0x00]

v_mul_hi_u32 v5, v1, ttmp11
// GFX10: encoding: [0x05,0x00,0x6a,0xd5,0x01,0xef,0x00,0x00]

v_mul_hi_u32 v5, v1, m0
// GFX10: encoding: [0x05,0x00,0x6a,0xd5,0x01,0xf9,0x00,0x00]

v_mul_hi_u32 v5, v1, exec_lo
// GFX10: encoding: [0x05,0x00,0x6a,0xd5,0x01,0xfd,0x00,0x00]

v_mul_hi_u32 v5, v1, exec_hi
// GFX10: encoding: [0x05,0x00,0x6a,0xd5,0x01,0xff,0x00,0x00]

v_mul_hi_u32 v5, v1, 0
// GFX10: encoding: [0x05,0x00,0x6a,0xd5,0x01,0x01,0x01,0x00]

v_mul_hi_u32 v5, v1, -1
// GFX10: encoding: [0x05,0x00,0x6a,0xd5,0x01,0x83,0x01,0x00]

v_mul_hi_u32 v5, v1, 0.5
// GFX10: encoding: [0x05,0x00,0x6a,0xd5,0x01,0xe1,0x01,0x00]

v_mul_hi_u32 v5, v1, -4.0
// GFX10: encoding: [0x05,0x00,0x6a,0xd5,0x01,0xef,0x01,0x00]

v_mul_lo_i32 v5, v1, v2
// GFX10: encoding: [0x05,0x00,0x6b,0xd5,0x01,0x05,0x02,0x00]

v_mul_lo_i32 v255, v1, v2
// GFX10: encoding: [0xff,0x00,0x6b,0xd5,0x01,0x05,0x02,0x00]

v_mul_lo_i32 v5, v255, v2
// GFX10: encoding: [0x05,0x00,0x6b,0xd5,0xff,0x05,0x02,0x00]

v_mul_lo_i32 v5, s1, v2
// GFX10: encoding: [0x05,0x00,0x6b,0xd5,0x01,0x04,0x02,0x00]

v_mul_lo_i32 v5, s103, v2
// GFX10: encoding: [0x05,0x00,0x6b,0xd5,0x67,0x04,0x02,0x00]

v_mul_lo_i32 v5, vcc_lo, v2
// GFX10: encoding: [0x05,0x00,0x6b,0xd5,0x6a,0x04,0x02,0x00]

v_mul_lo_i32 v5, vcc_hi, v2
// GFX10: encoding: [0x05,0x00,0x6b,0xd5,0x6b,0x04,0x02,0x00]

v_mul_lo_i32 v5, ttmp11, v2
// GFX10: encoding: [0x05,0x00,0x6b,0xd5,0x77,0x04,0x02,0x00]

v_mul_hi_i32 v5, v1, v2
// GFX10: encoding: [0x05,0x00,0x6c,0xd5,0x01,0x05,0x02,0x00]

v_mul_hi_i32 v255, v1, v2
// GFX10: encoding: [0xff,0x00,0x6c,0xd5,0x01,0x05,0x02,0x00]

v_mul_hi_i32 v5, v255, v2
// GFX10: encoding: [0x05,0x00,0x6c,0xd5,0xff,0x05,0x02,0x00]

v_mul_hi_i32 v5, s1, v2
// GFX10: encoding: [0x05,0x00,0x6c,0xd5,0x01,0x04,0x02,0x00]

v_mul_hi_i32 v5, s103, v2
// GFX10: encoding: [0x05,0x00,0x6c,0xd5,0x67,0x04,0x02,0x00]

v_mul_hi_i32 v5, vcc_lo, v2
// GFX10: encoding: [0x05,0x00,0x6c,0xd5,0x6a,0x04,0x02,0x00]

v_mul_hi_i32 v5, vcc_hi, v2
// GFX10: encoding: [0x05,0x00,0x6c,0xd5,0x6b,0x04,0x02,0x00]

v_mul_hi_i32 v5, ttmp11, v2
// GFX10: encoding: [0x05,0x00,0x6c,0xd5,0x77,0x04,0x02,0x00]

v_mul_hi_i32 v5, m0, v2
// GFX10: encoding: [0x05,0x00,0x6c,0xd5,0x7c,0x04,0x02,0x00]

v_mul_hi_i32 v5, exec_lo, v2
// GFX10: encoding: [0x05,0x00,0x6c,0xd5,0x7e,0x04,0x02,0x00]

v_mul_hi_i32 v5, exec_hi, v2
// GFX10: encoding: [0x05,0x00,0x6c,0xd5,0x7f,0x04,0x02,0x00]

v_mul_hi_i32 v5, 0, v2
// GFX10: encoding: [0x05,0x00,0x6c,0xd5,0x80,0x04,0x02,0x00]

v_mul_hi_i32 v5, -1, v2
// GFX10: encoding: [0x05,0x00,0x6c,0xd5,0xc1,0x04,0x02,0x00]

v_mul_hi_i32 v5, 0.5, v2
// GFX10: encoding: [0x05,0x00,0x6c,0xd5,0xf0,0x04,0x02,0x00]

v_mul_hi_i32 v5, -4.0, v2
// GFX10: encoding: [0x05,0x00,0x6c,0xd5,0xf7,0x04,0x02,0x00]

v_mul_hi_i32 v5, v1, v255
// GFX10: encoding: [0x05,0x00,0x6c,0xd5,0x01,0xff,0x03,0x00]

v_mul_hi_i32 v5, v1, s2
// GFX10: encoding: [0x05,0x00,0x6c,0xd5,0x01,0x05,0x00,0x00]

v_mul_hi_i32 v5, v1, s103
// GFX10: encoding: [0x05,0x00,0x6c,0xd5,0x01,0xcf,0x00,0x00]

v_mul_hi_i32 v5, v1, vcc_lo
// GFX10: encoding: [0x05,0x00,0x6c,0xd5,0x01,0xd5,0x00,0x00]

v_mul_hi_i32 v5, v1, vcc_hi
// GFX10: encoding: [0x05,0x00,0x6c,0xd5,0x01,0xd7,0x00,0x00]

v_mul_hi_i32 v5, v1, ttmp11
// GFX10: encoding: [0x05,0x00,0x6c,0xd5,0x01,0xef,0x00,0x00]

v_mul_hi_i32 v5, v1, m0
// GFX10: encoding: [0x05,0x00,0x6c,0xd5,0x01,0xf9,0x00,0x00]

v_mul_hi_i32 v5, v1, exec_lo
// GFX10: encoding: [0x05,0x00,0x6c,0xd5,0x01,0xfd,0x00,0x00]

v_mul_hi_i32 v5, v1, exec_hi
// GFX10: encoding: [0x05,0x00,0x6c,0xd5,0x01,0xff,0x00,0x00]

v_mul_hi_i32 v5, v1, 0
// GFX10: encoding: [0x05,0x00,0x6c,0xd5,0x01,0x01,0x01,0x00]

v_mul_hi_i32 v5, v1, -1
// GFX10: encoding: [0x05,0x00,0x6c,0xd5,0x01,0x83,0x01,0x00]

v_mul_hi_i32 v5, v1, 0.5
// GFX10: encoding: [0x05,0x00,0x6c,0xd5,0x01,0xe1,0x01,0x00]

v_mul_hi_i32 v5, v1, -4.0
// GFX10: encoding: [0x05,0x00,0x6c,0xd5,0x01,0xef,0x01,0x00]

v_div_scale_f32 v5, s0, v1, v2, v3
// W32: encoding: [0x05,0x00,0x6d,0xd5,0x01,0x05,0x0e,0x04]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f32 v255, s0, v1, v2, v3
// W32: encoding: [0xff,0x00,0x6d,0xd5,0x01,0x05,0x0e,0x04]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f32 v5, s0, v255, v2, v3
// W32: encoding: [0x05,0x00,0x6d,0xd5,0xff,0x05,0x0e,0x04]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f32 v5, s0, s1, v2, v3
// W32: encoding: [0x05,0x00,0x6d,0xd5,0x01,0x04,0x0e,0x04]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f32 v5, s0, s103, v2, v3
// W32: encoding: [0x05,0x00,0x6d,0xd5,0x67,0x04,0x0e,0x04]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f32 v5, s0, vcc_lo, v2, v3
// W32: encoding: [0x05,0x00,0x6d,0xd5,0x6a,0x04,0x0e,0x04]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f32 v5, s0, vcc_hi, v2, v3
// W32: encoding: [0x05,0x00,0x6d,0xd5,0x6b,0x04,0x0e,0x04]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f32 v5, s0, ttmp11, v2, v3
// W32: encoding: [0x05,0x00,0x6d,0xd5,0x77,0x04,0x0e,0x04]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f32 v5, s0, m0, v2, v3
// W32: encoding: [0x05,0x00,0x6d,0xd5,0x7c,0x04,0x0e,0x04]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f32 v5, s0, exec_lo, v2, v3
// W32: encoding: [0x05,0x00,0x6d,0xd5,0x7e,0x04,0x0e,0x04]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f32 v5, s0, exec_hi, v2, v3
// W32: encoding: [0x05,0x00,0x6d,0xd5,0x7f,0x04,0x0e,0x04]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f32 v5, s0, 0, v2, v3
// W32: encoding: [0x05,0x00,0x6d,0xd5,0x80,0x04,0x0e,0x04]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f32 v5, s0, -1, v2, v3
// W32: encoding: [0x05,0x00,0x6d,0xd5,0xc1,0x04,0x0e,0x04]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f32 v5, s0, 0.5, v2, v3
// W32: encoding: [0x05,0x00,0x6d,0xd5,0xf0,0x04,0x0e,0x04]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f32 v5, s0, -4.0, v2, v3
// W32: encoding: [0x05,0x00,0x6d,0xd5,0xf7,0x04,0x0e,0x04]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f32 v5, s0, v1, v255, v3
// W32: encoding: [0x05,0x00,0x6d,0xd5,0x01,0xff,0x0f,0x04]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f32 v5, s0, v1, s2, v3
// W32: encoding: [0x05,0x00,0x6d,0xd5,0x01,0x05,0x0c,0x04]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f32 v5, s0, v1, s103, v3
// W32: encoding: [0x05,0x00,0x6d,0xd5,0x01,0xcf,0x0c,0x04]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f32 v5, s0, v1, vcc_lo, v3
// W32: encoding: [0x05,0x00,0x6d,0xd5,0x01,0xd5,0x0c,0x04]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f32 v5, s0, v1, vcc_hi, v3
// W32: encoding: [0x05,0x00,0x6d,0xd5,0x01,0xd7,0x0c,0x04]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f32 v5, s0, v1, ttmp11, v3
// W32: encoding: [0x05,0x00,0x6d,0xd5,0x01,0xef,0x0c,0x04]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f32 v5, s0, v1, m0, v3
// W32: encoding: [0x05,0x00,0x6d,0xd5,0x01,0xf9,0x0c,0x04]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f32 v5, s0, v1, exec_lo, v3
// W32: encoding: [0x05,0x00,0x6d,0xd5,0x01,0xfd,0x0c,0x04]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f32 v5, s0, v1, exec_hi, v3
// W32: encoding: [0x05,0x00,0x6d,0xd5,0x01,0xff,0x0c,0x04]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f32 v5, s0, v1, 0, v3
// W32: encoding: [0x05,0x00,0x6d,0xd5,0x01,0x01,0x0d,0x04]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f32 v5, s0, v1, -1, v3
// W32: encoding: [0x05,0x00,0x6d,0xd5,0x01,0x83,0x0d,0x04]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f32 v5, s0, v1, 0.5, v3
// W32: encoding: [0x05,0x00,0x6d,0xd5,0x01,0xe1,0x0d,0x04]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f32 v5, s0, v1, -4.0, v3
// W32: encoding: [0x05,0x00,0x6d,0xd5,0x01,0xef,0x0d,0x04]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f32 v5, s0, v1, v2, v255
// W32: encoding: [0x05,0x00,0x6d,0xd5,0x01,0x05,0xfe,0x07]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f32 v5, s0, v1, v2, s3
// W32: encoding: [0x05,0x00,0x6d,0xd5,0x01,0x05,0x0e,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f32 v5, s0, v1, v2, s103
// W32: encoding: [0x05,0x00,0x6d,0xd5,0x01,0x05,0x9e,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f32 v5, s0, v1, v2, vcc_lo
// W32: encoding: [0x05,0x00,0x6d,0xd5,0x01,0x05,0xaa,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f32 v5, s0, v1, v2, vcc_hi
// W32: encoding: [0x05,0x00,0x6d,0xd5,0x01,0x05,0xae,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f32 v5, s0, v1, v2, ttmp11
// W32: encoding: [0x05,0x00,0x6d,0xd5,0x01,0x05,0xde,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f32 v5, s0, v1, v2, m0
// W32: encoding: [0x05,0x00,0x6d,0xd5,0x01,0x05,0xf2,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f32 v5, s0, v1, v2, exec_lo
// W32: encoding: [0x05,0x00,0x6d,0xd5,0x01,0x05,0xfa,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f32 v5, s0, v1, v2, exec_hi
// W32: encoding: [0x05,0x00,0x6d,0xd5,0x01,0x05,0xfe,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f32 v5, s0, v1, v2, 0
// W32: encoding: [0x05,0x00,0x6d,0xd5,0x01,0x05,0x02,0x02]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f32 v5, s0, v1, v2, -1
// W32: encoding: [0x05,0x00,0x6d,0xd5,0x01,0x05,0x06,0x03]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f32 v5, s0, v1, v2, 0.5
// W32: encoding: [0x05,0x00,0x6d,0xd5,0x01,0x05,0xc2,0x03]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f32 v5, s0, v1, v2, -4.0
// W32: encoding: [0x05,0x00,0x6d,0xd5,0x01,0x05,0xde,0x03]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f32 v5, s[0:1], v1, v2, v3
// W64: encoding: [0x05,0x00,0x6d,0xd5,0x01,0x05,0x0e,0x04]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f32 v255, s[0:1], v1, v2, v3
// W64: encoding: [0xff,0x00,0x6d,0xd5,0x01,0x05,0x0e,0x04]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f32 v5, s[0:1], v255, v2, v3
// W64: encoding: [0x05,0x00,0x6d,0xd5,0xff,0x05,0x0e,0x04]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f32 v5, s[0:1], s1, v2, v3
// W64: encoding: [0x05,0x00,0x6d,0xd5,0x01,0x04,0x0e,0x04]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f32 v5, s[0:1], s103, v2, v3
// W64: encoding: [0x05,0x00,0x6d,0xd5,0x67,0x04,0x0e,0x04]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f32 v5, s[0:1], vcc_lo, v2, v3
// W64: encoding: [0x05,0x00,0x6d,0xd5,0x6a,0x04,0x0e,0x04]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f32 v5, s[0:1], vcc_hi, v2, v3
// W64: encoding: [0x05,0x00,0x6d,0xd5,0x6b,0x04,0x0e,0x04]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f32 v5, s[0:1], ttmp11, v2, v3
// W64: encoding: [0x05,0x00,0x6d,0xd5,0x77,0x04,0x0e,0x04]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f32 v5, s[0:1], m0, v2, v3
// W64: encoding: [0x05,0x00,0x6d,0xd5,0x7c,0x04,0x0e,0x04]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f32 v5, s[0:1], exec_lo, v2, v3
// W64: encoding: [0x05,0x00,0x6d,0xd5,0x7e,0x04,0x0e,0x04]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f32 v5, s[0:1], exec_hi, v2, v3
// W64: encoding: [0x05,0x00,0x6d,0xd5,0x7f,0x04,0x0e,0x04]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f32 v5, s[0:1], 0, v2, v3
// W64: encoding: [0x05,0x00,0x6d,0xd5,0x80,0x04,0x0e,0x04]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f32 v5, s[0:1], -1, v2, v3
// W64: encoding: [0x05,0x00,0x6d,0xd5,0xc1,0x04,0x0e,0x04]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f32 v5, s[0:1], 0.5, v2, v3
// W64: encoding: [0x05,0x00,0x6d,0xd5,0xf0,0x04,0x0e,0x04]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f32 v5, s[0:1], -4.0, v2, v3
// W64: encoding: [0x05,0x00,0x6d,0xd5,0xf7,0x04,0x0e,0x04]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f32 v5, s[0:1], v1, v255, v3
// W64: encoding: [0x05,0x00,0x6d,0xd5,0x01,0xff,0x0f,0x04]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f32 v5, s[0:1], v1, s2, v3
// W64: encoding: [0x05,0x00,0x6d,0xd5,0x01,0x05,0x0c,0x04]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f32 v5, s[0:1], v1, s103, v3
// W64: encoding: [0x05,0x00,0x6d,0xd5,0x01,0xcf,0x0c,0x04]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f32 v5, s[0:1], v1, vcc_lo, v3
// W64: encoding: [0x05,0x00,0x6d,0xd5,0x01,0xd5,0x0c,0x04]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f32 v5, s[0:1], v1, vcc_hi, v3
// W64: encoding: [0x05,0x00,0x6d,0xd5,0x01,0xd7,0x0c,0x04]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f32 v5, s[0:1], v1, ttmp11, v3
// W64: encoding: [0x05,0x00,0x6d,0xd5,0x01,0xef,0x0c,0x04]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f32 v5, s[0:1], v1, m0, v3
// W64: encoding: [0x05,0x00,0x6d,0xd5,0x01,0xf9,0x0c,0x04]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f32 v5, s[0:1], v1, exec_lo, v3
// W64: encoding: [0x05,0x00,0x6d,0xd5,0x01,0xfd,0x0c,0x04]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f32 v5, s[0:1], v1, exec_hi, v3
// W64: encoding: [0x05,0x00,0x6d,0xd5,0x01,0xff,0x0c,0x04]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f32 v5, s[0:1], v1, 0, v3
// W64: encoding: [0x05,0x00,0x6d,0xd5,0x01,0x01,0x0d,0x04]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f32 v5, s[0:1], v1, -1, v3
// W64: encoding: [0x05,0x00,0x6d,0xd5,0x01,0x83,0x0d,0x04]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f32 v5, s[0:1], v1, 0.5, v3
// W64: encoding: [0x05,0x00,0x6d,0xd5,0x01,0xe1,0x0d,0x04]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f32 v5, s[0:1], v1, -4.0, v3
// W64: encoding: [0x05,0x00,0x6d,0xd5,0x01,0xef,0x0d,0x04]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f32 v5, s[0:1], v1, v2, v255
// W64: encoding: [0x05,0x00,0x6d,0xd5,0x01,0x05,0xfe,0x07]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f32 v5, s[0:1], v1, v2, s3
// W64: encoding: [0x05,0x00,0x6d,0xd5,0x01,0x05,0x0e,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f32 v5, s[0:1], v1, v2, s103
// W64: encoding: [0x05,0x00,0x6d,0xd5,0x01,0x05,0x9e,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f32 v5, s[0:1], v1, v2, vcc_lo
// W64: encoding: [0x05,0x00,0x6d,0xd5,0x01,0x05,0xaa,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f32 v5, s[0:1], v1, v2, vcc_hi
// W64: encoding: [0x05,0x00,0x6d,0xd5,0x01,0x05,0xae,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f32 v5, s[0:1], v1, v2, ttmp11
// W64: encoding: [0x05,0x00,0x6d,0xd5,0x01,0x05,0xde,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f32 v5, s[0:1], v1, v2, m0
// W64: encoding: [0x05,0x00,0x6d,0xd5,0x01,0x05,0xf2,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f32 v5, s[0:1], v1, v2, exec_lo
// W64: encoding: [0x05,0x00,0x6d,0xd5,0x01,0x05,0xfa,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f32 v5, s[0:1], v1, v2, exec_hi
// W64: encoding: [0x05,0x00,0x6d,0xd5,0x01,0x05,0xfe,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f32 v5, s[0:1], v1, v2, 0
// W64: encoding: [0x05,0x00,0x6d,0xd5,0x01,0x05,0x02,0x02]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f32 v5, s[0:1], v1, v2, -1
// W64: encoding: [0x05,0x00,0x6d,0xd5,0x01,0x05,0x06,0x03]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f32 v5, s[0:1], v1, v2, 0.5
// W64: encoding: [0x05,0x00,0x6d,0xd5,0x01,0x05,0xc2,0x03]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f32 v5, s[0:1], v1, v2, -4.0
// W64: encoding: [0x05,0x00,0x6d,0xd5,0x01,0x05,0xde,0x03]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_fmas_f32 v5, v1, v2, v3
// GFX10: encoding: [0x05,0x00,0x6f,0xd5,0x01,0x05,0x0e,0x04]

v_div_fmas_f32 v255, v1, v2, v3
// GFX10: encoding: [0xff,0x00,0x6f,0xd5,0x01,0x05,0x0e,0x04]

v_div_fmas_f32 v5, v255, v2, v3
// GFX10: encoding: [0x05,0x00,0x6f,0xd5,0xff,0x05,0x0e,0x04]

v_div_fmas_f32 v5, 0, v2, v3
// GFX10: encoding: [0x05,0x00,0x6f,0xd5,0x80,0x04,0x0e,0x04]

v_div_fmas_f32 v5, -1, v2, v3
// GFX10: encoding: [0x05,0x00,0x6f,0xd5,0xc1,0x04,0x0e,0x04]

v_div_fmas_f32 v5, 0.5, v2, v3
// GFX10: encoding: [0x05,0x00,0x6f,0xd5,0xf0,0x04,0x0e,0x04]

v_div_fmas_f32 v5, -4.0, v2, v3
// GFX10: encoding: [0x05,0x00,0x6f,0xd5,0xf7,0x04,0x0e,0x04]

v_div_fmas_f32 v5, v1, v255, v3
// GFX10: encoding: [0x05,0x00,0x6f,0xd5,0x01,0xff,0x0f,0x04]

v_div_fmas_f32 v5, v1, 0, v3
// GFX10: encoding: [0x05,0x00,0x6f,0xd5,0x01,0x01,0x0d,0x04]

v_div_fmas_f32 v5, v1, -1, v3
// GFX10: encoding: [0x05,0x00,0x6f,0xd5,0x01,0x83,0x0d,0x04]

v_div_fmas_f32 v5, v1, 0.5, v3
// GFX10: encoding: [0x05,0x00,0x6f,0xd5,0x01,0xe1,0x0d,0x04]

v_div_fmas_f32 v5, v1, -4.0, v3
// GFX10: encoding: [0x05,0x00,0x6f,0xd5,0x01,0xef,0x0d,0x04]

v_div_fmas_f32 v5, v1, v2, v255
// GFX10: encoding: [0x05,0x00,0x6f,0xd5,0x01,0x05,0xfe,0x07]

v_div_fmas_f32 v5, v1, v2, 0
// GFX10: encoding: [0x05,0x00,0x6f,0xd5,0x01,0x05,0x02,0x02]

v_div_fmas_f32 v5, v1, v2, -1
// GFX10: encoding: [0x05,0x00,0x6f,0xd5,0x01,0x05,0x06,0x03]

v_div_fmas_f32 v5, v1, v2, 0.5
// GFX10: encoding: [0x05,0x00,0x6f,0xd5,0x01,0x05,0xc2,0x03]

v_div_fmas_f32 v5, v1, v2, -4.0
// GFX10: encoding: [0x05,0x00,0x6f,0xd5,0x01,0x05,0xde,0x03]

v_div_fmas_f32 v5, -v1, v2, v3
// GFX10: encoding: [0x05,0x00,0x6f,0xd5,0x01,0x05,0x0e,0x24]

v_div_fmas_f32 v5, v1, -v2, v3
// GFX10: encoding: [0x05,0x00,0x6f,0xd5,0x01,0x05,0x0e,0x44]

v_div_fmas_f32 v5, v1, v2, -v3
// GFX10: encoding: [0x05,0x00,0x6f,0xd5,0x01,0x05,0x0e,0x84]

v_div_fmas_f32 v5, -v1, -v2, -v3
// GFX10: encoding: [0x05,0x00,0x6f,0xd5,0x01,0x05,0x0e,0xe4]

v_div_fmas_f32 v5, |v1|, v2, v3
// GFX10: encoding: [0x05,0x01,0x6f,0xd5,0x01,0x05,0x0e,0x04]

v_div_fmas_f32 v5, v1, |v2|, v3
// GFX10: encoding: [0x05,0x02,0x6f,0xd5,0x01,0x05,0x0e,0x04]

v_div_fmas_f32 v5, v1, v2, |v3|
// GFX10: encoding: [0x05,0x04,0x6f,0xd5,0x01,0x05,0x0e,0x04]

v_div_fmas_f32 v5, |v1|, |v2|, |v3|
// GFX10: encoding: [0x05,0x07,0x6f,0xd5,0x01,0x05,0x0e,0x04]

v_div_fmas_f32 v5, v1, v2, v3 clamp
// GFX10: encoding: [0x05,0x80,0x6f,0xd5,0x01,0x05,0x0e,0x04]

v_div_fmas_f32 v5, v1, v2, v3 mul:2
// GFX10: encoding: [0x05,0x00,0x6f,0xd5,0x01,0x05,0x0e,0x0c]

v_div_fmas_f32 v5, v1, v2, v3 mul:4
// GFX10: encoding: [0x05,0x00,0x6f,0xd5,0x01,0x05,0x0e,0x14]

v_div_fmas_f32 v5, v1, v2, v3 div:2
// GFX10: encoding: [0x05,0x00,0x6f,0xd5,0x01,0x05,0x0e,0x1c]

v_div_fmas_f64 v[5:6], v[1:2], v[2:3], v[3:4]
// GFX10: encoding: [0x05,0x00,0x70,0xd5,0x01,0x05,0x0e,0x04]

v_div_fmas_f64 v[254:255], v[1:2], v[2:3], v[3:4]
// GFX10: encoding: [0xfe,0x00,0x70,0xd5,0x01,0x05,0x0e,0x04]

v_div_fmas_f64 v[5:6], v[254:255], v[2:3], v[3:4]
// GFX10: encoding: [0x05,0x00,0x70,0xd5,0xfe,0x05,0x0e,0x04]

v_div_fmas_f64 v[5:6], 0, v[2:3], v[3:4]
// GFX10: encoding: [0x05,0x00,0x70,0xd5,0x80,0x04,0x0e,0x04]

v_div_fmas_f64 v[5:6], -1, v[2:3], v[3:4]
// GFX10: encoding: [0x05,0x00,0x70,0xd5,0xc1,0x04,0x0e,0x04]

v_div_fmas_f64 v[5:6], 0.5, v[2:3], v[3:4]
// GFX10: encoding: [0x05,0x00,0x70,0xd5,0xf0,0x04,0x0e,0x04]

v_div_fmas_f64 v[5:6], -4.0, v[2:3], v[3:4]
// GFX10: encoding: [0x05,0x00,0x70,0xd5,0xf7,0x04,0x0e,0x04]

v_div_fmas_f64 v[5:6], v[1:2], v[254:255], v[3:4]
// GFX10: encoding: [0x05,0x00,0x70,0xd5,0x01,0xfd,0x0f,0x04]

v_div_fmas_f64 v[5:6], v[1:2], 0, v[3:4]
// GFX10: encoding: [0x05,0x00,0x70,0xd5,0x01,0x01,0x0d,0x04]

v_div_fmas_f64 v[5:6], v[1:2], -1, v[3:4]
// GFX10: encoding: [0x05,0x00,0x70,0xd5,0x01,0x83,0x0d,0x04]

v_div_fmas_f64 v[5:6], v[1:2], 0.5, v[3:4]
// GFX10: encoding: [0x05,0x00,0x70,0xd5,0x01,0xe1,0x0d,0x04]

v_div_fmas_f64 v[5:6], v[1:2], -4.0, v[3:4]
// GFX10: encoding: [0x05,0x00,0x70,0xd5,0x01,0xef,0x0d,0x04]

v_div_fmas_f64 v[5:6], v[1:2], v[2:3], v[254:255]
// GFX10: encoding: [0x05,0x00,0x70,0xd5,0x01,0x05,0xfa,0x07]

v_div_fmas_f64 v[5:6], v[1:2], v[2:3], 0
// GFX10: encoding: [0x05,0x00,0x70,0xd5,0x01,0x05,0x02,0x02]

v_div_fmas_f64 v[5:6], v[1:2], v[2:3], -1
// GFX10: encoding: [0x05,0x00,0x70,0xd5,0x01,0x05,0x06,0x03]

v_div_fmas_f64 v[5:6], v[1:2], v[2:3], 0.5
// GFX10: encoding: [0x05,0x00,0x70,0xd5,0x01,0x05,0xc2,0x03]

v_div_fmas_f64 v[5:6], v[1:2], v[2:3], -4.0
// GFX10: encoding: [0x05,0x00,0x70,0xd5,0x01,0x05,0xde,0x03]

v_div_fmas_f64 v[5:6], -v[1:2], v[2:3], v[3:4]
// GFX10: encoding: [0x05,0x00,0x70,0xd5,0x01,0x05,0x0e,0x24]

v_div_fmas_f64 v[5:6], v[1:2], -v[2:3], v[3:4]
// GFX10: encoding: [0x05,0x00,0x70,0xd5,0x01,0x05,0x0e,0x44]

v_div_fmas_f64 v[5:6], v[1:2], v[2:3], -v[3:4]
// GFX10: encoding: [0x05,0x00,0x70,0xd5,0x01,0x05,0x0e,0x84]

v_div_fmas_f64 v[5:6], -v[1:2], -v[2:3], -v[3:4]
// GFX10: encoding: [0x05,0x00,0x70,0xd5,0x01,0x05,0x0e,0xe4]

v_div_fmas_f64 v[5:6], |v[1:2]|, v[2:3], v[3:4]
// GFX10: encoding: [0x05,0x01,0x70,0xd5,0x01,0x05,0x0e,0x04]

v_div_fmas_f64 v[5:6], v[1:2], |v[2:3]|, v[3:4]
// GFX10: encoding: [0x05,0x02,0x70,0xd5,0x01,0x05,0x0e,0x04]

v_div_fmas_f64 v[5:6], v[1:2], v[2:3], |v[3:4]|
// GFX10: encoding: [0x05,0x04,0x70,0xd5,0x01,0x05,0x0e,0x04]

v_div_fmas_f64 v[5:6], |v[1:2]|, |v[2:3]|, |v[3:4]|
// GFX10: encoding: [0x05,0x07,0x70,0xd5,0x01,0x05,0x0e,0x04]

v_div_fmas_f64 v[5:6], v[1:2], v[2:3], v[3:4] clamp
// GFX10: encoding: [0x05,0x80,0x70,0xd5,0x01,0x05,0x0e,0x04]

v_div_fmas_f64 v[5:6], v[1:2], v[2:3], v[3:4] mul:2
// GFX10: encoding: [0x05,0x00,0x70,0xd5,0x01,0x05,0x0e,0x0c]

v_div_fmas_f64 v[5:6], v[1:2], v[2:3], v[3:4] mul:4
// GFX10: encoding: [0x05,0x00,0x70,0xd5,0x01,0x05,0x0e,0x14]

v_div_fmas_f64 v[5:6], v[1:2], v[2:3], v[3:4] div:2
// GFX10: encoding: [0x05,0x00,0x70,0xd5,0x01,0x05,0x0e,0x1c]

v_msad_u8 v5, v1, v2, v3
// GFX10: encoding: [0x05,0x00,0x71,0xd5,0x01,0x05,0x0e,0x04]

v_msad_u8 v255, v1, v2, v3
// GFX10: encoding: [0xff,0x00,0x71,0xd5,0x01,0x05,0x0e,0x04]

v_msad_u8 v5, v255, v2, v3
// GFX10: encoding: [0x05,0x00,0x71,0xd5,0xff,0x05,0x0e,0x04]

v_msad_u8 v5, s1, v2, v3
// GFX10: encoding: [0x05,0x00,0x71,0xd5,0x01,0x04,0x0e,0x04]

v_msad_u8 v5, s103, v2, v3
// GFX10: encoding: [0x05,0x00,0x71,0xd5,0x67,0x04,0x0e,0x04]

v_msad_u8 v5, vcc_lo, v2, v3
// GFX10: encoding: [0x05,0x00,0x71,0xd5,0x6a,0x04,0x0e,0x04]

v_msad_u8 v5, vcc_hi, v2, v3
// GFX10: encoding: [0x05,0x00,0x71,0xd5,0x6b,0x04,0x0e,0x04]

v_msad_u8 v5, ttmp11, v2, v3
// GFX10: encoding: [0x05,0x00,0x71,0xd5,0x77,0x04,0x0e,0x04]

v_msad_u8 v5, m0, v2, v3
// GFX10: encoding: [0x05,0x00,0x71,0xd5,0x7c,0x04,0x0e,0x04]

v_msad_u8 v5, exec_lo, v2, v3
// GFX10: encoding: [0x05,0x00,0x71,0xd5,0x7e,0x04,0x0e,0x04]

v_msad_u8 v5, exec_hi, v2, v3
// GFX10: encoding: [0x05,0x00,0x71,0xd5,0x7f,0x04,0x0e,0x04]

v_msad_u8 v5, 0, v2, v3
// GFX10: encoding: [0x05,0x00,0x71,0xd5,0x80,0x04,0x0e,0x04]

v_msad_u8 v5, -1, v2, v3
// GFX10: encoding: [0x05,0x00,0x71,0xd5,0xc1,0x04,0x0e,0x04]

v_msad_u8 v5, 0.5, v2, v3
// GFX10: encoding: [0x05,0x00,0x71,0xd5,0xf0,0x04,0x0e,0x04]

v_msad_u8 v5, -4.0, v2, v3
// GFX10: encoding: [0x05,0x00,0x71,0xd5,0xf7,0x04,0x0e,0x04]

v_msad_u8 v5, v1, v255, v3
// GFX10: encoding: [0x05,0x00,0x71,0xd5,0x01,0xff,0x0f,0x04]

v_msad_u8 v5, v1, s2, v3
// GFX10: encoding: [0x05,0x00,0x71,0xd5,0x01,0x05,0x0c,0x04]

v_msad_u8 v5, v1, s103, v3
// GFX10: encoding: [0x05,0x00,0x71,0xd5,0x01,0xcf,0x0c,0x04]

v_msad_u8 v5, v1, vcc_lo, v3
// GFX10: encoding: [0x05,0x00,0x71,0xd5,0x01,0xd5,0x0c,0x04]

v_msad_u8 v5, v1, vcc_hi, v3
// GFX10: encoding: [0x05,0x00,0x71,0xd5,0x01,0xd7,0x0c,0x04]

v_msad_u8 v5, v1, ttmp11, v3
// GFX10: encoding: [0x05,0x00,0x71,0xd5,0x01,0xef,0x0c,0x04]

v_msad_u8 v5, v1, m0, v3
// GFX10: encoding: [0x05,0x00,0x71,0xd5,0x01,0xf9,0x0c,0x04]

v_msad_u8 v5, v1, exec_lo, v3
// GFX10: encoding: [0x05,0x00,0x71,0xd5,0x01,0xfd,0x0c,0x04]

v_msad_u8 v5, v1, exec_hi, v3
// GFX10: encoding: [0x05,0x00,0x71,0xd5,0x01,0xff,0x0c,0x04]

v_msad_u8 v5, v1, 0, v3
// GFX10: encoding: [0x05,0x00,0x71,0xd5,0x01,0x01,0x0d,0x04]

v_msad_u8 v5, v1, -1, v3
// GFX10: encoding: [0x05,0x00,0x71,0xd5,0x01,0x83,0x0d,0x04]

v_msad_u8 v5, v1, 0.5, v3
// GFX10: encoding: [0x05,0x00,0x71,0xd5,0x01,0xe1,0x0d,0x04]

v_msad_u8 v5, v1, -4.0, v3
// GFX10: encoding: [0x05,0x00,0x71,0xd5,0x01,0xef,0x0d,0x04]

v_msad_u8 v5, v1, v2, v255
// GFX10: encoding: [0x05,0x00,0x71,0xd5,0x01,0x05,0xfe,0x07]

v_msad_u8 v5, v1, v2, s3
// GFX10: encoding: [0x05,0x00,0x71,0xd5,0x01,0x05,0x0e,0x00]

v_msad_u8 v5, v1, v2, s103
// GFX10: encoding: [0x05,0x00,0x71,0xd5,0x01,0x05,0x9e,0x01]

v_msad_u8 v5, v1, v2, vcc_lo
// GFX10: encoding: [0x05,0x00,0x71,0xd5,0x01,0x05,0xaa,0x01]

v_msad_u8 v5, v1, v2, vcc_hi
// GFX10: encoding: [0x05,0x00,0x71,0xd5,0x01,0x05,0xae,0x01]

v_msad_u8 v5, v1, v2, ttmp11
// GFX10: encoding: [0x05,0x00,0x71,0xd5,0x01,0x05,0xde,0x01]

v_msad_u8 v5, v1, v2, m0
// GFX10: encoding: [0x05,0x00,0x71,0xd5,0x01,0x05,0xf2,0x01]

v_msad_u8 v5, v1, v2, exec_lo
// GFX10: encoding: [0x05,0x00,0x71,0xd5,0x01,0x05,0xfa,0x01]

v_msad_u8 v5, v1, v2, exec_hi
// GFX10: encoding: [0x05,0x00,0x71,0xd5,0x01,0x05,0xfe,0x01]

v_msad_u8 v5, v1, v2, 0
// GFX10: encoding: [0x05,0x00,0x71,0xd5,0x01,0x05,0x02,0x02]

v_msad_u8 v5, v1, v2, -1
// GFX10: encoding: [0x05,0x00,0x71,0xd5,0x01,0x05,0x06,0x03]

v_msad_u8 v5, v1, v2, 0.5
// GFX10: encoding: [0x05,0x00,0x71,0xd5,0x01,0x05,0xc2,0x03]

v_msad_u8 v5, v1, v2, -4.0
// GFX10: encoding: [0x05,0x00,0x71,0xd5,0x01,0x05,0xde,0x03]

v_qsad_pk_u16_u8 v[5:6], v[1:2], v2, v[3:4]
// GFX10: encoding: [0x05,0x00,0x72,0xd5,0x01,0x05,0x0e,0x04]

v_qsad_pk_u16_u8 v[254:255], v[1:2], v2, v[3:4]
// GFX10: encoding: [0xfe,0x00,0x72,0xd5,0x01,0x05,0x0e,0x04]

v_qsad_pk_u16_u8 v[5:6], v[254:255], v2, v[3:4]
// GFX10: encoding: [0x05,0x00,0x72,0xd5,0xfe,0x05,0x0e,0x04]

v_qsad_pk_u16_u8 v[5:6], s[2:3], v2, v[3:4]
// GFX10: encoding: [0x05,0x00,0x72,0xd5,0x02,0x04,0x0e,0x04]

v_qsad_pk_u16_u8 v[5:6], s[4:5], v2, v[3:4]
// GFX10: encoding: [0x05,0x00,0x72,0xd5,0x04,0x04,0x0e,0x04]

v_qsad_pk_u16_u8 v[5:6], s[102:103], v2, v[3:4]
// GFX10: encoding: [0x05,0x00,0x72,0xd5,0x66,0x04,0x0e,0x04]

v_qsad_pk_u16_u8 v[5:6], vcc, v2, v[3:4]
// GFX10: encoding: [0x05,0x00,0x72,0xd5,0x6a,0x04,0x0e,0x04]

v_qsad_pk_u16_u8 v[5:6], ttmp[10:11], v2, v[3:4]
// GFX10: encoding: [0x05,0x00,0x72,0xd5,0x76,0x04,0x0e,0x04]

v_qsad_pk_u16_u8 v[5:6], exec, v2, v[3:4]
// GFX10: encoding: [0x05,0x00,0x72,0xd5,0x7e,0x04,0x0e,0x04]

v_qsad_pk_u16_u8 v[5:6], 0, v2, v[3:4]
// GFX10: encoding: [0x05,0x00,0x72,0xd5,0x80,0x04,0x0e,0x04]

v_qsad_pk_u16_u8 v[5:6], -1, v2, v[3:4]
// GFX10: encoding: [0x05,0x00,0x72,0xd5,0xc1,0x04,0x0e,0x04]

v_qsad_pk_u16_u8 v[5:6], v[1:2], v255, v[3:4]
// GFX10: encoding: [0x05,0x00,0x72,0xd5,0x01,0xff,0x0f,0x04]

v_qsad_pk_u16_u8 v[5:6], v[1:2], s2, v[3:4]
// GFX10: encoding: [0x05,0x00,0x72,0xd5,0x01,0x05,0x0c,0x04]

v_qsad_pk_u16_u8 v[5:6], v[1:2], s103, v[3:4]
// GFX10: encoding: [0x05,0x00,0x72,0xd5,0x01,0xcf,0x0c,0x04]

v_qsad_pk_u16_u8 v[5:6], v[1:2], vcc_lo, v[3:4]
// GFX10: encoding: [0x05,0x00,0x72,0xd5,0x01,0xd5,0x0c,0x04]

v_qsad_pk_u16_u8 v[5:6], v[1:2], vcc_hi, v[3:4]
// GFX10: encoding: [0x05,0x00,0x72,0xd5,0x01,0xd7,0x0c,0x04]

v_qsad_pk_u16_u8 v[5:6], v[1:2], ttmp11, v[3:4]
// GFX10: encoding: [0x05,0x00,0x72,0xd5,0x01,0xef,0x0c,0x04]

v_qsad_pk_u16_u8 v[5:6], v[1:2], m0, v[3:4]
// GFX10: encoding: [0x05,0x00,0x72,0xd5,0x01,0xf9,0x0c,0x04]

v_qsad_pk_u16_u8 v[5:6], v[1:2], exec_lo, v[3:4]
// GFX10: encoding: [0x05,0x00,0x72,0xd5,0x01,0xfd,0x0c,0x04]

v_qsad_pk_u16_u8 v[5:6], v[1:2], exec_hi, v[3:4]
// GFX10: encoding: [0x05,0x00,0x72,0xd5,0x01,0xff,0x0c,0x04]

v_qsad_pk_u16_u8 v[5:6], v[1:2], 0, v[3:4]
// GFX10: encoding: [0x05,0x00,0x72,0xd5,0x01,0x01,0x0d,0x04]

v_qsad_pk_u16_u8 v[5:6], v[1:2], -1, v[3:4]
// GFX10: encoding: [0x05,0x00,0x72,0xd5,0x01,0x83,0x0d,0x04]

v_qsad_pk_u16_u8 v[5:6], v[1:2], v2, v[254:255]
// GFX10: encoding: [0x05,0x00,0x72,0xd5,0x01,0x05,0xfa,0x07]

v_qsad_pk_u16_u8 v[5:6], v[1:2], v2, s[6:7]
// GFX10: encoding: [0x05,0x00,0x72,0xd5,0x01,0x05,0x1a,0x00]

v_qsad_pk_u16_u8 v[5:6], v[1:2], v2, s[8:9]
// GFX10: encoding: [0x05,0x00,0x72,0xd5,0x01,0x05,0x22,0x00]

v_qsad_pk_u16_u8 v[5:6], v[1:2], v2, s[102:103]
// GFX10: encoding: [0x05,0x00,0x72,0xd5,0x01,0x05,0x9a,0x01]

v_qsad_pk_u16_u8 v[5:6], v[1:2], v2, vcc
// GFX10: encoding: [0x05,0x00,0x72,0xd5,0x01,0x05,0xaa,0x01]

v_qsad_pk_u16_u8 v[5:6], v[1:2], v2, ttmp[10:11]
// GFX10: encoding: [0x05,0x00,0x72,0xd5,0x01,0x05,0xda,0x01]

v_qsad_pk_u16_u8 v[5:6], v[1:2], v2, exec
// GFX10: encoding: [0x05,0x00,0x72,0xd5,0x01,0x05,0xfa,0x01]

v_qsad_pk_u16_u8 v[5:6], v[1:2], v2, 0
// GFX10: encoding: [0x05,0x00,0x72,0xd5,0x01,0x05,0x02,0x02]

v_qsad_pk_u16_u8 v[5:6], v[1:2], v2, -1
// GFX10: encoding: [0x05,0x00,0x72,0xd5,0x01,0x05,0x06,0x03]

v_mqsad_pk_u16_u8 v[5:6], v[1:2], v2, v[3:4]
// GFX10: encoding: [0x05,0x00,0x73,0xd5,0x01,0x05,0x0e,0x04]

v_mqsad_pk_u16_u8 v[254:255], v[1:2], v2, v[3:4]
// GFX10: encoding: [0xfe,0x00,0x73,0xd5,0x01,0x05,0x0e,0x04]

v_mqsad_pk_u16_u8 v[5:6], v[254:255], v2, v[3:4]
// GFX10: encoding: [0x05,0x00,0x73,0xd5,0xfe,0x05,0x0e,0x04]

v_mqsad_pk_u16_u8 v[5:6], s[2:3], v2, v[3:4]
// GFX10: encoding: [0x05,0x00,0x73,0xd5,0x02,0x04,0x0e,0x04]

v_mqsad_pk_u16_u8 v[5:6], s[4:5], v2, v[3:4]
// GFX10: encoding: [0x05,0x00,0x73,0xd5,0x04,0x04,0x0e,0x04]

v_mqsad_pk_u16_u8 v[5:6], s[102:103], v2, v[3:4]
// GFX10: encoding: [0x05,0x00,0x73,0xd5,0x66,0x04,0x0e,0x04]

v_mqsad_pk_u16_u8 v[5:6], vcc, v2, v[3:4]
// GFX10: encoding: [0x05,0x00,0x73,0xd5,0x6a,0x04,0x0e,0x04]

v_mqsad_pk_u16_u8 v[5:6], ttmp[10:11], v2, v[3:4]
// GFX10: encoding: [0x05,0x00,0x73,0xd5,0x76,0x04,0x0e,0x04]

v_mqsad_pk_u16_u8 v[5:6], exec, v2, v[3:4]
// GFX10: encoding: [0x05,0x00,0x73,0xd5,0x7e,0x04,0x0e,0x04]

v_mqsad_pk_u16_u8 v[5:6], 0, v2, v[3:4]
// GFX10: encoding: [0x05,0x00,0x73,0xd5,0x80,0x04,0x0e,0x04]

v_mqsad_pk_u16_u8 v[5:6], -1, v2, v[3:4]
// GFX10: encoding: [0x05,0x00,0x73,0xd5,0xc1,0x04,0x0e,0x04]

v_mqsad_pk_u16_u8 v[5:6], v[1:2], v255, v[3:4]
// GFX10: encoding: [0x05,0x00,0x73,0xd5,0x01,0xff,0x0f,0x04]

v_mqsad_pk_u16_u8 v[5:6], v[1:2], s2, v[3:4]
// GFX10: encoding: [0x05,0x00,0x73,0xd5,0x01,0x05,0x0c,0x04]

v_mqsad_pk_u16_u8 v[5:6], v[1:2], s103, v[3:4]
// GFX10: encoding: [0x05,0x00,0x73,0xd5,0x01,0xcf,0x0c,0x04]

v_mqsad_pk_u16_u8 v[5:6], v[1:2], vcc_lo, v[3:4]
// GFX10: encoding: [0x05,0x00,0x73,0xd5,0x01,0xd5,0x0c,0x04]

v_mqsad_pk_u16_u8 v[5:6], v[1:2], vcc_hi, v[3:4]
// GFX10: encoding: [0x05,0x00,0x73,0xd5,0x01,0xd7,0x0c,0x04]

v_mqsad_pk_u16_u8 v[5:6], v[1:2], ttmp11, v[3:4]
// GFX10: encoding: [0x05,0x00,0x73,0xd5,0x01,0xef,0x0c,0x04]

v_mqsad_pk_u16_u8 v[5:6], v[1:2], m0, v[3:4]
// GFX10: encoding: [0x05,0x00,0x73,0xd5,0x01,0xf9,0x0c,0x04]

v_mqsad_pk_u16_u8 v[5:6], v[1:2], exec_lo, v[3:4]
// GFX10: encoding: [0x05,0x00,0x73,0xd5,0x01,0xfd,0x0c,0x04]

v_mqsad_pk_u16_u8 v[5:6], v[1:2], exec_hi, v[3:4]
// GFX10: encoding: [0x05,0x00,0x73,0xd5,0x01,0xff,0x0c,0x04]

v_mqsad_pk_u16_u8 v[5:6], v[1:2], 0, v[3:4]
// GFX10: encoding: [0x05,0x00,0x73,0xd5,0x01,0x01,0x0d,0x04]

v_mqsad_pk_u16_u8 v[5:6], v[1:2], -1, v[3:4]
// GFX10: encoding: [0x05,0x00,0x73,0xd5,0x01,0x83,0x0d,0x04]

v_mqsad_pk_u16_u8 v[5:6], v[1:2], v2, v[254:255]
// GFX10: encoding: [0x05,0x00,0x73,0xd5,0x01,0x05,0xfa,0x07]

v_mqsad_pk_u16_u8 v[5:6], v[1:2], v2, s[6:7]
// GFX10: encoding: [0x05,0x00,0x73,0xd5,0x01,0x05,0x1a,0x00]

v_mqsad_pk_u16_u8 v[5:6], v[1:2], v2, s[8:9]
// GFX10: encoding: [0x05,0x00,0x73,0xd5,0x01,0x05,0x22,0x00]

v_mqsad_pk_u16_u8 v[5:6], v[1:2], v2, s[102:103]
// GFX10: encoding: [0x05,0x00,0x73,0xd5,0x01,0x05,0x9a,0x01]

v_mqsad_pk_u16_u8 v[5:6], v[1:2], v2, vcc
// GFX10: encoding: [0x05,0x00,0x73,0xd5,0x01,0x05,0xaa,0x01]

v_mqsad_pk_u16_u8 v[5:6], v[1:2], v2, ttmp[10:11]
// GFX10: encoding: [0x05,0x00,0x73,0xd5,0x01,0x05,0xda,0x01]

v_mqsad_pk_u16_u8 v[5:6], v[1:2], v2, exec
// GFX10: encoding: [0x05,0x00,0x73,0xd5,0x01,0x05,0xfa,0x01]

v_mqsad_pk_u16_u8 v[5:6], v[1:2], v2, 0
// GFX10: encoding: [0x05,0x00,0x73,0xd5,0x01,0x05,0x02,0x02]

v_mqsad_pk_u16_u8 v[5:6], v[1:2], v2, -1
// GFX10: encoding: [0x05,0x00,0x73,0xd5,0x01,0x05,0x06,0x03]

v_trig_preop_f64 v[5:6], v[1:2], v2
// GFX10: encoding: [0x05,0x00,0x74,0xd5,0x01,0x05,0x02,0x00]

v_trig_preop_f64 v[254:255], v[1:2], v2
// GFX10: encoding: [0xfe,0x00,0x74,0xd5,0x01,0x05,0x02,0x00]

v_trig_preop_f64 v[5:6], v[254:255], v2
// GFX10: encoding: [0x05,0x00,0x74,0xd5,0xfe,0x05,0x02,0x00]

v_trig_preop_f64 v[5:6], s[2:3], v2
// GFX10: encoding: [0x05,0x00,0x74,0xd5,0x02,0x04,0x02,0x00]

v_trig_preop_f64 v[5:6], s[4:5], v2
// GFX10: encoding: [0x05,0x00,0x74,0xd5,0x04,0x04,0x02,0x00]

v_trig_preop_f64 v[5:6], s[102:103], v2
// GFX10: encoding: [0x05,0x00,0x74,0xd5,0x66,0x04,0x02,0x00]

v_trig_preop_f64 v[5:6], vcc, v2
// GFX10: encoding: [0x05,0x00,0x74,0xd5,0x6a,0x04,0x02,0x00]

v_trig_preop_f64 v[5:6], ttmp[10:11], v2
// GFX10: encoding: [0x05,0x00,0x74,0xd5,0x76,0x04,0x02,0x00]

v_trig_preop_f64 v[5:6], exec, v2
// GFX10: encoding: [0x05,0x00,0x74,0xd5,0x7e,0x04,0x02,0x00]

v_trig_preop_f64 v[5:6], 0, v2
// GFX10: encoding: [0x05,0x00,0x74,0xd5,0x80,0x04,0x02,0x00]

v_trig_preop_f64 v[5:6], -1, v2
// GFX10: encoding: [0x05,0x00,0x74,0xd5,0xc1,0x04,0x02,0x00]

v_trig_preop_f64 v[5:6], 0.5, v2
// GFX10: encoding: [0x05,0x00,0x74,0xd5,0xf0,0x04,0x02,0x00]

v_trig_preop_f64 v[5:6], -4.0, v2
// GFX10: encoding: [0x05,0x00,0x74,0xd5,0xf7,0x04,0x02,0x00]

v_trig_preop_f64 v[5:6], v[1:2], v255
// GFX10: encoding: [0x05,0x00,0x74,0xd5,0x01,0xff,0x03,0x00]

v_trig_preop_f64 v[5:6], v[1:2], s2
// GFX10: encoding: [0x05,0x00,0x74,0xd5,0x01,0x05,0x00,0x00]

v_trig_preop_f64 v[5:6], v[1:2], s103
// GFX10: encoding: [0x05,0x00,0x74,0xd5,0x01,0xcf,0x00,0x00]

v_trig_preop_f64 v[5:6], v[1:2], vcc_lo
// GFX10: encoding: [0x05,0x00,0x74,0xd5,0x01,0xd5,0x00,0x00]

v_trig_preop_f64 v[5:6], v[1:2], vcc_hi
// GFX10: encoding: [0x05,0x00,0x74,0xd5,0x01,0xd7,0x00,0x00]

v_trig_preop_f64 v[5:6], v[1:2], ttmp11
// GFX10: encoding: [0x05,0x00,0x74,0xd5,0x01,0xef,0x00,0x00]

v_trig_preop_f64 v[5:6], v[1:2], m0
// GFX10: encoding: [0x05,0x00,0x74,0xd5,0x01,0xf9,0x00,0x00]

v_trig_preop_f64 v[5:6], v[1:2], exec_lo
// GFX10: encoding: [0x05,0x00,0x74,0xd5,0x01,0xfd,0x00,0x00]

v_trig_preop_f64 v[5:6], v[1:2], exec_hi
// GFX10: encoding: [0x05,0x00,0x74,0xd5,0x01,0xff,0x00,0x00]

v_trig_preop_f64 v[5:6], v[1:2], 0
// GFX10: encoding: [0x05,0x00,0x74,0xd5,0x01,0x01,0x01,0x00]

v_trig_preop_f64 v[5:6], v[1:2], -1
// GFX10: encoding: [0x05,0x00,0x74,0xd5,0x01,0x83,0x01,0x00]

v_trig_preop_f64 v[5:6], v[1:2], 0.5
// GFX10: encoding: [0x05,0x00,0x74,0xd5,0x01,0xe1,0x01,0x00]

v_trig_preop_f64 v[5:6], v[1:2], -4.0
// GFX10: encoding: [0x05,0x00,0x74,0xd5,0x01,0xef,0x01,0x00]

v_trig_preop_f64 v[5:6], -v[1:2], v2
// GFX10: encoding: [0x05,0x00,0x74,0xd5,0x01,0x05,0x02,0x20]

v_trig_preop_f64 v[5:6], |v[1:2]|, v2
// GFX10: encoding: [0x05,0x01,0x74,0xd5,0x01,0x05,0x02,0x00]

v_trig_preop_f64 v[5:6], v[1:2], v2 clamp
// GFX10: encoding: [0x05,0x80,0x74,0xd5,0x01,0x05,0x02,0x00]

v_trig_preop_f64 v[5:6], v[1:2], v2 mul:2
// GFX10: encoding: [0x05,0x00,0x74,0xd5,0x01,0x05,0x02,0x08]

v_trig_preop_f64 v[5:6], v[1:2], v2 mul:4
// GFX10: encoding: [0x05,0x00,0x74,0xd5,0x01,0x05,0x02,0x10]

v_trig_preop_f64 v[5:6], v[1:2], v2 div:2
// GFX10: encoding: [0x05,0x00,0x74,0xd5,0x01,0x05,0x02,0x18]

v_mqsad_u32_u8 v[252:255], v[1:2], v2, v[3:6]
// GFX10: encoding: [0xfc,0x00,0x75,0xd5,0x01,0x05,0x0e,0x04]

v_mqsad_u32_u8 v[252:255], s[2:3], v2, v[3:6]
// GFX10: encoding: [0xfc,0x00,0x75,0xd5,0x02,0x04,0x0e,0x04]

v_mqsad_u32_u8 v[252:255], s[4:5], v2, v[3:6]
// GFX10: encoding: [0xfc,0x00,0x75,0xd5,0x04,0x04,0x0e,0x04]

v_mqsad_u32_u8 v[252:255], s[102:103], v2, v[3:6]
// GFX10: encoding: [0xfc,0x00,0x75,0xd5,0x66,0x04,0x0e,0x04]

v_mqsad_u32_u8 v[252:255], vcc, v2, v[3:6]
// GFX10: encoding: [0xfc,0x00,0x75,0xd5,0x6a,0x04,0x0e,0x04]

v_mqsad_u32_u8 v[252:255], ttmp[10:11], v2, v[3:6]
// GFX10: encoding: [0xfc,0x00,0x75,0xd5,0x76,0x04,0x0e,0x04]

v_mqsad_u32_u8 v[252:255], exec, v2, v[3:6]
// GFX10: encoding: [0xfc,0x00,0x75,0xd5,0x7e,0x04,0x0e,0x04]

v_mqsad_u32_u8 v[252:255], 0, v2, v[3:6]
// GFX10: encoding: [0xfc,0x00,0x75,0xd5,0x80,0x04,0x0e,0x04]

v_mqsad_u32_u8 v[252:255], -1, v2, v[3:6]
// GFX10: encoding: [0xfc,0x00,0x75,0xd5,0xc1,0x04,0x0e,0x04]

v_mqsad_u32_u8 v[252:255], v[1:2], s2, v[3:6]
// GFX10: encoding: [0xfc,0x00,0x75,0xd5,0x01,0x05,0x0c,0x04]

v_mqsad_u32_u8 v[252:255], v[1:2], s103, v[3:6]
// GFX10: encoding: [0xfc,0x00,0x75,0xd5,0x01,0xcf,0x0c,0x04]

v_mqsad_u32_u8 v[252:255], v[1:2], vcc_lo, v[3:6]
// GFX10: encoding: [0xfc,0x00,0x75,0xd5,0x01,0xd5,0x0c,0x04]

v_mqsad_u32_u8 v[252:255], v[1:2], vcc_hi, v[3:6]
// GFX10: encoding: [0xfc,0x00,0x75,0xd5,0x01,0xd7,0x0c,0x04]

v_mqsad_u32_u8 v[252:255], v[1:2], ttmp11, v[3:6]
// GFX10: encoding: [0xfc,0x00,0x75,0xd5,0x01,0xef,0x0c,0x04]

v_mqsad_u32_u8 v[252:255], v[1:2], m0, v[3:6]
// GFX10: encoding: [0xfc,0x00,0x75,0xd5,0x01,0xf9,0x0c,0x04]

v_mqsad_u32_u8 v[252:255], v[1:2], exec_lo, v[3:6]
// GFX10: encoding: [0xfc,0x00,0x75,0xd5,0x01,0xfd,0x0c,0x04]

v_mqsad_u32_u8 v[252:255], v[1:2], exec_hi, v[3:6]
// GFX10: encoding: [0xfc,0x00,0x75,0xd5,0x01,0xff,0x0c,0x04]

v_mqsad_u32_u8 v[252:255], v[1:2], 0, v[3:6]
// GFX10: encoding: [0xfc,0x00,0x75,0xd5,0x01,0x01,0x0d,0x04]

v_mqsad_u32_u8 v[252:255], v[1:2], -1, v[3:6]
// GFX10: encoding: [0xfc,0x00,0x75,0xd5,0x01,0x83,0x0d,0x04]

v_mad_u64_u32 v[5:6], s12, v1, v2, v[3:4]
// W32: encoding: [0x05,0x0c,0x76,0xd5,0x01,0x05,0x0e,0x04]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_u64_u32 v[254:255], s12, v1, v2, v[3:4]
// W32: encoding: [0xfe,0x0c,0x76,0xd5,0x01,0x05,0x0e,0x04]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s14, v1, v2, v[3:4]
// W32: encoding: [0x05,0x0e,0x76,0xd5,0x01,0x05,0x0e,0x04]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s100, v1, v2, v[3:4]
// W32: encoding: [0x05,0x64,0x76,0xd5,0x01,0x05,0x0e,0x04]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s12, v255, v2, v[3:4]
// W32: encoding: [0x05,0x0c,0x76,0xd5,0xff,0x05,0x0e,0x04]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s12, s1, v2, v[3:4]
// W32: encoding: [0x05,0x0c,0x76,0xd5,0x01,0x04,0x0e,0x04]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s12, s101, v2, v[3:4]
// W32: encoding: [0x05,0x0c,0x76,0xd5,0x65,0x04,0x0e,0x04]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s12, vcc_lo, v2, v[3:4]
// W32: encoding: [0x05,0x0c,0x76,0xd5,0x6a,0x04,0x0e,0x04]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s12, vcc_hi, v2, v[3:4]
// W32: encoding: [0x05,0x0c,0x76,0xd5,0x6b,0x04,0x0e,0x04]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s12, m0, v2, v[3:4]
// W32: encoding: [0x05,0x0c,0x76,0xd5,0x7c,0x04,0x0e,0x04]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s12, exec_lo, v2, v[3:4]
// W32: encoding: [0x05,0x0c,0x76,0xd5,0x7e,0x04,0x0e,0x04]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s12, exec_hi, v2, v[3:4]
// W32: encoding: [0x05,0x0c,0x76,0xd5,0x7f,0x04,0x0e,0x04]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s12, 0, v2, v[3:4]
// W32: encoding: [0x05,0x0c,0x76,0xd5,0x80,0x04,0x0e,0x04]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s12, -1, v2, v[3:4]
// W32: encoding: [0x05,0x0c,0x76,0xd5,0xc1,0x04,0x0e,0x04]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s12, 0.5, v2, v[3:4]
// W32: encoding: [0x05,0x0c,0x76,0xd5,0xf0,0x04,0x0e,0x04]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s12, -4.0, v2, v[3:4]
// W32: encoding: [0x05,0x0c,0x76,0xd5,0xf7,0x04,0x0e,0x04]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s12, v1, v255, v[3:4]
// W32: encoding: [0x05,0x0c,0x76,0xd5,0x01,0xff,0x0f,0x04]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s12, v1, s2, v[3:4]
// W32: encoding: [0x05,0x0c,0x76,0xd5,0x01,0x05,0x0c,0x04]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s12, v1, s101, v[3:4]
// W32: encoding: [0x05,0x0c,0x76,0xd5,0x01,0xcb,0x0c,0x04]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s12, v1, vcc_lo, v[3:4]
// W32: encoding: [0x05,0x0c,0x76,0xd5,0x01,0xd5,0x0c,0x04]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s12, v1, vcc_hi, v[3:4]
// W32: encoding: [0x05,0x0c,0x76,0xd5,0x01,0xd7,0x0c,0x04]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s12, v1, m0, v[3:4]
// W32: encoding: [0x05,0x0c,0x76,0xd5,0x01,0xf9,0x0c,0x04]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s12, v1, exec_lo, v[3:4]
// W32: encoding: [0x05,0x0c,0x76,0xd5,0x01,0xfd,0x0c,0x04]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s12, v1, exec_hi, v[3:4]
// W32: encoding: [0x05,0x0c,0x76,0xd5,0x01,0xff,0x0c,0x04]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s12, v1, 0, v[3:4]
// W32: encoding: [0x05,0x0c,0x76,0xd5,0x01,0x01,0x0d,0x04]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s12, v1, -1, v[3:4]
// W32: encoding: [0x05,0x0c,0x76,0xd5,0x01,0x83,0x0d,0x04]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s12, v1, 0.5, v[3:4]
// W32: encoding: [0x05,0x0c,0x76,0xd5,0x01,0xe1,0x0d,0x04]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s12, v1, -4.0, v[3:4]
// W32: encoding: [0x05,0x0c,0x76,0xd5,0x01,0xef,0x0d,0x04]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s12, v1, v2, v[254:255]
// W32: encoding: [0x05,0x0c,0x76,0xd5,0x01,0x05,0xfa,0x07]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s12, v1, v2, s[6:7]
// W32: encoding: [0x05,0x0c,0x76,0xd5,0x01,0x05,0x1a,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s12, v1, v2, s[8:9]
// W32: encoding: [0x05,0x0c,0x76,0xd5,0x01,0x05,0x22,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s12, v1, v2, s[100:101]
// W32: encoding: [0x05,0x0c,0x76,0xd5,0x01,0x05,0x92,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s12, v1, v2, vcc
// W32: encoding: [0x05,0x0c,0x76,0xd5,0x01,0x05,0xaa,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s12, v1, v2, exec
// W32: encoding: [0x05,0x0c,0x76,0xd5,0x01,0x05,0xfa,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s12, v1, v2, 0
// W32: encoding: [0x05,0x0c,0x76,0xd5,0x01,0x05,0x02,0x02]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s12, v1, v2, -1
// W32: encoding: [0x05,0x0c,0x76,0xd5,0x01,0x05,0x06,0x03]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s12, v1, v2, 0.5
// W32: encoding: [0x05,0x0c,0x76,0xd5,0x01,0x05,0xc2,0x03]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s12, v1, v2, -4.0
// W32: encoding: [0x05,0x0c,0x76,0xd5,0x01,0x05,0xde,0x03]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s[12:13], v1, v2, v[3:4]
// W64: encoding: [0x05,0x0c,0x76,0xd5,0x01,0x05,0x0e,0x04]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_u64_u32 v[254:255], s[12:13], v1, v2, v[3:4]
// W64: encoding: [0xfe,0x0c,0x76,0xd5,0x01,0x05,0x0e,0x04]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s[14:15], v1, v2, v[3:4]
// W64: encoding: [0x05,0x0e,0x76,0xd5,0x01,0x05,0x0e,0x04]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s[100:101], v1, v2, v[3:4]
// W64: encoding: [0x05,0x64,0x76,0xd5,0x01,0x05,0x0e,0x04]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s[12:13], v255, v2, v[3:4]
// W64: encoding: [0x05,0x0c,0x76,0xd5,0xff,0x05,0x0e,0x04]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s[12:13], s1, v2, v[3:4]
// W64: encoding: [0x05,0x0c,0x76,0xd5,0x01,0x04,0x0e,0x04]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s[12:13], s101, v2, v[3:4]
// W64: encoding: [0x05,0x0c,0x76,0xd5,0x65,0x04,0x0e,0x04]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s[12:13], vcc_lo, v2, v[3:4]
// W64: encoding: [0x05,0x0c,0x76,0xd5,0x6a,0x04,0x0e,0x04]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s[12:13], vcc_hi, v2, v[3:4]
// W64: encoding: [0x05,0x0c,0x76,0xd5,0x6b,0x04,0x0e,0x04]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s[12:13], m0, v2, v[3:4]
// W64: encoding: [0x05,0x0c,0x76,0xd5,0x7c,0x04,0x0e,0x04]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s[12:13], exec_lo, v2, v[3:4]
// W64: encoding: [0x05,0x0c,0x76,0xd5,0x7e,0x04,0x0e,0x04]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s[12:13], exec_hi, v2, v[3:4]
// W64: encoding: [0x05,0x0c,0x76,0xd5,0x7f,0x04,0x0e,0x04]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s[12:13], 0, v2, v[3:4]
// W64: encoding: [0x05,0x0c,0x76,0xd5,0x80,0x04,0x0e,0x04]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s[12:13], -1, v2, v[3:4]
// W64: encoding: [0x05,0x0c,0x76,0xd5,0xc1,0x04,0x0e,0x04]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s[12:13], 0.5, v2, v[3:4]
// W64: encoding: [0x05,0x0c,0x76,0xd5,0xf0,0x04,0x0e,0x04]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s[12:13], -4.0, v2, v[3:4]
// W64: encoding: [0x05,0x0c,0x76,0xd5,0xf7,0x04,0x0e,0x04]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s[12:13], v1, v255, v[3:4]
// W64: encoding: [0x05,0x0c,0x76,0xd5,0x01,0xff,0x0f,0x04]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s[12:13], v1, s2, v[3:4]
// W64: encoding: [0x05,0x0c,0x76,0xd5,0x01,0x05,0x0c,0x04]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s[12:13], v1, s101, v[3:4]
// W64: encoding: [0x05,0x0c,0x76,0xd5,0x01,0xcb,0x0c,0x04]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s[12:13], v1, vcc_lo, v[3:4]
// W64: encoding: [0x05,0x0c,0x76,0xd5,0x01,0xd5,0x0c,0x04]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s[12:13], v1, vcc_hi, v[3:4]
// W64: encoding: [0x05,0x0c,0x76,0xd5,0x01,0xd7,0x0c,0x04]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s[12:13], v1, m0, v[3:4]
// W64: encoding: [0x05,0x0c,0x76,0xd5,0x01,0xf9,0x0c,0x04]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s[12:13], v1, exec_lo, v[3:4]
// W64: encoding: [0x05,0x0c,0x76,0xd5,0x01,0xfd,0x0c,0x04]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s[12:13], v1, exec_hi, v[3:4]
// W64: encoding: [0x05,0x0c,0x76,0xd5,0x01,0xff,0x0c,0x04]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s[12:13], v1, 0, v[3:4]
// W64: encoding: [0x05,0x0c,0x76,0xd5,0x01,0x01,0x0d,0x04]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s[12:13], v1, -1, v[3:4]
// W64: encoding: [0x05,0x0c,0x76,0xd5,0x01,0x83,0x0d,0x04]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s[12:13], v1, 0.5, v[3:4]
// W64: encoding: [0x05,0x0c,0x76,0xd5,0x01,0xe1,0x0d,0x04]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s[12:13], v1, -4.0, v[3:4]
// W64: encoding: [0x05,0x0c,0x76,0xd5,0x01,0xef,0x0d,0x04]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s[12:13], v1, v2, v[254:255]
// W64: encoding: [0x05,0x0c,0x76,0xd5,0x01,0x05,0xfa,0x07]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s[12:13], v1, v2, s[6:7]
// W64: encoding: [0x05,0x0c,0x76,0xd5,0x01,0x05,0x1a,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s[12:13], v1, v2, s[8:9]
// W64: encoding: [0x05,0x0c,0x76,0xd5,0x01,0x05,0x22,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s[12:13], v1, v2, s[100:101]
// W64: encoding: [0x05,0x0c,0x76,0xd5,0x01,0x05,0x92,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s[12:13], v1, v2, vcc
// W64: encoding: [0x05,0x0c,0x76,0xd5,0x01,0x05,0xaa,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s[12:13], v1, v2, exec
// W64: encoding: [0x05,0x0c,0x76,0xd5,0x01,0x05,0xfa,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s[12:13], v1, v2, 0
// W64: encoding: [0x05,0x0c,0x76,0xd5,0x01,0x05,0x02,0x02]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s[12:13], v1, v2, -1
// W64: encoding: [0x05,0x0c,0x76,0xd5,0x01,0x05,0x06,0x03]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s[12:13], v1, v2, 0.5
// W64: encoding: [0x05,0x0c,0x76,0xd5,0x01,0x05,0xc2,0x03]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s[12:13], v1, v2, -4.0
// W64: encoding: [0x05,0x0c,0x76,0xd5,0x01,0x05,0xde,0x03]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s12, v1, v2, v[3:4]
// W32: encoding: [0x05,0x0c,0x77,0xd5,0x01,0x05,0x0e,0x04]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_i64_i32 v[254:255], s12, v1, v2, v[3:4]
// W32: encoding: [0xfe,0x0c,0x77,0xd5,0x01,0x05,0x0e,0x04]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s14, v1, v2, v[3:4]
// W32: encoding: [0x05,0x0e,0x77,0xd5,0x01,0x05,0x0e,0x04]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s100, v1, v2, v[3:4]
// W32: encoding: [0x05,0x64,0x77,0xd5,0x01,0x05,0x0e,0x04]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s12, v255, v2, v[3:4]
// W32: encoding: [0x05,0x0c,0x77,0xd5,0xff,0x05,0x0e,0x04]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s12, s1, v2, v[3:4]
// W32: encoding: [0x05,0x0c,0x77,0xd5,0x01,0x04,0x0e,0x04]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s12, s101, v2, v[3:4]
// W32: encoding: [0x05,0x0c,0x77,0xd5,0x65,0x04,0x0e,0x04]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s12, vcc_lo, v2, v[3:4]
// W32: encoding: [0x05,0x0c,0x77,0xd5,0x6a,0x04,0x0e,0x04]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s12, vcc_hi, v2, v[3:4]
// W32: encoding: [0x05,0x0c,0x77,0xd5,0x6b,0x04,0x0e,0x04]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s12, m0, v2, v[3:4]
// W32: encoding: [0x05,0x0c,0x77,0xd5,0x7c,0x04,0x0e,0x04]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s12, exec_lo, v2, v[3:4]
// W32: encoding: [0x05,0x0c,0x77,0xd5,0x7e,0x04,0x0e,0x04]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s12, exec_hi, v2, v[3:4]
// W32: encoding: [0x05,0x0c,0x77,0xd5,0x7f,0x04,0x0e,0x04]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s12, 0, v2, v[3:4]
// W32: encoding: [0x05,0x0c,0x77,0xd5,0x80,0x04,0x0e,0x04]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s12, -1, v2, v[3:4]
// W32: encoding: [0x05,0x0c,0x77,0xd5,0xc1,0x04,0x0e,0x04]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s12, 0.5, v2, v[3:4]
// W32: encoding: [0x05,0x0c,0x77,0xd5,0xf0,0x04,0x0e,0x04]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s12, -4.0, v2, v[3:4]
// W32: encoding: [0x05,0x0c,0x77,0xd5,0xf7,0x04,0x0e,0x04]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s12, v1, v255, v[3:4]
// W32: encoding: [0x05,0x0c,0x77,0xd5,0x01,0xff,0x0f,0x04]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s12, v1, s2, v[3:4]
// W32: encoding: [0x05,0x0c,0x77,0xd5,0x01,0x05,0x0c,0x04]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s12, v1, s101, v[3:4]
// W32: encoding: [0x05,0x0c,0x77,0xd5,0x01,0xcb,0x0c,0x04]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s12, v1, vcc_lo, v[3:4]
// W32: encoding: [0x05,0x0c,0x77,0xd5,0x01,0xd5,0x0c,0x04]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s12, v1, vcc_hi, v[3:4]
// W32: encoding: [0x05,0x0c,0x77,0xd5,0x01,0xd7,0x0c,0x04]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s12, v1, m0, v[3:4]
// W32: encoding: [0x05,0x0c,0x77,0xd5,0x01,0xf9,0x0c,0x04]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s12, v1, exec_lo, v[3:4]
// W32: encoding: [0x05,0x0c,0x77,0xd5,0x01,0xfd,0x0c,0x04]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s12, v1, exec_hi, v[3:4]
// W32: encoding: [0x05,0x0c,0x77,0xd5,0x01,0xff,0x0c,0x04]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s12, v1, 0, v[3:4]
// W32: encoding: [0x05,0x0c,0x77,0xd5,0x01,0x01,0x0d,0x04]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s12, v1, -1, v[3:4]
// W32: encoding: [0x05,0x0c,0x77,0xd5,0x01,0x83,0x0d,0x04]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s12, v1, 0.5, v[3:4]
// W32: encoding: [0x05,0x0c,0x77,0xd5,0x01,0xe1,0x0d,0x04]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s12, v1, -4.0, v[3:4]
// W32: encoding: [0x05,0x0c,0x77,0xd5,0x01,0xef,0x0d,0x04]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s12, v1, v2, v[254:255]
// W32: encoding: [0x05,0x0c,0x77,0xd5,0x01,0x05,0xfa,0x07]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s12, v1, v2, s[6:7]
// W32: encoding: [0x05,0x0c,0x77,0xd5,0x01,0x05,0x1a,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s12, v1, v2, s[8:9]
// W32: encoding: [0x05,0x0c,0x77,0xd5,0x01,0x05,0x22,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s12, v1, v2, s[100:101]
// W32: encoding: [0x05,0x0c,0x77,0xd5,0x01,0x05,0x92,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s12, v1, v2, vcc
// W32: encoding: [0x05,0x0c,0x77,0xd5,0x01,0x05,0xaa,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s12, v1, v2, exec
// W32: encoding: [0x05,0x0c,0x77,0xd5,0x01,0x05,0xfa,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s12, v1, v2, 0
// W32: encoding: [0x05,0x0c,0x77,0xd5,0x01,0x05,0x02,0x02]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s12, v1, v2, -1
// W32: encoding: [0x05,0x0c,0x77,0xd5,0x01,0x05,0x06,0x03]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s12, v1, v2, 0.5
// W32: encoding: [0x05,0x0c,0x77,0xd5,0x01,0x05,0xc2,0x03]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s12, v1, v2, -4.0
// W32: encoding: [0x05,0x0c,0x77,0xd5,0x01,0x05,0xde,0x03]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s[12:13], v1, v2, v[3:4]
// W64: encoding: [0x05,0x0c,0x77,0xd5,0x01,0x05,0x0e,0x04]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_i64_i32 v[254:255], s[12:13], v1, v2, v[3:4]
// W64: encoding: [0xfe,0x0c,0x77,0xd5,0x01,0x05,0x0e,0x04]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s[14:15], v1, v2, v[3:4]
// W64: encoding: [0x05,0x0e,0x77,0xd5,0x01,0x05,0x0e,0x04]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s[100:101], v1, v2, v[3:4]
// W64: encoding: [0x05,0x64,0x77,0xd5,0x01,0x05,0x0e,0x04]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s[12:13], v255, v2, v[3:4]
// W64: encoding: [0x05,0x0c,0x77,0xd5,0xff,0x05,0x0e,0x04]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s[12:13], s1, v2, v[3:4]
// W64: encoding: [0x05,0x0c,0x77,0xd5,0x01,0x04,0x0e,0x04]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s[12:13], s101, v2, v[3:4]
// W64: encoding: [0x05,0x0c,0x77,0xd5,0x65,0x04,0x0e,0x04]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s[12:13], vcc_lo, v2, v[3:4]
// W64: encoding: [0x05,0x0c,0x77,0xd5,0x6a,0x04,0x0e,0x04]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s[12:13], vcc_hi, v2, v[3:4]
// W64: encoding: [0x05,0x0c,0x77,0xd5,0x6b,0x04,0x0e,0x04]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s[12:13], m0, v2, v[3:4]
// W64: encoding: [0x05,0x0c,0x77,0xd5,0x7c,0x04,0x0e,0x04]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s[12:13], exec_lo, v2, v[3:4]
// W64: encoding: [0x05,0x0c,0x77,0xd5,0x7e,0x04,0x0e,0x04]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s[12:13], exec_hi, v2, v[3:4]
// W64: encoding: [0x05,0x0c,0x77,0xd5,0x7f,0x04,0x0e,0x04]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s[12:13], 0, v2, v[3:4]
// W64: encoding: [0x05,0x0c,0x77,0xd5,0x80,0x04,0x0e,0x04]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s[12:13], -1, v2, v[3:4]
// W64: encoding: [0x05,0x0c,0x77,0xd5,0xc1,0x04,0x0e,0x04]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s[12:13], 0.5, v2, v[3:4]
// W64: encoding: [0x05,0x0c,0x77,0xd5,0xf0,0x04,0x0e,0x04]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s[12:13], -4.0, v2, v[3:4]
// W64: encoding: [0x05,0x0c,0x77,0xd5,0xf7,0x04,0x0e,0x04]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s[12:13], v1, v255, v[3:4]
// W64: encoding: [0x05,0x0c,0x77,0xd5,0x01,0xff,0x0f,0x04]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s[12:13], v1, s2, v[3:4]
// W64: encoding: [0x05,0x0c,0x77,0xd5,0x01,0x05,0x0c,0x04]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s[12:13], v1, s101, v[3:4]
// W64: encoding: [0x05,0x0c,0x77,0xd5,0x01,0xcb,0x0c,0x04]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s[12:13], v1, vcc_lo, v[3:4]
// W64: encoding: [0x05,0x0c,0x77,0xd5,0x01,0xd5,0x0c,0x04]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s[12:13], v1, vcc_hi, v[3:4]
// W64: encoding: [0x05,0x0c,0x77,0xd5,0x01,0xd7,0x0c,0x04]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s[12:13], v1, m0, v[3:4]
// W64: encoding: [0x05,0x0c,0x77,0xd5,0x01,0xf9,0x0c,0x04]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s[12:13], v1, exec_lo, v[3:4]
// W64: encoding: [0x05,0x0c,0x77,0xd5,0x01,0xfd,0x0c,0x04]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s[12:13], v1, exec_hi, v[3:4]
// W64: encoding: [0x05,0x0c,0x77,0xd5,0x01,0xff,0x0c,0x04]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s[12:13], v1, 0, v[3:4]
// W64: encoding: [0x05,0x0c,0x77,0xd5,0x01,0x01,0x0d,0x04]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s[12:13], v1, -1, v[3:4]
// W64: encoding: [0x05,0x0c,0x77,0xd5,0x01,0x83,0x0d,0x04]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s[12:13], v1, 0.5, v[3:4]
// W64: encoding: [0x05,0x0c,0x77,0xd5,0x01,0xe1,0x0d,0x04]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s[12:13], v1, -4.0, v[3:4]
// W64: encoding: [0x05,0x0c,0x77,0xd5,0x01,0xef,0x0d,0x04]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s[12:13], v1, v2, v[254:255]
// W64: encoding: [0x05,0x0c,0x77,0xd5,0x01,0x05,0xfa,0x07]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s[12:13], v1, v2, s[6:7]
// W64: encoding: [0x05,0x0c,0x77,0xd5,0x01,0x05,0x1a,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s[12:13], v1, v2, s[8:9]
// W64: encoding: [0x05,0x0c,0x77,0xd5,0x01,0x05,0x22,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s[12:13], v1, v2, s[100:101]
// W64: encoding: [0x05,0x0c,0x77,0xd5,0x01,0x05,0x92,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s[12:13], v1, v2, vcc
// W64: encoding: [0x05,0x0c,0x77,0xd5,0x01,0x05,0xaa,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s[12:13], v1, v2, exec
// W64: encoding: [0x05,0x0c,0x77,0xd5,0x01,0x05,0xfa,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s[12:13], v1, v2, 0
// W64: encoding: [0x05,0x0c,0x77,0xd5,0x01,0x05,0x02,0x02]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s[12:13], v1, v2, -1
// W64: encoding: [0x05,0x0c,0x77,0xd5,0x01,0x05,0x06,0x03]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s[12:13], v1, v2, 0.5
// W64: encoding: [0x05,0x0c,0x77,0xd5,0x01,0x05,0xc2,0x03]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s[12:13], v1, v2, -4.0
// W64: encoding: [0x05,0x0c,0x77,0xd5,0x01,0x05,0xde,0x03]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_xor3_b32 v5, v1, v2, v3
// GFX10: encoding: [0x05,0x00,0x78,0xd5,0x01,0x05,0x0e,0x04]

v_xor3_b32 v255, v1, v2, v3
// GFX10: encoding: [0xff,0x00,0x78,0xd5,0x01,0x05,0x0e,0x04]

v_xor3_b32 v5, v255, v2, v3
// GFX10: encoding: [0x05,0x00,0x78,0xd5,0xff,0x05,0x0e,0x04]

v_xor3_b32 v5, s1, v2, v3
// GFX10: encoding: [0x05,0x00,0x78,0xd5,0x01,0x04,0x0e,0x04]

v_xor3_b32 v5, s103, v2, v3
// GFX10: encoding: [0x05,0x00,0x78,0xd5,0x67,0x04,0x0e,0x04]

v_xor3_b32 v5, vcc_lo, v2, v3
// GFX10: encoding: [0x05,0x00,0x78,0xd5,0x6a,0x04,0x0e,0x04]

v_xor3_b32 v5, vcc_hi, v2, v3
// GFX10: encoding: [0x05,0x00,0x78,0xd5,0x6b,0x04,0x0e,0x04]

v_xor3_b32 v5, ttmp11, v2, v3
// GFX10: encoding: [0x05,0x00,0x78,0xd5,0x77,0x04,0x0e,0x04]

v_xor3_b32 v5, m0, v2, v3
// GFX10: encoding: [0x05,0x00,0x78,0xd5,0x7c,0x04,0x0e,0x04]

v_xor3_b32 v5, exec_lo, v2, v3
// GFX10: encoding: [0x05,0x00,0x78,0xd5,0x7e,0x04,0x0e,0x04]

v_xor3_b32 v5, exec_hi, v2, v3
// GFX10: encoding: [0x05,0x00,0x78,0xd5,0x7f,0x04,0x0e,0x04]

v_xor3_b32 v5, 0, v2, v3
// GFX10: encoding: [0x05,0x00,0x78,0xd5,0x80,0x04,0x0e,0x04]

v_xor3_b32 v5, -1, v2, v3
// GFX10: encoding: [0x05,0x00,0x78,0xd5,0xc1,0x04,0x0e,0x04]

v_xor3_b32 v5, 0.5, v2, v3
// GFX10: encoding: [0x05,0x00,0x78,0xd5,0xf0,0x04,0x0e,0x04]

v_xor3_b32 v5, -4.0, v2, v3
// GFX10: encoding: [0x05,0x00,0x78,0xd5,0xf7,0x04,0x0e,0x04]

v_xor3_b32 v5, v1, v255, v3
// GFX10: encoding: [0x05,0x00,0x78,0xd5,0x01,0xff,0x0f,0x04]

v_xor3_b32 v5, v1, s2, v3
// GFX10: encoding: [0x05,0x00,0x78,0xd5,0x01,0x05,0x0c,0x04]

v_xor3_b32 v5, v1, s103, v3
// GFX10: encoding: [0x05,0x00,0x78,0xd5,0x01,0xcf,0x0c,0x04]

v_xor3_b32 v5, v1, vcc_lo, v3
// GFX10: encoding: [0x05,0x00,0x78,0xd5,0x01,0xd5,0x0c,0x04]

v_xor3_b32 v5, v1, vcc_hi, v3
// GFX10: encoding: [0x05,0x00,0x78,0xd5,0x01,0xd7,0x0c,0x04]

v_xor3_b32 v5, v1, ttmp11, v3
// GFX10: encoding: [0x05,0x00,0x78,0xd5,0x01,0xef,0x0c,0x04]

v_xor3_b32 v5, v1, m0, v3
// GFX10: encoding: [0x05,0x00,0x78,0xd5,0x01,0xf9,0x0c,0x04]

v_xor3_b32 v5, v1, exec_lo, v3
// GFX10: encoding: [0x05,0x00,0x78,0xd5,0x01,0xfd,0x0c,0x04]

v_xor3_b32 v5, v1, exec_hi, v3
// GFX10: encoding: [0x05,0x00,0x78,0xd5,0x01,0xff,0x0c,0x04]

v_xor3_b32 v5, v1, 0, v3
// GFX10: encoding: [0x05,0x00,0x78,0xd5,0x01,0x01,0x0d,0x04]

v_xor3_b32 v5, v1, -1, v3
// GFX10: encoding: [0x05,0x00,0x78,0xd5,0x01,0x83,0x0d,0x04]

v_xor3_b32 v5, v1, 0.5, v3
// GFX10: encoding: [0x05,0x00,0x78,0xd5,0x01,0xe1,0x0d,0x04]

v_xor3_b32 v5, v1, -4.0, v3
// GFX10: encoding: [0x05,0x00,0x78,0xd5,0x01,0xef,0x0d,0x04]

v_xor3_b32 v5, v1, v2, v255
// GFX10: encoding: [0x05,0x00,0x78,0xd5,0x01,0x05,0xfe,0x07]

v_xor3_b32 v5, v1, v2, s3
// GFX10: encoding: [0x05,0x00,0x78,0xd5,0x01,0x05,0x0e,0x00]

v_xor3_b32 v5, v1, v2, s103
// GFX10: encoding: [0x05,0x00,0x78,0xd5,0x01,0x05,0x9e,0x01]

v_xor3_b32 v5, v1, v2, vcc_lo
// GFX10: encoding: [0x05,0x00,0x78,0xd5,0x01,0x05,0xaa,0x01]

v_xor3_b32 v5, v1, v2, vcc_hi
// GFX10: encoding: [0x05,0x00,0x78,0xd5,0x01,0x05,0xae,0x01]

v_xor3_b32 v5, v1, v2, ttmp11
// GFX10: encoding: [0x05,0x00,0x78,0xd5,0x01,0x05,0xde,0x01]

v_xor3_b32 v5, v1, v2, m0
// GFX10: encoding: [0x05,0x00,0x78,0xd5,0x01,0x05,0xf2,0x01]

v_xor3_b32 v5, v1, v2, exec_lo
// GFX10: encoding: [0x05,0x00,0x78,0xd5,0x01,0x05,0xfa,0x01]

v_xor3_b32 v5, v1, v2, exec_hi
// GFX10: encoding: [0x05,0x00,0x78,0xd5,0x01,0x05,0xfe,0x01]

v_xor3_b32 v5, v1, v2, 0
// GFX10: encoding: [0x05,0x00,0x78,0xd5,0x01,0x05,0x02,0x02]

v_xor3_b32 v5, v1, v2, -1
// GFX10: encoding: [0x05,0x00,0x78,0xd5,0x01,0x05,0x06,0x03]

v_xor3_b32 v5, v1, v2, 0.5
// GFX10: encoding: [0x05,0x00,0x78,0xd5,0x01,0x05,0xc2,0x03]

v_xor3_b32 v5, v1, v2, -4.0
// GFX10: encoding: [0x05,0x00,0x78,0xd5,0x01,0x05,0xde,0x03]

v_lshlrev_b64 v[5:6], v1, v[2:3]
// GFX10: encoding: [0x05,0x00,0xff,0xd6,0x01,0x05,0x02,0x00]

v_lshlrev_b64 v[254:255], v1, v[2:3]
// GFX10: encoding: [0xfe,0x00,0xff,0xd6,0x01,0x05,0x02,0x00]

v_lshlrev_b64 v[5:6], v255, v[2:3]
// GFX10: encoding: [0x05,0x00,0xff,0xd6,0xff,0x05,0x02,0x00]

v_lshlrev_b64 v[5:6], s1, v[2:3]
// GFX10: encoding: [0x05,0x00,0xff,0xd6,0x01,0x04,0x02,0x00]

v_lshlrev_b64 v[5:6], s101, v[2:3]
// GFX10: encoding: [0x05,0x00,0xff,0xd6,0x65,0x04,0x02,0x00]

v_lshlrev_b64 v[5:6], vcc_lo, v[2:3]
// GFX10: encoding: [0x05,0x00,0xff,0xd6,0x6a,0x04,0x02,0x00]

v_lshlrev_b64 v[5:6], vcc_hi, v[2:3]
// GFX10: encoding: [0x05,0x00,0xff,0xd6,0x6b,0x04,0x02,0x00]

v_lshlrev_b64 v[5:6], m0, v[2:3]
// GFX10: encoding: [0x05,0x00,0xff,0xd6,0x7c,0x04,0x02,0x00]

v_lshlrev_b64 v[5:6], exec_lo, v[2:3]
// GFX10: encoding: [0x05,0x00,0xff,0xd6,0x7e,0x04,0x02,0x00]

v_lshlrev_b64 v[5:6], exec_hi, v[2:3]
// GFX10: encoding: [0x05,0x00,0xff,0xd6,0x7f,0x04,0x02,0x00]

v_lshlrev_b64 v[5:6], 0, v[2:3]
// GFX10: encoding: [0x05,0x00,0xff,0xd6,0x80,0x04,0x02,0x00]

v_lshlrev_b64 v[5:6], -1, v[2:3]
// GFX10: encoding: [0x05,0x00,0xff,0xd6,0xc1,0x04,0x02,0x00]

v_lshlrev_b64 v[5:6], 0.5, v[2:3]
// GFX10: encoding: [0x05,0x00,0xff,0xd6,0xf0,0x04,0x02,0x00]

v_lshlrev_b64 v[5:6], -4.0, v[2:3]
// GFX10: encoding: [0x05,0x00,0xff,0xd6,0xf7,0x04,0x02,0x00]

v_lshlrev_b64 v[5:6], v1, v[254:255]
// GFX10: encoding: [0x05,0x00,0xff,0xd6,0x01,0xfd,0x03,0x00]

v_lshlrev_b64 v[5:6], v1, s[4:5]
// GFX10: encoding: [0x05,0x00,0xff,0xd6,0x01,0x09,0x00,0x00]

v_lshlrev_b64 v[5:6], v1, s[6:7]
// GFX10: encoding: [0x05,0x00,0xff,0xd6,0x01,0x0d,0x00,0x00]

v_lshlrev_b64 v[5:6], v1, s[100:101]
// GFX10: encoding: [0x05,0x00,0xff,0xd6,0x01,0xc9,0x00,0x00]

v_lshlrev_b64 v[5:6], v1, vcc
// GFX10: encoding: [0x05,0x00,0xff,0xd6,0x01,0xd5,0x00,0x00]

v_lshlrev_b64 v[5:6], v1, exec
// GFX10: encoding: [0x05,0x00,0xff,0xd6,0x01,0xfd,0x00,0x00]

v_lshlrev_b64 v[5:6], v1, 0
// GFX10: encoding: [0x05,0x00,0xff,0xd6,0x01,0x01,0x01,0x00]

v_lshlrev_b64 v[5:6], v1, -1
// GFX10: encoding: [0x05,0x00,0xff,0xd6,0x01,0x83,0x01,0x00]

v_lshlrev_b64 v[5:6], v1, 0.5
// GFX10: encoding: [0x05,0x00,0xff,0xd6,0x01,0xe1,0x01,0x00]

v_lshlrev_b64 v[5:6], v1, -4.0
// GFX10: encoding: [0x05,0x00,0xff,0xd6,0x01,0xef,0x01,0x00]

v_lshrrev_b64 v[5:6], v1, v[2:3]
// GFX10: encoding: [0x05,0x00,0x00,0xd7,0x01,0x05,0x02,0x00]

v_lshrrev_b64 v[254:255], v1, v[2:3]
// GFX10: encoding: [0xfe,0x00,0x00,0xd7,0x01,0x05,0x02,0x00]

v_lshrrev_b64 v[5:6], v255, v[2:3]
// GFX10: encoding: [0x05,0x00,0x00,0xd7,0xff,0x05,0x02,0x00]

v_lshrrev_b64 v[5:6], s1, v[2:3]
// GFX10: encoding: [0x05,0x00,0x00,0xd7,0x01,0x04,0x02,0x00]

v_lshrrev_b64 v[5:6], s101, v[2:3]
// GFX10: encoding: [0x05,0x00,0x00,0xd7,0x65,0x04,0x02,0x00]

v_lshrrev_b64 v[5:6], vcc_lo, v[2:3]
// GFX10: encoding: [0x05,0x00,0x00,0xd7,0x6a,0x04,0x02,0x00]

v_lshrrev_b64 v[5:6], vcc_hi, v[2:3]
// GFX10: encoding: [0x05,0x00,0x00,0xd7,0x6b,0x04,0x02,0x00]

v_lshrrev_b64 v[5:6], m0, v[2:3]
// GFX10: encoding: [0x05,0x00,0x00,0xd7,0x7c,0x04,0x02,0x00]

v_lshrrev_b64 v[5:6], exec_lo, v[2:3]
// GFX10: encoding: [0x05,0x00,0x00,0xd7,0x7e,0x04,0x02,0x00]

v_lshrrev_b64 v[5:6], exec_hi, v[2:3]
// GFX10: encoding: [0x05,0x00,0x00,0xd7,0x7f,0x04,0x02,0x00]

v_lshrrev_b64 v[5:6], 0, v[2:3]
// GFX10: encoding: [0x05,0x00,0x00,0xd7,0x80,0x04,0x02,0x00]

v_lshrrev_b64 v[5:6], -1, v[2:3]
// GFX10: encoding: [0x05,0x00,0x00,0xd7,0xc1,0x04,0x02,0x00]

v_lshrrev_b64 v[5:6], 0.5, v[2:3]
// GFX10: encoding: [0x05,0x00,0x00,0xd7,0xf0,0x04,0x02,0x00]

v_lshrrev_b64 v[5:6], -4.0, v[2:3]
// GFX10: encoding: [0x05,0x00,0x00,0xd7,0xf7,0x04,0x02,0x00]

v_lshrrev_b64 v[5:6], v1, v[254:255]
// GFX10: encoding: [0x05,0x00,0x00,0xd7,0x01,0xfd,0x03,0x00]

v_lshrrev_b64 v[5:6], v1, s[4:5]
// GFX10: encoding: [0x05,0x00,0x00,0xd7,0x01,0x09,0x00,0x00]

v_lshrrev_b64 v[5:6], v1, s[6:7]
// GFX10: encoding: [0x05,0x00,0x00,0xd7,0x01,0x0d,0x00,0x00]

v_lshrrev_b64 v[5:6], v1, s[100:101]
// GFX10: encoding: [0x05,0x00,0x00,0xd7,0x01,0xc9,0x00,0x00]

v_lshrrev_b64 v[5:6], v1, vcc
// GFX10: encoding: [0x05,0x00,0x00,0xd7,0x01,0xd5,0x00,0x00]

v_lshrrev_b64 v[5:6], v1, exec
// GFX10: encoding: [0x05,0x00,0x00,0xd7,0x01,0xfd,0x00,0x00]

v_lshrrev_b64 v[5:6], v1, 0
// GFX10: encoding: [0x05,0x00,0x00,0xd7,0x01,0x01,0x01,0x00]

v_lshrrev_b64 v[5:6], v1, -1
// GFX10: encoding: [0x05,0x00,0x00,0xd7,0x01,0x83,0x01,0x00]

v_lshrrev_b64 v[5:6], v1, 0.5
// GFX10: encoding: [0x05,0x00,0x00,0xd7,0x01,0xe1,0x01,0x00]

v_lshrrev_b64 v[5:6], v1, -4.0
// GFX10: encoding: [0x05,0x00,0x00,0xd7,0x01,0xef,0x01,0x00]

v_ashrrev_i64 v[5:6], v1, v[2:3]
// GFX10: encoding: [0x05,0x00,0x01,0xd7,0x01,0x05,0x02,0x00]

v_ashrrev_i64 v[254:255], v1, v[2:3]
// GFX10: encoding: [0xfe,0x00,0x01,0xd7,0x01,0x05,0x02,0x00]

v_ashrrev_i64 v[5:6], v255, v[2:3]
// GFX10: encoding: [0x05,0x00,0x01,0xd7,0xff,0x05,0x02,0x00]

v_ashrrev_i64 v[5:6], s1, v[2:3]
// GFX10: encoding: [0x05,0x00,0x01,0xd7,0x01,0x04,0x02,0x00]

v_ashrrev_i64 v[5:6], s101, v[2:3]
// GFX10: encoding: [0x05,0x00,0x01,0xd7,0x65,0x04,0x02,0x00]

v_ashrrev_i64 v[5:6], vcc_lo, v[2:3]
// GFX10: encoding: [0x05,0x00,0x01,0xd7,0x6a,0x04,0x02,0x00]

v_ashrrev_i64 v[5:6], vcc_hi, v[2:3]
// GFX10: encoding: [0x05,0x00,0x01,0xd7,0x6b,0x04,0x02,0x00]

v_ashrrev_i64 v[5:6], m0, v[2:3]
// GFX10: encoding: [0x05,0x00,0x01,0xd7,0x7c,0x04,0x02,0x00]

v_ashrrev_i64 v[5:6], exec_lo, v[2:3]
// GFX10: encoding: [0x05,0x00,0x01,0xd7,0x7e,0x04,0x02,0x00]

v_ashrrev_i64 v[5:6], exec_hi, v[2:3]
// GFX10: encoding: [0x05,0x00,0x01,0xd7,0x7f,0x04,0x02,0x00]

v_ashrrev_i64 v[5:6], 0, v[2:3]
// GFX10: encoding: [0x05,0x00,0x01,0xd7,0x80,0x04,0x02,0x00]

v_ashrrev_i64 v[5:6], -1, v[2:3]
// GFX10: encoding: [0x05,0x00,0x01,0xd7,0xc1,0x04,0x02,0x00]

v_ashrrev_i64 v[5:6], 0.5, v[2:3]
// GFX10: encoding: [0x05,0x00,0x01,0xd7,0xf0,0x04,0x02,0x00]

v_ashrrev_i64 v[5:6], -4.0, v[2:3]
// GFX10: encoding: [0x05,0x00,0x01,0xd7,0xf7,0x04,0x02,0x00]

v_ashrrev_i64 v[5:6], v1, v[254:255]
// GFX10: encoding: [0x05,0x00,0x01,0xd7,0x01,0xfd,0x03,0x00]

v_ashrrev_i64 v[5:6], v1, s[4:5]
// GFX10: encoding: [0x05,0x00,0x01,0xd7,0x01,0x09,0x00,0x00]

v_ashrrev_i64 v[5:6], v1, s[6:7]
// GFX10: encoding: [0x05,0x00,0x01,0xd7,0x01,0x0d,0x00,0x00]

v_ashrrev_i64 v[5:6], v1, s[100:101]
// GFX10: encoding: [0x05,0x00,0x01,0xd7,0x01,0xc9,0x00,0x00]

v_ashrrev_i64 v[5:6], v1, vcc
// GFX10: encoding: [0x05,0x00,0x01,0xd7,0x01,0xd5,0x00,0x00]

v_ashrrev_i64 v[5:6], v1, exec
// GFX10: encoding: [0x05,0x00,0x01,0xd7,0x01,0xfd,0x00,0x00]

v_ashrrev_i64 v[5:6], v1, 0
// GFX10: encoding: [0x05,0x00,0x01,0xd7,0x01,0x01,0x01,0x00]

v_ashrrev_i64 v[5:6], v1, -1
// GFX10: encoding: [0x05,0x00,0x01,0xd7,0x01,0x83,0x01,0x00]

v_ashrrev_i64 v[5:6], v1, 0.5
// GFX10: encoding: [0x05,0x00,0x01,0xd7,0x01,0xe1,0x01,0x00]

v_ashrrev_i64 v[5:6], v1, -4.0
// GFX10: encoding: [0x05,0x00,0x01,0xd7,0x01,0xef,0x01,0x00]

v_add_nc_u16 v5, v1, v2
// GFX10: encoding: [0x05,0x00,0x03,0xd7,0x01,0x05,0x02,0x00]

v_add_nc_u16 v255, v1, v2
// GFX10: encoding: [0xff,0x00,0x03,0xd7,0x01,0x05,0x02,0x00]

v_add_nc_u16 v5, v255, v2
// GFX10: encoding: [0x05,0x00,0x03,0xd7,0xff,0x05,0x02,0x00]

v_add_nc_u16 v5, s1, v2
// GFX10: encoding: [0x05,0x00,0x03,0xd7,0x01,0x04,0x02,0x00]

v_add_nc_u16 v5, s101, v2
// GFX10: encoding: [0x05,0x00,0x03,0xd7,0x65,0x04,0x02,0x00]

v_add_nc_u16 v5, vcc_lo, v2
// GFX10: encoding: [0x05,0x00,0x03,0xd7,0x6a,0x04,0x02,0x00]

v_add_nc_u16 v5, vcc_hi, v2
// GFX10: encoding: [0x05,0x00,0x03,0xd7,0x6b,0x04,0x02,0x00]

v_add_nc_u16 v5, m0, v2
// GFX10: encoding: [0x05,0x00,0x03,0xd7,0x7c,0x04,0x02,0x00]

v_add_nc_u16 v5, exec_lo, v2
// GFX10: encoding: [0x05,0x00,0x03,0xd7,0x7e,0x04,0x02,0x00]

v_add_nc_u16 v5, exec_hi, v2
// GFX10: encoding: [0x05,0x00,0x03,0xd7,0x7f,0x04,0x02,0x00]

v_add_nc_u16 v5, 0, v2
// GFX10: encoding: [0x05,0x00,0x03,0xd7,0x80,0x04,0x02,0x00]

v_add_nc_u16 v5, -1, v2
// GFX10: encoding: [0x05,0x00,0x03,0xd7,0xc1,0x04,0x02,0x00]

v_add_nc_u16 v5, 0.5, v2
// GFX10: encoding: [0x05,0x00,0x03,0xd7,0xff,0x04,0x02,0x00,0x00,0x38,0x00,0x00]

v_add_nc_u16 v5, -4.0, v2
// GFX10: encoding: [0x05,0x00,0x03,0xd7,0xff,0x04,0x02,0x00,0x00,0xc4,0x00,0x00]

v_add_nc_u16 v5, v1, v255
// GFX10: encoding: [0x05,0x00,0x03,0xd7,0x01,0xff,0x03,0x00]

v_add_nc_u16 v5, v1, s2
// GFX10: encoding: [0x05,0x00,0x03,0xd7,0x01,0x05,0x00,0x00]

v_add_nc_u16 v5, v1, s101
// GFX10: encoding: [0x05,0x00,0x03,0xd7,0x01,0xcb,0x00,0x00]

v_add_nc_u16 v5, v1, vcc_lo
// GFX10: encoding: [0x05,0x00,0x03,0xd7,0x01,0xd5,0x00,0x00]

v_add_nc_u16 v5, v1, vcc_hi
// GFX10: encoding: [0x05,0x00,0x03,0xd7,0x01,0xd7,0x00,0x00]

v_add_nc_u16 v5, v1, m0
// GFX10: encoding: [0x05,0x00,0x03,0xd7,0x01,0xf9,0x00,0x00]

v_add_nc_u16 v5, v1, exec_lo
// GFX10: encoding: [0x05,0x00,0x03,0xd7,0x01,0xfd,0x00,0x00]

v_add_nc_u16 v5, v1, exec_hi
// GFX10: encoding: [0x05,0x00,0x03,0xd7,0x01,0xff,0x00,0x00]

v_add_nc_u16 v5, v1, 0
// GFX10: encoding: [0x05,0x00,0x03,0xd7,0x01,0x01,0x01,0x00]

v_add_nc_u16 v5, v1, -1
// GFX10: encoding: [0x05,0x00,0x03,0xd7,0x01,0x83,0x01,0x00]

v_add_nc_u16 v5, v1, 0.5
// GFX10: encoding: [0x05,0x00,0x03,0xd7,0x01,0xff,0x01,0x00,0x00,0x38,0x00,0x00]

v_add_nc_u16 v5, v1, -4.0
// GFX10: encoding: [0x05,0x00,0x03,0xd7,0x01,0xff,0x01,0x00,0x00,0xc4,0x00,0x00]

v_add_nc_u16 v5, v1, -4.0 clamp
// GFX10: encoding: [0x05,0x80,0x03,0xd7,0x01,0xff,0x01,0x00,0x00,0xc4,0x00,0x00]

v_sub_nc_u16 v5, v1, v2
// GFX10: encoding: [0x05,0x00,0x04,0xd7,0x01,0x05,0x02,0x00]

v_sub_nc_u16 v255, v1, v2
// GFX10: encoding: [0xff,0x00,0x04,0xd7,0x01,0x05,0x02,0x00]

v_sub_nc_u16 v5, v255, v2
// GFX10: encoding: [0x05,0x00,0x04,0xd7,0xff,0x05,0x02,0x00]

v_sub_nc_u16 v5, s1, v2
// GFX10: encoding: [0x05,0x00,0x04,0xd7,0x01,0x04,0x02,0x00]

v_sub_nc_u16 v5, s101, v2
// GFX10: encoding: [0x05,0x00,0x04,0xd7,0x65,0x04,0x02,0x00]

v_sub_nc_u16 v5, vcc_lo, v2
// GFX10: encoding: [0x05,0x00,0x04,0xd7,0x6a,0x04,0x02,0x00]

v_sub_nc_u16 v5, vcc_hi, v2
// GFX10: encoding: [0x05,0x00,0x04,0xd7,0x6b,0x04,0x02,0x00]

v_sub_nc_u16 v5, m0, v2
// GFX10: encoding: [0x05,0x00,0x04,0xd7,0x7c,0x04,0x02,0x00]

v_sub_nc_u16 v5, exec_lo, v2
// GFX10: encoding: [0x05,0x00,0x04,0xd7,0x7e,0x04,0x02,0x00]

v_sub_nc_u16 v5, exec_hi, v2
// GFX10: encoding: [0x05,0x00,0x04,0xd7,0x7f,0x04,0x02,0x00]

v_sub_nc_u16 v5, 0, v2
// GFX10: encoding: [0x05,0x00,0x04,0xd7,0x80,0x04,0x02,0x00]

v_sub_nc_u16 v5, -1, v2
// GFX10: encoding: [0x05,0x00,0x04,0xd7,0xc1,0x04,0x02,0x00]

v_sub_nc_u16 v5, 0.5, v2
// GFX10: encoding: [0x05,0x00,0x04,0xd7,0xff,0x04,0x02,0x00,0x00,0x38,0x00,0x00]

v_sub_nc_u16 v5, -4.0, v2
// GFX10: encoding: [0x05,0x00,0x04,0xd7,0xff,0x04,0x02,0x00,0x00,0xc4,0x00,0x00]

v_sub_nc_u16 v5, v1, v255
// GFX10: encoding: [0x05,0x00,0x04,0xd7,0x01,0xff,0x03,0x00]

v_sub_nc_u16 v5, v1, s2
// GFX10: encoding: [0x05,0x00,0x04,0xd7,0x01,0x05,0x00,0x00]

v_sub_nc_u16 v5, v1, s101
// GFX10: encoding: [0x05,0x00,0x04,0xd7,0x01,0xcb,0x00,0x00]

v_sub_nc_u16 v5, v1, vcc_lo
// GFX10: encoding: [0x05,0x00,0x04,0xd7,0x01,0xd5,0x00,0x00]

v_sub_nc_u16 v5, v1, vcc_hi
// GFX10: encoding: [0x05,0x00,0x04,0xd7,0x01,0xd7,0x00,0x00]

v_sub_nc_u16 v5, v1, m0
// GFX10: encoding: [0x05,0x00,0x04,0xd7,0x01,0xf9,0x00,0x00]

v_sub_nc_u16 v5, v1, exec_lo
// GFX10: encoding: [0x05,0x00,0x04,0xd7,0x01,0xfd,0x00,0x00]

v_sub_nc_u16 v5, v1, exec_hi
// GFX10: encoding: [0x05,0x00,0x04,0xd7,0x01,0xff,0x00,0x00]

v_sub_nc_u16 v5, v1, 0
// GFX10: encoding: [0x05,0x00,0x04,0xd7,0x01,0x01,0x01,0x00]

v_sub_nc_u16 v5, v1, -1
// GFX10: encoding: [0x05,0x00,0x04,0xd7,0x01,0x83,0x01,0x00]

v_sub_nc_u16 v5, v1, 0.5
// GFX10: encoding: [0x05,0x00,0x04,0xd7,0x01,0xff,0x01,0x00,0x00,0x38,0x00,0x00]

v_sub_nc_u16 v5, v1, -4.0
// GFX10: encoding: [0x05,0x00,0x04,0xd7,0x01,0xff,0x01,0x00,0x00,0xc4,0x00,0x00]

v_sub_nc_u16 v5, v1, -4.0 clamp
// GFX10: encoding: [0x05,0x80,0x04,0xd7,0x01,0xff,0x01,0x00,0x00,0xc4,0x00,0x00]

v_mul_lo_u16 v5, v1, v2
// GFX10: encoding: [0x05,0x00,0x05,0xd7,0x01,0x05,0x02,0x00]

v_mul_lo_u16 v255, v1, v2
// GFX10: encoding: [0xff,0x00,0x05,0xd7,0x01,0x05,0x02,0x00]

v_mul_lo_u16 v5, v255, v2
// GFX10: encoding: [0x05,0x00,0x05,0xd7,0xff,0x05,0x02,0x00]

v_mul_lo_u16 v5, s1, v2
// GFX10: encoding: [0x05,0x00,0x05,0xd7,0x01,0x04,0x02,0x00]

v_mul_lo_u16 v5, s101, v2
// GFX10: encoding: [0x05,0x00,0x05,0xd7,0x65,0x04,0x02,0x00]

v_mul_lo_u16 v5, vcc_lo, v2
// GFX10: encoding: [0x05,0x00,0x05,0xd7,0x6a,0x04,0x02,0x00]

v_mul_lo_u16 v5, vcc_hi, v2
// GFX10: encoding: [0x05,0x00,0x05,0xd7,0x6b,0x04,0x02,0x00]

v_mul_lo_u16 v5, m0, v2
// GFX10: encoding: [0x05,0x00,0x05,0xd7,0x7c,0x04,0x02,0x00]

v_mul_lo_u16 v5, exec_lo, v2
// GFX10: encoding: [0x05,0x00,0x05,0xd7,0x7e,0x04,0x02,0x00]

v_mul_lo_u16 v5, exec_hi, v2
// GFX10: encoding: [0x05,0x00,0x05,0xd7,0x7f,0x04,0x02,0x00]

v_mul_lo_u16 v5, 0, v2
// GFX10: encoding: [0x05,0x00,0x05,0xd7,0x80,0x04,0x02,0x00]

v_mul_lo_u16 v5, -1, v2
// GFX10: encoding: [0x05,0x00,0x05,0xd7,0xc1,0x04,0x02,0x00]

v_mul_lo_u16 v5, 0.5, v2
// GFX10: encoding: [0x05,0x00,0x05,0xd7,0xff,0x04,0x02,0x00,0x00,0x38,0x00,0x00]

v_mul_lo_u16 v5, -4.0, v2
// GFX10: encoding: [0x05,0x00,0x05,0xd7,0xff,0x04,0x02,0x00,0x00,0xc4,0x00,0x00]

v_mul_lo_u16 v5, v1, v255
// GFX10: encoding: [0x05,0x00,0x05,0xd7,0x01,0xff,0x03,0x00]

v_mul_lo_u16 v5, v1, s2
// GFX10: encoding: [0x05,0x00,0x05,0xd7,0x01,0x05,0x00,0x00]

v_mul_lo_u16 v5, v1, s101
// GFX10: encoding: [0x05,0x00,0x05,0xd7,0x01,0xcb,0x00,0x00]

v_mul_lo_u16 v5, v1, vcc_lo
// GFX10: encoding: [0x05,0x00,0x05,0xd7,0x01,0xd5,0x00,0x00]

v_mul_lo_u16 v5, v1, vcc_hi
// GFX10: encoding: [0x05,0x00,0x05,0xd7,0x01,0xd7,0x00,0x00]

v_mul_lo_u16 v5, v1, m0
// GFX10: encoding: [0x05,0x00,0x05,0xd7,0x01,0xf9,0x00,0x00]

v_mul_lo_u16 v5, v1, exec_lo
// GFX10: encoding: [0x05,0x00,0x05,0xd7,0x01,0xfd,0x00,0x00]

v_mul_lo_u16 v5, v1, exec_hi
// GFX10: encoding: [0x05,0x00,0x05,0xd7,0x01,0xff,0x00,0x00]

v_mul_lo_u16 v5, v1, 0
// GFX10: encoding: [0x05,0x00,0x05,0xd7,0x01,0x01,0x01,0x00]

v_mul_lo_u16 v5, v1, -1
// GFX10: encoding: [0x05,0x00,0x05,0xd7,0x01,0x83,0x01,0x00]

v_mul_lo_u16 v5, v1, 0.5
// GFX10: encoding: [0x05,0x00,0x05,0xd7,0x01,0xff,0x01,0x00,0x00,0x38,0x00,0x00]

v_mul_lo_u16 v5, v1, -4.0
// GFX10: encoding: [0x05,0x00,0x05,0xd7,0x01,0xff,0x01,0x00,0x00,0xc4,0x00,0x00]

v_lshrrev_b16 v5, v1, v2
// GFX10: encoding: [0x05,0x00,0x07,0xd7,0x01,0x05,0x02,0x00]

v_lshrrev_b16 v255, v1, v2
// GFX10: encoding: [0xff,0x00,0x07,0xd7,0x01,0x05,0x02,0x00]

v_lshrrev_b16 v5, v255, v2
// GFX10: encoding: [0x05,0x00,0x07,0xd7,0xff,0x05,0x02,0x00]

v_lshrrev_b16 v5, s1, v2
// GFX10: encoding: [0x05,0x00,0x07,0xd7,0x01,0x04,0x02,0x00]

v_lshrrev_b16 v5, s101, v2
// GFX10: encoding: [0x05,0x00,0x07,0xd7,0x65,0x04,0x02,0x00]

v_lshrrev_b16 v5, vcc_lo, v2
// GFX10: encoding: [0x05,0x00,0x07,0xd7,0x6a,0x04,0x02,0x00]

v_lshrrev_b16 v5, vcc_hi, v2
// GFX10: encoding: [0x05,0x00,0x07,0xd7,0x6b,0x04,0x02,0x00]

v_lshrrev_b16 v5, m0, v2
// GFX10: encoding: [0x05,0x00,0x07,0xd7,0x7c,0x04,0x02,0x00]

v_lshrrev_b16 v5, exec_lo, v2
// GFX10: encoding: [0x05,0x00,0x07,0xd7,0x7e,0x04,0x02,0x00]

v_lshrrev_b16 v5, exec_hi, v2
// GFX10: encoding: [0x05,0x00,0x07,0xd7,0x7f,0x04,0x02,0x00]

v_lshrrev_b16 v5, 0, v2
// GFX10: encoding: [0x05,0x00,0x07,0xd7,0x80,0x04,0x02,0x00]

v_lshrrev_b16 v5, -1, v2
// GFX10: encoding: [0x05,0x00,0x07,0xd7,0xc1,0x04,0x02,0x00]

v_lshrrev_b16 v5, 0.5, v2
// GFX10: encoding: [0x05,0x00,0x07,0xd7,0xff,0x04,0x02,0x00,0x00,0x38,0x00,0x00]

v_lshrrev_b16 v5, -4.0, v2
// GFX10: encoding: [0x05,0x00,0x07,0xd7,0xff,0x04,0x02,0x00,0x00,0xc4,0x00,0x00]

v_lshrrev_b16 v5, v1, v255
// GFX10: encoding: [0x05,0x00,0x07,0xd7,0x01,0xff,0x03,0x00]

v_lshrrev_b16 v5, v1, s2
// GFX10: encoding: [0x05,0x00,0x07,0xd7,0x01,0x05,0x00,0x00]

v_lshrrev_b16 v5, v1, s101
// GFX10: encoding: [0x05,0x00,0x07,0xd7,0x01,0xcb,0x00,0x00]

v_lshrrev_b16 v5, v1, vcc_lo
// GFX10: encoding: [0x05,0x00,0x07,0xd7,0x01,0xd5,0x00,0x00]

v_lshrrev_b16 v5, v1, vcc_hi
// GFX10: encoding: [0x05,0x00,0x07,0xd7,0x01,0xd7,0x00,0x00]

v_lshrrev_b16 v5, v1, m0
// GFX10: encoding: [0x05,0x00,0x07,0xd7,0x01,0xf9,0x00,0x00]

v_lshrrev_b16 v5, v1, exec_lo
// GFX10: encoding: [0x05,0x00,0x07,0xd7,0x01,0xfd,0x00,0x00]

v_lshrrev_b16 v5, v1, exec_hi
// GFX10: encoding: [0x05,0x00,0x07,0xd7,0x01,0xff,0x00,0x00]

v_lshrrev_b16 v5, v1, 0
// GFX10: encoding: [0x05,0x00,0x07,0xd7,0x01,0x01,0x01,0x00]

v_lshrrev_b16 v5, v1, -1
// GFX10: encoding: [0x05,0x00,0x07,0xd7,0x01,0x83,0x01,0x00]

v_lshrrev_b16 v5, v1, 0.5
// GFX10: encoding: [0x05,0x00,0x07,0xd7,0x01,0xff,0x01,0x00,0x00,0x38,0x00,0x00]

v_lshrrev_b16 v5, v1, -4.0
// GFX10: encoding: [0x05,0x00,0x07,0xd7,0x01,0xff,0x01,0x00,0x00,0xc4,0x00,0x00]

v_ashrrev_i16 v5, v1, v2
// GFX10: encoding: [0x05,0x00,0x08,0xd7,0x01,0x05,0x02,0x00]

v_ashrrev_i16 v255, v1, v2
// GFX10: encoding: [0xff,0x00,0x08,0xd7,0x01,0x05,0x02,0x00]

v_ashrrev_i16 v5, v255, v2
// GFX10: encoding: [0x05,0x00,0x08,0xd7,0xff,0x05,0x02,0x00]

v_ashrrev_i16 v5, s1, v2
// GFX10: encoding: [0x05,0x00,0x08,0xd7,0x01,0x04,0x02,0x00]

v_ashrrev_i16 v5, s101, v2
// GFX10: encoding: [0x05,0x00,0x08,0xd7,0x65,0x04,0x02,0x00]

v_ashrrev_i16 v5, vcc_lo, v2
// GFX10: encoding: [0x05,0x00,0x08,0xd7,0x6a,0x04,0x02,0x00]

v_ashrrev_i16 v5, vcc_hi, v2
// GFX10: encoding: [0x05,0x00,0x08,0xd7,0x6b,0x04,0x02,0x00]

v_ashrrev_i16 v5, m0, v2
// GFX10: encoding: [0x05,0x00,0x08,0xd7,0x7c,0x04,0x02,0x00]

v_ashrrev_i16 v5, exec_lo, v2
// GFX10: encoding: [0x05,0x00,0x08,0xd7,0x7e,0x04,0x02,0x00]

v_ashrrev_i16 v5, exec_hi, v2
// GFX10: encoding: [0x05,0x00,0x08,0xd7,0x7f,0x04,0x02,0x00]

v_ashrrev_i16 v5, 0, v2
// GFX10: encoding: [0x05,0x00,0x08,0xd7,0x80,0x04,0x02,0x00]

v_ashrrev_i16 v5, -1, v2
// GFX10: encoding: [0x05,0x00,0x08,0xd7,0xc1,0x04,0x02,0x00]

v_ashrrev_i16 v5, 0.5, v2
// GFX10: encoding: [0x05,0x00,0x08,0xd7,0xff,0x04,0x02,0x00,0x00,0x38,0x00,0x00]

v_ashrrev_i16 v5, -4.0, v2
// GFX10: encoding: [0x05,0x00,0x08,0xd7,0xff,0x04,0x02,0x00,0x00,0xc4,0x00,0x00]

v_ashrrev_i16 v5, v1, v255
// GFX10: encoding: [0x05,0x00,0x08,0xd7,0x01,0xff,0x03,0x00]

v_ashrrev_i16 v5, v1, s2
// GFX10: encoding: [0x05,0x00,0x08,0xd7,0x01,0x05,0x00,0x00]

v_ashrrev_i16 v5, v1, s101
// GFX10: encoding: [0x05,0x00,0x08,0xd7,0x01,0xcb,0x00,0x00]

v_ashrrev_i16 v5, v1, vcc_lo
// GFX10: encoding: [0x05,0x00,0x08,0xd7,0x01,0xd5,0x00,0x00]

v_ashrrev_i16 v5, v1, vcc_hi
// GFX10: encoding: [0x05,0x00,0x08,0xd7,0x01,0xd7,0x00,0x00]

v_ashrrev_i16 v5, v1, m0
// GFX10: encoding: [0x05,0x00,0x08,0xd7,0x01,0xf9,0x00,0x00]

v_ashrrev_i16 v5, v1, exec_lo
// GFX10: encoding: [0x05,0x00,0x08,0xd7,0x01,0xfd,0x00,0x00]

v_ashrrev_i16 v5, v1, exec_hi
// GFX10: encoding: [0x05,0x00,0x08,0xd7,0x01,0xff,0x00,0x00]

v_ashrrev_i16 v5, v1, 0
// GFX10: encoding: [0x05,0x00,0x08,0xd7,0x01,0x01,0x01,0x00]

v_ashrrev_i16 v5, v1, -1
// GFX10: encoding: [0x05,0x00,0x08,0xd7,0x01,0x83,0x01,0x00]

v_ashrrev_i16 v5, v1, 0.5
// GFX10: encoding: [0x05,0x00,0x08,0xd7,0x01,0xff,0x01,0x00,0x00,0x38,0x00,0x00]

v_ashrrev_i16 v5, v1, -4.0
// GFX10: encoding: [0x05,0x00,0x08,0xd7,0x01,0xff,0x01,0x00,0x00,0xc4,0x00,0x00]

v_max_u16 v5, v1, v2
// GFX10: encoding: [0x05,0x00,0x09,0xd7,0x01,0x05,0x02,0x00]

v_max_u16 v255, v1, v2
// GFX10: encoding: [0xff,0x00,0x09,0xd7,0x01,0x05,0x02,0x00]

v_max_u16 v5, v255, v2
// GFX10: encoding: [0x05,0x00,0x09,0xd7,0xff,0x05,0x02,0x00]

v_max_u16 v5, s1, v2
// GFX10: encoding: [0x05,0x00,0x09,0xd7,0x01,0x04,0x02,0x00]

v_max_u16 v5, s101, v2
// GFX10: encoding: [0x05,0x00,0x09,0xd7,0x65,0x04,0x02,0x00]

v_max_u16 v5, vcc_lo, v2
// GFX10: encoding: [0x05,0x00,0x09,0xd7,0x6a,0x04,0x02,0x00]

v_max_u16 v5, vcc_hi, v2
// GFX10: encoding: [0x05,0x00,0x09,0xd7,0x6b,0x04,0x02,0x00]

v_max_u16 v5, m0, v2
// GFX10: encoding: [0x05,0x00,0x09,0xd7,0x7c,0x04,0x02,0x00]

v_max_u16 v5, exec_lo, v2
// GFX10: encoding: [0x05,0x00,0x09,0xd7,0x7e,0x04,0x02,0x00]

v_max_u16 v5, exec_hi, v2
// GFX10: encoding: [0x05,0x00,0x09,0xd7,0x7f,0x04,0x02,0x00]

v_max_u16 v5, 0, v2
// GFX10: encoding: [0x05,0x00,0x09,0xd7,0x80,0x04,0x02,0x00]

v_max_u16 v5, -1, v2
// GFX10: encoding: [0x05,0x00,0x09,0xd7,0xc1,0x04,0x02,0x00]

v_max_u16 v5, 0.5, v2
// GFX10: encoding: [0x05,0x00,0x09,0xd7,0xff,0x04,0x02,0x00,0x00,0x38,0x00,0x00]

v_max_u16 v5, -4.0, v2
// GFX10: encoding: [0x05,0x00,0x09,0xd7,0xff,0x04,0x02,0x00,0x00,0xc4,0x00,0x00]

v_max_u16 v5, v1, v255
// GFX10: encoding: [0x05,0x00,0x09,0xd7,0x01,0xff,0x03,0x00]

v_max_u16 v5, v1, s2
// GFX10: encoding: [0x05,0x00,0x09,0xd7,0x01,0x05,0x00,0x00]

v_max_u16 v5, v1, s101
// GFX10: encoding: [0x05,0x00,0x09,0xd7,0x01,0xcb,0x00,0x00]

v_max_u16 v5, v1, vcc_lo
// GFX10: encoding: [0x05,0x00,0x09,0xd7,0x01,0xd5,0x00,0x00]

v_max_u16 v5, v1, vcc_hi
// GFX10: encoding: [0x05,0x00,0x09,0xd7,0x01,0xd7,0x00,0x00]

v_max_u16 v5, v1, m0
// GFX10: encoding: [0x05,0x00,0x09,0xd7,0x01,0xf9,0x00,0x00]

v_max_u16 v5, v1, exec_lo
// GFX10: encoding: [0x05,0x00,0x09,0xd7,0x01,0xfd,0x00,0x00]

v_max_u16 v5, v1, exec_hi
// GFX10: encoding: [0x05,0x00,0x09,0xd7,0x01,0xff,0x00,0x00]

v_max_u16 v5, v1, 0
// GFX10: encoding: [0x05,0x00,0x09,0xd7,0x01,0x01,0x01,0x00]

v_max_u16 v5, v1, -1
// GFX10: encoding: [0x05,0x00,0x09,0xd7,0x01,0x83,0x01,0x00]

v_max_u16 v5, v1, 0.5
// GFX10: encoding: [0x05,0x00,0x09,0xd7,0x01,0xff,0x01,0x00,0x00,0x38,0x00,0x00]

v_max_u16 v5, v1, -4.0
// GFX10: encoding: [0x05,0x00,0x09,0xd7,0x01,0xff,0x01,0x00,0x00,0xc4,0x00,0x00]

v_max_i16 v5, v1, v2
// GFX10: encoding: [0x05,0x00,0x0a,0xd7,0x01,0x05,0x02,0x00]

v_max_i16 v255, v1, v2
// GFX10: encoding: [0xff,0x00,0x0a,0xd7,0x01,0x05,0x02,0x00]

v_max_i16 v5, v255, v2
// GFX10: encoding: [0x05,0x00,0x0a,0xd7,0xff,0x05,0x02,0x00]

v_max_i16 v5, s1, v2
// GFX10: encoding: [0x05,0x00,0x0a,0xd7,0x01,0x04,0x02,0x00]

v_max_i16 v5, s101, v2
// GFX10: encoding: [0x05,0x00,0x0a,0xd7,0x65,0x04,0x02,0x00]

v_max_i16 v5, vcc_lo, v2
// GFX10: encoding: [0x05,0x00,0x0a,0xd7,0x6a,0x04,0x02,0x00]

v_max_i16 v5, vcc_hi, v2
// GFX10: encoding: [0x05,0x00,0x0a,0xd7,0x6b,0x04,0x02,0x00]

v_max_i16 v5, m0, v2
// GFX10: encoding: [0x05,0x00,0x0a,0xd7,0x7c,0x04,0x02,0x00]

v_max_i16 v5, exec_lo, v2
// GFX10: encoding: [0x05,0x00,0x0a,0xd7,0x7e,0x04,0x02,0x00]

v_max_i16 v5, exec_hi, v2
// GFX10: encoding: [0x05,0x00,0x0a,0xd7,0x7f,0x04,0x02,0x00]

v_max_i16 v5, 0, v2
// GFX10: encoding: [0x05,0x00,0x0a,0xd7,0x80,0x04,0x02,0x00]

v_max_i16 v5, -1, v2
// GFX10: encoding: [0x05,0x00,0x0a,0xd7,0xc1,0x04,0x02,0x00]

v_max_i16 v5, 0.5, v2
// GFX10: encoding: [0x05,0x00,0x0a,0xd7,0xff,0x04,0x02,0x00,0x00,0x38,0x00,0x00]

v_max_i16 v5, -4.0, v2
// GFX10: encoding: [0x05,0x00,0x0a,0xd7,0xff,0x04,0x02,0x00,0x00,0xc4,0x00,0x00]

v_max_i16 v5, v1, v255
// GFX10: encoding: [0x05,0x00,0x0a,0xd7,0x01,0xff,0x03,0x00]

v_max_i16 v5, v1, s2
// GFX10: encoding: [0x05,0x00,0x0a,0xd7,0x01,0x05,0x00,0x00]

v_max_i16 v5, v1, s101
// GFX10: encoding: [0x05,0x00,0x0a,0xd7,0x01,0xcb,0x00,0x00]

v_max_i16 v5, v1, vcc_lo
// GFX10: encoding: [0x05,0x00,0x0a,0xd7,0x01,0xd5,0x00,0x00]

v_max_i16 v5, v1, vcc_hi
// GFX10: encoding: [0x05,0x00,0x0a,0xd7,0x01,0xd7,0x00,0x00]

v_max_i16 v5, v1, m0
// GFX10: encoding: [0x05,0x00,0x0a,0xd7,0x01,0xf9,0x00,0x00]

v_max_i16 v5, v1, exec_lo
// GFX10: encoding: [0x05,0x00,0x0a,0xd7,0x01,0xfd,0x00,0x00]

v_max_i16 v5, v1, exec_hi
// GFX10: encoding: [0x05,0x00,0x0a,0xd7,0x01,0xff,0x00,0x00]

v_max_i16 v5, v1, 0
// GFX10: encoding: [0x05,0x00,0x0a,0xd7,0x01,0x01,0x01,0x00]

v_max_i16 v5, v1, -1
// GFX10: encoding: [0x05,0x00,0x0a,0xd7,0x01,0x83,0x01,0x00]

v_max_i16 v5, v1, 0.5
// GFX10: encoding: [0x05,0x00,0x0a,0xd7,0x01,0xff,0x01,0x00,0x00,0x38,0x00,0x00]

v_max_i16 v5, v1, -4.0
// GFX10: encoding: [0x05,0x00,0x0a,0xd7,0x01,0xff,0x01,0x00,0x00,0xc4,0x00,0x00]

v_min_u16 v5, v1, v2
// GFX10: encoding: [0x05,0x00,0x0b,0xd7,0x01,0x05,0x02,0x00]

v_min_u16 v255, v1, v2
// GFX10: encoding: [0xff,0x00,0x0b,0xd7,0x01,0x05,0x02,0x00]

v_min_u16 v5, v255, v2
// GFX10: encoding: [0x05,0x00,0x0b,0xd7,0xff,0x05,0x02,0x00]

v_min_u16 v5, s1, v2
// GFX10: encoding: [0x05,0x00,0x0b,0xd7,0x01,0x04,0x02,0x00]

v_min_u16 v5, s101, v2
// GFX10: encoding: [0x05,0x00,0x0b,0xd7,0x65,0x04,0x02,0x00]

v_min_u16 v5, vcc_lo, v2
// GFX10: encoding: [0x05,0x00,0x0b,0xd7,0x6a,0x04,0x02,0x00]

v_min_u16 v5, vcc_hi, v2
// GFX10: encoding: [0x05,0x00,0x0b,0xd7,0x6b,0x04,0x02,0x00]

v_min_u16 v5, m0, v2
// GFX10: encoding: [0x05,0x00,0x0b,0xd7,0x7c,0x04,0x02,0x00]

v_min_u16 v5, exec_lo, v2
// GFX10: encoding: [0x05,0x00,0x0b,0xd7,0x7e,0x04,0x02,0x00]

v_min_u16 v5, exec_hi, v2
// GFX10: encoding: [0x05,0x00,0x0b,0xd7,0x7f,0x04,0x02,0x00]

v_min_u16 v5, 0, v2
// GFX10: encoding: [0x05,0x00,0x0b,0xd7,0x80,0x04,0x02,0x00]

v_min_u16 v5, -1, v2
// GFX10: encoding: [0x05,0x00,0x0b,0xd7,0xc1,0x04,0x02,0x00]

v_min_u16 v5, 0.5, v2
// GFX10: encoding: [0x05,0x00,0x0b,0xd7,0xff,0x04,0x02,0x00,0x00,0x38,0x00,0x00]

v_min_u16 v5, -4.0, v2
// GFX10: encoding: [0x05,0x00,0x0b,0xd7,0xff,0x04,0x02,0x00,0x00,0xc4,0x00,0x00]

v_min_u16 v5, v1, v255
// GFX10: encoding: [0x05,0x00,0x0b,0xd7,0x01,0xff,0x03,0x00]

v_min_u16 v5, v1, s2
// GFX10: encoding: [0x05,0x00,0x0b,0xd7,0x01,0x05,0x00,0x00]

v_min_u16 v5, v1, s101
// GFX10: encoding: [0x05,0x00,0x0b,0xd7,0x01,0xcb,0x00,0x00]

v_min_u16 v5, v1, vcc_lo
// GFX10: encoding: [0x05,0x00,0x0b,0xd7,0x01,0xd5,0x00,0x00]

v_min_u16 v5, v1, vcc_hi
// GFX10: encoding: [0x05,0x00,0x0b,0xd7,0x01,0xd7,0x00,0x00]

v_min_u16 v5, v1, m0
// GFX10: encoding: [0x05,0x00,0x0b,0xd7,0x01,0xf9,0x00,0x00]

v_min_u16 v5, v1, exec_lo
// GFX10: encoding: [0x05,0x00,0x0b,0xd7,0x01,0xfd,0x00,0x00]

v_min_u16 v5, v1, exec_hi
// GFX10: encoding: [0x05,0x00,0x0b,0xd7,0x01,0xff,0x00,0x00]

v_min_u16 v5, v1, 0
// GFX10: encoding: [0x05,0x00,0x0b,0xd7,0x01,0x01,0x01,0x00]

v_min_u16 v5, v1, -1
// GFX10: encoding: [0x05,0x00,0x0b,0xd7,0x01,0x83,0x01,0x00]

v_min_u16 v5, v1, 0.5
// GFX10: encoding: [0x05,0x00,0x0b,0xd7,0x01,0xff,0x01,0x00,0x00,0x38,0x00,0x00]

v_min_u16 v5, v1, -4.0
// GFX10: encoding: [0x05,0x00,0x0b,0xd7,0x01,0xff,0x01,0x00,0x00,0xc4,0x00,0x00]

v_min_i16 v5, v1, v2
// GFX10: encoding: [0x05,0x00,0x0c,0xd7,0x01,0x05,0x02,0x00]

v_min_i16 v255, v1, v2
// GFX10: encoding: [0xff,0x00,0x0c,0xd7,0x01,0x05,0x02,0x00]

v_min_i16 v5, v255, v2
// GFX10: encoding: [0x05,0x00,0x0c,0xd7,0xff,0x05,0x02,0x00]

v_min_i16 v5, s1, v2
// GFX10: encoding: [0x05,0x00,0x0c,0xd7,0x01,0x04,0x02,0x00]

v_min_i16 v5, s101, v2
// GFX10: encoding: [0x05,0x00,0x0c,0xd7,0x65,0x04,0x02,0x00]

v_min_i16 v5, vcc_lo, v2
// GFX10: encoding: [0x05,0x00,0x0c,0xd7,0x6a,0x04,0x02,0x00]

v_min_i16 v5, vcc_hi, v2
// GFX10: encoding: [0x05,0x00,0x0c,0xd7,0x6b,0x04,0x02,0x00]

v_min_i16 v5, m0, v2
// GFX10: encoding: [0x05,0x00,0x0c,0xd7,0x7c,0x04,0x02,0x00]

v_min_i16 v5, exec_lo, v2
// GFX10: encoding: [0x05,0x00,0x0c,0xd7,0x7e,0x04,0x02,0x00]

v_min_i16 v5, exec_hi, v2
// GFX10: encoding: [0x05,0x00,0x0c,0xd7,0x7f,0x04,0x02,0x00]

v_min_i16 v5, 0, v2
// GFX10: encoding: [0x05,0x00,0x0c,0xd7,0x80,0x04,0x02,0x00]

v_min_i16 v5, -1, v2
// GFX10: encoding: [0x05,0x00,0x0c,0xd7,0xc1,0x04,0x02,0x00]

v_min_i16 v5, 0.5, v2
// GFX10: encoding: [0x05,0x00,0x0c,0xd7,0xff,0x04,0x02,0x00,0x00,0x38,0x00,0x00]

v_min_i16 v5, -4.0, v2
// GFX10: encoding: [0x05,0x00,0x0c,0xd7,0xff,0x04,0x02,0x00,0x00,0xc4,0x00,0x00]

v_min_i16 v5, v1, v255
// GFX10: encoding: [0x05,0x00,0x0c,0xd7,0x01,0xff,0x03,0x00]

v_min_i16 v5, v1, s2
// GFX10: encoding: [0x05,0x00,0x0c,0xd7,0x01,0x05,0x00,0x00]

v_min_i16 v5, v1, s101
// GFX10: encoding: [0x05,0x00,0x0c,0xd7,0x01,0xcb,0x00,0x00]

v_min_i16 v5, v1, vcc_lo
// GFX10: encoding: [0x05,0x00,0x0c,0xd7,0x01,0xd5,0x00,0x00]

v_min_i16 v5, v1, vcc_hi
// GFX10: encoding: [0x05,0x00,0x0c,0xd7,0x01,0xd7,0x00,0x00]

v_min_i16 v5, v1, m0
// GFX10: encoding: [0x05,0x00,0x0c,0xd7,0x01,0xf9,0x00,0x00]

v_min_i16 v5, v1, exec_lo
// GFX10: encoding: [0x05,0x00,0x0c,0xd7,0x01,0xfd,0x00,0x00]

v_min_i16 v5, v1, exec_hi
// GFX10: encoding: [0x05,0x00,0x0c,0xd7,0x01,0xff,0x00,0x00]

v_min_i16 v5, v1, 0
// GFX10: encoding: [0x05,0x00,0x0c,0xd7,0x01,0x01,0x01,0x00]

v_min_i16 v5, v1, -1
// GFX10: encoding: [0x05,0x00,0x0c,0xd7,0x01,0x83,0x01,0x00]

v_min_i16 v5, v1, 0.5
// GFX10: encoding: [0x05,0x00,0x0c,0xd7,0x01,0xff,0x01,0x00,0x00,0x38,0x00,0x00]

v_min_i16 v5, v1, -4.0
// GFX10: encoding: [0x05,0x00,0x0c,0xd7,0x01,0xff,0x01,0x00,0x00,0xc4,0x00,0x00]

v_add_nc_i16 v5, v1, v2
// GFX10: encoding: [0x05,0x00,0x0d,0xd7,0x01,0x05,0x02,0x00]

v_add_nc_i16 v255, v1, v2
// GFX10: encoding: [0xff,0x00,0x0d,0xd7,0x01,0x05,0x02,0x00]

v_add_nc_i16 v5, v255, v2
// GFX10: encoding: [0x05,0x00,0x0d,0xd7,0xff,0x05,0x02,0x00]

v_add_nc_i16 v5, s1, v2
// GFX10: encoding: [0x05,0x00,0x0d,0xd7,0x01,0x04,0x02,0x00]

v_add_nc_i16 v5, s101, v2
// GFX10: encoding: [0x05,0x00,0x0d,0xd7,0x65,0x04,0x02,0x00]

v_add_nc_i16 v5, vcc_lo, v2
// GFX10: encoding: [0x05,0x00,0x0d,0xd7,0x6a,0x04,0x02,0x00]

v_add_nc_i16 v5, vcc_hi, v2
// GFX10: encoding: [0x05,0x00,0x0d,0xd7,0x6b,0x04,0x02,0x00]

v_add_nc_i16 v5, m0, v2
// GFX10: encoding: [0x05,0x00,0x0d,0xd7,0x7c,0x04,0x02,0x00]

v_add_nc_i16 v5, exec_lo, v2
// GFX10: encoding: [0x05,0x00,0x0d,0xd7,0x7e,0x04,0x02,0x00]

v_add_nc_i16 v5, exec_hi, v2
// GFX10: encoding: [0x05,0x00,0x0d,0xd7,0x7f,0x04,0x02,0x00]

v_add_nc_i16 v5, 0, v2
// GFX10: encoding: [0x05,0x00,0x0d,0xd7,0x80,0x04,0x02,0x00]

v_add_nc_i16 v5, -1, v2
// GFX10: encoding: [0x05,0x00,0x0d,0xd7,0xc1,0x04,0x02,0x00]

v_add_nc_i16 v5, 0.5, v2
// GFX10: encoding: [0x05,0x00,0x0d,0xd7,0xff,0x04,0x02,0x00,0x00,0x38,0x00,0x00]

v_add_nc_i16 v5, -4.0, v2
// GFX10: encoding: [0x05,0x00,0x0d,0xd7,0xff,0x04,0x02,0x00,0x00,0xc4,0x00,0x00]

v_add_nc_i16 v5, v1, v255
// GFX10: encoding: [0x05,0x00,0x0d,0xd7,0x01,0xff,0x03,0x00]

v_add_nc_i16 v5, v1, s2
// GFX10: encoding: [0x05,0x00,0x0d,0xd7,0x01,0x05,0x00,0x00]

v_add_nc_i16 v5, v1, s101
// GFX10: encoding: [0x05,0x00,0x0d,0xd7,0x01,0xcb,0x00,0x00]

v_add_nc_i16 v5, v1, vcc_lo
// GFX10: encoding: [0x05,0x00,0x0d,0xd7,0x01,0xd5,0x00,0x00]

v_add_nc_i16 v5, v1, vcc_hi
// GFX10: encoding: [0x05,0x00,0x0d,0xd7,0x01,0xd7,0x00,0x00]

v_add_nc_i16 v5, v1, m0
// GFX10: encoding: [0x05,0x00,0x0d,0xd7,0x01,0xf9,0x00,0x00]

v_add_nc_i16 v5, v1, exec_lo
// GFX10: encoding: [0x05,0x00,0x0d,0xd7,0x01,0xfd,0x00,0x00]

v_add_nc_i16 v5, v1, exec_hi
// GFX10: encoding: [0x05,0x00,0x0d,0xd7,0x01,0xff,0x00,0x00]

v_add_nc_i16 v5, v1, 0
// GFX10: encoding: [0x05,0x00,0x0d,0xd7,0x01,0x01,0x01,0x00]

v_add_nc_i16 v5, v1, -1
// GFX10: encoding: [0x05,0x00,0x0d,0xd7,0x01,0x83,0x01,0x00]

v_add_nc_i16 v5, v1, 0.5
// GFX10: encoding: [0x05,0x00,0x0d,0xd7,0x01,0xff,0x01,0x00,0x00,0x38,0x00,0x00]

v_add_nc_i16 v5, v1, -4.0
// GFX10: encoding: [0x05,0x00,0x0d,0xd7,0x01,0xff,0x01,0x00,0x00,0xc4,0x00,0x00]

v_sub_nc_i16 v5, v1, v2
// GFX10: encoding: [0x05,0x00,0x0e,0xd7,0x01,0x05,0x02,0x00]

v_sub_nc_i16 v255, v1, v2
// GFX10: encoding: [0xff,0x00,0x0e,0xd7,0x01,0x05,0x02,0x00]

v_sub_nc_i16 v5, v255, v2
// GFX10: encoding: [0x05,0x00,0x0e,0xd7,0xff,0x05,0x02,0x00]

v_sub_nc_i16 v5, s1, v2
// GFX10: encoding: [0x05,0x00,0x0e,0xd7,0x01,0x04,0x02,0x00]

v_sub_nc_i16 v5, s101, v2
// GFX10: encoding: [0x05,0x00,0x0e,0xd7,0x65,0x04,0x02,0x00]

v_sub_nc_i16 v5, vcc_lo, v2
// GFX10: encoding: [0x05,0x00,0x0e,0xd7,0x6a,0x04,0x02,0x00]

v_sub_nc_i16 v5, vcc_hi, v2
// GFX10: encoding: [0x05,0x00,0x0e,0xd7,0x6b,0x04,0x02,0x00]

v_sub_nc_i16 v5, m0, v2
// GFX10: encoding: [0x05,0x00,0x0e,0xd7,0x7c,0x04,0x02,0x00]

v_sub_nc_i16 v5, exec_lo, v2
// GFX10: encoding: [0x05,0x00,0x0e,0xd7,0x7e,0x04,0x02,0x00]

v_sub_nc_i16 v5, exec_hi, v2
// GFX10: encoding: [0x05,0x00,0x0e,0xd7,0x7f,0x04,0x02,0x00]

v_sub_nc_i16 v5, 0, v2
// GFX10: encoding: [0x05,0x00,0x0e,0xd7,0x80,0x04,0x02,0x00]

v_sub_nc_i16 v5, -1, v2
// GFX10: encoding: [0x05,0x00,0x0e,0xd7,0xc1,0x04,0x02,0x00]

v_sub_nc_i16 v5, 0.5, v2
// GFX10: encoding: [0x05,0x00,0x0e,0xd7,0xff,0x04,0x02,0x00,0x00,0x38,0x00,0x00]

v_sub_nc_i16 v5, -4.0, v2
// GFX10: encoding: [0x05,0x00,0x0e,0xd7,0xff,0x04,0x02,0x00,0x00,0xc4,0x00,0x00]

v_sub_nc_i16 v5, v1, v255
// GFX10: encoding: [0x05,0x00,0x0e,0xd7,0x01,0xff,0x03,0x00]

v_sub_nc_i16 v5, v1, s2
// GFX10: encoding: [0x05,0x00,0x0e,0xd7,0x01,0x05,0x00,0x00]

v_sub_nc_i16 v5, v1, s101
// GFX10: encoding: [0x05,0x00,0x0e,0xd7,0x01,0xcb,0x00,0x00]

v_sub_nc_i16 v5, v1, vcc_lo
// GFX10: encoding: [0x05,0x00,0x0e,0xd7,0x01,0xd5,0x00,0x00]

v_sub_nc_i16 v5, v1, vcc_hi
// GFX10: encoding: [0x05,0x00,0x0e,0xd7,0x01,0xd7,0x00,0x00]

v_sub_nc_i16 v5, v1, m0
// GFX10: encoding: [0x05,0x00,0x0e,0xd7,0x01,0xf9,0x00,0x00]

v_sub_nc_i16 v5, v1, exec_lo
// GFX10: encoding: [0x05,0x00,0x0e,0xd7,0x01,0xfd,0x00,0x00]

v_sub_nc_i16 v5, v1, exec_hi
// GFX10: encoding: [0x05,0x00,0x0e,0xd7,0x01,0xff,0x00,0x00]

v_sub_nc_i16 v5, v1, 0
// GFX10: encoding: [0x05,0x00,0x0e,0xd7,0x01,0x01,0x01,0x00]

v_sub_nc_i16 v5, v1, -1
// GFX10: encoding: [0x05,0x00,0x0e,0xd7,0x01,0x83,0x01,0x00]

v_sub_nc_i16 v5, v1, 0.5
// GFX10: encoding: [0x05,0x00,0x0e,0xd7,0x01,0xff,0x01,0x00,0x00,0x38,0x00,0x00]

v_sub_nc_i16 v5, v1, -4.0
// GFX10: encoding: [0x05,0x00,0x0e,0xd7,0x01,0xff,0x01,0x00,0x00,0xc4,0x00,0x00]

v_pack_b32_f16 v5, v1, v2
// GFX10: encoding: [0x05,0x00,0x11,0xd7,0x01,0x05,0x02,0x00]

v_pack_b32_f16 v255, v1, v2
// GFX10: encoding: [0xff,0x00,0x11,0xd7,0x01,0x05,0x02,0x00]

v_pack_b32_f16 v5, v255, v2
// GFX10: encoding: [0x05,0x00,0x11,0xd7,0xff,0x05,0x02,0x00]

v_pack_b32_f16 v5, s1, v2
// GFX10: encoding: [0x05,0x00,0x11,0xd7,0x01,0x04,0x02,0x00]

v_pack_b32_f16 v5, s101, v2
// GFX10: encoding: [0x05,0x00,0x11,0xd7,0x65,0x04,0x02,0x00]

v_pack_b32_f16 v5, vcc_lo, v2
// GFX10: encoding: [0x05,0x00,0x11,0xd7,0x6a,0x04,0x02,0x00]

v_pack_b32_f16 v5, vcc_hi, v2
// GFX10: encoding: [0x05,0x00,0x11,0xd7,0x6b,0x04,0x02,0x00]

v_pack_b32_f16 v5, m0, v2
// GFX10: encoding: [0x05,0x00,0x11,0xd7,0x7c,0x04,0x02,0x00]

v_pack_b32_f16 v5, exec_lo, v2
// GFX10: encoding: [0x05,0x00,0x11,0xd7,0x7e,0x04,0x02,0x00]

v_pack_b32_f16 v5, exec_hi, v2
// GFX10: encoding: [0x05,0x00,0x11,0xd7,0x7f,0x04,0x02,0x00]

v_pack_b32_f16 v5, 0, v2
// GFX10: encoding: [0x05,0x00,0x11,0xd7,0x80,0x04,0x02,0x00]

v_pack_b32_f16 v5, -1, v2
// GFX10: encoding: [0x05,0x00,0x11,0xd7,0xc1,0x04,0x02,0x00]

v_pack_b32_f16 v5, 0.5, v2
// GFX10: encoding: [0x05,0x00,0x11,0xd7,0xf0,0x04,0x02,0x00]

v_pack_b32_f16 v5, -4.0, v2
// GFX10: encoding: [0x05,0x00,0x11,0xd7,0xf7,0x04,0x02,0x00]

v_pack_b32_f16 v5, v1, v255
// GFX10: encoding: [0x05,0x00,0x11,0xd7,0x01,0xff,0x03,0x00]

v_pack_b32_f16 v5, v1, s2
// GFX10: encoding: [0x05,0x00,0x11,0xd7,0x01,0x05,0x00,0x00]

v_pack_b32_f16 v5, v1, s101
// GFX10: encoding: [0x05,0x00,0x11,0xd7,0x01,0xcb,0x00,0x00]

v_pack_b32_f16 v5, v1, vcc_lo
// GFX10: encoding: [0x05,0x00,0x11,0xd7,0x01,0xd5,0x00,0x00]

v_pack_b32_f16 v5, v1, vcc_hi
// GFX10: encoding: [0x05,0x00,0x11,0xd7,0x01,0xd7,0x00,0x00]

v_pack_b32_f16 v5, v1, m0
// GFX10: encoding: [0x05,0x00,0x11,0xd7,0x01,0xf9,0x00,0x00]

v_pack_b32_f16 v5, v1, exec_lo
// GFX10: encoding: [0x05,0x00,0x11,0xd7,0x01,0xfd,0x00,0x00]

v_pack_b32_f16 v5, v1, exec_hi
// GFX10: encoding: [0x05,0x00,0x11,0xd7,0x01,0xff,0x00,0x00]

v_pack_b32_f16 v5, v1, 0
// GFX10: encoding: [0x05,0x00,0x11,0xd7,0x01,0x01,0x01,0x00]

v_pack_b32_f16 v5, v1, -1
// GFX10: encoding: [0x05,0x00,0x11,0xd7,0x01,0x83,0x01,0x00]

v_pack_b32_f16 v5, v1, 0.5
// GFX10: encoding: [0x05,0x00,0x11,0xd7,0x01,0xe1,0x01,0x00]

v_pack_b32_f16 v5, v1, -4.0
// GFX10: encoding: [0x05,0x00,0x11,0xd7,0x01,0xef,0x01,0x00]

v_pack_b32_f16 v5, -v1, v2
// GFX10: encoding: [0x05,0x00,0x11,0xd7,0x01,0x05,0x02,0x20]

v_pack_b32_f16 v5, v1, -v2
// GFX10: encoding: [0x05,0x00,0x11,0xd7,0x01,0x05,0x02,0x40]

v_pack_b32_f16 v5, -v1, -v2
// GFX10: encoding: [0x05,0x00,0x11,0xd7,0x01,0x05,0x02,0x60]

v_pack_b32_f16 v5, |v1|, v2
// GFX10: encoding: [0x05,0x01,0x11,0xd7,0x01,0x05,0x02,0x00]

v_pack_b32_f16 v5, v1, |v2|
// GFX10: encoding: [0x05,0x02,0x11,0xd7,0x01,0x05,0x02,0x00]

v_pack_b32_f16 v5, |v1|, |v2|
// GFX10: encoding: [0x05,0x03,0x11,0xd7,0x01,0x05,0x02,0x00]

v_pack_b32_f16 v5, v1, v2 op_sel:[0,0,0]
// GFX10: encoding: [0x05,0x00,0x11,0xd7,0x01,0x05,0x02,0x00]

v_pack_b32_f16 v5, v1, v2 op_sel:[1,0,0]
// GFX10: encoding: [0x05,0x08,0x11,0xd7,0x01,0x05,0x02,0x00]

v_pack_b32_f16 v5, v1, v2 op_sel:[0,1,0]
// GFX10: encoding: [0x05,0x10,0x11,0xd7,0x01,0x05,0x02,0x00]

v_pack_b32_f16 v5, v1, v2 op_sel:[0,0,1]
// GFX10: encoding: [0x05,0x40,0x11,0xd7,0x01,0x05,0x02,0x00]

v_pack_b32_f16 v5, v1, v2 op_sel:[1,1,1]
// GFX10: encoding: [0x05,0x58,0x11,0xd7,0x01,0x05,0x02,0x00]

v_cvt_pknorm_i16_f16 v5, v1, v2
// GFX10: encoding: [0x05,0x00,0x12,0xd7,0x01,0x05,0x02,0x00]

v_cvt_pknorm_i16_f16 v255, v1, v2
// GFX10: encoding: [0xff,0x00,0x12,0xd7,0x01,0x05,0x02,0x00]

v_cvt_pknorm_i16_f16 v5, v255, v2
// GFX10: encoding: [0x05,0x00,0x12,0xd7,0xff,0x05,0x02,0x00]

v_cvt_pknorm_i16_f16 v5, s1, v2
// GFX10: encoding: [0x05,0x00,0x12,0xd7,0x01,0x04,0x02,0x00]

v_cvt_pknorm_i16_f16 v5, s101, v2
// GFX10: encoding: [0x05,0x00,0x12,0xd7,0x65,0x04,0x02,0x00]

v_cvt_pknorm_i16_f16 v5, vcc_lo, v2
// GFX10: encoding: [0x05,0x00,0x12,0xd7,0x6a,0x04,0x02,0x00]

v_cvt_pknorm_i16_f16 v5, vcc_hi, v2
// GFX10: encoding: [0x05,0x00,0x12,0xd7,0x6b,0x04,0x02,0x00]

v_cvt_pknorm_i16_f16 v5, m0, v2
// GFX10: encoding: [0x05,0x00,0x12,0xd7,0x7c,0x04,0x02,0x00]

v_cvt_pknorm_i16_f16 v5, exec_lo, v2
// GFX10: encoding: [0x05,0x00,0x12,0xd7,0x7e,0x04,0x02,0x00]

v_cvt_pknorm_i16_f16 v5, exec_hi, v2
// GFX10: encoding: [0x05,0x00,0x12,0xd7,0x7f,0x04,0x02,0x00]

v_cvt_pknorm_i16_f16 v5, 0, v2
// GFX10: encoding: [0x05,0x00,0x12,0xd7,0x80,0x04,0x02,0x00]

v_cvt_pknorm_i16_f16 v5, -1, v2
// GFX10: encoding: [0x05,0x00,0x12,0xd7,0xc1,0x04,0x02,0x00]

v_cvt_pknorm_i16_f16 v5, 0.5, v2
// GFX10: encoding: [0x05,0x00,0x12,0xd7,0xf0,0x04,0x02,0x00]

v_cvt_pknorm_i16_f16 v5, -4.0, v2
// GFX10: encoding: [0x05,0x00,0x12,0xd7,0xf7,0x04,0x02,0x00]

v_cvt_pknorm_i16_f16 v5, v1, v255
// GFX10: encoding: [0x05,0x00,0x12,0xd7,0x01,0xff,0x03,0x00]

v_cvt_pknorm_i16_f16 v5, v1, s2
// GFX10: encoding: [0x05,0x00,0x12,0xd7,0x01,0x05,0x00,0x00]

v_cvt_pknorm_i16_f16 v5, v1, s101
// GFX10: encoding: [0x05,0x00,0x12,0xd7,0x01,0xcb,0x00,0x00]

v_cvt_pknorm_i16_f16 v5, v1, vcc_lo
// GFX10: encoding: [0x05,0x00,0x12,0xd7,0x01,0xd5,0x00,0x00]

v_cvt_pknorm_i16_f16 v5, v1, vcc_hi
// GFX10: encoding: [0x05,0x00,0x12,0xd7,0x01,0xd7,0x00,0x00]

v_cvt_pknorm_i16_f16 v5, v1, m0
// GFX10: encoding: [0x05,0x00,0x12,0xd7,0x01,0xf9,0x00,0x00]

v_cvt_pknorm_i16_f16 v5, v1, exec_lo
// GFX10: encoding: [0x05,0x00,0x12,0xd7,0x01,0xfd,0x00,0x00]

v_cvt_pknorm_i16_f16 v5, v1, exec_hi
// GFX10: encoding: [0x05,0x00,0x12,0xd7,0x01,0xff,0x00,0x00]

v_cvt_pknorm_i16_f16 v5, v1, 0
// GFX10: encoding: [0x05,0x00,0x12,0xd7,0x01,0x01,0x01,0x00]

v_cvt_pknorm_i16_f16 v5, v1, -1
// GFX10: encoding: [0x05,0x00,0x12,0xd7,0x01,0x83,0x01,0x00]

v_cvt_pknorm_i16_f16 v5, v1, 0.5
// GFX10: encoding: [0x05,0x00,0x12,0xd7,0x01,0xe1,0x01,0x00]

v_cvt_pknorm_i16_f16 v5, v1, -4.0
// GFX10: encoding: [0x05,0x00,0x12,0xd7,0x01,0xef,0x01,0x00]

v_cvt_pknorm_i16_f16 v5, -v1, v2
// GFX10: encoding: [0x05,0x00,0x12,0xd7,0x01,0x05,0x02,0x20]

v_cvt_pknorm_i16_f16 v5, v1, -v2
// GFX10: encoding: [0x05,0x00,0x12,0xd7,0x01,0x05,0x02,0x40]

v_cvt_pknorm_i16_f16 v5, -v1, -v2
// GFX10: encoding: [0x05,0x00,0x12,0xd7,0x01,0x05,0x02,0x60]

v_cvt_pknorm_i16_f16 v5, |v1|, v2
// GFX10: encoding: [0x05,0x01,0x12,0xd7,0x01,0x05,0x02,0x00]

v_cvt_pknorm_i16_f16 v5, v1, |v2|
// GFX10: encoding: [0x05,0x02,0x12,0xd7,0x01,0x05,0x02,0x00]

v_cvt_pknorm_i16_f16 v5, |v1|, |v2|
// GFX10: encoding: [0x05,0x03,0x12,0xd7,0x01,0x05,0x02,0x00]

v_cvt_pknorm_i16_f16 v5, v1, v2 op_sel:[0,0,0]
// GFX10: encoding: [0x05,0x00,0x12,0xd7,0x01,0x05,0x02,0x00]

v_cvt_pknorm_i16_f16 v5, v1, v2 op_sel:[1,0,0]
// GFX10: encoding: [0x05,0x08,0x12,0xd7,0x01,0x05,0x02,0x00]

v_cvt_pknorm_i16_f16 v5, v1, v2 op_sel:[0,1,0]
// GFX10: encoding: [0x05,0x10,0x12,0xd7,0x01,0x05,0x02,0x00]

v_cvt_pknorm_i16_f16 v5, v1, v2 op_sel:[0,0,1]
// GFX10: encoding: [0x05,0x40,0x12,0xd7,0x01,0x05,0x02,0x00]

v_cvt_pknorm_i16_f16 v5, v1, v2 op_sel:[1,1,1]
// GFX10: encoding: [0x05,0x58,0x12,0xd7,0x01,0x05,0x02,0x00]

v_cvt_pknorm_u16_f16 v5, v1, v2
// GFX10: encoding: [0x05,0x00,0x13,0xd7,0x01,0x05,0x02,0x00]

v_cvt_pknorm_u16_f16 v255, v1, v2
// GFX10: encoding: [0xff,0x00,0x13,0xd7,0x01,0x05,0x02,0x00]

v_cvt_pknorm_u16_f16 v5, v255, v2
// GFX10: encoding: [0x05,0x00,0x13,0xd7,0xff,0x05,0x02,0x00]

v_cvt_pknorm_u16_f16 v5, s1, v2
// GFX10: encoding: [0x05,0x00,0x13,0xd7,0x01,0x04,0x02,0x00]

v_cvt_pknorm_u16_f16 v5, s101, v2
// GFX10: encoding: [0x05,0x00,0x13,0xd7,0x65,0x04,0x02,0x00]

v_cvt_pknorm_u16_f16 v5, vcc_lo, v2
// GFX10: encoding: [0x05,0x00,0x13,0xd7,0x6a,0x04,0x02,0x00]

v_cvt_pknorm_u16_f16 v5, vcc_hi, v2
// GFX10: encoding: [0x05,0x00,0x13,0xd7,0x6b,0x04,0x02,0x00]

v_cvt_pknorm_u16_f16 v5, m0, v2
// GFX10: encoding: [0x05,0x00,0x13,0xd7,0x7c,0x04,0x02,0x00]

v_cvt_pknorm_u16_f16 v5, exec_lo, v2
// GFX10: encoding: [0x05,0x00,0x13,0xd7,0x7e,0x04,0x02,0x00]

v_cvt_pknorm_u16_f16 v5, exec_hi, v2
// GFX10: encoding: [0x05,0x00,0x13,0xd7,0x7f,0x04,0x02,0x00]

v_cvt_pknorm_u16_f16 v5, 0, v2
// GFX10: encoding: [0x05,0x00,0x13,0xd7,0x80,0x04,0x02,0x00]

v_cvt_pknorm_u16_f16 v5, -1, v2
// GFX10: encoding: [0x05,0x00,0x13,0xd7,0xc1,0x04,0x02,0x00]

v_cvt_pknorm_u16_f16 v5, 0.5, v2
// GFX10: encoding: [0x05,0x00,0x13,0xd7,0xf0,0x04,0x02,0x00]

v_cvt_pknorm_u16_f16 v5, -4.0, v2
// GFX10: encoding: [0x05,0x00,0x13,0xd7,0xf7,0x04,0x02,0x00]

v_cvt_pknorm_u16_f16 v5, v1, v255
// GFX10: encoding: [0x05,0x00,0x13,0xd7,0x01,0xff,0x03,0x00]

v_cvt_pknorm_u16_f16 v5, v1, s2
// GFX10: encoding: [0x05,0x00,0x13,0xd7,0x01,0x05,0x00,0x00]

v_cvt_pknorm_u16_f16 v5, v1, s101
// GFX10: encoding: [0x05,0x00,0x13,0xd7,0x01,0xcb,0x00,0x00]

v_cvt_pknorm_u16_f16 v5, v1, vcc_lo
// GFX10: encoding: [0x05,0x00,0x13,0xd7,0x01,0xd5,0x00,0x00]

v_cvt_pknorm_u16_f16 v5, v1, vcc_hi
// GFX10: encoding: [0x05,0x00,0x13,0xd7,0x01,0xd7,0x00,0x00]

v_cvt_pknorm_u16_f16 v5, v1, m0
// GFX10: encoding: [0x05,0x00,0x13,0xd7,0x01,0xf9,0x00,0x00]

v_cvt_pknorm_u16_f16 v5, v1, exec_lo
// GFX10: encoding: [0x05,0x00,0x13,0xd7,0x01,0xfd,0x00,0x00]

v_cvt_pknorm_u16_f16 v5, v1, exec_hi
// GFX10: encoding: [0x05,0x00,0x13,0xd7,0x01,0xff,0x00,0x00]

v_cvt_pknorm_u16_f16 v5, v1, 0
// GFX10: encoding: [0x05,0x00,0x13,0xd7,0x01,0x01,0x01,0x00]

v_cvt_pknorm_u16_f16 v5, v1, -1
// GFX10: encoding: [0x05,0x00,0x13,0xd7,0x01,0x83,0x01,0x00]

v_cvt_pknorm_u16_f16 v5, v1, 0.5
// GFX10: encoding: [0x05,0x00,0x13,0xd7,0x01,0xe1,0x01,0x00]

v_cvt_pknorm_u16_f16 v5, v1, -4.0
// GFX10: encoding: [0x05,0x00,0x13,0xd7,0x01,0xef,0x01,0x00]

v_cvt_pknorm_u16_f16 v5, -v1, v2
// GFX10: encoding: [0x05,0x00,0x13,0xd7,0x01,0x05,0x02,0x20]

v_cvt_pknorm_u16_f16 v5, v1, -v2
// GFX10: encoding: [0x05,0x00,0x13,0xd7,0x01,0x05,0x02,0x40]

v_cvt_pknorm_u16_f16 v5, -v1, -v2
// GFX10: encoding: [0x05,0x00,0x13,0xd7,0x01,0x05,0x02,0x60]

v_cvt_pknorm_u16_f16 v5, |v1|, v2
// GFX10: encoding: [0x05,0x01,0x13,0xd7,0x01,0x05,0x02,0x00]

v_cvt_pknorm_u16_f16 v5, v1, |v2|
// GFX10: encoding: [0x05,0x02,0x13,0xd7,0x01,0x05,0x02,0x00]

v_cvt_pknorm_u16_f16 v5, |v1|, |v2|
// GFX10: encoding: [0x05,0x03,0x13,0xd7,0x01,0x05,0x02,0x00]

v_cvt_pknorm_u16_f16 v5, v1, v2 op_sel:[0,0,0]
// GFX10: encoding: [0x05,0x00,0x13,0xd7,0x01,0x05,0x02,0x00]

v_cvt_pknorm_u16_f16 v5, v1, v2 op_sel:[1,0,0]
// GFX10: encoding: [0x05,0x08,0x13,0xd7,0x01,0x05,0x02,0x00]

v_cvt_pknorm_u16_f16 v5, v1, v2 op_sel:[0,1,0]
// GFX10: encoding: [0x05,0x10,0x13,0xd7,0x01,0x05,0x02,0x00]

v_cvt_pknorm_u16_f16 v5, v1, v2 op_sel:[0,0,1]
// GFX10: encoding: [0x05,0x40,0x13,0xd7,0x01,0x05,0x02,0x00]

v_cvt_pknorm_u16_f16 v5, v1, v2 op_sel:[1,1,1]
// GFX10: encoding: [0x05,0x58,0x13,0xd7,0x01,0x05,0x02,0x00]

v_lshlrev_b16 v5, v1, v2
// GFX10: encoding: [0x05,0x00,0x14,0xd7,0x01,0x05,0x02,0x00]

v_lshlrev_b16 v255, v1, v2
// GFX10: encoding: [0xff,0x00,0x14,0xd7,0x01,0x05,0x02,0x00]

v_lshlrev_b16 v5, v255, v2
// GFX10: encoding: [0x05,0x00,0x14,0xd7,0xff,0x05,0x02,0x00]

v_lshlrev_b16 v5, s1, v2
// GFX10: encoding: [0x05,0x00,0x14,0xd7,0x01,0x04,0x02,0x00]

v_lshlrev_b16 v5, s101, v2
// GFX10: encoding: [0x05,0x00,0x14,0xd7,0x65,0x04,0x02,0x00]

v_lshlrev_b16 v5, vcc_lo, v2
// GFX10: encoding: [0x05,0x00,0x14,0xd7,0x6a,0x04,0x02,0x00]

v_lshlrev_b16 v5, vcc_hi, v2
// GFX10: encoding: [0x05,0x00,0x14,0xd7,0x6b,0x04,0x02,0x00]

v_lshlrev_b16 v5, m0, v2
// GFX10: encoding: [0x05,0x00,0x14,0xd7,0x7c,0x04,0x02,0x00]

v_lshlrev_b16 v5, exec_lo, v2
// GFX10: encoding: [0x05,0x00,0x14,0xd7,0x7e,0x04,0x02,0x00]

v_lshlrev_b16 v5, exec_hi, v2
// GFX10: encoding: [0x05,0x00,0x14,0xd7,0x7f,0x04,0x02,0x00]

v_lshlrev_b16 v5, 0, v2
// GFX10: encoding: [0x05,0x00,0x14,0xd7,0x80,0x04,0x02,0x00]

v_lshlrev_b16 v5, -1, v2
// GFX10: encoding: [0x05,0x00,0x14,0xd7,0xc1,0x04,0x02,0x00]

v_lshlrev_b16 v5, 0.5, v2
// GFX10: encoding: [0x05,0x00,0x14,0xd7,0xff,0x04,0x02,0x00,0x00,0x38,0x00,0x00]

v_lshlrev_b16 v5, -4.0, v2
// GFX10: encoding: [0x05,0x00,0x14,0xd7,0xff,0x04,0x02,0x00,0x00,0xc4,0x00,0x00]

v_lshlrev_b16 v5, v1, v255
// GFX10: encoding: [0x05,0x00,0x14,0xd7,0x01,0xff,0x03,0x00]

v_lshlrev_b16 v5, v1, s2
// GFX10: encoding: [0x05,0x00,0x14,0xd7,0x01,0x05,0x00,0x00]

v_lshlrev_b16 v5, v1, s101
// GFX10: encoding: [0x05,0x00,0x14,0xd7,0x01,0xcb,0x00,0x00]

v_lshlrev_b16 v5, v1, vcc_lo
// GFX10: encoding: [0x05,0x00,0x14,0xd7,0x01,0xd5,0x00,0x00]

v_lshlrev_b16 v5, v1, vcc_hi
// GFX10: encoding: [0x05,0x00,0x14,0xd7,0x01,0xd7,0x00,0x00]

v_lshlrev_b16 v5, v1, m0
// GFX10: encoding: [0x05,0x00,0x14,0xd7,0x01,0xf9,0x00,0x00]

v_lshlrev_b16 v5, v1, exec_lo
// GFX10: encoding: [0x05,0x00,0x14,0xd7,0x01,0xfd,0x00,0x00]

v_lshlrev_b16 v5, v1, exec_hi
// GFX10: encoding: [0x05,0x00,0x14,0xd7,0x01,0xff,0x00,0x00]

v_lshlrev_b16 v5, v1, 0
// GFX10: encoding: [0x05,0x00,0x14,0xd7,0x01,0x01,0x01,0x00]

v_lshlrev_b16 v5, v1, -1
// GFX10: encoding: [0x05,0x00,0x14,0xd7,0x01,0x83,0x01,0x00]

v_lshlrev_b16 v5, v1, 0.5
// GFX10: encoding: [0x05,0x00,0x14,0xd7,0x01,0xff,0x01,0x00,0x00,0x38,0x00,0x00]

v_lshlrev_b16 v5, v1, -4.0
// GFX10: encoding: [0x05,0x00,0x14,0xd7,0x01,0xff,0x01,0x00,0x00,0xc4,0x00,0x00]

v_mad_u16 v5, 0, v2, v3
// GFX10: encoding: [0x05,0x00,0x40,0xd7,0x80,0x04,0x0e,0x04]

v_mad_u16 v5, v1, -1, v3
// GFX10: encoding: [0x05,0x00,0x40,0xd7,0x01,0x83,0x0d,0x04]

v_mad_u16 v5, v1, v2, -4.0
// GFX10: encoding: [0x05,0x00,0x40,0xd7,0x01,0x05,0xfe,0x03,0x00,0xc4,0x00,0x00]

v_mad_u16 v5, v1, v2, v3 clamp
// GFX10: encoding: [0x05,0x80,0x40,0xd7,0x01,0x05,0x0e,0x04]

v_mad_u16 v5, v1, v2, v3 op_sel:[1,0,0,0]
// GFX10: encoding: [0x05,0x08,0x40,0xd7,0x01,0x05,0x0e,0x04]

v_mad_u16 v5, v1, v2, v3 op_sel:[0,0,0,1]
// GFX10: encoding: [0x05,0x40,0x40,0xd7,0x01,0x05,0x0e,0x04]

v_mad_u16 v5, v1, v2, v3 op_sel:[1,1,1,1]
// GFX10: encoding: [0x05,0x78,0x40,0xd7,0x01,0x05,0x0e,0x04]

v_interp_p1ll_f16 v5, v2, attr31.x
// GFX10: encoding: [0x05,0x00,0x42,0xd7,0x1f,0x04,0x02,0x00]

v_interp_p1ll_f16 v5, v2, attr0.w
// GFX10: encoding: [0x05,0x00,0x42,0xd7,0xc0,0x04,0x02,0x00]

v_interp_p1ll_f16 v5, -v2, attr0.x
// GFX10: encoding: [0x05,0x00,0x42,0xd7,0x00,0x04,0x02,0x40]

v_interp_p1ll_f16 v5, |v2|, attr0.x
// GFX10: encoding: [0x05,0x02,0x42,0xd7,0x00,0x04,0x02,0x00]

v_interp_p1ll_f16 v5, v2, attr0.x high
// GFX10: encoding: [0x05,0x00,0x42,0xd7,0x00,0x05,0x02,0x00]

v_interp_p1ll_f16 v5, v2, attr0.x clamp
// GFX10: encoding: [0x05,0x80,0x42,0xd7,0x00,0x04,0x02,0x00]

v_interp_p1ll_f16 v5, v2, attr0.x mul:4
// GFX10: encoding: [0x05,0x00,0x42,0xd7,0x00,0x04,0x02,0x10]

v_interp_p1lv_f16 v5, v2, attr1.x, v3
// GFX10: encoding: [0x05,0x00,0x43,0xd7,0x01,0x04,0x0e,0x04]

v_interp_p1lv_f16 v5, v2, attr0.z, v3
// GFX10: encoding: [0x05,0x00,0x43,0xd7,0x80,0x04,0x0e,0x04]

v_interp_p1lv_f16 v5, -v2, attr0.x, v3
// GFX10: encoding: [0x05,0x00,0x43,0xd7,0x00,0x04,0x0e,0x44]

v_interp_p1lv_f16 v5, v2, attr0.x, -v3
// GFX10: encoding: [0x05,0x00,0x43,0xd7,0x00,0x04,0x0e,0x84]

v_interp_p1lv_f16 v5, |v2|, attr0.x, v3
// GFX10: encoding: [0x05,0x02,0x43,0xd7,0x00,0x04,0x0e,0x04]

v_interp_p1lv_f16 v5, v2, attr0.x, |v3|
// GFX10: encoding: [0x05,0x04,0x43,0xd7,0x00,0x04,0x0e,0x04]

v_interp_p1lv_f16 v5, v2, attr0.x, v3 high
// GFX10: encoding: [0x05,0x00,0x43,0xd7,0x00,0x05,0x0e,0x04]

v_interp_p1lv_f16 v5, v2, attr0.x, v3 clamp
// GFX10: encoding: [0x05,0x80,0x43,0xd7,0x00,0x04,0x0e,0x04]

v_interp_p1lv_f16 v5, v2, attr0.x, v3 mul:2
// GFX10: encoding: [0x05,0x00,0x43,0xd7,0x00,0x04,0x0e,0x0c]

v_interp_p1lv_f16 v5, v2, attr0.x, v3 div:2
// GFX10: encoding: [0x05,0x00,0x43,0xd7,0x00,0x04,0x0e,0x1c]

v_perm_b32 v5, v1, v2, v3
// GFX10: encoding: [0x05,0x00,0x44,0xd7,0x01,0x05,0x0e,0x04]

v_perm_b32 v255, v1, v2, v3
// GFX10: encoding: [0xff,0x00,0x44,0xd7,0x01,0x05,0x0e,0x04]

v_perm_b32 v5, v255, v2, v3
// GFX10: encoding: [0x05,0x00,0x44,0xd7,0xff,0x05,0x0e,0x04]

v_perm_b32 v5, s1, v2, v3
// GFX10: encoding: [0x05,0x00,0x44,0xd7,0x01,0x04,0x0e,0x04]

v_perm_b32 v5, s101, v2, v3
// GFX10: encoding: [0x05,0x00,0x44,0xd7,0x65,0x04,0x0e,0x04]

v_perm_b32 v5, vcc_lo, v2, v3
// GFX10: encoding: [0x05,0x00,0x44,0xd7,0x6a,0x04,0x0e,0x04]

v_perm_b32 v5, vcc_hi, v2, v3
// GFX10: encoding: [0x05,0x00,0x44,0xd7,0x6b,0x04,0x0e,0x04]

v_perm_b32 v5, m0, v2, v3
// GFX10: encoding: [0x05,0x00,0x44,0xd7,0x7c,0x04,0x0e,0x04]

v_perm_b32 v5, exec_lo, v2, v3
// GFX10: encoding: [0x05,0x00,0x44,0xd7,0x7e,0x04,0x0e,0x04]

v_perm_b32 v5, exec_hi, v2, v3
// GFX10: encoding: [0x05,0x00,0x44,0xd7,0x7f,0x04,0x0e,0x04]

v_perm_b32 v5, 0, v2, v3
// GFX10: encoding: [0x05,0x00,0x44,0xd7,0x80,0x04,0x0e,0x04]

v_perm_b32 v5, -1, v2, v3
// GFX10: encoding: [0x05,0x00,0x44,0xd7,0xc1,0x04,0x0e,0x04]

v_perm_b32 v5, 0.5, v2, v3
// GFX10: encoding: [0x05,0x00,0x44,0xd7,0xf0,0x04,0x0e,0x04]

v_perm_b32 v5, -4.0, v2, v3
// GFX10: encoding: [0x05,0x00,0x44,0xd7,0xf7,0x04,0x0e,0x04]

v_perm_b32 v5, v1, v255, v3
// GFX10: encoding: [0x05,0x00,0x44,0xd7,0x01,0xff,0x0f,0x04]

v_perm_b32 v5, v1, s2, v3
// GFX10: encoding: [0x05,0x00,0x44,0xd7,0x01,0x05,0x0c,0x04]

v_perm_b32 v5, v1, s101, v3
// GFX10: encoding: [0x05,0x00,0x44,0xd7,0x01,0xcb,0x0c,0x04]

v_perm_b32 v5, v1, vcc_lo, v3
// GFX10: encoding: [0x05,0x00,0x44,0xd7,0x01,0xd5,0x0c,0x04]

v_perm_b32 v5, v1, vcc_hi, v3
// GFX10: encoding: [0x05,0x00,0x44,0xd7,0x01,0xd7,0x0c,0x04]

v_perm_b32 v5, v1, m0, v3
// GFX10: encoding: [0x05,0x00,0x44,0xd7,0x01,0xf9,0x0c,0x04]

v_perm_b32 v5, v1, exec_lo, v3
// GFX10: encoding: [0x05,0x00,0x44,0xd7,0x01,0xfd,0x0c,0x04]

v_perm_b32 v5, v1, exec_hi, v3
// GFX10: encoding: [0x05,0x00,0x44,0xd7,0x01,0xff,0x0c,0x04]

v_perm_b32 v5, v1, 0, v3
// GFX10: encoding: [0x05,0x00,0x44,0xd7,0x01,0x01,0x0d,0x04]

v_perm_b32 v5, v1, -1, v3
// GFX10: encoding: [0x05,0x00,0x44,0xd7,0x01,0x83,0x0d,0x04]

v_perm_b32 v5, v1, 0.5, v3
// GFX10: encoding: [0x05,0x00,0x44,0xd7,0x01,0xe1,0x0d,0x04]

v_perm_b32 v5, v1, -4.0, v3
// GFX10: encoding: [0x05,0x00,0x44,0xd7,0x01,0xef,0x0d,0x04]

v_perm_b32 v5, v1, v2, v255
// GFX10: encoding: [0x05,0x00,0x44,0xd7,0x01,0x05,0xfe,0x07]

v_perm_b32 v5, v1, v2, s3
// GFX10: encoding: [0x05,0x00,0x44,0xd7,0x01,0x05,0x0e,0x00]

v_perm_b32 v5, v1, v2, s101
// GFX10: encoding: [0x05,0x00,0x44,0xd7,0x01,0x05,0x96,0x01]

v_perm_b32 v5, v1, v2, vcc_lo
// GFX10: encoding: [0x05,0x00,0x44,0xd7,0x01,0x05,0xaa,0x01]

v_perm_b32 v5, v1, v2, vcc_hi
// GFX10: encoding: [0x05,0x00,0x44,0xd7,0x01,0x05,0xae,0x01]

v_perm_b32 v5, v1, v2, m0
// GFX10: encoding: [0x05,0x00,0x44,0xd7,0x01,0x05,0xf2,0x01]

v_perm_b32 v5, v1, v2, exec_lo
// GFX10: encoding: [0x05,0x00,0x44,0xd7,0x01,0x05,0xfa,0x01]

v_perm_b32 v5, v1, v2, exec_hi
// GFX10: encoding: [0x05,0x00,0x44,0xd7,0x01,0x05,0xfe,0x01]

v_perm_b32 v5, v1, v2, 0
// GFX10: encoding: [0x05,0x00,0x44,0xd7,0x01,0x05,0x02,0x02]

v_perm_b32 v5, v1, v2, -1
// GFX10: encoding: [0x05,0x00,0x44,0xd7,0x01,0x05,0x06,0x03]

v_perm_b32 v5, v1, v2, 0.5
// GFX10: encoding: [0x05,0x00,0x44,0xd7,0x01,0x05,0xc2,0x03]

v_perm_b32 v5, v1, v2, -4.0
// GFX10: encoding: [0x05,0x00,0x44,0xd7,0x01,0x05,0xde,0x03]

v_xad_u32 v5, v1, v2, v3
// GFX10: encoding: [0x05,0x00,0x45,0xd7,0x01,0x05,0x0e,0x04]

v_xad_u32 v255, v1, v2, v3
// GFX10: encoding: [0xff,0x00,0x45,0xd7,0x01,0x05,0x0e,0x04]

v_xad_u32 v5, v255, v2, v3
// GFX10: encoding: [0x05,0x00,0x45,0xd7,0xff,0x05,0x0e,0x04]

v_xad_u32 v5, s1, v2, v3
// GFX10: encoding: [0x05,0x00,0x45,0xd7,0x01,0x04,0x0e,0x04]

v_xad_u32 v5, s101, v2, v3
// GFX10: encoding: [0x05,0x00,0x45,0xd7,0x65,0x04,0x0e,0x04]

v_xad_u32 v5, vcc_lo, v2, v3
// GFX10: encoding: [0x05,0x00,0x45,0xd7,0x6a,0x04,0x0e,0x04]

v_xad_u32 v5, vcc_hi, v2, v3
// GFX10: encoding: [0x05,0x00,0x45,0xd7,0x6b,0x04,0x0e,0x04]

v_xad_u32 v5, m0, v2, v3
// GFX10: encoding: [0x05,0x00,0x45,0xd7,0x7c,0x04,0x0e,0x04]

v_xad_u32 v5, exec_lo, v2, v3
// GFX10: encoding: [0x05,0x00,0x45,0xd7,0x7e,0x04,0x0e,0x04]

v_xad_u32 v5, exec_hi, v2, v3
// GFX10: encoding: [0x05,0x00,0x45,0xd7,0x7f,0x04,0x0e,0x04]

v_xad_u32 v5, 0, v2, v3
// GFX10: encoding: [0x05,0x00,0x45,0xd7,0x80,0x04,0x0e,0x04]

v_xad_u32 v5, -1, v2, v3
// GFX10: encoding: [0x05,0x00,0x45,0xd7,0xc1,0x04,0x0e,0x04]

v_xad_u32 v5, 0.5, v2, v3
// GFX10: encoding: [0x05,0x00,0x45,0xd7,0xf0,0x04,0x0e,0x04]

v_xad_u32 v5, -4.0, v2, v3
// GFX10: encoding: [0x05,0x00,0x45,0xd7,0xf7,0x04,0x0e,0x04]

v_xad_u32 v5, v1, v255, v3
// GFX10: encoding: [0x05,0x00,0x45,0xd7,0x01,0xff,0x0f,0x04]

v_xad_u32 v5, v1, s2, v3
// GFX10: encoding: [0x05,0x00,0x45,0xd7,0x01,0x05,0x0c,0x04]

v_xad_u32 v5, v1, s101, v3
// GFX10: encoding: [0x05,0x00,0x45,0xd7,0x01,0xcb,0x0c,0x04]

v_xad_u32 v5, v1, vcc_lo, v3
// GFX10: encoding: [0x05,0x00,0x45,0xd7,0x01,0xd5,0x0c,0x04]

v_xad_u32 v5, v1, vcc_hi, v3
// GFX10: encoding: [0x05,0x00,0x45,0xd7,0x01,0xd7,0x0c,0x04]

v_xad_u32 v5, v1, m0, v3
// GFX10: encoding: [0x05,0x00,0x45,0xd7,0x01,0xf9,0x0c,0x04]

v_xad_u32 v5, v1, exec_lo, v3
// GFX10: encoding: [0x05,0x00,0x45,0xd7,0x01,0xfd,0x0c,0x04]

v_xad_u32 v5, v1, exec_hi, v3
// GFX10: encoding: [0x05,0x00,0x45,0xd7,0x01,0xff,0x0c,0x04]

v_xad_u32 v5, v1, 0, v3
// GFX10: encoding: [0x05,0x00,0x45,0xd7,0x01,0x01,0x0d,0x04]

v_xad_u32 v5, v1, -1, v3
// GFX10: encoding: [0x05,0x00,0x45,0xd7,0x01,0x83,0x0d,0x04]

v_xad_u32 v5, v1, 0.5, v3
// GFX10: encoding: [0x05,0x00,0x45,0xd7,0x01,0xe1,0x0d,0x04]

v_xad_u32 v5, v1, -4.0, v3
// GFX10: encoding: [0x05,0x00,0x45,0xd7,0x01,0xef,0x0d,0x04]

v_xad_u32 v5, v1, v2, v255
// GFX10: encoding: [0x05,0x00,0x45,0xd7,0x01,0x05,0xfe,0x07]

v_xad_u32 v5, v1, v2, s3
// GFX10: encoding: [0x05,0x00,0x45,0xd7,0x01,0x05,0x0e,0x00]

v_xad_u32 v5, v1, v2, s101
// GFX10: encoding: [0x05,0x00,0x45,0xd7,0x01,0x05,0x96,0x01]

v_xad_u32 v5, v1, v2, vcc_lo
// GFX10: encoding: [0x05,0x00,0x45,0xd7,0x01,0x05,0xaa,0x01]

v_xad_u32 v5, v1, v2, vcc_hi
// GFX10: encoding: [0x05,0x00,0x45,0xd7,0x01,0x05,0xae,0x01]

v_xad_u32 v5, v1, v2, m0
// GFX10: encoding: [0x05,0x00,0x45,0xd7,0x01,0x05,0xf2,0x01]

v_xad_u32 v5, v1, v2, exec_lo
// GFX10: encoding: [0x05,0x00,0x45,0xd7,0x01,0x05,0xfa,0x01]

v_xad_u32 v5, v1, v2, exec_hi
// GFX10: encoding: [0x05,0x00,0x45,0xd7,0x01,0x05,0xfe,0x01]

v_xad_u32 v5, v1, v2, 0
// GFX10: encoding: [0x05,0x00,0x45,0xd7,0x01,0x05,0x02,0x02]

v_xad_u32 v5, v1, v2, -1
// GFX10: encoding: [0x05,0x00,0x45,0xd7,0x01,0x05,0x06,0x03]

v_xad_u32 v5, v1, v2, 0.5
// GFX10: encoding: [0x05,0x00,0x45,0xd7,0x01,0x05,0xc2,0x03]

v_xad_u32 v5, v1, v2, -4.0
// GFX10: encoding: [0x05,0x00,0x45,0xd7,0x01,0x05,0xde,0x03]

v_lshl_add_u32 v5, v1, v2, v3
// GFX10: encoding: [0x05,0x00,0x46,0xd7,0x01,0x05,0x0e,0x04]

v_lshl_add_u32 v255, v1, v2, v3
// GFX10: encoding: [0xff,0x00,0x46,0xd7,0x01,0x05,0x0e,0x04]

v_lshl_add_u32 v5, v255, v2, v3
// GFX10: encoding: [0x05,0x00,0x46,0xd7,0xff,0x05,0x0e,0x04]

v_lshl_add_u32 v5, s1, v2, v3
// GFX10: encoding: [0x05,0x00,0x46,0xd7,0x01,0x04,0x0e,0x04]

v_lshl_add_u32 v5, s101, v2, v3
// GFX10: encoding: [0x05,0x00,0x46,0xd7,0x65,0x04,0x0e,0x04]

v_lshl_add_u32 v5, vcc_lo, v2, v3
// GFX10: encoding: [0x05,0x00,0x46,0xd7,0x6a,0x04,0x0e,0x04]

v_lshl_add_u32 v5, vcc_hi, v2, v3
// GFX10: encoding: [0x05,0x00,0x46,0xd7,0x6b,0x04,0x0e,0x04]

v_lshl_add_u32 v5, m0, v2, v3
// GFX10: encoding: [0x05,0x00,0x46,0xd7,0x7c,0x04,0x0e,0x04]

v_lshl_add_u32 v5, exec_lo, v2, v3
// GFX10: encoding: [0x05,0x00,0x46,0xd7,0x7e,0x04,0x0e,0x04]

v_lshl_add_u32 v5, exec_hi, v2, v3
// GFX10: encoding: [0x05,0x00,0x46,0xd7,0x7f,0x04,0x0e,0x04]

v_lshl_add_u32 v5, 0, v2, v3
// GFX10: encoding: [0x05,0x00,0x46,0xd7,0x80,0x04,0x0e,0x04]

v_lshl_add_u32 v5, -1, v2, v3
// GFX10: encoding: [0x05,0x00,0x46,0xd7,0xc1,0x04,0x0e,0x04]

v_lshl_add_u32 v5, 0.5, v2, v3
// GFX10: encoding: [0x05,0x00,0x46,0xd7,0xf0,0x04,0x0e,0x04]

v_lshl_add_u32 v5, -4.0, v2, v3
// GFX10: encoding: [0x05,0x00,0x46,0xd7,0xf7,0x04,0x0e,0x04]

v_lshl_add_u32 v5, v1, v255, v3
// GFX10: encoding: [0x05,0x00,0x46,0xd7,0x01,0xff,0x0f,0x04]

v_lshl_add_u32 v5, v1, s2, v3
// GFX10: encoding: [0x05,0x00,0x46,0xd7,0x01,0x05,0x0c,0x04]

v_lshl_add_u32 v5, v1, s101, v3
// GFX10: encoding: [0x05,0x00,0x46,0xd7,0x01,0xcb,0x0c,0x04]

v_lshl_add_u32 v5, v1, vcc_lo, v3
// GFX10: encoding: [0x05,0x00,0x46,0xd7,0x01,0xd5,0x0c,0x04]

v_lshl_add_u32 v5, v1, vcc_hi, v3
// GFX10: encoding: [0x05,0x00,0x46,0xd7,0x01,0xd7,0x0c,0x04]

v_lshl_add_u32 v5, v1, m0, v3
// GFX10: encoding: [0x05,0x00,0x46,0xd7,0x01,0xf9,0x0c,0x04]

v_lshl_add_u32 v5, v1, exec_lo, v3
// GFX10: encoding: [0x05,0x00,0x46,0xd7,0x01,0xfd,0x0c,0x04]

v_lshl_add_u32 v5, v1, exec_hi, v3
// GFX10: encoding: [0x05,0x00,0x46,0xd7,0x01,0xff,0x0c,0x04]

v_lshl_add_u32 v5, v1, 0, v3
// GFX10: encoding: [0x05,0x00,0x46,0xd7,0x01,0x01,0x0d,0x04]

v_lshl_add_u32 v5, v1, -1, v3
// GFX10: encoding: [0x05,0x00,0x46,0xd7,0x01,0x83,0x0d,0x04]

v_lshl_add_u32 v5, v1, 0.5, v3
// GFX10: encoding: [0x05,0x00,0x46,0xd7,0x01,0xe1,0x0d,0x04]

v_lshl_add_u32 v5, v1, -4.0, v3
// GFX10: encoding: [0x05,0x00,0x46,0xd7,0x01,0xef,0x0d,0x04]

v_lshl_add_u32 v5, v1, v2, v255
// GFX10: encoding: [0x05,0x00,0x46,0xd7,0x01,0x05,0xfe,0x07]

v_lshl_add_u32 v5, v1, v2, s3
// GFX10: encoding: [0x05,0x00,0x46,0xd7,0x01,0x05,0x0e,0x00]

v_lshl_add_u32 v5, v1, v2, s101
// GFX10: encoding: [0x05,0x00,0x46,0xd7,0x01,0x05,0x96,0x01]

v_lshl_add_u32 v5, v1, v2, vcc_lo
// GFX10: encoding: [0x05,0x00,0x46,0xd7,0x01,0x05,0xaa,0x01]

v_lshl_add_u32 v5, v1, v2, vcc_hi
// GFX10: encoding: [0x05,0x00,0x46,0xd7,0x01,0x05,0xae,0x01]

v_lshl_add_u32 v5, v1, v2, m0
// GFX10: encoding: [0x05,0x00,0x46,0xd7,0x01,0x05,0xf2,0x01]

v_lshl_add_u32 v5, v1, v2, exec_lo
// GFX10: encoding: [0x05,0x00,0x46,0xd7,0x01,0x05,0xfa,0x01]

v_lshl_add_u32 v5, v1, v2, exec_hi
// GFX10: encoding: [0x05,0x00,0x46,0xd7,0x01,0x05,0xfe,0x01]

v_lshl_add_u32 v5, v1, v2, 0
// GFX10: encoding: [0x05,0x00,0x46,0xd7,0x01,0x05,0x02,0x02]

v_lshl_add_u32 v5, v1, v2, -1
// GFX10: encoding: [0x05,0x00,0x46,0xd7,0x01,0x05,0x06,0x03]

v_lshl_add_u32 v5, v1, v2, 0.5
// GFX10: encoding: [0x05,0x00,0x46,0xd7,0x01,0x05,0xc2,0x03]

v_lshl_add_u32 v5, v1, v2, -4.0
// GFX10: encoding: [0x05,0x00,0x46,0xd7,0x01,0x05,0xde,0x03]

v_add_lshl_u32 v5, v1, v2, v3
// GFX10: encoding: [0x05,0x00,0x47,0xd7,0x01,0x05,0x0e,0x04]

v_add_lshl_u32 v255, v1, v2, v3
// GFX10: encoding: [0xff,0x00,0x47,0xd7,0x01,0x05,0x0e,0x04]

v_add_lshl_u32 v5, v255, v2, v3
// GFX10: encoding: [0x05,0x00,0x47,0xd7,0xff,0x05,0x0e,0x04]

v_add_lshl_u32 v5, s1, v2, v3
// GFX10: encoding: [0x05,0x00,0x47,0xd7,0x01,0x04,0x0e,0x04]

v_add_lshl_u32 v5, s101, v2, v3
// GFX10: encoding: [0x05,0x00,0x47,0xd7,0x65,0x04,0x0e,0x04]

v_add_lshl_u32 v5, vcc_lo, v2, v3
// GFX10: encoding: [0x05,0x00,0x47,0xd7,0x6a,0x04,0x0e,0x04]

v_add_lshl_u32 v5, vcc_hi, v2, v3
// GFX10: encoding: [0x05,0x00,0x47,0xd7,0x6b,0x04,0x0e,0x04]

v_add_lshl_u32 v5, m0, v2, v3
// GFX10: encoding: [0x05,0x00,0x47,0xd7,0x7c,0x04,0x0e,0x04]

v_add_lshl_u32 v5, exec_lo, v2, v3
// GFX10: encoding: [0x05,0x00,0x47,0xd7,0x7e,0x04,0x0e,0x04]

v_add_lshl_u32 v5, exec_hi, v2, v3
// GFX10: encoding: [0x05,0x00,0x47,0xd7,0x7f,0x04,0x0e,0x04]

v_add_lshl_u32 v5, 0, v2, v3
// GFX10: encoding: [0x05,0x00,0x47,0xd7,0x80,0x04,0x0e,0x04]

v_add_lshl_u32 v5, -1, v2, v3
// GFX10: encoding: [0x05,0x00,0x47,0xd7,0xc1,0x04,0x0e,0x04]

v_add_lshl_u32 v5, 0.5, v2, v3
// GFX10: encoding: [0x05,0x00,0x47,0xd7,0xf0,0x04,0x0e,0x04]

v_add_lshl_u32 v5, -4.0, v2, v3
// GFX10: encoding: [0x05,0x00,0x47,0xd7,0xf7,0x04,0x0e,0x04]

v_add_lshl_u32 v5, v1, v255, v3
// GFX10: encoding: [0x05,0x00,0x47,0xd7,0x01,0xff,0x0f,0x04]

v_add_lshl_u32 v5, v1, s2, v3
// GFX10: encoding: [0x05,0x00,0x47,0xd7,0x01,0x05,0x0c,0x04]

v_add_lshl_u32 v5, v1, s101, v3
// GFX10: encoding: [0x05,0x00,0x47,0xd7,0x01,0xcb,0x0c,0x04]

v_add_lshl_u32 v5, v1, vcc_lo, v3
// GFX10: encoding: [0x05,0x00,0x47,0xd7,0x01,0xd5,0x0c,0x04]

v_add_lshl_u32 v5, v1, vcc_hi, v3
// GFX10: encoding: [0x05,0x00,0x47,0xd7,0x01,0xd7,0x0c,0x04]

v_add_lshl_u32 v5, v1, m0, v3
// GFX10: encoding: [0x05,0x00,0x47,0xd7,0x01,0xf9,0x0c,0x04]

v_add_lshl_u32 v5, v1, exec_lo, v3
// GFX10: encoding: [0x05,0x00,0x47,0xd7,0x01,0xfd,0x0c,0x04]

v_add_lshl_u32 v5, v1, exec_hi, v3
// GFX10: encoding: [0x05,0x00,0x47,0xd7,0x01,0xff,0x0c,0x04]

v_add_lshl_u32 v5, v1, 0, v3
// GFX10: encoding: [0x05,0x00,0x47,0xd7,0x01,0x01,0x0d,0x04]

v_add_lshl_u32 v5, v1, -1, v3
// GFX10: encoding: [0x05,0x00,0x47,0xd7,0x01,0x83,0x0d,0x04]

v_add_lshl_u32 v5, v1, 0.5, v3
// GFX10: encoding: [0x05,0x00,0x47,0xd7,0x01,0xe1,0x0d,0x04]

v_add_lshl_u32 v5, v1, -4.0, v3
// GFX10: encoding: [0x05,0x00,0x47,0xd7,0x01,0xef,0x0d,0x04]

v_add_lshl_u32 v5, v1, v2, v255
// GFX10: encoding: [0x05,0x00,0x47,0xd7,0x01,0x05,0xfe,0x07]

v_add_lshl_u32 v5, v1, v2, s3
// GFX10: encoding: [0x05,0x00,0x47,0xd7,0x01,0x05,0x0e,0x00]

v_add_lshl_u32 v5, v1, v2, s101
// GFX10: encoding: [0x05,0x00,0x47,0xd7,0x01,0x05,0x96,0x01]

v_add_lshl_u32 v5, v1, v2, vcc_lo
// GFX10: encoding: [0x05,0x00,0x47,0xd7,0x01,0x05,0xaa,0x01]

v_add_lshl_u32 v5, v1, v2, vcc_hi
// GFX10: encoding: [0x05,0x00,0x47,0xd7,0x01,0x05,0xae,0x01]

v_add_lshl_u32 v5, v1, v2, m0
// GFX10: encoding: [0x05,0x00,0x47,0xd7,0x01,0x05,0xf2,0x01]

v_add_lshl_u32 v5, v1, v2, exec_lo
// GFX10: encoding: [0x05,0x00,0x47,0xd7,0x01,0x05,0xfa,0x01]

v_add_lshl_u32 v5, v1, v2, exec_hi
// GFX10: encoding: [0x05,0x00,0x47,0xd7,0x01,0x05,0xfe,0x01]

v_add_lshl_u32 v5, v1, v2, 0
// GFX10: encoding: [0x05,0x00,0x47,0xd7,0x01,0x05,0x02,0x02]

v_add_lshl_u32 v5, v1, v2, -1
// GFX10: encoding: [0x05,0x00,0x47,0xd7,0x01,0x05,0x06,0x03]

v_add_lshl_u32 v5, v1, v2, 0.5
// GFX10: encoding: [0x05,0x00,0x47,0xd7,0x01,0x05,0xc2,0x03]

v_add_lshl_u32 v5, v1, v2, -4.0
// GFX10: encoding: [0x05,0x00,0x47,0xd7,0x01,0x05,0xde,0x03]

v_fma_f16 v5, v1, v2, v3
// GFX10: encoding: [0x05,0x00,0x4b,0xd7,0x01,0x05,0x0e,0x04]

v_fma_f16 v5, v1, -v2, v3
// GFX10: encoding: [0x05,0x00,0x4b,0xd7,0x01,0x05,0x0e,0x44]

v_fma_f16 v5, v1, v2, |v3|
// GFX10: encoding: [0x05,0x04,0x4b,0xd7,0x01,0x05,0x0e,0x04]

v_fma_f16 v5, v1, v2, v3 clamp
// GFX10: encoding: [0x05,0x80,0x4b,0xd7,0x01,0x05,0x0e,0x04]

// FIXME-GFX10-V_FMA_F16: See "FIXME-GFX10-V_FMA_F16" in VOP3Instructions.td.
// v_fma_f16 v5, v1, v2, v3 op_sel:[1,0,0,0]
// FIXME-GFX10-V_FMA_F16: encoding: [0x05,0x08,0x4b,0xd7,0x01,0x05,0x0e,0x04]

// v_fma_f16 v5, v1, v2, v3 op_sel:[0,1,0,0]
// FIXME-GFX10-V_FMA_F16: encoding: [0x05,0x10,0x4b,0xd7,0x01,0x05,0x0e,0x04]

// v_fma_f16 v5, v1, v2, v3 op_sel:[1,1,1,1]
// FIXME-GFX10-V_FMA_F16: encoding: [0x05,0x78,0x4b,0xd7,0x01,0x05,0x0e,0x04]

v_min3_f16 v5, v1, v2, v3
// GFX10: encoding: [0x05,0x00,0x51,0xd7,0x01,0x05,0x0e,0x04]

v_min3_f16 v255, v1, v2, v3
// GFX10: encoding: [0xff,0x00,0x51,0xd7,0x01,0x05,0x0e,0x04]

v_min3_f16 v5, v255, v2, v3
// GFX10: encoding: [0x05,0x00,0x51,0xd7,0xff,0x05,0x0e,0x04]

v_min3_f16 v5, s1, v2, v3
// GFX10: encoding: [0x05,0x00,0x51,0xd7,0x01,0x04,0x0e,0x04]

v_min3_f16 v5, s101, v2, v3
// GFX10: encoding: [0x05,0x00,0x51,0xd7,0x65,0x04,0x0e,0x04]

v_min3_f16 v5, vcc_lo, v2, v3
// GFX10: encoding: [0x05,0x00,0x51,0xd7,0x6a,0x04,0x0e,0x04]

v_min3_f16 v5, vcc_hi, v2, v3
// GFX10: encoding: [0x05,0x00,0x51,0xd7,0x6b,0x04,0x0e,0x04]

v_min3_f16 v5, m0, v2, v3
// GFX10: encoding: [0x05,0x00,0x51,0xd7,0x7c,0x04,0x0e,0x04]

v_min3_f16 v5, exec_lo, v2, v3
// GFX10: encoding: [0x05,0x00,0x51,0xd7,0x7e,0x04,0x0e,0x04]

v_min3_f16 v5, exec_hi, v2, v3
// GFX10: encoding: [0x05,0x00,0x51,0xd7,0x7f,0x04,0x0e,0x04]

v_min3_f16 v5, 0, v2, v3
// GFX10: encoding: [0x05,0x00,0x51,0xd7,0x80,0x04,0x0e,0x04]

v_min3_f16 v5, -1, v2, v3
// GFX10: encoding: [0x05,0x00,0x51,0xd7,0xc1,0x04,0x0e,0x04]

v_min3_f16 v5, 0.5, v2, v3
// GFX10: encoding: [0x05,0x00,0x51,0xd7,0xf0,0x04,0x0e,0x04]

v_min3_f16 v5, -4.0, v2, v3
// GFX10: encoding: [0x05,0x00,0x51,0xd7,0xf7,0x04,0x0e,0x04]

v_min3_f16 v5, v1, v255, v3
// GFX10: encoding: [0x05,0x00,0x51,0xd7,0x01,0xff,0x0f,0x04]

v_min3_f16 v5, v1, s2, v3
// GFX10: encoding: [0x05,0x00,0x51,0xd7,0x01,0x05,0x0c,0x04]

v_min3_f16 v5, v1, s101, v3
// GFX10: encoding: [0x05,0x00,0x51,0xd7,0x01,0xcb,0x0c,0x04]

v_min3_f16 v5, v1, vcc_lo, v3
// GFX10: encoding: [0x05,0x00,0x51,0xd7,0x01,0xd5,0x0c,0x04]

v_min3_f16 v5, v1, vcc_hi, v3
// GFX10: encoding: [0x05,0x00,0x51,0xd7,0x01,0xd7,0x0c,0x04]

v_min3_f16 v5, v1, m0, v3
// GFX10: encoding: [0x05,0x00,0x51,0xd7,0x01,0xf9,0x0c,0x04]

v_min3_f16 v5, v1, exec_lo, v3
// GFX10: encoding: [0x05,0x00,0x51,0xd7,0x01,0xfd,0x0c,0x04]

v_min3_f16 v5, v1, exec_hi, v3
// GFX10: encoding: [0x05,0x00,0x51,0xd7,0x01,0xff,0x0c,0x04]

v_min3_f16 v5, v1, 0, v3
// GFX10: encoding: [0x05,0x00,0x51,0xd7,0x01,0x01,0x0d,0x04]

v_min3_f16 v5, v1, -1, v3
// GFX10: encoding: [0x05,0x00,0x51,0xd7,0x01,0x83,0x0d,0x04]

v_min3_f16 v5, v1, 0.5, v3
// GFX10: encoding: [0x05,0x00,0x51,0xd7,0x01,0xe1,0x0d,0x04]

v_min3_f16 v5, v1, -4.0, v3
// GFX10: encoding: [0x05,0x00,0x51,0xd7,0x01,0xef,0x0d,0x04]

v_min3_f16 v5, v1, v2, v255
// GFX10: encoding: [0x05,0x00,0x51,0xd7,0x01,0x05,0xfe,0x07]

v_min3_f16 v5, v1, v2, s3
// GFX10: encoding: [0x05,0x00,0x51,0xd7,0x01,0x05,0x0e,0x00]

v_min3_f16 v5, v1, v2, s101
// GFX10: encoding: [0x05,0x00,0x51,0xd7,0x01,0x05,0x96,0x01]

v_min3_f16 v5, v1, v2, vcc_lo
// GFX10: encoding: [0x05,0x00,0x51,0xd7,0x01,0x05,0xaa,0x01]

v_min3_f16 v5, v1, v2, vcc_hi
// GFX10: encoding: [0x05,0x00,0x51,0xd7,0x01,0x05,0xae,0x01]

v_min3_f16 v5, v1, v2, m0
// GFX10: encoding: [0x05,0x00,0x51,0xd7,0x01,0x05,0xf2,0x01]

v_min3_f16 v5, v1, v2, exec_lo
// GFX10: encoding: [0x05,0x00,0x51,0xd7,0x01,0x05,0xfa,0x01]

v_min3_f16 v5, v1, v2, exec_hi
// GFX10: encoding: [0x05,0x00,0x51,0xd7,0x01,0x05,0xfe,0x01]

v_min3_f16 v5, v1, v2, 0
// GFX10: encoding: [0x05,0x00,0x51,0xd7,0x01,0x05,0x02,0x02]

v_min3_f16 v5, v1, v2, -1
// GFX10: encoding: [0x05,0x00,0x51,0xd7,0x01,0x05,0x06,0x03]

v_min3_f16 v5, v1, v2, 0.5
// GFX10: encoding: [0x05,0x00,0x51,0xd7,0x01,0x05,0xc2,0x03]

v_min3_f16 v5, v1, v2, -4.0
// GFX10: encoding: [0x05,0x00,0x51,0xd7,0x01,0x05,0xde,0x03]

v_min3_f16 v5, -v1, v2, v3
// GFX10: encoding: [0x05,0x00,0x51,0xd7,0x01,0x05,0x0e,0x24]

v_min3_f16 v5, v1, -v2, v3
// GFX10: encoding: [0x05,0x00,0x51,0xd7,0x01,0x05,0x0e,0x44]

v_min3_f16 v5, v1, v2, -v3
// GFX10: encoding: [0x05,0x00,0x51,0xd7,0x01,0x05,0x0e,0x84]

v_min3_f16 v5, -v1, -v2, -v3
// GFX10: encoding: [0x05,0x00,0x51,0xd7,0x01,0x05,0x0e,0xe4]

v_min3_f16 v5, |v1|, v2, v3
// GFX10: encoding: [0x05,0x01,0x51,0xd7,0x01,0x05,0x0e,0x04]

v_min3_f16 v5, v1, |v2|, v3
// GFX10: encoding: [0x05,0x02,0x51,0xd7,0x01,0x05,0x0e,0x04]

v_min3_f16 v5, v1, v2, |v3|
// GFX10: encoding: [0x05,0x04,0x51,0xd7,0x01,0x05,0x0e,0x04]

v_min3_f16 v5, |v1|, |v2|, |v3|
// GFX10: encoding: [0x05,0x07,0x51,0xd7,0x01,0x05,0x0e,0x04]

v_min3_f16 v5, v1, v2, v3 op_sel:[0,0,0,0]
// GFX10: encoding: [0x05,0x00,0x51,0xd7,0x01,0x05,0x0e,0x04]

v_min3_f16 v5, v1, v2, v3 op_sel:[1,0,0,0]
// GFX10: encoding: [0x05,0x08,0x51,0xd7,0x01,0x05,0x0e,0x04]

v_min3_f16 v5, v1, v2, v3 op_sel:[0,1,0,0]
// GFX10: encoding: [0x05,0x10,0x51,0xd7,0x01,0x05,0x0e,0x04]

v_min3_f16 v5, v1, v2, v3 op_sel:[0,0,1,0]
// GFX10: encoding: [0x05,0x20,0x51,0xd7,0x01,0x05,0x0e,0x04]

v_min3_f16 v5, v1, v2, v3 op_sel:[0,0,0,1]
// GFX10: encoding: [0x05,0x40,0x51,0xd7,0x01,0x05,0x0e,0x04]

v_min3_f16 v5, v1, v2, v3 op_sel:[1,1,1,1]
// GFX10: encoding: [0x05,0x78,0x51,0xd7,0x01,0x05,0x0e,0x04]

v_min3_f16 v5, v1, v2, v3 clamp
// GFX10: encoding: [0x05,0x80,0x51,0xd7,0x01,0x05,0x0e,0x04]

v_min3_i16 v5, v1, v2, v3
// GFX10: encoding: [0x05,0x00,0x52,0xd7,0x01,0x05,0x0e,0x04]

v_min3_i16 v255, v1, v2, v3
// GFX10: encoding: [0xff,0x00,0x52,0xd7,0x01,0x05,0x0e,0x04]

v_min3_i16 v5, v255, v2, v3
// GFX10: encoding: [0x05,0x00,0x52,0xd7,0xff,0x05,0x0e,0x04]

v_min3_i16 v5, s1, v2, v3
// GFX10: encoding: [0x05,0x00,0x52,0xd7,0x01,0x04,0x0e,0x04]

v_min3_i16 v5, s101, v2, v3
// GFX10: encoding: [0x05,0x00,0x52,0xd7,0x65,0x04,0x0e,0x04]

v_min3_i16 v5, vcc_lo, v2, v3
// GFX10: encoding: [0x05,0x00,0x52,0xd7,0x6a,0x04,0x0e,0x04]

v_min3_i16 v5, vcc_hi, v2, v3
// GFX10: encoding: [0x05,0x00,0x52,0xd7,0x6b,0x04,0x0e,0x04]

v_min3_i16 v5, m0, v2, v3
// GFX10: encoding: [0x05,0x00,0x52,0xd7,0x7c,0x04,0x0e,0x04]

v_min3_i16 v5, exec_lo, v2, v3
// GFX10: encoding: [0x05,0x00,0x52,0xd7,0x7e,0x04,0x0e,0x04]

v_min3_i16 v5, exec_hi, v2, v3
// GFX10: encoding: [0x05,0x00,0x52,0xd7,0x7f,0x04,0x0e,0x04]

v_min3_i16 v5, 0, v2, v3
// GFX10: encoding: [0x05,0x00,0x52,0xd7,0x80,0x04,0x0e,0x04]

v_min3_i16 v5, -1, v2, v3
// GFX10: encoding: [0x05,0x00,0x52,0xd7,0xc1,0x04,0x0e,0x04]

v_min3_i16 v5, 0.5, v2, v3
// GFX10: encoding: [0x05,0x00,0x52,0xd7,0xff,0x04,0x0e,0x04,0x00,0x38,0x00,0x00]

v_min3_i16 v5, -4.0, v2, v3
// GFX10: encoding: [0x05,0x00,0x52,0xd7,0xff,0x04,0x0e,0x04,0x00,0xc4,0x00,0x00]

v_min3_i16 v5, v1, v255, v3
// GFX10: encoding: [0x05,0x00,0x52,0xd7,0x01,0xff,0x0f,0x04]

v_min3_i16 v5, v1, s2, v3
// GFX10: encoding: [0x05,0x00,0x52,0xd7,0x01,0x05,0x0c,0x04]

v_min3_i16 v5, v1, s101, v3
// GFX10: encoding: [0x05,0x00,0x52,0xd7,0x01,0xcb,0x0c,0x04]

v_min3_i16 v5, v1, vcc_lo, v3
// GFX10: encoding: [0x05,0x00,0x52,0xd7,0x01,0xd5,0x0c,0x04]

v_min3_i16 v5, v1, vcc_hi, v3
// GFX10: encoding: [0x05,0x00,0x52,0xd7,0x01,0xd7,0x0c,0x04]

v_min3_i16 v5, v1, m0, v3
// GFX10: encoding: [0x05,0x00,0x52,0xd7,0x01,0xf9,0x0c,0x04]

v_min3_i16 v5, v1, exec_lo, v3
// GFX10: encoding: [0x05,0x00,0x52,0xd7,0x01,0xfd,0x0c,0x04]

v_min3_i16 v5, v1, exec_hi, v3
// GFX10: encoding: [0x05,0x00,0x52,0xd7,0x01,0xff,0x0c,0x04]

v_min3_i16 v5, v1, 0, v3
// GFX10: encoding: [0x05,0x00,0x52,0xd7,0x01,0x01,0x0d,0x04]

v_min3_i16 v5, v1, -1, v3
// GFX10: encoding: [0x05,0x00,0x52,0xd7,0x01,0x83,0x0d,0x04]

v_min3_i16 v5, v1, 0.5, v3
// GFX10: encoding: [0x05,0x00,0x52,0xd7,0x01,0xff,0x0d,0x04,0x00,0x38,0x00,0x00]

v_min3_i16 v5, v1, -4.0, v3
// GFX10: encoding: [0x05,0x00,0x52,0xd7,0x01,0xff,0x0d,0x04,0x00,0xc4,0x00,0x00]

v_min3_i16 v5, v1, v2, v255
// GFX10: encoding: [0x05,0x00,0x52,0xd7,0x01,0x05,0xfe,0x07]

v_min3_i16 v5, v1, v2, s3
// GFX10: encoding: [0x05,0x00,0x52,0xd7,0x01,0x05,0x0e,0x00]

v_min3_i16 v5, v1, v2, s101
// GFX10: encoding: [0x05,0x00,0x52,0xd7,0x01,0x05,0x96,0x01]

v_min3_i16 v5, v1, v2, vcc_lo
// GFX10: encoding: [0x05,0x00,0x52,0xd7,0x01,0x05,0xaa,0x01]

v_min3_i16 v5, v1, v2, vcc_hi
// GFX10: encoding: [0x05,0x00,0x52,0xd7,0x01,0x05,0xae,0x01]

v_min3_i16 v5, v1, v2, m0
// GFX10: encoding: [0x05,0x00,0x52,0xd7,0x01,0x05,0xf2,0x01]

v_min3_i16 v5, v1, v2, exec_lo
// GFX10: encoding: [0x05,0x00,0x52,0xd7,0x01,0x05,0xfa,0x01]

v_min3_i16 v5, v1, v2, exec_hi
// GFX10: encoding: [0x05,0x00,0x52,0xd7,0x01,0x05,0xfe,0x01]

v_min3_i16 v5, v1, v2, 0
// GFX10: encoding: [0x05,0x00,0x52,0xd7,0x01,0x05,0x02,0x02]

v_min3_i16 v5, v1, v2, -1
// GFX10: encoding: [0x05,0x00,0x52,0xd7,0x01,0x05,0x06,0x03]

v_min3_i16 v5, v1, v2, 0.5
// GFX10: encoding: [0x05,0x00,0x52,0xd7,0x01,0x05,0xfe,0x03,0x00,0x38,0x00,0x00]

v_min3_i16 v5, v1, v2, -4.0
// GFX10: encoding: [0x05,0x00,0x52,0xd7,0x01,0x05,0xfe,0x03,0x00,0xc4,0x00,0x00]

v_min3_i16 v5, v1, v2, v3 op_sel:[0,0,0,0]
// GFX10: encoding: [0x05,0x00,0x52,0xd7,0x01,0x05,0x0e,0x04]

v_min3_i16 v5, v1, v2, v3 op_sel:[1,0,0,0]
// GFX10: encoding: [0x05,0x08,0x52,0xd7,0x01,0x05,0x0e,0x04]

v_min3_i16 v5, v1, v2, v3 op_sel:[0,1,0,0]
// GFX10: encoding: [0x05,0x10,0x52,0xd7,0x01,0x05,0x0e,0x04]

v_min3_i16 v5, v1, v2, v3 op_sel:[0,0,1,0]
// GFX10: encoding: [0x05,0x20,0x52,0xd7,0x01,0x05,0x0e,0x04]

v_min3_i16 v5, v1, v2, v3 op_sel:[0,0,0,1]
// GFX10: encoding: [0x05,0x40,0x52,0xd7,0x01,0x05,0x0e,0x04]

v_min3_i16 v5, v1, v2, v3 op_sel:[1,1,1,1]
// GFX10: encoding: [0x05,0x78,0x52,0xd7,0x01,0x05,0x0e,0x04]

v_min3_i16 v5, v1, v2, v3 clamp
// GFX10: encoding: [0x05,0x80,0x52,0xd7,0x01,0x05,0x0e,0x04]

v_min3_u16 v5, v1, v2, v3
// GFX10: encoding: [0x05,0x00,0x53,0xd7,0x01,0x05,0x0e,0x04]

v_min3_u16 v255, v1, v2, v3
// GFX10: encoding: [0xff,0x00,0x53,0xd7,0x01,0x05,0x0e,0x04]

v_min3_u16 v5, v255, v2, v3
// GFX10: encoding: [0x05,0x00,0x53,0xd7,0xff,0x05,0x0e,0x04]

v_min3_u16 v5, s1, v2, v3
// GFX10: encoding: [0x05,0x00,0x53,0xd7,0x01,0x04,0x0e,0x04]

v_min3_u16 v5, s101, v2, v3
// GFX10: encoding: [0x05,0x00,0x53,0xd7,0x65,0x04,0x0e,0x04]

v_min3_u16 v5, vcc_lo, v2, v3
// GFX10: encoding: [0x05,0x00,0x53,0xd7,0x6a,0x04,0x0e,0x04]

v_min3_u16 v5, vcc_hi, v2, v3
// GFX10: encoding: [0x05,0x00,0x53,0xd7,0x6b,0x04,0x0e,0x04]

v_min3_u16 v5, m0, v2, v3
// GFX10: encoding: [0x05,0x00,0x53,0xd7,0x7c,0x04,0x0e,0x04]

v_min3_u16 v5, exec_lo, v2, v3
// GFX10: encoding: [0x05,0x00,0x53,0xd7,0x7e,0x04,0x0e,0x04]

v_min3_u16 v5, exec_hi, v2, v3
// GFX10: encoding: [0x05,0x00,0x53,0xd7,0x7f,0x04,0x0e,0x04]

v_min3_u16 v5, 0, v2, v3
// GFX10: encoding: [0x05,0x00,0x53,0xd7,0x80,0x04,0x0e,0x04]

v_min3_u16 v5, -1, v2, v3
// GFX10: encoding: [0x05,0x00,0x53,0xd7,0xc1,0x04,0x0e,0x04]

v_min3_u16 v5, 0.5, v2, v3
// GFX10: encoding: [0x05,0x00,0x53,0xd7,0xff,0x04,0x0e,0x04,0x00,0x38,0x00,0x00]

v_min3_u16 v5, -4.0, v2, v3
// GFX10: encoding: [0x05,0x00,0x53,0xd7,0xff,0x04,0x0e,0x04,0x00,0xc4,0x00,0x00]

v_min3_u16 v5, v1, v255, v3
// GFX10: encoding: [0x05,0x00,0x53,0xd7,0x01,0xff,0x0f,0x04]

v_min3_u16 v5, v1, s2, v3
// GFX10: encoding: [0x05,0x00,0x53,0xd7,0x01,0x05,0x0c,0x04]

v_min3_u16 v5, v1, s101, v3
// GFX10: encoding: [0x05,0x00,0x53,0xd7,0x01,0xcb,0x0c,0x04]

v_min3_u16 v5, v1, vcc_lo, v3
// GFX10: encoding: [0x05,0x00,0x53,0xd7,0x01,0xd5,0x0c,0x04]

v_min3_u16 v5, v1, vcc_hi, v3
// GFX10: encoding: [0x05,0x00,0x53,0xd7,0x01,0xd7,0x0c,0x04]

v_min3_u16 v5, v1, m0, v3
// GFX10: encoding: [0x05,0x00,0x53,0xd7,0x01,0xf9,0x0c,0x04]

v_min3_u16 v5, v1, exec_lo, v3
// GFX10: encoding: [0x05,0x00,0x53,0xd7,0x01,0xfd,0x0c,0x04]

v_min3_u16 v5, v1, exec_hi, v3
// GFX10: encoding: [0x05,0x00,0x53,0xd7,0x01,0xff,0x0c,0x04]

v_min3_u16 v5, v1, 0, v3
// GFX10: encoding: [0x05,0x00,0x53,0xd7,0x01,0x01,0x0d,0x04]

v_min3_u16 v5, v1, -1, v3
// GFX10: encoding: [0x05,0x00,0x53,0xd7,0x01,0x83,0x0d,0x04]

v_min3_u16 v5, v1, 0.5, v3
// GFX10: encoding: [0x05,0x00,0x53,0xd7,0x01,0xff,0x0d,0x04,0x00,0x38,0x00,0x00]

v_min3_u16 v5, v1, -4.0, v3
// GFX10: encoding: [0x05,0x00,0x53,0xd7,0x01,0xff,0x0d,0x04,0x00,0xc4,0x00,0x00]

v_min3_u16 v5, v1, v2, v255
// GFX10: encoding: [0x05,0x00,0x53,0xd7,0x01,0x05,0xfe,0x07]

v_min3_u16 v5, v1, v2, s3
// GFX10: encoding: [0x05,0x00,0x53,0xd7,0x01,0x05,0x0e,0x00]

v_min3_u16 v5, v1, v2, s101
// GFX10: encoding: [0x05,0x00,0x53,0xd7,0x01,0x05,0x96,0x01]

v_min3_u16 v5, v1, v2, vcc_lo
// GFX10: encoding: [0x05,0x00,0x53,0xd7,0x01,0x05,0xaa,0x01]

v_min3_u16 v5, v1, v2, vcc_hi
// GFX10: encoding: [0x05,0x00,0x53,0xd7,0x01,0x05,0xae,0x01]

v_min3_u16 v5, v1, v2, m0
// GFX10: encoding: [0x05,0x00,0x53,0xd7,0x01,0x05,0xf2,0x01]

v_min3_u16 v5, v1, v2, exec_lo
// GFX10: encoding: [0x05,0x00,0x53,0xd7,0x01,0x05,0xfa,0x01]

v_min3_u16 v5, v1, v2, exec_hi
// GFX10: encoding: [0x05,0x00,0x53,0xd7,0x01,0x05,0xfe,0x01]

v_min3_u16 v5, v1, v2, 0
// GFX10: encoding: [0x05,0x00,0x53,0xd7,0x01,0x05,0x02,0x02]

v_min3_u16 v5, v1, v2, -1
// GFX10: encoding: [0x05,0x00,0x53,0xd7,0x01,0x05,0x06,0x03]

v_min3_u16 v5, v1, v2, 0.5
// GFX10: encoding: [0x05,0x00,0x53,0xd7,0x01,0x05,0xfe,0x03,0x00,0x38,0x00,0x00]

v_min3_u16 v5, v1, v2, -4.0
// GFX10: encoding: [0x05,0x00,0x53,0xd7,0x01,0x05,0xfe,0x03,0x00,0xc4,0x00,0x00]

v_min3_u16 v5, v1, v2, v3 op_sel:[0,0,0,0]
// GFX10: encoding: [0x05,0x00,0x53,0xd7,0x01,0x05,0x0e,0x04]

v_min3_u16 v5, v1, v2, v3 op_sel:[1,0,0,0]
// GFX10: encoding: [0x05,0x08,0x53,0xd7,0x01,0x05,0x0e,0x04]

v_min3_u16 v5, v1, v2, v3 op_sel:[0,1,0,0]
// GFX10: encoding: [0x05,0x10,0x53,0xd7,0x01,0x05,0x0e,0x04]

v_min3_u16 v5, v1, v2, v3 op_sel:[0,0,1,0]
// GFX10: encoding: [0x05,0x20,0x53,0xd7,0x01,0x05,0x0e,0x04]

v_min3_u16 v5, v1, v2, v3 op_sel:[0,0,0,1]
// GFX10: encoding: [0x05,0x40,0x53,0xd7,0x01,0x05,0x0e,0x04]

v_min3_u16 v5, v1, v2, v3 op_sel:[1,1,1,1]
// GFX10: encoding: [0x05,0x78,0x53,0xd7,0x01,0x05,0x0e,0x04]

v_min3_u16 v5, v1, v2, v3 clamp
// GFX10: encoding: [0x05,0x80,0x53,0xd7,0x01,0x05,0x0e,0x04]

v_max3_f16 v5, v1, v2, v3
// GFX10: encoding: [0x05,0x00,0x54,0xd7,0x01,0x05,0x0e,0x04]

v_max3_f16 v255, v1, v2, v3
// GFX10: encoding: [0xff,0x00,0x54,0xd7,0x01,0x05,0x0e,0x04]

v_max3_f16 v5, v255, v2, v3
// GFX10: encoding: [0x05,0x00,0x54,0xd7,0xff,0x05,0x0e,0x04]

v_max3_f16 v5, s1, v2, v3
// GFX10: encoding: [0x05,0x00,0x54,0xd7,0x01,0x04,0x0e,0x04]

v_max3_f16 v5, s101, v2, v3
// GFX10: encoding: [0x05,0x00,0x54,0xd7,0x65,0x04,0x0e,0x04]

v_max3_f16 v5, vcc_lo, v2, v3
// GFX10: encoding: [0x05,0x00,0x54,0xd7,0x6a,0x04,0x0e,0x04]

v_max3_f16 v5, vcc_hi, v2, v3
// GFX10: encoding: [0x05,0x00,0x54,0xd7,0x6b,0x04,0x0e,0x04]

v_max3_f16 v5, m0, v2, v3
// GFX10: encoding: [0x05,0x00,0x54,0xd7,0x7c,0x04,0x0e,0x04]

v_max3_f16 v5, exec_lo, v2, v3
// GFX10: encoding: [0x05,0x00,0x54,0xd7,0x7e,0x04,0x0e,0x04]

v_max3_f16 v5, exec_hi, v2, v3
// GFX10: encoding: [0x05,0x00,0x54,0xd7,0x7f,0x04,0x0e,0x04]

v_max3_f16 v5, 0, v2, v3
// GFX10: encoding: [0x05,0x00,0x54,0xd7,0x80,0x04,0x0e,0x04]

v_max3_f16 v5, -1, v2, v3
// GFX10: encoding: [0x05,0x00,0x54,0xd7,0xc1,0x04,0x0e,0x04]

v_max3_f16 v5, 0.5, v2, v3
// GFX10: encoding: [0x05,0x00,0x54,0xd7,0xf0,0x04,0x0e,0x04]

v_max3_f16 v5, -4.0, v2, v3
// GFX10: encoding: [0x05,0x00,0x54,0xd7,0xf7,0x04,0x0e,0x04]

v_max3_f16 v5, v1, v255, v3
// GFX10: encoding: [0x05,0x00,0x54,0xd7,0x01,0xff,0x0f,0x04]

v_max3_f16 v5, v1, s2, v3
// GFX10: encoding: [0x05,0x00,0x54,0xd7,0x01,0x05,0x0c,0x04]

v_max3_f16 v5, v1, s101, v3
// GFX10: encoding: [0x05,0x00,0x54,0xd7,0x01,0xcb,0x0c,0x04]

v_max3_f16 v5, v1, vcc_lo, v3
// GFX10: encoding: [0x05,0x00,0x54,0xd7,0x01,0xd5,0x0c,0x04]

v_max3_f16 v5, v1, vcc_hi, v3
// GFX10: encoding: [0x05,0x00,0x54,0xd7,0x01,0xd7,0x0c,0x04]

v_max3_f16 v5, v1, m0, v3
// GFX10: encoding: [0x05,0x00,0x54,0xd7,0x01,0xf9,0x0c,0x04]

v_max3_f16 v5, v1, exec_lo, v3
// GFX10: encoding: [0x05,0x00,0x54,0xd7,0x01,0xfd,0x0c,0x04]

v_max3_f16 v5, v1, exec_hi, v3
// GFX10: encoding: [0x05,0x00,0x54,0xd7,0x01,0xff,0x0c,0x04]

v_max3_f16 v5, v1, 0, v3
// GFX10: encoding: [0x05,0x00,0x54,0xd7,0x01,0x01,0x0d,0x04]

v_max3_f16 v5, v1, -1, v3
// GFX10: encoding: [0x05,0x00,0x54,0xd7,0x01,0x83,0x0d,0x04]

v_max3_f16 v5, v1, 0.5, v3
// GFX10: encoding: [0x05,0x00,0x54,0xd7,0x01,0xe1,0x0d,0x04]

v_max3_f16 v5, v1, -4.0, v3
// GFX10: encoding: [0x05,0x00,0x54,0xd7,0x01,0xef,0x0d,0x04]

v_max3_f16 v5, v1, v2, v255
// GFX10: encoding: [0x05,0x00,0x54,0xd7,0x01,0x05,0xfe,0x07]

v_max3_f16 v5, v1, v2, s3
// GFX10: encoding: [0x05,0x00,0x54,0xd7,0x01,0x05,0x0e,0x00]

v_max3_f16 v5, v1, v2, s101
// GFX10: encoding: [0x05,0x00,0x54,0xd7,0x01,0x05,0x96,0x01]

v_max3_f16 v5, v1, v2, vcc_lo
// GFX10: encoding: [0x05,0x00,0x54,0xd7,0x01,0x05,0xaa,0x01]

v_max3_f16 v5, v1, v2, vcc_hi
// GFX10: encoding: [0x05,0x00,0x54,0xd7,0x01,0x05,0xae,0x01]

v_max3_f16 v5, v1, v2, m0
// GFX10: encoding: [0x05,0x00,0x54,0xd7,0x01,0x05,0xf2,0x01]

v_max3_f16 v5, v1, v2, exec_lo
// GFX10: encoding: [0x05,0x00,0x54,0xd7,0x01,0x05,0xfa,0x01]

v_max3_f16 v5, v1, v2, exec_hi
// GFX10: encoding: [0x05,0x00,0x54,0xd7,0x01,0x05,0xfe,0x01]

v_max3_f16 v5, v1, v2, 0
// GFX10: encoding: [0x05,0x00,0x54,0xd7,0x01,0x05,0x02,0x02]

v_max3_f16 v5, v1, v2, -1
// GFX10: encoding: [0x05,0x00,0x54,0xd7,0x01,0x05,0x06,0x03]

v_max3_f16 v5, v1, v2, 0.5
// GFX10: encoding: [0x05,0x00,0x54,0xd7,0x01,0x05,0xc2,0x03]

v_max3_f16 v5, v1, v2, -4.0
// GFX10: encoding: [0x05,0x00,0x54,0xd7,0x01,0x05,0xde,0x03]

v_max3_f16 v5, -v1, v2, v3
// GFX10: encoding: [0x05,0x00,0x54,0xd7,0x01,0x05,0x0e,0x24]

v_max3_f16 v5, v1, -v2, v3
// GFX10: encoding: [0x05,0x00,0x54,0xd7,0x01,0x05,0x0e,0x44]

v_max3_f16 v5, v1, v2, -v3
// GFX10: encoding: [0x05,0x00,0x54,0xd7,0x01,0x05,0x0e,0x84]

v_max3_f16 v5, -v1, -v2, -v3
// GFX10: encoding: [0x05,0x00,0x54,0xd7,0x01,0x05,0x0e,0xe4]

v_max3_f16 v5, |v1|, v2, v3
// GFX10: encoding: [0x05,0x01,0x54,0xd7,0x01,0x05,0x0e,0x04]

v_max3_f16 v5, v1, |v2|, v3
// GFX10: encoding: [0x05,0x02,0x54,0xd7,0x01,0x05,0x0e,0x04]

v_max3_f16 v5, v1, v2, |v3|
// GFX10: encoding: [0x05,0x04,0x54,0xd7,0x01,0x05,0x0e,0x04]

v_max3_f16 v5, |v1|, |v2|, |v3|
// GFX10: encoding: [0x05,0x07,0x54,0xd7,0x01,0x05,0x0e,0x04]

v_max3_f16 v5, v1, v2, v3 op_sel:[0,0,0,0]
// GFX10: encoding: [0x05,0x00,0x54,0xd7,0x01,0x05,0x0e,0x04]

v_max3_f16 v5, v1, v2, v3 op_sel:[1,0,0,0]
// GFX10: encoding: [0x05,0x08,0x54,0xd7,0x01,0x05,0x0e,0x04]

v_max3_f16 v5, v1, v2, v3 op_sel:[0,1,0,0]
// GFX10: encoding: [0x05,0x10,0x54,0xd7,0x01,0x05,0x0e,0x04]

v_max3_f16 v5, v1, v2, v3 op_sel:[0,0,1,0]
// GFX10: encoding: [0x05,0x20,0x54,0xd7,0x01,0x05,0x0e,0x04]

v_max3_f16 v5, v1, v2, v3 op_sel:[0,0,0,1]
// GFX10: encoding: [0x05,0x40,0x54,0xd7,0x01,0x05,0x0e,0x04]

v_max3_f16 v5, v1, v2, v3 op_sel:[1,1,1,1]
// GFX10: encoding: [0x05,0x78,0x54,0xd7,0x01,0x05,0x0e,0x04]

v_max3_f16 v5, v1, v2, v3 clamp
// GFX10: encoding: [0x05,0x80,0x54,0xd7,0x01,0x05,0x0e,0x04]

v_max3_i16 v5, v1, v2, v3
// GFX10: encoding: [0x05,0x00,0x55,0xd7,0x01,0x05,0x0e,0x04]

v_max3_i16 v255, v1, v2, v3
// GFX10: encoding: [0xff,0x00,0x55,0xd7,0x01,0x05,0x0e,0x04]

v_max3_i16 v5, v255, v2, v3
// GFX10: encoding: [0x05,0x00,0x55,0xd7,0xff,0x05,0x0e,0x04]

v_max3_i16 v5, s1, v2, v3
// GFX10: encoding: [0x05,0x00,0x55,0xd7,0x01,0x04,0x0e,0x04]

v_max3_i16 v5, s101, v2, v3
// GFX10: encoding: [0x05,0x00,0x55,0xd7,0x65,0x04,0x0e,0x04]

v_max3_i16 v5, vcc_lo, v2, v3
// GFX10: encoding: [0x05,0x00,0x55,0xd7,0x6a,0x04,0x0e,0x04]

v_max3_i16 v5, vcc_hi, v2, v3
// GFX10: encoding: [0x05,0x00,0x55,0xd7,0x6b,0x04,0x0e,0x04]

v_max3_i16 v5, m0, v2, v3
// GFX10: encoding: [0x05,0x00,0x55,0xd7,0x7c,0x04,0x0e,0x04]

v_max3_i16 v5, exec_lo, v2, v3
// GFX10: encoding: [0x05,0x00,0x55,0xd7,0x7e,0x04,0x0e,0x04]

v_max3_i16 v5, exec_hi, v2, v3
// GFX10: encoding: [0x05,0x00,0x55,0xd7,0x7f,0x04,0x0e,0x04]

v_max3_i16 v5, 0, v2, v3
// GFX10: encoding: [0x05,0x00,0x55,0xd7,0x80,0x04,0x0e,0x04]

v_max3_i16 v5, -1, v2, v3
// GFX10: encoding: [0x05,0x00,0x55,0xd7,0xc1,0x04,0x0e,0x04]

v_max3_i16 v5, 0.5, v2, v3
// GFX10: encoding: [0x05,0x00,0x55,0xd7,0xff,0x04,0x0e,0x04,0x00,0x38,0x00,0x00]

v_max3_i16 v5, -4.0, v2, v3
// GFX10: encoding: [0x05,0x00,0x55,0xd7,0xff,0x04,0x0e,0x04,0x00,0xc4,0x00,0x00]

v_max3_i16 v5, v1, v255, v3
// GFX10: encoding: [0x05,0x00,0x55,0xd7,0x01,0xff,0x0f,0x04]

v_max3_i16 v5, v1, s2, v3
// GFX10: encoding: [0x05,0x00,0x55,0xd7,0x01,0x05,0x0c,0x04]

v_max3_i16 v5, v1, s101, v3
// GFX10: encoding: [0x05,0x00,0x55,0xd7,0x01,0xcb,0x0c,0x04]

v_max3_i16 v5, v1, vcc_lo, v3
// GFX10: encoding: [0x05,0x00,0x55,0xd7,0x01,0xd5,0x0c,0x04]

v_max3_i16 v5, v1, vcc_hi, v3
// GFX10: encoding: [0x05,0x00,0x55,0xd7,0x01,0xd7,0x0c,0x04]

v_max3_i16 v5, v1, m0, v3
// GFX10: encoding: [0x05,0x00,0x55,0xd7,0x01,0xf9,0x0c,0x04]

v_max3_i16 v5, v1, exec_lo, v3
// GFX10: encoding: [0x05,0x00,0x55,0xd7,0x01,0xfd,0x0c,0x04]

v_max3_i16 v5, v1, exec_hi, v3
// GFX10: encoding: [0x05,0x00,0x55,0xd7,0x01,0xff,0x0c,0x04]

v_max3_i16 v5, v1, 0, v3
// GFX10: encoding: [0x05,0x00,0x55,0xd7,0x01,0x01,0x0d,0x04]

v_max3_i16 v5, v1, -1, v3
// GFX10: encoding: [0x05,0x00,0x55,0xd7,0x01,0x83,0x0d,0x04]

v_max3_i16 v5, v1, 0.5, v3
// GFX10: encoding: [0x05,0x00,0x55,0xd7,0x01,0xff,0x0d,0x04,0x00,0x38,0x00,0x00]

v_max3_i16 v5, v1, -4.0, v3
// GFX10: encoding: [0x05,0x00,0x55,0xd7,0x01,0xff,0x0d,0x04,0x00,0xc4,0x00,0x00]

v_max3_i16 v5, v1, v2, v255
// GFX10: encoding: [0x05,0x00,0x55,0xd7,0x01,0x05,0xfe,0x07]

v_max3_i16 v5, v1, v2, s3
// GFX10: encoding: [0x05,0x00,0x55,0xd7,0x01,0x05,0x0e,0x00]

v_max3_i16 v5, v1, v2, s101
// GFX10: encoding: [0x05,0x00,0x55,0xd7,0x01,0x05,0x96,0x01]

v_max3_i16 v5, v1, v2, vcc_lo
// GFX10: encoding: [0x05,0x00,0x55,0xd7,0x01,0x05,0xaa,0x01]

v_max3_i16 v5, v1, v2, vcc_hi
// GFX10: encoding: [0x05,0x00,0x55,0xd7,0x01,0x05,0xae,0x01]

v_max3_i16 v5, v1, v2, m0
// GFX10: encoding: [0x05,0x00,0x55,0xd7,0x01,0x05,0xf2,0x01]

v_max3_i16 v5, v1, v2, exec_lo
// GFX10: encoding: [0x05,0x00,0x55,0xd7,0x01,0x05,0xfa,0x01]

v_max3_i16 v5, v1, v2, exec_hi
// GFX10: encoding: [0x05,0x00,0x55,0xd7,0x01,0x05,0xfe,0x01]

v_max3_i16 v5, v1, v2, 0
// GFX10: encoding: [0x05,0x00,0x55,0xd7,0x01,0x05,0x02,0x02]

v_max3_i16 v5, v1, v2, -1
// GFX10: encoding: [0x05,0x00,0x55,0xd7,0x01,0x05,0x06,0x03]

v_max3_i16 v5, v1, v2, 0.5
// GFX10: encoding: [0x05,0x00,0x55,0xd7,0x01,0x05,0xfe,0x03,0x00,0x38,0x00,0x00]

v_max3_i16 v5, v1, v2, -4.0
// GFX10: encoding: [0x05,0x00,0x55,0xd7,0x01,0x05,0xfe,0x03,0x00,0xc4,0x00,0x00]

v_max3_i16 v5, v1, v2, v3 op_sel:[0,0,0,0]
// GFX10: encoding: [0x05,0x00,0x55,0xd7,0x01,0x05,0x0e,0x04]

v_max3_i16 v5, v1, v2, v3 op_sel:[1,0,0,0]
// GFX10: encoding: [0x05,0x08,0x55,0xd7,0x01,0x05,0x0e,0x04]

v_max3_i16 v5, v1, v2, v3 op_sel:[0,1,0,0]
// GFX10: encoding: [0x05,0x10,0x55,0xd7,0x01,0x05,0x0e,0x04]

v_max3_i16 v5, v1, v2, v3 op_sel:[0,0,1,0]
// GFX10: encoding: [0x05,0x20,0x55,0xd7,0x01,0x05,0x0e,0x04]

v_max3_i16 v5, v1, v2, v3 op_sel:[0,0,0,1]
// GFX10: encoding: [0x05,0x40,0x55,0xd7,0x01,0x05,0x0e,0x04]

v_max3_i16 v5, v1, v2, v3 op_sel:[1,1,1,1]
// GFX10: encoding: [0x05,0x78,0x55,0xd7,0x01,0x05,0x0e,0x04]

v_max3_i16 v5, v1, v2, v3 clamp
// GFX10: encoding: [0x05,0x80,0x55,0xd7,0x01,0x05,0x0e,0x04]

v_max3_u16 v5, v1, v2, v3
// GFX10: encoding: [0x05,0x00,0x56,0xd7,0x01,0x05,0x0e,0x04]

v_max3_u16 v255, v1, v2, v3
// GFX10: encoding: [0xff,0x00,0x56,0xd7,0x01,0x05,0x0e,0x04]

v_max3_u16 v5, v255, v2, v3
// GFX10: encoding: [0x05,0x00,0x56,0xd7,0xff,0x05,0x0e,0x04]

v_max3_u16 v5, s1, v2, v3
// GFX10: encoding: [0x05,0x00,0x56,0xd7,0x01,0x04,0x0e,0x04]

v_max3_u16 v5, s101, v2, v3
// GFX10: encoding: [0x05,0x00,0x56,0xd7,0x65,0x04,0x0e,0x04]

v_max3_u16 v5, vcc_lo, v2, v3
// GFX10: encoding: [0x05,0x00,0x56,0xd7,0x6a,0x04,0x0e,0x04]

v_max3_u16 v5, vcc_hi, v2, v3
// GFX10: encoding: [0x05,0x00,0x56,0xd7,0x6b,0x04,0x0e,0x04]

v_max3_u16 v5, m0, v2, v3
// GFX10: encoding: [0x05,0x00,0x56,0xd7,0x7c,0x04,0x0e,0x04]

v_max3_u16 v5, exec_lo, v2, v3
// GFX10: encoding: [0x05,0x00,0x56,0xd7,0x7e,0x04,0x0e,0x04]

v_max3_u16 v5, exec_hi, v2, v3
// GFX10: encoding: [0x05,0x00,0x56,0xd7,0x7f,0x04,0x0e,0x04]

v_max3_u16 v5, 0, v2, v3
// GFX10: encoding: [0x05,0x00,0x56,0xd7,0x80,0x04,0x0e,0x04]

v_max3_u16 v5, -1, v2, v3
// GFX10: encoding: [0x05,0x00,0x56,0xd7,0xc1,0x04,0x0e,0x04]

v_max3_u16 v5, 0.5, v2, v3
// GFX10: encoding: [0x05,0x00,0x56,0xd7,0xff,0x04,0x0e,0x04,0x00,0x38,0x00,0x00]

v_max3_u16 v5, -4.0, v2, v3
// GFX10: encoding: [0x05,0x00,0x56,0xd7,0xff,0x04,0x0e,0x04,0x00,0xc4,0x00,0x00]

v_max3_u16 v5, v1, v255, v3
// GFX10: encoding: [0x05,0x00,0x56,0xd7,0x01,0xff,0x0f,0x04]

v_max3_u16 v5, v1, s2, v3
// GFX10: encoding: [0x05,0x00,0x56,0xd7,0x01,0x05,0x0c,0x04]

v_max3_u16 v5, v1, s101, v3
// GFX10: encoding: [0x05,0x00,0x56,0xd7,0x01,0xcb,0x0c,0x04]

v_max3_u16 v5, v1, vcc_lo, v3
// GFX10: encoding: [0x05,0x00,0x56,0xd7,0x01,0xd5,0x0c,0x04]

v_max3_u16 v5, v1, vcc_hi, v3
// GFX10: encoding: [0x05,0x00,0x56,0xd7,0x01,0xd7,0x0c,0x04]

v_max3_u16 v5, v1, m0, v3
// GFX10: encoding: [0x05,0x00,0x56,0xd7,0x01,0xf9,0x0c,0x04]

v_max3_u16 v5, v1, exec_lo, v3
// GFX10: encoding: [0x05,0x00,0x56,0xd7,0x01,0xfd,0x0c,0x04]

v_max3_u16 v5, v1, exec_hi, v3
// GFX10: encoding: [0x05,0x00,0x56,0xd7,0x01,0xff,0x0c,0x04]

v_max3_u16 v5, v1, 0, v3
// GFX10: encoding: [0x05,0x00,0x56,0xd7,0x01,0x01,0x0d,0x04]

v_max3_u16 v5, v1, -1, v3
// GFX10: encoding: [0x05,0x00,0x56,0xd7,0x01,0x83,0x0d,0x04]

v_max3_u16 v5, v1, 0.5, v3
// GFX10: encoding: [0x05,0x00,0x56,0xd7,0x01,0xff,0x0d,0x04,0x00,0x38,0x00,0x00]

v_max3_u16 v5, v1, -4.0, v3
// GFX10: encoding: [0x05,0x00,0x56,0xd7,0x01,0xff,0x0d,0x04,0x00,0xc4,0x00,0x00]

v_max3_u16 v5, v1, v2, v255
// GFX10: encoding: [0x05,0x00,0x56,0xd7,0x01,0x05,0xfe,0x07]

v_max3_u16 v5, v1, v2, s3
// GFX10: encoding: [0x05,0x00,0x56,0xd7,0x01,0x05,0x0e,0x00]

v_max3_u16 v5, v1, v2, s101
// GFX10: encoding: [0x05,0x00,0x56,0xd7,0x01,0x05,0x96,0x01]

v_max3_u16 v5, v1, v2, vcc_lo
// GFX10: encoding: [0x05,0x00,0x56,0xd7,0x01,0x05,0xaa,0x01]

v_max3_u16 v5, v1, v2, vcc_hi
// GFX10: encoding: [0x05,0x00,0x56,0xd7,0x01,0x05,0xae,0x01]

v_max3_u16 v5, v1, v2, m0
// GFX10: encoding: [0x05,0x00,0x56,0xd7,0x01,0x05,0xf2,0x01]

v_max3_u16 v5, v1, v2, exec_lo
// GFX10: encoding: [0x05,0x00,0x56,0xd7,0x01,0x05,0xfa,0x01]

v_max3_u16 v5, v1, v2, exec_hi
// GFX10: encoding: [0x05,0x00,0x56,0xd7,0x01,0x05,0xfe,0x01]

v_max3_u16 v5, v1, v2, 0
// GFX10: encoding: [0x05,0x00,0x56,0xd7,0x01,0x05,0x02,0x02]

v_max3_u16 v5, v1, v2, -1
// GFX10: encoding: [0x05,0x00,0x56,0xd7,0x01,0x05,0x06,0x03]

v_max3_u16 v5, v1, v2, 0.5
// GFX10: encoding: [0x05,0x00,0x56,0xd7,0x01,0x05,0xfe,0x03,0x00,0x38,0x00,0x00]

v_max3_u16 v5, v1, v2, -4.0
// GFX10: encoding: [0x05,0x00,0x56,0xd7,0x01,0x05,0xfe,0x03,0x00,0xc4,0x00,0x00]

v_max3_u16 v5, v1, v2, v3 op_sel:[0,0,0,0]
// GFX10: encoding: [0x05,0x00,0x56,0xd7,0x01,0x05,0x0e,0x04]

v_max3_u16 v5, v1, v2, v3 op_sel:[1,0,0,0]
// GFX10: encoding: [0x05,0x08,0x56,0xd7,0x01,0x05,0x0e,0x04]

v_max3_u16 v5, v1, v2, v3 op_sel:[0,1,0,0]
// GFX10: encoding: [0x05,0x10,0x56,0xd7,0x01,0x05,0x0e,0x04]

v_max3_u16 v5, v1, v2, v3 op_sel:[0,0,1,0]
// GFX10: encoding: [0x05,0x20,0x56,0xd7,0x01,0x05,0x0e,0x04]

v_max3_u16 v5, v1, v2, v3 op_sel:[0,0,0,1]
// GFX10: encoding: [0x05,0x40,0x56,0xd7,0x01,0x05,0x0e,0x04]

v_max3_u16 v5, v1, v2, v3 op_sel:[1,1,1,1]
// GFX10: encoding: [0x05,0x78,0x56,0xd7,0x01,0x05,0x0e,0x04]

v_max3_u16 v5, v1, v2, v3 clamp
// GFX10: encoding: [0x05,0x80,0x56,0xd7,0x01,0x05,0x0e,0x04]

v_med3_f16 v5, v1, v2, v3
// GFX10: encoding: [0x05,0x00,0x57,0xd7,0x01,0x05,0x0e,0x04]

v_med3_f16 v255, v1, v2, v3
// GFX10: encoding: [0xff,0x00,0x57,0xd7,0x01,0x05,0x0e,0x04]

v_med3_f16 v5, v255, v2, v3
// GFX10: encoding: [0x05,0x00,0x57,0xd7,0xff,0x05,0x0e,0x04]

v_med3_f16 v5, s1, v2, v3
// GFX10: encoding: [0x05,0x00,0x57,0xd7,0x01,0x04,0x0e,0x04]

v_med3_f16 v5, s101, v2, v3
// GFX10: encoding: [0x05,0x00,0x57,0xd7,0x65,0x04,0x0e,0x04]

v_med3_f16 v5, vcc_lo, v2, v3
// GFX10: encoding: [0x05,0x00,0x57,0xd7,0x6a,0x04,0x0e,0x04]

v_med3_f16 v5, vcc_hi, v2, v3
// GFX10: encoding: [0x05,0x00,0x57,0xd7,0x6b,0x04,0x0e,0x04]

v_med3_f16 v5, m0, v2, v3
// GFX10: encoding: [0x05,0x00,0x57,0xd7,0x7c,0x04,0x0e,0x04]

v_med3_f16 v5, exec_lo, v2, v3
// GFX10: encoding: [0x05,0x00,0x57,0xd7,0x7e,0x04,0x0e,0x04]

v_med3_f16 v5, exec_hi, v2, v3
// GFX10: encoding: [0x05,0x00,0x57,0xd7,0x7f,0x04,0x0e,0x04]

v_med3_f16 v5, 0, v2, v3
// GFX10: encoding: [0x05,0x00,0x57,0xd7,0x80,0x04,0x0e,0x04]

v_med3_f16 v5, -1, v2, v3
// GFX10: encoding: [0x05,0x00,0x57,0xd7,0xc1,0x04,0x0e,0x04]

v_med3_f16 v5, 0.5, v2, v3
// GFX10: encoding: [0x05,0x00,0x57,0xd7,0xf0,0x04,0x0e,0x04]

v_med3_f16 v5, -4.0, v2, v3
// GFX10: encoding: [0x05,0x00,0x57,0xd7,0xf7,0x04,0x0e,0x04]

v_med3_f16 v5, v1, v255, v3
// GFX10: encoding: [0x05,0x00,0x57,0xd7,0x01,0xff,0x0f,0x04]

v_med3_f16 v5, v1, s2, v3
// GFX10: encoding: [0x05,0x00,0x57,0xd7,0x01,0x05,0x0c,0x04]

v_med3_f16 v5, v1, s101, v3
// GFX10: encoding: [0x05,0x00,0x57,0xd7,0x01,0xcb,0x0c,0x04]

v_med3_f16 v5, v1, vcc_lo, v3
// GFX10: encoding: [0x05,0x00,0x57,0xd7,0x01,0xd5,0x0c,0x04]

v_med3_f16 v5, v1, vcc_hi, v3
// GFX10: encoding: [0x05,0x00,0x57,0xd7,0x01,0xd7,0x0c,0x04]

v_med3_f16 v5, v1, m0, v3
// GFX10: encoding: [0x05,0x00,0x57,0xd7,0x01,0xf9,0x0c,0x04]

v_med3_f16 v5, v1, exec_lo, v3
// GFX10: encoding: [0x05,0x00,0x57,0xd7,0x01,0xfd,0x0c,0x04]

v_med3_f16 v5, v1, exec_hi, v3
// GFX10: encoding: [0x05,0x00,0x57,0xd7,0x01,0xff,0x0c,0x04]

v_med3_f16 v5, v1, 0, v3
// GFX10: encoding: [0x05,0x00,0x57,0xd7,0x01,0x01,0x0d,0x04]

v_med3_f16 v5, v1, -1, v3
// GFX10: encoding: [0x05,0x00,0x57,0xd7,0x01,0x83,0x0d,0x04]

v_med3_f16 v5, v1, 0.5, v3
// GFX10: encoding: [0x05,0x00,0x57,0xd7,0x01,0xe1,0x0d,0x04]

v_med3_f16 v5, v1, -4.0, v3
// GFX10: encoding: [0x05,0x00,0x57,0xd7,0x01,0xef,0x0d,0x04]

v_med3_f16 v5, v1, v2, v255
// GFX10: encoding: [0x05,0x00,0x57,0xd7,0x01,0x05,0xfe,0x07]

v_med3_f16 v5, v1, v2, s3
// GFX10: encoding: [0x05,0x00,0x57,0xd7,0x01,0x05,0x0e,0x00]

v_med3_f16 v5, v1, v2, s101
// GFX10: encoding: [0x05,0x00,0x57,0xd7,0x01,0x05,0x96,0x01]

v_med3_f16 v5, v1, v2, vcc_lo
// GFX10: encoding: [0x05,0x00,0x57,0xd7,0x01,0x05,0xaa,0x01]

v_med3_f16 v5, v1, v2, vcc_hi
// GFX10: encoding: [0x05,0x00,0x57,0xd7,0x01,0x05,0xae,0x01]

v_med3_f16 v5, v1, v2, m0
// GFX10: encoding: [0x05,0x00,0x57,0xd7,0x01,0x05,0xf2,0x01]

v_med3_f16 v5, v1, v2, exec_lo
// GFX10: encoding: [0x05,0x00,0x57,0xd7,0x01,0x05,0xfa,0x01]

v_med3_f16 v5, v1, v2, exec_hi
// GFX10: encoding: [0x05,0x00,0x57,0xd7,0x01,0x05,0xfe,0x01]

v_med3_f16 v5, v1, v2, 0
// GFX10: encoding: [0x05,0x00,0x57,0xd7,0x01,0x05,0x02,0x02]

v_med3_f16 v5, v1, v2, -1
// GFX10: encoding: [0x05,0x00,0x57,0xd7,0x01,0x05,0x06,0x03]

v_med3_f16 v5, v1, v2, 0.5
// GFX10: encoding: [0x05,0x00,0x57,0xd7,0x01,0x05,0xc2,0x03]

v_med3_f16 v5, v1, v2, -4.0
// GFX10: encoding: [0x05,0x00,0x57,0xd7,0x01,0x05,0xde,0x03]

v_med3_f16 v5, -v1, v2, v3
// GFX10: encoding: [0x05,0x00,0x57,0xd7,0x01,0x05,0x0e,0x24]

v_med3_f16 v5, v1, -v2, v3
// GFX10: encoding: [0x05,0x00,0x57,0xd7,0x01,0x05,0x0e,0x44]

v_med3_f16 v5, v1, v2, -v3
// GFX10: encoding: [0x05,0x00,0x57,0xd7,0x01,0x05,0x0e,0x84]

v_med3_f16 v5, -v1, -v2, -v3
// GFX10: encoding: [0x05,0x00,0x57,0xd7,0x01,0x05,0x0e,0xe4]

v_med3_f16 v5, |v1|, v2, v3
// GFX10: encoding: [0x05,0x01,0x57,0xd7,0x01,0x05,0x0e,0x04]

v_med3_f16 v5, v1, |v2|, v3
// GFX10: encoding: [0x05,0x02,0x57,0xd7,0x01,0x05,0x0e,0x04]

v_med3_f16 v5, v1, v2, |v3|
// GFX10: encoding: [0x05,0x04,0x57,0xd7,0x01,0x05,0x0e,0x04]

v_med3_f16 v5, |v1|, |v2|, |v3|
// GFX10: encoding: [0x05,0x07,0x57,0xd7,0x01,0x05,0x0e,0x04]

v_med3_f16 v5, v1, v2, v3 op_sel:[0,0,0,0]
// GFX10: encoding: [0x05,0x00,0x57,0xd7,0x01,0x05,0x0e,0x04]

v_med3_f16 v5, v1, v2, v3 op_sel:[1,0,0,0]
// GFX10: encoding: [0x05,0x08,0x57,0xd7,0x01,0x05,0x0e,0x04]

v_med3_f16 v5, v1, v2, v3 op_sel:[0,1,0,0]
// GFX10: encoding: [0x05,0x10,0x57,0xd7,0x01,0x05,0x0e,0x04]

v_med3_f16 v5, v1, v2, v3 op_sel:[0,0,1,0]
// GFX10: encoding: [0x05,0x20,0x57,0xd7,0x01,0x05,0x0e,0x04]

v_med3_f16 v5, v1, v2, v3 op_sel:[0,0,0,1]
// GFX10: encoding: [0x05,0x40,0x57,0xd7,0x01,0x05,0x0e,0x04]

v_med3_f16 v5, v1, v2, v3 op_sel:[1,1,1,1]
// GFX10: encoding: [0x05,0x78,0x57,0xd7,0x01,0x05,0x0e,0x04]

v_med3_f16 v5, v1, v2, v3 clamp
// GFX10: encoding: [0x05,0x80,0x57,0xd7,0x01,0x05,0x0e,0x04]

v_med3_i16 v5, v1, v2, v3
// GFX10: encoding: [0x05,0x00,0x58,0xd7,0x01,0x05,0x0e,0x04]

v_med3_i16 v255, v1, v2, v3
// GFX10: encoding: [0xff,0x00,0x58,0xd7,0x01,0x05,0x0e,0x04]

v_med3_i16 v5, v255, v2, v3
// GFX10: encoding: [0x05,0x00,0x58,0xd7,0xff,0x05,0x0e,0x04]

v_med3_i16 v5, s1, v2, v3
// GFX10: encoding: [0x05,0x00,0x58,0xd7,0x01,0x04,0x0e,0x04]

v_med3_i16 v5, s101, v2, v3
// GFX10: encoding: [0x05,0x00,0x58,0xd7,0x65,0x04,0x0e,0x04]

v_med3_i16 v5, vcc_lo, v2, v3
// GFX10: encoding: [0x05,0x00,0x58,0xd7,0x6a,0x04,0x0e,0x04]

v_med3_i16 v5, vcc_hi, v2, v3
// GFX10: encoding: [0x05,0x00,0x58,0xd7,0x6b,0x04,0x0e,0x04]

v_med3_i16 v5, m0, v2, v3
// GFX10: encoding: [0x05,0x00,0x58,0xd7,0x7c,0x04,0x0e,0x04]

v_med3_i16 v5, exec_lo, v2, v3
// GFX10: encoding: [0x05,0x00,0x58,0xd7,0x7e,0x04,0x0e,0x04]

v_med3_i16 v5, exec_hi, v2, v3
// GFX10: encoding: [0x05,0x00,0x58,0xd7,0x7f,0x04,0x0e,0x04]

v_med3_i16 v5, 0, v2, v3
// GFX10: encoding: [0x05,0x00,0x58,0xd7,0x80,0x04,0x0e,0x04]

v_med3_i16 v5, -1, v2, v3
// GFX10: encoding: [0x05,0x00,0x58,0xd7,0xc1,0x04,0x0e,0x04]

v_med3_i16 v5, 0.5, v2, v3
// GFX10: encoding: [0x05,0x00,0x58,0xd7,0xff,0x04,0x0e,0x04,0x00,0x38,0x00,0x00]

v_med3_i16 v5, -4.0, v2, v3
// GFX10: encoding: [0x05,0x00,0x58,0xd7,0xff,0x04,0x0e,0x04,0x00,0xc4,0x00,0x00]

v_med3_i16 v5, v1, v255, v3
// GFX10: encoding: [0x05,0x00,0x58,0xd7,0x01,0xff,0x0f,0x04]

v_med3_i16 v5, v1, s2, v3
// GFX10: encoding: [0x05,0x00,0x58,0xd7,0x01,0x05,0x0c,0x04]

v_med3_i16 v5, v1, s101, v3
// GFX10: encoding: [0x05,0x00,0x58,0xd7,0x01,0xcb,0x0c,0x04]

v_med3_i16 v5, v1, vcc_lo, v3
// GFX10: encoding: [0x05,0x00,0x58,0xd7,0x01,0xd5,0x0c,0x04]

v_med3_i16 v5, v1, vcc_hi, v3
// GFX10: encoding: [0x05,0x00,0x58,0xd7,0x01,0xd7,0x0c,0x04]

v_med3_i16 v5, v1, m0, v3
// GFX10: encoding: [0x05,0x00,0x58,0xd7,0x01,0xf9,0x0c,0x04]

v_med3_i16 v5, v1, exec_lo, v3
// GFX10: encoding: [0x05,0x00,0x58,0xd7,0x01,0xfd,0x0c,0x04]

v_med3_i16 v5, v1, exec_hi, v3
// GFX10: encoding: [0x05,0x00,0x58,0xd7,0x01,0xff,0x0c,0x04]

v_med3_i16 v5, v1, 0, v3
// GFX10: encoding: [0x05,0x00,0x58,0xd7,0x01,0x01,0x0d,0x04]

v_med3_i16 v5, v1, -1, v3
// GFX10: encoding: [0x05,0x00,0x58,0xd7,0x01,0x83,0x0d,0x04]

v_med3_i16 v5, v1, 0.5, v3
// GFX10: encoding: [0x05,0x00,0x58,0xd7,0x01,0xff,0x0d,0x04,0x00,0x38,0x00,0x00]

v_med3_i16 v5, v1, -4.0, v3
// GFX10: encoding: [0x05,0x00,0x58,0xd7,0x01,0xff,0x0d,0x04,0x00,0xc4,0x00,0x00]

v_med3_i16 v5, v1, v2, v255
// GFX10: encoding: [0x05,0x00,0x58,0xd7,0x01,0x05,0xfe,0x07]

v_med3_i16 v5, v1, v2, s3
// GFX10: encoding: [0x05,0x00,0x58,0xd7,0x01,0x05,0x0e,0x00]

v_med3_i16 v5, v1, v2, s101
// GFX10: encoding: [0x05,0x00,0x58,0xd7,0x01,0x05,0x96,0x01]

v_med3_i16 v5, v1, v2, vcc_lo
// GFX10: encoding: [0x05,0x00,0x58,0xd7,0x01,0x05,0xaa,0x01]

v_med3_i16 v5, v1, v2, vcc_hi
// GFX10: encoding: [0x05,0x00,0x58,0xd7,0x01,0x05,0xae,0x01]

v_med3_i16 v5, v1, v2, m0
// GFX10: encoding: [0x05,0x00,0x58,0xd7,0x01,0x05,0xf2,0x01]

v_med3_i16 v5, v1, v2, exec_lo
// GFX10: encoding: [0x05,0x00,0x58,0xd7,0x01,0x05,0xfa,0x01]

v_med3_i16 v5, v1, v2, exec_hi
// GFX10: encoding: [0x05,0x00,0x58,0xd7,0x01,0x05,0xfe,0x01]

v_med3_i16 v5, v1, v2, 0
// GFX10: encoding: [0x05,0x00,0x58,0xd7,0x01,0x05,0x02,0x02]

v_med3_i16 v5, v1, v2, -1
// GFX10: encoding: [0x05,0x00,0x58,0xd7,0x01,0x05,0x06,0x03]

v_med3_i16 v5, v1, v2, 0.5
// GFX10: encoding: [0x05,0x00,0x58,0xd7,0x01,0x05,0xfe,0x03,0x00,0x38,0x00,0x00]

v_med3_i16 v5, v1, v2, -4.0
// GFX10: encoding: [0x05,0x00,0x58,0xd7,0x01,0x05,0xfe,0x03,0x00,0xc4,0x00,0x00]

v_med3_i16 v5, v1, v2, v3 op_sel:[0,0,0,0]
// GFX10: encoding: [0x05,0x00,0x58,0xd7,0x01,0x05,0x0e,0x04]

v_med3_i16 v5, v1, v2, v3 op_sel:[1,0,0,0]
// GFX10: encoding: [0x05,0x08,0x58,0xd7,0x01,0x05,0x0e,0x04]

v_med3_i16 v5, v1, v2, v3 op_sel:[0,1,0,0]
// GFX10: encoding: [0x05,0x10,0x58,0xd7,0x01,0x05,0x0e,0x04]

v_med3_i16 v5, v1, v2, v3 op_sel:[0,0,1,0]
// GFX10: encoding: [0x05,0x20,0x58,0xd7,0x01,0x05,0x0e,0x04]

v_med3_i16 v5, v1, v2, v3 op_sel:[0,0,0,1]
// GFX10: encoding: [0x05,0x40,0x58,0xd7,0x01,0x05,0x0e,0x04]

v_med3_i16 v5, v1, v2, v3 op_sel:[1,1,1,1]
// GFX10: encoding: [0x05,0x78,0x58,0xd7,0x01,0x05,0x0e,0x04]

v_med3_i16 v5, v1, v2, v3 clamp
// GFX10: encoding: [0x05,0x80,0x58,0xd7,0x01,0x05,0x0e,0x04]

v_med3_u16 v5, v1, v2, v3
// GFX10: encoding: [0x05,0x00,0x59,0xd7,0x01,0x05,0x0e,0x04]

v_med3_u16 v255, v1, v2, v3
// GFX10: encoding: [0xff,0x00,0x59,0xd7,0x01,0x05,0x0e,0x04]

v_med3_u16 v5, v255, v2, v3
// GFX10: encoding: [0x05,0x00,0x59,0xd7,0xff,0x05,0x0e,0x04]

v_med3_u16 v5, s1, v2, v3
// GFX10: encoding: [0x05,0x00,0x59,0xd7,0x01,0x04,0x0e,0x04]

v_med3_u16 v5, s101, v2, v3
// GFX10: encoding: [0x05,0x00,0x59,0xd7,0x65,0x04,0x0e,0x04]

v_med3_u16 v5, vcc_lo, v2, v3
// GFX10: encoding: [0x05,0x00,0x59,0xd7,0x6a,0x04,0x0e,0x04]

v_med3_u16 v5, vcc_hi, v2, v3
// GFX10: encoding: [0x05,0x00,0x59,0xd7,0x6b,0x04,0x0e,0x04]

v_med3_u16 v5, m0, v2, v3
// GFX10: encoding: [0x05,0x00,0x59,0xd7,0x7c,0x04,0x0e,0x04]

v_med3_u16 v5, exec_lo, v2, v3
// GFX10: encoding: [0x05,0x00,0x59,0xd7,0x7e,0x04,0x0e,0x04]

v_med3_u16 v5, exec_hi, v2, v3
// GFX10: encoding: [0x05,0x00,0x59,0xd7,0x7f,0x04,0x0e,0x04]

v_med3_u16 v5, 0, v2, v3
// GFX10: encoding: [0x05,0x00,0x59,0xd7,0x80,0x04,0x0e,0x04]

v_med3_u16 v5, -1, v2, v3
// GFX10: encoding: [0x05,0x00,0x59,0xd7,0xc1,0x04,0x0e,0x04]

v_med3_u16 v5, 0.5, v2, v3
// GFX10: encoding: [0x05,0x00,0x59,0xd7,0xff,0x04,0x0e,0x04,0x00,0x38,0x00,0x00]

v_med3_u16 v5, -4.0, v2, v3
// GFX10: encoding: [0x05,0x00,0x59,0xd7,0xff,0x04,0x0e,0x04,0x00,0xc4,0x00,0x00]

v_med3_u16 v5, v1, v255, v3
// GFX10: encoding: [0x05,0x00,0x59,0xd7,0x01,0xff,0x0f,0x04]

v_med3_u16 v5, v1, s2, v3
// GFX10: encoding: [0x05,0x00,0x59,0xd7,0x01,0x05,0x0c,0x04]

v_med3_u16 v5, v1, s101, v3
// GFX10: encoding: [0x05,0x00,0x59,0xd7,0x01,0xcb,0x0c,0x04]

v_med3_u16 v5, v1, vcc_lo, v3
// GFX10: encoding: [0x05,0x00,0x59,0xd7,0x01,0xd5,0x0c,0x04]

v_med3_u16 v5, v1, vcc_hi, v3
// GFX10: encoding: [0x05,0x00,0x59,0xd7,0x01,0xd7,0x0c,0x04]

v_med3_u16 v5, v1, m0, v3
// GFX10: encoding: [0x05,0x00,0x59,0xd7,0x01,0xf9,0x0c,0x04]

v_med3_u16 v5, v1, exec_lo, v3
// GFX10: encoding: [0x05,0x00,0x59,0xd7,0x01,0xfd,0x0c,0x04]

v_med3_u16 v5, v1, exec_hi, v3
// GFX10: encoding: [0x05,0x00,0x59,0xd7,0x01,0xff,0x0c,0x04]

v_med3_u16 v5, v1, 0, v3
// GFX10: encoding: [0x05,0x00,0x59,0xd7,0x01,0x01,0x0d,0x04]

v_med3_u16 v5, v1, -1, v3
// GFX10: encoding: [0x05,0x00,0x59,0xd7,0x01,0x83,0x0d,0x04]

v_med3_u16 v5, v1, 0.5, v3
// GFX10: encoding: [0x05,0x00,0x59,0xd7,0x01,0xff,0x0d,0x04,0x00,0x38,0x00,0x00]

v_med3_u16 v5, v1, -4.0, v3
// GFX10: encoding: [0x05,0x00,0x59,0xd7,0x01,0xff,0x0d,0x04,0x00,0xc4,0x00,0x00]

v_med3_u16 v5, v1, v2, v255
// GFX10: encoding: [0x05,0x00,0x59,0xd7,0x01,0x05,0xfe,0x07]

v_med3_u16 v5, v1, v2, s3
// GFX10: encoding: [0x05,0x00,0x59,0xd7,0x01,0x05,0x0e,0x00]

v_med3_u16 v5, v1, v2, s101
// GFX10: encoding: [0x05,0x00,0x59,0xd7,0x01,0x05,0x96,0x01]

v_med3_u16 v5, v1, v2, vcc_lo
// GFX10: encoding: [0x05,0x00,0x59,0xd7,0x01,0x05,0xaa,0x01]

v_med3_u16 v5, v1, v2, vcc_hi
// GFX10: encoding: [0x05,0x00,0x59,0xd7,0x01,0x05,0xae,0x01]

v_med3_u16 v5, v1, v2, m0
// GFX10: encoding: [0x05,0x00,0x59,0xd7,0x01,0x05,0xf2,0x01]

v_med3_u16 v5, v1, v2, exec_lo
// GFX10: encoding: [0x05,0x00,0x59,0xd7,0x01,0x05,0xfa,0x01]

v_med3_u16 v5, v1, v2, exec_hi
// GFX10: encoding: [0x05,0x00,0x59,0xd7,0x01,0x05,0xfe,0x01]

v_med3_u16 v5, v1, v2, 0
// GFX10: encoding: [0x05,0x00,0x59,0xd7,0x01,0x05,0x02,0x02]

v_med3_u16 v5, v1, v2, -1
// GFX10: encoding: [0x05,0x00,0x59,0xd7,0x01,0x05,0x06,0x03]

v_med3_u16 v5, v1, v2, 0.5
// GFX10: encoding: [0x05,0x00,0x59,0xd7,0x01,0x05,0xfe,0x03,0x00,0x38,0x00,0x00]

v_med3_u16 v5, v1, v2, -4.0
// GFX10: encoding: [0x05,0x00,0x59,0xd7,0x01,0x05,0xfe,0x03,0x00,0xc4,0x00,0x00]

v_med3_u16 v5, v1, v2, v3 op_sel:[0,0,0,0]
// GFX10: encoding: [0x05,0x00,0x59,0xd7,0x01,0x05,0x0e,0x04]

v_med3_u16 v5, v1, v2, v3 op_sel:[1,0,0,0]
// GFX10: encoding: [0x05,0x08,0x59,0xd7,0x01,0x05,0x0e,0x04]

v_med3_u16 v5, v1, v2, v3 op_sel:[0,1,0,0]
// GFX10: encoding: [0x05,0x10,0x59,0xd7,0x01,0x05,0x0e,0x04]

v_med3_u16 v5, v1, v2, v3 op_sel:[0,0,1,0]
// GFX10: encoding: [0x05,0x20,0x59,0xd7,0x01,0x05,0x0e,0x04]

v_med3_u16 v5, v1, v2, v3 op_sel:[0,0,0,1]
// GFX10: encoding: [0x05,0x40,0x59,0xd7,0x01,0x05,0x0e,0x04]

v_med3_u16 v5, v1, v2, v3 op_sel:[1,1,1,1]
// GFX10: encoding: [0x05,0x78,0x59,0xd7,0x01,0x05,0x0e,0x04]

v_interp_p2_f16 v5, v2, attr0.x, v3
// GFX10: encoding: [0x05,0x00,0x5a,0xd7,0x00,0x04,0x0e,0x04]

v_interp_p2_f16 v5, -v2, attr0.x, v3
// GFX10: encoding: [0x05,0x00,0x5a,0xd7,0x00,0x04,0x0e,0x44]

v_interp_p2_f16 v5, v2, attr0.x, |v3|
// GFX10: encoding: [0x05,0x04,0x5a,0xd7,0x00,0x04,0x0e,0x04]

v_interp_p2_f16 v5, v2, attr0.w, v3
// GFX10: encoding: [0x05,0x00,0x5a,0xd7,0xc0,0x04,0x0e,0x04]

v_interp_p2_f16 v5, v2, attr0.x, v3 high
// GFX10: encoding: [0x05,0x00,0x5a,0xd7,0x00,0x05,0x0e,0x04]

v_interp_p2_f16 v5, v2, attr0.x, v3 clamp
// GFX10: encoding: [0x05,0x80,0x5a,0xd7,0x00,0x04,0x0e,0x04]

v_mad_i16 v5, 0, v2, v3
// GFX10: encoding: [0x05,0x00,0x5e,0xd7,0x80,0x04,0x0e,0x04]

v_mad_i16 v5, v1, -1, v3
// GFX10: encoding: [0x05,0x00,0x5e,0xd7,0x01,0x83,0x0d,0x04]

v_mad_i16 v5, v1, v2, -4.0
// GFX10: encoding: [0x05,0x00,0x5e,0xd7,0x01,0x05,0xfe,0x03,0x00,0xc4,0x00,0x00]

v_mad_i16 v5, v1, v2, v3 clamp
// GFX10: encoding: [0x05,0x80,0x5e,0xd7,0x01,0x05,0x0e,0x04]

v_mad_i16 v5, v1, v2, v3 op_sel:[0,0,0,1]
// GFX10: encoding: [0x05,0x40,0x5e,0xd7,0x01,0x05,0x0e,0x04]

v_mad_i16 v5, v1, v2, v3 op_sel:[1,1,1,1]
// GFX10: encoding: [0x05,0x78,0x5e,0xd7,0x01,0x05,0x0e,0x04]

v_div_fixup_f16 v5, 0.5, v2, v3
// GFX10: encoding: [0x05,0x00,0x5f,0xd7,0xf0,0x04,0x0e,0x04]

v_div_fixup_f16 v5, v1, 0.5, v3
// GFX10: encoding: [0x05,0x00,0x5f,0xd7,0x01,0xe1,0x0d,0x04]

v_div_fixup_f16 v5, v1, v2, 0.5
// GFX10: encoding: [0x05,0x00,0x5f,0xd7,0x01,0x05,0xc2,0x03]

v_div_fixup_f16 v5, -v1, v2, v3
// GFX10: encoding: [0x05,0x00,0x5f,0xd7,0x01,0x05,0x0e,0x24]

v_div_fixup_f16 v5, |v1|, v2, v3
// GFX10: encoding: [0x05,0x01,0x5f,0xd7,0x01,0x05,0x0e,0x04]

v_div_fixup_f16 v5, v1, v2, v3 clamp
// GFX10: encoding: [0x05,0x80,0x5f,0xd7,0x01,0x05,0x0e,0x04]

v_div_fixup_f16 v5, v1, v2, v3 op_sel:[1,0,0,0]
// GFX10: encoding: [0x05,0x08,0x5f,0xd7,0x01,0x05,0x0e,0x04]

v_div_fixup_f16 v5, v1, v2, v3 op_sel:[0,0,1,0]
// GFX10: encoding: [0x05,0x20,0x5f,0xd7,0x01,0x05,0x0e,0x04]

v_div_fixup_f16 v5, v1, v2, v3 op_sel:[0,0,0,1]
// GFX10: encoding: [0x05,0x40,0x5f,0xd7,0x01,0x05,0x0e,0x04]

v_add3_u32 v5, v1, v2, v3
// GFX10: encoding: [0x05,0x00,0x6d,0xd7,0x01,0x05,0x0e,0x04]

v_add3_u32 v255, v1, v2, v3
// GFX10: encoding: [0xff,0x00,0x6d,0xd7,0x01,0x05,0x0e,0x04]

v_add3_u32 v5, v255, v2, v3
// GFX10: encoding: [0x05,0x00,0x6d,0xd7,0xff,0x05,0x0e,0x04]

v_add3_u32 v5, s1, v2, v3
// GFX10: encoding: [0x05,0x00,0x6d,0xd7,0x01,0x04,0x0e,0x04]

v_add3_u32 v5, s101, v2, v3
// GFX10: encoding: [0x05,0x00,0x6d,0xd7,0x65,0x04,0x0e,0x04]

v_add3_u32 v5, vcc_lo, v2, v3
// GFX10: encoding: [0x05,0x00,0x6d,0xd7,0x6a,0x04,0x0e,0x04]

v_add3_u32 v5, vcc_hi, v2, v3
// GFX10: encoding: [0x05,0x00,0x6d,0xd7,0x6b,0x04,0x0e,0x04]

v_add3_u32 v5, m0, v2, v3
// GFX10: encoding: [0x05,0x00,0x6d,0xd7,0x7c,0x04,0x0e,0x04]

v_add3_u32 v5, exec_lo, v2, v3
// GFX10: encoding: [0x05,0x00,0x6d,0xd7,0x7e,0x04,0x0e,0x04]

v_add3_u32 v5, exec_hi, v2, v3
// GFX10: encoding: [0x05,0x00,0x6d,0xd7,0x7f,0x04,0x0e,0x04]

v_add3_u32 v5, 0, v2, v3
// GFX10: encoding: [0x05,0x00,0x6d,0xd7,0x80,0x04,0x0e,0x04]

v_add3_u32 v5, -1, v2, v3
// GFX10: encoding: [0x05,0x00,0x6d,0xd7,0xc1,0x04,0x0e,0x04]

v_add3_u32 v5, 0.5, v2, v3
// GFX10: encoding: [0x05,0x00,0x6d,0xd7,0xf0,0x04,0x0e,0x04]

v_add3_u32 v5, -4.0, v2, v3
// GFX10: encoding: [0x05,0x00,0x6d,0xd7,0xf7,0x04,0x0e,0x04]

v_add3_u32 v5, v1, v255, v3
// GFX10: encoding: [0x05,0x00,0x6d,0xd7,0x01,0xff,0x0f,0x04]

v_add3_u32 v5, v1, s2, v3
// GFX10: encoding: [0x05,0x00,0x6d,0xd7,0x01,0x05,0x0c,0x04]

v_add3_u32 v5, v1, s101, v3
// GFX10: encoding: [0x05,0x00,0x6d,0xd7,0x01,0xcb,0x0c,0x04]

v_add3_u32 v5, v1, vcc_lo, v3
// GFX10: encoding: [0x05,0x00,0x6d,0xd7,0x01,0xd5,0x0c,0x04]

v_add3_u32 v5, v1, vcc_hi, v3
// GFX10: encoding: [0x05,0x00,0x6d,0xd7,0x01,0xd7,0x0c,0x04]

v_add3_u32 v5, v1, m0, v3
// GFX10: encoding: [0x05,0x00,0x6d,0xd7,0x01,0xf9,0x0c,0x04]

v_add3_u32 v5, v1, exec_lo, v3
// GFX10: encoding: [0x05,0x00,0x6d,0xd7,0x01,0xfd,0x0c,0x04]

v_add3_u32 v5, v1, exec_hi, v3
// GFX10: encoding: [0x05,0x00,0x6d,0xd7,0x01,0xff,0x0c,0x04]

v_add3_u32 v5, v1, 0, v3
// GFX10: encoding: [0x05,0x00,0x6d,0xd7,0x01,0x01,0x0d,0x04]

v_add3_u32 v5, v1, -1, v3
// GFX10: encoding: [0x05,0x00,0x6d,0xd7,0x01,0x83,0x0d,0x04]

v_add3_u32 v5, v1, 0.5, v3
// GFX10: encoding: [0x05,0x00,0x6d,0xd7,0x01,0xe1,0x0d,0x04]

v_add3_u32 v5, v1, -4.0, v3
// GFX10: encoding: [0x05,0x00,0x6d,0xd7,0x01,0xef,0x0d,0x04]

v_add3_u32 v5, v1, v2, v255
// GFX10: encoding: [0x05,0x00,0x6d,0xd7,0x01,0x05,0xfe,0x07]

v_add3_u32 v5, v1, v2, s3
// GFX10: encoding: [0x05,0x00,0x6d,0xd7,0x01,0x05,0x0e,0x00]

v_add3_u32 v5, v1, v2, s101
// GFX10: encoding: [0x05,0x00,0x6d,0xd7,0x01,0x05,0x96,0x01]

v_add3_u32 v5, v1, v2, vcc_lo
// GFX10: encoding: [0x05,0x00,0x6d,0xd7,0x01,0x05,0xaa,0x01]

v_add3_u32 v5, v1, v2, vcc_hi
// GFX10: encoding: [0x05,0x00,0x6d,0xd7,0x01,0x05,0xae,0x01]

v_add3_u32 v5, v1, v2, m0
// GFX10: encoding: [0x05,0x00,0x6d,0xd7,0x01,0x05,0xf2,0x01]

v_add3_u32 v5, v1, v2, exec_lo
// GFX10: encoding: [0x05,0x00,0x6d,0xd7,0x01,0x05,0xfa,0x01]

v_add3_u32 v5, v1, v2, exec_hi
// GFX10: encoding: [0x05,0x00,0x6d,0xd7,0x01,0x05,0xfe,0x01]

v_add3_u32 v5, v1, v2, 0
// GFX10: encoding: [0x05,0x00,0x6d,0xd7,0x01,0x05,0x02,0x02]

v_add3_u32 v5, v1, v2, -1
// GFX10: encoding: [0x05,0x00,0x6d,0xd7,0x01,0x05,0x06,0x03]

v_add3_u32 v5, v1, v2, 0.5
// GFX10: encoding: [0x05,0x00,0x6d,0xd7,0x01,0x05,0xc2,0x03]

v_add3_u32 v5, v1, v2, -4.0
// GFX10: encoding: [0x05,0x00,0x6d,0xd7,0x01,0x05,0xde,0x03]

v_lshl_or_b32 v5, v1, v2, v3
// GFX10: encoding: [0x05,0x00,0x6f,0xd7,0x01,0x05,0x0e,0x04]

v_lshl_or_b32 v255, v1, v2, v3
// GFX10: encoding: [0xff,0x00,0x6f,0xd7,0x01,0x05,0x0e,0x04]

v_lshl_or_b32 v5, v255, v2, v3
// GFX10: encoding: [0x05,0x00,0x6f,0xd7,0xff,0x05,0x0e,0x04]

v_lshl_or_b32 v5, s1, v2, v3
// GFX10: encoding: [0x05,0x00,0x6f,0xd7,0x01,0x04,0x0e,0x04]

v_lshl_or_b32 v5, s101, v2, v3
// GFX10: encoding: [0x05,0x00,0x6f,0xd7,0x65,0x04,0x0e,0x04]

v_lshl_or_b32 v5, vcc_lo, v2, v3
// GFX10: encoding: [0x05,0x00,0x6f,0xd7,0x6a,0x04,0x0e,0x04]

v_lshl_or_b32 v5, vcc_hi, v2, v3
// GFX10: encoding: [0x05,0x00,0x6f,0xd7,0x6b,0x04,0x0e,0x04]

v_lshl_or_b32 v5, m0, v2, v3
// GFX10: encoding: [0x05,0x00,0x6f,0xd7,0x7c,0x04,0x0e,0x04]

v_lshl_or_b32 v5, exec_lo, v2, v3
// GFX10: encoding: [0x05,0x00,0x6f,0xd7,0x7e,0x04,0x0e,0x04]

v_lshl_or_b32 v5, exec_hi, v2, v3
// GFX10: encoding: [0x05,0x00,0x6f,0xd7,0x7f,0x04,0x0e,0x04]

v_lshl_or_b32 v5, 0, v2, v3
// GFX10: encoding: [0x05,0x00,0x6f,0xd7,0x80,0x04,0x0e,0x04]

v_lshl_or_b32 v5, -1, v2, v3
// GFX10: encoding: [0x05,0x00,0x6f,0xd7,0xc1,0x04,0x0e,0x04]

v_lshl_or_b32 v5, 0.5, v2, v3
// GFX10: encoding: [0x05,0x00,0x6f,0xd7,0xf0,0x04,0x0e,0x04]

v_lshl_or_b32 v5, -4.0, v2, v3
// GFX10: encoding: [0x05,0x00,0x6f,0xd7,0xf7,0x04,0x0e,0x04]

v_lshl_or_b32 v5, v1, v255, v3
// GFX10: encoding: [0x05,0x00,0x6f,0xd7,0x01,0xff,0x0f,0x04]

v_lshl_or_b32 v5, v1, s2, v3
// GFX10: encoding: [0x05,0x00,0x6f,0xd7,0x01,0x05,0x0c,0x04]

v_lshl_or_b32 v5, v1, s101, v3
// GFX10: encoding: [0x05,0x00,0x6f,0xd7,0x01,0xcb,0x0c,0x04]

v_lshl_or_b32 v5, v1, vcc_lo, v3
// GFX10: encoding: [0x05,0x00,0x6f,0xd7,0x01,0xd5,0x0c,0x04]

v_lshl_or_b32 v5, v1, vcc_hi, v3
// GFX10: encoding: [0x05,0x00,0x6f,0xd7,0x01,0xd7,0x0c,0x04]

v_lshl_or_b32 v5, v1, m0, v3
// GFX10: encoding: [0x05,0x00,0x6f,0xd7,0x01,0xf9,0x0c,0x04]

v_lshl_or_b32 v5, v1, exec_lo, v3
// GFX10: encoding: [0x05,0x00,0x6f,0xd7,0x01,0xfd,0x0c,0x04]

v_lshl_or_b32 v5, v1, exec_hi, v3
// GFX10: encoding: [0x05,0x00,0x6f,0xd7,0x01,0xff,0x0c,0x04]

v_lshl_or_b32 v5, v1, 0, v3
// GFX10: encoding: [0x05,0x00,0x6f,0xd7,0x01,0x01,0x0d,0x04]

v_lshl_or_b32 v5, v1, -1, v3
// GFX10: encoding: [0x05,0x00,0x6f,0xd7,0x01,0x83,0x0d,0x04]

v_lshl_or_b32 v5, v1, 0.5, v3
// GFX10: encoding: [0x05,0x00,0x6f,0xd7,0x01,0xe1,0x0d,0x04]

v_lshl_or_b32 v5, v1, -4.0, v3
// GFX10: encoding: [0x05,0x00,0x6f,0xd7,0x01,0xef,0x0d,0x04]

v_lshl_or_b32 v5, v1, v2, v255
// GFX10: encoding: [0x05,0x00,0x6f,0xd7,0x01,0x05,0xfe,0x07]

v_lshl_or_b32 v5, v1, v2, s3
// GFX10: encoding: [0x05,0x00,0x6f,0xd7,0x01,0x05,0x0e,0x00]

v_lshl_or_b32 v5, v1, v2, s101
// GFX10: encoding: [0x05,0x00,0x6f,0xd7,0x01,0x05,0x96,0x01]

v_lshl_or_b32 v5, v1, v2, vcc_lo
// GFX10: encoding: [0x05,0x00,0x6f,0xd7,0x01,0x05,0xaa,0x01]

v_lshl_or_b32 v5, v1, v2, vcc_hi
// GFX10: encoding: [0x05,0x00,0x6f,0xd7,0x01,0x05,0xae,0x01]

v_lshl_or_b32 v5, v1, v2, m0
// GFX10: encoding: [0x05,0x00,0x6f,0xd7,0x01,0x05,0xf2,0x01]

v_lshl_or_b32 v5, v1, v2, exec_lo
// GFX10: encoding: [0x05,0x00,0x6f,0xd7,0x01,0x05,0xfa,0x01]

v_lshl_or_b32 v5, v1, v2, exec_hi
// GFX10: encoding: [0x05,0x00,0x6f,0xd7,0x01,0x05,0xfe,0x01]

v_lshl_or_b32 v5, v1, v2, 0
// GFX10: encoding: [0x05,0x00,0x6f,0xd7,0x01,0x05,0x02,0x02]

v_lshl_or_b32 v5, v1, v2, -1
// GFX10: encoding: [0x05,0x00,0x6f,0xd7,0x01,0x05,0x06,0x03]

v_lshl_or_b32 v5, v1, v2, 0.5
// GFX10: encoding: [0x05,0x00,0x6f,0xd7,0x01,0x05,0xc2,0x03]

v_lshl_or_b32 v5, v1, v2, -4.0
// GFX10: encoding: [0x05,0x00,0x6f,0xd7,0x01,0x05,0xde,0x03]

v_and_or_b32 v5, v1, v2, v3
// GFX10: encoding: [0x05,0x00,0x71,0xd7,0x01,0x05,0x0e,0x04]

v_and_or_b32 v255, v1, v2, v3
// GFX10: encoding: [0xff,0x00,0x71,0xd7,0x01,0x05,0x0e,0x04]

v_and_or_b32 v5, v255, v2, v3
// GFX10: encoding: [0x05,0x00,0x71,0xd7,0xff,0x05,0x0e,0x04]

v_and_or_b32 v5, s1, v2, v3
// GFX10: encoding: [0x05,0x00,0x71,0xd7,0x01,0x04,0x0e,0x04]

v_and_or_b32 v5, s101, v2, v3
// GFX10: encoding: [0x05,0x00,0x71,0xd7,0x65,0x04,0x0e,0x04]

v_and_or_b32 v5, vcc_lo, v2, v3
// GFX10: encoding: [0x05,0x00,0x71,0xd7,0x6a,0x04,0x0e,0x04]

v_and_or_b32 v5, vcc_hi, v2, v3
// GFX10: encoding: [0x05,0x00,0x71,0xd7,0x6b,0x04,0x0e,0x04]

v_and_or_b32 v5, m0, v2, v3
// GFX10: encoding: [0x05,0x00,0x71,0xd7,0x7c,0x04,0x0e,0x04]

v_and_or_b32 v5, exec_lo, v2, v3
// GFX10: encoding: [0x05,0x00,0x71,0xd7,0x7e,0x04,0x0e,0x04]

v_and_or_b32 v5, exec_hi, v2, v3
// GFX10: encoding: [0x05,0x00,0x71,0xd7,0x7f,0x04,0x0e,0x04]

v_and_or_b32 v5, 0, v2, v3
// GFX10: encoding: [0x05,0x00,0x71,0xd7,0x80,0x04,0x0e,0x04]

v_and_or_b32 v5, -1, v2, v3
// GFX10: encoding: [0x05,0x00,0x71,0xd7,0xc1,0x04,0x0e,0x04]

v_and_or_b32 v5, 0.5, v2, v3
// GFX10: encoding: [0x05,0x00,0x71,0xd7,0xf0,0x04,0x0e,0x04]

v_and_or_b32 v5, -4.0, v2, v3
// GFX10: encoding: [0x05,0x00,0x71,0xd7,0xf7,0x04,0x0e,0x04]

v_and_or_b32 v5, v1, v255, v3
// GFX10: encoding: [0x05,0x00,0x71,0xd7,0x01,0xff,0x0f,0x04]

v_and_or_b32 v5, v1, s2, v3
// GFX10: encoding: [0x05,0x00,0x71,0xd7,0x01,0x05,0x0c,0x04]

v_and_or_b32 v5, v1, s101, v3
// GFX10: encoding: [0x05,0x00,0x71,0xd7,0x01,0xcb,0x0c,0x04]

v_and_or_b32 v5, v1, vcc_lo, v3
// GFX10: encoding: [0x05,0x00,0x71,0xd7,0x01,0xd5,0x0c,0x04]

v_and_or_b32 v5, v1, vcc_hi, v3
// GFX10: encoding: [0x05,0x00,0x71,0xd7,0x01,0xd7,0x0c,0x04]

v_and_or_b32 v5, v1, m0, v3
// GFX10: encoding: [0x05,0x00,0x71,0xd7,0x01,0xf9,0x0c,0x04]

v_and_or_b32 v5, v1, exec_lo, v3
// GFX10: encoding: [0x05,0x00,0x71,0xd7,0x01,0xfd,0x0c,0x04]

v_and_or_b32 v5, v1, exec_hi, v3
// GFX10: encoding: [0x05,0x00,0x71,0xd7,0x01,0xff,0x0c,0x04]

v_and_or_b32 v5, v1, 0, v3
// GFX10: encoding: [0x05,0x00,0x71,0xd7,0x01,0x01,0x0d,0x04]

v_and_or_b32 v5, v1, -1, v3
// GFX10: encoding: [0x05,0x00,0x71,0xd7,0x01,0x83,0x0d,0x04]

v_and_or_b32 v5, v1, 0.5, v3
// GFX10: encoding: [0x05,0x00,0x71,0xd7,0x01,0xe1,0x0d,0x04]

v_and_or_b32 v5, v1, -4.0, v3
// GFX10: encoding: [0x05,0x00,0x71,0xd7,0x01,0xef,0x0d,0x04]

v_and_or_b32 v5, v1, v2, v255
// GFX10: encoding: [0x05,0x00,0x71,0xd7,0x01,0x05,0xfe,0x07]

v_and_or_b32 v5, v1, v2, s3
// GFX10: encoding: [0x05,0x00,0x71,0xd7,0x01,0x05,0x0e,0x00]

v_and_or_b32 v5, v1, v2, s101
// GFX10: encoding: [0x05,0x00,0x71,0xd7,0x01,0x05,0x96,0x01]

v_and_or_b32 v5, v1, v2, vcc_lo
// GFX10: encoding: [0x05,0x00,0x71,0xd7,0x01,0x05,0xaa,0x01]

v_and_or_b32 v5, v1, v2, vcc_hi
// GFX10: encoding: [0x05,0x00,0x71,0xd7,0x01,0x05,0xae,0x01]

v_and_or_b32 v5, v1, v2, m0
// GFX10: encoding: [0x05,0x00,0x71,0xd7,0x01,0x05,0xf2,0x01]

v_and_or_b32 v5, v1, v2, exec_lo
// GFX10: encoding: [0x05,0x00,0x71,0xd7,0x01,0x05,0xfa,0x01]

v_and_or_b32 v5, v1, v2, exec_hi
// GFX10: encoding: [0x05,0x00,0x71,0xd7,0x01,0x05,0xfe,0x01]

v_and_or_b32 v5, v1, v2, 0
// GFX10: encoding: [0x05,0x00,0x71,0xd7,0x01,0x05,0x02,0x02]

v_and_or_b32 v5, v1, v2, -1
// GFX10: encoding: [0x05,0x00,0x71,0xd7,0x01,0x05,0x06,0x03]

v_and_or_b32 v5, v1, v2, 0.5
// GFX10: encoding: [0x05,0x00,0x71,0xd7,0x01,0x05,0xc2,0x03]

v_and_or_b32 v5, v1, v2, -4.0
// GFX10: encoding: [0x05,0x00,0x71,0xd7,0x01,0x05,0xde,0x03]

v_or3_b32 v5, v1, v2, v3
// GFX10: encoding: [0x05,0x00,0x72,0xd7,0x01,0x05,0x0e,0x04]

v_or3_b32 v255, v1, v2, v3
// GFX10: encoding: [0xff,0x00,0x72,0xd7,0x01,0x05,0x0e,0x04]

v_or3_b32 v5, v255, v2, v3
// GFX10: encoding: [0x05,0x00,0x72,0xd7,0xff,0x05,0x0e,0x04]

v_or3_b32 v5, s1, v2, v3
// GFX10: encoding: [0x05,0x00,0x72,0xd7,0x01,0x04,0x0e,0x04]

v_or3_b32 v5, s101, v2, v3
// GFX10: encoding: [0x05,0x00,0x72,0xd7,0x65,0x04,0x0e,0x04]

v_or3_b32 v5, vcc_lo, v2, v3
// GFX10: encoding: [0x05,0x00,0x72,0xd7,0x6a,0x04,0x0e,0x04]

v_or3_b32 v5, vcc_hi, v2, v3
// GFX10: encoding: [0x05,0x00,0x72,0xd7,0x6b,0x04,0x0e,0x04]

v_or3_b32 v5, m0, v2, v3
// GFX10: encoding: [0x05,0x00,0x72,0xd7,0x7c,0x04,0x0e,0x04]

v_or3_b32 v5, exec_lo, v2, v3
// GFX10: encoding: [0x05,0x00,0x72,0xd7,0x7e,0x04,0x0e,0x04]

v_or3_b32 v5, exec_hi, v2, v3
// GFX10: encoding: [0x05,0x00,0x72,0xd7,0x7f,0x04,0x0e,0x04]

v_or3_b32 v5, 0, v2, v3
// GFX10: encoding: [0x05,0x00,0x72,0xd7,0x80,0x04,0x0e,0x04]

v_or3_b32 v5, -1, v2, v3
// GFX10: encoding: [0x05,0x00,0x72,0xd7,0xc1,0x04,0x0e,0x04]

v_or3_b32 v5, 0.5, v2, v3
// GFX10: encoding: [0x05,0x00,0x72,0xd7,0xf0,0x04,0x0e,0x04]

v_or3_b32 v5, -4.0, v2, v3
// GFX10: encoding: [0x05,0x00,0x72,0xd7,0xf7,0x04,0x0e,0x04]

v_or3_b32 v5, v1, v255, v3
// GFX10: encoding: [0x05,0x00,0x72,0xd7,0x01,0xff,0x0f,0x04]

v_or3_b32 v5, v1, s2, v3
// GFX10: encoding: [0x05,0x00,0x72,0xd7,0x01,0x05,0x0c,0x04]

v_or3_b32 v5, v1, s101, v3
// GFX10: encoding: [0x05,0x00,0x72,0xd7,0x01,0xcb,0x0c,0x04]

v_or3_b32 v5, v1, vcc_lo, v3
// GFX10: encoding: [0x05,0x00,0x72,0xd7,0x01,0xd5,0x0c,0x04]

v_or3_b32 v5, v1, vcc_hi, v3
// GFX10: encoding: [0x05,0x00,0x72,0xd7,0x01,0xd7,0x0c,0x04]

v_or3_b32 v5, v1, m0, v3
// GFX10: encoding: [0x05,0x00,0x72,0xd7,0x01,0xf9,0x0c,0x04]

v_or3_b32 v5, v1, exec_lo, v3
// GFX10: encoding: [0x05,0x00,0x72,0xd7,0x01,0xfd,0x0c,0x04]

v_or3_b32 v5, v1, exec_hi, v3
// GFX10: encoding: [0x05,0x00,0x72,0xd7,0x01,0xff,0x0c,0x04]

v_or3_b32 v5, v1, 0, v3
// GFX10: encoding: [0x05,0x00,0x72,0xd7,0x01,0x01,0x0d,0x04]

v_or3_b32 v5, v1, -1, v3
// GFX10: encoding: [0x05,0x00,0x72,0xd7,0x01,0x83,0x0d,0x04]

v_or3_b32 v5, v1, 0.5, v3
// GFX10: encoding: [0x05,0x00,0x72,0xd7,0x01,0xe1,0x0d,0x04]

v_or3_b32 v5, v1, -4.0, v3
// GFX10: encoding: [0x05,0x00,0x72,0xd7,0x01,0xef,0x0d,0x04]

v_or3_b32 v5, v1, v2, v255
// GFX10: encoding: [0x05,0x00,0x72,0xd7,0x01,0x05,0xfe,0x07]

v_or3_b32 v5, v1, v2, s3
// GFX10: encoding: [0x05,0x00,0x72,0xd7,0x01,0x05,0x0e,0x00]

v_or3_b32 v5, v1, v2, s101
// GFX10: encoding: [0x05,0x00,0x72,0xd7,0x01,0x05,0x96,0x01]

v_or3_b32 v5, v1, v2, vcc_lo
// GFX10: encoding: [0x05,0x00,0x72,0xd7,0x01,0x05,0xaa,0x01]

v_or3_b32 v5, v1, v2, vcc_hi
// GFX10: encoding: [0x05,0x00,0x72,0xd7,0x01,0x05,0xae,0x01]

v_or3_b32 v5, v1, v2, m0
// GFX10: encoding: [0x05,0x00,0x72,0xd7,0x01,0x05,0xf2,0x01]

v_or3_b32 v5, v1, v2, exec_lo
// GFX10: encoding: [0x05,0x00,0x72,0xd7,0x01,0x05,0xfa,0x01]

v_or3_b32 v5, v1, v2, exec_hi
// GFX10: encoding: [0x05,0x00,0x72,0xd7,0x01,0x05,0xfe,0x01]

v_or3_b32 v5, v1, v2, 0
// GFX10: encoding: [0x05,0x00,0x72,0xd7,0x01,0x05,0x02,0x02]

v_or3_b32 v5, v1, v2, -1
// GFX10: encoding: [0x05,0x00,0x72,0xd7,0x01,0x05,0x06,0x03]

v_or3_b32 v5, v1, v2, 0.5
// GFX10: encoding: [0x05,0x00,0x72,0xd7,0x01,0x05,0xc2,0x03]

v_or3_b32 v5, v1, v2, -4.0
// GFX10: encoding: [0x05,0x00,0x72,0xd7,0x01,0x05,0xde,0x03]

v_mad_u32_u16 v5, v1, v2, v3
// GFX10: encoding: [0x05,0x00,0x73,0xd7,0x01,0x05,0x0e,0x04]

v_mad_u32_u16 v255, v1, v2, v3
// GFX10: encoding: [0xff,0x00,0x73,0xd7,0x01,0x05,0x0e,0x04]

v_mad_u32_u16 v5, v255, v2, v3
// GFX10: encoding: [0x05,0x00,0x73,0xd7,0xff,0x05,0x0e,0x04]

v_mad_u32_u16 v5, s1, v2, v3
// GFX10: encoding: [0x05,0x00,0x73,0xd7,0x01,0x04,0x0e,0x04]

v_mad_u32_u16 v5, s101, v2, v3
// GFX10: encoding: [0x05,0x00,0x73,0xd7,0x65,0x04,0x0e,0x04]

v_mad_u32_u16 v5, vcc_lo, v2, v3
// GFX10: encoding: [0x05,0x00,0x73,0xd7,0x6a,0x04,0x0e,0x04]

v_mad_u32_u16 v5, vcc_hi, v2, v3
// GFX10: encoding: [0x05,0x00,0x73,0xd7,0x6b,0x04,0x0e,0x04]

v_mad_u32_u16 v5, m0, v2, v3
// GFX10: encoding: [0x05,0x00,0x73,0xd7,0x7c,0x04,0x0e,0x04]

v_mad_u32_u16 v5, exec_lo, v2, v3
// GFX10: encoding: [0x05,0x00,0x73,0xd7,0x7e,0x04,0x0e,0x04]

v_mad_u32_u16 v5, exec_hi, v2, v3
// GFX10: encoding: [0x05,0x00,0x73,0xd7,0x7f,0x04,0x0e,0x04]

v_mad_u32_u16 v5, 0, v2, v3
// GFX10: encoding: [0x05,0x00,0x73,0xd7,0x80,0x04,0x0e,0x04]

v_mad_u32_u16 v5, -1, v2, v3
// GFX10: encoding: [0x05,0x00,0x73,0xd7,0xc1,0x04,0x0e,0x04]

v_mad_u32_u16 v5, 0.5, v2, v3
// GFX10: encoding: [0x05,0x00,0x73,0xd7,0xff,0x04,0x0e,0x04,0x00,0x38,0x00,0x00]

v_mad_u32_u16 v5, -4.0, v2, v3
// GFX10: encoding: [0x05,0x00,0x73,0xd7,0xff,0x04,0x0e,0x04,0x00,0xc4,0x00,0x00]

v_mad_u32_u16 v5, v1, v255, v3
// GFX10: encoding: [0x05,0x00,0x73,0xd7,0x01,0xff,0x0f,0x04]

v_mad_u32_u16 v5, v1, s2, v3
// GFX10: encoding: [0x05,0x00,0x73,0xd7,0x01,0x05,0x0c,0x04]

v_mad_u32_u16 v5, v1, s101, v3
// GFX10: encoding: [0x05,0x00,0x73,0xd7,0x01,0xcb,0x0c,0x04]

v_mad_u32_u16 v5, v1, vcc_lo, v3
// GFX10: encoding: [0x05,0x00,0x73,0xd7,0x01,0xd5,0x0c,0x04]

v_mad_u32_u16 v5, v1, vcc_hi, v3
// GFX10: encoding: [0x05,0x00,0x73,0xd7,0x01,0xd7,0x0c,0x04]

v_mad_u32_u16 v5, v1, m0, v3
// GFX10: encoding: [0x05,0x00,0x73,0xd7,0x01,0xf9,0x0c,0x04]

v_mad_u32_u16 v5, v1, exec_lo, v3
// GFX10: encoding: [0x05,0x00,0x73,0xd7,0x01,0xfd,0x0c,0x04]

v_mad_u32_u16 v5, v1, exec_hi, v3
// GFX10: encoding: [0x05,0x00,0x73,0xd7,0x01,0xff,0x0c,0x04]

v_mad_u32_u16 v5, v1, 0, v3
// GFX10: encoding: [0x05,0x00,0x73,0xd7,0x01,0x01,0x0d,0x04]

v_mad_u32_u16 v5, v1, -1, v3
// GFX10: encoding: [0x05,0x00,0x73,0xd7,0x01,0x83,0x0d,0x04]

v_mad_u32_u16 v5, v1, 0.5, v3
// GFX10: encoding: [0x05,0x00,0x73,0xd7,0x01,0xff,0x0d,0x04,0x00,0x38,0x00,0x00]

v_mad_u32_u16 v5, v1, -4.0, v3
// GFX10: encoding: [0x05,0x00,0x73,0xd7,0x01,0xff,0x0d,0x04,0x00,0xc4,0x00,0x00]

v_mad_u32_u16 v5, v1, v2, v255
// GFX10: encoding: [0x05,0x00,0x73,0xd7,0x01,0x05,0xfe,0x07]

v_mad_u32_u16 v5, v1, v2, s3
// GFX10: encoding: [0x05,0x00,0x73,0xd7,0x01,0x05,0x0e,0x00]

v_mad_u32_u16 v5, v1, v2, s101
// GFX10: encoding: [0x05,0x00,0x73,0xd7,0x01,0x05,0x96,0x01]

v_mad_u32_u16 v5, v1, v2, vcc_lo
// GFX10: encoding: [0x05,0x00,0x73,0xd7,0x01,0x05,0xaa,0x01]

v_mad_u32_u16 v5, v1, v2, vcc_hi
// GFX10: encoding: [0x05,0x00,0x73,0xd7,0x01,0x05,0xae,0x01]

v_mad_u32_u16 v5, v1, v2, m0
// GFX10: encoding: [0x05,0x00,0x73,0xd7,0x01,0x05,0xf2,0x01]

v_mad_u32_u16 v5, v1, v2, exec_lo
// GFX10: encoding: [0x05,0x00,0x73,0xd7,0x01,0x05,0xfa,0x01]

v_mad_u32_u16 v5, v1, v2, exec_hi
// GFX10: encoding: [0x05,0x00,0x73,0xd7,0x01,0x05,0xfe,0x01]

v_mad_u32_u16 v5, v1, v2, 0
// GFX10: encoding: [0x05,0x00,0x73,0xd7,0x01,0x05,0x02,0x02]

v_mad_u32_u16 v5, v1, v2, -1
// GFX10: encoding: [0x05,0x00,0x73,0xd7,0x01,0x05,0x06,0x03]

v_mad_u32_u16 v5, v1, v2, 0.5
// GFX10: encoding: [0x05,0x00,0x73,0xd7,0x01,0x05,0xc2,0x03]

v_mad_u32_u16 v5, v1, v2, -4.0
// GFX10: encoding: [0x05,0x00,0x73,0xd7,0x01,0x05,0xde,0x03]

v_mad_u32_u16 v5, v1, v2, v3 op_sel:[0,0,0,0]
// GFX10: encoding: [0x05,0x00,0x73,0xd7,0x01,0x05,0x0e,0x04]

v_mad_u32_u16 v5, v1, v2, v3 op_sel:[1,0,0,0]
// GFX10: encoding: [0x05,0x08,0x73,0xd7,0x01,0x05,0x0e,0x04]

v_mad_u32_u16 v5, v1, v2, v3 op_sel:[0,1,0,0]
// GFX10: encoding: [0x05,0x10,0x73,0xd7,0x01,0x05,0x0e,0x04]

v_mad_u32_u16 v5, v1, v2, v3 op_sel:[0,0,1,0]
// GFX10: encoding: [0x05,0x20,0x73,0xd7,0x01,0x05,0x0e,0x04]

v_mad_u32_u16 v5, v1, v2, v3 op_sel:[0,0,0,1]
// GFX10: encoding: [0x05,0x40,0x73,0xd7,0x01,0x05,0x0e,0x04]

v_mad_u32_u16 v5, v1, v2, v3 op_sel:[1,1,1,1]
// GFX10: encoding: [0x05,0x78,0x73,0xd7,0x01,0x05,0x0e,0x04]

v_mad_u32_u16 v5, v1, v2, v3 clamp
// GFX10: encoding: [0x05,0x80,0x73,0xd7,0x01,0x05,0x0e,0x04]

v_mad_i32_i16 v5, v1, v2, v3
// GFX10: encoding: [0x05,0x00,0x75,0xd7,0x01,0x05,0x0e,0x04]

v_mad_i32_i16 v255, v1, v2, v3
// GFX10: encoding: [0xff,0x00,0x75,0xd7,0x01,0x05,0x0e,0x04]

v_mad_i32_i16 v5, v255, v2, v3
// GFX10: encoding: [0x05,0x00,0x75,0xd7,0xff,0x05,0x0e,0x04]

v_mad_i32_i16 v5, s1, v2, v3
// GFX10: encoding: [0x05,0x00,0x75,0xd7,0x01,0x04,0x0e,0x04]

v_mad_i32_i16 v5, s101, v2, v3
// GFX10: encoding: [0x05,0x00,0x75,0xd7,0x65,0x04,0x0e,0x04]

v_mad_i32_i16 v5, vcc_lo, v2, v3
// GFX10: encoding: [0x05,0x00,0x75,0xd7,0x6a,0x04,0x0e,0x04]

v_mad_i32_i16 v5, vcc_hi, v2, v3
// GFX10: encoding: [0x05,0x00,0x75,0xd7,0x6b,0x04,0x0e,0x04]

v_mad_i32_i16 v5, m0, v2, v3
// GFX10: encoding: [0x05,0x00,0x75,0xd7,0x7c,0x04,0x0e,0x04]

v_mad_i32_i16 v5, exec_lo, v2, v3
// GFX10: encoding: [0x05,0x00,0x75,0xd7,0x7e,0x04,0x0e,0x04]

v_mad_i32_i16 v5, exec_hi, v2, v3
// GFX10: encoding: [0x05,0x00,0x75,0xd7,0x7f,0x04,0x0e,0x04]

v_mad_i32_i16 v5, 0, v2, v3
// GFX10: encoding: [0x05,0x00,0x75,0xd7,0x80,0x04,0x0e,0x04]

v_mad_i32_i16 v5, -1, v2, v3
// GFX10: encoding: [0x05,0x00,0x75,0xd7,0xc1,0x04,0x0e,0x04]

v_mad_i32_i16 v5, 0.5, v2, v3
// GFX10: encoding: [0x05,0x00,0x75,0xd7,0xff,0x04,0x0e,0x04,0x00,0x38,0x00,0x00]

v_mad_i32_i16 v5, -4.0, v2, v3
// GFX10: encoding: [0x05,0x00,0x75,0xd7,0xff,0x04,0x0e,0x04,0x00,0xc4,0x00,0x00]

v_mad_i32_i16 v5, v1, v255, v3
// GFX10: encoding: [0x05,0x00,0x75,0xd7,0x01,0xff,0x0f,0x04]

v_mad_i32_i16 v5, v1, s2, v3
// GFX10: encoding: [0x05,0x00,0x75,0xd7,0x01,0x05,0x0c,0x04]

v_mad_i32_i16 v5, v1, s101, v3
// GFX10: encoding: [0x05,0x00,0x75,0xd7,0x01,0xcb,0x0c,0x04]

v_mad_i32_i16 v5, v1, vcc_lo, v3
// GFX10: encoding: [0x05,0x00,0x75,0xd7,0x01,0xd5,0x0c,0x04]

v_mad_i32_i16 v5, v1, vcc_hi, v3
// GFX10: encoding: [0x05,0x00,0x75,0xd7,0x01,0xd7,0x0c,0x04]

v_mad_i32_i16 v5, v1, m0, v3
// GFX10: encoding: [0x05,0x00,0x75,0xd7,0x01,0xf9,0x0c,0x04]

v_mad_i32_i16 v5, v1, exec_lo, v3
// GFX10: encoding: [0x05,0x00,0x75,0xd7,0x01,0xfd,0x0c,0x04]

v_mad_i32_i16 v5, v1, exec_hi, v3
// GFX10: encoding: [0x05,0x00,0x75,0xd7,0x01,0xff,0x0c,0x04]

v_mad_i32_i16 v5, v1, 0, v3
// GFX10: encoding: [0x05,0x00,0x75,0xd7,0x01,0x01,0x0d,0x04]

v_mad_i32_i16 v5, v1, -1, v3
// GFX10: encoding: [0x05,0x00,0x75,0xd7,0x01,0x83,0x0d,0x04]

v_mad_i32_i16 v5, v1, 0.5, v3
// GFX10: encoding: [0x05,0x00,0x75,0xd7,0x01,0xff,0x0d,0x04,0x00,0x38,0x00,0x00]

v_mad_i32_i16 v5, v1, -4.0, v3
// GFX10: encoding: [0x05,0x00,0x75,0xd7,0x01,0xff,0x0d,0x04,0x00,0xc4,0x00,0x00]

v_mad_i32_i16 v5, v1, v2, v255
// GFX10: encoding: [0x05,0x00,0x75,0xd7,0x01,0x05,0xfe,0x07]

v_mad_i32_i16 v5, v1, v2, s3
// GFX10: encoding: [0x05,0x00,0x75,0xd7,0x01,0x05,0x0e,0x00]

v_mad_i32_i16 v5, v1, v2, s101
// GFX10: encoding: [0x05,0x00,0x75,0xd7,0x01,0x05,0x96,0x01]

v_mad_i32_i16 v5, v1, v2, vcc_lo
// GFX10: encoding: [0x05,0x00,0x75,0xd7,0x01,0x05,0xaa,0x01]

v_mad_i32_i16 v5, v1, v2, vcc_hi
// GFX10: encoding: [0x05,0x00,0x75,0xd7,0x01,0x05,0xae,0x01]

v_mad_i32_i16 v5, v1, v2, m0
// GFX10: encoding: [0x05,0x00,0x75,0xd7,0x01,0x05,0xf2,0x01]

v_mad_i32_i16 v5, v1, v2, exec_lo
// GFX10: encoding: [0x05,0x00,0x75,0xd7,0x01,0x05,0xfa,0x01]

v_mad_i32_i16 v5, v1, v2, exec_hi
// GFX10: encoding: [0x05,0x00,0x75,0xd7,0x01,0x05,0xfe,0x01]

v_mad_i32_i16 v5, v1, v2, 0
// GFX10: encoding: [0x05,0x00,0x75,0xd7,0x01,0x05,0x02,0x02]

v_mad_i32_i16 v5, v1, v2, -1
// GFX10: encoding: [0x05,0x00,0x75,0xd7,0x01,0x05,0x06,0x03]

v_mad_i32_i16 v5, v1, v2, 0.5
// GFX10: encoding: [0x05,0x00,0x75,0xd7,0x01,0x05,0xc2,0x03]

v_mad_i32_i16 v5, v1, v2, -4.0
// GFX10: encoding: [0x05,0x00,0x75,0xd7,0x01,0x05,0xde,0x03]

v_mad_i32_i16 v5, v1, v2, v3 op_sel:[0,0,0,0]
// GFX10: encoding: [0x05,0x00,0x75,0xd7,0x01,0x05,0x0e,0x04]

v_mad_i32_i16 v5, v1, v2, v3 op_sel:[1,0,0,0]
// GFX10: encoding: [0x05,0x08,0x75,0xd7,0x01,0x05,0x0e,0x04]

v_mad_i32_i16 v5, v1, v2, v3 op_sel:[0,1,0,0]
// GFX10: encoding: [0x05,0x10,0x75,0xd7,0x01,0x05,0x0e,0x04]

v_mad_i32_i16 v5, v1, v2, v3 op_sel:[0,0,1,0]
// GFX10: encoding: [0x05,0x20,0x75,0xd7,0x01,0x05,0x0e,0x04]

v_mad_i32_i16 v5, v1, v2, v3 op_sel:[0,0,0,1]
// GFX10: encoding: [0x05,0x40,0x75,0xd7,0x01,0x05,0x0e,0x04]

v_mad_i32_i16 v5, v1, v2, v3 op_sel:[1,1,1,1]
// GFX10: encoding: [0x05,0x78,0x75,0xd7,0x01,0x05,0x0e,0x04]

v_mad_i32_i16 v5, v1, v2, v3 clamp
// GFX10: encoding: [0x05,0x80,0x75,0xd7,0x01,0x05,0x0e,0x04]

v_sub_nc_i32 v5, v1, v2
// GFX10: encoding: [0x05,0x00,0x76,0xd7,0x01,0x05,0x02,0x00]

v_sub_nc_i32 v255, v1, v2
// GFX10: encoding: [0xff,0x00,0x76,0xd7,0x01,0x05,0x02,0x00]

v_sub_nc_i32 v5, v255, v2
// GFX10: encoding: [0x05,0x00,0x76,0xd7,0xff,0x05,0x02,0x00]

v_sub_nc_i32 v5, s1, v2
// GFX10: encoding: [0x05,0x00,0x76,0xd7,0x01,0x04,0x02,0x00]

v_sub_nc_i32 v5, s103, v2
// GFX10: encoding: [0x05,0x00,0x76,0xd7,0x67,0x04,0x02,0x00]

v_sub_nc_i32 v5, vcc_lo, v2
// GFX10: encoding: [0x05,0x00,0x76,0xd7,0x6a,0x04,0x02,0x00]

v_sub_nc_i32 v5, vcc_hi, v2
// GFX10: encoding: [0x05,0x00,0x76,0xd7,0x6b,0x04,0x02,0x00]

v_sub_nc_i32 v5, ttmp11, v2
// GFX10: encoding: [0x05,0x00,0x76,0xd7,0x77,0x04,0x02,0x00]

v_sub_nc_i32 v5, m0, v2
// GFX10: encoding: [0x05,0x00,0x76,0xd7,0x7c,0x04,0x02,0x00]

v_sub_nc_i32 v5, exec_lo, v2
// GFX10: encoding: [0x05,0x00,0x76,0xd7,0x7e,0x04,0x02,0x00]

v_sub_nc_i32 v5, exec_hi, v2
// GFX10: encoding: [0x05,0x00,0x76,0xd7,0x7f,0x04,0x02,0x00]

v_sub_nc_i32 v5, 0, v2
// GFX10: encoding: [0x05,0x00,0x76,0xd7,0x80,0x04,0x02,0x00]

v_sub_nc_i32 v5, -1, v2
// GFX10: encoding: [0x05,0x00,0x76,0xd7,0xc1,0x04,0x02,0x00]

v_sub_nc_i32 v5, 0.5, v2
// GFX10: encoding: [0x05,0x00,0x76,0xd7,0xf0,0x04,0x02,0x00]

v_sub_nc_i32 v5, -4.0, v2
// GFX10: encoding: [0x05,0x00,0x76,0xd7,0xf7,0x04,0x02,0x00]

v_sub_nc_i32 v5, v1, v255
// GFX10: encoding: [0x05,0x00,0x76,0xd7,0x01,0xff,0x03,0x00]

v_sub_nc_i32 v5, v1, s2
// GFX10: encoding: [0x05,0x00,0x76,0xd7,0x01,0x05,0x00,0x00]

v_sub_nc_i32 v5, v1, s103
// GFX10: encoding: [0x05,0x00,0x76,0xd7,0x01,0xcf,0x00,0x00]

v_sub_nc_i32 v5, v1, vcc_lo
// GFX10: encoding: [0x05,0x00,0x76,0xd7,0x01,0xd5,0x00,0x00]

v_sub_nc_i32 v5, v1, vcc_hi
// GFX10: encoding: [0x05,0x00,0x76,0xd7,0x01,0xd7,0x00,0x00]

v_sub_nc_i32 v5, v1, ttmp11
// GFX10: encoding: [0x05,0x00,0x76,0xd7,0x01,0xef,0x00,0x00]

v_sub_nc_i32 v5, v1, m0
// GFX10: encoding: [0x05,0x00,0x76,0xd7,0x01,0xf9,0x00,0x00]

v_sub_nc_i32 v5, v1, exec_lo
// GFX10: encoding: [0x05,0x00,0x76,0xd7,0x01,0xfd,0x00,0x00]

v_sub_nc_i32 v5, v1, exec_hi
// GFX10: encoding: [0x05,0x00,0x76,0xd7,0x01,0xff,0x00,0x00]

v_sub_nc_i32 v5, v1, 0
// GFX10: encoding: [0x05,0x00,0x76,0xd7,0x01,0x01,0x01,0x00]

v_sub_nc_i32 v5, v1, -1
// GFX10: encoding: [0x05,0x00,0x76,0xd7,0x01,0x83,0x01,0x00]

v_sub_nc_i32 v5, v1, 0.5
// GFX10: encoding: [0x05,0x00,0x76,0xd7,0x01,0xe1,0x01,0x00]

v_sub_nc_i32 v5, v1, -4.0
// GFX10: encoding: [0x05,0x00,0x76,0xd7,0x01,0xef,0x01,0x00]

v_sub_nc_i32 v5, v1, -4.0 clamp
// GFX10: v_sub_nc_i32 v5, v1, -4.0 clamp ; encoding: [0x05,0x80,0x76,0xd7,0x01,0xef,0x01,0x00]

v_permlane16_b32 v5, v1, v2, v3
// GFX10-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

v_permlane16_b32 v5, v1, v2, s3
// GFX10-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

v_permlane16_b32 v5, v1, s2, v3
// GFX10-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

v_permlane16_b32 v5, s1, s2, s3
// GFX10-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

v_permlane16_b32 v5, 0, s2, s3
// GFX10-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

v_permlane16_b32 v5, v1, s2, s3
// GFX10: encoding: [0x05,0x00,0x77,0xd7,0x01,0x05,0x0c,0x00]

v_permlane16_b32 v255, v1, s2, s3
// GFX10: encoding: [0xff,0x00,0x77,0xd7,0x01,0x05,0x0c,0x00]

v_permlane16_b32 v5, v255, s2, s3
// GFX10: encoding: [0x05,0x00,0x77,0xd7,0xff,0x05,0x0c,0x00]

v_permlane16_b32 v5, v103, s2, s3
// GFX10: encoding: [0x05,0x00,0x77,0xd7,0x67,0x05,0x0c,0x00]

v_permlane16_b32 v5, v1, vcc_lo, s2
// GFX10: encoding: [0x05,0x00,0x77,0xd7,0x01,0xd5,0x08,0x00]

v_permlane16_b32 v5, v1, vcc_hi, s2
// GFX10: encoding: [0x05,0x00,0x77,0xd7,0x01,0xd7,0x08,0x00]

v_permlane16_b32 v5, v1, ttmp11, s2
// GFX10: encoding: [0x05,0x00,0x77,0xd7,0x01,0xef,0x08,0x00]

v_permlane16_b32 v5, v1, m0, s2
// GFX10: encoding: [0x05,0x00,0x77,0xd7,0x01,0xf9,0x08,0x00]

v_permlane16_b32 v5, v1, exec_lo, s2
// GFX10: encoding: [0x05,0x00,0x77,0xd7,0x01,0xfd,0x08,0x00]

v_permlane16_b32 v5, v1, exec_hi, s2
// GFX10: encoding: [0x05,0x00,0x77,0xd7,0x01,0xff,0x08,0x00]

v_permlane16_b32 v5, v1, s103, s3
// GFX10: encoding: [0x05,0x00,0x77,0xd7,0x01,0xcf,0x0c,0x00]

v_permlane16_b32 v5, v1, vcc_lo, s3
// GFX10: encoding: [0x05,0x00,0x77,0xd7,0x01,0xd5,0x0c,0x00]

v_permlane16_b32 v5, v1, vcc_hi, s3
// GFX10: encoding: [0x05,0x00,0x77,0xd7,0x01,0xd7,0x0c,0x00]

v_permlane16_b32 v5, v1, ttmp11, s3
// GFX10: encoding: [0x05,0x00,0x77,0xd7,0x01,0xef,0x0c,0x00]

v_permlane16_b32 v5, v1, m0, s3
// GFX10: encoding: [0x05,0x00,0x77,0xd7,0x01,0xf9,0x0c,0x00]

v_permlane16_b32 v5, v1, exec_lo, s3
// GFX10: encoding: [0x05,0x00,0x77,0xd7,0x01,0xfd,0x0c,0x00]

v_permlane16_b32 v5, v1, exec_hi, s3
// GFX10: encoding: [0x05,0x00,0x77,0xd7,0x01,0xff,0x0c,0x00]

v_permlane16_b32 v5, v1, 0, s3
// GFX10: encoding: [0x05,0x00,0x77,0xd7,0x01,0x01,0x0d,0x00]

v_permlane16_b32 v5, v1, -1, s3
// GFX10: encoding: [0x05,0x00,0x77,0xd7,0x01,0x83,0x0d,0x00]

v_permlane16_b32 v5, v1, 0.5, s3
// GFX10: encoding: [0x05,0x00,0x77,0xd7,0x01,0xe1,0x0d,0x00]

v_permlane16_b32 v5, v1, -4.0, s3
// GFX10: encoding: [0x05,0x00,0x77,0xd7,0x01,0xef,0x0d,0x00]

v_permlane16_b32 v5, v1, s2, s103
// GFX10: encoding: [0x05,0x00,0x77,0xd7,0x01,0x05,0x9c,0x01]

v_permlane16_b32 v5, v1, s2, vcc_lo
// GFX10: encoding: [0x05,0x00,0x77,0xd7,0x01,0x05,0xa8,0x01]

v_permlane16_b32 v5, v1, s2, vcc_hi
// GFX10: encoding: [0x05,0x00,0x77,0xd7,0x01,0x05,0xac,0x01]

v_permlane16_b32 v5, v1, s2, ttmp11
// GFX10: encoding: [0x05,0x00,0x77,0xd7,0x01,0x05,0xdc,0x01]

v_permlane16_b32 v5, v1, s2, m0
// GFX10: encoding: [0x05,0x00,0x77,0xd7,0x01,0x05,0xf0,0x01]

v_permlane16_b32 v5, v1, s2, exec_lo
// GFX10: encoding: [0x05,0x00,0x77,0xd7,0x01,0x05,0xf8,0x01]

v_permlane16_b32 v5, v1, s2, exec_hi
// GFX10: encoding: [0x05,0x00,0x77,0xd7,0x01,0x05,0xfc,0x01]

v_permlane16_b32 v5, v1, s2, 0
// GFX10: encoding: [0x05,0x00,0x77,0xd7,0x01,0x05,0x00,0x02]

v_permlane16_b32 v5, v1, s2, -1
// GFX10: encoding: [0x05,0x00,0x77,0xd7,0x01,0x05,0x04,0x03]

v_permlane16_b32 v5, v1, s2, 0.5
// GFX10: encoding: [0x05,0x00,0x77,0xd7,0x01,0x05,0xc0,0x03]

v_permlane16_b32 v5, v1, s2, -4.0
// GFX10: encoding: [0x05,0x00,0x77,0xd7,0x01,0x05,0xdc,0x03]

v_permlane16_b32 v5, v1, s2, s3 op_sel:[1,0]
// GFX10: encoding: [0x05,0x08,0x77,0xd7,0x01,0x05,0x0c,0x00]

v_permlane16_b32 v5, v1, s2, s3 op_sel:[1,1]
// GFX10: encoding: [0x05,0x18,0x77,0xd7,0x01,0x05,0x0c,0x00]

v_permlane16_b32 v5, v1, s2, s3 op_sel:[0,1]
// GFX10: encoding: [0x05,0x10,0x77,0xd7,0x01,0x05,0x0c,0x00]

v_permlane16_b32 v5, v1, s2, s3 op_sel:[0, 0, 0, 1]
// GFX10-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid op_sel operand

v_permlane16_b32 v5, v1, s2, s3 op_sel:[0, 0, 1, 0]
// GFX10-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid op_sel operand

v_permlanex16_b32 v5, v1, v2, v3
// GFX10-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

v_permlanex16_b32 v5, v1, v2, s3
// GFX10-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

v_permlanex16_b32 v5, v1, s2, v3
// GFX10-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

v_permlanex16_b32 v5, s1, s2, s3
// GFX10-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

v_permlanex16_b32 v5, 0, s2, s3
// GFX10-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

v_permlanex16_b32 v5, v1, s2, s3
// GFX10: encoding: [0x05,0x00,0x78,0xd7,0x01,0x05,0x0c,0x00]

v_permlanex16_b32 v255, v1, s2, s3
// GFX10: encoding: [0xff,0x00,0x78,0xd7,0x01,0x05,0x0c,0x00]

v_permlanex16_b32 v5, v255, s2, s3
// GFX10: encoding: [0x05,0x00,0x78,0xd7,0xff,0x05,0x0c,0x00]

v_permlanex16_b32 v5, v103, s2, s3
// GFX10: encoding: [0x05,0x00,0x78,0xd7,0x67,0x05,0x0c,0x00]

v_permlanex16_b32 v5, v1, vcc_lo, s2
// GFX10: encoding: [0x05,0x00,0x78,0xd7,0x01,0xd5,0x08,0x00]

v_permlanex16_b32 v5, v1, vcc_hi, s2
// GFX10: encoding: [0x05,0x00,0x78,0xd7,0x01,0xd7,0x08,0x00]

v_permlanex16_b32 v5, v1, ttmp11, s2
// GFX10: encoding: [0x05,0x00,0x78,0xd7,0x01,0xef,0x08,0x00]

v_permlanex16_b32 v5, v1, m0, s2
// GFX10: encoding: [0x05,0x00,0x78,0xd7,0x01,0xf9,0x08,0x00]

v_permlanex16_b32 v5, v1, exec_lo, s2
// GFX10: encoding: [0x05,0x00,0x78,0xd7,0x01,0xfd,0x08,0x00]

v_permlanex16_b32 v5, v1, exec_hi, s2
// GFX10: encoding: [0x05,0x00,0x78,0xd7,0x01,0xff,0x08,0x00]

v_permlanex16_b32 v5, v1, s103, s3
// GFX10: encoding: [0x05,0x00,0x78,0xd7,0x01,0xcf,0x0c,0x00]

v_permlanex16_b32 v5, v1, vcc_lo, s3
// GFX10: encoding: [0x05,0x00,0x78,0xd7,0x01,0xd5,0x0c,0x00]

v_permlanex16_b32 v5, v1, vcc_hi, s3
// GFX10: encoding: [0x05,0x00,0x78,0xd7,0x01,0xd7,0x0c,0x00]

v_permlanex16_b32 v5, v1, ttmp11, s3
// GFX10: encoding: [0x05,0x00,0x78,0xd7,0x01,0xef,0x0c,0x00]

v_permlanex16_b32 v5, v1, m0, s3
// GFX10: encoding: [0x05,0x00,0x78,0xd7,0x01,0xf9,0x0c,0x00]

v_permlanex16_b32 v5, v1, exec_lo, s3
// GFX10: encoding: [0x05,0x00,0x78,0xd7,0x01,0xfd,0x0c,0x00]

v_permlanex16_b32 v5, v1, exec_hi, s3
// GFX10: encoding: [0x05,0x00,0x78,0xd7,0x01,0xff,0x0c,0x00]

v_permlanex16_b32 v5, v1, 0, s3
// GFX10: encoding: [0x05,0x00,0x78,0xd7,0x01,0x01,0x0d,0x00]

v_permlanex16_b32 v5, v1, -1, s3
// GFX10: encoding: [0x05,0x00,0x78,0xd7,0x01,0x83,0x0d,0x00]

v_permlanex16_b32 v5, v1, 0.5, s3
// GFX10: encoding: [0x05,0x00,0x78,0xd7,0x01,0xe1,0x0d,0x00]

v_permlanex16_b32 v5, v1, -4.0, s3
// GFX10: encoding: [0x05,0x00,0x78,0xd7,0x01,0xef,0x0d,0x00]

v_permlanex16_b32 v5, v1, s2, s103
// GFX10: encoding: [0x05,0x00,0x78,0xd7,0x01,0x05,0x9c,0x01]

v_permlanex16_b32 v5, v1, s2, vcc_lo
// GFX10: encoding: [0x05,0x00,0x78,0xd7,0x01,0x05,0xa8,0x01]

v_permlanex16_b32 v5, v1, s2, vcc_hi
// GFX10: encoding: [0x05,0x00,0x78,0xd7,0x01,0x05,0xac,0x01]

v_permlanex16_b32 v5, v1, s2, ttmp11
// GFX10: encoding: [0x05,0x00,0x78,0xd7,0x01,0x05,0xdc,0x01]

v_permlanex16_b32 v5, v1, s2, m0
// GFX10: encoding: [0x05,0x00,0x78,0xd7,0x01,0x05,0xf0,0x01]

v_permlanex16_b32 v5, v1, s2, exec_lo
// GFX10: encoding: [0x05,0x00,0x78,0xd7,0x01,0x05,0xf8,0x01]

v_permlanex16_b32 v5, v1, s2, exec_hi
// GFX10: encoding: [0x05,0x00,0x78,0xd7,0x01,0x05,0xfc,0x01]

v_permlanex16_b32 v5, v1, s2, 0
// GFX10: encoding: [0x05,0x00,0x78,0xd7,0x01,0x05,0x00,0x02]

v_permlanex16_b32 v5, v1, s2, -1
// GFX10: encoding: [0x05,0x00,0x78,0xd7,0x01,0x05,0x04,0x03]

v_permlanex16_b32 v5, v1, s2, 0.5
// GFX10: encoding: [0x05,0x00,0x78,0xd7,0x01,0x05,0xc0,0x03]

v_permlanex16_b32 v5, v1, s2, -4.0
// GFX10: encoding: [0x05,0x00,0x78,0xd7,0x01,0x05,0xdc,0x03]

v_permlanex16_b32 v5, v1, s2, s3 op_sel:[1,0]
// GFX10: encoding: [0x05,0x08,0x78,0xd7,0x01,0x05,0x0c,0x00]

v_permlanex16_b32 v5, v1, s2, s3 op_sel:[1,1]
// GFX10: encoding: [0x05,0x18,0x78,0xd7,0x01,0x05,0x0c,0x00]

v_permlanex16_b32 v5, v1, s2, s3 op_sel:[0,1]
// GFX10: encoding: [0x05,0x10,0x78,0xd7,0x01,0x05,0x0c,0x00]

v_permlanex16_b32 v5, v1, s2, s3 op_sel:[0, 0, 0, 1]
// GFX10-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid op_sel operand

v_permlanex16_b32 v5, v1, s2, s3 op_sel:[0, 0, 1, 0]
// GFX10-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid op_sel operand

v_add_nc_i32 v5, v1, v2
// GFX10: encoding: [0x05,0x00,0x7f,0xd7,0x01,0x05,0x02,0x00]

v_add_nc_i32 v255, v1, v2
// GFX10: encoding: [0xff,0x00,0x7f,0xd7,0x01,0x05,0x02,0x00]

v_add_nc_i32 v5, v255, v2
// GFX10: encoding: [0x05,0x00,0x7f,0xd7,0xff,0x05,0x02,0x00]

v_add_nc_i32 v5, s1, v2
// GFX10: encoding: [0x05,0x00,0x7f,0xd7,0x01,0x04,0x02,0x00]

v_add_nc_i32 v5, s103, v2
// GFX10: encoding: [0x05,0x00,0x7f,0xd7,0x67,0x04,0x02,0x00]

v_add_nc_i32 v5, vcc_lo, v2
// GFX10: encoding: [0x05,0x00,0x7f,0xd7,0x6a,0x04,0x02,0x00]

v_add_nc_i32 v5, vcc_hi, v2
// GFX10: encoding: [0x05,0x00,0x7f,0xd7,0x6b,0x04,0x02,0x00]

v_add_nc_i32 v5, ttmp11, v2
// GFX10: encoding: [0x05,0x00,0x7f,0xd7,0x77,0x04,0x02,0x00]

v_add_nc_i32 v5, m0, v2
// GFX10: encoding: [0x05,0x00,0x7f,0xd7,0x7c,0x04,0x02,0x00]

v_add_nc_i32 v5, exec_lo, v2
// GFX10: encoding: [0x05,0x00,0x7f,0xd7,0x7e,0x04,0x02,0x00]

v_add_nc_i32 v5, exec_hi, v2
// GFX10: encoding: [0x05,0x00,0x7f,0xd7,0x7f,0x04,0x02,0x00]

v_add_nc_i32 v5, 0, v2
// GFX10: encoding: [0x05,0x00,0x7f,0xd7,0x80,0x04,0x02,0x00]

v_add_nc_i32 v5, -1, v2
// GFX10: encoding: [0x05,0x00,0x7f,0xd7,0xc1,0x04,0x02,0x00]

v_add_nc_i32 v5, 0.5, v2
// GFX10: encoding: [0x05,0x00,0x7f,0xd7,0xf0,0x04,0x02,0x00]

v_add_nc_i32 v5, -4.0, v2
// GFX10: encoding: [0x05,0x00,0x7f,0xd7,0xf7,0x04,0x02,0x00]

v_add_nc_i32 v5, v1, v255
// GFX10: encoding: [0x05,0x00,0x7f,0xd7,0x01,0xff,0x03,0x00]

v_add_nc_i32 v5, v1, s2
// GFX10: encoding: [0x05,0x00,0x7f,0xd7,0x01,0x05,0x00,0x00]

v_add_nc_i32 v5, v1, s103
// GFX10: encoding: [0x05,0x00,0x7f,0xd7,0x01,0xcf,0x00,0x00]

v_add_nc_i32 v5, v1, vcc_lo
// GFX10: encoding: [0x05,0x00,0x7f,0xd7,0x01,0xd5,0x00,0x00]

v_add_nc_i32 v5, v1, vcc_hi
// GFX10: encoding: [0x05,0x00,0x7f,0xd7,0x01,0xd7,0x00,0x00]

v_add_nc_i32 v5, v1, ttmp11
// GFX10: encoding: [0x05,0x00,0x7f,0xd7,0x01,0xef,0x00,0x00]

v_add_nc_i32 v5, v1, m0
// GFX10: encoding: [0x05,0x00,0x7f,0xd7,0x01,0xf9,0x00,0x00]

v_add_nc_i32 v5, v1, exec_lo
// GFX10: encoding: [0x05,0x00,0x7f,0xd7,0x01,0xfd,0x00,0x00]

v_add_nc_i32 v5, v1, exec_hi
// GFX10: encoding: [0x05,0x00,0x7f,0xd7,0x01,0xff,0x00,0x00]

v_add_nc_i32 v5, v1, 0
// GFX10: encoding: [0x05,0x00,0x7f,0xd7,0x01,0x01,0x01,0x00]

v_add_nc_i32 v5, v1, -1
// GFX10: encoding: [0x05,0x00,0x7f,0xd7,0x01,0x83,0x01,0x00]

v_add_nc_i32 v5, v1, 0.5
// GFX10: encoding: [0x05,0x00,0x7f,0xd7,0x01,0xe1,0x01,0x00]

v_add_nc_i32 v5, v1, -4.0
// GFX10: encoding: [0x05,0x00,0x7f,0xd7,0x01,0xef,0x01,0x00]

v_add_nc_i32 v5, v1, -4.0 clamp
// GFX10: v_add_nc_i32 v5, v1, -4.0 clamp ; encoding: [0x05,0x80,0x7f,0xd7,0x01,0xef,0x01,0x00]

//===----------------------------------------------------------------------===//
// ENC_VOP3 INTERP.
//===----------------------------------------------------------------------===//

v_interp_p1_f32_e64 v5, v2, attr0.x
// GFX10: v_interp_p1_f32_e64 v5, v2, attr0.x ; encoding: [0x05,0x00,0x00,0xd6,0x00,0x04,0x02,0x00]

v_interp_p1_f32_e64 v255, v2, attr0.x
// GFX10: v_interp_p1_f32_e64 v255, v2, attr0.x ; encoding: [0xff,0x00,0x00,0xd6,0x00,0x04,0x02,0x00]

v_interp_p1_f32_e64 v5, v2, attr1.x
// GFX10: v_interp_p1_f32_e64 v5, v2, attr1.x ; encoding: [0x05,0x00,0x00,0xd6,0x01,0x04,0x02,0x00]

v_interp_p1_f32_e64 v5, v2, attr31.x
// GFX10: v_interp_p1_f32_e64 v5, v2, attr31.x ; encoding: [0x05,0x00,0x00,0xd6,0x1f,0x04,0x02,0x00]

v_interp_p1_f32_e64 v5, v2, attr32.x
// GFX10: v_interp_p1_f32_e64 v5, v2, attr32.x ; encoding: [0x05,0x00,0x00,0xd6,0x20,0x04,0x02,0x00]

v_interp_p1_f32_e64 v5, v255, attr0.x
// GFX10: v_interp_p1_f32_e64 v5, v255, attr0.x ; encoding: [0x05,0x00,0x00,0xd6,0x00,0xfe,0x03,0x00]

v_interp_p1_f32_e64 v5, -v2, attr0.x
// GFX10: v_interp_p1_f32_e64 v5, -v2, attr0.x ; encoding: [0x05,0x00,0x00,0xd6,0x00,0x04,0x02,0x40]

v_interp_p1_f32_e64 v5, |v2|, attr0.x
// GFX10: v_interp_p1_f32_e64 v5, |v2|, attr0.x ; encoding: [0x05,0x02,0x00,0xd6,0x00,0x04,0x02,0x00]

v_interp_p1_f32_e64 v5, v2, attr0.y
// GFX10: v_interp_p1_f32_e64 v5, v2, attr0.y ; encoding: [0x05,0x00,0x00,0xd6,0x40,0x04,0x02,0x00]

v_interp_p1_f32_e64 v5, v2, attr0.z
// GFX10: v_interp_p1_f32_e64 v5, v2, attr0.z ; encoding: [0x05,0x00,0x00,0xd6,0x80,0x04,0x02,0x00]

v_interp_p1_f32_e64 v5, v2, attr0.w
// GFX10: v_interp_p1_f32_e64 v5, v2, attr0.w ; encoding: [0x05,0x00,0x00,0xd6,0xc0,0x04,0x02,0x00]

v_interp_p1_f32_e64 v5, v2, attr0.x clamp
// GFX10: v_interp_p1_f32_e64 v5, v2, attr0.x clamp ; encoding: [0x05,0x80,0x00,0xd6,0x00,0x04,0x02,0x00]

v_interp_p1_f32_e64 v5, v2, attr0.x mul:2
// GFX10: v_interp_p1_f32_e64 v5, v2, attr0.x mul:2 ; encoding: [0x05,0x00,0x00,0xd6,0x00,0x04,0x02,0x08]

v_interp_p1_f32_e64 v5, v2, attr0.x mul:4
// GFX10: v_interp_p1_f32_e64 v5, v2, attr0.x mul:4 ; encoding: [0x05,0x00,0x00,0xd6,0x00,0x04,0x02,0x10]

v_interp_p1_f32_e64 v5, v2, attr0.x div:2
// GFX10: v_interp_p1_f32_e64 v5, v2, attr0.x div:2 ; encoding: [0x05,0x00,0x00,0xd6,0x00,0x04,0x02,0x18]

v_interp_p2_f32_e64 v5, v2, attr0.x
// GFX10: v_interp_p2_f32_e64 v5, v2, attr0.x ; encoding: [0x05,0x00,0x01,0xd6,0x00,0x04,0x02,0x00]

v_interp_p2_f32_e64 v255, v2, attr0.x
// GFX10: v_interp_p2_f32_e64 v255, v2, attr0.x ; encoding: [0xff,0x00,0x01,0xd6,0x00,0x04,0x02,0x00]

v_interp_p2_f32_e64 v5, v2, attr1.x
// GFX10: v_interp_p2_f32_e64 v5, v2, attr1.x ; encoding: [0x05,0x00,0x01,0xd6,0x01,0x04,0x02,0x00]

v_interp_p2_f32_e64 v5, v2, attr31.x
// GFX10: v_interp_p2_f32_e64 v5, v2, attr31.x ; encoding: [0x05,0x00,0x01,0xd6,0x1f,0x04,0x02,0x00]

v_interp_p2_f32_e64 v5, v2, attr32.x
// GFX10: v_interp_p2_f32_e64 v5, v2, attr32.x ; encoding: [0x05,0x00,0x01,0xd6,0x20,0x04,0x02,0x00]

v_interp_p2_f32_e64 v5, v255, attr0.x
// GFX10: v_interp_p2_f32_e64 v5, v255, attr0.x ; encoding: [0x05,0x00,0x01,0xd6,0x00,0xfe,0x03,0x00]

v_interp_p2_f32_e64 v5, -v2, attr0.x
// GFX10: v_interp_p2_f32_e64 v5, -v2, attr0.x ; encoding: [0x05,0x00,0x01,0xd6,0x00,0x04,0x02,0x40]

v_interp_p2_f32_e64 v5, |v2|, attr0.x
// GFX10: v_interp_p2_f32_e64 v5, |v2|, attr0.x ; encoding: [0x05,0x02,0x01,0xd6,0x00,0x04,0x02,0x00]

v_interp_p2_f32_e64 v5, v2, attr0.y
// GFX10: v_interp_p2_f32_e64 v5, v2, attr0.y ; encoding: [0x05,0x00,0x01,0xd6,0x40,0x04,0x02,0x00]

v_interp_p2_f32_e64 v5, v2, attr0.z
// GFX10: v_interp_p2_f32_e64 v5, v2, attr0.z ; encoding: [0x05,0x00,0x01,0xd6,0x80,0x04,0x02,0x00]

v_interp_p2_f32_e64 v5, v2, attr0.w
// GFX10: v_interp_p2_f32_e64 v5, v2, attr0.w ; encoding: [0x05,0x00,0x01,0xd6,0xc0,0x04,0x02,0x00]

v_interp_p2_f32_e64 v5, v2, attr0.x clamp
// GFX10: v_interp_p2_f32_e64 v5, v2, attr0.x clamp ; encoding: [0x05,0x80,0x01,0xd6,0x00,0x04,0x02,0x00]

v_interp_p2_f32_e64 v5, v2, attr0.x mul:2
// GFX10: v_interp_p2_f32_e64 v5, v2, attr0.x mul:2 ; encoding: [0x05,0x00,0x01,0xd6,0x00,0x04,0x02,0x08]

v_interp_p2_f32_e64 v5, v2, attr0.x mul:4
// GFX10: v_interp_p2_f32_e64 v5, v2, attr0.x mul:4 ; encoding: [0x05,0x00,0x01,0xd6,0x00,0x04,0x02,0x10]

v_interp_p2_f32_e64 v5, v2, attr0.x div:2
// GFX10: v_interp_p2_f32_e64 v5, v2, attr0.x div:2 ; encoding: [0x05,0x00,0x01,0xd6,0x00,0x04,0x02,0x18]

v_interp_mov_f32_e64 v5, p10, attr0.x
// GFX10: v_interp_mov_f32_e64 v5, p10, attr0.x ; encoding: [0x05,0x00,0x02,0xd6,0x00,0x00,0x00,0x00]

v_interp_mov_f32_e64 v255, p10, attr0.x
// GFX10: v_interp_mov_f32_e64 v255, p10, attr0.x ; encoding: [0xff,0x00,0x02,0xd6,0x00,0x00,0x00,0x00]

v_interp_mov_f32_e64 v5, p10, attr1.x
// GFX10: v_interp_mov_f32_e64 v5, p10, attr1.x ; encoding: [0x05,0x00,0x02,0xd6,0x01,0x00,0x00,0x00]

v_interp_mov_f32_e64 v5, p10, attr31.x
// GFX10: v_interp_mov_f32_e64 v5, p10, attr31.x ; encoding: [0x05,0x00,0x02,0xd6,0x1f,0x00,0x00,0x00]

v_interp_mov_f32_e64 v5, p10, attr32.x
// GFX10: v_interp_mov_f32_e64 v5, p10, attr32.x ; encoding: [0x05,0x00,0x02,0xd6,0x20,0x00,0x00,0x00]

v_interp_mov_f32_e64 v5, p20, attr0.x
// GFX10: v_interp_mov_f32_e64 v5, p20, attr0.x ; encoding: [0x05,0x00,0x02,0xd6,0x00,0x02,0x00,0x00]

v_interp_mov_f32_e64 v5, p0, attr0.x
// GFX10: v_interp_mov_f32_e64 v5, p0, attr0.x ; encoding: [0x05,0x00,0x02,0xd6,0x00,0x04,0x00,0x00]

v_interp_mov_f32_e64 v5, p10, attr0.y
// GFX10: v_interp_mov_f32_e64 v5, p10, attr0.y ; encoding: [0x05,0x00,0x02,0xd6,0x40,0x00,0x00,0x00]

v_interp_mov_f32_e64 v5, p10, attr0.z
// GFX10: v_interp_mov_f32_e64 v5, p10, attr0.z ; encoding: [0x05,0x00,0x02,0xd6,0x80,0x00,0x00,0x00]

v_interp_mov_f32_e64 v5, p10, attr0.w
// GFX10: v_interp_mov_f32_e64 v5, p10, attr0.w ; encoding: [0x05,0x00,0x02,0xd6,0xc0,0x00,0x00,0x00]

v_interp_mov_f32_e64 v5, p10, attr0.x clamp
// GFX10: v_interp_mov_f32_e64 v5, p10, attr0.x clamp ; encoding: [0x05,0x80,0x02,0xd6,0x00,0x00,0x00,0x00]

v_interp_mov_f32_e64 v5, p10, attr0.x mul:2
// GFX10: v_interp_mov_f32_e64 v5, p10, attr0.x mul:2 ; encoding: [0x05,0x00,0x02,0xd6,0x00,0x00,0x00,0x08]

v_interp_mov_f32_e64 v5, p10, attr0.x mul:4
// GFX10: v_interp_mov_f32_e64 v5, p10, attr0.x mul:4 ; encoding: [0x05,0x00,0x02,0xd6,0x00,0x00,0x00,0x10]

v_interp_mov_f32_e64 v5, p10, attr0.x div:2
// GFX10: v_interp_mov_f32_e64 v5, p10, attr0.x div:2 ; encoding: [0x05,0x00,0x02,0xd6,0x00,0x00,0x00,0x18]
