; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i686-unknown-unknown -mattr=+sse2 -O3 | FileCheck %s --check-prefixes=SSE-32
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+sse2 -O3 | FileCheck %s --check-prefixes=SSE-64
; RUN: llc < %s -mtriple=i686-unknown-unknown -mattr=+avx -O3 | FileCheck %s --check-prefixes=AVX-32
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx -O3 | FileCheck %s --check-prefixes=AVX-64
; RUN: llc < %s -mtriple=i686-unknown-unknown -mattr=+avx512f -mattr=+avx512vl -O3 | FileCheck %s --check-prefixes=AVX512-32
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512f -mattr=+avx512vl -O3 | FileCheck %s --check-prefixes=AVX512-64
; RUN: llc < %s -mtriple=i686-unknown-unknown -mattr=+avx512f -O3 | FileCheck %s --check-prefixes=AVX512F-32
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512f -O3 | FileCheck %s --check-prefixes=AVX512F-64

define <4 x i32> @test_v4f32_oeq_q(<4 x i32> %a, <4 x i32> %b, <4 x float> %f1, <4 x float> %f2) #0 {
; SSE-32-LABEL: test_v4f32_oeq_q:
; SSE-32:       # %bb.0:
; SSE-32-NEXT:    pushl %ebp
; SSE-32-NEXT:    movl %esp, %ebp
; SSE-32-NEXT:    andl $-16, %esp
; SSE-32-NEXT:    subl $16, %esp
; SSE-32-NEXT:    cmpeqps 8(%ebp), %xmm2
; SSE-32-NEXT:    andps %xmm2, %xmm0
; SSE-32-NEXT:    andnps %xmm1, %xmm2
; SSE-32-NEXT:    orps %xmm2, %xmm0
; SSE-32-NEXT:    movl %ebp, %esp
; SSE-32-NEXT:    popl %ebp
; SSE-32-NEXT:    retl
;
; SSE-64-LABEL: test_v4f32_oeq_q:
; SSE-64:       # %bb.0:
; SSE-64-NEXT:    cmpeqps %xmm3, %xmm2
; SSE-64-NEXT:    andps %xmm2, %xmm0
; SSE-64-NEXT:    andnps %xmm1, %xmm2
; SSE-64-NEXT:    orps %xmm2, %xmm0
; SSE-64-NEXT:    retq
;
; AVX-32-LABEL: test_v4f32_oeq_q:
; AVX-32:       # %bb.0:
; AVX-32-NEXT:    pushl %ebp
; AVX-32-NEXT:    movl %esp, %ebp
; AVX-32-NEXT:    andl $-16, %esp
; AVX-32-NEXT:    subl $16, %esp
; AVX-32-NEXT:    vcmpeqps 8(%ebp), %xmm2, %xmm2
; AVX-32-NEXT:    vblendvps %xmm2, %xmm0, %xmm1, %xmm0
; AVX-32-NEXT:    movl %ebp, %esp
; AVX-32-NEXT:    popl %ebp
; AVX-32-NEXT:    retl
;
; AVX-64-LABEL: test_v4f32_oeq_q:
; AVX-64:       # %bb.0:
; AVX-64-NEXT:    vcmpeqps %xmm3, %xmm2, %xmm2
; AVX-64-NEXT:    vblendvps %xmm2, %xmm0, %xmm1, %xmm0
; AVX-64-NEXT:    retq
;
; AVX512-32-LABEL: test_v4f32_oeq_q:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-16, %esp
; AVX512-32-NEXT:    subl $16, %esp
; AVX512-32-NEXT:    vcmpeqps 8(%ebp), %xmm2, %k1
; AVX512-32-NEXT:    vpblendmd %xmm0, %xmm1, %xmm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v4f32_oeq_q:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmpeqps %xmm3, %xmm2, %k1
; AVX512-64-NEXT:    vpblendmd %xmm0, %xmm1, %xmm0 {%k1}
; AVX512-64-NEXT:    retq
;
; AVX512F-32-LABEL: test_v4f32_oeq_q:
; AVX512F-32:       # %bb.0:
; AVX512F-32-NEXT:    pushl %ebp
; AVX512F-32-NEXT:    movl %esp, %ebp
; AVX512F-32-NEXT:    andl $-16, %esp
; AVX512F-32-NEXT:    subl $16, %esp
; AVX512F-32-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-32-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-32-NEXT:    vcmpeqps 8(%ebp), %xmm2, %xmm2
; AVX512F-32-NEXT:    vptestmd %zmm2, %zmm2, %k1
; AVX512F-32-NEXT:    vpblendmd %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-32-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-32-NEXT:    movl %ebp, %esp
; AVX512F-32-NEXT:    popl %ebp
; AVX512F-32-NEXT:    vzeroupper
; AVX512F-32-NEXT:    retl
;
; AVX512F-64-LABEL: test_v4f32_oeq_q:
; AVX512F-64:       # %bb.0:
; AVX512F-64-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-64-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-64-NEXT:    vcmpeqps %xmm3, %xmm2, %xmm2
; AVX512F-64-NEXT:    vptestmd %zmm2, %zmm2, %k1
; AVX512F-64-NEXT:    vpblendmd %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-64-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-64-NEXT:    vzeroupper
; AVX512F-64-NEXT:    retq
  %cond = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f32(
                                               <4 x float> %f1, <4 x float> %f2, metadata !"oeq",
                                               metadata !"fpexcept.strict") #0
  %res = select <4 x i1> %cond, <4 x i32> %a, <4 x i32> %b
  ret <4 x i32> %res
}

define <4 x i32> @test_v4f32_ogt_q(<4 x i32> %a, <4 x i32> %b, <4 x float> %f1, <4 x float> %f2) #0 {
; SSE-32-LABEL: test_v4f32_ogt_q:
; SSE-32:       # %bb.0:
; SSE-32-NEXT:    pushl %ebp
; SSE-32-NEXT:    movl %esp, %ebp
; SSE-32-NEXT:    andl $-16, %esp
; SSE-32-NEXT:    subl $16, %esp
; SSE-32-NEXT:    movaps 8(%ebp), %xmm3
; SSE-32-NEXT:    movaps %xmm3, %xmm4
; SSE-32-NEXT:    shufps {{.*#+}} xmm4 = xmm4[3,3],xmm3[3,3]
; SSE-32-NEXT:    movaps %xmm2, %xmm5
; SSE-32-NEXT:    shufps {{.*#+}} xmm5 = xmm5[3,3],xmm2[3,3]
; SSE-32-NEXT:    xorl %eax, %eax
; SSE-32-NEXT:    ucomiss %xmm4, %xmm5
; SSE-32-NEXT:    movl $-1, %ecx
; SSE-32-NEXT:    movl $0, %edx
; SSE-32-NEXT:    cmoval %ecx, %edx
; SSE-32-NEXT:    movd %edx, %xmm4
; SSE-32-NEXT:    movaps %xmm3, %xmm5
; SSE-32-NEXT:    unpckhpd {{.*#+}} xmm5 = xmm5[1],xmm3[1]
; SSE-32-NEXT:    movaps %xmm2, %xmm6
; SSE-32-NEXT:    unpckhpd {{.*#+}} xmm6 = xmm6[1],xmm2[1]
; SSE-32-NEXT:    ucomiss %xmm5, %xmm6
; SSE-32-NEXT:    movl $0, %edx
; SSE-32-NEXT:    cmoval %ecx, %edx
; SSE-32-NEXT:    movd %edx, %xmm5
; SSE-32-NEXT:    punpckldq {{.*#+}} xmm5 = xmm5[0],xmm4[0],xmm5[1],xmm4[1]
; SSE-32-NEXT:    ucomiss %xmm3, %xmm2
; SSE-32-NEXT:    movl $0, %edx
; SSE-32-NEXT:    cmoval %ecx, %edx
; SSE-32-NEXT:    movd %edx, %xmm4
; SSE-32-NEXT:    shufps {{.*#+}} xmm3 = xmm3[1,1,1,1]
; SSE-32-NEXT:    shufps {{.*#+}} xmm2 = xmm2[1,1,1,1]
; SSE-32-NEXT:    ucomiss %xmm3, %xmm2
; SSE-32-NEXT:    cmoval %ecx, %eax
; SSE-32-NEXT:    movd %eax, %xmm2
; SSE-32-NEXT:    punpckldq {{.*#+}} xmm4 = xmm4[0],xmm2[0],xmm4[1],xmm2[1]
; SSE-32-NEXT:    punpcklqdq {{.*#+}} xmm4 = xmm4[0],xmm5[0]
; SSE-32-NEXT:    pand %xmm4, %xmm0
; SSE-32-NEXT:    pandn %xmm1, %xmm4
; SSE-32-NEXT:    por %xmm4, %xmm0
; SSE-32-NEXT:    movl %ebp, %esp
; SSE-32-NEXT:    popl %ebp
; SSE-32-NEXT:    retl
;
; SSE-64-LABEL: test_v4f32_ogt_q:
; SSE-64:       # %bb.0:
; SSE-64-NEXT:    movaps %xmm3, %xmm4
; SSE-64-NEXT:    shufps {{.*#+}} xmm4 = xmm4[3,3],xmm3[3,3]
; SSE-64-NEXT:    movaps %xmm2, %xmm5
; SSE-64-NEXT:    shufps {{.*#+}} xmm5 = xmm5[3,3],xmm2[3,3]
; SSE-64-NEXT:    xorl %eax, %eax
; SSE-64-NEXT:    ucomiss %xmm4, %xmm5
; SSE-64-NEXT:    movl $-1, %ecx
; SSE-64-NEXT:    movl $0, %edx
; SSE-64-NEXT:    cmoval %ecx, %edx
; SSE-64-NEXT:    movd %edx, %xmm4
; SSE-64-NEXT:    movaps %xmm3, %xmm5
; SSE-64-NEXT:    unpckhpd {{.*#+}} xmm5 = xmm5[1],xmm3[1]
; SSE-64-NEXT:    movaps %xmm2, %xmm6
; SSE-64-NEXT:    unpckhpd {{.*#+}} xmm6 = xmm6[1],xmm2[1]
; SSE-64-NEXT:    ucomiss %xmm5, %xmm6
; SSE-64-NEXT:    movl $0, %edx
; SSE-64-NEXT:    cmoval %ecx, %edx
; SSE-64-NEXT:    movd %edx, %xmm5
; SSE-64-NEXT:    punpckldq {{.*#+}} xmm5 = xmm5[0],xmm4[0],xmm5[1],xmm4[1]
; SSE-64-NEXT:    ucomiss %xmm3, %xmm2
; SSE-64-NEXT:    movl $0, %edx
; SSE-64-NEXT:    cmoval %ecx, %edx
; SSE-64-NEXT:    movd %edx, %xmm4
; SSE-64-NEXT:    shufps {{.*#+}} xmm3 = xmm3[1,1,1,1]
; SSE-64-NEXT:    shufps {{.*#+}} xmm2 = xmm2[1,1,1,1]
; SSE-64-NEXT:    ucomiss %xmm3, %xmm2
; SSE-64-NEXT:    cmoval %ecx, %eax
; SSE-64-NEXT:    movd %eax, %xmm2
; SSE-64-NEXT:    punpckldq {{.*#+}} xmm4 = xmm4[0],xmm2[0],xmm4[1],xmm2[1]
; SSE-64-NEXT:    punpcklqdq {{.*#+}} xmm4 = xmm4[0],xmm5[0]
; SSE-64-NEXT:    pand %xmm4, %xmm0
; SSE-64-NEXT:    pandn %xmm1, %xmm4
; SSE-64-NEXT:    por %xmm4, %xmm0
; SSE-64-NEXT:    retq
;
; AVX-32-LABEL: test_v4f32_ogt_q:
; AVX-32:       # %bb.0:
; AVX-32-NEXT:    pushl %ebp
; AVX-32-NEXT:    movl %esp, %ebp
; AVX-32-NEXT:    andl $-16, %esp
; AVX-32-NEXT:    subl $16, %esp
; AVX-32-NEXT:    vmovaps 8(%ebp), %xmm3
; AVX-32-NEXT:    vcmplt_oqps %xmm2, %xmm3, %xmm2
; AVX-32-NEXT:    vblendvps %xmm2, %xmm0, %xmm1, %xmm0
; AVX-32-NEXT:    movl %ebp, %esp
; AVX-32-NEXT:    popl %ebp
; AVX-32-NEXT:    retl
;
; AVX-64-LABEL: test_v4f32_ogt_q:
; AVX-64:       # %bb.0:
; AVX-64-NEXT:    vcmplt_oqps %xmm2, %xmm3, %xmm2
; AVX-64-NEXT:    vblendvps %xmm2, %xmm0, %xmm1, %xmm0
; AVX-64-NEXT:    retq
;
; AVX512-32-LABEL: test_v4f32_ogt_q:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-16, %esp
; AVX512-32-NEXT:    subl $16, %esp
; AVX512-32-NEXT:    vcmpgt_oqps 8(%ebp), %xmm2, %k1
; AVX512-32-NEXT:    vpblendmd %xmm0, %xmm1, %xmm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v4f32_ogt_q:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmplt_oqps %xmm2, %xmm3, %k1
; AVX512-64-NEXT:    vpblendmd %xmm0, %xmm1, %xmm0 {%k1}
; AVX512-64-NEXT:    retq
;
; AVX512F-32-LABEL: test_v4f32_ogt_q:
; AVX512F-32:       # %bb.0:
; AVX512F-32-NEXT:    pushl %ebp
; AVX512F-32-NEXT:    movl %esp, %ebp
; AVX512F-32-NEXT:    andl $-16, %esp
; AVX512F-32-NEXT:    subl $16, %esp
; AVX512F-32-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-32-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-32-NEXT:    vmovaps 8(%ebp), %xmm3
; AVX512F-32-NEXT:    vcmplt_oqps %xmm2, %xmm3, %xmm2
; AVX512F-32-NEXT:    vptestmd %zmm2, %zmm2, %k1
; AVX512F-32-NEXT:    vpblendmd %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-32-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-32-NEXT:    movl %ebp, %esp
; AVX512F-32-NEXT:    popl %ebp
; AVX512F-32-NEXT:    vzeroupper
; AVX512F-32-NEXT:    retl
;
; AVX512F-64-LABEL: test_v4f32_ogt_q:
; AVX512F-64:       # %bb.0:
; AVX512F-64-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-64-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-64-NEXT:    vcmplt_oqps %xmm2, %xmm3, %xmm2
; AVX512F-64-NEXT:    vptestmd %zmm2, %zmm2, %k1
; AVX512F-64-NEXT:    vpblendmd %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-64-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-64-NEXT:    vzeroupper
; AVX512F-64-NEXT:    retq
  %cond = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f32(
                                               <4 x float> %f1, <4 x float> %f2, metadata !"ogt",
                                               metadata !"fpexcept.strict") #0
  %res = select <4 x i1> %cond, <4 x i32> %a, <4 x i32> %b
  ret <4 x i32> %res
}

define <4 x i32> @test_v4f32_oge_q(<4 x i32> %a, <4 x i32> %b, <4 x float> %f1, <4 x float> %f2) #0 {
; SSE-32-LABEL: test_v4f32_oge_q:
; SSE-32:       # %bb.0:
; SSE-32-NEXT:    pushl %ebp
; SSE-32-NEXT:    movl %esp, %ebp
; SSE-32-NEXT:    andl $-16, %esp
; SSE-32-NEXT:    subl $16, %esp
; SSE-32-NEXT:    movaps 8(%ebp), %xmm3
; SSE-32-NEXT:    movaps %xmm3, %xmm4
; SSE-32-NEXT:    shufps {{.*#+}} xmm4 = xmm4[3,3],xmm3[3,3]
; SSE-32-NEXT:    movaps %xmm2, %xmm5
; SSE-32-NEXT:    shufps {{.*#+}} xmm5 = xmm5[3,3],xmm2[3,3]
; SSE-32-NEXT:    xorl %eax, %eax
; SSE-32-NEXT:    ucomiss %xmm4, %xmm5
; SSE-32-NEXT:    movl $-1, %ecx
; SSE-32-NEXT:    movl $0, %edx
; SSE-32-NEXT:    cmovael %ecx, %edx
; SSE-32-NEXT:    movd %edx, %xmm4
; SSE-32-NEXT:    movaps %xmm3, %xmm5
; SSE-32-NEXT:    unpckhpd {{.*#+}} xmm5 = xmm5[1],xmm3[1]
; SSE-32-NEXT:    movaps %xmm2, %xmm6
; SSE-32-NEXT:    unpckhpd {{.*#+}} xmm6 = xmm6[1],xmm2[1]
; SSE-32-NEXT:    ucomiss %xmm5, %xmm6
; SSE-32-NEXT:    movl $0, %edx
; SSE-32-NEXT:    cmovael %ecx, %edx
; SSE-32-NEXT:    movd %edx, %xmm5
; SSE-32-NEXT:    punpckldq {{.*#+}} xmm5 = xmm5[0],xmm4[0],xmm5[1],xmm4[1]
; SSE-32-NEXT:    ucomiss %xmm3, %xmm2
; SSE-32-NEXT:    movl $0, %edx
; SSE-32-NEXT:    cmovael %ecx, %edx
; SSE-32-NEXT:    movd %edx, %xmm4
; SSE-32-NEXT:    shufps {{.*#+}} xmm3 = xmm3[1,1,1,1]
; SSE-32-NEXT:    shufps {{.*#+}} xmm2 = xmm2[1,1,1,1]
; SSE-32-NEXT:    ucomiss %xmm3, %xmm2
; SSE-32-NEXT:    cmovael %ecx, %eax
; SSE-32-NEXT:    movd %eax, %xmm2
; SSE-32-NEXT:    punpckldq {{.*#+}} xmm4 = xmm4[0],xmm2[0],xmm4[1],xmm2[1]
; SSE-32-NEXT:    punpcklqdq {{.*#+}} xmm4 = xmm4[0],xmm5[0]
; SSE-32-NEXT:    pand %xmm4, %xmm0
; SSE-32-NEXT:    pandn %xmm1, %xmm4
; SSE-32-NEXT:    por %xmm4, %xmm0
; SSE-32-NEXT:    movl %ebp, %esp
; SSE-32-NEXT:    popl %ebp
; SSE-32-NEXT:    retl
;
; SSE-64-LABEL: test_v4f32_oge_q:
; SSE-64:       # %bb.0:
; SSE-64-NEXT:    movaps %xmm3, %xmm4
; SSE-64-NEXT:    shufps {{.*#+}} xmm4 = xmm4[3,3],xmm3[3,3]
; SSE-64-NEXT:    movaps %xmm2, %xmm5
; SSE-64-NEXT:    shufps {{.*#+}} xmm5 = xmm5[3,3],xmm2[3,3]
; SSE-64-NEXT:    xorl %eax, %eax
; SSE-64-NEXT:    ucomiss %xmm4, %xmm5
; SSE-64-NEXT:    movl $-1, %ecx
; SSE-64-NEXT:    movl $0, %edx
; SSE-64-NEXT:    cmovael %ecx, %edx
; SSE-64-NEXT:    movd %edx, %xmm4
; SSE-64-NEXT:    movaps %xmm3, %xmm5
; SSE-64-NEXT:    unpckhpd {{.*#+}} xmm5 = xmm5[1],xmm3[1]
; SSE-64-NEXT:    movaps %xmm2, %xmm6
; SSE-64-NEXT:    unpckhpd {{.*#+}} xmm6 = xmm6[1],xmm2[1]
; SSE-64-NEXT:    ucomiss %xmm5, %xmm6
; SSE-64-NEXT:    movl $0, %edx
; SSE-64-NEXT:    cmovael %ecx, %edx
; SSE-64-NEXT:    movd %edx, %xmm5
; SSE-64-NEXT:    punpckldq {{.*#+}} xmm5 = xmm5[0],xmm4[0],xmm5[1],xmm4[1]
; SSE-64-NEXT:    ucomiss %xmm3, %xmm2
; SSE-64-NEXT:    movl $0, %edx
; SSE-64-NEXT:    cmovael %ecx, %edx
; SSE-64-NEXT:    movd %edx, %xmm4
; SSE-64-NEXT:    shufps {{.*#+}} xmm3 = xmm3[1,1,1,1]
; SSE-64-NEXT:    shufps {{.*#+}} xmm2 = xmm2[1,1,1,1]
; SSE-64-NEXT:    ucomiss %xmm3, %xmm2
; SSE-64-NEXT:    cmovael %ecx, %eax
; SSE-64-NEXT:    movd %eax, %xmm2
; SSE-64-NEXT:    punpckldq {{.*#+}} xmm4 = xmm4[0],xmm2[0],xmm4[1],xmm2[1]
; SSE-64-NEXT:    punpcklqdq {{.*#+}} xmm4 = xmm4[0],xmm5[0]
; SSE-64-NEXT:    pand %xmm4, %xmm0
; SSE-64-NEXT:    pandn %xmm1, %xmm4
; SSE-64-NEXT:    por %xmm4, %xmm0
; SSE-64-NEXT:    retq
;
; AVX-32-LABEL: test_v4f32_oge_q:
; AVX-32:       # %bb.0:
; AVX-32-NEXT:    pushl %ebp
; AVX-32-NEXT:    movl %esp, %ebp
; AVX-32-NEXT:    andl $-16, %esp
; AVX-32-NEXT:    subl $16, %esp
; AVX-32-NEXT:    vmovaps 8(%ebp), %xmm3
; AVX-32-NEXT:    vcmple_oqps %xmm2, %xmm3, %xmm2
; AVX-32-NEXT:    vblendvps %xmm2, %xmm0, %xmm1, %xmm0
; AVX-32-NEXT:    movl %ebp, %esp
; AVX-32-NEXT:    popl %ebp
; AVX-32-NEXT:    retl
;
; AVX-64-LABEL: test_v4f32_oge_q:
; AVX-64:       # %bb.0:
; AVX-64-NEXT:    vcmple_oqps %xmm2, %xmm3, %xmm2
; AVX-64-NEXT:    vblendvps %xmm2, %xmm0, %xmm1, %xmm0
; AVX-64-NEXT:    retq
;
; AVX512-32-LABEL: test_v4f32_oge_q:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-16, %esp
; AVX512-32-NEXT:    subl $16, %esp
; AVX512-32-NEXT:    vcmpge_oqps 8(%ebp), %xmm2, %k1
; AVX512-32-NEXT:    vpblendmd %xmm0, %xmm1, %xmm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v4f32_oge_q:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmple_oqps %xmm2, %xmm3, %k1
; AVX512-64-NEXT:    vpblendmd %xmm0, %xmm1, %xmm0 {%k1}
; AVX512-64-NEXT:    retq
;
; AVX512F-32-LABEL: test_v4f32_oge_q:
; AVX512F-32:       # %bb.0:
; AVX512F-32-NEXT:    pushl %ebp
; AVX512F-32-NEXT:    movl %esp, %ebp
; AVX512F-32-NEXT:    andl $-16, %esp
; AVX512F-32-NEXT:    subl $16, %esp
; AVX512F-32-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-32-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-32-NEXT:    vmovaps 8(%ebp), %xmm3
; AVX512F-32-NEXT:    vcmple_oqps %xmm2, %xmm3, %xmm2
; AVX512F-32-NEXT:    vptestmd %zmm2, %zmm2, %k1
; AVX512F-32-NEXT:    vpblendmd %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-32-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-32-NEXT:    movl %ebp, %esp
; AVX512F-32-NEXT:    popl %ebp
; AVX512F-32-NEXT:    vzeroupper
; AVX512F-32-NEXT:    retl
;
; AVX512F-64-LABEL: test_v4f32_oge_q:
; AVX512F-64:       # %bb.0:
; AVX512F-64-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-64-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-64-NEXT:    vcmple_oqps %xmm2, %xmm3, %xmm2
; AVX512F-64-NEXT:    vptestmd %zmm2, %zmm2, %k1
; AVX512F-64-NEXT:    vpblendmd %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-64-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-64-NEXT:    vzeroupper
; AVX512F-64-NEXT:    retq
  %cond = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f32(
                                               <4 x float> %f1, <4 x float> %f2, metadata !"oge",
                                               metadata !"fpexcept.strict") #0
  %res = select <4 x i1> %cond, <4 x i32> %a, <4 x i32> %b
  ret <4 x i32> %res
}

define <4 x i32> @test_v4f32_olt_q(<4 x i32> %a, <4 x i32> %b, <4 x float> %f1, <4 x float> %f2) #0 {
; SSE-32-LABEL: test_v4f32_olt_q:
; SSE-32:       # %bb.0:
; SSE-32-NEXT:    pushl %ebp
; SSE-32-NEXT:    movl %esp, %ebp
; SSE-32-NEXT:    andl $-16, %esp
; SSE-32-NEXT:    subl $16, %esp
; SSE-32-NEXT:    movaps 8(%ebp), %xmm3
; SSE-32-NEXT:    movaps %xmm2, %xmm4
; SSE-32-NEXT:    shufps {{.*#+}} xmm4 = xmm4[3,3],xmm2[3,3]
; SSE-32-NEXT:    movaps %xmm3, %xmm5
; SSE-32-NEXT:    shufps {{.*#+}} xmm5 = xmm5[3,3],xmm3[3,3]
; SSE-32-NEXT:    xorl %eax, %eax
; SSE-32-NEXT:    ucomiss %xmm4, %xmm5
; SSE-32-NEXT:    movl $-1, %ecx
; SSE-32-NEXT:    movl $0, %edx
; SSE-32-NEXT:    cmoval %ecx, %edx
; SSE-32-NEXT:    movd %edx, %xmm4
; SSE-32-NEXT:    movaps %xmm2, %xmm5
; SSE-32-NEXT:    unpckhpd {{.*#+}} xmm5 = xmm5[1],xmm2[1]
; SSE-32-NEXT:    movaps %xmm3, %xmm6
; SSE-32-NEXT:    unpckhpd {{.*#+}} xmm6 = xmm6[1],xmm3[1]
; SSE-32-NEXT:    ucomiss %xmm5, %xmm6
; SSE-32-NEXT:    movl $0, %edx
; SSE-32-NEXT:    cmoval %ecx, %edx
; SSE-32-NEXT:    movd %edx, %xmm5
; SSE-32-NEXT:    punpckldq {{.*#+}} xmm5 = xmm5[0],xmm4[0],xmm5[1],xmm4[1]
; SSE-32-NEXT:    ucomiss %xmm2, %xmm3
; SSE-32-NEXT:    movl $0, %edx
; SSE-32-NEXT:    cmoval %ecx, %edx
; SSE-32-NEXT:    movd %edx, %xmm4
; SSE-32-NEXT:    shufps {{.*#+}} xmm2 = xmm2[1,1,1,1]
; SSE-32-NEXT:    shufps {{.*#+}} xmm3 = xmm3[1,1,1,1]
; SSE-32-NEXT:    ucomiss %xmm2, %xmm3
; SSE-32-NEXT:    cmoval %ecx, %eax
; SSE-32-NEXT:    movd %eax, %xmm2
; SSE-32-NEXT:    punpckldq {{.*#+}} xmm4 = xmm4[0],xmm2[0],xmm4[1],xmm2[1]
; SSE-32-NEXT:    punpcklqdq {{.*#+}} xmm4 = xmm4[0],xmm5[0]
; SSE-32-NEXT:    pand %xmm4, %xmm0
; SSE-32-NEXT:    pandn %xmm1, %xmm4
; SSE-32-NEXT:    por %xmm4, %xmm0
; SSE-32-NEXT:    movl %ebp, %esp
; SSE-32-NEXT:    popl %ebp
; SSE-32-NEXT:    retl
;
; SSE-64-LABEL: test_v4f32_olt_q:
; SSE-64:       # %bb.0:
; SSE-64-NEXT:    movaps %xmm2, %xmm4
; SSE-64-NEXT:    shufps {{.*#+}} xmm4 = xmm4[3,3],xmm2[3,3]
; SSE-64-NEXT:    movaps %xmm3, %xmm5
; SSE-64-NEXT:    shufps {{.*#+}} xmm5 = xmm5[3,3],xmm3[3,3]
; SSE-64-NEXT:    xorl %eax, %eax
; SSE-64-NEXT:    ucomiss %xmm4, %xmm5
; SSE-64-NEXT:    movl $-1, %ecx
; SSE-64-NEXT:    movl $0, %edx
; SSE-64-NEXT:    cmoval %ecx, %edx
; SSE-64-NEXT:    movd %edx, %xmm4
; SSE-64-NEXT:    movaps %xmm2, %xmm5
; SSE-64-NEXT:    unpckhpd {{.*#+}} xmm5 = xmm5[1],xmm2[1]
; SSE-64-NEXT:    movaps %xmm3, %xmm6
; SSE-64-NEXT:    unpckhpd {{.*#+}} xmm6 = xmm6[1],xmm3[1]
; SSE-64-NEXT:    ucomiss %xmm5, %xmm6
; SSE-64-NEXT:    movl $0, %edx
; SSE-64-NEXT:    cmoval %ecx, %edx
; SSE-64-NEXT:    movd %edx, %xmm5
; SSE-64-NEXT:    punpckldq {{.*#+}} xmm5 = xmm5[0],xmm4[0],xmm5[1],xmm4[1]
; SSE-64-NEXT:    ucomiss %xmm2, %xmm3
; SSE-64-NEXT:    movl $0, %edx
; SSE-64-NEXT:    cmoval %ecx, %edx
; SSE-64-NEXT:    movd %edx, %xmm4
; SSE-64-NEXT:    shufps {{.*#+}} xmm2 = xmm2[1,1,1,1]
; SSE-64-NEXT:    shufps {{.*#+}} xmm3 = xmm3[1,1,1,1]
; SSE-64-NEXT:    ucomiss %xmm2, %xmm3
; SSE-64-NEXT:    cmoval %ecx, %eax
; SSE-64-NEXT:    movd %eax, %xmm2
; SSE-64-NEXT:    punpckldq {{.*#+}} xmm4 = xmm4[0],xmm2[0],xmm4[1],xmm2[1]
; SSE-64-NEXT:    punpcklqdq {{.*#+}} xmm4 = xmm4[0],xmm5[0]
; SSE-64-NEXT:    pand %xmm4, %xmm0
; SSE-64-NEXT:    pandn %xmm1, %xmm4
; SSE-64-NEXT:    por %xmm4, %xmm0
; SSE-64-NEXT:    retq
;
; AVX-32-LABEL: test_v4f32_olt_q:
; AVX-32:       # %bb.0:
; AVX-32-NEXT:    pushl %ebp
; AVX-32-NEXT:    movl %esp, %ebp
; AVX-32-NEXT:    andl $-16, %esp
; AVX-32-NEXT:    subl $16, %esp
; AVX-32-NEXT:    vcmplt_oqps 8(%ebp), %xmm2, %xmm2
; AVX-32-NEXT:    vblendvps %xmm2, %xmm0, %xmm1, %xmm0
; AVX-32-NEXT:    movl %ebp, %esp
; AVX-32-NEXT:    popl %ebp
; AVX-32-NEXT:    retl
;
; AVX-64-LABEL: test_v4f32_olt_q:
; AVX-64:       # %bb.0:
; AVX-64-NEXT:    vcmplt_oqps %xmm3, %xmm2, %xmm2
; AVX-64-NEXT:    vblendvps %xmm2, %xmm0, %xmm1, %xmm0
; AVX-64-NEXT:    retq
;
; AVX512-32-LABEL: test_v4f32_olt_q:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-16, %esp
; AVX512-32-NEXT:    subl $16, %esp
; AVX512-32-NEXT:    vcmplt_oqps 8(%ebp), %xmm2, %k1
; AVX512-32-NEXT:    vpblendmd %xmm0, %xmm1, %xmm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v4f32_olt_q:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmplt_oqps %xmm3, %xmm2, %k1
; AVX512-64-NEXT:    vpblendmd %xmm0, %xmm1, %xmm0 {%k1}
; AVX512-64-NEXT:    retq
;
; AVX512F-32-LABEL: test_v4f32_olt_q:
; AVX512F-32:       # %bb.0:
; AVX512F-32-NEXT:    pushl %ebp
; AVX512F-32-NEXT:    movl %esp, %ebp
; AVX512F-32-NEXT:    andl $-16, %esp
; AVX512F-32-NEXT:    subl $16, %esp
; AVX512F-32-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-32-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-32-NEXT:    vcmplt_oqps 8(%ebp), %xmm2, %xmm2
; AVX512F-32-NEXT:    vptestmd %zmm2, %zmm2, %k1
; AVX512F-32-NEXT:    vpblendmd %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-32-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-32-NEXT:    movl %ebp, %esp
; AVX512F-32-NEXT:    popl %ebp
; AVX512F-32-NEXT:    vzeroupper
; AVX512F-32-NEXT:    retl
;
; AVX512F-64-LABEL: test_v4f32_olt_q:
; AVX512F-64:       # %bb.0:
; AVX512F-64-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-64-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-64-NEXT:    vcmplt_oqps %xmm3, %xmm2, %xmm2
; AVX512F-64-NEXT:    vptestmd %zmm2, %zmm2, %k1
; AVX512F-64-NEXT:    vpblendmd %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-64-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-64-NEXT:    vzeroupper
; AVX512F-64-NEXT:    retq
  %cond = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f32(
                                               <4 x float> %f1, <4 x float> %f2, metadata !"olt",
                                               metadata !"fpexcept.strict") #0
  %res = select <4 x i1> %cond, <4 x i32> %a, <4 x i32> %b
  ret <4 x i32> %res
}

define <4 x i32> @test_v4f32_ole_q(<4 x i32> %a, <4 x i32> %b, <4 x float> %f1, <4 x float> %f2) #0 {
; SSE-32-LABEL: test_v4f32_ole_q:
; SSE-32:       # %bb.0:
; SSE-32-NEXT:    pushl %ebp
; SSE-32-NEXT:    movl %esp, %ebp
; SSE-32-NEXT:    andl $-16, %esp
; SSE-32-NEXT:    subl $16, %esp
; SSE-32-NEXT:    movaps 8(%ebp), %xmm3
; SSE-32-NEXT:    movaps %xmm2, %xmm4
; SSE-32-NEXT:    shufps {{.*#+}} xmm4 = xmm4[3,3],xmm2[3,3]
; SSE-32-NEXT:    movaps %xmm3, %xmm5
; SSE-32-NEXT:    shufps {{.*#+}} xmm5 = xmm5[3,3],xmm3[3,3]
; SSE-32-NEXT:    xorl %eax, %eax
; SSE-32-NEXT:    ucomiss %xmm4, %xmm5
; SSE-32-NEXT:    movl $-1, %ecx
; SSE-32-NEXT:    movl $0, %edx
; SSE-32-NEXT:    cmovael %ecx, %edx
; SSE-32-NEXT:    movd %edx, %xmm4
; SSE-32-NEXT:    movaps %xmm2, %xmm5
; SSE-32-NEXT:    unpckhpd {{.*#+}} xmm5 = xmm5[1],xmm2[1]
; SSE-32-NEXT:    movaps %xmm3, %xmm6
; SSE-32-NEXT:    unpckhpd {{.*#+}} xmm6 = xmm6[1],xmm3[1]
; SSE-32-NEXT:    ucomiss %xmm5, %xmm6
; SSE-32-NEXT:    movl $0, %edx
; SSE-32-NEXT:    cmovael %ecx, %edx
; SSE-32-NEXT:    movd %edx, %xmm5
; SSE-32-NEXT:    punpckldq {{.*#+}} xmm5 = xmm5[0],xmm4[0],xmm5[1],xmm4[1]
; SSE-32-NEXT:    ucomiss %xmm2, %xmm3
; SSE-32-NEXT:    movl $0, %edx
; SSE-32-NEXT:    cmovael %ecx, %edx
; SSE-32-NEXT:    movd %edx, %xmm4
; SSE-32-NEXT:    shufps {{.*#+}} xmm2 = xmm2[1,1,1,1]
; SSE-32-NEXT:    shufps {{.*#+}} xmm3 = xmm3[1,1,1,1]
; SSE-32-NEXT:    ucomiss %xmm2, %xmm3
; SSE-32-NEXT:    cmovael %ecx, %eax
; SSE-32-NEXT:    movd %eax, %xmm2
; SSE-32-NEXT:    punpckldq {{.*#+}} xmm4 = xmm4[0],xmm2[0],xmm4[1],xmm2[1]
; SSE-32-NEXT:    punpcklqdq {{.*#+}} xmm4 = xmm4[0],xmm5[0]
; SSE-32-NEXT:    pand %xmm4, %xmm0
; SSE-32-NEXT:    pandn %xmm1, %xmm4
; SSE-32-NEXT:    por %xmm4, %xmm0
; SSE-32-NEXT:    movl %ebp, %esp
; SSE-32-NEXT:    popl %ebp
; SSE-32-NEXT:    retl
;
; SSE-64-LABEL: test_v4f32_ole_q:
; SSE-64:       # %bb.0:
; SSE-64-NEXT:    movaps %xmm2, %xmm4
; SSE-64-NEXT:    shufps {{.*#+}} xmm4 = xmm4[3,3],xmm2[3,3]
; SSE-64-NEXT:    movaps %xmm3, %xmm5
; SSE-64-NEXT:    shufps {{.*#+}} xmm5 = xmm5[3,3],xmm3[3,3]
; SSE-64-NEXT:    xorl %eax, %eax
; SSE-64-NEXT:    ucomiss %xmm4, %xmm5
; SSE-64-NEXT:    movl $-1, %ecx
; SSE-64-NEXT:    movl $0, %edx
; SSE-64-NEXT:    cmovael %ecx, %edx
; SSE-64-NEXT:    movd %edx, %xmm4
; SSE-64-NEXT:    movaps %xmm2, %xmm5
; SSE-64-NEXT:    unpckhpd {{.*#+}} xmm5 = xmm5[1],xmm2[1]
; SSE-64-NEXT:    movaps %xmm3, %xmm6
; SSE-64-NEXT:    unpckhpd {{.*#+}} xmm6 = xmm6[1],xmm3[1]
; SSE-64-NEXT:    ucomiss %xmm5, %xmm6
; SSE-64-NEXT:    movl $0, %edx
; SSE-64-NEXT:    cmovael %ecx, %edx
; SSE-64-NEXT:    movd %edx, %xmm5
; SSE-64-NEXT:    punpckldq {{.*#+}} xmm5 = xmm5[0],xmm4[0],xmm5[1],xmm4[1]
; SSE-64-NEXT:    ucomiss %xmm2, %xmm3
; SSE-64-NEXT:    movl $0, %edx
; SSE-64-NEXT:    cmovael %ecx, %edx
; SSE-64-NEXT:    movd %edx, %xmm4
; SSE-64-NEXT:    shufps {{.*#+}} xmm2 = xmm2[1,1,1,1]
; SSE-64-NEXT:    shufps {{.*#+}} xmm3 = xmm3[1,1,1,1]
; SSE-64-NEXT:    ucomiss %xmm2, %xmm3
; SSE-64-NEXT:    cmovael %ecx, %eax
; SSE-64-NEXT:    movd %eax, %xmm2
; SSE-64-NEXT:    punpckldq {{.*#+}} xmm4 = xmm4[0],xmm2[0],xmm4[1],xmm2[1]
; SSE-64-NEXT:    punpcklqdq {{.*#+}} xmm4 = xmm4[0],xmm5[0]
; SSE-64-NEXT:    pand %xmm4, %xmm0
; SSE-64-NEXT:    pandn %xmm1, %xmm4
; SSE-64-NEXT:    por %xmm4, %xmm0
; SSE-64-NEXT:    retq
;
; AVX-32-LABEL: test_v4f32_ole_q:
; AVX-32:       # %bb.0:
; AVX-32-NEXT:    pushl %ebp
; AVX-32-NEXT:    movl %esp, %ebp
; AVX-32-NEXT:    andl $-16, %esp
; AVX-32-NEXT:    subl $16, %esp
; AVX-32-NEXT:    vcmple_oqps 8(%ebp), %xmm2, %xmm2
; AVX-32-NEXT:    vblendvps %xmm2, %xmm0, %xmm1, %xmm0
; AVX-32-NEXT:    movl %ebp, %esp
; AVX-32-NEXT:    popl %ebp
; AVX-32-NEXT:    retl
;
; AVX-64-LABEL: test_v4f32_ole_q:
; AVX-64:       # %bb.0:
; AVX-64-NEXT:    vcmple_oqps %xmm3, %xmm2, %xmm2
; AVX-64-NEXT:    vblendvps %xmm2, %xmm0, %xmm1, %xmm0
; AVX-64-NEXT:    retq
;
; AVX512-32-LABEL: test_v4f32_ole_q:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-16, %esp
; AVX512-32-NEXT:    subl $16, %esp
; AVX512-32-NEXT:    vcmple_oqps 8(%ebp), %xmm2, %k1
; AVX512-32-NEXT:    vpblendmd %xmm0, %xmm1, %xmm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v4f32_ole_q:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmple_oqps %xmm3, %xmm2, %k1
; AVX512-64-NEXT:    vpblendmd %xmm0, %xmm1, %xmm0 {%k1}
; AVX512-64-NEXT:    retq
;
; AVX512F-32-LABEL: test_v4f32_ole_q:
; AVX512F-32:       # %bb.0:
; AVX512F-32-NEXT:    pushl %ebp
; AVX512F-32-NEXT:    movl %esp, %ebp
; AVX512F-32-NEXT:    andl $-16, %esp
; AVX512F-32-NEXT:    subl $16, %esp
; AVX512F-32-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-32-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-32-NEXT:    vcmple_oqps 8(%ebp), %xmm2, %xmm2
; AVX512F-32-NEXT:    vptestmd %zmm2, %zmm2, %k1
; AVX512F-32-NEXT:    vpblendmd %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-32-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-32-NEXT:    movl %ebp, %esp
; AVX512F-32-NEXT:    popl %ebp
; AVX512F-32-NEXT:    vzeroupper
; AVX512F-32-NEXT:    retl
;
; AVX512F-64-LABEL: test_v4f32_ole_q:
; AVX512F-64:       # %bb.0:
; AVX512F-64-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-64-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-64-NEXT:    vcmple_oqps %xmm3, %xmm2, %xmm2
; AVX512F-64-NEXT:    vptestmd %zmm2, %zmm2, %k1
; AVX512F-64-NEXT:    vpblendmd %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-64-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-64-NEXT:    vzeroupper
; AVX512F-64-NEXT:    retq
  %cond = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f32(
                                               <4 x float> %f1, <4 x float> %f2, metadata !"ole",
                                               metadata !"fpexcept.strict") #0
  %res = select <4 x i1> %cond, <4 x i32> %a, <4 x i32> %b
  ret <4 x i32> %res
}

define <4 x i32> @test_v4f32_one_q(<4 x i32> %a, <4 x i32> %b, <4 x float> %f1, <4 x float> %f2) #0 {
; SSE-32-LABEL: test_v4f32_one_q:
; SSE-32:       # %bb.0:
; SSE-32-NEXT:    pushl %ebp
; SSE-32-NEXT:    movl %esp, %ebp
; SSE-32-NEXT:    andl $-16, %esp
; SSE-32-NEXT:    subl $16, %esp
; SSE-32-NEXT:    movaps 8(%ebp), %xmm3
; SSE-32-NEXT:    movaps %xmm2, %xmm4
; SSE-32-NEXT:    cmpneqps %xmm3, %xmm4
; SSE-32-NEXT:    cmpordps %xmm3, %xmm2
; SSE-32-NEXT:    andps %xmm4, %xmm2
; SSE-32-NEXT:    andps %xmm2, %xmm0
; SSE-32-NEXT:    andnps %xmm1, %xmm2
; SSE-32-NEXT:    orps %xmm2, %xmm0
; SSE-32-NEXT:    movl %ebp, %esp
; SSE-32-NEXT:    popl %ebp
; SSE-32-NEXT:    retl
;
; SSE-64-LABEL: test_v4f32_one_q:
; SSE-64:       # %bb.0:
; SSE-64-NEXT:    movaps %xmm2, %xmm4
; SSE-64-NEXT:    cmpneqps %xmm3, %xmm4
; SSE-64-NEXT:    cmpordps %xmm3, %xmm2
; SSE-64-NEXT:    andps %xmm4, %xmm2
; SSE-64-NEXT:    andps %xmm2, %xmm0
; SSE-64-NEXT:    andnps %xmm1, %xmm2
; SSE-64-NEXT:    orps %xmm2, %xmm0
; SSE-64-NEXT:    retq
;
; AVX-32-LABEL: test_v4f32_one_q:
; AVX-32:       # %bb.0:
; AVX-32-NEXT:    pushl %ebp
; AVX-32-NEXT:    movl %esp, %ebp
; AVX-32-NEXT:    andl $-16, %esp
; AVX-32-NEXT:    subl $16, %esp
; AVX-32-NEXT:    vcmpneq_oqps 8(%ebp), %xmm2, %xmm2
; AVX-32-NEXT:    vblendvps %xmm2, %xmm0, %xmm1, %xmm0
; AVX-32-NEXT:    movl %ebp, %esp
; AVX-32-NEXT:    popl %ebp
; AVX-32-NEXT:    retl
;
; AVX-64-LABEL: test_v4f32_one_q:
; AVX-64:       # %bb.0:
; AVX-64-NEXT:    vcmpneq_oqps %xmm3, %xmm2, %xmm2
; AVX-64-NEXT:    vblendvps %xmm2, %xmm0, %xmm1, %xmm0
; AVX-64-NEXT:    retq
;
; AVX512-32-LABEL: test_v4f32_one_q:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-16, %esp
; AVX512-32-NEXT:    subl $16, %esp
; AVX512-32-NEXT:    vcmpneq_oqps 8(%ebp), %xmm2, %k1
; AVX512-32-NEXT:    vpblendmd %xmm0, %xmm1, %xmm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v4f32_one_q:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmpneq_oqps %xmm3, %xmm2, %k1
; AVX512-64-NEXT:    vpblendmd %xmm0, %xmm1, %xmm0 {%k1}
; AVX512-64-NEXT:    retq
;
; AVX512F-32-LABEL: test_v4f32_one_q:
; AVX512F-32:       # %bb.0:
; AVX512F-32-NEXT:    pushl %ebp
; AVX512F-32-NEXT:    movl %esp, %ebp
; AVX512F-32-NEXT:    andl $-16, %esp
; AVX512F-32-NEXT:    subl $16, %esp
; AVX512F-32-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-32-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-32-NEXT:    vcmpneq_oqps 8(%ebp), %xmm2, %xmm2
; AVX512F-32-NEXT:    vptestmd %zmm2, %zmm2, %k1
; AVX512F-32-NEXT:    vpblendmd %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-32-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-32-NEXT:    movl %ebp, %esp
; AVX512F-32-NEXT:    popl %ebp
; AVX512F-32-NEXT:    vzeroupper
; AVX512F-32-NEXT:    retl
;
; AVX512F-64-LABEL: test_v4f32_one_q:
; AVX512F-64:       # %bb.0:
; AVX512F-64-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-64-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-64-NEXT:    vcmpneq_oqps %xmm3, %xmm2, %xmm2
; AVX512F-64-NEXT:    vptestmd %zmm2, %zmm2, %k1
; AVX512F-64-NEXT:    vpblendmd %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-64-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-64-NEXT:    vzeroupper
; AVX512F-64-NEXT:    retq
  %cond = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f32(
                                               <4 x float> %f1, <4 x float> %f2, metadata !"one",
                                               metadata !"fpexcept.strict") #0
  %res = select <4 x i1> %cond, <4 x i32> %a, <4 x i32> %b
  ret <4 x i32> %res
}

define <4 x i32> @test_v4f32_ord_q(<4 x i32> %a, <4 x i32> %b, <4 x float> %f1, <4 x float> %f2) #0 {
; SSE-32-LABEL: test_v4f32_ord_q:
; SSE-32:       # %bb.0:
; SSE-32-NEXT:    pushl %ebp
; SSE-32-NEXT:    movl %esp, %ebp
; SSE-32-NEXT:    andl $-16, %esp
; SSE-32-NEXT:    subl $16, %esp
; SSE-32-NEXT:    cmpordps 8(%ebp), %xmm2
; SSE-32-NEXT:    andps %xmm2, %xmm0
; SSE-32-NEXT:    andnps %xmm1, %xmm2
; SSE-32-NEXT:    orps %xmm2, %xmm0
; SSE-32-NEXT:    movl %ebp, %esp
; SSE-32-NEXT:    popl %ebp
; SSE-32-NEXT:    retl
;
; SSE-64-LABEL: test_v4f32_ord_q:
; SSE-64:       # %bb.0:
; SSE-64-NEXT:    cmpordps %xmm3, %xmm2
; SSE-64-NEXT:    andps %xmm2, %xmm0
; SSE-64-NEXT:    andnps %xmm1, %xmm2
; SSE-64-NEXT:    orps %xmm2, %xmm0
; SSE-64-NEXT:    retq
;
; AVX-32-LABEL: test_v4f32_ord_q:
; AVX-32:       # %bb.0:
; AVX-32-NEXT:    pushl %ebp
; AVX-32-NEXT:    movl %esp, %ebp
; AVX-32-NEXT:    andl $-16, %esp
; AVX-32-NEXT:    subl $16, %esp
; AVX-32-NEXT:    vcmpordps 8(%ebp), %xmm2, %xmm2
; AVX-32-NEXT:    vblendvps %xmm2, %xmm0, %xmm1, %xmm0
; AVX-32-NEXT:    movl %ebp, %esp
; AVX-32-NEXT:    popl %ebp
; AVX-32-NEXT:    retl
;
; AVX-64-LABEL: test_v4f32_ord_q:
; AVX-64:       # %bb.0:
; AVX-64-NEXT:    vcmpordps %xmm3, %xmm2, %xmm2
; AVX-64-NEXT:    vblendvps %xmm2, %xmm0, %xmm1, %xmm0
; AVX-64-NEXT:    retq
;
; AVX512-32-LABEL: test_v4f32_ord_q:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-16, %esp
; AVX512-32-NEXT:    subl $16, %esp
; AVX512-32-NEXT:    vcmpordps 8(%ebp), %xmm2, %k1
; AVX512-32-NEXT:    vpblendmd %xmm0, %xmm1, %xmm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v4f32_ord_q:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmpordps %xmm3, %xmm2, %k1
; AVX512-64-NEXT:    vpblendmd %xmm0, %xmm1, %xmm0 {%k1}
; AVX512-64-NEXT:    retq
;
; AVX512F-32-LABEL: test_v4f32_ord_q:
; AVX512F-32:       # %bb.0:
; AVX512F-32-NEXT:    pushl %ebp
; AVX512F-32-NEXT:    movl %esp, %ebp
; AVX512F-32-NEXT:    andl $-16, %esp
; AVX512F-32-NEXT:    subl $16, %esp
; AVX512F-32-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-32-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-32-NEXT:    vcmpordps 8(%ebp), %xmm2, %xmm2
; AVX512F-32-NEXT:    vptestmd %zmm2, %zmm2, %k1
; AVX512F-32-NEXT:    vpblendmd %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-32-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-32-NEXT:    movl %ebp, %esp
; AVX512F-32-NEXT:    popl %ebp
; AVX512F-32-NEXT:    vzeroupper
; AVX512F-32-NEXT:    retl
;
; AVX512F-64-LABEL: test_v4f32_ord_q:
; AVX512F-64:       # %bb.0:
; AVX512F-64-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-64-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-64-NEXT:    vcmpordps %xmm3, %xmm2, %xmm2
; AVX512F-64-NEXT:    vptestmd %zmm2, %zmm2, %k1
; AVX512F-64-NEXT:    vpblendmd %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-64-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-64-NEXT:    vzeroupper
; AVX512F-64-NEXT:    retq
  %cond = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f32(
                                               <4 x float> %f1, <4 x float> %f2, metadata !"ord",
                                               metadata !"fpexcept.strict") #0
  %res = select <4 x i1> %cond, <4 x i32> %a, <4 x i32> %b
  ret <4 x i32> %res
}

define <4 x i32> @test_v4f32_ueq_q(<4 x i32> %a, <4 x i32> %b, <4 x float> %f1, <4 x float> %f2) #0 {
; SSE-32-LABEL: test_v4f32_ueq_q:
; SSE-32:       # %bb.0:
; SSE-32-NEXT:    pushl %ebp
; SSE-32-NEXT:    movl %esp, %ebp
; SSE-32-NEXT:    andl $-16, %esp
; SSE-32-NEXT:    subl $16, %esp
; SSE-32-NEXT:    movaps 8(%ebp), %xmm3
; SSE-32-NEXT:    movaps %xmm2, %xmm4
; SSE-32-NEXT:    cmpeqps %xmm3, %xmm4
; SSE-32-NEXT:    cmpunordps %xmm3, %xmm2
; SSE-32-NEXT:    orps %xmm4, %xmm2
; SSE-32-NEXT:    andps %xmm2, %xmm0
; SSE-32-NEXT:    andnps %xmm1, %xmm2
; SSE-32-NEXT:    orps %xmm2, %xmm0
; SSE-32-NEXT:    movl %ebp, %esp
; SSE-32-NEXT:    popl %ebp
; SSE-32-NEXT:    retl
;
; SSE-64-LABEL: test_v4f32_ueq_q:
; SSE-64:       # %bb.0:
; SSE-64-NEXT:    movaps %xmm2, %xmm4
; SSE-64-NEXT:    cmpeqps %xmm3, %xmm4
; SSE-64-NEXT:    cmpunordps %xmm3, %xmm2
; SSE-64-NEXT:    orps %xmm4, %xmm2
; SSE-64-NEXT:    andps %xmm2, %xmm0
; SSE-64-NEXT:    andnps %xmm1, %xmm2
; SSE-64-NEXT:    orps %xmm2, %xmm0
; SSE-64-NEXT:    retq
;
; AVX-32-LABEL: test_v4f32_ueq_q:
; AVX-32:       # %bb.0:
; AVX-32-NEXT:    pushl %ebp
; AVX-32-NEXT:    movl %esp, %ebp
; AVX-32-NEXT:    andl $-16, %esp
; AVX-32-NEXT:    subl $16, %esp
; AVX-32-NEXT:    vcmpeq_uqps 8(%ebp), %xmm2, %xmm2
; AVX-32-NEXT:    vblendvps %xmm2, %xmm0, %xmm1, %xmm0
; AVX-32-NEXT:    movl %ebp, %esp
; AVX-32-NEXT:    popl %ebp
; AVX-32-NEXT:    retl
;
; AVX-64-LABEL: test_v4f32_ueq_q:
; AVX-64:       # %bb.0:
; AVX-64-NEXT:    vcmpeq_uqps %xmm3, %xmm2, %xmm2
; AVX-64-NEXT:    vblendvps %xmm2, %xmm0, %xmm1, %xmm0
; AVX-64-NEXT:    retq
;
; AVX512-32-LABEL: test_v4f32_ueq_q:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-16, %esp
; AVX512-32-NEXT:    subl $16, %esp
; AVX512-32-NEXT:    vcmpeq_uqps 8(%ebp), %xmm2, %k1
; AVX512-32-NEXT:    vpblendmd %xmm0, %xmm1, %xmm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v4f32_ueq_q:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmpeq_uqps %xmm3, %xmm2, %k1
; AVX512-64-NEXT:    vpblendmd %xmm0, %xmm1, %xmm0 {%k1}
; AVX512-64-NEXT:    retq
;
; AVX512F-32-LABEL: test_v4f32_ueq_q:
; AVX512F-32:       # %bb.0:
; AVX512F-32-NEXT:    pushl %ebp
; AVX512F-32-NEXT:    movl %esp, %ebp
; AVX512F-32-NEXT:    andl $-16, %esp
; AVX512F-32-NEXT:    subl $16, %esp
; AVX512F-32-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-32-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-32-NEXT:    vcmpeq_uqps 8(%ebp), %xmm2, %xmm2
; AVX512F-32-NEXT:    vptestmd %zmm2, %zmm2, %k1
; AVX512F-32-NEXT:    vpblendmd %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-32-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-32-NEXT:    movl %ebp, %esp
; AVX512F-32-NEXT:    popl %ebp
; AVX512F-32-NEXT:    vzeroupper
; AVX512F-32-NEXT:    retl
;
; AVX512F-64-LABEL: test_v4f32_ueq_q:
; AVX512F-64:       # %bb.0:
; AVX512F-64-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-64-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-64-NEXT:    vcmpeq_uqps %xmm3, %xmm2, %xmm2
; AVX512F-64-NEXT:    vptestmd %zmm2, %zmm2, %k1
; AVX512F-64-NEXT:    vpblendmd %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-64-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-64-NEXT:    vzeroupper
; AVX512F-64-NEXT:    retq
  %cond = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f32(
                                               <4 x float> %f1, <4 x float> %f2, metadata !"ueq",
                                               metadata !"fpexcept.strict") #0
  %res = select <4 x i1> %cond, <4 x i32> %a, <4 x i32> %b
  ret <4 x i32> %res
}

define <4 x i32> @test_v4f32_ugt_q(<4 x i32> %a, <4 x i32> %b, <4 x float> %f1, <4 x float> %f2) #0 {
; SSE-32-LABEL: test_v4f32_ugt_q:
; SSE-32:       # %bb.0:
; SSE-32-NEXT:    pushl %ebp
; SSE-32-NEXT:    movl %esp, %ebp
; SSE-32-NEXT:    andl $-16, %esp
; SSE-32-NEXT:    subl $16, %esp
; SSE-32-NEXT:    movaps 8(%ebp), %xmm3
; SSE-32-NEXT:    movaps %xmm2, %xmm4
; SSE-32-NEXT:    shufps {{.*#+}} xmm4 = xmm4[3,3],xmm2[3,3]
; SSE-32-NEXT:    movaps %xmm3, %xmm5
; SSE-32-NEXT:    shufps {{.*#+}} xmm5 = xmm5[3,3],xmm3[3,3]
; SSE-32-NEXT:    xorl %eax, %eax
; SSE-32-NEXT:    ucomiss %xmm4, %xmm5
; SSE-32-NEXT:    movl $-1, %ecx
; SSE-32-NEXT:    movl $0, %edx
; SSE-32-NEXT:    cmovbl %ecx, %edx
; SSE-32-NEXT:    movd %edx, %xmm4
; SSE-32-NEXT:    movaps %xmm2, %xmm5
; SSE-32-NEXT:    unpckhpd {{.*#+}} xmm5 = xmm5[1],xmm2[1]
; SSE-32-NEXT:    movaps %xmm3, %xmm6
; SSE-32-NEXT:    unpckhpd {{.*#+}} xmm6 = xmm6[1],xmm3[1]
; SSE-32-NEXT:    ucomiss %xmm5, %xmm6
; SSE-32-NEXT:    movl $0, %edx
; SSE-32-NEXT:    cmovbl %ecx, %edx
; SSE-32-NEXT:    movd %edx, %xmm5
; SSE-32-NEXT:    punpckldq {{.*#+}} xmm5 = xmm5[0],xmm4[0],xmm5[1],xmm4[1]
; SSE-32-NEXT:    ucomiss %xmm2, %xmm3
; SSE-32-NEXT:    movl $0, %edx
; SSE-32-NEXT:    cmovbl %ecx, %edx
; SSE-32-NEXT:    movd %edx, %xmm4
; SSE-32-NEXT:    shufps {{.*#+}} xmm2 = xmm2[1,1,1,1]
; SSE-32-NEXT:    shufps {{.*#+}} xmm3 = xmm3[1,1,1,1]
; SSE-32-NEXT:    ucomiss %xmm2, %xmm3
; SSE-32-NEXT:    cmovbl %ecx, %eax
; SSE-32-NEXT:    movd %eax, %xmm2
; SSE-32-NEXT:    punpckldq {{.*#+}} xmm4 = xmm4[0],xmm2[0],xmm4[1],xmm2[1]
; SSE-32-NEXT:    punpcklqdq {{.*#+}} xmm4 = xmm4[0],xmm5[0]
; SSE-32-NEXT:    pand %xmm4, %xmm0
; SSE-32-NEXT:    pandn %xmm1, %xmm4
; SSE-32-NEXT:    por %xmm4, %xmm0
; SSE-32-NEXT:    movl %ebp, %esp
; SSE-32-NEXT:    popl %ebp
; SSE-32-NEXT:    retl
;
; SSE-64-LABEL: test_v4f32_ugt_q:
; SSE-64:       # %bb.0:
; SSE-64-NEXT:    movaps %xmm2, %xmm4
; SSE-64-NEXT:    shufps {{.*#+}} xmm4 = xmm4[3,3],xmm2[3,3]
; SSE-64-NEXT:    movaps %xmm3, %xmm5
; SSE-64-NEXT:    shufps {{.*#+}} xmm5 = xmm5[3,3],xmm3[3,3]
; SSE-64-NEXT:    xorl %eax, %eax
; SSE-64-NEXT:    ucomiss %xmm4, %xmm5
; SSE-64-NEXT:    movl $-1, %ecx
; SSE-64-NEXT:    movl $0, %edx
; SSE-64-NEXT:    cmovbl %ecx, %edx
; SSE-64-NEXT:    movd %edx, %xmm4
; SSE-64-NEXT:    movaps %xmm2, %xmm5
; SSE-64-NEXT:    unpckhpd {{.*#+}} xmm5 = xmm5[1],xmm2[1]
; SSE-64-NEXT:    movaps %xmm3, %xmm6
; SSE-64-NEXT:    unpckhpd {{.*#+}} xmm6 = xmm6[1],xmm3[1]
; SSE-64-NEXT:    ucomiss %xmm5, %xmm6
; SSE-64-NEXT:    movl $0, %edx
; SSE-64-NEXT:    cmovbl %ecx, %edx
; SSE-64-NEXT:    movd %edx, %xmm5
; SSE-64-NEXT:    punpckldq {{.*#+}} xmm5 = xmm5[0],xmm4[0],xmm5[1],xmm4[1]
; SSE-64-NEXT:    ucomiss %xmm2, %xmm3
; SSE-64-NEXT:    movl $0, %edx
; SSE-64-NEXT:    cmovbl %ecx, %edx
; SSE-64-NEXT:    movd %edx, %xmm4
; SSE-64-NEXT:    shufps {{.*#+}} xmm2 = xmm2[1,1,1,1]
; SSE-64-NEXT:    shufps {{.*#+}} xmm3 = xmm3[1,1,1,1]
; SSE-64-NEXT:    ucomiss %xmm2, %xmm3
; SSE-64-NEXT:    cmovbl %ecx, %eax
; SSE-64-NEXT:    movd %eax, %xmm2
; SSE-64-NEXT:    punpckldq {{.*#+}} xmm4 = xmm4[0],xmm2[0],xmm4[1],xmm2[1]
; SSE-64-NEXT:    punpcklqdq {{.*#+}} xmm4 = xmm4[0],xmm5[0]
; SSE-64-NEXT:    pand %xmm4, %xmm0
; SSE-64-NEXT:    pandn %xmm1, %xmm4
; SSE-64-NEXT:    por %xmm4, %xmm0
; SSE-64-NEXT:    retq
;
; AVX-32-LABEL: test_v4f32_ugt_q:
; AVX-32:       # %bb.0:
; AVX-32-NEXT:    pushl %ebp
; AVX-32-NEXT:    movl %esp, %ebp
; AVX-32-NEXT:    andl $-16, %esp
; AVX-32-NEXT:    subl $16, %esp
; AVX-32-NEXT:    vcmpnle_uqps 8(%ebp), %xmm2, %xmm2
; AVX-32-NEXT:    vblendvps %xmm2, %xmm0, %xmm1, %xmm0
; AVX-32-NEXT:    movl %ebp, %esp
; AVX-32-NEXT:    popl %ebp
; AVX-32-NEXT:    retl
;
; AVX-64-LABEL: test_v4f32_ugt_q:
; AVX-64:       # %bb.0:
; AVX-64-NEXT:    vcmpnle_uqps %xmm3, %xmm2, %xmm2
; AVX-64-NEXT:    vblendvps %xmm2, %xmm0, %xmm1, %xmm0
; AVX-64-NEXT:    retq
;
; AVX512-32-LABEL: test_v4f32_ugt_q:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-16, %esp
; AVX512-32-NEXT:    subl $16, %esp
; AVX512-32-NEXT:    vcmpnle_uqps 8(%ebp), %xmm2, %k1
; AVX512-32-NEXT:    vpblendmd %xmm0, %xmm1, %xmm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v4f32_ugt_q:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmpnle_uqps %xmm3, %xmm2, %k1
; AVX512-64-NEXT:    vpblendmd %xmm0, %xmm1, %xmm0 {%k1}
; AVX512-64-NEXT:    retq
;
; AVX512F-32-LABEL: test_v4f32_ugt_q:
; AVX512F-32:       # %bb.0:
; AVX512F-32-NEXT:    pushl %ebp
; AVX512F-32-NEXT:    movl %esp, %ebp
; AVX512F-32-NEXT:    andl $-16, %esp
; AVX512F-32-NEXT:    subl $16, %esp
; AVX512F-32-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-32-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-32-NEXT:    vcmpnle_uqps 8(%ebp), %xmm2, %xmm2
; AVX512F-32-NEXT:    vptestmd %zmm2, %zmm2, %k1
; AVX512F-32-NEXT:    vpblendmd %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-32-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-32-NEXT:    movl %ebp, %esp
; AVX512F-32-NEXT:    popl %ebp
; AVX512F-32-NEXT:    vzeroupper
; AVX512F-32-NEXT:    retl
;
; AVX512F-64-LABEL: test_v4f32_ugt_q:
; AVX512F-64:       # %bb.0:
; AVX512F-64-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-64-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-64-NEXT:    vcmpnle_uqps %xmm3, %xmm2, %xmm2
; AVX512F-64-NEXT:    vptestmd %zmm2, %zmm2, %k1
; AVX512F-64-NEXT:    vpblendmd %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-64-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-64-NEXT:    vzeroupper
; AVX512F-64-NEXT:    retq
  %cond = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f32(
                                               <4 x float> %f1, <4 x float> %f2, metadata !"ugt",
                                               metadata !"fpexcept.strict") #0
  %res = select <4 x i1> %cond, <4 x i32> %a, <4 x i32> %b
  ret <4 x i32> %res
}

define <4 x i32> @test_v4f32_uge_q(<4 x i32> %a, <4 x i32> %b, <4 x float> %f1, <4 x float> %f2) #0 {
; SSE-32-LABEL: test_v4f32_uge_q:
; SSE-32:       # %bb.0:
; SSE-32-NEXT:    pushl %ebp
; SSE-32-NEXT:    movl %esp, %ebp
; SSE-32-NEXT:    andl $-16, %esp
; SSE-32-NEXT:    subl $16, %esp
; SSE-32-NEXT:    movaps 8(%ebp), %xmm3
; SSE-32-NEXT:    movaps %xmm2, %xmm4
; SSE-32-NEXT:    shufps {{.*#+}} xmm4 = xmm4[3,3],xmm2[3,3]
; SSE-32-NEXT:    movaps %xmm3, %xmm5
; SSE-32-NEXT:    shufps {{.*#+}} xmm5 = xmm5[3,3],xmm3[3,3]
; SSE-32-NEXT:    xorl %eax, %eax
; SSE-32-NEXT:    ucomiss %xmm4, %xmm5
; SSE-32-NEXT:    movl $-1, %ecx
; SSE-32-NEXT:    movl $0, %edx
; SSE-32-NEXT:    cmovbel %ecx, %edx
; SSE-32-NEXT:    movd %edx, %xmm4
; SSE-32-NEXT:    movaps %xmm2, %xmm5
; SSE-32-NEXT:    unpckhpd {{.*#+}} xmm5 = xmm5[1],xmm2[1]
; SSE-32-NEXT:    movaps %xmm3, %xmm6
; SSE-32-NEXT:    unpckhpd {{.*#+}} xmm6 = xmm6[1],xmm3[1]
; SSE-32-NEXT:    ucomiss %xmm5, %xmm6
; SSE-32-NEXT:    movl $0, %edx
; SSE-32-NEXT:    cmovbel %ecx, %edx
; SSE-32-NEXT:    movd %edx, %xmm5
; SSE-32-NEXT:    punpckldq {{.*#+}} xmm5 = xmm5[0],xmm4[0],xmm5[1],xmm4[1]
; SSE-32-NEXT:    ucomiss %xmm2, %xmm3
; SSE-32-NEXT:    movl $0, %edx
; SSE-32-NEXT:    cmovbel %ecx, %edx
; SSE-32-NEXT:    movd %edx, %xmm4
; SSE-32-NEXT:    shufps {{.*#+}} xmm2 = xmm2[1,1,1,1]
; SSE-32-NEXT:    shufps {{.*#+}} xmm3 = xmm3[1,1,1,1]
; SSE-32-NEXT:    ucomiss %xmm2, %xmm3
; SSE-32-NEXT:    cmovbel %ecx, %eax
; SSE-32-NEXT:    movd %eax, %xmm2
; SSE-32-NEXT:    punpckldq {{.*#+}} xmm4 = xmm4[0],xmm2[0],xmm4[1],xmm2[1]
; SSE-32-NEXT:    punpcklqdq {{.*#+}} xmm4 = xmm4[0],xmm5[0]
; SSE-32-NEXT:    pand %xmm4, %xmm0
; SSE-32-NEXT:    pandn %xmm1, %xmm4
; SSE-32-NEXT:    por %xmm4, %xmm0
; SSE-32-NEXT:    movl %ebp, %esp
; SSE-32-NEXT:    popl %ebp
; SSE-32-NEXT:    retl
;
; SSE-64-LABEL: test_v4f32_uge_q:
; SSE-64:       # %bb.0:
; SSE-64-NEXT:    movaps %xmm2, %xmm4
; SSE-64-NEXT:    shufps {{.*#+}} xmm4 = xmm4[3,3],xmm2[3,3]
; SSE-64-NEXT:    movaps %xmm3, %xmm5
; SSE-64-NEXT:    shufps {{.*#+}} xmm5 = xmm5[3,3],xmm3[3,3]
; SSE-64-NEXT:    xorl %eax, %eax
; SSE-64-NEXT:    ucomiss %xmm4, %xmm5
; SSE-64-NEXT:    movl $-1, %ecx
; SSE-64-NEXT:    movl $0, %edx
; SSE-64-NEXT:    cmovbel %ecx, %edx
; SSE-64-NEXT:    movd %edx, %xmm4
; SSE-64-NEXT:    movaps %xmm2, %xmm5
; SSE-64-NEXT:    unpckhpd {{.*#+}} xmm5 = xmm5[1],xmm2[1]
; SSE-64-NEXT:    movaps %xmm3, %xmm6
; SSE-64-NEXT:    unpckhpd {{.*#+}} xmm6 = xmm6[1],xmm3[1]
; SSE-64-NEXT:    ucomiss %xmm5, %xmm6
; SSE-64-NEXT:    movl $0, %edx
; SSE-64-NEXT:    cmovbel %ecx, %edx
; SSE-64-NEXT:    movd %edx, %xmm5
; SSE-64-NEXT:    punpckldq {{.*#+}} xmm5 = xmm5[0],xmm4[0],xmm5[1],xmm4[1]
; SSE-64-NEXT:    ucomiss %xmm2, %xmm3
; SSE-64-NEXT:    movl $0, %edx
; SSE-64-NEXT:    cmovbel %ecx, %edx
; SSE-64-NEXT:    movd %edx, %xmm4
; SSE-64-NEXT:    shufps {{.*#+}} xmm2 = xmm2[1,1,1,1]
; SSE-64-NEXT:    shufps {{.*#+}} xmm3 = xmm3[1,1,1,1]
; SSE-64-NEXT:    ucomiss %xmm2, %xmm3
; SSE-64-NEXT:    cmovbel %ecx, %eax
; SSE-64-NEXT:    movd %eax, %xmm2
; SSE-64-NEXT:    punpckldq {{.*#+}} xmm4 = xmm4[0],xmm2[0],xmm4[1],xmm2[1]
; SSE-64-NEXT:    punpcklqdq {{.*#+}} xmm4 = xmm4[0],xmm5[0]
; SSE-64-NEXT:    pand %xmm4, %xmm0
; SSE-64-NEXT:    pandn %xmm1, %xmm4
; SSE-64-NEXT:    por %xmm4, %xmm0
; SSE-64-NEXT:    retq
;
; AVX-32-LABEL: test_v4f32_uge_q:
; AVX-32:       # %bb.0:
; AVX-32-NEXT:    pushl %ebp
; AVX-32-NEXT:    movl %esp, %ebp
; AVX-32-NEXT:    andl $-16, %esp
; AVX-32-NEXT:    subl $16, %esp
; AVX-32-NEXT:    vcmpnlt_uqps 8(%ebp), %xmm2, %xmm2
; AVX-32-NEXT:    vblendvps %xmm2, %xmm0, %xmm1, %xmm0
; AVX-32-NEXT:    movl %ebp, %esp
; AVX-32-NEXT:    popl %ebp
; AVX-32-NEXT:    retl
;
; AVX-64-LABEL: test_v4f32_uge_q:
; AVX-64:       # %bb.0:
; AVX-64-NEXT:    vcmpnlt_uqps %xmm3, %xmm2, %xmm2
; AVX-64-NEXT:    vblendvps %xmm2, %xmm0, %xmm1, %xmm0
; AVX-64-NEXT:    retq
;
; AVX512-32-LABEL: test_v4f32_uge_q:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-16, %esp
; AVX512-32-NEXT:    subl $16, %esp
; AVX512-32-NEXT:    vcmpnlt_uqps 8(%ebp), %xmm2, %k1
; AVX512-32-NEXT:    vpblendmd %xmm0, %xmm1, %xmm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v4f32_uge_q:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmpnlt_uqps %xmm3, %xmm2, %k1
; AVX512-64-NEXT:    vpblendmd %xmm0, %xmm1, %xmm0 {%k1}
; AVX512-64-NEXT:    retq
;
; AVX512F-32-LABEL: test_v4f32_uge_q:
; AVX512F-32:       # %bb.0:
; AVX512F-32-NEXT:    pushl %ebp
; AVX512F-32-NEXT:    movl %esp, %ebp
; AVX512F-32-NEXT:    andl $-16, %esp
; AVX512F-32-NEXT:    subl $16, %esp
; AVX512F-32-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-32-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-32-NEXT:    vcmpnlt_uqps 8(%ebp), %xmm2, %xmm2
; AVX512F-32-NEXT:    vptestmd %zmm2, %zmm2, %k1
; AVX512F-32-NEXT:    vpblendmd %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-32-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-32-NEXT:    movl %ebp, %esp
; AVX512F-32-NEXT:    popl %ebp
; AVX512F-32-NEXT:    vzeroupper
; AVX512F-32-NEXT:    retl
;
; AVX512F-64-LABEL: test_v4f32_uge_q:
; AVX512F-64:       # %bb.0:
; AVX512F-64-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-64-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-64-NEXT:    vcmpnlt_uqps %xmm3, %xmm2, %xmm2
; AVX512F-64-NEXT:    vptestmd %zmm2, %zmm2, %k1
; AVX512F-64-NEXT:    vpblendmd %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-64-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-64-NEXT:    vzeroupper
; AVX512F-64-NEXT:    retq
  %cond = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f32(
                                               <4 x float> %f1, <4 x float> %f2, metadata !"uge",
                                               metadata !"fpexcept.strict") #0
  %res = select <4 x i1> %cond, <4 x i32> %a, <4 x i32> %b
  ret <4 x i32> %res
}

define <4 x i32> @test_v4f32_ult_q(<4 x i32> %a, <4 x i32> %b, <4 x float> %f1, <4 x float> %f2) #0 {
; SSE-32-LABEL: test_v4f32_ult_q:
; SSE-32:       # %bb.0:
; SSE-32-NEXT:    pushl %ebp
; SSE-32-NEXT:    movl %esp, %ebp
; SSE-32-NEXT:    andl $-16, %esp
; SSE-32-NEXT:    subl $16, %esp
; SSE-32-NEXT:    movaps 8(%ebp), %xmm3
; SSE-32-NEXT:    movaps %xmm3, %xmm4
; SSE-32-NEXT:    shufps {{.*#+}} xmm4 = xmm4[3,3],xmm3[3,3]
; SSE-32-NEXT:    movaps %xmm2, %xmm5
; SSE-32-NEXT:    shufps {{.*#+}} xmm5 = xmm5[3,3],xmm2[3,3]
; SSE-32-NEXT:    xorl %eax, %eax
; SSE-32-NEXT:    ucomiss %xmm4, %xmm5
; SSE-32-NEXT:    movl $-1, %ecx
; SSE-32-NEXT:    movl $0, %edx
; SSE-32-NEXT:    cmovbl %ecx, %edx
; SSE-32-NEXT:    movd %edx, %xmm4
; SSE-32-NEXT:    movaps %xmm3, %xmm5
; SSE-32-NEXT:    unpckhpd {{.*#+}} xmm5 = xmm5[1],xmm3[1]
; SSE-32-NEXT:    movaps %xmm2, %xmm6
; SSE-32-NEXT:    unpckhpd {{.*#+}} xmm6 = xmm6[1],xmm2[1]
; SSE-32-NEXT:    ucomiss %xmm5, %xmm6
; SSE-32-NEXT:    movl $0, %edx
; SSE-32-NEXT:    cmovbl %ecx, %edx
; SSE-32-NEXT:    movd %edx, %xmm5
; SSE-32-NEXT:    punpckldq {{.*#+}} xmm5 = xmm5[0],xmm4[0],xmm5[1],xmm4[1]
; SSE-32-NEXT:    ucomiss %xmm3, %xmm2
; SSE-32-NEXT:    movl $0, %edx
; SSE-32-NEXT:    cmovbl %ecx, %edx
; SSE-32-NEXT:    movd %edx, %xmm4
; SSE-32-NEXT:    shufps {{.*#+}} xmm3 = xmm3[1,1,1,1]
; SSE-32-NEXT:    shufps {{.*#+}} xmm2 = xmm2[1,1,1,1]
; SSE-32-NEXT:    ucomiss %xmm3, %xmm2
; SSE-32-NEXT:    cmovbl %ecx, %eax
; SSE-32-NEXT:    movd %eax, %xmm2
; SSE-32-NEXT:    punpckldq {{.*#+}} xmm4 = xmm4[0],xmm2[0],xmm4[1],xmm2[1]
; SSE-32-NEXT:    punpcklqdq {{.*#+}} xmm4 = xmm4[0],xmm5[0]
; SSE-32-NEXT:    pand %xmm4, %xmm0
; SSE-32-NEXT:    pandn %xmm1, %xmm4
; SSE-32-NEXT:    por %xmm4, %xmm0
; SSE-32-NEXT:    movl %ebp, %esp
; SSE-32-NEXT:    popl %ebp
; SSE-32-NEXT:    retl
;
; SSE-64-LABEL: test_v4f32_ult_q:
; SSE-64:       # %bb.0:
; SSE-64-NEXT:    movaps %xmm3, %xmm4
; SSE-64-NEXT:    shufps {{.*#+}} xmm4 = xmm4[3,3],xmm3[3,3]
; SSE-64-NEXT:    movaps %xmm2, %xmm5
; SSE-64-NEXT:    shufps {{.*#+}} xmm5 = xmm5[3,3],xmm2[3,3]
; SSE-64-NEXT:    xorl %eax, %eax
; SSE-64-NEXT:    ucomiss %xmm4, %xmm5
; SSE-64-NEXT:    movl $-1, %ecx
; SSE-64-NEXT:    movl $0, %edx
; SSE-64-NEXT:    cmovbl %ecx, %edx
; SSE-64-NEXT:    movd %edx, %xmm4
; SSE-64-NEXT:    movaps %xmm3, %xmm5
; SSE-64-NEXT:    unpckhpd {{.*#+}} xmm5 = xmm5[1],xmm3[1]
; SSE-64-NEXT:    movaps %xmm2, %xmm6
; SSE-64-NEXT:    unpckhpd {{.*#+}} xmm6 = xmm6[1],xmm2[1]
; SSE-64-NEXT:    ucomiss %xmm5, %xmm6
; SSE-64-NEXT:    movl $0, %edx
; SSE-64-NEXT:    cmovbl %ecx, %edx
; SSE-64-NEXT:    movd %edx, %xmm5
; SSE-64-NEXT:    punpckldq {{.*#+}} xmm5 = xmm5[0],xmm4[0],xmm5[1],xmm4[1]
; SSE-64-NEXT:    ucomiss %xmm3, %xmm2
; SSE-64-NEXT:    movl $0, %edx
; SSE-64-NEXT:    cmovbl %ecx, %edx
; SSE-64-NEXT:    movd %edx, %xmm4
; SSE-64-NEXT:    shufps {{.*#+}} xmm3 = xmm3[1,1,1,1]
; SSE-64-NEXT:    shufps {{.*#+}} xmm2 = xmm2[1,1,1,1]
; SSE-64-NEXT:    ucomiss %xmm3, %xmm2
; SSE-64-NEXT:    cmovbl %ecx, %eax
; SSE-64-NEXT:    movd %eax, %xmm2
; SSE-64-NEXT:    punpckldq {{.*#+}} xmm4 = xmm4[0],xmm2[0],xmm4[1],xmm2[1]
; SSE-64-NEXT:    punpcklqdq {{.*#+}} xmm4 = xmm4[0],xmm5[0]
; SSE-64-NEXT:    pand %xmm4, %xmm0
; SSE-64-NEXT:    pandn %xmm1, %xmm4
; SSE-64-NEXT:    por %xmm4, %xmm0
; SSE-64-NEXT:    retq
;
; AVX-32-LABEL: test_v4f32_ult_q:
; AVX-32:       # %bb.0:
; AVX-32-NEXT:    pushl %ebp
; AVX-32-NEXT:    movl %esp, %ebp
; AVX-32-NEXT:    andl $-16, %esp
; AVX-32-NEXT:    subl $16, %esp
; AVX-32-NEXT:    vmovaps 8(%ebp), %xmm3
; AVX-32-NEXT:    vcmpnle_uqps %xmm2, %xmm3, %xmm2
; AVX-32-NEXT:    vblendvps %xmm2, %xmm0, %xmm1, %xmm0
; AVX-32-NEXT:    movl %ebp, %esp
; AVX-32-NEXT:    popl %ebp
; AVX-32-NEXT:    retl
;
; AVX-64-LABEL: test_v4f32_ult_q:
; AVX-64:       # %bb.0:
; AVX-64-NEXT:    vcmpnle_uqps %xmm2, %xmm3, %xmm2
; AVX-64-NEXT:    vblendvps %xmm2, %xmm0, %xmm1, %xmm0
; AVX-64-NEXT:    retq
;
; AVX512-32-LABEL: test_v4f32_ult_q:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-16, %esp
; AVX512-32-NEXT:    subl $16, %esp
; AVX512-32-NEXT:    vcmpnge_uqps 8(%ebp), %xmm2, %k1
; AVX512-32-NEXT:    vpblendmd %xmm0, %xmm1, %xmm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v4f32_ult_q:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmpnle_uqps %xmm2, %xmm3, %k1
; AVX512-64-NEXT:    vpblendmd %xmm0, %xmm1, %xmm0 {%k1}
; AVX512-64-NEXT:    retq
;
; AVX512F-32-LABEL: test_v4f32_ult_q:
; AVX512F-32:       # %bb.0:
; AVX512F-32-NEXT:    pushl %ebp
; AVX512F-32-NEXT:    movl %esp, %ebp
; AVX512F-32-NEXT:    andl $-16, %esp
; AVX512F-32-NEXT:    subl $16, %esp
; AVX512F-32-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-32-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-32-NEXT:    vmovaps 8(%ebp), %xmm3
; AVX512F-32-NEXT:    vcmpnle_uqps %xmm2, %xmm3, %xmm2
; AVX512F-32-NEXT:    vptestmd %zmm2, %zmm2, %k1
; AVX512F-32-NEXT:    vpblendmd %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-32-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-32-NEXT:    movl %ebp, %esp
; AVX512F-32-NEXT:    popl %ebp
; AVX512F-32-NEXT:    vzeroupper
; AVX512F-32-NEXT:    retl
;
; AVX512F-64-LABEL: test_v4f32_ult_q:
; AVX512F-64:       # %bb.0:
; AVX512F-64-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-64-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-64-NEXT:    vcmpnle_uqps %xmm2, %xmm3, %xmm2
; AVX512F-64-NEXT:    vptestmd %zmm2, %zmm2, %k1
; AVX512F-64-NEXT:    vpblendmd %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-64-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-64-NEXT:    vzeroupper
; AVX512F-64-NEXT:    retq
  %cond = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f32(
                                               <4 x float> %f1, <4 x float> %f2, metadata !"ult",
                                               metadata !"fpexcept.strict") #0
  %res = select <4 x i1> %cond, <4 x i32> %a, <4 x i32> %b
  ret <4 x i32> %res
}

define <4 x i32> @test_v4f32_ule_q(<4 x i32> %a, <4 x i32> %b, <4 x float> %f1, <4 x float> %f2) #0 {
; SSE-32-LABEL: test_v4f32_ule_q:
; SSE-32:       # %bb.0:
; SSE-32-NEXT:    pushl %ebp
; SSE-32-NEXT:    movl %esp, %ebp
; SSE-32-NEXT:    andl $-16, %esp
; SSE-32-NEXT:    subl $16, %esp
; SSE-32-NEXT:    movaps 8(%ebp), %xmm3
; SSE-32-NEXT:    movaps %xmm3, %xmm4
; SSE-32-NEXT:    shufps {{.*#+}} xmm4 = xmm4[3,3],xmm3[3,3]
; SSE-32-NEXT:    movaps %xmm2, %xmm5
; SSE-32-NEXT:    shufps {{.*#+}} xmm5 = xmm5[3,3],xmm2[3,3]
; SSE-32-NEXT:    xorl %eax, %eax
; SSE-32-NEXT:    ucomiss %xmm4, %xmm5
; SSE-32-NEXT:    movl $-1, %ecx
; SSE-32-NEXT:    movl $0, %edx
; SSE-32-NEXT:    cmovbel %ecx, %edx
; SSE-32-NEXT:    movd %edx, %xmm4
; SSE-32-NEXT:    movaps %xmm3, %xmm5
; SSE-32-NEXT:    unpckhpd {{.*#+}} xmm5 = xmm5[1],xmm3[1]
; SSE-32-NEXT:    movaps %xmm2, %xmm6
; SSE-32-NEXT:    unpckhpd {{.*#+}} xmm6 = xmm6[1],xmm2[1]
; SSE-32-NEXT:    ucomiss %xmm5, %xmm6
; SSE-32-NEXT:    movl $0, %edx
; SSE-32-NEXT:    cmovbel %ecx, %edx
; SSE-32-NEXT:    movd %edx, %xmm5
; SSE-32-NEXT:    punpckldq {{.*#+}} xmm5 = xmm5[0],xmm4[0],xmm5[1],xmm4[1]
; SSE-32-NEXT:    ucomiss %xmm3, %xmm2
; SSE-32-NEXT:    movl $0, %edx
; SSE-32-NEXT:    cmovbel %ecx, %edx
; SSE-32-NEXT:    movd %edx, %xmm4
; SSE-32-NEXT:    shufps {{.*#+}} xmm3 = xmm3[1,1,1,1]
; SSE-32-NEXT:    shufps {{.*#+}} xmm2 = xmm2[1,1,1,1]
; SSE-32-NEXT:    ucomiss %xmm3, %xmm2
; SSE-32-NEXT:    cmovbel %ecx, %eax
; SSE-32-NEXT:    movd %eax, %xmm2
; SSE-32-NEXT:    punpckldq {{.*#+}} xmm4 = xmm4[0],xmm2[0],xmm4[1],xmm2[1]
; SSE-32-NEXT:    punpcklqdq {{.*#+}} xmm4 = xmm4[0],xmm5[0]
; SSE-32-NEXT:    pand %xmm4, %xmm0
; SSE-32-NEXT:    pandn %xmm1, %xmm4
; SSE-32-NEXT:    por %xmm4, %xmm0
; SSE-32-NEXT:    movl %ebp, %esp
; SSE-32-NEXT:    popl %ebp
; SSE-32-NEXT:    retl
;
; SSE-64-LABEL: test_v4f32_ule_q:
; SSE-64:       # %bb.0:
; SSE-64-NEXT:    movaps %xmm3, %xmm4
; SSE-64-NEXT:    shufps {{.*#+}} xmm4 = xmm4[3,3],xmm3[3,3]
; SSE-64-NEXT:    movaps %xmm2, %xmm5
; SSE-64-NEXT:    shufps {{.*#+}} xmm5 = xmm5[3,3],xmm2[3,3]
; SSE-64-NEXT:    xorl %eax, %eax
; SSE-64-NEXT:    ucomiss %xmm4, %xmm5
; SSE-64-NEXT:    movl $-1, %ecx
; SSE-64-NEXT:    movl $0, %edx
; SSE-64-NEXT:    cmovbel %ecx, %edx
; SSE-64-NEXT:    movd %edx, %xmm4
; SSE-64-NEXT:    movaps %xmm3, %xmm5
; SSE-64-NEXT:    unpckhpd {{.*#+}} xmm5 = xmm5[1],xmm3[1]
; SSE-64-NEXT:    movaps %xmm2, %xmm6
; SSE-64-NEXT:    unpckhpd {{.*#+}} xmm6 = xmm6[1],xmm2[1]
; SSE-64-NEXT:    ucomiss %xmm5, %xmm6
; SSE-64-NEXT:    movl $0, %edx
; SSE-64-NEXT:    cmovbel %ecx, %edx
; SSE-64-NEXT:    movd %edx, %xmm5
; SSE-64-NEXT:    punpckldq {{.*#+}} xmm5 = xmm5[0],xmm4[0],xmm5[1],xmm4[1]
; SSE-64-NEXT:    ucomiss %xmm3, %xmm2
; SSE-64-NEXT:    movl $0, %edx
; SSE-64-NEXT:    cmovbel %ecx, %edx
; SSE-64-NEXT:    movd %edx, %xmm4
; SSE-64-NEXT:    shufps {{.*#+}} xmm3 = xmm3[1,1,1,1]
; SSE-64-NEXT:    shufps {{.*#+}} xmm2 = xmm2[1,1,1,1]
; SSE-64-NEXT:    ucomiss %xmm3, %xmm2
; SSE-64-NEXT:    cmovbel %ecx, %eax
; SSE-64-NEXT:    movd %eax, %xmm2
; SSE-64-NEXT:    punpckldq {{.*#+}} xmm4 = xmm4[0],xmm2[0],xmm4[1],xmm2[1]
; SSE-64-NEXT:    punpcklqdq {{.*#+}} xmm4 = xmm4[0],xmm5[0]
; SSE-64-NEXT:    pand %xmm4, %xmm0
; SSE-64-NEXT:    pandn %xmm1, %xmm4
; SSE-64-NEXT:    por %xmm4, %xmm0
; SSE-64-NEXT:    retq
;
; AVX-32-LABEL: test_v4f32_ule_q:
; AVX-32:       # %bb.0:
; AVX-32-NEXT:    pushl %ebp
; AVX-32-NEXT:    movl %esp, %ebp
; AVX-32-NEXT:    andl $-16, %esp
; AVX-32-NEXT:    subl $16, %esp
; AVX-32-NEXT:    vmovaps 8(%ebp), %xmm3
; AVX-32-NEXT:    vcmpnlt_uqps %xmm2, %xmm3, %xmm2
; AVX-32-NEXT:    vblendvps %xmm2, %xmm0, %xmm1, %xmm0
; AVX-32-NEXT:    movl %ebp, %esp
; AVX-32-NEXT:    popl %ebp
; AVX-32-NEXT:    retl
;
; AVX-64-LABEL: test_v4f32_ule_q:
; AVX-64:       # %bb.0:
; AVX-64-NEXT:    vcmpnlt_uqps %xmm2, %xmm3, %xmm2
; AVX-64-NEXT:    vblendvps %xmm2, %xmm0, %xmm1, %xmm0
; AVX-64-NEXT:    retq
;
; AVX512-32-LABEL: test_v4f32_ule_q:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-16, %esp
; AVX512-32-NEXT:    subl $16, %esp
; AVX512-32-NEXT:    vcmpngt_uqps 8(%ebp), %xmm2, %k1
; AVX512-32-NEXT:    vpblendmd %xmm0, %xmm1, %xmm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v4f32_ule_q:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmpnlt_uqps %xmm2, %xmm3, %k1
; AVX512-64-NEXT:    vpblendmd %xmm0, %xmm1, %xmm0 {%k1}
; AVX512-64-NEXT:    retq
;
; AVX512F-32-LABEL: test_v4f32_ule_q:
; AVX512F-32:       # %bb.0:
; AVX512F-32-NEXT:    pushl %ebp
; AVX512F-32-NEXT:    movl %esp, %ebp
; AVX512F-32-NEXT:    andl $-16, %esp
; AVX512F-32-NEXT:    subl $16, %esp
; AVX512F-32-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-32-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-32-NEXT:    vmovaps 8(%ebp), %xmm3
; AVX512F-32-NEXT:    vcmpnlt_uqps %xmm2, %xmm3, %xmm2
; AVX512F-32-NEXT:    vptestmd %zmm2, %zmm2, %k1
; AVX512F-32-NEXT:    vpblendmd %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-32-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-32-NEXT:    movl %ebp, %esp
; AVX512F-32-NEXT:    popl %ebp
; AVX512F-32-NEXT:    vzeroupper
; AVX512F-32-NEXT:    retl
;
; AVX512F-64-LABEL: test_v4f32_ule_q:
; AVX512F-64:       # %bb.0:
; AVX512F-64-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-64-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-64-NEXT:    vcmpnlt_uqps %xmm2, %xmm3, %xmm2
; AVX512F-64-NEXT:    vptestmd %zmm2, %zmm2, %k1
; AVX512F-64-NEXT:    vpblendmd %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-64-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-64-NEXT:    vzeroupper
; AVX512F-64-NEXT:    retq
  %cond = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f32(
                                               <4 x float> %f1, <4 x float> %f2, metadata !"ule",
                                               metadata !"fpexcept.strict") #0
  %res = select <4 x i1> %cond, <4 x i32> %a, <4 x i32> %b
  ret <4 x i32> %res
}

define <4 x i32> @test_v4f32_une_q(<4 x i32> %a, <4 x i32> %b, <4 x float> %f1, <4 x float> %f2) #0 {
; SSE-32-LABEL: test_v4f32_une_q:
; SSE-32:       # %bb.0:
; SSE-32-NEXT:    pushl %ebp
; SSE-32-NEXT:    movl %esp, %ebp
; SSE-32-NEXT:    andl $-16, %esp
; SSE-32-NEXT:    subl $16, %esp
; SSE-32-NEXT:    cmpneqps 8(%ebp), %xmm2
; SSE-32-NEXT:    andps %xmm2, %xmm0
; SSE-32-NEXT:    andnps %xmm1, %xmm2
; SSE-32-NEXT:    orps %xmm2, %xmm0
; SSE-32-NEXT:    movl %ebp, %esp
; SSE-32-NEXT:    popl %ebp
; SSE-32-NEXT:    retl
;
; SSE-64-LABEL: test_v4f32_une_q:
; SSE-64:       # %bb.0:
; SSE-64-NEXT:    cmpneqps %xmm3, %xmm2
; SSE-64-NEXT:    andps %xmm2, %xmm0
; SSE-64-NEXT:    andnps %xmm1, %xmm2
; SSE-64-NEXT:    orps %xmm2, %xmm0
; SSE-64-NEXT:    retq
;
; AVX-32-LABEL: test_v4f32_une_q:
; AVX-32:       # %bb.0:
; AVX-32-NEXT:    pushl %ebp
; AVX-32-NEXT:    movl %esp, %ebp
; AVX-32-NEXT:    andl $-16, %esp
; AVX-32-NEXT:    subl $16, %esp
; AVX-32-NEXT:    vcmpneqps 8(%ebp), %xmm2, %xmm2
; AVX-32-NEXT:    vblendvps %xmm2, %xmm0, %xmm1, %xmm0
; AVX-32-NEXT:    movl %ebp, %esp
; AVX-32-NEXT:    popl %ebp
; AVX-32-NEXT:    retl
;
; AVX-64-LABEL: test_v4f32_une_q:
; AVX-64:       # %bb.0:
; AVX-64-NEXT:    vcmpneqps %xmm3, %xmm2, %xmm2
; AVX-64-NEXT:    vblendvps %xmm2, %xmm0, %xmm1, %xmm0
; AVX-64-NEXT:    retq
;
; AVX512-32-LABEL: test_v4f32_une_q:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-16, %esp
; AVX512-32-NEXT:    subl $16, %esp
; AVX512-32-NEXT:    vcmpneqps 8(%ebp), %xmm2, %k1
; AVX512-32-NEXT:    vpblendmd %xmm0, %xmm1, %xmm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v4f32_une_q:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmpneqps %xmm3, %xmm2, %k1
; AVX512-64-NEXT:    vpblendmd %xmm0, %xmm1, %xmm0 {%k1}
; AVX512-64-NEXT:    retq
;
; AVX512F-32-LABEL: test_v4f32_une_q:
; AVX512F-32:       # %bb.0:
; AVX512F-32-NEXT:    pushl %ebp
; AVX512F-32-NEXT:    movl %esp, %ebp
; AVX512F-32-NEXT:    andl $-16, %esp
; AVX512F-32-NEXT:    subl $16, %esp
; AVX512F-32-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-32-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-32-NEXT:    vcmpneqps 8(%ebp), %xmm2, %xmm2
; AVX512F-32-NEXT:    vptestmd %zmm2, %zmm2, %k1
; AVX512F-32-NEXT:    vpblendmd %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-32-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-32-NEXT:    movl %ebp, %esp
; AVX512F-32-NEXT:    popl %ebp
; AVX512F-32-NEXT:    vzeroupper
; AVX512F-32-NEXT:    retl
;
; AVX512F-64-LABEL: test_v4f32_une_q:
; AVX512F-64:       # %bb.0:
; AVX512F-64-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-64-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-64-NEXT:    vcmpneqps %xmm3, %xmm2, %xmm2
; AVX512F-64-NEXT:    vptestmd %zmm2, %zmm2, %k1
; AVX512F-64-NEXT:    vpblendmd %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-64-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-64-NEXT:    vzeroupper
; AVX512F-64-NEXT:    retq
  %cond = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f32(
                                               <4 x float> %f1, <4 x float> %f2, metadata !"une",
                                               metadata !"fpexcept.strict") #0
  %res = select <4 x i1> %cond, <4 x i32> %a, <4 x i32> %b
  ret <4 x i32> %res
}

define <4 x i32> @test_v4f32_uno_q(<4 x i32> %a, <4 x i32> %b, <4 x float> %f1, <4 x float> %f2) #0 {
; SSE-32-LABEL: test_v4f32_uno_q:
; SSE-32:       # %bb.0:
; SSE-32-NEXT:    pushl %ebp
; SSE-32-NEXT:    movl %esp, %ebp
; SSE-32-NEXT:    andl $-16, %esp
; SSE-32-NEXT:    subl $16, %esp
; SSE-32-NEXT:    cmpunordps 8(%ebp), %xmm2
; SSE-32-NEXT:    andps %xmm2, %xmm0
; SSE-32-NEXT:    andnps %xmm1, %xmm2
; SSE-32-NEXT:    orps %xmm2, %xmm0
; SSE-32-NEXT:    movl %ebp, %esp
; SSE-32-NEXT:    popl %ebp
; SSE-32-NEXT:    retl
;
; SSE-64-LABEL: test_v4f32_uno_q:
; SSE-64:       # %bb.0:
; SSE-64-NEXT:    cmpunordps %xmm3, %xmm2
; SSE-64-NEXT:    andps %xmm2, %xmm0
; SSE-64-NEXT:    andnps %xmm1, %xmm2
; SSE-64-NEXT:    orps %xmm2, %xmm0
; SSE-64-NEXT:    retq
;
; AVX-32-LABEL: test_v4f32_uno_q:
; AVX-32:       # %bb.0:
; AVX-32-NEXT:    pushl %ebp
; AVX-32-NEXT:    movl %esp, %ebp
; AVX-32-NEXT:    andl $-16, %esp
; AVX-32-NEXT:    subl $16, %esp
; AVX-32-NEXT:    vcmpunordps 8(%ebp), %xmm2, %xmm2
; AVX-32-NEXT:    vblendvps %xmm2, %xmm0, %xmm1, %xmm0
; AVX-32-NEXT:    movl %ebp, %esp
; AVX-32-NEXT:    popl %ebp
; AVX-32-NEXT:    retl
;
; AVX-64-LABEL: test_v4f32_uno_q:
; AVX-64:       # %bb.0:
; AVX-64-NEXT:    vcmpunordps %xmm3, %xmm2, %xmm2
; AVX-64-NEXT:    vblendvps %xmm2, %xmm0, %xmm1, %xmm0
; AVX-64-NEXT:    retq
;
; AVX512-32-LABEL: test_v4f32_uno_q:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-16, %esp
; AVX512-32-NEXT:    subl $16, %esp
; AVX512-32-NEXT:    vcmpunordps 8(%ebp), %xmm2, %k1
; AVX512-32-NEXT:    vpblendmd %xmm0, %xmm1, %xmm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v4f32_uno_q:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmpunordps %xmm3, %xmm2, %k1
; AVX512-64-NEXT:    vpblendmd %xmm0, %xmm1, %xmm0 {%k1}
; AVX512-64-NEXT:    retq
;
; AVX512F-32-LABEL: test_v4f32_uno_q:
; AVX512F-32:       # %bb.0:
; AVX512F-32-NEXT:    pushl %ebp
; AVX512F-32-NEXT:    movl %esp, %ebp
; AVX512F-32-NEXT:    andl $-16, %esp
; AVX512F-32-NEXT:    subl $16, %esp
; AVX512F-32-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-32-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-32-NEXT:    vcmpunordps 8(%ebp), %xmm2, %xmm2
; AVX512F-32-NEXT:    vptestmd %zmm2, %zmm2, %k1
; AVX512F-32-NEXT:    vpblendmd %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-32-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-32-NEXT:    movl %ebp, %esp
; AVX512F-32-NEXT:    popl %ebp
; AVX512F-32-NEXT:    vzeroupper
; AVX512F-32-NEXT:    retl
;
; AVX512F-64-LABEL: test_v4f32_uno_q:
; AVX512F-64:       # %bb.0:
; AVX512F-64-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-64-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-64-NEXT:    vcmpunordps %xmm3, %xmm2, %xmm2
; AVX512F-64-NEXT:    vptestmd %zmm2, %zmm2, %k1
; AVX512F-64-NEXT:    vpblendmd %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-64-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-64-NEXT:    vzeroupper
; AVX512F-64-NEXT:    retq
  %cond = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f32(
                                               <4 x float> %f1, <4 x float> %f2, metadata !"uno",
                                               metadata !"fpexcept.strict") #0
  %res = select <4 x i1> %cond, <4 x i32> %a, <4 x i32> %b
  ret <4 x i32> %res
}

define <2 x i64> @test_v2f64_oeq_q(<2 x i64> %a, <2 x i64> %b, <2 x double> %f1, <2 x double> %f2) #0 {
; SSE-32-LABEL: test_v2f64_oeq_q:
; SSE-32:       # %bb.0:
; SSE-32-NEXT:    pushl %ebp
; SSE-32-NEXT:    movl %esp, %ebp
; SSE-32-NEXT:    andl $-16, %esp
; SSE-32-NEXT:    subl $16, %esp
; SSE-32-NEXT:    cmpeqpd 8(%ebp), %xmm2
; SSE-32-NEXT:    andpd %xmm2, %xmm0
; SSE-32-NEXT:    andnpd %xmm1, %xmm2
; SSE-32-NEXT:    orpd %xmm2, %xmm0
; SSE-32-NEXT:    movl %ebp, %esp
; SSE-32-NEXT:    popl %ebp
; SSE-32-NEXT:    retl
;
; SSE-64-LABEL: test_v2f64_oeq_q:
; SSE-64:       # %bb.0:
; SSE-64-NEXT:    cmpeqpd %xmm3, %xmm2
; SSE-64-NEXT:    andpd %xmm2, %xmm0
; SSE-64-NEXT:    andnpd %xmm1, %xmm2
; SSE-64-NEXT:    orpd %xmm2, %xmm0
; SSE-64-NEXT:    retq
;
; AVX-32-LABEL: test_v2f64_oeq_q:
; AVX-32:       # %bb.0:
; AVX-32-NEXT:    pushl %ebp
; AVX-32-NEXT:    movl %esp, %ebp
; AVX-32-NEXT:    andl $-16, %esp
; AVX-32-NEXT:    subl $16, %esp
; AVX-32-NEXT:    vcmpeqpd 8(%ebp), %xmm2, %xmm2
; AVX-32-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; AVX-32-NEXT:    movl %ebp, %esp
; AVX-32-NEXT:    popl %ebp
; AVX-32-NEXT:    retl
;
; AVX-64-LABEL: test_v2f64_oeq_q:
; AVX-64:       # %bb.0:
; AVX-64-NEXT:    vcmpeqpd %xmm3, %xmm2, %xmm2
; AVX-64-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; AVX-64-NEXT:    retq
;
; AVX512-32-LABEL: test_v2f64_oeq_q:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-16, %esp
; AVX512-32-NEXT:    subl $16, %esp
; AVX512-32-NEXT:    vcmpeqpd 8(%ebp), %xmm2, %k1
; AVX512-32-NEXT:    vpblendmq %xmm0, %xmm1, %xmm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v2f64_oeq_q:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmpeqpd %xmm3, %xmm2, %k1
; AVX512-64-NEXT:    vpblendmq %xmm0, %xmm1, %xmm0 {%k1}
; AVX512-64-NEXT:    retq
;
; AVX512F-32-LABEL: test_v2f64_oeq_q:
; AVX512F-32:       # %bb.0:
; AVX512F-32-NEXT:    pushl %ebp
; AVX512F-32-NEXT:    movl %esp, %ebp
; AVX512F-32-NEXT:    andl $-16, %esp
; AVX512F-32-NEXT:    subl $16, %esp
; AVX512F-32-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-32-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-32-NEXT:    vcmpeqpd 8(%ebp), %xmm2, %xmm2
; AVX512F-32-NEXT:    vptestmq %zmm2, %zmm2, %k1
; AVX512F-32-NEXT:    vpblendmq %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-32-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-32-NEXT:    movl %ebp, %esp
; AVX512F-32-NEXT:    popl %ebp
; AVX512F-32-NEXT:    vzeroupper
; AVX512F-32-NEXT:    retl
;
; AVX512F-64-LABEL: test_v2f64_oeq_q:
; AVX512F-64:       # %bb.0:
; AVX512F-64-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-64-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-64-NEXT:    vcmpeqpd %xmm3, %xmm2, %xmm2
; AVX512F-64-NEXT:    vptestmq %zmm2, %zmm2, %k1
; AVX512F-64-NEXT:    vpblendmq %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-64-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-64-NEXT:    vzeroupper
; AVX512F-64-NEXT:    retq
  %cond = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f64(
                                               <2 x double> %f1, <2 x double> %f2, metadata !"oeq",
                                               metadata !"fpexcept.strict") #0
  %res = select <2 x i1> %cond, <2 x i64> %a, <2 x i64> %b
  ret <2 x i64> %res
}

define <2 x i64> @test_v2f64_ogt_q(<2 x i64> %a, <2 x i64> %b, <2 x double> %f1, <2 x double> %f2) #0 {
; SSE-32-LABEL: test_v2f64_ogt_q:
; SSE-32:       # %bb.0:
; SSE-32-NEXT:    pushl %ebp
; SSE-32-NEXT:    movl %esp, %ebp
; SSE-32-NEXT:    andl $-16, %esp
; SSE-32-NEXT:    subl $16, %esp
; SSE-32-NEXT:    movapd 8(%ebp), %xmm3
; SSE-32-NEXT:    xorl %eax, %eax
; SSE-32-NEXT:    ucomisd %xmm3, %xmm2
; SSE-32-NEXT:    movl $-1, %ecx
; SSE-32-NEXT:    movl $0, %edx
; SSE-32-NEXT:    cmoval %ecx, %edx
; SSE-32-NEXT:    movd %edx, %xmm4
; SSE-32-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[0,0,1,1]
; SSE-32-NEXT:    unpckhpd {{.*#+}} xmm3 = xmm3[1,1]
; SSE-32-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1,1]
; SSE-32-NEXT:    ucomisd %xmm3, %xmm2
; SSE-32-NEXT:    cmoval %ecx, %eax
; SSE-32-NEXT:    movd %eax, %xmm2
; SSE-32-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,0,1,1]
; SSE-32-NEXT:    punpcklqdq {{.*#+}} xmm4 = xmm4[0],xmm2[0]
; SSE-32-NEXT:    pand %xmm4, %xmm0
; SSE-32-NEXT:    pandn %xmm1, %xmm4
; SSE-32-NEXT:    por %xmm4, %xmm0
; SSE-32-NEXT:    movl %ebp, %esp
; SSE-32-NEXT:    popl %ebp
; SSE-32-NEXT:    retl
;
; SSE-64-LABEL: test_v2f64_ogt_q:
; SSE-64:       # %bb.0:
; SSE-64-NEXT:    xorl %eax, %eax
; SSE-64-NEXT:    ucomisd %xmm3, %xmm2
; SSE-64-NEXT:    movq $-1, %rcx
; SSE-64-NEXT:    movl $0, %edx
; SSE-64-NEXT:    cmovaq %rcx, %rdx
; SSE-64-NEXT:    movq %rdx, %xmm4
; SSE-64-NEXT:    unpckhpd {{.*#+}} xmm3 = xmm3[1,1]
; SSE-64-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1,1]
; SSE-64-NEXT:    ucomisd %xmm3, %xmm2
; SSE-64-NEXT:    cmovaq %rcx, %rax
; SSE-64-NEXT:    movq %rax, %xmm2
; SSE-64-NEXT:    punpcklqdq {{.*#+}} xmm4 = xmm4[0],xmm2[0]
; SSE-64-NEXT:    pand %xmm4, %xmm0
; SSE-64-NEXT:    pandn %xmm1, %xmm4
; SSE-64-NEXT:    por %xmm4, %xmm0
; SSE-64-NEXT:    retq
;
; AVX-32-LABEL: test_v2f64_ogt_q:
; AVX-32:       # %bb.0:
; AVX-32-NEXT:    pushl %ebp
; AVX-32-NEXT:    movl %esp, %ebp
; AVX-32-NEXT:    andl $-16, %esp
; AVX-32-NEXT:    subl $16, %esp
; AVX-32-NEXT:    vmovapd 8(%ebp), %xmm3
; AVX-32-NEXT:    vcmplt_oqpd %xmm2, %xmm3, %xmm2
; AVX-32-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; AVX-32-NEXT:    movl %ebp, %esp
; AVX-32-NEXT:    popl %ebp
; AVX-32-NEXT:    retl
;
; AVX-64-LABEL: test_v2f64_ogt_q:
; AVX-64:       # %bb.0:
; AVX-64-NEXT:    vcmplt_oqpd %xmm2, %xmm3, %xmm2
; AVX-64-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; AVX-64-NEXT:    retq
;
; AVX512-32-LABEL: test_v2f64_ogt_q:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-16, %esp
; AVX512-32-NEXT:    subl $16, %esp
; AVX512-32-NEXT:    vcmpgt_oqpd 8(%ebp), %xmm2, %k1
; AVX512-32-NEXT:    vpblendmq %xmm0, %xmm1, %xmm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v2f64_ogt_q:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmplt_oqpd %xmm2, %xmm3, %k1
; AVX512-64-NEXT:    vpblendmq %xmm0, %xmm1, %xmm0 {%k1}
; AVX512-64-NEXT:    retq
;
; AVX512F-32-LABEL: test_v2f64_ogt_q:
; AVX512F-32:       # %bb.0:
; AVX512F-32-NEXT:    pushl %ebp
; AVX512F-32-NEXT:    movl %esp, %ebp
; AVX512F-32-NEXT:    andl $-16, %esp
; AVX512F-32-NEXT:    subl $16, %esp
; AVX512F-32-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-32-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-32-NEXT:    vmovapd 8(%ebp), %xmm3
; AVX512F-32-NEXT:    vcmplt_oqpd %xmm2, %xmm3, %xmm2
; AVX512F-32-NEXT:    vptestmq %zmm2, %zmm2, %k1
; AVX512F-32-NEXT:    vpblendmq %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-32-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-32-NEXT:    movl %ebp, %esp
; AVX512F-32-NEXT:    popl %ebp
; AVX512F-32-NEXT:    vzeroupper
; AVX512F-32-NEXT:    retl
;
; AVX512F-64-LABEL: test_v2f64_ogt_q:
; AVX512F-64:       # %bb.0:
; AVX512F-64-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-64-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-64-NEXT:    vcmplt_oqpd %xmm2, %xmm3, %xmm2
; AVX512F-64-NEXT:    vptestmq %zmm2, %zmm2, %k1
; AVX512F-64-NEXT:    vpblendmq %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-64-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-64-NEXT:    vzeroupper
; AVX512F-64-NEXT:    retq
  %cond = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f64(
                                               <2 x double> %f1, <2 x double> %f2, metadata !"ogt",
                                               metadata !"fpexcept.strict") #0
  %res = select <2 x i1> %cond, <2 x i64> %a, <2 x i64> %b
  ret <2 x i64> %res
}

define <2 x i64> @test_v2f64_oge_q(<2 x i64> %a, <2 x i64> %b, <2 x double> %f1, <2 x double> %f2) #0 {
; SSE-32-LABEL: test_v2f64_oge_q:
; SSE-32:       # %bb.0:
; SSE-32-NEXT:    pushl %ebp
; SSE-32-NEXT:    movl %esp, %ebp
; SSE-32-NEXT:    andl $-16, %esp
; SSE-32-NEXT:    subl $16, %esp
; SSE-32-NEXT:    movapd 8(%ebp), %xmm3
; SSE-32-NEXT:    xorl %eax, %eax
; SSE-32-NEXT:    ucomisd %xmm3, %xmm2
; SSE-32-NEXT:    movl $-1, %ecx
; SSE-32-NEXT:    movl $0, %edx
; SSE-32-NEXT:    cmovael %ecx, %edx
; SSE-32-NEXT:    movd %edx, %xmm4
; SSE-32-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[0,0,1,1]
; SSE-32-NEXT:    unpckhpd {{.*#+}} xmm3 = xmm3[1,1]
; SSE-32-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1,1]
; SSE-32-NEXT:    ucomisd %xmm3, %xmm2
; SSE-32-NEXT:    cmovael %ecx, %eax
; SSE-32-NEXT:    movd %eax, %xmm2
; SSE-32-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,0,1,1]
; SSE-32-NEXT:    punpcklqdq {{.*#+}} xmm4 = xmm4[0],xmm2[0]
; SSE-32-NEXT:    pand %xmm4, %xmm0
; SSE-32-NEXT:    pandn %xmm1, %xmm4
; SSE-32-NEXT:    por %xmm4, %xmm0
; SSE-32-NEXT:    movl %ebp, %esp
; SSE-32-NEXT:    popl %ebp
; SSE-32-NEXT:    retl
;
; SSE-64-LABEL: test_v2f64_oge_q:
; SSE-64:       # %bb.0:
; SSE-64-NEXT:    xorl %eax, %eax
; SSE-64-NEXT:    ucomisd %xmm3, %xmm2
; SSE-64-NEXT:    movq $-1, %rcx
; SSE-64-NEXT:    movl $0, %edx
; SSE-64-NEXT:    cmovaeq %rcx, %rdx
; SSE-64-NEXT:    movq %rdx, %xmm4
; SSE-64-NEXT:    unpckhpd {{.*#+}} xmm3 = xmm3[1,1]
; SSE-64-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1,1]
; SSE-64-NEXT:    ucomisd %xmm3, %xmm2
; SSE-64-NEXT:    cmovaeq %rcx, %rax
; SSE-64-NEXT:    movq %rax, %xmm2
; SSE-64-NEXT:    punpcklqdq {{.*#+}} xmm4 = xmm4[0],xmm2[0]
; SSE-64-NEXT:    pand %xmm4, %xmm0
; SSE-64-NEXT:    pandn %xmm1, %xmm4
; SSE-64-NEXT:    por %xmm4, %xmm0
; SSE-64-NEXT:    retq
;
; AVX-32-LABEL: test_v2f64_oge_q:
; AVX-32:       # %bb.0:
; AVX-32-NEXT:    pushl %ebp
; AVX-32-NEXT:    movl %esp, %ebp
; AVX-32-NEXT:    andl $-16, %esp
; AVX-32-NEXT:    subl $16, %esp
; AVX-32-NEXT:    vmovapd 8(%ebp), %xmm3
; AVX-32-NEXT:    vcmple_oqpd %xmm2, %xmm3, %xmm2
; AVX-32-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; AVX-32-NEXT:    movl %ebp, %esp
; AVX-32-NEXT:    popl %ebp
; AVX-32-NEXT:    retl
;
; AVX-64-LABEL: test_v2f64_oge_q:
; AVX-64:       # %bb.0:
; AVX-64-NEXT:    vcmple_oqpd %xmm2, %xmm3, %xmm2
; AVX-64-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; AVX-64-NEXT:    retq
;
; AVX512-32-LABEL: test_v2f64_oge_q:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-16, %esp
; AVX512-32-NEXT:    subl $16, %esp
; AVX512-32-NEXT:    vcmpge_oqpd 8(%ebp), %xmm2, %k1
; AVX512-32-NEXT:    vpblendmq %xmm0, %xmm1, %xmm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v2f64_oge_q:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmple_oqpd %xmm2, %xmm3, %k1
; AVX512-64-NEXT:    vpblendmq %xmm0, %xmm1, %xmm0 {%k1}
; AVX512-64-NEXT:    retq
;
; AVX512F-32-LABEL: test_v2f64_oge_q:
; AVX512F-32:       # %bb.0:
; AVX512F-32-NEXT:    pushl %ebp
; AVX512F-32-NEXT:    movl %esp, %ebp
; AVX512F-32-NEXT:    andl $-16, %esp
; AVX512F-32-NEXT:    subl $16, %esp
; AVX512F-32-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-32-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-32-NEXT:    vmovapd 8(%ebp), %xmm3
; AVX512F-32-NEXT:    vcmple_oqpd %xmm2, %xmm3, %xmm2
; AVX512F-32-NEXT:    vptestmq %zmm2, %zmm2, %k1
; AVX512F-32-NEXT:    vpblendmq %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-32-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-32-NEXT:    movl %ebp, %esp
; AVX512F-32-NEXT:    popl %ebp
; AVX512F-32-NEXT:    vzeroupper
; AVX512F-32-NEXT:    retl
;
; AVX512F-64-LABEL: test_v2f64_oge_q:
; AVX512F-64:       # %bb.0:
; AVX512F-64-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-64-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-64-NEXT:    vcmple_oqpd %xmm2, %xmm3, %xmm2
; AVX512F-64-NEXT:    vptestmq %zmm2, %zmm2, %k1
; AVX512F-64-NEXT:    vpblendmq %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-64-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-64-NEXT:    vzeroupper
; AVX512F-64-NEXT:    retq
  %cond = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f64(
                                               <2 x double> %f1, <2 x double> %f2, metadata !"oge",
                                               metadata !"fpexcept.strict") #0
  %res = select <2 x i1> %cond, <2 x i64> %a, <2 x i64> %b
  ret <2 x i64> %res
}

define <2 x i64> @test_v2f64_olt_q(<2 x i64> %a, <2 x i64> %b, <2 x double> %f1, <2 x double> %f2) #0 {
; SSE-32-LABEL: test_v2f64_olt_q:
; SSE-32:       # %bb.0:
; SSE-32-NEXT:    pushl %ebp
; SSE-32-NEXT:    movl %esp, %ebp
; SSE-32-NEXT:    andl $-16, %esp
; SSE-32-NEXT:    subl $16, %esp
; SSE-32-NEXT:    movapd 8(%ebp), %xmm3
; SSE-32-NEXT:    xorl %eax, %eax
; SSE-32-NEXT:    ucomisd %xmm2, %xmm3
; SSE-32-NEXT:    movl $-1, %ecx
; SSE-32-NEXT:    movl $0, %edx
; SSE-32-NEXT:    cmoval %ecx, %edx
; SSE-32-NEXT:    movd %edx, %xmm4
; SSE-32-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[0,0,1,1]
; SSE-32-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1,1]
; SSE-32-NEXT:    unpckhpd {{.*#+}} xmm3 = xmm3[1,1]
; SSE-32-NEXT:    ucomisd %xmm2, %xmm3
; SSE-32-NEXT:    cmoval %ecx, %eax
; SSE-32-NEXT:    movd %eax, %xmm2
; SSE-32-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,0,1,1]
; SSE-32-NEXT:    punpcklqdq {{.*#+}} xmm4 = xmm4[0],xmm2[0]
; SSE-32-NEXT:    pand %xmm4, %xmm0
; SSE-32-NEXT:    pandn %xmm1, %xmm4
; SSE-32-NEXT:    por %xmm4, %xmm0
; SSE-32-NEXT:    movl %ebp, %esp
; SSE-32-NEXT:    popl %ebp
; SSE-32-NEXT:    retl
;
; SSE-64-LABEL: test_v2f64_olt_q:
; SSE-64:       # %bb.0:
; SSE-64-NEXT:    xorl %eax, %eax
; SSE-64-NEXT:    ucomisd %xmm2, %xmm3
; SSE-64-NEXT:    movq $-1, %rcx
; SSE-64-NEXT:    movl $0, %edx
; SSE-64-NEXT:    cmovaq %rcx, %rdx
; SSE-64-NEXT:    movq %rdx, %xmm4
; SSE-64-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1,1]
; SSE-64-NEXT:    unpckhpd {{.*#+}} xmm3 = xmm3[1,1]
; SSE-64-NEXT:    ucomisd %xmm2, %xmm3
; SSE-64-NEXT:    cmovaq %rcx, %rax
; SSE-64-NEXT:    movq %rax, %xmm2
; SSE-64-NEXT:    punpcklqdq {{.*#+}} xmm4 = xmm4[0],xmm2[0]
; SSE-64-NEXT:    pand %xmm4, %xmm0
; SSE-64-NEXT:    pandn %xmm1, %xmm4
; SSE-64-NEXT:    por %xmm4, %xmm0
; SSE-64-NEXT:    retq
;
; AVX-32-LABEL: test_v2f64_olt_q:
; AVX-32:       # %bb.0:
; AVX-32-NEXT:    pushl %ebp
; AVX-32-NEXT:    movl %esp, %ebp
; AVX-32-NEXT:    andl $-16, %esp
; AVX-32-NEXT:    subl $16, %esp
; AVX-32-NEXT:    vcmplt_oqpd 8(%ebp), %xmm2, %xmm2
; AVX-32-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; AVX-32-NEXT:    movl %ebp, %esp
; AVX-32-NEXT:    popl %ebp
; AVX-32-NEXT:    retl
;
; AVX-64-LABEL: test_v2f64_olt_q:
; AVX-64:       # %bb.0:
; AVX-64-NEXT:    vcmplt_oqpd %xmm3, %xmm2, %xmm2
; AVX-64-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; AVX-64-NEXT:    retq
;
; AVX512-32-LABEL: test_v2f64_olt_q:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-16, %esp
; AVX512-32-NEXT:    subl $16, %esp
; AVX512-32-NEXT:    vcmplt_oqpd 8(%ebp), %xmm2, %k1
; AVX512-32-NEXT:    vpblendmq %xmm0, %xmm1, %xmm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v2f64_olt_q:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmplt_oqpd %xmm3, %xmm2, %k1
; AVX512-64-NEXT:    vpblendmq %xmm0, %xmm1, %xmm0 {%k1}
; AVX512-64-NEXT:    retq
;
; AVX512F-32-LABEL: test_v2f64_olt_q:
; AVX512F-32:       # %bb.0:
; AVX512F-32-NEXT:    pushl %ebp
; AVX512F-32-NEXT:    movl %esp, %ebp
; AVX512F-32-NEXT:    andl $-16, %esp
; AVX512F-32-NEXT:    subl $16, %esp
; AVX512F-32-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-32-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-32-NEXT:    vcmplt_oqpd 8(%ebp), %xmm2, %xmm2
; AVX512F-32-NEXT:    vptestmq %zmm2, %zmm2, %k1
; AVX512F-32-NEXT:    vpblendmq %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-32-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-32-NEXT:    movl %ebp, %esp
; AVX512F-32-NEXT:    popl %ebp
; AVX512F-32-NEXT:    vzeroupper
; AVX512F-32-NEXT:    retl
;
; AVX512F-64-LABEL: test_v2f64_olt_q:
; AVX512F-64:       # %bb.0:
; AVX512F-64-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-64-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-64-NEXT:    vcmplt_oqpd %xmm3, %xmm2, %xmm2
; AVX512F-64-NEXT:    vptestmq %zmm2, %zmm2, %k1
; AVX512F-64-NEXT:    vpblendmq %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-64-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-64-NEXT:    vzeroupper
; AVX512F-64-NEXT:    retq
  %cond = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f64(
                                               <2 x double> %f1, <2 x double> %f2, metadata !"olt",
                                               metadata !"fpexcept.strict") #0
  %res = select <2 x i1> %cond, <2 x i64> %a, <2 x i64> %b
  ret <2 x i64> %res
}

define <2 x i64> @test_v2f64_ole_q(<2 x i64> %a, <2 x i64> %b, <2 x double> %f1, <2 x double> %f2) #0 {
; SSE-32-LABEL: test_v2f64_ole_q:
; SSE-32:       # %bb.0:
; SSE-32-NEXT:    pushl %ebp
; SSE-32-NEXT:    movl %esp, %ebp
; SSE-32-NEXT:    andl $-16, %esp
; SSE-32-NEXT:    subl $16, %esp
; SSE-32-NEXT:    movapd 8(%ebp), %xmm3
; SSE-32-NEXT:    xorl %eax, %eax
; SSE-32-NEXT:    ucomisd %xmm2, %xmm3
; SSE-32-NEXT:    movl $-1, %ecx
; SSE-32-NEXT:    movl $0, %edx
; SSE-32-NEXT:    cmovael %ecx, %edx
; SSE-32-NEXT:    movd %edx, %xmm4
; SSE-32-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[0,0,1,1]
; SSE-32-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1,1]
; SSE-32-NEXT:    unpckhpd {{.*#+}} xmm3 = xmm3[1,1]
; SSE-32-NEXT:    ucomisd %xmm2, %xmm3
; SSE-32-NEXT:    cmovael %ecx, %eax
; SSE-32-NEXT:    movd %eax, %xmm2
; SSE-32-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,0,1,1]
; SSE-32-NEXT:    punpcklqdq {{.*#+}} xmm4 = xmm4[0],xmm2[0]
; SSE-32-NEXT:    pand %xmm4, %xmm0
; SSE-32-NEXT:    pandn %xmm1, %xmm4
; SSE-32-NEXT:    por %xmm4, %xmm0
; SSE-32-NEXT:    movl %ebp, %esp
; SSE-32-NEXT:    popl %ebp
; SSE-32-NEXT:    retl
;
; SSE-64-LABEL: test_v2f64_ole_q:
; SSE-64:       # %bb.0:
; SSE-64-NEXT:    xorl %eax, %eax
; SSE-64-NEXT:    ucomisd %xmm2, %xmm3
; SSE-64-NEXT:    movq $-1, %rcx
; SSE-64-NEXT:    movl $0, %edx
; SSE-64-NEXT:    cmovaeq %rcx, %rdx
; SSE-64-NEXT:    movq %rdx, %xmm4
; SSE-64-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1,1]
; SSE-64-NEXT:    unpckhpd {{.*#+}} xmm3 = xmm3[1,1]
; SSE-64-NEXT:    ucomisd %xmm2, %xmm3
; SSE-64-NEXT:    cmovaeq %rcx, %rax
; SSE-64-NEXT:    movq %rax, %xmm2
; SSE-64-NEXT:    punpcklqdq {{.*#+}} xmm4 = xmm4[0],xmm2[0]
; SSE-64-NEXT:    pand %xmm4, %xmm0
; SSE-64-NEXT:    pandn %xmm1, %xmm4
; SSE-64-NEXT:    por %xmm4, %xmm0
; SSE-64-NEXT:    retq
;
; AVX-32-LABEL: test_v2f64_ole_q:
; AVX-32:       # %bb.0:
; AVX-32-NEXT:    pushl %ebp
; AVX-32-NEXT:    movl %esp, %ebp
; AVX-32-NEXT:    andl $-16, %esp
; AVX-32-NEXT:    subl $16, %esp
; AVX-32-NEXT:    vcmple_oqpd 8(%ebp), %xmm2, %xmm2
; AVX-32-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; AVX-32-NEXT:    movl %ebp, %esp
; AVX-32-NEXT:    popl %ebp
; AVX-32-NEXT:    retl
;
; AVX-64-LABEL: test_v2f64_ole_q:
; AVX-64:       # %bb.0:
; AVX-64-NEXT:    vcmple_oqpd %xmm3, %xmm2, %xmm2
; AVX-64-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; AVX-64-NEXT:    retq
;
; AVX512-32-LABEL: test_v2f64_ole_q:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-16, %esp
; AVX512-32-NEXT:    subl $16, %esp
; AVX512-32-NEXT:    vcmple_oqpd 8(%ebp), %xmm2, %k1
; AVX512-32-NEXT:    vpblendmq %xmm0, %xmm1, %xmm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v2f64_ole_q:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmple_oqpd %xmm3, %xmm2, %k1
; AVX512-64-NEXT:    vpblendmq %xmm0, %xmm1, %xmm0 {%k1}
; AVX512-64-NEXT:    retq
;
; AVX512F-32-LABEL: test_v2f64_ole_q:
; AVX512F-32:       # %bb.0:
; AVX512F-32-NEXT:    pushl %ebp
; AVX512F-32-NEXT:    movl %esp, %ebp
; AVX512F-32-NEXT:    andl $-16, %esp
; AVX512F-32-NEXT:    subl $16, %esp
; AVX512F-32-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-32-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-32-NEXT:    vcmple_oqpd 8(%ebp), %xmm2, %xmm2
; AVX512F-32-NEXT:    vptestmq %zmm2, %zmm2, %k1
; AVX512F-32-NEXT:    vpblendmq %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-32-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-32-NEXT:    movl %ebp, %esp
; AVX512F-32-NEXT:    popl %ebp
; AVX512F-32-NEXT:    vzeroupper
; AVX512F-32-NEXT:    retl
;
; AVX512F-64-LABEL: test_v2f64_ole_q:
; AVX512F-64:       # %bb.0:
; AVX512F-64-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-64-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-64-NEXT:    vcmple_oqpd %xmm3, %xmm2, %xmm2
; AVX512F-64-NEXT:    vptestmq %zmm2, %zmm2, %k1
; AVX512F-64-NEXT:    vpblendmq %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-64-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-64-NEXT:    vzeroupper
; AVX512F-64-NEXT:    retq
  %cond = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f64(
                                               <2 x double> %f1, <2 x double> %f2, metadata !"ole",
                                               metadata !"fpexcept.strict") #0
  %res = select <2 x i1> %cond, <2 x i64> %a, <2 x i64> %b
  ret <2 x i64> %res
}

define <2 x i64> @test_v2f64_one_q(<2 x i64> %a, <2 x i64> %b, <2 x double> %f1, <2 x double> %f2) #0 {
; SSE-32-LABEL: test_v2f64_one_q:
; SSE-32:       # %bb.0:
; SSE-32-NEXT:    pushl %ebp
; SSE-32-NEXT:    movl %esp, %ebp
; SSE-32-NEXT:    andl $-16, %esp
; SSE-32-NEXT:    subl $16, %esp
; SSE-32-NEXT:    movapd 8(%ebp), %xmm3
; SSE-32-NEXT:    movapd %xmm2, %xmm4
; SSE-32-NEXT:    cmpneqpd %xmm3, %xmm4
; SSE-32-NEXT:    cmpordpd %xmm3, %xmm2
; SSE-32-NEXT:    andpd %xmm4, %xmm2
; SSE-32-NEXT:    andpd %xmm2, %xmm0
; SSE-32-NEXT:    andnpd %xmm1, %xmm2
; SSE-32-NEXT:    orpd %xmm2, %xmm0
; SSE-32-NEXT:    movl %ebp, %esp
; SSE-32-NEXT:    popl %ebp
; SSE-32-NEXT:    retl
;
; SSE-64-LABEL: test_v2f64_one_q:
; SSE-64:       # %bb.0:
; SSE-64-NEXT:    movapd %xmm2, %xmm4
; SSE-64-NEXT:    cmpneqpd %xmm3, %xmm4
; SSE-64-NEXT:    cmpordpd %xmm3, %xmm2
; SSE-64-NEXT:    andpd %xmm4, %xmm2
; SSE-64-NEXT:    andpd %xmm2, %xmm0
; SSE-64-NEXT:    andnpd %xmm1, %xmm2
; SSE-64-NEXT:    orpd %xmm2, %xmm0
; SSE-64-NEXT:    retq
;
; AVX-32-LABEL: test_v2f64_one_q:
; AVX-32:       # %bb.0:
; AVX-32-NEXT:    pushl %ebp
; AVX-32-NEXT:    movl %esp, %ebp
; AVX-32-NEXT:    andl $-16, %esp
; AVX-32-NEXT:    subl $16, %esp
; AVX-32-NEXT:    vcmpneq_oqpd 8(%ebp), %xmm2, %xmm2
; AVX-32-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; AVX-32-NEXT:    movl %ebp, %esp
; AVX-32-NEXT:    popl %ebp
; AVX-32-NEXT:    retl
;
; AVX-64-LABEL: test_v2f64_one_q:
; AVX-64:       # %bb.0:
; AVX-64-NEXT:    vcmpneq_oqpd %xmm3, %xmm2, %xmm2
; AVX-64-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; AVX-64-NEXT:    retq
;
; AVX512-32-LABEL: test_v2f64_one_q:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-16, %esp
; AVX512-32-NEXT:    subl $16, %esp
; AVX512-32-NEXT:    vcmpneq_oqpd 8(%ebp), %xmm2, %k1
; AVX512-32-NEXT:    vpblendmq %xmm0, %xmm1, %xmm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v2f64_one_q:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmpneq_oqpd %xmm3, %xmm2, %k1
; AVX512-64-NEXT:    vpblendmq %xmm0, %xmm1, %xmm0 {%k1}
; AVX512-64-NEXT:    retq
;
; AVX512F-32-LABEL: test_v2f64_one_q:
; AVX512F-32:       # %bb.0:
; AVX512F-32-NEXT:    pushl %ebp
; AVX512F-32-NEXT:    movl %esp, %ebp
; AVX512F-32-NEXT:    andl $-16, %esp
; AVX512F-32-NEXT:    subl $16, %esp
; AVX512F-32-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-32-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-32-NEXT:    vcmpneq_oqpd 8(%ebp), %xmm2, %xmm2
; AVX512F-32-NEXT:    vptestmq %zmm2, %zmm2, %k1
; AVX512F-32-NEXT:    vpblendmq %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-32-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-32-NEXT:    movl %ebp, %esp
; AVX512F-32-NEXT:    popl %ebp
; AVX512F-32-NEXT:    vzeroupper
; AVX512F-32-NEXT:    retl
;
; AVX512F-64-LABEL: test_v2f64_one_q:
; AVX512F-64:       # %bb.0:
; AVX512F-64-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-64-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-64-NEXT:    vcmpneq_oqpd %xmm3, %xmm2, %xmm2
; AVX512F-64-NEXT:    vptestmq %zmm2, %zmm2, %k1
; AVX512F-64-NEXT:    vpblendmq %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-64-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-64-NEXT:    vzeroupper
; AVX512F-64-NEXT:    retq
  %cond = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f64(
                                               <2 x double> %f1, <2 x double> %f2, metadata !"one",
                                               metadata !"fpexcept.strict") #0
  %res = select <2 x i1> %cond, <2 x i64> %a, <2 x i64> %b
  ret <2 x i64> %res
}

define <2 x i64> @test_v2f64_ord_q(<2 x i64> %a, <2 x i64> %b, <2 x double> %f1, <2 x double> %f2) #0 {
; SSE-32-LABEL: test_v2f64_ord_q:
; SSE-32:       # %bb.0:
; SSE-32-NEXT:    pushl %ebp
; SSE-32-NEXT:    movl %esp, %ebp
; SSE-32-NEXT:    andl $-16, %esp
; SSE-32-NEXT:    subl $16, %esp
; SSE-32-NEXT:    cmpordpd 8(%ebp), %xmm2
; SSE-32-NEXT:    andpd %xmm2, %xmm0
; SSE-32-NEXT:    andnpd %xmm1, %xmm2
; SSE-32-NEXT:    orpd %xmm2, %xmm0
; SSE-32-NEXT:    movl %ebp, %esp
; SSE-32-NEXT:    popl %ebp
; SSE-32-NEXT:    retl
;
; SSE-64-LABEL: test_v2f64_ord_q:
; SSE-64:       # %bb.0:
; SSE-64-NEXT:    cmpordpd %xmm3, %xmm2
; SSE-64-NEXT:    andpd %xmm2, %xmm0
; SSE-64-NEXT:    andnpd %xmm1, %xmm2
; SSE-64-NEXT:    orpd %xmm2, %xmm0
; SSE-64-NEXT:    retq
;
; AVX-32-LABEL: test_v2f64_ord_q:
; AVX-32:       # %bb.0:
; AVX-32-NEXT:    pushl %ebp
; AVX-32-NEXT:    movl %esp, %ebp
; AVX-32-NEXT:    andl $-16, %esp
; AVX-32-NEXT:    subl $16, %esp
; AVX-32-NEXT:    vcmpordpd 8(%ebp), %xmm2, %xmm2
; AVX-32-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; AVX-32-NEXT:    movl %ebp, %esp
; AVX-32-NEXT:    popl %ebp
; AVX-32-NEXT:    retl
;
; AVX-64-LABEL: test_v2f64_ord_q:
; AVX-64:       # %bb.0:
; AVX-64-NEXT:    vcmpordpd %xmm3, %xmm2, %xmm2
; AVX-64-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; AVX-64-NEXT:    retq
;
; AVX512-32-LABEL: test_v2f64_ord_q:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-16, %esp
; AVX512-32-NEXT:    subl $16, %esp
; AVX512-32-NEXT:    vcmpordpd 8(%ebp), %xmm2, %k1
; AVX512-32-NEXT:    vpblendmq %xmm0, %xmm1, %xmm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v2f64_ord_q:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmpordpd %xmm3, %xmm2, %k1
; AVX512-64-NEXT:    vpblendmq %xmm0, %xmm1, %xmm0 {%k1}
; AVX512-64-NEXT:    retq
;
; AVX512F-32-LABEL: test_v2f64_ord_q:
; AVX512F-32:       # %bb.0:
; AVX512F-32-NEXT:    pushl %ebp
; AVX512F-32-NEXT:    movl %esp, %ebp
; AVX512F-32-NEXT:    andl $-16, %esp
; AVX512F-32-NEXT:    subl $16, %esp
; AVX512F-32-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-32-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-32-NEXT:    vcmpordpd 8(%ebp), %xmm2, %xmm2
; AVX512F-32-NEXT:    vptestmq %zmm2, %zmm2, %k1
; AVX512F-32-NEXT:    vpblendmq %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-32-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-32-NEXT:    movl %ebp, %esp
; AVX512F-32-NEXT:    popl %ebp
; AVX512F-32-NEXT:    vzeroupper
; AVX512F-32-NEXT:    retl
;
; AVX512F-64-LABEL: test_v2f64_ord_q:
; AVX512F-64:       # %bb.0:
; AVX512F-64-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-64-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-64-NEXT:    vcmpordpd %xmm3, %xmm2, %xmm2
; AVX512F-64-NEXT:    vptestmq %zmm2, %zmm2, %k1
; AVX512F-64-NEXT:    vpblendmq %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-64-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-64-NEXT:    vzeroupper
; AVX512F-64-NEXT:    retq
  %cond = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f64(
                                               <2 x double> %f1, <2 x double> %f2, metadata !"ord",
                                               metadata !"fpexcept.strict") #0
  %res = select <2 x i1> %cond, <2 x i64> %a, <2 x i64> %b
  ret <2 x i64> %res
}

define <2 x i64> @test_v2f64_ueq_q(<2 x i64> %a, <2 x i64> %b, <2 x double> %f1, <2 x double> %f2) #0 {
; SSE-32-LABEL: test_v2f64_ueq_q:
; SSE-32:       # %bb.0:
; SSE-32-NEXT:    pushl %ebp
; SSE-32-NEXT:    movl %esp, %ebp
; SSE-32-NEXT:    andl $-16, %esp
; SSE-32-NEXT:    subl $16, %esp
; SSE-32-NEXT:    movapd 8(%ebp), %xmm3
; SSE-32-NEXT:    movapd %xmm2, %xmm4
; SSE-32-NEXT:    cmpeqpd %xmm3, %xmm4
; SSE-32-NEXT:    cmpunordpd %xmm3, %xmm2
; SSE-32-NEXT:    orpd %xmm4, %xmm2
; SSE-32-NEXT:    andpd %xmm2, %xmm0
; SSE-32-NEXT:    andnpd %xmm1, %xmm2
; SSE-32-NEXT:    orpd %xmm2, %xmm0
; SSE-32-NEXT:    movl %ebp, %esp
; SSE-32-NEXT:    popl %ebp
; SSE-32-NEXT:    retl
;
; SSE-64-LABEL: test_v2f64_ueq_q:
; SSE-64:       # %bb.0:
; SSE-64-NEXT:    movapd %xmm2, %xmm4
; SSE-64-NEXT:    cmpeqpd %xmm3, %xmm4
; SSE-64-NEXT:    cmpunordpd %xmm3, %xmm2
; SSE-64-NEXT:    orpd %xmm4, %xmm2
; SSE-64-NEXT:    andpd %xmm2, %xmm0
; SSE-64-NEXT:    andnpd %xmm1, %xmm2
; SSE-64-NEXT:    orpd %xmm2, %xmm0
; SSE-64-NEXT:    retq
;
; AVX-32-LABEL: test_v2f64_ueq_q:
; AVX-32:       # %bb.0:
; AVX-32-NEXT:    pushl %ebp
; AVX-32-NEXT:    movl %esp, %ebp
; AVX-32-NEXT:    andl $-16, %esp
; AVX-32-NEXT:    subl $16, %esp
; AVX-32-NEXT:    vcmpeq_uqpd 8(%ebp), %xmm2, %xmm2
; AVX-32-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; AVX-32-NEXT:    movl %ebp, %esp
; AVX-32-NEXT:    popl %ebp
; AVX-32-NEXT:    retl
;
; AVX-64-LABEL: test_v2f64_ueq_q:
; AVX-64:       # %bb.0:
; AVX-64-NEXT:    vcmpeq_uqpd %xmm3, %xmm2, %xmm2
; AVX-64-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; AVX-64-NEXT:    retq
;
; AVX512-32-LABEL: test_v2f64_ueq_q:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-16, %esp
; AVX512-32-NEXT:    subl $16, %esp
; AVX512-32-NEXT:    vcmpeq_uqpd 8(%ebp), %xmm2, %k1
; AVX512-32-NEXT:    vpblendmq %xmm0, %xmm1, %xmm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v2f64_ueq_q:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmpeq_uqpd %xmm3, %xmm2, %k1
; AVX512-64-NEXT:    vpblendmq %xmm0, %xmm1, %xmm0 {%k1}
; AVX512-64-NEXT:    retq
;
; AVX512F-32-LABEL: test_v2f64_ueq_q:
; AVX512F-32:       # %bb.0:
; AVX512F-32-NEXT:    pushl %ebp
; AVX512F-32-NEXT:    movl %esp, %ebp
; AVX512F-32-NEXT:    andl $-16, %esp
; AVX512F-32-NEXT:    subl $16, %esp
; AVX512F-32-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-32-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-32-NEXT:    vcmpeq_uqpd 8(%ebp), %xmm2, %xmm2
; AVX512F-32-NEXT:    vptestmq %zmm2, %zmm2, %k1
; AVX512F-32-NEXT:    vpblendmq %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-32-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-32-NEXT:    movl %ebp, %esp
; AVX512F-32-NEXT:    popl %ebp
; AVX512F-32-NEXT:    vzeroupper
; AVX512F-32-NEXT:    retl
;
; AVX512F-64-LABEL: test_v2f64_ueq_q:
; AVX512F-64:       # %bb.0:
; AVX512F-64-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-64-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-64-NEXT:    vcmpeq_uqpd %xmm3, %xmm2, %xmm2
; AVX512F-64-NEXT:    vptestmq %zmm2, %zmm2, %k1
; AVX512F-64-NEXT:    vpblendmq %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-64-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-64-NEXT:    vzeroupper
; AVX512F-64-NEXT:    retq
  %cond = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f64(
                                               <2 x double> %f1, <2 x double> %f2, metadata !"ueq",
                                               metadata !"fpexcept.strict") #0
  %res = select <2 x i1> %cond, <2 x i64> %a, <2 x i64> %b
  ret <2 x i64> %res
}

define <2 x i64> @test_v2f64_ugt_q(<2 x i64> %a, <2 x i64> %b, <2 x double> %f1, <2 x double> %f2) #0 {
; SSE-32-LABEL: test_v2f64_ugt_q:
; SSE-32:       # %bb.0:
; SSE-32-NEXT:    pushl %ebp
; SSE-32-NEXT:    movl %esp, %ebp
; SSE-32-NEXT:    andl $-16, %esp
; SSE-32-NEXT:    subl $16, %esp
; SSE-32-NEXT:    movapd 8(%ebp), %xmm3
; SSE-32-NEXT:    xorl %eax, %eax
; SSE-32-NEXT:    ucomisd %xmm2, %xmm3
; SSE-32-NEXT:    movl $-1, %ecx
; SSE-32-NEXT:    movl $0, %edx
; SSE-32-NEXT:    cmovbl %ecx, %edx
; SSE-32-NEXT:    movd %edx, %xmm4
; SSE-32-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[0,0,1,1]
; SSE-32-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1,1]
; SSE-32-NEXT:    unpckhpd {{.*#+}} xmm3 = xmm3[1,1]
; SSE-32-NEXT:    ucomisd %xmm2, %xmm3
; SSE-32-NEXT:    cmovbl %ecx, %eax
; SSE-32-NEXT:    movd %eax, %xmm2
; SSE-32-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,0,1,1]
; SSE-32-NEXT:    punpcklqdq {{.*#+}} xmm4 = xmm4[0],xmm2[0]
; SSE-32-NEXT:    pand %xmm4, %xmm0
; SSE-32-NEXT:    pandn %xmm1, %xmm4
; SSE-32-NEXT:    por %xmm4, %xmm0
; SSE-32-NEXT:    movl %ebp, %esp
; SSE-32-NEXT:    popl %ebp
; SSE-32-NEXT:    retl
;
; SSE-64-LABEL: test_v2f64_ugt_q:
; SSE-64:       # %bb.0:
; SSE-64-NEXT:    xorl %eax, %eax
; SSE-64-NEXT:    ucomisd %xmm2, %xmm3
; SSE-64-NEXT:    movq $-1, %rcx
; SSE-64-NEXT:    movl $0, %edx
; SSE-64-NEXT:    cmovbq %rcx, %rdx
; SSE-64-NEXT:    movq %rdx, %xmm4
; SSE-64-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1,1]
; SSE-64-NEXT:    unpckhpd {{.*#+}} xmm3 = xmm3[1,1]
; SSE-64-NEXT:    ucomisd %xmm2, %xmm3
; SSE-64-NEXT:    cmovbq %rcx, %rax
; SSE-64-NEXT:    movq %rax, %xmm2
; SSE-64-NEXT:    punpcklqdq {{.*#+}} xmm4 = xmm4[0],xmm2[0]
; SSE-64-NEXT:    pand %xmm4, %xmm0
; SSE-64-NEXT:    pandn %xmm1, %xmm4
; SSE-64-NEXT:    por %xmm4, %xmm0
; SSE-64-NEXT:    retq
;
; AVX-32-LABEL: test_v2f64_ugt_q:
; AVX-32:       # %bb.0:
; AVX-32-NEXT:    pushl %ebp
; AVX-32-NEXT:    movl %esp, %ebp
; AVX-32-NEXT:    andl $-16, %esp
; AVX-32-NEXT:    subl $16, %esp
; AVX-32-NEXT:    vcmpnle_uqpd 8(%ebp), %xmm2, %xmm2
; AVX-32-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; AVX-32-NEXT:    movl %ebp, %esp
; AVX-32-NEXT:    popl %ebp
; AVX-32-NEXT:    retl
;
; AVX-64-LABEL: test_v2f64_ugt_q:
; AVX-64:       # %bb.0:
; AVX-64-NEXT:    vcmpnle_uqpd %xmm3, %xmm2, %xmm2
; AVX-64-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; AVX-64-NEXT:    retq
;
; AVX512-32-LABEL: test_v2f64_ugt_q:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-16, %esp
; AVX512-32-NEXT:    subl $16, %esp
; AVX512-32-NEXT:    vcmpnle_uqpd 8(%ebp), %xmm2, %k1
; AVX512-32-NEXT:    vpblendmq %xmm0, %xmm1, %xmm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v2f64_ugt_q:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmpnle_uqpd %xmm3, %xmm2, %k1
; AVX512-64-NEXT:    vpblendmq %xmm0, %xmm1, %xmm0 {%k1}
; AVX512-64-NEXT:    retq
;
; AVX512F-32-LABEL: test_v2f64_ugt_q:
; AVX512F-32:       # %bb.0:
; AVX512F-32-NEXT:    pushl %ebp
; AVX512F-32-NEXT:    movl %esp, %ebp
; AVX512F-32-NEXT:    andl $-16, %esp
; AVX512F-32-NEXT:    subl $16, %esp
; AVX512F-32-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-32-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-32-NEXT:    vcmpnle_uqpd 8(%ebp), %xmm2, %xmm2
; AVX512F-32-NEXT:    vptestmq %zmm2, %zmm2, %k1
; AVX512F-32-NEXT:    vpblendmq %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-32-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-32-NEXT:    movl %ebp, %esp
; AVX512F-32-NEXT:    popl %ebp
; AVX512F-32-NEXT:    vzeroupper
; AVX512F-32-NEXT:    retl
;
; AVX512F-64-LABEL: test_v2f64_ugt_q:
; AVX512F-64:       # %bb.0:
; AVX512F-64-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-64-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-64-NEXT:    vcmpnle_uqpd %xmm3, %xmm2, %xmm2
; AVX512F-64-NEXT:    vptestmq %zmm2, %zmm2, %k1
; AVX512F-64-NEXT:    vpblendmq %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-64-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-64-NEXT:    vzeroupper
; AVX512F-64-NEXT:    retq
  %cond = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f64(
                                               <2 x double> %f1, <2 x double> %f2, metadata !"ugt",
                                               metadata !"fpexcept.strict") #0
  %res = select <2 x i1> %cond, <2 x i64> %a, <2 x i64> %b
  ret <2 x i64> %res
}

define <2 x i64> @test_v2f64_uge_q(<2 x i64> %a, <2 x i64> %b, <2 x double> %f1, <2 x double> %f2) #0 {
; SSE-32-LABEL: test_v2f64_uge_q:
; SSE-32:       # %bb.0:
; SSE-32-NEXT:    pushl %ebp
; SSE-32-NEXT:    movl %esp, %ebp
; SSE-32-NEXT:    andl $-16, %esp
; SSE-32-NEXT:    subl $16, %esp
; SSE-32-NEXT:    movapd 8(%ebp), %xmm3
; SSE-32-NEXT:    xorl %eax, %eax
; SSE-32-NEXT:    ucomisd %xmm2, %xmm3
; SSE-32-NEXT:    movl $-1, %ecx
; SSE-32-NEXT:    movl $0, %edx
; SSE-32-NEXT:    cmovbel %ecx, %edx
; SSE-32-NEXT:    movd %edx, %xmm4
; SSE-32-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[0,0,1,1]
; SSE-32-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1,1]
; SSE-32-NEXT:    unpckhpd {{.*#+}} xmm3 = xmm3[1,1]
; SSE-32-NEXT:    ucomisd %xmm2, %xmm3
; SSE-32-NEXT:    cmovbel %ecx, %eax
; SSE-32-NEXT:    movd %eax, %xmm2
; SSE-32-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,0,1,1]
; SSE-32-NEXT:    punpcklqdq {{.*#+}} xmm4 = xmm4[0],xmm2[0]
; SSE-32-NEXT:    pand %xmm4, %xmm0
; SSE-32-NEXT:    pandn %xmm1, %xmm4
; SSE-32-NEXT:    por %xmm4, %xmm0
; SSE-32-NEXT:    movl %ebp, %esp
; SSE-32-NEXT:    popl %ebp
; SSE-32-NEXT:    retl
;
; SSE-64-LABEL: test_v2f64_uge_q:
; SSE-64:       # %bb.0:
; SSE-64-NEXT:    xorl %eax, %eax
; SSE-64-NEXT:    ucomisd %xmm2, %xmm3
; SSE-64-NEXT:    movq $-1, %rcx
; SSE-64-NEXT:    movl $0, %edx
; SSE-64-NEXT:    cmovbeq %rcx, %rdx
; SSE-64-NEXT:    movq %rdx, %xmm4
; SSE-64-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1,1]
; SSE-64-NEXT:    unpckhpd {{.*#+}} xmm3 = xmm3[1,1]
; SSE-64-NEXT:    ucomisd %xmm2, %xmm3
; SSE-64-NEXT:    cmovbeq %rcx, %rax
; SSE-64-NEXT:    movq %rax, %xmm2
; SSE-64-NEXT:    punpcklqdq {{.*#+}} xmm4 = xmm4[0],xmm2[0]
; SSE-64-NEXT:    pand %xmm4, %xmm0
; SSE-64-NEXT:    pandn %xmm1, %xmm4
; SSE-64-NEXT:    por %xmm4, %xmm0
; SSE-64-NEXT:    retq
;
; AVX-32-LABEL: test_v2f64_uge_q:
; AVX-32:       # %bb.0:
; AVX-32-NEXT:    pushl %ebp
; AVX-32-NEXT:    movl %esp, %ebp
; AVX-32-NEXT:    andl $-16, %esp
; AVX-32-NEXT:    subl $16, %esp
; AVX-32-NEXT:    vcmpnlt_uqpd 8(%ebp), %xmm2, %xmm2
; AVX-32-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; AVX-32-NEXT:    movl %ebp, %esp
; AVX-32-NEXT:    popl %ebp
; AVX-32-NEXT:    retl
;
; AVX-64-LABEL: test_v2f64_uge_q:
; AVX-64:       # %bb.0:
; AVX-64-NEXT:    vcmpnlt_uqpd %xmm3, %xmm2, %xmm2
; AVX-64-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; AVX-64-NEXT:    retq
;
; AVX512-32-LABEL: test_v2f64_uge_q:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-16, %esp
; AVX512-32-NEXT:    subl $16, %esp
; AVX512-32-NEXT:    vcmpnlt_uqpd 8(%ebp), %xmm2, %k1
; AVX512-32-NEXT:    vpblendmq %xmm0, %xmm1, %xmm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v2f64_uge_q:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmpnlt_uqpd %xmm3, %xmm2, %k1
; AVX512-64-NEXT:    vpblendmq %xmm0, %xmm1, %xmm0 {%k1}
; AVX512-64-NEXT:    retq
;
; AVX512F-32-LABEL: test_v2f64_uge_q:
; AVX512F-32:       # %bb.0:
; AVX512F-32-NEXT:    pushl %ebp
; AVX512F-32-NEXT:    movl %esp, %ebp
; AVX512F-32-NEXT:    andl $-16, %esp
; AVX512F-32-NEXT:    subl $16, %esp
; AVX512F-32-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-32-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-32-NEXT:    vcmpnlt_uqpd 8(%ebp), %xmm2, %xmm2
; AVX512F-32-NEXT:    vptestmq %zmm2, %zmm2, %k1
; AVX512F-32-NEXT:    vpblendmq %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-32-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-32-NEXT:    movl %ebp, %esp
; AVX512F-32-NEXT:    popl %ebp
; AVX512F-32-NEXT:    vzeroupper
; AVX512F-32-NEXT:    retl
;
; AVX512F-64-LABEL: test_v2f64_uge_q:
; AVX512F-64:       # %bb.0:
; AVX512F-64-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-64-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-64-NEXT:    vcmpnlt_uqpd %xmm3, %xmm2, %xmm2
; AVX512F-64-NEXT:    vptestmq %zmm2, %zmm2, %k1
; AVX512F-64-NEXT:    vpblendmq %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-64-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-64-NEXT:    vzeroupper
; AVX512F-64-NEXT:    retq
  %cond = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f64(
                                               <2 x double> %f1, <2 x double> %f2, metadata !"uge",
                                               metadata !"fpexcept.strict") #0
  %res = select <2 x i1> %cond, <2 x i64> %a, <2 x i64> %b
  ret <2 x i64> %res
}

define <2 x i64> @test_v2f64_ult_q(<2 x i64> %a, <2 x i64> %b, <2 x double> %f1, <2 x double> %f2) #0 {
; SSE-32-LABEL: test_v2f64_ult_q:
; SSE-32:       # %bb.0:
; SSE-32-NEXT:    pushl %ebp
; SSE-32-NEXT:    movl %esp, %ebp
; SSE-32-NEXT:    andl $-16, %esp
; SSE-32-NEXT:    subl $16, %esp
; SSE-32-NEXT:    movapd 8(%ebp), %xmm3
; SSE-32-NEXT:    xorl %eax, %eax
; SSE-32-NEXT:    ucomisd %xmm3, %xmm2
; SSE-32-NEXT:    movl $-1, %ecx
; SSE-32-NEXT:    movl $0, %edx
; SSE-32-NEXT:    cmovbl %ecx, %edx
; SSE-32-NEXT:    movd %edx, %xmm4
; SSE-32-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[0,0,1,1]
; SSE-32-NEXT:    unpckhpd {{.*#+}} xmm3 = xmm3[1,1]
; SSE-32-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1,1]
; SSE-32-NEXT:    ucomisd %xmm3, %xmm2
; SSE-32-NEXT:    cmovbl %ecx, %eax
; SSE-32-NEXT:    movd %eax, %xmm2
; SSE-32-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,0,1,1]
; SSE-32-NEXT:    punpcklqdq {{.*#+}} xmm4 = xmm4[0],xmm2[0]
; SSE-32-NEXT:    pand %xmm4, %xmm0
; SSE-32-NEXT:    pandn %xmm1, %xmm4
; SSE-32-NEXT:    por %xmm4, %xmm0
; SSE-32-NEXT:    movl %ebp, %esp
; SSE-32-NEXT:    popl %ebp
; SSE-32-NEXT:    retl
;
; SSE-64-LABEL: test_v2f64_ult_q:
; SSE-64:       # %bb.0:
; SSE-64-NEXT:    xorl %eax, %eax
; SSE-64-NEXT:    ucomisd %xmm3, %xmm2
; SSE-64-NEXT:    movq $-1, %rcx
; SSE-64-NEXT:    movl $0, %edx
; SSE-64-NEXT:    cmovbq %rcx, %rdx
; SSE-64-NEXT:    movq %rdx, %xmm4
; SSE-64-NEXT:    unpckhpd {{.*#+}} xmm3 = xmm3[1,1]
; SSE-64-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1,1]
; SSE-64-NEXT:    ucomisd %xmm3, %xmm2
; SSE-64-NEXT:    cmovbq %rcx, %rax
; SSE-64-NEXT:    movq %rax, %xmm2
; SSE-64-NEXT:    punpcklqdq {{.*#+}} xmm4 = xmm4[0],xmm2[0]
; SSE-64-NEXT:    pand %xmm4, %xmm0
; SSE-64-NEXT:    pandn %xmm1, %xmm4
; SSE-64-NEXT:    por %xmm4, %xmm0
; SSE-64-NEXT:    retq
;
; AVX-32-LABEL: test_v2f64_ult_q:
; AVX-32:       # %bb.0:
; AVX-32-NEXT:    pushl %ebp
; AVX-32-NEXT:    movl %esp, %ebp
; AVX-32-NEXT:    andl $-16, %esp
; AVX-32-NEXT:    subl $16, %esp
; AVX-32-NEXT:    vmovapd 8(%ebp), %xmm3
; AVX-32-NEXT:    vcmpnle_uqpd %xmm2, %xmm3, %xmm2
; AVX-32-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; AVX-32-NEXT:    movl %ebp, %esp
; AVX-32-NEXT:    popl %ebp
; AVX-32-NEXT:    retl
;
; AVX-64-LABEL: test_v2f64_ult_q:
; AVX-64:       # %bb.0:
; AVX-64-NEXT:    vcmpnle_uqpd %xmm2, %xmm3, %xmm2
; AVX-64-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; AVX-64-NEXT:    retq
;
; AVX512-32-LABEL: test_v2f64_ult_q:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-16, %esp
; AVX512-32-NEXT:    subl $16, %esp
; AVX512-32-NEXT:    vcmpnge_uqpd 8(%ebp), %xmm2, %k1
; AVX512-32-NEXT:    vpblendmq %xmm0, %xmm1, %xmm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v2f64_ult_q:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmpnle_uqpd %xmm2, %xmm3, %k1
; AVX512-64-NEXT:    vpblendmq %xmm0, %xmm1, %xmm0 {%k1}
; AVX512-64-NEXT:    retq
;
; AVX512F-32-LABEL: test_v2f64_ult_q:
; AVX512F-32:       # %bb.0:
; AVX512F-32-NEXT:    pushl %ebp
; AVX512F-32-NEXT:    movl %esp, %ebp
; AVX512F-32-NEXT:    andl $-16, %esp
; AVX512F-32-NEXT:    subl $16, %esp
; AVX512F-32-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-32-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-32-NEXT:    vmovapd 8(%ebp), %xmm3
; AVX512F-32-NEXT:    vcmpnle_uqpd %xmm2, %xmm3, %xmm2
; AVX512F-32-NEXT:    vptestmq %zmm2, %zmm2, %k1
; AVX512F-32-NEXT:    vpblendmq %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-32-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-32-NEXT:    movl %ebp, %esp
; AVX512F-32-NEXT:    popl %ebp
; AVX512F-32-NEXT:    vzeroupper
; AVX512F-32-NEXT:    retl
;
; AVX512F-64-LABEL: test_v2f64_ult_q:
; AVX512F-64:       # %bb.0:
; AVX512F-64-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-64-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-64-NEXT:    vcmpnle_uqpd %xmm2, %xmm3, %xmm2
; AVX512F-64-NEXT:    vptestmq %zmm2, %zmm2, %k1
; AVX512F-64-NEXT:    vpblendmq %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-64-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-64-NEXT:    vzeroupper
; AVX512F-64-NEXT:    retq
  %cond = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f64(
                                               <2 x double> %f1, <2 x double> %f2, metadata !"ult",
                                               metadata !"fpexcept.strict") #0
  %res = select <2 x i1> %cond, <2 x i64> %a, <2 x i64> %b
  ret <2 x i64> %res
}

define <2 x i64> @test_v2f64_ule_q(<2 x i64> %a, <2 x i64> %b, <2 x double> %f1, <2 x double> %f2) #0 {
; SSE-32-LABEL: test_v2f64_ule_q:
; SSE-32:       # %bb.0:
; SSE-32-NEXT:    pushl %ebp
; SSE-32-NEXT:    movl %esp, %ebp
; SSE-32-NEXT:    andl $-16, %esp
; SSE-32-NEXT:    subl $16, %esp
; SSE-32-NEXT:    movapd 8(%ebp), %xmm3
; SSE-32-NEXT:    xorl %eax, %eax
; SSE-32-NEXT:    ucomisd %xmm3, %xmm2
; SSE-32-NEXT:    movl $-1, %ecx
; SSE-32-NEXT:    movl $0, %edx
; SSE-32-NEXT:    cmovbel %ecx, %edx
; SSE-32-NEXT:    movd %edx, %xmm4
; SSE-32-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[0,0,1,1]
; SSE-32-NEXT:    unpckhpd {{.*#+}} xmm3 = xmm3[1,1]
; SSE-32-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1,1]
; SSE-32-NEXT:    ucomisd %xmm3, %xmm2
; SSE-32-NEXT:    cmovbel %ecx, %eax
; SSE-32-NEXT:    movd %eax, %xmm2
; SSE-32-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,0,1,1]
; SSE-32-NEXT:    punpcklqdq {{.*#+}} xmm4 = xmm4[0],xmm2[0]
; SSE-32-NEXT:    pand %xmm4, %xmm0
; SSE-32-NEXT:    pandn %xmm1, %xmm4
; SSE-32-NEXT:    por %xmm4, %xmm0
; SSE-32-NEXT:    movl %ebp, %esp
; SSE-32-NEXT:    popl %ebp
; SSE-32-NEXT:    retl
;
; SSE-64-LABEL: test_v2f64_ule_q:
; SSE-64:       # %bb.0:
; SSE-64-NEXT:    xorl %eax, %eax
; SSE-64-NEXT:    ucomisd %xmm3, %xmm2
; SSE-64-NEXT:    movq $-1, %rcx
; SSE-64-NEXT:    movl $0, %edx
; SSE-64-NEXT:    cmovbeq %rcx, %rdx
; SSE-64-NEXT:    movq %rdx, %xmm4
; SSE-64-NEXT:    unpckhpd {{.*#+}} xmm3 = xmm3[1,1]
; SSE-64-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1,1]
; SSE-64-NEXT:    ucomisd %xmm3, %xmm2
; SSE-64-NEXT:    cmovbeq %rcx, %rax
; SSE-64-NEXT:    movq %rax, %xmm2
; SSE-64-NEXT:    punpcklqdq {{.*#+}} xmm4 = xmm4[0],xmm2[0]
; SSE-64-NEXT:    pand %xmm4, %xmm0
; SSE-64-NEXT:    pandn %xmm1, %xmm4
; SSE-64-NEXT:    por %xmm4, %xmm0
; SSE-64-NEXT:    retq
;
; AVX-32-LABEL: test_v2f64_ule_q:
; AVX-32:       # %bb.0:
; AVX-32-NEXT:    pushl %ebp
; AVX-32-NEXT:    movl %esp, %ebp
; AVX-32-NEXT:    andl $-16, %esp
; AVX-32-NEXT:    subl $16, %esp
; AVX-32-NEXT:    vmovapd 8(%ebp), %xmm3
; AVX-32-NEXT:    vcmpnlt_uqpd %xmm2, %xmm3, %xmm2
; AVX-32-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; AVX-32-NEXT:    movl %ebp, %esp
; AVX-32-NEXT:    popl %ebp
; AVX-32-NEXT:    retl
;
; AVX-64-LABEL: test_v2f64_ule_q:
; AVX-64:       # %bb.0:
; AVX-64-NEXT:    vcmpnlt_uqpd %xmm2, %xmm3, %xmm2
; AVX-64-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; AVX-64-NEXT:    retq
;
; AVX512-32-LABEL: test_v2f64_ule_q:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-16, %esp
; AVX512-32-NEXT:    subl $16, %esp
; AVX512-32-NEXT:    vcmpngt_uqpd 8(%ebp), %xmm2, %k1
; AVX512-32-NEXT:    vpblendmq %xmm0, %xmm1, %xmm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v2f64_ule_q:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmpnlt_uqpd %xmm2, %xmm3, %k1
; AVX512-64-NEXT:    vpblendmq %xmm0, %xmm1, %xmm0 {%k1}
; AVX512-64-NEXT:    retq
;
; AVX512F-32-LABEL: test_v2f64_ule_q:
; AVX512F-32:       # %bb.0:
; AVX512F-32-NEXT:    pushl %ebp
; AVX512F-32-NEXT:    movl %esp, %ebp
; AVX512F-32-NEXT:    andl $-16, %esp
; AVX512F-32-NEXT:    subl $16, %esp
; AVX512F-32-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-32-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-32-NEXT:    vmovapd 8(%ebp), %xmm3
; AVX512F-32-NEXT:    vcmpnlt_uqpd %xmm2, %xmm3, %xmm2
; AVX512F-32-NEXT:    vptestmq %zmm2, %zmm2, %k1
; AVX512F-32-NEXT:    vpblendmq %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-32-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-32-NEXT:    movl %ebp, %esp
; AVX512F-32-NEXT:    popl %ebp
; AVX512F-32-NEXT:    vzeroupper
; AVX512F-32-NEXT:    retl
;
; AVX512F-64-LABEL: test_v2f64_ule_q:
; AVX512F-64:       # %bb.0:
; AVX512F-64-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-64-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-64-NEXT:    vcmpnlt_uqpd %xmm2, %xmm3, %xmm2
; AVX512F-64-NEXT:    vptestmq %zmm2, %zmm2, %k1
; AVX512F-64-NEXT:    vpblendmq %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-64-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-64-NEXT:    vzeroupper
; AVX512F-64-NEXT:    retq
  %cond = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f64(
                                               <2 x double> %f1, <2 x double> %f2, metadata !"ule",
                                               metadata !"fpexcept.strict") #0
  %res = select <2 x i1> %cond, <2 x i64> %a, <2 x i64> %b
  ret <2 x i64> %res
}

define <2 x i64> @test_v2f64_une_q(<2 x i64> %a, <2 x i64> %b, <2 x double> %f1, <2 x double> %f2) #0 {
; SSE-32-LABEL: test_v2f64_une_q:
; SSE-32:       # %bb.0:
; SSE-32-NEXT:    pushl %ebp
; SSE-32-NEXT:    movl %esp, %ebp
; SSE-32-NEXT:    andl $-16, %esp
; SSE-32-NEXT:    subl $16, %esp
; SSE-32-NEXT:    cmpneqpd 8(%ebp), %xmm2
; SSE-32-NEXT:    andpd %xmm2, %xmm0
; SSE-32-NEXT:    andnpd %xmm1, %xmm2
; SSE-32-NEXT:    orpd %xmm2, %xmm0
; SSE-32-NEXT:    movl %ebp, %esp
; SSE-32-NEXT:    popl %ebp
; SSE-32-NEXT:    retl
;
; SSE-64-LABEL: test_v2f64_une_q:
; SSE-64:       # %bb.0:
; SSE-64-NEXT:    cmpneqpd %xmm3, %xmm2
; SSE-64-NEXT:    andpd %xmm2, %xmm0
; SSE-64-NEXT:    andnpd %xmm1, %xmm2
; SSE-64-NEXT:    orpd %xmm2, %xmm0
; SSE-64-NEXT:    retq
;
; AVX-32-LABEL: test_v2f64_une_q:
; AVX-32:       # %bb.0:
; AVX-32-NEXT:    pushl %ebp
; AVX-32-NEXT:    movl %esp, %ebp
; AVX-32-NEXT:    andl $-16, %esp
; AVX-32-NEXT:    subl $16, %esp
; AVX-32-NEXT:    vcmpneqpd 8(%ebp), %xmm2, %xmm2
; AVX-32-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; AVX-32-NEXT:    movl %ebp, %esp
; AVX-32-NEXT:    popl %ebp
; AVX-32-NEXT:    retl
;
; AVX-64-LABEL: test_v2f64_une_q:
; AVX-64:       # %bb.0:
; AVX-64-NEXT:    vcmpneqpd %xmm3, %xmm2, %xmm2
; AVX-64-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; AVX-64-NEXT:    retq
;
; AVX512-32-LABEL: test_v2f64_une_q:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-16, %esp
; AVX512-32-NEXT:    subl $16, %esp
; AVX512-32-NEXT:    vcmpneqpd 8(%ebp), %xmm2, %k1
; AVX512-32-NEXT:    vpblendmq %xmm0, %xmm1, %xmm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v2f64_une_q:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmpneqpd %xmm3, %xmm2, %k1
; AVX512-64-NEXT:    vpblendmq %xmm0, %xmm1, %xmm0 {%k1}
; AVX512-64-NEXT:    retq
;
; AVX512F-32-LABEL: test_v2f64_une_q:
; AVX512F-32:       # %bb.0:
; AVX512F-32-NEXT:    pushl %ebp
; AVX512F-32-NEXT:    movl %esp, %ebp
; AVX512F-32-NEXT:    andl $-16, %esp
; AVX512F-32-NEXT:    subl $16, %esp
; AVX512F-32-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-32-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-32-NEXT:    vcmpneqpd 8(%ebp), %xmm2, %xmm2
; AVX512F-32-NEXT:    vptestmq %zmm2, %zmm2, %k1
; AVX512F-32-NEXT:    vpblendmq %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-32-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-32-NEXT:    movl %ebp, %esp
; AVX512F-32-NEXT:    popl %ebp
; AVX512F-32-NEXT:    vzeroupper
; AVX512F-32-NEXT:    retl
;
; AVX512F-64-LABEL: test_v2f64_une_q:
; AVX512F-64:       # %bb.0:
; AVX512F-64-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-64-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-64-NEXT:    vcmpneqpd %xmm3, %xmm2, %xmm2
; AVX512F-64-NEXT:    vptestmq %zmm2, %zmm2, %k1
; AVX512F-64-NEXT:    vpblendmq %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-64-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-64-NEXT:    vzeroupper
; AVX512F-64-NEXT:    retq
  %cond = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f64(
                                               <2 x double> %f1, <2 x double> %f2, metadata !"une",
                                               metadata !"fpexcept.strict") #0
  %res = select <2 x i1> %cond, <2 x i64> %a, <2 x i64> %b
  ret <2 x i64> %res
}

define <2 x i64> @test_v2f64_uno_q(<2 x i64> %a, <2 x i64> %b, <2 x double> %f1, <2 x double> %f2) #0 {
; SSE-32-LABEL: test_v2f64_uno_q:
; SSE-32:       # %bb.0:
; SSE-32-NEXT:    pushl %ebp
; SSE-32-NEXT:    movl %esp, %ebp
; SSE-32-NEXT:    andl $-16, %esp
; SSE-32-NEXT:    subl $16, %esp
; SSE-32-NEXT:    cmpunordpd 8(%ebp), %xmm2
; SSE-32-NEXT:    andpd %xmm2, %xmm0
; SSE-32-NEXT:    andnpd %xmm1, %xmm2
; SSE-32-NEXT:    orpd %xmm2, %xmm0
; SSE-32-NEXT:    movl %ebp, %esp
; SSE-32-NEXT:    popl %ebp
; SSE-32-NEXT:    retl
;
; SSE-64-LABEL: test_v2f64_uno_q:
; SSE-64:       # %bb.0:
; SSE-64-NEXT:    cmpunordpd %xmm3, %xmm2
; SSE-64-NEXT:    andpd %xmm2, %xmm0
; SSE-64-NEXT:    andnpd %xmm1, %xmm2
; SSE-64-NEXT:    orpd %xmm2, %xmm0
; SSE-64-NEXT:    retq
;
; AVX-32-LABEL: test_v2f64_uno_q:
; AVX-32:       # %bb.0:
; AVX-32-NEXT:    pushl %ebp
; AVX-32-NEXT:    movl %esp, %ebp
; AVX-32-NEXT:    andl $-16, %esp
; AVX-32-NEXT:    subl $16, %esp
; AVX-32-NEXT:    vcmpunordpd 8(%ebp), %xmm2, %xmm2
; AVX-32-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; AVX-32-NEXT:    movl %ebp, %esp
; AVX-32-NEXT:    popl %ebp
; AVX-32-NEXT:    retl
;
; AVX-64-LABEL: test_v2f64_uno_q:
; AVX-64:       # %bb.0:
; AVX-64-NEXT:    vcmpunordpd %xmm3, %xmm2, %xmm2
; AVX-64-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; AVX-64-NEXT:    retq
;
; AVX512-32-LABEL: test_v2f64_uno_q:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-16, %esp
; AVX512-32-NEXT:    subl $16, %esp
; AVX512-32-NEXT:    vcmpunordpd 8(%ebp), %xmm2, %k1
; AVX512-32-NEXT:    vpblendmq %xmm0, %xmm1, %xmm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v2f64_uno_q:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmpunordpd %xmm3, %xmm2, %k1
; AVX512-64-NEXT:    vpblendmq %xmm0, %xmm1, %xmm0 {%k1}
; AVX512-64-NEXT:    retq
;
; AVX512F-32-LABEL: test_v2f64_uno_q:
; AVX512F-32:       # %bb.0:
; AVX512F-32-NEXT:    pushl %ebp
; AVX512F-32-NEXT:    movl %esp, %ebp
; AVX512F-32-NEXT:    andl $-16, %esp
; AVX512F-32-NEXT:    subl $16, %esp
; AVX512F-32-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-32-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-32-NEXT:    vcmpunordpd 8(%ebp), %xmm2, %xmm2
; AVX512F-32-NEXT:    vptestmq %zmm2, %zmm2, %k1
; AVX512F-32-NEXT:    vpblendmq %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-32-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-32-NEXT:    movl %ebp, %esp
; AVX512F-32-NEXT:    popl %ebp
; AVX512F-32-NEXT:    vzeroupper
; AVX512F-32-NEXT:    retl
;
; AVX512F-64-LABEL: test_v2f64_uno_q:
; AVX512F-64:       # %bb.0:
; AVX512F-64-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-64-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-64-NEXT:    vcmpunordpd %xmm3, %xmm2, %xmm2
; AVX512F-64-NEXT:    vptestmq %zmm2, %zmm2, %k1
; AVX512F-64-NEXT:    vpblendmq %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-64-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-64-NEXT:    vzeroupper
; AVX512F-64-NEXT:    retq
  %cond = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f64(
                                               <2 x double> %f1, <2 x double> %f2, metadata !"uno",
                                               metadata !"fpexcept.strict") #0
  %res = select <2 x i1> %cond, <2 x i64> %a, <2 x i64> %b
  ret <2 x i64> %res
}

define <4 x i32> @test_v4f32_oeq_s(<4 x i32> %a, <4 x i32> %b, <4 x float> %f1, <4 x float> %f2) #0 {
; SSE-32-LABEL: test_v4f32_oeq_s:
; SSE-32:       # %bb.0:
; SSE-32-NEXT:    pushl %ebp
; SSE-32-NEXT:    movl %esp, %ebp
; SSE-32-NEXT:    andl $-16, %esp
; SSE-32-NEXT:    subl $16, %esp
; SSE-32-NEXT:    movaps 8(%ebp), %xmm3
; SSE-32-NEXT:    movaps %xmm2, %xmm4
; SSE-32-NEXT:    cmpltps %xmm3, %xmm4
; SSE-32-NEXT:    cmpeqps %xmm3, %xmm2
; SSE-32-NEXT:    andps %xmm2, %xmm0
; SSE-32-NEXT:    andnps %xmm1, %xmm2
; SSE-32-NEXT:    orps %xmm2, %xmm0
; SSE-32-NEXT:    movl %ebp, %esp
; SSE-32-NEXT:    popl %ebp
; SSE-32-NEXT:    retl
;
; SSE-64-LABEL: test_v4f32_oeq_s:
; SSE-64:       # %bb.0:
; SSE-64-NEXT:    movaps %xmm2, %xmm4
; SSE-64-NEXT:    cmpltps %xmm3, %xmm4
; SSE-64-NEXT:    cmpeqps %xmm3, %xmm2
; SSE-64-NEXT:    andps %xmm2, %xmm0
; SSE-64-NEXT:    andnps %xmm1, %xmm2
; SSE-64-NEXT:    orps %xmm2, %xmm0
; SSE-64-NEXT:    retq
;
; AVX-32-LABEL: test_v4f32_oeq_s:
; AVX-32:       # %bb.0:
; AVX-32-NEXT:    pushl %ebp
; AVX-32-NEXT:    movl %esp, %ebp
; AVX-32-NEXT:    andl $-16, %esp
; AVX-32-NEXT:    subl $16, %esp
; AVX-32-NEXT:    vcmpeq_osps 8(%ebp), %xmm2, %xmm2
; AVX-32-NEXT:    vblendvps %xmm2, %xmm0, %xmm1, %xmm0
; AVX-32-NEXT:    movl %ebp, %esp
; AVX-32-NEXT:    popl %ebp
; AVX-32-NEXT:    retl
;
; AVX-64-LABEL: test_v4f32_oeq_s:
; AVX-64:       # %bb.0:
; AVX-64-NEXT:    vcmpeq_osps %xmm3, %xmm2, %xmm2
; AVX-64-NEXT:    vblendvps %xmm2, %xmm0, %xmm1, %xmm0
; AVX-64-NEXT:    retq
;
; AVX512-32-LABEL: test_v4f32_oeq_s:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-16, %esp
; AVX512-32-NEXT:    subl $16, %esp
; AVX512-32-NEXT:    vcmpeq_osps 8(%ebp), %xmm2, %k1
; AVX512-32-NEXT:    vpblendmd %xmm0, %xmm1, %xmm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v4f32_oeq_s:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmpeq_osps %xmm3, %xmm2, %k1
; AVX512-64-NEXT:    vpblendmd %xmm0, %xmm1, %xmm0 {%k1}
; AVX512-64-NEXT:    retq
;
; AVX512F-32-LABEL: test_v4f32_oeq_s:
; AVX512F-32:       # %bb.0:
; AVX512F-32-NEXT:    pushl %ebp
; AVX512F-32-NEXT:    movl %esp, %ebp
; AVX512F-32-NEXT:    andl $-16, %esp
; AVX512F-32-NEXT:    subl $16, %esp
; AVX512F-32-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-32-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-32-NEXT:    vcmpeq_osps 8(%ebp), %xmm2, %xmm2
; AVX512F-32-NEXT:    vptestmd %zmm2, %zmm2, %k1
; AVX512F-32-NEXT:    vpblendmd %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-32-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-32-NEXT:    movl %ebp, %esp
; AVX512F-32-NEXT:    popl %ebp
; AVX512F-32-NEXT:    vzeroupper
; AVX512F-32-NEXT:    retl
;
; AVX512F-64-LABEL: test_v4f32_oeq_s:
; AVX512F-64:       # %bb.0:
; AVX512F-64-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-64-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-64-NEXT:    vcmpeq_osps %xmm3, %xmm2, %xmm2
; AVX512F-64-NEXT:    vptestmd %zmm2, %zmm2, %k1
; AVX512F-64-NEXT:    vpblendmd %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-64-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-64-NEXT:    vzeroupper
; AVX512F-64-NEXT:    retq
  %cond = call <4 x i1> @llvm.experimental.constrained.fcmps.v4f32(
                                               <4 x float> %f1, <4 x float> %f2, metadata !"oeq",
                                               metadata !"fpexcept.strict") #0
  %res = select <4 x i1> %cond, <4 x i32> %a, <4 x i32> %b
  ret <4 x i32> %res
}

define <4 x i32> @test_v4f32_ogt_s(<4 x i32> %a, <4 x i32> %b, <4 x float> %f1, <4 x float> %f2) #0 {
; SSE-32-LABEL: test_v4f32_ogt_s:
; SSE-32:       # %bb.0:
; SSE-32-NEXT:    pushl %ebp
; SSE-32-NEXT:    movl %esp, %ebp
; SSE-32-NEXT:    andl $-16, %esp
; SSE-32-NEXT:    subl $16, %esp
; SSE-32-NEXT:    movaps 8(%ebp), %xmm3
; SSE-32-NEXT:    cmpltps %xmm2, %xmm3
; SSE-32-NEXT:    andps %xmm3, %xmm0
; SSE-32-NEXT:    andnps %xmm1, %xmm3
; SSE-32-NEXT:    orps %xmm3, %xmm0
; SSE-32-NEXT:    movl %ebp, %esp
; SSE-32-NEXT:    popl %ebp
; SSE-32-NEXT:    retl
;
; SSE-64-LABEL: test_v4f32_ogt_s:
; SSE-64:       # %bb.0:
; SSE-64-NEXT:    cmpltps %xmm2, %xmm3
; SSE-64-NEXT:    andps %xmm3, %xmm0
; SSE-64-NEXT:    andnps %xmm1, %xmm3
; SSE-64-NEXT:    orps %xmm3, %xmm0
; SSE-64-NEXT:    retq
;
; AVX-32-LABEL: test_v4f32_ogt_s:
; AVX-32:       # %bb.0:
; AVX-32-NEXT:    pushl %ebp
; AVX-32-NEXT:    movl %esp, %ebp
; AVX-32-NEXT:    andl $-16, %esp
; AVX-32-NEXT:    subl $16, %esp
; AVX-32-NEXT:    vmovaps 8(%ebp), %xmm3
; AVX-32-NEXT:    vcmpltps %xmm2, %xmm3, %xmm2
; AVX-32-NEXT:    vblendvps %xmm2, %xmm0, %xmm1, %xmm0
; AVX-32-NEXT:    movl %ebp, %esp
; AVX-32-NEXT:    popl %ebp
; AVX-32-NEXT:    retl
;
; AVX-64-LABEL: test_v4f32_ogt_s:
; AVX-64:       # %bb.0:
; AVX-64-NEXT:    vcmpltps %xmm2, %xmm3, %xmm2
; AVX-64-NEXT:    vblendvps %xmm2, %xmm0, %xmm1, %xmm0
; AVX-64-NEXT:    retq
;
; AVX512-32-LABEL: test_v4f32_ogt_s:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-16, %esp
; AVX512-32-NEXT:    subl $16, %esp
; AVX512-32-NEXT:    vcmpgtps 8(%ebp), %xmm2, %k1
; AVX512-32-NEXT:    vpblendmd %xmm0, %xmm1, %xmm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v4f32_ogt_s:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmpltps %xmm2, %xmm3, %k1
; AVX512-64-NEXT:    vpblendmd %xmm0, %xmm1, %xmm0 {%k1}
; AVX512-64-NEXT:    retq
;
; AVX512F-32-LABEL: test_v4f32_ogt_s:
; AVX512F-32:       # %bb.0:
; AVX512F-32-NEXT:    pushl %ebp
; AVX512F-32-NEXT:    movl %esp, %ebp
; AVX512F-32-NEXT:    andl $-16, %esp
; AVX512F-32-NEXT:    subl $16, %esp
; AVX512F-32-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-32-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-32-NEXT:    vmovaps 8(%ebp), %xmm3
; AVX512F-32-NEXT:    vcmpltps %xmm2, %xmm3, %xmm2
; AVX512F-32-NEXT:    vptestmd %zmm2, %zmm2, %k1
; AVX512F-32-NEXT:    vpblendmd %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-32-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-32-NEXT:    movl %ebp, %esp
; AVX512F-32-NEXT:    popl %ebp
; AVX512F-32-NEXT:    vzeroupper
; AVX512F-32-NEXT:    retl
;
; AVX512F-64-LABEL: test_v4f32_ogt_s:
; AVX512F-64:       # %bb.0:
; AVX512F-64-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-64-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-64-NEXT:    vcmpltps %xmm2, %xmm3, %xmm2
; AVX512F-64-NEXT:    vptestmd %zmm2, %zmm2, %k1
; AVX512F-64-NEXT:    vpblendmd %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-64-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-64-NEXT:    vzeroupper
; AVX512F-64-NEXT:    retq
  %cond = call <4 x i1> @llvm.experimental.constrained.fcmps.v4f32(
                                               <4 x float> %f1, <4 x float> %f2, metadata !"ogt",
                                               metadata !"fpexcept.strict") #0
  %res = select <4 x i1> %cond, <4 x i32> %a, <4 x i32> %b
  ret <4 x i32> %res
}

define <4 x i32> @test_v4f32_oge_s(<4 x i32> %a, <4 x i32> %b, <4 x float> %f1, <4 x float> %f2) #0 {
; SSE-32-LABEL: test_v4f32_oge_s:
; SSE-32:       # %bb.0:
; SSE-32-NEXT:    pushl %ebp
; SSE-32-NEXT:    movl %esp, %ebp
; SSE-32-NEXT:    andl $-16, %esp
; SSE-32-NEXT:    subl $16, %esp
; SSE-32-NEXT:    movaps 8(%ebp), %xmm3
; SSE-32-NEXT:    cmpleps %xmm2, %xmm3
; SSE-32-NEXT:    andps %xmm3, %xmm0
; SSE-32-NEXT:    andnps %xmm1, %xmm3
; SSE-32-NEXT:    orps %xmm3, %xmm0
; SSE-32-NEXT:    movl %ebp, %esp
; SSE-32-NEXT:    popl %ebp
; SSE-32-NEXT:    retl
;
; SSE-64-LABEL: test_v4f32_oge_s:
; SSE-64:       # %bb.0:
; SSE-64-NEXT:    cmpleps %xmm2, %xmm3
; SSE-64-NEXT:    andps %xmm3, %xmm0
; SSE-64-NEXT:    andnps %xmm1, %xmm3
; SSE-64-NEXT:    orps %xmm3, %xmm0
; SSE-64-NEXT:    retq
;
; AVX-32-LABEL: test_v4f32_oge_s:
; AVX-32:       # %bb.0:
; AVX-32-NEXT:    pushl %ebp
; AVX-32-NEXT:    movl %esp, %ebp
; AVX-32-NEXT:    andl $-16, %esp
; AVX-32-NEXT:    subl $16, %esp
; AVX-32-NEXT:    vmovaps 8(%ebp), %xmm3
; AVX-32-NEXT:    vcmpleps %xmm2, %xmm3, %xmm2
; AVX-32-NEXT:    vblendvps %xmm2, %xmm0, %xmm1, %xmm0
; AVX-32-NEXT:    movl %ebp, %esp
; AVX-32-NEXT:    popl %ebp
; AVX-32-NEXT:    retl
;
; AVX-64-LABEL: test_v4f32_oge_s:
; AVX-64:       # %bb.0:
; AVX-64-NEXT:    vcmpleps %xmm2, %xmm3, %xmm2
; AVX-64-NEXT:    vblendvps %xmm2, %xmm0, %xmm1, %xmm0
; AVX-64-NEXT:    retq
;
; AVX512-32-LABEL: test_v4f32_oge_s:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-16, %esp
; AVX512-32-NEXT:    subl $16, %esp
; AVX512-32-NEXT:    vcmpgeps 8(%ebp), %xmm2, %k1
; AVX512-32-NEXT:    vpblendmd %xmm0, %xmm1, %xmm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v4f32_oge_s:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmpleps %xmm2, %xmm3, %k1
; AVX512-64-NEXT:    vpblendmd %xmm0, %xmm1, %xmm0 {%k1}
; AVX512-64-NEXT:    retq
;
; AVX512F-32-LABEL: test_v4f32_oge_s:
; AVX512F-32:       # %bb.0:
; AVX512F-32-NEXT:    pushl %ebp
; AVX512F-32-NEXT:    movl %esp, %ebp
; AVX512F-32-NEXT:    andl $-16, %esp
; AVX512F-32-NEXT:    subl $16, %esp
; AVX512F-32-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-32-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-32-NEXT:    vmovaps 8(%ebp), %xmm3
; AVX512F-32-NEXT:    vcmpleps %xmm2, %xmm3, %xmm2
; AVX512F-32-NEXT:    vptestmd %zmm2, %zmm2, %k1
; AVX512F-32-NEXT:    vpblendmd %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-32-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-32-NEXT:    movl %ebp, %esp
; AVX512F-32-NEXT:    popl %ebp
; AVX512F-32-NEXT:    vzeroupper
; AVX512F-32-NEXT:    retl
;
; AVX512F-64-LABEL: test_v4f32_oge_s:
; AVX512F-64:       # %bb.0:
; AVX512F-64-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-64-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-64-NEXT:    vcmpleps %xmm2, %xmm3, %xmm2
; AVX512F-64-NEXT:    vptestmd %zmm2, %zmm2, %k1
; AVX512F-64-NEXT:    vpblendmd %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-64-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-64-NEXT:    vzeroupper
; AVX512F-64-NEXT:    retq
  %cond = call <4 x i1> @llvm.experimental.constrained.fcmps.v4f32(
                                               <4 x float> %f1, <4 x float> %f2, metadata !"oge",
                                               metadata !"fpexcept.strict") #0
  %res = select <4 x i1> %cond, <4 x i32> %a, <4 x i32> %b
  ret <4 x i32> %res
}

define <4 x i32> @test_v4f32_olt_s(<4 x i32> %a, <4 x i32> %b, <4 x float> %f1, <4 x float> %f2) #0 {
; SSE-32-LABEL: test_v4f32_olt_s:
; SSE-32:       # %bb.0:
; SSE-32-NEXT:    pushl %ebp
; SSE-32-NEXT:    movl %esp, %ebp
; SSE-32-NEXT:    andl $-16, %esp
; SSE-32-NEXT:    subl $16, %esp
; SSE-32-NEXT:    cmpltps 8(%ebp), %xmm2
; SSE-32-NEXT:    andps %xmm2, %xmm0
; SSE-32-NEXT:    andnps %xmm1, %xmm2
; SSE-32-NEXT:    orps %xmm2, %xmm0
; SSE-32-NEXT:    movl %ebp, %esp
; SSE-32-NEXT:    popl %ebp
; SSE-32-NEXT:    retl
;
; SSE-64-LABEL: test_v4f32_olt_s:
; SSE-64:       # %bb.0:
; SSE-64-NEXT:    cmpltps %xmm3, %xmm2
; SSE-64-NEXT:    andps %xmm2, %xmm0
; SSE-64-NEXT:    andnps %xmm1, %xmm2
; SSE-64-NEXT:    orps %xmm2, %xmm0
; SSE-64-NEXT:    retq
;
; AVX-32-LABEL: test_v4f32_olt_s:
; AVX-32:       # %bb.0:
; AVX-32-NEXT:    pushl %ebp
; AVX-32-NEXT:    movl %esp, %ebp
; AVX-32-NEXT:    andl $-16, %esp
; AVX-32-NEXT:    subl $16, %esp
; AVX-32-NEXT:    vcmpltps 8(%ebp), %xmm2, %xmm2
; AVX-32-NEXT:    vblendvps %xmm2, %xmm0, %xmm1, %xmm0
; AVX-32-NEXT:    movl %ebp, %esp
; AVX-32-NEXT:    popl %ebp
; AVX-32-NEXT:    retl
;
; AVX-64-LABEL: test_v4f32_olt_s:
; AVX-64:       # %bb.0:
; AVX-64-NEXT:    vcmpltps %xmm3, %xmm2, %xmm2
; AVX-64-NEXT:    vblendvps %xmm2, %xmm0, %xmm1, %xmm0
; AVX-64-NEXT:    retq
;
; AVX512-32-LABEL: test_v4f32_olt_s:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-16, %esp
; AVX512-32-NEXT:    subl $16, %esp
; AVX512-32-NEXT:    vcmpltps 8(%ebp), %xmm2, %k1
; AVX512-32-NEXT:    vpblendmd %xmm0, %xmm1, %xmm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v4f32_olt_s:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmpltps %xmm3, %xmm2, %k1
; AVX512-64-NEXT:    vpblendmd %xmm0, %xmm1, %xmm0 {%k1}
; AVX512-64-NEXT:    retq
;
; AVX512F-32-LABEL: test_v4f32_olt_s:
; AVX512F-32:       # %bb.0:
; AVX512F-32-NEXT:    pushl %ebp
; AVX512F-32-NEXT:    movl %esp, %ebp
; AVX512F-32-NEXT:    andl $-16, %esp
; AVX512F-32-NEXT:    subl $16, %esp
; AVX512F-32-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-32-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-32-NEXT:    vcmpltps 8(%ebp), %xmm2, %xmm2
; AVX512F-32-NEXT:    vptestmd %zmm2, %zmm2, %k1
; AVX512F-32-NEXT:    vpblendmd %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-32-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-32-NEXT:    movl %ebp, %esp
; AVX512F-32-NEXT:    popl %ebp
; AVX512F-32-NEXT:    vzeroupper
; AVX512F-32-NEXT:    retl
;
; AVX512F-64-LABEL: test_v4f32_olt_s:
; AVX512F-64:       # %bb.0:
; AVX512F-64-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-64-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-64-NEXT:    vcmpltps %xmm3, %xmm2, %xmm2
; AVX512F-64-NEXT:    vptestmd %zmm2, %zmm2, %k1
; AVX512F-64-NEXT:    vpblendmd %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-64-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-64-NEXT:    vzeroupper
; AVX512F-64-NEXT:    retq
  %cond = call <4 x i1> @llvm.experimental.constrained.fcmps.v4f32(
                                               <4 x float> %f1, <4 x float> %f2, metadata !"olt",
                                               metadata !"fpexcept.strict") #0
  %res = select <4 x i1> %cond, <4 x i32> %a, <4 x i32> %b
  ret <4 x i32> %res
}

define <4 x i32> @test_v4f32_ole_s(<4 x i32> %a, <4 x i32> %b, <4 x float> %f1, <4 x float> %f2) #0 {
; SSE-32-LABEL: test_v4f32_ole_s:
; SSE-32:       # %bb.0:
; SSE-32-NEXT:    pushl %ebp
; SSE-32-NEXT:    movl %esp, %ebp
; SSE-32-NEXT:    andl $-16, %esp
; SSE-32-NEXT:    subl $16, %esp
; SSE-32-NEXT:    cmpleps 8(%ebp), %xmm2
; SSE-32-NEXT:    andps %xmm2, %xmm0
; SSE-32-NEXT:    andnps %xmm1, %xmm2
; SSE-32-NEXT:    orps %xmm2, %xmm0
; SSE-32-NEXT:    movl %ebp, %esp
; SSE-32-NEXT:    popl %ebp
; SSE-32-NEXT:    retl
;
; SSE-64-LABEL: test_v4f32_ole_s:
; SSE-64:       # %bb.0:
; SSE-64-NEXT:    cmpleps %xmm3, %xmm2
; SSE-64-NEXT:    andps %xmm2, %xmm0
; SSE-64-NEXT:    andnps %xmm1, %xmm2
; SSE-64-NEXT:    orps %xmm2, %xmm0
; SSE-64-NEXT:    retq
;
; AVX-32-LABEL: test_v4f32_ole_s:
; AVX-32:       # %bb.0:
; AVX-32-NEXT:    pushl %ebp
; AVX-32-NEXT:    movl %esp, %ebp
; AVX-32-NEXT:    andl $-16, %esp
; AVX-32-NEXT:    subl $16, %esp
; AVX-32-NEXT:    vcmpleps 8(%ebp), %xmm2, %xmm2
; AVX-32-NEXT:    vblendvps %xmm2, %xmm0, %xmm1, %xmm0
; AVX-32-NEXT:    movl %ebp, %esp
; AVX-32-NEXT:    popl %ebp
; AVX-32-NEXT:    retl
;
; AVX-64-LABEL: test_v4f32_ole_s:
; AVX-64:       # %bb.0:
; AVX-64-NEXT:    vcmpleps %xmm3, %xmm2, %xmm2
; AVX-64-NEXT:    vblendvps %xmm2, %xmm0, %xmm1, %xmm0
; AVX-64-NEXT:    retq
;
; AVX512-32-LABEL: test_v4f32_ole_s:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-16, %esp
; AVX512-32-NEXT:    subl $16, %esp
; AVX512-32-NEXT:    vcmpleps 8(%ebp), %xmm2, %k1
; AVX512-32-NEXT:    vpblendmd %xmm0, %xmm1, %xmm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v4f32_ole_s:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmpleps %xmm3, %xmm2, %k1
; AVX512-64-NEXT:    vpblendmd %xmm0, %xmm1, %xmm0 {%k1}
; AVX512-64-NEXT:    retq
;
; AVX512F-32-LABEL: test_v4f32_ole_s:
; AVX512F-32:       # %bb.0:
; AVX512F-32-NEXT:    pushl %ebp
; AVX512F-32-NEXT:    movl %esp, %ebp
; AVX512F-32-NEXT:    andl $-16, %esp
; AVX512F-32-NEXT:    subl $16, %esp
; AVX512F-32-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-32-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-32-NEXT:    vcmpleps 8(%ebp), %xmm2, %xmm2
; AVX512F-32-NEXT:    vptestmd %zmm2, %zmm2, %k1
; AVX512F-32-NEXT:    vpblendmd %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-32-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-32-NEXT:    movl %ebp, %esp
; AVX512F-32-NEXT:    popl %ebp
; AVX512F-32-NEXT:    vzeroupper
; AVX512F-32-NEXT:    retl
;
; AVX512F-64-LABEL: test_v4f32_ole_s:
; AVX512F-64:       # %bb.0:
; AVX512F-64-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-64-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-64-NEXT:    vcmpleps %xmm3, %xmm2, %xmm2
; AVX512F-64-NEXT:    vptestmd %zmm2, %zmm2, %k1
; AVX512F-64-NEXT:    vpblendmd %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-64-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-64-NEXT:    vzeroupper
; AVX512F-64-NEXT:    retq
  %cond = call <4 x i1> @llvm.experimental.constrained.fcmps.v4f32(
                                               <4 x float> %f1, <4 x float> %f2, metadata !"ole",
                                               metadata !"fpexcept.strict") #0
  %res = select <4 x i1> %cond, <4 x i32> %a, <4 x i32> %b
  ret <4 x i32> %res
}

define <4 x i32> @test_v4f32_one_s(<4 x i32> %a, <4 x i32> %b, <4 x float> %f1, <4 x float> %f2) #0 {
; SSE-32-LABEL: test_v4f32_one_s:
; SSE-32:       # %bb.0:
; SSE-32-NEXT:    pushl %ebp
; SSE-32-NEXT:    movl %esp, %ebp
; SSE-32-NEXT:    andl $-16, %esp
; SSE-32-NEXT:    subl $16, %esp
; SSE-32-NEXT:    movaps 8(%ebp), %xmm3
; SSE-32-NEXT:    movaps %xmm2, %xmm4
; SSE-32-NEXT:    cmpltps %xmm3, %xmm4
; SSE-32-NEXT:    movaps %xmm2, %xmm4
; SSE-32-NEXT:    cmpneqps %xmm3, %xmm4
; SSE-32-NEXT:    cmpordps %xmm3, %xmm2
; SSE-32-NEXT:    andps %xmm4, %xmm2
; SSE-32-NEXT:    andps %xmm2, %xmm0
; SSE-32-NEXT:    andnps %xmm1, %xmm2
; SSE-32-NEXT:    orps %xmm2, %xmm0
; SSE-32-NEXT:    movl %ebp, %esp
; SSE-32-NEXT:    popl %ebp
; SSE-32-NEXT:    retl
;
; SSE-64-LABEL: test_v4f32_one_s:
; SSE-64:       # %bb.0:
; SSE-64-NEXT:    movaps %xmm2, %xmm4
; SSE-64-NEXT:    cmpltps %xmm3, %xmm4
; SSE-64-NEXT:    movaps %xmm2, %xmm4
; SSE-64-NEXT:    cmpneqps %xmm3, %xmm4
; SSE-64-NEXT:    cmpordps %xmm3, %xmm2
; SSE-64-NEXT:    andps %xmm4, %xmm2
; SSE-64-NEXT:    andps %xmm2, %xmm0
; SSE-64-NEXT:    andnps %xmm1, %xmm2
; SSE-64-NEXT:    orps %xmm2, %xmm0
; SSE-64-NEXT:    retq
;
; AVX-32-LABEL: test_v4f32_one_s:
; AVX-32:       # %bb.0:
; AVX-32-NEXT:    pushl %ebp
; AVX-32-NEXT:    movl %esp, %ebp
; AVX-32-NEXT:    andl $-16, %esp
; AVX-32-NEXT:    subl $16, %esp
; AVX-32-NEXT:    vcmpneq_osps 8(%ebp), %xmm2, %xmm2
; AVX-32-NEXT:    vblendvps %xmm2, %xmm0, %xmm1, %xmm0
; AVX-32-NEXT:    movl %ebp, %esp
; AVX-32-NEXT:    popl %ebp
; AVX-32-NEXT:    retl
;
; AVX-64-LABEL: test_v4f32_one_s:
; AVX-64:       # %bb.0:
; AVX-64-NEXT:    vcmpneq_osps %xmm3, %xmm2, %xmm2
; AVX-64-NEXT:    vblendvps %xmm2, %xmm0, %xmm1, %xmm0
; AVX-64-NEXT:    retq
;
; AVX512-32-LABEL: test_v4f32_one_s:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-16, %esp
; AVX512-32-NEXT:    subl $16, %esp
; AVX512-32-NEXT:    vcmpneq_osps 8(%ebp), %xmm2, %k1
; AVX512-32-NEXT:    vpblendmd %xmm0, %xmm1, %xmm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v4f32_one_s:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmpneq_osps %xmm3, %xmm2, %k1
; AVX512-64-NEXT:    vpblendmd %xmm0, %xmm1, %xmm0 {%k1}
; AVX512-64-NEXT:    retq
;
; AVX512F-32-LABEL: test_v4f32_one_s:
; AVX512F-32:       # %bb.0:
; AVX512F-32-NEXT:    pushl %ebp
; AVX512F-32-NEXT:    movl %esp, %ebp
; AVX512F-32-NEXT:    andl $-16, %esp
; AVX512F-32-NEXT:    subl $16, %esp
; AVX512F-32-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-32-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-32-NEXT:    vcmpneq_osps 8(%ebp), %xmm2, %xmm2
; AVX512F-32-NEXT:    vptestmd %zmm2, %zmm2, %k1
; AVX512F-32-NEXT:    vpblendmd %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-32-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-32-NEXT:    movl %ebp, %esp
; AVX512F-32-NEXT:    popl %ebp
; AVX512F-32-NEXT:    vzeroupper
; AVX512F-32-NEXT:    retl
;
; AVX512F-64-LABEL: test_v4f32_one_s:
; AVX512F-64:       # %bb.0:
; AVX512F-64-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-64-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-64-NEXT:    vcmpneq_osps %xmm3, %xmm2, %xmm2
; AVX512F-64-NEXT:    vptestmd %zmm2, %zmm2, %k1
; AVX512F-64-NEXT:    vpblendmd %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-64-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-64-NEXT:    vzeroupper
; AVX512F-64-NEXT:    retq
  %cond = call <4 x i1> @llvm.experimental.constrained.fcmps.v4f32(
                                               <4 x float> %f1, <4 x float> %f2, metadata !"one",
                                               metadata !"fpexcept.strict") #0
  %res = select <4 x i1> %cond, <4 x i32> %a, <4 x i32> %b
  ret <4 x i32> %res
}

define <4 x i32> @test_v4f32_ord_s(<4 x i32> %a, <4 x i32> %b, <4 x float> %f1, <4 x float> %f2) #0 {
; SSE-32-LABEL: test_v4f32_ord_s:
; SSE-32:       # %bb.0:
; SSE-32-NEXT:    pushl %ebp
; SSE-32-NEXT:    movl %esp, %ebp
; SSE-32-NEXT:    andl $-16, %esp
; SSE-32-NEXT:    subl $16, %esp
; SSE-32-NEXT:    movaps 8(%ebp), %xmm3
; SSE-32-NEXT:    movaps %xmm2, %xmm4
; SSE-32-NEXT:    cmpltps %xmm3, %xmm4
; SSE-32-NEXT:    cmpordps %xmm3, %xmm2
; SSE-32-NEXT:    andps %xmm2, %xmm0
; SSE-32-NEXT:    andnps %xmm1, %xmm2
; SSE-32-NEXT:    orps %xmm2, %xmm0
; SSE-32-NEXT:    movl %ebp, %esp
; SSE-32-NEXT:    popl %ebp
; SSE-32-NEXT:    retl
;
; SSE-64-LABEL: test_v4f32_ord_s:
; SSE-64:       # %bb.0:
; SSE-64-NEXT:    movaps %xmm2, %xmm4
; SSE-64-NEXT:    cmpltps %xmm3, %xmm4
; SSE-64-NEXT:    cmpordps %xmm3, %xmm2
; SSE-64-NEXT:    andps %xmm2, %xmm0
; SSE-64-NEXT:    andnps %xmm1, %xmm2
; SSE-64-NEXT:    orps %xmm2, %xmm0
; SSE-64-NEXT:    retq
;
; AVX-32-LABEL: test_v4f32_ord_s:
; AVX-32:       # %bb.0:
; AVX-32-NEXT:    pushl %ebp
; AVX-32-NEXT:    movl %esp, %ebp
; AVX-32-NEXT:    andl $-16, %esp
; AVX-32-NEXT:    subl $16, %esp
; AVX-32-NEXT:    vcmpord_sps 8(%ebp), %xmm2, %xmm2
; AVX-32-NEXT:    vblendvps %xmm2, %xmm0, %xmm1, %xmm0
; AVX-32-NEXT:    movl %ebp, %esp
; AVX-32-NEXT:    popl %ebp
; AVX-32-NEXT:    retl
;
; AVX-64-LABEL: test_v4f32_ord_s:
; AVX-64:       # %bb.0:
; AVX-64-NEXT:    vcmpord_sps %xmm3, %xmm2, %xmm2
; AVX-64-NEXT:    vblendvps %xmm2, %xmm0, %xmm1, %xmm0
; AVX-64-NEXT:    retq
;
; AVX512-32-LABEL: test_v4f32_ord_s:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-16, %esp
; AVX512-32-NEXT:    subl $16, %esp
; AVX512-32-NEXT:    vcmpord_sps 8(%ebp), %xmm2, %k1
; AVX512-32-NEXT:    vpblendmd %xmm0, %xmm1, %xmm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v4f32_ord_s:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmpord_sps %xmm3, %xmm2, %k1
; AVX512-64-NEXT:    vpblendmd %xmm0, %xmm1, %xmm0 {%k1}
; AVX512-64-NEXT:    retq
;
; AVX512F-32-LABEL: test_v4f32_ord_s:
; AVX512F-32:       # %bb.0:
; AVX512F-32-NEXT:    pushl %ebp
; AVX512F-32-NEXT:    movl %esp, %ebp
; AVX512F-32-NEXT:    andl $-16, %esp
; AVX512F-32-NEXT:    subl $16, %esp
; AVX512F-32-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-32-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-32-NEXT:    vcmpord_sps 8(%ebp), %xmm2, %xmm2
; AVX512F-32-NEXT:    vptestmd %zmm2, %zmm2, %k1
; AVX512F-32-NEXT:    vpblendmd %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-32-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-32-NEXT:    movl %ebp, %esp
; AVX512F-32-NEXT:    popl %ebp
; AVX512F-32-NEXT:    vzeroupper
; AVX512F-32-NEXT:    retl
;
; AVX512F-64-LABEL: test_v4f32_ord_s:
; AVX512F-64:       # %bb.0:
; AVX512F-64-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-64-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-64-NEXT:    vcmpord_sps %xmm3, %xmm2, %xmm2
; AVX512F-64-NEXT:    vptestmd %zmm2, %zmm2, %k1
; AVX512F-64-NEXT:    vpblendmd %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-64-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-64-NEXT:    vzeroupper
; AVX512F-64-NEXT:    retq
  %cond = call <4 x i1> @llvm.experimental.constrained.fcmps.v4f32(
                                               <4 x float> %f1, <4 x float> %f2, metadata !"ord",
                                               metadata !"fpexcept.strict") #0
  %res = select <4 x i1> %cond, <4 x i32> %a, <4 x i32> %b
  ret <4 x i32> %res
}

define <4 x i32> @test_v4f32_ueq_s(<4 x i32> %a, <4 x i32> %b, <4 x float> %f1, <4 x float> %f2) #0 {
; SSE-32-LABEL: test_v4f32_ueq_s:
; SSE-32:       # %bb.0:
; SSE-32-NEXT:    pushl %ebp
; SSE-32-NEXT:    movl %esp, %ebp
; SSE-32-NEXT:    andl $-16, %esp
; SSE-32-NEXT:    subl $16, %esp
; SSE-32-NEXT:    movaps 8(%ebp), %xmm3
; SSE-32-NEXT:    movaps %xmm2, %xmm4
; SSE-32-NEXT:    cmpltps %xmm3, %xmm4
; SSE-32-NEXT:    movaps %xmm2, %xmm4
; SSE-32-NEXT:    cmpeqps %xmm3, %xmm4
; SSE-32-NEXT:    cmpunordps %xmm3, %xmm2
; SSE-32-NEXT:    orps %xmm4, %xmm2
; SSE-32-NEXT:    andps %xmm2, %xmm0
; SSE-32-NEXT:    andnps %xmm1, %xmm2
; SSE-32-NEXT:    orps %xmm2, %xmm0
; SSE-32-NEXT:    movl %ebp, %esp
; SSE-32-NEXT:    popl %ebp
; SSE-32-NEXT:    retl
;
; SSE-64-LABEL: test_v4f32_ueq_s:
; SSE-64:       # %bb.0:
; SSE-64-NEXT:    movaps %xmm2, %xmm4
; SSE-64-NEXT:    cmpltps %xmm3, %xmm4
; SSE-64-NEXT:    movaps %xmm2, %xmm4
; SSE-64-NEXT:    cmpeqps %xmm3, %xmm4
; SSE-64-NEXT:    cmpunordps %xmm3, %xmm2
; SSE-64-NEXT:    orps %xmm4, %xmm2
; SSE-64-NEXT:    andps %xmm2, %xmm0
; SSE-64-NEXT:    andnps %xmm1, %xmm2
; SSE-64-NEXT:    orps %xmm2, %xmm0
; SSE-64-NEXT:    retq
;
; AVX-32-LABEL: test_v4f32_ueq_s:
; AVX-32:       # %bb.0:
; AVX-32-NEXT:    pushl %ebp
; AVX-32-NEXT:    movl %esp, %ebp
; AVX-32-NEXT:    andl $-16, %esp
; AVX-32-NEXT:    subl $16, %esp
; AVX-32-NEXT:    vcmpeq_usps 8(%ebp), %xmm2, %xmm2
; AVX-32-NEXT:    vblendvps %xmm2, %xmm0, %xmm1, %xmm0
; AVX-32-NEXT:    movl %ebp, %esp
; AVX-32-NEXT:    popl %ebp
; AVX-32-NEXT:    retl
;
; AVX-64-LABEL: test_v4f32_ueq_s:
; AVX-64:       # %bb.0:
; AVX-64-NEXT:    vcmpeq_usps %xmm3, %xmm2, %xmm2
; AVX-64-NEXT:    vblendvps %xmm2, %xmm0, %xmm1, %xmm0
; AVX-64-NEXT:    retq
;
; AVX512-32-LABEL: test_v4f32_ueq_s:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-16, %esp
; AVX512-32-NEXT:    subl $16, %esp
; AVX512-32-NEXT:    vcmpeq_usps 8(%ebp), %xmm2, %k1
; AVX512-32-NEXT:    vpblendmd %xmm0, %xmm1, %xmm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v4f32_ueq_s:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmpeq_usps %xmm3, %xmm2, %k1
; AVX512-64-NEXT:    vpblendmd %xmm0, %xmm1, %xmm0 {%k1}
; AVX512-64-NEXT:    retq
;
; AVX512F-32-LABEL: test_v4f32_ueq_s:
; AVX512F-32:       # %bb.0:
; AVX512F-32-NEXT:    pushl %ebp
; AVX512F-32-NEXT:    movl %esp, %ebp
; AVX512F-32-NEXT:    andl $-16, %esp
; AVX512F-32-NEXT:    subl $16, %esp
; AVX512F-32-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-32-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-32-NEXT:    vcmpeq_usps 8(%ebp), %xmm2, %xmm2
; AVX512F-32-NEXT:    vptestmd %zmm2, %zmm2, %k1
; AVX512F-32-NEXT:    vpblendmd %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-32-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-32-NEXT:    movl %ebp, %esp
; AVX512F-32-NEXT:    popl %ebp
; AVX512F-32-NEXT:    vzeroupper
; AVX512F-32-NEXT:    retl
;
; AVX512F-64-LABEL: test_v4f32_ueq_s:
; AVX512F-64:       # %bb.0:
; AVX512F-64-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-64-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-64-NEXT:    vcmpeq_usps %xmm3, %xmm2, %xmm2
; AVX512F-64-NEXT:    vptestmd %zmm2, %zmm2, %k1
; AVX512F-64-NEXT:    vpblendmd %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-64-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-64-NEXT:    vzeroupper
; AVX512F-64-NEXT:    retq
  %cond = call <4 x i1> @llvm.experimental.constrained.fcmps.v4f32(
                                               <4 x float> %f1, <4 x float> %f2, metadata !"ueq",
                                               metadata !"fpexcept.strict") #0
  %res = select <4 x i1> %cond, <4 x i32> %a, <4 x i32> %b
  ret <4 x i32> %res
}

define <4 x i32> @test_v4f32_ugt_s(<4 x i32> %a, <4 x i32> %b, <4 x float> %f1, <4 x float> %f2) #0 {
; SSE-32-LABEL: test_v4f32_ugt_s:
; SSE-32:       # %bb.0:
; SSE-32-NEXT:    pushl %ebp
; SSE-32-NEXT:    movl %esp, %ebp
; SSE-32-NEXT:    andl $-16, %esp
; SSE-32-NEXT:    subl $16, %esp
; SSE-32-NEXT:    cmpnleps 8(%ebp), %xmm2
; SSE-32-NEXT:    andps %xmm2, %xmm0
; SSE-32-NEXT:    andnps %xmm1, %xmm2
; SSE-32-NEXT:    orps %xmm2, %xmm0
; SSE-32-NEXT:    movl %ebp, %esp
; SSE-32-NEXT:    popl %ebp
; SSE-32-NEXT:    retl
;
; SSE-64-LABEL: test_v4f32_ugt_s:
; SSE-64:       # %bb.0:
; SSE-64-NEXT:    cmpnleps %xmm3, %xmm2
; SSE-64-NEXT:    andps %xmm2, %xmm0
; SSE-64-NEXT:    andnps %xmm1, %xmm2
; SSE-64-NEXT:    orps %xmm2, %xmm0
; SSE-64-NEXT:    retq
;
; AVX-32-LABEL: test_v4f32_ugt_s:
; AVX-32:       # %bb.0:
; AVX-32-NEXT:    pushl %ebp
; AVX-32-NEXT:    movl %esp, %ebp
; AVX-32-NEXT:    andl $-16, %esp
; AVX-32-NEXT:    subl $16, %esp
; AVX-32-NEXT:    vcmpnleps 8(%ebp), %xmm2, %xmm2
; AVX-32-NEXT:    vblendvps %xmm2, %xmm0, %xmm1, %xmm0
; AVX-32-NEXT:    movl %ebp, %esp
; AVX-32-NEXT:    popl %ebp
; AVX-32-NEXT:    retl
;
; AVX-64-LABEL: test_v4f32_ugt_s:
; AVX-64:       # %bb.0:
; AVX-64-NEXT:    vcmpnleps %xmm3, %xmm2, %xmm2
; AVX-64-NEXT:    vblendvps %xmm2, %xmm0, %xmm1, %xmm0
; AVX-64-NEXT:    retq
;
; AVX512-32-LABEL: test_v4f32_ugt_s:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-16, %esp
; AVX512-32-NEXT:    subl $16, %esp
; AVX512-32-NEXT:    vcmpnleps 8(%ebp), %xmm2, %k1
; AVX512-32-NEXT:    vpblendmd %xmm0, %xmm1, %xmm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v4f32_ugt_s:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmpnleps %xmm3, %xmm2, %k1
; AVX512-64-NEXT:    vpblendmd %xmm0, %xmm1, %xmm0 {%k1}
; AVX512-64-NEXT:    retq
;
; AVX512F-32-LABEL: test_v4f32_ugt_s:
; AVX512F-32:       # %bb.0:
; AVX512F-32-NEXT:    pushl %ebp
; AVX512F-32-NEXT:    movl %esp, %ebp
; AVX512F-32-NEXT:    andl $-16, %esp
; AVX512F-32-NEXT:    subl $16, %esp
; AVX512F-32-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-32-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-32-NEXT:    vcmpnleps 8(%ebp), %xmm2, %xmm2
; AVX512F-32-NEXT:    vptestmd %zmm2, %zmm2, %k1
; AVX512F-32-NEXT:    vpblendmd %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-32-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-32-NEXT:    movl %ebp, %esp
; AVX512F-32-NEXT:    popl %ebp
; AVX512F-32-NEXT:    vzeroupper
; AVX512F-32-NEXT:    retl
;
; AVX512F-64-LABEL: test_v4f32_ugt_s:
; AVX512F-64:       # %bb.0:
; AVX512F-64-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-64-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-64-NEXT:    vcmpnleps %xmm3, %xmm2, %xmm2
; AVX512F-64-NEXT:    vptestmd %zmm2, %zmm2, %k1
; AVX512F-64-NEXT:    vpblendmd %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-64-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-64-NEXT:    vzeroupper
; AVX512F-64-NEXT:    retq
  %cond = call <4 x i1> @llvm.experimental.constrained.fcmps.v4f32(
                                               <4 x float> %f1, <4 x float> %f2, metadata !"ugt",
                                               metadata !"fpexcept.strict") #0
  %res = select <4 x i1> %cond, <4 x i32> %a, <4 x i32> %b
  ret <4 x i32> %res
}

define <4 x i32> @test_v4f32_uge_s(<4 x i32> %a, <4 x i32> %b, <4 x float> %f1, <4 x float> %f2) #0 {
; SSE-32-LABEL: test_v4f32_uge_s:
; SSE-32:       # %bb.0:
; SSE-32-NEXT:    pushl %ebp
; SSE-32-NEXT:    movl %esp, %ebp
; SSE-32-NEXT:    andl $-16, %esp
; SSE-32-NEXT:    subl $16, %esp
; SSE-32-NEXT:    cmpnltps 8(%ebp), %xmm2
; SSE-32-NEXT:    andps %xmm2, %xmm0
; SSE-32-NEXT:    andnps %xmm1, %xmm2
; SSE-32-NEXT:    orps %xmm2, %xmm0
; SSE-32-NEXT:    movl %ebp, %esp
; SSE-32-NEXT:    popl %ebp
; SSE-32-NEXT:    retl
;
; SSE-64-LABEL: test_v4f32_uge_s:
; SSE-64:       # %bb.0:
; SSE-64-NEXT:    cmpnltps %xmm3, %xmm2
; SSE-64-NEXT:    andps %xmm2, %xmm0
; SSE-64-NEXT:    andnps %xmm1, %xmm2
; SSE-64-NEXT:    orps %xmm2, %xmm0
; SSE-64-NEXT:    retq
;
; AVX-32-LABEL: test_v4f32_uge_s:
; AVX-32:       # %bb.0:
; AVX-32-NEXT:    pushl %ebp
; AVX-32-NEXT:    movl %esp, %ebp
; AVX-32-NEXT:    andl $-16, %esp
; AVX-32-NEXT:    subl $16, %esp
; AVX-32-NEXT:    vcmpnltps 8(%ebp), %xmm2, %xmm2
; AVX-32-NEXT:    vblendvps %xmm2, %xmm0, %xmm1, %xmm0
; AVX-32-NEXT:    movl %ebp, %esp
; AVX-32-NEXT:    popl %ebp
; AVX-32-NEXT:    retl
;
; AVX-64-LABEL: test_v4f32_uge_s:
; AVX-64:       # %bb.0:
; AVX-64-NEXT:    vcmpnltps %xmm3, %xmm2, %xmm2
; AVX-64-NEXT:    vblendvps %xmm2, %xmm0, %xmm1, %xmm0
; AVX-64-NEXT:    retq
;
; AVX512-32-LABEL: test_v4f32_uge_s:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-16, %esp
; AVX512-32-NEXT:    subl $16, %esp
; AVX512-32-NEXT:    vcmpnltps 8(%ebp), %xmm2, %k1
; AVX512-32-NEXT:    vpblendmd %xmm0, %xmm1, %xmm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v4f32_uge_s:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmpnltps %xmm3, %xmm2, %k1
; AVX512-64-NEXT:    vpblendmd %xmm0, %xmm1, %xmm0 {%k1}
; AVX512-64-NEXT:    retq
;
; AVX512F-32-LABEL: test_v4f32_uge_s:
; AVX512F-32:       # %bb.0:
; AVX512F-32-NEXT:    pushl %ebp
; AVX512F-32-NEXT:    movl %esp, %ebp
; AVX512F-32-NEXT:    andl $-16, %esp
; AVX512F-32-NEXT:    subl $16, %esp
; AVX512F-32-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-32-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-32-NEXT:    vcmpnltps 8(%ebp), %xmm2, %xmm2
; AVX512F-32-NEXT:    vptestmd %zmm2, %zmm2, %k1
; AVX512F-32-NEXT:    vpblendmd %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-32-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-32-NEXT:    movl %ebp, %esp
; AVX512F-32-NEXT:    popl %ebp
; AVX512F-32-NEXT:    vzeroupper
; AVX512F-32-NEXT:    retl
;
; AVX512F-64-LABEL: test_v4f32_uge_s:
; AVX512F-64:       # %bb.0:
; AVX512F-64-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-64-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-64-NEXT:    vcmpnltps %xmm3, %xmm2, %xmm2
; AVX512F-64-NEXT:    vptestmd %zmm2, %zmm2, %k1
; AVX512F-64-NEXT:    vpblendmd %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-64-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-64-NEXT:    vzeroupper
; AVX512F-64-NEXT:    retq
  %cond = call <4 x i1> @llvm.experimental.constrained.fcmps.v4f32(
                                               <4 x float> %f1, <4 x float> %f2, metadata !"uge",
                                               metadata !"fpexcept.strict") #0
  %res = select <4 x i1> %cond, <4 x i32> %a, <4 x i32> %b
  ret <4 x i32> %res
}

define <4 x i32> @test_v4f32_ult_s(<4 x i32> %a, <4 x i32> %b, <4 x float> %f1, <4 x float> %f2) #0 {
; SSE-32-LABEL: test_v4f32_ult_s:
; SSE-32:       # %bb.0:
; SSE-32-NEXT:    pushl %ebp
; SSE-32-NEXT:    movl %esp, %ebp
; SSE-32-NEXT:    andl $-16, %esp
; SSE-32-NEXT:    subl $16, %esp
; SSE-32-NEXT:    movaps 8(%ebp), %xmm3
; SSE-32-NEXT:    cmpnleps %xmm2, %xmm3
; SSE-32-NEXT:    andps %xmm3, %xmm0
; SSE-32-NEXT:    andnps %xmm1, %xmm3
; SSE-32-NEXT:    orps %xmm3, %xmm0
; SSE-32-NEXT:    movl %ebp, %esp
; SSE-32-NEXT:    popl %ebp
; SSE-32-NEXT:    retl
;
; SSE-64-LABEL: test_v4f32_ult_s:
; SSE-64:       # %bb.0:
; SSE-64-NEXT:    cmpnleps %xmm2, %xmm3
; SSE-64-NEXT:    andps %xmm3, %xmm0
; SSE-64-NEXT:    andnps %xmm1, %xmm3
; SSE-64-NEXT:    orps %xmm3, %xmm0
; SSE-64-NEXT:    retq
;
; AVX-32-LABEL: test_v4f32_ult_s:
; AVX-32:       # %bb.0:
; AVX-32-NEXT:    pushl %ebp
; AVX-32-NEXT:    movl %esp, %ebp
; AVX-32-NEXT:    andl $-16, %esp
; AVX-32-NEXT:    subl $16, %esp
; AVX-32-NEXT:    vmovaps 8(%ebp), %xmm3
; AVX-32-NEXT:    vcmpnleps %xmm2, %xmm3, %xmm2
; AVX-32-NEXT:    vblendvps %xmm2, %xmm0, %xmm1, %xmm0
; AVX-32-NEXT:    movl %ebp, %esp
; AVX-32-NEXT:    popl %ebp
; AVX-32-NEXT:    retl
;
; AVX-64-LABEL: test_v4f32_ult_s:
; AVX-64:       # %bb.0:
; AVX-64-NEXT:    vcmpnleps %xmm2, %xmm3, %xmm2
; AVX-64-NEXT:    vblendvps %xmm2, %xmm0, %xmm1, %xmm0
; AVX-64-NEXT:    retq
;
; AVX512-32-LABEL: test_v4f32_ult_s:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-16, %esp
; AVX512-32-NEXT:    subl $16, %esp
; AVX512-32-NEXT:    vcmpngeps 8(%ebp), %xmm2, %k1
; AVX512-32-NEXT:    vpblendmd %xmm0, %xmm1, %xmm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v4f32_ult_s:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmpnleps %xmm2, %xmm3, %k1
; AVX512-64-NEXT:    vpblendmd %xmm0, %xmm1, %xmm0 {%k1}
; AVX512-64-NEXT:    retq
;
; AVX512F-32-LABEL: test_v4f32_ult_s:
; AVX512F-32:       # %bb.0:
; AVX512F-32-NEXT:    pushl %ebp
; AVX512F-32-NEXT:    movl %esp, %ebp
; AVX512F-32-NEXT:    andl $-16, %esp
; AVX512F-32-NEXT:    subl $16, %esp
; AVX512F-32-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-32-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-32-NEXT:    vmovaps 8(%ebp), %xmm3
; AVX512F-32-NEXT:    vcmpnleps %xmm2, %xmm3, %xmm2
; AVX512F-32-NEXT:    vptestmd %zmm2, %zmm2, %k1
; AVX512F-32-NEXT:    vpblendmd %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-32-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-32-NEXT:    movl %ebp, %esp
; AVX512F-32-NEXT:    popl %ebp
; AVX512F-32-NEXT:    vzeroupper
; AVX512F-32-NEXT:    retl
;
; AVX512F-64-LABEL: test_v4f32_ult_s:
; AVX512F-64:       # %bb.0:
; AVX512F-64-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-64-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-64-NEXT:    vcmpnleps %xmm2, %xmm3, %xmm2
; AVX512F-64-NEXT:    vptestmd %zmm2, %zmm2, %k1
; AVX512F-64-NEXT:    vpblendmd %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-64-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-64-NEXT:    vzeroupper
; AVX512F-64-NEXT:    retq
  %cond = call <4 x i1> @llvm.experimental.constrained.fcmps.v4f32(
                                               <4 x float> %f1, <4 x float> %f2, metadata !"ult",
                                               metadata !"fpexcept.strict") #0
  %res = select <4 x i1> %cond, <4 x i32> %a, <4 x i32> %b
  ret <4 x i32> %res
}

define <4 x i32> @test_v4f32_ule_s(<4 x i32> %a, <4 x i32> %b, <4 x float> %f1, <4 x float> %f2) #0 {
; SSE-32-LABEL: test_v4f32_ule_s:
; SSE-32:       # %bb.0:
; SSE-32-NEXT:    pushl %ebp
; SSE-32-NEXT:    movl %esp, %ebp
; SSE-32-NEXT:    andl $-16, %esp
; SSE-32-NEXT:    subl $16, %esp
; SSE-32-NEXT:    movaps 8(%ebp), %xmm3
; SSE-32-NEXT:    cmpnltps %xmm2, %xmm3
; SSE-32-NEXT:    andps %xmm3, %xmm0
; SSE-32-NEXT:    andnps %xmm1, %xmm3
; SSE-32-NEXT:    orps %xmm3, %xmm0
; SSE-32-NEXT:    movl %ebp, %esp
; SSE-32-NEXT:    popl %ebp
; SSE-32-NEXT:    retl
;
; SSE-64-LABEL: test_v4f32_ule_s:
; SSE-64:       # %bb.0:
; SSE-64-NEXT:    cmpnltps %xmm2, %xmm3
; SSE-64-NEXT:    andps %xmm3, %xmm0
; SSE-64-NEXT:    andnps %xmm1, %xmm3
; SSE-64-NEXT:    orps %xmm3, %xmm0
; SSE-64-NEXT:    retq
;
; AVX-32-LABEL: test_v4f32_ule_s:
; AVX-32:       # %bb.0:
; AVX-32-NEXT:    pushl %ebp
; AVX-32-NEXT:    movl %esp, %ebp
; AVX-32-NEXT:    andl $-16, %esp
; AVX-32-NEXT:    subl $16, %esp
; AVX-32-NEXT:    vmovaps 8(%ebp), %xmm3
; AVX-32-NEXT:    vcmpnltps %xmm2, %xmm3, %xmm2
; AVX-32-NEXT:    vblendvps %xmm2, %xmm0, %xmm1, %xmm0
; AVX-32-NEXT:    movl %ebp, %esp
; AVX-32-NEXT:    popl %ebp
; AVX-32-NEXT:    retl
;
; AVX-64-LABEL: test_v4f32_ule_s:
; AVX-64:       # %bb.0:
; AVX-64-NEXT:    vcmpnltps %xmm2, %xmm3, %xmm2
; AVX-64-NEXT:    vblendvps %xmm2, %xmm0, %xmm1, %xmm0
; AVX-64-NEXT:    retq
;
; AVX512-32-LABEL: test_v4f32_ule_s:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-16, %esp
; AVX512-32-NEXT:    subl $16, %esp
; AVX512-32-NEXT:    vcmpngtps 8(%ebp), %xmm2, %k1
; AVX512-32-NEXT:    vpblendmd %xmm0, %xmm1, %xmm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v4f32_ule_s:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmpnltps %xmm2, %xmm3, %k1
; AVX512-64-NEXT:    vpblendmd %xmm0, %xmm1, %xmm0 {%k1}
; AVX512-64-NEXT:    retq
;
; AVX512F-32-LABEL: test_v4f32_ule_s:
; AVX512F-32:       # %bb.0:
; AVX512F-32-NEXT:    pushl %ebp
; AVX512F-32-NEXT:    movl %esp, %ebp
; AVX512F-32-NEXT:    andl $-16, %esp
; AVX512F-32-NEXT:    subl $16, %esp
; AVX512F-32-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-32-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-32-NEXT:    vmovaps 8(%ebp), %xmm3
; AVX512F-32-NEXT:    vcmpnltps %xmm2, %xmm3, %xmm2
; AVX512F-32-NEXT:    vptestmd %zmm2, %zmm2, %k1
; AVX512F-32-NEXT:    vpblendmd %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-32-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-32-NEXT:    movl %ebp, %esp
; AVX512F-32-NEXT:    popl %ebp
; AVX512F-32-NEXT:    vzeroupper
; AVX512F-32-NEXT:    retl
;
; AVX512F-64-LABEL: test_v4f32_ule_s:
; AVX512F-64:       # %bb.0:
; AVX512F-64-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-64-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-64-NEXT:    vcmpnltps %xmm2, %xmm3, %xmm2
; AVX512F-64-NEXT:    vptestmd %zmm2, %zmm2, %k1
; AVX512F-64-NEXT:    vpblendmd %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-64-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-64-NEXT:    vzeroupper
; AVX512F-64-NEXT:    retq
  %cond = call <4 x i1> @llvm.experimental.constrained.fcmps.v4f32(
                                               <4 x float> %f1, <4 x float> %f2, metadata !"ule",
                                               metadata !"fpexcept.strict") #0
  %res = select <4 x i1> %cond, <4 x i32> %a, <4 x i32> %b
  ret <4 x i32> %res
}

define <4 x i32> @test_v4f32_une_s(<4 x i32> %a, <4 x i32> %b, <4 x float> %f1, <4 x float> %f2) #0 {
; SSE-32-LABEL: test_v4f32_une_s:
; SSE-32:       # %bb.0:
; SSE-32-NEXT:    pushl %ebp
; SSE-32-NEXT:    movl %esp, %ebp
; SSE-32-NEXT:    andl $-16, %esp
; SSE-32-NEXT:    subl $16, %esp
; SSE-32-NEXT:    movaps 8(%ebp), %xmm3
; SSE-32-NEXT:    movaps %xmm2, %xmm4
; SSE-32-NEXT:    cmpltps %xmm3, %xmm4
; SSE-32-NEXT:    cmpneqps %xmm3, %xmm2
; SSE-32-NEXT:    andps %xmm2, %xmm0
; SSE-32-NEXT:    andnps %xmm1, %xmm2
; SSE-32-NEXT:    orps %xmm2, %xmm0
; SSE-32-NEXT:    movl %ebp, %esp
; SSE-32-NEXT:    popl %ebp
; SSE-32-NEXT:    retl
;
; SSE-64-LABEL: test_v4f32_une_s:
; SSE-64:       # %bb.0:
; SSE-64-NEXT:    movaps %xmm2, %xmm4
; SSE-64-NEXT:    cmpltps %xmm3, %xmm4
; SSE-64-NEXT:    cmpneqps %xmm3, %xmm2
; SSE-64-NEXT:    andps %xmm2, %xmm0
; SSE-64-NEXT:    andnps %xmm1, %xmm2
; SSE-64-NEXT:    orps %xmm2, %xmm0
; SSE-64-NEXT:    retq
;
; AVX-32-LABEL: test_v4f32_une_s:
; AVX-32:       # %bb.0:
; AVX-32-NEXT:    pushl %ebp
; AVX-32-NEXT:    movl %esp, %ebp
; AVX-32-NEXT:    andl $-16, %esp
; AVX-32-NEXT:    subl $16, %esp
; AVX-32-NEXT:    vcmpneq_usps 8(%ebp), %xmm2, %xmm2
; AVX-32-NEXT:    vblendvps %xmm2, %xmm0, %xmm1, %xmm0
; AVX-32-NEXT:    movl %ebp, %esp
; AVX-32-NEXT:    popl %ebp
; AVX-32-NEXT:    retl
;
; AVX-64-LABEL: test_v4f32_une_s:
; AVX-64:       # %bb.0:
; AVX-64-NEXT:    vcmpneq_usps %xmm3, %xmm2, %xmm2
; AVX-64-NEXT:    vblendvps %xmm2, %xmm0, %xmm1, %xmm0
; AVX-64-NEXT:    retq
;
; AVX512-32-LABEL: test_v4f32_une_s:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-16, %esp
; AVX512-32-NEXT:    subl $16, %esp
; AVX512-32-NEXT:    vcmpneq_usps 8(%ebp), %xmm2, %k1
; AVX512-32-NEXT:    vpblendmd %xmm0, %xmm1, %xmm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v4f32_une_s:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmpneq_usps %xmm3, %xmm2, %k1
; AVX512-64-NEXT:    vpblendmd %xmm0, %xmm1, %xmm0 {%k1}
; AVX512-64-NEXT:    retq
;
; AVX512F-32-LABEL: test_v4f32_une_s:
; AVX512F-32:       # %bb.0:
; AVX512F-32-NEXT:    pushl %ebp
; AVX512F-32-NEXT:    movl %esp, %ebp
; AVX512F-32-NEXT:    andl $-16, %esp
; AVX512F-32-NEXT:    subl $16, %esp
; AVX512F-32-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-32-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-32-NEXT:    vcmpneq_usps 8(%ebp), %xmm2, %xmm2
; AVX512F-32-NEXT:    vptestmd %zmm2, %zmm2, %k1
; AVX512F-32-NEXT:    vpblendmd %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-32-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-32-NEXT:    movl %ebp, %esp
; AVX512F-32-NEXT:    popl %ebp
; AVX512F-32-NEXT:    vzeroupper
; AVX512F-32-NEXT:    retl
;
; AVX512F-64-LABEL: test_v4f32_une_s:
; AVX512F-64:       # %bb.0:
; AVX512F-64-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-64-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-64-NEXT:    vcmpneq_usps %xmm3, %xmm2, %xmm2
; AVX512F-64-NEXT:    vptestmd %zmm2, %zmm2, %k1
; AVX512F-64-NEXT:    vpblendmd %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-64-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-64-NEXT:    vzeroupper
; AVX512F-64-NEXT:    retq
  %cond = call <4 x i1> @llvm.experimental.constrained.fcmps.v4f32(
                                               <4 x float> %f1, <4 x float> %f2, metadata !"une",
                                               metadata !"fpexcept.strict") #0
  %res = select <4 x i1> %cond, <4 x i32> %a, <4 x i32> %b
  ret <4 x i32> %res
}

define <4 x i32> @test_v4f32_uno_s(<4 x i32> %a, <4 x i32> %b, <4 x float> %f1, <4 x float> %f2) #0 {
; SSE-32-LABEL: test_v4f32_uno_s:
; SSE-32:       # %bb.0:
; SSE-32-NEXT:    pushl %ebp
; SSE-32-NEXT:    movl %esp, %ebp
; SSE-32-NEXT:    andl $-16, %esp
; SSE-32-NEXT:    subl $16, %esp
; SSE-32-NEXT:    movaps 8(%ebp), %xmm3
; SSE-32-NEXT:    movaps %xmm2, %xmm4
; SSE-32-NEXT:    cmpltps %xmm3, %xmm4
; SSE-32-NEXT:    cmpunordps %xmm3, %xmm2
; SSE-32-NEXT:    andps %xmm2, %xmm0
; SSE-32-NEXT:    andnps %xmm1, %xmm2
; SSE-32-NEXT:    orps %xmm2, %xmm0
; SSE-32-NEXT:    movl %ebp, %esp
; SSE-32-NEXT:    popl %ebp
; SSE-32-NEXT:    retl
;
; SSE-64-LABEL: test_v4f32_uno_s:
; SSE-64:       # %bb.0:
; SSE-64-NEXT:    movaps %xmm2, %xmm4
; SSE-64-NEXT:    cmpltps %xmm3, %xmm4
; SSE-64-NEXT:    cmpunordps %xmm3, %xmm2
; SSE-64-NEXT:    andps %xmm2, %xmm0
; SSE-64-NEXT:    andnps %xmm1, %xmm2
; SSE-64-NEXT:    orps %xmm2, %xmm0
; SSE-64-NEXT:    retq
;
; AVX-32-LABEL: test_v4f32_uno_s:
; AVX-32:       # %bb.0:
; AVX-32-NEXT:    pushl %ebp
; AVX-32-NEXT:    movl %esp, %ebp
; AVX-32-NEXT:    andl $-16, %esp
; AVX-32-NEXT:    subl $16, %esp
; AVX-32-NEXT:    vcmpunord_sps 8(%ebp), %xmm2, %xmm2
; AVX-32-NEXT:    vblendvps %xmm2, %xmm0, %xmm1, %xmm0
; AVX-32-NEXT:    movl %ebp, %esp
; AVX-32-NEXT:    popl %ebp
; AVX-32-NEXT:    retl
;
; AVX-64-LABEL: test_v4f32_uno_s:
; AVX-64:       # %bb.0:
; AVX-64-NEXT:    vcmpunord_sps %xmm3, %xmm2, %xmm2
; AVX-64-NEXT:    vblendvps %xmm2, %xmm0, %xmm1, %xmm0
; AVX-64-NEXT:    retq
;
; AVX512-32-LABEL: test_v4f32_uno_s:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-16, %esp
; AVX512-32-NEXT:    subl $16, %esp
; AVX512-32-NEXT:    vcmpunord_sps 8(%ebp), %xmm2, %k1
; AVX512-32-NEXT:    vpblendmd %xmm0, %xmm1, %xmm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v4f32_uno_s:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmpunord_sps %xmm3, %xmm2, %k1
; AVX512-64-NEXT:    vpblendmd %xmm0, %xmm1, %xmm0 {%k1}
; AVX512-64-NEXT:    retq
;
; AVX512F-32-LABEL: test_v4f32_uno_s:
; AVX512F-32:       # %bb.0:
; AVX512F-32-NEXT:    pushl %ebp
; AVX512F-32-NEXT:    movl %esp, %ebp
; AVX512F-32-NEXT:    andl $-16, %esp
; AVX512F-32-NEXT:    subl $16, %esp
; AVX512F-32-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-32-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-32-NEXT:    vcmpunord_sps 8(%ebp), %xmm2, %xmm2
; AVX512F-32-NEXT:    vptestmd %zmm2, %zmm2, %k1
; AVX512F-32-NEXT:    vpblendmd %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-32-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-32-NEXT:    movl %ebp, %esp
; AVX512F-32-NEXT:    popl %ebp
; AVX512F-32-NEXT:    vzeroupper
; AVX512F-32-NEXT:    retl
;
; AVX512F-64-LABEL: test_v4f32_uno_s:
; AVX512F-64:       # %bb.0:
; AVX512F-64-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-64-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-64-NEXT:    vcmpunord_sps %xmm3, %xmm2, %xmm2
; AVX512F-64-NEXT:    vptestmd %zmm2, %zmm2, %k1
; AVX512F-64-NEXT:    vpblendmd %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-64-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-64-NEXT:    vzeroupper
; AVX512F-64-NEXT:    retq
  %cond = call <4 x i1> @llvm.experimental.constrained.fcmps.v4f32(
                                               <4 x float> %f1, <4 x float> %f2, metadata !"uno",
                                               metadata !"fpexcept.strict") #0
  %res = select <4 x i1> %cond, <4 x i32> %a, <4 x i32> %b
  ret <4 x i32> %res
}

define <2 x i64> @test_v2f64_oeq_s(<2 x i64> %a, <2 x i64> %b, <2 x double> %f1, <2 x double> %f2) #0 {
; SSE-32-LABEL: test_v2f64_oeq_s:
; SSE-32:       # %bb.0:
; SSE-32-NEXT:    pushl %ebp
; SSE-32-NEXT:    movl %esp, %ebp
; SSE-32-NEXT:    andl $-16, %esp
; SSE-32-NEXT:    subl $16, %esp
; SSE-32-NEXT:    movapd 8(%ebp), %xmm3
; SSE-32-NEXT:    movapd %xmm2, %xmm4
; SSE-32-NEXT:    cmpltpd %xmm3, %xmm4
; SSE-32-NEXT:    cmpeqpd %xmm3, %xmm2
; SSE-32-NEXT:    andpd %xmm2, %xmm0
; SSE-32-NEXT:    andnpd %xmm1, %xmm2
; SSE-32-NEXT:    orpd %xmm2, %xmm0
; SSE-32-NEXT:    movl %ebp, %esp
; SSE-32-NEXT:    popl %ebp
; SSE-32-NEXT:    retl
;
; SSE-64-LABEL: test_v2f64_oeq_s:
; SSE-64:       # %bb.0:
; SSE-64-NEXT:    movapd %xmm2, %xmm4
; SSE-64-NEXT:    cmpltpd %xmm3, %xmm4
; SSE-64-NEXT:    cmpeqpd %xmm3, %xmm2
; SSE-64-NEXT:    andpd %xmm2, %xmm0
; SSE-64-NEXT:    andnpd %xmm1, %xmm2
; SSE-64-NEXT:    orpd %xmm2, %xmm0
; SSE-64-NEXT:    retq
;
; AVX-32-LABEL: test_v2f64_oeq_s:
; AVX-32:       # %bb.0:
; AVX-32-NEXT:    pushl %ebp
; AVX-32-NEXT:    movl %esp, %ebp
; AVX-32-NEXT:    andl $-16, %esp
; AVX-32-NEXT:    subl $16, %esp
; AVX-32-NEXT:    vcmpeq_ospd 8(%ebp), %xmm2, %xmm2
; AVX-32-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; AVX-32-NEXT:    movl %ebp, %esp
; AVX-32-NEXT:    popl %ebp
; AVX-32-NEXT:    retl
;
; AVX-64-LABEL: test_v2f64_oeq_s:
; AVX-64:       # %bb.0:
; AVX-64-NEXT:    vcmpeq_ospd %xmm3, %xmm2, %xmm2
; AVX-64-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; AVX-64-NEXT:    retq
;
; AVX512-32-LABEL: test_v2f64_oeq_s:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-16, %esp
; AVX512-32-NEXT:    subl $16, %esp
; AVX512-32-NEXT:    vcmpeq_ospd 8(%ebp), %xmm2, %k1
; AVX512-32-NEXT:    vpblendmq %xmm0, %xmm1, %xmm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v2f64_oeq_s:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmpeq_ospd %xmm3, %xmm2, %k1
; AVX512-64-NEXT:    vpblendmq %xmm0, %xmm1, %xmm0 {%k1}
; AVX512-64-NEXT:    retq
;
; AVX512F-32-LABEL: test_v2f64_oeq_s:
; AVX512F-32:       # %bb.0:
; AVX512F-32-NEXT:    pushl %ebp
; AVX512F-32-NEXT:    movl %esp, %ebp
; AVX512F-32-NEXT:    andl $-16, %esp
; AVX512F-32-NEXT:    subl $16, %esp
; AVX512F-32-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-32-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-32-NEXT:    vcmpeq_ospd 8(%ebp), %xmm2, %xmm2
; AVX512F-32-NEXT:    vptestmq %zmm2, %zmm2, %k1
; AVX512F-32-NEXT:    vpblendmq %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-32-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-32-NEXT:    movl %ebp, %esp
; AVX512F-32-NEXT:    popl %ebp
; AVX512F-32-NEXT:    vzeroupper
; AVX512F-32-NEXT:    retl
;
; AVX512F-64-LABEL: test_v2f64_oeq_s:
; AVX512F-64:       # %bb.0:
; AVX512F-64-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-64-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-64-NEXT:    vcmpeq_ospd %xmm3, %xmm2, %xmm2
; AVX512F-64-NEXT:    vptestmq %zmm2, %zmm2, %k1
; AVX512F-64-NEXT:    vpblendmq %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-64-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-64-NEXT:    vzeroupper
; AVX512F-64-NEXT:    retq
  %cond = call <2 x i1> @llvm.experimental.constrained.fcmps.v2f64(
                                               <2 x double> %f1, <2 x double> %f2, metadata !"oeq",
                                               metadata !"fpexcept.strict") #0
  %res = select <2 x i1> %cond, <2 x i64> %a, <2 x i64> %b
  ret <2 x i64> %res
}

define <2 x i64> @test_v2f64_ogt_s(<2 x i64> %a, <2 x i64> %b, <2 x double> %f1, <2 x double> %f2) #0 {
; SSE-32-LABEL: test_v2f64_ogt_s:
; SSE-32:       # %bb.0:
; SSE-32-NEXT:    pushl %ebp
; SSE-32-NEXT:    movl %esp, %ebp
; SSE-32-NEXT:    andl $-16, %esp
; SSE-32-NEXT:    subl $16, %esp
; SSE-32-NEXT:    movapd 8(%ebp), %xmm3
; SSE-32-NEXT:    cmpltpd %xmm2, %xmm3
; SSE-32-NEXT:    andpd %xmm3, %xmm0
; SSE-32-NEXT:    andnpd %xmm1, %xmm3
; SSE-32-NEXT:    orpd %xmm3, %xmm0
; SSE-32-NEXT:    movl %ebp, %esp
; SSE-32-NEXT:    popl %ebp
; SSE-32-NEXT:    retl
;
; SSE-64-LABEL: test_v2f64_ogt_s:
; SSE-64:       # %bb.0:
; SSE-64-NEXT:    cmpltpd %xmm2, %xmm3
; SSE-64-NEXT:    andpd %xmm3, %xmm0
; SSE-64-NEXT:    andnpd %xmm1, %xmm3
; SSE-64-NEXT:    orpd %xmm3, %xmm0
; SSE-64-NEXT:    retq
;
; AVX-32-LABEL: test_v2f64_ogt_s:
; AVX-32:       # %bb.0:
; AVX-32-NEXT:    pushl %ebp
; AVX-32-NEXT:    movl %esp, %ebp
; AVX-32-NEXT:    andl $-16, %esp
; AVX-32-NEXT:    subl $16, %esp
; AVX-32-NEXT:    vmovapd 8(%ebp), %xmm3
; AVX-32-NEXT:    vcmpltpd %xmm2, %xmm3, %xmm2
; AVX-32-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; AVX-32-NEXT:    movl %ebp, %esp
; AVX-32-NEXT:    popl %ebp
; AVX-32-NEXT:    retl
;
; AVX-64-LABEL: test_v2f64_ogt_s:
; AVX-64:       # %bb.0:
; AVX-64-NEXT:    vcmpltpd %xmm2, %xmm3, %xmm2
; AVX-64-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; AVX-64-NEXT:    retq
;
; AVX512-32-LABEL: test_v2f64_ogt_s:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-16, %esp
; AVX512-32-NEXT:    subl $16, %esp
; AVX512-32-NEXT:    vcmpgtpd 8(%ebp), %xmm2, %k1
; AVX512-32-NEXT:    vpblendmq %xmm0, %xmm1, %xmm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v2f64_ogt_s:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmpltpd %xmm2, %xmm3, %k1
; AVX512-64-NEXT:    vpblendmq %xmm0, %xmm1, %xmm0 {%k1}
; AVX512-64-NEXT:    retq
;
; AVX512F-32-LABEL: test_v2f64_ogt_s:
; AVX512F-32:       # %bb.0:
; AVX512F-32-NEXT:    pushl %ebp
; AVX512F-32-NEXT:    movl %esp, %ebp
; AVX512F-32-NEXT:    andl $-16, %esp
; AVX512F-32-NEXT:    subl $16, %esp
; AVX512F-32-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-32-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-32-NEXT:    vmovapd 8(%ebp), %xmm3
; AVX512F-32-NEXT:    vcmpltpd %xmm2, %xmm3, %xmm2
; AVX512F-32-NEXT:    vptestmq %zmm2, %zmm2, %k1
; AVX512F-32-NEXT:    vpblendmq %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-32-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-32-NEXT:    movl %ebp, %esp
; AVX512F-32-NEXT:    popl %ebp
; AVX512F-32-NEXT:    vzeroupper
; AVX512F-32-NEXT:    retl
;
; AVX512F-64-LABEL: test_v2f64_ogt_s:
; AVX512F-64:       # %bb.0:
; AVX512F-64-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-64-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-64-NEXT:    vcmpltpd %xmm2, %xmm3, %xmm2
; AVX512F-64-NEXT:    vptestmq %zmm2, %zmm2, %k1
; AVX512F-64-NEXT:    vpblendmq %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-64-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-64-NEXT:    vzeroupper
; AVX512F-64-NEXT:    retq
  %cond = call <2 x i1> @llvm.experimental.constrained.fcmps.v2f64(
                                               <2 x double> %f1, <2 x double> %f2, metadata !"ogt",
                                               metadata !"fpexcept.strict") #0
  %res = select <2 x i1> %cond, <2 x i64> %a, <2 x i64> %b
  ret <2 x i64> %res
}

define <2 x i64> @test_v2f64_oge_s(<2 x i64> %a, <2 x i64> %b, <2 x double> %f1, <2 x double> %f2) #0 {
; SSE-32-LABEL: test_v2f64_oge_s:
; SSE-32:       # %bb.0:
; SSE-32-NEXT:    pushl %ebp
; SSE-32-NEXT:    movl %esp, %ebp
; SSE-32-NEXT:    andl $-16, %esp
; SSE-32-NEXT:    subl $16, %esp
; SSE-32-NEXT:    movapd 8(%ebp), %xmm3
; SSE-32-NEXT:    cmplepd %xmm2, %xmm3
; SSE-32-NEXT:    andpd %xmm3, %xmm0
; SSE-32-NEXT:    andnpd %xmm1, %xmm3
; SSE-32-NEXT:    orpd %xmm3, %xmm0
; SSE-32-NEXT:    movl %ebp, %esp
; SSE-32-NEXT:    popl %ebp
; SSE-32-NEXT:    retl
;
; SSE-64-LABEL: test_v2f64_oge_s:
; SSE-64:       # %bb.0:
; SSE-64-NEXT:    cmplepd %xmm2, %xmm3
; SSE-64-NEXT:    andpd %xmm3, %xmm0
; SSE-64-NEXT:    andnpd %xmm1, %xmm3
; SSE-64-NEXT:    orpd %xmm3, %xmm0
; SSE-64-NEXT:    retq
;
; AVX-32-LABEL: test_v2f64_oge_s:
; AVX-32:       # %bb.0:
; AVX-32-NEXT:    pushl %ebp
; AVX-32-NEXT:    movl %esp, %ebp
; AVX-32-NEXT:    andl $-16, %esp
; AVX-32-NEXT:    subl $16, %esp
; AVX-32-NEXT:    vmovapd 8(%ebp), %xmm3
; AVX-32-NEXT:    vcmplepd %xmm2, %xmm3, %xmm2
; AVX-32-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; AVX-32-NEXT:    movl %ebp, %esp
; AVX-32-NEXT:    popl %ebp
; AVX-32-NEXT:    retl
;
; AVX-64-LABEL: test_v2f64_oge_s:
; AVX-64:       # %bb.0:
; AVX-64-NEXT:    vcmplepd %xmm2, %xmm3, %xmm2
; AVX-64-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; AVX-64-NEXT:    retq
;
; AVX512-32-LABEL: test_v2f64_oge_s:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-16, %esp
; AVX512-32-NEXT:    subl $16, %esp
; AVX512-32-NEXT:    vcmpgepd 8(%ebp), %xmm2, %k1
; AVX512-32-NEXT:    vpblendmq %xmm0, %xmm1, %xmm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v2f64_oge_s:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmplepd %xmm2, %xmm3, %k1
; AVX512-64-NEXT:    vpblendmq %xmm0, %xmm1, %xmm0 {%k1}
; AVX512-64-NEXT:    retq
;
; AVX512F-32-LABEL: test_v2f64_oge_s:
; AVX512F-32:       # %bb.0:
; AVX512F-32-NEXT:    pushl %ebp
; AVX512F-32-NEXT:    movl %esp, %ebp
; AVX512F-32-NEXT:    andl $-16, %esp
; AVX512F-32-NEXT:    subl $16, %esp
; AVX512F-32-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-32-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-32-NEXT:    vmovapd 8(%ebp), %xmm3
; AVX512F-32-NEXT:    vcmplepd %xmm2, %xmm3, %xmm2
; AVX512F-32-NEXT:    vptestmq %zmm2, %zmm2, %k1
; AVX512F-32-NEXT:    vpblendmq %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-32-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-32-NEXT:    movl %ebp, %esp
; AVX512F-32-NEXT:    popl %ebp
; AVX512F-32-NEXT:    vzeroupper
; AVX512F-32-NEXT:    retl
;
; AVX512F-64-LABEL: test_v2f64_oge_s:
; AVX512F-64:       # %bb.0:
; AVX512F-64-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-64-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-64-NEXT:    vcmplepd %xmm2, %xmm3, %xmm2
; AVX512F-64-NEXT:    vptestmq %zmm2, %zmm2, %k1
; AVX512F-64-NEXT:    vpblendmq %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-64-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-64-NEXT:    vzeroupper
; AVX512F-64-NEXT:    retq
  %cond = call <2 x i1> @llvm.experimental.constrained.fcmps.v2f64(
                                               <2 x double> %f1, <2 x double> %f2, metadata !"oge",
                                               metadata !"fpexcept.strict") #0
  %res = select <2 x i1> %cond, <2 x i64> %a, <2 x i64> %b
  ret <2 x i64> %res
}

define <2 x i64> @test_v2f64_olt_s(<2 x i64> %a, <2 x i64> %b, <2 x double> %f1, <2 x double> %f2) #0 {
; SSE-32-LABEL: test_v2f64_olt_s:
; SSE-32:       # %bb.0:
; SSE-32-NEXT:    pushl %ebp
; SSE-32-NEXT:    movl %esp, %ebp
; SSE-32-NEXT:    andl $-16, %esp
; SSE-32-NEXT:    subl $16, %esp
; SSE-32-NEXT:    cmpltpd 8(%ebp), %xmm2
; SSE-32-NEXT:    andpd %xmm2, %xmm0
; SSE-32-NEXT:    andnpd %xmm1, %xmm2
; SSE-32-NEXT:    orpd %xmm2, %xmm0
; SSE-32-NEXT:    movl %ebp, %esp
; SSE-32-NEXT:    popl %ebp
; SSE-32-NEXT:    retl
;
; SSE-64-LABEL: test_v2f64_olt_s:
; SSE-64:       # %bb.0:
; SSE-64-NEXT:    cmpltpd %xmm3, %xmm2
; SSE-64-NEXT:    andpd %xmm2, %xmm0
; SSE-64-NEXT:    andnpd %xmm1, %xmm2
; SSE-64-NEXT:    orpd %xmm2, %xmm0
; SSE-64-NEXT:    retq
;
; AVX-32-LABEL: test_v2f64_olt_s:
; AVX-32:       # %bb.0:
; AVX-32-NEXT:    pushl %ebp
; AVX-32-NEXT:    movl %esp, %ebp
; AVX-32-NEXT:    andl $-16, %esp
; AVX-32-NEXT:    subl $16, %esp
; AVX-32-NEXT:    vcmpltpd 8(%ebp), %xmm2, %xmm2
; AVX-32-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; AVX-32-NEXT:    movl %ebp, %esp
; AVX-32-NEXT:    popl %ebp
; AVX-32-NEXT:    retl
;
; AVX-64-LABEL: test_v2f64_olt_s:
; AVX-64:       # %bb.0:
; AVX-64-NEXT:    vcmpltpd %xmm3, %xmm2, %xmm2
; AVX-64-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; AVX-64-NEXT:    retq
;
; AVX512-32-LABEL: test_v2f64_olt_s:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-16, %esp
; AVX512-32-NEXT:    subl $16, %esp
; AVX512-32-NEXT:    vcmpltpd 8(%ebp), %xmm2, %k1
; AVX512-32-NEXT:    vpblendmq %xmm0, %xmm1, %xmm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v2f64_olt_s:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmpltpd %xmm3, %xmm2, %k1
; AVX512-64-NEXT:    vpblendmq %xmm0, %xmm1, %xmm0 {%k1}
; AVX512-64-NEXT:    retq
;
; AVX512F-32-LABEL: test_v2f64_olt_s:
; AVX512F-32:       # %bb.0:
; AVX512F-32-NEXT:    pushl %ebp
; AVX512F-32-NEXT:    movl %esp, %ebp
; AVX512F-32-NEXT:    andl $-16, %esp
; AVX512F-32-NEXT:    subl $16, %esp
; AVX512F-32-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-32-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-32-NEXT:    vcmpltpd 8(%ebp), %xmm2, %xmm2
; AVX512F-32-NEXT:    vptestmq %zmm2, %zmm2, %k1
; AVX512F-32-NEXT:    vpblendmq %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-32-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-32-NEXT:    movl %ebp, %esp
; AVX512F-32-NEXT:    popl %ebp
; AVX512F-32-NEXT:    vzeroupper
; AVX512F-32-NEXT:    retl
;
; AVX512F-64-LABEL: test_v2f64_olt_s:
; AVX512F-64:       # %bb.0:
; AVX512F-64-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-64-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-64-NEXT:    vcmpltpd %xmm3, %xmm2, %xmm2
; AVX512F-64-NEXT:    vptestmq %zmm2, %zmm2, %k1
; AVX512F-64-NEXT:    vpblendmq %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-64-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-64-NEXT:    vzeroupper
; AVX512F-64-NEXT:    retq
  %cond = call <2 x i1> @llvm.experimental.constrained.fcmps.v2f64(
                                               <2 x double> %f1, <2 x double> %f2, metadata !"olt",
                                               metadata !"fpexcept.strict") #0
  %res = select <2 x i1> %cond, <2 x i64> %a, <2 x i64> %b
  ret <2 x i64> %res
}

define <2 x i64> @test_v2f64_ole_s(<2 x i64> %a, <2 x i64> %b, <2 x double> %f1, <2 x double> %f2) #0 {
; SSE-32-LABEL: test_v2f64_ole_s:
; SSE-32:       # %bb.0:
; SSE-32-NEXT:    pushl %ebp
; SSE-32-NEXT:    movl %esp, %ebp
; SSE-32-NEXT:    andl $-16, %esp
; SSE-32-NEXT:    subl $16, %esp
; SSE-32-NEXT:    cmplepd 8(%ebp), %xmm2
; SSE-32-NEXT:    andpd %xmm2, %xmm0
; SSE-32-NEXT:    andnpd %xmm1, %xmm2
; SSE-32-NEXT:    orpd %xmm2, %xmm0
; SSE-32-NEXT:    movl %ebp, %esp
; SSE-32-NEXT:    popl %ebp
; SSE-32-NEXT:    retl
;
; SSE-64-LABEL: test_v2f64_ole_s:
; SSE-64:       # %bb.0:
; SSE-64-NEXT:    cmplepd %xmm3, %xmm2
; SSE-64-NEXT:    andpd %xmm2, %xmm0
; SSE-64-NEXT:    andnpd %xmm1, %xmm2
; SSE-64-NEXT:    orpd %xmm2, %xmm0
; SSE-64-NEXT:    retq
;
; AVX-32-LABEL: test_v2f64_ole_s:
; AVX-32:       # %bb.0:
; AVX-32-NEXT:    pushl %ebp
; AVX-32-NEXT:    movl %esp, %ebp
; AVX-32-NEXT:    andl $-16, %esp
; AVX-32-NEXT:    subl $16, %esp
; AVX-32-NEXT:    vcmplepd 8(%ebp), %xmm2, %xmm2
; AVX-32-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; AVX-32-NEXT:    movl %ebp, %esp
; AVX-32-NEXT:    popl %ebp
; AVX-32-NEXT:    retl
;
; AVX-64-LABEL: test_v2f64_ole_s:
; AVX-64:       # %bb.0:
; AVX-64-NEXT:    vcmplepd %xmm3, %xmm2, %xmm2
; AVX-64-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; AVX-64-NEXT:    retq
;
; AVX512-32-LABEL: test_v2f64_ole_s:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-16, %esp
; AVX512-32-NEXT:    subl $16, %esp
; AVX512-32-NEXT:    vcmplepd 8(%ebp), %xmm2, %k1
; AVX512-32-NEXT:    vpblendmq %xmm0, %xmm1, %xmm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v2f64_ole_s:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmplepd %xmm3, %xmm2, %k1
; AVX512-64-NEXT:    vpblendmq %xmm0, %xmm1, %xmm0 {%k1}
; AVX512-64-NEXT:    retq
;
; AVX512F-32-LABEL: test_v2f64_ole_s:
; AVX512F-32:       # %bb.0:
; AVX512F-32-NEXT:    pushl %ebp
; AVX512F-32-NEXT:    movl %esp, %ebp
; AVX512F-32-NEXT:    andl $-16, %esp
; AVX512F-32-NEXT:    subl $16, %esp
; AVX512F-32-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-32-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-32-NEXT:    vcmplepd 8(%ebp), %xmm2, %xmm2
; AVX512F-32-NEXT:    vptestmq %zmm2, %zmm2, %k1
; AVX512F-32-NEXT:    vpblendmq %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-32-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-32-NEXT:    movl %ebp, %esp
; AVX512F-32-NEXT:    popl %ebp
; AVX512F-32-NEXT:    vzeroupper
; AVX512F-32-NEXT:    retl
;
; AVX512F-64-LABEL: test_v2f64_ole_s:
; AVX512F-64:       # %bb.0:
; AVX512F-64-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-64-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-64-NEXT:    vcmplepd %xmm3, %xmm2, %xmm2
; AVX512F-64-NEXT:    vptestmq %zmm2, %zmm2, %k1
; AVX512F-64-NEXT:    vpblendmq %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-64-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-64-NEXT:    vzeroupper
; AVX512F-64-NEXT:    retq
  %cond = call <2 x i1> @llvm.experimental.constrained.fcmps.v2f64(
                                               <2 x double> %f1, <2 x double> %f2, metadata !"ole",
                                               metadata !"fpexcept.strict") #0
  %res = select <2 x i1> %cond, <2 x i64> %a, <2 x i64> %b
  ret <2 x i64> %res
}

define <2 x i64> @test_v2f64_one_s(<2 x i64> %a, <2 x i64> %b, <2 x double> %f1, <2 x double> %f2) #0 {
; SSE-32-LABEL: test_v2f64_one_s:
; SSE-32:       # %bb.0:
; SSE-32-NEXT:    pushl %ebp
; SSE-32-NEXT:    movl %esp, %ebp
; SSE-32-NEXT:    andl $-16, %esp
; SSE-32-NEXT:    subl $16, %esp
; SSE-32-NEXT:    movapd 8(%ebp), %xmm3
; SSE-32-NEXT:    movapd %xmm2, %xmm4
; SSE-32-NEXT:    cmpltpd %xmm3, %xmm4
; SSE-32-NEXT:    movapd %xmm2, %xmm4
; SSE-32-NEXT:    cmpneqpd %xmm3, %xmm4
; SSE-32-NEXT:    cmpordpd %xmm3, %xmm2
; SSE-32-NEXT:    andpd %xmm4, %xmm2
; SSE-32-NEXT:    andpd %xmm2, %xmm0
; SSE-32-NEXT:    andnpd %xmm1, %xmm2
; SSE-32-NEXT:    orpd %xmm2, %xmm0
; SSE-32-NEXT:    movl %ebp, %esp
; SSE-32-NEXT:    popl %ebp
; SSE-32-NEXT:    retl
;
; SSE-64-LABEL: test_v2f64_one_s:
; SSE-64:       # %bb.0:
; SSE-64-NEXT:    movapd %xmm2, %xmm4
; SSE-64-NEXT:    cmpltpd %xmm3, %xmm4
; SSE-64-NEXT:    movapd %xmm2, %xmm4
; SSE-64-NEXT:    cmpneqpd %xmm3, %xmm4
; SSE-64-NEXT:    cmpordpd %xmm3, %xmm2
; SSE-64-NEXT:    andpd %xmm4, %xmm2
; SSE-64-NEXT:    andpd %xmm2, %xmm0
; SSE-64-NEXT:    andnpd %xmm1, %xmm2
; SSE-64-NEXT:    orpd %xmm2, %xmm0
; SSE-64-NEXT:    retq
;
; AVX-32-LABEL: test_v2f64_one_s:
; AVX-32:       # %bb.0:
; AVX-32-NEXT:    pushl %ebp
; AVX-32-NEXT:    movl %esp, %ebp
; AVX-32-NEXT:    andl $-16, %esp
; AVX-32-NEXT:    subl $16, %esp
; AVX-32-NEXT:    vcmpneq_ospd 8(%ebp), %xmm2, %xmm2
; AVX-32-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; AVX-32-NEXT:    movl %ebp, %esp
; AVX-32-NEXT:    popl %ebp
; AVX-32-NEXT:    retl
;
; AVX-64-LABEL: test_v2f64_one_s:
; AVX-64:       # %bb.0:
; AVX-64-NEXT:    vcmpneq_ospd %xmm3, %xmm2, %xmm2
; AVX-64-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; AVX-64-NEXT:    retq
;
; AVX512-32-LABEL: test_v2f64_one_s:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-16, %esp
; AVX512-32-NEXT:    subl $16, %esp
; AVX512-32-NEXT:    vcmpneq_ospd 8(%ebp), %xmm2, %k1
; AVX512-32-NEXT:    vpblendmq %xmm0, %xmm1, %xmm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v2f64_one_s:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmpneq_ospd %xmm3, %xmm2, %k1
; AVX512-64-NEXT:    vpblendmq %xmm0, %xmm1, %xmm0 {%k1}
; AVX512-64-NEXT:    retq
;
; AVX512F-32-LABEL: test_v2f64_one_s:
; AVX512F-32:       # %bb.0:
; AVX512F-32-NEXT:    pushl %ebp
; AVX512F-32-NEXT:    movl %esp, %ebp
; AVX512F-32-NEXT:    andl $-16, %esp
; AVX512F-32-NEXT:    subl $16, %esp
; AVX512F-32-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-32-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-32-NEXT:    vcmpneq_ospd 8(%ebp), %xmm2, %xmm2
; AVX512F-32-NEXT:    vptestmq %zmm2, %zmm2, %k1
; AVX512F-32-NEXT:    vpblendmq %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-32-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-32-NEXT:    movl %ebp, %esp
; AVX512F-32-NEXT:    popl %ebp
; AVX512F-32-NEXT:    vzeroupper
; AVX512F-32-NEXT:    retl
;
; AVX512F-64-LABEL: test_v2f64_one_s:
; AVX512F-64:       # %bb.0:
; AVX512F-64-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-64-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-64-NEXT:    vcmpneq_ospd %xmm3, %xmm2, %xmm2
; AVX512F-64-NEXT:    vptestmq %zmm2, %zmm2, %k1
; AVX512F-64-NEXT:    vpblendmq %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-64-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-64-NEXT:    vzeroupper
; AVX512F-64-NEXT:    retq
  %cond = call <2 x i1> @llvm.experimental.constrained.fcmps.v2f64(
                                               <2 x double> %f1, <2 x double> %f2, metadata !"one",
                                               metadata !"fpexcept.strict") #0
  %res = select <2 x i1> %cond, <2 x i64> %a, <2 x i64> %b
  ret <2 x i64> %res
}

define <2 x i64> @test_v2f64_ord_s(<2 x i64> %a, <2 x i64> %b, <2 x double> %f1, <2 x double> %f2) #0 {
; SSE-32-LABEL: test_v2f64_ord_s:
; SSE-32:       # %bb.0:
; SSE-32-NEXT:    pushl %ebp
; SSE-32-NEXT:    movl %esp, %ebp
; SSE-32-NEXT:    andl $-16, %esp
; SSE-32-NEXT:    subl $16, %esp
; SSE-32-NEXT:    movapd 8(%ebp), %xmm3
; SSE-32-NEXT:    movapd %xmm2, %xmm4
; SSE-32-NEXT:    cmpltpd %xmm3, %xmm4
; SSE-32-NEXT:    cmpordpd %xmm3, %xmm2
; SSE-32-NEXT:    andpd %xmm2, %xmm0
; SSE-32-NEXT:    andnpd %xmm1, %xmm2
; SSE-32-NEXT:    orpd %xmm2, %xmm0
; SSE-32-NEXT:    movl %ebp, %esp
; SSE-32-NEXT:    popl %ebp
; SSE-32-NEXT:    retl
;
; SSE-64-LABEL: test_v2f64_ord_s:
; SSE-64:       # %bb.0:
; SSE-64-NEXT:    movapd %xmm2, %xmm4
; SSE-64-NEXT:    cmpltpd %xmm3, %xmm4
; SSE-64-NEXT:    cmpordpd %xmm3, %xmm2
; SSE-64-NEXT:    andpd %xmm2, %xmm0
; SSE-64-NEXT:    andnpd %xmm1, %xmm2
; SSE-64-NEXT:    orpd %xmm2, %xmm0
; SSE-64-NEXT:    retq
;
; AVX-32-LABEL: test_v2f64_ord_s:
; AVX-32:       # %bb.0:
; AVX-32-NEXT:    pushl %ebp
; AVX-32-NEXT:    movl %esp, %ebp
; AVX-32-NEXT:    andl $-16, %esp
; AVX-32-NEXT:    subl $16, %esp
; AVX-32-NEXT:    vcmpord_spd 8(%ebp), %xmm2, %xmm2
; AVX-32-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; AVX-32-NEXT:    movl %ebp, %esp
; AVX-32-NEXT:    popl %ebp
; AVX-32-NEXT:    retl
;
; AVX-64-LABEL: test_v2f64_ord_s:
; AVX-64:       # %bb.0:
; AVX-64-NEXT:    vcmpord_spd %xmm3, %xmm2, %xmm2
; AVX-64-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; AVX-64-NEXT:    retq
;
; AVX512-32-LABEL: test_v2f64_ord_s:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-16, %esp
; AVX512-32-NEXT:    subl $16, %esp
; AVX512-32-NEXT:    vcmpord_spd 8(%ebp), %xmm2, %k1
; AVX512-32-NEXT:    vpblendmq %xmm0, %xmm1, %xmm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v2f64_ord_s:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmpord_spd %xmm3, %xmm2, %k1
; AVX512-64-NEXT:    vpblendmq %xmm0, %xmm1, %xmm0 {%k1}
; AVX512-64-NEXT:    retq
;
; AVX512F-32-LABEL: test_v2f64_ord_s:
; AVX512F-32:       # %bb.0:
; AVX512F-32-NEXT:    pushl %ebp
; AVX512F-32-NEXT:    movl %esp, %ebp
; AVX512F-32-NEXT:    andl $-16, %esp
; AVX512F-32-NEXT:    subl $16, %esp
; AVX512F-32-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-32-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-32-NEXT:    vcmpord_spd 8(%ebp), %xmm2, %xmm2
; AVX512F-32-NEXT:    vptestmq %zmm2, %zmm2, %k1
; AVX512F-32-NEXT:    vpblendmq %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-32-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-32-NEXT:    movl %ebp, %esp
; AVX512F-32-NEXT:    popl %ebp
; AVX512F-32-NEXT:    vzeroupper
; AVX512F-32-NEXT:    retl
;
; AVX512F-64-LABEL: test_v2f64_ord_s:
; AVX512F-64:       # %bb.0:
; AVX512F-64-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-64-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-64-NEXT:    vcmpord_spd %xmm3, %xmm2, %xmm2
; AVX512F-64-NEXT:    vptestmq %zmm2, %zmm2, %k1
; AVX512F-64-NEXT:    vpblendmq %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-64-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-64-NEXT:    vzeroupper
; AVX512F-64-NEXT:    retq
  %cond = call <2 x i1> @llvm.experimental.constrained.fcmps.v2f64(
                                               <2 x double> %f1, <2 x double> %f2, metadata !"ord",
                                               metadata !"fpexcept.strict") #0
  %res = select <2 x i1> %cond, <2 x i64> %a, <2 x i64> %b
  ret <2 x i64> %res
}

define <2 x i64> @test_v2f64_ueq_s(<2 x i64> %a, <2 x i64> %b, <2 x double> %f1, <2 x double> %f2) #0 {
; SSE-32-LABEL: test_v2f64_ueq_s:
; SSE-32:       # %bb.0:
; SSE-32-NEXT:    pushl %ebp
; SSE-32-NEXT:    movl %esp, %ebp
; SSE-32-NEXT:    andl $-16, %esp
; SSE-32-NEXT:    subl $16, %esp
; SSE-32-NEXT:    movapd 8(%ebp), %xmm3
; SSE-32-NEXT:    movapd %xmm2, %xmm4
; SSE-32-NEXT:    cmpltpd %xmm3, %xmm4
; SSE-32-NEXT:    movapd %xmm2, %xmm4
; SSE-32-NEXT:    cmpeqpd %xmm3, %xmm4
; SSE-32-NEXT:    cmpunordpd %xmm3, %xmm2
; SSE-32-NEXT:    orpd %xmm4, %xmm2
; SSE-32-NEXT:    andpd %xmm2, %xmm0
; SSE-32-NEXT:    andnpd %xmm1, %xmm2
; SSE-32-NEXT:    orpd %xmm2, %xmm0
; SSE-32-NEXT:    movl %ebp, %esp
; SSE-32-NEXT:    popl %ebp
; SSE-32-NEXT:    retl
;
; SSE-64-LABEL: test_v2f64_ueq_s:
; SSE-64:       # %bb.0:
; SSE-64-NEXT:    movapd %xmm2, %xmm4
; SSE-64-NEXT:    cmpltpd %xmm3, %xmm4
; SSE-64-NEXT:    movapd %xmm2, %xmm4
; SSE-64-NEXT:    cmpeqpd %xmm3, %xmm4
; SSE-64-NEXT:    cmpunordpd %xmm3, %xmm2
; SSE-64-NEXT:    orpd %xmm4, %xmm2
; SSE-64-NEXT:    andpd %xmm2, %xmm0
; SSE-64-NEXT:    andnpd %xmm1, %xmm2
; SSE-64-NEXT:    orpd %xmm2, %xmm0
; SSE-64-NEXT:    retq
;
; AVX-32-LABEL: test_v2f64_ueq_s:
; AVX-32:       # %bb.0:
; AVX-32-NEXT:    pushl %ebp
; AVX-32-NEXT:    movl %esp, %ebp
; AVX-32-NEXT:    andl $-16, %esp
; AVX-32-NEXT:    subl $16, %esp
; AVX-32-NEXT:    vcmpeq_uspd 8(%ebp), %xmm2, %xmm2
; AVX-32-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; AVX-32-NEXT:    movl %ebp, %esp
; AVX-32-NEXT:    popl %ebp
; AVX-32-NEXT:    retl
;
; AVX-64-LABEL: test_v2f64_ueq_s:
; AVX-64:       # %bb.0:
; AVX-64-NEXT:    vcmpeq_uspd %xmm3, %xmm2, %xmm2
; AVX-64-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; AVX-64-NEXT:    retq
;
; AVX512-32-LABEL: test_v2f64_ueq_s:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-16, %esp
; AVX512-32-NEXT:    subl $16, %esp
; AVX512-32-NEXT:    vcmpeq_uspd 8(%ebp), %xmm2, %k1
; AVX512-32-NEXT:    vpblendmq %xmm0, %xmm1, %xmm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v2f64_ueq_s:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmpeq_uspd %xmm3, %xmm2, %k1
; AVX512-64-NEXT:    vpblendmq %xmm0, %xmm1, %xmm0 {%k1}
; AVX512-64-NEXT:    retq
;
; AVX512F-32-LABEL: test_v2f64_ueq_s:
; AVX512F-32:       # %bb.0:
; AVX512F-32-NEXT:    pushl %ebp
; AVX512F-32-NEXT:    movl %esp, %ebp
; AVX512F-32-NEXT:    andl $-16, %esp
; AVX512F-32-NEXT:    subl $16, %esp
; AVX512F-32-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-32-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-32-NEXT:    vcmpeq_uspd 8(%ebp), %xmm2, %xmm2
; AVX512F-32-NEXT:    vptestmq %zmm2, %zmm2, %k1
; AVX512F-32-NEXT:    vpblendmq %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-32-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-32-NEXT:    movl %ebp, %esp
; AVX512F-32-NEXT:    popl %ebp
; AVX512F-32-NEXT:    vzeroupper
; AVX512F-32-NEXT:    retl
;
; AVX512F-64-LABEL: test_v2f64_ueq_s:
; AVX512F-64:       # %bb.0:
; AVX512F-64-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-64-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-64-NEXT:    vcmpeq_uspd %xmm3, %xmm2, %xmm2
; AVX512F-64-NEXT:    vptestmq %zmm2, %zmm2, %k1
; AVX512F-64-NEXT:    vpblendmq %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-64-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-64-NEXT:    vzeroupper
; AVX512F-64-NEXT:    retq
  %cond = call <2 x i1> @llvm.experimental.constrained.fcmps.v2f64(
                                               <2 x double> %f1, <2 x double> %f2, metadata !"ueq",
                                               metadata !"fpexcept.strict") #0
  %res = select <2 x i1> %cond, <2 x i64> %a, <2 x i64> %b
  ret <2 x i64> %res
}

define <2 x i64> @test_v2f64_ugt_s(<2 x i64> %a, <2 x i64> %b, <2 x double> %f1, <2 x double> %f2) #0 {
; SSE-32-LABEL: test_v2f64_ugt_s:
; SSE-32:       # %bb.0:
; SSE-32-NEXT:    pushl %ebp
; SSE-32-NEXT:    movl %esp, %ebp
; SSE-32-NEXT:    andl $-16, %esp
; SSE-32-NEXT:    subl $16, %esp
; SSE-32-NEXT:    cmpnlepd 8(%ebp), %xmm2
; SSE-32-NEXT:    andpd %xmm2, %xmm0
; SSE-32-NEXT:    andnpd %xmm1, %xmm2
; SSE-32-NEXT:    orpd %xmm2, %xmm0
; SSE-32-NEXT:    movl %ebp, %esp
; SSE-32-NEXT:    popl %ebp
; SSE-32-NEXT:    retl
;
; SSE-64-LABEL: test_v2f64_ugt_s:
; SSE-64:       # %bb.0:
; SSE-64-NEXT:    cmpnlepd %xmm3, %xmm2
; SSE-64-NEXT:    andpd %xmm2, %xmm0
; SSE-64-NEXT:    andnpd %xmm1, %xmm2
; SSE-64-NEXT:    orpd %xmm2, %xmm0
; SSE-64-NEXT:    retq
;
; AVX-32-LABEL: test_v2f64_ugt_s:
; AVX-32:       # %bb.0:
; AVX-32-NEXT:    pushl %ebp
; AVX-32-NEXT:    movl %esp, %ebp
; AVX-32-NEXT:    andl $-16, %esp
; AVX-32-NEXT:    subl $16, %esp
; AVX-32-NEXT:    vcmpnlepd 8(%ebp), %xmm2, %xmm2
; AVX-32-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; AVX-32-NEXT:    movl %ebp, %esp
; AVX-32-NEXT:    popl %ebp
; AVX-32-NEXT:    retl
;
; AVX-64-LABEL: test_v2f64_ugt_s:
; AVX-64:       # %bb.0:
; AVX-64-NEXT:    vcmpnlepd %xmm3, %xmm2, %xmm2
; AVX-64-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; AVX-64-NEXT:    retq
;
; AVX512-32-LABEL: test_v2f64_ugt_s:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-16, %esp
; AVX512-32-NEXT:    subl $16, %esp
; AVX512-32-NEXT:    vcmpnlepd 8(%ebp), %xmm2, %k1
; AVX512-32-NEXT:    vpblendmq %xmm0, %xmm1, %xmm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v2f64_ugt_s:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmpnlepd %xmm3, %xmm2, %k1
; AVX512-64-NEXT:    vpblendmq %xmm0, %xmm1, %xmm0 {%k1}
; AVX512-64-NEXT:    retq
;
; AVX512F-32-LABEL: test_v2f64_ugt_s:
; AVX512F-32:       # %bb.0:
; AVX512F-32-NEXT:    pushl %ebp
; AVX512F-32-NEXT:    movl %esp, %ebp
; AVX512F-32-NEXT:    andl $-16, %esp
; AVX512F-32-NEXT:    subl $16, %esp
; AVX512F-32-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-32-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-32-NEXT:    vcmpnlepd 8(%ebp), %xmm2, %xmm2
; AVX512F-32-NEXT:    vptestmq %zmm2, %zmm2, %k1
; AVX512F-32-NEXT:    vpblendmq %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-32-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-32-NEXT:    movl %ebp, %esp
; AVX512F-32-NEXT:    popl %ebp
; AVX512F-32-NEXT:    vzeroupper
; AVX512F-32-NEXT:    retl
;
; AVX512F-64-LABEL: test_v2f64_ugt_s:
; AVX512F-64:       # %bb.0:
; AVX512F-64-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-64-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-64-NEXT:    vcmpnlepd %xmm3, %xmm2, %xmm2
; AVX512F-64-NEXT:    vptestmq %zmm2, %zmm2, %k1
; AVX512F-64-NEXT:    vpblendmq %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-64-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-64-NEXT:    vzeroupper
; AVX512F-64-NEXT:    retq
  %cond = call <2 x i1> @llvm.experimental.constrained.fcmps.v2f64(
                                               <2 x double> %f1, <2 x double> %f2, metadata !"ugt",
                                               metadata !"fpexcept.strict") #0
  %res = select <2 x i1> %cond, <2 x i64> %a, <2 x i64> %b
  ret <2 x i64> %res
}

define <2 x i64> @test_v2f64_uge_s(<2 x i64> %a, <2 x i64> %b, <2 x double> %f1, <2 x double> %f2) #0 {
; SSE-32-LABEL: test_v2f64_uge_s:
; SSE-32:       # %bb.0:
; SSE-32-NEXT:    pushl %ebp
; SSE-32-NEXT:    movl %esp, %ebp
; SSE-32-NEXT:    andl $-16, %esp
; SSE-32-NEXT:    subl $16, %esp
; SSE-32-NEXT:    cmpnltpd 8(%ebp), %xmm2
; SSE-32-NEXT:    andpd %xmm2, %xmm0
; SSE-32-NEXT:    andnpd %xmm1, %xmm2
; SSE-32-NEXT:    orpd %xmm2, %xmm0
; SSE-32-NEXT:    movl %ebp, %esp
; SSE-32-NEXT:    popl %ebp
; SSE-32-NEXT:    retl
;
; SSE-64-LABEL: test_v2f64_uge_s:
; SSE-64:       # %bb.0:
; SSE-64-NEXT:    cmpnltpd %xmm3, %xmm2
; SSE-64-NEXT:    andpd %xmm2, %xmm0
; SSE-64-NEXT:    andnpd %xmm1, %xmm2
; SSE-64-NEXT:    orpd %xmm2, %xmm0
; SSE-64-NEXT:    retq
;
; AVX-32-LABEL: test_v2f64_uge_s:
; AVX-32:       # %bb.0:
; AVX-32-NEXT:    pushl %ebp
; AVX-32-NEXT:    movl %esp, %ebp
; AVX-32-NEXT:    andl $-16, %esp
; AVX-32-NEXT:    subl $16, %esp
; AVX-32-NEXT:    vcmpnltpd 8(%ebp), %xmm2, %xmm2
; AVX-32-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; AVX-32-NEXT:    movl %ebp, %esp
; AVX-32-NEXT:    popl %ebp
; AVX-32-NEXT:    retl
;
; AVX-64-LABEL: test_v2f64_uge_s:
; AVX-64:       # %bb.0:
; AVX-64-NEXT:    vcmpnltpd %xmm3, %xmm2, %xmm2
; AVX-64-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; AVX-64-NEXT:    retq
;
; AVX512-32-LABEL: test_v2f64_uge_s:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-16, %esp
; AVX512-32-NEXT:    subl $16, %esp
; AVX512-32-NEXT:    vcmpnltpd 8(%ebp), %xmm2, %k1
; AVX512-32-NEXT:    vpblendmq %xmm0, %xmm1, %xmm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v2f64_uge_s:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmpnltpd %xmm3, %xmm2, %k1
; AVX512-64-NEXT:    vpblendmq %xmm0, %xmm1, %xmm0 {%k1}
; AVX512-64-NEXT:    retq
;
; AVX512F-32-LABEL: test_v2f64_uge_s:
; AVX512F-32:       # %bb.0:
; AVX512F-32-NEXT:    pushl %ebp
; AVX512F-32-NEXT:    movl %esp, %ebp
; AVX512F-32-NEXT:    andl $-16, %esp
; AVX512F-32-NEXT:    subl $16, %esp
; AVX512F-32-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-32-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-32-NEXT:    vcmpnltpd 8(%ebp), %xmm2, %xmm2
; AVX512F-32-NEXT:    vptestmq %zmm2, %zmm2, %k1
; AVX512F-32-NEXT:    vpblendmq %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-32-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-32-NEXT:    movl %ebp, %esp
; AVX512F-32-NEXT:    popl %ebp
; AVX512F-32-NEXT:    vzeroupper
; AVX512F-32-NEXT:    retl
;
; AVX512F-64-LABEL: test_v2f64_uge_s:
; AVX512F-64:       # %bb.0:
; AVX512F-64-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-64-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-64-NEXT:    vcmpnltpd %xmm3, %xmm2, %xmm2
; AVX512F-64-NEXT:    vptestmq %zmm2, %zmm2, %k1
; AVX512F-64-NEXT:    vpblendmq %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-64-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-64-NEXT:    vzeroupper
; AVX512F-64-NEXT:    retq
  %cond = call <2 x i1> @llvm.experimental.constrained.fcmps.v2f64(
                                               <2 x double> %f1, <2 x double> %f2, metadata !"uge",
                                               metadata !"fpexcept.strict") #0
  %res = select <2 x i1> %cond, <2 x i64> %a, <2 x i64> %b
  ret <2 x i64> %res
}

define <2 x i64> @test_v2f64_ult_s(<2 x i64> %a, <2 x i64> %b, <2 x double> %f1, <2 x double> %f2) #0 {
; SSE-32-LABEL: test_v2f64_ult_s:
; SSE-32:       # %bb.0:
; SSE-32-NEXT:    pushl %ebp
; SSE-32-NEXT:    movl %esp, %ebp
; SSE-32-NEXT:    andl $-16, %esp
; SSE-32-NEXT:    subl $16, %esp
; SSE-32-NEXT:    movapd 8(%ebp), %xmm3
; SSE-32-NEXT:    cmpnlepd %xmm2, %xmm3
; SSE-32-NEXT:    andpd %xmm3, %xmm0
; SSE-32-NEXT:    andnpd %xmm1, %xmm3
; SSE-32-NEXT:    orpd %xmm3, %xmm0
; SSE-32-NEXT:    movl %ebp, %esp
; SSE-32-NEXT:    popl %ebp
; SSE-32-NEXT:    retl
;
; SSE-64-LABEL: test_v2f64_ult_s:
; SSE-64:       # %bb.0:
; SSE-64-NEXT:    cmpnlepd %xmm2, %xmm3
; SSE-64-NEXT:    andpd %xmm3, %xmm0
; SSE-64-NEXT:    andnpd %xmm1, %xmm3
; SSE-64-NEXT:    orpd %xmm3, %xmm0
; SSE-64-NEXT:    retq
;
; AVX-32-LABEL: test_v2f64_ult_s:
; AVX-32:       # %bb.0:
; AVX-32-NEXT:    pushl %ebp
; AVX-32-NEXT:    movl %esp, %ebp
; AVX-32-NEXT:    andl $-16, %esp
; AVX-32-NEXT:    subl $16, %esp
; AVX-32-NEXT:    vmovapd 8(%ebp), %xmm3
; AVX-32-NEXT:    vcmpnlepd %xmm2, %xmm3, %xmm2
; AVX-32-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; AVX-32-NEXT:    movl %ebp, %esp
; AVX-32-NEXT:    popl %ebp
; AVX-32-NEXT:    retl
;
; AVX-64-LABEL: test_v2f64_ult_s:
; AVX-64:       # %bb.0:
; AVX-64-NEXT:    vcmpnlepd %xmm2, %xmm3, %xmm2
; AVX-64-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; AVX-64-NEXT:    retq
;
; AVX512-32-LABEL: test_v2f64_ult_s:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-16, %esp
; AVX512-32-NEXT:    subl $16, %esp
; AVX512-32-NEXT:    vcmpngepd 8(%ebp), %xmm2, %k1
; AVX512-32-NEXT:    vpblendmq %xmm0, %xmm1, %xmm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v2f64_ult_s:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmpnlepd %xmm2, %xmm3, %k1
; AVX512-64-NEXT:    vpblendmq %xmm0, %xmm1, %xmm0 {%k1}
; AVX512-64-NEXT:    retq
;
; AVX512F-32-LABEL: test_v2f64_ult_s:
; AVX512F-32:       # %bb.0:
; AVX512F-32-NEXT:    pushl %ebp
; AVX512F-32-NEXT:    movl %esp, %ebp
; AVX512F-32-NEXT:    andl $-16, %esp
; AVX512F-32-NEXT:    subl $16, %esp
; AVX512F-32-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-32-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-32-NEXT:    vmovapd 8(%ebp), %xmm3
; AVX512F-32-NEXT:    vcmpnlepd %xmm2, %xmm3, %xmm2
; AVX512F-32-NEXT:    vptestmq %zmm2, %zmm2, %k1
; AVX512F-32-NEXT:    vpblendmq %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-32-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-32-NEXT:    movl %ebp, %esp
; AVX512F-32-NEXT:    popl %ebp
; AVX512F-32-NEXT:    vzeroupper
; AVX512F-32-NEXT:    retl
;
; AVX512F-64-LABEL: test_v2f64_ult_s:
; AVX512F-64:       # %bb.0:
; AVX512F-64-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-64-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-64-NEXT:    vcmpnlepd %xmm2, %xmm3, %xmm2
; AVX512F-64-NEXT:    vptestmq %zmm2, %zmm2, %k1
; AVX512F-64-NEXT:    vpblendmq %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-64-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-64-NEXT:    vzeroupper
; AVX512F-64-NEXT:    retq
  %cond = call <2 x i1> @llvm.experimental.constrained.fcmps.v2f64(
                                               <2 x double> %f1, <2 x double> %f2, metadata !"ult",
                                               metadata !"fpexcept.strict") #0
  %res = select <2 x i1> %cond, <2 x i64> %a, <2 x i64> %b
  ret <2 x i64> %res
}

define <2 x i64> @test_v2f64_ule_s(<2 x i64> %a, <2 x i64> %b, <2 x double> %f1, <2 x double> %f2) #0 {
; SSE-32-LABEL: test_v2f64_ule_s:
; SSE-32:       # %bb.0:
; SSE-32-NEXT:    pushl %ebp
; SSE-32-NEXT:    movl %esp, %ebp
; SSE-32-NEXT:    andl $-16, %esp
; SSE-32-NEXT:    subl $16, %esp
; SSE-32-NEXT:    movapd 8(%ebp), %xmm3
; SSE-32-NEXT:    cmpnltpd %xmm2, %xmm3
; SSE-32-NEXT:    andpd %xmm3, %xmm0
; SSE-32-NEXT:    andnpd %xmm1, %xmm3
; SSE-32-NEXT:    orpd %xmm3, %xmm0
; SSE-32-NEXT:    movl %ebp, %esp
; SSE-32-NEXT:    popl %ebp
; SSE-32-NEXT:    retl
;
; SSE-64-LABEL: test_v2f64_ule_s:
; SSE-64:       # %bb.0:
; SSE-64-NEXT:    cmpnltpd %xmm2, %xmm3
; SSE-64-NEXT:    andpd %xmm3, %xmm0
; SSE-64-NEXT:    andnpd %xmm1, %xmm3
; SSE-64-NEXT:    orpd %xmm3, %xmm0
; SSE-64-NEXT:    retq
;
; AVX-32-LABEL: test_v2f64_ule_s:
; AVX-32:       # %bb.0:
; AVX-32-NEXT:    pushl %ebp
; AVX-32-NEXT:    movl %esp, %ebp
; AVX-32-NEXT:    andl $-16, %esp
; AVX-32-NEXT:    subl $16, %esp
; AVX-32-NEXT:    vmovapd 8(%ebp), %xmm3
; AVX-32-NEXT:    vcmpnltpd %xmm2, %xmm3, %xmm2
; AVX-32-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; AVX-32-NEXT:    movl %ebp, %esp
; AVX-32-NEXT:    popl %ebp
; AVX-32-NEXT:    retl
;
; AVX-64-LABEL: test_v2f64_ule_s:
; AVX-64:       # %bb.0:
; AVX-64-NEXT:    vcmpnltpd %xmm2, %xmm3, %xmm2
; AVX-64-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; AVX-64-NEXT:    retq
;
; AVX512-32-LABEL: test_v2f64_ule_s:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-16, %esp
; AVX512-32-NEXT:    subl $16, %esp
; AVX512-32-NEXT:    vcmpngtpd 8(%ebp), %xmm2, %k1
; AVX512-32-NEXT:    vpblendmq %xmm0, %xmm1, %xmm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v2f64_ule_s:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmpnltpd %xmm2, %xmm3, %k1
; AVX512-64-NEXT:    vpblendmq %xmm0, %xmm1, %xmm0 {%k1}
; AVX512-64-NEXT:    retq
;
; AVX512F-32-LABEL: test_v2f64_ule_s:
; AVX512F-32:       # %bb.0:
; AVX512F-32-NEXT:    pushl %ebp
; AVX512F-32-NEXT:    movl %esp, %ebp
; AVX512F-32-NEXT:    andl $-16, %esp
; AVX512F-32-NEXT:    subl $16, %esp
; AVX512F-32-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-32-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-32-NEXT:    vmovapd 8(%ebp), %xmm3
; AVX512F-32-NEXT:    vcmpnltpd %xmm2, %xmm3, %xmm2
; AVX512F-32-NEXT:    vptestmq %zmm2, %zmm2, %k1
; AVX512F-32-NEXT:    vpblendmq %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-32-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-32-NEXT:    movl %ebp, %esp
; AVX512F-32-NEXT:    popl %ebp
; AVX512F-32-NEXT:    vzeroupper
; AVX512F-32-NEXT:    retl
;
; AVX512F-64-LABEL: test_v2f64_ule_s:
; AVX512F-64:       # %bb.0:
; AVX512F-64-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-64-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-64-NEXT:    vcmpnltpd %xmm2, %xmm3, %xmm2
; AVX512F-64-NEXT:    vptestmq %zmm2, %zmm2, %k1
; AVX512F-64-NEXT:    vpblendmq %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-64-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-64-NEXT:    vzeroupper
; AVX512F-64-NEXT:    retq
  %cond = call <2 x i1> @llvm.experimental.constrained.fcmps.v2f64(
                                               <2 x double> %f1, <2 x double> %f2, metadata !"ule",
                                               metadata !"fpexcept.strict") #0
  %res = select <2 x i1> %cond, <2 x i64> %a, <2 x i64> %b
  ret <2 x i64> %res
}

define <2 x i64> @test_v2f64_une_s(<2 x i64> %a, <2 x i64> %b, <2 x double> %f1, <2 x double> %f2) #0 {
; SSE-32-LABEL: test_v2f64_une_s:
; SSE-32:       # %bb.0:
; SSE-32-NEXT:    pushl %ebp
; SSE-32-NEXT:    movl %esp, %ebp
; SSE-32-NEXT:    andl $-16, %esp
; SSE-32-NEXT:    subl $16, %esp
; SSE-32-NEXT:    movapd 8(%ebp), %xmm3
; SSE-32-NEXT:    movapd %xmm2, %xmm4
; SSE-32-NEXT:    cmpltpd %xmm3, %xmm4
; SSE-32-NEXT:    cmpneqpd %xmm3, %xmm2
; SSE-32-NEXT:    andpd %xmm2, %xmm0
; SSE-32-NEXT:    andnpd %xmm1, %xmm2
; SSE-32-NEXT:    orpd %xmm2, %xmm0
; SSE-32-NEXT:    movl %ebp, %esp
; SSE-32-NEXT:    popl %ebp
; SSE-32-NEXT:    retl
;
; SSE-64-LABEL: test_v2f64_une_s:
; SSE-64:       # %bb.0:
; SSE-64-NEXT:    movapd %xmm2, %xmm4
; SSE-64-NEXT:    cmpltpd %xmm3, %xmm4
; SSE-64-NEXT:    cmpneqpd %xmm3, %xmm2
; SSE-64-NEXT:    andpd %xmm2, %xmm0
; SSE-64-NEXT:    andnpd %xmm1, %xmm2
; SSE-64-NEXT:    orpd %xmm2, %xmm0
; SSE-64-NEXT:    retq
;
; AVX-32-LABEL: test_v2f64_une_s:
; AVX-32:       # %bb.0:
; AVX-32-NEXT:    pushl %ebp
; AVX-32-NEXT:    movl %esp, %ebp
; AVX-32-NEXT:    andl $-16, %esp
; AVX-32-NEXT:    subl $16, %esp
; AVX-32-NEXT:    vcmpneq_uspd 8(%ebp), %xmm2, %xmm2
; AVX-32-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; AVX-32-NEXT:    movl %ebp, %esp
; AVX-32-NEXT:    popl %ebp
; AVX-32-NEXT:    retl
;
; AVX-64-LABEL: test_v2f64_une_s:
; AVX-64:       # %bb.0:
; AVX-64-NEXT:    vcmpneq_uspd %xmm3, %xmm2, %xmm2
; AVX-64-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; AVX-64-NEXT:    retq
;
; AVX512-32-LABEL: test_v2f64_une_s:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-16, %esp
; AVX512-32-NEXT:    subl $16, %esp
; AVX512-32-NEXT:    vcmpneq_uspd 8(%ebp), %xmm2, %k1
; AVX512-32-NEXT:    vpblendmq %xmm0, %xmm1, %xmm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v2f64_une_s:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmpneq_uspd %xmm3, %xmm2, %k1
; AVX512-64-NEXT:    vpblendmq %xmm0, %xmm1, %xmm0 {%k1}
; AVX512-64-NEXT:    retq
;
; AVX512F-32-LABEL: test_v2f64_une_s:
; AVX512F-32:       # %bb.0:
; AVX512F-32-NEXT:    pushl %ebp
; AVX512F-32-NEXT:    movl %esp, %ebp
; AVX512F-32-NEXT:    andl $-16, %esp
; AVX512F-32-NEXT:    subl $16, %esp
; AVX512F-32-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-32-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-32-NEXT:    vcmpneq_uspd 8(%ebp), %xmm2, %xmm2
; AVX512F-32-NEXT:    vptestmq %zmm2, %zmm2, %k1
; AVX512F-32-NEXT:    vpblendmq %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-32-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-32-NEXT:    movl %ebp, %esp
; AVX512F-32-NEXT:    popl %ebp
; AVX512F-32-NEXT:    vzeroupper
; AVX512F-32-NEXT:    retl
;
; AVX512F-64-LABEL: test_v2f64_une_s:
; AVX512F-64:       # %bb.0:
; AVX512F-64-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-64-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-64-NEXT:    vcmpneq_uspd %xmm3, %xmm2, %xmm2
; AVX512F-64-NEXT:    vptestmq %zmm2, %zmm2, %k1
; AVX512F-64-NEXT:    vpblendmq %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-64-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-64-NEXT:    vzeroupper
; AVX512F-64-NEXT:    retq
  %cond = call <2 x i1> @llvm.experimental.constrained.fcmps.v2f64(
                                               <2 x double> %f1, <2 x double> %f2, metadata !"une",
                                               metadata !"fpexcept.strict") #0
  %res = select <2 x i1> %cond, <2 x i64> %a, <2 x i64> %b
  ret <2 x i64> %res
}

define <2 x i64> @test_v2f64_uno_s(<2 x i64> %a, <2 x i64> %b, <2 x double> %f1, <2 x double> %f2) #0 {
; SSE-32-LABEL: test_v2f64_uno_s:
; SSE-32:       # %bb.0:
; SSE-32-NEXT:    pushl %ebp
; SSE-32-NEXT:    movl %esp, %ebp
; SSE-32-NEXT:    andl $-16, %esp
; SSE-32-NEXT:    subl $16, %esp
; SSE-32-NEXT:    movapd 8(%ebp), %xmm3
; SSE-32-NEXT:    movapd %xmm2, %xmm4
; SSE-32-NEXT:    cmpltpd %xmm3, %xmm4
; SSE-32-NEXT:    cmpunordpd %xmm3, %xmm2
; SSE-32-NEXT:    andpd %xmm2, %xmm0
; SSE-32-NEXT:    andnpd %xmm1, %xmm2
; SSE-32-NEXT:    orpd %xmm2, %xmm0
; SSE-32-NEXT:    movl %ebp, %esp
; SSE-32-NEXT:    popl %ebp
; SSE-32-NEXT:    retl
;
; SSE-64-LABEL: test_v2f64_uno_s:
; SSE-64:       # %bb.0:
; SSE-64-NEXT:    movapd %xmm2, %xmm4
; SSE-64-NEXT:    cmpltpd %xmm3, %xmm4
; SSE-64-NEXT:    cmpunordpd %xmm3, %xmm2
; SSE-64-NEXT:    andpd %xmm2, %xmm0
; SSE-64-NEXT:    andnpd %xmm1, %xmm2
; SSE-64-NEXT:    orpd %xmm2, %xmm0
; SSE-64-NEXT:    retq
;
; AVX-32-LABEL: test_v2f64_uno_s:
; AVX-32:       # %bb.0:
; AVX-32-NEXT:    pushl %ebp
; AVX-32-NEXT:    movl %esp, %ebp
; AVX-32-NEXT:    andl $-16, %esp
; AVX-32-NEXT:    subl $16, %esp
; AVX-32-NEXT:    vcmpunord_spd 8(%ebp), %xmm2, %xmm2
; AVX-32-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; AVX-32-NEXT:    movl %ebp, %esp
; AVX-32-NEXT:    popl %ebp
; AVX-32-NEXT:    retl
;
; AVX-64-LABEL: test_v2f64_uno_s:
; AVX-64:       # %bb.0:
; AVX-64-NEXT:    vcmpunord_spd %xmm3, %xmm2, %xmm2
; AVX-64-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; AVX-64-NEXT:    retq
;
; AVX512-32-LABEL: test_v2f64_uno_s:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-16, %esp
; AVX512-32-NEXT:    subl $16, %esp
; AVX512-32-NEXT:    vcmpunord_spd 8(%ebp), %xmm2, %k1
; AVX512-32-NEXT:    vpblendmq %xmm0, %xmm1, %xmm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v2f64_uno_s:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmpunord_spd %xmm3, %xmm2, %k1
; AVX512-64-NEXT:    vpblendmq %xmm0, %xmm1, %xmm0 {%k1}
; AVX512-64-NEXT:    retq
;
; AVX512F-32-LABEL: test_v2f64_uno_s:
; AVX512F-32:       # %bb.0:
; AVX512F-32-NEXT:    pushl %ebp
; AVX512F-32-NEXT:    movl %esp, %ebp
; AVX512F-32-NEXT:    andl $-16, %esp
; AVX512F-32-NEXT:    subl $16, %esp
; AVX512F-32-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-32-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-32-NEXT:    vcmpunord_spd 8(%ebp), %xmm2, %xmm2
; AVX512F-32-NEXT:    vptestmq %zmm2, %zmm2, %k1
; AVX512F-32-NEXT:    vpblendmq %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-32-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-32-NEXT:    movl %ebp, %esp
; AVX512F-32-NEXT:    popl %ebp
; AVX512F-32-NEXT:    vzeroupper
; AVX512F-32-NEXT:    retl
;
; AVX512F-64-LABEL: test_v2f64_uno_s:
; AVX512F-64:       # %bb.0:
; AVX512F-64-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-64-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-64-NEXT:    vcmpunord_spd %xmm3, %xmm2, %xmm2
; AVX512F-64-NEXT:    vptestmq %zmm2, %zmm2, %k1
; AVX512F-64-NEXT:    vpblendmq %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-64-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-64-NEXT:    vzeroupper
; AVX512F-64-NEXT:    retq
  %cond = call <2 x i1> @llvm.experimental.constrained.fcmps.v2f64(
                                               <2 x double> %f1, <2 x double> %f2, metadata !"uno",
                                               metadata !"fpexcept.strict") #0
  %res = select <2 x i1> %cond, <2 x i64> %a, <2 x i64> %b
  ret <2 x i64> %res
}

attributes #0 = { strictfp nounwind }

declare <4 x i1> @llvm.experimental.constrained.fcmp.v4f32(<4 x float>, <4 x float>, metadata, metadata)
declare <2 x i1> @llvm.experimental.constrained.fcmp.v2f64(<2 x double>, <2 x double>, metadata, metadata)
declare <4 x i1> @llvm.experimental.constrained.fcmps.v4f32(<4 x float>, <4 x float>, metadata, metadata)
declare <2 x i1> @llvm.experimental.constrained.fcmps.v2f64(<2 x double>, <2 x double>, metadata, metadata)
