; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=mips64el-unknown-linux-gnu -target-abi n64 | FileCheck %s --check-prefix=MIPSN64
; RUN: llc < %s -mtriple=mips64el-unknown-linux-gnu -target-abi n32 | FileCheck %s --check-prefix=MIPSN32

; Test that powi has its integer argument sign extended on mips64.

declare double @llvm.powi.f64(double, i32)

define double @powi(double %value, i32 %power) {
; MIPSN64-LABEL: powi:
; MIPSN64:       # %bb.0:
; MIPSN64-NEXT:    daddiu $sp, $sp, -16
; MIPSN64-NEXT:    .cfi_def_cfa_offset 16
; MIPSN64-NEXT:    sd $ra, 8($sp) # 8-byte Folded Spill
; MIPSN64-NEXT:    .cfi_offset 31, -8
; MIPSN64-NEXT:    jal __powidf2
; MIPSN64-NEXT:    sll $5, $5, 0
; MIPSN64-NEXT:    ld $ra, 8($sp) # 8-byte Folded Reload
; MIPSN64-NEXT:    jr $ra
; MIPSN64-NEXT:    daddiu $sp, $sp, 16
;
; MIPSN32-LABEL: powi:
; MIPSN32:       # %bb.0:
; MIPSN32-NEXT:    addiu $sp, $sp, -16
; MIPSN32-NEXT:    .cfi_def_cfa_offset 16
; MIPSN32-NEXT:    sd $ra, 8($sp) # 8-byte Folded Spill
; MIPSN32-NEXT:    .cfi_offset 31, -8
; MIPSN32-NEXT:    jal __powidf2
; MIPSN32-NEXT:    sll $5, $5, 0
; MIPSN32-NEXT:    ld $ra, 8($sp) # 8-byte Folded Reload
; MIPSN32-NEXT:    jr $ra
; MIPSN32-NEXT:    addiu $sp, $sp, 16
        %1 = tail call double @llvm.powi.f64(double %value, i32 %power)
        ret double %1
}

declare float @llvm.powi.f32(float, i32)

define float @powfi(float %value, i32 %power) {
; MIPSN64-LABEL: powfi:
; MIPSN64:       # %bb.0:
; MIPSN64-NEXT:    daddiu $sp, $sp, -16
; MIPSN64-NEXT:    .cfi_def_cfa_offset 16
; MIPSN64-NEXT:    sd $ra, 8($sp) # 8-byte Folded Spill
; MIPSN64-NEXT:    .cfi_offset 31, -8
; MIPSN64-NEXT:    jal __powisf2
; MIPSN64-NEXT:    sll $5, $5, 0
; MIPSN64-NEXT:    ld $ra, 8($sp) # 8-byte Folded Reload
; MIPSN64-NEXT:    jr $ra
; MIPSN64-NEXT:    daddiu $sp, $sp, 16
;
; MIPSN32-LABEL: powfi:
; MIPSN32:       # %bb.0:
; MIPSN32-NEXT:    addiu $sp, $sp, -16
; MIPSN32-NEXT:    .cfi_def_cfa_offset 16
; MIPSN32-NEXT:    sd $ra, 8($sp) # 8-byte Folded Spill
; MIPSN32-NEXT:    .cfi_offset 31, -8
; MIPSN32-NEXT:    jal __powisf2
; MIPSN32-NEXT:    sll $5, $5, 0
; MIPSN32-NEXT:    ld $ra, 8($sp) # 8-byte Folded Reload
; MIPSN32-NEXT:    jr $ra
; MIPSN32-NEXT:    addiu $sp, $sp, 16
        %1 = tail call float @llvm.powi.f32(float %value, i32 %power)
        ret float %1
}
