; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -amdgpu-scalarize-global-loads=false  -march=amdgcn -mtriple=amdgcn-- -mcpu=verde -verify-machineinstrs | FileCheck %s -allow-deprecated-dag-overlap --check-prefix=GCN
; XUN: llc < %s -march=amdgcn -mtriple=amdgcn-- -mcpu=tonga -mattr=-flat-for-global -verify-machineinstrs | FileCheck %s -check-prefixes=GCN,VI
; RUN: llc < %s -amdgpu-scalarize-global-loads=false  -march=r600 -mtriple=r600-- -mcpu=redwood -verify-machineinstrs | FileCheck %s -allow-deprecated-dag-overlap --check-prefix=EG

declare i32 @llvm.amdgcn.workitem.id.x() #0

declare i32 @llvm.amdgcn.workgroup.id.x() #0

define amdgpu_kernel void @shl_v2i32(<2 x i32> addrspace(1)* %out, <2 x i32> addrspace(1)* %in) {
; GCN-LABEL: shl_v2i32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; GCN-NEXT:    s_mov_b32 s3, 0xf000
; GCN-NEXT:    s_mov_b32 s2, -1
; GCN-NEXT:    s_mov_b32 s10, s2
; GCN-NEXT:    s_mov_b32 s11, s3
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_mov_b32 s8, s6
; GCN-NEXT:    s_mov_b32 s9, s7
; GCN-NEXT:    buffer_load_dwordx4 v[0:3], off, s[8:11], 0
; GCN-NEXT:    s_mov_b32 s0, s4
; GCN-NEXT:    s_mov_b32 s1, s5
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    v_lshl_b32_e32 v1, v1, v3
; GCN-NEXT:    v_lshl_b32_e32 v0, v0, v2
; GCN-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GCN-NEXT:    s_endpgm
;
; EG-LABEL: shl_v2i32:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @10, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 1 @6
; EG-NEXT:    ALU 3, @11, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XY, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_64 T1.XY, T0.X, 8, #1
; EG-NEXT:     VTX_READ_64 T0.XY, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 10:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 11:
; EG-NEXT:     LSHL * T0.Y, T0.Y, T1.Y,
; EG-NEXT:     LSHL T0.X, T0.X, T1.X,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
  %b_ptr = getelementptr <2 x i32>, <2 x i32> addrspace(1)* %in, i32 1
  %a = load <2 x i32>, <2 x i32> addrspace(1)* %in
  %b = load <2 x i32>, <2 x i32> addrspace(1)* %b_ptr
  %result = shl <2 x i32> %a, %b
  store <2 x i32> %result, <2 x i32> addrspace(1)* %out
  ret void
}

define amdgpu_kernel void @shl_v4i32(<4 x i32> addrspace(1)* %out, <4 x i32> addrspace(1)* %in) {
; GCN-LABEL: shl_v4i32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; GCN-NEXT:    s_mov_b32 s3, 0xf000
; GCN-NEXT:    s_mov_b32 s2, -1
; GCN-NEXT:    s_mov_b32 s10, s2
; GCN-NEXT:    s_mov_b32 s11, s3
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_mov_b32 s8, s6
; GCN-NEXT:    s_mov_b32 s9, s7
; GCN-NEXT:    buffer_load_dwordx4 v[0:3], off, s[8:11], 0
; GCN-NEXT:    buffer_load_dwordx4 v[4:7], off, s[8:11], 0 offset:16
; GCN-NEXT:    s_mov_b32 s0, s4
; GCN-NEXT:    s_mov_b32 s1, s5
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    v_lshl_b32_e32 v3, v3, v7
; GCN-NEXT:    v_lshl_b32_e32 v2, v2, v6
; GCN-NEXT:    v_lshl_b32_e32 v1, v1, v5
; GCN-NEXT:    v_lshl_b32_e32 v0, v0, v4
; GCN-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0
; GCN-NEXT:    s_endpgm
;
; EG-LABEL: shl_v4i32:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @10, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 1 @6
; EG-NEXT:    ALU 5, @11, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XYZW, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_128 T1.XYZW, T0.X, 16, #1
; EG-NEXT:     VTX_READ_128 T0.XYZW, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 10:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 11:
; EG-NEXT:     LSHL * T0.W, T0.W, T1.W,
; EG-NEXT:     LSHL * T0.Z, T0.Z, T1.Z,
; EG-NEXT:     LSHL * T0.Y, T0.Y, T1.Y,
; EG-NEXT:     LSHL T0.X, T0.X, T1.X,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
  %b_ptr = getelementptr <4 x i32>, <4 x i32> addrspace(1)* %in, i32 1
  %a = load <4 x i32>, <4 x i32> addrspace(1)* %in
  %b = load <4 x i32>, <4 x i32> addrspace(1)* %b_ptr
  %result = shl <4 x i32> %a, %b
  store <4 x i32> %result, <4 x i32> addrspace(1)* %out
  ret void
}

define amdgpu_kernel void @shl_i16(i16 addrspace(1)* %out, i16 addrspace(1)* %in) {
; GCN-LABEL: shl_i16:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; GCN-NEXT:    s_mov_b32 s3, 0xf000
; GCN-NEXT:    s_mov_b32 s2, -1
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_mov_b32 s0, s4
; GCN-NEXT:    s_mov_b32 s1, s5
; GCN-NEXT:    s_mov_b32 s4, s6
; GCN-NEXT:    s_mov_b32 s5, s7
; GCN-NEXT:    s_mov_b32 s6, s2
; GCN-NEXT:    s_mov_b32 s7, s3
; GCN-NEXT:    buffer_load_ushort v0, off, s[4:7], 0
; GCN-NEXT:    buffer_load_ushort v1, off, s[4:7], 0 offset:2
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    v_lshlrev_b32_e32 v0, v1, v0
; GCN-NEXT:    buffer_store_short v0, off, s[0:3], 0
; GCN-NEXT:    s_endpgm
;
; EG-LABEL: shl_i16:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @10, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 1 @6
; EG-NEXT:    ALU 12, @11, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT MSKOR T0.XW, T1.X
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_16 T1.X, T0.X, 2, #1
; EG-NEXT:     VTX_READ_16 T0.X, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 10:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 11:
; EG-NEXT:     AND_INT T0.W, KC0[2].Y, literal.x,
; EG-NEXT:     LSHL * T1.W, T0.X, T1.X,
; EG-NEXT:    3(4.203895e-45), 0(0.000000e+00)
; EG-NEXT:     AND_INT T1.W, PS, literal.x,
; EG-NEXT:     LSHL * T0.W, PV.W, literal.y,
; EG-NEXT:    65535(9.183409e-41), 3(4.203895e-45)
; EG-NEXT:     LSHL T0.X, PV.W, PS,
; EG-NEXT:     LSHL * T0.W, literal.x, PS,
; EG-NEXT:    65535(9.183409e-41), 0(0.000000e+00)
; EG-NEXT:     MOV T0.Y, 0.0,
; EG-NEXT:     MOV * T0.Z, 0.0,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
  %b_ptr = getelementptr i16, i16 addrspace(1)* %in, i16 1
  %a = load i16, i16 addrspace(1)* %in
  %b = load i16, i16 addrspace(1)* %b_ptr
  %result = shl i16 %a, %b
  store i16 %result, i16 addrspace(1)* %out
  ret void
}

define amdgpu_kernel void @shl_i16_v_s(i16 addrspace(1)* %out, i16 addrspace(1)* %in, i16 %b) {
; GCN-LABEL: shl_i16_v_s:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; GCN-NEXT:    s_load_dword s8, s[0:1], 0xd
; GCN-NEXT:    s_mov_b32 s3, 0xf000
; GCN-NEXT:    s_mov_b32 s2, -1
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_mov_b32 s0, s4
; GCN-NEXT:    s_mov_b32 s1, s5
; GCN-NEXT:    s_mov_b32 s4, s6
; GCN-NEXT:    s_mov_b32 s5, s7
; GCN-NEXT:    s_mov_b32 s6, s2
; GCN-NEXT:    s_mov_b32 s7, s3
; GCN-NEXT:    buffer_load_ushort v0, off, s[4:7], 0
; GCN-NEXT:    s_and_b32 s8, s8, 0xffff
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    v_lshlrev_b32_e32 v0, s8, v0
; GCN-NEXT:    buffer_store_short v0, off, s[0:3], 0
; GCN-NEXT:    s_endpgm
;
; EG-LABEL: shl_i16_v_s:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 1, @10, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 1 @6
; EG-NEXT:    ALU 12, @12, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT MSKOR T0.XW, T1.X
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_16 T1.X, T1.X, 0, #1
; EG-NEXT:     VTX_READ_16 T0.X, T0.X, 44, #3
; EG-NEXT:    ALU clause starting at 10:
; EG-NEXT:     MOV T0.X, 0.0,
; EG-NEXT:     MOV * T1.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 12:
; EG-NEXT:     AND_INT T0.W, KC0[2].Y, literal.x,
; EG-NEXT:     LSHL * T1.W, T1.X, T0.X,
; EG-NEXT:    3(4.203895e-45), 0(0.000000e+00)
; EG-NEXT:     AND_INT T1.W, PS, literal.x,
; EG-NEXT:     LSHL * T0.W, PV.W, literal.y,
; EG-NEXT:    65535(9.183409e-41), 3(4.203895e-45)
; EG-NEXT:     LSHL T0.X, PV.W, PS,
; EG-NEXT:     LSHL * T0.W, literal.x, PS,
; EG-NEXT:    65535(9.183409e-41), 0(0.000000e+00)
; EG-NEXT:     MOV T0.Y, 0.0,
; EG-NEXT:     MOV * T0.Z, 0.0,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
  %a = load i16, i16 addrspace(1)* %in
  %result = shl i16 %a, %b
  store i16 %result, i16 addrspace(1)* %out
  ret void
}

define amdgpu_kernel void @shl_i16_v_compute_s(i16 addrspace(1)* %out, i16 addrspace(1)* %in, i16 %b) {
; GCN-LABEL: shl_i16_v_compute_s:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; GCN-NEXT:    s_load_dword s8, s[0:1], 0xd
; GCN-NEXT:    s_mov_b32 s3, 0xf000
; GCN-NEXT:    s_mov_b32 s2, -1
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_mov_b32 s0, s4
; GCN-NEXT:    s_mov_b32 s1, s5
; GCN-NEXT:    s_mov_b32 s4, s6
; GCN-NEXT:    s_mov_b32 s5, s7
; GCN-NEXT:    s_mov_b32 s6, s2
; GCN-NEXT:    s_mov_b32 s7, s3
; GCN-NEXT:    buffer_load_ushort v0, off, s[4:7], 0
; GCN-NEXT:    s_add_i32 s8, s8, 3
; GCN-NEXT:    s_and_b32 s4, s8, 0xffff
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    v_lshlrev_b32_e32 v0, s4, v0
; GCN-NEXT:    buffer_store_short v0, off, s[0:3], 0
; GCN-NEXT:    s_endpgm
;
; EG-LABEL: shl_i16_v_compute_s:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @12, KC0[], KC1[]
; EG-NEXT:    TEX 0 @8
; EG-NEXT:    ALU 0, @13, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @10
; EG-NEXT:    ALU 15, @14, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT MSKOR T0.XW, T1.X
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 8:
; EG-NEXT:     VTX_READ_16 T0.X, T0.X, 44, #3
; EG-NEXT:    Fetch clause starting at 10:
; EG-NEXT:     VTX_READ_16 T1.X, T1.X, 0, #1
; EG-NEXT:    ALU clause starting at 12:
; EG-NEXT:     MOV * T0.X, 0.0,
; EG-NEXT:    ALU clause starting at 13:
; EG-NEXT:     MOV * T1.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 14:
; EG-NEXT:     ADD_INT * T0.W, T0.X, literal.x,
; EG-NEXT:    3(4.203895e-45), 0(0.000000e+00)
; EG-NEXT:     AND_INT T0.W, PV.W, literal.x,
; EG-NEXT:     AND_INT * T1.W, KC0[2].Y, literal.y,
; EG-NEXT:    65535(9.183409e-41), 3(4.203895e-45)
; EG-NEXT:     LSHL * T0.W, T1.X, PV.W,
; EG-NEXT:     AND_INT T0.W, PV.W, literal.x,
; EG-NEXT:     LSHL * T1.W, T1.W, literal.y,
; EG-NEXT:    65535(9.183409e-41), 3(4.203895e-45)
; EG-NEXT:     LSHL T0.X, PV.W, PS,
; EG-NEXT:     LSHL * T0.W, literal.x, PS,
; EG-NEXT:    65535(9.183409e-41), 0(0.000000e+00)
; EG-NEXT:     MOV T0.Y, 0.0,
; EG-NEXT:     MOV * T0.Z, 0.0,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
  %a = load i16, i16 addrspace(1)* %in
  %b.add = add i16 %b, 3
  %result = shl i16 %a, %b.add
  store i16 %result, i16 addrspace(1)* %out
  ret void
}

define amdgpu_kernel void @shl_i16_computed_amount(i16 addrspace(1)* %out, i16 addrspace(1)* %in) {
; GCN-LABEL: shl_i16_computed_amount:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; GCN-NEXT:    s_mov_b32 s3, 0xf000
; GCN-NEXT:    s_mov_b32 s2, -1
; GCN-NEXT:    s_mov_b32 s10, s2
; GCN-NEXT:    s_mov_b32 s11, s3
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_mov_b32 s8, s6
; GCN-NEXT:    s_mov_b32 s9, s7
; GCN-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GCN-NEXT:    v_mov_b32_e32 v1, 0
; GCN-NEXT:    s_mov_b32 s14, 0
; GCN-NEXT:    s_mov_b32 s15, s3
; GCN-NEXT:    s_mov_b64 s[12:13], s[6:7]
; GCN-NEXT:    buffer_load_ushort v2, off, s[8:11], 0 glc
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    buffer_load_ushort v0, v[0:1], s[12:15], 0 addr64 offset:2 glc
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    s_mov_b32 s0, s4
; GCN-NEXT:    s_mov_b32 s1, s5
; GCN-NEXT:    v_add_i32_e32 v0, vcc, 3, v0
; GCN-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GCN-NEXT:    v_lshl_b32_e32 v0, v2, v0
; GCN-NEXT:    buffer_store_short v0, off, s[0:3], 0
; GCN-NEXT:    s_endpgm
;
; EG-LABEL: shl_i16_computed_amount:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @12, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @8
; EG-NEXT:    ALU 1, @13, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @10
; EG-NEXT:    ALU 15, @15, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT MSKOR T0.XW, T1.X
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 8:
; EG-NEXT:     VTX_READ_16 T1.X, T1.X, 0, #1
; EG-NEXT:    Fetch clause starting at 10:
; EG-NEXT:     VTX_READ_16 T0.X, T0.X, 2, #1
; EG-NEXT:    ALU clause starting at 12:
; EG-NEXT:     MOV * T1.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 13:
; EG-NEXT:     LSHL * T0.W, T0.X, 1,
; EG-NEXT:     ADD_INT * T0.X, KC0[2].Z, PV.W,
; EG-NEXT:    ALU clause starting at 15:
; EG-NEXT:     ADD_INT * T0.W, T0.X, literal.x,
; EG-NEXT:    3(4.203895e-45), 0(0.000000e+00)
; EG-NEXT:     AND_INT T0.W, PV.W, literal.x,
; EG-NEXT:     AND_INT * T1.W, KC0[2].Y, literal.y,
; EG-NEXT:    65535(9.183409e-41), 3(4.203895e-45)
; EG-NEXT:     LSHL * T0.W, T1.X, PV.W,
; EG-NEXT:     AND_INT T0.W, PV.W, literal.x,
; EG-NEXT:     LSHL * T1.W, T1.W, literal.y,
; EG-NEXT:    65535(9.183409e-41), 3(4.203895e-45)
; EG-NEXT:     LSHL T0.X, PV.W, PS,
; EG-NEXT:     LSHL * T0.W, literal.x, PS,
; EG-NEXT:    65535(9.183409e-41), 0(0.000000e+00)
; EG-NEXT:     MOV T0.Y, 0.0,
; EG-NEXT:     MOV * T0.Z, 0.0,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
  %tid = call i32 @llvm.amdgcn.workitem.id.x() #0
  %gep = getelementptr inbounds i16, i16 addrspace(1)* %in, i32 %tid
  %gep.out = getelementptr inbounds i16, i16 addrspace(1)* %out, i32 %tid
  %b_ptr = getelementptr i16, i16 addrspace(1)* %gep, i16 1
  %a = load volatile i16, i16 addrspace(1)* %in
  %b = load volatile i16, i16 addrspace(1)* %b_ptr
  %b.add = add i16 %b, 3
  %result = shl i16 %a, %b.add
  store i16 %result, i16 addrspace(1)* %out
  ret void
}

define amdgpu_kernel void @shl_i16_i_s(i16 addrspace(1)* %out, i16 zeroext %a) {
; GCN-LABEL: shl_i16_i_s:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x9
; GCN-NEXT:    s_load_dword s0, s[0:1], 0xb
; GCN-NEXT:    s_mov_b32 s7, 0xf000
; GCN-NEXT:    s_mov_b32 s6, -1
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_lshl_b32 s0, s0, 12
; GCN-NEXT:    v_mov_b32_e32 v0, s0
; GCN-NEXT:    buffer_store_short v0, off, s[4:7], 0
; GCN-NEXT:    s_endpgm
;
; EG-LABEL: shl_i16_i_s:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @8, KC0[], KC1[]
; EG-NEXT:    TEX 0 @6
; EG-NEXT:    ALU 14, @9, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT MSKOR T0.XW, T1.X
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_16 T0.X, T0.X, 40, #3
; EG-NEXT:    ALU clause starting at 8:
; EG-NEXT:     MOV * T0.X, 0.0,
; EG-NEXT:    ALU clause starting at 9:
; EG-NEXT:     BFE_INT T0.W, T0.X, 0.0, literal.x,
; EG-NEXT:     AND_INT * T1.W, KC0[2].Y, literal.y,
; EG-NEXT:    16(2.242078e-44), 3(4.203895e-45)
; EG-NEXT:     LSHL * T0.W, PV.W, literal.x,
; EG-NEXT:    12(1.681558e-44), 0(0.000000e+00)
; EG-NEXT:     AND_INT T0.W, PV.W, literal.x,
; EG-NEXT:     LSHL * T1.W, T1.W, literal.y,
; EG-NEXT:    61440(8.609578e-41), 3(4.203895e-45)
; EG-NEXT:     LSHL T0.X, PV.W, PS,
; EG-NEXT:     LSHL * T0.W, literal.x, PS,
; EG-NEXT:    65535(9.183409e-41), 0(0.000000e+00)
; EG-NEXT:     MOV T0.Y, 0.0,
; EG-NEXT:     MOV * T0.Z, 0.0,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
  %result = shl i16 %a, 12
  store i16 %result, i16 addrspace(1)* %out
  ret void
}

define amdgpu_kernel void @shl_v2i16(<2 x i16> addrspace(1)* %out, <2 x i16> addrspace(1)* %in) {
; GCN-LABEL: shl_v2i16:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; GCN-NEXT:    s_mov_b32 s3, 0xf000
; GCN-NEXT:    s_mov_b32 s2, -1
; GCN-NEXT:    s_mov_b32 s10, s2
; GCN-NEXT:    s_mov_b32 s11, s3
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_mov_b32 s8, s6
; GCN-NEXT:    s_mov_b32 s9, s7
; GCN-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GCN-NEXT:    s_mov_b64 s[12:13], s[6:7]
; GCN-NEXT:    v_mov_b32_e32 v1, 0
; GCN-NEXT:    s_mov_b32 s14, 0
; GCN-NEXT:    s_mov_b32 s15, s3
; GCN-NEXT:    buffer_load_dword v2, off, s[8:11], 0
; GCN-NEXT:    buffer_load_dword v0, v[0:1], s[12:15], 0 addr64 offset:4
; GCN-NEXT:    s_mov_b32 s6, 0xffff
; GCN-NEXT:    s_mov_b32 s0, s4
; GCN-NEXT:    s_mov_b32 s1, s5
; GCN-NEXT:    s_waitcnt vmcnt(1)
; GCN-NEXT:    v_lshrrev_b32_e32 v1, 16, v2
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    v_lshrrev_b32_e32 v3, 16, v0
; GCN-NEXT:    v_and_b32_e32 v0, s6, v0
; GCN-NEXT:    v_lshl_b32_e32 v0, v2, v0
; GCN-NEXT:    v_lshl_b32_e32 v1, v1, v3
; GCN-NEXT:    v_and_b32_e32 v0, s6, v0
; GCN-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GCN-NEXT:    v_or_b32_e32 v0, v0, v1
; GCN-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GCN-NEXT:    s_endpgm
;
; EG-LABEL: shl_v2i16:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 2, @12, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @8
; EG-NEXT:    ALU 0, @15, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @10
; EG-NEXT:    ALU 12, @16, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.X, T7.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 8:
; EG-NEXT:     VTX_READ_32 T0.X, T0.X, 4, #1
; EG-NEXT:    Fetch clause starting at 10:
; EG-NEXT:     VTX_READ_32 T7.X, T7.X, 0, #1
; EG-NEXT:    ALU clause starting at 12:
; EG-NEXT:     LSHL * T0.W, T0.X, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
; EG-NEXT:     ADD_INT * T0.X, KC0[2].Z, PV.W,
; EG-NEXT:    ALU clause starting at 15:
; EG-NEXT:     MOV * T7.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 16:
; EG-NEXT:     AND_INT T0.Y, T0.X, literal.x,
; EG-NEXT:     AND_INT T0.Z, T7.X, literal.x, BS:VEC_120/SCL_212
; EG-NEXT:     LSHR T0.W, T0.X, literal.y,
; EG-NEXT:     LSHR * T1.W, T7.X, literal.y,
; EG-NEXT:    65535(9.183409e-41), 16(2.242078e-44)
; EG-NEXT:     LSHL T0.W, PS, PV.W,
; EG-NEXT:     LSHL * T1.W, PV.Z, PV.Y,
; EG-NEXT:     AND_INT T1.W, PS, literal.x,
; EG-NEXT:     LSHL * T0.W, PV.W, literal.y,
; EG-NEXT:    65535(9.183409e-41), 16(2.242078e-44)
; EG-NEXT:     OR_INT T0.X, PV.W, PS,
; EG-NEXT:     LSHR * T7.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
  %tid = call i32 @llvm.amdgcn.workitem.id.x() #0
  %gep = getelementptr inbounds <2 x i16>, <2 x i16> addrspace(1)* %in, i32 %tid
  %gep.out = getelementptr inbounds <2 x i16>, <2 x i16> addrspace(1)* %out, i32 %tid
  %b_ptr = getelementptr <2 x i16>, <2 x i16> addrspace(1)* %gep, i16 1
  %a = load <2 x i16>, <2 x i16> addrspace(1)* %in
  %b = load <2 x i16>, <2 x i16> addrspace(1)* %b_ptr
  %result = shl <2 x i16> %a, %b
  store <2 x i16> %result, <2 x i16> addrspace(1)* %out
  ret void
}

define amdgpu_kernel void @shl_v4i16(<4 x i16> addrspace(1)* %out, <4 x i16> addrspace(1)* %in) {
; GCN-LABEL: shl_v4i16:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; GCN-NEXT:    s_mov_b32 s3, 0xf000
; GCN-NEXT:    s_mov_b32 s2, 0
; GCN-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GCN-NEXT:    v_mov_b32_e32 v1, 0
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_mov_b64 s[0:1], s[6:7]
; GCN-NEXT:    buffer_load_dwordx2 v[2:3], v[0:1], s[0:3], 0 addr64
; GCN-NEXT:    buffer_load_dwordx2 v[4:5], v[0:1], s[0:3], 0 addr64 offset:8
; GCN-NEXT:    s_mov_b32 s0, 0xffff
; GCN-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GCN-NEXT:    s_waitcnt vmcnt(1)
; GCN-NEXT:    v_lshrrev_b32_e32 v6, 16, v2
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    v_and_b32_e32 v8, s0, v4
; GCN-NEXT:    v_lshrrev_b32_e32 v4, 16, v4
; GCN-NEXT:    v_and_b32_e32 v9, s0, v5
; GCN-NEXT:    v_lshrrev_b32_e32 v7, 16, v3
; GCN-NEXT:    v_lshrrev_b32_e32 v5, 16, v5
; GCN-NEXT:    v_lshl_b32_e32 v5, v7, v5
; GCN-NEXT:    v_lshl_b32_e32 v3, v3, v9
; GCN-NEXT:    v_lshl_b32_e32 v4, v6, v4
; GCN-NEXT:    v_lshl_b32_e32 v2, v2, v8
; GCN-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; GCN-NEXT:    v_and_b32_e32 v3, s0, v3
; GCN-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GCN-NEXT:    v_and_b32_e32 v2, s0, v2
; GCN-NEXT:    v_or_b32_e32 v3, v3, v5
; GCN-NEXT:    v_or_b32_e32 v2, v2, v4
; GCN-NEXT:    buffer_store_dwordx2 v[2:3], v[0:1], s[4:7], 0 addr64
; GCN-NEXT:    s_endpgm
;
; EG-LABEL: shl_v4i16:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 2, @12, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @8
; EG-NEXT:    ALU 3, @15, KC0[], KC1[]
; EG-NEXT:    TEX 0 @10
; EG-NEXT:    ALU 49, @19, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T10.XY, T0.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 8:
; EG-NEXT:     VTX_READ_64 T10.XY, T0.X, 0, #1
; EG-NEXT:    Fetch clause starting at 10:
; EG-NEXT:     VTX_READ_64 T10.XY, T0.X, 8, #1
; EG-NEXT:    ALU clause starting at 12:
; EG-NEXT:     LSHL * T0.W, T0.X, literal.x,
; EG-NEXT:    3(4.203895e-45), 0(0.000000e+00)
; EG-NEXT:     ADD_INT * T0.X, KC0[2].Z, PV.W,
; EG-NEXT:    ALU clause starting at 15:
; EG-NEXT:     MOV T4.X, T10.X,
; EG-NEXT:     MOV * T5.X, T10.Y,
; EG-NEXT:     MOV T0.Y, PV.X,
; EG-NEXT:     MOV * T0.Z, PS,
; EG-NEXT:    ALU clause starting at 19:
; EG-NEXT:     MOV T2.X, T10.X,
; EG-NEXT:     MOV * T3.X, T10.Y,
; EG-NEXT:     MOV T0.X, T6.X,
; EG-NEXT:     MOV * T1.Y, PV.X,
; EG-NEXT:     AND_INT T1.W, PV.Y, literal.x,
; EG-NEXT:     AND_INT * T2.W, T0.Y, literal.x,
; EG-NEXT:    65535(9.183409e-41), 0(0.000000e+00)
; EG-NEXT:     LSHL * T1.W, PS, PV.W,
; EG-NEXT:     AND_INT T1.W, PV.W, literal.x,
; EG-NEXT:     AND_INT * T2.W, T0.X, literal.y,
; EG-NEXT:    65535(9.183409e-41), -65536(nan)
; EG-NEXT:     OR_INT * T1.W, PS, PV.W,
; EG-NEXT:     MOV T0.X, T3.X,
; EG-NEXT:     MOV * T6.X, PV.W,
; EG-NEXT:     MOV T1.Z, PS,
; EG-NEXT:     LSHR T1.W, T1.Y, literal.x,
; EG-NEXT:     LSHR * T2.W, T0.Y, literal.x,
; EG-NEXT:    16(2.242078e-44), 0(0.000000e+00)
; EG-NEXT:     LSHL T1.W, PS, PV.W,
; EG-NEXT:     AND_INT * T2.W, PV.Z, literal.x,
; EG-NEXT:    65535(9.183409e-41), 0(0.000000e+00)
; EG-NEXT:     LSHL * T1.W, PV.W, literal.x,
; EG-NEXT:    16(2.242078e-44), 0(0.000000e+00)
; EG-NEXT:     OR_INT * T1.W, T2.W, PV.W,
; EG-NEXT:     MOV T6.X, PV.W,
; EG-NEXT:     MOV T0.Y, T7.X,
; EG-NEXT:     AND_INT T1.W, T0.X, literal.x, BS:VEC_120/SCL_212
; EG-NEXT:     AND_INT * T2.W, T0.Z, literal.x,
; EG-NEXT:    65535(9.183409e-41), 0(0.000000e+00)
; EG-NEXT:     LSHL T1.W, PS, PV.W,
; EG-NEXT:     AND_INT * T2.W, PV.Y, literal.x,
; EG-NEXT:    -65536(nan), 0(0.000000e+00)
; EG-NEXT:     AND_INT * T1.W, PV.W, literal.x,
; EG-NEXT:    65535(9.183409e-41), 0(0.000000e+00)
; EG-NEXT:     OR_INT * T1.W, T2.W, PV.W,
; EG-NEXT:     MOV * T7.X, PV.W,
; EG-NEXT:     MOV T0.Y, PV.X,
; EG-NEXT:     LSHR T1.W, T0.X, literal.x,
; EG-NEXT:     LSHR * T2.W, T0.Z, literal.x,
; EG-NEXT:    16(2.242078e-44), 0(0.000000e+00)
; EG-NEXT:     LSHL * T1.W, PS, PV.W,
; EG-NEXT:     AND_INT T0.Z, T0.Y, literal.x,
; EG-NEXT:     LSHL T1.W, PV.W, literal.y,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, T0.W,
; EG-NEXT:    65535(9.183409e-41), 16(2.242078e-44)
; EG-NEXT:     LSHR T0.X, PS, literal.x,
; EG-NEXT:     OR_INT * T10.Y, PV.Z, PV.W,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
; EG-NEXT:     MOV T7.X, PV.Y,
; EG-NEXT:     MOV * T10.X, T6.X,
  %tid = call i32 @llvm.amdgcn.workitem.id.x() #0
  %gep = getelementptr inbounds <4 x i16>, <4 x i16> addrspace(1)* %in, i32 %tid
  %gep.out = getelementptr inbounds <4 x i16>, <4 x i16> addrspace(1)* %out, i32 %tid
  %b_ptr = getelementptr <4 x i16>, <4 x i16> addrspace(1)* %gep, i16 1
  %a = load <4 x i16>, <4 x i16> addrspace(1)* %gep
  %b = load <4 x i16>, <4 x i16> addrspace(1)* %b_ptr
  %result = shl <4 x i16> %a, %b
  store <4 x i16> %result, <4 x i16> addrspace(1)* %gep.out
  ret void
}

define amdgpu_kernel void @shl_i64(i64 addrspace(1)* %out, i64 addrspace(1)* %in) {
; GCN-LABEL: shl_i64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; GCN-NEXT:    s_mov_b32 s3, 0xf000
; GCN-NEXT:    s_mov_b32 s2, -1
; GCN-NEXT:    s_mov_b32 s10, s2
; GCN-NEXT:    s_mov_b32 s11, s3
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_mov_b32 s8, s6
; GCN-NEXT:    s_mov_b32 s9, s7
; GCN-NEXT:    buffer_load_dwordx4 v[0:3], off, s[8:11], 0
; GCN-NEXT:    s_mov_b32 s0, s4
; GCN-NEXT:    s_mov_b32 s1, s5
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    v_lshl_b64 v[0:1], v[0:1], v2
; GCN-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GCN-NEXT:    s_endpgm
;
; EG-LABEL: shl_i64:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @8, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @6
; EG-NEXT:    ALU 15, @9, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XY, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_128 T0.XYZW, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 8:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 9:
; EG-NEXT:     SUB_INT * T0.W, literal.x, T0.Z,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     LSHR * T0.W, T0.X, PV.W,
; EG-NEXT:     ADD_INT T1.Z, T0.Z, literal.x,
; EG-NEXT:     LSHR T0.W, PV.W, 1,
; EG-NEXT:     LSHL * T1.W, T0.Y, T0.Z,
; EG-NEXT:    -32(nan), 0(0.000000e+00)
; EG-NEXT:     OR_INT T2.Z, PS, PV.W,
; EG-NEXT:     LSHL T0.W, T0.X, PV.Z,
; EG-NEXT:     SETGT_UINT * T1.W, T0.Z, literal.x,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     CNDE_INT T0.Y, PS, PV.Z, PV.W,
; EG-NEXT:     LSHL * T0.W, T0.X, T0.Z,
; EG-NEXT:     CNDE_INT T0.X, T1.W, PV.W, 0.0,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
  %b_ptr = getelementptr i64, i64 addrspace(1)* %in, i64 1
  %a = load i64, i64 addrspace(1)* %in
  %b = load i64, i64 addrspace(1)* %b_ptr
  %result = shl i64 %a, %b
  store i64 %result, i64 addrspace(1)* %out
  ret void
}

define amdgpu_kernel void @shl_v2i64(<2 x i64> addrspace(1)* %out, <2 x i64> addrspace(1)* %in) {
; GCN-LABEL: shl_v2i64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; GCN-NEXT:    s_mov_b32 s3, 0xf000
; GCN-NEXT:    s_mov_b32 s2, -1
; GCN-NEXT:    s_mov_b32 s10, s2
; GCN-NEXT:    s_mov_b32 s11, s3
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_mov_b32 s8, s6
; GCN-NEXT:    s_mov_b32 s9, s7
; GCN-NEXT:    buffer_load_dwordx4 v[0:3], off, s[8:11], 0
; GCN-NEXT:    buffer_load_dwordx4 v[4:7], off, s[8:11], 0 offset:16
; GCN-NEXT:    s_mov_b32 s0, s4
; GCN-NEXT:    s_mov_b32 s1, s5
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    v_lshl_b64 v[2:3], v[2:3], v6
; GCN-NEXT:    v_lshl_b64 v[0:1], v[0:1], v4
; GCN-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0
; GCN-NEXT:    s_endpgm
;
; EG-LABEL: shl_v2i64:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @10, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 1 @6
; EG-NEXT:    ALU 28, @11, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T2.XYZW, T0.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_128 T1.XYZW, T0.X, 16, #1
; EG-NEXT:     VTX_READ_128 T0.XYZW, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 10:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 11:
; EG-NEXT:     SUB_INT * T1.W, literal.x, T1.Z,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     LSHR * T1.W, T0.Z, PV.W,
; EG-NEXT:     SUB_INT T2.Z, literal.x, T1.X,
; EG-NEXT:     LSHR T1.W, PV.W, 1,
; EG-NEXT:     LSHL * T0.W, T0.W, T1.Z,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     OR_INT T3.Z, PS, PV.W,
; EG-NEXT:     LSHR T0.W, T0.X, PV.Z,
; EG-NEXT:     ADD_INT * T1.W, T1.Z, literal.x,
; EG-NEXT:    -32(nan), 0(0.000000e+00)
; EG-NEXT:     LSHL T2.X, T0.Z, PS,
; EG-NEXT:     SETGT_UINT T1.Y, T1.Z, literal.x, BS:VEC_120/SCL_212
; EG-NEXT:     ADD_INT T2.Z, T1.X, literal.y,
; EG-NEXT:     LSHR T0.W, PV.W, 1,
; EG-NEXT:     LSHL * T1.W, T0.Y, T1.X,
; EG-NEXT:    31(4.344025e-44), -32(nan)
; EG-NEXT:     OR_INT T0.Y, PS, PV.W,
; EG-NEXT:     LSHL T2.Z, T0.X, PV.Z,
; EG-NEXT:     SETGT_UINT T0.W, T1.X, literal.x, BS:VEC_120/SCL_212
; EG-NEXT:     CNDE_INT * T2.W, PV.Y, T3.Z, PV.X,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     CNDE_INT T2.Y, PV.W, PV.Y, PV.Z,
; EG-NEXT:     LSHL * T1.W, T0.Z, T1.Z,
; EG-NEXT:     CNDE_INT T2.Z, T1.Y, PV.W, 0.0,
; EG-NEXT:     LSHL * T1.W, T0.X, T1.X,
; EG-NEXT:     CNDE_INT T2.X, T0.W, PV.W, 0.0,
; EG-NEXT:     LSHR * T0.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
  %b_ptr = getelementptr <2 x i64>, <2 x i64> addrspace(1)* %in, i64 1
  %a = load <2 x i64>, <2 x i64> addrspace(1)* %in
  %b = load <2 x i64>, <2 x i64> addrspace(1)* %b_ptr
  %result = shl <2 x i64> %a, %b
  store <2 x i64> %result, <2 x i64> addrspace(1)* %out
  ret void
}

define amdgpu_kernel void @shl_v4i64(<4 x i64> addrspace(1)* %out, <4 x i64> addrspace(1)* %in) {
; GCN-LABEL: shl_v4i64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; GCN-NEXT:    s_mov_b32 s3, 0xf000
; GCN-NEXT:    s_mov_b32 s2, -1
; GCN-NEXT:    s_mov_b32 s10, s2
; GCN-NEXT:    s_mov_b32 s11, s3
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_mov_b32 s8, s6
; GCN-NEXT:    s_mov_b32 s9, s7
; GCN-NEXT:    buffer_load_dwordx4 v[0:3], off, s[8:11], 0
; GCN-NEXT:    buffer_load_dwordx4 v[4:7], off, s[8:11], 0 offset:16
; GCN-NEXT:    buffer_load_dwordx4 v[8:11], off, s[8:11], 0 offset:32
; GCN-NEXT:    buffer_load_dwordx4 v[11:14], off, s[8:11], 0 offset:48
; GCN-NEXT:    s_mov_b32 s0, s4
; GCN-NEXT:    s_mov_b32 s1, s5
; GCN-NEXT:    s_waitcnt vmcnt(1)
; GCN-NEXT:    v_lshl_b64 v[2:3], v[2:3], v10
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    v_lshl_b64 v[6:7], v[6:7], v13
; GCN-NEXT:    v_lshl_b64 v[4:5], v[4:5], v11
; GCN-NEXT:    v_lshl_b64 v[0:1], v[0:1], v8
; GCN-NEXT:    buffer_store_dwordx4 v[4:7], off, s[0:3], 0 offset:16
; GCN-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0
; GCN-NEXT:    s_endpgm
;
; EG-LABEL: shl_v4i64:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @14, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 3 @6
; EG-NEXT:    ALU 58, @15, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T1.XYZW, T0.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T3.XYZW, T4.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_128 T1.XYZW, T0.X, 48, #1
; EG-NEXT:     VTX_READ_128 T2.XYZW, T0.X, 0, #1
; EG-NEXT:     VTX_READ_128 T3.XYZW, T0.X, 16, #1
; EG-NEXT:     VTX_READ_128 T0.XYZW, T0.X, 32, #1
; EG-NEXT:    ALU clause starting at 14:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 15:
; EG-NEXT:     SUB_INT * T0.W, literal.x, T1.Z,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SUB_INT T4.Z, literal.x, T0.Z,
; EG-NEXT:     SUB_INT T1.W, literal.x, T0.X,
; EG-NEXT:     LSHR * T0.W, T3.Z, PV.W,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SUB_INT T0.Y, literal.x, T1.X,
; EG-NEXT:     LSHR T5.Z, PS, 1,
; EG-NEXT:     LSHR T0.W, T2.X, PV.W,
; EG-NEXT:     LSHR * T1.W, T2.Z, PV.Z,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     LSHL T4.X, T3.W, T1.Z,
; EG-NEXT:     LSHR T1.Y, PS, 1,
; EG-NEXT:     LSHL T4.Z, T2.W, T0.Z, BS:VEC_120/SCL_212
; EG-NEXT:     LSHR T0.W, PV.W, 1,
; EG-NEXT:     LSHL * T1.W, T2.Y, T0.X,
; EG-NEXT:     OR_INT T5.X, PS, PV.W,
; EG-NEXT:     OR_INT T1.Y, PV.Z, PV.Y,
; EG-NEXT:     OR_INT T4.Z, PV.X, T5.Z,
; EG-NEXT:     LSHR T0.W, T3.X, T0.Y,
; EG-NEXT:     ADD_INT * T1.W, T1.Z, literal.x,
; EG-NEXT:    -32(nan), 0(0.000000e+00)
; EG-NEXT:     LSHL T4.X, T3.Z, PS,
; EG-NEXT:     SETGT_UINT T0.Y, T1.Z, literal.x, BS:VEC_120/SCL_212
; EG-NEXT:     ADD_INT T5.Z, T1.X, literal.y,
; EG-NEXT:     LSHR T0.W, PV.W, 1,
; EG-NEXT:     LSHL * T1.W, T3.Y, T1.X,
; EG-NEXT:    31(4.344025e-44), -32(nan)
; EG-NEXT:     OR_INT T6.X, PS, PV.W,
; EG-NEXT:     LSHL T2.Y, T3.X, PV.Z,
; EG-NEXT:     SETGT_UINT T5.Z, T1.X, literal.x, BS:VEC_120/SCL_212
; EG-NEXT:     ADD_INT T0.W, T0.Z, literal.y,
; EG-NEXT:     CNDE_INT * T3.W, PV.Y, T4.Z, PV.X,
; EG-NEXT:    31(4.344025e-44), -32(nan)
; EG-NEXT:     LSHL T4.X, T2.Z, PV.W,
; EG-NEXT:     CNDE_INT T3.Y, PV.Z, PV.X, PV.Y,
; EG-NEXT:     SETGT_UINT * T4.Z, T0.Z, literal.x, BS:VEC_120/SCL_212
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     LSHL T0.W, T3.Z, T1.Z,
; EG-NEXT:     ADD_INT * T1.W, T0.X, literal.x,
; EG-NEXT:    -32(nan), 0(0.000000e+00)
; EG-NEXT:     LSHL T6.X, T2.X, PS,
; EG-NEXT:     SETGT_UINT T2.Y, T0.X, literal.x, BS:VEC_120/SCL_212
; EG-NEXT:     CNDE_INT * T3.Z, T0.Y, PV.W, 0.0,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     LSHL T0.W, T3.X, T1.X, BS:VEC_120/SCL_212
; EG-NEXT:     CNDE_INT * T1.W, T4.Z, T1.Y, T4.X,
; EG-NEXT:     CNDE_INT T3.X, T5.Z, PV.W, 0.0,
; EG-NEXT:     CNDE_INT T1.Y, T2.Y, T5.X, T6.X,
; EG-NEXT:     LSHL T0.W, T2.Z, T0.Z, BS:VEC_120/SCL_212
; EG-NEXT:     ADD_INT * T2.W, KC0[2].Y, literal.x,
; EG-NEXT:    16(2.242078e-44), 0(0.000000e+00)
; EG-NEXT:     LSHR T4.X, PS, literal.x,
; EG-NEXT:     CNDE_INT T1.Z, T4.Z, PV.W, 0.0,
; EG-NEXT:     LSHL * T0.W, T2.X, T0.X,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
; EG-NEXT:     CNDE_INT T1.X, T2.Y, PV.W, 0.0,
; EG-NEXT:     LSHR * T0.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
  %b_ptr = getelementptr <4 x i64>, <4 x i64> addrspace(1)* %in, i64 1
  %a = load <4 x i64>, <4 x i64> addrspace(1)* %in
  %b = load <4 x i64>, <4 x i64> addrspace(1)* %b_ptr
  %result = shl <4 x i64> %a, %b
  store <4 x i64> %result, <4 x i64> addrspace(1)* %out
  ret void
}

; Make sure load width gets reduced to i32 load.
define amdgpu_kernel void @s_shl_32_i64(i64 addrspace(1)* %out, [8 x i32], i64 %a) {
; GCN-LABEL: s_shl_32_i64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x9
; GCN-NEXT:    s_load_dword s0, s[0:1], 0x13
; GCN-NEXT:    s_mov_b32 s7, 0xf000
; GCN-NEXT:    s_mov_b32 s6, -1
; GCN-NEXT:    v_mov_b32_e32 v0, 0
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    v_mov_b32_e32 v1, s0
; GCN-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GCN-NEXT:    s_endpgm
;
; EG-LABEL: s_shl_32_i64:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 3, @4, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XY, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    ALU clause starting at 4:
; EG-NEXT:     MOV * T0.Y, KC0[4].W,
; EG-NEXT:     MOV T0.X, 0.0,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
  %result = shl i64 %a, 32
  store i64 %result, i64 addrspace(1)* %out
  ret void
}

define amdgpu_kernel void @v_shl_32_i64(i64 addrspace(1)* %out, i64 addrspace(1)* %in) {
; GCN-LABEL: v_shl_32_i64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx4 s[8:11], s[0:1], 0x9
; GCN-NEXT:    s_ashr_i32 s3, s2, 31
; GCN-NEXT:    s_lshl_b64 s[0:1], s[2:3], 3
; GCN-NEXT:    v_mov_b32_e32 v0, s0
; GCN-NEXT:    s_mov_b32 s7, 0xf000
; GCN-NEXT:    s_mov_b32 s6, 0
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_mov_b64 s[4:5], s[10:11]
; GCN-NEXT:    v_mov_b32_e32 v1, s1
; GCN-NEXT:    buffer_load_dword v3, v[0:1], s[4:7], 0 addr64
; GCN-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GCN-NEXT:    v_mov_b32_e32 v2, 0
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    buffer_store_dwordx2 v[2:3], v[0:1], s[8:11], 0 addr64
; GCN-NEXT:    s_endpgm
;
; EG-LABEL: v_shl_32_i64:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 2, @8, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @6
; EG-NEXT:    ALU 4, @11, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T1.XY, T2.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_32 T0.X, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 8:
; EG-NEXT:     LSHL * T0.W, T1.X, literal.x,
; EG-NEXT:    3(4.203895e-45), 0(0.000000e+00)
; EG-NEXT:     ADD_INT * T0.X, KC0[2].Z, PV.W,
; EG-NEXT:    ALU clause starting at 11:
; EG-NEXT:     MOV T1.X, 0.0,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, T0.W,
; EG-NEXT:     LSHR T2.X, PV.W, literal.x,
; EG-NEXT:     MOV * T1.Y, T0.X,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
  %tid = call i32 @llvm.amdgcn.workgroup.id.x() #0
  %gep.in = getelementptr i64, i64 addrspace(1)* %in, i32 %tid
  %gep.out = getelementptr i64, i64 addrspace(1)* %out, i32 %tid
  %a = load i64, i64 addrspace(1)* %gep.in
  %result = shl i64 %a, 32
  store i64 %result, i64 addrspace(1)* %gep.out
  ret void
}

define amdgpu_kernel void @s_shl_constant_i64(i64 addrspace(1)* %out, i64 %a) {
; GCN-LABEL: s_shl_constant_i64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; GCN-NEXT:    s_mov_b32 s2, -1
; GCN-NEXT:    s_mov_b32 s9, 0xffff
; GCN-NEXT:    s_mov_b32 s8, s2
; GCN-NEXT:    s_mov_b32 s3, 0xf000
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_mov_b32 s0, s4
; GCN-NEXT:    s_mov_b32 s1, s5
; GCN-NEXT:    s_lshl_b64 s[4:5], s[8:9], s6
; GCN-NEXT:    v_mov_b32_e32 v0, s4
; GCN-NEXT:    v_mov_b32_e32 v1, s5
; GCN-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GCN-NEXT:    s_endpgm
;
; EG-LABEL: s_shl_constant_i64:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 17, @4, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XY, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    ALU clause starting at 4:
; EG-NEXT:     SUB_INT * T0.W, literal.x, KC0[2].W,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     LSHR * T0.W, literal.x, PV.W,
; EG-NEXT:    -1(nan), 0(0.000000e+00)
; EG-NEXT:     ADD_INT T0.Z, KC0[2].W, literal.x,
; EG-NEXT:     LSHR T0.W, PV.W, 1,
; EG-NEXT:     LSHL * T1.W, literal.y, KC0[2].W,
; EG-NEXT:    -32(nan), 65535(9.183409e-41)
; EG-NEXT:     OR_INT T1.Z, PS, PV.W,
; EG-NEXT:     LSHL T0.W, literal.x, PV.Z,
; EG-NEXT:     SETGT_UINT * T1.W, KC0[2].W, literal.y,
; EG-NEXT:    -1(nan), 31(4.344025e-44)
; EG-NEXT:     CNDE_INT T0.Y, PS, PV.Z, PV.W,
; EG-NEXT:     LSHL * T0.W, literal.x, KC0[2].W,
; EG-NEXT:    -1(nan), 0(0.000000e+00)
; EG-NEXT:     CNDE_INT T0.X, T1.W, PV.W, 0.0,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
  %shl = shl i64 281474976710655, %a
  store i64 %shl, i64 addrspace(1)* %out, align 8
  ret void
}

define amdgpu_kernel void @v_shl_constant_i64(i64 addrspace(1)* %out, i64 addrspace(1)* %aptr) {
; GCN-LABEL: v_shl_constant_i64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; GCN-NEXT:    s_mov_b32 s3, 0xf000
; GCN-NEXT:    s_mov_b32 s2, -1
; GCN-NEXT:    s_mov_b32 s10, s2
; GCN-NEXT:    s_mov_b32 s11, s3
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_mov_b32 s8, s6
; GCN-NEXT:    s_mov_b32 s9, s7
; GCN-NEXT:    buffer_load_dword v0, off, s[8:11], 0
; GCN-NEXT:    s_movk_i32 s7, 0x11e
; GCN-NEXT:    s_mov_b32 s6, 0xab19b207
; GCN-NEXT:    s_mov_b32 s0, s4
; GCN-NEXT:    s_mov_b32 s1, s5
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    v_lshl_b64 v[0:1], s[6:7], v0
; GCN-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GCN-NEXT:    s_endpgm
;
; EG-LABEL: v_shl_constant_i64:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @8, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @6
; EG-NEXT:    ALU 17, @9, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XY, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_32 T0.X, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 8:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 9:
; EG-NEXT:     SUB_INT * T0.W, literal.x, T0.X,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     LSHR * T0.W, literal.x, PV.W,
; EG-NEXT:    -1424379385(-5.460358e-13), 0(0.000000e+00)
; EG-NEXT:     ADD_INT T0.Z, T0.X, literal.x,
; EG-NEXT:     LSHR T0.W, PV.W, 1,
; EG-NEXT:     LSHL * T1.W, literal.y, T0.X,
; EG-NEXT:    -32(nan), 286(4.007714e-43)
; EG-NEXT:     OR_INT T1.Z, PS, PV.W,
; EG-NEXT:     SETGT_UINT T0.W, T0.X, literal.x,
; EG-NEXT:     LSHL * T1.W, literal.y, PV.Z,
; EG-NEXT:    31(4.344025e-44), -1424379385(-5.460358e-13)
; EG-NEXT:     CNDE_INT T0.Y, PV.W, PV.Z, PS,
; EG-NEXT:     LSHL * T1.W, literal.x, T0.X,
; EG-NEXT:    -1424379385(-5.460358e-13), 0(0.000000e+00)
; EG-NEXT:     CNDE_INT T0.X, T0.W, PV.W, 0.0,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
  %a = load i64, i64 addrspace(1)* %aptr, align 8
  %shl = shl i64 1231231234567, %a
  store i64 %shl, i64 addrspace(1)* %out, align 8
  ret void
}

define amdgpu_kernel void @v_shl_i64_32_bit_constant(i64 addrspace(1)* %out, i64 addrspace(1)* %aptr) {
; GCN-LABEL: v_shl_i64_32_bit_constant:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; GCN-NEXT:    s_mov_b32 s3, 0xf000
; GCN-NEXT:    s_mov_b32 s2, -1
; GCN-NEXT:    s_mov_b32 s10, s2
; GCN-NEXT:    s_mov_b32 s11, s3
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_mov_b32 s8, s6
; GCN-NEXT:    s_mov_b32 s9, s7
; GCN-NEXT:    buffer_load_dword v0, off, s[8:11], 0
; GCN-NEXT:    s_mov_b32 s7, 0
; GCN-NEXT:    s_mov_b32 s6, 0x12d687
; GCN-NEXT:    s_mov_b32 s0, s4
; GCN-NEXT:    s_mov_b32 s1, s5
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    v_lshl_b64 v[0:1], s[6:7], v0
; GCN-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GCN-NEXT:    s_endpgm
;
; EG-LABEL: v_shl_i64_32_bit_constant:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @8, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @6
; EG-NEXT:    ALU 14, @9, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XY, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_32 T0.X, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 8:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 9:
; EG-NEXT:     SUB_INT T0.W, literal.x, T0.X,
; EG-NEXT:     ADD_INT * T1.W, T0.X, literal.y,
; EG-NEXT:    31(4.344025e-44), -32(nan)
; EG-NEXT:     LSHR * T0.W, literal.x, PV.W,
; EG-NEXT:    1234567(1.729997e-39), 0(0.000000e+00)
; EG-NEXT:     LSHR T0.Z, PV.W, 1,
; EG-NEXT:     LSHL T0.W, literal.x, T1.W,
; EG-NEXT:     SETGT_UINT * T1.W, T0.X, literal.y,
; EG-NEXT:    1234567(1.729997e-39), 31(4.344025e-44)
; EG-NEXT:     CNDE_INT T0.Y, PS, PV.Z, PV.W,
; EG-NEXT:     LSHL * T0.W, literal.x, T0.X,
; EG-NEXT:    1234567(1.729997e-39), 0(0.000000e+00)
; EG-NEXT:     CNDE_INT T0.X, T1.W, PV.W, 0.0,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
  %a = load i64, i64 addrspace(1)* %aptr, align 8
  %shl = shl i64 1234567, %a
  store i64 %shl, i64 addrspace(1)* %out, align 8
  ret void
}

define amdgpu_kernel void @v_shl_inline_imm_64_i64(i64 addrspace(1)* %out, i64 addrspace(1)* %aptr) {
; GCN-LABEL: v_shl_inline_imm_64_i64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; GCN-NEXT:    s_mov_b32 s3, 0xf000
; GCN-NEXT:    s_mov_b32 s2, -1
; GCN-NEXT:    s_mov_b32 s10, s2
; GCN-NEXT:    s_mov_b32 s11, s3
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_mov_b32 s8, s6
; GCN-NEXT:    s_mov_b32 s9, s7
; GCN-NEXT:    buffer_load_dword v0, off, s[8:11], 0
; GCN-NEXT:    s_mov_b32 s0, s4
; GCN-NEXT:    s_mov_b32 s1, s5
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    v_lshl_b64 v[0:1], 64, v0
; GCN-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GCN-NEXT:    s_endpgm
;
; EG-LABEL: v_shl_inline_imm_64_i64:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @8, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @6
; EG-NEXT:    ALU 14, @9, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XY, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_32 T0.X, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 8:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 9:
; EG-NEXT:     SUB_INT T0.W, literal.x, T0.X,
; EG-NEXT:     ADD_INT * T1.W, T0.X, literal.y,
; EG-NEXT:    31(4.344025e-44), -32(nan)
; EG-NEXT:     LSHR * T0.W, literal.x, PV.W,
; EG-NEXT:    64(8.968310e-44), 0(0.000000e+00)
; EG-NEXT:     LSHR T0.Z, PV.W, 1,
; EG-NEXT:     LSHL T0.W, literal.x, T1.W,
; EG-NEXT:     SETGT_UINT * T1.W, T0.X, literal.y,
; EG-NEXT:    64(8.968310e-44), 31(4.344025e-44)
; EG-NEXT:     CNDE_INT T0.Y, PS, PV.Z, PV.W,
; EG-NEXT:     LSHL * T0.W, literal.x, T0.X,
; EG-NEXT:    64(8.968310e-44), 0(0.000000e+00)
; EG-NEXT:     CNDE_INT T0.X, T1.W, PV.W, 0.0,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
  %a = load i64, i64 addrspace(1)* %aptr, align 8
  %shl = shl i64 64, %a
  store i64 %shl, i64 addrspace(1)* %out, align 8
  ret void
}

define amdgpu_kernel void @s_shl_inline_imm_64_i64(i64 addrspace(1)* %out, i64 addrspace(1)* %aptr, i64 %a) {
; GCN-LABEL: s_shl_inline_imm_64_i64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x9
; GCN-NEXT:    s_load_dword s0, s[0:1], 0xd
; GCN-NEXT:    s_mov_b32 s7, 0xf000
; GCN-NEXT:    s_mov_b32 s6, -1
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_lshl_b64 s[0:1], 64, s0
; GCN-NEXT:    v_mov_b32_e32 v0, s0
; GCN-NEXT:    v_mov_b32_e32 v1, s1
; GCN-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GCN-NEXT:    s_endpgm
;
; EG-LABEL: s_shl_inline_imm_64_i64:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 14, @4, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XY, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    ALU clause starting at 4:
; EG-NEXT:     SUB_INT * T0.W, literal.x, KC0[2].W,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     LSHR T0.W, literal.x, PV.W,
; EG-NEXT:     ADD_INT * T1.W, KC0[2].W, literal.y,
; EG-NEXT:    64(8.968310e-44), -32(nan)
; EG-NEXT:     LSHL T0.Z, literal.x, PS,
; EG-NEXT:     LSHR T0.W, PV.W, 1,
; EG-NEXT:     SETGT_UINT * T1.W, KC0[2].W, literal.y,
; EG-NEXT:    64(8.968310e-44), 31(4.344025e-44)
; EG-NEXT:     CNDE_INT T0.Y, PS, PV.W, PV.Z,
; EG-NEXT:     LSHL * T0.W, literal.x, KC0[2].W,
; EG-NEXT:    64(8.968310e-44), 0(0.000000e+00)
; EG-NEXT:     CNDE_INT T0.X, T1.W, PV.W, 0.0,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
  %shl = shl i64 64, %a
  store i64 %shl, i64 addrspace(1)* %out, align 8
  ret void
}

define amdgpu_kernel void @s_shl_inline_imm_1_i64(i64 addrspace(1)* %out, i64 addrspace(1)* %aptr, i64 %a) {
; GCN-LABEL: s_shl_inline_imm_1_i64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x9
; GCN-NEXT:    s_load_dword s0, s[0:1], 0xd
; GCN-NEXT:    s_mov_b32 s7, 0xf000
; GCN-NEXT:    s_mov_b32 s6, -1
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_lshl_b64 s[0:1], 1, s0
; GCN-NEXT:    v_mov_b32_e32 v0, s0
; GCN-NEXT:    v_mov_b32_e32 v1, s1
; GCN-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GCN-NEXT:    s_endpgm
;
; EG-LABEL: s_shl_inline_imm_1_i64:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 8, @4, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XY, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    ALU clause starting at 4:
; EG-NEXT:     ADD_INT T0.Z, KC0[2].W, literal.x,
; EG-NEXT:     SETGT_UINT T0.W, KC0[2].W, literal.y,
; EG-NEXT:     LSHL * T1.W, 1, KC0[2].W,
; EG-NEXT:    -32(nan), 31(4.344025e-44)
; EG-NEXT:     CNDE_INT T0.X, PV.W, PS, 0.0,
; EG-NEXT:     LSHL T1.W, 1, PV.Z,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
; EG-NEXT:     CNDE_INT * T0.Y, T0.W, 0.0, PV.W,
  %shl = shl i64 1, %a
  store i64 %shl, i64 addrspace(1)* %out, align 8
  ret void
}

define amdgpu_kernel void @s_shl_inline_imm_1_0_i64(i64 addrspace(1)* %out, i64 addrspace(1)* %aptr, i64 %a) {
; GCN-LABEL: s_shl_inline_imm_1_0_i64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x9
; GCN-NEXT:    s_load_dword s0, s[0:1], 0xd
; GCN-NEXT:    s_mov_b32 s7, 0xf000
; GCN-NEXT:    s_mov_b32 s6, -1
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_lshl_b64 s[0:1], 1.0, s0
; GCN-NEXT:    v_mov_b32_e32 v0, s0
; GCN-NEXT:    v_mov_b32_e32 v1, s1
; GCN-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GCN-NEXT:    s_endpgm
;
; EG-LABEL: s_shl_inline_imm_1_0_i64:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 6, @4, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XY, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    ALU clause starting at 4:
; EG-NEXT:     SETGT_UINT T0.W, KC0[2].W, literal.x,
; EG-NEXT:     LSHL * T1.W, literal.y, KC0[2].W,
; EG-NEXT:    31(4.344025e-44), 1072693248(1.875000e+00)
; EG-NEXT:     CNDE_INT * T0.Y, PV.W, PS, 0.0,
; EG-NEXT:     MOV T0.X, 0.0,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
  %shl = shl i64 4607182418800017408, %a
  store i64 %shl, i64 addrspace(1)* %out, align 8
  ret void
}

define amdgpu_kernel void @s_shl_inline_imm_neg_1_0_i64(i64 addrspace(1)* %out, i64 addrspace(1)* %aptr, i64 %a) {
; GCN-LABEL: s_shl_inline_imm_neg_1_0_i64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x9
; GCN-NEXT:    s_load_dword s0, s[0:1], 0xd
; GCN-NEXT:    s_mov_b32 s7, 0xf000
; GCN-NEXT:    s_mov_b32 s6, -1
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_lshl_b64 s[0:1], -1.0, s0
; GCN-NEXT:    v_mov_b32_e32 v0, s0
; GCN-NEXT:    v_mov_b32_e32 v1, s1
; GCN-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GCN-NEXT:    s_endpgm
;
; EG-LABEL: s_shl_inline_imm_neg_1_0_i64:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 6, @4, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XY, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    ALU clause starting at 4:
; EG-NEXT:     SETGT_UINT T0.W, KC0[2].W, literal.x,
; EG-NEXT:     LSHL * T1.W, literal.y, KC0[2].W,
; EG-NEXT:    31(4.344025e-44), -1074790400(-1.875000e+00)
; EG-NEXT:     CNDE_INT * T0.Y, PV.W, PS, 0.0,
; EG-NEXT:     MOV T0.X, 0.0,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
  %shl = shl i64 13830554455654793216, %a
  store i64 %shl, i64 addrspace(1)* %out, align 8
  ret void
}

define amdgpu_kernel void @s_shl_inline_imm_0_5_i64(i64 addrspace(1)* %out, i64 addrspace(1)* %aptr, i64 %a) {
; GCN-LABEL: s_shl_inline_imm_0_5_i64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x9
; GCN-NEXT:    s_load_dword s0, s[0:1], 0xd
; GCN-NEXT:    s_mov_b32 s7, 0xf000
; GCN-NEXT:    s_mov_b32 s6, -1
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_lshl_b64 s[0:1], 0.5, s0
; GCN-NEXT:    v_mov_b32_e32 v0, s0
; GCN-NEXT:    v_mov_b32_e32 v1, s1
; GCN-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GCN-NEXT:    s_endpgm
;
; EG-LABEL: s_shl_inline_imm_0_5_i64:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 6, @4, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XY, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    ALU clause starting at 4:
; EG-NEXT:     SETGT_UINT T0.W, KC0[2].W, literal.x,
; EG-NEXT:     LSHL * T1.W, literal.y, KC0[2].W,
; EG-NEXT:    31(4.344025e-44), 1071644672(1.750000e+00)
; EG-NEXT:     CNDE_INT * T0.Y, PV.W, PS, 0.0,
; EG-NEXT:     MOV T0.X, 0.0,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
  %shl = shl i64 4602678819172646912, %a
  store i64 %shl, i64 addrspace(1)* %out, align 8
  ret void
}

define amdgpu_kernel void @s_shl_inline_imm_neg_0_5_i64(i64 addrspace(1)* %out, i64 addrspace(1)* %aptr, i64 %a) {
; GCN-LABEL: s_shl_inline_imm_neg_0_5_i64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x9
; GCN-NEXT:    s_load_dword s0, s[0:1], 0xd
; GCN-NEXT:    s_mov_b32 s7, 0xf000
; GCN-NEXT:    s_mov_b32 s6, -1
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_lshl_b64 s[0:1], -0.5, s0
; GCN-NEXT:    v_mov_b32_e32 v0, s0
; GCN-NEXT:    v_mov_b32_e32 v1, s1
; GCN-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GCN-NEXT:    s_endpgm
;
; EG-LABEL: s_shl_inline_imm_neg_0_5_i64:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 6, @4, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XY, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    ALU clause starting at 4:
; EG-NEXT:     SETGT_UINT T0.W, KC0[2].W, literal.x,
; EG-NEXT:     LSHL * T1.W, literal.y, KC0[2].W,
; EG-NEXT:    31(4.344025e-44), -1075838976(-1.750000e+00)
; EG-NEXT:     CNDE_INT * T0.Y, PV.W, PS, 0.0,
; EG-NEXT:     MOV T0.X, 0.0,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
  %shl = shl i64 13826050856027422720, %a
  store i64 %shl, i64 addrspace(1)* %out, align 8
  ret void
}

define amdgpu_kernel void @s_shl_inline_imm_2_0_i64(i64 addrspace(1)* %out, i64 addrspace(1)* %aptr, i64 %a) {
; GCN-LABEL: s_shl_inline_imm_2_0_i64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x9
; GCN-NEXT:    s_load_dword s0, s[0:1], 0xd
; GCN-NEXT:    s_mov_b32 s7, 0xf000
; GCN-NEXT:    s_mov_b32 s6, -1
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_lshl_b64 s[0:1], 2.0, s0
; GCN-NEXT:    v_mov_b32_e32 v0, s0
; GCN-NEXT:    v_mov_b32_e32 v1, s1
; GCN-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GCN-NEXT:    s_endpgm
;
; EG-LABEL: s_shl_inline_imm_2_0_i64:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 6, @4, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XY, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    ALU clause starting at 4:
; EG-NEXT:     SETGT_UINT T0.W, KC0[2].W, literal.x,
; EG-NEXT:     LSHL * T1.W, literal.y, KC0[2].W,
; EG-NEXT:    31(4.344025e-44), 1073741824(2.000000e+00)
; EG-NEXT:     CNDE_INT * T0.Y, PV.W, PS, 0.0,
; EG-NEXT:     MOV T0.X, 0.0,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
  %shl = shl i64 4611686018427387904, %a
  store i64 %shl, i64 addrspace(1)* %out, align 8
  ret void
}

define amdgpu_kernel void @s_shl_inline_imm_neg_2_0_i64(i64 addrspace(1)* %out, i64 addrspace(1)* %aptr, i64 %a) {
; GCN-LABEL: s_shl_inline_imm_neg_2_0_i64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x9
; GCN-NEXT:    s_load_dword s0, s[0:1], 0xd
; GCN-NEXT:    s_mov_b32 s7, 0xf000
; GCN-NEXT:    s_mov_b32 s6, -1
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_lshl_b64 s[0:1], -2.0, s0
; GCN-NEXT:    v_mov_b32_e32 v0, s0
; GCN-NEXT:    v_mov_b32_e32 v1, s1
; GCN-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GCN-NEXT:    s_endpgm
;
; EG-LABEL: s_shl_inline_imm_neg_2_0_i64:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 6, @4, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XY, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    ALU clause starting at 4:
; EG-NEXT:     SETGT_UINT T0.W, KC0[2].W, literal.x,
; EG-NEXT:     LSHL * T1.W, literal.y, KC0[2].W,
; EG-NEXT:    31(4.344025e-44), -1073741824(-2.000000e+00)
; EG-NEXT:     CNDE_INT * T0.Y, PV.W, PS, 0.0,
; EG-NEXT:     MOV T0.X, 0.0,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
  %shl = shl i64 13835058055282163712, %a
  store i64 %shl, i64 addrspace(1)* %out, align 8
  ret void
}

define amdgpu_kernel void @s_shl_inline_imm_4_0_i64(i64 addrspace(1)* %out, i64 addrspace(1)* %aptr, i64 %a) {
; GCN-LABEL: s_shl_inline_imm_4_0_i64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x9
; GCN-NEXT:    s_load_dword s0, s[0:1], 0xd
; GCN-NEXT:    s_mov_b32 s7, 0xf000
; GCN-NEXT:    s_mov_b32 s6, -1
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_lshl_b64 s[0:1], 4.0, s0
; GCN-NEXT:    v_mov_b32_e32 v0, s0
; GCN-NEXT:    v_mov_b32_e32 v1, s1
; GCN-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GCN-NEXT:    s_endpgm
;
; EG-LABEL: s_shl_inline_imm_4_0_i64:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 6, @4, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XY, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    ALU clause starting at 4:
; EG-NEXT:     SETGT_UINT T0.W, KC0[2].W, literal.x,
; EG-NEXT:     LSHL * T1.W, literal.y, KC0[2].W,
; EG-NEXT:    31(4.344025e-44), 1074790400(2.250000e+00)
; EG-NEXT:     CNDE_INT * T0.Y, PV.W, PS, 0.0,
; EG-NEXT:     MOV T0.X, 0.0,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
  %shl = shl i64 4616189618054758400, %a
  store i64 %shl, i64 addrspace(1)* %out, align 8
  ret void
}

define amdgpu_kernel void @s_shl_inline_imm_neg_4_0_i64(i64 addrspace(1)* %out, i64 addrspace(1)* %aptr, i64 %a) {
; GCN-LABEL: s_shl_inline_imm_neg_4_0_i64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x9
; GCN-NEXT:    s_load_dword s0, s[0:1], 0xd
; GCN-NEXT:    s_mov_b32 s7, 0xf000
; GCN-NEXT:    s_mov_b32 s6, -1
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_lshl_b64 s[0:1], -4.0, s0
; GCN-NEXT:    v_mov_b32_e32 v0, s0
; GCN-NEXT:    v_mov_b32_e32 v1, s1
; GCN-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GCN-NEXT:    s_endpgm
;
; EG-LABEL: s_shl_inline_imm_neg_4_0_i64:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 6, @4, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XY, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    ALU clause starting at 4:
; EG-NEXT:     SETGT_UINT T0.W, KC0[2].W, literal.x,
; EG-NEXT:     LSHL * T1.W, literal.y, KC0[2].W,
; EG-NEXT:    31(4.344025e-44), -1072693248(-2.250000e+00)
; EG-NEXT:     CNDE_INT * T0.Y, PV.W, PS, 0.0,
; EG-NEXT:     MOV T0.X, 0.0,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
  %shl = shl i64 13839561654909534208, %a
  store i64 %shl, i64 addrspace(1)* %out, align 8
  ret void
}


; Test with the 64-bit integer bitpattern for a 32-bit float in the
; low 32-bits, which is not a valid 64-bit inline immmediate.
define amdgpu_kernel void @s_shl_inline_imm_f32_4_0_i64(i64 addrspace(1)* %out, i64 addrspace(1)* %aptr, i64 %a) {
; GCN-LABEL: s_shl_inline_imm_f32_4_0_i64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x9
; GCN-NEXT:    s_load_dword s2, s[0:1], 0xd
; GCN-NEXT:    s_mov_b32 s1, 0
; GCN-NEXT:    s_mov_b32 s0, 4.0
; GCN-NEXT:    s_mov_b32 s7, 0xf000
; GCN-NEXT:    s_mov_b32 s6, -1
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_lshl_b64 s[0:1], s[0:1], s2
; GCN-NEXT:    v_mov_b32_e32 v0, s0
; GCN-NEXT:    v_mov_b32_e32 v1, s1
; GCN-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GCN-NEXT:    s_endpgm
;
; EG-LABEL: s_shl_inline_imm_f32_4_0_i64:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 14, @4, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XY, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    ALU clause starting at 4:
; EG-NEXT:     SUB_INT * T0.W, literal.x, KC0[2].W,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     LSHR T0.W, literal.x, PV.W,
; EG-NEXT:     ADD_INT * T1.W, KC0[2].W, literal.y,
; EG-NEXT:    1082130432(4.000000e+00), -32(nan)
; EG-NEXT:     LSHL T0.Z, literal.x, PS,
; EG-NEXT:     LSHR T0.W, PV.W, 1,
; EG-NEXT:     SETGT_UINT * T1.W, KC0[2].W, literal.y,
; EG-NEXT:    1082130432(4.000000e+00), 31(4.344025e-44)
; EG-NEXT:     CNDE_INT T0.Y, PS, PV.W, PV.Z,
; EG-NEXT:     LSHL * T0.W, literal.x, KC0[2].W,
; EG-NEXT:    1082130432(4.000000e+00), 0(0.000000e+00)
; EG-NEXT:     CNDE_INT T0.X, T1.W, PV.W, 0.0,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
  %shl = shl i64 1082130432, %a
  store i64 %shl, i64 addrspace(1)* %out, align 8
  ret void
}

; FIXME: Copy of -1 register
define amdgpu_kernel void @s_shl_inline_imm_f32_neg_4_0_i64(i64 addrspace(1)* %out, i64 addrspace(1)* %aptr, i64 %a) {
; GCN-LABEL: s_shl_inline_imm_f32_neg_4_0_i64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x9
; GCN-NEXT:    s_load_dword s2, s[0:1], 0xd
; GCN-NEXT:    s_mov_b32 s6, -1
; GCN-NEXT:    s_mov_b32 s0, -4.0
; GCN-NEXT:    s_mov_b32 s1, s6
; GCN-NEXT:    s_mov_b32 s7, 0xf000
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_lshl_b64 s[0:1], s[0:1], s2
; GCN-NEXT:    v_mov_b32_e32 v0, s0
; GCN-NEXT:    v_mov_b32_e32 v1, s1
; GCN-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GCN-NEXT:    s_endpgm
;
; EG-LABEL: s_shl_inline_imm_f32_neg_4_0_i64:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 17, @4, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XY, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    ALU clause starting at 4:
; EG-NEXT:     SUB_INT * T0.W, literal.x, KC0[2].W,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     LSHR * T0.W, literal.x, PV.W,
; EG-NEXT:    -1065353216(-4.000000e+00), 0(0.000000e+00)
; EG-NEXT:     ADD_INT T0.Z, KC0[2].W, literal.x,
; EG-NEXT:     LSHR T0.W, PV.W, 1,
; EG-NEXT:     LSHL * T1.W, literal.y, KC0[2].W,
; EG-NEXT:    -32(nan), -1(nan)
; EG-NEXT:     OR_INT T1.Z, PS, PV.W,
; EG-NEXT:     LSHL T0.W, literal.x, PV.Z,
; EG-NEXT:     SETGT_UINT * T1.W, KC0[2].W, literal.y,
; EG-NEXT:    -1065353216(-4.000000e+00), 31(4.344025e-44)
; EG-NEXT:     CNDE_INT T0.Y, PS, PV.Z, PV.W,
; EG-NEXT:     LSHL * T0.W, literal.x, KC0[2].W,
; EG-NEXT:    -1065353216(-4.000000e+00), 0(0.000000e+00)
; EG-NEXT:     CNDE_INT T0.X, T1.W, PV.W, 0.0,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
  %shl = shl i64 -1065353216, %a
  store i64 %shl, i64 addrspace(1)* %out, align 8
  ret void
}

define amdgpu_kernel void @s_shl_inline_high_imm_f32_4_0_i64(i64 addrspace(1)* %out, i64 addrspace(1)* %aptr, i64 %a) {
; GCN-LABEL: s_shl_inline_high_imm_f32_4_0_i64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x9
; GCN-NEXT:    s_load_dword s2, s[0:1], 0xd
; GCN-NEXT:    s_mov_b32 s1, 4.0
; GCN-NEXT:    s_mov_b32 s0, 0
; GCN-NEXT:    s_mov_b32 s7, 0xf000
; GCN-NEXT:    s_mov_b32 s6, -1
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_lshl_b64 s[0:1], s[0:1], s2
; GCN-NEXT:    v_mov_b32_e32 v0, s0
; GCN-NEXT:    v_mov_b32_e32 v1, s1
; GCN-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GCN-NEXT:    s_endpgm
;
; EG-LABEL: s_shl_inline_high_imm_f32_4_0_i64:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 6, @4, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XY, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    ALU clause starting at 4:
; EG-NEXT:     SETGT_UINT T0.W, KC0[2].W, literal.x,
; EG-NEXT:     LSHL * T1.W, literal.y, KC0[2].W,
; EG-NEXT:    31(4.344025e-44), 1082130432(4.000000e+00)
; EG-NEXT:     CNDE_INT * T0.Y, PV.W, PS, 0.0,
; EG-NEXT:     MOV T0.X, 0.0,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
  %shl = shl i64 4647714815446351872, %a
  store i64 %shl, i64 addrspace(1)* %out, align 8
  ret void
}

define amdgpu_kernel void @s_shl_inline_high_imm_f32_neg_4_0_i64(i64 addrspace(1)* %out, i64 addrspace(1)* %aptr, i64 %a) {
; GCN-LABEL: s_shl_inline_high_imm_f32_neg_4_0_i64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x9
; GCN-NEXT:    s_load_dword s2, s[0:1], 0xd
; GCN-NEXT:    s_mov_b32 s1, -4.0
; GCN-NEXT:    s_mov_b32 s0, 0
; GCN-NEXT:    s_mov_b32 s7, 0xf000
; GCN-NEXT:    s_mov_b32 s6, -1
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_lshl_b64 s[0:1], s[0:1], s2
; GCN-NEXT:    v_mov_b32_e32 v0, s0
; GCN-NEXT:    v_mov_b32_e32 v1, s1
; GCN-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GCN-NEXT:    s_endpgm
;
; EG-LABEL: s_shl_inline_high_imm_f32_neg_4_0_i64:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 6, @4, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XY, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    ALU clause starting at 4:
; EG-NEXT:     SETGT_UINT T0.W, KC0[2].W, literal.x,
; EG-NEXT:     LSHL * T1.W, literal.y, KC0[2].W,
; EG-NEXT:    31(4.344025e-44), -1065353216(-4.000000e+00)
; EG-NEXT:     CNDE_INT * T0.Y, PV.W, PS, 0.0,
; EG-NEXT:     MOV T0.X, 0.0,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
  %shl = shl i64 13871086852301127680, %a
  store i64 %shl, i64 addrspace(1)* %out, align 8
  ret void
}

define amdgpu_kernel void @test_mul2(i32 %p) {
; GCN-LABEL: test_mul2:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dword s0, s[0:1], 0x9
; GCN-NEXT:    s_mov_b32 s3, 0xf000
; GCN-NEXT:    s_mov_b32 s2, -1
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_lshl_b32 s0, s0, 1
; GCN-NEXT:    v_mov_b32_e32 v0, s0
; GCN-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    s_endpgm
;
; EG-LABEL: test_mul2:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 2, @4, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T1.X, T0.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    ALU clause starting at 4:
; EG-NEXT:     MOV T0.X, literal.x,
; EG-NEXT:     LSHL * T1.X, KC0[2].Y, 1,
; EG-NEXT:    0(0.000000e+00), 0(0.000000e+00)
   %i = mul i32 %p, 2
   store volatile i32 %i, i32 addrspace(1)* undef
   ret void
}

define void @shl_or_k(i32 addrspace(1)* %out, i32 %in) {
; GCN-LABEL: shl_or_k:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    s_mov_b32 s6, 0
; GCN-NEXT:    v_lshlrev_b32_e32 v2, 2, v2
; GCN-NEXT:    s_mov_b32 s7, 0xf000
; GCN-NEXT:    s_mov_b32 s4, s6
; GCN-NEXT:    s_mov_b32 s5, s6
; GCN-NEXT:    v_or_b32_e32 v2, 4, v2
; GCN-NEXT:    buffer_store_dword v2, v[0:1], s[4:7], 0 addr64
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; GCN-NEXT:    s_setpc_b64 s[30:31]
;
; EG-LABEL: shl_or_k:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 4, @4, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.X, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    ALU clause starting at 4:
; EG-NEXT:     LSHL * T0.W, KC0[2].Z, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
; EG-NEXT:     OR_INT T0.X, PV.W, literal.x,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.y,
; EG-NEXT:    4(5.605194e-45), 2(2.802597e-45)
  %tmp0 = or i32 %in, 1
  %tmp2 = shl i32 %tmp0, 2
  store i32 %tmp2, i32 addrspace(1)* %out
  ret void
}

define void @shl_or_k_two_uses(i32 addrspace(1)* %out0, i32 addrspace(1)* %out1, i32 %in) {
; GCN-LABEL: shl_or_k_two_uses:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    s_mov_b32 s6, 0
; GCN-NEXT:    v_or_b32_e32 v4, 1, v4
; GCN-NEXT:    s_mov_b32 s7, 0xf000
; GCN-NEXT:    s_mov_b32 s4, s6
; GCN-NEXT:    s_mov_b32 s5, s6
; GCN-NEXT:    v_lshlrev_b32_e32 v5, 2, v4
; GCN-NEXT:    buffer_store_dword v5, v[0:1], s[4:7], 0 addr64
; GCN-NEXT:    buffer_store_dword v4, v[2:3], s[4:7], 0 addr64
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; GCN-NEXT:    s_setpc_b64 s[30:31]
;
; EG-LABEL: shl_or_k_two_uses:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 5, @4, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T2.X, T3.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T1.X, T0.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    ALU clause starting at 4:
; EG-NEXT:     LSHR T0.X, KC0[2].Z, literal.x,
; EG-NEXT:     OR_INT * T1.X, KC0[2].W, 1,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
; EG-NEXT:     LSHL T2.X, PS, literal.x,
; EG-NEXT:     LSHR * T3.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
  %tmp0 = or i32 %in, 1
  %tmp2 = shl i32 %tmp0, 2
  store i32 %tmp2, i32 addrspace(1)* %out0
  store i32 %tmp0, i32 addrspace(1)* %out1
  ret void
}

attributes #0 = { nounwind readnone }
