; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=i686-unknown-linux-gnu %s -o - | FileCheck %s --check-prefix=CHECK --check-prefix=CHECK32
; RUN: llc -mtriple=x86_64-unknown-linux-gnu %s -o - | FileCheck %s --check-prefix=CHECK --check-prefix=CHECK64

define void @zero_optsize(i32* %p) optsize {
; CHECK32-LABEL: zero_optsize:
; CHECK32:       # %bb.0: # %entry
; CHECK32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; CHECK32-NEXT:    movl $0, (%eax)
; CHECK32-NEXT:    retl
;
; CHECK64-LABEL: zero_optsize:
; CHECK64:       # %bb.0: # %entry
; CHECK64-NEXT:    movl $0, (%rdi)
; CHECK64-NEXT:    retq
entry:
  store i32 0, i32* %p
  ret void

}

define void @zero_pgso(i32* %p) !prof !14 {
; CHECK32-LABEL: zero_pgso:
; CHECK32:       # %bb.0: # %entry
; CHECK32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; CHECK32-NEXT:    movl $0, (%eax)
; CHECK32-NEXT:    retl
;
; CHECK64-LABEL: zero_pgso:
; CHECK64:       # %bb.0: # %entry
; CHECK64-NEXT:    movl $0, (%rdi)
; CHECK64-NEXT:    retq
entry:
  store i32 0, i32* %p
  ret void

}

define void @minus_one_optsize(i32* %p) optsize {
; CHECK32-LABEL: minus_one_optsize:
; CHECK32:       # %bb.0: # %entry
; CHECK32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; CHECK32-NEXT:    movl $-1, (%eax)
; CHECK32-NEXT:    retl
;
; CHECK64-LABEL: minus_one_optsize:
; CHECK64:       # %bb.0: # %entry
; CHECK64-NEXT:    movl $-1, (%rdi)
; CHECK64-NEXT:    retq
entry:
  store i32 -1, i32* %p
  ret void

}

define void @minus_one_pgso(i32* %p) !prof !14 {
; CHECK32-LABEL: minus_one_pgso:
; CHECK32:       # %bb.0: # %entry
; CHECK32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; CHECK32-NEXT:    movl $-1, (%eax)
; CHECK32-NEXT:    retl
;
; CHECK64-LABEL: minus_one_pgso:
; CHECK64:       # %bb.0: # %entry
; CHECK64-NEXT:    movl $-1, (%rdi)
; CHECK64-NEXT:    retq
entry:
  store i32 -1, i32* %p
  ret void

}

define void @zero_64(i64* %p) minsize {
; CHECK32-LABEL: zero_64:
; CHECK32:       # %bb.0: # %entry
; CHECK32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; CHECK32-NEXT:    andl $0, 4(%eax)
; CHECK32-NEXT:    andl $0, (%eax)
; CHECK32-NEXT:    retl
;
; CHECK64-LABEL: zero_64:
; CHECK64:       # %bb.0: # %entry
; CHECK64-NEXT:    andq $0, (%rdi)
; CHECK64-NEXT:    retq
entry:
  store i64 0, i64* %p
  ret void

}

define void @zero_32(i32* %p) minsize {
; CHECK32-LABEL: zero_32:
; CHECK32:       # %bb.0: # %entry
; CHECK32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; CHECK32-NEXT:    andl $0, (%eax)
; CHECK32-NEXT:    retl
;
; CHECK64-LABEL: zero_32:
; CHECK64:       # %bb.0: # %entry
; CHECK64-NEXT:    andl $0, (%rdi)
; CHECK64-NEXT:    retq
entry:
  store i32 0, i32* %p
  ret void

}

define void @zero_16(i16* %p) minsize {
; CHECK32-LABEL: zero_16:
; CHECK32:       # %bb.0: # %entry
; CHECK32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; CHECK32-NEXT:    andw $0, (%eax)
; CHECK32-NEXT:    retl
;
; CHECK64-LABEL: zero_16:
; CHECK64:       # %bb.0: # %entry
; CHECK64-NEXT:    andw $0, (%rdi)
; CHECK64-NEXT:    retq
entry:
  store i16 0, i16* %p
  ret void

}


define void @minus_one_64(i64* %p) minsize {
; CHECK32-LABEL: minus_one_64:
; CHECK32:       # %bb.0: # %entry
; CHECK32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; CHECK32-NEXT:    orl $-1, 4(%eax)
; CHECK32-NEXT:    orl $-1, (%eax)
; CHECK32-NEXT:    retl
;
; CHECK64-LABEL: minus_one_64:
; CHECK64:       # %bb.0: # %entry
; CHECK64-NEXT:    orq $-1, (%rdi)
; CHECK64-NEXT:    retq
entry:
  store i64 -1, i64* %p
  ret void

}

define void @minus_one_32(i32* %p) minsize {
; CHECK32-LABEL: minus_one_32:
; CHECK32:       # %bb.0: # %entry
; CHECK32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; CHECK32-NEXT:    orl $-1, (%eax)
; CHECK32-NEXT:    retl
;
; CHECK64-LABEL: minus_one_32:
; CHECK64:       # %bb.0: # %entry
; CHECK64-NEXT:    orl $-1, (%rdi)
; CHECK64-NEXT:    retq
entry:
  store i32 -1, i32* %p
  ret void

}

define void @minus_one_16(i16* %p) minsize {
; CHECK32-LABEL: minus_one_16:
; CHECK32:       # %bb.0: # %entry
; CHECK32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; CHECK32-NEXT:    orw $-1, (%eax)
; CHECK32-NEXT:    retl
;
; CHECK64-LABEL: minus_one_16:
; CHECK64:       # %bb.0: # %entry
; CHECK64-NEXT:    orw $-1, (%rdi)
; CHECK64-NEXT:    retq
entry:
  store i16 -1, i16* %p
  ret void

}

; FIXME: Make sure we don't use the and/or trick on volatile stores.
define void @volatile_zero_64(i64* %p) minsize {
; CHECK32-LABEL: volatile_zero_64:
; CHECK32:       # %bb.0: # %entry
; CHECK32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; CHECK32-NEXT:    xorl %ecx, %ecx
; CHECK32-NEXT:    movl %ecx, 4(%eax)
; CHECK32-NEXT:    movl %ecx, (%eax)
; CHECK32-NEXT:    retl
;
; CHECK64-LABEL: volatile_zero_64:
; CHECK64:       # %bb.0: # %entry
; CHECK64-NEXT:    movq $0, (%rdi)
; CHECK64-NEXT:    retq
entry:
  store volatile i64 0, i64* %p
  ret void
}

define void @volatile_zero_32(i32* %p) minsize {
; CHECK32-LABEL: volatile_zero_32:
; CHECK32:       # %bb.0: # %entry
; CHECK32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; CHECK32-NEXT:    movl $0, (%eax)
; CHECK32-NEXT:    retl
;
; CHECK64-LABEL: volatile_zero_32:
; CHECK64:       # %bb.0: # %entry
; CHECK64-NEXT:    movl $0, (%rdi)
; CHECK64-NEXT:    retq
entry:
  store volatile i32 0, i32* %p
  ret void
}

define void @volatile_zero_16(i16* %p) minsize {
; CHECK32-LABEL: volatile_zero_16:
; CHECK32:       # %bb.0: # %entry
; CHECK32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; CHECK32-NEXT:    movw $0, (%eax)
; CHECK32-NEXT:    retl
;
; CHECK64-LABEL: volatile_zero_16:
; CHECK64:       # %bb.0: # %entry
; CHECK64-NEXT:    movw $0, (%rdi)
; CHECK64-NEXT:    retq
entry:
  store volatile i16 0, i16* %p
  ret void
}


define void @volatile_minus_one_64(i64* %p) minsize {
; CHECK32-LABEL: volatile_minus_one_64:
; CHECK32:       # %bb.0: # %entry
; CHECK32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; CHECK32-NEXT:    xorl %ecx, %ecx
; CHECK32-NEXT:    decl %ecx
; CHECK32-NEXT:    movl %ecx, 4(%eax)
; CHECK32-NEXT:    movl %ecx, (%eax)
; CHECK32-NEXT:    retl
;
; CHECK64-LABEL: volatile_minus_one_64:
; CHECK64:       # %bb.0: # %entry
; CHECK64-NEXT:    movq $-1, (%rdi)
; CHECK64-NEXT:    retq
entry:
  store volatile i64 -1, i64* %p
  ret void
}

define void @volatile_minus_one_32(i32* %p) minsize {
; CHECK32-LABEL: volatile_minus_one_32:
; CHECK32:       # %bb.0: # %entry
; CHECK32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; CHECK32-NEXT:    movl $-1, (%eax)
; CHECK32-NEXT:    retl
;
; CHECK64-LABEL: volatile_minus_one_32:
; CHECK64:       # %bb.0: # %entry
; CHECK64-NEXT:    movl $-1, (%rdi)
; CHECK64-NEXT:    retq
entry:
  store volatile i32 -1, i32* %p
  ret void
}

define void @volatile_minus_one_16(i16* %p) minsize {
; CHECK32-LABEL: volatile_minus_one_16:
; CHECK32:       # %bb.0: # %entry
; CHECK32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; CHECK32-NEXT:    movw $-1, (%eax)
; CHECK32-NEXT:    retl
;
; CHECK64-LABEL: volatile_minus_one_16:
; CHECK64:       # %bb.0: # %entry
; CHECK64-NEXT:    movw $-1, (%rdi)
; CHECK64-NEXT:    retq
entry:
  store volatile i16 -1, i16* %p
  ret void
}

!llvm.module.flags = !{!0}
!0 = !{i32 1, !"ProfileSummary", !1}
!1 = !{!2, !3, !4, !5, !6, !7, !8, !9}
!2 = !{!"ProfileFormat", !"InstrProf"}
!3 = !{!"TotalCount", i64 10000}
!4 = !{!"MaxCount", i64 10}
!5 = !{!"MaxInternalCount", i64 1}
!6 = !{!"MaxFunctionCount", i64 1000}
!7 = !{!"NumCounts", i64 3}
!8 = !{!"NumFunctions", i64 3}
!9 = !{!"DetailedSummary", !10}
!10 = !{!11, !12, !13}
!11 = !{i32 10000, i64 100, i32 1}
!12 = !{i32 999000, i64 100, i32 1}
!13 = !{i32 999999, i64 1, i32 2}
!14 = !{!"function_entry_count", i64 0}
