/* SPDX-License-Identifier: GPL-2.0-only */
/*
 * Copyright (c) 2022 MediaTek Inc.
 * Author: Garmin Chang <garmin.chang@mediatek.com>
 */

#ifndef __SOC_MEDIATEK_MT8188_PM_DOMAINS_H
#define __SOC_MEDIATEK_MT8188_PM_DOMAINS_H

#include "mtk-pm-domains.h"
#include <dt-bindings/power/mediatek,mt8188-power.h>

/*
 * MT8188 power domain support
 */

static const struct scpsys_domain_data scpsys_domain_data_mt8188[] = {
	[MT8188_POWER_DOMAIN_MFG0] = {
		.name = "mfg0",
		.sta_mask = BIT(1),
		.ctl_offs = 0x300,
		.pwr_sta_offs = 0x174,
		.pwr_sta2nd_offs = 0x178,
		.sram_pdn_bits = BIT(8),
		.sram_pdn_ack_bits = BIT(12),
		.caps = MTK_SCPD_KEEP_DEFAULT_OFF | MTK_SCPD_DOMAIN_SUPPLY,
	},
	[MT8188_POWER_DOMAIN_MFG1] = {
		.name = "mfg1",
		.sta_mask = BIT(2),
		.ctl_offs = 0x304,
		.pwr_sta_offs = 0x174,
		.pwr_sta2nd_offs = 0x178,
		.sram_pdn_bits = BIT(8),
		.sram_pdn_ack_bits = BIT(12),
		.bp_cfg = {
			BUS_PROT_WR(INFRA,
				    MT8188_TOP_AXI_PROT_EN_MFG1_STEP1,
				    MT8188_TOP_AXI_PROT_EN_SET,
				    MT8188_TOP_AXI_PROT_EN_CLR,
				    MT8188_TOP_AXI_PROT_EN_STA),
			BUS_PROT_WR(INFRA,
				    MT8188_TOP_AXI_PROT_EN_2_MFG1_STEP2,
				    MT8188_TOP_AXI_PROT_EN_2_SET,
				    MT8188_TOP_AXI_PROT_EN_2_CLR,
				    MT8188_TOP_AXI_PROT_EN_2_STA),
			BUS_PROT_WR(INFRA,
				    MT8188_TOP_AXI_PROT_EN_1_MFG1_STEP3,
				    MT8188_TOP_AXI_PROT_EN_1_SET,
				    MT8188_TOP_AXI_PROT_EN_1_CLR,
				    MT8188_TOP_AXI_PROT_EN_1_STA),
			BUS_PROT_WR(INFRA,
				    MT8188_TOP_AXI_PROT_EN_2_MFG1_STEP4,
				    MT8188_TOP_AXI_PROT_EN_2_SET,
				    MT8188_TOP_AXI_PROT_EN_2_CLR,
				    MT8188_TOP_AXI_PROT_EN_2_STA),
			BUS_PROT_WR(INFRA,
				    MT8188_TOP_AXI_PROT_EN_MFG1_STEP5,
				    MT8188_TOP_AXI_PROT_EN_SET,
				    MT8188_TOP_AXI_PROT_EN_CLR,
				    MT8188_TOP_AXI_PROT_EN_STA),
			BUS_PROT_WR(INFRA,
				    MT8188_TOP_AXI_PROT_EN_SUB_INFRA_VDNR_MFG1_STEP6,
				    MT8188_TOP_AXI_PROT_EN_SUB_INFRA_VDNR_SET,
				    MT8188_TOP_AXI_PROT_EN_SUB_INFRA_VDNR_CLR,
				    MT8188_TOP_AXI_PROT_EN_SUB_INFRA_VDNR_STA),
		},
		.caps = MTK_SCPD_KEEP_DEFAULT_OFF | MTK_SCPD_DOMAIN_SUPPLY,
	},
	[MT8188_POWER_DOMAIN_MFG2] = {
		.name = "mfg2",
		.sta_mask = BIT(3),
		.ctl_offs = 0x308,
		.pwr_sta_offs = 0x174,
		.pwr_sta2nd_offs = 0x178,
		.sram_pdn_bits = BIT(8),
		.sram_pdn_ack_bits = BIT(12),
		.caps = MTK_SCPD_KEEP_DEFAULT_OFF,
	},
	[MT8188_POWER_DOMAIN_MFG3] = {
		.name = "mfg3",
		.sta_mask = BIT(4),
		.ctl_offs = 0x30C,
		.pwr_sta_offs = 0x174,
		.pwr_sta2nd_offs = 0x178,
		.sram_pdn_bits = BIT(8),
		.sram_pdn_ack_bits = BIT(12),
		.caps = MTK_SCPD_KEEP_DEFAULT_OFF,
	},
	[MT8188_POWER_DOMAIN_MFG4] = {
		.name = "mfg4",
		.sta_mask = BIT(5),
		.ctl_offs = 0x310,
		.pwr_sta_offs = 0x174,
		.pwr_sta2nd_offs = 0x178,
		.sram_pdn_bits = BIT(8),
		.sram_pdn_ack_bits = BIT(12),
		.caps = MTK_SCPD_KEEP_DEFAULT_OFF,
	},
	[MT8188_POWER_DOMAIN_PEXTP_MAC_P0] = {
		.name = "pextp_mac_p0",
		.sta_mask = BIT(10),
		.ctl_offs = 0x324,
		.pwr_sta_offs = 0x174,
		.pwr_sta2nd_offs = 0x178,
		.sram_pdn_bits = BIT(8),
		.sram_pdn_ack_bits = BIT(12),
		.bp_cfg = {
			BUS_PROT_WR(INFRA,
				    MT8188_TOP_AXI_PROT_EN_PEXTP_MAC_P0_STEP1,
				    MT8188_TOP_AXI_PROT_EN_SET,
				    MT8188_TOP_AXI_PROT_EN_CLR,
				    MT8188_TOP_AXI_PROT_EN_STA),
			BUS_PROT_WR(INFRA,
				    MT8188_TOP_AXI_PROT_EN_INFRA_VDNR_PEXTP_MAC_P0_STEP2,
				    MT8188_TOP_AXI_PROT_EN_INFRA_VDNR_SET,
				    MT8188_TOP_AXI_PROT_EN_INFRA_VDNR_CLR,
				    MT8188_TOP_AXI_PROT_EN_INFRA_VDNR_STA),
		},
		.caps = MTK_SCPD_KEEP_DEFAULT_OFF,
	},
	[MT8188_POWER_DOMAIN_PEXTP_PHY_TOP] = {
		.name = "pextp_phy_top",
		.sta_mask = BIT(12),
		.ctl_offs = 0x328,
		.pwr_sta_offs = 0x174,
		.pwr_sta2nd_offs = 0x178,
		.caps = MTK_SCPD_KEEP_DEFAULT_OFF,
	},
	[MT8188_POWER_DOMAIN_CSIRX_TOP] = {
		.name = "pextp_csirx_top",
		.sta_mask = BIT(17),
		.ctl_offs = 0x3C4,
		.pwr_sta_offs = 0x174,
		.pwr_sta2nd_offs = 0x178,
		.caps = MTK_SCPD_KEEP_DEFAULT_OFF,
	},
	[MT8188_POWER_DOMAIN_ETHER] = {
		.name = "ether",
		.sta_mask = BIT(1),
		.ctl_offs = 0x338,
		.pwr_sta_offs = 0x16C,
		.pwr_sta2nd_offs = 0x170,
		.sram_pdn_bits = BIT(8),
		.sram_pdn_ack_bits = BIT(12),
		.bp_cfg = {
			BUS_PROT_WR(INFRA,
				    MT8188_TOP_AXI_PROT_EN_INFRA_VDNR_ETHER_STEP1,
				    MT8188_TOP_AXI_PROT_EN_INFRA_VDNR_SET,
				    MT8188_TOP_AXI_PROT_EN_INFRA_VDNR_CLR,
				    MT8188_TOP_AXI_PROT_EN_INFRA_VDNR_STA),
		},
		.caps = MTK_SCPD_KEEP_DEFAULT_OFF | MTK_SCPD_ACTIVE_WAKEUP,
	},
	[MT8188_POWER_DOMAIN_HDMI_TX] = {
		.name = "hdmi_tx",
		.sta_mask = BIT(18),
		.ctl_offs = 0x37C,
		.pwr_sta_offs = 0x16C,
		.pwr_sta2nd_offs = 0x170,
		.sram_pdn_bits = BIT(8),
		.sram_pdn_ack_bits = BIT(12),
		.bp_cfg = {
			BUS_PROT_WR(INFRA,
				    MT8188_TOP_AXI_PROT_EN_INFRA_VDNR_HDMI_TX_STEP1,
				    MT8188_TOP_AXI_PROT_EN_INFRA_VDNR_SET,
				    MT8188_TOP_AXI_PROT_EN_INFRA_VDNR_CLR,
				    MT8188_TOP_AXI_PROT_EN_INFRA_VDNR_STA),
		},
		.caps = MTK_SCPD_KEEP_DEFAULT_OFF | MTK_SCPD_ACTIVE_WAKEUP,
	},
	[MT8188_POWER_DOMAIN_ADSP_AO] = {
		.name = "adsp_ao",
		.sta_mask = BIT(10),
		.ctl_offs = 0x35C,
		.pwr_sta_offs = 0x16C,
		.pwr_sta2nd_offs = 0x170,
		.bp_cfg = {
			BUS_PROT_WR(INFRA,
				    MT8188_TOP_AXI_PROT_EN_2_ADSP_AO_STEP1,
				    MT8188_TOP_AXI_PROT_EN_2_SET,
				    MT8188_TOP_AXI_PROT_EN_2_CLR,
				    MT8188_TOP_AXI_PROT_EN_2_STA),
			BUS_PROT_WR(INFRA,
				    MT8188_TOP_AXI_PROT_EN_2_ADSP_AO_STEP2,
				    MT8188_TOP_AXI_PROT_EN_2_SET,
				    MT8188_TOP_AXI_PROT_EN_2_CLR,
				    MT8188_TOP_AXI_PROT_EN_2_STA),
		},
		.caps = MTK_SCPD_ALWAYS_ON,
	},
	[MT8188_POWER_DOMAIN_ADSP_INFRA] = {
		.name = "adsp_infra",
		.sta_mask = BIT(9),
		.ctl_offs = 0x358,
		.pwr_sta_offs = 0x16C,
		.pwr_sta2nd_offs = 0x170,
		.sram_pdn_bits = BIT(8),
		.sram_pdn_ack_bits = BIT(12),
		.bp_cfg = {
			BUS_PROT_WR(INFRA,
				    MT8188_TOP_AXI_PROT_EN_2_ADSP_INFRA_STEP1,
				    MT8188_TOP_AXI_PROT_EN_2_SET,
				    MT8188_TOP_AXI_PROT_EN_2_CLR,
				    MT8188_TOP_AXI_PROT_EN_2_STA),
			BUS_PROT_WR(INFRA,
				    MT8188_TOP_AXI_PROT_EN_2_ADSP_INFRA_STEP2,
				    MT8188_TOP_AXI_PROT_EN_2_SET,
				    MT8188_TOP_AXI_PROT_EN_2_CLR,
				    MT8188_TOP_AXI_PROT_EN_2_STA),
		},
		.caps = MTK_SCPD_SRAM_ISO | MTK_SCPD_ALWAYS_ON,
	},
	[MT8188_POWER_DOMAIN_ADSP] = {
		.name = "adsp",
		.sta_mask = BIT(8),
		.ctl_offs = 0x354,
		.pwr_sta_offs = 0x16C,
		.pwr_sta2nd_offs = 0x170,
		.sram_pdn_bits = BIT(8),
		.sram_pdn_ack_bits = BIT(12),
		.bp_cfg = {
			BUS_PROT_WR(INFRA,
				    MT8188_TOP_AXI_PROT_EN_2_ADSP_STEP1,
				    MT8188_TOP_AXI_PROT_EN_2_SET,
				    MT8188_TOP_AXI_PROT_EN_2_CLR,
				    MT8188_TOP_AXI_PROT_EN_2_STA),
			BUS_PROT_WR(INFRA,
				    MT8188_TOP_AXI_PROT_EN_2_ADSP_STEP2,
				    MT8188_TOP_AXI_PROT_EN_2_SET,
				    MT8188_TOP_AXI_PROT_EN_2_CLR,
				    MT8188_TOP_AXI_PROT_EN_2_STA),
		},
		.caps = MTK_SCPD_KEEP_DEFAULT_OFF | MTK_SCPD_SRAM_ISO | MTK_SCPD_ACTIVE_WAKEUP,
	},
	[MT8188_POWER_DOMAIN_AUDIO] = {
		.name = "audio",
		.sta_mask = BIT(6),
		.ctl_offs = 0x34C,
		.pwr_sta_offs = 0x16C,
		.pwr_sta2nd_offs = 0x170,
		.sram_pdn_bits = BIT(8),
		.sram_pdn_ack_bits = BIT(12),
		.bp_cfg = {
			BUS_PROT_WR(INFRA,
				    MT8188_TOP_AXI_PROT_EN_2_AUDIO_STEP1,
				    MT8188_TOP_AXI_PROT_EN_2_SET,
				    MT8188_TOP_AXI_PROT_EN_2_CLR,
				    MT8188_TOP_AXI_PROT_EN_2_STA),
			BUS_PROT_WR(INFRA,
				    MT8188_TOP_AXI_PROT_EN_2_AUDIO_STEP2,
				    MT8188_TOP_AXI_PROT_EN_2_SET,
				    MT8188_TOP_AXI_PROT_EN_2_CLR,
				    MT8188_TOP_AXI_PROT_EN_2_STA),
		},
		.caps = MTK_SCPD_KEEP_DEFAULT_OFF | MTK_SCPD_ACTIVE_WAKEUP,
	},
	[MT8188_POWER_DOMAIN_AUDIO_ASRC] = {
		.name = "audio_asrc",
		.sta_mask = BIT(7),
		.ctl_offs = 0x350,
		.pwr_sta_offs = 0x16C,
		.pwr_sta2nd_offs = 0x170,
		.sram_pdn_bits = BIT(8),
		.sram_pdn_ack_bits = BIT(12),
		.bp_cfg = {
			BUS_PROT_WR(INFRA,
				    MT8188_TOP_AXI_PROT_EN_2_AUDIO_ASRC_STEP1,
				    MT8188_TOP_AXI_PROT_EN_2_SET,
				    MT8188_TOP_AXI_PROT_EN_2_CLR,
				    MT8188_TOP_AXI_PROT_EN_2_STA),
			BUS_PROT_WR(INFRA,
				    MT8188_TOP_AXI_PROT_EN_2_AUDIO_ASRC_STEP2,
				    MT8188_TOP_AXI_PROT_EN_2_SET,
				    MT8188_TOP_AXI_PROT_EN_2_CLR,
				    MT8188_TOP_AXI_PROT_EN_2_STA),
		},
		.caps = MTK_SCPD_KEEP_DEFAULT_OFF,
	},
	[MT8188_POWER_DOMAIN_VPPSYS0] = {
		.name = "vppsys0",
		.sta_mask = BIT(11),
		.ctl_offs = 0x360,
		.pwr_sta_offs = 0x16C,
		.pwr_sta2nd_offs = 0x170,
		.sram_pdn_bits = BIT(8),
		.sram_pdn_ack_bits = BIT(12),
		.bp_cfg = {
			BUS_PROT_WR(INFRA,
				    MT8188_TOP_AXI_PROT_EN_VPPSYS0_STEP1,
				    MT8188_TOP_AXI_PROT_EN_SET,
				    MT8188_TOP_AXI_PROT_EN_CLR,
				    MT8188_TOP_AXI_PROT_EN_STA),
			BUS_PROT_WR(INFRA,
				    MT8188_TOP_AXI_PROT_EN_MM_2_VPPSYS0_STEP2,
				    MT8188_TOP_AXI_PROT_EN_MM_2_SET,
				    MT8188_TOP_AXI_PROT_EN_MM_2_CLR,
				    MT8188_TOP_AXI_PROT_EN_MM_2_STA),
			BUS_PROT_WR(INFRA,
				    MT8188_TOP_AXI_PROT_EN_VPPSYS0_STEP3,
				    MT8188_TOP_AXI_PROT_EN_SET,
				    MT8188_TOP_AXI_PROT_EN_CLR,
				    MT8188_TOP_AXI_PROT_EN_STA),
			BUS_PROT_WR(INFRA,
				    MT8188_TOP_AXI_PROT_EN_MM_2_VPPSYS0_STEP4,
				    MT8188_TOP_AXI_PROT_EN_MM_2_SET,
				    MT8188_TOP_AXI_PROT_EN_MM_2_CLR,
				    MT8188_TOP_AXI_PROT_EN_MM_2_STA),
			BUS_PROT_WR(INFRA,
				    MT8188_TOP_AXI_PROT_EN_SUB_INFRA_VDNR_VPPSYS0_STEP5,
				    MT8188_TOP_AXI_PROT_EN_SUB_INFRA_VDNR_SET,
				    MT8188_TOP_AXI_PROT_EN_SUB_INFRA_VDNR_CLR,
				    MT8188_TOP_AXI_PROT_EN_SUB_INFRA_VDNR_STA),
		},
	},
	[MT8188_POWER_DOMAIN_VDOSYS0] = {
		.name = "vdosys0",
		.sta_mask = BIT(13),
		.ctl_offs = 0x368,
		.pwr_sta_offs = 0x16C,
		.pwr_sta2nd_offs = 0x170,
		.sram_pdn_bits = BIT(8),
		.sram_pdn_ack_bits = BIT(12),
		.bp_cfg = {
			BUS_PROT_WR(INFRA,
				    MT8188_TOP_AXI_PROT_EN_MM_VDOSYS0_STEP1,
				    MT8188_TOP_AXI_PROT_EN_MM_SET,
				    MT8188_TOP_AXI_PROT_EN_MM_CLR,
				    MT8188_TOP_AXI_PROT_EN_MM_STA),
			BUS_PROT_WR(INFRA,
				    MT8188_TOP_AXI_PROT_EN_VDOSYS0_STEP2,
				    MT8188_TOP_AXI_PROT_EN_SET,
				    MT8188_TOP_AXI_PROT_EN_CLR,
				    MT8188_TOP_AXI_PROT_EN_STA),
			BUS_PROT_WR(INFRA,
				    MT8188_TOP_AXI_PROT_EN_SUB_INFRA_VDNR_VDOSYS0_STEP3,
				    MT8188_TOP_AXI_PROT_EN_SUB_INFRA_VDNR_SET,
				    MT8188_TOP_AXI_PROT_EN_SUB_INFRA_VDNR_CLR,
				    MT8188_TOP_AXI_PROT_EN_SUB_INFRA_VDNR_STA),
		},
	},
	[MT8188_POWER_DOMAIN_VDOSYS1] = {
		.name = "vdosys1",
		.sta_mask = BIT(14),
		.ctl_offs = 0x36C,
		.pwr_sta_offs = 0x16C,
		.pwr_sta2nd_offs = 0x170,
		.sram_pdn_bits = BIT(8),
		.sram_pdn_ack_bits = BIT(12),
		.bp_cfg = {
			BUS_PROT_WR(INFRA,
				    MT8188_TOP_AXI_PROT_EN_MM_VDOSYS1_STEP1,
				    MT8188_TOP_AXI_PROT_EN_MM_SET,
				    MT8188_TOP_AXI_PROT_EN_MM_CLR,
				    MT8188_TOP_AXI_PROT_EN_MM_STA),
			BUS_PROT_WR(INFRA,
				    MT8188_TOP_AXI_PROT_EN_MM_VDOSYS1_STEP2,
				    MT8188_TOP_AXI_PROT_EN_MM_SET,
				    MT8188_TOP_AXI_PROT_EN_MM_CLR,
				    MT8188_TOP_AXI_PROT_EN_MM_STA),
			BUS_PROT_WR(INFRA,
				    MT8188_TOP_AXI_PROT_EN_MM_2_VDOSYS1_STEP3,
				    MT8188_TOP_AXI_PROT_EN_MM_2_SET,
				    MT8188_TOP_AXI_PROT_EN_MM_2_CLR,
				    MT8188_TOP_AXI_PROT_EN_MM_2_STA),
		},
	},
	[MT8188_POWER_DOMAIN_DP_TX] = {
		.name = "dp_tx",
		.sta_mask = BIT(16),
		.ctl_offs = 0x374,
		.pwr_sta_offs = 0x16C,
		.pwr_sta2nd_offs = 0x170,
		.sram_pdn_bits = BIT(8),
		.sram_pdn_ack_bits = BIT(12),
		.bp_cfg = {
			BUS_PROT_WR(INFRA,
				    MT8188_TOP_AXI_PROT_EN_INFRA_VDNR_DP_TX_STEP1,
				    MT8188_TOP_AXI_PROT_EN_INFRA_VDNR_SET,
				    MT8188_TOP_AXI_PROT_EN_INFRA_VDNR_CLR,
				    MT8188_TOP_AXI_PROT_EN_INFRA_VDNR_STA),
		},
		.caps = MTK_SCPD_KEEP_DEFAULT_OFF,
	},
	[MT8188_POWER_DOMAIN_EDP_TX] = {
		.name = "edp_tx",
		.sta_mask = BIT(17),
		.ctl_offs = 0x378,
		.pwr_sta_offs = 0x16C,
		.pwr_sta2nd_offs = 0x170,
		.sram_pdn_bits = BIT(8),
		.sram_pdn_ack_bits = BIT(12),
		.bp_cfg = {
			BUS_PROT_WR(INFRA,
				    MT8188_TOP_AXI_PROT_EN_INFRA_VDNR_EDP_TX_STEP1,
				    MT8188_TOP_AXI_PROT_EN_INFRA_VDNR_SET,
				    MT8188_TOP_AXI_PROT_EN_INFRA_VDNR_CLR,
				    MT8188_TOP_AXI_PROT_EN_INFRA_VDNR_STA),
		},
		.caps = MTK_SCPD_KEEP_DEFAULT_OFF,
	},
	[MT8188_POWER_DOMAIN_VPPSYS1] = {
		.name = "vppsys1",
		.sta_mask = BIT(12),
		.ctl_offs = 0x364,
		.pwr_sta_offs = 0x16C,
		.pwr_sta2nd_offs = 0x170,
		.sram_pdn_bits = BIT(8),
		.sram_pdn_ack_bits = BIT(12),
		.bp_cfg = {
			BUS_PROT_WR(INFRA,
				    MT8188_TOP_AXI_PROT_EN_MM_VPPSYS1_STEP1,
				    MT8188_TOP_AXI_PROT_EN_MM_SET,
				    MT8188_TOP_AXI_PROT_EN_MM_CLR,
				    MT8188_TOP_AXI_PROT_EN_MM_STA),
			BUS_PROT_WR(INFRA,
				    MT8188_TOP_AXI_PROT_EN_MM_VPPSYS1_STEP2,
				    MT8188_TOP_AXI_PROT_EN_MM_SET,
				    MT8188_TOP_AXI_PROT_EN_MM_CLR,
				    MT8188_TOP_AXI_PROT_EN_MM_STA),
			BUS_PROT_WR(INFRA,
				    MT8188_TOP_AXI_PROT_EN_MM_2_VPPSYS1_STEP3,
				    MT8188_TOP_AXI_PROT_EN_MM_2_SET,
				    MT8188_TOP_AXI_PROT_EN_MM_2_CLR,
				    MT8188_TOP_AXI_PROT_EN_MM_2_STA),
		},
	},
	[MT8188_POWER_DOMAIN_WPE] = {
		.name = "wpe",
		.sta_mask = BIT(15),
		.ctl_offs = 0x370,
		.pwr_sta_offs = 0x16C,
		.pwr_sta2nd_offs = 0x170,
		.sram_pdn_bits = BIT(8),
		.sram_pdn_ack_bits = BIT(12),
		.bp_cfg = {
			BUS_PROT_WR(INFRA,
				    MT8188_TOP_AXI_PROT_EN_MM_2_WPE_STEP1,
				    MT8188_TOP_AXI_PROT_EN_MM_2_SET,
				    MT8188_TOP_AXI_PROT_EN_MM_2_CLR,
				    MT8188_TOP_AXI_PROT_EN_MM_2_STA),
			BUS_PROT_WR(INFRA,
				    MT8188_TOP_AXI_PROT_EN_MM_2_WPE_STEP2,
				    MT8188_TOP_AXI_PROT_EN_MM_2_SET,
				    MT8188_TOP_AXI_PROT_EN_MM_2_CLR,
				    MT8188_TOP_AXI_PROT_EN_MM_2_STA),
		},
		.caps = MTK_SCPD_KEEP_DEFAULT_OFF,
	},
	[MT8188_POWER_DOMAIN_VDEC0] = {
		.name = "vdec0",
		.sta_mask = BIT(19),
		.ctl_offs = 0x380,
		.pwr_sta_offs = 0x16C,
		.pwr_sta2nd_offs = 0x170,
		.sram_pdn_bits = BIT(8),
		.sram_pdn_ack_bits = BIT(12),
		.bp_cfg = {
			BUS_PROT_WR(INFRA,
				    MT8188_TOP_AXI_PROT_EN_MM_VDEC0_STEP1,
				    MT8188_TOP_AXI_PROT_EN_MM_SET,
				    MT8188_TOP_AXI_PROT_EN_MM_CLR,
				    MT8188_TOP_AXI_PROT_EN_MM_STA),
			BUS_PROT_WR(INFRA,
				    MT8188_TOP_AXI_PROT_EN_MM_2_VDEC0_STEP2,
				    MT8188_TOP_AXI_PROT_EN_MM_2_SET,
				    MT8188_TOP_AXI_PROT_EN_MM_2_CLR,
				    MT8188_TOP_AXI_PROT_EN_MM_2_STA),
		},
		.caps = MTK_SCPD_KEEP_DEFAULT_OFF,
	},
	[MT8188_POWER_DOMAIN_VDEC1] = {
		.name = "vdec1",
		.sta_mask = BIT(20),
		.ctl_offs = 0x384,
		.pwr_sta_offs = 0x16C,
		.pwr_sta2nd_offs = 0x170,
		.sram_pdn_bits = BIT(8),
		.sram_pdn_ack_bits = BIT(12),
		.bp_cfg = {
			BUS_PROT_WR(INFRA,
				    MT8188_TOP_AXI_PROT_EN_MM_VDEC1_STEP1,
				    MT8188_TOP_AXI_PROT_EN_MM_SET,
				    MT8188_TOP_AXI_PROT_EN_MM_CLR,
				    MT8188_TOP_AXI_PROT_EN_MM_STA),
			BUS_PROT_WR(INFRA,
				    MT8188_TOP_AXI_PROT_EN_MM_VDEC1_STEP2,
				    MT8188_TOP_AXI_PROT_EN_MM_SET,
				    MT8188_TOP_AXI_PROT_EN_MM_CLR,
				    MT8188_TOP_AXI_PROT_EN_MM_STA),
		},
		.caps = MTK_SCPD_KEEP_DEFAULT_OFF,
	},
	[MT8188_POWER_DOMAIN_VENC] = {
		.name = "venc",
		.sta_mask = BIT(22),
		.ctl_offs = 0x38C,
		.pwr_sta_offs = 0x16C,
		.pwr_sta2nd_offs = 0x170,
		.sram_pdn_bits = BIT(8),
		.sram_pdn_ack_bits = BIT(12),
		.bp_cfg = {
			BUS_PROT_WR(INFRA,
				    MT8188_TOP_AXI_PROT_EN_MM_VENC_STEP1,
				    MT8188_TOP_AXI_PROT_EN_MM_SET,
				    MT8188_TOP_AXI_PROT_EN_MM_CLR,
				    MT8188_TOP_AXI_PROT_EN_MM_STA),
			BUS_PROT_WR(INFRA,
				    MT8188_TOP_AXI_PROT_EN_MM_VENC_STEP2,
				    MT8188_TOP_AXI_PROT_EN_MM_SET,
				    MT8188_TOP_AXI_PROT_EN_MM_CLR,
				    MT8188_TOP_AXI_PROT_EN_MM_STA),
			BUS_PROT_WR(INFRA,
				    MT8188_TOP_AXI_PROT_EN_MM_2_VENC_STEP3,
				    MT8188_TOP_AXI_PROT_EN_MM_2_SET,
				    MT8188_TOP_AXI_PROT_EN_MM_2_CLR,
				    MT8188_TOP_AXI_PROT_EN_MM_2_STA),
		},
		.caps = MTK_SCPD_KEEP_DEFAULT_OFF,
	},
	[MT8188_POWER_DOMAIN_IMG_VCORE] = {
		.name = "vcore",
		.sta_mask = BIT(28),
		.ctl_offs = 0x3A4,
		.pwr_sta_offs = 0x16C,
		.pwr_sta2nd_offs = 0x170,
		.bp_cfg = {
			BUS_PROT_WR(INFRA,
				    MT8188_TOP_AXI_PROT_EN_MM_IMG_VCORE_STEP1,
				    MT8188_TOP_AXI_PROT_EN_MM_SET,
				    MT8188_TOP_AXI_PROT_EN_MM_CLR,
				    MT8188_TOP_AXI_PROT_EN_MM_STA),
			BUS_PROT_WR(INFRA,
				    MT8188_TOP_AXI_PROT_EN_MM_IMG_VCORE_STEP2,
				    MT8188_TOP_AXI_PROT_EN_MM_SET,
				    MT8188_TOP_AXI_PROT_EN_MM_CLR,
				    MT8188_TOP_AXI_PROT_EN_MM_STA),
			BUS_PROT_WR(INFRA,
				    MT8188_TOP_AXI_PROT_EN_MM_2_IMG_VCORE_STEP3,
				    MT8188_TOP_AXI_PROT_EN_MM_2_SET,
				    MT8188_TOP_AXI_PROT_EN_MM_2_CLR,
				    MT8188_TOP_AXI_PROT_EN_MM_2_STA),
		},
		.caps = MTK_SCPD_KEEP_DEFAULT_OFF | MTK_SCPD_DOMAIN_SUPPLY,
	},
	[MT8188_POWER_DOMAIN_IMG_MAIN] = {
		.name = "img_main",
		.sta_mask = BIT(29),
		.ctl_offs = 0x3A8,
		.pwr_sta_offs = 0x16C,
		.pwr_sta2nd_offs = 0x170,
		.sram_pdn_bits = BIT(8),
		.sram_pdn_ack_bits = BIT(12),
		.bp_cfg = {
			BUS_PROT_WR(INFRA,
				    MT8188_TOP_AXI_PROT_EN_MM_2_IMG_MAIN_STEP1,
				    MT8188_TOP_AXI_PROT_EN_MM_2_SET,
				    MT8188_TOP_AXI_PROT_EN_MM_2_CLR,
				    MT8188_TOP_AXI_PROT_EN_MM_2_STA),
			BUS_PROT_WR(INFRA,
				    MT8188_TOP_AXI_PROT_EN_MM_2_IMG_MAIN_STEP2,
				    MT8188_TOP_AXI_PROT_EN_MM_2_SET,
				    MT8188_TOP_AXI_PROT_EN_MM_2_CLR,
				    MT8188_TOP_AXI_PROT_EN_MM_2_STA),
		},
		.caps = MTK_SCPD_KEEP_DEFAULT_OFF,
	},
	[MT8188_POWER_DOMAIN_DIP] = {
		.name = "dip",
		.sta_mask = BIT(30),
		.ctl_offs = 0x3AC,
		.pwr_sta_offs = 0x16C,
		.pwr_sta2nd_offs = 0x170,
		.sram_pdn_bits = BIT(8),
		.sram_pdn_ack_bits = BIT(12),
		.caps = MTK_SCPD_KEEP_DEFAULT_OFF,
	},
	[MT8188_POWER_DOMAIN_IPE] = {
		.name = "ipe",
		.sta_mask = BIT(31),
		.ctl_offs = 0x3B0,
		.pwr_sta_offs = 0x16C,
		.pwr_sta2nd_offs = 0x170,
		.sram_pdn_bits = BIT(8),
		.sram_pdn_ack_bits = BIT(12),
		.caps = MTK_SCPD_KEEP_DEFAULT_OFF,
	},
	[MT8188_POWER_DOMAIN_CAM_VCORE] = {
		.name = "cam_vcore",
		.sta_mask = BIT(27),
		.ctl_offs = 0x3A0,
		.pwr_sta_offs = 0x16C,
		.pwr_sta2nd_offs = 0x170,
		.bp_cfg = {
			BUS_PROT_WR(INFRA,
				    MT8188_TOP_AXI_PROT_EN_MM_CAM_VCORE_STEP1,
				    MT8188_TOP_AXI_PROT_EN_MM_SET,
				    MT8188_TOP_AXI_PROT_EN_MM_CLR,
				    MT8188_TOP_AXI_PROT_EN_MM_STA),
			BUS_PROT_WR(INFRA,
				    MT8188_TOP_AXI_PROT_EN_2_CAM_VCORE_STEP2,
				    MT8188_TOP_AXI_PROT_EN_2_SET,
				    MT8188_TOP_AXI_PROT_EN_2_CLR,
				    MT8188_TOP_AXI_PROT_EN_2_STA),
			BUS_PROT_WR(INFRA,
				    MT8188_TOP_AXI_PROT_EN_1_CAM_VCORE_STEP3,
				    MT8188_TOP_AXI_PROT_EN_1_SET,
				    MT8188_TOP_AXI_PROT_EN_1_CLR,
				    MT8188_TOP_AXI_PROT_EN_1_STA),
			BUS_PROT_WR(INFRA,
				    MT8188_TOP_AXI_PROT_EN_MM_CAM_VCORE_STEP4,
				    MT8188_TOP_AXI_PROT_EN_MM_SET,
				    MT8188_TOP_AXI_PROT_EN_MM_CLR,
				    MT8188_TOP_AXI_PROT_EN_MM_STA),
			BUS_PROT_WR(INFRA,
				    MT8188_TOP_AXI_PROT_EN_MM_2_CAM_VCORE_STEP5,
				    MT8188_TOP_AXI_PROT_EN_MM_2_SET,
				    MT8188_TOP_AXI_PROT_EN_MM_2_CLR,
				    MT8188_TOP_AXI_PROT_EN_MM_2_STA),
		},
		.caps = MTK_SCPD_KEEP_DEFAULT_OFF | MTK_SCPD_DOMAIN_SUPPLY,
	},
	[MT8188_POWER_DOMAIN_CAM_MAIN] = {
		.name = "cam_main",
		.sta_mask = BIT(24),
		.ctl_offs = 0x394,
		.pwr_sta_offs = 0x16C,
		.pwr_sta2nd_offs = 0x170,
		.sram_pdn_bits = BIT(8),
		.sram_pdn_ack_bits = BIT(12),
		.bp_cfg = {
			BUS_PROT_WR(INFRA,
				    MT8188_TOP_AXI_PROT_EN_MM_2_CAM_MAIN_STEP1,
				    MT8188_TOP_AXI_PROT_EN_MM_2_SET,
				    MT8188_TOP_AXI_PROT_EN_MM_2_CLR,
				    MT8188_TOP_AXI_PROT_EN_MM_2_STA),
			BUS_PROT_WR(INFRA,
				    MT8188_TOP_AXI_PROT_EN_2_CAM_MAIN_STEP2,
				    MT8188_TOP_AXI_PROT_EN_2_SET,
				    MT8188_TOP_AXI_PROT_EN_2_CLR,
				    MT8188_TOP_AXI_PROT_EN_2_STA),
			BUS_PROT_WR(INFRA,
				    MT8188_TOP_AXI_PROT_EN_MM_2_CAM_MAIN_STEP3,
				    MT8188_TOP_AXI_PROT_EN_MM_2_SET,
				    MT8188_TOP_AXI_PROT_EN_MM_2_CLR,
				    MT8188_TOP_AXI_PROT_EN_MM_2_STA),
			BUS_PROT_WR(INFRA,
				    MT8188_TOP_AXI_PROT_EN_2_CAM_MAIN_STEP4,
				    MT8188_TOP_AXI_PROT_EN_2_SET,
				    MT8188_TOP_AXI_PROT_EN_2_CLR,
				    MT8188_TOP_AXI_PROT_EN_2_STA),
		},
		.caps = MTK_SCPD_KEEP_DEFAULT_OFF,
	},
	[MT8188_POWER_DOMAIN_CAM_SUBA] = {
		.name = "cam_suba",
		.sta_mask = BIT(25),
		.ctl_offs = 0x398,
		.pwr_sta_offs = 0x16C,
		.pwr_sta2nd_offs = 0x170,
		.sram_pdn_bits = BIT(8),
		.sram_pdn_ack_bits = BIT(12),
		.caps = MTK_SCPD_KEEP_DEFAULT_OFF,
	},
	[MT8188_POWER_DOMAIN_CAM_SUBB] = {
		.name = "cam_subb",
		.sta_mask = BIT(26),
		.ctl_offs = 0x39C,
		.pwr_sta_offs = 0x16C,
		.pwr_sta2nd_offs = 0x170,
		.sram_pdn_bits = BIT(8),
		.sram_pdn_ack_bits = BIT(12),
		.caps = MTK_SCPD_KEEP_DEFAULT_OFF,
	},
};

static const struct scpsys_soc_data mt8188_scpsys_data = {
	.domains_data = scpsys_domain_data_mt8188,
	.num_domains = ARRAY_SIZE(scpsys_domain_data_mt8188),
};

#endif /* __SOC_MEDIATEK_MT8188_PM_DOMAINS_H */
