/* sudoku-printer.c generated by valac 0.39.92.14-46f76, the Vala compiler
 * generated from sudoku-printer.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * Copyright © 2014 Parin Porecha
 * Copyright © 2014 Michael Catanzaro
 *
 * This file is part of GNOME Sudoku.
 *
 * GNOME Sudoku is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME Sudoku is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME Sudoku. If not, see <http://www.gnu.org/licenses/>.
 */


#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include "libsudoku.h"
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <cairo.h>
#include <float.h>
#include <math.h>


#define TYPE_SUDOKU_PRINTER (sudoku_printer_get_type ())
#define SUDOKU_PRINTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_PRINTER, SudokuPrinter))
#define SUDOKU_PRINTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_PRINTER, SudokuPrinterClass))
#define IS_SUDOKU_PRINTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_PRINTER))
#define IS_SUDOKU_PRINTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_PRINTER))
#define SUDOKU_PRINTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_PRINTER, SudokuPrinterClass))

typedef struct _SudokuPrinter SudokuPrinter;
typedef struct _SudokuPrinterClass SudokuPrinterClass;
typedef struct _SudokuPrinterPrivate SudokuPrinterPrivate;
enum  {
	SUDOKU_PRINTER_0_PROPERTY,
	SUDOKU_PRINTER_NUM_PROPERTIES
};
static GParamSpec* sudoku_printer_properties[SUDOKU_PRINTER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))

struct _SudokuPrinter {
	GObject parent_instance;
	SudokuPrinterPrivate * priv;
};

struct _SudokuPrinterClass {
	GObjectClass parent_class;
};

struct _SudokuPrinterPrivate {
	GeeList* boards;
	GtkWindow* window;
	gint margin;
	gint n_sudokus;
	GtkPrintOperation* print_op;
};


static gpointer sudoku_printer_parent_class = NULL;

GType sudoku_printer_get_type (void) G_GNUC_CONST;
#define SUDOKU_PRINTER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SUDOKU_PRINTER, SudokuPrinterPrivate))
#define SUDOKU_PRINTER_SUDOKUS_PER_PAGE 2
GtkPrintOperationResult sudoku_printer_print_sudoku (SudokuPrinter* self);
SudokuPrinter* sudoku_printer_new (GeeList* boards,
                                   GtkWindow* window);
SudokuPrinter* sudoku_printer_construct (GType object_type,
                                         GeeList* boards,
                                         GtkWindow* window);
static void sudoku_printer_begin_print_cb (SudokuPrinter* self,
                                    GtkPrintOperation* operation,
                                    GtkPrintContext* context);
static void _sudoku_printer_begin_print_cb_gtk_print_operation_begin_print (GtkPrintOperation* _sender,
                                                                     GtkPrintContext* context,
                                                                     gpointer self);
static void sudoku_printer_draw_page_cb (SudokuPrinter* self,
                                  GtkPrintOperation* operation,
                                  GtkPrintContext* context,
                                  gint page_nr);
static void _sudoku_printer_draw_page_cb_gtk_print_operation_draw_page (GtkPrintOperation* _sender,
                                                                 GtkPrintContext* context,
                                                                 gint page_nr,
                                                                 gpointer self);
static gdouble sudoku_printer_fit_squares_in_rectangle (SudokuPrinter* self,
                                                 gdouble width,
                                                 gdouble height,
                                                 gint margin);
static void sudoku_printer_draw_sudoku (SudokuPrinter* self,
                                 cairo_t* cr,
                                 SudokuBoard* sudoku_board,
                                 gdouble size,
                                 gdouble offset_x,
                                 gdouble offset_y);
static void sudoku_printer_finalize (GObject * obj);


GtkPrintOperationResult
sudoku_printer_print_sudoku (SudokuPrinter* self)
{
	GtkPrintOperationResult result = 0;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	{
		GtkPrintOperationResult _result_ = 0;
		GtkPrintOperation* _tmp0_;
		GtkWindow* _tmp1_;
		_tmp0_ = self->priv->print_op;
		_tmp1_ = self->priv->window;
		_result_ = gtk_print_operation_run (_tmp0_, GTK_PRINT_OPERATION_ACTION_PRINT_DIALOG, _tmp1_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch5_g_error;
		}
		result = _result_;
		return result;
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError* e = NULL;
		GtkWindow* _tmp2_;
		GError* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		GtkMessageDialog* _tmp7_;
		GtkMessageDialog* _tmp8_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = self->priv->window;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		_tmp5_ = g_strdup_printf ("%s\n%s", _ ("Error printing file:"), _tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = (GtkMessageDialog*) gtk_message_dialog_new (_tmp2_, GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE, "%s", _tmp6_);
		g_object_ref_sink (_tmp7_);
		_tmp8_ = _tmp7_;
		gtk_dialog_run ((GtkDialog*) _tmp8_);
		_g_object_unref0 (_tmp8_);
		_g_free0 (_tmp6_);
		_g_error_free0 (e);
	}
	__finally5:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	result = GTK_PRINT_OPERATION_RESULT_ERROR;
	return result;
}


static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}


static void
_sudoku_printer_begin_print_cb_gtk_print_operation_begin_print (GtkPrintOperation* _sender,
                                                                GtkPrintContext* context,
                                                                gpointer self)
{
	sudoku_printer_begin_print_cb ((SudokuPrinter*) self, _sender, context);
}


static void
_sudoku_printer_draw_page_cb_gtk_print_operation_draw_page (GtkPrintOperation* _sender,
                                                            GtkPrintContext* context,
                                                            gint page_nr,
                                                            gpointer self)
{
	sudoku_printer_draw_page_cb ((SudokuPrinter*) self, _sender, context, page_nr);
}


SudokuPrinter*
sudoku_printer_construct (GType object_type,
                          GeeList* boards,
                          GtkWindow* window)
{
	SudokuPrinter * self = NULL;
	GeeList* _tmp0_;
	GtkWindow* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	GtkPrintOperation* _tmp4_;
	GtkPrintOperation* _tmp5_;
	GtkPrintOperation* _tmp6_;
	g_return_val_if_fail (boards != NULL, NULL);
	g_return_val_if_fail (window != NULL, NULL);
	self = (SudokuPrinter*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (boards);
	_g_object_unref0 (self->priv->boards);
	self->priv->boards = _tmp0_;
	_tmp1_ = _g_object_ref0 (window);
	_g_object_unref0 (self->priv->window);
	self->priv->window = _tmp1_;
	self->priv->margin = 25;
	_tmp2_ = gee_collection_get_size ((GeeCollection*) boards);
	_tmp3_ = _tmp2_;
	self->priv->n_sudokus = _tmp3_;
	_tmp4_ = gtk_print_operation_new ();
	_g_object_unref0 (self->priv->print_op);
	self->priv->print_op = _tmp4_;
	_tmp5_ = self->priv->print_op;
	g_signal_connect_object (_tmp5_, "begin-print", (GCallback) _sudoku_printer_begin_print_cb_gtk_print_operation_begin_print, self, 0);
	_tmp6_ = self->priv->print_op;
	g_signal_connect_object (_tmp6_, "draw-page", (GCallback) _sudoku_printer_draw_page_cb_gtk_print_operation_draw_page, self, 0);
	return self;
}


SudokuPrinter*
sudoku_printer_new (GeeList* boards,
                    GtkWindow* window)
{
	return sudoku_printer_construct (TYPE_SUDOKU_PRINTER, boards, window);
}


static void
sudoku_printer_begin_print_cb (SudokuPrinter* self,
                               GtkPrintOperation* operation,
                               GtkPrintContext* context)
{
	gint pages = 0;
	gint _tmp0_;
	gint _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (operation != NULL);
	g_return_if_fail (context != NULL);
	_tmp0_ = self->priv->n_sudokus;
	pages = _tmp0_ / SUDOKU_PRINTER_SUDOKUS_PER_PAGE;
	while (TRUE) {
		gint _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		_tmp1_ = pages;
		_tmp2_ = self->priv->n_sudokus;
		if (!((_tmp1_ * SUDOKU_PRINTER_SUDOKUS_PER_PAGE) < _tmp2_)) {
			break;
		}
		_tmp3_ = pages;
		pages = _tmp3_ + 1;
	}
	_tmp4_ = pages;
	gtk_print_operation_set_n_pages (operation, _tmp4_);
}


static gpointer
_cairo_reference0 (gpointer self)
{
	return self ? cairo_reference (self) : NULL;
}


static void
sudoku_printer_draw_page_cb (SudokuPrinter* self,
                             GtkPrintOperation* operation,
                             GtkPrintContext* context,
                             gint page_nr)
{
	cairo_t* cr = NULL;
	cairo_t* _tmp0_;
	cairo_t* _tmp1_;
	gdouble width = 0.0;
	gdouble height = 0.0;
	gdouble best_square_size = 0.0;
	gdouble _tmp2_;
	gdouble _tmp3_;
	gint _tmp4_;
	gint start = 0;
	gint end = 0;
	gint _tmp5_;
	GeeList* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	GeeList* sudokus_on_page = NULL;
	GeeList* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	GeeList* _tmp12_;
	gdouble left = 0.0;
	gdouble _tmp13_;
	gdouble _tmp14_;
	gdouble top = 0.0;
	gint _tmp15_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (operation != NULL);
	g_return_if_fail (context != NULL);
	_tmp0_ = gtk_print_context_get_cairo_context (context);
	_tmp1_ = _cairo_reference0 (_tmp0_);
	cr = _tmp1_;
	width = gtk_print_context_get_width (context);
	height = gtk_print_context_get_height (context);
	_tmp2_ = width;
	_tmp3_ = height;
	_tmp4_ = self->priv->margin;
	best_square_size = sudoku_printer_fit_squares_in_rectangle (self, _tmp2_, _tmp3_, _tmp4_);
	start = page_nr * SUDOKU_PRINTER_SUDOKUS_PER_PAGE;
	_tmp5_ = start;
	_tmp6_ = self->priv->boards;
	_tmp7_ = gee_collection_get_size ((GeeCollection*) _tmp6_);
	_tmp8_ = _tmp7_;
	end = MIN (_tmp5_ + SUDOKU_PRINTER_SUDOKUS_PER_PAGE, _tmp8_);
	_tmp9_ = self->priv->boards;
	_tmp10_ = start;
	_tmp11_ = end;
	_tmp12_ = gee_list_slice (_tmp9_, _tmp10_, _tmp11_);
	sudokus_on_page = _tmp12_;
	_tmp13_ = width;
	_tmp14_ = best_square_size;
	left = (_tmp13_ - _tmp14_) / 2;
	_tmp15_ = self->priv->margin;
	top = (gdouble) _tmp15_;
	{
		GeeList* _sudoku_list = NULL;
		GeeList* _tmp16_;
		GeeList* _tmp17_;
		gint _sudoku_size = 0;
		GeeList* _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
		gint _sudoku_index = 0;
		_tmp16_ = sudokus_on_page;
		_tmp17_ = _g_object_ref0 (_tmp16_);
		_sudoku_list = _tmp17_;
		_tmp18_ = _sudoku_list;
		_tmp19_ = gee_collection_get_size ((GeeCollection*) _tmp18_);
		_tmp20_ = _tmp19_;
		_sudoku_size = _tmp20_;
		_sudoku_index = -1;
		while (TRUE) {
			gint _tmp21_;
			gint _tmp22_;
			gint _tmp23_;
			SudokuBoard* sudoku = NULL;
			GeeList* _tmp24_;
			gint _tmp25_;
			gpointer _tmp26_;
			gchar* label = NULL;
			SudokuBoard* _tmp27_;
			DifficultyCategory _tmp28_;
			DifficultyCategory _tmp29_;
			gchar* _tmp30_;
			cairo_t* _tmp31_;
			cairo_t* _tmp32_;
			cairo_t* _tmp33_;
			cairo_text_extents_t extents = {0};
			cairo_t* _tmp34_;
			const gchar* _tmp35_;
			cairo_text_extents_t _tmp36_ = {0};
			cairo_t* _tmp37_;
			gdouble _tmp38_;
			cairo_text_extents_t _tmp39_;
			gdouble _tmp40_;
			gdouble _tmp41_;
			cairo_text_extents_t _tmp42_;
			gdouble _tmp43_;
			cairo_t* _tmp44_;
			const gchar* _tmp45_;
			cairo_t* _tmp46_;
			SudokuBoard* _tmp47_;
			gdouble _tmp48_;
			gdouble _tmp49_;
			gdouble _tmp50_;
			gdouble _tmp51_;
			gdouble _tmp52_;
			gint _tmp53_;
			_tmp21_ = _sudoku_index;
			_sudoku_index = _tmp21_ + 1;
			_tmp22_ = _sudoku_index;
			_tmp23_ = _sudoku_size;
			if (!(_tmp22_ < _tmp23_)) {
				break;
			}
			_tmp24_ = _sudoku_list;
			_tmp25_ = _sudoku_index;
			_tmp26_ = gee_list_get (_tmp24_, _tmp25_);
			sudoku = (SudokuBoard*) _tmp26_;
			_tmp27_ = sudoku;
			_tmp28_ = sudoku_board_get_difficulty_category (_tmp27_);
			_tmp29_ = _tmp28_;
			_tmp30_ = difficulty_category_to_string (_tmp29_);
			label = _tmp30_;
			_tmp31_ = cr;
			cairo_set_font_size (_tmp31_, (gdouble) 12);
			_tmp32_ = cr;
			cairo_select_font_face (_tmp32_, "Sans", CAIRO_FONT_SLANT_NORMAL, CAIRO_FONT_WEIGHT_BOLD);
			_tmp33_ = cr;
			cairo_set_source_rgb (_tmp33_, (gdouble) 0, (gdouble) 0, (gdouble) 0);
			_tmp34_ = cr;
			_tmp35_ = label;
			cairo_text_extents (_tmp34_, _tmp35_, &_tmp36_);
			extents = _tmp36_;
			_tmp37_ = cr;
			_tmp38_ = width;
			_tmp39_ = extents;
			_tmp40_ = _tmp39_.width;
			_tmp41_ = top;
			_tmp42_ = extents;
			_tmp43_ = _tmp42_.height;
			cairo_move_to (_tmp37_, (_tmp38_ - _tmp40_) / 2, _tmp41_ - (_tmp43_ / 2));
			_tmp44_ = cr;
			_tmp45_ = label;
			cairo_show_text (_tmp44_, _tmp45_);
			_tmp46_ = cr;
			_tmp47_ = sudoku;
			_tmp48_ = best_square_size;
			_tmp49_ = left;
			_tmp50_ = top;
			sudoku_printer_draw_sudoku (self, _tmp46_, _tmp47_, _tmp48_, _tmp49_, _tmp50_);
			_tmp51_ = top;
			_tmp52_ = best_square_size;
			_tmp53_ = self->priv->margin;
			top = _tmp51_ + (_tmp52_ + (2 * _tmp53_));
			_g_free0 (label);
			_g_object_unref0 (sudoku);
		}
		_g_object_unref0 (_sudoku_list);
	}
	_g_object_unref0 (sudokus_on_page);
	_cairo_destroy0 (cr);
}


static gdouble
sudoku_printer_fit_squares_in_rectangle (SudokuPrinter* self,
                                         gdouble width,
                                         gdouble height,
                                         gint margin)
{
	gdouble result = 0.0;
	gint n = 0;
	gdouble best_square_size = 0.0;
	gdouble square_size = 0.0;
	g_return_val_if_fail (self != NULL, 0.0);
	n = SUDOKU_PRINTER_SUDOKUS_PER_PAGE;
	best_square_size = 0.0;
	square_size = 0.0;
	{
		gint n_across = 0;
		n_across = 1;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				gint _tmp3_;
				gdouble n_down = 0.0;
				gint _tmp4_;
				gint _tmp5_;
				gdouble across_size = 0.0;
				gint _tmp6_;
				gdouble _tmp7_;
				gint _tmp8_;
				gdouble down_size = 0.0;
				gdouble _tmp9_;
				gdouble _tmp10_;
				gdouble _tmp11_;
				gdouble _tmp12_;
				gdouble _tmp13_;
				gdouble _tmp14_;
				gdouble _tmp15_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = n_across;
					n_across = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = n_across;
				_tmp3_ = n;
				if (!(_tmp2_ <= _tmp3_)) {
					break;
				}
				_tmp4_ = n;
				_tmp5_ = n_across;
				n_down = (gdouble) (_tmp4_ / _tmp5_);
				_tmp6_ = n_across;
				across_size = width - ((_tmp6_ + 1) * margin);
				_tmp7_ = across_size;
				_tmp8_ = n_across;
				across_size = _tmp7_ / _tmp8_;
				_tmp9_ = n_down;
				down_size = height - ((_tmp9_ + 1) * margin);
				_tmp10_ = down_size;
				_tmp11_ = n_down;
				down_size = _tmp10_ / _tmp11_;
				_tmp12_ = across_size;
				_tmp13_ = down_size;
				square_size = MIN (_tmp12_, _tmp13_);
				_tmp14_ = square_size;
				_tmp15_ = best_square_size;
				if (_tmp14_ > _tmp15_) {
					gdouble _tmp16_;
					_tmp16_ = square_size;
					best_square_size = _tmp16_;
				}
			}
		}
	}
	result = best_square_size;
	return result;
}


static void
sudoku_printer_draw_sudoku (SudokuPrinter* self,
                            cairo_t* cr,
                            SudokuBoard* sudoku_board,
                            gdouble size,
                            gdouble offset_x,
                            gdouble offset_y)
{
	static const gint SUDOKU_SIZE = 9;
	static const gint N_BOXES = 3;
	static const gdouble PENCIL_GREY[3] = {0.3, 0.3, 0.3};
	static const gdouble BACKGROUND_COLOR[3] = {1.0, 1.0, 1.0};
	static const gdouble BORDER_COLOR[3] = {1.0, 1.0, 1.0};
	static const gdouble LINE_COLOR[3] = {0.0, 0.0, 0.0};
	gdouble THIN = 0.0;
	gdouble THICK = 0.0;
	gdouble _tmp0_;
	gdouble BORDER = 0.0;
	gdouble _tmp1_;
	gdouble WHITE_SPACE = 0.0;
	gdouble _tmp2_;
	gdouble _tmp3_;
	gdouble _tmp4_;
	gdouble _tmp5_;
	gdouble SQUARE_SIZE = 0.0;
	gdouble _tmp6_;
	gint FONT_SIZE = 0;
	gdouble _tmp7_;
	static const cairo_font_weight_t FONT_WEIGHT = CAIRO_FONT_WEIGHT_NORMAL;
	gdouble* outer = NULL;
	gdouble* _tmp8_;
	gint outer_length1;
	gint _outer_size_;
	gdouble* _tmp9_;
	gint _tmp9__length1;
	gdouble _tmp10_;
	gdouble* _tmp11_;
	gint _tmp11__length1;
	gdouble _tmp12_;
	gdouble _tmp13_;
	gdouble* _tmp14_;
	gint _tmp14__length1;
	gdouble _tmp15_;
	gdouble _tmp16_;
	gdouble* _tmp17_;
	gint _tmp17__length1;
	gdouble _tmp18_;
	gdouble _tmp19_;
	gdouble _tmp20_;
	gdouble _tmp21_;
	gdouble _tmp22_;
	gdouble _tmp23_;
	gdouble _tmp24_;
	gdouble _tmp25_;
	gdouble _tmp26_;
	gdouble _tmp27_;
	gdouble _tmp28_;
	gdouble* _tmp29_;
	gint _tmp29__length1;
	gdouble _tmp30_;
	gdouble _tmp31_;
	gdouble _tmp32_;
	gdouble* _tmp33_;
	gint _tmp33__length1;
	gdouble _tmp34_;
	gdouble _tmp35_;
	gdouble _tmp36_;
	gdouble _tmp37_;
	gdouble _tmp38_;
	gdouble _tmp39_;
	gdouble _tmp40_;
	gdouble _tmp41_;
	gdouble _tmp42_;
	gdouble _tmp43_;
	gdouble* pos = NULL;
	gdouble* _tmp44_;
	gint pos_length1;
	gint _pos_size_;
	gdouble position = 0.0;
	gdouble _tmp45_;
	gdouble _tmp46_;
	gdouble* _tmp47_;
	gint _tmp47__length1;
	gdouble _tmp48_;
	gdouble _tmp49_;
	gdouble _tmp50_;
	gdouble last_line = 0.0;
	gint _tmp85_;
	gchar* letter = NULL;
	gchar* _tmp86_;
	cairo_text_extents_t extents = {0};
	gint* sudoku = NULL;
	gint _tmp87_;
	gint _tmp88_;
	gint* _tmp89_;
	gint sudoku_length1;
	gint sudoku_length2;
	gboolean invert = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	g_return_if_fail (sudoku_board != NULL);
	THIN = size / 500.0;
	_tmp0_ = THIN;
	THICK = _tmp0_ * 5;
	_tmp1_ = THICK;
	BORDER = _tmp1_;
	_tmp2_ = BORDER;
	_tmp3_ = THICK;
	_tmp4_ = THICK;
	_tmp5_ = THIN;
	WHITE_SPACE = (((size - (2 * _tmp2_)) - (2 * _tmp3_)) - ((N_BOXES - 1) * _tmp4_)) - ((N_BOXES * 2) * _tmp5_);
	_tmp6_ = WHITE_SPACE;
	SQUARE_SIZE = _tmp6_ / SUDOKU_SIZE;
	_tmp7_ = SQUARE_SIZE;
	FONT_SIZE = ((gint) _tmp7_) / 2;
	_tmp8_ = g_new0 (gdouble, 4);
	_tmp8_[0] = offset_x;
	_tmp8_[1] = offset_x + size;
	_tmp8_[2] = offset_y;
	_tmp8_[3] = offset_y + size;
	outer = _tmp8_;
	outer_length1 = 4;
	_outer_size_ = outer_length1;
	cairo_set_source_rgb (cr, 1.0, 1.0, 1.0);
	_tmp9_ = outer;
	_tmp9__length1 = outer_length1;
	_tmp10_ = _tmp9_[0];
	_tmp11_ = outer;
	_tmp11__length1 = outer_length1;
	_tmp12_ = _tmp11_[2];
	cairo_rectangle (cr, _tmp10_, _tmp12_, size, size);
	cairo_fill (cr);
	cairo_set_line_join (cr, CAIRO_LINE_JOIN_ROUND);
	_tmp13_ = BORDER;
	cairo_set_line_width (cr, _tmp13_);
	_tmp14_ = outer;
	_tmp14__length1 = outer_length1;
	_tmp15_ = _tmp14_[0];
	_tmp16_ = BORDER;
	_tmp17_ = outer;
	_tmp17__length1 = outer_length1;
	_tmp18_ = _tmp17_[2];
	_tmp19_ = BORDER;
	_tmp20_ = BORDER;
	_tmp21_ = BORDER;
	cairo_rectangle (cr, _tmp15_ + (_tmp16_ / 2.0), _tmp18_ + (_tmp19_ / 2.0), size - _tmp20_, size - _tmp21_);
	_tmp22_ = BACKGROUND_COLOR[0];
	_tmp23_ = BACKGROUND_COLOR[1];
	_tmp24_ = BACKGROUND_COLOR[2];
	cairo_set_source_rgb (cr, _tmp22_, _tmp23_, _tmp24_);
	cairo_fill_preserve (cr);
	_tmp25_ = BORDER_COLOR[0];
	_tmp26_ = BORDER_COLOR[1];
	_tmp27_ = BORDER_COLOR[2];
	cairo_set_source_rgb (cr, _tmp25_, _tmp26_, _tmp27_);
	cairo_stroke (cr);
	cairo_set_line_join (cr, CAIRO_LINE_JOIN_MITER);
	_tmp28_ = THICK;
	cairo_set_line_width (cr, _tmp28_);
	_tmp29_ = outer;
	_tmp29__length1 = outer_length1;
	_tmp30_ = _tmp29_[0];
	_tmp31_ = BORDER;
	_tmp32_ = THICK;
	_tmp33_ = outer;
	_tmp33__length1 = outer_length1;
	_tmp34_ = _tmp33_[2];
	_tmp35_ = BORDER;
	_tmp36_ = THICK;
	_tmp37_ = BORDER;
	_tmp38_ = THICK;
	_tmp39_ = BORDER;
	_tmp40_ = THICK;
	cairo_rectangle (cr, (_tmp30_ + _tmp31_) + (_tmp32_ / 2.0), (_tmp34_ + _tmp35_) + (_tmp36_ / 2.0), (size - (_tmp37_ * 2)) - _tmp38_, (size - (_tmp39_ * 2)) - _tmp40_);
	_tmp41_ = LINE_COLOR[0];
	_tmp42_ = LINE_COLOR[1];
	_tmp43_ = LINE_COLOR[2];
	cairo_set_source_rgb (cr, _tmp41_, _tmp42_, _tmp43_);
	cairo_stroke (cr);
	_tmp44_ = g_new0 (gdouble, SUDOKU_SIZE + 1);
	pos = _tmp44_;
	pos_length1 = SUDOKU_SIZE + 1;
	_pos_size_ = pos_length1;
	_tmp45_ = BORDER;
	_tmp46_ = THICK;
	position = _tmp45_ + _tmp46_;
	_tmp47_ = pos;
	_tmp47__length1 = pos_length1;
	_tmp48_ = position;
	_tmp49_ = SQUARE_SIZE;
	_tmp47_[0] = _tmp48_ + (_tmp49_ / 2.0);
	_tmp50_ = _tmp47_[0];
	last_line = 0.0;
	{
		gint n = 0;
		n = 1;
		{
			gboolean _tmp51_ = FALSE;
			_tmp51_ = TRUE;
			while (TRUE) {
				gint _tmp53_;
				gint _tmp54_;
				gdouble* _tmp67_;
				gint _tmp67__length1;
				gint _tmp68_;
				gdouble _tmp69_;
				gdouble _tmp70_;
				gdouble _tmp71_;
				gdouble _tmp72_;
				gdouble _tmp73_;
				gdouble _tmp74_;
				gdouble _tmp75_;
				gdouble _tmp76_;
				gdouble _tmp77_;
				gdouble _tmp78_;
				gdouble _tmp79_;
				gdouble _tmp80_;
				gdouble _tmp81_;
				gdouble _tmp82_;
				gdouble _tmp83_;
				gdouble _tmp84_;
				if (!_tmp51_) {
					gint _tmp52_;
					_tmp52_ = n;
					n = _tmp52_ + 1;
				}
				_tmp51_ = FALSE;
				_tmp53_ = n;
				if (!(_tmp53_ <= SUDOKU_SIZE)) {
					break;
				}
				_tmp54_ = n;
				if ((_tmp54_ % N_BOXES) == 0) {
					gdouble _tmp55_;
					gdouble _tmp56_;
					gdouble _tmp57_;
					gdouble _tmp58_;
					gdouble _tmp59_;
					gdouble _tmp60_;
					_tmp55_ = THICK;
					cairo_set_line_width (cr, _tmp55_);
					_tmp56_ = position;
					_tmp57_ = SQUARE_SIZE;
					_tmp58_ = last_line;
					_tmp59_ = THICK;
					position = _tmp56_ + ((_tmp57_ + (_tmp58_ / 2.0)) + (_tmp59_ / 2.0));
					_tmp60_ = THICK;
					last_line = _tmp60_;
				} else {
					gdouble _tmp61_;
					gdouble _tmp62_;
					gdouble _tmp63_;
					gdouble _tmp64_;
					gdouble _tmp65_;
					gdouble _tmp66_;
					_tmp61_ = THIN;
					cairo_set_line_width (cr, _tmp61_);
					_tmp62_ = position;
					_tmp63_ = SQUARE_SIZE;
					_tmp64_ = last_line;
					_tmp65_ = THIN;
					position = _tmp62_ + ((_tmp63_ + (_tmp64_ / 2.0)) + (_tmp65_ / 2.0));
					_tmp66_ = THIN;
					last_line = _tmp66_;
				}
				_tmp67_ = pos;
				_tmp67__length1 = pos_length1;
				_tmp68_ = n;
				_tmp69_ = position;
				_tmp70_ = last_line;
				_tmp71_ = SQUARE_SIZE;
				_tmp67_[_tmp68_] = (_tmp69_ + (_tmp70_ / 2.0)) + (_tmp71_ / 2.0);
				_tmp72_ = _tmp67_[_tmp68_];
				_tmp73_ = BORDER;
				_tmp74_ = THICK;
				_tmp75_ = position;
				cairo_move_to (cr, (_tmp73_ + (_tmp74_ / 2.0)) + offset_x, _tmp75_ + offset_y);
				_tmp76_ = BORDER;
				_tmp77_ = THICK;
				_tmp78_ = position;
				cairo_line_to (cr, ((size - _tmp76_) - (_tmp77_ / 2.0)) + offset_x, _tmp78_ + offset_y);
				_tmp79_ = position;
				_tmp80_ = BORDER;
				_tmp81_ = THICK;
				cairo_move_to (cr, _tmp79_ + offset_x, (_tmp80_ + (_tmp81_ / 2.0)) + offset_y);
				_tmp82_ = position;
				_tmp83_ = BORDER;
				_tmp84_ = THICK;
				cairo_line_to (cr, _tmp82_ + offset_x, ((size - _tmp83_) - (_tmp84_ / 2.0)) + offset_y);
				cairo_stroke (cr);
			}
		}
	}
	_tmp85_ = FONT_SIZE;
	cairo_set_font_size (cr, (gdouble) _tmp85_);
	_tmp86_ = g_strdup ("");
	letter = _tmp86_;
	_tmp89_ = sudoku_board_get_cells (sudoku_board, &_tmp87_, &_tmp88_);
	sudoku = _tmp89_;
	sudoku_length1 = _tmp87_;
	sudoku_length2 = _tmp88_;
	invert = gtk_widget_get_default_direction () == GTK_TEXT_DIR_RTL;
	{
		gint x = 0;
		x = 0;
		{
			gboolean _tmp90_ = FALSE;
			_tmp90_ = TRUE;
			while (TRUE) {
				gint _tmp92_;
				gint _tmp93_ = 0;
				gboolean _tmp94_;
				gint real_x = 0;
				if (!_tmp90_) {
					gint _tmp91_;
					_tmp91_ = x;
					x = _tmp91_ + 1;
				}
				_tmp90_ = FALSE;
				_tmp92_ = x;
				if (!(_tmp92_ < SUDOKU_SIZE)) {
					break;
				}
				_tmp94_ = invert;
				if (_tmp94_) {
					gint _tmp95_;
					_tmp95_ = x;
					_tmp93_ = (SUDOKU_SIZE - _tmp95_) - 1;
				} else {
					gint _tmp96_;
					_tmp96_ = x;
					_tmp93_ = _tmp96_;
				}
				real_x = _tmp93_;
				{
					gint y = 0;
					y = 0;
					{
						gboolean _tmp97_ = FALSE;
						_tmp97_ = TRUE;
						while (TRUE) {
							gint _tmp99_;
							gdouble* _tmp100_;
							gint _tmp100__length1;
							gint _tmp101_;
							gdouble _tmp102_;
							gdouble* _tmp103_;
							gint _tmp103__length1;
							gint _tmp104_;
							gdouble _tmp105_;
							gchar* _tmp106_;
							gint* _tmp107_;
							gint _tmp107__length1;
							gint _tmp107__length2;
							gint _tmp108_;
							gint _tmp109_;
							gint _tmp110_;
							if (!_tmp97_) {
								gint _tmp98_;
								_tmp98_ = y;
								y = _tmp98_ + 1;
							}
							_tmp97_ = FALSE;
							_tmp99_ = y;
							if (!(_tmp99_ < SUDOKU_SIZE)) {
								break;
							}
							_tmp100_ = pos;
							_tmp100__length1 = pos_length1;
							_tmp101_ = x;
							_tmp102_ = _tmp100_[_tmp101_];
							_tmp103_ = pos;
							_tmp103__length1 = pos_length1;
							_tmp104_ = y;
							_tmp105_ = _tmp103_[_tmp104_];
							cairo_move_to (cr, _tmp102_ + offset_x, _tmp105_ + offset_y);
							_tmp106_ = g_strdup ("");
							_g_free0 (letter);
							letter = _tmp106_;
							_tmp107_ = sudoku;
							_tmp107__length1 = sudoku_length1;
							_tmp107__length2 = sudoku_length2;
							_tmp108_ = y;
							_tmp109_ = real_x;
							_tmp110_ = _tmp107_[(_tmp108_ * _tmp107__length2) + _tmp109_];
							if (_tmp110_ != 0) {
								gint* _tmp111_;
								gint _tmp111__length1;
								gint _tmp111__length2;
								gint _tmp112_;
								gint _tmp113_;
								gint _tmp114_;
								gchar* _tmp115_;
								gboolean* _tmp116_;
								gint _tmp116__length1;
								gint _tmp116__length2;
								gint _tmp117_;
								gint _tmp118_;
								gboolean _tmp119_;
								const gchar* _tmp123_;
								cairo_text_extents_t _tmp124_ = {0};
								gdouble* _tmp125_;
								gint _tmp125__length1;
								gint _tmp126_;
								gdouble _tmp127_;
								cairo_text_extents_t _tmp128_;
								gdouble _tmp129_;
								gdouble* _tmp130_;
								gint _tmp130__length1;
								gint _tmp131_;
								gdouble _tmp132_;
								cairo_text_extents_t _tmp133_;
								gdouble _tmp134_;
								const gchar* _tmp135_;
								_tmp111_ = sudoku;
								_tmp111__length1 = sudoku_length1;
								_tmp111__length2 = sudoku_length2;
								_tmp112_ = y;
								_tmp113_ = real_x;
								_tmp114_ = _tmp111_[(_tmp112_ * _tmp111__length2) + _tmp113_];
								_tmp115_ = g_strdup_printf ("%i", _tmp114_);
								_g_free0 (letter);
								letter = _tmp115_;
								_tmp116_ = sudoku_board->is_fixed;
								_tmp116__length1 = sudoku_board->is_fixed_length1;
								_tmp116__length2 = sudoku_board->is_fixed_length2;
								_tmp117_ = y;
								_tmp118_ = real_x;
								_tmp119_ = _tmp116_[(_tmp117_ * _tmp116__length2) + _tmp118_];
								if (_tmp119_) {
									cairo_select_font_face (cr, "Sans", CAIRO_FONT_SLANT_NORMAL, FONT_WEIGHT);
									cairo_set_source_rgb (cr, (gdouble) 0, (gdouble) 0, (gdouble) 0);
								} else {
									gdouble _tmp120_;
									gdouble _tmp121_;
									gdouble _tmp122_;
									cairo_select_font_face (cr, "Sans", CAIRO_FONT_SLANT_ITALIC, FONT_WEIGHT);
									_tmp120_ = PENCIL_GREY[0];
									_tmp121_ = PENCIL_GREY[1];
									_tmp122_ = PENCIL_GREY[2];
									cairo_set_source_rgb (cr, _tmp120_, _tmp121_, _tmp122_);
								}
								_tmp123_ = letter;
								cairo_text_extents (cr, _tmp123_, &_tmp124_);
								extents = _tmp124_;
								_tmp125_ = pos;
								_tmp125__length1 = pos_length1;
								_tmp126_ = x;
								_tmp127_ = _tmp125_[_tmp126_];
								_tmp128_ = extents;
								_tmp129_ = _tmp128_.x_advance;
								_tmp130_ = pos;
								_tmp130__length1 = pos_length1;
								_tmp131_ = y;
								_tmp132_ = _tmp130_[_tmp131_];
								_tmp133_ = extents;
								_tmp134_ = _tmp133_.height;
								cairo_move_to (cr, (_tmp127_ + offset_x) - (_tmp129_ / 2.0), (_tmp132_ + offset_y) + (_tmp134_ / 2.0));
								_tmp135_ = letter;
								cairo_show_text (cr, _tmp135_);
							}
						}
					}
				}
			}
		}
	}
	sudoku = (g_free (sudoku), NULL);
	_g_free0 (letter);
	pos = (g_free (pos), NULL);
	outer = (g_free (outer), NULL);
}


static void
sudoku_printer_class_init (SudokuPrinterClass * klass)
{
	sudoku_printer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SudokuPrinterPrivate));
	G_OBJECT_CLASS (klass)->finalize = sudoku_printer_finalize;
}


static void
sudoku_printer_instance_init (SudokuPrinter * self)
{
	self->priv = SUDOKU_PRINTER_GET_PRIVATE (self);
}


static void
sudoku_printer_finalize (GObject * obj)
{
	SudokuPrinter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SUDOKU_PRINTER, SudokuPrinter);
	_g_object_unref0 (self->priv->boards);
	_g_object_unref0 (self->priv->window);
	_g_object_unref0 (self->priv->print_op);
	G_OBJECT_CLASS (sudoku_printer_parent_class)->finalize (obj);
}


GType
sudoku_printer_get_type (void)
{
	static volatile gsize sudoku_printer_type_id__volatile = 0;
	if (g_once_init_enter (&sudoku_printer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SudokuPrinterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sudoku_printer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SudokuPrinter), 0, (GInstanceInitFunc) sudoku_printer_instance_init, NULL };
		GType sudoku_printer_type_id;
		sudoku_printer_type_id = g_type_register_static (G_TYPE_OBJECT, "SudokuPrinter", &g_define_type_info, 0);
		g_once_init_leave (&sudoku_printer_type_id__volatile, sudoku_printer_type_id);
	}
	return sudoku_printer_type_id__volatile;
}



