static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2006 Øyvind Kolås <pippin@gimp.org>                            \n"
" *           2006 Dominik Ernst <dernst@gmx.de>                               \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_file_path (path, _(\"File\"), \"\")                                  \n"
"  description (_(\"Target path and filename, use '-' for stdout.\"))          \n"
"property_int    (compression, _(\"Compression\"), 3)                          \n"
"  description (_(\"PNG compression level from 1 to 9\"))                      \n"
"  value_range (1, 9)                                                          \n"
"property_int    (bitdepth, _(\"Bitdepth\"), 16)                               \n"
"  description(_(\"8 and 16 are the currently accepted values.\"))             \n"
"  value_range (8, 16)                                                         \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_SINK                                                          \n"
"#define GEGL_OP_C_SOURCE png-save.c                                           \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"#include <png.h>                                                              \n"
"#include <stdio.h>                                                            \n"
"                                                                              \n"
"/* this call is available when the png-save plug-in is loaded,                \n"
" * it might have to be dlsymed to be used?                                    \n"
" */                                                                           \n"
"gint                                                                          \n"
"gegl_buffer_export_png (GeglBuffer  *gegl_buffer,                             \n"
"                        const gchar *path,                                    \n"
"                        gint         compression,                             \n"
"                        gint         bd,                                      \n"
"                        gint         src_x,                                   \n"
"                        gint         src_y,                                   \n"
"                        gint         width,                                   \n"
"                        gint         height);                                 \n"
"                                                                              \n"
"gint                                                                          \n"
"gegl_buffer_export_png (GeglBuffer  *gegl_buffer,                             \n"
"                        const gchar *path,                                    \n"
"                        gint         compression,                             \n"
"                        gint         bd,                                      \n"
"                        gint         src_x,                                   \n"
"                        gint         src_y,                                   \n"
"                        gint         width,                                   \n"
"                        gint         height)                                  \n"
"{                                                                             \n"
"  FILE          *fp;                                                          \n"
"  gint           i;                                                           \n"
"  png_struct    *png;                                                         \n"
"  png_info      *info;                                                        \n"
"  guchar        *pixels;                                                      \n"
"  png_color_16   white;                                                       \n"
"  int            png_color_type;                                              \n"
"  gchar          format_string[16];                                           \n"
"  const Babl    *format;                                                      \n"
"  gint           bit_depth = 8;                                               \n"
"                                                                              \n"
"  if (!strcmp (path, \"-\"))                                                  \n"
"    {                                                                         \n"
"      fp = stdout;                                                            \n"
"    }                                                                         \n"
"  else                                                                        \n"
"    {                                                                         \n"
"      fp = fopen (path, \"wb\");                                              \n"
"    }                                                                         \n"
"  if (!fp)                                                                    \n"
"    {                                                                         \n"
"      return -1;                                                              \n"
"    }                                                                         \n"
"                                                                              \n"
"  {                                                                           \n"
"    const Babl *babl = gegl_buffer_get_format (gegl_buffer);                  \n"
"                                                                              \n"
"    if (bd == 16)                                                             \n"
"      bit_depth = 16;                                                         \n"
"    else                                                                      \n"
"      bit_depth = 8;                                                          \n"
"                                                                              \n"
"    if (babl_format_has_alpha (babl))                                         \n"
"      if (babl_format_get_n_components (babl) != 2)                           \n"
"        {                                                                     \n"
"          png_color_type = PNG_COLOR_TYPE_RGB_ALPHA;                          \n"
"          strcpy (format_string, \"R'G'B'A \");                               \n"
"        }                                                                     \n"
"      else                                                                    \n"
"        {                                                                     \n"
"          png_color_type = PNG_COLOR_TYPE_GRAY_ALPHA;                         \n"
"          strcpy (format_string, \"Y'A \");                                   \n"
"        }                                                                     \n"
"    else                                                                      \n"
"      if (babl_format_get_n_components (babl) != 1)                           \n"
"        {                                                                     \n"
"          png_color_type = PNG_COLOR_TYPE_RGB;                                \n"
"          strcpy (format_string, \"R'G'B' \");                                \n"
"        }                                                                     \n"
"      else                                                                    \n"
"        {                                                                     \n"
"          png_color_type = PNG_COLOR_TYPE_GRAY;                               \n"
"          strcpy (format_string, \"Y' \");                                    \n"
"        }                                                                     \n"
"  }                                                                           \n"
"                                                                              \n"
"  if (bit_depth == 16)                                                        \n"
"    strcat (format_string, \"u16\");                                          \n"
"  else                                                                        \n"
"    strcat (format_string, \"u8\");                                           \n"
"                                                                              \n"
"  png = png_create_write_struct (PNG_LIBPNG_VER_STRING, NULL, NULL, NULL);    \n"
"  if (png == NULL)                                                            \n"
"    {                                                                         \n"
"      if (stdout != fp)                                                       \n"
"        fclose (fp);                                                          \n"
"                                                                              \n"
"      return -1;                                                              \n"
"    }                                                                         \n"
"                                                                              \n"
"  info = png_create_info_struct (png);                                        \n"
"                                                                              \n"
"  if (setjmp (png_jmpbuf (png)))                                              \n"
"    {                                                                         \n"
"      if (stdout != fp)                                                       \n"
"        fclose (fp);                                                          \n"
"                                                                              \n"
"      return -1;                                                              \n"
"    }                                                                         \n"
"                                                                              \n"
"  png_set_compression_level (png, compression);                               \n"
"  png_init_io (png, fp);                                                      \n"
"                                                                              \n"
"  png_set_IHDR (png, info,                                                    \n"
"     width, height, bit_depth, png_color_type,                                \n"
"     PNG_INTERLACE_NONE, PNG_COMPRESSION_TYPE_BASE, PNG_FILTER_TYPE_DEFAULT); \n"
"                                                                              \n"
"  if (png_color_type == PNG_COLOR_TYPE_RGB || png_color_type == PNG_COLOR_TYPE_RGB_ALPHA)\n"
"    {                                                                         \n"
"      white.red = 0xff;                                                       \n"
"      white.blue = 0xff;                                                      \n"
"      white.green = 0xff;                                                     \n"
"    }                                                                         \n"
"  else                                                                        \n"
"    white.gray = 0xff;                                                        \n"
"  png_set_bKGD (png, info, &white);                                           \n"
"                                                                              \n"
"  png_write_info (png, info);                                                 \n"
"                                                                              \n"
"#if BYTE_ORDER == LITTLE_ENDIAN                                               \n"
"  if (bit_depth > 8)                                                          \n"
"    png_set_swap (png);                                                       \n"
"#endif                                                                        \n"
"                                                                              \n"
"  format = babl_format (format_string);                                       \n"
"  pixels = g_malloc0 (width * babl_format_get_bytes_per_pixel (format));      \n"
"                                                                              \n"
"  for (i=0; i< height; i++)                                                   \n"
"    {                                                                         \n"
"      GeglRectangle rect;                                                     \n"
"                                                                              \n"
"      rect.x = src_x;                                                         \n"
"      rect.y = src_y+i;                                                       \n"
"      rect.width = width;                                                     \n"
"      rect.height = 1;                                                        \n"
"                                                                              \n"
"      gegl_buffer_get (gegl_buffer, &rect, 1.0, babl_format (format_string), pixels, GEGL_AUTO_ROWSTRIDE, GEGL_ABYSS_NONE);\n"
"                                                                              \n"
"      png_write_rows (png, &pixels, 1);                                       \n"
"    }                                                                         \n"
"                                                                              \n"
"  png_write_end (png, info);                                                  \n"
"                                                                              \n"
"  png_destroy_write_struct (&png, &info);                                     \n"
"  g_free (pixels);                                                            \n"
"                                                                              \n"
"  if (stdout != fp)                                                           \n"
"    fclose (fp);                                                              \n"
"                                                                              \n"
"  return 0;                                                                   \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"gegl_png_save_process (GeglOperation       *operation,                        \n"
"                       GeglBuffer          *input,                            \n"
"                       const GeglRectangle *result,                           \n"
"                       gint                 level)                            \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"                                                                              \n"
"  gegl_buffer_export_png (input, o->path, o->compression, o->bitdepth,        \n"
"                          result->x, result->y,                               \n"
"                          result->width, result->height);                     \n"
"  return  TRUE;                                                               \n"
"}                                                                             \n"
"                                                                              \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass     *operation_class;                                    \n"
"  GeglOperationSinkClass *sink_class;                                         \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  sink_class      = GEGL_OPERATION_SINK_CLASS (klass);                        \n"
"                                                                              \n"
"  sink_class->process    = gegl_png_save_process;                             \n"
"  sink_class->needs_full = TRUE;                                              \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"  \"name\",        \"gegl:png-save\",                                         \n"
"  \"title\",       _(\"PNG File Saver\"),                                     \n"
"  \"categories\" , \"output\",                                                \n"
"  \"description\",                                                            \n"
"        _(\"PNG image saver (passes the buffer through, saves as a side-effect.)\"),\n"
"        NULL);                                                                \n"
"                                                                              \n"
"  gegl_extension_handler_register_saver (\".png\", \"gegl:png-save\");        \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
