/* command-set.c generated by valac 0.21.1.1-0d6f, the Vala compiler
 * generated from command-set.vala, do not modify */

/*
 * Copyright (C) 2012 Jeremy Whiting <jeremy.whiting@collabora.com>
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Jeremy Whiting <jeremy.whiting@collabora.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <folks/folks.h>
#include <gee.h>
#include <stdio.h>
#include <readline/readline.h>


#define FOLKS_INSPECT_TYPE_COMMAND (folks_inspect_command_get_type ())
#define FOLKS_INSPECT_COMMAND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_INSPECT_TYPE_COMMAND, FolksInspectCommand))
#define FOLKS_INSPECT_COMMAND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_INSPECT_TYPE_COMMAND, FolksInspectCommandClass))
#define FOLKS_INSPECT_IS_COMMAND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_INSPECT_TYPE_COMMAND))
#define FOLKS_INSPECT_IS_COMMAND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_INSPECT_TYPE_COMMAND))
#define FOLKS_INSPECT_COMMAND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_INSPECT_TYPE_COMMAND, FolksInspectCommandClass))

typedef struct _FolksInspectCommand FolksInspectCommand;
typedef struct _FolksInspectCommandClass FolksInspectCommandClass;
typedef struct _FolksInspectCommandPrivate FolksInspectCommandPrivate;

#define FOLKS_INSPECT_TYPE_CLIENT (folks_inspect_client_get_type ())
#define FOLKS_INSPECT_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_INSPECT_TYPE_CLIENT, FolksInspectClient))
#define FOLKS_INSPECT_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_INSPECT_TYPE_CLIENT, FolksInspectClientClass))
#define FOLKS_INSPECT_IS_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_INSPECT_TYPE_CLIENT))
#define FOLKS_INSPECT_IS_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_INSPECT_TYPE_CLIENT))
#define FOLKS_INSPECT_CLIENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_INSPECT_TYPE_CLIENT, FolksInspectClientClass))

typedef struct _FolksInspectClient FolksInspectClient;
typedef struct _FolksInspectClientClass FolksInspectClientClass;

#define FOLKS_INSPECT_COMMANDS_TYPE_SET (folks_inspect_commands_set_get_type ())
#define FOLKS_INSPECT_COMMANDS_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_INSPECT_COMMANDS_TYPE_SET, FolksInspectCommandsSet))
#define FOLKS_INSPECT_COMMANDS_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_INSPECT_COMMANDS_TYPE_SET, FolksInspectCommandsSetClass))
#define FOLKS_INSPECT_COMMANDS_IS_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_INSPECT_COMMANDS_TYPE_SET))
#define FOLKS_INSPECT_COMMANDS_IS_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_INSPECT_COMMANDS_TYPE_SET))
#define FOLKS_INSPECT_COMMANDS_SET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_INSPECT_COMMANDS_TYPE_SET, FolksInspectCommandsSetClass))

typedef struct _FolksInspectCommandsSet FolksInspectCommandsSet;
typedef struct _FolksInspectCommandsSetClass FolksInspectCommandsSetClass;
typedef struct _FolksInspectCommandsSetPrivate FolksInspectCommandsSetPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _folks_inspect_command_unref0(var) ((var == NULL) ? NULL : (var = (folks_inspect_command_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _FolksInspectCommandsSetRunData FolksInspectCommandsSetRunData;

struct _FolksInspectCommand {
	GTypeInstance parent_instance;
	volatile int ref_count;
	FolksInspectCommandPrivate * priv;
	FolksInspectClient* client;
};

struct _FolksInspectCommandClass {
	GTypeClass parent_class;
	void (*finalize) (FolksInspectCommand *self);
	void (*run) (FolksInspectCommand* self, const gchar* command_string, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*run_finish) (FolksInspectCommand* self, GAsyncResult* _res_);
	gchar** (*complete_subcommand) (FolksInspectCommand* self, const gchar* subcommand, int* result_length1);
	const gchar* (*get_name) (FolksInspectCommand* self);
	const gchar* (*get_description) (FolksInspectCommand* self);
	const gchar* (*get_help) (FolksInspectCommand* self);
};

struct _FolksInspectCommandsSet {
	FolksInspectCommand parent_instance;
	FolksInspectCommandsSetPrivate * priv;
};

struct _FolksInspectCommandsSetClass {
	FolksInspectCommandClass parent_class;
};

struct _FolksInspectCommandsSetRunData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksInspectCommandsSet* self;
	gchar* command_string;
	gchar** parts;
	gchar** _tmp0_;
	gint parts_length1;
	gint _parts_size_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gboolean _tmp5_;
	gchar** _tmp6_;
	gint _tmp6__length1;
	gchar** _tmp7_;
	gint _tmp7__length1;
	const gchar* _tmp8_;
	gboolean _tmp9_;
	const gchar* _tmp10_;
	gchar** _tmp11_;
	gint _tmp11__length1;
	const gchar* _tmp12_;
	gchar** _tmp13_;
	gint _tmp13__length1;
	gboolean _tmp14_;
	gchar** _tmp15_;
	gint _tmp15__length1;
	const gchar* _tmp16_;
	gchar** _tmp17_;
	gint _tmp17__length1;
	const gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gboolean _tmp21_;
	gchar** _tmp22_;
	gint _tmp22__length1;
	const gchar* _tmp23_;
	gchar* id;
	gchar** _tmp24_;
	gint _tmp24__length1;
	const gchar* _tmp25_;
	gchar* _tmp26_;
	FolksIndividual* individual;
	FolksInspectClient* _tmp27_;
	FolksIndividualAggregator* _tmp28_;
	FolksIndividualAggregator* _tmp29_;
	GeeMap* _tmp30_;
	GeeMap* _tmp31_;
	const gchar* _tmp32_;
	gpointer _tmp33_;
	FolksIndividual* _tmp34_;
	const gchar* _tmp35_;
	FolksPersona* persona;
	FolksInspectClient* _tmp36_;
	FolksIndividualAggregator* _tmp37_;
	FolksIndividualAggregator* _tmp38_;
	FolksIndividual* _tmp39_;
	FolksPersona* _tmp40_;
	FolksPersona* _tmp41_;
	FolksIndividual* _tmp42_;
	FolksIndividual* _tmp43_;
	gchar** _tmp44_;
	gint _tmp44__length1;
	const gchar* _tmp45_;
	gchar** _tmp46_;
	gint _tmp46__length1;
	const gchar* _tmp47_;
	GError* e;
	gchar** _tmp48_;
	gint _tmp48__length1;
	const gchar* _tmp49_;
	GError * _inner_error_;
};


static gpointer folks_inspect_commands_set_parent_class = NULL;
static gchar** folks_inspect_commands_set_subcommand_completions;
static gchar** folks_inspect_commands_set_subcommand_completions = NULL;
static guint folks_inspect_commands_set_completion_count;
static guint folks_inspect_commands_set_completion_count = 0U;
static gchar* folks_inspect_commands_set_prefix;
static gchar* folks_inspect_commands_set_prefix = NULL;

gpointer folks_inspect_command_ref (gpointer instance);
void folks_inspect_command_unref (gpointer instance);
GParamSpec* folks_inspect_param_spec_command (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void folks_inspect_value_set_command (GValue* value, gpointer v_object);
void folks_inspect_value_take_command (GValue* value, gpointer v_object);
gpointer folks_inspect_value_get_command (const GValue* value);
GType folks_inspect_command_get_type (void) G_GNUC_CONST;
GType folks_inspect_client_get_type (void) G_GNUC_CONST;
GType folks_inspect_commands_set_get_type (void) G_GNUC_CONST;
enum  {
	FOLKS_INSPECT_COMMANDS_SET_DUMMY_PROPERTY
};
FolksInspectCommandsSet* folks_inspect_commands_set_new (FolksInspectClient* client);
FolksInspectCommandsSet* folks_inspect_commands_set_construct (GType object_type, FolksInspectClient* client);
FolksInspectCommand* folks_inspect_command_construct (GType object_type, FolksInspectClient* client);
static void folks_inspect_commands_set_real_run_data_free (gpointer _data);
static void folks_inspect_commands_set_real_run (FolksInspectCommand* base, const gchar* command_string, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean folks_inspect_commands_set_real_run_co (FolksInspectCommandsSetRunData* _data_);
void folks_inspect_utils_print_line (const gchar* format, ...);
FolksIndividualAggregator* folks_inspect_client_get_aggregator (FolksInspectClient* self);
static void folks_inspect_commands_set_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
gchar* folks_inspect_commands_set_subcommand_name_completion_cb (const gchar* word, gint state);
gchar* folks_inspect_utils_individual_id_completion_cb (const gchar* word, gint state);
static gchar* _folks_inspect_utils_individual_id_completion_cb_rl_compentry_func_t (const gchar* str, gint a);
static gchar** _vala_array_dup10 (gchar** self, int length);
static gchar** folks_inspect_commands_set_real_complete_subcommand (FolksInspectCommand* base, const gchar* subcommand, int* result_length1);
static gchar* _folks_inspect_commands_set_subcommand_name_completion_cb_rl_compentry_func_t (const gchar* str, gint a);
static gchar** _vala_array_dup11 (gchar** self, int length);
static void folks_inspect_commands_set_finalize (FolksInspectCommand* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


FolksInspectCommandsSet* folks_inspect_commands_set_construct (GType object_type, FolksInspectClient* client) {
	FolksInspectCommandsSet* self = NULL;
	FolksInspectClient* _tmp0_ = NULL;
	g_return_val_if_fail (client != NULL, NULL);
	_tmp0_ = client;
	self = (FolksInspectCommandsSet*) folks_inspect_command_construct (object_type, _tmp0_);
	return self;
}


FolksInspectCommandsSet* folks_inspect_commands_set_new (FolksInspectClient* client) {
	return folks_inspect_commands_set_construct (FOLKS_INSPECT_COMMANDS_TYPE_SET, client);
}


static void folks_inspect_commands_set_real_run_data_free (gpointer _data) {
	FolksInspectCommandsSetRunData* _data_;
	_data_ = _data;
	_g_free0 (_data_->command_string);
	_folks_inspect_command_unref0 (_data_->self);
	g_slice_free (FolksInspectCommandsSetRunData, _data_);
}


static gpointer _folks_inspect_command_ref0 (gpointer self) {
	return self ? folks_inspect_command_ref (self) : NULL;
}


static void folks_inspect_commands_set_real_run (FolksInspectCommand* base, const gchar* command_string, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksInspectCommandsSet * self;
	FolksInspectCommandsSetRunData* _data_;
	FolksInspectCommandsSet* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	self = (FolksInspectCommandsSet*) base;
	_data_ = g_slice_new0 (FolksInspectCommandsSetRunData);
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, folks_inspect_commands_set_real_run);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_inspect_commands_set_real_run_data_free);
	_tmp0_ = _folks_inspect_command_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = command_string;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (_data_->command_string);
	_data_->command_string = _tmp2_;
	folks_inspect_commands_set_real_run_co (_data_);
}


static void folks_inspect_commands_set_real_run_finish (FolksInspectCommand* base, GAsyncResult* _res_) {
	FolksInspectCommandsSetRunData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


static void folks_inspect_commands_set_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FolksInspectCommandsSetRunData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	folks_inspect_commands_set_real_run_co (_data_);
}


static gboolean folks_inspect_commands_set_real_run_co (FolksInspectCommandsSetRunData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = g_new0 (gchar*, 0 + 1);
	_data_->parts_length1 = 0;
	_data_->_parts_size_ = 0;
	_data_->parts = _data_->_tmp0_;
	_data_->parts_length1 = 0;
	_data_->_parts_size_ = _data_->parts_length1;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->command_string;
	if (_data_->_tmp1_ != NULL) {
		_data_->_tmp2_ = NULL;
		_data_->_tmp2_ = _data_->command_string;
		_data_->_tmp3_ = NULL;
		_data_->_tmp4_ = NULL;
		_data_->_tmp4_ = _data_->_tmp3_ = g_strsplit (_data_->_tmp2_, " ", 0);
		_data_->parts = (_vala_array_free (_data_->parts, _data_->parts_length1, (GDestroyNotify) g_free), NULL);
		_data_->parts = _data_->_tmp4_;
		_data_->parts_length1 = _vala_array_length (_data_->_tmp3_);
		_data_->_parts_size_ = _data_->parts_length1;
	}
	_data_->_tmp6_ = NULL;
	_data_->_tmp6__length1 = 0;
	_data_->_tmp6_ = _data_->parts;
	_data_->_tmp6__length1 = _data_->parts_length1;
	if (_data_->_tmp6__length1 < 1) {
		_data_->_tmp5_ = TRUE;
	} else {
		_data_->_tmp7_ = NULL;
		_data_->_tmp7__length1 = 0;
		_data_->_tmp7_ = _data_->parts;
		_data_->_tmp7__length1 = _data_->parts_length1;
		_data_->_tmp8_ = NULL;
		_data_->_tmp8_ = _data_->_tmp7_[0];
		_data_->_tmp5_ = g_strcmp0 (_data_->_tmp8_, "alias") != 0;
	}
	_data_->_tmp9_ = FALSE;
	_data_->_tmp9_ = _data_->_tmp5_;
	if (_data_->_tmp9_) {
		_data_->_tmp10_ = NULL;
		_data_->_tmp10_ = _data_->command_string;
		folks_inspect_utils_print_line ("Unrecognised 'set' command '%s'.", _data_->_tmp10_);
		_data_->parts = (_vala_array_free (_data_->parts, _data_->parts_length1, (GDestroyNotify) g_free), NULL);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp11_ = NULL;
	_data_->_tmp11__length1 = 0;
	_data_->_tmp11_ = _data_->parts;
	_data_->_tmp11__length1 = _data_->parts_length1;
	_data_->_tmp12_ = NULL;
	_data_->_tmp12_ = _data_->_tmp11_[0];
	if (g_strcmp0 (_data_->_tmp12_, "alias") == 0) {
		_data_->_tmp13_ = NULL;
		_data_->_tmp13__length1 = 0;
		_data_->_tmp13_ = _data_->parts;
		_data_->_tmp13__length1 = _data_->parts_length1;
		if (_data_->_tmp13__length1 < 3) {
			folks_inspect_utils_print_line ("%s", "Must pass at least one individual ID and a new alias to an " "'alias' subcommand.");
			_data_->parts = (_vala_array_free (_data_->parts, _data_->parts_length1, (GDestroyNotify) g_free), NULL);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp15_ = NULL;
		_data_->_tmp15__length1 = 0;
		_data_->_tmp15_ = _data_->parts;
		_data_->_tmp15__length1 = _data_->parts_length1;
		_data_->_tmp16_ = NULL;
		_data_->_tmp16_ = _data_->_tmp15_[1];
		if (_data_->_tmp16_ == NULL) {
			_data_->_tmp14_ = TRUE;
		} else {
			_data_->_tmp17_ = NULL;
			_data_->_tmp17__length1 = 0;
			_data_->_tmp17_ = _data_->parts;
			_data_->_tmp17__length1 = _data_->parts_length1;
			_data_->_tmp18_ = NULL;
			_data_->_tmp18_ = _data_->_tmp17_[1];
			_data_->_tmp19_ = NULL;
			_data_->_tmp19_ = string_strip (_data_->_tmp18_);
			_data_->_tmp20_ = NULL;
			_data_->_tmp20_ = _data_->_tmp19_;
			_data_->_tmp14_ = g_strcmp0 (_data_->_tmp20_, "") == 0;
			_g_free0 (_data_->_tmp20_);
		}
		_data_->_tmp21_ = FALSE;
		_data_->_tmp21_ = _data_->_tmp14_;
		if (_data_->_tmp21_) {
			_data_->_tmp22_ = NULL;
			_data_->_tmp22__length1 = 0;
			_data_->_tmp22_ = _data_->parts;
			_data_->_tmp22__length1 = _data_->parts_length1;
			_data_->_tmp23_ = NULL;
			_data_->_tmp23_ = _data_->_tmp22_[1];
			folks_inspect_utils_print_line ("Unrecognised individual ID '%s'.", _data_->_tmp23_);
			_data_->parts = (_vala_array_free (_data_->parts, _data_->parts_length1, (GDestroyNotify) g_free), NULL);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp24_ = NULL;
		_data_->_tmp24__length1 = 0;
		_data_->_tmp24_ = _data_->parts;
		_data_->_tmp24__length1 = _data_->parts_length1;
		_data_->_tmp25_ = NULL;
		_data_->_tmp25_ = _data_->_tmp24_[1];
		_data_->_tmp26_ = NULL;
		_data_->_tmp26_ = string_strip (_data_->_tmp25_);
		_data_->id = _data_->_tmp26_;
		_data_->_tmp27_ = NULL;
		_data_->_tmp27_ = ((FolksInspectCommand*) _data_->self)->client;
		_data_->_tmp28_ = NULL;
		_data_->_tmp28_ = folks_inspect_client_get_aggregator (_data_->_tmp27_);
		_data_->_tmp29_ = NULL;
		_data_->_tmp29_ = _data_->_tmp28_;
		_data_->_tmp30_ = NULL;
		_data_->_tmp30_ = folks_individual_aggregator_get_individuals (_data_->_tmp29_);
		_data_->_tmp31_ = NULL;
		_data_->_tmp31_ = _data_->_tmp30_;
		_data_->_tmp32_ = NULL;
		_data_->_tmp32_ = _data_->id;
		_data_->_tmp33_ = NULL;
		_data_->_tmp33_ = gee_map_get (_data_->_tmp31_, _data_->_tmp32_);
		_data_->individual = (FolksIndividual*) _data_->_tmp33_;
		_data_->_tmp34_ = NULL;
		_data_->_tmp34_ = _data_->individual;
		if (_data_->_tmp34_ == NULL) {
			_data_->_tmp35_ = NULL;
			_data_->_tmp35_ = _data_->id;
			folks_inspect_utils_print_line ("Unrecognized individual ID '%s'.", _data_->_tmp35_);
			_g_object_unref0 (_data_->individual);
			_g_free0 (_data_->id);
			_data_->parts = (_vala_array_free (_data_->parts, _data_->parts_length1, (GDestroyNotify) g_free), NULL);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		{
			_data_->_tmp36_ = NULL;
			_data_->_tmp36_ = ((FolksInspectCommand*) _data_->self)->client;
			_data_->_tmp37_ = NULL;
			_data_->_tmp37_ = folks_inspect_client_get_aggregator (_data_->_tmp36_);
			_data_->_tmp38_ = NULL;
			_data_->_tmp38_ = _data_->_tmp37_;
			_data_->_tmp39_ = NULL;
			_data_->_tmp39_ = _data_->individual;
			_data_->_state_ = 1;
			folks_individual_aggregator_ensure_individual_property_writeable (_data_->_tmp38_, _data_->_tmp39_, "alias", folks_inspect_commands_set_run_ready, _data_);
			return FALSE;
			_state_1:
			_data_->_tmp40_ = NULL;
			_data_->_tmp40_ = folks_individual_aggregator_ensure_individual_property_writeable_finish (_data_->_tmp38_, _data_->_res_, &_data_->_inner_error_);
			_data_->persona = _data_->_tmp40_;
			if (_data_->_inner_error_ != NULL) {
				if (_data_->_inner_error_->domain == FOLKS_INDIVIDUAL_AGGREGATOR_ERROR) {
					goto __catch2_folks_individual_aggregator_error;
				}
				_g_object_unref0 (_data_->individual);
				_g_free0 (_data_->id);
				_data_->parts = (_vala_array_free (_data_->parts, _data_->parts_length1, (GDestroyNotify) g_free), NULL);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
				g_clear_error (&_data_->_inner_error_);
				return FALSE;
			}
			_data_->_tmp41_ = NULL;
			_data_->_tmp41_ = _data_->persona;
			_data_->_tmp42_ = NULL;
			_data_->_tmp42_ = folks_persona_get_individual (_data_->_tmp41_);
			_data_->_tmp43_ = NULL;
			_data_->_tmp43_ = _data_->_tmp42_;
			_data_->_tmp44_ = NULL;
			_data_->_tmp44__length1 = 0;
			_data_->_tmp44_ = _data_->parts;
			_data_->_tmp44__length1 = _data_->parts_length1;
			_data_->_tmp45_ = NULL;
			_data_->_tmp45_ = _data_->_tmp44_[2];
			folks_alias_details_set_alias ((FolksAliasDetails*) _data_->_tmp43_, _data_->_tmp45_);
			_data_->_tmp46_ = NULL;
			_data_->_tmp46__length1 = 0;
			_data_->_tmp46_ = _data_->parts;
			_data_->_tmp46__length1 = _data_->parts_length1;
			_data_->_tmp47_ = NULL;
			_data_->_tmp47_ = _data_->_tmp46_[2];
			folks_inspect_utils_print_line ("Setting of individual's alias to '%s' was successful.", _data_->_tmp47_);
			_g_object_unref0 (_data_->persona);
		}
		goto __finally2;
		__catch2_folks_individual_aggregator_error:
		{
			_data_->e = _data_->_inner_error_;
			_data_->_inner_error_ = NULL;
			_data_->_tmp48_ = NULL;
			_data_->_tmp48__length1 = 0;
			_data_->_tmp48_ = _data_->parts;
			_data_->_tmp48__length1 = _data_->parts_length1;
			_data_->_tmp49_ = NULL;
			_data_->_tmp49_ = _data_->_tmp48_[2];
			folks_inspect_utils_print_line ("Setting of individual's alias to '%s' failed.", _data_->_tmp49_);
			_g_error_free0 (_data_->e);
		}
		__finally2:
		if (_data_->_inner_error_ != NULL) {
			_g_object_unref0 (_data_->individual);
			_g_free0 (_data_->id);
			_data_->parts = (_vala_array_free (_data_->parts, _data_->parts_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
		_g_object_unref0 (_data_->individual);
		_g_free0 (_data_->id);
		_data_->parts = (_vala_array_free (_data_->parts, _data_->parts_length1, (GDestroyNotify) g_free), NULL);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		g_assert_not_reached ();
	}
	_data_->parts = (_vala_array_free (_data_->parts, _data_->parts_length1, (GDestroyNotify) g_free), NULL);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static gchar* _folks_inspect_utils_individual_id_completion_cb_rl_compentry_func_t (const gchar* str, gint a) {
	gchar* result;
	result = folks_inspect_utils_individual_id_completion_cb (str, a);
	return result;
}


static gchar** _vala_array_dup10 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	glong _tmp2_ = 0L;
	glong _tmp5_ = 0L;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_ = 0L;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	glong _tmp14_ = 0L;
	gboolean _tmp17_ = FALSE;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	glong _tmp22_ = 0L;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	_tmp2_ = start;
	if (_tmp2_ < ((glong) 0)) {
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		_tmp3_ = string_length;
		_tmp4_ = start;
		start = _tmp3_ + _tmp4_;
	}
	_tmp5_ = end;
	if (_tmp5_ < ((glong) 0)) {
		glong _tmp6_ = 0L;
		glong _tmp7_ = 0L;
		_tmp6_ = string_length;
		_tmp7_ = end;
		end = _tmp6_ + _tmp7_;
	}
	_tmp9_ = start;
	if (_tmp9_ >= ((glong) 0)) {
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		_tmp10_ = start;
		_tmp11_ = string_length;
		_tmp8_ = _tmp10_ <= _tmp11_;
	} else {
		_tmp8_ = FALSE;
	}
	_tmp12_ = _tmp8_;
	g_return_val_if_fail (_tmp12_, NULL);
	_tmp14_ = end;
	if (_tmp14_ >= ((glong) 0)) {
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
		_tmp15_ = end;
		_tmp16_ = string_length;
		_tmp13_ = _tmp15_ <= _tmp16_;
	} else {
		_tmp13_ = FALSE;
	}
	_tmp17_ = _tmp13_;
	g_return_val_if_fail (_tmp17_, NULL);
	_tmp18_ = start;
	_tmp19_ = end;
	g_return_val_if_fail (_tmp18_ <= _tmp19_, NULL);
	_tmp20_ = start;
	_tmp21_ = end;
	_tmp22_ = start;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) (_tmp21_ - _tmp22_));
	result = _tmp23_;
	return result;
}


gchar* folks_inspect_commands_set_subcommand_name_completion_cb (const gchar* word, gint state) {
	gchar* result = NULL;
	gint _tmp0_ = 0;
	gchar* _tmp49_ = NULL;
	g_return_val_if_fail (word != NULL, NULL);
	_tmp0_ = state;
	if (_tmp0_ == 0) {
		gchar** parts = NULL;
		const gchar* _tmp1_ = NULL;
		gchar** _tmp2_ = NULL;
		gchar** _tmp3_ = NULL;
		gint parts_length1 = 0;
		gint _parts_size_ = 0;
		gboolean _tmp4_ = FALSE;
		gchar** _tmp5_ = NULL;
		gint _tmp5__length1 = 0;
		gboolean _tmp8_ = FALSE;
		_tmp1_ = word;
		_tmp3_ = _tmp2_ = g_strsplit (_tmp1_, " ", 0);
		parts = _tmp3_;
		parts_length1 = _vala_array_length (_tmp2_);
		_parts_size_ = parts_length1;
		_tmp5_ = parts;
		_tmp5__length1 = parts_length1;
		if (_tmp5__length1 > 0) {
			gchar** _tmp6_ = NULL;
			gint _tmp6__length1 = 0;
			const gchar* _tmp7_ = NULL;
			_tmp6_ = parts;
			_tmp6__length1 = parts_length1;
			_tmp7_ = _tmp6_[0];
			_tmp4_ = g_strcmp0 (_tmp7_, "alias") == 0;
		} else {
			_tmp4_ = FALSE;
		}
		_tmp8_ = _tmp4_;
		if (_tmp8_) {
			gchar* last_part = NULL;
			gchar** _tmp9_ = NULL;
			gint _tmp9__length1 = 0;
			gchar** _tmp10_ = NULL;
			gint _tmp10__length1 = 0;
			const gchar* _tmp11_ = NULL;
			gchar* _tmp12_ = NULL;
			gchar** _tmp13_ = NULL;
			gint _tmp13__length1 = 0;
			const gchar* _tmp14_ = NULL;
			const gchar* _tmp19_ = NULL;
			_tmp9_ = parts;
			_tmp9__length1 = parts_length1;
			_tmp10_ = parts;
			_tmp10__length1 = parts_length1;
			_tmp11_ = _tmp9_[_tmp10__length1 - 1];
			_tmp12_ = g_strdup (_tmp11_);
			last_part = _tmp12_;
			_tmp13_ = parts;
			_tmp13__length1 = parts_length1;
			_tmp14_ = _tmp13_[0];
			if (g_strcmp0 (_tmp14_, "alias") == 0) {
				const gchar* _tmp15_ = NULL;
				gchar** _tmp16_ = NULL;
				gchar** _tmp17_ = NULL;
				gchar** _tmp18_ = NULL;
				gint _tmp18__length1 = 0;
				_tmp15_ = last_part;
				_tmp17_ = _tmp16_ = rl_completion_matches (_tmp15_, _folks_inspect_utils_individual_id_completion_cb_rl_compentry_func_t);
				_tmp18_ = (_tmp17_ != NULL) ? _vala_array_dup10 (_tmp17_, _vala_array_length (_tmp16_)) : ((gpointer) _tmp17_);
				_tmp18__length1 = _vala_array_length (_tmp16_);
				folks_inspect_commands_set_subcommand_completions = (_vala_array_free (folks_inspect_commands_set_subcommand_completions, _vala_array_length (folks_inspect_commands_set_subcommand_completions), (GDestroyNotify) g_free), NULL);
				folks_inspect_commands_set_subcommand_completions = _tmp18_;
			}
			_tmp19_ = last_part;
			if (g_strcmp0 (_tmp19_, "") == 0) {
				const gchar* _tmp20_ = NULL;
				gchar* _tmp21_ = NULL;
				_tmp20_ = word;
				_tmp21_ = g_strdup (_tmp20_);
				_g_free0 (folks_inspect_commands_set_prefix);
				folks_inspect_commands_set_prefix = _tmp21_;
			} else {
				const gchar* _tmp22_ = NULL;
				const gchar* _tmp23_ = NULL;
				gint _tmp24_ = 0;
				gint _tmp25_ = 0;
				gchar* _tmp26_ = NULL;
				_tmp22_ = word;
				_tmp23_ = last_part;
				_tmp24_ = strlen (_tmp23_);
				_tmp25_ = _tmp24_;
				_tmp26_ = string_slice (_tmp22_, (glong) 0, (glong) (-_tmp25_));
				_g_free0 (folks_inspect_commands_set_prefix);
				folks_inspect_commands_set_prefix = _tmp26_;
			}
			_g_free0 (last_part);
		} else {
			gchar* _tmp27_ = NULL;
			gchar** _tmp28_ = NULL;
			gchar* _tmp29_ = NULL;
			_tmp27_ = g_strdup ("alias");
			_tmp28_ = g_new0 (gchar*, 2 + 1);
			_tmp28_[0] = _tmp27_;
			_tmp28_[1] = NULL;
			folks_inspect_commands_set_subcommand_completions = (_vala_array_free (folks_inspect_commands_set_subcommand_completions, _vala_array_length (folks_inspect_commands_set_subcommand_completions), (GDestroyNotify) g_free), NULL);
			folks_inspect_commands_set_subcommand_completions = _tmp28_;
			_tmp29_ = g_strdup ("");
			_g_free0 (folks_inspect_commands_set_prefix);
			folks_inspect_commands_set_prefix = _tmp29_;
		}
		folks_inspect_commands_set_completion_count = (guint) 0;
		parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
	}
	while (TRUE) {
		guint _tmp30_ = 0U;
		gchar** _tmp31_ = NULL;
		gint _tmp31__length1 = 0;
		gchar* completion = NULL;
		gchar** _tmp32_ = NULL;
		gint _tmp32__length1 = 0;
		guint _tmp33_ = 0U;
		const gchar* _tmp34_ = NULL;
		gchar* _tmp35_ = NULL;
		gchar* candidate = NULL;
		const gchar* _tmp36_ = NULL;
		const gchar* _tmp37_ = NULL;
		gchar* _tmp38_ = NULL;
		guint _tmp39_ = 0U;
		gboolean _tmp40_ = FALSE;
		gboolean _tmp41_ = FALSE;
		const gchar* _tmp42_ = NULL;
		gboolean _tmp44_ = FALSE;
		gboolean _tmp48_ = FALSE;
		_tmp30_ = folks_inspect_commands_set_completion_count;
		_tmp31_ = folks_inspect_commands_set_subcommand_completions;
		_tmp31__length1 = _vala_array_length (folks_inspect_commands_set_subcommand_completions);
		if (!(_tmp30_ < ((guint) _tmp31__length1))) {
			break;
		}
		_tmp32_ = folks_inspect_commands_set_subcommand_completions;
		_tmp32__length1 = _vala_array_length (folks_inspect_commands_set_subcommand_completions);
		_tmp33_ = folks_inspect_commands_set_completion_count;
		_tmp34_ = _tmp32_[_tmp33_];
		_tmp35_ = g_strdup (_tmp34_);
		completion = _tmp35_;
		_tmp36_ = folks_inspect_commands_set_prefix;
		_tmp37_ = completion;
		_tmp38_ = g_strconcat (_tmp36_, _tmp37_, NULL);
		candidate = _tmp38_;
		_tmp39_ = folks_inspect_commands_set_completion_count;
		folks_inspect_commands_set_completion_count = _tmp39_ + 1;
		_tmp42_ = completion;
		if (_tmp42_ != NULL) {
			const gchar* _tmp43_ = NULL;
			_tmp43_ = completion;
			_tmp41_ = g_strcmp0 (_tmp43_, "") != 0;
		} else {
			_tmp41_ = FALSE;
		}
		_tmp44_ = _tmp41_;
		if (_tmp44_) {
			const gchar* _tmp45_ = NULL;
			const gchar* _tmp46_ = NULL;
			gboolean _tmp47_ = FALSE;
			_tmp45_ = candidate;
			_tmp46_ = word;
			_tmp47_ = g_str_has_prefix (_tmp45_, _tmp46_);
			_tmp40_ = _tmp47_;
		} else {
			_tmp40_ = FALSE;
		}
		_tmp48_ = _tmp40_;
		if (_tmp48_) {
			result = completion;
			_g_free0 (candidate);
			return result;
		}
		_g_free0 (candidate);
		_g_free0 (completion);
	}
	folks_inspect_commands_set_subcommand_completions = (_vala_array_free (folks_inspect_commands_set_subcommand_completions, _vala_array_length (folks_inspect_commands_set_subcommand_completions), (GDestroyNotify) g_free), NULL);
	folks_inspect_commands_set_subcommand_completions = NULL;
	folks_inspect_commands_set_completion_count = (guint) 0;
	_tmp49_ = g_strdup ("");
	_g_free0 (folks_inspect_commands_set_prefix);
	folks_inspect_commands_set_prefix = _tmp49_;
	result = NULL;
	return result;
}


static gchar* _folks_inspect_commands_set_subcommand_name_completion_cb_rl_compentry_func_t (const gchar* str, gint a) {
	gchar* result;
	result = folks_inspect_commands_set_subcommand_name_completion_cb (str, a);
	return result;
}


static gchar** _vala_array_dup11 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** folks_inspect_commands_set_real_complete_subcommand (FolksInspectCommand* base, const gchar* subcommand, int* result_length1) {
	FolksInspectCommandsSet * self;
	gchar** result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar** _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	gchar** _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	self = (FolksInspectCommandsSet*) base;
	g_return_val_if_fail (subcommand != NULL, NULL);
	_tmp0_ = subcommand;
	_tmp2_ = _tmp1_ = rl_completion_matches (_tmp0_, _folks_inspect_commands_set_subcommand_name_completion_cb_rl_compentry_func_t);
	_tmp3_ = (_tmp2_ != NULL) ? _vala_array_dup11 (_tmp2_, _vala_array_length (_tmp1_)) : ((gpointer) _tmp2_);
	_tmp3__length1 = _vala_array_length (_tmp1_);
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp3__length1;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	return result;
}


static const gchar* folks_inspect_commands_set_real_get_name (FolksInspectCommand* base) {
	const gchar* result;
	FolksInspectCommandsSet* self;
	self = (FolksInspectCommandsSet*) base;
	result = "set";
	return result;
}


static const gchar* folks_inspect_commands_set_real_get_description (FolksInspectCommand* base) {
	const gchar* result;
	FolksInspectCommandsSet* self;
	self = (FolksInspectCommandsSet*) base;
	result = "set an individual's attributes";
	return result;
}


static const gchar* folks_inspect_commands_set_real_get_help (FolksInspectCommand* base) {
	const gchar* result;
	FolksInspectCommandsSet* self;
	self = (FolksInspectCommandsSet*) base;
	result = "set alias [individual UID] [new alias]" "   Set the alias of the given individual.";
	return result;
}


static void folks_inspect_commands_set_class_init (FolksInspectCommandsSetClass * klass) {
	folks_inspect_commands_set_parent_class = g_type_class_peek_parent (klass);
	FOLKS_INSPECT_COMMAND_CLASS (klass)->finalize = folks_inspect_commands_set_finalize;
	FOLKS_INSPECT_COMMAND_CLASS (klass)->run = folks_inspect_commands_set_real_run;
	FOLKS_INSPECT_COMMAND_CLASS (klass)->run_finish = folks_inspect_commands_set_real_run_finish;
	FOLKS_INSPECT_COMMAND_CLASS (klass)->complete_subcommand = folks_inspect_commands_set_real_complete_subcommand;
	FOLKS_INSPECT_COMMAND_CLASS (klass)->get_name = folks_inspect_commands_set_real_get_name;
	FOLKS_INSPECT_COMMAND_CLASS (klass)->get_description = folks_inspect_commands_set_real_get_description;
	FOLKS_INSPECT_COMMAND_CLASS (klass)->get_help = folks_inspect_commands_set_real_get_help;
}


static void folks_inspect_commands_set_instance_init (FolksInspectCommandsSet * self) {
}


static void folks_inspect_commands_set_finalize (FolksInspectCommand* obj) {
	FolksInspectCommandsSet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FOLKS_INSPECT_COMMANDS_TYPE_SET, FolksInspectCommandsSet);
	FOLKS_INSPECT_COMMAND_CLASS (folks_inspect_commands_set_parent_class)->finalize (obj);
}


GType folks_inspect_commands_set_get_type (void) {
	static volatile gsize folks_inspect_commands_set_type_id__volatile = 0;
	if (g_once_init_enter (&folks_inspect_commands_set_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FolksInspectCommandsSetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_inspect_commands_set_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksInspectCommandsSet), 0, (GInstanceInitFunc) folks_inspect_commands_set_instance_init, NULL };
		GType folks_inspect_commands_set_type_id;
		folks_inspect_commands_set_type_id = g_type_register_static (FOLKS_INSPECT_TYPE_COMMAND, "FolksInspectCommandsSet", &g_define_type_info, 0);
		g_once_init_leave (&folks_inspect_commands_set_type_id__volatile, folks_inspect_commands_set_type_id);
	}
	return folks_inspect_commands_set_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



