/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.renderer.java3d.terrain.roam;

import javax.media.j3d.Appearance;
import javax.media.j3d.BoundingBox;
import javax.media.j3d.Bounds;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryUpdater;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.media.j3d.TriangleArray;
import org.j3d.terrain.TerrainData;
import org.j3d.terrain.roam.ROAMPatch;
import org.j3d.terrain.roam.VertexData;
import org.j3d.util.frustum.ViewFrustum;

class Patch
extends ROAMPatch
implements GeometryUpdater {
    private Shape3D shape3D;
    private TriangleArray geometry;
    private BoundingBox bounds;
    private Appearance appearance;

    Patch(TerrainData terrainData, int n, Appearance appearance, ViewFrustum viewFrustum, int n2, int n3) {
        super(terrainData, n, viewFrustum, n2, n3);
        this.appearance = appearance;
        this.bounds = new BoundingBox();
        boolean bl = this.terrainData.hasTexture();
        boolean bl2 = this.terrainData.hasColor();
        this.vertexData = new VertexData(this.PATCH_SIZE, bl, bl2);
        int n4 = 129;
        if (bl) {
            n4 |= 0x20;
        }
        if (bl2) {
            n4 |= 4;
        }
        this.geometry = new TriangleArray(this.PATCH_SIZE * this.PATCH_SIZE * 2 * 3, n4);
        this.geometry.setCapability(19);
        this.geometry.setCapability(20);
        this.geometry.setCoordRefFloat(this.vertexData.getCoords());
        if (bl) {
            this.geometry.setTexCoordRefFloat(0, this.vertexData.getTextureCoords());
        }
        if (bl2) {
            this.geometry.setColorRefByte(this.vertexData.getColors());
        }
        this.shape3D = new Shape3D((Geometry)this.geometry, appearance);
        this.shape3D.setCapability(4);
        this.shape3D.setBoundsAutoCompute(false);
        this.shape3D.setUserData((Object)this.terrainData);
    }

    public void updateData(Geometry geometry) {
        if (!this.resetRequested) {
            this.createGeometry();
        }
        TriangleArray triangleArray = (TriangleArray)geometry;
        triangleArray.setValidVertexCount(this.vertexData.getVertexCount());
    }

    Appearance getAppearance() {
        return this.appearance;
    }

    public void updateGeometry() {
        if (this.NWTree != null && (this.NWTree.getVisibility() != 2 || this.SETree.getVisibility() != 2 || this.vertexData.getVertexCount() != 0)) {
            this.geometry.updateData((GeometryUpdater)this);
        }
    }

    public void clear() {
        super.clear();
        this.geometry.updateData((GeometryUpdater)this);
    }

    protected void setOrigin(int n, int n2) {
        super.setOrigin(n, n2);
        int n3 = n + this.PATCH_SIZE;
        int n4 = n2 + this.PATCH_SIZE;
        double d = this.terrainData.getGridXStep();
        double d2 = this.terrainData.getGridYStep();
        this.bounds.setLower((double)n * d, (double)this.minY, (double)(-n3) * d2);
        this.bounds.setUpper((double)n4 * d, (double)this.maxY, (double)(-n2) * d2);
        this.shape3D.setBounds((Bounds)this.bounds);
    }

    Node getSceneGraphObject() {
        return this.shape3D;
    }
}

