/*
 * Decompiled with CFR 0.152.
 */
package org.xj3d.io;

import java.io.FilterReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.xj3d.io.ReadProgressListener;

public class ReportableInputStreamReader
extends FilterReader {
    private int bytesRead = 0;
    private int totalBytesRead;
    private boolean relative;
    private int updateSize;
    private ReadProgressListener listener;

    public ReportableInputStreamReader(boolean bl, int n, ReadProgressListener readProgressListener, InputStream inputStream) {
        super(new InputStreamReader(inputStream));
        this.relative = bl;
        this.updateSize = n;
        this.listener = readProgressListener;
    }

    public void close() throws IOException {
        super.close();
        if (this.listener != null) {
            this.listener.streamClosed();
        }
    }

    public int read() throws IOException {
        int n = super.read();
        if (n != -1) {
            ++this.bytesRead;
        }
        if (this.bytesRead >= this.updateSize) {
            this.totalBytesRead += this.bytesRead;
            if (this.relative) {
                this.listener.progressUpdate(this.bytesRead);
            } else {
                this.listener.progressUpdate(this.totalBytesRead);
            }
            this.bytesRead = 0;
        }
        return n;
    }

    public int read(char[] cArray) throws IOException {
        int n = super.read(cArray, 0, cArray.length);
        if (n != -1) {
            this.bytesRead += n;
        }
        if (this.bytesRead >= this.updateSize) {
            this.totalBytesRead += this.bytesRead;
            if (this.relative) {
                this.listener.progressUpdate(this.bytesRead);
            } else {
                this.listener.progressUpdate(this.totalBytesRead);
            }
            this.bytesRead = 0;
        }
        return n;
    }

    public int read(char[] cArray, int n, int n2) throws IOException {
        int n3 = super.read(cArray, n, n2);
        if (n3 != -1) {
            this.bytesRead += n3;
        }
        if (this.bytesRead >= this.updateSize) {
            this.totalBytesRead += this.bytesRead;
            if (this.relative) {
                this.listener.progressUpdate(this.bytesRead);
            } else {
                this.listener.progressUpdate(this.totalBytesRead);
            }
            this.bytesRead = 0;
        }
        return n3;
    }

    public void reset() throws IOException {
        super.reset();
        this.totalBytesRead = 0;
        this.bytesRead = 0;
    }

    public long skip(long l) throws IOException {
        long l2 = this.skip(l);
        this.bytesRead = (int)((long)this.bytesRead + l);
        if (this.bytesRead >= this.updateSize) {
            this.totalBytesRead += this.bytesRead;
            if (this.relative) {
                this.listener.progressUpdate(this.bytesRead);
            } else {
                this.listener.progressUpdate(this.totalBytesRead);
            }
            this.bytesRead = 0;
        }
        return l2;
    }
}

