/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.util;

import java.util.Arrays;

public class ShortHashMap
implements Cloneable {
    private transient Entry[] table;
    private transient int count;
    private int threshold;
    private float loadFactor;

    public ShortHashMap() {
        this(20, 0.75f);
    }

    public ShortHashMap(int n) {
        this(n, 0.75f);
    }

    public ShortHashMap(int n, float f) {
        if (n < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + n);
        }
        if (f <= 0.0f) {
            throw new IllegalArgumentException("Illegal Load: " + f);
        }
        if (n == 0) {
            n = 1;
        }
        this.loadFactor = f;
        this.table = new Entry[n];
        this.threshold = (int)((float)n * f);
    }

    public Object clone() throws CloneNotSupportedException {
        ShortHashMap shortHashMap = (ShortHashMap)super.clone();
        shortHashMap.table = new Entry[this.table.length];
        int n = this.table.length;
        while (n-- > 0) {
            if (this.table[n] == null) continue;
            shortHashMap.table[n] = (Entry)this.table[n].clone();
        }
        return shortHashMap;
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public boolean contains(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        Entry[] entryArray = this.table;
        int n = entryArray.length;
        while (n-- > 0) {
            Entry entry = entryArray[n];
            while (entry != null) {
                if (entry.value.equals(object)) {
                    return true;
                }
                entry = entry.next;
            }
        }
        return false;
    }

    public boolean containsValue(Object object) {
        return this.contains(object);
    }

    public boolean containsKey(short s) {
        Entry[] entryArray = this.table;
        short s2 = s;
        int n = (s2 & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n];
        while (entry != null) {
            if (entry.hash == s2) {
                return true;
            }
            entry = entry.next;
        }
        return false;
    }

    public Object get(short s) {
        Entry[] entryArray = this.table;
        short s2 = s;
        int n = (s2 & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n];
        while (entry != null) {
            if (entry.hash == s2) {
                return entry.value;
            }
            entry = entry.next;
        }
        return null;
    }

    public short[] keySet() {
        short[] sArray = new short[this.count];
        int n = 0;
        Entry[] entryArray = this.table;
        int n2 = entryArray.length;
        while (n2-- > 0) {
            Entry entry = entryArray[n2];
            while (entry != null) {
                sArray[n++] = entry.key;
                entry = entry.next;
            }
        }
        return sArray;
    }

    public short[] keySetSorted() {
        short[] sArray = this.keySet();
        Arrays.sort(sArray);
        return sArray;
    }

    protected void rehash() {
        int n = this.table.length;
        Entry[] entryArray = this.table;
        int n2 = n * 2 + 1;
        Entry[] entryArray2 = new Entry[n2];
        this.threshold = (int)((float)n2 * this.loadFactor);
        this.table = entryArray2;
        int n3 = n;
        while (n3-- > 0) {
            Entry entry = entryArray[n3];
            while (entry != null) {
                Entry entry2 = entry;
                entry = entry.next;
                int n4 = (entry2.hash & Integer.MAX_VALUE) % n2;
                entry2.next = entryArray2[n4];
                entryArray2[n4] = entry2;
            }
        }
    }

    public Object put(short s, Object object) {
        if (object == null) {
            throw new NullPointerException("Value is null");
        }
        Entry[] entryArray = this.table;
        short s2 = s;
        int n = (s2 & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n];
        while (entry != null) {
            if (entry.hash == s2) {
                Object object2 = entry.value;
                entry.value = object;
                return object2;
            }
            entry = entry.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            entryArray = this.table;
            n = (s2 & Integer.MAX_VALUE) % entryArray.length;
        }
        entryArray[n] = entry = new Entry(s2, s, object, entryArray[n]);
        ++this.count;
        return null;
    }

    public Object remove(short s) {
        Entry[] entryArray = this.table;
        short s2 = s;
        int n = (s2 & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n];
        Entry entry2 = null;
        while (entry != null) {
            if (entry.hash == s2) {
                if (entry2 != null) {
                    entry2.next = entry.next;
                } else {
                    entryArray[n] = entry.next;
                }
                --this.count;
                Object object = entry.value;
                entry.value = null;
                return object;
            }
            entry2 = entry;
            entry = entry.next;
        }
        return null;
    }

    public synchronized void clear() {
        Entry[] entryArray = this.table;
        int n = entryArray.length;
        while (--n >= 0) {
            entryArray[n] = null;
        }
        this.count = 0;
    }

    private static class Entry
    implements Cloneable {
        int hash;
        short key;
        Object value;
        Entry next;

        protected Entry(int n, short s, Object object, Entry entry) {
            this.hash = n;
            this.key = s;
            this.value = object;
            this.next = entry;
        }

        public Object clone() throws CloneNotSupportedException {
            Entry entry = (Entry)super.clone();
            if (this.next != null) {
                entry.next = (Entry)this.next.clone();
            }
            return entry;
        }
    }
}

