/*
 * Decompiled with CFR 0.152.
 */
package org.xj3d.impl.core.loading;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.ietf.uri.ResourceConnection;
import org.web3d.util.ErrorReporter;

abstract class BaseLoadHandler {
    protected boolean terminateCurrent = false;
    protected ResourceConnection currentConnection;

    BaseLoadHandler() {
    }

    public void abortCurrentFile() {
        this.terminateCurrent = true;
        if (this.currentConnection != null) {
            this.currentConnection.close();
        }
    }

    public void shutdown() {
        this.terminateCurrent = true;
        if (this.currentConnection != null) {
            this.currentConnection.close();
        }
    }

    protected boolean makeConnection(ErrorReporter errorReporter) {
        boolean bl = true;
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    BaseLoadHandler.this.currentConnection.connect();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            bl = false;
            Exception exception = privilegedActionException.getException();
            if (exception instanceof FileNotFoundException) {
                String string = "File not found: " + this.currentConnection.getURI();
                errorReporter.warningReport(string, null);
            }
            String string = "IO Error reading external file " + this.currentConnection.getURI();
            errorReporter.warningReport(string, privilegedActionException.getException());
        }
        return bl;
    }
}

