/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.loaders.vterrain;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.j3d.loaders.HeightMapSource;
import org.j3d.loaders.vterrain.BTHeader;

public class BTParser
implements HeightMapSource {
    private byte[] buffer = new byte[10];
    private BufferedInputStream input;
    private BTHeader header;
    private float[][] heights;
    private float[] gridStepData = new float[2];
    private boolean dataReady = false;

    public BTParser() {
    }

    public BTParser(InputStream inputStream) {
        this();
        this.input = inputStream instanceof BufferedInputStream ? (BufferedInputStream)inputStream : new BufferedInputStream(inputStream);
    }

    public void reset(InputStream inputStream) {
        this.input = inputStream instanceof BufferedInputStream ? (BufferedInputStream)inputStream : new BufferedInputStream(inputStream);
        this.dataReady = false;
        this.header = null;
        this.heights = null;
    }

    public void clear() {
        this.dataReady = false;
        this.input = null;
        this.header = null;
        this.heights = null;
    }

    public BTHeader getHeader() {
        return this.header;
    }

    public float[][] getHeights() {
        return this.heights;
    }

    public float[] getGridStep() {
        return this.gridStepData;
    }

    public float[][] parse() throws IOException {
        int n;
        int n2;
        if (this.dataReady) {
            throw new IOException("Data has already been read from this stream");
        }
        this.input.read(this.buffer, 0, 10);
        this.header = new BTHeader();
        int n3 = 0;
        this.header.version = new String(this.buffer, "US-ASCII");
        if (this.header.version.equals("binterr1.0")) {
            n3 = 0;
        } else if (this.header.version.equals("binterr1.1")) {
            n3 = 1;
        } else if (this.header.version.equals("binterr1.2")) {
            n3 = 2;
        }
        this.header.columns = this.readInt();
        int n4 = this.header.rows = this.readInt();
        int n5 = this.header.columns;
        boolean bl = false;
        short s = this.readShort();
        if (n3 > 0) {
            bl = this.readShort() == 1;
        }
        this.header.utmProjection = this.readShort() == 1;
        this.header.utmZone = this.readShort();
        if (n3 > 0) {
            this.header.datum = this.readShort();
            this.header.leftExtent = this.readDouble();
            this.header.rightExtent = this.readDouble();
            this.header.bottomExtent = this.readDouble();
            this.header.topExtent = this.readDouble();
        } else {
            this.header.leftExtent = this.readFloat();
            this.header.rightExtent = this.readFloat();
            this.header.bottomExtent = this.readFloat();
            this.header.topExtent = this.readFloat();
            bl = this.readShort() == 1;
        }
        switch (n3) {
            case 0: {
                this.input.skip(212L);
                break;
            }
            case 1: {
                this.input.skip(196L);
                break;
            }
            case 2: {
                this.header.needsExternalProj = this.readShort() == 1;
                this.input.skip(194L);
            }
        }
        this.heights = new float[n4][n5];
        boolean bl2 = false;
        if (bl) {
            for (n2 = 0; n2 < n5; ++n2) {
                for (n = 0; n < n4; ++n) {
                    this.heights[n][n2] = this.readFloat();
                }
            }
        } else {
            for (n2 = 0; n2 < n5; ++n2) {
                for (n = 0; n < n4; ++n) {
                    this.heights[n][n2] = this.readInt();
                }
            }
        }
        float f = (float)(this.header.rightExtent - this.header.leftExtent);
        float f2 = (float)(this.header.topExtent - this.header.bottomExtent);
        this.gridStepData[0] = f / (float)this.header.rows;
        this.gridStepData[1] = f2 / (float)this.header.columns;
        this.dataReady = true;
        return this.heights;
    }

    private final long readLong() throws IOException {
        this.input.read(this.buffer, 0, 8);
        long l = this.buffer[0] & 0xFF | (this.buffer[1] & 0xFF) << 8 | (this.buffer[2] & 0xFF) << 16 | (this.buffer[3] & 0xFF) << 24;
        long l2 = this.buffer[4] & 0xFF | (this.buffer[5] & 0xFF) << 8 | (this.buffer[6] & 0xFF) << 16 | (this.buffer[7] & 0xFF) << 24;
        return l + (l2 << 32);
    }

    private final int readInt() throws IOException {
        this.input.read(this.buffer, 0, 4);
        return this.buffer[0] & 0xFF | (this.buffer[1] & 0xFF) << 8 | (this.buffer[2] & 0xFF) << 16 | (this.buffer[3] & 0xFF) << 24;
    }

    private final short readShort() throws IOException {
        this.input.read(this.buffer, 0, 2);
        return (short)((this.buffer[0] & 0xFF) + ((this.buffer[1] & 0xFF) << 8));
    }

    private final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    private final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }
}

