/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.particle;

import org.j3d.geom.particle.ParticleFunction;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLParticlePhysicsModelNodeType;
import org.web3d.vrml.renderer.common.nodes.AbstractNode;

public abstract class BasePhysicsModel
extends AbstractNode
implements VRMLParticlePhysicsModelNodeType {
    protected static final int FIELD_ENABLED = 1;
    protected static final int LAST_PHYSICS_INDEX = 1;
    private static final int NUM_FIELDS = 2;
    protected boolean vfEnabled = true;
    protected ParticleFunction particleFunction;

    protected BasePhysicsModel(String string) {
        super(string);
    }

    protected void copy(VRMLParticlePhysicsModelNodeType vRMLParticlePhysicsModelNodeType) {
        try {
            int n = vRMLParticlePhysicsModelNodeType.getFieldIndex("enabled");
            VRMLFieldData vRMLFieldData = vRMLParticlePhysicsModelNodeType.getFieldValue(n);
            this.vfEnabled = vRMLFieldData.booleanValue;
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public ParticleFunction getParticleFunction() {
        return this.particleFunction;
    }

    public void setEnabled(boolean bl) {
        this.vfEnabled = bl;
        if (!this.inSetup) {
            this.particleFunction.setEnabled(bl);
            this.hasChanged[1] = true;
            this.fireFieldChanged(1);
        }
    }

    public boolean getEnabled() {
        return this.vfEnabled;
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        this.particleFunction.setEnabled(this.vfEnabled);
    }

    public int getPrimaryType() {
        return 65;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        VRMLFieldData vRMLFieldData = (VRMLFieldData)this.fieldLocalData.get();
        switch (n) {
            case 1: {
                vRMLFieldData.clear();
                vRMLFieldData.booleanValue = this.vfEnabled;
                vRMLFieldData.dataType = 1;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return vRMLFieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 1: {
                    vRMLNodeType.setValue(n2, this.vfEnabled);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("sendRoute: No field! " + invalidFieldException.getFieldName());
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("sendRoute: Invalid field value: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, boolean bl) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 1: {
                this.setEnabled(bl);
                break;
            }
            default: {
                super.setValue(n, bl);
            }
        }
    }
}

