/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.group;

import java.util.HashMap;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLGroupingNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.renderer.common.nodes.BaseGroupingNode;

public class BaseSwitch
extends BaseGroupingNode {
    protected static final int FIELD_WHICH_CHOICE = 6;
    protected static final int LAST_SWITCH_INDEX = 6;
    protected static final int NUM_FIELDS = 7;
    private static VRMLFieldDeclaration[] fieldDecl;
    private static HashMap fieldMap;
    private static int[] nodeFields;
    protected int vfWhichChoice = -1;

    public BaseSwitch() {
        super("Switch");
        this.hasChanged = new boolean[7];
    }

    public BaseSwitch(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        this.copy((VRMLGroupingNodeType)vRMLNodeType);
        try {
            int n = vRMLNodeType.getFieldIndex("whichChoice");
            VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfWhichChoice = vRMLFieldData.intValue;
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 6) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        VRMLFieldData vRMLFieldData = (VRMLFieldData)this.fieldLocalData.get();
        switch (n) {
            case 6: {
                vRMLFieldData.clear();
                vRMLFieldData.intValue = this.vfWhichChoice;
                vRMLFieldData.dataType = (short)2;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return vRMLFieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 6: {
                    vRMLNodeType.setValue(n2, this.vfWhichChoice);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("sendRoute: No field!" + invalidFieldException.getFieldName());
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("sendRoute: Invalid fieldValue: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, int n2) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 6: {
                this.setWhichChoice(n2);
                break;
            }
            default: {
                super.setValue(n, n2);
            }
        }
    }

    protected void setWhichChoice(int n) throws InvalidFieldValueException {
        if (n < -1) {
            throw new InvalidFieldValueException("whichChoice < -1");
        }
        this.vfWhichChoice = n;
        if (!this.inSetup) {
            this.hasChanged[6] = true;
            this.fireFieldChanged(6);
        }
    }

    static {
        nodeFields = new int[]{1, 0};
        fieldDecl = new VRMLFieldDeclaration[7];
        fieldMap = new HashMap(7);
        BaseSwitch.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseSwitch.fieldDecl[1] = new VRMLFieldDeclaration(3, "MFNode", "children");
        BaseSwitch.fieldDecl[2] = new VRMLFieldDeclaration(1, "MFNode", "addChildren");
        BaseSwitch.fieldDecl[3] = new VRMLFieldDeclaration(1, "MFNode", "removeChildren");
        BaseSwitch.fieldDecl[4] = new VRMLFieldDeclaration(2, "SFVec3f", "bboxCenter");
        BaseSwitch.fieldDecl[5] = new VRMLFieldDeclaration(2, "SFVec3f", "bboxSize");
        BaseSwitch.fieldDecl[6] = new VRMLFieldDeclaration(3, "SFInt32", "whichChoice");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(1);
        fieldMap.put("children", n);
        fieldMap.put("set_children", n);
        fieldMap.put("children_changed", n);
        fieldMap.put("choice", n);
        fieldMap.put("set_choice", n);
        fieldMap.put("choice_changed", n);
        n = new Integer(2);
        fieldMap.put("addChildren", n);
        fieldMap.put("set_addChildren", n);
        n = new Integer(3);
        fieldMap.put("removeChildren", n);
        fieldMap.put("set_removeChildren", n);
        fieldMap.put("bboxCenter", new Integer(4));
        fieldMap.put("bboxSize", new Integer(5));
        n = new Integer(6);
        fieldMap.put("whichChoice", n);
        fieldMap.put("set_whichChoice", n);
        fieldMap.put("whichChoice_changed", n);
    }
}

