/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.loaders;

import java.awt.image.BufferedImage;
import javax.vecmath.Point2d;
import org.j3d.loaders.HeightMapSource;
import org.j3d.terrain.AbstractStaticTerrainData;
import org.j3d.util.interpolator.ColorInterpolator;

public class HeightMapTerrainData
extends AbstractStaticTerrainData {
    private float[][] heightMap;
    private BufferedImage texture = null;
    private ColorInterpolator colorInterp;

    public HeightMapTerrainData(HeightMapSource heightMapSource) {
        this.heightMap = heightMapSource.getHeights();
        float[] fArray = heightMapSource.getGridStep();
        this.gridStepX = fArray[0];
        this.gridStepY = fArray[1];
        this.gridDepth = this.heightMap.length;
        this.gridWidth = this.heightMap[0].length;
    }

    public HeightMapTerrainData(float[][] fArray, boolean bl, Point2d point2d) {
        if (bl) {
            int n = fArray.length;
            int n2 = fArray[0].length;
            this.heightMap = new float[n][n2];
            for (int i = 0; i < n; ++i) {
                System.arraycopy(fArray[i], 0, this.heightMap[i], 0, n2);
            }
            this.gridDepth = n;
            this.gridWidth = n2;
        } else {
            this.heightMap = fArray;
            this.gridDepth = this.heightMap.length;
            this.gridWidth = this.heightMap[0].length;
        }
        this.gridStepX = point2d.x;
        this.gridStepY = point2d.y;
    }

    public float getHeight(float f, float f2) {
        float f3 = f / (float)this.gridStepX;
        float f4 = f2 / (float)this.gridStepY;
        int n = (int)Math.floor(f3);
        int n2 = (int)Math.floor(f4);
        if (n < 0 || n2 < 0 || n + 1 >= this.gridWidth || n2 + 1 >= this.gridDepth) {
            return Float.NaN;
        }
        float f5 = this.heightMap[n][n2];
        float f6 = this.heightMap[n][n2 + 1];
        float f7 = this.heightMap[n + 1][n2];
        float f8 = this.heightMap[n + 1][n2 + 1];
        return (f5 + f6 + f7 + f8) * 0.25f;
    }

    public void getCoordinate(float[] fArray, int n, int n2) {
        fArray[0] = (float)n * (float)this.gridStepX;
        fArray[1] = this.heightMap[n][n2];
        fArray[2] = (float)(-n2) * (float)this.gridStepY;
    }

    public void getCoordinate(float[] fArray, float[] fArray2, float[] fArray3, int n, int n2) {
        float f = this.heightMap[n][n2];
        fArray[0] = (float)n * (float)this.gridStepX;
        fArray[1] = f;
        fArray[2] = (float)(-n2) * (float)this.gridStepY;
        fArray2[0] = (float)n / (float)(this.gridWidth - 1);
        fArray2[1] = (float)n2 / (float)(this.gridDepth - 1);
        float[] fArray4 = this.colorInterp.floatRGBValue(f);
        fArray3[0] = fArray4[0];
        fArray3[1] = fArray4[1];
        fArray3[2] = fArray4[2];
    }

    public void getCoordinateWithTexture(float[] fArray, float[] fArray2, int n, int n2, int n3, int n4) {
        fArray[0] = (float)n * (float)this.gridStepX;
        fArray[1] = this.heightMap[n][n2];
        fArray[2] = (float)(-n2) * (float)this.gridStepY;
        fArray2[0] = (float)n / (float)(this.gridWidth - 1);
        fArray2[1] = (float)n2 / (float)(this.gridDepth - 1);
    }

    public void getCoordinateWithColor(float[] fArray, float[] fArray2, int n, int n2) {
        float f = this.heightMap[n][n2];
        fArray[0] = (float)n * (float)this.gridStepX;
        fArray[1] = f;
        fArray[2] = (float)(-n2) * (float)this.gridStepY;
        float[] fArray3 = this.colorInterp.floatRGBValue(f);
        fArray2[0] = fArray3[0];
        fArray2[1] = fArray3[1];
        fArray2[2] = fArray3[2];
    }

    public BufferedImage getTexture() {
        return this.texture;
    }

    public float getHeightFromGrid(int n, int n2) {
        return this.heightMap[n][n2];
    }

    public void setTexture(BufferedImage bufferedImage) {
        this.texture = bufferedImage;
        this.textureAvailable = this.texture != null;
    }

    public void setColorInterpolator(ColorInterpolator colorInterpolator) {
        this.colorInterp = colorInterpolator;
        this.colorAvailable = this.colorInterp != null;
    }
}

