/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.picking;

import java.util.HashMap;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLPickingSensorNodeType;
import org.web3d.vrml.nodes.VRMLProtoInstance;
import org.web3d.vrml.renderer.common.nodes.picking.BasePickingNode;

public abstract class BasePointPicker
extends BasePickingNode {
    protected static final int FIELD_PICKED_POINT = 9;
    protected static final int LAST_POINT_INDEX = 9;
    protected static final int NUM_FIELDS = 10;
    protected static final String POINT_PROTO_MSG = "Proto does not describe a PointSet object";
    protected static final String POINT_NODE_MSG = "Node does not describe a PointSet object";
    private static final String PICK_GEOM_MSG = "The pickGeometry type is invalid for PointPicker. It must be a PointSet";
    private static VRMLFieldDeclaration[] fieldDecl;
    private static HashMap fieldMap;
    private static int[] nodeFields;
    private float[] vfPickedPoint;
    private int numPickedPoint;

    public BasePointPicker() {
        super("PointPicker", PICK_GEOM_MSG);
        this.hasChanged = new boolean[10];
        this.validGeometryNodeNames.add("PointSet");
    }

    public BasePointPicker(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        this.copy((VRMLPickingSensorNodeType)vRMLNodeType);
    }

    public int getPickingType() {
        return 1;
    }

    public void setPickingGeometry(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        String string = vRMLNodeType.getVRMLNodeName();
        if (!string.equals("PointSet")) {
            if (!(vRMLNodeType instanceof VRMLProtoInstance)) {
                throw new InvalidFieldValueException(POINT_NODE_MSG);
            }
            VRMLNodeType vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
            string = vRMLNodeType2.getVRMLNodeName();
            if (!string.equals("PointSet") && !(vRMLNodeType instanceof VRMLProtoInstance)) {
                throw new InvalidFieldValueException(POINT_NODE_MSG);
            }
        }
        super.setPickingGeometry(vRMLNodeType);
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 9) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        VRMLFieldData vRMLFieldData = (VRMLFieldData)this.fieldLocalData.get();
        switch (n) {
            case 9: {
                vRMLFieldData.clear();
                vRMLFieldData.floatArrayValue = this.vfPickedPoint;
                vRMLFieldData.dataType = (short)11;
                vRMLFieldData.numElements = this.numPickedPoint / 3;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return vRMLFieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 9: {
                    vRMLNodeType.setValue(n2, this.vfPickedPoint, this.numPickedPoint);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("BaseTouchSensor.sendRoute: No field! " + n);
            invalidFieldException.printStackTrace();
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("BaseTouchSensor.sendRoute: Invalid field value: " + invalidFieldValueException.getMessage());
        }
    }

    static {
        nodeFields = new int[]{4, 3, 0};
        fieldDecl = new VRMLFieldDeclaration[10];
        fieldMap = new HashMap(30);
        BasePointPicker.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BasePointPicker.fieldDecl[3] = new VRMLFieldDeclaration(3, "SFNode", "pickingGeometry");
        BasePointPicker.fieldDecl[4] = new VRMLFieldDeclaration(3, "MFNode", "pickTarget");
        BasePointPicker.fieldDecl[1] = new VRMLFieldDeclaration(3, "SFBool", "enabled");
        BasePointPicker.fieldDecl[6] = new VRMLFieldDeclaration(4, "MFNode", "pickedGeometry");
        BasePointPicker.fieldDecl[2] = new VRMLFieldDeclaration(4, "SFBool", "isActive");
        BasePointPicker.fieldDecl[5] = new VRMLFieldDeclaration(2, "SFString", "intersectionType");
        BasePointPicker.fieldDecl[7] = new VRMLFieldDeclaration(2, "SFString", "sortOrder");
        BasePointPicker.fieldDecl[9] = new VRMLFieldDeclaration(4, "MFVec3f", "pickedPoint");
        BasePointPicker.fieldDecl[8] = new VRMLFieldDeclaration(3, "MFString", "objectType");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(3);
        fieldMap.put("pickingGeometry", n);
        fieldMap.put("set_pickingGeometry", n);
        fieldMap.put("pickingGeometry_changed", n);
        n = new Integer(4);
        fieldMap.put("pickTarget", n);
        fieldMap.put("set_pickTarget", n);
        fieldMap.put("pickTarget_changed", n);
        n = new Integer(1);
        fieldMap.put("enabled", n);
        fieldMap.put("set_enabled", n);
        fieldMap.put("enabled_changed", n);
        n = new Integer(8);
        fieldMap.put("objectType", n);
        fieldMap.put("set_objectType", n);
        fieldMap.put("objectType_changed", n);
        fieldMap.put("sortOrder", new Integer(7));
        fieldMap.put("intersectionType", new Integer(5));
        fieldMap.put("isActive", new Integer(2));
        fieldMap.put("pickedGeometry", new Integer(6));
        fieldMap.put("pickedPoint", new Integer(9));
    }
}

