/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.renderer.java3d.overlay;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import javax.media.j3d.Canvas3D;
import org.j3d.renderer.java3d.overlay.OverlayBase;
import org.j3d.renderer.java3d.overlay.UpdateManager;

public class LabelOverlay
extends OverlayBase {
    private static final Font DEFAULT_FONT = new Font("Helvetica", 0, 14);
    private static final Color DEFAULT_COLOR = Color.white;
    public static final int LEFT_ALIGN = 1;
    public static final int RIGHT_ALIGN = 2;
    public static final int CENTER_ALIGN = 3;
    public static final int TOP_ALIGN = 4;
    public static final int BOTTOM_ALIGN = 5;
    private static final String BAD_ALIGN_MSG = "The alignment value provided is unknown: ";
    private String text;
    private String renderedText;
    private int visibleLength;
    private Font font;
    private FontRenderContext renderContext;
    private Color color;
    private int verticalAlignment;
    private int horizontalAlignment;
    private int textX;
    private int textY;

    public LabelOverlay(Canvas3D canvas3D, Dimension dimension) {
        this(canvas3D, dimension, null, DEFAULT_FONT, DEFAULT_COLOR, 1, 4, null);
    }

    public LabelOverlay(Canvas3D canvas3D, Dimension dimension, String string) {
        this(canvas3D, dimension, string, DEFAULT_FONT, DEFAULT_COLOR, 1, 4, null);
    }

    public LabelOverlay(Canvas3D canvas3D, Dimension dimension, String string, Font font, Color color, int n, int n2) {
        this(canvas3D, dimension, string, font, color, n, n2, null);
    }

    public LabelOverlay(Canvas3D canvas3D, Dimension dimension, String string, Font font, Color color, int n, int n2, UpdateManager updateManager) {
        super(canvas3D, dimension, updateManager);
        this.font = font == null ? DEFAULT_FONT : font;
        this.color = color == null ? DEFAULT_COLOR : color;
        this.renderedText = this.text = string;
        this.visibleLength = -1;
        this.renderContext = new FontRenderContext(null, true, true);
        this.setVerticalAlignment(n2);
        this.setHorizontalAlignment(n);
        this.resize();
        this.repositionText();
    }

    public void paint(Graphics2D graphics2D) {
        if (this.renderedText == null) {
            return;
        }
        graphics2D.setColor(this.color);
        graphics2D.setFont(this.font);
        graphics2D.drawString(this.renderedText, this.textX, this.textY);
    }

    public void setInsets(int n, int n2, int n3, int n4) {
        super.setInsets(n, n2, n3, n4);
        this.resize();
        this.repositionText();
    }

    public void setVerticalAlignment(int n) {
        switch (n) {
            case 3: 
            case 4: 
            case 5: {
                this.verticalAlignment = n;
                break;
            }
            default: {
                throw new IllegalArgumentException(BAD_ALIGN_MSG);
            }
        }
        this.repositionText();
    }

    public int getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setHorizontalAlignment(int n) {
        switch (n) {
            case 1: 
            case 2: 
            case 3: {
                this.horizontalAlignment = n;
                break;
            }
            default: {
                throw new IllegalArgumentException(BAD_ALIGN_MSG);
            }
        }
        this.repositionText();
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setColor(Color color) {
        if (!this.color.equals(color)) {
            this.color = color;
            this.repaint();
        }
    }

    public void setFont(Font font) {
        if (!this.font.equals(font)) {
            this.font = font;
            this.resize();
            this.repositionText();
            this.repaint();
        }
    }

    public void setText(String string) {
        this.text = string;
        switch (this.visibleLength) {
            case -1: {
                this.renderedText = this.text;
                break;
            }
            case 0: {
                this.renderedText = null;
                break;
            }
            default: {
                this.renderedText = this.text.substring(0, this.visibleLength);
            }
        }
        this.resize();
        this.repositionText();
        this.repaint();
    }

    public int getVisibleLength() {
        return this.visibleLength;
    }

    public void setVisibleLength(int n) {
        this.visibleLength = n;
        switch (this.visibleLength) {
            case -1: {
                this.renderedText = this.text;
                break;
            }
            case 0: {
                this.renderedText = null;
                break;
            }
            default: {
                this.renderedText = this.text.substring(0, this.visibleLength);
            }
        }
        this.resize();
        this.repositionText();
        this.repaint();
    }

    private void resize() {
        if (this.fixedSize) {
            return;
        }
        LineMetrics lineMetrics = this.font.getLineMetrics(this.renderedText, this.renderContext);
        Rectangle2D rectangle2D = this.font.getStringBounds(this.renderedText, this.renderContext);
        float f = 0.0f;
        float f2 = 0.0f;
        if (rectangle2D instanceof Rectangle) {
            f = ((Rectangle)rectangle2D).width;
            f2 = ((Rectangle)rectangle2D).height;
        } else if (rectangle2D instanceof Rectangle2D.Float) {
            f = ((Rectangle2D.Float)rectangle2D).width;
            f2 = ((Rectangle2D.Float)rectangle2D).height;
        } else if (rectangle2D instanceof Rectangle2D.Double) {
            f = (float)((Rectangle2D.Double)rectangle2D).width;
            f2 = (float)((Rectangle2D.Double)rectangle2D).height;
        }
        this.setSize((int)(f += (float)(this.leftInset + this.rightInset)), (int)(f2 += (float)(this.bottomInset + this.topInset)));
    }

    private void repositionText() {
        if (this.renderedText == null) {
            return;
        }
        LineMetrics lineMetrics = this.font.getLineMetrics(this.renderedText, this.renderContext);
        float f = 0.0f;
        float f2 = 0.0f;
        switch (this.verticalAlignment) {
            case 4: {
                f2 = lineMetrics.getAscent() + lineMetrics.getLeading() + (float)this.topInset;
                break;
            }
            case 5: {
                f2 = (float)this.overlayBounds.height - lineMetrics.getDescent() - lineMetrics.getLeading() - (float)this.bottomInset;
                break;
            }
            case 3: {
                f2 = (float)this.overlayBounds.height * 0.5f + lineMetrics.getHeight() * 0.5f;
            }
        }
        Rectangle2D rectangle2D = this.font.getStringBounds(this.renderedText, this.renderContext);
        float f3 = 0.0f;
        if (rectangle2D instanceof Rectangle) {
            f3 = ((Rectangle)rectangle2D).width;
        } else if (rectangle2D instanceof Rectangle2D.Float) {
            f3 = ((Rectangle2D.Float)rectangle2D).width;
        } else if (rectangle2D instanceof Rectangle2D.Double) {
            f3 = (float)((Rectangle2D.Double)rectangle2D).width;
        }
        switch (this.horizontalAlignment) {
            case 1: {
                f = this.leftInset;
                break;
            }
            case 2: {
                f = (float)this.overlayBounds.width - f3 - (float)this.rightInset;
                break;
            }
            case 3: {
                f = (float)this.overlayBounds.width * 0.5f - f3 * 0.5f;
            }
        }
        this.textX = (int)f;
        this.textY = (int)f2;
    }
}

