/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.texture;

import java.util.HashMap;
import org.web3d.vrml.lang.InvalidFieldAccessException;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldFormatException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLTextureCoordinateNodeType;
import org.web3d.vrml.renderer.common.nodes.BaseGeometricPropertyNode;

public abstract class BaseTextureCoordinateGenerator
extends BaseGeometricPropertyNode
implements VRMLTextureCoordinateNodeType {
    protected static final int FIELD_MODE = 1;
    protected static final int LAST_TEXTURECOORDINATE_INDEX = 1;
    private static final int NUM_FIELDS = 2;
    protected static VRMLFieldDeclaration[] fieldDecl;
    protected static HashMap fieldMap;
    private static int[] nodeFields;
    protected String vfMode;

    protected BaseTextureCoordinateGenerator() {
        super("TextureCoordinateGenerator");
        this.hasChanged = new boolean[2];
    }

    protected BaseTextureCoordinateGenerator(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        try {
            int n = vRMLNodeType.getFieldIndex("mode");
            VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfMode = vRMLFieldData.stringValue;
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public int getNumTextureComponents() {
        return 2;
    }

    public int getNumSets() {
        return 1;
    }

    public int getSize(int n) {
        return 0;
    }

    public void setPoint(int n, float[] fArray, int n2) {
    }

    public void getPoint(int n, float[] fArray) {
    }

    public int isShared(int n) {
        return n;
    }

    public String getTexCoordGenMode(int n) {
        return this.vfMode;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 1) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public int getPrimaryType() {
        return 48;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        VRMLFieldData vRMLFieldData = (VRMLFieldData)this.fieldLocalData.get();
        switch (n) {
            case 1: {
                vRMLFieldData.clear();
                vRMLFieldData.stringValue = this.vfMode;
                vRMLFieldData.dataType = (short)6;
                vRMLFieldData.numElements = 1;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return vRMLFieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 1: {
                    vRMLNodeType.setValue(n2, this.vfMode);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("sendRoute: No field!" + invalidFieldException.getFieldName());
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("sendRoute: Invalid field Value: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, String string) throws InvalidFieldFormatException {
        switch (n) {
            case 1: {
                if (!this.inSetup) {
                    throw new InvalidFieldAccessException("mode is initializeOnly");
                }
                this.vfMode = string;
                break;
            }
            default: {
                super.setValue(n, string);
            }
        }
    }

    static {
        nodeFields = new int[]{0};
        fieldDecl = new VRMLFieldDeclaration[2];
        fieldMap = new HashMap(6);
        BaseTextureCoordinateGenerator.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseTextureCoordinateGenerator.fieldDecl[1] = new VRMLFieldDeclaration(2, "SFString", "mode");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        fieldMap.put("mode", new Integer(1));
    }
}

