/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.geom2d;

import java.util.HashMap;
import org.web3d.vrml.lang.FieldConstants;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.LocalColorsListener;
import org.web3d.vrml.nodes.TexCoordGenModeListener;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLGeometryNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.renderer.common.nodes.AbstractNode;

public abstract class BasePolyline2D
extends AbstractNode
implements VRMLGeometryNodeType {
    protected static final int FIELD_LINE_SEGMENTS = 1;
    private static final int LAST_POLYLINE2D_INDEX = 1;
    private static final int NUM_FIELDS = 2;
    private static VRMLFieldDeclaration[] fieldDecl;
    private static HashMap fieldMap;
    private static int[] nodeFields;
    protected float[] vfLineSegments = FieldConstants.EMPTY_MFVEC2F;
    protected int numLineSegments;

    protected BasePolyline2D() {
        super("Polyline2D");
        this.hasChanged = new boolean[2];
    }

    protected BasePolyline2D(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        try {
            int n = vRMLNodeType.getFieldIndex("lineSegments");
            VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(n);
            if (vRMLFieldData.numElements != 0) {
                this.vfLineSegments = new float[vRMLFieldData.numElements * 2];
                System.arraycopy(vRMLFieldData.floatArrayValue, 0, this.vfLineSegments, 0, vRMLFieldData.numElements * 2);
                this.numLineSegments = vRMLFieldData.numElements;
            }
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public boolean hasLocalColors() {
        return false;
    }

    public boolean hasLocalColorAlpha() {
        return false;
    }

    public void addLocalColorsListener(LocalColorsListener localColorsListener) {
    }

    public void removeLocalColorsListener(LocalColorsListener localColorsListener) {
    }

    public void addTexCoordGenModeChanged(TexCoordGenModeListener texCoordGenModeListener) {
    }

    public void removeTexCoordGenModeChanged(TexCoordGenModeListener texCoordGenModeListener) {
    }

    public String getTexCoordGenMode(int n) {
        return null;
    }

    public int getNumSets() {
        return 0;
    }

    public boolean isSolid() {
        return true;
    }

    public boolean isCCW() {
        return true;
    }

    public boolean isLightingEnabled() {
        return true;
    }

    public int getPrimaryType() {
        return 21;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        VRMLFieldData vRMLFieldData = (VRMLFieldData)this.fieldLocalData.get();
        switch (n) {
            case 1: {
                vRMLFieldData.clear();
                vRMLFieldData.floatArrayValue = this.vfLineSegments;
                vRMLFieldData.dataType = (short)11;
                vRMLFieldData.numElements = this.numLineSegments / 2;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return vRMLFieldData;
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 1) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        switch (n) {
            case 1: {
                vRMLNodeType.setValue(n2, this.vfLineSegments, this.numLineSegments);
                break;
            }
            default: {
                super.sendRoute(d, n, vRMLNodeType, n2);
            }
        }
    }

    public void setValue(int n, float[] fArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 1: {
                this.setLineSegments(fArray, n2);
                break;
            }
            default: {
                super.setValue(n, fArray, n2);
            }
        }
    }

    protected void setLineSegments(float[] fArray, int n) throws InvalidFieldValueException {
        if (this.vfLineSegments.length < n) {
            this.vfLineSegments = new float[n];
        }
        System.arraycopy(fArray, 0, this.vfLineSegments, 0, n);
        this.numLineSegments = n;
        if (!this.inSetup) {
            this.hasChanged[1] = true;
            this.fireFieldChanged(1);
        }
    }

    static {
        nodeFields = new int[]{0};
        fieldDecl = new VRMLFieldDeclaration[2];
        fieldMap = new HashMap(6);
        BasePolyline2D.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BasePolyline2D.fieldDecl[1] = new VRMLFieldDeclaration(3, "MFVec2f", "lineSegments");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(1);
        fieldMap.put("lineSegments", n);
        fieldMap.put("set_lineSegments", n);
        fieldMap.put("lineSegments_changed", n);
    }
}

