// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_SIM_TRN1_8H_TRACE_AARCH64_H_
#define VIXL_SIM_TRN1_8H_TRACE_AARCH64_H_

const uint16_t kExpected_NEON_trn1_8H[] = {
  0x007e, 0x007e, 0x3333, 0x3333, 0x7ffd, 0x7ffd, 0x7fff, 0x7fff,
  0x007e, 0x007f, 0x3333, 0x5555, 0x7ffd, 0x7ffe, 0x7fff, 0x0000,
  0x007e, 0x3333, 0x3333, 0x7ffd, 0x7ffd, 0x7fff, 0x7fff, 0x0001,
  0x007e, 0x5555, 0x3333, 0x7ffe, 0x7ffd, 0x0000, 0x7fff, 0x0002,
  0x007e, 0x7ffd, 0x3333, 0x7fff, 0x7ffd, 0x0001, 0x7fff, 0x0010,
  0x007e, 0x7ffe, 0x3333, 0x0000, 0x7ffd, 0x0002, 0x7fff, 0x007d,
  0x007e, 0x7fff, 0x3333, 0x0001, 0x7ffd, 0x0010, 0x7fff, 0x007e,
  0x007e, 0x0000, 0x3333, 0x0002, 0x7ffd, 0x007d, 0x7fff, 0x007f,
  0x007e, 0x0001, 0x3333, 0x0010, 0x7ffd, 0x007e, 0x7fff, 0x3333,
  0x007e, 0x0002, 0x3333, 0x007d, 0x7ffd, 0x007f, 0x7fff, 0x5555,
  0x007e, 0x0010, 0x3333, 0x007e, 0x7ffd, 0x3333, 0x7fff, 0x7ffd,
  0x007e, 0x007d, 0x3333, 0x007f, 0x7ffd, 0x5555, 0x7fff, 0x7ffe,
  0x007e, 0x007e, 0x3333, 0x3333, 0x7ffd, 0x7ffd, 0x7fff, 0x7fff,
  0x007e, 0x007f, 0x3333, 0x5555, 0x7ffd, 0x7ffe, 0x7fff, 0x8000,
  0x007e, 0x3333, 0x3333, 0x7ffd, 0x7ffd, 0x7fff, 0x7fff, 0x8001,
  0x007e, 0x5555, 0x3333, 0x7ffe, 0x7ffd, 0x8000, 0x7fff, 0xaaaa,
  0x007e, 0x7ffd, 0x3333, 0x7fff, 0x7ffd, 0x8001, 0x7fff, 0xcccc,
  0x007e, 0x7ffe, 0x3333, 0x8000, 0x7ffd, 0xaaaa, 0x7fff, 0xff80,
  0x007e, 0x7fff, 0x3333, 0x8001, 0x7ffd, 0xcccc, 0x7fff, 0xff81,
  0x007e, 0x8000, 0x3333, 0xaaaa, 0x7ffd, 0xff80, 0x7fff, 0xff82,
  0x007e, 0x8001, 0x3333, 0xcccc, 0x7ffd, 0xff81, 0x7fff, 0xff83,
  0x007e, 0xaaaa, 0x3333, 0xff80, 0x7ffd, 0xff82, 0x7fff, 0xfff0,
  0x007e, 0xcccc, 0x3333, 0xff81, 0x7ffd, 0xff83, 0x7fff, 0xfffd,
  0x007e, 0xff80, 0x3333, 0xff82, 0x7ffd, 0xfff0, 0x7fff, 0xfffe,
  0x007f, 0xff81, 0x5555, 0xff83, 0x7ffe, 0xfffd, 0x0000, 0xffff,
  0x007f, 0xff82, 0x5555, 0xfff0, 0x7ffe, 0xfffe, 0x0000, 0x0000,
  0x007f, 0xff83, 0x5555, 0xfffd, 0x7ffe, 0xffff, 0x0000, 0x0001,
  0x007f, 0xfff0, 0x5555, 0xfffe, 0x7ffe, 0x0000, 0x0000, 0x0002,
  0x007f, 0xfffd, 0x5555, 0xffff, 0x7ffe, 0x0001, 0x0000, 0x0010,
  0x007f, 0xfffe, 0x5555, 0x0000, 0x7ffe, 0x0002, 0x0000, 0x007d,
  0x007f, 0xffff, 0x5555, 0x0001, 0x7ffe, 0x0010, 0x0000, 0x007e,
  0x007f, 0x0000, 0x5555, 0x0002, 0x7ffe, 0x007d, 0x0000, 0x007f,
  0x007f, 0x0001, 0x5555, 0x0010, 0x7ffe, 0x007e, 0x0000, 0x3333,
  0x007f, 0x0002, 0x5555, 0x007d, 0x7ffe, 0x007f, 0x0000, 0x5555,
  0x007f, 0x0010, 0x5555, 0x007e, 0x7ffe, 0x3333, 0x0000, 0x7ffd,
  0x007f, 0x007d, 0x5555, 0x007f, 0x7ffe, 0x5555, 0x0000, 0x7ffe,
  0x007f, 0x007e, 0x5555, 0x3333, 0x7ffe, 0x7ffd, 0x0000, 0x7fff,
  0x007f, 0x007f, 0x5555, 0x5555, 0x7ffe, 0x7ffe, 0x0000, 0x8000,
  0x007f, 0x3333, 0x5555, 0x7ffd, 0x7ffe, 0x7fff, 0x0000, 0x8001,
  0x007f, 0x5555, 0x5555, 0x7ffe, 0x7ffe, 0x8000, 0x0000, 0xaaaa,
  0x007f, 0x7ffd, 0x5555, 0x7fff, 0x7ffe, 0x8001, 0x0000, 0xcccc,
  0x007f, 0x7ffe, 0x5555, 0x8000, 0x7ffe, 0xaaaa, 0x0000, 0xff80,
  0x007f, 0x7fff, 0x5555, 0x8001, 0x7ffe, 0xcccc, 0x0000, 0xff81,
  0x007f, 0x8000, 0x5555, 0xaaaa, 0x7ffe, 0xff80, 0x0000, 0xff82,
  0x007f, 0x8001, 0x5555, 0xcccc, 0x7ffe, 0xff81, 0x0000, 0xff83,
  0x007f, 0xaaaa, 0x5555, 0xff80, 0x7ffe, 0xff82, 0x0000, 0xfff0,
  0x007f, 0xcccc, 0x5555, 0xff81, 0x7ffe, 0xff83, 0x0000, 0xfffd,
  0x007f, 0xff80, 0x5555, 0xff82, 0x7ffe, 0xfff0, 0x0000, 0xfffe,
  0x3333, 0xff81, 0x7ffd, 0xff83, 0x7fff, 0xfffd, 0x0001, 0xffff,
  0x3333, 0xff82, 0x7ffd, 0xfff0, 0x7fff, 0xfffe, 0x0001, 0x0000,
  0x3333, 0xff83, 0x7ffd, 0xfffd, 0x7fff, 0xffff, 0x0001, 0x0001,
  0x3333, 0xfff0, 0x7ffd, 0xfffe, 0x7fff, 0x0000, 0x0001, 0x0002,
  0x3333, 0xfffd, 0x7ffd, 0xffff, 0x7fff, 0x0001, 0x0001, 0x0010,
  0x3333, 0xfffe, 0x7ffd, 0x0000, 0x7fff, 0x0002, 0x0001, 0x007d,
  0x3333, 0xffff, 0x7ffd, 0x0001, 0x7fff, 0x0010, 0x0001, 0x007e,
  0x3333, 0x0000, 0x7ffd, 0x0002, 0x7fff, 0x007d, 0x0001, 0x007f,
  0x3333, 0x0001, 0x7ffd, 0x0010, 0x7fff, 0x007e, 0x0001, 0x3333,
  0x3333, 0x0002, 0x7ffd, 0x007d, 0x7fff, 0x007f, 0x0001, 0x5555,
  0x3333, 0x0010, 0x7ffd, 0x007e, 0x7fff, 0x3333, 0x0001, 0x7ffd,
  0x3333, 0x007d, 0x7ffd, 0x007f, 0x7fff, 0x5555, 0x0001, 0x7ffe,
  0x3333, 0x007e, 0x7ffd, 0x3333, 0x7fff, 0x7ffd, 0x0001, 0x7fff,
  0x3333, 0x007f, 0x7ffd, 0x5555, 0x7fff, 0x7ffe, 0x0001, 0x8000,
  0x3333, 0x3333, 0x7ffd, 0x7ffd, 0x7fff, 0x7fff, 0x0001, 0x8001,
  0x3333, 0x5555, 0x7ffd, 0x7ffe, 0x7fff, 0x8000, 0x0001, 0xaaaa,
  0x3333, 0x7ffd, 0x7ffd, 0x7fff, 0x7fff, 0x8001, 0x0001, 0xcccc,
  0x3333, 0x7ffe, 0x7ffd, 0x8000, 0x7fff, 0xaaaa, 0x0001, 0xff80,
  0x3333, 0x7fff, 0x7ffd, 0x8001, 0x7fff, 0xcccc, 0x0001, 0xff81,
  0x3333, 0x8000, 0x7ffd, 0xaaaa, 0x7fff, 0xff80, 0x0001, 0xff82,
  0x3333, 0x8001, 0x7ffd, 0xcccc, 0x7fff, 0xff81, 0x0001, 0xff83,
  0x3333, 0xaaaa, 0x7ffd, 0xff80, 0x7fff, 0xff82, 0x0001, 0xfff0,
  0x3333, 0xcccc, 0x7ffd, 0xff81, 0x7fff, 0xff83, 0x0001, 0xfffd,
  0x3333, 0xff80, 0x7ffd, 0xff82, 0x7fff, 0xfff0, 0x0001, 0xfffe,
  0x5555, 0xff81, 0x7ffe, 0xff83, 0x0000, 0xfffd, 0x0002, 0xffff,
  0x5555, 0xff82, 0x7ffe, 0xfff0, 0x0000, 0xfffe, 0x0002, 0x0000,
  0x5555, 0xff83, 0x7ffe, 0xfffd, 0x0000, 0xffff, 0x0002, 0x0001,
  0x5555, 0xfff0, 0x7ffe, 0xfffe, 0x0000, 0x0000, 0x0002, 0x0002,
  0x5555, 0xfffd, 0x7ffe, 0xffff, 0x0000, 0x0001, 0x0002, 0x0010,
  0x5555, 0xfffe, 0x7ffe, 0x0000, 0x0000, 0x0002, 0x0002, 0x007d,
  0x5555, 0xffff, 0x7ffe, 0x0001, 0x0000, 0x0010, 0x0002, 0x007e,
  0x5555, 0x0000, 0x7ffe, 0x0002, 0x0000, 0x007d, 0x0002, 0x007f,
  0x5555, 0x0001, 0x7ffe, 0x0010, 0x0000, 0x007e, 0x0002, 0x3333,
  0x5555, 0x0002, 0x7ffe, 0x007d, 0x0000, 0x007f, 0x0002, 0x5555,
  0x5555, 0x0010, 0x7ffe, 0x007e, 0x0000, 0x3333, 0x0002, 0x7ffd,
  0x5555, 0x007d, 0x7ffe, 0x007f, 0x0000, 0x5555, 0x0002, 0x7ffe,
  0x5555, 0x007e, 0x7ffe, 0x3333, 0x0000, 0x7ffd, 0x0002, 0x7fff,
  0x5555, 0x007f, 0x7ffe, 0x5555, 0x0000, 0x7ffe, 0x0002, 0x8000,
  0x5555, 0x3333, 0x7ffe, 0x7ffd, 0x0000, 0x7fff, 0x0002, 0x8001,
  0x5555, 0x5555, 0x7ffe, 0x7ffe, 0x0000, 0x8000, 0x0002, 0xaaaa,
  0x5555, 0x7ffd, 0x7ffe, 0x7fff, 0x0000, 0x8001, 0x0002, 0xcccc,
  0x5555, 0x7ffe, 0x7ffe, 0x8000, 0x0000, 0xaaaa, 0x0002, 0xff80,
  0x5555, 0x7fff, 0x7ffe, 0x8001, 0x0000, 0xcccc, 0x0002, 0xff81,
  0x5555, 0x8000, 0x7ffe, 0xaaaa, 0x0000, 0xff80, 0x0002, 0xff82,
  0x5555, 0x8001, 0x7ffe, 0xcccc, 0x0000, 0xff81, 0x0002, 0xff83,
  0x5555, 0xaaaa, 0x7ffe, 0xff80, 0x0000, 0xff82, 0x0002, 0xfff0,
  0x5555, 0xcccc, 0x7ffe, 0xff81, 0x0000, 0xff83, 0x0002, 0xfffd,
  0x5555, 0xff80, 0x7ffe, 0xff82, 0x0000, 0xfff0, 0x0002, 0xfffe,
  0x7ffd, 0xff81, 0x7fff, 0xff83, 0x0001, 0xfffd, 0x0010, 0xffff,
  0x7ffd, 0xff82, 0x7fff, 0xfff0, 0x0001, 0xfffe, 0x0010, 0x0000,
  0x7ffd, 0xff83, 0x7fff, 0xfffd, 0x0001, 0xffff, 0x0010, 0x0001,
  0x7ffd, 0xfff0, 0x7fff, 0xfffe, 0x0001, 0x0000, 0x0010, 0x0002,
  0x7ffd, 0xfffd, 0x7fff, 0xffff, 0x0001, 0x0001, 0x0010, 0x0010,
  0x7ffd, 0xfffe, 0x7fff, 0x0000, 0x0001, 0x0002, 0x0010, 0x007d,
  0x7ffd, 0xffff, 0x7fff, 0x0001, 0x0001, 0x0010, 0x0010, 0x007e,
  0x7ffd, 0x0000, 0x7fff, 0x0002, 0x0001, 0x007d, 0x0010, 0x007f,
  0x7ffd, 0x0001, 0x7fff, 0x0010, 0x0001, 0x007e, 0x0010, 0x3333,
  0x7ffd, 0x0002, 0x7fff, 0x007d, 0x0001, 0x007f, 0x0010, 0x5555,
  0x7ffd, 0x0010, 0x7fff, 0x007e, 0x0001, 0x3333, 0x0010, 0x7ffd,
  0x7ffd, 0x007d, 0x7fff, 0x007f, 0x0001, 0x5555, 0x0010, 0x7ffe,
  0x7ffd, 0x007e, 0x7fff, 0x3333, 0x0001, 0x7ffd, 0x0010, 0x7fff,
  0x7ffd, 0x007f, 0x7fff, 0x5555, 0x0001, 0x7ffe, 0x0010, 0x8000,
  0x7ffd, 0x3333, 0x7fff, 0x7ffd, 0x0001, 0x7fff, 0x0010, 0x8001,
  0x7ffd, 0x5555, 0x7fff, 0x7ffe, 0x0001, 0x8000, 0x0010, 0xaaaa,
  0x7ffd, 0x7ffd, 0x7fff, 0x7fff, 0x0001, 0x8001, 0x0010, 0xcccc,
  0x7ffd, 0x7ffe, 0x7fff, 0x8000, 0x0001, 0xaaaa, 0x0010, 0xff80,
  0x7ffd, 0x7fff, 0x7fff, 0x8001, 0x0001, 0xcccc, 0x0010, 0xff81,
  0x7ffd, 0x8000, 0x7fff, 0xaaaa, 0x0001, 0xff80, 0x0010, 0xff82,
  0x7ffd, 0x8001, 0x7fff, 0xcccc, 0x0001, 0xff81, 0x0010, 0xff83,
  0x7ffd, 0xaaaa, 0x7fff, 0xff80, 0x0001, 0xff82, 0x0010, 0xfff0,
  0x7ffd, 0xcccc, 0x7fff, 0xff81, 0x0001, 0xff83, 0x0010, 0xfffd,
  0x7ffd, 0xff80, 0x7fff, 0xff82, 0x0001, 0xfff0, 0x0010, 0xfffe,
  0x7ffe, 0xff81, 0x0000, 0xff83, 0x0002, 0xfffd, 0x007d, 0xffff,
  0x7ffe, 0xff82, 0x0000, 0xfff0, 0x0002, 0xfffe, 0x007d, 0x0000,
  0x7ffe, 0xff83, 0x0000, 0xfffd, 0x0002, 0xffff, 0x007d, 0x0001,
  0x7ffe, 0xfff0, 0x0000, 0xfffe, 0x0002, 0x0000, 0x007d, 0x0002,
  0x7ffe, 0xfffd, 0x0000, 0xffff, 0x0002, 0x0001, 0x007d, 0x0010,
  0x7ffe, 0xfffe, 0x0000, 0x0000, 0x0002, 0x0002, 0x007d, 0x007d,
  0x7ffe, 0xffff, 0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e,
  0x7ffe, 0x0000, 0x0000, 0x0002, 0x0002, 0x007d, 0x007d, 0x007f,
  0x7ffe, 0x0001, 0x0000, 0x0010, 0x0002, 0x007e, 0x007d, 0x3333,
  0x7ffe, 0x0002, 0x0000, 0x007d, 0x0002, 0x007f, 0x007d, 0x5555,
  0x7ffe, 0x0010, 0x0000, 0x007e, 0x0002, 0x3333, 0x007d, 0x7ffd,
  0x7ffe, 0x007d, 0x0000, 0x007f, 0x0002, 0x5555, 0x007d, 0x7ffe,
  0x7ffe, 0x007e, 0x0000, 0x3333, 0x0002, 0x7ffd, 0x007d, 0x7fff,
  0x7ffe, 0x007f, 0x0000, 0x5555, 0x0002, 0x7ffe, 0x007d, 0x8000,
  0x7ffe, 0x3333, 0x0000, 0x7ffd, 0x0002, 0x7fff, 0x007d, 0x8001,
  0x7ffe, 0x5555, 0x0000, 0x7ffe, 0x0002, 0x8000, 0x007d, 0xaaaa,
  0x7ffe, 0x7ffd, 0x0000, 0x7fff, 0x0002, 0x8001, 0x007d, 0xcccc,
  0x7ffe, 0x7ffe, 0x0000, 0x8000, 0x0002, 0xaaaa, 0x007d, 0xff80,
  0x7ffe, 0x7fff, 0x0000, 0x8001, 0x0002, 0xcccc, 0x007d, 0xff81,
  0x7ffe, 0x8000, 0x0000, 0xaaaa, 0x0002, 0xff80, 0x007d, 0xff82,
  0x7ffe, 0x8001, 0x0000, 0xcccc, 0x0002, 0xff81, 0x007d, 0xff83,
  0x7ffe, 0xaaaa, 0x0000, 0xff80, 0x0002, 0xff82, 0x007d, 0xfff0,
  0x7ffe, 0xcccc, 0x0000, 0xff81, 0x0002, 0xff83, 0x007d, 0xfffd,
  0x7ffe, 0xff80, 0x0000, 0xff82, 0x0002, 0xfff0, 0x007d, 0xfffe,
  0x7fff, 0xff81, 0x0001, 0xff83, 0x0010, 0xfffd, 0x007e, 0xffff,
  0x7fff, 0xff82, 0x0001, 0xfff0, 0x0010, 0xfffe, 0x007e, 0x0000,
  0x7fff, 0xff83, 0x0001, 0xfffd, 0x0010, 0xffff, 0x007e, 0x0001,
  0x7fff, 0xfff0, 0x0001, 0xfffe, 0x0010, 0x0000, 0x007e, 0x0002,
  0x7fff, 0xfffd, 0x0001, 0xffff, 0x0010, 0x0001, 0x007e, 0x0010,
  0x7fff, 0xfffe, 0x0001, 0x0000, 0x0010, 0x0002, 0x007e, 0x007d,
  0x7fff, 0xffff, 0x0001, 0x0001, 0x0010, 0x0010, 0x007e, 0x007e,
  0x7fff, 0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f,
  0x7fff, 0x0001, 0x0001, 0x0010, 0x0010, 0x007e, 0x007e, 0x3333,
  0x7fff, 0x0002, 0x0001, 0x007d, 0x0010, 0x007f, 0x007e, 0x5555,
  0x7fff, 0x0010, 0x0001, 0x007e, 0x0010, 0x3333, 0x007e, 0x7ffd,
  0x7fff, 0x007d, 0x0001, 0x007f, 0x0010, 0x5555, 0x007e, 0x7ffe,
  0x7fff, 0x007e, 0x0001, 0x3333, 0x0010, 0x7ffd, 0x007e, 0x7fff,
  0x7fff, 0x007f, 0x0001, 0x5555, 0x0010, 0x7ffe, 0x007e, 0x8000,
  0x7fff, 0x3333, 0x0001, 0x7ffd, 0x0010, 0x7fff, 0x007e, 0x8001,
  0x7fff, 0x5555, 0x0001, 0x7ffe, 0x0010, 0x8000, 0x007e, 0xaaaa,
  0x7fff, 0x7ffd, 0x0001, 0x7fff, 0x0010, 0x8001, 0x007e, 0xcccc,
  0x7fff, 0x7ffe, 0x0001, 0x8000, 0x0010, 0xaaaa, 0x007e, 0xff80,
  0x7fff, 0x7fff, 0x0001, 0x8001, 0x0010, 0xcccc, 0x007e, 0xff81,
  0x7fff, 0x8000, 0x0001, 0xaaaa, 0x0010, 0xff80, 0x007e, 0xff82,
  0x7fff, 0x8001, 0x0001, 0xcccc, 0x0010, 0xff81, 0x007e, 0xff83,
  0x7fff, 0xaaaa, 0x0001, 0xff80, 0x0010, 0xff82, 0x007e, 0xfff0,
  0x7fff, 0xcccc, 0x0001, 0xff81, 0x0010, 0xff83, 0x007e, 0xfffd,
  0x7fff, 0xff80, 0x0001, 0xff82, 0x0010, 0xfff0, 0x007e, 0xfffe,
  0x0000, 0xff81, 0x0002, 0xff83, 0x007d, 0xfffd, 0x007f, 0xffff,
  0x0000, 0xff82, 0x0002, 0xfff0, 0x007d, 0xfffe, 0x007f, 0x0000,
  0x0000, 0xff83, 0x0002, 0xfffd, 0x007d, 0xffff, 0x007f, 0x0001,
  0x0000, 0xfff0, 0x0002, 0xfffe, 0x007d, 0x0000, 0x007f, 0x0002,
  0x0000, 0xfffd, 0x0002, 0xffff, 0x007d, 0x0001, 0x007f, 0x0010,
  0x0000, 0xfffe, 0x0002, 0x0000, 0x007d, 0x0002, 0x007f, 0x007d,
  0x0000, 0xffff, 0x0002, 0x0001, 0x007d, 0x0010, 0x007f, 0x007e,
  0x0000, 0x0000, 0x0002, 0x0002, 0x007d, 0x007d, 0x007f, 0x007f,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0000, 0x0002, 0x0002, 0x007d, 0x007d, 0x007f, 0x007f, 0x5555,
  0x0000, 0x0010, 0x0002, 0x007e, 0x007d, 0x3333, 0x007f, 0x7ffd,
  0x0000, 0x007d, 0x0002, 0x007f, 0x007d, 0x5555, 0x007f, 0x7ffe,
  0x0000, 0x007e, 0x0002, 0x3333, 0x007d, 0x7ffd, 0x007f, 0x7fff,
  0x0000, 0x007f, 0x0002, 0x5555, 0x007d, 0x7ffe, 0x007f, 0x8000,
  0x0000, 0x3333, 0x0002, 0x7ffd, 0x007d, 0x7fff, 0x007f, 0x8001,
  0x0000, 0x5555, 0x0002, 0x7ffe, 0x007d, 0x8000, 0x007f, 0xaaaa,
  0x0000, 0x7ffd, 0x0002, 0x7fff, 0x007d, 0x8001, 0x007f, 0xcccc,
  0x0000, 0x7ffe, 0x0002, 0x8000, 0x007d, 0xaaaa, 0x007f, 0xff80,
  0x0000, 0x7fff, 0x0002, 0x8001, 0x007d, 0xcccc, 0x007f, 0xff81,
  0x0000, 0x8000, 0x0002, 0xaaaa, 0x007d, 0xff80, 0x007f, 0xff82,
  0x0000, 0x8001, 0x0002, 0xcccc, 0x007d, 0xff81, 0x007f, 0xff83,
  0x0000, 0xaaaa, 0x0002, 0xff80, 0x007d, 0xff82, 0x007f, 0xfff0,
  0x0000, 0xcccc, 0x0002, 0xff81, 0x007d, 0xff83, 0x007f, 0xfffd,
  0x0000, 0xff80, 0x0002, 0xff82, 0x007d, 0xfff0, 0x007f, 0xfffe,
  0x0001, 0xff81, 0x0010, 0xff83, 0x007e, 0xfffd, 0x3333, 0xffff,
  0x0001, 0xff82, 0x0010, 0xfff0, 0x007e, 0xfffe, 0x3333, 0x0000,
  0x0001, 0xff83, 0x0010, 0xfffd, 0x007e, 0xffff, 0x3333, 0x0001,
  0x0001, 0xfff0, 0x0010, 0xfffe, 0x007e, 0x0000, 0x3333, 0x0002,
  0x0001, 0xfffd, 0x0010, 0xffff, 0x007e, 0x0001, 0x3333, 0x0010,
  0x0001, 0xfffe, 0x0010, 0x0000, 0x007e, 0x0002, 0x3333, 0x007d,
  0x0001, 0xffff, 0x0010, 0x0001, 0x007e, 0x0010, 0x3333, 0x007e,
  0x0001, 0x0000, 0x0010, 0x0002, 0x007e, 0x007d, 0x3333, 0x007f,
  0x0001, 0x0001, 0x0010, 0x0010, 0x007e, 0x007e, 0x3333, 0x3333,
  0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333, 0x5555,
  0x0001, 0x0010, 0x0010, 0x007e, 0x007e, 0x3333, 0x3333, 0x7ffd,
  0x0001, 0x007d, 0x0010, 0x007f, 0x007e, 0x5555, 0x3333, 0x7ffe,
  0x0001, 0x007e, 0x0010, 0x3333, 0x007e, 0x7ffd, 0x3333, 0x7fff,
  0x0001, 0x007f, 0x0010, 0x5555, 0x007e, 0x7ffe, 0x3333, 0x8000,
  0x0001, 0x3333, 0x0010, 0x7ffd, 0x007e, 0x7fff, 0x3333, 0x8001,
  0x0001, 0x5555, 0x0010, 0x7ffe, 0x007e, 0x8000, 0x3333, 0xaaaa,
  0x0001, 0x7ffd, 0x0010, 0x7fff, 0x007e, 0x8001, 0x3333, 0xcccc,
  0x0001, 0x7ffe, 0x0010, 0x8000, 0x007e, 0xaaaa, 0x3333, 0xff80,
  0x0001, 0x7fff, 0x0010, 0x8001, 0x007e, 0xcccc, 0x3333, 0xff81,
  0x0001, 0x8000, 0x0010, 0xaaaa, 0x007e, 0xff80, 0x3333, 0xff82,
  0x0001, 0x8001, 0x0010, 0xcccc, 0x007e, 0xff81, 0x3333, 0xff83,
  0x0001, 0xaaaa, 0x0010, 0xff80, 0x007e, 0xff82, 0x3333, 0xfff0,
  0x0001, 0xcccc, 0x0010, 0xff81, 0x007e, 0xff83, 0x3333, 0xfffd,
  0x0001, 0xff80, 0x0010, 0xff82, 0x007e, 0xfff0, 0x3333, 0xfffe,
  0x0002, 0xff81, 0x007d, 0xff83, 0x007f, 0xfffd, 0x5555, 0xffff,
  0x0002, 0xff82, 0x007d, 0xfff0, 0x007f, 0xfffe, 0x5555, 0x0000,
  0x0002, 0xff83, 0x007d, 0xfffd, 0x007f, 0xffff, 0x5555, 0x0001,
  0x0002, 0xfff0, 0x007d, 0xfffe, 0x007f, 0x0000, 0x5555, 0x0002,
  0x0002, 0xfffd, 0x007d, 0xffff, 0x007f, 0x0001, 0x5555, 0x0010,
  0x0002, 0xfffe, 0x007d, 0x0000, 0x007f, 0x0002, 0x5555, 0x007d,
  0x0002, 0xffff, 0x007d, 0x0001, 0x007f, 0x0010, 0x5555, 0x007e,
  0x0002, 0x0000, 0x007d, 0x0002, 0x007f, 0x007d, 0x5555, 0x007f,
  0x0002, 0x0001, 0x007d, 0x0010, 0x007f, 0x007e, 0x5555, 0x3333,
  0x0002, 0x0002, 0x007d, 0x007d, 0x007f, 0x007f, 0x5555, 0x5555,
  0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333, 0x5555, 0x7ffd,
  0x0002, 0x007d, 0x007d, 0x007f, 0x007f, 0x5555, 0x5555, 0x7ffe,
  0x0002, 0x007e, 0x007d, 0x3333, 0x007f, 0x7ffd, 0x5555, 0x7fff,
  0x0002, 0x007f, 0x007d, 0x5555, 0x007f, 0x7ffe, 0x5555, 0x8000,
  0x0002, 0x3333, 0x007d, 0x7ffd, 0x007f, 0x7fff, 0x5555, 0x8001,
  0x0002, 0x5555, 0x007d, 0x7ffe, 0x007f, 0x8000, 0x5555, 0xaaaa,
  0x0002, 0x7ffd, 0x007d, 0x7fff, 0x007f, 0x8001, 0x5555, 0xcccc,
  0x0002, 0x7ffe, 0x007d, 0x8000, 0x007f, 0xaaaa, 0x5555, 0xff80,
  0x0002, 0x7fff, 0x007d, 0x8001, 0x007f, 0xcccc, 0x5555, 0xff81,
  0x0002, 0x8000, 0x007d, 0xaaaa, 0x007f, 0xff80, 0x5555, 0xff82,
  0x0002, 0x8001, 0x007d, 0xcccc, 0x007f, 0xff81, 0x5555, 0xff83,
  0x0002, 0xaaaa, 0x007d, 0xff80, 0x007f, 0xff82, 0x5555, 0xfff0,
  0x0002, 0xcccc, 0x007d, 0xff81, 0x007f, 0xff83, 0x5555, 0xfffd,
  0x0002, 0xff80, 0x007d, 0xff82, 0x007f, 0xfff0, 0x5555, 0xfffe,
  0x0010, 0xff81, 0x007e, 0xff83, 0x3333, 0xfffd, 0x7ffd, 0xffff,
  0x0010, 0xff82, 0x007e, 0xfff0, 0x3333, 0xfffe, 0x7ffd, 0x0000,
  0x0010, 0xff83, 0x007e, 0xfffd, 0x3333, 0xffff, 0x7ffd, 0x0001,
  0x0010, 0xfff0, 0x007e, 0xfffe, 0x3333, 0x0000, 0x7ffd, 0x0002,
  0x0010, 0xfffd, 0x007e, 0xffff, 0x3333, 0x0001, 0x7ffd, 0x0010,
  0x0010, 0xfffe, 0x007e, 0x0000, 0x3333, 0x0002, 0x7ffd, 0x007d,
  0x0010, 0xffff, 0x007e, 0x0001, 0x3333, 0x0010, 0x7ffd, 0x007e,
  0x0010, 0x0000, 0x007e, 0x0002, 0x3333, 0x007d, 0x7ffd, 0x007f,
  0x0010, 0x0001, 0x007e, 0x0010, 0x3333, 0x007e, 0x7ffd, 0x3333,
  0x0010, 0x0002, 0x007e, 0x007d, 0x3333, 0x007f, 0x7ffd, 0x5555,
  0x0010, 0x0010, 0x007e, 0x007e, 0x3333, 0x3333, 0x7ffd, 0x7ffd,
  0x0010, 0x007d, 0x007e, 0x007f, 0x3333, 0x5555, 0x7ffd, 0x7ffe,
  0x0010, 0x007e, 0x007e, 0x3333, 0x3333, 0x7ffd, 0x7ffd, 0x7fff,
  0x0010, 0x007f, 0x007e, 0x5555, 0x3333, 0x7ffe, 0x7ffd, 0x8000,
  0x0010, 0x3333, 0x007e, 0x7ffd, 0x3333, 0x7fff, 0x7ffd, 0x8001,
  0x0010, 0x5555, 0x007e, 0x7ffe, 0x3333, 0x8000, 0x7ffd, 0xaaaa,
  0x0010, 0x7ffd, 0x007e, 0x7fff, 0x3333, 0x8001, 0x7ffd, 0xcccc,
  0x0010, 0x7ffe, 0x007e, 0x8000, 0x3333, 0xaaaa, 0x7ffd, 0xff80,
  0x0010, 0x7fff, 0x007e, 0x8001, 0x3333, 0xcccc, 0x7ffd, 0xff81,
  0x0010, 0x8000, 0x007e, 0xaaaa, 0x3333, 0xff80, 0x7ffd, 0xff82,
  0x0010, 0x8001, 0x007e, 0xcccc, 0x3333, 0xff81, 0x7ffd, 0xff83,
  0x0010, 0xaaaa, 0x007e, 0xff80, 0x3333, 0xff82, 0x7ffd, 0xfff0,
  0x0010, 0xcccc, 0x007e, 0xff81, 0x3333, 0xff83, 0x7ffd, 0xfffd,
  0x0010, 0xff80, 0x007e, 0xff82, 0x3333, 0xfff0, 0x7ffd, 0xfffe,
  0x007d, 0xff81, 0x007f, 0xff83, 0x5555, 0xfffd, 0x7ffe, 0xffff,
  0x007d, 0xff82, 0x007f, 0xfff0, 0x5555, 0xfffe, 0x7ffe, 0x0000,
  0x007d, 0xff83, 0x007f, 0xfffd, 0x5555, 0xffff, 0x7ffe, 0x0001,
  0x007d, 0xfff0, 0x007f, 0xfffe, 0x5555, 0x0000, 0x7ffe, 0x0002,
  0x007d, 0xfffd, 0x007f, 0xffff, 0x5555, 0x0001, 0x7ffe, 0x0010,
  0x007d, 0xfffe, 0x007f, 0x0000, 0x5555, 0x0002, 0x7ffe, 0x007d,
  0x007d, 0xffff, 0x007f, 0x0001, 0x5555, 0x0010, 0x7ffe, 0x007e,
  0x007d, 0x0000, 0x007f, 0x0002, 0x5555, 0x007d, 0x7ffe, 0x007f,
  0x007d, 0x0001, 0x007f, 0x0010, 0x5555, 0x007e, 0x7ffe, 0x3333,
  0x007d, 0x0002, 0x007f, 0x007d, 0x5555, 0x007f, 0x7ffe, 0x5555,
  0x007d, 0x0010, 0x007f, 0x007e, 0x5555, 0x3333, 0x7ffe, 0x7ffd,
  0x007d, 0x007d, 0x007f, 0x007f, 0x5555, 0x5555, 0x7ffe, 0x7ffe,
  0x007d, 0x007e, 0x007f, 0x3333, 0x5555, 0x7ffd, 0x7ffe, 0x7fff,
  0x007d, 0x007f, 0x007f, 0x5555, 0x5555, 0x7ffe, 0x7ffe, 0x8000,
  0x007d, 0x3333, 0x007f, 0x7ffd, 0x5555, 0x7fff, 0x7ffe, 0x8001,
  0x007d, 0x5555, 0x007f, 0x7ffe, 0x5555, 0x8000, 0x7ffe, 0xaaaa,
  0x007d, 0x7ffd, 0x007f, 0x7fff, 0x5555, 0x8001, 0x7ffe, 0xcccc,
  0x007d, 0x7ffe, 0x007f, 0x8000, 0x5555, 0xaaaa, 0x7ffe, 0xff80,
  0x007d, 0x7fff, 0x007f, 0x8001, 0x5555, 0xcccc, 0x7ffe, 0xff81,
  0x007d, 0x8000, 0x007f, 0xaaaa, 0x5555, 0xff80, 0x7ffe, 0xff82,
  0x007d, 0x8001, 0x007f, 0xcccc, 0x5555, 0xff81, 0x7ffe, 0xff83,
  0x007d, 0xaaaa, 0x007f, 0xff80, 0x5555, 0xff82, 0x7ffe, 0xfff0,
  0x007d, 0xcccc, 0x007f, 0xff81, 0x5555, 0xff83, 0x7ffe, 0xfffd,
  0x007d, 0xff80, 0x007f, 0xff82, 0x5555, 0xfff0, 0x7ffe, 0xfffe,
  0x007e, 0xff81, 0x3333, 0xff83, 0x7ffd, 0xfffd, 0x7fff, 0xffff,
  0x007e, 0xff82, 0x3333, 0xfff0, 0x7ffd, 0xfffe, 0x7fff, 0x0000,
  0x007e, 0xff83, 0x3333, 0xfffd, 0x7ffd, 0xffff, 0x7fff, 0x0001,
  0x007e, 0xfff0, 0x3333, 0xfffe, 0x7ffd, 0x0000, 0x7fff, 0x0002,
  0x007e, 0xfffd, 0x3333, 0xffff, 0x7ffd, 0x0001, 0x7fff, 0x0010,
  0x007e, 0xfffe, 0x3333, 0x0000, 0x7ffd, 0x0002, 0x7fff, 0x007d,
  0x007e, 0xffff, 0x3333, 0x0001, 0x7ffd, 0x0010, 0x7fff, 0x007e,
  0x007e, 0x0000, 0x3333, 0x0002, 0x7ffd, 0x007d, 0x7fff, 0x007f,
  0x007e, 0x0001, 0x3333, 0x0010, 0x7ffd, 0x007e, 0x7fff, 0x3333,
  0x007e, 0x0002, 0x3333, 0x007d, 0x7ffd, 0x007f, 0x7fff, 0x5555,
  0x007e, 0x0010, 0x3333, 0x007e, 0x7ffd, 0x3333, 0x7fff, 0x7ffd,
  0x007e, 0x007d, 0x3333, 0x007f, 0x7ffd, 0x5555, 0x7fff, 0x7ffe,
  0x007e, 0x007e, 0x3333, 0x3333, 0x7ffd, 0x7ffd, 0x7fff, 0x7fff,
  0x007e, 0x007f, 0x3333, 0x5555, 0x7ffd, 0x7ffe, 0x7fff, 0x8000,
  0x007e, 0x3333, 0x3333, 0x7ffd, 0x7ffd, 0x7fff, 0x7fff, 0x8001,
  0x007e, 0x5555, 0x3333, 0x7ffe, 0x7ffd, 0x8000, 0x7fff, 0xaaaa,
  0x007e, 0x7ffd, 0x3333, 0x7fff, 0x7ffd, 0x8001, 0x7fff, 0xcccc,
  0x007e, 0x7ffe, 0x3333, 0x8000, 0x7ffd, 0xaaaa, 0x7fff, 0xff80,
  0x007e, 0x7fff, 0x3333, 0x8001, 0x7ffd, 0xcccc, 0x7fff, 0xff81,
  0x007e, 0x8000, 0x3333, 0xaaaa, 0x7ffd, 0xff80, 0x7fff, 0xff82,
  0x007e, 0x8001, 0x3333, 0xcccc, 0x7ffd, 0xff81, 0x7fff, 0xff83,
  0x007e, 0xaaaa, 0x3333, 0xff80, 0x7ffd, 0xff82, 0x7fff, 0xfff0,
  0x007e, 0xcccc, 0x3333, 0xff81, 0x7ffd, 0xff83, 0x7fff, 0xfffd,
  0x007e, 0xff80, 0x3333, 0xff82, 0x7ffd, 0xfff0, 0x7fff, 0xfffe,
  0x007f, 0xff81, 0x5555, 0xff83, 0x7ffe, 0xfffd, 0x8000, 0xffff,
  0x007f, 0xff82, 0x5555, 0xfff0, 0x7ffe, 0xfffe, 0x8000, 0x0000,
  0x007f, 0xff83, 0x5555, 0xfffd, 0x7ffe, 0xffff, 0x8000, 0x0001,
  0x007f, 0xfff0, 0x5555, 0xfffe, 0x7ffe, 0x0000, 0x8000, 0x0002,
  0x007f, 0xfffd, 0x5555, 0xffff, 0x7ffe, 0x0001, 0x8000, 0x0010,
  0x007f, 0xfffe, 0x5555, 0x0000, 0x7ffe, 0x0002, 0x8000, 0x007d,
  0x007f, 0xffff, 0x5555, 0x0001, 0x7ffe, 0x0010, 0x8000, 0x007e,
  0x007f, 0x0000, 0x5555, 0x0002, 0x7ffe, 0x007d, 0x8000, 0x007f,
  0x007f, 0x0001, 0x5555, 0x0010, 0x7ffe, 0x007e, 0x8000, 0x3333,
  0x007f, 0x0002, 0x5555, 0x007d, 0x7ffe, 0x007f, 0x8000, 0x5555,
  0x007f, 0x0010, 0x5555, 0x007e, 0x7ffe, 0x3333, 0x8000, 0x7ffd,
  0x007f, 0x007d, 0x5555, 0x007f, 0x7ffe, 0x5555, 0x8000, 0x7ffe,
  0x007f, 0x007e, 0x5555, 0x3333, 0x7ffe, 0x7ffd, 0x8000, 0x7fff,
  0x007f, 0x007f, 0x5555, 0x5555, 0x7ffe, 0x7ffe, 0x8000, 0x8000,
  0x007f, 0x3333, 0x5555, 0x7ffd, 0x7ffe, 0x7fff, 0x8000, 0x8001,
  0x007f, 0x5555, 0x5555, 0x7ffe, 0x7ffe, 0x8000, 0x8000, 0xaaaa,
  0x007f, 0x7ffd, 0x5555, 0x7fff, 0x7ffe, 0x8001, 0x8000, 0xcccc,
  0x007f, 0x7ffe, 0x5555, 0x8000, 0x7ffe, 0xaaaa, 0x8000, 0xff80,
  0x007f, 0x7fff, 0x5555, 0x8001, 0x7ffe, 0xcccc, 0x8000, 0xff81,
  0x007f, 0x8000, 0x5555, 0xaaaa, 0x7ffe, 0xff80, 0x8000, 0xff82,
  0x007f, 0x8001, 0x5555, 0xcccc, 0x7ffe, 0xff81, 0x8000, 0xff83,
  0x007f, 0xaaaa, 0x5555, 0xff80, 0x7ffe, 0xff82, 0x8000, 0xfff0,
  0x007f, 0xcccc, 0x5555, 0xff81, 0x7ffe, 0xff83, 0x8000, 0xfffd,
  0x007f, 0xff80, 0x5555, 0xff82, 0x7ffe, 0xfff0, 0x8000, 0xfffe,
  0x3333, 0xff81, 0x7ffd, 0xff83, 0x7fff, 0xfffd, 0x8001, 0xffff,
  0x3333, 0xff82, 0x7ffd, 0xfff0, 0x7fff, 0xfffe, 0x8001, 0x0000,
  0x3333, 0xff83, 0x7ffd, 0xfffd, 0x7fff, 0xffff, 0x8001, 0x0001,
  0x3333, 0xfff0, 0x7ffd, 0xfffe, 0x7fff, 0x0000, 0x8001, 0x0002,
  0x3333, 0xfffd, 0x7ffd, 0xffff, 0x7fff, 0x0001, 0x8001, 0x0010,
  0x3333, 0xfffe, 0x7ffd, 0x0000, 0x7fff, 0x0002, 0x8001, 0x007d,
  0x3333, 0xffff, 0x7ffd, 0x0001, 0x7fff, 0x0010, 0x8001, 0x007e,
  0x3333, 0x0000, 0x7ffd, 0x0002, 0x7fff, 0x007d, 0x8001, 0x007f,
  0x3333, 0x0001, 0x7ffd, 0x0010, 0x7fff, 0x007e, 0x8001, 0x3333,
  0x3333, 0x0002, 0x7ffd, 0x007d, 0x7fff, 0x007f, 0x8001, 0x5555,
  0x3333, 0x0010, 0x7ffd, 0x007e, 0x7fff, 0x3333, 0x8001, 0x7ffd,
  0x3333, 0x007d, 0x7ffd, 0x007f, 0x7fff, 0x5555, 0x8001, 0x7ffe,
  0x3333, 0x007e, 0x7ffd, 0x3333, 0x7fff, 0x7ffd, 0x8001, 0x7fff,
  0x3333, 0x007f, 0x7ffd, 0x5555, 0x7fff, 0x7ffe, 0x8001, 0x8000,
  0x3333, 0x3333, 0x7ffd, 0x7ffd, 0x7fff, 0x7fff, 0x8001, 0x8001,
  0x3333, 0x5555, 0x7ffd, 0x7ffe, 0x7fff, 0x8000, 0x8001, 0xaaaa,
  0x3333, 0x7ffd, 0x7ffd, 0x7fff, 0x7fff, 0x8001, 0x8001, 0xcccc,
  0x3333, 0x7ffe, 0x7ffd, 0x8000, 0x7fff, 0xaaaa, 0x8001, 0xff80,
  0x3333, 0x7fff, 0x7ffd, 0x8001, 0x7fff, 0xcccc, 0x8001, 0xff81,
  0x3333, 0x8000, 0x7ffd, 0xaaaa, 0x7fff, 0xff80, 0x8001, 0xff82,
  0x3333, 0x8001, 0x7ffd, 0xcccc, 0x7fff, 0xff81, 0x8001, 0xff83,
  0x3333, 0xaaaa, 0x7ffd, 0xff80, 0x7fff, 0xff82, 0x8001, 0xfff0,
  0x3333, 0xcccc, 0x7ffd, 0xff81, 0x7fff, 0xff83, 0x8001, 0xfffd,
  0x3333, 0xff80, 0x7ffd, 0xff82, 0x7fff, 0xfff0, 0x8001, 0xfffe,
  0x5555, 0xff81, 0x7ffe, 0xff83, 0x8000, 0xfffd, 0xaaaa, 0xffff,
  0x5555, 0xff82, 0x7ffe, 0xfff0, 0x8000, 0xfffe, 0xaaaa, 0x0000,
  0x5555, 0xff83, 0x7ffe, 0xfffd, 0x8000, 0xffff, 0xaaaa, 0x0001,
  0x5555, 0xfff0, 0x7ffe, 0xfffe, 0x8000, 0x0000, 0xaaaa, 0x0002,
  0x5555, 0xfffd, 0x7ffe, 0xffff, 0x8000, 0x0001, 0xaaaa, 0x0010,
  0x5555, 0xfffe, 0x7ffe, 0x0000, 0x8000, 0x0002, 0xaaaa, 0x007d,
  0x5555, 0xffff, 0x7ffe, 0x0001, 0x8000, 0x0010, 0xaaaa, 0x007e,
  0x5555, 0x0000, 0x7ffe, 0x0002, 0x8000, 0x007d, 0xaaaa, 0x007f,
  0x5555, 0x0001, 0x7ffe, 0x0010, 0x8000, 0x007e, 0xaaaa, 0x3333,
  0x5555, 0x0002, 0x7ffe, 0x007d, 0x8000, 0x007f, 0xaaaa, 0x5555,
  0x5555, 0x0010, 0x7ffe, 0x007e, 0x8000, 0x3333, 0xaaaa, 0x7ffd,
  0x5555, 0x007d, 0x7ffe, 0x007f, 0x8000, 0x5555, 0xaaaa, 0x7ffe,
  0x5555, 0x007e, 0x7ffe, 0x3333, 0x8000, 0x7ffd, 0xaaaa, 0x7fff,
  0x5555, 0x007f, 0x7ffe, 0x5555, 0x8000, 0x7ffe, 0xaaaa, 0x8000,
  0x5555, 0x3333, 0x7ffe, 0x7ffd, 0x8000, 0x7fff, 0xaaaa, 0x8001,
  0x5555, 0x5555, 0x7ffe, 0x7ffe, 0x8000, 0x8000, 0xaaaa, 0xaaaa,
  0x5555, 0x7ffd, 0x7ffe, 0x7fff, 0x8000, 0x8001, 0xaaaa, 0xcccc,
  0x5555, 0x7ffe, 0x7ffe, 0x8000, 0x8000, 0xaaaa, 0xaaaa, 0xff80,
  0x5555, 0x7fff, 0x7ffe, 0x8001, 0x8000, 0xcccc, 0xaaaa, 0xff81,
  0x5555, 0x8000, 0x7ffe, 0xaaaa, 0x8000, 0xff80, 0xaaaa, 0xff82,
  0x5555, 0x8001, 0x7ffe, 0xcccc, 0x8000, 0xff81, 0xaaaa, 0xff83,
  0x5555, 0xaaaa, 0x7ffe, 0xff80, 0x8000, 0xff82, 0xaaaa, 0xfff0,
  0x5555, 0xcccc, 0x7ffe, 0xff81, 0x8000, 0xff83, 0xaaaa, 0xfffd,
  0x5555, 0xff80, 0x7ffe, 0xff82, 0x8000, 0xfff0, 0xaaaa, 0xfffe,
  0x7ffd, 0xff81, 0x7fff, 0xff83, 0x8001, 0xfffd, 0xcccc, 0xffff,
  0x7ffd, 0xff82, 0x7fff, 0xfff0, 0x8001, 0xfffe, 0xcccc, 0x0000,
  0x7ffd, 0xff83, 0x7fff, 0xfffd, 0x8001, 0xffff, 0xcccc, 0x0001,
  0x7ffd, 0xfff0, 0x7fff, 0xfffe, 0x8001, 0x0000, 0xcccc, 0x0002,
  0x7ffd, 0xfffd, 0x7fff, 0xffff, 0x8001, 0x0001, 0xcccc, 0x0010,
  0x7ffd, 0xfffe, 0x7fff, 0x0000, 0x8001, 0x0002, 0xcccc, 0x007d,
  0x7ffd, 0xffff, 0x7fff, 0x0001, 0x8001, 0x0010, 0xcccc, 0x007e,
  0x7ffd, 0x0000, 0x7fff, 0x0002, 0x8001, 0x007d, 0xcccc, 0x007f,
  0x7ffd, 0x0001, 0x7fff, 0x0010, 0x8001, 0x007e, 0xcccc, 0x3333,
  0x7ffd, 0x0002, 0x7fff, 0x007d, 0x8001, 0x007f, 0xcccc, 0x5555,
  0x7ffd, 0x0010, 0x7fff, 0x007e, 0x8001, 0x3333, 0xcccc, 0x7ffd,
  0x7ffd, 0x007d, 0x7fff, 0x007f, 0x8001, 0x5555, 0xcccc, 0x7ffe,
  0x7ffd, 0x007e, 0x7fff, 0x3333, 0x8001, 0x7ffd, 0xcccc, 0x7fff,
  0x7ffd, 0x007f, 0x7fff, 0x5555, 0x8001, 0x7ffe, 0xcccc, 0x8000,
  0x7ffd, 0x3333, 0x7fff, 0x7ffd, 0x8001, 0x7fff, 0xcccc, 0x8001,
  0x7ffd, 0x5555, 0x7fff, 0x7ffe, 0x8001, 0x8000, 0xcccc, 0xaaaa,
  0x7ffd, 0x7ffd, 0x7fff, 0x7fff, 0x8001, 0x8001, 0xcccc, 0xcccc,
  0x7ffd, 0x7ffe, 0x7fff, 0x8000, 0x8001, 0xaaaa, 0xcccc, 0xff80,
  0x7ffd, 0x7fff, 0x7fff, 0x8001, 0x8001, 0xcccc, 0xcccc, 0xff81,
  0x7ffd, 0x8000, 0x7fff, 0xaaaa, 0x8001, 0xff80, 0xcccc, 0xff82,
  0x7ffd, 0x8001, 0x7fff, 0xcccc, 0x8001, 0xff81, 0xcccc, 0xff83,
  0x7ffd, 0xaaaa, 0x7fff, 0xff80, 0x8001, 0xff82, 0xcccc, 0xfff0,
  0x7ffd, 0xcccc, 0x7fff, 0xff81, 0x8001, 0xff83, 0xcccc, 0xfffd,
  0x7ffd, 0xff80, 0x7fff, 0xff82, 0x8001, 0xfff0, 0xcccc, 0xfffe,
  0x7ffe, 0xff81, 0x8000, 0xff83, 0xaaaa, 0xfffd, 0xff80, 0xffff,
  0x7ffe, 0xff82, 0x8000, 0xfff0, 0xaaaa, 0xfffe, 0xff80, 0x0000,
  0x7ffe, 0xff83, 0x8000, 0xfffd, 0xaaaa, 0xffff, 0xff80, 0x0001,
  0x7ffe, 0xfff0, 0x8000, 0xfffe, 0xaaaa, 0x0000, 0xff80, 0x0002,
  0x7ffe, 0xfffd, 0x8000, 0xffff, 0xaaaa, 0x0001, 0xff80, 0x0010,
  0x7ffe, 0xfffe, 0x8000, 0x0000, 0xaaaa, 0x0002, 0xff80, 0x007d,
  0x7ffe, 0xffff, 0x8000, 0x0001, 0xaaaa, 0x0010, 0xff80, 0x007e,
  0x7ffe, 0x0000, 0x8000, 0x0002, 0xaaaa, 0x007d, 0xff80, 0x007f,
  0x7ffe, 0x0001, 0x8000, 0x0010, 0xaaaa, 0x007e, 0xff80, 0x3333,
  0x7ffe, 0x0002, 0x8000, 0x007d, 0xaaaa, 0x007f, 0xff80, 0x5555,
  0x7ffe, 0x0010, 0x8000, 0x007e, 0xaaaa, 0x3333, 0xff80, 0x7ffd,
  0x7ffe, 0x007d, 0x8000, 0x007f, 0xaaaa, 0x5555, 0xff80, 0x7ffe,
  0x7ffe, 0x007e, 0x8000, 0x3333, 0xaaaa, 0x7ffd, 0xff80, 0x7fff,
  0x7ffe, 0x007f, 0x8000, 0x5555, 0xaaaa, 0x7ffe, 0xff80, 0x8000,
  0x7ffe, 0x3333, 0x8000, 0x7ffd, 0xaaaa, 0x7fff, 0xff80, 0x8001,
  0x7ffe, 0x5555, 0x8000, 0x7ffe, 0xaaaa, 0x8000, 0xff80, 0xaaaa,
  0x7ffe, 0x7ffd, 0x8000, 0x7fff, 0xaaaa, 0x8001, 0xff80, 0xcccc,
  0x7ffe, 0x7ffe, 0x8000, 0x8000, 0xaaaa, 0xaaaa, 0xff80, 0xff80,
  0x7ffe, 0x7fff, 0x8000, 0x8001, 0xaaaa, 0xcccc, 0xff80, 0xff81,
  0x7ffe, 0x8000, 0x8000, 0xaaaa, 0xaaaa, 0xff80, 0xff80, 0xff82,
  0x7ffe, 0x8001, 0x8000, 0xcccc, 0xaaaa, 0xff81, 0xff80, 0xff83,
  0x7ffe, 0xaaaa, 0x8000, 0xff80, 0xaaaa, 0xff82, 0xff80, 0xfff0,
  0x7ffe, 0xcccc, 0x8000, 0xff81, 0xaaaa, 0xff83, 0xff80, 0xfffd,
  0x7ffe, 0xff80, 0x8000, 0xff82, 0xaaaa, 0xfff0, 0xff80, 0xfffe,
  0x7fff, 0xff81, 0x8001, 0xff83, 0xcccc, 0xfffd, 0xff81, 0xffff,
  0x7fff, 0xff82, 0x8001, 0xfff0, 0xcccc, 0xfffe, 0xff81, 0x0000,
  0x7fff, 0xff83, 0x8001, 0xfffd, 0xcccc, 0xffff, 0xff81, 0x0001,
  0x7fff, 0xfff0, 0x8001, 0xfffe, 0xcccc, 0x0000, 0xff81, 0x0002,
  0x7fff, 0xfffd, 0x8001, 0xffff, 0xcccc, 0x0001, 0xff81, 0x0010,
  0x7fff, 0xfffe, 0x8001, 0x0000, 0xcccc, 0x0002, 0xff81, 0x007d,
  0x7fff, 0xffff, 0x8001, 0x0001, 0xcccc, 0x0010, 0xff81, 0x007e,
  0x7fff, 0x0000, 0x8001, 0x0002, 0xcccc, 0x007d, 0xff81, 0x007f,
  0x7fff, 0x0001, 0x8001, 0x0010, 0xcccc, 0x007e, 0xff81, 0x3333,
  0x7fff, 0x0002, 0x8001, 0x007d, 0xcccc, 0x007f, 0xff81, 0x5555,
  0x7fff, 0x0010, 0x8001, 0x007e, 0xcccc, 0x3333, 0xff81, 0x7ffd,
  0x7fff, 0x007d, 0x8001, 0x007f, 0xcccc, 0x5555, 0xff81, 0x7ffe,
  0x7fff, 0x007e, 0x8001, 0x3333, 0xcccc, 0x7ffd, 0xff81, 0x7fff,
  0x7fff, 0x007f, 0x8001, 0x5555, 0xcccc, 0x7ffe, 0xff81, 0x8000,
  0x7fff, 0x3333, 0x8001, 0x7ffd, 0xcccc, 0x7fff, 0xff81, 0x8001,
  0x7fff, 0x5555, 0x8001, 0x7ffe, 0xcccc, 0x8000, 0xff81, 0xaaaa,
  0x7fff, 0x7ffd, 0x8001, 0x7fff, 0xcccc, 0x8001, 0xff81, 0xcccc,
  0x7fff, 0x7ffe, 0x8001, 0x8000, 0xcccc, 0xaaaa, 0xff81, 0xff80,
  0x7fff, 0x7fff, 0x8001, 0x8001, 0xcccc, 0xcccc, 0xff81, 0xff81,
  0x7fff, 0x8000, 0x8001, 0xaaaa, 0xcccc, 0xff80, 0xff81, 0xff82,
  0x7fff, 0x8001, 0x8001, 0xcccc, 0xcccc, 0xff81, 0xff81, 0xff83,
  0x7fff, 0xaaaa, 0x8001, 0xff80, 0xcccc, 0xff82, 0xff81, 0xfff0,
  0x7fff, 0xcccc, 0x8001, 0xff81, 0xcccc, 0xff83, 0xff81, 0xfffd,
  0x7fff, 0xff80, 0x8001, 0xff82, 0xcccc, 0xfff0, 0xff81, 0xfffe,
  0x8000, 0xff81, 0xaaaa, 0xff83, 0xff80, 0xfffd, 0xff82, 0xffff,
  0x8000, 0xff82, 0xaaaa, 0xfff0, 0xff80, 0xfffe, 0xff82, 0x0000,
  0x8000, 0xff83, 0xaaaa, 0xfffd, 0xff80, 0xffff, 0xff82, 0x0001,
  0x8000, 0xfff0, 0xaaaa, 0xfffe, 0xff80, 0x0000, 0xff82, 0x0002,
  0x8000, 0xfffd, 0xaaaa, 0xffff, 0xff80, 0x0001, 0xff82, 0x0010,
  0x8000, 0xfffe, 0xaaaa, 0x0000, 0xff80, 0x0002, 0xff82, 0x007d,
  0x8000, 0xffff, 0xaaaa, 0x0001, 0xff80, 0x0010, 0xff82, 0x007e,
  0x8000, 0x0000, 0xaaaa, 0x0002, 0xff80, 0x007d, 0xff82, 0x007f,
  0x8000, 0x0001, 0xaaaa, 0x0010, 0xff80, 0x007e, 0xff82, 0x3333,
  0x8000, 0x0002, 0xaaaa, 0x007d, 0xff80, 0x007f, 0xff82, 0x5555,
  0x8000, 0x0010, 0xaaaa, 0x007e, 0xff80, 0x3333, 0xff82, 0x7ffd,
  0x8000, 0x007d, 0xaaaa, 0x007f, 0xff80, 0x5555, 0xff82, 0x7ffe,
  0x8000, 0x007e, 0xaaaa, 0x3333, 0xff80, 0x7ffd, 0xff82, 0x7fff,
  0x8000, 0x007f, 0xaaaa, 0x5555, 0xff80, 0x7ffe, 0xff82, 0x8000,
  0x8000, 0x3333, 0xaaaa, 0x7ffd, 0xff80, 0x7fff, 0xff82, 0x8001,
  0x8000, 0x5555, 0xaaaa, 0x7ffe, 0xff80, 0x8000, 0xff82, 0xaaaa,
  0x8000, 0x7ffd, 0xaaaa, 0x7fff, 0xff80, 0x8001, 0xff82, 0xcccc,
  0x8000, 0x7ffe, 0xaaaa, 0x8000, 0xff80, 0xaaaa, 0xff82, 0xff80,
  0x8000, 0x7fff, 0xaaaa, 0x8001, 0xff80, 0xcccc, 0xff82, 0xff81,
  0x8000, 0x8000, 0xaaaa, 0xaaaa, 0xff80, 0xff80, 0xff82, 0xff82,
  0x8000, 0x8001, 0xaaaa, 0xcccc, 0xff80, 0xff81, 0xff82, 0xff83,
  0x8000, 0xaaaa, 0xaaaa, 0xff80, 0xff80, 0xff82, 0xff82, 0xfff0,
  0x8000, 0xcccc, 0xaaaa, 0xff81, 0xff80, 0xff83, 0xff82, 0xfffd,
  0x8000, 0xff80, 0xaaaa, 0xff82, 0xff80, 0xfff0, 0xff82, 0xfffe,
  0x8001, 0xff81, 0xcccc, 0xff83, 0xff81, 0xfffd, 0xff83, 0xffff,
  0x8001, 0xff82, 0xcccc, 0xfff0, 0xff81, 0xfffe, 0xff83, 0x0000,
  0x8001, 0xff83, 0xcccc, 0xfffd, 0xff81, 0xffff, 0xff83, 0x0001,
  0x8001, 0xfff0, 0xcccc, 0xfffe, 0xff81, 0x0000, 0xff83, 0x0002,
  0x8001, 0xfffd, 0xcccc, 0xffff, 0xff81, 0x0001, 0xff83, 0x0010,
  0x8001, 0xfffe, 0xcccc, 0x0000, 0xff81, 0x0002, 0xff83, 0x007d,
  0x8001, 0xffff, 0xcccc, 0x0001, 0xff81, 0x0010, 0xff83, 0x007e,
  0x8001, 0x0000, 0xcccc, 0x0002, 0xff81, 0x007d, 0xff83, 0x007f,
  0x8001, 0x0001, 0xcccc, 0x0010, 0xff81, 0x007e, 0xff83, 0x3333,
  0x8001, 0x0002, 0xcccc, 0x007d, 0xff81, 0x007f, 0xff83, 0x5555,
  0x8001, 0x0010, 0xcccc, 0x007e, 0xff81, 0x3333, 0xff83, 0x7ffd,
  0x8001, 0x007d, 0xcccc, 0x007f, 0xff81, 0x5555, 0xff83, 0x7ffe,
  0x8001, 0x007e, 0xcccc, 0x3333, 0xff81, 0x7ffd, 0xff83, 0x7fff,
  0x8001, 0x007f, 0xcccc, 0x5555, 0xff81, 0x7ffe, 0xff83, 0x8000,
  0x8001, 0x3333, 0xcccc, 0x7ffd, 0xff81, 0x7fff, 0xff83, 0x8001,
  0x8001, 0x5555, 0xcccc, 0x7ffe, 0xff81, 0x8000, 0xff83, 0xaaaa,
  0x8001, 0x7ffd, 0xcccc, 0x7fff, 0xff81, 0x8001, 0xff83, 0xcccc,
  0x8001, 0x7ffe, 0xcccc, 0x8000, 0xff81, 0xaaaa, 0xff83, 0xff80,
  0x8001, 0x7fff, 0xcccc, 0x8001, 0xff81, 0xcccc, 0xff83, 0xff81,
  0x8001, 0x8000, 0xcccc, 0xaaaa, 0xff81, 0xff80, 0xff83, 0xff82,
  0x8001, 0x8001, 0xcccc, 0xcccc, 0xff81, 0xff81, 0xff83, 0xff83,
  0x8001, 0xaaaa, 0xcccc, 0xff80, 0xff81, 0xff82, 0xff83, 0xfff0,
  0x8001, 0xcccc, 0xcccc, 0xff81, 0xff81, 0xff83, 0xff83, 0xfffd,
  0x8001, 0xff80, 0xcccc, 0xff82, 0xff81, 0xfff0, 0xff83, 0xfffe,
  0xaaaa, 0xff81, 0xff80, 0xff83, 0xff82, 0xfffd, 0xfff0, 0xffff,
  0xaaaa, 0xff82, 0xff80, 0xfff0, 0xff82, 0xfffe, 0xfff0, 0x0000,
  0xaaaa, 0xff83, 0xff80, 0xfffd, 0xff82, 0xffff, 0xfff0, 0x0001,
  0xaaaa, 0xfff0, 0xff80, 0xfffe, 0xff82, 0x0000, 0xfff0, 0x0002,
  0xaaaa, 0xfffd, 0xff80, 0xffff, 0xff82, 0x0001, 0xfff0, 0x0010,
  0xaaaa, 0xfffe, 0xff80, 0x0000, 0xff82, 0x0002, 0xfff0, 0x007d,
  0xaaaa, 0xffff, 0xff80, 0x0001, 0xff82, 0x0010, 0xfff0, 0x007e,
  0xaaaa, 0x0000, 0xff80, 0x0002, 0xff82, 0x007d, 0xfff0, 0x007f,
  0xaaaa, 0x0001, 0xff80, 0x0010, 0xff82, 0x007e, 0xfff0, 0x3333,
  0xaaaa, 0x0002, 0xff80, 0x007d, 0xff82, 0x007f, 0xfff0, 0x5555,
  0xaaaa, 0x0010, 0xff80, 0x007e, 0xff82, 0x3333, 0xfff0, 0x7ffd,
  0xaaaa, 0x007d, 0xff80, 0x007f, 0xff82, 0x5555, 0xfff0, 0x7ffe,
  0xaaaa, 0x007e, 0xff80, 0x3333, 0xff82, 0x7ffd, 0xfff0, 0x7fff,
  0xaaaa, 0x007f, 0xff80, 0x5555, 0xff82, 0x7ffe, 0xfff0, 0x8000,
  0xaaaa, 0x3333, 0xff80, 0x7ffd, 0xff82, 0x7fff, 0xfff0, 0x8001,
  0xaaaa, 0x5555, 0xff80, 0x7ffe, 0xff82, 0x8000, 0xfff0, 0xaaaa,
  0xaaaa, 0x7ffd, 0xff80, 0x7fff, 0xff82, 0x8001, 0xfff0, 0xcccc,
  0xaaaa, 0x7ffe, 0xff80, 0x8000, 0xff82, 0xaaaa, 0xfff0, 0xff80,
  0xaaaa, 0x7fff, 0xff80, 0x8001, 0xff82, 0xcccc, 0xfff0, 0xff81,
  0xaaaa, 0x8000, 0xff80, 0xaaaa, 0xff82, 0xff80, 0xfff0, 0xff82,
  0xaaaa, 0x8001, 0xff80, 0xcccc, 0xff82, 0xff81, 0xfff0, 0xff83,
  0xaaaa, 0xaaaa, 0xff80, 0xff80, 0xff82, 0xff82, 0xfff0, 0xfff0,
  0xaaaa, 0xcccc, 0xff80, 0xff81, 0xff82, 0xff83, 0xfff0, 0xfffd,
  0xaaaa, 0xff80, 0xff80, 0xff82, 0xff82, 0xfff0, 0xfff0, 0xfffe,
  0xcccc, 0xff81, 0xff81, 0xff83, 0xff83, 0xfffd, 0xfffd, 0xffff,
  0xcccc, 0xff82, 0xff81, 0xfff0, 0xff83, 0xfffe, 0xfffd, 0x0000,
  0xcccc, 0xff83, 0xff81, 0xfffd, 0xff83, 0xffff, 0xfffd, 0x0001,
  0xcccc, 0xfff0, 0xff81, 0xfffe, 0xff83, 0x0000, 0xfffd, 0x0002,
  0xcccc, 0xfffd, 0xff81, 0xffff, 0xff83, 0x0001, 0xfffd, 0x0010,
  0xcccc, 0xfffe, 0xff81, 0x0000, 0xff83, 0x0002, 0xfffd, 0x007d,
  0xcccc, 0xffff, 0xff81, 0x0001, 0xff83, 0x0010, 0xfffd, 0x007e,
  0xcccc, 0x0000, 0xff81, 0x0002, 0xff83, 0x007d, 0xfffd, 0x007f,
  0xcccc, 0x0001, 0xff81, 0x0010, 0xff83, 0x007e, 0xfffd, 0x3333,
  0xcccc, 0x0002, 0xff81, 0x007d, 0xff83, 0x007f, 0xfffd, 0x5555,
  0xcccc, 0x0010, 0xff81, 0x007e, 0xff83, 0x3333, 0xfffd, 0x7ffd,
  0xcccc, 0x007d, 0xff81, 0x007f, 0xff83, 0x5555, 0xfffd, 0x7ffe,
  0xcccc, 0x007e, 0xff81, 0x3333, 0xff83, 0x7ffd, 0xfffd, 0x7fff,
  0xcccc, 0x007f, 0xff81, 0x5555, 0xff83, 0x7ffe, 0xfffd, 0x8000,
  0xcccc, 0x3333, 0xff81, 0x7ffd, 0xff83, 0x7fff, 0xfffd, 0x8001,
  0xcccc, 0x5555, 0xff81, 0x7ffe, 0xff83, 0x8000, 0xfffd, 0xaaaa,
  0xcccc, 0x7ffd, 0xff81, 0x7fff, 0xff83, 0x8001, 0xfffd, 0xcccc,
  0xcccc, 0x7ffe, 0xff81, 0x8000, 0xff83, 0xaaaa, 0xfffd, 0xff80,
  0xcccc, 0x7fff, 0xff81, 0x8001, 0xff83, 0xcccc, 0xfffd, 0xff81,
  0xcccc, 0x8000, 0xff81, 0xaaaa, 0xff83, 0xff80, 0xfffd, 0xff82,
  0xcccc, 0x8001, 0xff81, 0xcccc, 0xff83, 0xff81, 0xfffd, 0xff83,
  0xcccc, 0xaaaa, 0xff81, 0xff80, 0xff83, 0xff82, 0xfffd, 0xfff0,
  0xcccc, 0xcccc, 0xff81, 0xff81, 0xff83, 0xff83, 0xfffd, 0xfffd,
  0xcccc, 0xff80, 0xff81, 0xff82, 0xff83, 0xfff0, 0xfffd, 0xfffe,
  0xff80, 0xff81, 0xff82, 0xff83, 0xfff0, 0xfffd, 0xfffe, 0xffff,
  0xff80, 0xff82, 0xff82, 0xfff0, 0xfff0, 0xfffe, 0xfffe, 0x0000,
  0xff80, 0xff83, 0xff82, 0xfffd, 0xfff0, 0xffff, 0xfffe, 0x0001,
  0xff80, 0xfff0, 0xff82, 0xfffe, 0xfff0, 0x0000, 0xfffe, 0x0002,
  0xff80, 0xfffd, 0xff82, 0xffff, 0xfff0, 0x0001, 0xfffe, 0x0010,
  0xff80, 0xfffe, 0xff82, 0x0000, 0xfff0, 0x0002, 0xfffe, 0x007d,
  0xff80, 0xffff, 0xff82, 0x0001, 0xfff0, 0x0010, 0xfffe, 0x007e,
  0xff80, 0x0000, 0xff82, 0x0002, 0xfff0, 0x007d, 0xfffe, 0x007f,
  0xff80, 0x0001, 0xff82, 0x0010, 0xfff0, 0x007e, 0xfffe, 0x3333,
  0xff80, 0x0002, 0xff82, 0x007d, 0xfff0, 0x007f, 0xfffe, 0x5555,
  0xff80, 0x0010, 0xff82, 0x007e, 0xfff0, 0x3333, 0xfffe, 0x7ffd,
  0xff80, 0x007d, 0xff82, 0x007f, 0xfff0, 0x5555, 0xfffe, 0x7ffe,
  0xff80, 0x007e, 0xff82, 0x3333, 0xfff0, 0x7ffd, 0xfffe, 0x7fff,
  0xff80, 0x007f, 0xff82, 0x5555, 0xfff0, 0x7ffe, 0xfffe, 0x8000,
  0xff80, 0x3333, 0xff82, 0x7ffd, 0xfff0, 0x7fff, 0xfffe, 0x8001,
  0xff80, 0x5555, 0xff82, 0x7ffe, 0xfff0, 0x8000, 0xfffe, 0xaaaa,
  0xff80, 0x7ffd, 0xff82, 0x7fff, 0xfff0, 0x8001, 0xfffe, 0xcccc,
  0xff80, 0x7ffe, 0xff82, 0x8000, 0xfff0, 0xaaaa, 0xfffe, 0xff80,
  0xff80, 0x7fff, 0xff82, 0x8001, 0xfff0, 0xcccc, 0xfffe, 0xff81,
  0xff80, 0x8000, 0xff82, 0xaaaa, 0xfff0, 0xff80, 0xfffe, 0xff82,
  0xff80, 0x8001, 0xff82, 0xcccc, 0xfff0, 0xff81, 0xfffe, 0xff83,
  0xff80, 0xaaaa, 0xff82, 0xff80, 0xfff0, 0xff82, 0xfffe, 0xfff0,
  0xff80, 0xcccc, 0xff82, 0xff81, 0xfff0, 0xff83, 0xfffe, 0xfffd,
  0xff80, 0xff80, 0xff82, 0xff82, 0xfff0, 0xfff0, 0xfffe, 0xfffe,
};
const unsigned kExpectedCount_NEON_trn1_8H = 576;

#endif  // VIXL_SIM_TRN1_8H_TRACE_AARCH64_H_
